/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.google.gson.Gson;
import com.viztrend.safe.persistence.entity.ApiToken;
import com.viztrend.safe.persistence.entity.Config;
import com.viztrend.safe.persistence.entity.SAMLConfig;
import com.viztrend.safe.persistence.entity.dto.LdapUser;
import com.viztrend.safe.persistence.repository.ApiTokenRepository;
import com.viztrend.safe.persistence.repository.SAMLConfigRepository;
import com.viztrend.safe.service.LDAPService;
import com.viztrend.safe.utils.StringUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OktaServiceImpl
implements LDAPService {
    @Autowired
    private ApiTokenRepository apiTokenRepository;
    @Autowired
    private SAMLConfigRepository sAMLConfigRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(OktaServiceImpl.class);

    public List<String> serach() {
        return null;
    }

    public List<LdapUser> listGroups() {
        return null;
    }

    public List<LdapUser> listUsers(String GroupDn) {
        return null;
    }

    public boolean authenticateAndAuthorize(String userName, String pass) {
        return false;
    }

    public List<String> authenticate(String userName, String pass, Config.LDAPConfig ldapConfig) {
        return null;
    }

    public LdapUser findUser(String uid) {
        return null;
    }

    public List<LdapUser> search(String searchStr) {
        SAMLConfig samlConfig = (SAMLConfig)this.sAMLConfigRepository.findAll().get(0);
        ApiToken oktaApiToken = this.apiTokenRepository.findByProvider("Okta");
        String apiToken = oktaApiToken.getToken();
        String identityProviderSS = samlConfig.getIdentityProviderSingleSign();
        String oktaApiUrl = identityProviderSS.substring(0, identityProviderSS.indexOf(".okta.com")) + ".okta.com/api/v1/";
        ArrayList<LdapUser> ldapusers = new ArrayList<LdapUser>();
        try {
            String responseJson = this.getOktaUsers(apiToken, oktaApiUrl, searchStr);
            List mapList = (List)new Gson().fromJson(responseJson, List.class);
            for (Map map : mapList) {
                Map profileMap = (Map)map.get("profile");
                LdapUser ldapUser = new LdapUser();
                ldapUser.setFirstName(String.valueOf(profileMap.get("firstName")));
                ldapUser.setLastName(String.valueOf(profileMap.get("lastName")));
                ldapUser.setEmail(String.valueOf(profileMap.get("email")));
                ldapUser.setId(String.valueOf(profileMap.get("login")));
                ldapUser.setType("user");
                ldapusers.add(ldapUser);
            }
            String responseGroupsJson = this.getOktaGrups(apiToken, oktaApiUrl, searchStr);
            List gpMapList = (List)new Gson().fromJson(responseGroupsJson, List.class);
            for (Map map : gpMapList) {
                Map profileMap = (Map)map.get("profile");
                LdapUser ldapUser = new LdapUser();
                ldapUser.setId(String.valueOf(profileMap.get("name")));
                ldapUser.setDn(String.valueOf(profileMap.get("description")));
                ldapUser.setType("group");
                ldapusers.add(ldapUser);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return ldapusers;
    }

    public static void main(String[] args) {
        try {
            String identityProviderSS = "https://loxvo2.okta.com/app/loxvoorg411524_kendissaml_1/exkcvauk0Uv5R6sSo356/sso/saml";
            String oktaApiUrl = identityProviderSS.substring(0, identityProviderSS.indexOf(".okta.com")) + ".okta.com/api/v1/";
            String json = new OktaServiceImpl().getOktaGrups("00vP5FtGBs7MA0NTHoijlxb09mLRY_neAZKCL3XikO", oktaApiUrl, "z");
            List mapList = (List)new Gson().fromJson(json, List.class);
            mapList.get(0);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public String getOktaUsers(String apiToken, String apiUrl, String str) throws Exception {
        String url = apiUrl + "users?q=" + str;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet request = new HttpGet(url);
        request.addHeader("Accept", "application/json");
        request.addHeader("Content-type", "application/json");
        apiToken = "SSWS" + apiToken;
        request.addHeader("Authorization", apiToken);
        HttpResponse response = null;
        response = client.execute((HttpUriRequest)request);
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        StringBuffer result = new StringBuffer();
        String line = "";
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        return result.toString();
    }

    public String getOktaGrups(String apiToken, String apiUrl, String str) throws Exception {
        String url = apiUrl + "groups?q=" + str;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet request = new HttpGet(url);
        request.addHeader("Accept", "application/json");
        request.addHeader("Content-type", "application/json");
        apiToken = "SSWS" + apiToken;
        request.addHeader("Authorization", apiToken);
        HttpResponse response = null;
        response = client.execute((HttpUriRequest)request);
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        StringBuffer result = new StringBuffer();
        String line = "";
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        return result.toString();
    }

    public List<LdapUser> searchLdap(String userDn, String pass, String baseUrl, String baseDN, String addionalDN, String searchStr, boolean isSSL) throws Exception {
        return null;
    }
}

