/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.viztrend.safe.exception.KendisException;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.FieldTemplate;
import com.viztrend.safe.persistence.entity.Fields;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.Risk;
import com.viztrend.safe.persistence.entity.RiskRegister;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.Watcher;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.repository.BaseItemRepository;
import com.viztrend.safe.persistence.repository.FieldTemplateRepository;
import com.viztrend.safe.persistence.repository.FieldsRepository;
import com.viztrend.safe.persistence.repository.ItemLinkRepository;
import com.viztrend.safe.persistence.repository.ItemLinkTypeRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.service.ALMSyncService;
import com.viztrend.safe.service.MyViewService;
import com.viztrend.safe.service.TFSservice;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class MyViewServiceImpl
implements MyViewService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MyViewServiceImpl.class);
    private final FieldsRepository fieldsRepository;
    private final BaseItemRepository baseItemRepository;
    private final TFSservice tfSservice;
    private final ALMSyncService almSyncService;
    private final ItemLinkTypeRepository itemLinkTypeRepository;
    private final StatusRepository statusRepository;
    private final UserRepository userRepository;
    private final WorkFlowRepository workFlowRepository;
    private final ItemRepository itemRepository;
    private final ItemLinkRepository itemLinkRepository;
    private final FieldTemplateRepository fieldTemplateRepository;
    private final SessionRepository sessionRepository;
    private final MongoTemplate mongoTemplate;

    MyViewServiceImpl(FieldsRepository fieldsRepository, BaseItemRepository baseItemRepository, WorkFlowRepository workFlowRepository, TFSservice tfSservice, ALMSyncService almSyncService, ItemLinkTypeRepository itemLinkTypeRepository, StatusRepository statusRepository, UserRepository userRepository, ItemRepository itemRepository, ItemLinkRepository itemLinkRepository, FieldTemplateRepository fieldTemplateRepository, SessionRepository sessionRepository, MongoTemplate mongoTemplate) {
        this.fieldsRepository = fieldsRepository;
        this.baseItemRepository = baseItemRepository;
        this.tfSservice = tfSservice;
        this.almSyncService = almSyncService;
        this.itemLinkTypeRepository = itemLinkTypeRepository;
        this.statusRepository = statusRepository;
        this.userRepository = userRepository;
        this.itemRepository = itemRepository;
        this.itemLinkRepository = itemLinkRepository;
        this.workFlowRepository = workFlowRepository;
        this.fieldTemplateRepository = fieldTemplateRepository;
        this.sessionRepository = sessionRepository;
        this.mongoTemplate = mongoTemplate;
    }

    public ItemLink saveDependency(Item item) {
        try {
            ItemLink itemLink = (ItemLink)item.getItemLinks().get(0);
            itemLink.setSourceItem(null);
            itemLink.setTargetItem(null);
            return (ItemLink)this.itemLinkRepository.save(item.getItemLinks().get(0));
        }
        catch (Exception e) {
            LOGGER.error("error occurred in method saveDependency()---" + e.getMessage());
            throw new KendisException(e.getMessage());
        }
    }

    public void deleteDependency(ItemLink itemLink) {
        try {
            Item sourceItem = this.itemRepository.findById(itemLink.getSourceItemId());
            int indexOfItemLink = 0;
            for (int i = 0; i < sourceItem.getItemLinks().size(); ++i) {
                if (!((ItemLink)sourceItem.getItemLinks().get(i)).getId().equals(itemLink.getId())) continue;
                indexOfItemLink = i;
            }
            sourceItem.getItemLinks().remove(indexOfItemLink);
            this.itemRepository.save((Object)sourceItem);
            this.itemLinkRepository.delete((Serializable)((Object)itemLink.getId()));
        }
        catch (Exception e) {
            LOGGER.error("Error occurred in method deleteDependency()---" + e.getMessage());
            throw new KendisException(e.getMessage());
        }
    }

    public HashMap<String, Object> getDependenciesListByUserId(String userId) {
        try {
            ArrayList sessionBoardIdList = new ArrayList();
            HashMap<String, Object> responseData = new HashMap<String, Object>();
            HashMap linkTypesListMap = new HashMap();
            HashMap itemJiraDependenciesListMap = new HashMap();
            HashMap sessionBoardIdsListMap = new HashMap();
            HashMap dependencyStatusesListMap = new HashMap();
            LOGGER.debug("Getting watchers list of user " + userId);
            List watcherList = this.loadWatchersListByUserId(userId);
            LOGGER.debug("Getting itemLinks of user by user Id and watcher Id");
            List itemLinkList = this.getItemLinkListByUserIdAndWatcherId(userId, watcherList);
            HashMap responseGetItemLinks = this.getItemLinksForKendisAndALM(itemLinkList, itemJiraDependenciesListMap, sessionBoardIdList, userId);
            List sessionBoardsList = this.loadSessionBoardMetaInformation(sessionBoardIdList);
            sessionBoardsList.forEach(sessionBoard -> {
                sessionBoardIdsListMap.put(sessionBoard.getId(), sessionBoard);
                this.fetchItemLinkTypeListBySessionBoard(linkTypesListMap, sessionBoard);
                dependencyStatusesListMap.put(sessionBoard.getId(), this.fetchDependencyStatuses(sessionBoard));
                this.fetchFeaturesListForJiraAndKendisBoard(sessionBoard);
                this.fetchUsersForSessionBoards(sessionBoard);
            });
            responseData.put("itemLinkList", responseGetItemLinks.get("itemLinkList"));
            responseData.put("itemJiraDependencyList", responseGetItemLinks.get("itemJiraDependenciesList"));
            LOGGER.debug("Session Boards List----->  " + sessionBoardIdsListMap.size());
            responseData.put("sessionBoardsMetaMap", sessionBoardIdsListMap);
            LOGGER.debug("WatcherList for User " + userId + " is---->  " + watcherList.size());
            responseData.put("watcherList", watcherList);
            LOGGER.debug("Link Types List---->  " + linkTypesListMap.size());
            responseData.put("linkTypeList", linkTypesListMap);
            LOGGER.debug("Dependency Status List ---->  " + dependencyStatusesListMap.size());
            responseData.put("dependencyStatusesListMap", dependencyStatusesListMap);
            LOGGER.debug("Fetch Dependencies List for User Id " + userId + " Successfully");
            return responseData;
        }
        catch (Exception e) {
            throw new KendisException("Error Occurred  While Fetching Dependencies (My View) for User --> " + userId);
        }
    }

    private List<Watcher> loadWatchersListByUserId(String userId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"user.$id").is((Object)new ObjectId(userId)));
        return this.mongoTemplate.find(query, Watcher.class);
    }

    private void fetchUsersForSessionBoards(SessionBoard sessionBoard) {
        ArrayList<User> users = new ArrayList<User>();
        List usersAll = this.userRepository.findByUserCompanies_Company_Id(UserContextUtil.getUserContext().getCurrentCompany().getId());
        for (User user : usersAll) {
            if (!this.tfSservice.isLoggedInCompanyUser(user).booleanValue()) continue;
            users.add(user);
        }
        sessionBoard.setUsers(users);
    }

    private void fetchFeaturesListForJiraAndKendisBoard(SessionBoard sessionBoard) {
        try {
            if (sessionBoard.getSession().getAlmEnabled().booleanValue() && PropertyValidator.isValid((Object)sessionBoard.getSession().getTfsAlmConfigurations())) {
                return;
            }
            ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
            sessionBoards.add(sessionBoard);
            List bos = this.itemRepository.findBySessionBoardsInOrderBySequence(sessionBoards);
            ArrayList<Item> boardItems = new ArrayList<Item>();
            if (PropertyValidator.isValid((Collection)bos)) {
                for (Item item : bos) {
                    boardItems.add(item);
                }
            }
            sessionBoard.setItems(boardItems);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred in method fetchFeaturesListForJiraAndKendisBoard()---" + e.getMessage());
            throw new KendisException(e.getMessage());
        }
    }

    private List<Status> fetchDependencyStatuses(SessionBoard sessionBoard) {
        List dependencyStatuses = this.statusRepository.findByWorkFlow(sessionBoard.getSession().getDependencyWorkFlow());
        WorkFlow workFlow = sessionBoard.getSession().getDependencyWorkFlow();
        ArrayList<Status> sortedStatuses = new ArrayList<Status>();
        HashMap<String, Status> sortedStatusesMap = new HashMap<String, Status>();
        if (PropertyValidator.isValid((Object)workFlow.getStatusSequence())) {
            String[] sortedStatusIds = workFlow.getStatusSequence().split(",");
            for (Status status : dependencyStatuses) {
                sortedStatusesMap.put(status.getId(), status);
            }
            for (String statusId : sortedStatusIds) {
                sortedStatuses.add((Status)sortedStatusesMap.get(statusId));
            }
            return sortedStatuses;
        }
        return dependencyStatuses;
    }

    private void fetchItemLinkTypeListBySessionBoard(HashMap<String, Object> linkTypesListMap, SessionBoard sessionBoard) {
        if (sessionBoard.getSession().getAlmEnabled().booleanValue()) {
            if (PropertyValidator.isValid((Object)sessionBoard.getSession().getTfsAlmConfigurations())) {
                this.fetchTfsLinkTypes(linkTypesListMap, sessionBoard);
            } else if (PropertyValidator.isValid((Collection)sessionBoard.getSession().getAlmConfigurations())) {
                this.fetchJiraLinkTypes(linkTypesListMap, sessionBoard);
            }
        }
        if (!linkTypesListMap.containsKey("kendisLinkTypes") && sessionBoard.getSession().getNewSystemLinkTypes().booleanValue()) {
            this.fetchKendisLinkTypes(linkTypesListMap);
        }
    }

    private void fetchKendisLinkTypes(HashMap<String, Object> linkTypesListMap) {
        List kendisLinkTypes = this.itemLinkTypeRepository.findBySystem(Boolean.TRUE);
        if (!PropertyValidator.isValid((Collection)kendisLinkTypes)) {
            kendisLinkTypes = this.tfSservice.createNewKendisLinkTypes();
        }
        linkTypesListMap.put("kendisLinkTypes", kendisLinkTypes);
    }

    private void fetchJiraLinkTypes(HashMap<String, Object> linkTypesListMap, SessionBoard sessionBoard) {
        AlmAccount almAccount = ((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getAlmAccount();
        if (!linkTypesListMap.containsKey(almAccount.getId())) {
            List jiraIssueLinkTypes = this.almSyncService.retrieveJiraIssueLinkTypesList(almAccount, false);
            linkTypesListMap.put(almAccount.getId(), jiraIssueLinkTypes);
        }
    }

    private void fetchTfsLinkTypes(HashMap<String, Object> linkTypesListMap, SessionBoard sessionBoard) {
        AlmAccount almAccount = sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount();
        if (!linkTypesListMap.containsKey(almAccount.getId())) {
            HashMap tfsLinkTypesResult = this.tfSservice.retrieveJiraIssueLinkTypesList(almAccount, false);
            linkTypesListMap.put(almAccount.getId(), tfsLinkTypesResult.get("linkTypes"));
        }
    }

    private HashMap<String, Object> getItemLinksForKendisAndALM(List<ItemLink> itemLinkList, HashMap<String, Object> itemJiraDependenciesListMap, List<String> sessionBoardIdList, String userId) {
        try {
            ArrayList itemLinkSourceItemIdsList = new ArrayList();
            ArrayList jiraLinksSourceItemIdsList = new ArrayList();
            ArrayList tfsLinksSourceItemIdsList = new ArrayList();
            ArrayList itemLinkTargetItemIdsList = new ArrayList();
            ArrayList jiraLinkTargetItemIdsList = new ArrayList();
            ArrayList tfsLinkTargetItemIdsList = new ArrayList();
            ArrayList sourceTeamContainerIdsList = new ArrayList();
            ArrayList targetTeamContainerIdsList = new ArrayList();
            HashMap<String, Object> returnListMap = new HashMap<String, Object>();
            ArrayList itemJiraDependencyList = new ArrayList();
            ArrayListMultimap itemLinksSourceItemIdsListMap = ArrayListMultimap.create();
            ArrayListMultimap jiraLinksSourceItemIdsListMap = ArrayListMultimap.create();
            ArrayListMultimap tfsLinksSourceItemIdsListMap = ArrayListMultimap.create();
            ArrayListMultimap itemLinksTargetItemIdsListMap = ArrayListMultimap.create();
            ArrayListMultimap jiraLinksTargetItemIdsListMap = ArrayListMultimap.create();
            ArrayListMultimap tfsLinksTargetItemIdsListMap = ArrayListMultimap.create();
            ArrayListMultimap sourceTeamContainerIdsListMap = ArrayListMultimap.create();
            ArrayListMultimap targetTeamContainerIdsListMap = ArrayListMultimap.create();
            itemLinkList.forEach(arg_0 -> this.lambda$getItemLinksForKendisAndALM$1(itemJiraDependenciesListMap, sessionBoardIdList, itemLinkSourceItemIdsList, itemLinkTargetItemIdsList, sourceTeamContainerIdsList, targetTeamContainerIdsList, (Multimap)itemLinksSourceItemIdsListMap, (Multimap)itemLinksTargetItemIdsListMap, (Multimap)sourceTeamContainerIdsListMap, (Multimap)targetTeamContainerIdsListMap, arg_0));
            this.setItemAndTeamContainersForItemLink(itemLinkSourceItemIdsList, itemLinkTargetItemIdsList, sourceTeamContainerIdsList, targetTeamContainerIdsList, (Multimap)itemLinksSourceItemIdsListMap, (Multimap)itemLinksTargetItemIdsListMap, (Multimap)sourceTeamContainerIdsListMap, (Multimap)targetTeamContainerIdsListMap);
            List almLinkDataList = this.getItemJiraDependencies(itemJiraDependenciesListMap, userId, itemJiraDependencyList);
            almLinkDataList.forEach(arg_0 -> this.lambda$getItemLinksForKendisAndALM$2(sessionBoardIdList, jiraLinksSourceItemIdsList, jiraLinkTargetItemIdsList, (Multimap)jiraLinksSourceItemIdsListMap, (Multimap)jiraLinksTargetItemIdsListMap, tfsLinksSourceItemIdsList, tfsLinkTargetItemIdsList, (Multimap)tfsLinksSourceItemIdsListMap, (Multimap)tfsLinksTargetItemIdsListMap, arg_0));
            this.setItemAndTeamContainersForAlmLink(jiraLinksSourceItemIdsList, jiraLinkTargetItemIdsList, (Multimap)jiraLinksSourceItemIdsListMap, (Multimap)jiraLinksTargetItemIdsListMap, tfsLinksSourceItemIdsList, tfsLinkTargetItemIdsList, (Multimap)tfsLinksSourceItemIdsListMap, (Multimap)tfsLinksTargetItemIdsListMap);
            LOGGER.debug("-------Preparing Response Data-------");
            LOGGER.debug("ItemLinkList----->  " + itemLinkList.size());
            LOGGER.debug("AlmDependenciesList----->  " + almLinkDataList.size());
            returnListMap.put("itemJiraDependenciesList", almLinkDataList);
            returnListMap.put("itemLinkList", itemLinkList);
            return returnListMap;
        }
        catch (Exception e) {
            LOGGER.debug("Error Occurred in method getItemLinksForKendisAndALM()--- " + e.getMessage());
            throw new KendisException(e.getMessage());
        }
    }

    private void setItemAndTeamContainersForAlmLink(List<String> jiraSourceItemIdsList, List<String> jiraTargetItemIdsList, Multimap<String, ItemJiraDependency> jiraSourceItemIdsListMap, Multimap<String, ItemJiraDependency> jiraTargetItemIdsListMap, List<String> tfsSourceItemIdsList, List<String> tfsTargetItemIdsList, Multimap<String, ItemJiraDependency> tfsSourceItemIdsListMap, Multimap<String, ItemJiraDependency> tfsTargetItemIdsListMap) {
        List sourceItemList = this.getItemListByIdForJiraAlm(jiraSourceItemIdsList);
        this.setAlmLinkItemField(sourceItemList, jiraSourceItemIdsListMap, true, false);
        List targetItemList = this.getItemListByIdForJiraAlm(jiraTargetItemIdsList);
        this.setAlmLinkItemField(targetItemList, jiraTargetItemIdsListMap, false, false);
        sourceItemList = this.getItemListByTfsId(tfsSourceItemIdsList);
        this.setAlmLinkItemField(sourceItemList, tfsSourceItemIdsListMap, true, true);
        targetItemList = this.getItemListByTfsId(tfsTargetItemIdsList);
        this.setAlmLinkItemField(targetItemList, tfsTargetItemIdsListMap, false, true);
    }

    private List<Item> getItemListByTfsId(List<String> tfsSourceItemIdsList) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tfsId").in(tfsSourceItemIdsList));
        return this.mongoTemplate.find(query, Item.class);
    }

    private void getItemsAndTeamContainerIdsByAlmLink(List<String> sessionBoardIdList, List<String> jiraSourceItemIdsList, List<String> jiraTargetItemIdsList, Multimap<String, ItemJiraDependency> jiraSourceItemIdsListMap, Multimap<String, ItemJiraDependency> jiraTargetItemIdsListMap, List<String> tfsSourceItemIdsList, List<String> tfsTargetItemIdsList, Multimap<String, ItemJiraDependency> tfsSourceItemIdsListMap, Multimap<String, ItemJiraDependency> tfsTargetItemIdsListMap, ItemJiraDependency almLink) {
        if (!almLink.getIsTFS().booleanValue()) {
            String sourceItemId = almLink.getTargetJiraIssue().getJiraParentId();
            jiraSourceItemIdsList.add(sourceItemId);
            jiraSourceItemIdsListMap.put((Object)sourceItemId, (Object)almLink);
            String targetItemId = almLink.getTargetJiraIssue().getJiraId();
            jiraTargetItemIdsList.add(targetItemId);
            jiraTargetItemIdsListMap.put((Object)targetItemId, (Object)almLink);
        } else {
            String sourceItemId = almLink.getSourceTFSItem().getTfsId();
            tfsSourceItemIdsList.add(sourceItemId);
            tfsSourceItemIdsListMap.put((Object)sourceItemId, (Object)almLink);
            String targetItemId = almLink.getTargetTFSItem().getTfsId();
            tfsTargetItemIdsList.add(targetItemId);
            tfsTargetItemIdsListMap.put((Object)targetItemId, (Object)almLink);
        }
        sessionBoardIdList.add(almLink.getSessionBoardId());
    }

    private void getItemsAndTeamContainerIdsByItemLink(HashMap<String, Object> itemJiraDependenciesListMap, List<String> sessionBoardIdList, List<String> sourceItemIdsList, List<String> targetItemIdsList, List<String> sourceTeamContainerIdsList, List<String> targetTeamContainerIdsList, Multimap<String, ItemLink> sourceItemIdsListMap, Multimap<String, ItemLink> targetItemIdsListMap, Multimap<String, ItemLink> sourceTeamContainerIdsListMap, Multimap<String, ItemLink> targetTeamContainerIdsListMap, ItemLink itemLink) {
        try {
            if (PropertyValidator.isValid((Object)itemLink.getAlmLinkId())) {
                itemJiraDependenciesListMap.put(itemLink.getAlmLinkId(), itemLink.getAlmLinkId());
            }
            String sourceItemId = itemLink.getSourceItemId() == null ? itemLink.getSourceFeatureId() : itemLink.getSourceItemId();
            String targetItemId = itemLink.getTargetItemId() == null ? itemLink.getTargetFeatureId() : itemLink.getTargetItemId();
            sourceItemIdsList.add(sourceItemId);
            targetItemIdsList.add(targetItemId);
            sessionBoardIdList.add(itemLink.getSessionBoardId());
            sourceItemIdsListMap.put((Object)sourceItemId, (Object)itemLink);
            targetItemIdsListMap.put((Object)targetItemId, (Object)itemLink);
            sourceTeamContainerIdsList.add(itemLink.getSourceTeamContainerId());
            targetTeamContainerIdsList.add(itemLink.getTargetTeamContainerId());
            sourceTeamContainerIdsListMap.put((Object)itemLink.getSourceTeamContainerId(), (Object)itemLink);
            targetTeamContainerIdsListMap.put((Object)itemLink.getTargetTeamContainerId(), (Object)itemLink);
        }
        catch (Exception e) {
            LOGGER.debug("error occurred in method getItemsAndTeamContainerIdsByItemLink()---" + e.getMessage());
            throw new KendisException(e.getMessage());
        }
    }

    private void setItemAndTeamContainersForItemLink(List<String> sourceItemIdsList, List<String> targetItemIdsList, List<String> sourceTeamContainerIdsList, List<String> targetTeamContainerIdsList, Multimap<String, ItemLink> sourceItemIdsListMap, Multimap<String, ItemLink> targetItemIdsListMap, Multimap<String, ItemLink> sourceTeamContainerIdsListMap, Multimap<String, ItemLink> targetTeamContainerIdsListMap) {
        try {
            List sourceItemList = this.getItemListById(sourceItemIdsList);
            this.setItemLinkItemField(sourceItemList, sourceItemIdsListMap, true);
            List targetItemList = this.getItemListById(targetItemIdsList);
            this.setItemLinkItemField(targetItemList, targetItemIdsListMap, false);
            List sourceTcList = this.getTeamContainerListById(sourceTeamContainerIdsList);
            this.setItemLinkTeamContainerField(sourceTcList, sourceTeamContainerIdsListMap, true);
            List targetTcList = this.getTeamContainerListById(targetTeamContainerIdsList);
            this.setItemLinkTeamContainerField(targetTcList, targetTeamContainerIdsListMap, false);
        }
        catch (Exception e) {
            LOGGER.debug("Error occurred in method setItemAndTeamContainersForItemLink" + e.getMessage());
            throw new KendisException(e.getMessage());
        }
    }

    private List<ItemJiraDependency> getItemJiraDependencies(HashMap<String, Object> itemJiraDependenciesListMap, String userId, List<ItemJiraDependency> itemJiraDependencyList) {
        List watcherList = this.loadWatchersListByUserId(userId);
        List itemJiraDependenciesList = this.getItemJiraDependencyListByResponsible(userId, watcherList);
        itemJiraDependenciesList.forEach(itemJiraDependency -> {
            if (!itemJiraDependenciesListMap.containsKey(itemJiraDependency.getJiraDependencyId())) {
                itemJiraDependencyList.add((ItemJiraDependency)itemJiraDependency);
            }
        });
        return itemJiraDependenciesList;
    }

    private List<SessionBoard> loadSessionBoardMetaInformation(List<String> sessionBoardIdList) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").in(sessionBoardIdList));
        return this.mongoTemplate.find(query, SessionBoard.class);
    }

    public List<SessionBoard> loadSessionBoardMetaInformationBySessionId(List<ObjectId> sessionBoardIdList) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"session.$id").in(sessionBoardIdList));
        return this.mongoTemplate.find(query, SessionBoard.class);
    }

    private void setItemLinkTeamContainerField(List<TeamContainer> teamContainerList, Multimap<String, ItemLink> teamContainerIdsListMap, boolean isSourceTC) {
        teamContainerList.forEach(teamContainer -> {
            List itemLinkList = (List)teamContainerIdsListMap.get((Object)teamContainer.getId());
            itemLinkList.forEach(itemLink -> {
                if (isSourceTC && itemLink.getSourceItem() != null) {
                    if (itemLink.getSourceItem().getTeamContainers() == null) {
                        itemLink.getSourceItem().setTeamContainers(new ArrayList());
                        itemLink.getSourceItem().getTeamContainers().add(teamContainer);
                    } else {
                        itemLink.getSourceItem().getTeamContainers().add(teamContainer);
                    }
                } else if (itemLink.getTargetItem() != null) {
                    if (itemLink.getTargetItem().getTeamContainers() == null) {
                        itemLink.getTargetItem().setTeamContainers(new ArrayList());
                        itemLink.getTargetItem().getTeamContainers().add(teamContainer);
                    } else {
                        itemLink.getTargetItem().getTeamContainers().add(teamContainer);
                    }
                }
            });
        });
    }

    private void setItemLinkItemField(List<Item> itemList, Multimap<String, ItemLink> itemIdsListMap, boolean isSourceItem) {
        for (Item item : itemList) {
            List itemLinkList = (List)itemIdsListMap.get((Object)item.getId());
            itemLinkList.forEach(itemLink -> {
                if (isSourceItem) {
                    itemLink.setSourceItem(item);
                } else {
                    itemLink.setTargetItem(item);
                }
            });
        }
    }

    private void setAlmLinkItemField(List<Item> itemList, Multimap<String, ItemJiraDependency> itemIdsListMap, boolean isSourceItem, boolean isTFS) {
        for (Item item : itemList) {
            List almLinkList = isTFS ? (List)itemIdsListMap.get((Object)item.getTfsId()) : (List)itemIdsListMap.get((Object)item.getJiraId());
            almLinkList.forEach(almLink -> {
                if (isSourceItem) {
                    almLink.setSourceItem(item);
                } else {
                    almLink.setTargetItem(item);
                }
            });
        }
    }

    private List<TeamContainer> getTeamContainerListById(List<String> teamContainerIdsList) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").in(teamContainerIdsList));
        return this.mongoTemplate.find(query, TeamContainer.class);
    }

    private List<Item> getItemListById(List<String> itemIdsList) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").in(itemIdsList));
        return this.mongoTemplate.find(query, Item.class);
    }

    private List<Item> getItemListByIdForJiraAlm(List<String> itemIdsList) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"jiraId").in(itemIdsList));
        return this.mongoTemplate.find(query, Item.class);
    }

    private List<ItemJiraDependency> getItemJiraDependencyListByResponsible(String userId, List<Watcher> watcherList) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        List<Criteria> criterias = watcherList.stream().map(watcher -> Criteria.where((String)"watcherList.$id").is((Object)new ObjectId(watcher.getId()))).collect(Collectors.toList());
        criterias.add(Criteria.where((String)"responsible.$id").is((Object)new ObjectId(userId)));
        criterias.add(Criteria.where((String)"reporter.$id").is((Object)new ObjectId(userId)));
        criteria.orOperator(criterias.toArray(new Criteria[criterias.size()]));
        query.addCriteria((CriteriaDefinition)criteria);
        List itemJiraDependencyList = this.mongoTemplate.find(query, ItemJiraDependency.class);
        return itemJiraDependencyList;
    }

    private List<ItemLink> getItemLinkListByUserIdAndWatcherId(String userId, List<Watcher> watcherList) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        List<Criteria> criterias = watcherList.stream().map(watcher -> Criteria.where((String)"watcherList.$id").is((Object)new ObjectId(watcher.getId()))).collect(Collectors.toList());
        criterias.add(Criteria.where((String)"responsible.$id").is((Object)new ObjectId(userId)));
        criterias.add(Criteria.where((String)"reporter.$id").is((Object)new ObjectId(userId)));
        criteria.orOperator(criterias.toArray(new Criteria[criterias.size()]));
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, ItemLink.class);
    }

    public List<WorkFlow> getAllWorkFlows() {
        List workFlows = this.workFlowRepository.findAllByWorkflowType("Risk");
        if (workFlows.size() == 0) {
            this.createWorkFlow();
            workFlows = this.workFlowRepository.findAllByWorkflowType("Risk");
        }
        List statuses = null;
        for (WorkFlow workFlow : workFlows) {
            statuses = this.statusRepository.findByWorkFlow(workFlow);
            ArrayList sortedStatuses = new ArrayList();
            HashMap<String, Status> sortedStatusesMap = new HashMap<String, Status>();
            String[] sortedStatusIds = workFlow.getStatusSequence().split(",");
            for (Status status : statuses) {
                sortedStatusesMap.put(status.getId(), status);
            }
            for (String statusId : sortedStatusIds) {
                sortedStatuses.add(sortedStatusesMap.get(statusId));
            }
            workFlow.setStatuses(sortedStatuses);
        }
        return workFlows;
    }

    private void createWorkFlow() {
        WorkFlow workFlow = new WorkFlow();
        workFlow.setWorkflowType(WorkFlow.WorkFlowType.Risk.toString());
        workFlow.setTitle("Risk WorkFlow");
        WorkFlow savedWorkFlow = (WorkFlow)this.workFlowRepository.save((Object)workFlow);
        Status status1 = new Status();
        status1.setCategory("ToDo");
        status1.setTitle("Open");
        status1.setWorkFlow(workFlow);
        this.statusRepository.save((Object)status1);
        Status status2 = new Status();
        status2.setCategory("InProgress");
        status2.setTitle("Owned");
        status2.setWorkFlow(workFlow);
        this.statusRepository.save((Object)status2);
        Status status3 = new Status();
        status3.setCategory("Done");
        status3.setTitle("Accepted");
        status3.setWorkFlow(workFlow);
        this.statusRepository.save((Object)status3);
        Status status4 = new Status();
        status4.setCategory("Done");
        status4.setTitle("Mitigated");
        status4.setWorkFlow(workFlow);
        this.statusRepository.save((Object)status4);
        Status status5 = new Status();
        status5.setCategory("Done");
        status5.setTitle("Resolved");
        status5.setWorkFlow(workFlow);
        this.statusRepository.save((Object)status5);
        String sequence = status1.getId() + "," + status2.getId() + "," + status3.getId() + "," + status4.getId() + "," + status5.getId();
        workFlow.setStatusSequence(sequence);
        this.workFlowRepository.save((Object)workFlow);
    }

    public HashMap<String, Object> getRisksListByUserId(String userId) {
        try {
            LOGGER.debug("In Method getRisksListByUserId");
            LOGGER.debug("Going to fetch risks List for User with id: " + userId);
            List watcherList = this.loadWatchersListByUserId(userId);
            List riskList = this.loadRisksByResponsibleFieldAndWatcherField(userId, watcherList);
            if (riskList.size() == 0) {
                throw new KendisException("No Risks Found For User with id " + userId);
            }
            LOGGER.debug("Risks Of Size -> " + riskList.size() + " are Found");
            Map returnedRiskRegisterInfoMap = this.getRiskRegisterAndRiskRegisterIdsListFromRisks(riskList);
            this.assignSessionBoardFieldToRiskRegister(returnedRiskRegisterInfoMap);
            List workFlows = this.getAllWorkFlows();
            LOGGER.debug("Preparing Response Data");
            HashMap<String, Object> responseData = new HashMap<String, Object>();
            responseData.put("riskRegisterList", returnedRiskRegisterInfoMap.get("riskRegisterList"));
            responseData.put("risksList", riskList);
            responseData.put("watcherList", watcherList);
            responseData.put("sessionBoards", returnedRiskRegisterInfoMap.get("sessionBoards"));
            responseData.put("riskRegisterIdsListMap", returnedRiskRegisterInfoMap.get("riskRegisterIdsListMap"));
            responseData.put("riskids", riskList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            responseData.put("workFlows", workFlows);
            return responseData;
        }
        catch (Exception e) {
            LOGGER.error("Error Occurred while fetching Risks List For User With Id-->" + userId);
            throw new KendisException(e.getMessage());
        }
    }

    private void assignSessionBoardFieldToRiskRegister(Map<String, Object> returnedRiskRegisterInfoMap) {
        List riskRegisterIdsList = (List)returnedRiskRegisterInfoMap.get("riskRegisterIdsList");
        HashMap riskRegisterIdsListMap = (HashMap)returnedRiskRegisterInfoMap.get("riskRegisterIdsListMap");
        HashMap riskRegisterSessionBoardListMap = new HashMap();
        Query query = new Query();
        query.fields().include("id").include("title").include("riskRegister");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"riskRegister.$id").in((Collection)riskRegisterIdsList));
        List sessions = this.mongoTemplate.find(query, Session.class);
        if (sessions.size() == 0) {
            return;
        }
        LOGGER.debug("Sessions List of size " + sessions.size() + " returned");
        LOGGER.debug("Going to fetch sessionBoards by session Ids");
        ArrayList sessionBoardsIdsList = new ArrayList();
        sessions.forEach(session -> {
            sessionBoardsIdsList.add(new ObjectId(session.getId()));
            riskRegisterSessionBoardListMap.put(session.getId(), session);
        });
        query = new Query();
        query.fields().include("id").include("session").include("teamSequence").include("containers").include("teams");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"session.$id").in(sessionBoardsIdsList));
        List sessionBoards = this.mongoTemplate.find(query, SessionBoard.class);
        if (sessionBoards.size() == 0) {
            return;
        }
        LOGGER.debug("SessionBoards List of size " + sessionBoards.size() + " returned");
        LOGGER.debug("Going to assign sessionBoard Field for each risk Register");
        sessionBoards.forEach(sessionBoard -> {
            Session session = (Session)riskRegisterSessionBoardListMap.get(sessionBoard.getSession().getId());
            RiskRegister riskRegister = (RiskRegister)riskRegisterIdsListMap.get(session.getRiskRegister().getId());
            riskRegister.setSessionBoard(sessionBoard);
        });
        returnedRiskRegisterInfoMap.put("sessionBoards", sessionBoards);
    }

    private Map<String, Object> getRiskRegisterAndRiskRegisterIdsListFromRisks(List<Risk> riskList) {
        if (riskList.size() > 0) {
            HashMap<String, Object> returnDataMap = new HashMap<String, Object>();
            HashMap riskRegisterIdsListMap = new HashMap();
            ArrayList riskRegisterList = new ArrayList();
            ArrayList riskRegisterIds = new ArrayList();
            riskList.forEach(risk -> {
                if (risk.getRiskRegister() != null && !riskRegisterIdsListMap.containsKey(risk.getRiskRegister().getId())) {
                    riskRegisterList.add(risk.getRiskRegister());
                    riskRegisterIds.add(new ObjectId(risk.getRiskRegister().getId()));
                    riskRegisterIdsListMap.put(risk.getRiskRegister().getId(), risk.getRiskRegister());
                }
            });
            returnDataMap.put("riskRegisterList", riskRegisterList);
            returnDataMap.put("riskRegisterIdsList", riskRegisterIds);
            returnDataMap.put("riskRegisterIdsListMap", riskRegisterIdsListMap);
            return returnDataMap;
        }
        return null;
    }

    private List<Risk> loadRisksByResponsibleFieldAndWatcherField(String userId, List<Watcher> watcherList) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        List<Criteria> criterias = watcherList.stream().map(watcher -> Criteria.where((String)"watcherList.$id").is((Object)new ObjectId(watcher.getId()))).collect(Collectors.toList());
        criterias.add(Criteria.where((String)"responsible.$id").is((Object)new ObjectId(userId)));
        criteria.orOperator(criterias.toArray(new Criteria[criterias.size()]));
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, Risk.class);
    }

    public HashMap<String, Object> getImpedimentsListByUserId(String userId) {
        try {
            LOGGER.debug("In method getImpedimentsListByUserId");
            LOGGER.debug("fetching impediments list for user with id ->" + userId);
            ArrayList fieldsIdsList = new ArrayList();
            this.getFieldsIdListByTitleAndType("Responsible", "userpicker", fieldsIdsList);
            if (!PropertyValidator.isValid(fieldsIdsList)) {
                LOGGER.error("No Impediments Responsible Found.");
                throw new KendisException("No Impediments Responsible Found.");
            }
            List impedimentsList = this.getImpedimentsByUserIdAndFieldsId(fieldsIdsList, userId, "Impediment");
            HashMap sessionBoardsMap = this.getSessions(impedimentsList);
            LOGGER.debug("Preparing response Data");
            LOGGER.debug("Got Impediments of size --->" + impedimentsList.size());
            HashMap<String, Object> responseData = new HashMap<String, Object>();
            responseData.put("items", impedimentsList);
            responseData.put("sessionsMap", sessionBoardsMap);
            return responseData;
        }
        catch (Exception e) {
            throw new KendisException("Error Occurred while fetching impediments list for user with id ->" + userId);
        }
    }

    private List<ObjectId> getFieldsIdListByTitleAndType(String fieldTitle, String fieldType, List<ObjectId> fieldsIdsList) {
        try {
            List fieldsList = this.fieldsRepository.findAllByTitleAndType(fieldTitle, fieldType);
            for (Fields fields : fieldsList) {
                fieldsIdsList.add(new ObjectId(fields.getId()));
            }
            return fieldsIdsList;
        }
        catch (Exception e) {
            LOGGER.error("Error occurred in method getFieldsIdListByTitleAndType()--" + e.getMessage());
            throw new KendisException(e.getMessage());
        }
    }

    private List<BaseItem> getImpedimentsByUserIdAndFieldsId(List<ObjectId> fieldsIdsList, String userId, String itemType) {
        try {
            Query query = new Query();
            Criteria[] criterias = (Criteria[])fieldsIdsList.stream().map(fieldId -> Criteria.where((String)String.format("fields.%s.id", fieldId)).is((Object)userId)).toArray(Criteria[]::new);
            query.addCriteria((CriteriaDefinition)new Criteria().orOperator(criterias));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)itemType));
            return this.mongoTemplate.find(query, BaseItem.class);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred in method getImpedimentsByUserIdAndFieldsId()---" + e.getMessage());
            throw new KendisException(e.getMessage());
        }
    }

    private HashMap<String, SessionBoard> getSessionBoards(List<BaseItem> impedimentsList) {
        ArrayList sessionBoardIds = new ArrayList();
        HashMap<String, SessionBoard> sessionBoardsIdMap = new HashMap<String, SessionBoard>();
        ArrayListMultimap sessionBoardToImpedimentsListMap = ArrayListMultimap.create();
        impedimentsList.stream().forEach(arg_0 -> MyViewServiceImpl.lambda$getSessionBoards$16(sessionBoardIds, sessionBoardsIdMap, (Multimap)sessionBoardToImpedimentsListMap, arg_0));
        List sessionBoards = this.loadSessionBoardMetaInformationBySessionId(sessionBoardIds);
        sessionBoards.forEach(arg_0 -> MyViewServiceImpl.lambda$getSessionBoards$18(sessionBoardsIdMap, (Multimap)sessionBoardToImpedimentsListMap, arg_0));
        return sessionBoardsIdMap;
    }

    private HashMap<String, Session> getSessions(List<BaseItem> impedimentsList) {
        HashMap<String, Session> sessionIdMap = new HashMap<String, Session>();
        HashSet<String> sessionIds = new HashSet<String>();
        for (BaseItem item : impedimentsList) {
            List baseItemLinks = item.getBaseItemLinks();
            if (!PropertyValidator.isValid((Collection)baseItemLinks)) continue;
            for (BaseItemLink baseItemLink : baseItemLinks) {
                if (!PropertyValidator.isValid((Object)baseItemLink) || !PropertyValidator.isValid((Object)baseItemLink.getSessionId())) continue;
                sessionIds.add(baseItemLink.getSessionId());
            }
        }
        List sessions = this.sessionRepository.findSessionByIdIn(new ArrayList(sessionIds));
        for (Session session : sessions) {
            sessionIdMap.put(session.getId(), session);
        }
        return sessionIdMap;
    }

    public HashMap<String, Object> getActionPointsByMentionId(String dataMentionId) {
        try {
            List actionPointsByMention = this.getActionPointsByMention(dataMentionId, "ActionPoint");
            if (actionPointsByMention.size() == 0) {
                throw new KendisException("NO Action Points Found");
            }
            HashMap sessionBoardsMap = this.getSessions(actionPointsByMention);
            HashMap<String, Object> responseData = new HashMap<String, Object>();
            LOGGER.debug("Preparing Response Data");
            LOGGER.debug("Found Action Points List of size---> " + actionPointsByMention.size());
            responseData.put("items", actionPointsByMention);
            responseData.put("sessionsMap", sessionBoardsMap);
            return responseData;
        }
        catch (Exception e) {
            LOGGER.error("Error occurred in method getActionPointsByMentionId()---" + e.getMessage());
            throw new KendisException(e.getMessage());
        }
    }

    private List<BaseItem> getActionPointsByMention(String dataMentionId, String itemType) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)itemType));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"title").regex("data-mention-id=\"" + dataMentionId));
        return this.mongoTemplate.find(query, BaseItem.class);
    }

    public HashMap<String, Object> loadActionPointWithTemplate(String id) {
        BaseItem baseItem = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)id));
        if (!PropertyValidator.isValid((Object)baseItem)) {
            LOGGER.debug("Cannot find Action Point with id " + id);
            throw new KendisException("cannot find action point with id " + id);
        }
        if (!PropertyValidator.isValid((Object)baseItem.getItemType()) && (baseItem.getFieldsTemplate() == null || baseItem.getFieldsTemplate().getId() == null || "0".equals(baseItem.getFieldsTemplate().getId()))) {
            FieldTemplate template = this.fieldTemplateRepository.findByType(baseItem.getType());
            if (template == null) {
                template = new FieldTemplate();
                List<Object> fields = new ArrayList<Fields>();
                fields.add(new Fields("1", "Title", "simpleEditor", null, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
                fields = this.fieldsRepository.save(fields);
                template.setConfiguredFields(fields);
                template.setType(baseItem.getType());
                template = (FieldTemplate)this.fieldTemplateRepository.save((Object)template);
                LOGGER.debug("New Template Created with Configured Fields");
                baseItem.setFieldsTemplate(template);
            } else {
                baseItem.setFieldsTemplate(template);
            }
            this.baseItemRepository.save((Object)baseItem);
        }
        LOGGER.debug("Preparing Response Data");
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        responseData.put("item", baseItem);
        return responseData;
    }

    private static /* synthetic */ void lambda$getSessionBoards$18(HashMap sessionBoardsIdMap, Multimap sessionBoardToImpedimentsListMap, SessionBoard sessionBoard) {
        sessionBoardsIdMap.put(sessionBoard.getId(), sessionBoard);
        List impediments = (List)sessionBoardToImpedimentsListMap.get((Object)sessionBoard.getSession().getId());
        impediments.forEach(impediment -> impediment.setSessionBoard(sessionBoard));
    }

    private static /* synthetic */ void lambda$getSessionBoards$16(List sessionBoardIds, HashMap sessionBoardsIdMap, Multimap sessionBoardToImpedimentsListMap, BaseItem impediment) {
        if (impediment.getBaseItemLinks() != null && impediment.getBaseItemLinks().size() > 0) {
            sessionBoardIds.add(new ObjectId(((BaseItemLink)impediment.getBaseItemLinks().get(0)).getSessionId()));
            sessionBoardIds.add(new ObjectId(((BaseItemLink)impediment.getBaseItemLinks().get(1)).getSessionId()));
            sessionBoardsIdMap.put(((BaseItemLink)impediment.getBaseItemLinks().get(0)).getSessionId(), null);
            sessionBoardsIdMap.put(((BaseItemLink)impediment.getBaseItemLinks().get(1)).getSessionId(), null);
            sessionBoardToImpedimentsListMap.put((Object)((BaseItemLink)impediment.getBaseItemLinks().get(0)).getSessionId(), (Object)impediment);
            sessionBoardToImpedimentsListMap.put((Object)((BaseItemLink)impediment.getBaseItemLinks().get(1)).getSessionId(), (Object)impediment);
        }
    }

    private /* synthetic */ void lambda$getItemLinksForKendisAndALM$2(List sessionBoardIdList, List jiraLinksSourceItemIdsList, List jiraLinkTargetItemIdsList, Multimap jiraLinksSourceItemIdsListMap, Multimap jiraLinksTargetItemIdsListMap, List tfsLinksSourceItemIdsList, List tfsLinkTargetItemIdsList, Multimap tfsLinksSourceItemIdsListMap, Multimap tfsLinksTargetItemIdsListMap, ItemJiraDependency almLink) {
        this.getItemsAndTeamContainerIdsByAlmLink(sessionBoardIdList, jiraLinksSourceItemIdsList, jiraLinkTargetItemIdsList, jiraLinksSourceItemIdsListMap, jiraLinksTargetItemIdsListMap, tfsLinksSourceItemIdsList, tfsLinkTargetItemIdsList, tfsLinksSourceItemIdsListMap, tfsLinksTargetItemIdsListMap, almLink);
    }

    private /* synthetic */ void lambda$getItemLinksForKendisAndALM$1(HashMap itemJiraDependenciesListMap, List sessionBoardIdList, List itemLinkSourceItemIdsList, List itemLinkTargetItemIdsList, List sourceTeamContainerIdsList, List targetTeamContainerIdsList, Multimap itemLinksSourceItemIdsListMap, Multimap itemLinksTargetItemIdsListMap, Multimap sourceTeamContainerIdsListMap, Multimap targetTeamContainerIdsListMap, ItemLink itemLink) {
        this.getItemsAndTeamContainerIdsByItemLink(itemJiraDependenciesListMap, sessionBoardIdList, itemLinkSourceItemIdsList, itemLinkTargetItemIdsList, sourceTeamContainerIdsList, targetTeamContainerIdsList, itemLinksSourceItemIdsListMap, itemLinksTargetItemIdsListMap, sourceTeamContainerIdsListMap, targetTeamContainerIdsListMap, itemLink);
    }
}

