/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.persistence.entity.dto.LdapUser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.springframework.ldap.core.AttributesMapper;

class MultipleAttributesMapper
implements AttributesMapper<LdapUser> {
    private String type;

    public MultipleAttributesMapper(String type) {
        this.type = type;
    }

    public LdapUser mapFromAttributes(Attributes attributes) throws NamingException {
        String names;
        LdapUser ldapUser = new LdapUser();
        ldapUser.setId(attributes.get("sAMAccountName").get().toString());
        ldapUser.setDn(attributes.get("distinguishedname").get().toString());
        if (attributes.get("mail") != null) {
            ldapUser.setEmail(attributes.get("mail").get().toString());
        }
        if (attributes.get("cn") != null && (names = attributes.get("cn").get().toString()) != null) {
            String[] namesArrp = names.split("\\s+");
            ldapUser.setFirstName(namesArrp[0]);
            if (namesArrp.length > 1) {
                ldapUser.setLastName(namesArrp[1]);
            }
            if (namesArrp.length > 2) {
                ldapUser.setLastName(namesArrp[2]);
            }
        }
        if (attributes.get("objectClass").contains("user")) {
            ldapUser.setType("user");
        } else if (attributes.get("objectClass").contains("group")) {
            ldapUser.setType("group");
        }
        NamingEnumeration<? extends Attribute> attribs = attributes.getAll();
        while (attribs.hasMoreElements()) {
            Attribute value = attribs.next();
            String fixed = value.toString().replaceAll("[^\\u0000-\\uFFFF]", "");
            ldapUser.getOtherAttributes().add(fixed);
        }
        if (attributes.get("memberof") != null) {
            NamingEnumeration<?> bAttribs = attributes.get("memberof").getAll();
            while (bAttribs.hasMoreElements()) {
                Object value = bAttribs.next();
                ldapUser.getGroups().add(value.toString());
            }
        }
        return ldapUser;
    }
}

