/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.google.gson.Gson;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.KendisStats;
import com.viztrend.safe.persistence.entity.PaymentPackageConfig;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.ItemTypeRepository;
import com.viztrend.safe.persistence.repository.KendisStatsRepository;
import com.viztrend.safe.persistence.repository.ReportRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.KendisStatsService;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.S3CacheUtil;
import com.viztrend.safe.utils.StringUtils;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="KendisStatsService")
@Transactional
@ConditionalOnProperty(value={"isLocalDeployment"}, havingValue="false")
public class KendisStatsServiceImpl
implements KendisStatsService {
    @Autowired
    private KendisStatsRepository kendisStatsRepository;
    @Autowired
    private CompanyRepository companyRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private ItemTypeRepository itemTypeRepository;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private ReportRepository reportRepository;
    @Autowired
    private CustomRepository customRepository;
    @Autowired
    private Environment env;
    private static final Logger LOGGER = LoggerFactory.getLogger(KendisStatsServiceImpl.class);

    public List<KendisStats> kendisStatsFetchForConsole() {
        List kendisStatList = this.mongoTemplate.findAll(KendisStats.class);
        return kendisStatList;
    }

    public void saveCompanyDetails(String companyId, String urlPrefix, Date packageExpiryDate, Date nextPaymentDate, long userCount, Boolean isPremium) {
        Company companyData = (Company)this.companyRepository.findOne((Serializable)((Object)companyId));
        PaymentPackageConfig paymentPackageConfig = new PaymentPackageConfig();
        companyData.setExpiryDate(packageExpiryDate);
        companyData.setNextPaymentDate(nextPaymentDate);
        companyData.setUserCount(userCount);
        if (isPremium.booleanValue()) {
            paymentPackageConfig.setAllTrue();
            companyData.setIsPremium(isPremium);
            companyData.setPaymentPackageConfig(paymentPackageConfig);
        }
        companyData = (Company)this.companyRepository.save((Object)companyData);
    }

    @PostConstruct
    public void postConst() {
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        Runnable task = () -> this.syncKendisStatsForCompanyData();
        scheduler.scheduleAtFixedRate(task, 0L, 1L, TimeUnit.DAYS);
    }

    public void syncKendisStatsForCompanyData() {
        new Thread(() -> {
            String statsRemoved = "Stats removed";
            LOGGER.debug("kendis stats sync started");
            try {
                List companiesToSync = null;
                Instant oneDayAgo = Instant.now().minus(Duration.ofDays(1L));
                List kendisStatsForCompanies = this.kendisStatsRepository.findCompanyIdsByLastActiveAfter(Date.from(oneDayAgo));
                LOGGER.debug("total active companies:" + kendisStatsForCompanies.size());
                if (PropertyValidator.isValid((Collection)kendisStatsForCompanies)) {
                    List companyIds = kendisStatsForCompanies.stream().map(KendisStats::getCompanyId).collect(Collectors.toList());
                    companiesToSync = this.companyRepository.findByIdIn(companyIds);
                    LOGGER.debug("going to sync companies:" + companiesToSync.size());
                }
                if (PropertyValidator.isValid(companiesToSync)) {
                    for (Company company : companiesToSync) {
                        String tenant = company.getTenant();
                        String companyId = company.getId();
                        Long usersCount = this.userRepository.countByUserCompanies_Company_IdAndUserCompanies_isArchive(companyId, Boolean.valueOf(false));
                        Long sessionsCountWithoutAlm = this.sessionRepository.countByTenantAndArchiveFalseAndAlmConfigurationsIsNullAndTfsAlmConfigurationsIsNull(tenant);
                        Long sessionsCountWithAlm = this.sessionRepository.countByTenantAndArchiveFalseAndAlmConfigurationsNotNull(tenant);
                        Long sessionsCountWithTfsAlm = this.sessionRepository.countByTenantAndArchiveFalseAndTfsAlmConfigurationsNotNull(tenant);
                        sessionsCountWithAlm = sessionsCountWithAlm + sessionsCountWithTfsAlm;
                        Long workSpaceCount = this.workSpaceRepository.countByTenantAndArchiveFalse(tenant);
                        List users = this.userRepository.findByUserCompanies_Company_Id(companyId);
                        Date signupDate = company.getCreatedOn();
                        Date expiryDate = company.getExpiryDate();
                        Date nextPaymentDate = company.getNextPaymentDate();
                        Boolean isManualPayment = company.getPaymentDetails() == null && company.getNextPaymentDate() != null;
                        HashMap<String, Object> statsMap = new HashMap<String, Object>();
                        statsMap.put("usersCount", usersCount);
                        statsMap.put("sessionsCountWithoutAlm", sessionsCountWithoutAlm);
                        statsMap.put("sessionsCountWithAlm", sessionsCountWithAlm);
                        statsMap.put("workSpaceCount", workSpaceCount);
                        statsMap.put("signupDate", signupDate);
                        statsMap.put("expiryDate", expiryDate);
                        statsMap.put("nextPaymentDate", nextPaymentDate);
                        statsMap.put("isManualPayment", isManualPayment);
                        statsMap.put("name", company.getName());
                        statsMap.put("prefix", company.getUrlPrefix());
                        statsMap.put("cardTypes", statsRemoved);
                        statsMap.put("jiraItems", statsRemoved);
                        statsMap.put("localItems", statsRemoved);
                        statsMap.put("reports", statsRemoved);
                        statsMap.put("links", statsRemoved);
                        ArrayList<String> usersLst = new ArrayList<String>();
                        for (User user : users) {
                            usersLst.add(user.getUserName());
                        }
                        statsMap.put("users", usersLst);
                        KendisStats kendisStats = this.kendisStatsRepository.findByCompanyId(company.getId());
                        if (!PropertyValidator.isValid((Object)kendisStats)) {
                            kendisStats = new KendisStats();
                        }
                        kendisStats.setCompanyId(company.getId());
                        kendisStats.setStats(new Gson().toJson(statsMap));
                        LOGGER.debug("goint to sync company stats for:" + company.getUrlPrefix());
                        this.kendisStatsRepository.save((Object)kendisStats);
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            }
        }).start();
    }

    public void syncAciveAlmAccountForWebhook() {
        try {
            List companies = this.customRepository.findActiveCompaines();
            List almAccount = this.customRepository.getActiveAlmAccounts(companies);
            S3CacheUtil.regenerateAccounts((List)almAccount);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    @Scheduled(fixedRate=3600000L)
    public void unbockActiveAlmAcountInS3() {
        String accessKey = this.env.getProperty("sqs.aws.accessKey");
        boolean isLocal = Boolean.parseBoolean(this.env.getProperty("isLocalDeployment"));
        if (accessKey.contains("xxxxxx") || isLocal) {
            LOGGER.info("Skipping unbockActiveAlmAcountInS3 \u2014 invalid AWS credentials or local deployment");
            return;
        }
        try {
            List companies = this.customRepository.findActiveCompaines();
            List almAccount = this.customRepository.getActiveAlmAccounts(companies);
            for (String almId : almAccount) {
                S3CacheUtil.unblockAccount((String)almId);
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }
}

