/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.google.gson.Gson;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.jira.ImportUtil;
import com.viztrend.safe.alm.jira.JiraUtils;
import com.viztrend.safe.alm.jira.bo.JiraFilter;
import com.viztrend.safe.alm.jira.bo.JiraSearchRequest;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.AppInitConfig;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.PushResponse;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.repository.AppInitConfigRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.service.JiraSyncService;
import com.viztrend.safe.service.JiraSyncServiceImpl;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.ResyncParamsVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="JiraSyncService")
public class JiraSyncServiceImpl
implements JiraSyncService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraSyncServiceImpl.class);
    @Autowired
    private ImportUtil importUtil;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private PushResponseRepository pushResponseRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private AppInitConfigRepository appInitConfigRepository;

    public Item getSyncingItem(String id, Map<String, Item> map, ResyncParamsVO syncUtil) {
        String kid = (String)syncUtil.backlogAlmIds.get(id);
        if (kid != null && map.containsKey(kid)) {
            return map.get(kid);
        }
        return null;
    }

    private void pushLocalAndGlobal(String cid, String polling, String json, boolean completed) {
        PushSender.sendMsg((String)cid, (String)json);
        if (polling != null) {
            this.pushResponseRepository.save((Object)new PushResponse(polling, json, Boolean.valueOf(completed)));
        }
    }

    public void liveSync(Boolean auto, Long timer, String boardId, String parent, String child, String syncId, String polling, List<String> logs) {
        HashMap<String, Object> metaMap;
        JSONObject pushJson;
        String cid;
        block21: {
            String jiraId;
            List<String> fields = Arrays.asList("_id", "jiraId", "jiraKey", "type", "parent", "jiraFilter");
            SessionBoard board = this.sessionBoardRepository.findById(boardId);
            1 types = new /* Unavailable Anonymous Inner Class!! */;
            if (parent != null) {
                types.add(parent);
            }
            if (child != null) {
                types.add(child);
            }
            ArrayList allItems = null;
            try {
                allItems = this.customRepositoryImpl.retreiveItemsOnly(boardId, (List)types, fields);
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
                allItems = new ArrayList();
            }
            ArrayList parentIssueIds = new ArrayList();
            HashMap<String, String[]> idsMap = new HashMap<String, String[]>();
            HashMap childrenIssueIds = new HashMap();
            for (DBObject vo : allItems) {
                if (!vo.containsField("jiraId") || !vo.containsField("type")) continue;
                jiraId = (String)vo.get("jiraId");
                if (!parent.equals(vo.get("type"))) continue;
                if (parentIssueIds.size() == 0) {
                    parentIssueIds.add(new HashSet());
                }
                Set subList = (Set)parentIssueIds.get(parentIssueIds.size() - 1);
                subList.add(jiraId);
                idsMap.put(String.valueOf(vo.get("_id")), new String[]{(String)vo.get("jiraKey"), (String)vo.get("jiraFilter")});
            }
            if (child != null) {
                for (DBObject vo : allItems) {
                    List listPidsAndFids;
                    String[] fid;
                    DBRef ref;
                    if (!vo.containsField("jiraId") || !vo.containsField("type")) continue;
                    jiraId = (String)vo.get("jiraId");
                    if (!child.equals(vo.get("type")) || !vo.containsField("parent") || !PropertyValidator.isValid((Object)(ref = (DBRef)vo.get("parent"))) || (fid = (String[])idsMap.get(String.valueOf(ref.getId()))) == null || fid[1] == null) continue;
                    if (childrenIssueIds.get(fid[1]) == null) {
                        childrenIssueIds.put(fid[1], new ArrayList());
                    }
                    if ((listPidsAndFids = (List)childrenIssueIds.get(fid[1])).size() == 0) {
                        listPidsAndFids.add(new HashMap());
                    }
                    Map subset = (Map)listPidsAndFids.get(listPidsAndFids.size() - 1);
                    subset.put(jiraId, fid[0]);
                    if (subset.size() % 100 != 0) continue;
                    listPidsAndFids.add(new HashMap());
                }
            }
            allItems.clear();
            allItems = null;
            idsMap.clear();
            idsMap = null;
            cid = UserContextUtil.getUserContext().getCurrentCompanyId();
            Gson gson = new Gson();
            pushJson = new JSONObject();
            AlmAccount almAccount = ((AlmConfigurations)board.getSession().getAlmConfigurations().get(0)).getAlmAccount();
            JSONObject body = new JSONObject();
            JSONArray fieldsJsonArr = new JSONArray();
            fieldsJsonArr.put((Object)"key");
            fieldsJsonArr.put((Object)"id");
            fieldsJsonArr.put((Object)"summary");
            fieldsJsonArr.put((Object)"project");
            fieldsJsonArr.put((Object)"status");
            fieldsJsonArr.put((Object)"issuetype");
            body.put("fields", (Object)fieldsJsonArr);
            metaMap = new HashMap<String, Object>();
            metaMap.put("type", "Board");
            metaMap.put("auto", auto);
            metaMap.put("syncIdFrom", syncId);
            metaMap.put("syncId", syncId);
            metaMap.put("cid", cid);
            metaMap.put("polling", polling);
            pushJson.put("isJira", true);
            pushJson.put("type", (Object)"JiraIssue");
            metaMap.put("boardId", board.getId());
            try {
                AlmConfigurations config;
                List filters;
                if (!PropertyValidator.isValid((Collection)board.getSession().getAlmConfigurations()) || !PropertyValidator.isValid((Collection)(filters = (config = (AlmConfigurations)board.getSession().getAlmConfigurations().get(0)).getFeatureFilter()))) break block21;
                for (JiraFilter filter : filters) {
                    AlmAccount taggedAlmAccount;
                    if (!PropertyValidator.isValid((Object)filter.getJql())) continue;
                    AlmAccount alm = almAccount;
                    if (PropertyValidator.isValid((Object)filter.getFilterFetchedBy()) && PropertyValidator.isValid((Object)(taggedAlmAccount = JiraUtils.getTaggedAlmUser((User)filter.getFilterFetchedBy(), (AlmAccount)almAccount)))) {
                        alm = taggedAlmAccount;
                    }
                    String syncingGap = null;
                    if (PropertyValidator.isValid(parentIssueIds)) {
                        List setOfIds;
                        for (Set set : parentIssueIds) {
                            body.put("jql", (Object)JiraUtils.smartJQL((String)filter.query(), (String)syncingGap, (Collection)set));
                            if (logs != null) {
                                logs.add(body.toString());
                            }
                            this.fetchFromJiraSendToClient(parent, set, null, filter.getId(), alm, gson, body, metaMap, pushJson);
                        }
                        if (child == null || syncingGap == null || syncingGap.length() <= 0 || !PropertyValidator.isValid((Collection)(setOfIds = (List)childrenIssueIds.get(filter.getId())))) continue;
                        for (Map usids : setOfIds) {
                            StringBuilder query = new StringBuilder();
                            query.append(syncingGap);
                            if (!PropertyValidator.isValid((Object)usids)) continue;
                            query.append(" AND ID IN (" + String.join((CharSequence)",", usids.keySet()) + ")");
                            body.put("jql", (Object)query.toString());
                            if (logs != null) {
                                logs.add(body.toString());
                            }
                            this.fetchFromJiraSendToClient(child, null, usids, filter.getId(), alm, gson, body, metaMap, pushJson);
                        }
                        continue;
                    }
                    body.put("jql", (Object)JiraUtils.smartJQL((String)filter.query(), syncingGap, null));
                    if (logs != null) {
                        logs.add(body.toString());
                    }
                    this.fetchFromJiraSendToClient(parent, null, null, filter.getId(), alm, gson, body, metaMap, pushJson);
                }
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        AppInitConfig appInitConfig = (AppInitConfig)this.appInitConfigRepository.findAll().get(0);
        metaMap.put("event", "NOTIFICATION_OPEN");
        if (Boolean.TRUE.equals(appInitConfig.getAutoSync())) {
            metaMap.put("timer", timer);
        }
        pushJson.put("metaMap", metaMap);
        pushJson.remove("jiraIssues");
        pushJson.remove("kendisError");
        this.pushLocalAndGlobal(cid, polling, pushJson.toString(), true);
    }

    private void fetchFromJiraSendToClient(String type, Set<String> jiraIds, Map<String, String> childJiraIds, String fid, AlmAccount alm, Gson gson, JSONObject body, Map<String, Object> metaMap, JSONObject pushJson) {
        String polling = (String)metaMap.get("polling");
        try {
            if (!PropertyValidator.isValid((Object)body.get("jql"))) {
                return;
            }
            int pageSize = 100;
            int startAt = 0;
            int totalRecord = 0;
            JiraSearchRequest result = new JiraSearchRequest(null, Boolean.valueOf(false));
            boolean isCloud = alm.cloud();
            do {
                body.put("maxResults", pageSize);
                body.put("fieldsByKeys", true);
                body.put("nextPageToken", (Object)result.getNextPageToken());
                String endPoint = JiraUtils.decideSearchAPI((String)"/rest/api/3/search/jql", (boolean)isCloud, (JSONObject)body, (int)startAt);
                String responseData = this.importUtil.retrieveJiraResponse(endPoint, alm, body.toString());
                pushJson.remove("kendisError");
                metaMap.put("event", "NOTIFICATION_PUSH");
                pushJson.put("filterId", (Object)fid);
                pushJson.put("metaMap", metaMap);
                pushJson.put("response", (Object)responseData);
                pushJson.put("jiraIds", jiraIds);
                pushJson.put("childJiraIds", childJiraIds);
                pushJson.put("type", (Object)type);
                this.pushLocalAndGlobal((String)metaMap.get("cid"), polling, pushJson.toString(), false);
                result = (JiraSearchRequest)gson.fromJson(responseData, JiraSearchRequest.class);
                if (isCloud) continue;
                startAt += pageSize;
                if (result.getTotal() == null) continue;
                totalRecord = result.getTotal();
            } while (!result.ended(isCloud, startAt, totalRecord));
        }
        catch (ViztrendJiraException e) {
            metaMap.put("event", "NOTIFICATION_ERROR");
            pushJson.put("filterId", (Object)fid);
            pushJson.put("metaMap", metaMap);
            pushJson.put("kendisError", (Object)gson.toJson((Object)e));
            pushJson.remove("jiraIssues");
            this.pushLocalAndGlobal((String)metaMap.get("cid"), polling, pushJson.toString(), false);
        }
    }
}

