/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.google.gson.Gson;
import com.viztrend.safe.persistence.entity.BlackListUserDomain;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.Objective;
import com.viztrend.safe.persistence.entity.ObjectiveValue;
import com.viztrend.safe.persistence.entity.PushResponse;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.repository.BlackListUserDomainRepository;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.InvitationRepository;
import com.viztrend.safe.persistence.repository.ItemLinkRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TeamContainerRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.service.ImportService;
import com.viztrend.safe.utils.Constants;
import com.viztrend.safe.utils.EncDecUtility;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.LocalMailSender;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.MappedFieldVO;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.CsvListReader;
import org.supercsv.io.CsvMapReader;
import org.supercsv.prefs.CsvPreference;

@Component(value="ImportService")
@Transactional
public class ImportServiceImpl
implements ImportService {
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private TeamContainerRepository teamContainerRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private BlackListUserDomainRepository blackListUserDomainRepository;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private InvitationRepository invitationRepository;
    @Autowired
    private CompanyRepository companyRepository;
    @Autowired
    private PushResponseRepository pushResponseRepository;
    @Autowired
    private ItemLinkRepository itemLinkRepository;
    @Autowired
    private LocalMailSender mailSender;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    private List<User> importedUsers = null;
    public static final String[] allFields = new String[]{"Summary", "Status", "Due Date", "Key"};
    protected String dateFormat = "dd/MMM/yy hh:mm aa";
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportServiceImpl.class);

    public ArrayList<MappedFieldVO> mapCsvHeadersToFields(String filePath) {
        ArrayList<MappedFieldVO> inputFields = new ArrayList<MappedFieldVO>();
        try {
            String[] header;
            FileInputStream fis = new FileInputStream(new File(filePath));
            CsvMapReader inFile = new CsvMapReader((Reader)new InputStreamReader((InputStream)fis, "UTF-8"), CsvPreference.EXCEL_PREFERENCE);
            for (String field : header = inFile.getHeader(true)) {
                Boolean mapped = false;
                for (String mf : allFields) {
                    if (!field.toLowerCase().equalsIgnoreCase(mf.toLowerCase())) continue;
                    inputFields.add(new MappedFieldVO(field, mf));
                    mapped = true;
                    break;
                }
                if (mapped.booleanValue()) continue;
                inputFields.add(new MappedFieldVO(field, "", Boolean.valueOf(false)));
            }
            inFile.close();
            return inputFields;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return inputFields;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Object executeImport(Map<String, Object> param, SessionBoard board, ArrayList<MappedFieldVO> inputFields, CsvPreference csvPrefrences) {
        Gson gson = new Gson();
        ArrayList<String> allFields_local = new ArrayList<String>();
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashMap<String, Integer> fieldLocation = new HashMap<String, Integer>();
        String requestId = (String)param.get("syncId");
        String filePath = (String)param.get("filePath");
        if (!PropertyValidator.isValid((Object)filePath)) {
            filePath = (String)param.get("path");
        }
        response.put("requestURL", "/import");
        response.put("importType", param.get("importType"));
        response.put("metaMap", param.get("metaMap"));
        response.put("requestId", param.get("requestId"));
        response.put("isReadOnly", param.get("isReadOnly"));
        if (PropertyValidator.isValid((Object)param.get("syncId"))) {
            response.put("syncId", param.get("syncId"));
        } else if (PropertyValidator.isValid((Object)param.get("metaMap"))) {
            HashMap metaMap = (HashMap)param.get("metaMap");
            String syncId = (String)metaMap.get("syncId");
            response.put("syncId", syncId);
        }
        String importType = (String)param.get("importType");
        HashMap<String, Optional> internalCellProcessors = new HashMap<String, Optional>();
        for (MappedFieldVO mappedFieldVO : inputFields) {
            internalCellProcessors.put(mappedFieldVO.getMappedField(), new Optional());
            allFields_local.add(mappedFieldVO.getMappedField());
        }
        CsvListReader inFileList = null;
        try {
            void var18_27;
            int i;
            FileInputStream fis = new FileInputStream(new File(filePath));
            inFileList = new CsvListReader((Reader)new InputStreamReader((InputStream)fis, "UTF-8"), csvPrefrences);
            String[] header = inFileList.getHeader(true);
            String[] cleanedHeader = (String[])Arrays.stream(header).filter(Objects::nonNull).toArray(String[]::new);
            header = cleanedHeader;
            if (!PropertyValidator.isValid(inputFields)) {
                i = 0;
                for (String field : header) {
                    Boolean mapped = false;
                    for (String mf : allFields_local) {
                        if (!field.toLowerCase().equalsIgnoreCase(mf.toLowerCase())) continue;
                        inputFields.add(new MappedFieldVO(field, mf));
                        mapped = true;
                        fieldLocation.put(mf, i);
                        break;
                    }
                    if (!mapped.booleanValue()) {
                        inputFields.add(new MappedFieldVO(field, "", Boolean.valueOf(false)));
                    }
                    ++i;
                }
            } else {
                for (MappedFieldVO mappedFieldVO : inputFields) {
                    int j = 0;
                    for (String field : header) {
                        if (PropertyValidator.isValid((Object)field) && field.equals(mappedFieldVO.getInputField()) && !"".equals(mappedFieldVO.getMappedField())) {
                            fieldLocation.put(mappedFieldVO.getMappedField(), j);
                        }
                        ++j;
                    }
                }
                i = 0;
                for (String field : header) {
                    MappedFieldVO mfVo;
                    Boolean mapped = false;
                    for (String mf : allFields_local) {
                        if (!PropertyValidator.isValid((Object)field) || !field.toLowerCase().equalsIgnoreCase(mf.toLowerCase())) continue;
                        MappedFieldVO mfVo2 = new MappedFieldVO(field, mf, Boolean.valueOf(true));
                        if (!inputFields.contains(mfVo2)) {
                            inputFields.add(mfVo2);
                            mapped = true;
                            if (fieldLocation.get(mf) != null) break;
                            fieldLocation.put(mf, i);
                            break;
                        }
                        if (fieldLocation.get(mf) == null) {
                            fieldLocation.put(mf, i);
                        }
                        mapped = true;
                        break;
                    }
                    if (!mapped.booleanValue() && !inputFields.contains(mfVo = new MappedFieldVO(field, "", Boolean.valueOf(false)))) {
                        inputFields.add(mfVo);
                    }
                    ++i;
                }
            }
            CellProcessor[] csvCellProcessors = new CellProcessor[header.length];
            boolean bl = false;
            while (var18_27 < header.length) {
                for (MappedFieldVO field : inputFields) {
                    if (!header[var18_27].equals(field.getInputField())) continue;
                    csvCellProcessors[var18_27] = (CellProcessor)internalCellProcessors.get(field.getMappedField());
                }
                ++var18_27;
            }
            if (PropertyValidator.isValid((Object)board)) {
                if (importType.equals("objectives")) {
                    this.importObjectives(board, inFileList, inputFields, internalCellProcessors, fieldLocation, response);
                } else {
                    this.importItems(board, inFileList, inputFields, internalCellProcessors, fieldLocation, response);
                }
            } else {
                response.put("data", this.importUsers(inFileList, inputFields, internalCellProcessors, fieldLocation));
            }
        }
        catch (Exception e) {
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error(err);
            response.remove("data");
            response.put("kendisError", err);
            response.put("error", true);
            this.pushResponseRepository.save((Object)new PushResponse(requestId, gson.toJson(response), Boolean.valueOf(false)));
            response.remove("error");
            response.remove("kendisError");
        }
        finally {
            response.put("done", true);
            if (Boolean.TRUE.equals(param.get("isReadOnly"))) {
                response.put("requesParam", param);
            }
            this.pushResponseRepository.save((Object)new PushResponse(requestId, gson.toJson(response), Boolean.valueOf(true)));
        }
        return response;
    }

    private void importItems(SessionBoard board, CsvListReader inFileList, ArrayList<MappedFieldVO> inputFields, Map<String, CellProcessor> internalCellProcessors, Map<String, Integer> fieldLocation, Map<String, Object> response) throws Exception {
        ArrayList<String> childrenKeys = new ArrayList<String>();
        ArrayList<SessionBoard> boards = new ArrayList<SessionBoard>();
        HashMap<String, Team> teamMap = new HashMap<String, Team>();
        HashMap<String, Item> itemsMap = new HashMap<String, Item>();
        HashMap<String, Boolean> tcUsed = new HashMap<String, Boolean>();
        HashMap<String, Status> parentStatuses = new HashMap<String, Status>();
        HashMap<String, Status> childStatuses = new HashMap<String, Status>();
        HashMap tcs = new HashMap();
        HashMap<String, Container> sprintMap = new HashMap<String, Container>();
        Status defaultParentStatus = null;
        Status defaultChildStatus = null;
        List csvRow = null;
        List teams = board.getTeams();
        List sprints = board.getContainers();
        List boardStatuses = board.getSession().getItemWorkFlow().getStatuses();
        if (!PropertyValidator.isValid((Collection)boardStatuses)) {
            boardStatuses = this.statusRepository.findByWorkFlow(board.getSession().getItemWorkFlow());
        }
        boardStatuses = KendisUtils.sortStatuses((List)boardStatuses, (String)board.getSession().getItemWorkFlow().getStatusSequence());
        for (Status status : boardStatuses) {
            parentStatuses.put(status.getTitle().toLowerCase(), status);
            if (defaultParentStatus != null || !"ToDo".equals(status.getCategory())) continue;
            defaultParentStatus = status;
        }
        boardStatuses = board.getSession().getSubItemWorkFlow().getStatuses();
        if (!PropertyValidator.isValid((Collection)boardStatuses)) {
            boardStatuses = this.statusRepository.findByWorkFlow(board.getSession().getSubItemWorkFlow());
        }
        boardStatuses = KendisUtils.sortStatuses((List)boardStatuses, (String)board.getSession().getSubItemWorkFlow().getStatusSequence());
        for (Status status : boardStatuses) {
            childStatuses.put(status.getTitle().toLowerCase(), status);
            if (defaultChildStatus != null || !"ToDo".equals(status.getCategory())) continue;
            defaultChildStatus = status;
        }
        for (Team team : teams) {
            teamMap.put(team.getTitle().toLowerCase(), team);
            if (team.getLabel() == null) continue;
            teamMap.put(team.getLabel().toLowerCase(), team);
        }
        for (Container sprint : sprints) {
            sprintMap.put(sprint.getTitle().toLowerCase(), sprint);
            if (sprint.getLabel() == null) continue;
            sprintMap.put(sprint.getLabel().toLowerCase(), sprint);
        }
        boardStatuses.clear();
        boards.add(board);
        boolean readOnly = Boolean.TRUE.equals(response.get("isReadOnly"));
        HashMap<String, String> counts = new HashMap<String, String>();
        ArrayList<Map> errors = new ArrayList<Map>();
        int i = 0;
        boolean heavy = false;
        while ((csvRow = inFileList.read()) != null) {
            String key;
            HashMap<String, Item> itemByType = new HashMap<String, Item>();
            Map rowErrors = (Map)this.setItemProperties(itemByType, teamMap, sprintMap, tcs, csvRow, inputFields, internalCellProcessors, fieldLocation);
            Item item = (Item)itemByType.get(Item.Type.Feature.name());
            if (item != null && Item.Type.UserStory.name().equals(item.getType())) {
                itemByType.put(item.getType(), item);
                itemByType.remove(Item.Type.Feature.name());
            }
            if (itemByType.containsKey(Item.Type.Feature.name()) && PropertyValidator.isValid((Object)(key = (item = (Item)itemByType.get(Item.Type.Feature.name())).importKey()))) {
                TeamContainer tc = null;
                String tid_sid = null;
                if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                    tc = (TeamContainer)item.getTeamContainers().get(0);
                    tid_sid = tc.getTeam().getId() + "_" + tc.getContainer().getId();
                }
                if (!itemsMap.containsKey(key)) {
                    String status;
                    item.setType(Item.Type.Feature.name());
                    if (item.getTitle() == null) {
                        item.setTitle("No Title Provided");
                    }
                    if ((status = (String)item.getLastUpdatedValue("status")) != null) {
                        item.setStatus((Status)parentStatuses.get(String.valueOf(status).toLowerCase()));
                        if (item.getStatus() == null) {
                            String col = (String)item.getLastUpdatedValue("status_column");
                            ArrayList<String> error = new ArrayList<String>();
                            error.add(status);
                            error.add("not matched");
                            rowErrors.put(col, error);
                        }
                    }
                    if (item.getStatus() == null || item.getStatus().getTitle() == null) {
                        item.setStatus(defaultParentStatus);
                    }
                    if (PropertyValidator.isValid((Object)tc)) {
                        tcUsed.put(key + "_" + tid_sid, true);
                    }
                    item.setSessionBoards(boards);
                    item.putLastUpdatedValue("row", (Object)(i + 1));
                    itemsMap.put(key, item);
                    KendisUtils.addChanges((boolean)readOnly, (boolean)true, (Item)item, null);
                }
                if (PropertyValidator.isValid((Object)tc)) {
                    if (((Item)itemsMap.get(key)).getTeamContainers() == null) {
                        ((Item)itemsMap.get(key)).setTeamContainers(new ArrayList());
                    }
                    if (!tcUsed.containsKey(key + "_" + tid_sid)) {
                        ((Item)itemsMap.get(key)).getTeamContainers().add(tc);
                        tcUsed.put(key + "_" + tid_sid, true);
                    }
                }
            }
            if (itemByType.containsKey(Item.Type.UserStory.name()) && PropertyValidator.isValid((Object)(key = (item = (Item)itemByType.get(Item.Type.UserStory.name())).importKey()))) {
                Item parent;
                if (!PropertyValidator.isValid((Object)item.getParentKey()) && (parent = (Item)itemByType.get(Item.Type.Feature.name())) != null && parent.importKey() != null) {
                    item.setParentKey(parent.importKey());
                    item.setParent(parent);
                }
                if (!itemsMap.containsKey(key)) {
                    String status;
                    item.setType(Item.Type.UserStory.name());
                    if (item.getTitle() == null) {
                        item.setTitle("No Title Provided");
                    }
                    if ((status = (String)item.getLastUpdatedValue("status")) != null) {
                        item.setStatus((Status)childStatuses.get(String.valueOf(status).toLowerCase()));
                        if (item.getStatus() == null) {
                            String col = (String)item.getLastUpdatedValue("status_column");
                            ArrayList error = new ArrayList();
                            error.add(status);
                            error.add("not matched");
                            rowErrors.put(col, error);
                        }
                    }
                    if (item.getStatus() == null || item.getStatus().getTitle() == null) {
                        item.setStatus(defaultChildStatus);
                    }
                    item.setSessionBoards(boards);
                    item.putLastUpdatedValue("row", (Object)(i + 1));
                    itemsMap.put(key, item);
                    childrenKeys.add(key);
                    KendisUtils.addChanges((boolean)readOnly, (boolean)true, (Item)item, null);
                }
            }
            if (readOnly && !rowErrors.isEmpty()) {
                rowErrors.put("row", String.valueOf(i + 1));
                if (!rowErrors.isEmpty()) {
                    errors.add(rowErrors);
                }
            }
            if (i++ <= 2000) continue;
            heavy = true;
            break;
        }
        Gson gson = new Gson();
        if (!itemsMap.isEmpty()) {
            HashMap<String, Boolean> tcLinked = new HashMap<String, Boolean>();
            Map oldTCs = this.updateExistingItems(board, itemsMap, tcLinked, errors);
            List children = this.updateParentItemTCs(itemsMap, childrenKeys, tcs, tcUsed);
            if (readOnly) {
                counts.put(Item.Type.Feature.name(), String.valueOf(itemsMap.values().size()));
                counts.put(Item.Type.UserStory.name(), String.valueOf(children.size()));
            } else {
                List boardTeamContainers = null;
                if (PropertyValidator.isValid((Collection)sprints)) {
                    boardTeamContainers = this.teamContainerRepository.findByContainerIn(sprints);
                    ArrayList<String> tcids = new ArrayList<String>();
                    for (Object teamContainer : boardTeamContainers) {
                        tcids.add(teamContainer.getId());
                    }
                    List itemLinks = this.itemLinkRepository.findBySourceTeamContainerIdInOrTargetTeamContainerIdIn(tcids, tcids);
                    if (PropertyValidator.isValid((Collection)itemLinks)) {
                        for (ItemLink itemLink : itemLinks) {
                            tcLinked.put(itemLink.getSourceTeamContainerId(), true);
                            tcLinked.put(itemLink.getTargetTeamContainerId(), true);
                        }
                    }
                }
                if (!tcs.isEmpty()) {
                    this.teamContainerRepository.save(tcs.values());
                }
                LinkedList parents = new LinkedList(itemsMap.values());
                response.put("listType", Item.Type.Feature.name());
                this.savePaginatedList(parents, tcLinked, tcs, oldTCs, tcUsed, response, gson);
                response.put("listType", Item.Type.UserStory.name());
                this.savePaginatedList(children, tcLinked, tcs, oldTCs, null, response, gson);
                JSONObject pushJson = new JSONObject();
                try {
                    pushJson.put("type", (Object)"Board");
                    pushJson.put("metaMap", response.get("metaMap"));
                    PushSender.sendMsg((String)pushJson.toString());
                }
                catch (JSONException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
                this.customRepositoryImpl.bulkLogs(board.getId(), parents, children, null, board.getTenant());
            }
        }
        if (readOnly) {
            response.put("counts", counts);
            response.put("errors", errors);
            if (heavy) {
                response.put("heavy", 2000);
            }
            this.pushResponseRepository.save((Object)new PushResponse((String)response.get("requestId"), gson.toJson(response), Boolean.valueOf(false)));
            response.remove("errors");
            response.remove("counts");
            response.remove("heavy");
        }
        inFileList.close();
    }

    private void importObjectives(SessionBoard board, CsvListReader inFileList, ArrayList<MappedFieldVO> inputFields, Map<String, CellProcessor> internalCellProcessors, Map<String, Integer> fieldLocation, Map<String, Object> response) throws Exception {
        ArrayList<SessionBoard> boards = new ArrayList<SessionBoard>();
        List csvRow = null;
        boards.add(board);
        ArrayList<Objective> objectivesList = new ArrayList<Objective>();
        HashMap<String, Objective> objectiveMapForPush = new HashMap<String, Objective>();
        boolean heavy = false;
        int totalObjectives = 0;
        while ((csvRow = inFileList.read()) != null) {
            if (++totalObjectives > 999) {
                heavy = true;
                break;
            }
            Objective objective = new Objective();
            objective = this.setObjectivesProperties(objective, csvRow, inputFields, internalCellProcessors, fieldLocation, board);
            objectivesList.add(objective);
        }
        if (heavy) {
            response.put("heavy", 999);
        }
        HashMap<String, ArrayList<Objective>> objectivesMap = new HashMap<String, ArrayList<Objective>>();
        ArrayList savedObjectiveIds = board.getObjectiveIds();
        if (!PropertyValidator.isValid((Collection)savedObjectiveIds)) {
            savedObjectiveIds = new ArrayList();
        }
        HashMap<String, Object> savedObjectivesMap = board.getObjectivesMap();
        HashMap savedObjectiveTeamMap = new HashMap();
        if (!PropertyValidator.isValid((Object)savedObjectivesMap)) {
            savedObjectivesMap = new HashMap<String, Object>();
        } else {
            for (Map.Entry objectiveEntry : savedObjectivesMap.entrySet()) {
                String objectiveTeamId = ((Objective)objectiveEntry.getValue()).getTeamId();
                if (!PropertyValidator.isValid((Object)objectiveTeamId) || objectiveTeamId.equals("0")) continue;
                savedObjectiveTeamMap.put(objectiveTeamId, objectiveEntry.getValue());
            }
        }
        for (Objective objective : objectivesList) {
            ArrayList<Objective> objectiveMapList = new ArrayList();
            if (PropertyValidator.isValid((Object)objective.getTitle())) {
                objectiveMapList = (List)objectivesMap.get(objective.getTitle());
            } else if (PropertyValidator.isValid((Object)objective.getTeamId())) {
                objectiveMapList = (List)objectivesMap.get(objective.getTeamId());
            }
            if (!PropertyValidator.isValid((Collection)objectiveMapList)) {
                objectiveMapList = new ArrayList<Objective>();
            }
            objectiveMapList.add(objective);
            if (PropertyValidator.isValid((Object)objective.getTitle())) {
                objectivesMap.put(objective.getTitle(), objectiveMapList);
                continue;
            }
            if (!PropertyValidator.isValid((Object)objective.getTeamId())) continue;
            objectivesMap.put(objective.getTeamId(), objectiveMapList);
        }
        ArrayList<String> objectiveIds = new ArrayList<String>();
        HashMap<String, Objective> finalObjectiveMap = new HashMap<String, Objective>();
        for (Map.Entry entry : objectivesMap.entrySet()) {
            List groupObjectives = (List)entry.getValue();
            String title = "";
            String teamId = "";
            ArrayList objectiveValues = new ArrayList();
            for (Objective objective : groupObjectives) {
                objectiveValues.addAll(objective.getValues());
                if (!PropertyValidator.isValid((Object)title)) {
                    title = objective.getTitle();
                }
                if (PropertyValidator.isValid((Object)teamId)) continue;
                teamId = objective.getTeamId();
            }
            for (ObjectiveValue objVal : objectiveValues) {
                objVal.setId(UUID.randomUUID().toString());
            }
            if (!PropertyValidator.isValid(savedObjectiveTeamMap.get(teamId))) {
                Objective finalObjective = new Objective();
                finalObjective.setId(UUID.randomUUID().toString());
                finalObjective.setTeamId(teamId);
                finalObjective.setTitle(title);
                finalObjective.setValues(objectiveValues);
                objectiveIds.add(finalObjective.getId());
                finalObjectiveMap.put(finalObjective.getId(), finalObjective);
                objectiveMapForPush.put(finalObjective.getId(), finalObjective);
                continue;
            }
            Objective savedObjectiveOfTeam = (Objective)savedObjectiveTeamMap.get(teamId);
            List savedObjectiveOfTeamValues = savedObjectiveOfTeam.getValues();
            savedObjectiveOfTeamValues.addAll(objectiveValues);
            savedObjectiveOfTeam.setValues(savedObjectiveOfTeamValues);
            objectiveMapForPush.put(savedObjectiveOfTeam.getId(), savedObjectiveOfTeam);
            savedObjectivesMap.put(savedObjectiveOfTeam.getId(), savedObjectiveOfTeam);
        }
        savedObjectiveIds.addAll(objectiveIds);
        board.setObjectiveIds(savedObjectiveIds);
        savedObjectivesMap.putAll(finalObjectiveMap);
        board.setObjectivesMap(savedObjectivesMap);
        SessionBoard updatedBoard = (SessionBoard)this.sessionBoardRepository.save((Object)board);
        response.put("sessionBoard", updatedBoard);
        response.put("isImport", true);
        HashMap<String, Cloneable> hashMap = new HashMap<String, Cloneable>();
        hashMap.put("objectiveIds", savedObjectiveIds);
        hashMap.put("objectivesMap", objectiveMapForPush);
        this.pushObjectives(hashMap, updatedBoard.getId(), "import", response);
        inFileList.close();
    }

    private void savePaginatedList(List<Item> items, Map<String, Boolean> tcLinked, Map<String, TeamContainer> tcs, Map<String, List<TeamContainer>> oldTCs, Map<String, Boolean> tcUsed, Map<String, Object> param, Gson gson) {
        int length = 100;
        List<Item> subset = new ArrayList();
        for (Item item : items) {
            String key = item.getKendisKey();
            if (!PropertyValidator.isValid((Object)key)) {
                key = item.getJiraKey();
            }
            List<TeamContainer> _old = oldTCs.get(key);
            List _new = item.getTeamContainers();
            HashMap<String, Integer> indexes = new HashMap<String, Integer>();
            if (PropertyValidator.isValid((Collection)_new)) {
                for (int i = 0; i < _new.size(); ++i) {
                    String tid_sid = ((TeamContainer)_new.get(i)).getTeam().getId() + "_" + ((TeamContainer)_new.get(i)).getContainer().getId();
                    indexes.put(tid_sid, i);
                    if (tcUsed != null || item.getParent() == null || !tcs.containsKey(item.getParent().importKey() + "_" + tid_sid)) continue;
                    ((TeamContainer)_new.get(i)).setId(tcs.get(item.getParent().importKey() + "_" + tid_sid).getId());
                }
            }
            if (PropertyValidator.isValid(_old)) {
                for (TeamContainer tc : _old) {
                    if (tcLinked == null || tc == null || !tcLinked.containsKey(tc.getId())) continue;
                    String tid_sid = tc.getTeam().getId() + "_" + tc.getContainer().getId();
                    if (tcUsed == null) {
                        if (!indexes.containsKey(tid_sid) || (Integer)indexes.get(tid_sid) <= -1) continue;
                        item.getTeamContainers().set((Integer)indexes.get(tid_sid), new TeamContainer(tc.getId()));
                        continue;
                    }
                    if (tcUsed.containsKey(key + "_" + tid_sid)) {
                        if (!indexes.containsKey(tid_sid) || (Integer)indexes.get(tid_sid) <= -1) continue;
                        item.getTeamContainers().set((Integer)indexes.get(tid_sid), new TeamContainer(tc.getId()));
                        tcs.put(item.importKey() + "_" + tid_sid, tc);
                        continue;
                    }
                    if (item.getTeamContainers() == null) {
                        item.setTeamContainers(new ArrayList());
                    }
                    item.getTeamContainers().add(new TeamContainer(tc.getId()));
                }
            }
            item.setSuspendPush(true);
            item.setSuspendActivity(true);
            item.setUpdatedOn(new Date());
            item.setUpdatedBy(UserContextUtil.getUserContext().getLoggedInUser().getUserName());
            if (subset.size() > 0 && subset.size() % length == 0) {
                subset = this.itemRepository.save(subset);
                param.put("data", true);
                this.pushResponseRepository.save((Object)new PushResponse((String)param.get("requestId"), gson.toJson(param), Boolean.valueOf(false)));
                param.remove("data");
                subset = new ArrayList();
            }
            subset.add(item);
        }
        if (subset.size() > 0) {
            subset = this.itemRepository.save(subset);
            param.put("data", true);
            this.pushResponseRepository.save((Object)new PushResponse((String)param.get("requestId"), gson.toJson(param), Boolean.valueOf(false)));
            param.remove("data");
        }
    }

    private Map<String, List<TeamContainer>> updateExistingItems(SessionBoard board, Map<String, Item> itemsMap, Map<String, Boolean> tcLinked, List<Map<String, Object>> errors) {
        Set<String> itemKeys = itemsMap.keySet();
        HashMap<String, List<TeamContainer>> oldTCs = new HashMap<String, List<TeamContainer>>();
        List items = this.itemRepository.findBySessionBoardsIdAndKendisKeyInOrSessionBoardsIdAndJiraKeyIn(board.getId(), itemKeys, board.getId(), itemKeys);
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> childIds = new ArrayList<String>();
        for (Item item : items) {
            String key = item.getKendisKey();
            if (!PropertyValidator.isValid((Object)key)) {
                key = item.getJiraKey();
            }
            if (!itemsMap.containsKey(key)) continue;
            if (item.getType().equals(itemsMap.get(key).getType())) {
                KendisUtils.addChanges((boolean)false, (boolean)true, (Item)item, (Item)item);
                item.setJiraKey(itemsMap.get(key).getJiraKey());
                item.setKendisKey(itemsMap.get(key).getKendisKey());
                item.setTitle(itemsMap.get(key).getTitle());
                item.setStatus(itemsMap.get(key).getStatus());
                if (PropertyValidator.isValid((Object)itemsMap.get(key).getParent())) {
                    item.setExternalReferenceURL(itemsMap.get(key).getExternalReferenceURL());
                }
                if (PropertyValidator.isValid((Object)itemsMap.get(key).getDueDate())) {
                    item.setDueDate(itemsMap.get(key).getDueDate());
                }
                if (PropertyValidator.isValid((Object)itemsMap.get(key).getStoryPoints())) {
                    item.setStoryPoints(itemsMap.get(key).getStoryPoints());
                }
                if (PropertyValidator.isValid((Object)itemsMap.get(key).getParentKey())) {
                    item.setParentKey(itemsMap.get(key).getParentKey());
                }
                if (PropertyValidator.isValid((Object)itemsMap.get(key).getParent())) {
                    item.setParent(itemsMap.get(key).getParent());
                }
                oldTCs.put(key, item.getTeamContainers());
                item.setTeamContainers(itemsMap.get(key).getTeamContainers());
                itemsMap.put(key, item);
                if (Item.Type.Feature.name().equals(item.getType())) {
                    ids.add(item.getId());
                    if (!PropertyValidator.isValid((Object)itemsMap.get(key).getDueDate())) continue;
                    item.setDueDate(itemsMap.get(key).getDueDate());
                    continue;
                }
                childIds.add(item.getId());
                continue;
            }
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("row", String.valueOf(itemsMap.remove(key).getLastUpdatedValue("row")));
            error.put("", key + " already exists as " + (Item.Type.UserStory.name().equals(item.getType()) ? "child item" : "parent item"));
            errors.add(error);
        }
        if (PropertyValidator.isValid(ids)) {
            items = this.itemRepository.findByParentIdInAndIdNotIn(ids, childIds);
            for (Item item : items) {
                if (!PropertyValidator.isValid((Collection)item.getTeamContainers()) || item.getTeamContainers().size() <= 0 || !PropertyValidator.isValid(item.getTeamContainers().get(0)) || ((TeamContainer)item.getTeamContainers().get(0)).getId() == null) continue;
                tcLinked.put(((TeamContainer)item.getTeamContainers().get(0)).getId(), true);
            }
        }
        return oldTCs;
    }

    private List<Item> updateParentItemTCs(Map<String, Item> itemsMap, List<String> childrenKeys, Map<String, TeamContainer> tcs, Map<String, Boolean> tcUsed) {
        ArrayList<Item> children = new ArrayList<Item>();
        for (String childKey : childrenKeys) {
            Item parent;
            Item item = itemsMap.get(childKey);
            if (item == null) continue;
            if (itemsMap.containsKey(item.getParentKey()) && (parent = itemsMap.get(item.getParentKey())) != null && parent.getKendisKey() != null) {
                item.setParentKey(parent.getKendisKey());
                item.setParent(parent);
                if (item.getTeamContainers() != null && item.getTeamContainers().get(0) != null) {
                    TeamContainer tc = (TeamContainer)item.getTeamContainers().get(0);
                    String tid_sid = parent.importKey() + "_" + tc.getTeam().getId() + "_" + tc.getContainer().getId();
                    int exists = 0;
                    if (tcUsed.containsKey(tid_sid)) {
                        ++exists;
                    } else {
                        if (parent.getTeamContainers() == null) {
                            parent.setTeamContainers(new ArrayList());
                        }
                        tcUsed.put(tid_sid, true);
                        parent.getTeamContainers().add(tc);
                    }
                    if (tcs.containsKey(tid_sid)) {
                        ++exists;
                    } else {
                        tcs.put(tid_sid, tc);
                    }
                    if (exists == 2) {
                        item.getTeamContainers().set(0, tcs.get(tid_sid));
                    }
                }
            }
            children.add(item);
            itemsMap.remove(item.importKey());
        }
        return children;
    }

    private HashMap<String, Object> importUsers(CsvListReader inFileList, ArrayList<MappedFieldVO> inputFields, Map<String, CellProcessor> internalCellProcessors, Map<String, Integer> fieldLocation) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        List<User> users = new ArrayList();
        ArrayList<User> wrongUsers = new ArrayList<User>();
        ArrayList<User> existingUsers = new ArrayList<User>();
        ArrayList<User> multiCompanyUsers = new ArrayList<User>();
        ArrayList<User> fileDupUsers = new ArrayList<User>();
        List csvRow = null;
        int i = 0;
        ArrayList<String> mapEmails = new ArrayList<String>();
        ArrayList<String> mapUsernames = new ArrayList<String>();
        HashMap<String, Integer> emailDuplicateInFiles = new HashMap<String, Integer>();
        HashMap<String, Integer> unameDuplicateInFiles = new HashMap<String, Integer>();
        ArrayList<UserCompany> ucompanies = new ArrayList<UserCompany>();
        ucompanies.add(new UserCompany(UserContextUtil.getUserContext().getCurrentCompany()));
        List list = this.blackListUserDomainRepository.findAll();
        HashMap<String, Boolean> backListMap = new HashMap<String, Boolean>();
        for (BlackListUserDomain blackListUserDomain : list) {
            backListMap.put(blackListUserDomain.getDomain(), true);
        }
        while ((csvRow = inFileList.read()) != null) {
            User user = new User();
            user = this.setUserProperties(user, csvRow, inputFields, internalCellProcessors, fieldLocation);
            user.setUserCompanies(ucompanies);
            if (user.hasValidEmail().booleanValue() && user.hasValidUserName().booleanValue()) {
                if (emailDuplicateInFiles.get(user.getEmail()) == null && unameDuplicateInFiles.get(user.getUserName()) == null) {
                    String domain = user.getUserName().substring(user.getUserName().indexOf("@") + 1);
                    if (backListMap.get(domain) == null) {
                        users.add(user);
                        mapEmails.add(user.getEmail());
                        mapUsernames.add(user.getUserName());
                        if (emailDuplicateInFiles.get(user.getEmail()) == null) {
                            emailDuplicateInFiles.put(user.getEmail(), i);
                        }
                        if (unameDuplicateInFiles.get(user.getUserName()) == null) {
                            unameDuplicateInFiles.put(user.getUserName(), i);
                        }
                    }
                } else if (emailDuplicateInFiles.get(user.getEmail()) != null) {
                    fileDupUsers.add(user);
                } else if (unameDuplicateInFiles.get(user.getUserName()) != null) {
                    fileDupUsers.add(user);
                }
            } else {
                wrongUsers.add(user);
            }
            if (i++ <= 2000) continue;
            break;
        }
        if (PropertyValidator.isValid(users)) {
            long planUserCount;
            String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
            List duplicates = this.userRepository.findByEmailInOrUserNameIn(mapEmails, mapUsernames);
            if (PropertyValidator.isValid((Collection)duplicates)) {
                for (int j = 0; j < duplicates.size(); ++j) {
                    int index = -1;
                    for (int k = 0; k < users.size(); ++k) {
                        if (((User)duplicates.get(j)).compareTo((User)users.get(k)) <= -1 || (index = k--) <= -1) continue;
                        User u = (User)users.remove(index);
                        if (u.isUserInCompany(cid)) {
                            existingUsers.add(u);
                            continue;
                        }
                        u.getUserCompanies().add(new UserCompany(new Company(cid)));
                        multiCompanyUsers.add(u);
                    }
                }
            }
            if ((planUserCount = this.companyRepository.findById(cid).getUserCount()) > 0L) {
                long invitaionCount;
                List existing = this.userRepository.findByUserCompanies_Company_IdAndUserCompanies_isArchiveAndUserCompanies_isGuestAndUserCompanies_isActive(cid, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true));
                long existingUserCount = existing.size();
                if (planUserCount - (existingUserCount + (invitaionCount = (long)this.invitationRepository.findAll().size()) + (long)(users.size() + multiCompanyUsers.size())) >= 0L) {
                    users = this.userRepository.save(users);
                    if (multiCompanyUsers.size() > 0) {
                        users.addAll(this.userRepository.save(multiCompanyUsers));
                    }
                } else {
                    users.clear();
                    data.put("packageCount", planUserCount - (existingUserCount + invitaionCount));
                }
            } else {
                users = this.userRepository.save(users);
                if (multiCompanyUsers.size() > 0) {
                    users.addAll(this.userRepository.save(multiCompanyUsers));
                }
            }
        }
        if (users.size() > 0) {
            data.put("savedUsers", users);
            this.importedUsers = users;
            this.sendEmailAfterImprtUsers();
        }
        if (wrongUsers.size() > 0) {
            data.put("wrongUsers", wrongUsers);
        }
        if (existingUsers.size() > 0) {
            data.put("existingUsers", existingUsers);
        }
        if (fileDupUsers.size() > 0) {
            data.put("duplicateUsers", fileDupUsers);
        }
        inFileList.close();
        return data;
    }

    private void sendEmailAfterImprtUsers() {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    private Object setItemProperties(HashMap<String, Item> itemByType, Map<String, Team> teamMap, Map<String, Container> sprintMap, Map<String, TeamContainer> tcsMap, List csvRow, ArrayList<MappedFieldVO> inputFields, Map<String, CellProcessor> internalCellProcessors, Map<String, Integer> fieldLocation) {
        String key;
        HashMap erros = new HashMap();
        Team team = null;
        Container container = null;
        Item item = null;
        int totalColums = 0;
        int emptyColums = 0;
        for (MappedFieldVO field : inputFields) {
            key = field.getMappedField();
            Integer index = fieldLocation.get(key);
            if (index == null || !PropertyValidator.isValid((Object)field.getKey())) continue;
            Object value = null;
            if (internalCellProcessors.get(key) != null) {
                value = internalCellProcessors.get(key).execute(csvRow.get(index), null);
            }
            String typeKey = Item.Type.Feature.name();
            String[] str = field.getKey().split("_");
            String property = "";
            ++totalColums;
            if (str.length > 1) {
                typeKey = str[0];
                property = str[1];
            } else {
                property = str[0];
            }
            if (value == null) {
                if ("kendisKey".equals(property)) {
                    erros.put(field.getInputField(), new ArrayList());
                }
                if ("title".equals(property)) {
                    erros.put(field.getInputField(), new ArrayList());
                }
                if ("status".equals(property)) {
                    erros.put(field.getInputField(), new ArrayList());
                }
                ++emptyColums;
                continue;
            }
            if (itemByType.containsKey(typeKey)) {
                item = itemByType.get(typeKey);
            } else {
                Item newItem = new Item();
                newItem.setId(ObjectId.get().toString());
                newItem.setCreatedOn(new Date());
                newItem.setCreatedBy(UserContextUtil.getUserContext().getLoggedInUser().getUserName());
                newItem.setUpdatedOn(newItem.getCreatedOn());
                newItem.setUpdatedBy(newItem.getCreatedBy());
                itemByType.put(typeKey, newItem);
                item = itemByType.get(typeKey);
            }
            if ("kendisKey".equals(property)) {
                item.setJiraKey(value.toString());
                if (item.getJiraKey().length() > 30) {
                    item.setJiraKey(item.getJiraKey().substring(0, 30));
                    erros.put(field.getInputField(), new ArrayList());
                    ((ArrayList)erros.get(field.getInputField())).add(String.valueOf(value));
                    ((ArrayList)erros.get(field.getInputField())).add("length more than 30");
                }
                item.setKendisKey(item.getJiraKey());
            }
            if ("parentKey".equals(property)) {
                item.setParentKey(value.toString());
                if (item.getParentKey().length() > 30) {
                    item.setParentKey(item.getParentKey().substring(0, 30));
                    erros.put(field.getInputField(), new ArrayList());
                    ((ArrayList)erros.get(field.getInputField())).add(String.valueOf(value));
                    ((ArrayList)erros.get(field.getInputField())).add("length more than 30");
                }
                item.setType(Item.Type.UserStory.name());
            }
            if ("title".equals(property)) {
                item.setTitle(value.toString());
                if (item.getTitle().length() > 255) {
                    item.setTitle(item.getTitle().substring(0, 255));
                    erros.put(field.getInputField(), new ArrayList());
                    ((ArrayList)erros.get(field.getInputField())).add(String.valueOf(value));
                    ((ArrayList)erros.get(field.getInputField())).add("length more than 255");
                }
            }
            if ("status".equals(property)) {
                item.putLastUpdatedValue("status", (Object)String.valueOf(value));
                item.putLastUpdatedValue("status_column", (Object)field.getInputField());
            }
            if ("dueDate".equals(property) && PropertyValidator.isValid((Object)value)) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(field.getDateFormate());
                    Date date = sdf.parse(value.toString());
                    item.setDueDate(date);
                }
                catch (Exception e) {
                    erros.put(field.getInputField(), new ArrayList());
                    ((ArrayList)erros.get(field.getInputField())).add(String.valueOf(value));
                    ((ArrayList)erros.get(field.getInputField())).add("formate not matched");
                }
            }
            if ("externalReferenceURL".equals(property)) {
                item.setExternalReferenceURL(value.toString());
                Pattern p = Pattern.compile("\\b(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]");
                Matcher m = p.matcher(item.getExternalReferenceURL());
                if (!m.matches()) {
                    erros.put(field.getInputField(), new ArrayList());
                    ((ArrayList)erros.get(field.getInputField())).add(String.valueOf(value));
                    ((ArrayList)erros.get(field.getInputField())).add("invalid url");
                }
            }
            if ((Item.Type.UserStory.name().equals(typeKey) || Item.Type.UserStory.name().equals(item.getType())) && "storyPoints".equals(property)) {
                try {
                    item.setStoryPoints(Double.valueOf(Double.parseDouble(String.valueOf(value))));
                    item.setStoryPoints(Double.valueOf(StringUtils.round((double)item.getStoryPoints(), (int)2)));
                }
                catch (Exception e) {
                    erros.put(field.getInputField(), new ArrayList());
                    ((ArrayList)erros.get(field.getInputField())).add(String.valueOf(value));
                    ((ArrayList)erros.get(field.getInputField())).add("invalid estimates");
                }
            }
            if ("team".equals(property) && (team = teamMap.get(String.valueOf(value).toLowerCase())) == null) {
                erros.put(field.getInputField(), new ArrayList());
                ((ArrayList)erros.get(field.getInputField())).add(String.valueOf(value));
                ((ArrayList)erros.get(field.getInputField())).add("not matched");
            }
            if (!"continer".equals(property) || (container = sprintMap.get(String.valueOf(value).toLowerCase())) != null) continue;
            erros.put(field.getInputField(), new ArrayList());
            ((ArrayList)erros.get(field.getInputField())).add(String.valueOf(value));
            ((ArrayList)erros.get(field.getInputField())).add("not matched");
        }
        if (team != null && container != null) {
            String tid_sid;
            ArrayList<TeamContainer> tcs = new ArrayList<TeamContainer>();
            TeamContainer tc = new TeamContainer(team, container);
            tc.setId(ObjectId.get().toString());
            key = null;
            if (itemByType.containsKey(Item.Type.Feature.name())) {
                key = itemByType.get(Item.Type.Feature.name()).importKey();
            }
            if (itemByType.containsKey(Item.Type.UserStory.name()) && key == null) {
                key = itemByType.get(Item.Type.UserStory.name()).importKey();
            }
            if (tcsMap.containsKey(tid_sid = key + "_" + team.getId() + "_" + container.getId())) {
                tc = tcsMap.get(tid_sid);
            } else {
                tcsMap.put(tid_sid, tc);
            }
            tcs.add(tcsMap.get(tid_sid));
            if (itemByType.containsKey(Item.Type.Feature.name())) {
                itemByType.get(Item.Type.Feature.name()).setTeamContainers(tcs);
            }
            if (itemByType.containsKey(Item.Type.UserStory.name())) {
                itemByType.get(Item.Type.UserStory.name()).setTeamContainers(new ArrayList());
                itemByType.get(Item.Type.UserStory.name()).getTeamContainers().add(tc);
            }
        }
        if (emptyColums == totalColums) {
            erros.clear();
            itemByType.clear();
        }
        return erros;
    }

    private User setUserProperties(User user, List csvRow, ArrayList<MappedFieldVO> inputFields, Map<String, CellProcessor> internalCellProcessors, Map<String, Integer> fieldLocation) {
        user.setFullName("");
        user.setFirstName("");
        user.setLastName("");
        for (MappedFieldVO field : inputFields) {
            String key = field.getMappedField();
            Integer index = fieldLocation.get(key);
            if (index == null) continue;
            Object value = null;
            if (internalCellProcessors.get(key) != null) {
                value = internalCellProcessors.get(key).execute(csvRow.get(index), null);
            }
            if (value == null) continue;
            if (field.getMappedField().equalsIgnoreCase(Constants.importUserFields[2])) {
                user.setEmail(value.toString());
                user.setUserName(user.getEmail());
            }
            if (field.getMappedField().equalsIgnoreCase(Constants.importUserFields[3])) {
                if (PropertyValidator.isValid((Object)value.toString())) {
                    user.setPassword(EncDecUtility.bCryptPasswordEncoder((String)value.toString()));
                } else {
                    user.setPassword(EncDecUtility.bCryptPasswordEncoder((String)EncDecUtility.getRandomPassword((int)8)));
                }
            }
            if (field.getMappedField().equalsIgnoreCase(Constants.importUserFields[4])) {
                user.setFirstName(value.toString());
            }
            if (!field.getMappedField().equalsIgnoreCase(Constants.importUserFields[5])) continue;
            user.setLastName(value.toString());
        }
        if (PropertyValidator.isValid((Object)user.getFirstName())) {
            user.setFullName(user.getFirstName());
        }
        if (PropertyValidator.isValid((Object)user.getLastName())) {
            user.setFullName((user.getFullName() != null && user.getFullName().length() > 0 ? user.getFullName() + " " : "") + user.getLastName());
        }
        return user;
    }

    private Objective setObjectivesProperties(Objective objective, List csvRow, ArrayList<MappedFieldVO> inputFields, Map<String, CellProcessor> internalCellProcessors, Map<String, Integer> fieldLocation, SessionBoard board) {
        objective.setTitle("");
        objective.setTeamId("");
        ArrayList<ObjectiveValue> values = new ArrayList<ObjectiveValue>();
        ObjectiveValue objectiveValue = new ObjectiveValue();
        for (MappedFieldVO field : inputFields) {
            Integer actualValue;
            Integer planValue;
            String key = field.getMappedField();
            Integer index = fieldLocation.get(key);
            if (index == null) continue;
            Object value = null;
            if (internalCellProcessors.get(key) != null) {
                value = internalCellProcessors.get(key).execute(csvRow.get(index), null);
            }
            if (value == null) continue;
            String mappedField = field.getMappedField();
            if (mappedField.equalsIgnoreCase(Constants.importObjectiveFields[0])) {
                String teamId = "";
                String groupName = value.toString();
                if (groupName.length() > 255) {
                    groupName = groupName.substring(0, 255);
                }
                List teams = board.getTeams();
                for (Team team : teams) {
                    if (!team.getTitle().equals(groupName)) continue;
                    teamId = team.getId();
                    break;
                }
                if (PropertyValidator.isValid((Object)teamId)) {
                    objective.setTeamId(teamId);
                    objective.setTitle("");
                } else {
                    if (PropertyValidator.isValid((Collection)board.getSession().getAlmConfigurations())) {
                        objective.setTeamId("0");
                    }
                    objective.setTitle(groupName);
                }
            }
            if (mappedField.equalsIgnoreCase(Constants.importObjectiveFields[1])) {
                String valueTitle = value.toString();
                if (valueTitle.length() > 255) {
                    valueTitle = valueTitle.substring(0, 255);
                }
                objectiveValue.setTitle(valueTitle);
            }
            if (mappedField.equalsIgnoreCase(Constants.importObjectiveFields[2]) && PropertyValidator.isValid((Object)(planValue = new Integer(value.toString())))) {
                objectiveValue.setPlanValue(planValue);
            }
            if (mappedField.equalsIgnoreCase(Constants.importObjectiveFields[3]) && PropertyValidator.isValid((Object)(actualValue = new Integer(value.toString())))) {
                objectiveValue.setActualValue(actualValue);
            }
            if (mappedField.equalsIgnoreCase(Constants.importObjectiveFields[4])) {
                String objectiveType = value.toString();
                if (objectiveType.equalsIgnoreCase("Normal")) {
                    objectiveValue.setType("normal");
                } else if (objectiveType.equalsIgnoreCase("Uncommitted")) {
                    objectiveValue.setType("stretch");
                }
            }
            if (!mappedField.equalsIgnoreCase(Constants.importObjectiveFields[5])) continue;
            String linkedItemsString = value.toString();
            List<String> linkedItemsList = Arrays.asList(linkedItemsString.split(",|\\ "));
            List itemsList = this.itemRepository.findBySessionBoardsIdAndJiraKeyIn(board.getId(), linkedItemsList);
            ArrayList<String> itemIds = new ArrayList<String>();
            HashMap<String, String> externalItemIds = new HashMap<String, String>();
            for (Item item : itemsList) {
                itemIds.add(item.getId());
                externalItemIds.put(item.getId(), item.getJiraKey());
            }
            objectiveValue.setItemIds(itemIds);
            objectiveValue.setExternalItemIds(externalItemIds);
        }
        values.add(objectiveValue);
        objective.setValues(values);
        return objective;
    }

    private void pushObjectives(Object data, String boardId, String action, Map<String, Object> json) {
        try {
            if (PropertyValidator.isValid((Object)json.get("syncId"))) {
                Gson gson = new Gson();
                String cid = UserContextUtil.getUserContext().getCurrentCompany().getId();
                HashMap<String, Object> pushJson = new HashMap<String, Object>();
                HashMap<String, Object> meta = new HashMap<String, Object>();
                meta.put("event", "Objectives");
                meta.put("boardId", boardId);
                meta.put("syncId", json.get("syncId"));
                meta.put("isImport", json.get("isImport"));
                pushJson.put("type", "Objectives");
                pushJson.put("push", "Self");
                pushJson.put("metaMap", gson.toJson(meta));
                pushJson.put("ObjectiveData", data);
                PushSender.sendMsg((String)gson.toJson(pushJson));
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    static /* synthetic */ List access$000(ImportServiceImpl x0) {
        return x0.importedUsers;
    }

    static /* synthetic */ LocalMailSender access$100(ImportServiceImpl x0) {
        return x0.mailSender;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }

    static /* synthetic */ List access$002(ImportServiceImpl x0, List x1) {
        x0.importedUsers = x1;
        return x0.importedUsers;
    }
}

