/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.persistence.entity.CanvasBoard;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.repository.CanvasBoardRepository;
import com.viztrend.safe.service.GraphAuditLogService;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class GraphAuditLogServiceImpl
implements GraphAuditLogService {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private CanvasBoardRepository canvasBoardRepository;

    public HashMap<String, Object> saveAuditLog(HashMap<String, Object> params, GraphAuditLogService.LogActionType actionType) {
        Boolean ignoreLog;
        ArrayList items = new ArrayList();
        if (params.containsKey("ignoreLog") && (ignoreLog = (Boolean)params.get("ignoreLog")).booleanValue()) {
            return null;
        }
        String boardId = (String)params.get("boardId");
        List itemList = (List)params.get("items");
        String externalUserName = (String)params.get("externalUserName");
        itemList.forEach(item -> {
            HashMap entry = new HashMap();
            items.add(entry);
            if (actionType == GraphAuditLogService.LogActionType.Created) {
                entry.put("key", item.get("key"));
                entry.put("_id", item.get("_id"));
                entry.put("category", item.get("category"));
                entry.put("text", item.get("text"));
                if (item.containsKey("figure")) {
                    entry.put("figure", item.get("figure"));
                }
                if (item.containsKey("from")) {
                    entry.put("from", item.get("from"));
                }
                if (item.containsKey("to")) {
                    entry.put("to", item.get("to"));
                }
            } else {
                for (Object _key : item.keySet()) {
                    String key = (String)_key;
                    entry.put(key, item.get(key));
                }
            }
        });
        HashMap<String, Object> auditLog = new HashMap<String, Object>();
        Date createdOn = new Date();
        String id = UUID.randomUUID().toString();
        auditLog.put("_id", id);
        auditLog.put("event", actionType.toString());
        auditLog.put("items", items);
        auditLog.put("createdOn", createdOn.getTime());
        auditLog.put("boardId", boardId);
        if (externalUserName == null) {
            User user = UserContextUtil.getUserContext().getLoggedInUser();
            auditLog.put("tenant", UserContextUtil.getUserContext().getCurrentCompany().getTenant());
            auditLog.put("createdBy", user.getId());
            auditLog.put("createdByExternalUser", false);
        } else {
            CanvasBoard board = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)boardId));
            auditLog.put("tenant", board.getTenant());
            auditLog.put("createdBy", externalUserName);
            auditLog.put("createdByExternalUser", true);
        }
        this.mongoTemplate.insert(auditLog, "canvasAuditLog");
        return auditLog;
    }

    public List<Map> getAuditLog(HashMap<String, Object> params) {
        String boardId = (String)params.get("boardId");
        Number offset = (Number)params.get("offset");
        Number limit = (Number)params.get("limit");
        Query query = new Query();
        query.with((Pageable)new PageRequest(offset.intValue(), limit.intValue(), new Sort(Sort.Direction.DESC, new String[]{"createdOn"})));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"boardId").is((Object)boardId));
        List auditLogs = this.mongoTemplate.find(query, Map.class, "canvasAuditLog");
        return auditLogs;
    }

    public Map removeItemFromAuditLog(HashMap<String, String> params) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)params.get("logId")));
        List auditLogs = this.mongoTemplate.find(query, Map.class, "canvasAuditLog");
        if (PropertyValidator.isValid((Collection)auditLogs)) {
            Map log = (Map)auditLogs.get(0);
            ArrayList items = (ArrayList)log.get("items");
            int index = -1;
            for (int i = 0; i < items.size(); ++i) {
                Map item = (Map)items.get(i);
                if (!item.get("_id").equals(params.get("itemId"))) continue;
                index = i;
                break;
            }
            if (index > -1) {
                items.remove(index);
                if (items.size() > 0) {
                    log.put("items", items);
                    this.mongoTemplate.save((Object)log, "canvasAuditLog");
                } else {
                    query = new Query();
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(new Object[]{params.get("logId")}));
                    this.mongoTemplate.remove(query, "canvasAuditLog");
                }
            }
        }
        return null;
    }
}

