/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.google.gson.Gson;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.safe.alm.jira.bo.JiraField;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.Answer;
import com.viztrend.safe.persistence.entity.AuditLog;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Fields;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemJiraFieldMap;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.ItemLog;
import com.viztrend.safe.persistence.entity.ModuleConfiguration;
import com.viztrend.safe.persistence.entity.Objective;
import com.viztrend.safe.persistence.entity.ObjectiveValue;
import com.viztrend.safe.persistence.entity.PiAgendaDay;
import com.viztrend.safe.persistence.entity.PiContainerCapacity;
import com.viztrend.safe.persistence.entity.PiJourneyEvent;
import com.viztrend.safe.persistence.entity.PiJourneyRoomLink;
import com.viztrend.safe.persistence.entity.PiProgramRole;
import com.viztrend.safe.persistence.entity.PiSite;
import com.viztrend.safe.persistence.entity.PiTeamBreakoutTeam;
import com.viztrend.safe.persistence.entity.PiTeamCapacity;
import com.viztrend.safe.persistence.entity.PiUserCapacity;
import com.viztrend.safe.persistence.entity.Question;
import com.viztrend.safe.persistence.entity.Report;
import com.viztrend.safe.persistence.entity.ScoreCard;
import com.viztrend.safe.persistence.entity.ScoreParam;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.State;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.IssueTypeRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.JiraFieldRepository;
import com.viztrend.safe.persistence.repository.ModuleConfigurationRepository;
import com.viztrend.safe.persistence.repository.ScoreCardRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.TeamContainerRepository;
import com.viztrend.safe.persistence.repository.TeamRepository;
import com.viztrend.safe.service.CustomFieldService;
import com.viztrend.safe.service.ExportService;
import com.viztrend.safe.service.ExportServiceImpl;
import com.viztrend.safe.utils.AlmUtils;
import com.viztrend.safe.utils.Constants;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.Attachment;
import com.viztrend.safe.vos.ItemLinkVO;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.bson.types.ObjectId;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.supercsv.io.CsvMapWriter;
import org.supercsv.io.ICsvMapWriter;
import org.supercsv.prefs.CsvPreference;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="ExportService")
@Transactional
public class ExportServiceImpl
implements ExportService {
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private IssueTypeRepository issueTypeRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private Environment env;
    @Autowired
    private TeamContainerRepository teamContainerRepository;
    @Autowired
    private JiraFieldRepository jiraFieldRepository;
    @Autowired
    private ScoreCardRepository scoreCardRepository;
    @Autowired
    private TeamRepository teamRepository;
    @Autowired
    private ModuleConfigurationRepository objectiveMenuPermissionsRepository;
    @Autowired
    private CustomFieldService customFieldService;
    static final String CSV_DEPS_HEADER = "#,Id,From,To,From Item,Link Type,To Item,Status,Description,Raised On,Target Resolution Date,Reporter,Responsible,description";
    static final String CSV_DEPS_HEADER_TFS = "#,Id,From,To,From Item,Link Type,To Item,Status,Summary,Raised On,Target Resolution Date,Reporter,Responsible,description";
    static final String CSV_JIRA_DEPS_HEADER = "#,Id,From Item,From Item Status,Link Type,To Item,To Item Status,Raised On,Target Resolution Date,Reporter,Responsible,description";
    private SimpleDateFormat dateExportFormate = new SimpleDateFormat("dd MMM yyyy hh:mm aa");
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportServiceImpl.class);
    private static final DecimalFormat decfor = new DecimalFormat("0.00");

    public List<Item> prepareDataForExport(String boardId, SessionBoard board) {
        ArrayList<SessionBoard> boardsList = new ArrayList<SessionBoard>();
        if (board == null) {
            board = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)boardId));
        }
        boardsList.add(board);
        Date startTime = new Date();
        LOGGER.debug("======================FETCHING ITEMS FOR DOWNLOAD =================================================");
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is((Object)new ObjectId(boardId)));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query.getQueryObject());
        dbCursorPrefix.sort((DBObject)new BasicDBObject("sequence", (Object)1));
        List allItems = dbCursorPrefix.toArray();
        HashMap teamMapById = new HashMap();
        HashMap containerMapById = new HashMap();
        List containers = board.getContainers();
        List teams = board.getTeams();
        containers.forEach(container -> containerMapById.put(container.getId(), container));
        teams.forEach(team -> teamMapById.put(team.getId(), team));
        ArrayList allStatuses = new ArrayList();
        HashMap statusMapById = new HashMap();
        List issueTypes = this.issueTypeRepository.findAll();
        HashMap issueTypeMapById = new HashMap();
        issueTypes.forEach(issueType -> issueTypeMapById.put(issueType.getId(), issueType));
        ArrayList itemLinks = new ArrayList();
        HashMap itemLinkMapById = new HashMap();
        ArrayList jiraLinks = new ArrayList();
        HashMap jiraLinkMapById = new HashMap();
        ArrayList<Item> boardItems = new ArrayList<Item>();
        Date endTime = new Date();
        Long millies = endTime.getTime() - startTime.getTime();
        LOGGER.debug("Time Taken :: " + millies);
        LOGGER.debug("=======================================================================");
        ArrayList<Item> featureList = new ArrayList<Item>();
        HashMap<String, Integer> featureMap = new HashMap<String, Integer>();
        HashMap featureUserstoriesMap = new HashMap();
        int featureCount = 0;
        HashMap<String, String> featureByTCs = new HashMap<String, String>();
        for (DBObject vo : allItems) {
            try {
                Item item = this.createItemForReport(vo, statusMapById, allStatuses, itemLinkMapById, itemLinks, jiraLinkMapById, jiraLinks, teamMapById, containerMapById, issueTypeMapById);
                if (PropertyValidator.isValid((Object)item.getType()) && "Feature".equals(item.getType())) {
                    item.setStoryPoints(Double.valueOf(0.0));
                    featureList.add(item);
                    featureMap.put(item.getId(), featureCount);
                    ++featureCount;
                    if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                        for (TeamContainer tc : item.getTeamContainers()) {
                            featureByTCs.put(tc.getId(), item.getId());
                        }
                    }
                    item.setItemLinksVO(new ArrayList());
                    item.putLastUpdatedValue("nochild", (Object)true);
                } else if (PropertyValidator.isValid((Object)item.getParent()) && PropertyValidator.isValid((Object)item.getParent().getId())) {
                    String parentId = item.getParent().getId();
                    if (!featureUserstoriesMap.containsKey(parentId)) {
                        featureUserstoriesMap.put(parentId, new ArrayList());
                    }
                    ((List)featureUserstoriesMap.get(parentId)).add(item);
                }
                Map jiraFieldByKey = (Map)vo.get("jiraFieldByKey");
                List configFields = null;
                if (Item.Type.Feature.name().equals(item.getType())) {
                    configFields = board.getSession().getAdditionalFieldsValuesFeature();
                }
                if (Item.Type.UserStory.name().equals(item.getType())) {
                    configFields = board.getSession().getAdditionalFieldsValuesUserStory();
                }
                if (!PropertyValidator.isValid((Collection)configFields)) continue;
                if (board.getSession().getAdditionalFieldsJiraTimeZone() != null) {
                    for (ItemJiraFieldMap field : configFields) {
                        field.setClientTimeZone(board.getSession().getAdditionalFieldsJiraTimeZone());
                    }
                }
                item.putCustomeValuesAsText(jiraFieldByKey, (Collection)configFields, null);
            }
            catch (Exception exx) {
                LOGGER.error(StringUtils.getTraceString((Throwable)exx));
            }
        }
        for (Item item : featureList) {
            Integer featureIndex;
            if (PropertyValidator.isValid((Collection)item.getItemLinks())) {
                for (ItemLink it : item.getItemLinks()) {
                    Item linkedFeature;
                    String linkedFeatureId;
                    if (!featureByTCs.containsKey(it.getTargetTeamContainerId()) || !featureMap.containsKey(linkedFeatureId = (String)featureByTCs.get(it.getTargetTeamContainerId())) || !PropertyValidator.isValid((Object)(linkedFeature = (Item)featureList.get(featureIndex = (Integer)featureMap.get(linkedFeatureId))))) continue;
                    ItemLinkVO linkVo = new ItemLinkVO(it.getId());
                    linkVo.setType(it.getType());
                    if (item.getItemLinksVO().contains(linkVo)) continue;
                    linkVo.setTitle(linkedFeature.getTitle());
                    item.getItemLinksVO().add(linkVo);
                }
            }
            boardItems.add(item);
            if (!featureUserstoriesMap.containsKey(item.getId())) continue;
            List usList = (List)featureUserstoriesMap.get(item.getId());
            for (Item us : usList) {
                if (!featureMap.containsKey(us.getParent().getId())) continue;
                featureIndex = (Integer)featureMap.get(us.getParent().getId());
                us.setParent((Item)featureList.get(featureIndex));
                us.getParent().putLastUpdatedValue("nochild", (Object)false);
                boardItems.add(us);
                if (!PropertyValidator.isValid((Object)us.getStoryPoints())) continue;
                item.setStoryPoints(Double.valueOf(us.getStoryPoints() + item.getStoryPoints()));
            }
        }
        return boardItems;
    }

    private Item createItemForReport(DBObject vo, HashMap<String, Status> statusMapById, ArrayList<String> allStatuses, HashMap<String, String> itemLinkMapById, ArrayList<String> itemLinks, HashMap<String, String> jiraLinkMapById, ArrayList<String> jiraLinks, HashMap<String, Team> teamMapById, HashMap<String, Container> containerMapById, HashMap<String, IssueType> issueTypeMapById) {
        Item parent = null;
        DBRef parentRef = (DBRef)vo.get("parent");
        if (PropertyValidator.isValid((Object)parentRef)) {
            parent = new Item(String.valueOf(parentRef.getId()));
        }
        DBRef statusRef = (DBRef)vo.get("status");
        Status itemStatus = new Status();
        if (PropertyValidator.isValid((Object)statusRef)) {
            String statusId = String.valueOf(statusRef.getId());
            itemStatus.setId(statusId);
            if (statusMapById.get(statusId) == null) {
                Query statusQuery = new Query();
                statusQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(statusRef.getId()));
                DBCursor dbCursorDomain = this.customRepositoryImpl.getMongoTemplate().getCollection("status").find(statusQuery.getQueryObject());
                if (dbCursorDomain.hasNext()) {
                    DBObject statusObject = dbCursorDomain.next();
                    itemStatus.setTitle((String)statusObject.get("title"));
                    itemStatus.setColor((String)statusObject.get("color"));
                    itemStatus.setCategory((String)statusObject.get("category"));
                }
                statusMapById.put(statusId, itemStatus);
                allStatuses.add(statusId);
            } else {
                itemStatus = statusMapById.get(statusId);
            }
        } else {
            LOGGER.debug("Status ref is null for Item :: " + String.valueOf(vo.get("_id")));
        }
        IssueType issueType = null;
        DBRef issueTypeRef = (DBRef)vo.get("issueType");
        if (PropertyValidator.isValid((Object)issueTypeRef)) {
            String issueTypeId = String.valueOf(issueTypeRef.getId());
            issueType = issueTypeMapById.get(issueTypeId);
        }
        ArrayList<ItemLink> _itemLinks = new ArrayList<ItemLink>();
        List itemLinksRef = (List)vo.get("itemLinks");
        if (PropertyValidator.isValid((Collection)itemLinksRef)) {
            for (DBRef linkRef2 : itemLinksRef) {
                Query query1 = new Query();
                String linkId = String.valueOf(linkRef2.getId());
                ItemLink link = new ItemLink();
                link.setId(linkId);
                query1.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(linkRef2.getId()));
                DBCursor dbCursorDomain = this.customRepositoryImpl.getMongoTemplate().getCollection("itemLink").find(query1.getQueryObject());
                if (dbCursorDomain.hasNext()) {
                    DBObject itemLinkObject = dbCursorDomain.next();
                    link.setStatus((String)itemLinkObject.get("status"));
                    link.setDescription((String)itemLinkObject.get("description"));
                    link.setSourceTeamContainerId((String)itemLinkObject.get("sourceTeamContainerId"));
                    link.setTargetTeamContainerId((String)itemLinkObject.get("targetTeamContainerId"));
                    link.setSourceUserStoryId((String)itemLinkObject.get("sourceUserStoryId"));
                    link.setTargetUserStoryId((String)itemLinkObject.get("targetUserStoryId"));
                    if (itemLinkObject.get("raisedOn") != null) {
                        link.setRaisedOn((Date)itemLinkObject.get("raisedOn"));
                    }
                    if (itemLinkObject.get("resolvedOn") != null) {
                        link.setResolvedOn((Date)itemLinkObject.get("resolvedOn"));
                    }
                    link.setType((String)itemLinkObject.get("type"));
                    link.setTitle((String)itemLinkObject.get("title"));
                }
                if (itemLinkMapById.get(linkId) == null) {
                    itemLinkMapById.put(linkId, linkId);
                    itemLinks.add(linkId);
                }
                _itemLinks.add(link);
            }
        }
        ArrayList _jiraLinks = new ArrayList();
        List jiraLinksRef = (List)vo.get("jiraDependencies");
        if (PropertyValidator.isValid((Collection)jiraLinksRef)) {
            jiraLinksRef.forEach(linkRef -> {
                String linkId = String.valueOf(linkRef.getId());
                ItemJiraDependency link = new ItemJiraDependency();
                link.setId(linkId);
                if (jiraLinkMapById.get(linkId) == null) {
                    jiraLinkMapById.put(linkId, linkId);
                    jiraLinks.add(linkId);
                }
                _jiraLinks.add(link);
            });
        }
        List teamContainersRef = (List)vo.get("teamContainers");
        ArrayList<TeamContainer> teamContainers = new ArrayList<TeamContainer>();
        if (PropertyValidator.isValid((Collection)teamContainersRef)) {
            for (int i = 0; i < teamContainersRef.size(); ++i) {
                DBRef tcRef = (DBRef)teamContainersRef.get(i);
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(tcRef.getId()));
                DBCursor dbCursorDomain = this.customRepositoryImpl.getMongoTemplate().getCollection("teamContainer").find(query.getQueryObject());
                if (!dbCursorDomain.hasNext()) continue;
                DBObject tcObject = dbCursorDomain.next();
                DBRef teamRef = (DBRef)tcObject.get("team");
                DBRef containerRef = (DBRef)tcObject.get("container");
                Double sequence = (Double)tcObject.get("sequence");
                Team team = teamMapById.get(String.valueOf(teamRef.getId()));
                Container container = containerMapById.get(String.valueOf(containerRef.getId()));
                TeamContainer teamContainer = new TeamContainer();
                teamContainer.setId(String.valueOf(tcObject.get("_id")));
                teamContainer.setOriginItemId((String)tcObject.get("originItemId"));
                teamContainer.setTeam(team);
                teamContainer.setContainer(container);
                teamContainer.setSequence(sequence);
                if (!PropertyValidator.isValid((Object)team) || !PropertyValidator.isValid((Object)team.getId()) || !PropertyValidator.isValid((Object)container) || !PropertyValidator.isValid((Object)container.getId())) continue;
                teamContainers.add(teamContainer);
            }
        }
        return new Item(vo, null, itemStatus, issueType, parent, _itemLinks, _jiraLinks, teamContainers, null);
    }

    public List<Item> prepareDataForExport_old(String boardId, SessionBoard board) {
        ArrayList<Item> orderedList = new ArrayList<Item>();
        ArrayList<SessionBoard> boardsList = new ArrayList<SessionBoard>();
        if (board == null) {
            board = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)boardId));
        }
        boardsList.add(board);
        List items = this.itemRepository.findBySessionBoardsInOrderBySequence(boardsList);
        for (Item item : items) {
            if (!PropertyValidator.isValid((Object)item.getType()) || !"Feature".equals(item.getType())) continue;
            orderedList.add(item);
            List childItems = this.itemRepository.findByParent(item);
            if (PropertyValidator.isValid((Collection)childItems)) {
                double cummolativeSum = childItems.stream().filter(Objects::nonNull).mapToDouble(Item::getStoryPoints).sum();
                item.setStoryPoints(Double.valueOf(cummolativeSum));
                orderedList.addAll(childItems);
            }
            if (!PropertyValidator.isValid((Collection)item.getItemLinks())) continue;
            for (ItemLink iLink : item.getItemLinks()) {
                if (!PropertyValidator.isValid((Object)iLink)) continue;
                String targetTeamCont = iLink.getTargetTeamContainerId();
                TeamContainer tc = (TeamContainer)this.teamContainerRepository.findOne((Serializable)((Object)targetTeamCont));
                ArrayList<TeamContainer> tcList = new ArrayList<TeamContainer>();
                if (tc != null) {
                    tcList.add(tc);
                }
                List linkedItems = null;
                if (PropertyValidator.isValid(tcList) && tcList.size() > 0) {
                    linkedItems = this.itemRepository.findBySessionBoardsInAndTeamContainersInAndType(boardsList, tcList, item.getType());
                }
                if (!PropertyValidator.isValid(linkedItems)) continue;
                ItemLinkVO linkVo = new ItemLinkVO(iLink.getId());
                linkVo.setType(iLink.getType());
                if (item.getItemLinksVO().contains(linkVo)) continue;
                linkVo.setTitle(((Item)linkedItems.get(0)).getTitle());
                item.getItemLinksVO().add(linkVo);
            }
        }
        return orderedList;
    }

    public List<Map<String, String>> prepareDepsDataForExport(JSONArray depsArr, String viewType) throws Exception {
        ArrayList<Map<String, String>> orderedList = new ArrayList<Map<String, String>>();
        try {
            if (PropertyValidator.isValid((Object)depsArr) && depsArr.length() > 0) {
                for (int i = 0; i < depsArr.length(); ++i) {
                    JSONObject depsObj = depsArr.getJSONObject(i);
                    HashMap<String, String> row = new HashMap<String, String>();
                    if (!depsObj.isNull("depId")) {
                        row.put("Id", depsObj.getString("depId"));
                    }
                    if (!depsObj.isNull("sTeam")) {
                        row.put("From", depsObj.getString("sTeam"));
                    }
                    if (!depsObj.isNull("tTeam")) {
                        row.put("To", depsObj.getString("tTeam"));
                    }
                    String fromFeature = "";
                    if (!depsObj.isNull("sSprint") && PropertyValidator.isValid((Object)depsObj.getString("sSprint"))) {
                        fromFeature = fromFeature + depsObj.getString("sSprint");
                        fromFeature = fromFeature + " ";
                    }
                    if (!depsObj.isNull("sType") && PropertyValidator.isValid((Object)depsObj.getString("sType"))) {
                        fromFeature = fromFeature + "[" + depsObj.getString("sType") + "] ";
                    }
                    if (!depsObj.isNull("sFeatureKey") && PropertyValidator.isValid((Object)depsObj.getString("sFeatureKey"))) {
                        fromFeature = fromFeature + depsObj.getString("sFeatureKey");
                        fromFeature = fromFeature + " ";
                    }
                    if (!depsObj.isNull("sFeature") && PropertyValidator.isValid((Object)depsObj.getString("sFeature"))) {
                        fromFeature = fromFeature + depsObj.getString("sFeature");
                        fromFeature = fromFeature + " ";
                    }
                    if (!"".equals(fromFeature)) {
                        row.put("From Item", fromFeature);
                    }
                    String toFeature = "";
                    if (!depsObj.isNull("tSprint") && PropertyValidator.isValid((Object)depsObj.getString("tSprint"))) {
                        toFeature = toFeature + depsObj.getString("tSprint");
                        toFeature = toFeature + " ";
                    }
                    if (!depsObj.isNull("tType") && PropertyValidator.isValid((Object)depsObj.getString("tType"))) {
                        toFeature = toFeature + "[" + depsObj.getString("tType") + "] ";
                    }
                    if (!depsObj.isNull("tFeatureKey") && PropertyValidator.isValid((Object)depsObj.getString("tFeatureKey"))) {
                        toFeature = toFeature + depsObj.getString("tFeatureKey");
                        toFeature = toFeature + " ";
                    }
                    if (!depsObj.isNull("tFeature") && PropertyValidator.isValid((Object)depsObj.getString("tFeature"))) {
                        toFeature = toFeature + depsObj.getString("tFeature");
                        toFeature = toFeature + " ";
                    }
                    if (!"".equals(toFeature)) {
                        row.put("To Item", toFeature);
                    }
                    if (!depsObj.isNull("status")) {
                        row.put("Status", depsObj.getString("status"));
                    }
                    if (!depsObj.isNull("type")) {
                        row.put("Link Type", depsObj.getString("type"));
                    }
                    if (!depsObj.isNull("description")) {
                        if (!depsObj.isNull("isTfs")) {
                            row.put("Summary", depsObj.getString("description"));
                        } else {
                            row.put("Description", depsObj.getString("description"));
                        }
                    }
                    if (!depsObj.isNull("sFeatureStatus")) {
                        row.put("From Item Status", depsObj.getString("sFeatureStatus"));
                    }
                    if (!depsObj.isNull("tFeatureStatus")) {
                        row.put("To Item Status", depsObj.getString("tFeatureStatus"));
                    }
                    if (!depsObj.isNull("sFeatureStatus")) {
                        row.put("From Item Status", depsObj.getString("sFeatureStatus"));
                    }
                    if (!depsObj.isNull("tFeatureStatus")) {
                        row.put("To Item Status", depsObj.getString("tFeatureStatus"));
                    }
                    if (!depsObj.isNull("raisedOn")) {
                        row.put("Raised On", depsObj.getString("raisedOn"));
                    }
                    if (!depsObj.isNull("targetResolutionDate")) {
                        row.put("Target Resolution Date", depsObj.getString("targetResolutionDate"));
                    }
                    if (!depsObj.isNull("reporter")) {
                        row.put("Reporter", depsObj.getString("reporter"));
                    }
                    if (!depsObj.isNull("responsible")) {
                        row.put("Responsible", depsObj.getString("responsible"));
                    }
                    if (!depsObj.isNull("richDescription")) {
                        row.put("description", depsObj.getString("richDescription"));
                    }
                    orderedList.add(row);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
        return orderedList;
    }

    public List<Map<String, String>> prepareDepsDataForExcelExport(JSONArray depsArr, String viewType) {
        ArrayList<Map<String, String>> orderedList = new ArrayList<Map<String, String>>();
        try {
            if (PropertyValidator.isValid((Object)depsArr) && depsArr.length() > 0) {
                for (int i = 0; i < depsArr.length(); ++i) {
                    JSONObject depsObj = depsArr.getJSONObject(i);
                    HashMap<String, String> row = new HashMap<String, String>();
                    if (!depsObj.isNull("depId")) {
                        row.put("Id", depsObj.getString("depId"));
                    }
                    if (!depsObj.isNull("sTeam")) {
                        row.put("From", depsObj.getString("sTeam"));
                    }
                    if (!depsObj.isNull("tTeam")) {
                        row.put("To", depsObj.getString("tTeam"));
                    }
                    String fromFeature = "";
                    if (!depsObj.isNull("sSprint") && PropertyValidator.isValid((Object)depsObj.getString("sSprint"))) {
                        fromFeature = fromFeature + depsObj.getString("sSprint");
                        fromFeature = fromFeature + " ";
                        row.put("sSprint", depsObj.getString("sSprint"));
                    }
                    if (!depsObj.isNull("sType") && PropertyValidator.isValid((Object)depsObj.getString("sType"))) {
                        fromFeature = fromFeature + "[" + depsObj.getString("sType") + "] ";
                    }
                    if (!depsObj.isNull("sFeatureKey") && PropertyValidator.isValid((Object)depsObj.getString("sFeatureKey"))) {
                        fromFeature = fromFeature + depsObj.getString("sFeatureKey");
                        fromFeature = fromFeature + " ";
                        row.put("sFeatureKey", depsObj.getString("sFeatureKey"));
                    }
                    if (!depsObj.isNull("sFeature") && PropertyValidator.isValid((Object)depsObj.getString("sFeature"))) {
                        fromFeature = fromFeature + depsObj.getString("sFeature");
                        fromFeature = fromFeature + " ";
                        row.put("sFeature", depsObj.getString("sFeature"));
                    }
                    if (!"".equals(fromFeature)) {
                        row.put("From Item", fromFeature);
                    }
                    if (!depsObj.isNull("sFeatureStatus")) {
                        row.put("From Item Status", depsObj.getString("sFeatureStatus"));
                    }
                    String toFeature = "";
                    if (!depsObj.isNull("tSprint") && PropertyValidator.isValid((Object)depsObj.getString("tSprint"))) {
                        toFeature = toFeature + depsObj.getString("tSprint");
                        toFeature = toFeature + " ";
                        row.put("tSprint", depsObj.getString("tSprint"));
                    }
                    if (!depsObj.isNull("tType") && PropertyValidator.isValid((Object)depsObj.getString("tType"))) {
                        toFeature = toFeature + "[" + depsObj.getString("tType") + "] ";
                    }
                    if (!depsObj.isNull("tFeatureKey") && PropertyValidator.isValid((Object)depsObj.getString("tFeatureKey"))) {
                        toFeature = toFeature + depsObj.getString("tFeatureKey");
                        toFeature = toFeature + " ";
                        row.put("tFeatureKey", depsObj.getString("tFeatureKey"));
                    }
                    if (!depsObj.isNull("tFeatureStatus")) {
                        row.put("To Item Status", depsObj.getString("tFeatureStatus"));
                    }
                    if (!depsObj.isNull("tFeature") && PropertyValidator.isValid((Object)depsObj.getString("tFeature"))) {
                        toFeature = toFeature + depsObj.getString("tFeature");
                        toFeature = toFeature + " ";
                    }
                    if (!"".equals(toFeature)) {
                        row.put("To Item", toFeature);
                    }
                    if (!depsObj.isNull("status")) {
                        row.put("Status", depsObj.getString("status"));
                    }
                    if (!depsObj.isNull("type")) {
                        row.put("Link Type", depsObj.getString("type"));
                    }
                    if (!depsObj.isNull("description")) {
                        if (!depsObj.isNull("isTfs")) {
                            row.put("Summary", depsObj.getString("description"));
                        } else {
                            row.put("Description", depsObj.getString("description"));
                        }
                    }
                    if (!depsObj.isNull("raisedOn")) {
                        row.put("Raised On", depsObj.getString("raisedOn"));
                    }
                    if (!depsObj.isNull("targetResolutionDate")) {
                        row.put("Target Resolution Date", depsObj.getString("targetResolutionDate"));
                    }
                    if (!depsObj.isNull("reporter")) {
                        row.put("Reporter", depsObj.getString("reporter"));
                    }
                    if (!depsObj.isNull("responsible")) {
                        row.put("Responsible", depsObj.getString("responsible"));
                    }
                    if (!depsObj.isNull("richDescription")) {
                        row.put("description", depsObj.getString("richDescription"));
                    }
                    orderedList.add(row);
                }
            }
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return orderedList;
    }

    public List<Map<String, String>> prepareWsjfDataForExport(List<Item> wsjfDataArr, String headers, SessionBoard board) {
        ArrayList<Map<String, String>> orderedList;
        block26: {
            orderedList = new ArrayList<Map<String, String>>();
            ScoreCard savedScoreCard = this.scoreCardRepository.findByType(ScoreCard.Type.WSJF.toString());
            try {
                if (!PropertyValidator.isValid(wsjfDataArr)) break block26;
                for (Item wsjfObj : wsjfDataArr) {
                    HashMap<String, String> row = new HashMap<String, String>();
                    if (PropertyValidator.isValid((Object)wsjfObj.getJiraKey())) {
                        row.put("Feature ID", wsjfObj.getJiraKey());
                    } else if (PropertyValidator.isValid((Object)wsjfObj.getTfsId())) {
                        row.put("Feature ID", wsjfObj.getTfsId());
                    } else if (PropertyValidator.isValid((Object)wsjfObj.getKendisKey())) {
                        row.put("Feature ID", wsjfObj.getKendisKey());
                    }
                    if (PropertyValidator.isValid((Object)wsjfObj.getTitle())) {
                        row.put("Title", wsjfObj.getTitle());
                    }
                    if (PropertyValidator.isValid((Object)wsjfObj.getStatus()) && PropertyValidator.isValid((Object)wsjfObj.getStatus().getTitle())) {
                        row.put("Status", wsjfObj.getStatus().getTitle());
                    }
                    if (PropertyValidator.isValid((Object)wsjfObj.getIssueType())) {
                        row.put("Card Type", wsjfObj.getIssueType().getTitle());
                    } else {
                        row.put("Card Type", wsjfObj.getType());
                    }
                    if (PropertyValidator.isValid((Object)wsjfObj.getStoryPoints())) {
                        row.put("Estimate", String.valueOf(wsjfObj.getStoryPoints()));
                    }
                    try {
                        if (PropertyValidator.isValid((Object)wsjfObj.getScoreParams()) && PropertyValidator.isValid(wsjfObj.getScoreParams().get("param1"))) {
                            row.put(((ScoreParam)savedScoreCard.getParams().get("param1")).getName(), (String)wsjfObj.getScoreParams().get("param1"));
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                    try {
                        if (PropertyValidator.isValid((Object)wsjfObj.getScoreParams()) && PropertyValidator.isValid(wsjfObj.getScoreParams().get("param2"))) {
                            row.put(((ScoreParam)savedScoreCard.getParams().get("param2")).getName(), (String)wsjfObj.getScoreParams().get("param2"));
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                    try {
                        if (PropertyValidator.isValid((Object)wsjfObj.getScoreParams()) && PropertyValidator.isValid(wsjfObj.getScoreParams().get("param3"))) {
                            row.put(((ScoreParam)savedScoreCard.getParams().get("param3")).getName(), (String)wsjfObj.getScoreParams().get("param3"));
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                    try {
                        if (PropertyValidator.isValid((Object)wsjfObj.getScoreParams()) && PropertyValidator.isValid(wsjfObj.getScoreParams().get("param4"))) {
                            row.put(((ScoreParam)savedScoreCard.getParams().get("param4")).getName(), (String)wsjfObj.getScoreParams().get("param4"));
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                    if (PropertyValidator.isValid((Object)wsjfObj.getScore())) {
                        row.put("WSJF", String.valueOf(wsjfObj.getScore()));
                    }
                    orderedList.add(row);
                }
            }
            catch (JSONException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        return orderedList;
    }

    public String exportSolutionDepsData(String headers, List<HashMap<String, String>> data, int exportType, String viewType) {
        if (exportType == 1) {
            String fileName = new Date().getTime() + ".xls";
            String filePath = this.env.getProperty("temp.file.location") + fileName;
            try {
                FileOutputStream os = new FileOutputStream(filePath);
                HSSFWorkbook workbook = new HSSFWorkbook();
                HSSFSheet worksheet = workbook.createSheet("Kendis Worksheet");
                int rowIndex = 0;
                HSSFRow row = worksheet.createRow((int)((short)rowIndex++));
                String[] header = headers.split(",");
                for (int i = 0; i < header.length; ++i) {
                    HSSFCell cell = row.createCell((int)((short)i));
                    HSSFCellStyle cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
                    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    cell.setCellStyle(cellStyle);
                    cell.setCellValue(header[i]);
                    worksheet.autoSizeColumn((int)((short)i));
                }
                worksheet.setColumnWidth(1, 10000);
                worksheet.setColumnWidth(5, 10000);
                HSSFCellStyle cellStyle = workbook.createCellStyle();
                cellStyle.setWrapText(true);
                for (int j = 0; j < data.size(); ++j) {
                    HashMap<String, String> rowData = data.get(j);
                    int colIndex = 0;
                    row = worksheet.createRow((int)((short)rowIndex++));
                    HSSFCell cell = null;
                    for (int k = 0; k < header.length; ++k) {
                        cell = row.createCell((int)((short)colIndex++));
                        cell.setCellValue(rowData.get(header[k]));
                        cell.setCellStyle(cellStyle);
                    }
                }
                LOGGER.debug("******** CHECKING EXPORT BYTES BEFORE WRITING************");
                LOGGER.debug("" + workbook.getBytes().length);
                workbook.write((OutputStream)os);
                os.flush();
                os.close();
                workbook.close();
                return filePath;
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        } else {
            CsvMapWriter writer = null;
            String[] header = headers.split(",");
            String fileName = new Date().getTime() + ".csv";
            String filePath = this.env.getProperty("temp.file.location") + "/" + fileName;
            try {
                FileOutputStream os = new FileOutputStream(filePath);
                writer = new CsvMapWriter((Writer)new OutputStreamWriter((OutputStream)os, "UTF-8"), CsvPreference.EXCEL_PREFERENCE);
                String[] completeHeader = header;
                writer.writeHeader(completeHeader);
                for (int j = 0; j < data.size(); ++j) {
                    HashMap<String, String> rowData = data.get(j);
                    writer.write(rowData, completeHeader);
                }
                writer.close();
                os.flush();
                os.close();
                return filePath;
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        return null;
    }

    public String exportBoardData(String boardId, SessionBoard sessionBoard, int exportAs, String headers) {
        try {
            boolean servicenow = false;
            if (headers.indexOf("Feature Key") > -1 && headers.indexOf("Story Key") > -1) {
                servicenow = true;
            }
            List orderedList = this.prepareDataForExport(boardId, sessionBoard);
            if (exportAs == 0) {
                return this.writeCSVFile(headers, orderedList, sessionBoard, servicenow);
            }
            try {
                return this.writeExcel(headers, orderedList, sessionBoard, servicenow);
            }
            catch (IOException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return "";
    }

    public String exportDepsData(JSONArray depsArr, int exportAs, String viewType) throws Exception {
        if (exportAs == 0) {
            List orderedList = this.prepareDepsDataForExport(depsArr, viewType);
            return this.writeDepsCSVFile("jira".equals(viewType) ? "#,Id,From Item,From Item Status,Link Type,To Item,To Item Status,Raised On,Target Resolution Date,Reporter,Responsible,description" : "#,Id,From,To,From Item,Link Type,To Item,Status,Description,Raised On,Target Resolution Date,Reporter,Responsible,description", orderedList);
        }
        try {
            List orderedList = this.prepareDepsDataForExcelExport(depsArr, viewType);
            return this.writeDepsExcel("jira".equals(viewType) ? "#,Id,From Item,From Item Status,Link Type,To Item,To Item Status,Raised On,Target Resolution Date,Reporter,Responsible,description" : "#,Id,From,To,From Item,Link Type,To Item,Status,Description,Raised On,Target Resolution Date,Reporter,Responsible,description", orderedList);
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return "";
        }
    }

    public String exportDepsDataTFS(JSONArray depsArr, int exportAs, String viewType) throws Exception {
        if (exportAs == 0) {
            List orderedList = this.prepareDepsDataForExport(depsArr, viewType);
            return this.writeDepsCSVFile("jira".equals(viewType) ? "#,Id,From Item,From Item Status,Link Type,To Item,To Item Status,Raised On,Target Resolution Date,Reporter,Responsible,description" : "#,Id,From,To,From Item,Link Type,To Item,Status,Summary,Raised On,Target Resolution Date,Reporter,Responsible,description", orderedList);
        }
        try {
            List orderedList = this.prepareDepsDataForExcelExport(depsArr, viewType);
            return this.writeDepsExcel("jira".equals(viewType) ? "#,Id,From Item,From Item Status,Link Type,To Item,To Item Status,Raised On,Target Resolution Date,Reporter,Responsible,description" : "#,Id,From,To,From Item,Link Type,To Item,Status,Summary,Raised On,Target Resolution Date,Reporter,Responsible,description", orderedList);
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return "";
        }
    }

    public String exportWsjfDataTFS(List<Item> wsjfDataArr, String headers, int exportAs, SessionBoard board) {
        if (exportAs == 0) {
            List orderedList = this.prepareWsjfDataForExport(wsjfDataArr, headers, board);
            return this.writeWsjfCSVFile(headers, orderedList);
        }
        try {
            List orderedList = this.prepareWsjfDataForExport(wsjfDataArr, headers, board);
            return this.writeWsjfExcel(headers, orderedList);
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return "";
        }
    }

    public String exportReportData(int exportAs, List<HashMap<String, Object>> items, List<Item> child, Map<String, HashMap<String, Object>> childMap, Report report) {
        if (exportAs == 0) {
            return this.writeReportsCSVFile(items, child, childMap, report);
        }
        try {
            return this.writeReportExcelFile(items, child, childMap, report);
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return "";
        }
    }

    public String exportLogData(SessionBoard sessionBoard, HashMap<String, LinkedHashSet<HashMap<String, ? super Object>>> chunks, List<String> errors, HashMap<String, String> requestBody) throws Exception {
        try {
            String dependencyData;
            int excelRowIndex = 0;
            Gson gson = new Gson();
            Integer beforeFEA = new Integer(requestBody.get("beforeFEA"));
            Integer beforeUS = new Integer(requestBody.get("beforeUS"));
            String fileName = new Date().getTime() + ".xls";
            String filePath = this.env.getProperty("temp.file.location") + fileName;
            FileOutputStream file = new FileOutputStream(filePath);
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet worksheet = workbook.createSheet("Resync Change Log");
            boolean ignoreChild = Boolean.parseBoolean(requestBody.get("ignoreChild"));
            LinkedHashSet<HashMap<String, ? super Object>> missingFEA = chunks.get("missingParent");
            LinkedHashSet<HashMap<String, ? super Object>> missingUS = chunks.get("missingChild");
            LinkedHashSet<HashMap<String, ? super Object>> newFEA = chunks.get("newParent");
            LinkedHashSet<HashMap<String, ? super Object>> newUS = chunks.get("newChild");
            LinkedHashSet<HashMap<String, ? super Object>> unsyncFEA = chunks.get("unsyncParent");
            LinkedHashSet<HashMap<String, ? super Object>> unsyncUS = chunks.get("unsyncChild");
            if (missingFEA != null && missingUS != null && newFEA != null && newUS != null) {
                Integer afterFEA = beforeFEA - missingFEA.size() + newFEA.size();
                Integer afterUS = beforeUS - missingUS.size() + newUS.size();
                String text1 = sessionBoard.getSession().getParentItem() + " Count Removed: " + missingFEA.size();
                String text2 = sessionBoard.getSession().getChildItem() + " Count Removed: " + missingUS.size();
                String text3 = sessionBoard.getSession().getParentItem() + " Count Added: " + newFEA.size();
                String text4 = sessionBoard.getSession().getChildItem() + " Count Added: " + newUS.size();
                String text5 = sessionBoard.getSession().getParentItem() + " Count not Updated: " + unsyncFEA.size();
                String text6 = sessionBoard.getSession().getChildItem() + " Count not Updated: " + unsyncUS.size();
                ArrayList<Object> innerTable = new ArrayList<Object>();
                innerTable.add(new /* Unavailable Anonymous Inner Class!! */);
                innerTable.add(new /* Unavailable Anonymous Inner Class!! */);
                innerTable.add(new /* Unavailable Anonymous Inner Class!! */);
                innerTable.add(new /* Unavailable Anonymous Inner Class!! */);
                LinkedHashSet<Object> counts = new LinkedHashSet<Object>();
                counts.add(new /* Unavailable Anonymous Inner Class!! */);
                if (!ignoreChild) {
                    counts.add(new /* Unavailable Anonymous Inner Class!! */);
                }
                counts.add(new /* Unavailable Anonymous Inner Class!! */);
                counts.add(new /* Unavailable Anonymous Inner Class!! */);
                excelRowIndex = this.writeItemLogFile((int)HSSFColor.GOLD.index, "Change Log", workbook, worksheet, innerTable, counts, null, excelRowIndex);
                excelRowIndex = this.writeItemLogFile((int)HSSFColor.RED.index, text1, workbook, worksheet, Constants.DEFAULT_HEADERS, missingFEA, null, excelRowIndex);
                excelRowIndex = this.writeItemLogFile((int)HSSFColor.RED.index, text2, workbook, worksheet, Constants.DEFAULT_HEADERS, missingUS, null, excelRowIndex);
                excelRowIndex = this.writeItemLogFile((int)HSSFColor.LIGHT_GREEN.index, text3, workbook, worksheet, Constants.DEFAULT_HEADERS, newFEA, null, excelRowIndex);
                excelRowIndex = this.writeItemLogFile((int)HSSFColor.LIGHT_GREEN.index, text4, workbook, worksheet, Constants.DEFAULT_HEADERS, newUS, null, excelRowIndex);
                excelRowIndex = this.writeItemLogFile((int)HSSFColor.LIGHT_YELLOW.index, text5, workbook, worksheet, Constants.DEFAULT_HEADERS, unsyncFEA, null, excelRowIndex);
                excelRowIndex = this.writeItemLogFile((int)HSSFColor.LIGHT_YELLOW.index, text6, workbook, worksheet, Constants.DEFAULT_HEADERS, unsyncUS, null, excelRowIndex);
            }
            if (PropertyValidator.isValid((Object)(dependencyData = requestBody.get("dependencyData")))) {
                dependencyData = URLDecoder.decode(dependencyData, "UTF-8");
                JSONArray JSONArray2 = new JSONArray(dependencyData);
                String viewType = requestBody.get("viewType");
                List despDataMap = this.prepareDepsDataForExcelExport(JSONArray2, viewType);
                String[] header = new String[]{"From", "To", "From Item", "Link Type", "To Item", "Status"};
                if (PropertyValidator.isValid((Collection)despDataMap)) {
                    int n = ++excelRowIndex;
                    HSSFRow title_heading = worksheet.createRow((int)((short)n));
                    HSSFCell box = title_heading.createCell(0);
                    box.setCellValue(despDataMap.size() + " Dependencies removed from the board");
                    Map columnPositionMap = this.createWorkSheetHeaders(++excelRowIndex, header, worksheet, workbook);
                    Map headerMap = this.stringArrayToMap(header);
                    for (Map userStory : despDataMap) {
                        this.createDepWorksheetRow(headerMap, userStory, excelRowIndex, worksheet, columnPositionMap, workbook);
                        ++excelRowIndex;
                    }
                }
            }
            if (PropertyValidator.isValid((Object)requestBody.get("itemIds"))) {
                int i;
                ++excelRowIndex;
                ++excelRowIndex;
                ArrayList<Object> objectiveHeader = new ArrayList<Object>();
                objectiveHeader.add(new /* Unavailable Anonymous Inner Class!! */);
                objectiveHeader.add(new /* Unavailable Anonymous Inner Class!! */);
                objectiveHeader.add(new /* Unavailable Anonymous Inner Class!! */);
                objectiveHeader.add(new /* Unavailable Anonymous Inner Class!! */);
                objectiveHeader.add(new /* Unavailable Anonymous Inner Class!! */);
                objectiveHeader.add(new /* Unavailable Anonymous Inner Class!! */);
                sessionBoard.setIsResyncing(Boolean.TRUE);
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                15 T = new /* Unavailable Anonymous Inner Class!! */;
                List itemIds = (List)gson.fromJson(requestBody.get("itemIds"), T.getType());
                16 T2 = new /* Unavailable Anonymous Inner Class!! */;
                Map jiraKeyByItemId = (Map)gson.fromJson(requestBody.get("jiraKeyByItemId"), T2.getType());
                for (i = 0; i < itemIds.size(); ++i) {
                    Item jiraKeyItem = new Item();
                    jiraKeyItem.setJiraKey((String)jiraKeyByItemId.get(itemIds.get(i)));
                    map.put(itemIds.get(i), jiraKeyItem);
                }
                if (PropertyValidator.isValid((Collection)sessionBoard.getTeams())) {
                    for (i = 0; i < sessionBoard.getTeams().size(); ++i) {
                        map.put(((Team)sessionBoard.getTeams().get(i)).getId(), sessionBoard.getTeams().get(i));
                    }
                }
                HSSFRow title_heading = worksheet.createRow((int)((short)excelRowIndex++));
                HSSFCell box = title_heading.createCell(0);
                box.setCellValue(" Objectives with Impact on Links ");
                excelRowIndex = this.writeObjectiveExcelFile(excelRowIndex, worksheet, workbook, sessionBoard, map, objectiveHeader);
            }
            if (PropertyValidator.isValid(errors) || PropertyValidator.isValid((Object)requestBody.get("errors"))) {
                17 T = new /* Unavailable Anonymous Inner Class!! */;
                errors = (List)gson.fromJson(requestBody.get("errors"), T.getType());
                ArrayList<Object> errorHeader = new ArrayList<Object>();
                errorHeader.add(new /* Unavailable Anonymous Inner Class!! */);
                errorHeader.add(new /* Unavailable Anonymous Inner Class!! */);
                this.writeItemLogFile((int)HSSFColor.RED.index, "Jira Errors", workbook, worksheet, errorHeader, null, errors, excelRowIndex);
            }
            this.autoSizeColumns(worksheet, 0);
            workbook.write((OutputStream)file);
            file.flush();
            file.close();
            return filePath;
        }
        catch (JSONException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    private String[] putJiraFieldsHeader(String[] header, Map<String, String> headerMap, SessionBoard sessionBoard) {
        if (Boolean.TRUE.equals(sessionBoard.getSession().getAdditionalFieldsEnabled())) {
            boolean added = false;
            Set extraFields = sessionBoard.getSession().combineAdditionalFields(null, null, true, null);
            String almAccountId = ((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getAlmAccount().getId();
            ArrayList<String> jiraIds = new ArrayList<String>();
            for (ItemJiraFieldMap field : extraFields) {
                jiraIds.add(field.getKey());
            }
            List jiraFields = this.jiraFieldRepository.findByJiraIdInAndAlmAccountId(jiraIds, almAccountId);
            Object[] newHeaders = new String[jiraFields.size()];
            for (int i = 0; i < jiraFields.size(); ++i) {
                headerMap.put(((JiraField)jiraFields.get(i)).getJiraId(), ((JiraField)jiraFields.get(i)).getName());
                newHeaders[i] = ((JiraField)jiraFields.get(i)).getName();
                added = true;
            }
            if (added) {
                header = (String[])ArrayUtils.addAll((Object[])header, (Object[])newHeaders);
            }
        }
        return header;
    }

    private String[] putKendisFieldsHeader(String[] header, Map<String, String> headerMap) {
        List fields;
        Map customFieldObj = this.customFieldService.getKendisCustomFieldsFromDefaultLayout(EnumKendis.KENDIS_ONLY_CARD.getCode());
        if (PropertyValidator.isValid((Object)customFieldObj) && PropertyValidator.isValid((Collection)(fields = (List)customFieldObj.get("fields")))) {
            Object[] newHeaders = new String[fields.size()];
            for (int i = 0; i < fields.size(); ++i) {
                headerMap.put(((Fields)fields.get(i)).getId(), ((Fields)fields.get(i)).getTitle());
                newHeaders[i] = ((Fields)fields.get(i)).getTitle();
            }
            header = (String[])ArrayUtils.addAll((Object[])header, (Object[])newHeaders);
            return header;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeCSVFile(String headers, List<Item> features, SessionBoard sessionBoard, boolean servicenow) {
        String[] kendisFieldsHeader;
        int i = 1;
        CsvMapWriter writer = null;
        String[] header = headers.split(",");
        Map headerMap = this.stringArrayToMap(header);
        if (!servicenow) {
            header = this.putJiraFieldsHeader(header, headerMap, sessionBoard);
        }
        if ((kendisFieldsHeader = this.putKendisFieldsHeader(header, headerMap)) != null) {
            header = kendisFieldsHeader;
        }
        try {
            String fileName = new Date().getTime() + ".csv";
            String filePath = this.env.getProperty("temp.file.location") + "/" + fileName;
            FileOutputStream os = new FileOutputStream(filePath);
            writer = new CsvMapWriter((Writer)new OutputStreamWriter((OutputStream)os, "UTF-8"), CsvPreference.EXCEL_PREFERENCE);
            String[] completeHeader = header;
            writer.writeHeader(completeHeader);
            if (PropertyValidator.isValid(features)) {
                for (Item item : features) {
                    HashMap rowData = null;
                    rowData = servicenow ? this.getRowServiceNow(headerMap, item, i, sessionBoard) : this.exportItemsCSVRow(headerMap, item, i, sessionBoard);
                    if (rowData == null) continue;
                    ++i;
                    try {
                        writer.write((Map)rowData, completeHeader);
                    }
                    catch (Exception e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                }
            }
            writer.close();
            os.close();
            String string = filePath;
            return string;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return null;
    }

    private String writeDepsCSVFile(String headers, List<Map<String, String>> despDataMap) {
        int i = 1;
        CsvMapWriter writer = null;
        String[] header = headers.split(",");
        try {
            String fileName = new Date().getTime() + ".csv";
            String filePath = this.env.getProperty("temp.file.location") + fileName;
            FileOutputStream os = new FileOutputStream(filePath);
            writer = new CsvMapWriter((Writer)new OutputStreamWriter((OutputStream)os, "UTF-8"), CsvPreference.EXCEL_PREFERENCE);
            String[] completeHeader = header;
            writer.writeHeader(completeHeader);
            if (PropertyValidator.isValid(despDataMap)) {
                for (Map<String, String> row : despDataMap) {
                    row.put("#", "" + i++);
                    try {
                        writer.write(row, completeHeader);
                    }
                    catch (Exception e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                }
            }
            writer.close();
            os.close();
            return filePath;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    private String writeWsjfCSVFile(String headers, List<Map<String, String>> despDataMap) {
        int i = 1;
        CsvMapWriter writer = null;
        String[] header = headers.split(",");
        try {
            String fileName = new Date().getTime() + ".csv";
            String filePath = this.env.getProperty("temp.file.location") + fileName;
            FileOutputStream os = new FileOutputStream(filePath);
            writer = new CsvMapWriter((Writer)new OutputStreamWriter((OutputStream)os, "UTF-8"), CsvPreference.EXCEL_PREFERENCE);
            String[] completeHeader = header;
            writer.writeHeader(completeHeader);
            if (PropertyValidator.isValid(despDataMap)) {
                for (Map<String, String> row : despDataMap) {
                    row.put("#", "" + i++);
                    try {
                        writer.write(row, completeHeader);
                    }
                    catch (Exception e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                }
            }
            writer.close();
            os.close();
            return filePath;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public String writeWsjfExcel(String headers, List<Map<String, String>> despDataMap) throws IOException {
        String[] header = headers.split(",");
        Map headerMap = this.stringArrayToMap(header);
        String fileName = new Date().getTime() + ".xls";
        String filePath = this.env.getProperty("temp.file.location") + fileName;
        FileOutputStream file = new FileOutputStream(filePath);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet worksheet = workbook.createSheet("Wsjf Worksheet");
        int position_index = 0;
        Map columnPositionMap = this.createWorkSheetHeaders(0, header, worksheet, workbook);
        if (PropertyValidator.isValid(despDataMap)) {
            for (Map<String, String> userStory : despDataMap) {
                this.createWsjfWorksheetRow(headerMap, userStory, position_index, worksheet, columnPositionMap, workbook);
                ++position_index;
            }
        }
        this.autoSizeColumns(worksheet, 0);
        workbook.write((OutputStream)file);
        file.flush();
        file.close();
        return filePath;
    }

    private Map<String, String> stringArrayToMap(String[] arr) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (PropertyValidator.isValid((String[])arr)) {
            for (String val : arr) {
                hashMap.put(val, val);
            }
        }
        return hashMap;
    }

    private HashMap<String, ? super Object> exportItemsCSVRow(Map<String, String> headerMap, Item item, int position, SessionBoard sessionBoard) throws IOException {
        try {
            Set keys;
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            if (PropertyValidator.isValid((Object)headerMap.get("Position")) && position != 0) {
                rowData.put(headerMap.get("Position"), position);
            }
            if (PropertyValidator.isValid((Object)headerMap.get("Type"))) {
                String typeText = "UserStory".equals(item.getType()) ? "Story" : (item.getIsEnabler() != null && item.getIsEnabler() != false ? "Enabler" : "Feature");
                rowData.put(headerMap.get("Type"), typeText);
            }
            if (PropertyValidator.isValid((Object)headerMap.get("Key"))) {
                if (PropertyValidator.isValid((Object)item.getTfsId())) {
                    rowData.put(headerMap.get("Key"), item.getTfsId());
                } else {
                    rowData.put(headerMap.get("Key"), item.getJiraKey());
                }
            }
            if (PropertyValidator.isValid((Object)headerMap.get("Summary"))) {
                if (PropertyValidator.isValid((Object)item.getTitle()) && item.getTitle() != null) {
                    rowData.put(headerMap.get("Summary"), item.getTitle());
                } else {
                    rowData.put(headerMap.get("Summary"), "");
                }
            }
            if (PropertyValidator.isValid((Object)headerMap.get("Parent Key"))) {
                if (PropertyValidator.isValid((Object)item.getParent())) {
                    if (PropertyValidator.isValid((Object)item.getParent().getTfsId())) {
                        rowData.put(headerMap.get("Parent Key"), item.getParent().getTfsId());
                    } else {
                        rowData.put(headerMap.get("Parent Key"), item.getParent().getJiraKey());
                    }
                    rowData.put(headerMap.get("Parent Title"), item.getParent().getTitle());
                } else {
                    rowData.put(headerMap.get("Parent Key"), "");
                    rowData.put(headerMap.get("Parent Title"), "");
                }
            }
            if (PropertyValidator.isValid((Object)headerMap.get("Session Board"))) {
                if (PropertyValidator.isValid((Object)sessionBoard)) {
                    rowData.put(headerMap.get("Session Board"), sessionBoard.getSession().getTitle());
                } else if (sessionBoard == null && item.getSessionBoards() != null && item.getSessionBoards().size() > 0 && ((SessionBoard)item.getSessionBoards().get(0)).getSession() != null) {
                    rowData.put(headerMap.get("Session Board"), ((SessionBoard)item.getSessionBoards().get(0)).getSession().getTitle());
                } else {
                    rowData.put(headerMap.get("Session Board"), "");
                }
            }
            if (PropertyValidator.isValid((Object)headerMap.get("Story Points"))) {
                rowData.put(headerMap.get("Story Points"), item.getStoryPoints());
            } else {
                rowData.put(headerMap.get("Story Points"), "");
            }
            if (PropertyValidator.isValid((Object)headerMap.get("Created by"))) {
                if (PropertyValidator.isValid((Object)item.getCreatedBy()) && item.getCreatedBy() != null) {
                    rowData.put(headerMap.get("Created by"), item.getCreatedBy());
                } else {
                    rowData.put(headerMap.get("Created by"), "");
                }
            }
            if (PropertyValidator.isValid((Object)headerMap.get("Created on"))) {
                if (PropertyValidator.isValid((Object)item.getCreatedOn()) && item.getCreatedOn() != null) {
                    rowData.put(headerMap.get("Created on"), item.getCreatedOn());
                } else {
                    rowData.put(headerMap.get("Created on"), "");
                }
            }
            if (PropertyValidator.isValid((Object)headerMap.get("Updated by"))) {
                if (PropertyValidator.isValid((Object)item.getUpdatedBy()) && item.getUpdatedBy() != null) {
                    rowData.put(headerMap.get("Updated by"), item.getUpdatedBy());
                } else {
                    rowData.put(headerMap.get("Updated by"), "");
                }
            }
            if (PropertyValidator.isValid((Object)headerMap.get("Updated on"))) {
                if (PropertyValidator.isValid((Object)item.getUpdatedOn()) && item.getUpdatedOn() != null) {
                    rowData.put(headerMap.get("Updated on"), item.getUpdatedOn());
                } else {
                    rowData.put(headerMap.get("Updated on"), "");
                }
            }
            if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                HashSet<String> sprintTitles = new HashSet<String>();
                HashSet<String> teamTitles = new HashSet<String>();
                for (TeamContainer teamCont : item.getTeamContainers()) {
                    if (teamCont == null || teamCont.getContainer() == null || teamCont.getTeam() == null) continue;
                    sprintTitles.add(teamCont.getContainer().getTitle());
                    teamTitles.add(teamCont.getTeam().getTitle());
                }
                rowData.put(headerMap.get("Sprints"), sprintTitles.stream().collect(Collectors.joining(",")));
                rowData.put(headerMap.get("Teams"), teamTitles.stream().collect(Collectors.joining(",")));
            } else {
                rowData.put(headerMap.get("Sprints"), "");
                rowData.put(headerMap.get("Teams"), "");
            }
            if (PropertyValidator.isValid((Collection)item.getItemLinksVO())) {
                HashSet<String> linkedTitles = new HashSet<String>();
                for (ItemLinkVO linkedItem : item.getItemLinksVO()) {
                    linkedTitles.add(linkedItem.getType() + " - " + linkedItem.getTitle());
                }
                rowData.put(headerMap.get("Linked Items"), linkedTitles.stream().collect(Collectors.joining(",")));
            } else {
                rowData.put(headerMap.get("Linked Items"), "");
            }
            if (PropertyValidator.isValid((Object)headerMap.get("Due Date"))) {
                if (PropertyValidator.isValid((Object)item.getDueDate()) && item.getDueDate() != null) {
                    rowData.put(headerMap.get("Due Date"), this.dateExportFormate.format(item.getDueDate()));
                } else {
                    rowData.put(headerMap.get("Due Date"), "");
                }
            }
            if (PropertyValidator.isValid((Object)headerMap.get("Status"))) {
                if (PropertyValidator.isValid((Object)item.getStatus()) && item.getStatus().getTitle() != null) {
                    rowData.put(headerMap.get("Status"), item.getStatus().getTitle());
                } else {
                    rowData.put(headerMap.get("Status"), "");
                }
            }
            if (PropertyValidator.isValid((Object)headerMap.get("Wsjf Score"))) {
                if (PropertyValidator.isValid((Object)item.getScore()) && item.getScore() != null) {
                    rowData.put(headerMap.get("Wsjf Score"), item.getScore());
                } else {
                    rowData.put(headerMap.get("Wsjf Score"), "");
                }
            }
            if (PropertyValidator.isValid((Object)headerMap.get("Card Type"))) {
                if (PropertyValidator.isValid((Object)item.getIssueType()) && item.getIssueType().getId() != null) {
                    rowData.put(headerMap.get("Card Type"), item.getIssueType().getTitle());
                } else if ("UserStory".equals(item.getType())) {
                    rowData.put(headerMap.get("Card Type"), "Story");
                } else {
                    rowData.put(headerMap.get("Card Type"), "Feature");
                }
            }
            if (PropertyValidator.isValid((Object)item.getJiraFieldTextByKey())) {
                keys = item.getJiraFieldTextByKey().keySet();
                for (String key : keys) {
                    if (!headerMap.containsKey(key)) continue;
                    if (PropertyValidator.isValid(item.getJiraFieldTextByKey().get(key))) {
                        rowData.put(headerMap.get(key), item.getJiraFieldTextByKey().get(key));
                        continue;
                    }
                    rowData.put(headerMap.get(key), "");
                }
            }
            if (PropertyValidator.isValid((Object)item.getFields())) {
                keys = item.getFields().keySet();
                for (String key : keys) {
                    if (!headerMap.containsKey(key)) continue;
                    if (PropertyValidator.isValid(item.getFields().get(key))) {
                        String str;
                        if (item.getFields().get(key) instanceof String) {
                            String str2 = ((String)item.getFields().get(key)).replaceAll("<[^>]*>", "");
                            str2 = str2.replaceAll("&nbsp;", "\n");
                            rowData.put(headerMap.get(key), str2);
                            continue;
                        }
                        if (item.getFields().get(key) instanceof List) {
                            ArrayList objs = (ArrayList)item.getFields().get(key);
                            str = "";
                            for (int i = 0; i < objs.size(); ++i) {
                                Map obj = (Map)objs.get(i);
                                str = str + obj.get("title");
                                if (i >= objs.size() - 1) continue;
                                str = str + ", ";
                            }
                            rowData.put(headerMap.get(key), str);
                            continue;
                        }
                        if (!(item.getFields().get(key) instanceof Object)) continue;
                        HashMap obj = (HashMap)item.getFields().get(key);
                        if (PropertyValidator.isValid(obj.get("title"))) {
                            rowData.put(headerMap.get(key), obj.get("title"));
                            continue;
                        }
                        if (PropertyValidator.isValid(obj.get("fullName"))) {
                            rowData.put(headerMap.get(key), obj.get("fullName"));
                            continue;
                        }
                        if (!PropertyValidator.isValid(obj.get("name"))) continue;
                        str = (String)obj.get("name");
                        String url = "";
                        if (PropertyValidator.isValid(obj.get("url"))) {
                            url = (String)obj.get("url");
                        }
                        rowData.put(headerMap.get(key), str + " : " + url);
                        continue;
                    }
                    rowData.put(headerMap.get(key), "");
                }
            }
            if (PropertyValidator.isValid((Object)headerMap.get("Iteration"))) {
                if (PropertyValidator.isValid((Object)item.getTfsIterationPath())) {
                    rowData.put(headerMap.get("Iteration"), item.getTfsIterationPath());
                } else {
                    rowData.put(headerMap.get("Iteration"), "");
                }
            }
            if (PropertyValidator.isValid((Object)headerMap.get("Area Path"))) {
                if (PropertyValidator.isValid((Object)item.getTfsAreaPath())) {
                    rowData.put(headerMap.get("Area Path"), item.getTfsAreaPath());
                } else {
                    rowData.put(headerMap.get("Area Path"), "");
                }
            }
            return rowData;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HashMap<String, ? super Object> getRowServiceNow(Map<String, String> headerMap, Item item, int position, SessionBoard sessionBoard) throws IOException {
        HashMap<String, Object> rowData = new HashMap<String, Object>();
        rowData.put(headerMap.get("Feature Key"), "");
        rowData.put(headerMap.get("Feature Link"), "");
        rowData.put(headerMap.get("Feature Summary"), "");
        rowData.put(headerMap.get("Feature Status"), "");
        rowData.put(headerMap.get("Feature Due Date"), "");
        rowData.put(headerMap.get("Story Key"), "");
        rowData.put(headerMap.get("Story Link"), "");
        rowData.put(headerMap.get("Story Summary"), "");
        rowData.put(headerMap.get("Story Status"), "");
        rowData.put(headerMap.get("Story Points"), "");
        rowData.put(headerMap.get("Team Name"), "");
        rowData.put(headerMap.get("Sprint Name"), "");
        rowData.put(headerMap.get("Wsjf Score"), "");
        if (item.getParent() == null) {
            if (!Boolean.TRUE.equals(item.getLastUpdatedValue("nochild"))) return null;
            rowData.put(headerMap.get("Feature Key"), PropertyValidator.isValid((Object)item.getKendisKey()) ? item.getKendisKey() : item.getJiraKey());
            rowData.put(headerMap.get("Feature Link"), item.getExternalReferenceURL());
            rowData.put(headerMap.get("Feature Summary"), item.getTitle());
            rowData.put(headerMap.get("Feature Status"), item.getStatus().getTitle());
            rowData.put(headerMap.get("Wsjf Score"), item.getScore());
            if (PropertyValidator.isValid((Object)item.getDueDate()) && item.getDueDate() != null) {
                rowData.put(headerMap.get("Feature Due Date"), this.dateExportFormate.format(item.getDueDate()));
            } else {
                rowData.put(headerMap.get("Feature Due Date"), "");
            }
        } else {
            rowData.put(headerMap.get("Feature Key"), PropertyValidator.isValid((Object)item.getParent().getKendisKey()) ? item.getParent().getKendisKey() : item.getParent().getJiraKey());
            rowData.put(headerMap.get("Feature Link"), item.getParent().getExternalReferenceURL());
            rowData.put(headerMap.get("Feature Summary"), item.getParent().getTitle());
            rowData.put(headerMap.get("Feature Status"), item.getParent().getStatus().getTitle());
            if (PropertyValidator.isValid((Object)item.getParent().getDueDate()) && item.getParent().getDueDate() != null) {
                rowData.put(headerMap.get("Feature Due Date"), this.dateExportFormate.format(item.getParent().getDueDate()));
            } else {
                rowData.put(headerMap.get("Feature Due Date"), "");
            }
            rowData.put(headerMap.get("Story Key"), PropertyValidator.isValid((Object)item.getKendisKey()) ? item.getKendisKey() : item.getJiraKey());
            rowData.put(headerMap.get("Story Link"), item.getExternalReferenceURL());
            rowData.put(headerMap.get("Story Summary"), item.getTitle());
            rowData.put(headerMap.get("Story Status"), item.getStatus().getTitle());
            rowData.put(headerMap.get("Story Points"), item.getStoryPoints());
            rowData.put(headerMap.get("Wsjf Score"), item.getScore());
        }
        if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
            HashSet<String> sprintTitles = new HashSet<String>();
            HashSet<String> teamTitles = new HashSet<String>();
            for (TeamContainer teamCont : item.getTeamContainers()) {
                if (teamCont == null || teamCont.getContainer() == null || teamCont.getTeam() == null) continue;
                sprintTitles.add(teamCont.getContainer().getTitle());
                teamTitles.add(teamCont.getTeam().getTitle());
            }
            rowData.put(headerMap.get("Team Name"), teamTitles.stream().collect(Collectors.joining(",")));
            rowData.put(headerMap.get("Sprint Name"), sprintTitles.stream().collect(Collectors.joining(",")));
        }
        if (!PropertyValidator.isValid((Object)item.getFields())) return rowData;
        Set keys = item.getFields().keySet();
        for (String key : keys) {
            if (!headerMap.containsKey(key)) continue;
            if (PropertyValidator.isValid(item.getFields().get(key))) {
                String str;
                if (item.getFields().get(key) instanceof String) {
                    String str2 = ((String)item.getFields().get(key)).replaceAll("<[^>]*>", "");
                    str2 = str2.replaceAll("&nbsp;", "\n");
                    rowData.put(headerMap.get(key), str2);
                    continue;
                }
                if (item.getFields().get(key) instanceof List) {
                    ArrayList objs = (ArrayList)item.getFields().get(key);
                    str = "";
                    for (int i = 0; i < objs.size(); ++i) {
                        Map obj = (Map)objs.get(i);
                        str = str + obj.get("title");
                        if (i >= objs.size() - 1) continue;
                        str = str + ", ";
                    }
                    rowData.put(headerMap.get(key), str);
                    continue;
                }
                if (!(item.getFields().get(key) instanceof Object)) continue;
                HashMap obj = (HashMap)item.getFields().get(key);
                if (PropertyValidator.isValid(obj.get("title"))) {
                    rowData.put(headerMap.get(key), obj.get("title"));
                    continue;
                }
                if (PropertyValidator.isValid(obj.get("fullName"))) {
                    rowData.put(headerMap.get(key), obj.get("fullName"));
                    continue;
                }
                if (!PropertyValidator.isValid(obj.get("name"))) continue;
                str = (String)obj.get("name");
                String url = "";
                if (PropertyValidator.isValid(obj.get("url"))) {
                    url = (String)obj.get("url");
                }
                rowData.put(headerMap.get(key), str + " : " + url);
                continue;
            }
            rowData.put(headerMap.get(key), "");
        }
        return rowData;
    }

    public void createItemWorksheetRow(Map<String, String> headerMap, Item item, int position, HSSFSheet worksheet, Map<String, Integer> columnPositionMap, SessionBoard sessionBoard) {
        HSSFCell cell;
        Set keys;
        HSSFCell cell2;
        HSSFRow row = worksheet.createRow((short)position + 1);
        if (PropertyValidator.isValid((Object)headerMap.get("Position"))) {
            cell2 = row.createCell((int)((short)columnPositionMap.get("Position").intValue()));
            cell2.setCellValue((double)(position + 1));
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Type"))) {
            cell2 = row.createCell((int)((short)columnPositionMap.get("Type").intValue()));
            String typeText = "UserStory".equals(item.getType()) ? "Story" : (item.getIsEnabler() != null && item.getIsEnabler() != false ? "Enabler" : "Feature");
            cell2.setCellValue(typeText);
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Key"))) {
            cell2 = row.createCell((int)((short)columnPositionMap.get("Key").intValue()));
            if (PropertyValidator.isValid((Object)item.getTfsId())) {
                cell2.setCellValue(item.getTfsId());
            } else {
                cell2.setCellValue(item.getJiraKey());
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Summary"))) {
            cell2 = row.createCell((int)((short)columnPositionMap.get("Summary").intValue()));
            if (PropertyValidator.isValid((Object)item.getTitle()) && item.getTitle() != null) {
                cell2.setCellValue(item.getTitle());
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Parent Key")) && PropertyValidator.isValid((Object)item.getParent())) {
            cell2 = row.createCell((int)((short)columnPositionMap.get("Parent Key").intValue()));
            if (PropertyValidator.isValid((Object)item.getParent())) {
                if (PropertyValidator.isValid((Object)item.getParent().getTfsId())) {
                    cell2.setCellValue(item.getParent().getTfsId());
                } else if (item.getParent().getJiraKey() != null) {
                    cell2.setCellValue(item.getParent().getJiraKey());
                }
            }
            cell2 = row.createCell((int)((short)columnPositionMap.get("Parent Title").intValue()));
            if (PropertyValidator.isValid((Object)item.getParent()) && item.getParent().getTitle() != null) {
                cell2.setCellValue(item.getParent().getTitle());
            }
        }
        if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
            HashSet<String> sprintTitles = new HashSet<String>();
            HashSet teamTitles = new HashSet();
            for (TeamContainer teamCont : item.getTeamContainers()) {
                if (teamCont == null || teamCont.getContainer() == null || teamCont.getTeam() == null) continue;
                sprintTitles.add(teamCont.getContainer().getTitle());
                teamTitles.add(teamCont.getTeam().getTitle());
            }
            HSSFCell cell3 = row.createCell((int)((short)columnPositionMap.get("Sprints").intValue()));
            cell3.setCellValue(sprintTitles.stream().collect(Collectors.joining(",")));
            cell3 = row.createCell((int)((short)columnPositionMap.get("Teams").intValue()));
            cell3.setCellValue(teamTitles.stream().collect(Collectors.joining(",")));
        }
        if (PropertyValidator.isValid((Collection)item.getItemLinksVO())) {
            HashSet<String> linkedTitles = new HashSet<String>();
            for (ItemLinkVO linkedItem : item.getItemLinksVO()) {
                linkedTitles.add(linkedItem.getType() + " - " + linkedItem.getTitle());
            }
            HSSFCell cell4 = row.createCell((int)((short)columnPositionMap.get("Linked Items").intValue()));
            cell4.setCellValue(linkedTitles.stream().collect(Collectors.joining(",")));
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Due Date")) && PropertyValidator.isValid((Object)item.getDueDate()) && item.getDueDate() != null) {
            cell2 = row.createCell((int)((short)columnPositionMap.get("Due Date").intValue()));
            cell2.setCellValue(this.dateExportFormate.format(item.getDueDate()));
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Status")) && PropertyValidator.isValid((Object)item.getStatus()) && item.getStatus().getTitle() != null) {
            cell2 = row.createCell((int)((short)columnPositionMap.get("Status").intValue()));
            cell2.setCellValue(item.getStatus().getTitle());
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Wsjf Score")) && PropertyValidator.isValid((Object)item.getScore()) && item.getScore() != null) {
            cell2 = row.createCell((int)((short)columnPositionMap.get("Wsjf Score").intValue()));
            cell2.setCellValue(item.getScore().doubleValue());
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Session Board"))) {
            if (PropertyValidator.isValid((Object)sessionBoard)) {
                cell2 = row.createCell((int)((short)columnPositionMap.get("Session Board").intValue()));
                cell2.setCellValue(sessionBoard.getSession().getTitle());
            } else if (sessionBoard == null && item.getSessionBoards() != null && item.getSessionBoards().size() > 0 && ((SessionBoard)item.getSessionBoards().get(0)).getSession() != null) {
                cell2 = row.createCell((int)((short)columnPositionMap.get("Session Board").intValue()));
                cell2.setCellValue(((SessionBoard)item.getSessionBoards().get(0)).getSession().getTitle());
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Description"))) {
            cell2 = row.createCell((int)((short)columnPositionMap.get("Description").intValue()));
            if (PropertyValidator.isValid((Object)item.getDescription()) && item.getDescription() != null) {
                cell2.setCellValue(item.getDescription());
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Story Points"))) {
            cell2 = row.createCell((int)((short)columnPositionMap.get("Story Points").intValue()));
            if (PropertyValidator.isValid((Object)item.getStoryPoints()) && item.getStoryPoints() != null) {
                cell2.setCellValue(item.getStoryPoints().doubleValue());
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Due Date"))) {
            cell2 = row.createCell((int)((short)columnPositionMap.get("Due Date").intValue()));
            if (PropertyValidator.isValid((Object)item.getDueDate()) && item.getDueDate() != null) {
                cell2.setCellValue(this.dateExportFormate.format(item.getDueDate()));
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Created by"))) {
            cell2 = row.createCell((int)((short)columnPositionMap.get("Created by").intValue()));
            if (PropertyValidator.isValid((Object)item.getCreatedBy()) && item.getCreatedBy() != null) {
                cell2.setCellValue(item.getCreatedBy());
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Created on"))) {
            cell2 = row.createCell((int)((short)columnPositionMap.get("Created on").intValue()));
            if (PropertyValidator.isValid((Object)item.getCreatedOn()) && item.getCreatedOn() != null) {
                cell2.setCellValue(item.getCreatedOn().toString());
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Updated on"))) {
            cell2 = row.createCell((int)((short)columnPositionMap.get("Updated on").intValue()));
            if (PropertyValidator.isValid((Object)item.getUpdatedOn()) && item.getUpdatedOn() != null) {
                cell2.setCellValue(item.getUpdatedOn().toString());
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Updated by"))) {
            cell2 = row.createCell((int)((short)columnPositionMap.get("Updated by").intValue()));
            if (PropertyValidator.isValid((Object)item.getUpdatedBy()) && item.getUpdatedBy() != null) {
                cell2.setCellValue(item.getUpdatedBy());
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Card Type"))) {
            cell2 = row.createCell((int)((short)columnPositionMap.get("Card Type").intValue()));
            if (PropertyValidator.isValid((Object)item.getIssueType()) && item.getIssueType().getId() != null) {
                cell2.setCellValue(item.getIssueType().getTitle());
            } else if ("UserStory".equals(item.getType())) {
                cell2.setCellValue("");
            } else {
                cell2.setCellValue("Feature");
            }
        }
        if (PropertyValidator.isValid((Object)item.getJiraFieldTextByKey())) {
            keys = item.getJiraFieldTextByKey().keySet();
            for (String key : keys) {
                if (!headerMap.containsKey(key) || !columnPositionMap.containsKey(headerMap.get(key))) continue;
                cell = row.createCell((int)((short)columnPositionMap.get(headerMap.get(key)).intValue()));
                if (PropertyValidator.isValid(item.getJiraFieldTextByKey().get(key))) {
                    cell.setCellValue((String)item.getJiraFieldTextByKey().get(key));
                    continue;
                }
                cell.setCellValue("");
            }
        }
        if (PropertyValidator.isValid((Object)item.getFields())) {
            keys = item.getFields().keySet();
            for (String key : keys) {
                if (!headerMap.containsKey(key) || !columnPositionMap.containsKey(headerMap.get(key))) continue;
                cell = row.createCell((int)((short)columnPositionMap.get(headerMap.get(key)).intValue()));
                if (PropertyValidator.isValid(item.getFields().get(key))) {
                    String str;
                    if (item.getFields().get(key) instanceof String) {
                        String str2 = ((String)item.getFields().get(key)).replaceAll("<[^>]*>", "");
                        str2 = str2.replaceAll("&nbsp;", "\n");
                        cell.setCellValue(str2);
                        continue;
                    }
                    if (item.getFields().get(key) instanceof List) {
                        ArrayList objs = (ArrayList)item.getFields().get(key);
                        str = "";
                        for (int i = 0; i < objs.size(); ++i) {
                            Map obj = (Map)objs.get(i);
                            str = str + obj.get("title");
                            if (i >= objs.size() - 1) continue;
                            str = str + ", ";
                        }
                        cell.setCellValue(str);
                        continue;
                    }
                    if (!(item.getFields().get(key) instanceof Object)) continue;
                    HashMap obj = (HashMap)item.getFields().get(key);
                    if (PropertyValidator.isValid(obj.get("title"))) {
                        str = (String)obj.get("title");
                        cell.setCellValue(str);
                        continue;
                    }
                    if (PropertyValidator.isValid(obj.get("fullName"))) {
                        str = (String)obj.get("fullName");
                        cell.setCellValue(str);
                        continue;
                    }
                    if (!PropertyValidator.isValid(obj.get("name"))) continue;
                    str = (String)obj.get("name");
                    String url = "";
                    if (PropertyValidator.isValid(obj.get("url"))) {
                        url = (String)obj.get("url");
                    }
                    cell.setCellValue(str + " : " + url);
                    continue;
                }
                cell.setCellValue("");
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Iteration"))) {
            cell2 = row.createCell((int)((short)columnPositionMap.get("Iteration").intValue()));
            if (PropertyValidator.isValid((Object)item.getTfsIterationPath())) {
                cell2.setCellValue(item.getTfsIterationPath());
            } else {
                cell2.setCellValue("");
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Area Path"))) {
            cell2 = row.createCell((int)((short)columnPositionMap.get("Area Path").intValue()));
            if (PropertyValidator.isValid((Object)item.getTfsAreaPath())) {
                cell2.setCellValue(item.getTfsAreaPath());
            } else {
                cell2.setCellValue("");
            }
        }
    }

    public String writeExcel(String headers, List<Item> features, SessionBoard sessionBoard, boolean servicenow) throws IOException {
        String[] kendisFieldsHeader;
        String[] header = headers.split(",");
        Map headerMap = this.stringArrayToMap(header);
        if (!servicenow) {
            header = this.putJiraFieldsHeader(header, headerMap, sessionBoard);
        }
        if ((kendisFieldsHeader = this.putKendisFieldsHeader(header, headerMap)) != null) {
            header = kendisFieldsHeader;
        }
        String fileName = new Date().getTime() + ".xls";
        String filePath = this.env.getProperty("temp.file.location") + fileName;
        FileOutputStream file = new FileOutputStream(filePath);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet worksheet = workbook.createSheet("Kendis Worksheet");
        int position_index = 0;
        Map columnPositionMap = this.createWorkSheetHeaders(0, header, worksheet, workbook);
        if (PropertyValidator.isValid(features)) {
            for (Item userStory : features) {
                if (servicenow) {
                    if (!this.getRowServiceNow(headerMap, userStory, position_index, worksheet, columnPositionMap, sessionBoard)) continue;
                    ++position_index;
                    continue;
                }
                this.createItemWorksheetRow(headerMap, userStory, position_index, worksheet, columnPositionMap, sessionBoard);
                ++position_index;
            }
        }
        workbook.write((OutputStream)file);
        file.flush();
        file.close();
        return filePath;
    }

    public String writeDepsExcel(String headers, List<Map<String, String>> despDataMap) throws IOException {
        String[] header = headers.split(",");
        Map headerMap = this.stringArrayToMap(header);
        String fileName = new Date().getTime() + ".xls";
        String filePath = this.env.getProperty("temp.file.location") + fileName;
        FileOutputStream file = new FileOutputStream(filePath);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet worksheet = workbook.createSheet("Dependencies Worksheet");
        int position_index = 0;
        Map columnPositionMap = this.createWorkSheetHeaders(0, header, worksheet, workbook);
        if (PropertyValidator.isValid(despDataMap)) {
            for (Map<String, String> userStory : despDataMap) {
                this.createDepWorksheetRow(headerMap, userStory, position_index, worksheet, columnPositionMap, workbook);
                ++position_index;
            }
        }
        this.autoSizeColumns(worksheet, 0);
        workbook.write((OutputStream)file);
        file.flush();
        file.close();
        return filePath;
    }

    public Map<String, Integer> createWorkSheetHeaders(int rowIndex, String[] headers, HSSFSheet worksheet, HSSFWorkbook workbook) {
        HashMap<String, Integer> columnPositionMap = new HashMap<String, Integer>();
        int index = 0;
        HSSFRow row = worksheet.createRow((int)((short)rowIndex));
        for (String header : headers) {
            HSSFCellStyle cellStyle;
            HSSFCell cell;
            if (header.equals("effortLogs")) {
                cell = row.createCell((int)((short)index));
                cellStyle = workbook.createCellStyle();
                cellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                cell.setCellStyle(cellStyle);
                cell.setCellValue("Effort Spent");
                columnPositionMap.put("Effort Spent", index);
                cell = row.createCell((int)((short)(++index)));
                cellStyle = workbook.createCellStyle();
                cellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                cell.setCellStyle(cellStyle);
                cell.setCellValue("Effort Spent By");
                columnPositionMap.put("Effort Spent By", index);
                cell = row.createCell((int)((short)(++index)));
                cellStyle = workbook.createCellStyle();
                cellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                cell.setCellStyle(cellStyle);
                cell.setCellValue("Effort Spent Desc");
                columnPositionMap.put("Effort Spent Desc", index);
                ++index;
                continue;
            }
            cell = row.createCell((int)((short)index));
            cellStyle = workbook.createCellStyle();
            cellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(header);
            columnPositionMap.put(header, index);
            ++index;
        }
        return columnPositionMap;
    }

    private boolean getRowServiceNow(Map<String, String> headerMap, Item item, int position, HSSFSheet worksheet, Map<String, Integer> columnPositionMap, SessionBoard sessionBoard) {
        HashMap obj;
        Map obj2;
        String str;
        ArrayList objs;
        String str2;
        Set keys;
        HSSFRow row = null;
        HSSFCell cell = null;
        if (item.getParent() == null) {
            if (Boolean.TRUE.equals(item.getLastUpdatedValue("nochild"))) {
                row = worksheet.createRow((short)position + 1);
                cell = row.createCell((int)((short)columnPositionMap.get("Feature Key").intValue()));
                if (PropertyValidator.isValid((Object)item.getKendisKey())) {
                    cell.setCellValue(item.getKendisKey());
                } else if (PropertyValidator.isValid((Object)item.getJiraKey())) {
                    cell.setCellValue(item.getJiraKey());
                } else {
                    cell.setCellValue("");
                }
                cell = row.createCell((int)((short)columnPositionMap.get("Feature Link").intValue()));
                if (PropertyValidator.isValid((Object)item.getExternalReferenceURL())) {
                    cell.setCellValue(item.getExternalReferenceURL());
                }
                cell = row.createCell((int)((short)columnPositionMap.get("Feature Summary").intValue()));
                if (PropertyValidator.isValid((Object)item.getTitle())) {
                    cell.setCellValue(item.getTitle());
                }
                cell = row.createCell((int)((short)columnPositionMap.get("Feature Status").intValue()));
                if (PropertyValidator.isValid((Object)item.getStatus()) && item.getStatus().getTitle() != null) {
                    cell.setCellValue(item.getStatus().getTitle());
                }
                cell = row.createCell((int)((short)columnPositionMap.get("Wsjf Score").intValue()));
                if (PropertyValidator.isValid((Object)item.getScore()) && item.getScore() != null) {
                    cell.setCellValue(item.getScore().doubleValue());
                }
                cell = row.createCell((int)((short)columnPositionMap.get("Feature Due Date").intValue()));
                if (PropertyValidator.isValid((Object)item.getDueDate()) && item.getDueDate() != null) {
                    cell.setCellValue(this.dateExportFormate.format(item.getDueDate()));
                } else {
                    cell.setCellValue("");
                }
                if (PropertyValidator.isValid((Object)item.getFields())) {
                    keys = item.getFields().keySet();
                    for (String key : keys) {
                        if (!headerMap.containsKey(key) || !columnPositionMap.containsKey(headerMap.get(key))) continue;
                        cell = row.createCell((int)((short)columnPositionMap.get(headerMap.get(key)).intValue()));
                        if (PropertyValidator.isValid(item.getFields().get(key))) {
                            if (item.getFields().get(key) instanceof String) {
                                str2 = ((String)item.getFields().get(key)).replaceAll("<[^>]*>", "");
                                str2 = str2.replaceAll("&nbsp;", "\n");
                                cell.setCellValue(str2);
                                continue;
                            }
                            if (item.getFields().get(key) instanceof List) {
                                objs = (ArrayList)item.getFields().get(key);
                                str = "";
                                for (int i = 0; i < objs.size(); ++i) {
                                    obj2 = (Map)objs.get(i);
                                    str = str + obj2.get("title");
                                    if (i >= objs.size() - 1) continue;
                                    str = str + ", ";
                                }
                                cell.setCellValue(str);
                                continue;
                            }
                            if (!(item.getFields().get(key) instanceof Object)) continue;
                            obj = (HashMap)item.getFields().get(key);
                            if (PropertyValidator.isValid(obj.get("title"))) {
                                str = (String)obj.get("title");
                                cell.setCellValue(str);
                                continue;
                            }
                            if (PropertyValidator.isValid(obj.get("fullName"))) {
                                str = (String)obj.get("fullName");
                                cell.setCellValue(str);
                                continue;
                            }
                            if (!PropertyValidator.isValid(obj.get("name"))) continue;
                            str = (String)obj.get("name");
                            String url = "";
                            if (PropertyValidator.isValid(obj.get("url"))) {
                                url = (String)obj.get("url");
                            }
                            cell.setCellValue(str + " : " + url);
                            continue;
                        }
                        cell.setCellValue("");
                    }
                }
            }
        } else {
            row = worksheet.createRow((short)position + 1);
            cell = row.createCell((int)((short)columnPositionMap.get("Feature Key").intValue()));
            if (PropertyValidator.isValid((Object)item.getParent().getKendisKey())) {
                cell.setCellValue(item.getParent().getKendisKey());
            } else if (PropertyValidator.isValid((Object)item.getParent().getJiraKey())) {
                cell.setCellValue(item.getParent().getJiraKey());
            } else {
                cell.setCellValue("");
            }
            cell = row.createCell((int)((short)columnPositionMap.get("Feature Link").intValue()));
            if (PropertyValidator.isValid((Object)item.getParent().getExternalReferenceURL())) {
                cell.setCellValue(item.getParent().getExternalReferenceURL());
            }
            cell = row.createCell((int)((short)columnPositionMap.get("Feature Summary").intValue()));
            if (PropertyValidator.isValid((Object)item.getParent().getTitle())) {
                cell.setCellValue(item.getParent().getTitle());
            }
            cell = row.createCell((int)((short)columnPositionMap.get("Feature Status").intValue()));
            if (PropertyValidator.isValid((Object)item.getParent().getStatus()) && item.getParent().getStatus().getTitle() != null) {
                cell.setCellValue(item.getParent().getStatus().getTitle());
            }
            cell = row.createCell((int)((short)columnPositionMap.get("Feature Due Date").intValue()));
            if (PropertyValidator.isValid((Object)item.getParent().getDueDate()) && item.getParent().getDueDate() != null) {
                cell.setCellValue(this.dateExportFormate.format(item.getParent().getDueDate()));
            } else {
                cell.setCellValue("");
            }
            cell = row.createCell((int)((short)columnPositionMap.get("Story Key").intValue()));
            if (PropertyValidator.isValid((Object)item.getKendisKey())) {
                cell.setCellValue(item.getKendisKey());
            } else if (PropertyValidator.isValid((Object)item.getJiraKey())) {
                cell.setCellValue(item.getJiraKey());
            } else {
                cell.setCellValue("");
            }
            cell = row.createCell((int)((short)columnPositionMap.get("Story Link").intValue()));
            if (PropertyValidator.isValid((Object)item.getExternalReferenceURL())) {
                cell.setCellValue(item.getExternalReferenceURL());
            }
            cell = row.createCell((int)((short)columnPositionMap.get("Story Summary").intValue()));
            if (PropertyValidator.isValid((Object)item.getTitle())) {
                cell.setCellValue(item.getTitle());
            }
            cell = row.createCell((int)((short)columnPositionMap.get("Story Status").intValue()));
            if (PropertyValidator.isValid((Object)item.getStatus()) && item.getStatus().getTitle() != null) {
                cell.setCellValue(item.getStatus().getTitle());
            }
            cell = row.createCell((int)((short)columnPositionMap.get("Story Points").intValue()));
            if (PropertyValidator.isValid((Object)item.getStoryPoints()) && item.getStoryPoints() != null) {
                cell.setCellValue(item.getStoryPoints().doubleValue());
            }
            cell = row.createCell((int)((short)columnPositionMap.get("Wsjf Score").intValue()));
            if (PropertyValidator.isValid((Object)item.getScore()) && item.getScore() != null) {
                cell.setCellValue(item.getScore().doubleValue());
            }
            if (PropertyValidator.isValid((Object)item.getFields())) {
                keys = item.getFields().keySet();
                for (String key : keys) {
                    if (!headerMap.containsKey(key) || !columnPositionMap.containsKey(headerMap.get(key))) continue;
                    cell = row.createCell((int)((short)columnPositionMap.get(headerMap.get(key)).intValue()));
                    if (PropertyValidator.isValid(item.getFields().get(key))) {
                        if (item.getFields().get(key) instanceof String) {
                            str2 = ((String)item.getFields().get(key)).replaceAll("<[^>]*>", "");
                            str2 = str2.replaceAll("&nbsp;", "\n");
                            cell.setCellValue(str2);
                            continue;
                        }
                        if (item.getFields().get(key) instanceof List) {
                            objs = (ArrayList)item.getFields().get(key);
                            str = "";
                            for (int i = 0; i < objs.size(); ++i) {
                                obj2 = (Map)objs.get(i);
                                str = str + obj2.get("title");
                                if (i >= objs.size() - 1) continue;
                                str = str + ", ";
                            }
                            cell.setCellValue(str);
                            continue;
                        }
                        if (!(item.getFields().get(key) instanceof Object)) continue;
                        obj = (HashMap)item.getFields().get(key);
                        if (PropertyValidator.isValid(obj.get("title"))) {
                            str = (String)obj.get("title");
                            cell.setCellValue(str);
                            continue;
                        }
                        if (PropertyValidator.isValid(obj.get("fullName"))) {
                            str = (String)obj.get("fullName");
                            cell.setCellValue(str);
                            continue;
                        }
                        if (!PropertyValidator.isValid(obj.get("name"))) continue;
                        str = (String)obj.get("name");
                        String url = "";
                        if (PropertyValidator.isValid(obj.get("url"))) {
                            url = (String)obj.get("url");
                        }
                        cell.setCellValue(str + " : " + url);
                        continue;
                    }
                    cell.setCellValue("");
                }
            }
        }
        if (row != null && PropertyValidator.isValid((Collection)item.getTeamContainers())) {
            HashSet<String> sprintTitles = new HashSet<String>();
            HashSet<String> teamTitles = new HashSet<String>();
            for (TeamContainer teamCont : item.getTeamContainers()) {
                if (teamCont == null || teamCont.getContainer() == null || teamCont.getTeam() == null) continue;
                sprintTitles.add(teamCont.getContainer().getTitle());
                teamTitles.add(teamCont.getTeam().getTitle());
            }
            cell = row.createCell((int)((short)columnPositionMap.get("Sprint Name").intValue()));
            cell.setCellValue(sprintTitles.stream().collect(Collectors.joining(",")));
            cell = row.createCell((int)((short)columnPositionMap.get("Team Name").intValue()));
            cell.setCellValue(teamTitles.stream().collect(Collectors.joining(",")));
        }
        return row != null;
    }

    public void createDepWorksheetRow(Map<String, String> headerMap, Map<String, String> rowData, int position, HSSFSheet worksheet, Map<String, Integer> columnPositionMap, HSSFWorkbook workbook) {
        int endIndex;
        int startIndex;
        HSSFFont my_font_2;
        HSSFFont my_font_1;
        HSSFRichTextString rts;
        HSSFCell cell;
        HSSFRow row = worksheet.createRow((short)position + 1);
        if (PropertyValidator.isValid((Object)headerMap.get("#"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("#").intValue()));
            cell.setCellValue((double)(position + 1));
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Id"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("Id").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("Id")) && rowData.get("Id") != null) {
                cell.setCellValue(rowData.get("Id"));
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("From"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("From").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("From")) && rowData.get("From") != null) {
                cell.setCellValue(rowData.get("From"));
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("To"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("To").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("To")) && rowData.get("To") != null) {
                cell.setCellValue(rowData.get("To"));
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("From Item"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("From Item").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("From Item")) && rowData.get("From Item") != null) {
                rts = new HSSFRichTextString(rowData.get("From Item"));
                my_font_1 = workbook.createFont();
                my_font_2 = workbook.createFont();
                if (PropertyValidator.isValid((Object)rowData.get("sSprint"))) {
                    my_font_1.setColor(IndexedColors.GREEN.index);
                    my_font_1.setBold(true);
                    startIndex = rowData.get("From Item").indexOf(rowData.get("sSprint"));
                    endIndex = startIndex + rowData.get("sSprint").length();
                    rts.applyFont(startIndex, endIndex, (Font)my_font_1);
                }
                if (PropertyValidator.isValid((Object)rowData.get("sTeam"))) {
                    my_font_1.setColor(IndexedColors.GREEN.index);
                    my_font_1.setBold(true);
                    startIndex = rowData.get("From Item").indexOf(rowData.get("sTeam"));
                    endIndex = startIndex + rowData.get("sTeam").length();
                    rts.applyFont(startIndex, endIndex, (Font)my_font_1);
                }
                if (PropertyValidator.isValid((Object)rowData.get("sFeatureKey"))) {
                    my_font_2.setColor(IndexedColors.BLUE.index);
                    my_font_2.setBold(true);
                    startIndex = rowData.get("From Item").indexOf(rowData.get("sFeatureKey"));
                    endIndex = startIndex + rowData.get("sFeatureKey").length();
                    rts.applyFont(startIndex, endIndex, (Font)my_font_2);
                }
                cell.setCellValue((RichTextString)rts);
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("To Item"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("To Item").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("To Item")) && rowData.get("To Item") != null) {
                rts = new HSSFRichTextString(rowData.get("To Item"));
                my_font_1 = workbook.createFont();
                my_font_2 = workbook.createFont();
                if (PropertyValidator.isValid((Object)rowData.get("tSprint"))) {
                    my_font_1.setColor(IndexedColors.GREEN.index);
                    my_font_1.setBold(true);
                    startIndex = rowData.get("To Item").indexOf(rowData.get("tSprint"));
                    endIndex = startIndex + rowData.get("tSprint").length();
                    rts.applyFont(startIndex, endIndex, (Font)my_font_1);
                }
                if (PropertyValidator.isValid((Object)rowData.get("tTeam"))) {
                    my_font_1.setColor(IndexedColors.GREEN.index);
                    my_font_1.setBold(true);
                    startIndex = rowData.get("To Item").indexOf(rowData.get("tTeam"));
                    endIndex = startIndex + rowData.get("tTeam").length();
                    rts.applyFont(startIndex, endIndex, (Font)my_font_1);
                }
                if (PropertyValidator.isValid((Object)rowData.get("tFeatureKey"))) {
                    my_font_2.setColor(IndexedColors.BLUE.index);
                    my_font_2.setBold(true);
                    startIndex = rowData.get("To Item").indexOf(rowData.get("tFeatureKey"));
                    endIndex = startIndex + rowData.get("tFeatureKey").length();
                    rts.applyFont(startIndex, endIndex, (Font)my_font_2);
                }
                cell.setCellValue((RichTextString)rts);
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("From Item Status"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("From Item Status").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("Link Type")) && rowData.get("From Item Status") != null) {
                cell.setCellValue(rowData.get("From Item Status"));
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("To Item Status"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("To Item Status").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("To Item Status")) && rowData.get("To Item Status") != null) {
                cell.setCellValue(rowData.get("To Item Status"));
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Link Type"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("Link Type").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("Link Type")) && rowData.get("Link Type") != null) {
                cell.setCellValue(rowData.get("Link Type"));
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Status")) && PropertyValidator.isValid((Object)rowData.get("Status")) && rowData.get("Status") != null) {
            cell = row.createCell((int)((short)columnPositionMap.get("Status").intValue()));
            if ("Resolved".equalsIgnoreCase(rowData.get("Status"))) {
                HSSFCellStyle cellStyle = workbook.createCellStyle();
                cellStyle.setFillForegroundColor(HSSFColor.LIGHT_GREEN.index);
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                cell.setCellStyle(cellStyle);
            }
            cell.setCellValue(rowData.get("Status"));
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Summary"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("Summary").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("Summary")) && rowData.get("Summary") != null) {
                cell.setCellValue(rowData.get("Summary"));
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Description"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("Description").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("Description")) && rowData.get("Description") != null) {
                cell.setCellValue(rowData.get("Description"));
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Raised On"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("Raised On").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("Raised On")) && rowData.get("Raised On") != null) {
                cell.setCellValue(rowData.get("Raised On"));
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Target Resolution Date"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("Target Resolution Date").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("Target Resolution Date")) && rowData.get("Target Resolution Date") != null) {
                cell.setCellValue(rowData.get("Target Resolution Date"));
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Reporter"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("Reporter").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("Reporter")) && rowData.get("Reporter") != null) {
                cell.setCellValue(rowData.get("Reporter"));
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Responsible"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("Responsible").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("Responsible")) && rowData.get("Responsible") != null) {
                cell.setCellValue(rowData.get("Responsible"));
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("description"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("description").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("description")) && rowData.get("description") != null) {
                cell.setCellValue(rowData.get("description"));
            }
        }
    }

    public void createWsjfWorksheetRow(Map<String, String> headerMap, Map<String, String> rowData, int position, HSSFSheet worksheet, Map<String, Integer> columnPositionMap, HSSFWorkbook workbook) {
        HSSFCell cell;
        HSSFRow row = worksheet.createRow((short)position + 1);
        if (PropertyValidator.isValid((Object)headerMap.get("#"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("#").intValue()));
            cell.setCellValue((double)(position + 1));
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Feature ID"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("Feature ID").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("Feature ID")) && rowData.get("Feature ID") != null) {
                cell.setCellValue(rowData.get("Feature ID"));
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Title"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("Title").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("Title")) && rowData.get("Title") != null) {
                cell.setCellValue(rowData.get("Title"));
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Estimate"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("Estimate").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("Estimate")) && rowData.get("Estimate") != null) {
                cell.setCellValue(rowData.get("Estimate"));
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Status"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("Status").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("Status")) && rowData.get("Status") != null) {
                cell.setCellValue(rowData.get("Status"));
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Card Type"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("Card Type").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("Card Type")) && rowData.get("Card Type") != null) {
                cell.setCellValue(rowData.get("Card Type"));
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("User-Business Value"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("User-Business Value").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("User-Business Value")) && rowData.get("User-Business Value") != null) {
                cell.setCellValue(rowData.get("User-Business Value"));
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Time Criticality"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("Time Criticality").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("Time Criticality")) && rowData.get("Time Criticality") != null) {
                cell.setCellValue(rowData.get("Time Criticality"));
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Risk Reduction(RR)/Opportunity Enablement(OE)"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("Risk Reduction(RR)/Opportunity Enablement(OE)").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("Risk Reduction(RR)/Opportunity Enablement(OE)")) && rowData.get("Risk Reduction(RR)/Opportunity Enablement(OE)") != null) {
                cell.setCellValue(rowData.get("Risk Reduction(RR)/Opportunity Enablement(OE)"));
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("Job Size"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("Job Size").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("Job Size")) && rowData.get("Job Size") != null) {
                cell.setCellValue(rowData.get("Job Size"));
            }
        }
        if (PropertyValidator.isValid((Object)headerMap.get("WSJF"))) {
            cell = row.createCell((int)((short)columnPositionMap.get("WSJF").intValue()));
            if (PropertyValidator.isValid((Object)rowData.get("WSJF")) && rowData.get("WSJF") != null) {
                cell.setCellValue(rowData.get("WSJF"));
            }
        }
    }

    private void autoSizeColumns(HSSFSheet sheet, int headerRowIndex) {
        try {
            Iterator cellIterator;
            HSSFRow row;
            if (sheet.getPhysicalNumberOfRows() > headerRowIndex && (row = sheet.getRow(headerRowIndex)) != null && (cellIterator = row.cellIterator()) != null) {
                while (cellIterator.hasNext()) {
                    Cell cell = (Cell)cellIterator.next();
                    int columnIndex = cell.getColumnIndex();
                    sheet.autoSizeColumn(columnIndex);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeReportsCSVFile(List<HashMap<String, Object>> features, List<Item> child, Map<String, HashMap<String, Object>> infoMap, Report report) {
        CsvMapWriter writer = null;
        try {
            String fileName = new Date().getTime() + ".csv";
            String filePath = this.env.getProperty("temp.file.location") + fileName;
            FileOutputStream os = new FileOutputStream(filePath);
            writer = new CsvMapWriter((Writer)new OutputStreamWriter((OutputStream)os, "UTF-8"), CsvPreference.EXCEL_PREFERENCE);
            String[] completeHeader = new String[report.getSelectedColumns().size() * report.getComparisonStateKeys().size()];
            int index = 0;
            for (int j = 0; j < report.getSelectedColumns().size(); ++j) {
                for (int k = 0; k < report.getComparisonStateKeys().size(); ++k) {
                    String headerKey = "";
                    if (report.getType() == 0) {
                        headerKey = (String)((HashMap)report.getSelectedColumns().get(j)).get("header");
                    } else if (((String)((HashMap)report.getSelectedColumns().get(j)).get("value")).equals("itemType") || ((String)((HashMap)report.getSelectedColumns().get(j)).get("value")).equals("jiraKey") || ((String)((HashMap)report.getSelectedColumns().get(j)).get("value")).equals("parent")) {
                        if (k != 0) continue;
                        headerKey = (String)((HashMap)report.getSelectedColumns().get(j)).get("header");
                    } else {
                        headerKey = (String)((HashMap)report.getSelectedColumns().get(j)).get("header") + " (" + ((State)report.getComparisonStates().get(k)).getTitle() + ")";
                    }
                    completeHeader[index] = headerKey;
                    ++index;
                }
            }
            writer.writeHeader(completeHeader);
            if (PropertyValidator.isValid(features)) {
                for (HashMap<String, Object> entry : features) {
                    HashMap itemStates = (HashMap)entry.get("states");
                    HashMap<String, String> rowData = new HashMap<String, String>();
                    String parentKey = "";
                    for (int i = 0; i < report.getComparisonStateKeys().size(); ++i) {
                        Item item = (Item)itemStates.get(report.getComparisonStateKeys().get(i));
                        if (item == null) continue;
                        this.putInfoInMap(item, infoMap);
                    }
                    for (int j = 0; j < report.getSelectedColumns().size(); ++j) {
                        for (int k = 0; k < report.getComparisonStateKeys().size(); ++k) {
                            Item item = (Item)itemStates.get(report.getComparisonStateKeys().get(k));
                            String headerKey = "";
                            if (report.getType() == 0) {
                                headerKey = (String)((HashMap)report.getSelectedColumns().get(j)).get("header");
                            } else if (((String)((HashMap)report.getSelectedColumns().get(j)).get("value")).equals("itemType") || ((String)((HashMap)report.getSelectedColumns().get(j)).get("value")).equals("jiraKey") || ((String)((HashMap)report.getSelectedColumns().get(j)).get("value")).equals("parent")) {
                                if (k != 0) continue;
                                headerKey = (String)((HashMap)report.getSelectedColumns().get(j)).get("header");
                            } else {
                                headerKey = (String)((HashMap)report.getSelectedColumns().get(j)).get("header") + " (" + ((State)report.getComparisonStates().get(k)).getTitle() + ")";
                            }
                            if (item != null) {
                                Object value = item.valueByKey((String)((HashMap)report.getSelectedColumns().get(j)).get("value"), infoMap);
                                if (PropertyValidator.isValid((Object)value)) {
                                    if (((String)((HashMap)report.getSelectedColumns().get(j)).get("header")).equals("Key")) {
                                        parentKey = value.toString();
                                    }
                                    rowData.put(headerKey, value.toString());
                                    continue;
                                }
                                rowData.put(headerKey, "");
                                continue;
                            }
                            rowData.put(headerKey, "");
                        }
                    }
                    try {
                        writer.write(rowData, completeHeader);
                        ArrayList subItems = this.getSubItem(entry, child, infoMap, report);
                        for (HashMap sEntry : subItems) {
                            itemStates = (HashMap)sEntry.get("states");
                            rowData = new HashMap();
                            for (int i = 0; i < report.getComparisonStateKeys().size(); ++i) {
                                Item item = (Item)itemStates.get(report.getComparisonStateKeys().get(i));
                                if (item == null) continue;
                                this.putInfoInMap(item, infoMap);
                            }
                            for (int j = 0; j < report.getSelectedColumns().size(); ++j) {
                                for (int k = 0; k < report.getComparisonStateKeys().size(); ++k) {
                                    Item item = (Item)itemStates.get(report.getComparisonStateKeys().get(k));
                                    String colomnKey = (String)((HashMap)report.getSelectedColumns().get(j)).get("value");
                                    String headerKey = "";
                                    if (report.getType() == 0) {
                                        headerKey = (String)((HashMap)report.getSelectedColumns().get(j)).get("header");
                                    } else if (((String)((HashMap)report.getSelectedColumns().get(j)).get("value")).equals("itemType") || ((String)((HashMap)report.getSelectedColumns().get(j)).get("value")).equals("jiraKey") || ((String)((HashMap)report.getSelectedColumns().get(j)).get("value")).equals("parent")) {
                                        if (k != 0) continue;
                                        headerKey = (String)((HashMap)report.getSelectedColumns().get(j)).get("header");
                                    } else {
                                        headerKey = (String)((HashMap)report.getSelectedColumns().get(j)).get("header") + " (" + ((State)report.getComparisonStates().get(k)).getTitle() + ")";
                                    }
                                    if (item != null) {
                                        if (colomnKey.equals("parent")) {
                                            rowData.put(headerKey, parentKey);
                                        } else {
                                            Object value = item.valueByKey((String)((HashMap)report.getSelectedColumns().get(j)).get("value"), infoMap);
                                            if (PropertyValidator.isValid((Object)value)) {
                                                rowData.put((String)((HashMap)report.getSelectedColumns().get(j)).get("header") + " " + (k + 1), value.toString());
                                            } else {
                                                rowData.put((String)((HashMap)report.getSelectedColumns().get(j)).get("header") + " " + (k + 1), "");
                                                rowData.put(headerKey, value.toString());
                                            }
                                        }
                                    }
                                    writer.write(rowData, completeHeader);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                }
            }
            writer.close();
            os.close();
            String string = filePath;
            return string;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return null;
    }

    public String writeReportExcelFile(List<HashMap<String, Object>> features, List<Item> child, Map<String, HashMap<String, Object>> infoMap, Report report) throws IOException {
        String fileName = new Date().getTime() + ".xls";
        String filePath = this.env.getProperty("temp.file.location") + fileName;
        FileOutputStream file = new FileOutputStream(filePath);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet worksheet = workbook.createSheet("Kendis Worksheet");
        String[] completeHeader = new String[report.getSelectedColumns().size() * 2];
        int rowRndex = 0;
        HSSFRow row = worksheet.createRow((int)((short)rowRndex++));
        int index = 0;
        for (int j = 0; j < report.getSelectedColumns().size(); ++j) {
            completeHeader[j] = (String)((HashMap)report.getSelectedColumns().get(j)).get("header");
            worksheet.setColumnWidth(j, 6400);
            for (int k = 0; k < report.getComparisonStateKeys().size(); ++k) {
                if (report.getType() == 0) {
                    completeHeader[index] = (String)((HashMap)report.getSelectedColumns().get(j)).get("header");
                } else if (((String)((HashMap)report.getSelectedColumns().get(j)).get("value")).equals("itemType") || ((String)((HashMap)report.getSelectedColumns().get(j)).get("value")).equals("jiraKey") || ((String)((HashMap)report.getSelectedColumns().get(j)).get("value")).equals("parent")) {
                    if (k != 0) continue;
                    completeHeader[index] = (String)((HashMap)report.getSelectedColumns().get(j)).get("header");
                } else {
                    completeHeader[index] = (String)((HashMap)report.getSelectedColumns().get(j)).get("header") + " (" + ((State)report.getComparisonStates().get(k)).getTitle() + ")";
                }
                HSSFFont fontBold = workbook.createFont();
                fontBold.setBold(true);
                HSSFCell cell = row.createCell((int)((short)index));
                HSSFCellStyle cellStyle = workbook.createCellStyle();
                cellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                cellStyle.setFont(fontBold);
                cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.index);
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                cell.setCellStyle(cellStyle);
                cell.setCellValue(completeHeader[index]);
                ++index;
            }
        }
        if (PropertyValidator.isValid(features)) {
            HSSFCellStyle cellStyle = null;
            ArrayList<HSSFCellStyle> cellStyleList = new ArrayList<HSSFCellStyle>();
            for (HashMap<String, Object> entry : features) {
                HashMap itemStates = (HashMap)entry.get("states");
                HashMap rowData = new HashMap();
                HSSFRow rows = worksheet.createRow((int)((short)rowRndex++));
                String parentKey = "";
                for (int i = 0; i < report.getComparisonStateKeys().size(); ++i) {
                    Item item = (Item)itemStates.get(report.getComparisonStateKeys().get(i));
                    if (item == null) continue;
                    this.putInfoInMap(item, infoMap);
                }
                index = 0;
                for (int j = 0; j < report.getSelectedColumns().size(); ++j) {
                    for (int k = 0; k < report.getComparisonStateKeys().size(); ++k) {
                        if (k == 1 && (((String)((HashMap)report.getSelectedColumns().get(j)).get("value")).equals("itemType") || ((String)((HashMap)report.getSelectedColumns().get(j)).get("value")).equals("jiraKey") || ((String)((HashMap)report.getSelectedColumns().get(j)).get("value")).equals("parent"))) continue;
                        Item item = (Item)itemStates.get(report.getComparisonStateKeys().get(k));
                        HSSFCell cell = rows.createCell((int)((short)index));
                        if (cellStyleList.size() == 0) {
                            cellStyle = workbook.createCellStyle();
                        }
                        cellStyle.setWrapText(true);
                        cell.setCellStyle(cellStyle);
                        if (item != null) {
                            Object value = item.valueByKey((String)((HashMap)report.getSelectedColumns().get(j)).get("value"), infoMap);
                            if (PropertyValidator.isValid((Object)value)) {
                                if (((String)((HashMap)report.getSelectedColumns().get(j)).get("header")).equals("Key")) {
                                    parentKey = value.toString();
                                }
                                cell.setCellValue(value.toString());
                            } else {
                                cell.setCellValue("");
                            }
                        } else {
                            cell.setCellValue("");
                        }
                        ++index;
                    }
                }
                ArrayList subItems = this.getSubItem(entry, child, infoMap, report);
                for (HashMap sEntry : subItems) {
                    itemStates = (HashMap)sEntry.get("states");
                    rowData = new HashMap();
                    rows = worksheet.createRow((int)((short)rowRndex++));
                    for (int i = 0; i < report.getComparisonStateKeys().size(); ++i) {
                        Item item = (Item)itemStates.get(report.getComparisonStateKeys().get(i));
                        if (item == null) continue;
                        this.putInfoInMap(item, infoMap);
                    }
                    index = 0;
                    for (int j = 0; j < report.getSelectedColumns().size(); ++j) {
                        for (int k = 0; k < report.getComparisonStateKeys().size(); ++k) {
                            if (k == 1 && (((String)((HashMap)report.getSelectedColumns().get(j)).get("value")).equals("itemType") || ((String)((HashMap)report.getSelectedColumns().get(j)).get("value")).equals("jiraKey") || ((String)((HashMap)report.getSelectedColumns().get(j)).get("value")).equals("parent"))) continue;
                            Item item = (Item)itemStates.get(report.getComparisonStateKeys().get(k));
                            String colomnKey = (String)((HashMap)report.getSelectedColumns().get(j)).get("value");
                            HSSFCell cell = rows.createCell((int)((short)index));
                            if (cellStyleList.size() == 0) {
                                cellStyle = workbook.createCellStyle();
                            }
                            cellStyleList.add(cellStyle);
                            cellStyle.setWrapText(true);
                            cell.setCellStyle(cellStyle);
                            if (item != null) {
                                if (colomnKey.equals("parent")) {
                                    cell.setCellValue(parentKey);
                                } else {
                                    Object value = item.valueByKey((String)((HashMap)report.getSelectedColumns().get(j)).get("value"), infoMap);
                                    if (PropertyValidator.isValid((Object)value)) {
                                        cell.setCellValue(value.toString());
                                    } else {
                                        cell.setCellValue("");
                                    }
                                }
                            } else {
                                cell.setCellValue("");
                            }
                            ++index;
                        }
                    }
                }
            }
        }
        workbook.write((OutputStream)file);
        file.flush();
        file.close();
        workbook.close();
        return filePath;
    }

    private void putInfoInMap(Item item, Map<String, HashMap<String, Object>> infoMap) {
        HashMap<String, Object> info;
        StringBuilder teams = new StringBuilder();
        StringBuilder sprints = new StringBuilder();
        StringBuilder teamLabels = new StringBuilder();
        StringBuilder sprintLabels = new StringBuilder();
        if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            for (int i = 0; i < item.getTeamContainers().size(); ++i) {
                if (map.get(((TeamContainer)item.getTeamContainers().get(i)).getTeam().getId()) == null) {
                    map.put(((TeamContainer)item.getTeamContainers().get(i)).getTeam().getId(), true);
                    if (i > 0) {
                        teams.append(", ");
                        teamLabels.append(", ");
                    }
                    teams.append(((TeamContainer)item.getTeamContainers().get(i)).getTeam().getTitle());
                    teamLabels.append(((TeamContainer)item.getTeamContainers().get(i)).getTeam().getLabel());
                }
                if (map.get(((TeamContainer)item.getTeamContainers().get(i)).getContainer().getId()) != null) continue;
                if (i > 0) {
                    sprints.append(", ");
                    sprintLabels.append(", ");
                }
                map.put(((TeamContainer)item.getTeamContainers().get(i)).getContainer().getId(), true);
                sprints.append(((TeamContainer)item.getTeamContainers().get(i)).getContainer().getTitle());
                sprintLabels.append(((TeamContainer)item.getTeamContainers().get(i)).getContainer().getLabel());
            }
        }
        if ((info = infoMap.get(item.getId())) == null) {
            info = new HashMap();
        }
        info.put("teams", teams.toString());
        info.put("teamsLabel", teamLabels.toString());
        info.put("sprints", sprints.toString());
        info.put("sprintsLabel", sprintLabels.toString());
        infoMap.put(item.getId(), info);
    }

    private ArrayList<HashMap<String, Object>> getSubItem(HashMap<String, Object> entry, List<Item> child, Map<String, HashMap<String, Object>> infoMap, Report report) {
        HashMap itemStates = (HashMap)entry.get("states");
        HashMap<String, HashMap> tempMap = new HashMap<String, HashMap>();
        ArrayList<HashMap<String, Object>> subItems = new ArrayList<HashMap<String, Object>>();
        for (int k = 0; k < report.getComparisonStateKeys().size(); ++k) {
            String stateKey = (String)report.getComparisonStateKeys().get(k);
            Item item = (Item)itemStates.get(stateKey);
            if (item == null || infoMap.get(item.getId()) == null || infoMap.get(item.getId()).get("childIndexes") == null) continue;
            List childIndex = (List)infoMap.get(item.getId()).get("childIndexes");
            for (Integer ind : childIndex) {
                HashMap<String, Item> states;
                HashMap mapEntry;
                String uniqueId;
                Item subItem = child.get(ind);
                if (report.getType() == 0) {
                    uniqueId = subItem.getId();
                } else {
                    uniqueId = subItem.getOriginItemId();
                    if (uniqueId == null) {
                        uniqueId = subItem.getId();
                    }
                }
                if (tempMap.get(uniqueId) == null) {
                    mapEntry = new HashMap();
                    mapEntry.put("id", subItem.getId());
                    if (item.getJiraId() != null) {
                        mapEntry.put("jiraId", subItem.getJiraId());
                    }
                    states = new HashMap<String, Item>();
                    states.put(stateKey, subItem);
                    mapEntry.put("states", states);
                    subItems.add(mapEntry);
                    tempMap.put(uniqueId, mapEntry);
                    continue;
                }
                mapEntry = (HashMap)tempMap.get(uniqueId);
                states = (HashMap<String, Item>)mapEntry.get("states");
                states.put(stateKey, subItem);
            }
        }
        return subItems;
    }

    public String exportObjectiveData(int exportAs, SessionBoard sessionBoard, HashMap<String, Object> map, List<HashMap<String, String>> columns) {
        if (exportAs == 0) {
            return this.writeObjectCSVFile(sessionBoard, map, columns);
        }
        try {
            String fileName = new Date().getTime() + ".xls";
            String filePath = this.env.getProperty("temp.file.location") + fileName;
            FileOutputStream file = new FileOutputStream(filePath);
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet worksheet = workbook.createSheet("Kendis Worksheet");
            this.writeObjectiveExcelFile(0, worksheet, workbook, sessionBoard, map, columns);
            workbook.write((OutputStream)file);
            file.flush();
            file.close();
            return filePath;
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeObjectCSVFile(SessionBoard sessionBoard, HashMap<String, Object> map, List<HashMap<String, String>> columns) {
        CsvMapWriter writer = null;
        try {
            String fileName = new Date().getTime() + ".csv";
            String filePath = this.env.getProperty("temp.file.location") + fileName;
            FileOutputStream os = new FileOutputStream(filePath);
            writer = new CsvMapWriter((Writer)new OutputStreamWriter((OutputStream)os, "UTF-8"), CsvPreference.EXCEL_PREFERENCE);
            String[] completeHeader = new String[columns.size()];
            for (int j = 0; j < columns.size(); ++j) {
                completeHeader[j] = columns.get(j).get("header");
            }
            writer.writeHeader(completeHeader);
            if (PropertyValidator.isValid((Collection)sessionBoard.getObjectiveIds())) {
                for (String oid : sessionBoard.getObjectiveIds()) {
                    List ovalues = ((Objective)sessionBoard.getObjectivesMap().get(oid)).getValues();
                    if (!PropertyValidator.isValid((Collection)ovalues)) continue;
                    for (int j = 0; j < ovalues.size(); ++j) {
                        HashMap<String, Object> rowData = new HashMap<String, Object>();
                        for (int c = 0; c < columns.size(); ++c) {
                            rowData.put(columns.get(c).get("header"), ((ObjectiveValue)ovalues.get(j)).valueByKey(columns.get(c).get("value"), (Objective)sessionBoard.getObjectivesMap().get(oid), map));
                        }
                        writer.write(rowData, completeHeader);
                    }
                }
            }
            writer.close();
            os.close();
            String string = filePath;
            return string;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return null;
    }

    public int writeObjectiveExcelFile(int rowRndex, HSSFSheet worksheet, HSSFWorkbook workbook, SessionBoard sessionBoard, HashMap<String, Object> map, List<HashMap<String, String>> columns) throws IOException {
        try {
            String[] completeHeader = new String[columns.size()];
            int startPoint = rowRndex;
            HSSFRow row = worksheet.createRow((int)((short)rowRndex++));
            for (int j = 0; j < columns.size(); ++j) {
                completeHeader[j] = columns.get(j).get("header");
                HSSFCell cell = row.createCell((int)((short)j));
                HSSFCellStyle cellStyle = workbook.createCellStyle();
                cellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                cell.setCellStyle(cellStyle);
                cell.setCellValue(completeHeader[j]);
            }
            int ovCounts = 0;
            if (PropertyValidator.isValid((Collection)sessionBoard.getObjectiveIds())) {
                for (String oid : sessionBoard.getObjectiveIds()) {
                    List ovalues = ((Objective)sessionBoard.getObjectivesMap().get(oid)).getValues();
                    if (!PropertyValidator.isValid((Collection)ovalues)) continue;
                    for (int j = 0; j < ovalues.size(); ++j) {
                        if (Boolean.TRUE.equals(sessionBoard.getIsResyncing())) {
                            String value;
                            if (sessionBoard.getIsResyncing().booleanValue()) {
                                boolean skip = true;
                                if (PropertyValidator.isValid(ovalues.get(j)) && PropertyValidator.isValid((Collection)((ObjectiveValue)ovalues.get(j)).getItemIds())) {
                                    for (int i = 0; i < ((ObjectiveValue)ovalues.get(j)).getItemIds().size(); ++i) {
                                        if (!map.containsKey(((ObjectiveValue)ovalues.get(j)).getItemIds().get(i))) continue;
                                        skip = false;
                                        break;
                                    }
                                }
                                if (skip) continue;
                            }
                            if (!PropertyValidator.isValid((Object)(value = ((ObjectiveValue)ovalues.get(j)).valueByKey("links", (Objective)sessionBoard.getObjectivesMap().get(oid), map).toString()))) continue;
                        }
                        ++ovCounts;
                        HSSFRow rows = worksheet.createRow((int)((short)rowRndex++));
                        for (int c = 0; c < columns.size(); ++c) {
                            HSSFCell cell = rows.createCell((int)((short)c));
                            cell.setCellValue(((ObjectiveValue)ovalues.get(j)).valueByKey(columns.get(c).get("value"), (Objective)sessionBoard.getObjectivesMap().get(oid), map).toString());
                        }
                    }
                }
            }
            if (Boolean.TRUE.equals(sessionBoard.getIsResyncing()) && ovCounts == 0) {
                worksheet.removeRow((Row)worksheet.getRow(rowRndex - 1));
                worksheet.removeRow((Row)worksheet.getRow(rowRndex - 2));
                rowRndex = startPoint;
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return rowRndex;
    }

    public int writeItemLogFile(int colorIndex, String title, HSSFWorkbook workbook, HSSFSheet worksheet, List<Map<String, String>> completeHeader, Collection<HashMap<String, ? super Object>> list, List<String> errors, int excelRowIndex) throws IOException {
        HSSFRow rows;
        HSSFRow row;
        HSSFRow title_heading;
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFCellStyle cellStyle2 = workbook.createCellStyle();
        HSSFCellStyle cellStyle3 = workbook.createCellStyle();
        cellStyle.setFillForegroundColor((short)colorIndex);
        if (colorIndex == HSSFColor.GOLD.index) {
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBorderTop(BorderStyle.THIN);
            cellStyle.setBorderRight(BorderStyle.THIN);
            cellStyle.setBorderLeft(BorderStyle.THIN);
            cellStyle2.setBorderBottom(BorderStyle.THIN);
            cellStyle2.setBorderTop(BorderStyle.THIN);
            cellStyle2.setBorderRight(BorderStyle.THIN);
            cellStyle2.setBorderLeft(BorderStyle.THIN);
        }
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle3.setFillForegroundColor((short)colorIndex);
        cellStyle3.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        if (PropertyValidator.isValid(list)) {
            if (PropertyValidator.isValid((Object)title)) {
                if (excelRowIndex > 0) {
                    // empty if block
                }
                int n = ++excelRowIndex;
                title_heading = worksheet.createRow((int)((short)n));
                HSSFCell box = title_heading.createCell(0);
                box.setCellValue(title);
            }
            int n = ++excelRowIndex;
            ++excelRowIndex;
            row = worksheet.createRow((int)((short)n));
            int index = 0;
            for (int j = 0; j < completeHeader.size(); ++j) {
                HSSFCell hSSFCell = row.createCell((int)((short)index));
                hSSFCell.setCellStyle(cellStyle);
                hSSFCell.setCellValue(completeHeader.get(j).get("header"));
                ++index;
            }
            for (Map map : list) {
                rows = worksheet.createRow((int)((short)excelRowIndex++));
                index = 0;
                for (int j = 0; j < completeHeader.size(); ++j) {
                    Object value = map.get(completeHeader.get(j).get("value"));
                    HSSFCell cell2 = rows.createCell((int)((short)index));
                    if (PropertyValidator.isValid(value)) {
                        cell2.setCellValue(value.toString());
                    } else {
                        cell2.setCellValue("");
                    }
                    if (colorIndex == HSSFColor.GOLD.index) {
                        cell2.setCellStyle(cellStyle2);
                    }
                    ++index;
                }
            }
        }
        if (PropertyValidator.isValid(errors)) {
            if (PropertyValidator.isValid((Object)title)) {
                if (excelRowIndex > 0) {
                    // empty if block
                }
                int n = ++excelRowIndex;
                title_heading = worksheet.createRow((int)((short)n));
                HSSFCell box = title_heading.createCell(0);
                box.setCellValue(title);
            }
            int n = ++excelRowIndex;
            ++excelRowIndex;
            row = worksheet.createRow((int)((short)n));
            int index = 0;
            for (int j = 0; j < completeHeader.size(); ++j) {
                HSSFCell hSSFCell = row.createCell((int)((short)index));
                hSSFCell.setCellStyle(cellStyle3);
                hSSFCell.setCellValue(completeHeader.get(j).get("header"));
                ++index;
            }
            for (String string : errors) {
                rows = worksheet.createRow((int)((short)excelRowIndex++));
                index = 0;
                String[] msg = string.split("<kendis-error></kendis-error>");
                for (int j = 0; j < completeHeader.size(); ++j) {
                    String value = msg[j < msg.length ? j : msg.length - 1];
                    HSSFCell cell3 = rows.createCell((int)((short)index));
                    if (PropertyValidator.isValid((Object)value)) {
                        cell3.setCellValue(value.toString());
                    } else {
                        cell3.setCellValue("");
                    }
                    ++index;
                }
            }
        }
        return excelRowIndex;
    }

    private void autoSizeColumns(XSSFSheet sheet, int excelRowIndex) throws Exception {
        Iterator cellIterator;
        XSSFRow row;
        if (sheet.getPhysicalNumberOfRows() > excelRowIndex && (row = sheet.getRow(excelRowIndex)) != null && (cellIterator = row.cellIterator()) != null) {
            while (cellIterator.hasNext()) {
                Cell cell = (Cell)cellIterator.next();
                int columnIndex = cell.getColumnIndex();
                sheet.autoSizeColumn(columnIndex);
            }
        }
    }

    public int writeItemLogFile(int colorIndex, String title, XSSFWorkbook workbook, XSSFSheet worksheet, List<Map<String, String>> completeHeader, Collection<HashMap<String, ? super Object>> list, List<String> errors, int excelRowIndex) throws IOException {
        XSSFRow rows;
        XSSFRow row;
        XSSFRow title_heading;
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        XSSFCellStyle cellStyle2 = workbook.createCellStyle();
        XSSFCellStyle cellStyle3 = workbook.createCellStyle();
        cellStyle.setFillForegroundColor((short)colorIndex);
        if (colorIndex == HSSFColor.GOLD.index) {
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBorderTop(BorderStyle.THIN);
            cellStyle.setBorderRight(BorderStyle.THIN);
            cellStyle.setBorderLeft(BorderStyle.THIN);
            cellStyle2.setBorderBottom(BorderStyle.THIN);
            cellStyle2.setBorderTop(BorderStyle.THIN);
            cellStyle2.setBorderRight(BorderStyle.THIN);
            cellStyle2.setBorderLeft(BorderStyle.THIN);
        }
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle3.setFillForegroundColor((short)colorIndex);
        cellStyle3.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        if (PropertyValidator.isValid(list)) {
            if (PropertyValidator.isValid((Object)title)) {
                if (excelRowIndex > 0) {
                    // empty if block
                }
                int n = ++excelRowIndex;
                title_heading = worksheet.createRow((int)((short)n));
                XSSFCell box = title_heading.createCell(0);
                box.setCellValue(title);
            }
            int n = ++excelRowIndex;
            ++excelRowIndex;
            row = worksheet.createRow((int)((short)n));
            int index = 0;
            for (int j = 0; j < completeHeader.size(); ++j) {
                XSSFCell xSSFCell = row.createCell((int)((short)index));
                xSSFCell.setCellStyle((CellStyle)cellStyle);
                xSSFCell.setCellValue(completeHeader.get(j).get("header"));
                ++index;
            }
            for (Map map : list) {
                rows = worksheet.createRow((int)((short)excelRowIndex++));
                index = 0;
                for (int j = 0; j < completeHeader.size(); ++j) {
                    Object value = map.get(completeHeader.get(j).get("value"));
                    XSSFCell cell2 = rows.createCell((int)((short)index));
                    if (PropertyValidator.isValid(value)) {
                        cell2.setCellValue(value.toString());
                    } else {
                        cell2.setCellValue("");
                    }
                    if (colorIndex == HSSFColor.GOLD.index) {
                        cell2.setCellStyle((CellStyle)cellStyle2);
                    }
                    ++index;
                }
            }
        }
        if (PropertyValidator.isValid(errors)) {
            if (PropertyValidator.isValid((Object)title)) {
                if (excelRowIndex > 0) {
                    // empty if block
                }
                int n = ++excelRowIndex;
                title_heading = worksheet.createRow((int)((short)n));
                XSSFCell box = title_heading.createCell(0);
                box.setCellValue(title);
            }
            int n = ++excelRowIndex;
            ++excelRowIndex;
            row = worksheet.createRow((int)((short)n));
            int index = 0;
            for (int j = 0; j < completeHeader.size(); ++j) {
                XSSFCell xSSFCell = row.createCell((int)((short)index));
                xSSFCell.setCellStyle((CellStyle)cellStyle3);
                xSSFCell.setCellValue(completeHeader.get(j).get("header"));
                ++index;
            }
            for (String string : errors) {
                rows = worksheet.createRow((int)((short)excelRowIndex++));
                index = 0;
                String[] msg = string.split("<kendis-error></kendis-error>");
                for (int j = 0; j < completeHeader.size(); ++j) {
                    String value = msg[j < msg.length ? j : msg.length - 1];
                    XSSFCell cell3 = rows.createCell((int)((short)index));
                    if (PropertyValidator.isValid((Object)value)) {
                        cell3.setCellValue(value.toString());
                    } else {
                        cell3.setCellValue("");
                    }
                    ++index;
                }
            }
        }
        return excelRowIndex;
    }

    public ResponseEntity<Object> exportChartDetail(String type, HashMap<String, Object> requestBody) throws Exception {
        HashMap<String, String> data = new HashMap<String, String>();
        String downloadName = "";
        List headers = (List)requestBody.get("headers");
        LinkedHashSet items = new LinkedHashSet((List)requestBody.get("items"));
        String collectionName = (String)requestBody.get("collectionName");
        String hierarchyLevel = (String)requestBody.get("hierarchyLevel");
        String fileName = new Date().getTime() + "." + type;
        String filePath = this.env.getProperty("temp.file.location") + fileName;
        FileOutputStream file = new FileOutputStream(filePath);
        if ("csv".equals(type)) {
            CsvMapWriter writer = new CsvMapWriter((Writer)new OutputStreamWriter((OutputStream)file, "UTF-8"), CsvPreference.EXCEL_PREFERENCE);
            String[] completeHeader = new String[headers.size()];
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)file, "UTF-8");
            if (PropertyValidator.isValid((Object)collectionName)) {
                outputStreamWriter.write("Collection Name : " + collectionName + "\n");
            }
            if (PropertyValidator.isValid((Object)hierarchyLevel)) {
                outputStreamWriter.write("Hierarchy Level : " + hierarchyLevel + "\n");
            }
            if (PropertyValidator.isValid((Object)hierarchyLevel) || PropertyValidator.isValid((Object)collectionName)) {
                outputStreamWriter.write("\n");
            }
            outputStreamWriter.flush();
            for (int j = 0; j < headers.size(); ++j) {
                if (headers.get(j) == null || ((Map)headers.get(j)).get("header") == null) continue;
                completeHeader[j] = (String)((Map)headers.get(j)).get("header");
            }
            if (completeHeader.length > 0) {
                writer.writeHeader(completeHeader);
            }
            for (HashMap entry : items) {
                HashMap rowData = new HashMap();
                for (int j = 0; j < headers.size(); ++j) {
                    if (headers.get(j) == null || ((Map)headers.get(j)).get("header") == null || ((Map)headers.get(j)).get("value") == null) continue;
                    rowData.put(((Map)headers.get(j)).get("header"), entry.get(((Map)headers.get(j)).get("value")));
                }
                writer.write(rowData, completeHeader);
            }
            writer.close();
            file.flush();
            file.close();
        } else if ("xls".equals(type) || "xlsx".equals(type)) {
            HSSFWorkbook workbook = null;
            HSSFSheet worksheet = null;
            XSSFWorkbook xssworkbook = null;
            XSSFSheet xssworksheet = null;
            if ("xlsx".equals(type)) {
                XSSFCell hierarchyCell;
                XSSFRow hierarchyRow;
                XSSFCell collectionCell;
                XSSFRow collectionRow;
                xssworkbook = new XSSFWorkbook();
                xssworksheet = xssworkbook.createSheet("Detail");
                int excelRowIndex = 0;
                if (PropertyValidator.isValid((Object)collectionName) && xssworksheet != null && (collectionRow = xssworksheet.createRow(excelRowIndex++)) != null && (collectionCell = collectionRow.createCell(0)) != null) {
                    collectionCell.setCellValue("Collection Name: " + collectionName);
                }
                if (PropertyValidator.isValid((Object)hierarchyLevel) && xssworksheet != null && (hierarchyRow = xssworksheet.createRow(excelRowIndex++)) != null && (hierarchyCell = hierarchyRow.createCell(0)) != null) {
                    hierarchyCell.setCellValue("Hierarchy Level: " + hierarchyLevel);
                }
                if (PropertyValidator.isValid((Object)collectionName) || PropertyValidator.isValid((Object)hierarchyLevel)) {
                    ++excelRowIndex;
                }
                this.writeItemLogFile((int)HSSFColor.GOLD.index, "", xssworkbook, xssworksheet, headers, items, null, excelRowIndex);
                this.autoSizeColumns(xssworksheet, excelRowIndex);
                xssworkbook.write((OutputStream)file);
                file.flush();
                file.close();
                xssworkbook.close();
            } else {
                workbook = new HSSFWorkbook();
                worksheet = workbook.createSheet("Detail");
                int excelRowIndex = 0;
                this.writeItemLogFile((int)HSSFColor.GOLD.index, "", workbook, worksheet, headers, items, null, excelRowIndex);
                this.autoSizeColumns(worksheet, excelRowIndex);
                workbook.write((OutputStream)file);
                file.flush();
                file.close();
                workbook.close();
            }
        }
        if (PropertyValidator.isValid((Object)filePath)) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
            downloadName = AlmUtils.cleanText((String)(requestBody.get("title") + formatter.format(new Date()))) + "." + type;
            if (PropertyValidator.isValid((Object)downloadName)) {
                data.put("srcPath", URLEncoder.encode(filePath, "UTF-8"));
                data.put("name", downloadName);
                return new ResponseEntity(data, HttpStatus.OK);
            }
            data.put("message", "Something went wrong");
            return new ResponseEntity(data, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(data, HttpStatus.BAD_REQUEST);
    }

    public static String getChangeString(String changes, HashMap<String, Team> teamMap, HashMap<String, Container> containerMap, HashMap<String, IssueType> issueTypeMap, HashMap<String, Item> itemMap, SessionBoard sessionBoard) {
        if (PropertyValidator.isValid((Object)changes)) {
            int activityStatusStringIndexLength;
            char removeChar;
            Map issueTypeIdMap;
            String changedData = changes;
            Gson gson = new Gson();
            20 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap changesJSON = (HashMap)gson.fromJson(changedData, T.getType());
            String activityStatusString = "";
            if (PropertyValidator.isValid(changesJSON.get("jiraKey"))) {
                activityStatusString = activityStatusString + " changed Key " + changesJSON.get("jiraKey") + ",";
            }
            if (PropertyValidator.isValid(changesJSON.get("title"))) {
                activityStatusString = activityStatusString + "changed title " + changesJSON.get("title") + ",";
            }
            if (PropertyValidator.isValid(changesJSON.get("storyPoints"))) {
                activityStatusString = activityStatusString + " changed estimate " + changesJSON.get("storyPoints") + ",";
            }
            if (PropertyValidator.isValid(changesJSON.get("dueDate"))) {
                activityStatusString = activityStatusString + " changed due date " + changesJSON.get("dueDate").toString() + ",";
            }
            if (PropertyValidator.isValid(changesJSON.get("score"))) {
                activityStatusString = activityStatusString + " changed score " + changesJSON.get("score") + ",";
            }
            if (PropertyValidator.isValid(changesJSON.get("almScoreField"))) {
                activityStatusString = activityStatusString + " changed score " + changesJSON.get("almScoreField") + ",";
            }
            if (PropertyValidator.isValid(changesJSON.get("issueType")) && PropertyValidator.isValid((issueTypeIdMap = (Map)changesJSON.get("issueType")).get("id"))) {
                IssueType issueType;
                if (issueTypeIdMap.get("id").toString().equals("-1")) {
                    activityStatusString = activityStatusString + "changed card type Feature ,";
                }
                if (PropertyValidator.isValid((Object)(issueType = issueTypeMap.get(issueTypeIdMap.get("id"))))) {
                    activityStatusString = activityStatusString + " changed card type " + issueType.getTitle() + ",";
                }
            }
            if (PropertyValidator.isValid(changesJSON.get("teamContainers"))) {
                Map tcMap = null;
                if (changesJSON.get("teamContainers") instanceof List) {
                    List tC = (List)changesJSON.get("teamContainers");
                    if (PropertyValidator.isValid((Collection)tC) && tC.size() > 0) {
                        tcMap = (Map)tC.get(0);
                    }
                } else if (changesJSON.get("teamContainers") instanceof Map) {
                    tcMap = (Map)changesJSON.get("teamContainers");
                }
                if (PropertyValidator.isValid(tcMap) && PropertyValidator.isValid(tcMap.get("team")) && PropertyValidator.isValid(tcMap.get("container"))) {
                    Map teamIdMap = (Map)tcMap.get("team");
                    Map containerIdMap = (Map)tcMap.get("container");
                    if (PropertyValidator.isValid(teamIdMap.get("id")) && PropertyValidator.isValid(containerIdMap.get("id"))) {
                        String teamId = teamIdMap.get("id").toString();
                        String containerId = containerIdMap.get("id").toString();
                        String tTitle = PropertyValidator.isValid((Object)teamMap.get(teamId)) ? teamMap.get(teamId).getTitle() : "";
                        String cTitle = PropertyValidator.isValid((Object)containerMap.get(containerId)) ? containerMap.get(containerId).getTitle() : "";
                        activityStatusString = activityStatusString + " moved to Sprint " + cTitle + " and Team " + tTitle + ",";
                    }
                }
            }
            if (PropertyValidator.isValid(changesJSON.get("startDate"))) {
                String startDate = changesJSON.get("startDate").toString();
                activityStatusString = activityStatusString + " changed start date " + startDate + ",";
            }
            if (PropertyValidator.isValid(changesJSON.get("endDate"))) {
                String endDate = changesJSON.get("endDate").toString();
                activityStatusString = activityStatusString + "changed end date " + endDate + ",";
            }
            if (PropertyValidator.isValid(changesJSON.get("phoenixSequence"))) {
                activityStatusString = activityStatusString + " changed delivery " + sessionBoard.getSession().getSprintLabel() + ",";
            }
            if (activityStatusString.length() > 0 && (removeChar = activityStatusString.charAt(activityStatusStringIndexLength = activityStatusString.length() - 1)) == ',') {
                activityStatusString = activityStatusString.substring(0, activityStatusString.length() - 1);
            }
            return activityStatusString;
        }
        return "";
    }

    public String exportActivityLogs(List activityLogData, List<Team> teams, List<Container> containers, List<IssueType> issueTypeList, List<Item> itemRepoList, String timeZone, SessionBoard sessionBoard) {
        try {
            String fileName = new Date().getTime() + ".xlsx";
            String filePath = this.env.getProperty("temp.file.location") + fileName;
            int sNo = 0;
            HashMap<String, Team> teamMap = new HashMap<String, Team>();
            HashMap<String, Container> containerMap = new HashMap<String, Container>();
            HashMap<String, IssueType> issueTypeMap = new HashMap<String, IssueType>();
            HashMap<String, Item> itemMap = new HashMap<String, Item>();
            for (Team team : teams) {
                teamMap.put(team.getId(), team);
            }
            for (Container container : containers) {
                containerMap.put(container.getId(), container);
            }
            for (IssueType issueType : issueTypeList) {
                issueTypeMap.put(issueType.getId(), issueType);
            }
            for (Item item : itemRepoList) {
                itemMap.put(item.getId(), item);
            }
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sh = workbook.createSheet("Activity Log");
            String[] columnHeadings = new String[]{"SNO", "Name", "Email", "Key", "Summary", "Activity Type", "Date", "Time"};
            XSSFFont headerFont = workbook.createFont();
            headerFont.setBold(true);
            headerFont.setFontHeightInPoints((short)15);
            headerFont.setColor(IndexedColors.BLACK.index);
            XSSFCellStyle headerStyle = workbook.createCellStyle();
            headerStyle.setFont((Font)headerFont);
            headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            headerStyle.setFillForegroundColor(IndexedColors.GOLD.index);
            XSSFRow headerRow = sh.createRow(0);
            for (int i = 0; i < columnHeadings.length; ++i) {
                Cell cell = headerRow.createCell(i);
                cell.setCellValue(columnHeadings[i]);
                cell.setCellStyle((CellStyle)headerStyle);
            }
            sh.createFreezePane(0, 1);
            List a = ExportServiceImpl.createActivityLog((List)activityLogData);
            XSSFCreationHelper creationHelper = workbook.getCreationHelper();
            XSSFCellStyle dateStyle = workbook.createCellStyle();
            dateStyle.setDataFormat(creationHelper.createDataFormat().getFormat("MM/dd/yyyy"));
            SimpleDateFormat sdf = new SimpleDateFormat("EE MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
            int rownum = 1;
            for (ItemLog i : a) {
                String eventText;
                XSSFRow row = sh.createRow(rownum++);
                row.createCell(0).setCellValue((double)(++sNo));
                row.createCell(1).setCellValue(i.getName());
                row.createCell(2).setCellValue(i.getActivityBy());
                String itemKeyId = "";
                if (PropertyValidator.isValid((Object)i.getDetail())) {
                    HashMap detail = (HashMap)i.getDetail();
                    if (PropertyValidator.isValid(detail.get("tfsId"))) {
                        itemKeyId = detail.get("tfsId").toString();
                    } else if (PropertyValidator.isValid(detail.get("jiraKey"))) {
                        itemKeyId = detail.get("jiraKey").toString();
                    } else if (PropertyValidator.isValid(detail.get("kendisKey"))) {
                        itemKeyId = detail.get("kendisKey").toString();
                    }
                }
                eventText = !(eventText = ExportServiceImpl.getChangeString((String)i.getChanges(), teamMap, containerMap, issueTypeMap, itemMap, (SessionBoard)sessionBoard)).equals("") && PropertyValidator.isValid((Object)eventText) ? " - [ " + eventText + " ]" : "";
                row.createCell(3).setCellValue(itemKeyId);
                row.createCell(4).setCellValue(i.getTitle());
                Date parsedDate = sdf.parse(i.getEventTime().toString());
                SimpleDateFormat print = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                print.setTimeZone(TimeZone.getTimeZone(timeZone));
                String time = print.format(parsedDate);
                row.createCell(5).setCellValue(i.getEventType() + eventText);
                Cell dateCell = row.createCell(6);
                dateCell.setCellValue(i.getEventTime());
                dateCell.setCellStyle((CellStyle)dateStyle);
                row.createCell(7).setCellValue(time.substring(11, time.length()));
            }
            for (int i = 0; i < columnHeadings.length; ++i) {
                sh.autoSizeColumn(i);
            }
            FileOutputStream file = new FileOutputStream(filePath);
            workbook.write((OutputStream)file);
            file.close();
            return filePath;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public static HashMap<String, String> auditLogMapSession() {
        HashMap<String, String> auditLogStringMap = new HashMap<String, String>();
        auditLogStringMap.put("BOARD_ADD_DEL", "Board Feature Add/Remove");
        auditLogStringMap.put("FILTER_ADD_DEL", "Filter Feature Add/Remove ");
        auditLogStringMap.put("BOARD_RESYNC", "Board Resync");
        auditLogStringMap.put("CELL_RESYNC", "Cell Resync");
        auditLogStringMap.put("SPRINT_RESYNC", "Smart Sync");
        auditLogStringMap.put("FILTER_RESYNC", "Filter Resync");
        auditLogStringMap.put("FEATURE_RESYNC", "Feature Resync");
        auditLogStringMap.put("TEAM_RESYNC", "Team Resync");
        auditLogStringMap.put("FILTER_REMOVED", "Filter Removed");
        auditLogStringMap.put("FILTER_ADD", "Filter Added");
        auditLogStringMap.put("TEAM_ADD", "Team Added");
        auditLogStringMap.put("TEAM_REMOVED", "Team Removed");
        auditLogStringMap.put("TEAM_SETTINGS", "Team Settings");
        auditLogStringMap.put("CONTAINER_ADD", "Sprint Added");
        auditLogStringMap.put("CONTAINER_DEL", "Sprint Removed");
        auditLogStringMap.put("ADDITIONAL_VAL", "Additional Fields");
        auditLogStringMap.put("COMPARISON", "Sprint compared");
        auditLogStringMap.put("BASE_LINE", "Sprint Started");
        auditLogStringMap.put("BASE_LINE_2", "Sprint Restarted");
        auditLogStringMap.put("SPILL_OVER", "Sprint Ended");
        auditLogStringMap.put("STATE_REVERTED", "Board State Reverted");
        auditLogStringMap.put("SPRINT_REPORT", "Sprint Report Generated");
        return auditLogStringMap;
    }

    public static HashMap<String, String> auditLogMapPiSession() {
        HashMap<String, String> auditLogStringMap = new HashMap<String, String>();
        auditLogStringMap.put("FILTER_REMOVED", "Filter Removed");
        auditLogStringMap.put("FILTER_ADD", "Filter Added");
        auditLogStringMap.put("CONTAINER_ADD", "Sprint Added");
        auditLogStringMap.put("CONTAINER_DEL", "Sprint Removed");
        auditLogStringMap.put("COMPARISON", "Sprint compared");
        auditLogStringMap.put("BASE_LINE", "Sprint Started");
        auditLogStringMap.put("BASE_LINE_2", "Sprint Restarted");
        auditLogStringMap.put("SPILL_OVER", "Sprint Ended");
        auditLogStringMap.put("SPRINT_REPORT", "Sprint Report Generated");
        return auditLogStringMap;
    }

    public static List<ItemLog> createActivityLog(List activityLogData) {
        boolean dataIndex = false;
        ArrayList activityList = (ArrayList)activityLogData;
        ArrayList<ItemLog> finalRecord = new ArrayList<ItemLog>();
        for (int i = 0; i < activityList.size(); ++i) {
            finalRecord.add(new ItemLog(((ItemLog)activityList.get(i)).getActivityBy(), ((ItemLog)activityList.get(i)).getCreatedBy(), ((ItemLog)activityList.get(i)).getEventType(), ((ItemLog)activityList.get(i)).getEventTime(), ((ItemLog)activityList.get(i)).getItemId(), ((ItemLog)activityList.get(i)).getItemType(), ((ItemLog)activityList.get(i)).getKey(), ((ItemLog)activityList.get(i)).getTitle(), ((ItemLog)activityList.get(i)).getDetail(), ((ItemLog)activityList.get(i)).getChanges()));
        }
        return finalRecord;
    }

    public String exportAuditLogs(List auditLogData, String boardType, String timeZone) {
        String fileName = new Date().getTime() + ".xlsx";
        String filePath = this.env.getProperty("temp.file.location") + fileName;
        HashMap actionsMap = new HashMap();
        if (boardType.equals("session")) {
            actionsMap = ExportServiceImpl.auditLogMapSession();
        } else if (boardType.equals("pisession")) {
            actionsMap = ExportServiceImpl.auditLogMapPiSession();
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sh = workbook.createSheet("Audit Log");
        try {
            int sNo = 0;
            String[] columnHeadings = new String[]{"SNO.", "User", "Action", "Created On", "Time"};
            XSSFFont headerFont = workbook.createFont();
            headerFont.setBold(true);
            headerFont.setFontHeightInPoints((short)15);
            headerFont.setColor(IndexedColors.BLACK.index);
            XSSFCellStyle headerStyle = workbook.createCellStyle();
            headerStyle.setFont((Font)headerFont);
            headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            headerStyle.setFillForegroundColor(IndexedColors.GOLD.index);
            XSSFRow headerRow = sh.createRow(0);
            for (int i = 0; i < columnHeadings.length; ++i) {
                Cell cell = headerRow.createCell(i);
                cell.setCellValue(columnHeadings[i]);
                cell.setCellStyle((CellStyle)headerStyle);
            }
            sh.createFreezePane(0, 1);
            ArrayList a = ExportServiceImpl.createAuditLogData((List)auditLogData);
            XSSFCreationHelper creationHelper = workbook.getCreationHelper();
            XSSFCellStyle dateStyle = workbook.createCellStyle();
            dateStyle.setDataFormat(creationHelper.createDataFormat().getFormat("MM/dd/yyyy"));
            SimpleDateFormat sdf = new SimpleDateFormat("EE MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
            Collections.sort(a, new /* Unavailable Anonymous Inner Class!! */);
            int rownum = 1;
            for (AuditLog i : a) {
                String eventNarrative = PropertyValidator.isValid((Object)i.getEventText()) ? i.getEventText() : (String)actionsMap.get(i.getEventType());
                if (!PropertyValidator.isValid((Object)eventNarrative)) continue;
                ++sNo;
                Date parsedDate = sdf.parse(i.getCreatedOn().toString());
                SimpleDateFormat print = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                print.setTimeZone(TimeZone.getTimeZone(timeZone.toString()));
                String time = print.format(parsedDate);
                XSSFRow row = sh.createRow(rownum++);
                row.createCell(0).setCellValue((double)sNo);
                row.createCell(1).setCellValue(i.getCreatedBy());
                row.createCell(2).setCellValue(eventNarrative);
                Cell dateCell = row.createCell(3);
                dateCell.setCellValue(i.getCreatedOn());
                dateCell.setCellStyle((CellStyle)dateStyle);
                row.createCell(4).setCellValue(time.substring(11, time.length()));
            }
            for (int i = 0; i < columnHeadings.length; ++i) {
                sh.autoSizeColumn(i);
            }
            FileOutputStream file = new FileOutputStream(filePath);
            workbook.write((OutputStream)file);
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filePath;
    }

    public static ArrayList<AuditLog> createAuditLogData(List AuditLogData) {
        boolean dataIndex = false;
        ArrayList auditList = (ArrayList)AuditLogData;
        ArrayList<AuditLog> finalRecord = new ArrayList<AuditLog>();
        for (int i = 0; i < auditList.size(); ++i) {
            finalRecord.add(new AuditLog(((AuditLog)auditList.get(i)).getCreatedBy(), ((AuditLog)auditList.get(i)).getEventType(), ((AuditLog)auditList.get(i)).getCreatedOn(), ((AuditLog)auditList.get(i)).getEventText()));
        }
        return finalRecord;
    }

    public String convertTime(Float time) {
        if (time.floatValue() < 0.0f) {
            time = Float.valueOf(-time.floatValue());
        }
        int horus = (int)Math.floor(time.floatValue());
        double mins = (time.floatValue() - (float)horus) * 60.0f;
        mins = (int)Math.round(mins);
        String returnTime = "";
        returnTime = horus < 10 ? returnTime + "0" + horus : (horus == 0 ? returnTime + "00" : returnTime + horus);
        returnTime = mins < 10.0 ? returnTime + ":0" + (int)Math.round(mins) : (mins == 0.0 ? returnTime + ":00" : returnTime + ":" + (int)Math.round(mins));
        return returnTime;
    }

    public HashMap<String, Object> formatedTime(Float time, PiSite defaultTimezone, PiSite currentTimezone) {
        HashMap<String, Object> timeMap = new HashMap<String, Object>();
        int currentOffset = currentTimezone.getRawOffset();
        int deafultOffset = defaultTimezone.getRawOffset();
        TimeZone defaultTz = TimeZone.getTimeZone(defaultTimezone.getTimeZone());
        if (defaultTz.inDaylightTime(new Date())) {
            defaultTimezone.setUseDst(Boolean.valueOf(true));
        } else {
            defaultTimezone.setUseDst(Boolean.valueOf(false));
        }
        TimeZone currentTz = TimeZone.getTimeZone(currentTimezone.getTimeZone());
        if (currentTz.inDaylightTime(new Date())) {
            currentTimezone.setUseDst(Boolean.valueOf(true));
        } else {
            currentTimezone.setUseDst(Boolean.valueOf(false));
        }
        if (currentTimezone.getUseDst().booleanValue()) {
            currentOffset += currentTimezone.getDstSavings();
        }
        if (defaultTimezone.getUseDst().booleanValue()) {
            deafultOffset += defaultTimezone.getDstSavings();
        }
        Float diff = Float.valueOf(currentOffset - deafultOffset);
        diff = Float.valueOf(diff.floatValue() / 3600000.0f);
        Float newTime = Float.valueOf(time.floatValue() + diff.floatValue());
        String dayDiff = "0";
        if (newTime.floatValue() < 0.0f) {
            if ((newTime = Float.valueOf(-newTime.floatValue())).floatValue() < 24.0f) {
                newTime = Float.valueOf(newTime.floatValue() - 24.0f);
                dayDiff = "-1";
            }
        } else if (newTime.floatValue() > 24.0f) {
            newTime = Float.valueOf(newTime.floatValue() - 24.0f);
            dayDiff = "+1";
        }
        String stime = this.convertTime(newTime);
        timeMap.put("stime", stime);
        timeMap.put("dayDiff", dayDiff);
        return timeMap;
    }

    public String exportPiAgendaData(List<PiAgendaDay> piAgendaDays, List<String> selectedColumns, String sessionBoardId, List<PiSite> piJourneySitesList) {
        try {
            HSSFRow dataRow;
            HSSFCellStyle cellStyle;
            HSSFCell cell;
            int j;
            String fileName = new Date().getTime() + ".xls";
            String filePath = this.env.getProperty("temp.file.location") + fileName;
            ArrayList<PiJourneyEvent> teamBreakoutList = new ArrayList<PiJourneyEvent>();
            int index = 0;
            SessionBoard sessionBoard = new SessionBoard();
            sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
            piJourneySitesList.sort((Comparator<PiSite>)new /* Unavailable Anonymous Inner Class!! */);
            List teams = sessionBoard.getTeams();
            String[] breakoutRoomHeaders = new String[]{"Team", "Time", "The Room"};
            HashMap<String, String> breakoutDayMap = new HashMap<String, String>();
            HSSFWorkbook workbook = new HSSFWorkbook();
            for (int i = 0; i < piAgendaDays.size(); ++i) {
                index = 0;
                HSSFSheet sh = workbook.createSheet(AlmUtils.cleanText((String)piAgendaDays.get(i).getDay().getTitle()));
                HSSFRow wRow = sh.createRow(0);
                for (j = 0; j < selectedColumns.size(); ++j) {
                    sh.setColumnWidth(j, 10000);
                    cell = wRow.createCell((int)((short)j));
                    cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
                    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    cellStyle.setBorderBottom(BorderStyle.THIN);
                    cellStyle.setBorderTop(BorderStyle.THIN);
                    cellStyle.setBorderRight(BorderStyle.THIN);
                    cellStyle.setBorderLeft(BorderStyle.THIN);
                    cell.setCellStyle(cellStyle);
                    cell.setCellValue(selectedColumns.get(j));
                }
                for (int k = 0; k < piAgendaDays.get(i).getEvents().size(); ++k) {
                    ++index;
                    PiJourneyEvent event = (PiJourneyEvent)piAgendaDays.get(i).getEvents().get(k);
                    if (event.getType() != null && event.getType().equals("breakout")) {
                        teamBreakoutList.add(event);
                        breakoutDayMap.put(event.getId(), AlmUtils.cleanText((String)piAgendaDays.get(i).getDay().getTitle()));
                    }
                    dataRow = sh.createRow(index);
                    HSSFCellStyle cs = workbook.createCellStyle();
                    cs.setWrapText(true);
                    for (int j2 = 0; j2 < selectedColumns.size(); ++j2) {
                        HSSFCell cell2 = dataRow.createCell((int)((short)j2));
                        cell2.setCellStyle((CellStyle)cs);
                        cs.setBorderBottom(BorderStyle.THIN);
                        cs.setBorderTop(BorderStyle.THIN);
                        cs.setBorderRight(BorderStyle.THIN);
                        cs.setBorderLeft(BorderStyle.THIN);
                        for (PiSite piSite : piJourneySitesList) {
                            if (!selectedColumns.get(j2).equals(piSite.getCity() + ", " + piSite.getCountry())) continue;
                            if (j2 == 0) {
                                String startTime = this.convertTime(event.getStartTime()) + "";
                                String endTime = this.convertTime(event.getEndTime()) + "";
                                cell2.setCellValue(startTime + " - " + endTime);
                                continue;
                            }
                            HashMap startTimeMap = this.formatedTime(event.getStartTime(), piJourneySitesList.get(0), piSite);
                            HashMap endTimeMap = this.formatedTime(event.getEndTime(), piJourneySitesList.get(0), piSite);
                            String startTime = startTimeMap.get("stime") + " (" + startTimeMap.get("dayDiff") + ")";
                            String endTime = endTimeMap.get("stime") + " (" + endTimeMap.get("dayDiff") + ")";
                            cell2.setCellValue(startTime + " - " + endTime);
                        }
                        if (selectedColumns.get(j2).equals("Planning Event") && event.getTitle() != null) {
                            cell2.setCellValue(event.getTitle());
                        }
                        if (selectedColumns.get(j2).equals("Description") && event.getDescription() != null) {
                            cell2.setCellValue(event.getDescription());
                        }
                        if (selectedColumns.get(j2).equals("Presenters") && event.getPresenters() != null) {
                            String presenters = "";
                            for (int a = 0; a < event.getPresenters().size(); ++a) {
                                presenters = presenters + ((User)event.getPresenters().get(a)).getFullName() + "\n";
                            }
                            cell2.setCellValue(presenters);
                        }
                        if (selectedColumns.get(j2).equals("Attachments") && event.getAttachments() != null) {
                            String attachments = "";
                            for (int a = 0; a < event.getAttachments().size(); ++a) {
                                attachments = attachments + ((Attachment)event.getAttachments().get(a)).getFilename() + "\n" + ((Attachment)event.getAttachments().get(a)).getFilepath() + "\n";
                            }
                            cell2.setCellValue(attachments);
                        }
                        if (!selectedColumns.get(j2).equals("Virtual Rooms") || event.getRooms() == null) continue;
                        String virtualRooms = "";
                        for (int a = 0; a < event.getRooms().size(); ++a) {
                            virtualRooms = virtualRooms + ((PiJourneyRoomLink)event.getRooms().get(a)).getTitle() + "\n" + ((PiJourneyRoomLink)event.getRooms().get(a)).getLink() + "\n";
                        }
                        cell2.setCellValue(virtualRooms);
                    }
                }
            }
            if (selectedColumns.contains("Virtual Rooms")) {
                for (int c = 0; c < teamBreakoutList.size(); ++c) {
                    index = 0;
                    HSSFSheet breakoutSheet = workbook.createSheet(((PiJourneyEvent)teamBreakoutList.get(c)).getTitle() + " (" + (String)breakoutDayMap.get(((PiJourneyEvent)teamBreakoutList.get(c)).getId()) + ")");
                    HSSFRow bRow = breakoutSheet.createRow(0);
                    for (j = 0; j < breakoutRoomHeaders.length; ++j) {
                        breakoutSheet.setColumnWidth(j, 10000);
                        cell = bRow.createCell((int)((short)j));
                        cellStyle = workbook.createCellStyle();
                        cellStyle.setBorderBottom(BorderStyle.THIN);
                        cellStyle.setBorderTop(BorderStyle.THIN);
                        cellStyle.setBorderRight(BorderStyle.THIN);
                        cellStyle.setBorderLeft(BorderStyle.THIN);
                        cellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
                        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                        cell.setCellStyle(cellStyle);
                        cell.setCellValue(breakoutRoomHeaders[j]);
                    }
                    if (((PiJourneyEvent)teamBreakoutList.get(c)).getTeams() == null) continue;
                    for (int y = 0; y < ((PiJourneyEvent)teamBreakoutList.get(c)).getTeams().size(); ++y) {
                        HSSFCellStyle wrapCell = workbook.createCellStyle();
                        wrapCell.setBorderBottom(BorderStyle.THIN);
                        wrapCell.setBorderTop(BorderStyle.THIN);
                        wrapCell.setBorderRight(BorderStyle.THIN);
                        wrapCell.setBorderLeft(BorderStyle.THIN);
                        wrapCell.setWrapText(true);
                        dataRow = breakoutSheet.createRow(++index);
                        for (int teamIndex = 0; teamIndex < teams.size(); ++teamIndex) {
                            if (!((PiTeamBreakoutTeam)((PiJourneyEvent)teamBreakoutList.get(c)).getTeams().get(y)).getTeamId().equals(((Team)teams.get(teamIndex)).getId())) continue;
                            HSSFCell cellDataTeam = dataRow.createCell(0);
                            cellDataTeam.setCellStyle((CellStyle)wrapCell);
                            cellDataTeam.setCellValue(((Team)teams.get(teamIndex)).getTitle());
                        }
                        HSSFCell cellDataTime = dataRow.createCell(1);
                        cellDataTime.setCellStyle((CellStyle)wrapCell);
                        cellDataTime.setCellValue(this.convertTime(((PiTeamBreakoutTeam)((PiJourneyEvent)teamBreakoutList.get(c)).getTeams().get(y)).getStartTime()) + " - " + this.convertTime(((PiTeamBreakoutTeam)((PiJourneyEvent)teamBreakoutList.get(c)).getTeams().get(y)).getEndTime()));
                        HSSFCell cellDataRoom = dataRow.createCell(2);
                        cellDataRoom.setCellStyle((CellStyle)wrapCell);
                        if (((PiTeamBreakoutTeam)((PiJourneyEvent)teamBreakoutList.get(c)).getTeams().get(y)).getRoom() == null || ((PiTeamBreakoutTeam)((PiJourneyEvent)teamBreakoutList.get(c)).getTeams().get(y)).getRoom().getLink() == null || ((PiTeamBreakoutTeam)((PiJourneyEvent)teamBreakoutList.get(c)).getTeams().get(y)).getRoom().getTitle() == null) continue;
                        cellDataRoom.setCellValue(((PiTeamBreakoutTeam)((PiJourneyEvent)teamBreakoutList.get(c)).getTeams().get(y)).getRoom().getTitle() + "\n" + ((PiTeamBreakoutTeam)((PiJourneyEvent)teamBreakoutList.get(c)).getTeams().get(y)).getRoom().getLink() + "\n");
                    }
                }
            }
            FileOutputStream file = new FileOutputStream(filePath);
            workbook.write((OutputStream)file);
            file.close();
            return filePath;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return "File Error";
        }
    }

    public int exportProgramRoles(List programRolesData, HSSFSheet wSheet, int ind, HSSFCellStyle cellStyle) {
        int index = ind;
        try {
            List columns = this.programRolesFiltered(programRolesData);
            ++index;
            for (PiProgramRole column : columns) {
                HSSFRow wRows = wSheet.createRow(index);
                String[] rowData = new String[]{column.getUser().getFullName(), column.getSystemRole().getTitle(), column.getUser().getEmail()};
                for (int j = 0; j < rowData.length; ++j) {
                    HSSFCell cell = wRows.createCell((int)((short)j));
                    cell.setCellStyle(cellStyle);
                    cellStyle.setBorderBottom(BorderStyle.THIN);
                    cellStyle.setBorderTop(BorderStyle.THIN);
                    cellStyle.setBorderRight(BorderStyle.THIN);
                    cellStyle.setBorderLeft(BorderStyle.THIN);
                    cell.setCellValue(rowData[j]);
                }
                ++index;
            }
            ind = index;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return ind;
    }

    public List<PiProgramRole> programRolesFiltered(List<PiProgramRole> programRolesList) {
        ArrayList<PiProgramRole> programRoles = new ArrayList<PiProgramRole>();
        for (PiProgramRole programRole : programRolesList) {
            if (programRole.getTeamId() != null) continue;
            programRoles.add(programRole);
        }
        return programRoles;
    }

    public List<PiProgramRole> teamRolesFiltered(List<PiProgramRole> programRolesList) {
        ArrayList<PiProgramRole> programRoles = new ArrayList<PiProgramRole>();
        for (PiProgramRole programRole : programRolesList) {
            if (programRole.getTeamId() == null) continue;
            programRoles.add(programRole);
        }
        return programRoles;
    }

    public String exportTeamRoles(List<PiProgramRole> teamRolesData, List<Team> teams, HSSFSheet wSheet, int ind, HSSFCellStyle cellStyle) {
        try {
            int index = ind;
            List piProgramRole = this.teamRolesFiltered(teamRolesData);
            ++index;
            for (Team team : teams) {
                HSSFRow rowData = wSheet.createRow(index);
                HSSFCell teamCell = rowData.createCell(0);
                teamCell.setCellStyle(cellStyle);
                cellStyle.setBorderBottom(BorderStyle.THIN);
                cellStyle.setBorderTop(BorderStyle.THIN);
                cellStyle.setBorderRight(BorderStyle.THIN);
                cellStyle.setBorderLeft(BorderStyle.THIN);
                teamCell.setCellValue(team.getTitle());
                for (PiProgramRole role : piProgramRole) {
                    if (team.getId().equals(role.getTeamId()) && role.getSystemRole().getTitle().equals("Product Owner")) {
                        HSSFCell pCell = rowData.createCell(1);
                        pCell.setCellStyle(cellStyle);
                        if (role.getUser() != null) {
                            pCell.setCellValue(role.getUser().getFullName());
                            continue;
                        }
                        pCell.setCellValue("");
                        continue;
                    }
                    if (!team.getId().equals(role.getTeamId()) || !role.getSystemRole().getTitle().equals("Scrum Master")) continue;
                    HSSFCell tCell = rowData.createCell(2);
                    tCell.setCellStyle(cellStyle);
                    if (role.getUser() != null) {
                        tCell.setCellValue(role.getUser().getFullName());
                        continue;
                    }
                    tCell.setCellValue("");
                }
                ++index;
            }
            ind = index;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return "teamroleExport";
    }

    public String exportProgramAndTeamRoles(List<PiProgramRole> programRolesData, List<Team> teamList, String type, String[] teamSequence) {
        try {
            HSSFRow pRRow;
            String fileName = new Date().getTime() + ".xls";
            String filePath = this.env.getProperty("temp.file.location") + fileName;
            HashMap<String, Team> teamListMap = new HashMap<String, Team>();
            ArrayList teams = new ArrayList();
            for (Team team : teamList) {
                teamListMap.put(team.getId(), team);
            }
            for (int i = 0; i < teamSequence.length; ++i) {
                teams.add(teamListMap.get(teamSequence[i]));
            }
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet wSheet = workbook.createSheet("Program Roles");
            HSSFCellStyle globalCellStyle = workbook.createCellStyle();
            int index = 0;
            String[] programRoleHeader = new String[]{"Name", "Role", "Email"};
            String[] completeHeader = new String[]{"Team", "Product Owner", "Scrum Master"};
            HSSFCellStyle cellHeaderStyleFont = workbook.createCellStyle();
            HSSFFont font = workbook.createFont();
            font.setBold(true);
            font.setFontName("Arial");
            font.setFontHeightInPoints((short)12);
            cellHeaderStyleFont.setFont(font);
            short height = 500;
            if (type.equals("all")) {
                pRRow = wSheet.createRow(index);
                HSSFCell programHeaderCell = pRRow.createCell(0);
                HSSFCellStyle cellHeaderStyle = workbook.createCellStyle();
                cellHeaderStyle.setFillForegroundColor(IndexedColors.GOLD.index);
                cellHeaderStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                cellHeaderStyle.setFont(font);
                pRRow.setHeight(height);
                cellHeaderStyle.setBorderBottom(BorderStyle.THIN);
                cellHeaderStyle.setBorderTop(BorderStyle.THIN);
                cellHeaderStyle.setBorderRight(BorderStyle.THIN);
                cellHeaderStyle.setBorderLeft(BorderStyle.THIN);
                programHeaderCell.setCellStyle(cellHeaderStyleFont);
                cellHeaderStyleFont.setBorderBottom(BorderStyle.THIN);
                cellHeaderStyleFont.setBorderTop(BorderStyle.THIN);
                cellHeaderStyleFont.setBorderRight(BorderStyle.THIN);
                cellHeaderStyleFont.setBorderLeft(BorderStyle.THIN);
                programHeaderCell.setCellValue("Program Roles");
                HSSFRow wRow = wSheet.createRow(++index);
                for (int j = 0; j < programRoleHeader.length; ++j) {
                    HSSFCell cell = wRow.createCell((int)((short)j));
                    HSSFCellStyle cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
                    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    cell.setCellStyle(cellStyle);
                    cellStyle.setBorderBottom(BorderStyle.THIN);
                    cellStyle.setBorderTop(BorderStyle.THIN);
                    cellStyle.setBorderRight(BorderStyle.THIN);
                    cellStyle.setBorderLeft(BorderStyle.THIN);
                    wSheet.setColumnWidth(j, 8000);
                    cellStyle.setBorderBottom(BorderStyle.THIN);
                    cellStyle.setBorderTop(BorderStyle.THIN);
                    cellStyle.setBorderRight(BorderStyle.THIN);
                    cellStyle.setBorderLeft(BorderStyle.THIN);
                    cell.setCellValue(programRoleHeader[j]);
                }
                index = this.exportProgramRoles(programRolesData, wSheet, index, globalCellStyle);
                HSSFRow mainHeader = wSheet.createRow(index += 2);
                HSSFCell mainHeaderCell = mainHeader.createCell(0);
                HSSFCellStyle mainHeaderCellStyle = workbook.createCellStyle();
                mainHeaderCellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
                mainHeaderCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                HSSFFont txtFont = workbook.createFont();
                txtFont.setFontName("Arial");
                txtFont.setFontHeightInPoints((short)10);
                mainHeaderCellStyle.setFont(txtFont);
                mainHeaderCell.setCellStyle(cellHeaderStyleFont);
                mainHeader.setHeight(height);
                mainHeaderCellStyle.setBorderBottom(BorderStyle.THIN);
                mainHeaderCellStyle.setBorderTop(BorderStyle.THIN);
                mainHeaderCellStyle.setBorderRight(BorderStyle.THIN);
                mainHeaderCellStyle.setBorderLeft(BorderStyle.THIN);
                mainHeaderCell.setCellValue("Team Roles");
                HSSFRow tRow = wSheet.createRow(++index);
                for (int j = 0; j < completeHeader.length; ++j) {
                    HSSFCell cell = tRow.createCell((int)((short)j));
                    HSSFCellStyle cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
                    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    cell.setCellStyle(cellStyle);
                    wSheet.setColumnWidth(j, 8000);
                    cellStyle.setBorderBottom(BorderStyle.THIN);
                    cellStyle.setBorderTop(BorderStyle.THIN);
                    cellStyle.setBorderRight(BorderStyle.THIN);
                    cellStyle.setBorderLeft(BorderStyle.THIN);
                    cell.setCellValue(completeHeader[j]);
                }
                this.exportTeamRoles(programRolesData, teams, wSheet, index, globalCellStyle);
            } else if (type.equals("programrole")) {
                pRRow = wSheet.createRow(index);
                HSSFCell programHeaderCell = pRRow.createCell(0);
                HSSFCellStyle cellHeaderStyle = workbook.createCellStyle();
                cellHeaderStyle.setFillForegroundColor(IndexedColors.GOLD.index);
                cellHeaderStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                HSSFFont fontTwo = workbook.createFont();
                fontTwo.setFontName("Arial");
                fontTwo.setFontHeightInPoints((short)10);
                fontTwo.setBold(true);
                cellHeaderStyle.setFont(fontTwo);
                programHeaderCell.setCellStyle(cellHeaderStyleFont);
                pRRow.setHeight(height);
                cellHeaderStyleFont.setBorderBottom(BorderStyle.THIN);
                cellHeaderStyleFont.setBorderTop(BorderStyle.THIN);
                cellHeaderStyleFont.setBorderRight(BorderStyle.THIN);
                cellHeaderStyleFont.setBorderLeft(BorderStyle.THIN);
                programHeaderCell.setCellValue("Program Roles");
                HSSFRow wRow = wSheet.createRow(++index);
                for (int j = 0; j < programRoleHeader.length; ++j) {
                    HSSFCell cell = wRow.createCell((int)((short)j));
                    HSSFCellStyle cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
                    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    cell.setCellStyle(cellStyle);
                    wSheet.setColumnWidth(j, 8000);
                    cellStyle.setBorderBottom(BorderStyle.THIN);
                    cellStyle.setBorderTop(BorderStyle.THIN);
                    cellStyle.setBorderRight(BorderStyle.THIN);
                    cellStyle.setBorderLeft(BorderStyle.THIN);
                    cell.setCellValue(programRoleHeader[j]);
                }
                this.exportProgramRoles(programRolesData, wSheet, index, globalCellStyle);
            } else if (type.equals("teamrole")) {
                HSSFRow mainHeader = wSheet.createRow(index);
                HSSFCell mainHeaderCell = mainHeader.createCell(0);
                HSSFCellStyle mainHeaderCellStyle = workbook.createCellStyle();
                mainHeaderCellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
                mainHeaderCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                HSSFFont txtFont = workbook.createFont();
                txtFont.setFontName("Arial");
                txtFont.setFontHeightInPoints((short)10);
                mainHeaderCellStyle.setFont(txtFont);
                mainHeaderCell.setCellStyle(cellHeaderStyleFont);
                mainHeader.setHeight(height);
                cellHeaderStyleFont.setBorderBottom(BorderStyle.THIN);
                cellHeaderStyleFont.setBorderTop(BorderStyle.THIN);
                cellHeaderStyleFont.setBorderRight(BorderStyle.THIN);
                cellHeaderStyleFont.setBorderLeft(BorderStyle.THIN);
                mainHeaderCell.setCellValue("Team Roles");
                HSSFRow tRow = wSheet.createRow(++index);
                for (int j = 0; j < completeHeader.length; ++j) {
                    HSSFCell cell = tRow.createCell((int)((short)j));
                    HSSFCellStyle cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
                    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    cell.setCellStyle(cellStyle);
                    wSheet.setColumnWidth(j, 8000);
                    cellStyle.setBorderBottom(BorderStyle.THIN);
                    cellStyle.setBorderTop(BorderStyle.THIN);
                    cellStyle.setBorderRight(BorderStyle.THIN);
                    cellStyle.setBorderLeft(BorderStyle.THIN);
                    cell.setCellValue(completeHeader[j]);
                }
                this.exportTeamRoles(programRolesData, teams, wSheet, index, globalCellStyle);
            }
            FileOutputStream file = new FileOutputStream(filePath);
            workbook.write((OutputStream)file);
            file.close();
            return filePath;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    public String exportTeamCapacity(SessionBoard sessionBoard, List<PiTeamCapacity> teamsCapacity, PiTeamCapacity teamCapacity, String type, String teamId, List<Team> teamList, List<String> filteredColumns) {
        try {
            String fileName = new Date().getTime() + ".xls";
            String filePath = this.env.getProperty("temp.file.location") + fileName;
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet wSheet = workbook.createSheet("Teams Capacity");
            HSSFCellStyle globalCellStyle = workbook.createCellStyle();
            int index = 2;
            int value = 0;
            HSSFCellStyle sHeaderStyle = workbook.createCellStyle();
            HSSFFont fontextBold = workbook.createFont();
            fontextBold.setFontName("Arial");
            fontextBold.setFontHeight((short)230);
            fontextBold.setBold(true);
            sHeaderStyle.setFont(fontextBold);
            sHeaderStyle.setBorderBottom(BorderStyle.THIN);
            sHeaderStyle.setBorderTop(BorderStyle.THIN);
            sHeaderStyle.setBorderRight(BorderStyle.THIN);
            sHeaderStyle.setBorderLeft(BorderStyle.THIN);
            HSSFCellStyle sHeaderStyletwo = workbook.createCellStyle();
            HSSFCellStyle sHeaderStyleThree = workbook.createCellStyle();
            sHeaderStyletwo.setFillForegroundColor(IndexedColors.GOLD.index);
            sHeaderStyletwo.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            sHeaderStyle.setFont(fontextBold);
            if (type.equals("team") && PropertyValidator.isValid((Object)teamId)) {
                index = 3;
                String teamName = "";
                String location = "";
                HSSFRow sHeader = wSheet.createRow(0);
                sHeader.setHeight((short)500);
                HSSFCell sCell = sHeader.createCell(0);
                HSSFRow sHeader2 = wSheet.createRow(1);
                HSSFCell sCell2 = sHeader2.createCell(0);
                HSSFCell sCell3 = sHeader2.createCell(1);
                sCell.setCellStyle(sHeaderStyle);
                sCell2.setCellStyle(sHeaderStyletwo);
                sCell3.setCellStyle(sHeaderStyleThree);
                sHeaderStyletwo.setBorderBottom(BorderStyle.THIN);
                sHeaderStyletwo.setBorderTop(BorderStyle.THIN);
                sHeaderStyletwo.setBorderRight(BorderStyle.THIN);
                sHeaderStyletwo.setBorderLeft(BorderStyle.THIN);
                sHeaderStyleThree.setBorderBottom(BorderStyle.THIN);
                sHeaderStyleThree.setBorderTop(BorderStyle.THIN);
                sHeaderStyleThree.setBorderRight(BorderStyle.THIN);
                sHeaderStyleThree.setBorderLeft(BorderStyle.THIN);
                wSheet.setColumnWidth(0, 10000);
                wSheet.setColumnWidth(1, 10000);
                sHeaderStyle.setFont(fontextBold);
                sCell.setCellValue("Team Capacity");
                for (int teamCount = 0; teamCount < teamList.size(); ++teamCount) {
                    if (!teamList.get(teamCount).getId().equals(teamId)) continue;
                    teamName = teamList.get(teamCount).getTitle();
                    for (int c = 0; c < teamCapacity.getSites().size(); ++c) {
                        location = location + "   [ " + ((PiSite)teamCapacity.getSites().get(c)).getCity() + ", " + ((PiSite)teamCapacity.getSites().get(c)).getCountry() + ", " + ((PiSite)teamCapacity.getSites().get(c)).getTimeZone() + " ]";
                    }
                }
                sCell2.setCellValue(teamName);
                sCell3.setCellValue(location);
                value = 2;
            } else if (!PropertyValidator.isValid((Object)teamId)) {
                HSSFRow sHeader = wSheet.createRow(0);
                HSSFCell sCell = sHeader.createCell(0);
                sCell.setCellStyle(sHeaderStyle);
                short height = 500;
                sHeader.setHeight(height);
                sHeaderStyle.setBorderBottom(BorderStyle.THIN);
                sHeaderStyle.setBorderTop(BorderStyle.THIN);
                sHeaderStyle.setBorderRight(BorderStyle.THIN);
                sHeaderStyle.setBorderLeft(BorderStyle.THIN);
                sCell.setCellValue("Program Level Capacity");
                value = 1;
            }
            if (type.equals("team")) {
                HSSFRow wRow = wSheet.createRow(value);
                ArrayList<String> headers = new ArrayList<String>();
                if (PropertyValidator.isValid((Object)teamId)) {
                    headers.add("Name");
                } else if (!PropertyValidator.isValid((Object)teamId)) {
                    headers.add("Team");
                }
                for (Container container : sessionBoard.getContainers()) {
                    headers.add(container.getTitle());
                }
                if (!PropertyValidator.isValid((Object)teamId)) {
                    headers.add("Total");
                } else if (PropertyValidator.isValid((Object)teamId)) {
                    headers.add("Sum");
                    for (String allowedFilters : filteredColumns) {
                        if (allowedFilters.equals("Role")) {
                            headers.add("Role");
                        }
                        if (!allowedFilters.equals("Location")) continue;
                        headers.add("Location");
                    }
                }
                for (int j = 0; j < headers.size(); ++j) {
                    HSSFCell cell = wRow.createCell((int)((short)j));
                    HSSFCellStyle cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
                    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    cell.setCellStyle(cellStyle);
                    wSheet.setColumnWidth(j, 5000);
                    cellStyle.setBorderBottom(BorderStyle.THIN);
                    cellStyle.setBorderTop(BorderStyle.THIN);
                    cellStyle.setBorderRight(BorderStyle.THIN);
                    cellStyle.setBorderLeft(BorderStyle.THIN);
                    cell.setCellValue((String)headers.get(j));
                }
                this.exportSingleCapacity(sessionBoard, teamsCapacity, teamCapacity, type, teamId, wSheet, index, teamList, filteredColumns, globalCellStyle);
            } else if (type.equals("All")) {
                index = 2;
                HSSFRow titleRow = wSheet.createRow(0);
                HSSFCell titleCell = titleRow.createCell(0);
                HSSFCellStyle titleCellStyle = workbook.createCellStyle();
                titleCell.setCellStyle(sHeaderStyle);
                wSheet.setColumnWidth(0, 5000);
                short height = 500;
                titleRow.setHeight(height);
                titleCell.setCellValue("Program Level Capacity");
                for (int i = 0; i < teamsCapacity.size(); ++i) {
                    if (i == 0) {
                        ArrayList<String> headers = new ArrayList<String>();
                        headers.add("Team");
                        for (Container container : sessionBoard.getContainers()) {
                            headers.add(container.getTitle());
                        }
                        headers.add("Total");
                        HSSFRow wRow = wSheet.createRow(1);
                        for (int j = 0; j < headers.size(); ++j) {
                            HSSFCell cell = wRow.createCell((int)((short)j));
                            HSSFCellStyle cellStyle = workbook.createCellStyle();
                            cellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
                            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                            cell.setCellStyle(cellStyle);
                            wSheet.setColumnWidth(j, 5000);
                            cellStyle.setBorderBottom(BorderStyle.THIN);
                            cellStyle.setBorderTop(BorderStyle.THIN);
                            cellStyle.setBorderRight(BorderStyle.THIN);
                            cellStyle.setBorderLeft(BorderStyle.THIN);
                            cell.setCellValue((String)headers.get(j));
                        }
                        index = this.exportSingleCapacity(sessionBoard, teamsCapacity, null, "team", null, wSheet, index, teamList, filteredColumns, globalCellStyle);
                        index += 2;
                        if (teamList.size() > 0) {
                            titleRow = wSheet.createRow(index);
                            titleCell = titleRow.createCell(0);
                            titleCellStyle = workbook.createCellStyle();
                            titleCellStyle.setBorderBottom(BorderStyle.THIN);
                            titleCellStyle.setBorderTop(BorderStyle.THIN);
                            titleCellStyle.setBorderRight(BorderStyle.THIN);
                            titleCellStyle.setBorderLeft(BorderStyle.THIN);
                            titleCellStyle.setFont(fontextBold);
                            titleCell.setCellStyle(titleCellStyle);
                            wSheet.setColumnWidth(0, 5000);
                            titleRow.setHeight(height);
                            titleCell.setCellValue("Teams Capacity");
                            ++index;
                        }
                    }
                    for (int teamCount = 0; teamCount < teamList.size(); ++teamCount) {
                        if (!teamList.get(teamCount).getTitle().equals(teamsCapacity.get(i).getTeam().getTitle())) continue;
                        String location = "";
                        HSSFRow tRow = wSheet.createRow(index);
                        HSSFCell tCell = tRow.createCell(0);
                        HSSFCell lCell = tRow.createCell(1);
                        HSSFCellStyle tCellStyle = workbook.createCellStyle();
                        tCellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
                        tCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                        tCell.setCellStyle(tCellStyle);
                        tCellStyle.setBorderBottom(BorderStyle.THIN);
                        tCellStyle.setBorderTop(BorderStyle.THIN);
                        tCellStyle.setBorderRight(BorderStyle.THIN);
                        tCellStyle.setBorderLeft(BorderStyle.THIN);
                        wSheet.setColumnWidth(0, 15000);
                        for (int c = 0; c < teamsCapacity.get(i).getSites().size(); ++c) {
                            location = location + "   [ " + ((PiSite)teamsCapacity.get(i).getSites().get(c)).getCity() + ", " + ((PiSite)teamsCapacity.get(i).getSites().get(c)).getCountry() + ", " + ((PiSite)teamsCapacity.get(i).getSites().get(c)).getTimeZone() + " ]";
                        }
                        tCell.setCellValue(teamsCapacity.get(i).getTeam().getTitle());
                        lCell.setCellValue(location);
                        HSSFRow wRow = wSheet.createRow(++index);
                        ArrayList<String> headers = new ArrayList<String>();
                        headers.add("Name");
                        for (Container container : sessionBoard.getContainers()) {
                            headers.add(container.getTitle());
                        }
                        headers.add("Sum");
                        for (String allowedFilters : filteredColumns) {
                            if (allowedFilters.equals("Role")) {
                                headers.add("Role");
                            }
                            if (!allowedFilters.equals("Location")) continue;
                            headers.add("Location");
                        }
                        for (int j = 0; j < headers.size(); ++j) {
                            HSSFCell cell = wRow.createCell((int)((short)j));
                            HSSFCellStyle cellStyle = workbook.createCellStyle();
                            cellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
                            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                            cell.setCellStyle(cellStyle);
                            cellStyle.setBorderBottom(BorderStyle.THIN);
                            cellStyle.setBorderTop(BorderStyle.THIN);
                            cellStyle.setBorderRight(BorderStyle.THIN);
                            cellStyle.setBorderLeft(BorderStyle.THIN);
                            wSheet.setColumnWidth(j, 5000);
                            cell.setCellValue((String)headers.get(j));
                        }
                        ++index;
                        index = this.exportSingleCapacity(sessionBoard, teamsCapacity, teamsCapacity.get(i), "team", teamsCapacity.get(i).getTeam().getId(), wSheet, index, teamList, filteredColumns, globalCellStyle);
                        index += 2;
                    }
                }
            }
            FileOutputStream file = new FileOutputStream(filePath);
            workbook.write((OutputStream)file);
            file.close();
            return filePath;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    private void convertDoubleToInt(ArrayList<String> rowData, Double number) {
        int intSumValue = number.intValue();
        if (number == (double)intSumValue) {
            rowData.add(String.valueOf(intSumValue));
        } else {
            rowData.add(String.valueOf(number));
        }
    }

    public int exportSingleCapacity(SessionBoard sessionBoard, List<PiTeamCapacity> teamsCapacity, PiTeamCapacity teamCapacity, String type, String teamId, HSSFSheet wSheet, int index, List<Team> teamList, List<String> filteredColumns, HSSFCellStyle globalCellStyle) throws Exception {
        block16: {
            List boardItems;
            block15: {
                boardItems = this.itemRepository.findBySessionBoardsInAndType(Collections.singletonList(sessionBoard), "UserStory");
                if (!type.equals("team") || !PropertyValidator.isValid((Object)teamId)) break block15;
                for (PiUserCapacity userCapacity : teamCapacity.getUsersCapacity()) {
                    ArrayList<String> rowData = new ArrayList<String>();
                    HSSFRow wRows = wSheet.createRow(index);
                    rowData.add(userCapacity.getUser().getFullName());
                    for (PiContainerCapacity containerCapacity : userCapacity.getContainersCapacity()) {
                        Double assignedUserCapacityByTeam = this.assignedUserItemsCapacityBySprint(teamCapacity.getTeam(), userCapacity.getUser(), containerCapacity.getContainerId(), boardItems);
                        Double doneUserCapacityBySprint = this.doneUserItemsCapacityBySprint(teamCapacity.getTeam(), userCapacity.getUser(), containerCapacity.getContainerId(), boardItems);
                        double userCapacityBySprint = Double.parseDouble(decfor.format(containerCapacity.getCapacity()));
                        String dataValue = (int)userCapacityBySprint + " | " + assignedUserCapacityByTeam.intValue() + " (" + doneUserCapacityBySprint.intValue() + ")";
                        rowData.add(dataValue);
                    }
                    Double assignedUserCapacity = this.assignedUserItemsCapacity(teamCapacity.getTeam(), userCapacity.getUser(), boardItems);
                    Double doneUserCapacity = this.doneUserItemsCapacity(teamCapacity.getTeam(), userCapacity.getUser(), boardItems);
                    Double totalUserCapacity = this.sumOfUserCapacity(userCapacity);
                    String dataValue = totalUserCapacity.intValue() + " | " + assignedUserCapacity.intValue() + " (" + doneUserCapacity.intValue() + ")";
                    rowData.add(dataValue);
                    int cellNum = 0;
                    for (int j = 0; j < rowData.size(); ++j) {
                        cellNum = j;
                        HSSFCell cell = wRows.createCell((int)((short)j));
                        globalCellStyle.setBorderBottom(BorderStyle.THIN);
                        globalCellStyle.setBorderTop(BorderStyle.THIN);
                        globalCellStyle.setBorderRight(BorderStyle.THIN);
                        globalCellStyle.setBorderLeft(BorderStyle.THIN);
                        cell.setCellStyle(globalCellStyle);
                        cell.setCellValue((String)rowData.get(j));
                    }
                    String userRole = "";
                    String userLocation = "";
                    for (String allowedFilters : filteredColumns) {
                        if (allowedFilters.equals("Role") && userCapacity.getSystemRole() != null) {
                            userRole = userCapacity.getSystemRole().getTitle();
                            HSSFCell roleCell = wRows.createCell((int)((short)(++cellNum)));
                            globalCellStyle.setBorderBottom(BorderStyle.THIN);
                            globalCellStyle.setBorderTop(BorderStyle.THIN);
                            globalCellStyle.setBorderRight(BorderStyle.THIN);
                            globalCellStyle.setBorderLeft(BorderStyle.THIN);
                            roleCell.setCellStyle(globalCellStyle);
                            roleCell.setCellValue(userRole);
                        }
                        if (!allowedFilters.equals("Location") || userCapacity.getSite() == null) continue;
                        userLocation = userCapacity.getSite().getCity();
                        HSSFCell locationCell = wRows.createCell((int)((short)(++cellNum)));
                        globalCellStyle.setBorderBottom(BorderStyle.THIN);
                        globalCellStyle.setBorderTop(BorderStyle.THIN);
                        globalCellStyle.setBorderRight(BorderStyle.THIN);
                        globalCellStyle.setBorderLeft(BorderStyle.THIN);
                        locationCell.setCellStyle(globalCellStyle);
                        locationCell.setCellValue(userLocation);
                    }
                    ++index;
                }
                HSSFRow wRows = wSheet.createRow(index);
                ArrayList<String> rowData = new ArrayList<String>();
                rowData.add("Team Capacity");
                for (int i = 0; i < sessionBoard.getContainers().size(); ++i) {
                    Double assignedTeamCapacityBySprint = this.assignedTeamItemsCapacityBySprint(teamCapacity.getTeam(), (Container)sessionBoard.getContainers().get(i), boardItems);
                    Double doneTeamCapacityBySprint = this.doneTeamItemsCapacityBySprint(teamCapacity.getTeam(), (Container)sessionBoard.getContainers().get(i), boardItems);
                    Double totalTeamCapacityBySprint = this.sumOfSprintCapacity(teamCapacity, null, i);
                    String dataValue = totalTeamCapacityBySprint.intValue() + " | " + assignedTeamCapacityBySprint.intValue() + " (" + doneTeamCapacityBySprint.intValue() + ")";
                    rowData.add(dataValue);
                }
                Double assignedTeamCapacity = this.assignedTeamItemsCapacity(teamCapacity.getTeam(), boardItems);
                Double doneTeamCapacity = this.doneTeamItemsCapacity(teamCapacity.getTeam(), boardItems);
                Double totalTeamCapacity = this.sumOfTeamCapacity(teamCapacity);
                String dataValue = totalTeamCapacity.intValue() + " | " + assignedTeamCapacity.intValue() + " (" + doneTeamCapacity.intValue() + ")";
                rowData.add(dataValue);
                for (int j = 0; j < rowData.size(); ++j) {
                    HSSFCell cell = wRows.createCell((int)((short)j));
                    globalCellStyle.setBorderBottom(BorderStyle.THIN);
                    globalCellStyle.setBorderTop(BorderStyle.THIN);
                    globalCellStyle.setBorderRight(BorderStyle.THIN);
                    globalCellStyle.setBorderLeft(BorderStyle.THIN);
                    cell.setCellStyle(globalCellStyle);
                    cell.setCellValue((String)rowData.get(j));
                }
                break block16;
            }
            if (!type.equals("team") || PropertyValidator.isValid((Object)teamId)) break block16;
            for (PiTeamCapacity tc : teamsCapacity) {
                for (int count = 0; count < teamList.size(); ++count) {
                    if (!tc.getTeam().getTitle().equals(teamList.get(count).getTitle())) continue;
                    ArrayList rowData = new ArrayList();
                    HSSFRow wRows = wSheet.createRow(index);
                    rowData.add(tc.getTeam().getTitle());
                    for (int i = 0; i < sessionBoard.getContainers().size(); ++i) {
                        Double assginedTeamCapacityBySprint = this.assignedTeamItemsCapacityBySprint(tc.getTeam(), (Container)sessionBoard.getContainers().get(i), boardItems);
                        Double doneTeamCapacityBySprint = this.doneTeamItemsCapacityBySprint(tc.getTeam(), (Container)sessionBoard.getContainers().get(i), boardItems);
                        Double totalTeamCapacityBySprint = this.sumOfSprintCapacity(tc, null, i);
                        String dataValue = totalTeamCapacityBySprint.intValue() + " | " + assginedTeamCapacityBySprint.intValue() + " (" + doneTeamCapacityBySprint.intValue() + ")";
                        rowData.add(dataValue);
                    }
                    Double assignedTeamCapcity = this.assignedTeamItemsCapacity(tc.getTeam(), boardItems);
                    Double doneTeamCapacity = this.doneTeamItemsCapacity(tc.getTeam(), boardItems);
                    Double totalTeamCapacity = this.sumOfTeamCapacity(tc);
                    String dataValue = totalTeamCapacity.intValue() + " | " + assignedTeamCapcity.intValue() + " (" + doneTeamCapacity.intValue() + ")";
                    rowData.add(dataValue);
                    for (int j = 0; j < rowData.size(); ++j) {
                        HSSFCell cell = wRows.createCell((int)((short)j));
                        globalCellStyle.setBorderBottom(BorderStyle.THIN);
                        globalCellStyle.setBorderTop(BorderStyle.THIN);
                        globalCellStyle.setBorderRight(BorderStyle.THIN);
                        globalCellStyle.setBorderLeft(BorderStyle.THIN);
                        cell.setCellStyle(globalCellStyle);
                        cell.setCellValue((String)rowData.get(j));
                    }
                    ++index;
                }
            }
            HSSFRow wRows = wSheet.createRow(index);
            ArrayList<String> rowData = new ArrayList<String>();
            rowData.add("");
            ArrayList<PiTeamCapacity> selectedTeamCapacity = new ArrayList<PiTeamCapacity>();
            for (Team selectedTeam : teamList) {
                for (PiTeamCapacity tc : teamsCapacity) {
                    if (!selectedTeam.getId().equals(tc.getTeam().getId())) continue;
                    selectedTeamCapacity.add(tc);
                }
            }
            for (int i = 0; i < sessionBoard.getContainers().size(); ++i) {
                Double assignedSprintCapacity = this.assignedItemsCapacityBySprint(teamsCapacity, (Container)sessionBoard.getContainers().get(i), boardItems);
                Double doneSprintItemsCapacity = this.doneItemsCapacityBySprint(teamsCapacity, (Container)sessionBoard.getContainers().get(i), boardItems);
                Double allSprintItemsCapacity = this.sumOfSprintCapacity(null, selectedTeamCapacity, i);
                String dataValue = allSprintItemsCapacity.intValue() + " | " + assignedSprintCapacity.intValue() + " (" + doneSprintItemsCapacity.intValue() + ")";
                rowData.add(dataValue);
            }
            Double assignedCapacity = this.assignedItemsCapacity(teamsCapacity, boardItems);
            Double allDoneItemsCapacity = this.doneItemsCapacity(teamsCapacity, boardItems);
            Double allItemsCapacity = this.sumOfAllUserCapacityOfAllTeams(selectedTeamCapacity);
            String dataValue = allItemsCapacity.intValue() + " | " + assignedCapacity.intValue() + " (" + allDoneItemsCapacity.intValue() + ")";
            rowData.add(dataValue);
            for (int j = 0; j < rowData.size(); ++j) {
                HSSFCell cell = wRows.createCell((int)((short)j));
                globalCellStyle.setBorderBottom(BorderStyle.THIN);
                globalCellStyle.setBorderTop(BorderStyle.THIN);
                globalCellStyle.setBorderRight(BorderStyle.THIN);
                globalCellStyle.setBorderLeft(BorderStyle.THIN);
                cell.setCellStyle(globalCellStyle);
                cell.setCellValue((String)rowData.get(j));
            }
        }
        return index;
    }

    private List<Item> doneItems(List<PiTeamCapacity> teamCapacities, List<Item> items) throws Exception {
        return teamCapacities.stream().flatMap(tc -> this.filterDoneItemsByTeam(tc.getTeam(), items).stream()).collect(Collectors.toList());
    }

    private List<Item> assignedItems(List<PiTeamCapacity> teamCapacities, List<Item> items) throws Exception {
        return teamCapacities.stream().flatMap(tc -> this.filterAssignedItemsByTeam(tc.getTeam(), items).stream()).collect(Collectors.toList());
    }

    private Double assignedItemsCapacity(List<PiTeamCapacity> teamCapacities, List<Item> items) throws Exception {
        return this.calculateTotalStoryPoints(this.assignedItems(teamCapacities, items));
    }

    private Double doneItemsCapacity(List<PiTeamCapacity> teamCapacities, List<Item> items) throws Exception {
        return this.calculateTotalStoryPoints(this.doneItems(teamCapacities, items));
    }

    private List<Item> doneItemsBySprint(List<PiTeamCapacity> teamCapacities, Container sprint, List<Item> items) throws Exception {
        return teamCapacities.stream().flatMap(tc -> this.filterDoneItemsByTeamAndSprint(tc.getTeam(), sprint.getId(), items).stream()).collect(Collectors.toList());
    }

    private List<Item> assignedItemsBySprint(List<PiTeamCapacity> teamCapacities, Container sprint, List<Item> items) throws Exception {
        return teamCapacities.stream().flatMap(tc -> this.filterAssignedItemsByTeamAndSprint(tc.getTeam(), sprint.getId(), items).stream()).collect(Collectors.toList());
    }

    private Double assignedItemsCapacityBySprint(List<PiTeamCapacity> teamCapacities, Container sprint, List<Item> items) throws Exception {
        return this.calculateTotalStoryPoints(this.assignedItemsBySprint(teamCapacities, sprint, items));
    }

    private Double doneItemsCapacityBySprint(List<PiTeamCapacity> teamCapacities, Container sprint, List<Item> items) throws Exception {
        return this.calculateTotalStoryPoints(this.doneItemsBySprint(teamCapacities, sprint, items));
    }

    private List<Item> doneTeamItems(Team team, List<Item> items) throws Exception {
        return this.filterDoneItemsByTeam(team, items);
    }

    private List<Item> assignedTeamItems(Team team, List<Item> items) throws Exception {
        return this.filterAssignedItemsByTeam(team, items);
    }

    private Double assignedTeamItemsCapacity(Team team, List<Item> items) throws Exception {
        return this.calculateTotalStoryPoints(this.assignedTeamItems(team, items));
    }

    private Double doneTeamItemsCapacity(Team team, List<Item> items) throws Exception {
        return this.calculateTotalStoryPoints(this.doneTeamItems(team, items));
    }

    private List<Item> doneTeamItemsBySprint(Team team, String sprint, List<Item> items) throws Exception {
        return this.filterDoneItemsByTeamAndSprint(team, sprint, items);
    }

    private Double doneTeamItemsCapacityBySprint(Team team, Container sprint, List<Item> items) throws Exception {
        return this.calculateTotalStoryPoints(this.doneTeamItemsBySprint(team, sprint.getId(), items));
    }

    private List<Item> assignedTeamItemsBySprint(Team team, String sprint, List<Item> items) throws Exception {
        return this.filterAssignedItemsByTeamAndSprint(team, sprint, items);
    }

    private Double assignedTeamItemsCapacityBySprint(Team team, Container sprint, List<Item> items) throws Exception {
        return this.calculateTotalStoryPoints(this.assignedTeamItemsBySprint(team, sprint.getId(), items));
    }

    private List<Item> doneUserItems(Team team, User user, List<Item> items) throws Exception {
        return this.filterDoneItemsByTeamAndUser(team, user, items);
    }

    private Double doneUserItemsCapacity(Team team, User user, List<Item> items) throws Exception {
        return this.calculateTotalStoryPoints(this.doneUserItems(team, user, items));
    }

    private List<Item> assignedUserItems(Team team, User user, List<Item> items) throws Exception {
        return this.filterAssignedItemsByTeamAndUser(team, user, items);
    }

    private Double assignedUserItemsCapacity(Team team, User user, List<Item> items) throws Exception {
        return this.calculateTotalStoryPoints(this.assignedUserItems(team, user, items));
    }

    private List<Item> doneUserItemsBySprint(Team team, User user, String sprint, List<Item> items) throws Exception {
        return this.filterDoneItemsByTeamSprintAndUser(team, user, sprint, items);
    }

    private List<Item> assignedUserItemsBySprint(Team team, User user, String sprint, List<Item> items) throws Exception {
        return this.filterAssignedItemsByTeamSprintAndUser(team, user, sprint, items);
    }

    private Double assignedUserItemsCapacityBySprint(Team team, User user, String sprint, List<Item> items) throws Exception {
        return this.calculateTotalStoryPoints(this.assignedUserItemsBySprint(team, user, sprint, items));
    }

    private Double doneUserItemsCapacityBySprint(Team team, User user, String sprint, List<Item> items) throws Exception {
        return this.calculateTotalStoryPoints(this.doneUserItemsBySprint(team, user, sprint, items));
    }

    private List<Item> filterDoneItemsByTeam(Team team, List<Item> items) {
        return items.stream().filter(item -> "Done".equals(item.getStatus().getCategory()) && PropertyValidator.isValid((Collection)item.getTeamContainers()) && item.getTeamContainers().stream().anyMatch(tc -> tc.getTeam().getId().equals(team.getId()))).collect(Collectors.toList());
    }

    private List<Item> filterAssignedItemsByTeamAndUser(Team team, User user, List<Item> items) throws Exception {
        return this.filterAssignedItemsByTeam(team, items).stream().filter(item -> this.isAssignedToUser(item, user)).collect(Collectors.toList());
    }

    private List<Item> filterDoneItemsByTeamAndSprint(Team team, String sprintId, List<Item> items) {
        return this.filterDoneItemsByTeam(team, items).stream().filter(item -> PropertyValidator.isValid((Collection)item.getTeamContainers()) && item.getTeamContainers().stream().anyMatch(tc -> sprintId.equals(tc.getContainer().getId()))).collect(Collectors.toList());
    }

    private List<Item> filterDoneItemsByTeamAndUser(Team team, User user, List<Item> items) throws Exception {
        return this.filterDoneItemsByTeam(team, items).stream().filter(item -> this.isAssignedToUser(item, user)).collect(Collectors.toList());
    }

    private List<Item> filterDoneItemsByTeamSprintAndUser(Team team, User user, String sprintId, List<Item> items) throws Exception {
        return this.filterDoneItemsByTeamAndSprint(team, sprintId, items).stream().filter(item -> this.isAssignedToUser(item, user)).collect(Collectors.toList());
    }

    private List<Item> filterAssignedItemsByTeam(Team team, List<Item> items) {
        return items.stream().filter(item -> PropertyValidator.isValid((Collection)item.getTeamContainers()) && item.getTeamContainers().stream().anyMatch(tc -> tc.getTeam().getId().equals(team.getId()))).collect(Collectors.toList());
    }

    private List<Item> filterAssignedItemsByTeamAndSprint(Team team, String sprintId, List<Item> items) {
        return this.filterAssignedItemsByTeam(team, items).stream().filter(item -> PropertyValidator.isValid((Collection)item.getTeamContainers()) && item.getTeamContainers().stream().anyMatch(tc -> sprintId.equals(tc.getContainer().getId()))).collect(Collectors.toList());
    }

    private List<Item> filterAssignedItemsByTeamSprintAndUser(Team team, User user, String sprintId, List<Item> items) throws Exception {
        return this.filterAssignedItemsByTeamAndSprint(team, sprintId, items).stream().filter(item -> this.isAssignedToUser(item, user)).collect(Collectors.toList());
    }

    private Double calculateTotalStoryPoints(List<Item> items) throws Exception {
        return items.stream().mapToDouble(item -> item.getStoryPoints() != null ? item.getStoryPoints() : 0.0).sum();
    }

    private boolean isAssignedToUser(Item item, User user) {
        String assignedTo;
        String assignee;
        String fullName = Stream.of(user.getFirstName(), user.getLastName()).filter(Objects::nonNull).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.joining(" "));
        if (fullName.isEmpty()) {
            return false;
        }
        String normalizedFullName = fullName.toLowerCase();
        if (PropertyValidator.isValid((Object)item.getJiraFieldTextByKey()) && (assignee = (String)item.getJiraFieldTextByKey().get("assignee")) != null && normalizedFullName.equals(assignee.toLowerCase())) {
            return true;
        }
        return PropertyValidator.isValid((Object)item.getTfsFieldByKey()) && (assignedTo = (String)item.getTfsFieldByKey().get("AssignedTo")) != null && normalizedFullName.equals(assignedTo.toLowerCase());
    }

    Double sumOfSprintCapacity(PiTeamCapacity teamCapacity, List<PiTeamCapacity> teamsCapacity, int sprintIndex) {
        Double sum = 0.0;
        if (!PropertyValidator.isValid((Object)teamCapacity)) {
            for (PiTeamCapacity tc : teamsCapacity) {
                for (PiUserCapacity uc : tc.getUsersCapacity()) {
                    sum = sum + (double)((PiContainerCapacity)uc.getContainersCapacity().get(sprintIndex)).getCapacity().floatValue();
                    sum = Double.parseDouble(decfor.format(sum));
                }
            }
        } else {
            for (PiUserCapacity uc : teamCapacity.getUsersCapacity()) {
                sum = sum + (double)((PiContainerCapacity)uc.getContainersCapacity().get(sprintIndex)).getCapacity().floatValue();
                sum = Double.parseDouble(decfor.format(sum));
            }
        }
        return sum;
    }

    Double sumOfUserCapacity(PiUserCapacity uc) {
        Double sum = 0.0;
        for (PiContainerCapacity cc : uc.getContainersCapacity()) {
            sum = sum + (double)cc.getCapacity().floatValue();
            sum = Double.parseDouble(decfor.format(sum));
        }
        return sum;
    }

    Double sumOfAllUserCapacity(PiTeamCapacity teamCapacity) {
        double sum = 0.0;
        for (PiUserCapacity uc : teamCapacity.getUsersCapacity()) {
            sum += this.sumOfUserCapacity(uc).doubleValue();
            sum = Double.parseDouble(decfor.format(sum));
        }
        return sum;
    }

    Double sumOfAllUserCapacityOfAllTeams(List<PiTeamCapacity> teamsCapacity) {
        Double sum = 0.0;
        for (PiTeamCapacity teamCapacity : teamsCapacity) {
            sum = sum + this.sumOfAllUserCapacity(teamCapacity);
            sum = Double.parseDouble(decfor.format(sum));
        }
        return sum;
    }

    Double sumOfTeamCapacity(PiTeamCapacity teamCapacity) {
        Double sum = 0.0;
        for (PiUserCapacity uc : teamCapacity.getUsersCapacity()) {
            for (PiContainerCapacity cc : uc.getContainersCapacity()) {
                sum = sum + (double)cc.getCapacity().floatValue();
                sum = Double.parseDouble(decfor.format(sum));
            }
        }
        return sum;
    }

    public static String fmt(double d) {
        if (d == (double)((long)d)) {
            return String.format("%d", (long)d);
        }
        return String.format("%s", d);
    }

    public String exportQuestionAnswers(List<Team> selectedTeams, List<Question> questions, List<Answer> answers, int totalTeams) {
        HashMap<String, Team> selectedTeamMap = new HashMap<String, Team>();
        for (Team team : selectedTeams) {
            selectedTeamMap.put(team.getId(), team);
        }
        String fileName = new Date().getTime() + ".xls";
        String filePath = this.env.getProperty("temp.file.location") + fileName;
        int maxSize = selectedTeams.size();
        try {
            String[] teamRoleHeader = new String[maxSize];
            String[] header = new String[maxSize + 1];
            header[0] = "SOS Sync Questions";
            for (int i = 0; i < selectedTeams.size(); ++i) {
                teamRoleHeader[i] = selectedTeams.get(i).getTitle().toString();
                header[i + 1] = selectedTeams.get(i).getTitle().toString();
            }
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet wSheet = workbook.createSheet("Planning SOS");
            HSSFRow wRow = wSheet.createRow(0);
            HSSFCellStyle qCellStyle = workbook.createCellStyle();
            qCellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
            qCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            HSSFCell questionHeader = wRow.createCell(0);
            questionHeader.setCellStyle(qCellStyle);
            qCellStyle.setBorderBottom(BorderStyle.THIN);
            qCellStyle.setBorderTop(BorderStyle.THIN);
            qCellStyle.setBorderRight(BorderStyle.THIN);
            qCellStyle.setBorderLeft(BorderStyle.THIN);
            wSheet.setColumnWidth(0, 15000);
            HashMap<String, String> voteByTeams = new HashMap<String, String>();
            if (selectedTeams.size() > 0) {
                for (int j = 1; j <= teamRoleHeader.length; ++j) {
                    HSSFCell cell = wRow.createCell((int)((short)j));
                    HSSFCellStyle cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
                    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    cell.setCellStyle(cellStyle);
                    cellStyle.setBorderBottom(BorderStyle.THIN);
                    cellStyle.setBorderTop(BorderStyle.THIN);
                    cellStyle.setBorderRight(BorderStyle.THIN);
                    cellStyle.setBorderLeft(BorderStyle.THIN);
                    cell.setCellValue(teamRoleHeader[j - 1]);
                }
            }
            int index = 0;
            for (int k = 0; k < questions.size(); ++k) {
                index = k + 1;
                HSSFRow answerDataRow = wSheet.createRow(index);
                for (int j = 0; j < header.length; ++j) {
                    HSSFCell dataCell = answerDataRow.createCell((int)((short)j));
                    HSSFCellStyle cellStyle = workbook.createCellStyle();
                    cellStyle.setWrapText(true);
                    dataCell.setCellStyle(cellStyle);
                    cellStyle.setBorderBottom(BorderStyle.THIN);
                    cellStyle.setBorderTop(BorderStyle.THIN);
                    cellStyle.setBorderRight(BorderStyle.THIN);
                    cellStyle.setBorderLeft(BorderStyle.THIN);
                    if (header[j].equals("SOS Sync Questions")) {
                        dataCell.setCellValue(questions.get(k).getQuestionText());
                        continue;
                    }
                    if (selectedTeams.size() <= 0) continue;
                    for (int answer = 0; answer < answers.size(); ++answer) {
                        if (!answers.get(answer).getTeam().getTitle().equals(header[j]) || !questions.get(k).getId().equals(answers.get(answer).getQuestion().getId())) continue;
                        if (answers.get(answer).getSelectedAnswer() != null) {
                            dataCell.setCellValue(answers.get(answer).getSelectedAnswer());
                        } else {
                            dataCell.setCellValue("");
                        }
                        if (answers.get(answer).getSelectedAnswer() == null || answers.get(answer).getSelectedAnswer().equals("")) continue;
                        voteByTeams.put(answers.get(answer).getTeam().getId(), answers.get(answer).getTeam().getId());
                    }
                }
            }
            Integer countOfquestionAnsweredByTeam = 0;
            for (String teamId : voteByTeams.keySet()) {
                if (!PropertyValidator.isValid(selectedTeamMap.get(teamId))) continue;
                countOfquestionAnsweredByTeam = countOfquestionAnsweredByTeam + 1;
            }
            questionHeader.setCellValue("SOS Sync Questions  " + countOfquestionAnsweredByTeam + "/" + selectedTeams.size() + " Teams");
            FileOutputStream file = new FileOutputStream(filePath);
            workbook.write((OutputStream)file);
            file.close();
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return filePath;
    }

    public String exportNewObjectiveData(int exportAs, List<HashMap<String, Object>> data, List<HashMap<String, String>> columns, String sessionId, List<Object> groupIds, HashMap<String, Double> groupCompletions) {
        ModuleConfiguration objectiveMenuPermission = this.objectiveMenuPermissionsRepository.findOneBySessionId(sessionId);
        Map<Object, List<HashMap>> groupedData = data.stream().collect(Collectors.groupingBy(item -> item.get("groupId")));
        if (exportAs == 0) {
            return this.writeNewObjectiveCSVFile(groupedData, columns, objectiveMenuPermission, groupIds);
        }
        try {
            String fileName = new Date().getTime() + ".xls";
            String filePath = this.env.getProperty("temp.file.location") + fileName;
            FileOutputStream file = new FileOutputStream(filePath);
            HSSFWorkbook workbook = new HSSFWorkbook();
            if (objectiveMenuPermission.getOkrEnabled()) {
                HSSFSheet worksheet = workbook.createSheet("New Format");
                this.writeNewObjectiveExcelFile(worksheet, workbook, groupedData, columns, objectiveMenuPermission, groupIds, groupCompletions);
            }
            HSSFSheet worksheet2 = workbook.createSheet("Old Format");
            this.exportObjectivesOnOldModel(worksheet2, workbook, groupedData, columns, objectiveMenuPermission, groupIds, groupCompletions);
            workbook.write((OutputStream)file);
            file.close();
            return filePath;
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeNewObjectiveCSVFile(Map<Object, List<HashMap<String, Object>>> list, List<HashMap<String, String>> columns, ModuleConfiguration objectiveMenuPermission, List<Object> groupIds) {
        CsvMapWriter writer = null;
        if (PropertyValidator.isValid((Object)objectiveMenuPermission)) {
            columns.forEach(column -> {
                if (!objectiveMenuPermission.getBVAchievementEnabled() && (((String)column.get("key")).equals("bvActual") || ((String)column.get("key")).equals("bvPlan"))) {
                    column.put("isShow", "false");
                }
                if (!objectiveMenuPermission.getStatusEnabled() && (((String)column.get("key")).equals("objectiveStatus") || ((String)column.get("key")).equals("objectiveDescription"))) {
                    column.put("isShow", "false");
                }
                if (!objectiveMenuPermission.isOkrStatusEnabled() && (((String)column.get("key")).equals("okrStatus") || ((String)column.get("key")).equals("okrDescription"))) {
                    column.put("isShow", "false");
                }
                if (!objectiveMenuPermission.getOkrBVAchievementEnabled()) {
                    if (((String)column.get("key")).equals("keyResult") || ((String)column.get("key")).equals("okrBvPlanned") || ((String)column.get("key")).equals("okrBvActual") || ((String)column.get("key")).equals("keyResultLinkCardsId") || ((String)column.get("key")).equals("objectiveIds") || ((String)column.get("key")).equals("progress") || ((String)column.get("key")).equals("targetValue")) {
                        column.put("isShow", "false");
                    }
                } else if (((String)column.get("key")).equals("groupName")) {
                    column.put("isShow", "true");
                }
                if (!objectiveMenuPermission.getOkrEnabled() && ((String)column.get("key")).equals("keyResultId")) {
                    column.put("isShow", "false");
                }
            });
        }
        List filteredList = columns.stream().filter(map -> Boolean.parseBoolean((String)map.get("isShow"))).collect(Collectors.toList());
        try {
            String fileName = new Date().getTime() + ".csv";
            String filePath = this.env.getProperty("temp.file.location") + fileName;
            FileOutputStream os = new FileOutputStream(filePath);
            writer = new CsvMapWriter((Writer)new OutputStreamWriter((OutputStream)os, "UTF-8"), CsvPreference.EXCEL_PREFERENCE);
            String[] completeHeader = new String[filteredList.size()];
            for (int j = 0; j < filteredList.size(); ++j) {
                HashMap column2 = (HashMap)filteredList.get(j);
                completeHeader[j] = (String)column2.get("value");
            }
            writer.writeHeader(completeHeader);
            CsvMapWriter finalWriter = writer;
            groupIds.forEach(arg_0 -> this.lambda$writeNewObjectiveCSVFile$27(list, filteredList, (ICsvMapWriter)finalWriter, completeHeader, arg_0));
            writer.close();
            os.close();
            String string = filePath;
            return string;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return null;
    }

    public int writeNewObjectiveExcelFile(HSSFSheet worksheet, HSSFWorkbook workbook, Map<Object, List<HashMap<String, Object>>> list, List<HashMap<String, String>> columns, ModuleConfiguration objectiveMenuPermission, List<Object> groupIds, HashMap<String, Double> groupCompletions) throws IOException {
        try {
            String[] excludedColumns = new String[]{"keyResult", "okrBvPlanned", "okrBvActual", "keyResultLinkCardsId", "objectiveIds", "progress", "targetValue", "keyResultId"};
            if (PropertyValidator.isValid((Object)objectiveMenuPermission)) {
                columns.forEach(column -> {
                    if (!objectiveMenuPermission.getBVAchievementEnabled() && (((String)column.get("key")).equals("bvActual") || ((String)column.get("key")).equals("bvPlan"))) {
                        column.put("isShow", "false");
                    }
                    if (!objectiveMenuPermission.getStatusEnabled() && (((String)column.get("key")).equals("objectiveStatus") || ((String)column.get("key")).equals("objectiveDescription"))) {
                        column.put("isShow", "false");
                    }
                    if (!objectiveMenuPermission.isOkrStatusEnabled() && (((String)column.get("key")).equals("okrStatus") || ((String)column.get("key")).equals("okrDescription"))) {
                        column.put("isShow", "false");
                    }
                    if (!objectiveMenuPermission.getOkrBVAchievementEnabled()) {
                        if (Arrays.asList(excludedColumns).contains(column.get("key"))) {
                            column.put("isShow", "false");
                        }
                    } else if (((String)column.get("key")).equals("groupName")) {
                        column.put("isShow", "true");
                    }
                    if (!objectiveMenuPermission.getOkrEnabled() && ((String)column.get("key")).equals("keyResultId")) {
                        column.put("isShow", "false");
                    }
                });
            }
            List filteredList = columns.stream().filter(map -> Boolean.parseBoolean((String)map.get("isShow"))).collect(Collectors.toList());
            HSSFCellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBorderTop(BorderStyle.THIN);
            cellStyle.setBorderLeft(BorderStyle.THIN);
            cellStyle.setBorderRight(BorderStyle.THIN);
            cellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            HSSFCellStyle rowCellStyle = workbook.createCellStyle();
            rowCellStyle.setBorderBottom(BorderStyle.THIN);
            rowCellStyle.setBorderTop(BorderStyle.THIN);
            rowCellStyle.setBorderLeft(BorderStyle.THIN);
            rowCellStyle.setBorderRight(BorderStyle.THIN);
            rowCellStyle.setFillPattern(FillPatternType.NO_FILL);
            AtomicInteger rowCount = new AtomicInteger(0);
            groupIds.forEach(groupId -> {
                List data = (List)list.get(groupId);
                HSSFRow row = worksheet.createRow(rowCount.getAndIncrement());
                HSSFCell cell = row.createCell(0);
                if (PropertyValidator.isValid((Collection)data) && data.size() > 0) {
                    cell.setCellValue(((HashMap)data.get(0)).get("groupName").toString());
                    row.createCell(1);
                    HSSFCell grpCompletionCell = row.createCell(2);
                    grpCompletionCell.setCellValue(((Double)groupCompletions.get(groupId)).doubleValue());
                    HSSFRow headerRow = worksheet.createRow((int)((short)rowCount.getAndIncrement()));
                    filteredList.forEach(column -> {
                        HSSFCell headerCell = headerRow.createCell((int)((short)filteredList.indexOf(column)));
                        headerCell.setCellStyle(cellStyle);
                        headerCell.setCellValue(((String)column.get("value")).toString());
                    });
                    data.forEach(mp -> {
                        HSSFRow dataRow = worksheet.createRow((int)((short)rowCount.getAndIncrement()));
                        mp.forEach((key, value) -> {
                            String stringValue = value.toString();
                            int colIndex = this.findIndexByKey(filteredList, key);
                            if (colIndex != -1) {
                                HSSFCell rowCell = dataRow.createCell(colIndex);
                                rowCell.setCellStyle(rowCellStyle);
                                if (key.equals("objectiveType")) {
                                    stringValue = stringValue.equals("Objective-Committed") ? "Normal" : "Uncommitted";
                                }
                                rowCell.setCellValue(stringValue);
                            }
                        });
                    });
                }
                worksheet.createRow((int)((short)rowCount.getAndIncrement()));
            });
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return 0;
    }

    private int exportObjectivesOnOldModel(HSSFSheet worksheet, HSSFWorkbook workbook, Map<Object, List<HashMap<String, Object>>> list, List<HashMap<String, String>> columns, ModuleConfiguration objectiveMenuPermission, List<Object> groupIds, HashMap<String, Double> groupCompletions) throws IOException {
        try {
            if (PropertyValidator.isValid((Object)objectiveMenuPermission)) {
                columns.add(0, (HashMap<String, String>)new /* Unavailable Anonymous Inner Class!! */);
                columns.forEach(column -> {
                    if (!objectiveMenuPermission.getBVAchievementEnabled() && (((String)column.get("key")).equals("bvActual") || ((String)column.get("key")).equals("bvPlan"))) {
                        column.put("isShow", "false");
                    }
                    if (!objectiveMenuPermission.getStatusEnabled() && (((String)column.get("key")).equals("objectiveStatus") || ((String)column.get("key")).equals("objectiveDescription"))) {
                        column.put("isShow", "false");
                    }
                    if (!objectiveMenuPermission.isOkrStatusEnabled() && (((String)column.get("key")).equals("okrStatus") || ((String)column.get("key")).equals("okrDescription"))) {
                        column.put("isShow", "false");
                    }
                    if (((String)column.get("key")).equals("keyResult") || ((String)column.get("key")).equals("okrBvPlanned") || ((String)column.get("key")).equals("okrBvActual") || ((String)column.get("key")).equals("keyResultLinkCardsId") || ((String)column.get("key")).equals("objectiveIds") || ((String)column.get("key")).equals("progress") || ((String)column.get("key")).equals("targetValue") || ((String)column.get("key")).equals("keyResultId")) {
                        column.put("isShow", "false");
                    }
                    if (((String)column.get("key")).equals("groupName")) {
                        column.put("isShow", "true");
                    }
                    if (((String)column.get("key")).equals("keyResultId")) {
                        column.put("isShow", "false");
                    }
                });
            }
            List<HashMap> filteredList = columns.stream().filter(map -> Boolean.parseBoolean((String)map.get("isShow"))).collect(Collectors.toList());
            HSSFCellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBorderTop(BorderStyle.THIN);
            cellStyle.setBorderLeft(BorderStyle.THIN);
            cellStyle.setBorderRight(BorderStyle.THIN);
            cellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            HSSFCellStyle rowCellStyle = workbook.createCellStyle();
            rowCellStyle.setBorderBottom(BorderStyle.THIN);
            rowCellStyle.setBorderTop(BorderStyle.THIN);
            rowCellStyle.setBorderLeft(BorderStyle.THIN);
            rowCellStyle.setBorderRight(BorderStyle.THIN);
            rowCellStyle.setFillPattern(FillPatternType.NO_FILL);
            AtomicInteger rowCount = new AtomicInteger(0);
            HSSFRow headerRow = worksheet.createRow((int)((short)rowCount.getAndIncrement()));
            filteredList.forEach(column -> {
                HSSFCell headerCell = headerRow.createCell((int)((short)filteredList.indexOf(column)));
                headerCell.setCellStyle(cellStyle);
                headerCell.setCellValue(((String)column.get("value")).toString());
            });
            groupIds.forEach(groupId -> {
                List data = (List)list.get(groupId);
                if (PropertyValidator.isValid((Collection)data) && data.size() > 0) {
                    data.add(0, new /* Unavailable Anonymous Inner Class!! */);
                    data.forEach(mp -> {
                        HSSFRow dataRow = worksheet.createRow((int)((short)rowCount.getAndIncrement()));
                        mp.forEach((key, value) -> {
                            String stringValue = value.toString();
                            int colIndex = this.findIndexByKey(filteredList, key);
                            if (colIndex != -1) {
                                HSSFCell rowCell = dataRow.createCell(colIndex);
                                rowCell.setCellStyle(rowCellStyle);
                                if (key.equals("objectiveType")) {
                                    stringValue = stringValue.equals("Objective-Committed") ? "Normal" : "Uncommitted";
                                }
                                rowCell.setCellValue(stringValue);
                            }
                        });
                    });
                }
            });
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return 0;
    }

    private int findIndexByKey(List<HashMap<String, String>> list, String key) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).get("key").equals(key)) continue;
            return i;
        }
        return -1;
    }

    public String exportSolutionFeatureDepExcel(Map data) {
        String fileName = new Date().getTime() + ".xlsx";
        String filePath = this.env.getProperty("temp.file.location") + fileName;
        try {
            FileOutputStream os = new FileOutputStream(filePath);
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet worksheet = workbook.createSheet("Summary by PI Boards");
            this.createSummaryByPIBoardsSheet(workbook, worksheet, data);
            XSSFSheet worksheet2 = workbook.createSheet("Summary by Teams");
            this.createSummaryByTeamsSheet(workbook, worksheet2, data);
            workbook.write((OutputStream)os);
            os.flush();
            os.close();
            workbook.close();
            return filePath;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void createSummaryByPIBoardsSheet(XSSFWorkbook workbook, XSSFSheet worksheet, Map data) {
        XSSFCellStyle style;
        ArrayList boards = (ArrayList)data.get("boards");
        HashMap matrix = (HashMap)data.get("data");
        XSSFFont boldFont = workbook.createFont();
        boldFont.setBold(true);
        XSSFCellStyle boldStyle = workbook.createCellStyle();
        boldStyle.setFont((Font)boldFont);
        XSSFFont itallicFont = workbook.createFont();
        itallicFont.setItalic(true);
        XSSFCellStyle itallicStyle = workbook.createCellStyle();
        itallicStyle.setFont((Font)itallicFont);
        XSSFCellStyle thinBorderStyle = workbook.createCellStyle();
        thinBorderStyle.setBorderTop(BorderStyle.THIN);
        thinBorderStyle.setBorderBottom(BorderStyle.THIN);
        thinBorderStyle.setBorderLeft(BorderStyle.THIN);
        thinBorderStyle.setBorderRight(BorderStyle.THIN);
        XSSFCellStyle boldAndBorderstyle = workbook.createCellStyle();
        boldAndBorderstyle.cloneStyleFrom((CellStyle)thinBorderStyle);
        boldAndBorderstyle.setFont((Font)boldFont);
        int rowIndex = 0;
        XSSFRow row = worksheet.createRow((int)((short)rowIndex++));
        XSSFCell cell = row.createCell(0);
        cell.setCellValue("Name of Solution Board");
        cell.setCellStyle((CellStyle)boldStyle);
        worksheet.autoSizeColumn(0);
        cell = row.createCell(1);
        cell.setCellValue((String)data.get("solutionBoardTitle"));
        cell.setCellStyle((CellStyle)itallicStyle);
        int n = ++rowIndex;
        ++rowIndex;
        row = worksheet.createRow((int)((short)n));
        cell = row.createCell(0);
        cell.setCellValue("PI Boards");
        cell.setCellStyle((CellStyle)boldAndBorderstyle);
        int firstRowCellPointer = 1;
        for (int i = 0; i < boards.size(); ++i) {
            HashMap board = (HashMap)boards.get(i);
            String boardColor = (String)board.get("color");
            cell = row.createCell((int)((short)firstRowCellPointer));
            cell.setCellValue((String)board.get("title") + " (Receiver)");
            Color color = Color.decode(boardColor);
            XSSFColor customColor = new XSSFColor(color);
            style = workbook.createCellStyle();
            style.cloneStyleFrom((CellStyle)thinBorderStyle);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setFillForegroundColor(customColor);
            XSSFFont font = workbook.createFont();
            font.setBold(true);
            style.setFont((Font)font);
            cell.setCellStyle((CellStyle)style);
            worksheet.autoSizeColumn((int)((short)firstRowCellPointer));
            ++firstRowCellPointer;
        }
        cell = row.createCell((int)((short)firstRowCellPointer));
        worksheet.autoSizeColumn((int)((short)firstRowCellPointer));
        cell.setCellValue("Total");
        cell.setCellStyle((CellStyle)boldAndBorderstyle);
        int[] columnSum = new int[boards.size() + 1];
        for (int i = 0; i < boards.size(); ++i) {
            HashMap columnboard = (HashMap)boards.get(i);
            row = worksheet.createRow((int)((short)rowIndex++));
            int cellPointer = 0;
            cell = row.createCell((int)((short)cellPointer++));
            cell.setCellValue((String)columnboard.get("title") + " (Creator)");
            Color color = Color.decode((String)columnboard.get("color"));
            XSSFColor customColor = new XSSFColor(color);
            style = workbook.createCellStyle();
            style.cloneStyleFrom((CellStyle)thinBorderStyle);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setFillForegroundColor(customColor);
            cell.setCellStyle((CellStyle)style);
            int rowSum = 0;
            for (int j = 0; j < boards.size(); ++j) {
                HashMap rowBoard = (HashMap)boards.get(j);
                String creatorSessionId = (String)columnboard.get("sessionId");
                String receiverSessionId = (String)rowBoard.get("sessionId");
                cell = row.createCell((int)((short)cellPointer++));
                int value = (Integer)matrix.get(creatorSessionId + "-" + receiverSessionId);
                cell.setCellValue((double)value);
                style = workbook.createCellStyle();
                style.cloneStyleFrom((CellStyle)thinBorderStyle);
                cell.setCellStyle((CellStyle)style);
                rowSum += value;
                columnSum[j] = columnSum[j] + value;
            }
            cell = row.createCell((int)((short)cellPointer++));
            cell.setCellValue((double)rowSum);
            style = workbook.createCellStyle();
            style.cloneStyleFrom((CellStyle)thinBorderStyle);
            cell.setCellStyle((CellStyle)style);
            columnSum[boards.size()] = columnSum[boards.size()] + rowSum;
        }
        int lastRowPointer = 0;
        row = worksheet.createRow((int)((short)rowIndex++));
        cell = row.createCell((int)((short)lastRowPointer++));
        cell.setCellValue("Total");
        cell.setCellStyle((CellStyle)boldAndBorderstyle);
        for (int i = 0; i < columnSum.length; ++i) {
            cell = row.createCell((int)((short)lastRowPointer++));
            cell.setCellValue((double)columnSum[i]);
            style = workbook.createCellStyle();
            style.cloneStyleFrom((CellStyle)thinBorderStyle);
            if (i == columnSum.length - 1) {
                style.setFont((Font)boldFont);
            }
            cell.setCellStyle((CellStyle)style);
        }
    }

    public void createSummaryByTeamsSheet(XSSFWorkbook workbook, XSSFSheet worksheet, Map data) {
        ArrayList boards = (ArrayList)data.get("boards");
        HashMap matrix = (HashMap)data.get("dataByTeams");
        worksheet.setColumnWidth(0, 5000);
        XSSFFont boldFont = workbook.createFont();
        boldFont.setBold(true);
        XSSFCellStyle boldStyle = workbook.createCellStyle();
        boldStyle.setFont((Font)boldFont);
        XSSFFont itallicFont = workbook.createFont();
        itallicFont.setItalic(true);
        XSSFCellStyle itallicStyle = workbook.createCellStyle();
        itallicStyle.setFont((Font)itallicFont);
        XSSFCellStyle thinBorderStyle = workbook.createCellStyle();
        thinBorderStyle.setBorderTop(BorderStyle.THIN);
        thinBorderStyle.setBorderBottom(BorderStyle.THIN);
        thinBorderStyle.setBorderLeft(BorderStyle.THIN);
        thinBorderStyle.setBorderRight(BorderStyle.THIN);
        XSSFCellStyle boldAndBorderstyle = workbook.createCellStyle();
        boldAndBorderstyle.cloneStyleFrom((CellStyle)thinBorderStyle);
        boldAndBorderstyle.setFont((Font)boldFont);
        int rowIndex = 0;
        XSSFRow row = worksheet.createRow((int)((short)rowIndex++));
        XSSFCell cell = row.createCell(0);
        cell.setCellValue("Name of Solution Board");
        cell.setCellStyle((CellStyle)boldStyle);
        worksheet.autoSizeColumn(0);
        cell = row.createCell(1);
        cell.setCellValue((String)data.get("solutionBoardTitle"));
        cell.setCellStyle((CellStyle)itallicStyle);
        int boardNamesRowIndex = ++rowIndex;
        row = worksheet.createRow((int)((short)rowIndex++));
        int receiverTeamsRow = rowIndex;
        row = worksheet.createRow((int)((short)rowIndex++));
        cell = row.createCell(0);
        cell.setCellValue("PI Boards");
        XSSFCellStyle style = workbook.createCellStyle();
        style.cloneStyleFrom((CellStyle)thinBorderStyle);
        style.setFont((Font)boldFont);
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(1);
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(2);
        cell.setCellValue("Teams");
        cell.setCellStyle((CellStyle)style);
        worksheet.autoSizeColumn(2);
        int colNum = 3;
        for (int i = 0; i < boards.size(); ++i) {
            List teams = (List)((HashMap)boards.get(i)).get("teams");
            int size = teams.size() + 1;
            int indexAtBoardName = size / 2;
            String boardColor = (String)((HashMap)boards.get(i)).get("color");
            String boardTitle = (String)((HashMap)boards.get(i)).get("title");
            for (int j = 0; j < size; ++j) {
                row = worksheet.getRow(boardNamesRowIndex);
                cell = row.createCell((int)((short)colNum));
                XSSFRow verticalRow = worksheet.createRow((int)((short)rowIndex++));
                XSSFCell verticalCell = verticalRow.createCell(0);
                Color color = Color.decode(boardColor);
                XSSFColor customColor = new XSSFColor(color);
                style = workbook.createCellStyle();
                style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                style.setFillForegroundColor(customColor);
                cell.setCellStyle((CellStyle)style);
                verticalCell.setCellStyle((CellStyle)style);
                if (j == indexAtBoardName) {
                    cell.setCellValue(boardTitle);
                    verticalCell.setCellValue(boardTitle);
                }
                row = worksheet.getRow(receiverTeamsRow);
                if (j < teams.size()) {
                    String teamColor = (String)((Map)teams.get(j)).get("color");
                    String teamTitle = (String)((Map)teams.get(j)).get("title");
                    cell = row.createCell((int)((short)colNum));
                    color = Color.decode(teamColor);
                    customColor = new XSSFColor(color);
                    style = workbook.createCellStyle();
                    style.cloneStyleFrom((CellStyle)thinBorderStyle);
                    style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    style.setFillForegroundColor(customColor);
                    cell.setCellStyle((CellStyle)style);
                    cell.setCellValue(teamTitle + "- Receiver");
                    verticalCell = verticalRow.createCell(2);
                    verticalCell.setCellStyle((CellStyle)style);
                    verticalCell.setCellValue(teamTitle + "- Creator");
                    worksheet.autoSizeColumn(2);
                    verticalCell = verticalRow.createCell(1);
                    style = workbook.createCellStyle();
                    style.cloneStyleFrom((CellStyle)thinBorderStyle);
                    verticalCell.setCellStyle((CellStyle)style);
                } else {
                    cell = row.createCell((int)((short)colNum));
                    style = workbook.createCellStyle();
                    style.cloneStyleFrom((CellStyle)thinBorderStyle);
                    style.setFont((Font)boldFont);
                    cell.setCellStyle((CellStyle)style);
                    cell.setCellValue("Total");
                    verticalCell = verticalRow.createCell(1);
                    verticalCell.setCellStyle((CellStyle)style);
                    verticalCell.setCellValue("Sub Total");
                }
                worksheet.autoSizeColumn((int)((short)colNum));
                ++colNum;
            }
        }
        row = worksheet.createRow((int)((short)rowIndex++));
        cell = row.createCell(0);
        cell.setCellValue("Total");
        style = workbook.createCellStyle();
        style.cloneStyleFrom((CellStyle)thinBorderStyle);
        style.setFont((Font)boldFont);
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(1);
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(2);
        cell.setCellStyle((CellStyle)style);
        int rowIndexCounter = receiverTeamsRow + 1;
        int grandFinalSum = 0;
        int colIndex = 0;
        HashMap<String, Integer> colSumsMap = new HashMap<String, Integer>();
        for (int i = 0; i < boards.size(); ++i) {
            Map rowBoard = (Map)boards.get(i);
            String rowBoardId = (String)rowBoard.get("sessionId");
            List rowTeams = (List)rowBoard.get("teams");
            int rowSize = rowTeams.size() + 1;
            colIndex = 3;
            int[] grandRowSum = new int[rowTeams.size() + 1];
            int grandTotalofSubTotalCol = 0;
            for (int j = 0; j < boards.size(); ++j) {
                Map colBoard = (Map)boards.get(j);
                String colBoardId = (String)colBoard.get("sessionId");
                List colTeams = (List)colBoard.get("teams");
                int colSize = colTeams.size() + 1;
                Map TeamsMapBySessionId = (Map)matrix.get(rowBoardId + "-" + colBoardId);
                int[] colSubTotal = new int[colSize];
                int[] grandColSum = new int[colSize];
                for (int ii = 0; ii < rowTeams.size(); ++ii) {
                    String rowTeamId = (String)((Map)rowTeams.get(ii)).get("id");
                    int rowSubTotal = 0;
                    for (int jj = 0; jj < colTeams.size(); ++jj) {
                        String colTeamId = (String)((Map)colTeams.get(jj)).get("id");
                        int value = (Integer)TeamsMapBySessionId.get(rowTeamId + "-" + colTeamId);
                        row = worksheet.getRow((short)rowIndexCounter + ii);
                        cell = row.createCell((short)colIndex + jj);
                        cell.setCellValue((double)value);
                        cell.setCellStyle((CellStyle)thinBorderStyle);
                        rowSubTotal += value;
                        colSubTotal[jj] = colSubTotal[jj] + value;
                    }
                    if (row != null) {
                        cell = row.createCell((short)colIndex + colSize - 1);
                        cell.setCellValue((double)rowSubTotal);
                        cell.setCellStyle((CellStyle)thinBorderStyle);
                    }
                    grandRowSum[ii] = grandRowSum[ii] + rowSubTotal;
                    colSubTotal[colSize - 1] = colSubTotal[colSize - 1] + rowSubTotal;
                    if (j != boards.size() - 1 || row == null) continue;
                    cell = row.createCell((short)colIndex + colSize);
                    cell.setCellValue((double)grandRowSum[ii]);
                    cell.setCellStyle((CellStyle)thinBorderStyle);
                    grandTotalofSubTotalCol += grandRowSum[ii];
                }
                for (int jj = 0; jj < colSize; ++jj) {
                    row = worksheet.getRow((short)rowIndexCounter + rowSize - 1);
                    cell = row.createCell((short)colIndex + jj);
                    cell.setCellValue((double)colSubTotal[jj]);
                    cell.setCellStyle((CellStyle)thinBorderStyle);
                    String key = null;
                    if (jj < colSize - 1) {
                        key = colBoardId + "-" + ((Map)colTeams.get(jj)).get("id");
                        if (!PropertyValidator.isValid(colSumsMap.get(key))) {
                            colSumsMap.put(key, 0);
                        }
                    } else {
                        key = colBoardId + "-total";
                        if (!PropertyValidator.isValid(colSumsMap.get(key))) {
                            colSumsMap.put(key, 0);
                        }
                    }
                    colSumsMap.put(key, (Integer)colSumsMap.get(key) + colSubTotal[jj]);
                    if (i != boards.size() - 1) continue;
                    row = worksheet.getRow((short)rowIndexCounter + rowSize);
                    cell = row.createCell((short)colIndex + jj);
                    int value = (Integer)colSumsMap.get(key);
                    cell.setCellValue((double)value);
                    cell.setCellStyle((CellStyle)thinBorderStyle);
                }
                colIndex += colSize;
            }
            row = worksheet.getRow((short)rowIndexCounter + rowSize - 1);
            cell = row.createCell((int)((short)colIndex));
            cell.setCellValue((double)grandTotalofSubTotalCol);
            cell.setCellStyle((CellStyle)thinBorderStyle);
            grandFinalSum += grandTotalofSubTotalCol;
            rowIndexCounter += rowSize;
        }
        row = worksheet.getRow(receiverTeamsRow);
        cell = row.createCell((int)((short)colNum));
        style = workbook.createCellStyle();
        style.cloneStyleFrom((CellStyle)thinBorderStyle);
        style.setFont((Font)boldFont);
        cell.setCellStyle((CellStyle)style);
        cell.setCellValue("Grand Total");
        worksheet.autoSizeColumn((int)((short)colNum));
        row = worksheet.getRow(rowIndexCounter);
        cell = row.createCell((int)((short)colIndex));
        cell.setCellStyle((CellStyle)style);
        cell.setCellValue((double)grandFinalSum);
    }

    private /* synthetic */ void lambda$writeNewObjectiveCSVFile$27(Map list, List filteredList, ICsvMapWriter finalWriter, String[] completeHeader, Object groupId) {
        List data = (List)list.get(groupId);
        ArrayList rowData = new ArrayList();
        if (PropertyValidator.isValid((Collection)data)) {
            data.forEach(mp -> {
                HashMap rowMap = new HashMap();
                mp.forEach((key, value) -> {
                    String stringValue = PropertyValidator.isValid((Object)value) ? value.toString() : "";
                    int colIndex = this.findIndexByKey(filteredList, key);
                    if (colIndex != -1) {
                        if (key.equals("objectiveType")) {
                            stringValue = stringValue.equals("Objective-Committed") ? "Normal" : "Uncommitted";
                        }
                        rowMap.put(key, stringValue);
                    }
                });
                rowData.add(rowMap);
            });
            try {
                for (HashMap row : rowData) {
                    String a = "";
                    23 newRowData = new /* Unavailable Anonymous Inner Class!! */;
                    finalWriter.write((Map)newRowData, completeHeader);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

