/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.enums.EnumBaseItemTypes;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.persistence.entity.Context;
import com.viztrend.safe.persistence.entity.FieldEntity;
import com.viztrend.safe.persistence.entity.FieldTemplate;
import com.viztrend.safe.persistence.entity.Fields;
import com.viztrend.safe.persistence.entity.FieldsLayout;
import com.viztrend.safe.persistence.entity.ItemType;
import com.viztrend.safe.persistence.entity.ItemTypeScheme;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.FieldTemplateRepository;
import com.viztrend.safe.persistence.repository.FieldsLayoutRepository;
import com.viztrend.safe.persistence.repository.FieldsRepository;
import com.viztrend.safe.persistence.repository.ItemTypeRepository;
import com.viztrend.safe.persistence.repository.ItemTypeSchemeRepository;
import com.viztrend.safe.persistence.repository.RiskRegisterRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.CustomFieldService;
import com.viztrend.safe.service.ObjectiveServiceImpl;
import com.viztrend.safe.utils.PropertyValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="CustomFieldService")
public class CustomFieldServiceImpl
implements CustomFieldService {
    @Autowired
    private FieldsRepository fieldsRepository;
    @Autowired
    private ItemTypeRepository itemTypeRepository;
    @Autowired
    private ItemTypeSchemeRepository itemTypeSchemeRepository;
    @Autowired
    private FieldTemplateRepository fieldTemplateRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private RiskRegisterRepository riskRegisterRepository;
    @Autowired
    private CustomRepository customRepository;
    @Autowired
    private ObjectiveServiceImpl objectiveServiceImpl;
    @Autowired
    private FieldsLayoutRepository fieldsLayoutRepository;

    public List<Fields> fetchAllCustomFields() {
        return this.fieldsRepository.findByIsUserDefined(Boolean.valueOf(true));
    }

    public List<Map<String, Object>> getItemTypeList() {
        ArrayList<Map<String, Object>> modulesList = new ArrayList<Map<String, Object>>();
        ArrayList<String> whereInClause = new ArrayList<String>();
        whereInClause.add(EnumKendis.KENDIS_ONLY_CARD.getCode());
        whereInClause.add(EnumKendis.RISK.getCode());
        List itemTypes = this.itemTypeRepository.findByTitleIn(whereInClause);
        for (ItemType itemType : itemTypes) {
            HashMap<String, Object> module = new HashMap<String, Object>();
            module.put("id", itemType.getId());
            module.put("title", itemType.getTitle());
            module.put("isLink", false);
            module.put("isVisible", false);
            module.put("isMandatory", false);
            modulesList.add(module);
        }
        return modulesList;
    }

    public Map<String, Object> saveCustomField(Fields field) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<ItemType> itemTypeList = new ArrayList<ItemType>();
        ArrayList<FieldTemplate> fieldTemplateList = new ArrayList<FieldTemplate>();
        ArrayList<ItemTypeScheme> itemTypeSchemesToRemoveField = new ArrayList<ItemTypeScheme>();
        ArrayList<ItemTypeScheme> itemTypeSchemesToAddField = new ArrayList<ItemTypeScheme>();
        if (PropertyValidator.isValid((Object)field.getId())) {
            ItemType itemType;
            HashMap<String, Context> oldItemTypeMapById = new HashMap<String, Context>();
            HashMap<String, Context> newItemTypeMapById = new HashMap<String, Context>();
            Fields oldField = (Fields)this.fieldsRepository.findOne((Serializable)((Object)field.getId()));
            oldField.setTitle(field.getTitle());
            oldField.setDescription(field.getDescription());
            oldField.setOptions(field.getOptions());
            oldField.setMaxValue(field.getMaxValue());
            oldField.setAllowedObjects(field.getAllowedObjects());
            for (Context cont : oldField.getModuleContexts()) {
                oldItemTypeMapById.put(cont.getItemTypeId(), cont);
            }
            for (Context cont : field.getModuleContexts()) {
                if (!PropertyValidator.isValid(oldItemTypeMapById.get(cont.getItemTypeId()))) {
                    itemType = new ItemType();
                    itemType.setId(cont.getItemTypeId());
                    itemTypeList.add(itemType);
                }
                newItemTypeMapById.put(cont.getItemTypeId(), cont);
            }
            for (Context cont : oldField.getModuleContexts()) {
                if (PropertyValidator.isValid(newItemTypeMapById.get(cont.getItemTypeId()))) continue;
                itemType = new ItemType();
                itemType.setId(cont.getItemTypeId());
                itemTypeList.add(itemType);
            }
            oldField.setModuleContexts(field.getModuleContexts());
            oldField = (Fields)this.fieldsRepository.save((Object)oldField);
            List itemTypeSchemes = this.itemTypeSchemeRepository.findByItemTypeIn(itemTypeList);
            if (PropertyValidator.isValid((Collection)itemTypeSchemes)) {
                for (ItemTypeScheme itemTypeScheme : itemTypeSchemes) {
                    if (PropertyValidator.isValid(newItemTypeMapById.get(itemTypeScheme.getItemType().getId()))) {
                        if (PropertyValidator.isValid((Object)itemTypeScheme.getFieldsTemplate())) {
                            itemTypeSchemesToAddField.add(itemTypeScheme);
                            if (!PropertyValidator.isValid((Collection)itemTypeScheme.getFieldsTemplate().getConfiguredFields())) {
                                itemTypeScheme.getFieldsTemplate().setConfiguredFields(new ArrayList());
                            }
                            if (itemTypeScheme.getFieldsTemplate().getType().equalsIgnoreCase(EnumKendis.OBJECTIVE.getCode()) || itemTypeScheme.getFieldsTemplate().getType().equalsIgnoreCase(EnumKendis.OBJECTIVE_KEY_RESULT.getCode())) {
                                for (Fields groupField : itemTypeScheme.getFieldsTemplate().getConfiguredFields()) {
                                    if (!groupField.getTitle().equalsIgnoreCase("Custom Fields") || !groupField.getIsGroup().booleanValue()) continue;
                                    groupField.getGroupFields().add(field);
                                    this.fieldsRepository.save((Object)groupField);
                                    break;
                                }
                            } else {
                                itemTypeScheme.getFieldsTemplate().getConfiguredFields().add(field);
                            }
                        }
                    } else if (PropertyValidator.isValid(oldItemTypeMapById.get(itemTypeScheme.getItemType().getId())) && PropertyValidator.isValid((Object)itemTypeScheme.getFieldsTemplate()) && PropertyValidator.isValid((Collection)itemTypeScheme.getFieldsTemplate().getConfiguredFields())) {
                        itemTypeSchemesToRemoveField.add(itemTypeScheme);
                        if (itemTypeScheme.getFieldsTemplate().getType().equalsIgnoreCase(EnumKendis.OBJECTIVE.getCode()) || itemTypeScheme.getFieldsTemplate().getType().equalsIgnoreCase(EnumKendis.OBJECTIVE_KEY_RESULT.getCode())) {
                            for (Fields groupField : itemTypeScheme.getFieldsTemplate().getConfiguredFields()) {
                                if (!groupField.getTitle().equalsIgnoreCase("Custom Fields") || !groupField.getIsGroup().booleanValue()) continue;
                                groupField.getGroupFields().remove(field);
                                this.fieldsRepository.save((Object)groupField);
                                break;
                            }
                        } else {
                            itemTypeScheme.getFieldsTemplate().getConfiguredFields().remove(field);
                        }
                    }
                    fieldTemplateList.add(itemTypeScheme.getFieldsTemplate());
                }
                this.fieldTemplateRepository.save(fieldTemplateList);
            }
            result.put("field", oldField);
        } else {
            field.setIsUserDefined(Boolean.valueOf(true));
            field.setIsRequired(Boolean.valueOf(false));
            field = (Fields)this.fieldsRepository.save((Object)field);
            if (PropertyValidator.isValid((Collection)field.getModuleContexts())) {
                for (Context cont : field.getModuleContexts()) {
                    ItemType itemType = new ItemType();
                    itemType.setId(cont.getItemTypeId());
                    itemTypeList.add(itemType);
                }
                List itemTypeSchemes = this.itemTypeSchemeRepository.findByItemTypeIn(itemTypeList);
                if (PropertyValidator.isValid((Collection)itemTypeSchemes)) {
                    for (ItemTypeScheme itemTypeScheme : itemTypeSchemes) {
                        if (PropertyValidator.isValid((Object)itemTypeScheme.getFieldsTemplate())) {
                            if (!PropertyValidator.isValid((Collection)itemTypeScheme.getFieldsTemplate().getConfiguredFields())) {
                                itemTypeScheme.getFieldsTemplate().setConfiguredFields(new ArrayList());
                            }
                            if (itemTypeScheme.getFieldsTemplate().getType().equalsIgnoreCase(EnumKendis.OBJECTIVE.getCode()) || itemTypeScheme.getFieldsTemplate().getType().equalsIgnoreCase(EnumKendis.OBJECTIVE_KEY_RESULT.getCode())) {
                                for (Fields groupField : itemTypeScheme.getFieldsTemplate().getConfiguredFields()) {
                                    if (!groupField.getTitle().equalsIgnoreCase("Custom Fields") || !groupField.getIsGroup().booleanValue()) continue;
                                    groupField.getGroupFields().add(field);
                                    this.fieldsRepository.save((Object)groupField);
                                    break;
                                }
                            } else {
                                itemTypeScheme.getFieldsTemplate().getConfiguredFields().add(field);
                            }
                        }
                        fieldTemplateList.add(itemTypeScheme.getFieldsTemplate());
                    }
                    this.fieldTemplateRepository.save(fieldTemplateList);
                }
            }
            result.put("field", field);
        }
        return result;
    }

    public Map<String, Object> archiveCustomField(String customFieldId, Boolean archive) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (archive.booleanValue()) {
            this.customRepository.setRowStatus(customFieldId, 1, Fields.class);
            result.put("isArchive", true);
        } else {
            this.customRepository.setRowStatus(customFieldId, 0, Fields.class);
            result.put("isArchive", false);
        }
        return result;
    }

    public void scriptToCreateItemTypes() {
        ItemTypeScheme itemTypeScheme;
        FieldTemplate fieldTemplate;
        ItemType itemType = this.itemTypeRepository.findByTitle(EnumKendis.KENDIS_ONLY_CARD.getCode());
        if (!PropertyValidator.isValid((Object)itemType)) {
            itemType = new ItemType();
            itemType.setTitle(EnumKendis.KENDIS_ONLY_CARD.getCode());
            itemType = (ItemType)this.itemTypeRepository.save((Object)itemType);
            fieldTemplate = new FieldTemplate();
            fieldTemplate.setType(EnumKendis.KENDIS_ONLY_CARD.getCode());
            fieldTemplate.setConfiguredFields(new ArrayList());
            fieldTemplate = (FieldTemplate)this.fieldTemplateRepository.save((Object)fieldTemplate);
            itemTypeScheme = new ItemTypeScheme();
            itemTypeScheme.setItemType(itemType);
            itemTypeScheme.setFieldsTemplate(fieldTemplate);
            this.itemTypeSchemeRepository.save((Object)itemTypeScheme);
        }
        if (!PropertyValidator.isValid((Object)(itemType = this.itemTypeRepository.findByTitle(EnumKendis.RISK.getCode())))) {
            itemType = new ItemType();
            itemType.setTitle(EnumKendis.RISK.getCode());
            itemType = (ItemType)this.itemTypeRepository.save((Object)itemType);
            fieldTemplate = new FieldTemplate();
            fieldTemplate.setType(EnumKendis.RISK.getCode());
            fieldTemplate.setConfiguredFields(new ArrayList());
            fieldTemplate = (FieldTemplate)this.fieldTemplateRepository.save((Object)fieldTemplate);
            itemTypeScheme = new ItemTypeScheme();
            itemTypeScheme.setItemType(itemType);
            itemTypeScheme.setFieldsTemplate(fieldTemplate);
            this.itemTypeSchemeRepository.save((Object)itemTypeScheme);
        }
        if (!PropertyValidator.isValid((Object)(itemType = this.itemTypeRepository.findByTitle(EnumBaseItemTypes.BATCH.getName())))) {
            itemType = new ItemType();
            itemType.setTitle(EnumBaseItemTypes.BATCH.getName());
            itemType = (ItemType)this.itemTypeRepository.save((Object)itemType);
            fieldTemplate = new FieldTemplate();
            fieldTemplate.setType(EnumBaseItemTypes.BATCH.getName());
            fieldTemplate.setConfiguredFields(new ArrayList());
            fieldTemplate = (FieldTemplate)this.fieldTemplateRepository.save((Object)fieldTemplate);
            itemTypeScheme = new ItemTypeScheme();
            itemTypeScheme.setItemType(itemType);
            itemTypeScheme.setFieldsTemplate(fieldTemplate);
            this.itemTypeSchemeRepository.save((Object)itemTypeScheme);
        }
        if (!PropertyValidator.isValid((Object)(itemType = this.itemTypeRepository.findByTitle(EnumKendis.IMPEDIMENT.getCode())))) {
            this.createImpedimentItemType();
        }
        if (!PropertyValidator.isValid((Object)(itemType = this.itemTypeRepository.findByTitle(EnumBaseItemTypes.BATCH_GROUP.getName())))) {
            itemType = new ItemType();
            itemType.setTitle(EnumBaseItemTypes.BATCH_GROUP.getName());
            itemType.setNested(false);
            itemType = (ItemType)this.itemTypeRepository.save((Object)itemType);
        }
        try {
            this.objectiveServiceImpl.getObjectiveEditModalTemplate(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createCustomFieldGroup() {
        Fields field;
        Boolean exists;
        FieldTemplate fieldTemplate = this.fieldTemplateRepository.findByType(EnumKendis.OBJECTIVE.getCode());
        if (PropertyValidator.isValid((Object)fieldTemplate)) {
            exists = false;
            for (Fields field2 : fieldTemplate.getConfiguredFields()) {
                if (!field2.getTitle().equalsIgnoreCase("Custom Fields") || !field2.getIsGroup().booleanValue()) continue;
                exists = true;
                break;
            }
            if (!exists.booleanValue()) {
                field = new Fields();
                field.setTitle("Custom Fields");
                field.setIsGroup(Boolean.valueOf(true));
                field.setGroupFields(new ArrayList());
                field = (Fields)this.fieldsRepository.save((Object)field);
                fieldTemplate.getConfiguredFields().add(field);
                this.fieldTemplateRepository.save((Object)fieldTemplate);
            }
        }
        if (PropertyValidator.isValid((Object)(fieldTemplate = this.fieldTemplateRepository.findByType(EnumKendis.OBJECTIVE_KEY_RESULT.getCode())))) {
            exists = false;
            for (Fields field2 : fieldTemplate.getConfiguredFields()) {
                if (!field2.getTitle().equalsIgnoreCase("Custom Fields") || !field2.getIsGroup().booleanValue()) continue;
                exists = true;
                break;
            }
            if (!exists.booleanValue()) {
                field = new Fields();
                field.setTitle("Custom Fields");
                field.setIsGroup(Boolean.valueOf(true));
                field.setGroupFields(new ArrayList());
                field = (Fields)this.fieldsRepository.save((Object)field);
                fieldTemplate.getConfiguredFields().add(field);
                this.fieldTemplateRepository.save((Object)fieldTemplate);
            }
        }
    }

    void createImpedimentItemType() {
        FieldTemplate template = this.fieldTemplateRepository.findByType(EnumKendis.IMPEDIMENT.getCode());
        if (!PropertyValidator.isValid((Object)template)) {
            template = new FieldTemplate();
            List<Object> fields = new ArrayList<Fields>();
            fields.add(new Fields("1", "Title", "simpleEditor", null, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
            fields.add(new Fields("2", "Description", "textarea", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
            fields.add(new Fields("3", "Status", "status", new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
            fields.add(new Fields("4", "Severity", "severity", new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
            fields.add(new Fields("5", "Responsible", "userpicker", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
            fields.add(new Fields("6", "Resolution Date", "datepicker", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
            fields = this.fieldsRepository.save(fields);
            template.setConfiguredFields(fields);
            template.setType(EnumKendis.IMPEDIMENT.getCode());
            template = (FieldTemplate)this.fieldTemplateRepository.save((Object)template);
        }
        ItemType itemType = new ItemType();
        itemType.setTitle(EnumKendis.IMPEDIMENT.getCode());
        itemType = (ItemType)this.itemTypeRepository.save((Object)itemType);
        ItemTypeScheme itemTypeScheme = new ItemTypeScheme();
        itemTypeScheme.setItemType(itemType);
        itemTypeScheme.setFieldsTemplate(template);
        this.itemTypeSchemeRepository.save((Object)itemTypeScheme);
    }

    public Map<String, Object> getKendisCustomFieldsFromDefaultLayout(String itemTypeStr) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Fields> customFields = new ArrayList<Fields>();
        HashMap<String, Boolean> mandatoryMap = new HashMap<String, Boolean>();
        ItemType itemType = this.itemTypeRepository.findByTitle(itemTypeStr);
        FieldsLayout fieldsLayout = this.fieldsLayoutRepository.findByItemTypeAndIsDefaultIsTrue(itemType);
        if (PropertyValidator.isValid((Object)fieldsLayout) && PropertyValidator.isValid((Collection)fieldsLayout.getFields())) {
            for (FieldEntity fieldEntity : fieldsLayout.getFields()) {
                Fields field = fieldEntity.getField();
                if (field.getRowStatus() != 0) continue;
                for (Context context : field.getModuleContexts()) {
                    if (!context.getItemTypeId().equals(itemType.getId())) continue;
                    if (context.getIsVisible().booleanValue()) {
                        customFields.add(field);
                    }
                    if (!context.getIsMandatory().booleanValue()) continue;
                    mandatoryMap.put(field.getId(), context.getIsMandatory());
                }
            }
            result.put("fields", customFields);
            result.put("mandatoryMap", mandatoryMap);
        }
        return result;
    }

    public Map<String, Object> getKendisCustomFieldsFromLayout(String itemTypeStr, FieldsLayout fieldsLayout) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Fields> customFields = new ArrayList<Fields>();
        HashMap<String, Boolean> mandatoryMap = new HashMap<String, Boolean>();
        ItemType itemType = this.itemTypeRepository.findByTitle(itemTypeStr);
        if (PropertyValidator.isValid((Object)fieldsLayout)) {
            if (!PropertyValidator.isValid((Collection)fieldsLayout.getFields())) {
                fieldsLayout = (FieldsLayout)this.fieldsLayoutRepository.findOne((Serializable)((Object)fieldsLayout.getId()));
            }
            if (PropertyValidator.isValid((Collection)fieldsLayout.getFields())) {
                for (FieldEntity fieldEntity : fieldsLayout.getFields()) {
                    Fields field = fieldEntity.getField();
                    if (field.getRowStatus() != 0) continue;
                    for (Context context : field.getModuleContexts()) {
                        if (!context.getItemTypeId().equals(itemType.getId())) continue;
                        if (context.getIsVisible().booleanValue()) {
                            customFields.add(field);
                        }
                        if (!context.getIsMandatory().booleanValue()) continue;
                        mandatoryMap.put(field.getId(), context.getIsMandatory());
                    }
                }
                result.put("fields", customFields);
                result.put("mandatoryMap", mandatoryMap);
            }
        }
        return result;
    }

    public Map<String, Object> saveFieldsLayout(FieldsLayout fieldsLayout) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)fieldsLayout.getId())) {
            fieldsLayout = (FieldsLayout)this.fieldsLayoutRepository.save((Object)fieldsLayout);
        } else {
            FieldsLayout oldFieldLayout = (FieldsLayout)this.fieldsLayoutRepository.findOne((Serializable)((Object)fieldsLayout.getId()));
            if (PropertyValidator.isValid((Object)oldFieldLayout)) {
                oldFieldLayout.setTitle(fieldsLayout.getTitle());
                oldFieldLayout.setFields(fieldsLayout.getFields());
                oldFieldLayout.setSystemFieldsToExclude(fieldsLayout.getSystemFieldsToExclude());
                fieldsLayout = (FieldsLayout)this.fieldsLayoutRepository.save((Object)oldFieldLayout);
            }
        }
        result.put("fieldsLayout", fieldsLayout);
        return result;
    }

    public List<FieldsLayout> fetchAllCustomFieldLayout() {
        return this.fieldsLayoutRepository.findAll();
    }

    private void setFieldsInLayout(Fields field, List<ItemTypeScheme> itemTypeSchemes, String action) {
        ArrayList<ItemType> itemTypeList = new ArrayList<ItemType>();
        for (ItemTypeScheme itemTypeScheme : itemTypeSchemes) {
            itemTypeList.add(itemTypeScheme.getItemType());
        }
        List fieldsLayouts = this.fieldsLayoutRepository.findByItemTypeInAndIsDefaultIsTrue(itemTypeList);
        HashMap<String, Boolean> existingLayoutIdsMap = new HashMap<String, Boolean>();
        if (PropertyValidator.isValid((Collection)fieldsLayouts)) {
            for (FieldsLayout fieldsLayout : fieldsLayouts) {
                if (action == "Add") {
                    FieldEntity fieldEntity2 = new FieldEntity();
                    fieldEntity2.setField(field);
                    fieldEntity2.setContainer("left-container");
                    fieldsLayout.getFields().add(fieldEntity2);
                } else {
                    fieldsLayout.getFields().removeIf(fieldEntity -> fieldEntity.getField().getId().equals(field.getId()));
                }
                existingLayoutIdsMap.put(fieldsLayout.getItemType().getId(), true);
            }
        }
        for (ItemType itemType : itemTypeList) {
            if (existingLayoutIdsMap.containsKey(itemType.getId()) || action != "Add") continue;
            FieldsLayout fieldLayout = new FieldsLayout();
            fieldLayout.setDefault(Boolean.valueOf(true));
            fieldLayout.setItemType(itemType);
            fieldLayout.setTitle(itemType.getTitle());
            fieldLayout.setSystemFieldsToExclude(new ArrayList());
            ArrayList<FieldEntity> fieldEntities = new ArrayList<FieldEntity>();
            FieldEntity fieldEntity3 = new FieldEntity();
            fieldEntity3.setField(field);
            fieldEntity3.setContainer("left-container");
            fieldEntities.add(fieldEntity3);
            fieldLayout.setFields(fieldEntities);
            fieldsLayouts.add(fieldLayout);
        }
        if (PropertyValidator.isValid((Collection)fieldsLayouts)) {
            this.fieldsLayoutRepository.save((Iterable)fieldsLayouts);
        }
    }

    public Map<String, Object> getKendisCustomFields(String itemTypeStr) {
        List fields;
        ItemTypeScheme itemTypeScheme;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Fields> customFields = new ArrayList<Fields>();
        ArrayList<Fields> systemFields = new ArrayList<Fields>();
        HashMap<String, Boolean> mandatoryMap = new HashMap<String, Boolean>();
        ItemType itemType = this.itemTypeRepository.findByTitle(itemTypeStr);
        if (PropertyValidator.isValid((Object)itemType) && PropertyValidator.isValid((Object)(itemTypeScheme = this.itemTypeSchemeRepository.findByItemType(itemType))) && PropertyValidator.isValid((Collection)(fields = itemTypeScheme.getFieldsTemplate().getConfiguredFields()))) {
            for (Fields field : fields) {
                if (field.getRowStatus() == 1) continue;
                if (PropertyValidator.isValid((Collection)field.getModuleContexts())) {
                    for (Context context : field.getModuleContexts()) {
                        if (!context.getItemTypeId().equals(itemType.getId())) continue;
                        if (context.getIsVisible().booleanValue()) {
                            customFields.add(field);
                        }
                        if (!context.getIsMandatory().booleanValue()) continue;
                        mandatoryMap.put(field.getId(), context.getIsMandatory());
                    }
                }
                if (field.getIsUserDefined().booleanValue()) continue;
                systemFields.add(field);
            }
            result.put("fields", customFields);
            result.put("mandatoryMap", mandatoryMap);
            result.put("systemFields", systemFields);
            return result;
        }
        return result;
    }

    public FieldsLayout getDefaultLayoutFromItemType(String itemTypeStr) {
        ItemType itemType = this.itemTypeRepository.findByTitle(itemTypeStr);
        FieldsLayout layout = null;
        if (PropertyValidator.isValid((Object)itemType)) {
            layout = this.fieldsLayoutRepository.findByItemTypeAndIsDefaultIsTrue(itemType);
        }
        return layout;
    }

    public Map<String, Object> markLayoutAsDefault(String id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FieldsLayout layout = (FieldsLayout)this.fieldsLayoutRepository.findOne((Serializable)((Object)id));
        List<Object> fieldsLayoutsToSave = new ArrayList<FieldsLayout>();
        if (PropertyValidator.isValid((Object)layout)) {
            FieldsLayout oldDefaultLayout = this.fieldsLayoutRepository.findByItemTypeAndIsDefaultIsTrue(layout.getItemType());
            if (PropertyValidator.isValid((Object)oldDefaultLayout)) {
                oldDefaultLayout.setDefault(Boolean.valueOf(false));
                fieldsLayoutsToSave.add(oldDefaultLayout);
            }
            layout.setDefault(Boolean.valueOf(true));
            fieldsLayoutsToSave.add(layout);
            fieldsLayoutsToSave = this.fieldsLayoutRepository.save(fieldsLayoutsToSave);
            result.put("success", true);
        } else {
            result.put("success", false);
        }
        return result;
    }

    public List<FieldsLayout> getAllLayoutsByItemType(String itemTypeStr) {
        ItemType itemType = this.itemTypeRepository.findByTitle(itemTypeStr);
        return this.fieldsLayoutRepository.findByItemType(itemType);
    }

    public void createDefaultLayoutForEachItemType() {
        ArrayList<String> itemTypesStr = new ArrayList<String>();
        ItemType kendisCardItemType = null;
        ItemType RiskItemType = null;
        ArrayList<FieldsLayout> fieldsLayoutsToSave = new ArrayList<FieldsLayout>();
        itemTypesStr.add(EnumKendis.KENDIS_ONLY_CARD.getCode());
        itemTypesStr.add(EnumKendis.RISK.getCode());
        List itemTypes = this.itemTypeRepository.findByTitleIn(itemTypesStr);
        if (PropertyValidator.isValid((Collection)itemTypes)) {
            FieldsLayout layout;
            for (ItemType it : itemTypes) {
                if (it.getTitle().equalsIgnoreCase(EnumKendis.KENDIS_ONLY_CARD.getCode())) {
                    kendisCardItemType = it;
                    continue;
                }
                if (!it.getTitle().equalsIgnoreCase(EnumKendis.RISK.getCode())) continue;
                RiskItemType = it;
            }
            if (PropertyValidator.isValid(kendisCardItemType) && !PropertyValidator.isValid((Object)(layout = this.fieldsLayoutRepository.findByItemTypeAndIsDefaultIsTrue(kendisCardItemType)))) {
                layout = new FieldsLayout();
                layout.setDefault(Boolean.valueOf(true));
                layout.setItemType(kendisCardItemType);
                layout.setTitle(EnumKendis.KENDIS_ONLY_CARD.getCode());
                layout.setSystemFieldsToExclude(new ArrayList());
                layout.setFields(new ArrayList());
                fieldsLayoutsToSave.add(layout);
            }
            if (PropertyValidator.isValid(RiskItemType) && !PropertyValidator.isValid((Object)(layout = this.fieldsLayoutRepository.findByItemTypeAndIsDefaultIsTrue(RiskItemType)))) {
                layout = new FieldsLayout();
                layout.setDefault(Boolean.valueOf(true));
                layout.setItemType(RiskItemType);
                layout.setTitle(EnumKendis.RISK.getCode());
                layout.setSystemFieldsToExclude(new ArrayList());
                layout.setFields(new ArrayList());
                fieldsLayoutsToSave.add(layout);
            }
            if (PropertyValidator.isValid(fieldsLayoutsToSave)) {
                this.fieldsLayoutRepository.save(fieldsLayoutsToSave);
            }
        }
    }

    public Map<String, Object> archiveLayout(String id, Boolean archive) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (archive.booleanValue()) {
            this.customRepository.setRowStatus(id, 1, FieldsLayout.class);
            result.put("isArchive", true);
        } else {
            this.customRepository.setRowStatus(id, 0, FieldsLayout.class);
            result.put("isArchive", false);
        }
        return result;
    }

    public Map<String, Object> deleteLayout(String id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FieldsLayout layout = new FieldsLayout();
        layout.setId(id);
        List orgViews = this.workSpaceRepository.findByKendisOnlyLayout(layout);
        List sessions = this.sessionRepository.findByKendisOnlyLayout(layout);
        List registers = this.riskRegisterRepository.findByLayout(layout);
        if (!(PropertyValidator.isValid((Collection)orgViews) || PropertyValidator.isValid((Collection)sessions) || PropertyValidator.isValid((Collection)registers))) {
            this.fieldsLayoutRepository.delete((Object)layout);
            result.put("success", true);
        } else {
            result.put("success", false);
            if (PropertyValidator.isValid((Collection)orgViews)) {
                result.put("orgViews", orgViews);
            }
            if (PropertyValidator.isValid((Collection)sessions)) {
                result.put("programBoards", sessions);
            }
            if (PropertyValidator.isValid((Collection)registers)) {
                result.put("registers", registers);
            }
        }
        return result;
    }

    public Map<String, Object> createDefaultLayouts() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            this.scriptToCreateItemTypes();
            this.createDefaultLayoutForEachItemType();
            result.put("success", true);
        }
        catch (Exception e) {
            result.put("success", false);
        }
        return result;
    }
}

