/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.repackaged.com.google.common.base.Objects;
import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.viztrend.safe.controller.PlanController;
import com.viztrend.safe.persistence.entity.Answer;
import com.viztrend.safe.persistence.entity.AnswerTemplate;
import com.viztrend.safe.persistence.entity.Option;
import com.viztrend.safe.persistence.entity.Question;
import com.viztrend.safe.persistence.entity.Questionnaire;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.repository.AnswerRepository;
import com.viztrend.safe.persistence.repository.AnswerTemplateRepository;
import com.viztrend.safe.persistence.repository.QuestionRepository;
import com.viztrend.safe.persistence.repository.QuestionnaireRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.service.ConfidenceVoteSurveyService;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.EncDecUtility;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.LocalMailSender;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.AnswerVO;
import com.viztrend.safe.vos.QuestionVO;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Component(value="confidenceVoteSurveyService")
public class ConfidenceVoteSurveyServiceImpl
implements ConfidenceVoteSurveyService {
    @Autowired
    private QuestionnaireRepository questionnaireRepository;
    @Autowired
    private QuestionRepository questionRepository;
    @Autowired
    private AnswerRepository answerRepository;
    @Autowired
    private AnswerTemplateRepository answerTemplateRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private LocalMailSender localMailSender;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private Environment env;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    private static final Logger LOGGER = LoggerFactory.getLogger(PlanController.class);

    private String getRandomColor() {
        ArrayList<String> colorList = new ArrayList<String>();
        colorList.add("#1991EB");
        colorList.add("#F85359");
        colorList.add("#6B47DB");
        colorList.add("#F9BF3B");
        colorList.add("#0747A6");
        colorList.add("#34495E");
        colorList.add("#2ECC71");
        colorList.add("#DB0A5B");
        colorList.add("#674172");
        colorList.add("#4ECDC4");
        colorList.add("#F39C12");
        colorList.add("#1C2227");
        colorList.add("#446CB3");
        colorList.add("#D2527F");
        colorList.add("#E87E04");
        colorList.add("#019875");
        colorList.add("#6C7A89");
        colorList.add("#9A12B3");
        colorList.add("#3A539B");
        colorList.add("#1E824C");
        colorList.add("#C6A21A");
        colorList.add("#336E7B");
        colorList.add("#C0392B");
        colorList.add("#013243");
        Random rand = new Random();
        return (String)colorList.get(rand.nextInt(colorList.size()));
    }

    public Map<String, Object> addNewQuestionnaire(Questionnaire questionnaire, String sessionId, List<Question> questions, List<Team> teams) {
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
        ArrayList<Questionnaire> questionnaireList = session.getConfidenceVoteSurvey();
        if (questionnaireList != null && !questionnaire.getIsSaved().equals("")) {
            Questionnaire qstns = new Questionnaire();
            qstns = (Questionnaire)questionnaireList.get(0);
            if (!teams.isEmpty()) {
                this.deleteQuestions(teams, qstns.getId());
            }
            boolean votingOnSelectionChanged = !qstns.getVotingOn().equals(questionnaire.getVotingOn());
            qstns.setDuration(questionnaire.getDuration());
            qstns.setHasPublicAccess(questionnaire.isHasPublicAccess());
            qstns.setHasPublicResult(questionnaire.isHasPublicResult());
            qstns.setHasVisibleVoter(questionnaire.isHasVisibleVoter());
            qstns.setHasVotingStarted(questionnaire.isHasVotingStarted());
            qstns.setHasVotingEnded(questionnaire.isHasVotingEnded());
            qstns.setVotingStartDate(questionnaire.getVotingStartDate());
            qstns.setVoteSaved(questionnaire.isVoteSaved());
            qstns.setHasResultEmail(questionnaire.isHasResultEmail());
            qstns.setHasVotingResumed(questionnaire.isHasVotingResumed());
            qstns.setVotingOn(questionnaire.getVotingOn());
            qstns.setSpecificTeamVote(questionnaire.isSpecificTeamVote());
            qstns.setHasEmailForPublicUser(questionnaire.isHasEmailForPublicUser());
            qstns.setHasResultHidden(questionnaire.isHasResultHidden());
            qstns.setHasExportConfidenceVote(questionnaire.isHasExportConfidenceVote());
            if (qstns.isHasVotingStarted() && !qstns.isHasVotingResumed() && !PropertyValidator.isValid((Object)qstns.getVoteStartedDate())) {
                qstns.setVoteStartedDate(new Date());
            }
            if (!qstns.isHasVotingStarted() && qstns.isHasVotingEnded() && !qstns.isHasVotingResumed()) {
                qstns.setVoteEndedDate(new Date());
            }
            questionnaireList.set(0, qstns);
            Questionnaire question = (Questionnaire)this.questionnaireRepository.save((Object)qstns);
            session.setConfidenceVoteSurvey(questionnaireList);
            this.sessionRepository.save((Object)session);
            AnswerTemplate answerTemplate = null;
            for (Question qstn : questions) {
                answerTemplate = (AnswerTemplate)this.answerTemplateRepository.findOne((Serializable)((Object)qstn.getAnswerTemplateId()));
                qstn.setQuestionnaire(qstns);
                qstn.setAnswerTemplate(answerTemplate);
            }
            List savedQuestions = new ArrayList();
            String votingOn = question.getVotingOn();
            if (votingOnSelectionChanged || !questions.isEmpty()) {
                if (votingOn.equals("pi")) {
                    this.questionRepository.deleteByTeamIsNotNullAndQuestionnaireId(question.getId());
                    if (this.questionRepository.findByTeamIsNull().isEmpty()) {
                        savedQuestions = this.questionRepository.save(questions);
                    }
                } else {
                    if (votingOn.equals("team")) {
                        this.questionRepository.deleteByTeamIsNullAndQuestionnaireId(question.getId());
                    }
                    savedQuestions = this.questionRepository.save(questions);
                }
            }
            String timeStamp = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Date());
            for (Question q : savedQuestions) {
                String qtn = "{\"id\":\"" + qstns.getId() + "\", \"question\":\"" + q.getId() + "\",\"time\":\"" + timeStamp + "\"}";
                try {
                    qtn = EncDecUtility.encryptSimple((String)qtn);
                }
                catch (Exception e) {
                    LOGGER.debug(e.getMessage());
                }
                q.setUrlToken(qtn);
            }
            this.questionRepository.save(savedQuestions);
            HashMap<String, Object> confidenceVoteSaved = new HashMap<String, Object>();
            confidenceVoteSaved.put("confidenceVote", question);
            List questionsOfQuestionnaire = this.getQuestionList(((Questionnaire)session.getConfidenceVoteSurvey().get(0)).getId());
            confidenceVoteSaved.put("questions", questionsOfQuestionnaire);
            if (qstns.isHasVotingEnded() && !qstns.isHasVotingResumed() && qstns.isHasResultEmail()) {
                List savedAnswers = this.getAnswers(qstns.getId(), questionsOfQuestionnaire);
                Map answerCount = this.getAnswersCount(qstns.getId(), questionsOfQuestionnaire);
                String boardName = session.getTitle();
                this.sendEmail(savedAnswers, answerCount, boardName, questionsOfQuestionnaire, qstns.getVoteEndedDate(), qstns.isHasEmailForPublicUser());
            }
            return confidenceVoteSaved;
        }
        if (questionnaireList == null && questionnaire.getIsSaved().equals("")) {
            questionnaireList = new ArrayList<Questionnaire>();
            questionnaire.setCompanyId(UserContextUtil.getUserContext().getCurrentCompanyId());
            Questionnaire confidencVote = (Questionnaire)this.questionnaireRepository.save((Object)questionnaire);
            questionnaireList.add(confidencVote);
            session.setConfidenceVoteSurvey(questionnaireList);
            AnswerTemplate answerTemplate = null;
            for (Question question : questions) {
                answerTemplate = (AnswerTemplate)this.answerTemplateRepository.findOne((Serializable)((Object)question.getAnswerTemplateId()));
                question.setQuestionnaire(confidencVote);
                question.setAnswerTemplate(answerTemplate);
            }
            this.sessionRepository.save((Object)session);
            List savedQuestions = this.questionRepository.save(questions);
            String timeStamp = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Date());
            for (Question q : savedQuestions) {
                String qstn = "{\"id\":\"" + confidencVote.getId() + "\", \"question\":\"" + q.getId() + "\",\"time\":\"" + timeStamp + "\"}";
                try {
                    qstn = EncDecUtility.encryptSimple((String)qstn);
                }
                catch (Exception e) {
                    LOGGER.debug(e.getMessage());
                }
                q.setUrlToken(qstn);
            }
            savedQuestions = this.questionRepository.save((Iterable)savedQuestions);
            try {
                String cnfvote = "{\"id\":\"" + confidencVote.getId() + "\",\"time\":\"" + timeStamp + "\"}";
                confidencVote.setUrlToken(EncDecUtility.encryptSimple((String)cnfvote));
                confidencVote = (Questionnaire)this.questionnaireRepository.save((Object)confidencVote);
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage());
            }
            HashMap<String, Object> confidenceVoteSaved = new HashMap<String, Object>();
            confidenceVoteSaved.put("confidenceVote", confidencVote);
            confidenceVoteSaved.put("questions", savedQuestions);
            return confidenceVoteSaved;
        }
        HashMap<String, Object> error = new HashMap<String, Object>();
        error.put("error", "Vote already exists");
        return error;
    }

    public void deleteQuestions(List<Team> deselectedTeams, String questionnaireId) {
        this.questionRepository.deleteByTeamInAndQuestionnaireId(deselectedTeams, questionnaireId);
    }

    public List<Question> getQuestionList(String questionnaireId) {
        List questions = this.findByQuestionnaireId(questionnaireId);
        int i = 0;
        boolean hasVoteForPi = false;
        for (Question question : questions) {
            if (question.getTeam() == null) {
                hasVoteForPi = true;
                break;
            }
            ++i;
        }
        if (hasVoteForPi) {
            Question piQuestion = (Question)questions.get(i);
            questions.remove(i);
            questions.add(0, piQuestion);
        }
        return questions;
    }

    private List<Question> findByQuestionnaireId(String questionnaireId) {
        BasicDBObject matchStage = new BasicDBObject();
        if (ObjectId.isValid((String)questionnaireId)) {
            ObjectId objectId = new ObjectId(questionnaireId);
            matchStage = new BasicDBObject("$match", (Object)new BasicDBObject("questionnaire.$id", (Object)objectId));
        }
        BasicDBObject questionnaireLookup = DBUtils.createLookup((String)"questionnaire", (String)"questionnaire.$id", (String)"_id", (String)"questionnaire");
        BasicDBObject questionnaireUnWind = new BasicDBObject("$unwind", (Object)"$questionnaire");
        BasicDBObject teamLookup = DBUtils.createLookup((String)"team", (String)"team.$id", (String)"_id", (String)"team");
        BasicDBObject teamUnWind = new BasicDBObject("$unwind", (Object)new BasicDBObject("path", (Object)"$team").append("preserveNullAndEmptyArrays", (Object)true));
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("questionText", (Object)1).append("answerTemplateId", (Object)1).append("answerTemplate", (Object)1).append("urlToken", (Object)1).append("questionnaire", (Object)1).append("team._id", (Object)"$team._id").append("team.title", (Object)"$team.title").append("team.label", (Object)"$team.label").append("team.color", (Object)"$team.color").append("team.boardId", (Object)"$team.boardId").append("team.projectId", (Object)"$team.projectId").append("team.issueTypeId", (Object)"$team.issueTypeId"));
        List<DBObject> pipeLine = Arrays.asList(matchStage, questionnaireLookup, questionnaireUnWind, teamLookup, teamUnWind, projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(Question.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        Cursor dbCursor = collection.aggregate(pipeLine, aggregationOptions);
        ArrayList<Question> questions = new ArrayList<Question>();
        while (dbCursor.hasNext()) {
            DBObject obj = (DBObject)dbCursor.next();
            Question question = new Question();
            String id = DBUtils.getIdFromDBObject((BasicDBObject)((BasicDBObject)obj), (String[])new String[0]);
            question.setId(id);
            if (!DBUtils.isEmptyObject((Object)obj.get("team"))) {
                question.setTeam(new Team((BasicDBObject)obj.get("team")));
            }
            question.setQuestionnaire(new Questionnaire((BasicDBObject)obj.get("questionnaire")));
            question.setQuestionText((String)obj.get("questionText"));
            question.setAnswerTemplate(new AnswerTemplate((BasicDBObject)obj.get("answerTemplate")));
            question.setUrlToken((String)obj.get("urlToken"));
            questions.add(question);
        }
        return questions;
    }

    public Map<String, Object> saveVote(HashMap<String, Object> payload, String questionnaireId, String tenant) {
        ObjectMapper mapper;
        HashMap<String, Object> pushJson;
        ArrayList<Answer> answers = new ArrayList<Answer>();
        HashMap<String, Object> answersAndAnswerCounts = new HashMap<String, Object>();
        Questionnaire questionnaire = this.questionnaireRepository.findById(questionnaireId);
        if (questionnaire.isHasVotingEnded()) {
            answersAndAnswerCounts.put("error", "Voting has Ended");
            return answersAndAnswerCounts;
        }
        Iterator<Map.Entry<String, Object>> it = payload.entrySet().iterator();
        String color = this.getRandomColor();
        boolean isPublicUser = false;
        String userId = "";
        String questionId = "";
        String selectedAnswer = "";
        while (it.hasNext()) {
            Object mapUser;
            Map.Entry<String, Object> pair = it.next();
            Object object = pair.getValue();
            Map map = (Map)object;
            Answer answer = new Answer();
            Iterator it2 = map.entrySet().iterator();
            while (it2.hasNext()) {
                Object obj;
                Map.Entry pair2 = it2.next();
                if (pair2.getKey() == "question") {
                    questionId = (String)pair2.getValue();
                    Question question = new Question();
                    question.setId(questionId);
                    answer.setQuestion(question);
                } else if (pair2.getKey() == "value") {
                    selectedAnswer = (String)pair2.getValue();
                    answer.setSelectedAnswer(selectedAnswer);
                } else if (pair2.getKey() == "user") {
                    if (pair2.getValue() instanceof Map) {
                        obj = pair2.getValue();
                        mapUser = (Map)obj;
                        mapUser.put("backgroundColor", color);
                        answer.setPublicUser((Map)mapUser);
                        userId = (String)mapUser.get("email");
                        isPublicUser = true;
                    } else {
                        userId = (String)pair2.getValue();
                        User user = new User();
                        user.setId(userId);
                        answer.setUser(user);
                    }
                } else if (pair2.getKey() == "id") {
                    obj = (String)pair2.getValue();
                    answer.setId(obj);
                }
                it2.remove();
            }
            if (tenant != null) {
                answer.setTenant(tenant);
            }
            Object existingAnswers = new ArrayList();
            if (isPublicUser) {
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"publicUser.email").is((Object)userId));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"question.$id").is((Object)new ObjectId(questionId)));
                existingAnswers = this.mongoTemplate.find(query, Answer.class);
            } else {
                existingAnswers = this.answerRepository.findByUserIdAndQuestionId(userId, questionId);
            }
            HashMap<String, Answer> answersMapByUserAndQuestion = new HashMap<String, Answer>();
            if (PropertyValidator.isValid((Collection)existingAnswers)) {
                mapUser = existingAnswers.iterator();
                while (mapUser.hasNext()) {
                    Answer ans = (Answer)mapUser.next();
                    answersMapByUserAndQuestion.put(userId.concat(questionId), ans);
                }
                Answer ansSaved = (Answer)answersMapByUserAndQuestion.get(userId.concat(questionId));
                if (PropertyValidator.isValid((Object)ansSaved)) {
                    ansSaved.setSelectedAnswer(selectedAnswer);
                    answers.add(ansSaved);
                }
            } else {
                answers.add(answer);
            }
            it.remove();
        }
        List newAnswers = this.answerRepository.save(answers);
        Map answersAndQuestions = this.getAnswersAndQuestions(questionnaireId);
        List savedAnswers = (List)answersAndQuestions.get("answers");
        List savedQuestions = (List)answersAndQuestions.get("questions");
        Map answerCount = this.getAnswersCount(questionnaireId, savedQuestions);
        answersAndAnswerCounts.put("savedAnswers", this.convertAnswerToAnswerVO(savedAnswers));
        answersAndAnswerCounts.put("answerCount", answerCount);
        for (Answer ans : savedAnswers) {
            if (!ans.getId().equals(((Answer)newAnswers.get(0)).getId()) || !PropertyValidator.isValid((Object)((Answer)newAnswers.get(0)).getUser())) continue;
            ((Answer)newAnswers.get(0)).setUser(ans.getUser());
        }
        answersAndAnswerCounts.put("newAnswers", this.convertAnswerToAnswerVO(newAnswers));
        if (!isPublicUser) {
            pushJson = answersAndAnswerCounts;
            pushJson.put("metaMap", "{\"event\":\"answerSubmitted\"}");
            mapper = new ObjectMapper();
            try {
                PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
            }
            catch (JsonProcessingException e) {
                LOGGER.debug(e.getMessage());
            }
        } else {
            pushJson = answersAndAnswerCounts;
            pushJson.put("metaMap", "{\"event\":\"answerSubmitted\"}");
            mapper = new ObjectMapper();
            try {
                PushSender.sendMsg((String)questionnaire.getCompanyId(), (String)mapper.writeValueAsString(pushJson));
            }
            catch (JsonProcessingException e) {
                LOGGER.debug(e.getMessage());
            }
        }
        return answersAndAnswerCounts;
    }

    public List<Answer> getAnswers(String questionnaireId, List<Question> questions) {
        List<Object> questionList = new ArrayList();
        questionList = !PropertyValidator.isValid(questions) ? this.getQuestionList(questionnaireId) : questions;
        ArrayList<ObjectId> questionObjIds = new ArrayList<ObjectId>();
        for (Question question : questionList) {
            String questionId = question.getId();
            questionObjIds.add(new ObjectId(questionId));
        }
        return this.findByQuestionIdIn(questionObjIds);
    }

    private List<Answer> findByQuestionIdIn(List<ObjectId> questionIds) {
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject("question.$id", (Object)new BasicDBObject("$in", questionIds)));
        BasicDBObject questionLookup = DBUtils.createLookup((String)"question", (String)"question.$id", (String)"_id", (String)"question");
        BasicDBObject questionUnWind = new BasicDBObject("$unwind", (Object)"$question");
        BasicDBObject questionnaireLookup = DBUtils.createLookup((String)"questionnaire", (String)"question.questionnaire.$id", (String)"_id", (String)"question.questionnaire");
        BasicDBObject questionnaireUnWind = new BasicDBObject("$unwind", (Object)"$question.questionnaire");
        BasicDBObject teamLookup = DBUtils.createLookup((String)"team", (String)"question.team.$id", (String)"_id", (String)"question.team");
        BasicDBObject teamUnWind = new BasicDBObject("$unwind", (Object)new BasicDBObject("path", (Object)"$question.team").append("preserveNullAndEmptyArrays", (Object)true));
        BasicDBObject userLookup = DBUtils.createLookup((String)"user", (String)"user.$id", (String)"_id", (String)"user");
        BasicDBObject userUnWind = new BasicDBObject("$unwind", (Object)new BasicDBObject("path", (Object)"$user").append("preserveNullAndEmptyArrays", (Object)true));
        BasicDBObject userProjection = new BasicDBObject();
        userProjection.append("user._id", (Object)"$user._id");
        userProjection.append("user.userName", (Object)"$user.userName");
        userProjection.append("user.fullName", (Object)"$user.fullName");
        userProjection.append("user.firstName", (Object)"$user.firstName");
        userProjection.append("user.lastName", (Object)"$user.lastName");
        userProjection.append("user.email", (Object)"$user.email");
        userProjection.append("user.picturePath", (Object)"$user.picturePath");
        userProjection.append("user.backgroundColor", (Object)"$user.backgroundColor");
        userProjection.append("user.imgPath", (Object)"$user.imgPath");
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("selectedAnswer", (Object)1).append("publicUser", (Object)1).append("createdBy", (Object)1).append("createdOn", (Object)1).append("archive", (Object)1).append("tenant", (Object)1).append("rowStatus", (Object)1).append("question._id", (Object)1).append("question.questionText", (Object)1).append("question.answerTemplateId", (Object)1).append("question.answerTemplate", (Object)1).append("question.urlToken", (Object)1).append("question.questionnaire", (Object)1).append("question.team._id", (Object)1).append("question.team.title", (Object)1).append("question.team.label", (Object)1).append("question.team.color", (Object)1).append("question.team.boardId", (Object)1).append("question.team.projectId", (Object)1).append("question.team.issueTypeId", (Object)1).append("user._id", (Object)"$user._id").append("user.userName", (Object)"$user.userName").append("user.fullName", (Object)"$user.fullName").append("user.firstName", (Object)"$user.firstName").append("user.lastName", (Object)"$user.lastName").append("user.email", (Object)"$user.email").append("user.picturePath", (Object)"$user.picturePath").append("user.backgroundColor", (Object)"$user.backgroundColor").append("user.imgPath", (Object)"$user.imgPath"));
        List<DBObject> pipeLine = Arrays.asList(matchStage, questionLookup, questionUnWind, questionnaireLookup, questionnaireUnWind, teamLookup, teamUnWind, userLookup, userUnWind, projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(Answer.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        Cursor dbCursor = collection.aggregate(pipeLine, aggregationOptions);
        ArrayList<Answer> answers = new ArrayList<Answer>();
        while (dbCursor.hasNext()) {
            DBObject obj = (DBObject)dbCursor.next();
            Answer answer = new Answer();
            answer.setId(DBUtils.getIdFromDBObject((BasicDBObject)((BasicDBObject)obj), (String[])new String[0]));
            answer.setSelectedAnswer((String)obj.get("selectedAnswer"));
            answer.setQuestion(new Question((BasicDBObject)obj.get("question")));
            if (obj.get("publicUser") != null) {
                answer.setPublicUser((Map)obj.get("publicUser"));
            } else {
                answer.setUser(new User((BasicDBObject)obj.get("user")));
            }
            answers.add(answer);
        }
        return answers;
    }

    public Map<String, Object> getAnswersAndQuestions(String questionnaireId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        List questionList = this.getQuestionList(questionnaireId);
        ArrayList<ObjectId> questionIds = new ArrayList<ObjectId>();
        for (Question question : questionList) {
            String questionId = question.getId();
            questionIds.add(new ObjectId(questionId));
        }
        List answers = this.findByQuestionIdIn(questionIds);
        response.put("answers", answers);
        response.put("questions", questionList);
        return response;
    }

    public boolean getAnswersByUser(String questionnaireId, String userId, List<Question> questions) {
        List<Object> questionList = new ArrayList();
        questionList = !PropertyValidator.isValid(questions) ? this.getQuestionList(questionnaireId) : questions;
        ArrayList<String> questionIds = new ArrayList<String>();
        for (Question question : questionList) {
            questionIds.add(question.getId());
        }
        try {
            List answers = this.answerRepository.findByQuestionIdIn(questionIds);
            if (answers.isEmpty()) {
                return false;
            }
            for (Answer answer : answers) {
                String mail;
                if (!(answer.getUser() != null ? answer.getUser().getId().equals(userId) : (mail = (String)answer.getPublicUser().get("email")).equals(userId))) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage());
            return false;
        }
    }

    public Map<String, Object> getAnswersCount(String questionnaireId, List<Question> questions) {
        List<Object> questionList = new ArrayList();
        questionList = !PropertyValidator.isValid(questions) ? this.getQuestionList(questionnaireId) : questions;
        ArrayList<ObjectId> questionIds = new ArrayList<ObjectId>();
        LinkedHashMap<String, Object> answerCountsOfQuestionByOptionSelected = new LinkedHashMap<String, Object>();
        for (Question question : questionList) {
            String string = question.getId();
            questionIds.add(new ObjectId(string));
        }
        List answers = this.findByQuestionIdIn(questionIds);
        for (Question question : questionList) {
            LinkedHashMap<String, Integer> optionsCount = new LinkedHashMap<String, Integer>();
            for (Option option : question.getAnswerTemplate().getOptions()) {
                optionsCount.put(option.getValue(), 0);
            }
            for (Answer answer : answers) {
                if (!answer.getQuestion().getId().equals(question.getId())) continue;
                int count = (Integer)((HashMap)optionsCount).get(answer.getSelectedAnswer()) + 1;
                optionsCount.put(answer.getSelectedAnswer(), count);
            }
            answerCountsOfQuestionByOptionSelected.put(question.getId(), optionsCount);
        }
        return answerCountsOfQuestionByOptionSelected;
    }

    public boolean getAnswerForTeamByUser(String questionId, String userId) {
        try {
            List answers = this.answerRepository.findByQuestionId(questionId);
            if (answers.isEmpty()) {
                return false;
            }
            for (Answer answer : answers) {
                String mail;
                if (!(answer.getUser() != null ? answer.getUser().getId().equals(userId) : (mail = (String)answer.getPublicUser().get("email")).equals(userId))) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage());
            return false;
        }
    }

    public Session getSession(String sessionId) {
        Session session = this.sessionRepository.findById(sessionId);
        return session;
    }

    public Session getSessionByConfidenceVoteId(String confidenceVoteId) {
        ArrayList<Questionnaire> questionnaire = new ArrayList<Questionnaire>();
        Questionnaire qn = new Questionnaire();
        qn.setId(confidenceVoteId);
        questionnaire.add(qn);
        Session session = this.sessionRepository.findByConfidenceVoteSurveyIdIn(questionnaire);
        return session;
    }

    public String decryptToken(String token) {
        String x = null;
        try {
            x = EncDecUtility.decryptSimple((String)token);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage());
        }
        return x;
    }

    public void sendEmail(List<Answer> savedAnswers, Map<String, Object> answerCount, String boardName, List<Question> questionsOfQuestionnaire, Date endDate, boolean voteBreakdownForPublicUser) {
        List emails = this.getEmails(savedAnswers);
        String userEmail = null;
        String subject = "Confidence Vote results for " + boardName;
        String userName = null;
        SimpleDateFormat formatter = new SimpleDateFormat("dd MMMMM, yyyy");
        String strEndDate = formatter.format(endDate);
        HashMap<String, String> voteIcons = new HashMap<String, String>();
        HashMap<String, Integer> fingerValue = new HashMap<String, Integer>();
        fingerValue.put("I don't understand", 0);
        fingerValue.put("No confidence", 1);
        fingerValue.put("Little confidence", 2);
        fingerValue.put("Good confidence", 3);
        fingerValue.put("High confidence", 4);
        fingerValue.put("Very High confidence", 5);
        voteIcons.put("I don't understand", "https://kendis.io/wp-content/uploads/2021/03/conf-0.png");
        voteIcons.put("No confidence", "https://kendis.io/wp-content/uploads/2021/03/conf-1.png");
        voteIcons.put("Little confidence", "https://kendis.io/wp-content/uploads/2021/03/conf-2.png");
        voteIcons.put("Good confidence", "https://kendis.io/wp-content/uploads/2021/03/conf-3.png");
        voteIcons.put("High confidence", "https://kendis.io/wp-content/uploads/2021/03/conf-4.png");
        voteIcons.put("Very High confidence", "https://kendis.io/wp-content/uploads/2021/03/conf-5.png");
        for (Object email : emails) {
            Object userVote;
            Map voteBreakdown;
            int totalVotes;
            float average;
            Map value;
            Map voteResult;
            HashMap<String, String> mailData = new HashMap<String, String>();
            String confidenceVoteEmail = null;
            if (email instanceof Map) {
                Map userInfo = (Map)email;
                voteResult = this.getVoteResultAndVoteCount(answerCount, questionsOfQuestionnaire, savedAnswers, email);
                userName = (String)userInfo.get("fullName");
                userEmail = (String)userInfo.get("email");
                confidenceVoteEmail = "<div style='color:#354052;font-size:17px;margin:10px 0 30px 0'>Hi " + userName + ", </div> <div style='color:#354052;font-size:17px;margin:10px 0 30px 0;line-height:26px;'>Thank you for participating in Confidence Voting for " + boardName + " held on " + strEndDate + ". The results are in!</div>";
                if (voteBreakdownForPublicUser) {
                    confidenceVoteEmail = confidenceVoteEmail + "<table style='border:1px solid #ddd;border-collapse: collapse;margin:20px 0;'>     <tr style='border-bottom: 1px solid #ddd;'>          <th style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'>Confidence Vote</th>          <th style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'>Result</th>          <th style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'><img src=\"" + (String)voteIcons.get("I don't understand") + "\"/></th>          <th style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'><img src=\"" + (String)voteIcons.get("No confidence") + "\"/></th>          <th style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'><img src=\"" + (String)voteIcons.get("Little confidence") + "\"/></th>          <th style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'><img src=\"" + (String)voteIcons.get("Good confidence") + "\"/></th>          <th style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'><img src=\"" + (String)voteIcons.get("High confidence") + "\"/></th>          <th style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'><img src=\"" + (String)voteIcons.get("Very High confidence") + "\"/></th>          <th style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'>Avg. Score</th>     </tr> ";
                    for (Map.Entry entry : voteResult.entrySet()) {
                        value = (Map)entry.getValue();
                        confidenceVoteEmail = confidenceVoteEmail + "<tr style='border-bottom: 1px solid #ddd;'> ";
                        confidenceVoteEmail = confidenceVoteEmail + "<td style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'>" + (String)entry.getKey() + "</td> ";
                        for (Map.Entry entry1 : value.entrySet()) {
                            if (((String)entry1.getKey()).equals("result")) {
                                confidenceVoteEmail = confidenceVoteEmail + "<td style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'><img src=\"" + (String)voteIcons.get(entry1.getValue()) + "\" /></td> ";
                                continue;
                            }
                            if (!((String)entry1.getKey()).equals("voteBreakdown")) continue;
                            average = 0.0f;
                            totalVotes = 0;
                            voteBreakdown = (Map)entry1.getValue();
                            for (Map.Entry breakdownEntry : voteBreakdown.entrySet()) {
                                if (!Objects.equal(breakdownEntry.getKey(), (Object)"I don't understand")) {
                                    totalVotes += ((Integer)breakdownEntry.getValue()).intValue();
                                }
                                average += (float)((Integer)breakdownEntry.getValue() * (Integer)fingerValue.get(breakdownEntry.getKey()));
                                confidenceVoteEmail = confidenceVoteEmail + "<td style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'>" + breakdownEntry.getValue() + "</td> ";
                            }
                            if (totalVotes == 0) {
                                average = 0.0f;
                            } else {
                                average /= (float)totalVotes;
                                average = (float)((double)Math.round((double)average * 100.0) / 100.0);
                            }
                            confidenceVoteEmail = confidenceVoteEmail + "<td style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'>" + average + "</td> ";
                        }
                        confidenceVoteEmail = confidenceVoteEmail + "</tr>";
                    }
                    confidenceVoteEmail = confidenceVoteEmail + "</table><br/>";
                }
                confidenceVoteEmail = confidenceVoteEmail + "<table style='border:1px solid #ddd;border-collapse: collapse;margin:20px 0;'>     <tr style='border-bottom: 1px solid #ddd;'>          <th style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'>Confidence Vote</th>          <th style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'>Your vote</th>     </tr> ";
                for (Map.Entry entry : voteResult.entrySet()) {
                    value = (Map)entry.getValue();
                    confidenceVoteEmail = confidenceVoteEmail + "<tr style='border-bottom: 1px solid #ddd;'> ";
                    confidenceVoteEmail = confidenceVoteEmail + "<td style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'>" + (String)entry.getKey() + "</td> ";
                    userVote = (String)value.get("userVote");
                    confidenceVoteEmail = !((String)userVote).equals("-") ? confidenceVoteEmail + "<td style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'><img src=\"" + (String)voteIcons.get(userVote) + "\" /></td> " : confidenceVoteEmail + "<td style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'>" + (String)userVote + "</td> ";
                    confidenceVoteEmail = confidenceVoteEmail + "</tr>";
                }
                confidenceVoteEmail = confidenceVoteEmail + "</table><br/>";
                confidenceVoteEmail = confidenceVoteEmail + "<div style='color:#354052;font-size:16px;line-height:24px;margin-top:20px'><b>Sincerely,</b><div>Kendis Support</div></div>";
                mailData.put("confidenceVoteEmail", confidenceVoteEmail);
            } else if (email instanceof User) {
                User user = (User)email;
                userName = user.getFirstName();
                userEmail = user.getEmail();
                voteResult = this.getVoteResultAndVoteCount(answerCount, questionsOfQuestionnaire, savedAnswers, email);
                confidenceVoteEmail = "<div style='color:#354052;font-size:17px;margin:10px 0 30px 0'>Hi " + userName + ", </div> <div style='color:#354052;font-size:17px;margin:10px 0 30px 0;line-height:26px;'>Thank you for participating in Confidence Voting for " + boardName + " held on " + strEndDate + ". The results are in!</div>";
                confidenceVoteEmail = confidenceVoteEmail + "<table style='border:1px solid #ddd;border-collapse: collapse;margin:20px 0;'>     <tr style='border-bottom: 1px solid #ddd;'>          <th style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'>Confidence Vote</th>          <th style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'>Result</th>          <th style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'><img src=\"" + (String)voteIcons.get("I don't understand") + "\"/></th>          <th style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'><img src=\"" + (String)voteIcons.get("No confidence") + "\"/></th>          <th style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'><img src=\"" + (String)voteIcons.get("Little confidence") + "\"/></th>          <th style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'><img src=\"" + (String)voteIcons.get("Good confidence") + "\"/></th>          <th style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'><img src=\"" + (String)voteIcons.get("High confidence") + "\"/></th>          <th style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'><img src=\"" + (String)voteIcons.get("Very High confidence") + "\"/></th>          <th style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'>Avg. Score</th>     </tr> ";
                for (Map.Entry entry : voteResult.entrySet()) {
                    value = (Map)entry.getValue();
                    confidenceVoteEmail = confidenceVoteEmail + "<tr style='border-bottom: 1px solid #ddd;'> ";
                    confidenceVoteEmail = confidenceVoteEmail + "<td style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'>" + (String)entry.getKey() + "</td> ";
                    for (Map.Entry entry1 : value.entrySet()) {
                        if (((String)entry1.getKey()).equals("result")) {
                            confidenceVoteEmail = confidenceVoteEmail + "<td style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'><img src=\"" + (String)voteIcons.get(entry1.getValue()) + "\" /></td> ";
                            continue;
                        }
                        if (!((String)entry1.getKey()).equals("voteBreakdown")) continue;
                        average = 0.0f;
                        totalVotes = 0;
                        voteBreakdown = (Map)entry1.getValue();
                        for (Map.Entry breakdownEntry : voteBreakdown.entrySet()) {
                            if (!Objects.equal(breakdownEntry.getKey(), (Object)"I don't understand")) {
                                totalVotes += ((Integer)breakdownEntry.getValue()).intValue();
                            }
                            average += (float)((Integer)breakdownEntry.getValue() * (Integer)fingerValue.get(breakdownEntry.getKey()));
                            confidenceVoteEmail = confidenceVoteEmail + "<td style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'>" + breakdownEntry.getValue() + "</td> ";
                        }
                        if (totalVotes == 0) {
                            average = 0.0f;
                        } else {
                            average /= (float)totalVotes;
                            average = (float)((double)Math.round((double)average * 100.0) / 100.0);
                        }
                        confidenceVoteEmail = confidenceVoteEmail + "<td style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'>" + average + "</td> ";
                    }
                    confidenceVoteEmail = confidenceVoteEmail + "</tr>";
                }
                confidenceVoteEmail = confidenceVoteEmail + "</table><br/>";
                confidenceVoteEmail = confidenceVoteEmail + "<table style='border:1px solid #ddd;border-collapse: collapse;margin:20px 0;'>     <tr style='border-bottom: 1px solid #ddd;'>          <th style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'>Confidence Vote</th>          <th style='color:#354052;font-size:13px;padding:10px;'>Your vote</th>     </tr> ";
                for (Map.Entry entry : voteResult.entrySet()) {
                    value = (Map)entry.getValue();
                    confidenceVoteEmail = confidenceVoteEmail + "<tr style='border-bottom: 1px solid #ddd;'>";
                    confidenceVoteEmail = confidenceVoteEmail + "<td style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'>" + (String)entry.getKey() + "</td> ";
                    userVote = (String)value.get("userVote");
                    confidenceVoteEmail = !((String)userVote).equals("-") ? confidenceVoteEmail + "<td style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'><img src=\"" + (String)voteIcons.get(userVote) + "\" /></td> " : confidenceVoteEmail + "<td style='color:#354052;font-size:13px;padding:10px;border-right:1px solid #ddd;'>" + (String)userVote + "</td> ";
                    confidenceVoteEmail = confidenceVoteEmail + "</tr>";
                }
                confidenceVoteEmail = confidenceVoteEmail + "</table>";
                confidenceVoteEmail = confidenceVoteEmail + "<div style='color:#354052;font-size:16px;line-height:24px;margin-top:20px'><b>Sincerely,</b><div>Kendis Support</div></div>";
                mailData.put("confidenceVoteEmail", confidenceVoteEmail);
            }
            try {
                this.localMailSender.sendMail(userEmail, subject, "voteResultsEmail", mailData, true);
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage());
            }
        }
    }

    public List<Object> getEmails(List<Answer> savedAnswers) {
        ArrayList<Object> users = new ArrayList<Object>();
        for (Answer answer : savedAnswers) {
            if (answer.getPublicUser() != null) {
                Map voter = answer.getPublicUser();
                voter.remove("backgroundColor");
                if (users.contains(voter)) continue;
                users.add(answer.getPublicUser());
                continue;
            }
            if (users.contains(answer.getUser())) continue;
            users.add(answer.getUser());
        }
        return users;
    }

    public Map<String, LinkedHashMap<String, Object>> getVoteResultAndVoteCount(Map<String, Object> answerCount, List<Question> questionsOfQuestionnaire, List<Answer> savedAnswers, Object user) {
        LinkedHashMap<String, LinkedHashMap<String, Object>> resultAndCount = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        for (Map.Entry<String, Object> entry : answerCount.entrySet()) {
            String key = entry.getKey();
            Map value = (Map)entry.getValue();
            Question q = questionsOfQuestionnaire.stream().filter(questionById -> key.equals(questionById.getId())).findFirst().orElse(null);
            String teamName = null;
            try {
                teamName = q.getTeam().getTitle();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            Map.Entry maxEntry = null;
            for (Map.Entry entry1 : value.entrySet()) {
                Integer entryValue = (Integer)entry1.getValue();
                Integer maxEntryValue = 0;
                if (maxEntry != null) {
                    maxEntryValue = (Integer)maxEntry.getValue();
                }
                if (maxEntry != null && entryValue <= maxEntryValue) continue;
                maxEntry = entry1;
            }
            String userVote = this.getUserVote(savedAnswers, user, q);
            result.put("result", maxEntry.getKey());
            if (userVote == null) {
                result.put("userVote", "-");
            } else {
                result.put("userVote", userVote);
            }
            result.put("voteBreakdown", value);
            if (teamName == null) {
                resultAndCount.put("PI Planning", result);
                continue;
            }
            resultAndCount.put(teamName, result);
        }
        return resultAndCount;
    }

    public String getUserVote(List<Answer> savedAnswers, Object user, Question q) {
        Answer userVote = null;
        if (user instanceof Map) {
            Map voter = (Map)user;
            voter.remove("backgroundColor");
            for (Answer answer : savedAnswers) {
                if (answer.getPublicUser() == null) continue;
                Map voterOfAnswer = answer.getPublicUser();
                voterOfAnswer.remove("backgroundColor");
                if (!voterOfAnswer.equals(voter) || !answer.getQuestion().equals((Object)q)) continue;
                userVote = answer;
                break;
            }
        } else if (user instanceof User) {
            User voter = (User)user;
            for (Answer answer : savedAnswers) {
                if (answer.getUser() == null || !answer.getUser().equals((Object)voter) || !answer.getQuestion().equals((Object)q)) continue;
                userVote = answer;
                break;
            }
        }
        if (userVote == null) {
            return null;
        }
        return userVote.getSelectedAnswer();
    }

    public Questionnaire fetchQuestionnaire(String questionnaireId) {
        Questionnaire questionnaire = this.questionnaireRepository.findById(questionnaireId);
        return questionnaire;
    }

    public List<Team> getTeams(String sessionId) {
        Session session = this.sessionRepository.findById(sessionId);
        SessionBoard currentSessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)session.getActiveSessionBoard()));
        List teamList = currentSessionBoard.getTeams();
        return teamList;
    }

    public String exportConfidenceVote(List<Answer> answerList, List<Question> questionList, Questionnaire questionaireSaved, List<Team> teamList, String boardName) {
        try {
            int i;
            int rowNumber = 0;
            int kendisUsers = 0;
            int publicUsers = 0;
            DecimalFormat df = new DecimalFormat("0.00");
            String fileName = new Date().getTime() + ".xls";
            String filePath = this.env.getProperty("temp.file.location") + fileName;
            String[] voteText = new String[]{"I\ndon't\nunderstand\n(0)", "No\nconfidence\n(1)", "Little\nconfidence\n(2)", "Good\nconfidence\n(3)", "High\nconfidence\n(4)", "Very\nHigh\nconfidence\n(5)"};
            String[] votedText = new String[]{"I don't understand", "No confidence", "Little confidence", "Good confidence", "High confidence", "Very High confidence"};
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet wSheet = workbook.createSheet("Results");
            HashMap userMap = new HashMap();
            HashMap<String, String> userNames = new HashMap<String, String>();
            HashMap<String, String> userTypeMap = new HashMap<String, String>();
            HashMap<String, String> userBoardScoreMap = new HashMap<String, String>();
            HashMap<String, String> userTeamScoreMap = new HashMap<String, String>();
            HashMap<String, ArrayList<String>> totalVotedUsersTeam = new HashMap<String, ArrayList<String>>();
            HashMap<String, String> totalVotedUsersBoard = new HashMap<String, String>();
            HashMap<String, String> userVoteMap = new HashMap<String, String>();
            HashMap<String, String> scoreMap = new HashMap<String, String>();
            scoreMap.put("I don't understand", "0");
            scoreMap.put("No confidence", "1");
            scoreMap.put("Little confidence", "2");
            scoreMap.put("Good confidence", "3");
            scoreMap.put("High confidence", "4");
            scoreMap.put("Very High confidence", "5");
            for (Answer answer : answerList) {
                String userName = "";
                if (PropertyValidator.isValid((Object)answer.getPublicUser())) {
                    Map publicUser = answer.getPublicUser();
                    userName = (String)publicUser.get("email");
                    userMap.put((String)publicUser.get("email"), publicUser);
                    userTypeMap.put((String)publicUser.get("email"), "Yes");
                    userNames.put((String)publicUser.get("email"), (String)publicUser.get("fullName"));
                    if (answer.getQuestion().getTeam() != null) {
                        ArrayList<String> teamNames = (ArrayList<String>)totalVotedUsersTeam.get((String)publicUser.get("email"));
                        if (teamNames == null) {
                            teamNames = new ArrayList<String>();
                        }
                        teamNames.add(answer.getQuestion().getTeam().getId());
                        totalVotedUsersTeam.put((String)publicUser.get("email"), teamNames);
                        userVoteMap.put(answer.getQuestion().getTeam().getId() + (String)publicUser.get("email"), answer.getSelectedAnswer());
                    } else {
                        totalVotedUsersBoard.put((String)publicUser.get("email"), "board");
                        userVoteMap.put("board" + (String)publicUser.get("email"), answer.getSelectedAnswer());
                    }
                } else {
                    userName = answer.getUser().getEmail();
                    userMap.put(answer.getUser().getEmail(), answer.getUser());
                    userTypeMap.put(answer.getUser().getEmail(), "No");
                    userNames.put(answer.getUser().getEmail(), (String)answer.getUser());
                    if (answer.getQuestion().getTeam() != null) {
                        ArrayList<String> teamNames = (ArrayList<String>)totalVotedUsersTeam.get(answer.getUser().getEmail());
                        if (teamNames == null) {
                            teamNames = new ArrayList<String>();
                        }
                        teamNames.add(answer.getQuestion().getTeam().getId());
                        totalVotedUsersTeam.put(answer.getUser().getEmail(), teamNames);
                        userVoteMap.put(answer.getQuestion().getTeam().getId() + answer.getUser().getEmail(), answer.getSelectedAnswer());
                    } else {
                        totalVotedUsersBoard.put(answer.getUser().getEmail(), "board");
                        userVoteMap.put("board" + answer.getUser().getEmail(), answer.getSelectedAnswer());
                    }
                }
                if (answer.getQuestion().getTeam() == null) {
                    userBoardScoreMap.put(userName, answer.getSelectedAnswer());
                    continue;
                }
                if (answer.getQuestion().getTeam() == null) continue;
                userTeamScoreMap.put(userName + answer.getQuestion().getTeam().getId(), answer.getSelectedAnswer());
            }
            int participantCount = userMap.keySet().size();
            for (String key : userMap.keySet()) {
                if (((String)userTypeMap.get(key)).equals("Yes")) {
                    ++publicUsers;
                    continue;
                }
                ++kendisUsers;
            }
            for (String key : userVoteMap.keySet()) {
                LOGGER.info(key);
            }
            HSSFRow hSSFRow = wSheet.createRow((int)((short)rowNumber));
            HSSFCell boardNameCell = hSSFRow.createCell(1);
            HSSFCellStyle boardNameCellStyle = workbook.createCellStyle();
            HSSFCellStyle boldTextCells = workbook.createCellStyle();
            HSSFCellStyle wrapText = workbook.createCellStyle();
            wrapText.setWrapText(true);
            HSSFFont txtFont = workbook.createFont();
            HSSFFont txtFontBold = workbook.createFont();
            txtFont.setFontName("Arial");
            txtFont.setFontHeightInPoints((short)15);
            txtFontBold.setBold(true);
            txtFontBold.setFontHeightInPoints((short)10);
            boardNameCellStyle.setFont(txtFont);
            boldTextCells.setWrapText(true);
            boldTextCells.setFont(txtFontBold);
            wSheet.setColumnWidth(0, 7800);
            wSheet.setColumnWidth(1, 5000);
            wSheet.setColumnWidth(2, 5000);
            wSheet.setColumnWidth(7, 5000);
            boardNameCell.setCellStyle(boardNameCellStyle);
            boardNameCell.setCellValue("Confidence voting Report: " + boardName);
            HSSFRow dateTimeHeader = wSheet.createRow((int)((short)(rowNumber += 3)));
            HSSFCell dateTimeCell = dateTimeHeader.createCell(0);
            HSSFCell durationCell = dateTimeHeader.createCell(1);
            HSSFCell participantsCell = dateTimeHeader.createCell(2);
            HSSFCell kendisUserHeader = dateTimeHeader.createCell(3);
            HSSFCell guestUserHeader = dateTimeHeader.createCell(4);
            dateTimeCell.setCellStyle(boldTextCells);
            durationCell.setCellStyle(boldTextCells);
            participantsCell.setCellStyle(boldTextCells);
            kendisUserHeader.setCellStyle(boldTextCells);
            guestUserHeader.setCellStyle(boldTextCells);
            dateTimeCell.setCellValue("Actual Start Time");
            durationCell.setCellValue("Duration");
            participantsCell.setCellValue("Participants");
            kendisUserHeader.setCellValue("Kendis Users");
            guestUserHeader.setCellValue("Guest Users");
            String votingDateStart = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z").format(questionaireSaved.getVoteStartedDate());
            HSSFRow dateTimeData = wSheet.createRow((int)((short)(++rowNumber)));
            HSSFCell dateTimeCellData = dateTimeData.createCell(0);
            HSSFCell durationCellData = dateTimeData.createCell(1);
            HSSFCell participantsCellData = dateTimeData.createCell(2);
            HSSFCell kendisUserData = dateTimeData.createCell(3);
            HSSFCell guestUserData = dateTimeData.createCell(4);
            dateTimeCellData.setCellValue(votingDateStart);
            durationCellData.setCellValue(questionaireSaved.getDuration() + " minutes");
            participantsCellData.setCellValue((double)participantCount);
            kendisUserData.setCellValue((double)kendisUsers);
            guestUserData.setCellValue((double)publicUsers);
            HSSFRow averageVote = wSheet.createRow((int)((short)(rowNumber += 2)));
            int cellNumHeader = 1;
            HSSFCell averageResultHeader = averageVote.createCell((int)((short)cellNumHeader));
            HSSFCell totalVotedHeader = averageVote.createCell((int)((short)(++cellNumHeader)));
            averageResultHeader.setCellStyle(boldTextCells);
            totalVotedHeader.setCellStyle(boldTextCells);
            averageResultHeader.setCellValue("Average Result");
            totalVotedHeader.setCellValue("Total Voted");
            for (int i2 = 0; i2 < voteText.length; ++i2) {
                wSheet.setColumnWidth(++cellNumHeader, 3000);
                HSSFCell voteTextHeader = averageVote.createCell((int)((short)cellNumHeader));
                voteTextHeader.setCellStyle(wrapText);
                voteTextHeader.setCellStyle(boldTextCells);
                voteTextHeader.setCellValue(voteText[i2]);
            }
            HSSFRow boardVoteData = wSheet.createRow((int)((short)(++rowNumber)));
            HSSFCell boardVoteDataCell = boardVoteData.createCell(0);
            HSSFCell boardVoteAverageCell = boardVoteData.createCell(1);
            HSSFCell boardTotalVotersCell = boardVoteData.createCell(2);
            boardVoteDataCell.setCellStyle(boldTextCells);
            boardVoteDataCell.setCellValue(boardName);
            int cellIndex = 3;
            int totalVoterCountExactForBoard = totalVotedUsersBoard.size();
            double voteScoreBoard = 0.0;
            double averageVoteScoreBoard = 0.0;
            for (i = 0; i < votedText.length; ++i) {
                int votedTextInteger = 0;
                HSSFCell voteTextCell = boardVoteData.createCell((int)((short)cellIndex));
                String voteTextCasted = "";
                for (String key : userVoteMap.keySet()) {
                    if (!key.substring(0, 5).equals("board") || !votedText[i].equals(voteTextCasted = ((String)userVoteMap.get(key)).toString())) continue;
                    if (!voteTextCasted.equals("I don't understand")) {
                        voteScoreBoard += Double.parseDouble((String)scoreMap.get(voteTextCasted));
                    } else {
                        --totalVoterCountExactForBoard;
                    }
                    ++votedTextInteger;
                }
                voteTextCell.setCellValue((double)votedTextInteger);
                ++cellIndex;
            }
            if (totalVotedUsersBoard.size() == 0) {
                averageVoteScoreBoard = 0.0;
            } else if (totalVoterCountExactForBoard > 0) {
                averageVoteScoreBoard = voteScoreBoard / (double)totalVoterCountExactForBoard;
            }
            averageVoteScoreBoard = Double.parseDouble(df.format(averageVoteScoreBoard));
            boardVoteAverageCell.setCellValue(averageVoteScoreBoard);
            boardTotalVotersCell.setCellValue((double)totalVotedUsersBoard.size());
            for (i = 0; i < teamList.size(); ++i) {
                ++rowNumber;
                cellIndex = 3;
                int voterCount = 0;
                int totalVoterCountCalculated = 0;
                double teamVoterScore = 0.0;
                double teamScoreAverage = 0.0;
                HSSFRow teamVoteData = wSheet.createRow((int)((short)rowNumber));
                HSSFCell teamVoteDataCell = teamVoteData.createCell(0);
                HSSFCell teamVoteAverageCell = teamVoteData.createCell(1);
                HSSFCell teamTotalVotersCell = teamVoteData.createCell(2);
                teamVoteDataCell.setCellStyle(boldTextCells);
                teamVoteDataCell.setCellValue(teamList.get(i).getTitle());
                for (String key : totalVotedUsersTeam.keySet()) {
                    List votedTeams = (List)totalVotedUsersTeam.get(key);
                    for (Object votedTeam : votedTeams) {
                        if (!teamList.get(i).getId().equals(votedTeam)) continue;
                        ++voterCount;
                    }
                }
                totalVoterCountCalculated = voterCount;
                for (int j = 0; j < votedText.length; ++j) {
                    Object votedTeam;
                    int votedTextInteger = 0;
                    HSSFCell voteTextCell = teamVoteData.createCell((int)((short)cellIndex));
                    String voteTextCasted = "";
                    votedTeam = userVoteMap.keySet().iterator();
                    while (votedTeam.hasNext()) {
                        String key = (String)votedTeam.next();
                        String teamName = "";
                        if (!key.substring(0, 5).equals("board")) {
                            teamName = key.substring(0, teamList.get(i).getId().length());
                        }
                        if (!teamName.equals(teamList.get(i).getId()) || !votedText[j].equals(voteTextCasted = ((String)userVoteMap.get(key)).toString())) continue;
                        if (!voteTextCasted.equals("I don't understand")) {
                            teamVoterScore += Double.parseDouble((String)scoreMap.get(voteTextCasted));
                        } else {
                            --totalVoterCountCalculated;
                        }
                        ++votedTextInteger;
                    }
                    voteTextCell.setCellValue((double)votedTextInteger);
                    ++cellIndex;
                }
                if (voterCount == 0) {
                    teamScoreAverage = 0.0;
                } else if (totalVoterCountCalculated > 0) {
                    teamScoreAverage = teamVoterScore / (double)totalVoterCountCalculated;
                }
                if (!PropertyValidator.isValid((Object)teamScoreAverage) || Double.isNaN(teamScoreAverage)) continue;
                teamScoreAverage = Double.parseDouble(df.format(teamScoreAverage));
                teamVoteAverageCell.setCellValue(teamScoreAverage);
                teamTotalVotersCell.setCellValue((double)voterCount);
            }
            rowNumber = 0;
            if (questionaireSaved.isHasPublicResult()) {
                HSSFSheet wSheetTwo = workbook.createSheet("Attendee-Details");
                HSSFRow confidenceVoteHeader = wSheetTwo.createRow((int)((short)rowNumber));
                HSSFCell confidenceVoteHeaderCell = confidenceVoteHeader.createCell(1);
                HSSFCellStyle confidenceVoteStyle = workbook.createCellStyle();
                confidenceVoteStyle.setFont(txtFont);
                confidenceVoteHeaderCell.setCellStyle(confidenceVoteStyle);
                confidenceVoteHeaderCell.setCellValue("Confidence Voting Attendee Report: " + boardName);
                HSSFRow legendRow = wSheetTwo.createRow((int)((short)(++rowNumber)));
                HSSFCell legendCell = legendRow.createCell(7);
                legendCell.setCellStyle(boldTextCells);
                legendCell.setCellValue("Legend");
                HSSFRow actualStartTimerRow = wSheetTwo.createRow((int)((short)(++rowNumber)));
                HSSFCell actualStartTimeHeader = actualStartTimerRow.createCell(1);
                HSSFCell actualStartTimeCell = actualStartTimerRow.createCell(2);
                HSSFCell veryHighConfidence = actualStartTimerRow.createCell(7);
                HSSFCell veryHighConfidenceCell = actualStartTimerRow.createCell(8);
                actualStartTimeHeader.setCellStyle(boldTextCells);
                actualStartTimeHeader.setCellValue("Actual Start Time");
                actualStartTimeCell.setCellValue(votingDateStart);
                veryHighConfidence.setCellValue("Very High Confidence");
                veryHighConfidenceCell.setCellValue("5");
                HSSFRow durationRow = wSheetTwo.createRow((int)((short)(++rowNumber)));
                HSSFCell durationHeader = durationRow.createCell(1);
                HSSFCell durationData = durationRow.createCell(2);
                HSSFCell highConfidence = durationRow.createCell(7);
                HSSFCell highConfidenceCell = durationRow.createCell(8);
                durationHeader.setCellStyle(boldTextCells);
                durationHeader.setCellValue("Duration");
                durationData.setCellValue(questionaireSaved.getDuration() + " minutes");
                highConfidence.setCellValue("High Confidence");
                highConfidenceCell.setCellValue("4");
                HSSFRow totalParticipantsRow = wSheetTwo.createRow((int)((short)(++rowNumber)));
                HSSFCell totalParticipantsHeader = totalParticipantsRow.createCell(1);
                HSSFCell totalParticipantsData = totalParticipantsRow.createCell(2);
                HSSFCell goodConfidence = totalParticipantsRow.createCell(7);
                HSSFCell goodConfidenceCell = totalParticipantsRow.createCell(8);
                totalParticipantsHeader.setCellStyle(boldTextCells);
                totalParticipantsHeader.setCellValue("Total Participants");
                totalParticipantsData.setCellValue((double)participantCount);
                goodConfidence.setCellValue("Good Confidence");
                goodConfidenceCell.setCellValue("3");
                HSSFRow kendisUsersRow = wSheetTwo.createRow((int)((short)(++rowNumber)));
                HSSFCell kendisUsersHeader = kendisUsersRow.createCell(1);
                HSSFCell kendisUsersCell = kendisUsersRow.createCell(2);
                HSSFCell littleConfidence = kendisUsersRow.createCell(7);
                HSSFCell littleConfidenceCell = kendisUsersRow.createCell(8);
                kendisUsersHeader.setCellStyle(boldTextCells);
                kendisUsersHeader.setCellValue("Kendis Users");
                kendisUsersCell.setCellValue((double)kendisUsers);
                littleConfidence.setCellValue("Little Confidence");
                littleConfidenceCell.setCellValue("2");
                HSSFRow guestUsersRow = wSheetTwo.createRow((int)((short)(++rowNumber)));
                HSSFCell guestUsersHeader = guestUsersRow.createCell(1);
                HSSFCell guestUsersCell = guestUsersRow.createCell(2);
                HSSFCell noConfidence = guestUsersRow.createCell(7);
                HSSFCell noConfidenceCell = guestUsersRow.createCell(8);
                guestUserHeader.setCellStyle(boldTextCells);
                guestUsersHeader.setCellValue("Guest Users");
                guestUsersCell.setCellValue((double)publicUsers);
                noConfidence.setCellValue("No Confidence");
                noConfidenceCell.setCellValue("1");
                HSSFRow legendNewRow = wSheetTwo.createRow((int)((short)(++rowNumber)));
                HSSFCell unknownHeader = legendNewRow.createCell(7);
                HSSFCell unknownCell = legendNewRow.createCell(8);
                unknownHeader.setCellValue("I Don't Know");
                unknownCell.setCellValue("0");
                HSSFRow attendeeTeamHeaderRow = wSheetTwo.createRow((int)((short)(++rowNumber)));
                HSSFCell attendeeHeader = attendeeTeamHeaderRow.createCell(1);
                HSSFCell teamHeader = attendeeTeamHeaderRow.createCell(5);
                attendeeHeader.setCellStyle(boldTextCells);
                teamHeader.setCellStyle(boldTextCells);
                attendeeHeader.setCellValue("Attendee Details");
                teamHeader.setCellValue("Teams");
                int columnNum = 0;
                HSSFRow confidenceTeamVotes = wSheetTwo.createRow((int)((short)(++rowNumber)));
                wSheetTwo.setColumnWidth(columnNum, 5000);
                HSSFCell guestUserCell = confidenceTeamVotes.createCell((int)((short)columnNum));
                wSheetTwo.setColumnWidth(++columnNum, 5000);
                HSSFCell firstNameCell = confidenceTeamVotes.createCell((int)((short)columnNum));
                wSheetTwo.setColumnWidth(++columnNum, 5000);
                HSSFCell lastNameCell = confidenceTeamVotes.createCell((int)((short)columnNum));
                wSheetTwo.setColumnWidth(++columnNum, 5000);
                HSSFCell emailCell = confidenceTeamVotes.createCell((int)((short)columnNum));
                wSheetTwo.setColumnWidth(++columnNum, 5000);
                HSSFCell boardCell = confidenceTeamVotes.createCell((int)((short)columnNum));
                guestUserCell.setCellStyle(boldTextCells);
                firstNameCell.setCellStyle(boldTextCells);
                lastNameCell.setCellStyle(boldTextCells);
                emailCell.setCellStyle(boldTextCells);
                boardCell.setCellStyle(boldTextCells);
                guestUserCell.setCellValue("Guest User");
                firstNameCell.setCellValue("First Name");
                lastNameCell.setCellValue("Last Name");
                emailCell.setCellValue("Email");
                boardCell.setCellValue(boardName);
                for (int i3 = 0; i3 < teamList.size(); ++i3) {
                    wSheetTwo.setColumnWidth(++columnNum, 5000);
                    HSSFCell voteTextHeader = confidenceTeamVotes.createCell((int)((short)columnNum));
                    voteTextHeader.setCellStyle(boldTextCells);
                    voteTextHeader.setCellValue(teamList.get(i3).getTitle());
                }
                for (Map.Entry mapData : userTypeMap.entrySet()) {
                    HSSFRow tabDataRow = wSheetTwo.createRow((int)((short)(++rowNumber)));
                    HSSFCell userType = tabDataRow.createCell(0);
                    HSSFCell firstName = tabDataRow.createCell(1);
                    HSSFCell lastName = tabDataRow.createCell(2);
                    HSSFCell email = tabDataRow.createCell(3);
                    HSSFCell boardVoteScore = tabDataRow.createCell(4);
                    userType.setCellValue((String)mapData.getValue());
                    if (((String)mapData.getValue()).equals("Yes")) {
                        firstName.setCellValue((String)userNames.get(mapData.getKey()));
                        lastName.setCellValue("");
                    } else {
                        User userData = (User)userNames.get(mapData.getKey());
                        firstName.setCellValue(userData.getFirstName());
                        lastName.setCellValue(userData.getLastName());
                    }
                    email.setCellValue((String)mapData.getKey());
                    String boardScoreByUser = (String)userBoardScoreMap.get(mapData.getKey());
                    boardVoteScore.setCellValue((String)scoreMap.get(boardScoreByUser));
                    int colNum = 4;
                    for (Team teamData : teamList) {
                        HSSFCell teamScoreCell = tabDataRow.createCell((int)((short)(++colNum)));
                        teamScoreCell.setCellValue((String)scoreMap.get("" + userTeamScoreMap.get((String)mapData.getKey() + teamData.getId())));
                    }
                }
            }
            FileOutputStream file = new FileOutputStream(filePath);
            workbook.write((OutputStream)file);
            file.close();
            workbook.close();
            return filePath;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return "File Now Found!";
        }
    }

    public List<AnswerVO> convertAnswerToAnswerVO(List<Answer> answers) {
        ArrayList<AnswerVO> answerVOS = new ArrayList<AnswerVO>();
        if (!PropertyValidator.isValid(answers)) {
            return answerVOS;
        }
        answers.forEach(answer -> answerVOS.add(new AnswerVO(answer)));
        return answerVOS;
    }

    public List<QuestionVO> convertQuestionToQuestionVO(List<Question> questions) {
        ArrayList<QuestionVO> questionVOs = new ArrayList<QuestionVO>();
        if (!PropertyValidator.isValid(questions)) {
            return questionVOs;
        }
        questions.forEach(question -> questionVOs.add(new QuestionVO(question)));
        return questionVOs;
    }
}

