/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.persistence.entity.CollaborationType;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.repository.CollaborationTypeRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.SolutionBoardRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.CollaborationTypeService;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.UserContextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class CollaborationTypeServiceImpl
implements CollaborationTypeService {
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private SolutionBoardRepository solutionBoardRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private CollaborationTypeRepository collaborationTypeRepository;
    @Autowired
    private MongoTemplate mongoTemplate;

    public List<CollaborationType> linkType(String id, Map payload) throws Exception {
        String context = (String)payload.get("context");
        List typesIds = (List)payload.get("types");
        List types = this.collaborationTypeRepository.findByIdIn(typesIds);
        switch (context) {
            case "session": {
                Session session = this.sessionRepository.findById(id);
                if (session == null) break;
                for (CollaborationType type : types) {
                    ArrayList<Session> existingSessions = type.getSessions();
                    if (existingSessions != null && existingSessions.stream().anyMatch(s -> s.getId().equals(session.getId()))) continue;
                    if (existingSessions == null) {
                        existingSessions = new ArrayList<Session>();
                    }
                    existingSessions.add(session);
                    type.setSessions(existingSessions);
                }
                break;
            }
            case "solution": {
                SolutionBoard solutionBoard = this.solutionBoardRepository.findByIdIn(id);
                if (solutionBoard == null) break;
                for (CollaborationType type : types) {
                    ArrayList<SolutionBoard> existingBoards = type.getSolutionBoards();
                    if (existingBoards != null && existingBoards.stream().anyMatch(sb -> sb.getId().equals(solutionBoard.getId()))) continue;
                    if (existingBoards == null) {
                        existingBoards = new ArrayList<SolutionBoard>();
                    }
                    existingBoards.add(solutionBoard);
                    type.setSolutionBoards(existingBoards);
                }
                break;
            }
            case "workspace": {
                WorkSpace workSpace = this.workSpaceRepository.findByKey(id);
                if (workSpace == null) break;
                for (CollaborationType type : types) {
                    ArrayList<WorkSpace> existingWorkspaces = type.getWorkSpaces();
                    if (existingWorkspaces != null && existingWorkspaces.stream().anyMatch(ws -> ws.getId().equals(workSpace.getId()))) continue;
                    if (existingWorkspaces == null) {
                        existingWorkspaces = new ArrayList<WorkSpace>();
                    }
                    existingWorkspaces.add(workSpace);
                    type.setWorkSpaces(existingWorkspaces);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid context: " + context);
            }
        }
        return this.collaborationTypeRepository.save((Iterable)types);
    }

    public List<CollaborationType> unlinkType(String id, Map payload) throws Exception {
        String context = (String)payload.get("context");
        List typesIds = (List)payload.get("types");
        List types = this.collaborationTypeRepository.findByIdIn(typesIds);
        switch (context) {
            case "session": {
                Session session = this.sessionRepository.findById(id);
                if (session == null) break;
                for (CollaborationType type : types) {
                    List existingSessions = type.getSessions();
                    if (existingSessions == null) continue;
                    existingSessions.removeIf(s -> s.getId().equals(session.getId()));
                    type.setSessions(existingSessions);
                }
                break;
            }
            case "solution": {
                SolutionBoard solutionBoard = this.solutionBoardRepository.findById(id);
                if (solutionBoard == null) break;
                for (CollaborationType type : types) {
                    List existingBoards = type.getSolutionBoards();
                    if (existingBoards == null) continue;
                    existingBoards.removeIf(sb -> sb.getId().equals(solutionBoard.getId()));
                    type.setSolutionBoards(existingBoards);
                }
                break;
            }
            case "workspace": {
                WorkSpace workSpace = this.workSpaceRepository.findByKey(id);
                if (workSpace == null) break;
                for (CollaborationType type : types) {
                    List existingWorkspaces = type.getWorkSpaces();
                    if (existingWorkspaces == null) continue;
                    existingWorkspaces.removeIf(ws -> ws.getId().equals(workSpace.getId()));
                    type.setWorkSpaces(existingWorkspaces);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid context: " + context);
            }
        }
        return this.collaborationTypeRepository.save((Iterable)types);
    }

    public List<CollaborationType> getTypesRelatedToContext(String id, Map payload) throws Exception {
        String context = (String)payload.get("context");
        String origin = (String)payload.get("origin");
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        criteriaList.add(Criteria.where((String)"tenant").is((Object)tenant));
        switch (context) {
            case "session": {
                if ("sessionBoard".equals(origin)) {
                    Session session = this.sessionRepository.findByActiveSessionBoard(id);
                    if (!PropertyValidator.isValid((Object)session)) break;
                    criteriaList.add(Criteria.where((String)"sessions").in(new Object[]{session.getId()}));
                    break;
                }
                criteriaList.add(Criteria.where((String)"sessions").in(new Object[]{id}));
                break;
            }
            case "solution": {
                criteriaList.add(Criteria.where((String)"solutionBoards").in(new Object[]{id}));
                break;
            }
            case "workspace": {
                WorkSpace matchedWorkspace = this.workSpaceRepository.findByKey(id);
                criteriaList.add(Criteria.where((String)"workSpaces").in(new Object[]{matchedWorkspace.getId()}));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid context: " + context);
            }
        }
        Criteria finalCriteria = new Criteria().andOperator(criteriaList.toArray(new Criteria[0]));
        Query query = new Query((CriteriaDefinition)finalCriteria);
        List types = this.mongoTemplate.find(query, CollaborationType.class);
        return types;
    }

    public CollaborationType createType(Map payload) throws Exception {
        String context = (String)payload.get("context");
        String origin = (String)payload.get("origin");
        String title = (String)payload.get("title");
        String id = (String)payload.get("id");
        CollaborationType type = new CollaborationType();
        type.setTitle(title);
        switch (context) {
            case "session": {
                Session session = "sessionBoard".equals(origin) ? this.sessionRepository.findByActiveSessionBoard(id) : this.sessionRepository.findById(id);
                if (!PropertyValidator.isValid((Object)session)) break;
                type.setSessions(Collections.singletonList(session));
                break;
            }
            case "solution": {
                SolutionBoard solutionBoard = this.solutionBoardRepository.findById(id);
                if (!PropertyValidator.isValid((Object)solutionBoard)) break;
                type.setSolutionBoards(Collections.singletonList(solutionBoard));
                break;
            }
            case "workspace": {
                WorkSpace workSpace = this.workSpaceRepository.findByKey(id);
                if (!PropertyValidator.isValid((Object)workSpace)) break;
                type.setWorkSpaces(Collections.singletonList(workSpace));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid context: " + context);
            }
        }
        return (CollaborationType)this.collaborationTypeRepository.save((Object)type);
    }

    public CollaborationType deleteTypeById(String id) throws Exception {
        Optional collaborationTypeOptional;
        if (PropertyValidator.isValid((Object)id) && (collaborationTypeOptional = this.collaborationTypeRepository.findById(id)).isPresent()) {
            CollaborationType collaborationType = (CollaborationType)collaborationTypeOptional.get();
            collaborationType.setRowStatus(1);
            return (CollaborationType)this.collaborationTypeRepository.save((Object)collaborationType);
        }
        return null;
    }

    public List<CollaborationType> getAllTypes() throws Exception {
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        return this.mongoTemplate.find(query, CollaborationType.class, "collaborationType");
    }
}

