/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.viztrend.safe.api.dto.BaseItemBulkItemsDTO;
import com.viztrend.safe.api.dto.BaseItemLinkDTO;
import com.viztrend.safe.enums.EnumBaseItemLinkTypes;
import com.viztrend.safe.enums.EnumBaseItemTypes;
import com.viztrend.safe.enums.EnumFieldTypes;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.exception.KendisException;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.FieldTemplate;
import com.viztrend.safe.persistence.entity.Fields;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemType;
import com.viztrend.safe.persistence.entity.ItemTypeScheme;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.TimeSeriesSyncStatus;
import com.viztrend.safe.persistence.entity.TimeSeriesSyncStatusRepository;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.WorkSpaceType;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.BacklogItemRepository;
import com.viztrend.safe.persistence.repository.BaseItemLinkRepository;
import com.viztrend.safe.persistence.repository.BaseItemRepository;
import com.viztrend.safe.persistence.repository.FieldTemplateRepository;
import com.viztrend.safe.persistence.repository.FieldsRepository;
import com.viztrend.safe.persistence.repository.ItemTypeRepository;
import com.viztrend.safe.persistence.repository.ItemTypeSchemeRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TimeSeriesRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceTypeRepository;
import com.viztrend.safe.service.AttachmentService;
import com.viztrend.safe.service.BatchService;
import com.viztrend.safe.service.CustomFieldService;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.TimeSeriesUtils;
import com.viztrend.safe.vos.Attachment;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class BatchServiceImpl
implements BatchService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchServiceImpl.class);
    @Autowired
    private WorkFlowRepository workFlowRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private BaseItemRepository baseItemRepository;
    @Autowired
    private BaseItemLinkRepository baseItemLinkRepository;
    @Autowired
    private BacklogItemRepository backlogItemRepository;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private FieldsRepository fieldsRepository;
    @Autowired
    private WorkSpaceTypeRepository workSpaceTypeRepository;
    @Autowired
    private ItemTypeRepository itemTypeRepository;
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private ItemTypeSchemeRepository itemTypeSchemeRepository;
    @Autowired
    private TimeSeriesRepository timeSeriesRepository;
    @Autowired
    private TimeSeriesSyncStatusRepository timeSeriesSyncStatusRepository;
    @Autowired
    private FieldTemplateRepository fieldTemplateRepository;

    public HashMap<String, Object> getAllBatches(String releaseTrainId, boolean isTreeView, boolean isListView, boolean isFields, boolean isObjectiveRelationView) {
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        try {
            List batchesListStructure;
            ArrayList<String> allBatchItemTypes;
            if (isTreeView) {
                List batchesTreeStructure = this.fetchBatchGroups(releaseTrainId);
                responseData.put("batches", batchesTreeStructure);
            }
            if (isListView && !isFields) {
                allBatchItemTypes = new ArrayList<String>();
                allBatchItemTypes.add(EnumBaseItemTypes.BATCH.getName());
                allBatchItemTypes.add(EnumBaseItemTypes.BATCH_GROUP.getName());
                batchesListStructure = this.loadBaseItemLinksBySessionIdAndTypes(allBatchItemTypes);
                responseData.put("batchesList", batchesListStructure);
            }
            if (isListView && isFields) {
                allBatchItemTypes = new ArrayList();
                allBatchItemTypes.add(EnumBaseItemTypes.BATCH.getName());
                allBatchItemTypes.add(EnumBaseItemTypes.BATCH_GROUP.getName());
                batchesListStructure = this.loadBaseItemLinksBySessionIdAndTypes(allBatchItemTypes);
                List fieldIds = this.getFieldIds(batchesListStructure);
                List fieldList = this.fieldsRepository.findByIdInAndTypeNot(fieldIds, EnumFieldTypes.SIMPLE_EDITOR.getFieldType());
                responseData.put("fieldList", fieldList);
                responseData.put("batchesList", batchesListStructure);
            }
            if (isObjectiveRelationView) {
                ArrayList<String> baseItemTypes = new ArrayList<String>();
                baseItemTypes.add(EnumBaseItemTypes.BATCH.getName());
                baseItemTypes.add(EnumBaseItemTypes.BATCH_GROUP.getName());
                List batchesList = this.getBatchListForObjectiveRelationView(baseItemTypes);
                responseData.put("batchesList", batchesList);
            }
            responseData.put("success", true);
        }
        catch (KendisException e) {
            responseData.put("success", true);
            throw e;
        }
        catch (Exception e) {
            responseData.put("success", true);
            throw new KendisException("Internal Server Error---" + e.getMessage());
        }
        return responseData;
    }

    public BaseItem updateBatchDates(String batchId, String startDate, String endDate) throws Exception {
        try {
            if (!PropertyValidator.isValid((Object)batchId)) {
                throw new KendisException("Invalid Batch Id");
            }
            if (!PropertyValidator.isValid((Object)startDate) && !PropertyValidator.isValid((Object)endDate)) {
                throw new KendisException("Invalid Dates");
            }
            BaseItem batch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)batchId));
            if (!PropertyValidator.isValid((Object)batch)) {
                throw new KendisException("Batch not found");
            }
            ArrayList<BaseItem> batchesListStructure = new ArrayList<BaseItem>();
            batchesListStructure.add(batch);
            List fieldIds = this.getFieldIds(batchesListStructure);
            List fieldList = this.fieldsRepository.findByIdInAndType(fieldIds, EnumFieldTypes.DATE_PICKER.getFieldType());
            if (fieldList != null) {
                if (batch.getFields() == null) {
                    batch.setFields(new HashMap());
                }
                this.addNewFieldIfNotPresentElseUpdateField(fieldList, EnumKendis.START_DATE.getCode(), EnumFieldTypes.DATE_PICKER.getFieldType(), batch, startDate);
                this.addNewFieldIfNotPresentElseUpdateField(fieldList, EnumKendis.END_DATE.getCode(), EnumFieldTypes.DATE_PICKER.getFieldType(), batch, endDate);
                this.baseItemRepository.save((Object)batch);
            }
            return batch;
        }
        catch (KendisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KendisException("Internal Server Error---" + e.getMessage());
        }
    }

    private void addNewFieldIfNotPresentElseUpdateField(List<Fields> batchFieldList, String fieldTitle, String fieldType, BaseItem batch, String value) {
        if (!PropertyValidator.isValid((Object)value)) {
            return;
        }
        String fieldId = null;
        for (Fields field : batchFieldList) {
            if (!fieldType.equals(field.getType()) || !fieldTitle.equals(field.getTitle())) continue;
            fieldId = field.getId();
        }
        if (fieldId != null) {
            if (PropertyValidator.isValid(fieldId)) {
                batch.getFields().put(fieldId, value);
            }
        } else {
            FieldTemplate fieldTemplate = this.fetchFieldTemplate(batch.getType());
            if (!PropertyValidator.isValid((Object)fieldTemplate)) {
                return;
            }
            String newFieldId = null;
            if (PropertyValidator.isValid((Collection)fieldTemplate.getConfiguredFields())) {
                for (Fields field : fieldTemplate.getConfiguredFields()) {
                    if (!fieldType.equals(field.getType()) || !fieldTitle.equals(field.getTitle())) continue;
                    newFieldId = field.getId();
                    break;
                }
            }
            if (PropertyValidator.isValid(newFieldId)) {
                batch.getFields().put(newFieldId, value);
            }
        }
    }

    private FieldTemplate fetchFieldTemplate(String type) {
        ItemType itemType = this.itemTypeRepository.findByTitle(type);
        if (!PropertyValidator.isValid((Object)itemType)) {
            return null;
        }
        ItemTypeScheme itemTypeScheme = this.itemTypeSchemeRepository.findByItemType(itemType);
        if (!PropertyValidator.isValid((Object)itemTypeScheme)) {
            return null;
        }
        return itemTypeScheme.getFieldsTemplate();
    }

    public HashMap<String, Object> getFieldsForBatch(String batchId) {
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        try {
            if (!PropertyValidator.isValid((Object)batchId)) {
                responseData.put("success", false);
                throw new KendisException("Invalid Batch Id");
            }
            BaseItem batch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)batchId));
            if (!PropertyValidator.isValid((Object)batch) || batch.isArchive()) {
                responseData.put("success", false);
                throw new KendisException("Batch not available");
            }
            ArrayList<BaseItem> batchesListStructure = new ArrayList<BaseItem>();
            batchesListStructure.add(batch);
            List fieldIds = this.getFieldIds(batchesListStructure);
            List fieldList = this.fieldsRepository.findByIdInAndTypeNot(fieldIds, EnumFieldTypes.SIMPLE_EDITOR.getFieldType());
            responseData.put("fieldList", fieldList);
            responseData.put("success", true);
        }
        catch (KendisException e) {
            responseData.put("success", false);
            throw e;
        }
        catch (Exception e) {
            responseData.put("success", false);
            throw new KendisException("Internal Server Error---" + e.getMessage());
        }
        return responseData;
    }

    private List<String> getFieldIds(List<BaseItem> batchesListStructure) throws Exception {
        ArrayList<String> fieldIds = new ArrayList<String>();
        for (BaseItem batch : batchesListStructure) {
            if (!PropertyValidator.isValid((Object)batch.getFields())) continue;
            Set keys = batch.getFields().keySet();
            fieldIds.addAll(keys);
        }
        return fieldIds;
    }

    public HashMap<String, Object> loadBatchId(String id) throws Exception {
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)id)) {
            responseData.put("success", false);
            throw new KendisException("Invalid Batch Id");
        }
        BaseItem batch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)id));
        this.populateImageIcon(batch);
        if (!PropertyValidator.isValid((Object)batch) || batch.isArchive()) {
            responseData.put("success", false);
            throw new KendisException("Batch not available");
        }
        responseData.put("objective", batch);
        return responseData;
    }

    public Map<String, Object> loadBatchByKey(String key) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            BaseItemLink link;
            LOGGER.debug("Fetching Batch for key -> " + key);
            BaseItem fetchedBatch = this.baseItemRepository.findByKey(key);
            if (!PropertyValidator.isValid((Object)fetchedBatch) || fetchedBatch.isArchive()) {
                responseJson.put("success", false);
                return responseJson;
            }
            this.populateImageIcon(fetchedBatch);
            if (PropertyValidator.isValid((Collection)fetchedBatch.getBaseItemLinks()) && PropertyValidator.isValid((Object)(link = (BaseItemLink)fetchedBatch.getBaseItemLinks().stream().filter(p -> p.getType().equalsIgnoreCase(fetchedBatch.getType())).findAny().orElse(null))) && !PropertyValidator.isValid((Object)link.getLayout())) {
                responseJson.put("defaultLayout", this.customFieldService.getDefaultLayoutFromItemType(fetchedBatch.getType()));
            }
            responseJson.put("fetchedBatch", fetchedBatch);
            responseJson.put("success", true);
            return responseJson;
        }
        catch (Exception e) {
            responseJson.put("success", false);
            throw new KendisException("Internal Server Error------" + e.getMessage());
        }
    }

    public Map<String, Object> loadBatchBreadCrumbs(String key) throws Exception {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        LOGGER.debug("Fetching Batch for key -> " + key);
        if (!PropertyValidator.isValid((Object)key)) {
            responseJson.put("success", false);
            throw new KendisException("Invalid Batch Key");
        }
        Map allBatchesMap = this.getAllBatchesBaseItemsMap();
        if (!PropertyValidator.isValid((Object)allBatchesMap)) {
            responseJson.put("success", false);
            return responseJson;
        }
        BaseItem fetchedBatch = this.fetchBaseItemByKey(key, allBatchesMap);
        if (!PropertyValidator.isValid((Object)fetchedBatch) || fetchedBatch.isArchive()) {
            responseJson.put("success", false);
            return responseJson;
        }
        ArrayList breadCrumbs = new ArrayList();
        this.generateBreadCrumbs(fetchedBatch, breadCrumbs, allBatchesMap);
        Collections.reverse(breadCrumbs);
        responseJson.put("breadCrumbs", breadCrumbs);
        responseJson.put("success", true);
        return responseJson;
    }

    private BaseItem fetchBaseItemByKey(String key, Map<String, BaseItem> allBatchesMap) throws Exception {
        BaseItem result = null;
        if (PropertyValidator.isValid(allBatchesMap)) {
            for (BaseItem item : allBatchesMap.values()) {
                if (!item.getKey().equals(key)) continue;
                result = item;
                break;
            }
        }
        return result;
    }

    private Map<String, BaseItem> getAllBatchesBaseItemsMap() throws Exception {
        HashMap<String, BaseItem> batchesBaseItemsMap = new HashMap<String, BaseItem>();
        LOGGER.debug("Fetching All Batches");
        ArrayList<String> types = new ArrayList<String>();
        types.add(EnumBaseItemTypes.BATCH.getName());
        types.add(EnumBaseItemTypes.BATCH_GROUP.getName());
        List allBatches = this.loadBaseItemLinksBySessionIdAndTypes(types);
        LOGGER.debug("Batches Fetched count" + allBatches.size());
        for (BaseItem obj : allBatches) {
            batchesBaseItemsMap.put(obj.getId(), obj);
        }
        return batchesBaseItemsMap;
    }

    private void generateBreadCrumbs(BaseItem fetchedBatch, List<String> breadCrumbs, Map<String, BaseItem> allBatchesMap) {
        if (!PropertyValidator.isValid((Object)fetchedBatch)) {
            return;
        }
        breadCrumbs.add(fetchedBatch.getKey());
        Optional<BaseItemLink> parentBaseItemLink = fetchedBatch.getBaseItemLinks().stream().filter(item -> Objects.equals(item.getLinkType(), "Parent-Batch")).findFirst();
        if (!parentBaseItemLink.isPresent()) {
            return;
        }
        String parentBaseItemId = parentBaseItemLink.get().getBaseItemId();
        BaseItem parentBaseItem = allBatchesMap.get(parentBaseItemId);
        this.generateBreadCrumbs(parentBaseItem, breadCrumbs, allBatchesMap);
    }

    private BaseItem fetchBatchDetails(BaseItem objective) {
        if (!PropertyValidator.isValid((Object)objective)) {
            return objective;
        }
        ArrayList<ObjectId> objectiveIds = new ArrayList<ObjectId>();
        this.fetchLinkedItems(objective);
        HashMap<String, BaseItem> batchMappedByGroup = new HashMap<String, BaseItem>();
        for (BaseItemLink link : objective.getBaseItemLinks()) {
            if (!PropertyValidator.isValid((Object)link.getBaseItemId()) || link.isArchive()) continue;
            batchMappedByGroup.put(link.getBaseItemId(), objective);
            objectiveIds.add(new ObjectId(link.getBaseItemId()));
        }
        List objectivesList = this.loadBatchesByBaseItemId(objectiveIds);
        HashMap keyResultMappedByBatch = new HashMap();
        ArrayList keyResultsIds = new ArrayList();
        objectivesList.forEach(obj -> {
            this.setBaseItemInParent((BaseItem)batchMappedByGroup.get(obj.getId()), obj);
            obj.getBaseItemLinks().forEach(link -> {
                if (PropertyValidator.isValid((Object)link) && PropertyValidator.isValid((Object)link.getBaseItemId())) {
                    keyResultsIds.add(new ObjectId(link.getBaseItemId()));
                    keyResultMappedByBatch.put(link.getBaseItemId(), obj);
                }
            });
        });
        List keyResultsList = this.loadBatchesByBaseItemId(keyResultsIds);
        keyResultsList.forEach(keyResult -> {
            if (keyResult.getBaseItemLinks().size() > 0 && !((BaseItemLink)keyResult.getBaseItemLinks().get(0)).isArchive()) {
                this.setBaseItemInParent((BaseItem)keyResultMappedByBatch.get(keyResult.getId()), keyResult);
            }
        });
        List objectiveBaseItemLinks = this.findByBaseItemId(objective.getId());
        List selectedLinkedGroups = this.baseItemRepository.findByBaseItemLinksIn(objectiveBaseItemLinks);
        objective.setSelectedLinkedGroups(selectedLinkedGroups);
        this.populateImageIcon(objective);
        return objective;
    }

    public List<BaseItemLink> findByBaseItemId(String objectiveId) {
        ArrayList<BaseItemLink> baseItemLinks = new ArrayList();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"baseItemId").is((Object)objectiveId));
        baseItemLinks = this.mongoTemplate.find(query, BaseItemLink.class);
        return baseItemLinks;
    }

    private List<BaseItem> fetchBatchGroups(String releaseTrainId) {
        List<BaseItem> batchesGroupsBaseItems = new ArrayList();
        List baseItemLinksTypeBatchGroups = PropertyValidator.isValid((Object)releaseTrainId) ? this.loadBaseItemLinksByReleasaeTrainIdAndType(releaseTrainId) : this.loadBaseItemLinksBySessionIdAndType("batch_group");
        List baseItemLinksTypeBatches = this.loadBaseItemLinksBySessionIdAndType("Batch");
        List batchesBaseItems = this.baseItemRepository.findByBaseItemLinksInOrderBySequenceAsc(baseItemLinksTypeBatches);
        batchesGroupsBaseItems = this.baseItemRepository.findByBaseItemLinksInOrderBySequenceAsc(baseItemLinksTypeBatchGroups);
        HashMap<String, BaseItem> batchesMap = new HashMap<String, BaseItem>();
        for (BaseItem baseItem : batchesBaseItems) {
            batchesMap.put(baseItem.getId(), baseItem);
        }
        for (BaseItem batchGroup : batchesGroupsBaseItems) {
            batchesMap.put(batchGroup.getId(), batchGroup);
        }
        if (PropertyValidator.isValid(batchesGroupsBaseItems)) {
            for (BaseItem batchGroup : batchesGroupsBaseItems) {
                this.populateImageIcon(batchGroup);
                if (batchGroup.isArchive()) continue;
                this.createBaseItemList(batchGroup, batchesMap);
            }
        }
        return batchesGroupsBaseItems;
    }

    private void populateImageIcon(BaseItem batchGroup) {
        if ("batch_group".equals(batchGroup.getType()) && PropertyValidator.isValid((Object)batchGroup.getImageIcon())) {
            ArrayList<Attachment> attachments = new ArrayList<Attachment>();
            attachments.add(batchGroup.getImageIcon());
            batchGroup.setImageIcon((Attachment)this.attachmentService.fetchAttachmentData(attachments).get(0));
        }
    }

    private void createBaseItemList(BaseItem baseItem, HashMap<String, BaseItem> batchesMap) {
        if (!PropertyValidator.isValid((Collection)baseItem.getBaseItemLinks())) {
            return;
        }
        for (BaseItemLink childLink : baseItem.getBaseItemLinks()) {
            if (!PropertyValidator.isValid((Object)childLink) || !PropertyValidator.isValid((Object)childLink.getBaseItemId()) || !EnumBaseItemLinkTypes.BATCH_TO_BATCH_CHILD.getLinkType().equals(childLink.getLinkType()) || childLink.isArchive()) continue;
            if (batchesMap.get(childLink.getBaseItemId()) != null) {
                this.createBaseItemList(batchesMap.get(childLink.getBaseItemId()), batchesMap);
            }
            if (baseItem.getBaseItemList() == null) {
                baseItem.setBaseItemList(new ArrayList());
            }
            if (batchesMap.get(childLink.getBaseItemId()) == null || baseItem.getBaseItemList().contains(batchesMap.get(childLink.getBaseItemId()))) continue;
            baseItem.getBaseItemList().add(batchesMap.get(childLink.getBaseItemId()));
        }
    }

    public HashMap<String, Object> deleteBatchById(HashMap<String, String> requestBody) throws Exception {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)requestBody.get("objId"))) {
            throw new KendisException(HttpStatus.BAD_REQUEST.toString(), "Invalid batch id");
        }
        BaseItem batch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)requestBody.get("objId")));
        if (!PropertyValidator.isValid((Object)batch)) {
            throw new KendisException(HttpStatus.INTERNAL_SERVER_ERROR.toString(), "Batch not found");
        }
        this.removeParentChildRelationsForBatch(batch.getId());
        ArrayList<BaseItemLink> groupLinks = new ArrayList<BaseItemLink>();
        for (BaseItemLink link : batch.getBaseItemLinks()) {
            if (PropertyValidator.isValid((Object)link.getType()) && ("batch_group".equals(link.getType()) || "release_train_batch".equals(link.getType())) || "Batch".equals(link.getType())) {
                link.setArchive(true);
                groupLinks.add(link);
            }
            this.baseItemLinkRepository.save(groupLinks);
            dataMap.put("deletedItem", batch);
        }
        this.removeLinkedBackLogItems(batch);
        batch.setArchive(true);
        this.baseItemRepository.save((Object)batch);
        return dataMap;
    }

    private void removeParentChildRelationsForBatch(String batchId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"baseItemId").is((Object)batchId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"linkType").in(Arrays.asList(EnumBaseItemLinkTypes.BATCH_TO_BATCH_CHILD.getLinkType(), EnumBaseItemLinkTypes.BATCH_TO_BATCH_PARENT.getLinkType())));
        List links = this.mongoTemplate.find(query, BaseItemLink.class);
        List batchesWithLinks = this.baseItemRepository.findByBaseItemLinksIn(links);
        for (BaseItem batch : batchesWithLinks) {
            List batchLinks = batch.getBaseItemLinks();
            batchLinks.removeAll(links);
            batch.setBaseItemLinks(batchLinks);
        }
        this.baseItemRepository.save((Iterable)batchesWithLinks);
        if (PropertyValidator.isValid((Collection)links)) {
            for (BaseItemLink link : links) {
                link.setArchive(true);
            }
            this.baseItemLinkRepository.save((Iterable)links);
        }
    }

    private void removeLinkedBackLogItems(BaseItem baseItem) {
        ArrayList<BaseItemLink> linksToArchive = new ArrayList<BaseItemLink>();
        if (PropertyValidator.isValid((Collection)baseItem.getBaseItemLinks())) {
            for (BaseItemLink link : baseItem.getBaseItemLinks()) {
                if (!PropertyValidator.isValid((Object)link.getLinkType()) || !"backLogItem".equals(link.getLinkType()) || link.isArchive()) continue;
                link.setArchive(true);
                linksToArchive.add(link);
            }
        }
        ArrayList<String> baseItemIds = new ArrayList<String>();
        for (BaseItemLink link : linksToArchive) {
            baseItemIds.add(link.getBaseItemId());
        }
        this.removeBatchRelationsFromBacklogItems(baseItemIds, baseItem.getId());
        this.baseItemLinkRepository.save(linksToArchive);
    }

    private void removeBatchRelationsFromBacklogItems(List<String> linksToArchive, String baseItemid) {
        if (PropertyValidator.isValid(linksToArchive)) {
            List backlogItems = this.backlogItemRepository.findByIdIn(linksToArchive);
            for (BacklogItem backlogItem : backlogItems) {
                if (!PropertyValidator.isValid((Collection)backlogItem.getBatchRelations())) continue;
                List links = backlogItem.getBatchRelations();
                for (BaseItemLink link : backlogItem.getBatchRelations()) {
                    if (!PropertyValidator.isValid((Object)link.getBaseItemId()) || !link.getBaseItemId().equals(baseItemid)) continue;
                    links.remove(link);
                    break;
                }
                backlogItem.setBatchRelations(links);
            }
            this.backlogItemRepository.save((Iterable)backlogItems);
        }
    }

    private List<BaseItem> loadBatchesByBaseItemId(List<ObjectId> baseItemIds) {
        Query query = new Query();
        Sort sort = new Sort(Sort.Direction.ASC, new String[]{"sequence"});
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(baseItemIds)).with(sort);
        return this.mongoTemplate.find(query, BaseItem.class);
    }

    private List<BaseItemLink> loadBaseItemLinksByType(String type) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        return this.mongoTemplate.find(query, BaseItemLink.class);
    }

    private void setBaseItemInParent(BaseItem parent, BaseItem keyResult) {
        List baseItemList = parent.getBaseItemList();
        if (PropertyValidator.isValid((Collection)baseItemList) && baseItemList.size() > 0) {
            baseItemList.add(keyResult);
        } else {
            ArrayList<BaseItem> keyResults = new ArrayList<BaseItem>();
            keyResults.add(keyResult);
            parent.setBaseItemList(keyResults);
        }
        this.fetchLinkedItems(keyResult);
    }

    public HashMap<String, Object> linkBackLogItemToBatch(List<BaseItemLink> baseItemLinks, String batchId) throws Exception {
        BaseItem savedBatch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)batchId));
        if (!PropertyValidator.isValid((Object)savedBatch)) {
            throw new KendisException("Batch not found");
        }
        List savedItemLinks = savedBatch.getBaseItemLinks();
        List<BaseItemLink> newItemLinks = new ArrayList();
        ArrayList<Object> updatedBaseItemLinks = new ArrayList<Object>();
        for (BaseItemLink baseItemLink : baseItemLinks) {
            if (PropertyValidator.isValid((Object)baseItemLink.getId()) || !savedItemLinks.stream().noneMatch(link -> PropertyValidator.isValid((Object)link.getBaseItemId()) && PropertyValidator.isValid((Object)link.getReleaseTrainId()) && PropertyValidator.isValid((Object)baseItemLink.getBaseItemId()) && PropertyValidator.isValid((Object)baseItemLink.getReleaseTrainId()) && link.getBaseItemId().equals(baseItemLink.getBaseItemId()) && link.getReleaseTrainId().equals(baseItemLink.getReleaseTrainId()))) continue;
            baseItemLink.setLinkType(EnumKendis.BACKLOG_ITEM.getCode());
            newItemLinks.add((BaseItemLink)baseItemLink.clone());
        }
        for (BaseItemLink baseItemLink : savedItemLinks) {
            updatedBaseItemLinks.add(baseItemLink);
        }
        if (PropertyValidator.isValid(newItemLinks)) {
            newItemLinks = this.baseItemLinkRepository.save(newItemLinks);
        }
        updatedBaseItemLinks.addAll(newItemLinks);
        savedBatch.setBaseItemLinks(updatedBaseItemLinks);
        savedBatch = (BaseItem)this.baseItemRepository.save((Object)savedBatch);
        List newAttachedItemList = new ArrayList();
        if (PropertyValidator.isValid(newItemLinks)) {
            newAttachedItemList = this.backlogItemRepository.findByIdIn((Collection)newItemLinks.stream().map(link -> link.getBaseItemId()).collect(Collectors.toList()));
            for (BacklogItem newAttachedItem : newAttachedItemList) {
                if (EnumBaseItemTypes.BATCH_GROUP.getName().equals(savedBatch.getItemType().getTitle()) || EnumBaseItemTypes.BATCH.getName().equals(savedBatch.getItemType().getTitle())) {
                    if (!PropertyValidator.isValid((Collection)newAttachedItem.getBatchRelations())) {
                        newAttachedItem.setBatchRelations(new ArrayList());
                    }
                    newAttachedItem.linkToBatch(null, savedBatch.getId());
                    continue;
                }
                if (EnumKendis.OBJECTIVE.getCode().equals(savedBatch.getItemType().getTitle())) {
                    if (!PropertyValidator.isValid((Collection)newAttachedItem.getObjectiveRelations())) {
                        newAttachedItem.setObjectiveRelations(new ArrayList());
                    }
                    newAttachedItem.linkToObjectives(null, savedBatch.getId());
                    continue;
                }
                if (!EnumKendis.OBJECTIVE_KEY_RESULT.getCode().equals(savedBatch.getType())) continue;
                if (!PropertyValidator.isValid((Collection)newAttachedItem.getKeyResultRelations())) {
                    newAttachedItem.setKeyResultRelations(new ArrayList());
                }
                newAttachedItem.linkToKeyResults(null, savedBatch.getId());
            }
        }
        if (PropertyValidator.isValid(newAttachedItemList)) {
            this.backlogItemRepository.save(newAttachedItemList);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("savedBatch", savedBatch);
        hashMap.put("updatedBacklogItems", newAttachedItemList);
        return hashMap;
    }

    public void moveItemLinks(Map<String, List<BaseItemLink>> selectedItemsMap, List<String> selectedBatchesIds, HashMap<String, Object> response) throws Exception {
        ArrayList<String> failedBatches = new ArrayList<String>();
        boolean isfailedLinking = false;
        for (Map.Entry<String, List<BaseItemLink>> entry : selectedItemsMap.entrySet()) {
            List<BaseItemLink> links = entry.getValue();
            for (String batchId : selectedBatchesIds) {
                try {
                    this.linkBackLogItemToBatch(links, batchId);
                }
                catch (Exception e) {
                    LOGGER.error("error occured while linking items with batch-id : " + batchId, (Throwable)e);
                    failedBatches.add(batchId);
                    isfailedLinking = true;
                }
            }
        }
        response.put("failedBatches", failedBatches);
        if (!isfailedLinking) {
            for (Map.Entry<String, List<BaseItemLink>> entry : selectedItemsMap.entrySet()) {
                String batchId = entry.getKey();
                List<BaseItemLink> links = entry.getValue();
                for (BaseItemLink link : links) {
                    String backlogItemId = link.getBaseItemId();
                    try {
                        this.unlinkBackLogItemFromBatch(backlogItemId, batchId);
                    }
                    catch (Exception e) {
                        LOGGER.error("error occurred while linking items with batch-id : " + batchId, (Throwable)e);
                    }
                }
            }
        }
    }

    public void updateLinkedBatchSequence(String linkedBatchId, String batchId, String sequence) throws Exception {
        if (!(PropertyValidator.isValid((Object)linkedBatchId) && PropertyValidator.isValid((Object)batchId) && PropertyValidator.isValid((Object)sequence))) {
            throw new KendisException("Invalid Arguments");
        }
        BaseItem batch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)batchId));
        if (!PropertyValidator.isValid((Object)batch)) {
            throw new KendisException("Batch not found");
        }
        for (BaseItemLink baseItemLink : batch.getBaseItemLinks()) {
            if (!PropertyValidator.isValid((Object)baseItemLink.getBaseItemId()) || !baseItemLink.getBaseItemId().equals(linkedBatchId) || !PropertyValidator.isValid((Object)baseItemLink.getLinkType()) || !EnumBaseItemLinkTypes.BATCH_TO_BATCH_CHILD.getLinkType().equals(baseItemLink.getLinkType())) continue;
            baseItemLink.setSequence(Double.valueOf(Double.parseDouble(sequence)));
            this.baseItemLinkRepository.save((Object)baseItemLink);
            break;
        }
    }

    public void updateBatchSequence(String batchId, String sequence) throws Exception {
        if (!PropertyValidator.isValid((Object)batchId) || !PropertyValidator.isValid((Object)sequence)) {
            throw new KendisException("Invalid Arguments");
        }
        BaseItem batch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)batchId));
        if (!PropertyValidator.isValid((Object)batch)) {
            throw new KendisException("Batch not found");
        }
        batch.setSequence(Double.valueOf(Double.parseDouble(sequence)));
        this.baseItemRepository.save((Object)batch);
    }

    public void unlinkBackLogItemFromBatch(String backlogItemId, String batchId) throws Exception {
        if (!PropertyValidator.isValid((Object)backlogItemId) || !PropertyValidator.isValid((Object)batchId)) {
            throw new KendisException("Invalid Arguments");
        }
        ArrayList<BaseItemLink> baseItemLinksToUpdate = new ArrayList<BaseItemLink>();
        BaseItem batch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)batchId));
        if (!PropertyValidator.isValid((Object)batch)) {
            throw new KendisException("Batch not found");
        }
        BacklogItem backlogItem = (BacklogItem)this.backlogItemRepository.findOne((Serializable)((Object)backlogItemId));
        if (!PropertyValidator.isValid((Object)backlogItem)) {
            throw new KendisException("Backlog item not found");
        }
        List baseItemLinks = batch.getBaseItemLinks();
        if (PropertyValidator.isValid((Collection)baseItemLinks)) {
            for (BaseItemLink baseItemLink : baseItemLinks) {
                if (!"backLogItem".equals(baseItemLink.getLinkType()) || !Objects.equals(baseItemLink.getBaseItemId(), backlogItemId)) continue;
                baseItemLink.setArchive(true);
                baseItemLinksToUpdate.add(baseItemLink);
            }
            baseItemLinks.removeAll(baseItemLinksToUpdate);
            batch.setBaseItemLinks(baseItemLinks);
            this.baseItemLinkRepository.save(baseItemLinksToUpdate);
            this.baseItemRepository.save((Object)batch);
        }
        List batchRelations = new ArrayList();
        if (EnumBaseItemTypes.BATCH_GROUP.getName().equals(batch.getItemType().getTitle()) || EnumBaseItemTypes.BATCH.getName().equals(batch.getItemType().getTitle())) {
            batchRelations = backlogItem.getBatchRelations();
        } else if (EnumKendis.OBJECTIVE.getCode().equals(batch.getItemType().getTitle())) {
            batchRelations = backlogItem.getObjectiveRelations();
        } else if (EnumKendis.OBJECTIVE_KEY_RESULT.getCode().equals(batch.getType())) {
            batchRelations = backlogItem.getKeyResultRelations();
        }
        if (PropertyValidator.isValid(batchRelations)) {
            for (BaseItemLink baseItemLink : batchRelations) {
                if (!batchId.equals(baseItemLink.getBaseItemId()) || baseItemLink.isArchive()) continue;
                batchRelations.remove(baseItemLink);
                this.backlogItemRepository.save((Object)backlogItem);
                break;
            }
        }
    }

    public void updateLinkSequence(String backlogItemId, String batchId, String sequence) throws Exception {
        if (!(PropertyValidator.isValid((Object)backlogItemId) && PropertyValidator.isValid((Object)batchId) && PropertyValidator.isValid((Object)sequence))) {
            throw new KendisException("Invalid Arguments");
        }
        BaseItem batch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)batchId));
        if (!PropertyValidator.isValid((Object)batch)) {
            throw new KendisException("Batch not found");
        }
        for (BaseItemLink baseItemLink : batch.getBaseItemLinks()) {
            if (!PropertyValidator.isValid((Object)baseItemLink.getBaseItemId()) || !baseItemLink.getBaseItemId().equals(backlogItemId) || !PropertyValidator.isValid((Object)baseItemLink.getLinkType()) || !"backLogItem".equals(baseItemLink.getLinkType())) continue;
            baseItemLink.setSequence(Double.valueOf(Double.parseDouble(sequence)));
            this.baseItemLinkRepository.save((Object)baseItemLink);
            break;
        }
    }

    public HashMap<String, Object> saveRelationships(Map<String, Object> request) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String linkingType = (String)request.get("linkingType");
        String batchId = (String)request.get("batchId");
        if (!PropertyValidator.isValid((Object)linkingType) || !PropertyValidator.isValid((Object)batchId)) {
            throw new KendisException("Mandatory fields missing");
        }
        if ("batch".equals(linkingType)) {
            ArrayList linkedBatchIds = (ArrayList)request.get("linkedBatchIds");
            String linkedBatchType = (String)request.get("linkedBatchType");
            Map batchesListStructureMap = this.getCurrentCompanyBatches();
            for (String linkedBatchId : linkedBatchIds) {
                response.put(linkedBatchId, this.createBatchRelation(linkedBatchId, linkedBatchType, batchId, batchesListStructureMap));
            }
        } else if ("art".equals(linkingType)) {
            String artId = (String)request.get("releaseTrainId");
            this.linkBatchArt(batchId, artId);
        }
        return response;
    }

    private Map<String, BaseItem> getCurrentCompanyBatches() {
        HashMap<String, BaseItem> batchesListStructureMap = new HashMap<String, BaseItem>();
        ArrayList<String> allBatchItemTypes = new ArrayList<String>();
        allBatchItemTypes.add(EnumBaseItemTypes.BATCH.getName());
        allBatchItemTypes.add(EnumBaseItemTypes.BATCH_GROUP.getName());
        List batchesListStructure = this.loadBaseItemLinksBySessionIdAndTypes(allBatchItemTypes);
        for (BaseItem baseItem : batchesListStructure) {
            batchesListStructureMap.put(baseItem.getId(), baseItem);
        }
        return batchesListStructureMap;
    }

    private void linkBatchArt(String batchId, String artId) {
        if (!PropertyValidator.isValid((Object)batchId) || !PropertyValidator.isValid((Object)artId)) {
            throw new KendisException("Invalid Arguments");
        }
        BaseItem batch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)batchId));
        if (!PropertyValidator.isValid((Object)batch)) {
            throw new KendisException("Batch not found");
        }
        boolean doesLinkExists = false;
        List baseItemLinks = batch.getBaseItemLinks();
        if (PropertyValidator.isValid((Collection)baseItemLinks)) {
            for (BaseItemLink baseItemLink : baseItemLinks) {
                if (!"release_train_batch".equals(baseItemLink.getType()) || !artId.equals(baseItemLink.getReleaseTrainId()) || baseItemLink.isArchive()) continue;
                doesLinkExists = true;
            }
        }
        if (!doesLinkExists) {
            BaseItemLink baseItemLink = new BaseItemLink(artId, "release_train_batch");
            this.baseItemLinkRepository.save((Object)baseItemLink);
            batch.getBaseItemLinks().add(baseItemLink);
            this.baseItemRepository.save((Object)batch);
        }
    }

    public List<SessionBoard> fetchMinimalSessionBoardsBySessionBoardIds(List<String> activeSessionBoardIds) {
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        ArrayList<BasicDBObject> pipelines = new ArrayList<BasicDBObject>();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (!PropertyValidator.isValid((Object)secureUser)) {
            throw new KendisException("Invalid User");
        }
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        if (!PropertyValidator.isValid((Object)tenant)) {
            throw new KendisException("Invalid Tenant");
        }
        ArrayList<ObjectId> objectIdList = new ArrayList<ObjectId>();
        for (String id : activeSessionBoardIds) {
            objectIdList.add(new ObjectId(id));
        }
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("$in", objectIdList)).append("tenant", (Object)tenant).append("archive", (Object)false));
        pipelines.add(matchStage);
        BasicDBObject lookupStage = new BasicDBObject("$lookup", (Object)new BasicDBObject().append("from", (Object)"session").append("localField", (Object)"session.$id").append("foreignField", (Object)"_id").append("as", (Object)"session"));
        pipelines.add(lookupStage);
        BasicDBObject unwindSession = new BasicDBObject("$unwind", (Object)new BasicDBObject("path", (Object)"$session").append("preserveNullAndEmptyArrays", (Object)true));
        pipelines.add(unwindSession);
        BasicDBObject matchNonArchivedSession = new BasicDBObject("$match", (Object)new BasicDBObject("session.archive", (Object)false).append("tenant", (Object)tenant));
        pipelines.add(matchNonArchivedSession);
        BasicDBObject lookupTeams = new BasicDBObject("$lookup", (Object)new BasicDBObject().append("from", (Object)"team").append("localField", (Object)"teams.$id").append("foreignField", (Object)"_id").append("as", (Object)"teams"));
        pipelines.add(lookupTeams);
        BasicDBObject matchNonArchivedTeams = new BasicDBObject("$match", (Object)new BasicDBObject("teams.archive", (Object)false).append("tenant", (Object)tenant));
        pipelines.add(matchNonArchivedTeams);
        BasicDBObject lookupContainers = new BasicDBObject("$lookup", (Object)new BasicDBObject().append("from", (Object)"container").append("localField", (Object)"containers.$id").append("foreignField", (Object)"_id").append("as", (Object)"containers"));
        pipelines.add(lookupContainers);
        BasicDBObject matchNonArchivedContainers = new BasicDBObject("$match", (Object)new BasicDBObject("containers.archive", (Object)false).append("tenant", (Object)tenant));
        pipelines.add(matchNonArchivedContainers);
        BasicDBObject projectStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("containers._id", (Object)1).append("containers.title", (Object)1).append("containers.label", (Object)1).append("teams._id", (Object)1).append("teams.title", (Object)1).append("teams.color", (Object)1).append("teams.label", (Object)1).append("session._id", (Object)1).append("session.title", (Object)1).append("session.prefix", (Object)1).append("session.prefixColor", (Object)1).append("session.activeSessionBoard", (Object)1));
        pipelines.add(projectStage);
        DBCollection collection = this.mongoTemplate.getCollection("sessionBoard");
        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.FALSE).build();
        try (Cursor dbCursor = collection.aggregate(pipelines, ao);){
            while (dbCursor.hasNext()) {
                DBObject item = (DBObject)dbCursor.next();
                SessionBoard sessionBoard = (SessionBoard)this.mongoTemplate.getConverter().read(SessionBoard.class, (Object)item);
                sessionBoards.add(sessionBoard);
            }
        }
        return sessionBoards;
    }

    private HashMap<String, Object> createBatchRelation(String linkedBatchId, String linkedBatchType, String batchId, Map<String, BaseItem> batchesListStructureMap) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            BaseItemLink baseItemLinkInParent;
            if (!PropertyValidator.isValid((Object)linkedBatchId) || !PropertyValidator.isValid((Object)linkedBatchType)) {
                response.put("success", false);
                response.put("message", "Invalid Arguments");
                return response;
            }
            if (this.checkCircularRelationExists(linkedBatchId, batchId, batchesListStructureMap)) {
                response.put("success", false);
                response.put("message", "Cannot be Added as a Parent, Batch already exists in the Branch");
                return response;
            }
            BaseItem batch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)batchId));
            if (!PropertyValidator.isValid((Object)batch)) {
                response.put("success", false);
                response.put("message", "Batch not found");
                return response;
            }
            for (BaseItemLink baseItemLink : batch.getBaseItemLinks()) {
                if (!PropertyValidator.isValid((Object)baseItemLink.getBaseItemId()) || !baseItemLink.getBaseItemId().equals(linkedBatchId) || baseItemLink.isArchive()) continue;
                response.put("success", false);
                response.put("message", "Batch already linked");
                return response;
            }
            BaseItem linkedBatch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)linkedBatchId));
            if ("child".equals(linkedBatchType)) {
                baseItemLinkInParent = new BaseItemLink();
                baseItemLinkInParent.setBaseItemId(linkedBatchId);
                baseItemLinkInParent.setLinkType(EnumBaseItemLinkTypes.BATCH_TO_BATCH_CHILD.getLinkType());
                BaseItemLink baseItemLinkInChild = new BaseItemLink();
                baseItemLinkInChild.setBaseItemId(batchId);
                baseItemLinkInChild.setLinkType(EnumBaseItemLinkTypes.BATCH_TO_BATCH_PARENT.getLinkType());
                baseItemLinkInParent = (BaseItemLink)this.baseItemLinkRepository.save((Object)baseItemLinkInParent);
                baseItemLinkInChild = (BaseItemLink)this.baseItemLinkRepository.save((Object)baseItemLinkInChild);
                batch.getBaseItemLinks().add(baseItemLinkInParent);
                linkedBatch.getBaseItemLinks().add(baseItemLinkInChild);
            } else if ("parent".equals(linkedBatchType)) {
                baseItemLinkInParent = new BaseItemLink();
                baseItemLinkInParent.setBaseItemId(linkedBatchId);
                baseItemLinkInParent.setLinkType(EnumBaseItemLinkTypes.BATCH_TO_BATCH_PARENT.getLinkType());
                BaseItemLink baseItemLinkInChild = new BaseItemLink();
                baseItemLinkInChild.setBaseItemId(batchId);
                baseItemLinkInChild.setLinkType(EnumBaseItemLinkTypes.BATCH_TO_BATCH_CHILD.getLinkType());
                baseItemLinkInParent = (BaseItemLink)this.baseItemLinkRepository.save((Object)baseItemLinkInParent);
                baseItemLinkInChild = (BaseItemLink)this.baseItemLinkRepository.save((Object)baseItemLinkInChild);
                batch.getBaseItemLinks().add(baseItemLinkInParent);
                linkedBatch.getBaseItemLinks().add(baseItemLinkInChild);
            }
            ArrayList<BaseItem> baseItems = new ArrayList<BaseItem>();
            baseItems.add(batch);
            baseItems.add(linkedBatch);
            this.baseItemRepository.save(baseItems);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            response.put("success", false);
            response.put("message", "Internal Server Error");
            return response;
        }
        response.put("success", true);
        response.put("message", "Batch linked successfully");
        return response;
    }

    private boolean checkCircularRelationExists(String linkedBatchId, String batchId, Map<String, BaseItem> batchesListStructureMap) throws Exception {
        if (!PropertyValidator.isValid((Object)linkedBatchId) || !PropertyValidator.isValid((Object)batchId)) {
            throw new KendisException("Mandatory fields missing to link batches");
        }
        BaseItem batch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)linkedBatchId));
        if (!PropertyValidator.isValid((Object)batch)) {
            throw new KendisException("Batch not found");
        }
        List batchListIdsTree1 = this.getAllNodesOfTreeDfs(batchesListStructureMap, batchesListStructureMap.get(batchId), new HashSet(), new ArrayList());
        List batchListIdsTree2 = new ArrayList();
        batchListIdsTree2 = this.getParentBatchNodes(batchesListStructureMap, batchesListStructureMap.get(linkedBatchId), new ArrayList());
        for (String id : batchListIdsTree1) {
            if (!batchListIdsTree2.contains(id)) continue;
            return true;
        }
        return false;
    }

    private List<String> getParentBatchNodes(Map<String, BaseItem> batchesListStructure, BaseItem node, List<String> ids) {
        if (ids.contains(node.getId())) {
            return ids;
        }
        ids.add(node.getId());
        for (BaseItemLink baseItemLink : node.getBaseItemLinks()) {
            BaseItem batch;
            if (!PropertyValidator.isValid((Object)baseItemLink.getLinkType()) || !baseItemLink.getLinkType().equals(EnumBaseItemLinkTypes.BATCH_TO_BATCH_PARENT.getLinkType()) || baseItemLink.isArchive() || !PropertyValidator.isValid((Object)(batch = batchesListStructure.get(baseItemLink.getBaseItemId())))) continue;
            this.getParentBatchNodes(batchesListStructure, batch, ids);
        }
        return ids;
    }

    private List<String> getAllNodesOfTreeDfs(Map<String, BaseItem> batchesListStructure, BaseItem node, Set<BaseItem> visit, List<String> batchListIds) throws Exception {
        if (visit.contains(node)) {
            return batchListIds;
        }
        visit.add(node);
        batchListIds.add((String)node.getId());
        for (BaseItemLink baseItemLink : node.getBaseItemLinks()) {
            if (!PropertyValidator.isValid((Object)baseItemLink.getLinkType()) || !baseItemLink.getLinkType().equals(EnumBaseItemLinkTypes.BATCH_TO_BATCH_CHILD.getLinkType()) || baseItemLink.isArchive()) continue;
            BaseItem batch = batchesListStructure.get(baseItemLink.getBaseItemId());
            batchListIds = this.getAllNodesOfTreeDfs(batchesListStructure, batch, visit, batchListIds);
        }
        return batchListIds;
    }

    public void modifyBatchType(String batchId) throws Exception {
        BaseItem batch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)batchId));
        List baseItemLinks = batch.getBaseItemLinks();
        if (PropertyValidator.isValid((Collection)baseItemLinks)) {
            for (BaseItemLink baseItemLink : baseItemLinks) {
                if (!EnumBaseItemLinkTypes.BATCH_TO_BATCH_PARENT.getLinkType().equals(baseItemLink.getLinkType()) || baseItemLink.isArchive()) continue;
                if (EnumBaseItemTypes.BATCH_GROUP.getName().equals(batch.getType())) {
                    batch.setType(EnumBaseItemTypes.BATCH.getName());
                    ItemType itemType = this.itemTypeRepository.findByTitle(EnumBaseItemTypes.BATCH.getName());
                    batch.setItemType(itemType);
                    this.baseItemRepository.save((Object)batch);
                    for (BaseItemLink link : batch.getBaseItemLinks()) {
                        if (!PropertyValidator.isValid((Object)link.getType()) || !EnumBaseItemTypes.BATCH_GROUP.getName().equals(link.getType())) continue;
                        link.setType(EnumBaseItemTypes.BATCH.getName());
                        this.baseItemLinkRepository.save((Object)link);
                    }
                }
                return;
            }
        }
        if (EnumBaseItemTypes.BATCH.getName().equals(batch.getType())) {
            batch.setType(EnumBaseItemTypes.BATCH_GROUP.getName());
            ItemType itemType = this.itemTypeRepository.findByTitle(EnumBaseItemTypes.BATCH_GROUP.getName());
            batch.setItemType(itemType);
            this.baseItemRepository.save((Object)batch);
            for (BaseItemLink link : batch.getBaseItemLinks()) {
                if (!PropertyValidator.isValid((Object)link.getType()) || !EnumBaseItemTypes.BATCH.getName().equals(link.getType())) continue;
                link.setType(EnumBaseItemTypes.BATCH_GROUP.getName());
                this.baseItemLinkRepository.save((Object)link);
            }
        }
    }

    public HashMap<String, Object> loadBatchRelationDetails(String objId) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashMap workSpaceMap = new HashMap();
        BaseItem batch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)objId));
        if (PropertyValidator.isValid((Object)batch)) {
            ArrayList<String> artKeys = new ArrayList<String>();
            ArrayList<String> linkedChildBatchesIds = new ArrayList<String>();
            ArrayList<String> linkedParentBatchesIds = new ArrayList<String>();
            for (BaseItemLink link : batch.getBaseItemLinks()) {
                if (EnumBaseItemLinkTypes.BATCH_TO_BATCH_PARENT.getLinkType().equals(link.getLinkType()) && !link.isArchive()) {
                    linkedParentBatchesIds.add(link.getBaseItemId());
                }
                if (EnumBaseItemLinkTypes.BATCH_TO_BATCH_CHILD.getLinkType().equals(link.getLinkType()) && !link.isArchive()) {
                    linkedChildBatchesIds.add(link.getBaseItemId());
                }
                if (!"release_train_batch".equals(link.getType()) || link.isArchive()) continue;
                artKeys.add(link.getReleaseTrainId());
            }
            if (PropertyValidator.isValid(linkedChildBatchesIds)) {
                response.put("linkedChildBatches", this.baseItemRepository.findByIdIn(linkedChildBatchesIds));
            }
            if (PropertyValidator.isValid(linkedParentBatchesIds)) {
                response.put("linkedParentBatches", this.baseItemRepository.findByIdIn(linkedParentBatchesIds));
            }
            if (artKeys.size() > 0) {
                DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(WorkSpace.class));
                AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
                SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
                ArrayList<BasicDBObject> pipeline = new ArrayList<BasicDBObject>();
                pipeline.add(new BasicDBObject("$match", (Object)new BasicDBObject("key", (Object)new BasicDBObject("$in", artKeys)).append("tenant", (Object)tenant)));
                pipeline.add(new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("$toString", (Object)"$type.$id")).append("data", (Object)new BasicDBObject("$push", (Object)"$$ROOT"))));
                Cursor dbCursor = collection.aggregate(pipeline, aggregationOptions);
                while (dbCursor.hasNext()) {
                    WorkSpaceType type;
                    DBObject dbObject = (DBObject)dbCursor.next();
                    String workSpaceTypeId = (String)dbObject.get("_id");
                    if (!PropertyValidator.isValid((Object)workSpaceTypeId) || !PropertyValidator.isValid((Object)(type = this.workSpaceTypeRepository.findById(workSpaceTypeId)))) continue;
                    List data = (List)dbObject.get("data");
                    ArrayList<WorkSpace> workSpaces = new ArrayList<WorkSpace>();
                    for (DBObject document : data) {
                        WorkSpace workSpace = (WorkSpace)this.mongoTemplate.getConverter().read(WorkSpace.class, (Object)document);
                        workSpaces.add(workSpace);
                    }
                    workSpaceMap.put(type.getTitle(), workSpaces);
                }
            }
            response.put("linkedWorkSpaces", workSpaceMap);
            response.put("baseItemLinks", batch.getBaseItemLinks());
        }
        return response;
    }

    public void unlinkArtRelation(Map<String, String> request) throws Exception {
        String batchId = request.get("batchId");
        String artId = request.get("releaseTrainId");
        if (!PropertyValidator.isValid((Object)batchId) || !PropertyValidator.isValid((Object)artId)) {
            throw new KendisException("Invalid Arguments");
        }
        BaseItem batch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)batchId));
        if (!PropertyValidator.isValid((Object)batch)) {
            throw new KendisException("Batch not found");
        }
        BaseItemLink baseItemLinkToRemove = null;
        List baseItemLinks = batch.getBaseItemLinks();
        if (PropertyValidator.isValid((Collection)baseItemLinks)) {
            for (BaseItemLink baseItemLink : baseItemLinks) {
                if (!"release_train_batch".equals(baseItemLink.getType()) || !artId.equals(baseItemLink.getReleaseTrainId()) || baseItemLink.isArchive()) continue;
                baseItemLink.setArchive(true);
                this.baseItemLinkRepository.save((Object)baseItemLink);
                baseItemLinkToRemove = baseItemLink;
                break;
            }
        }
        if (baseItemLinkToRemove != null) {
            batch.getBaseItemLinks().remove(baseItemLinkToRemove);
            this.baseItemRepository.save((Object)batch);
        }
    }

    public void unlinkRelativeBatch(Map<String, String> request) throws Exception {
        String batchId = request.get("batchId");
        String relativeBatchId = request.get("linkedBatchId");
        String linkType = request.get("linkedBatchType");
        BaseItemLink baseItemLinkToRemove = null;
        if (!(PropertyValidator.isValid((Object)batchId) && PropertyValidator.isValid((Object)relativeBatchId) && PropertyValidator.isValid((Object)linkType))) {
            throw new KendisException("Invalid Arguments");
        }
        BaseItem batch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)batchId));
        if (!PropertyValidator.isValid((Object)batch)) {
            throw new KendisException("Batch not found");
        }
        BaseItem relativeBatch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)relativeBatchId));
        if (!PropertyValidator.isValid((Object)relativeBatch)) {
            throw new KendisException("Relative Batch not found");
        }
        for (BaseItemLink baseItemLink : batch.getBaseItemLinks()) {
            if (!relativeBatchId.equals(baseItemLink.getBaseItemId()) || baseItemLink.isArchive()) continue;
            baseItemLink.setArchive(true);
            this.baseItemLinkRepository.save((Object)baseItemLink);
            baseItemLinkToRemove = baseItemLink;
            break;
        }
        if (PropertyValidator.isValid(baseItemLinkToRemove)) {
            batch.getBaseItemLinks().remove(baseItemLinkToRemove);
            this.baseItemRepository.save((Object)batch);
        }
        for (BaseItemLink baseItemLink : relativeBatch.getBaseItemLinks()) {
            if (!batchId.equals(baseItemLink.getBaseItemId()) || baseItemLink.isArchive()) continue;
            baseItemLink.setArchive(true);
            this.baseItemLinkRepository.save((Object)baseItemLink);
            baseItemLinkToRemove = baseItemLink;
            break;
        }
        if (PropertyValidator.isValid(baseItemLinkToRemove)) {
            relativeBatch.getBaseItemLinks().remove(baseItemLinkToRemove);
            this.baseItemRepository.save((Object)relativeBatch);
        }
    }

    private List<BaseItem> fetchBatchesList(String type) {
        List<Object> objectiveGroupList = new ArrayList<BaseItem>();
        ArrayList<ObjectId> objectiveIds = new ArrayList<ObjectId>();
        List baseItemLinks = this.loadBaseItemLinksByType(type);
        if (baseItemLinks == null || baseItemLinks.size() == 0) {
            return objectiveGroupList;
        }
        objectiveGroupList = this.baseItemRepository.findByBaseItemLinksInOrderBySequenceAsc(baseItemLinks);
        HashMap<String, List> objectiveMappedByGroup = new HashMap<String, List>();
        for (BaseItem baseItem : objectiveGroupList) {
            for (Object link2 : baseItem.getBaseItemLinks()) {
                if (!PropertyValidator.isValid((Object)link2.getBaseItemId()) || link2.isArchive()) continue;
                if (!PropertyValidator.isValid((Collection)((Collection)objectiveMappedByGroup.get(link2.getBaseItemId())))) {
                    objectiveMappedByGroup.put(link2.getBaseItemId(), new ArrayList());
                }
                List objGroups = (List)objectiveMappedByGroup.get(link2.getBaseItemId());
                objGroups.add(baseItem);
                objectiveMappedByGroup.put(link2.getBaseItemId(), objGroups);
                objectiveIds.add(new ObjectId(link2.getBaseItemId()));
            }
        }
        List objectivesList = this.loadBatchesByBaseItemId(objectiveIds);
        HashMap hashMap = new HashMap();
        ArrayList keyResultsIds = new ArrayList();
        for (BaseItem objective : objectivesList) {
            if (!PropertyValidator.isValid((Collection)((Collection)objectiveMappedByGroup.get(objective.getId())))) continue;
            List parents = (List)objectiveMappedByGroup.get(objective.getId());
            for (BaseItem parent : parents) {
                this.setBaseItemInParent(parent, objective);
                objective.getBaseItemLinks().forEach(link -> {
                    if (PropertyValidator.isValid((Object)link) && PropertyValidator.isValid((Object)link.getBaseItemId())) {
                        keyResultsIds.add(new ObjectId(link.getBaseItemId()));
                        keyResultMappedByObjective.put(link.getBaseItemId(), objective);
                    }
                });
            }
        }
        List keyResultsList = this.loadBatchesByBaseItemId(keyResultsIds);
        keyResultsList.forEach(keyResult -> {
            if (keyResult.getBaseItemLinks().size() > 0 && !((BaseItemLink)keyResult.getBaseItemLinks().get(0)).isArchive()) {
                this.setBaseItemInParent((BaseItem)keyResultMappedByObjective.get(keyResult.getId()), keyResult);
            }
        });
        return objectiveGroupList;
    }

    private void fetchLinkedItems(BaseItem objective) {
        ArrayList linkedItemIds = new ArrayList();
        ArrayList linkedItems = new ArrayList();
        HashMap linkedItemsById = new HashMap();
        if (PropertyValidator.isValid((Collection)objective.getBaseItemLinks()) && objective.getBaseItemLinks().size() > 0) {
            objective.getBaseItemLinks().forEach(link -> {
                if (PropertyValidator.isValid((Object)link.getItemId()) && !link.isArchive()) {
                    linkedItemIds.add(link.getItemId());
                    Item item = this.getItem(link.getItemId());
                    if (PropertyValidator.isValid((Object)item)) {
                        linkedItems.add(item);
                        if (item.getType().equals("Feature")) {
                            item.setSubItems(this.fetchChildItemsOrUserStories(item.getId()));
                        }
                        if (link.getLinkedItemById() != null) {
                            linkedItemsById.put(link.getItemId(), link.getLinkedItemById().get(link.getItemId()));
                        }
                    }
                }
            });
        }
        objective.setLinkedItems(linkedItems);
        objective.setLinkedItemsIds(linkedItemIds);
        objective.setLinkedItemsById(linkedItemsById);
    }

    public HashMap<String, Object> loadBatchesListBySessionId(String sessionId) {
        try {
            HashMap<String, Object> responseData = new HashMap<String, Object>();
            List BatchesList = this.fetchBatchesList("Batch");
            responseData.put("objectiveGroups", BatchesList);
            return responseData;
        }
        catch (KendisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KendisException("Internal Server Error------" + e.getMessage());
        }
    }

    public List<Item> fetchChildItemsOrUserStories(String id) {
        Query query = new Query();
        query.fields().include("title").include("key").include("type").include("storyPoints").include("tfsId").include("kendisKey").include("tfsURL").include("status").include("teamContainers").include("jiraId").include("jiraKey").include("jiraUrl").include("tfsItemTypeIcon").include("jiraIssueTypeId").include("jiraFieldByKey");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"parent.$id").is((Object)new ObjectId(id)));
        return this.mongoTemplate.find(query, Item.class);
    }

    private List<BaseItemLink> loadBaseItemLinksBySessionIdAndType(String batch) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)batch));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        return this.mongoTemplate.find(query, BaseItemLink.class);
    }

    private List<BaseItemLink> loadBaseItemLinksByReleasaeTrainIdAndType(String releasaeTrainId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)"release_train_batch"));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"releaseTrainId").is((Object)releasaeTrainId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        return this.mongoTemplate.find(query, BaseItemLink.class);
    }

    private List<BaseItem> loadBaseItemLinksBySessionIdAndTypes(List<String> types) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").in(types));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        return this.mongoTemplate.find(query, BaseItem.class);
    }

    private List<BaseItem> getBatchListForObjectiveRelationView(List<String> batchItemTypes) {
        Query query = new Query();
        query.fields().include("id").include("title").include("key").include("type");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").in(batchItemTypes));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        return this.mongoTemplate.find(query, BaseItem.class);
    }

    private Item getItem(String id) {
        Query query = new Query();
        query.fields().include("title").include("key").include("type").include("storyPoints").include("tfsId").include("kendisKey").include("tfsURL").include("status").include("teamContainers").include("jiraId").include("jiraKey").include("jiraUrl").include("sessionBoards").include("tfsItemTypeIcon").include("jiraIssueTypeId").include("jiraFieldByKey");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(new Object[]{new ObjectId(id)}));
        return (Item)this.mongoTemplate.findOne(query, Item.class);
    }

    public WorkFlow createDefaultBatchGroupWorkflow() {
        WorkFlow defaultScheme = new WorkFlow();
        defaultScheme.setTitle("Default Batch Group Workflow");
        defaultScheme.setDefault(false);
        defaultScheme.setWorkflowType("batch_group");
        ArrayList statusList = new ArrayList();
        this.creatBatchesWorkFlows(statusList, defaultScheme);
        defaultScheme = (WorkFlow)this.workFlowRepository.save((Object)defaultScheme);
        this.statusRepository.save(statusList);
        return defaultScheme;
    }

    private void creatBatchesWorkFlows(ArrayList<Status> statusList, WorkFlow defaultScheme) {
        try {
            Status status = new Status();
            status.setCategory("ToDo");
            status.setArchive(false);
            status.setWorkFlow(defaultScheme);
            status.setTitle("Draft");
            statusList.add(status);
            ArrayList<String> InProgressStatuses = new ArrayList<String>();
            InProgressStatuses.add("In Progress");
            InProgressStatuses.add("On Track");
            InProgressStatuses.add("Off Track");
            InProgressStatuses.add("At Risk");
            for (int i = 0; i < InProgressStatuses.size(); ++i) {
                status = new Status();
                status.setCategory("InProgress");
                status.setArchive(false);
                status.setWorkFlow(defaultScheme);
                status.setTitle((String)InProgressStatuses.get(i));
                statusList.add(status);
            }
            status = new Status();
            status.setCategory("Done");
            status.setArchive(false);
            status.setWorkFlow(defaultScheme);
            status.setTitle("Closed");
            statusList.add(status);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while batch workflow creating -> ", (Throwable)e);
        }
    }

    public WorkFlow createDefaultBatchWorkflow() {
        WorkFlow defaultScheme = new WorkFlow();
        defaultScheme.setTitle("Default Batch Workflow");
        defaultScheme.setDefault(false);
        defaultScheme.setWorkflowType("Batch");
        ArrayList statusList = new ArrayList();
        this.creatBatchesWorkFlows(statusList, defaultScheme);
        defaultScheme = (WorkFlow)this.workFlowRepository.save((Object)defaultScheme);
        this.statusRepository.save(statusList);
        return defaultScheme;
    }

    private List<BaseItemLink> convertBaseItemLinkDTOToBaseItemLinkList(List<BaseItemLinkDTO> baseItemLinkDTO) {
        ArrayList<BaseItemLink> baseItemLinks = new ArrayList<BaseItemLink>();
        for (BaseItemLinkDTO linkDTO : baseItemLinkDTO) {
            BaseItemLink baseItemLink = new BaseItemLink();
            baseItemLink.setBaseItemId(linkDTO.getBaseItemId());
            baseItemLink.setLinkType(linkDTO.getLinkType());
            baseItemLink.setReleaseTrainId(linkDTO.getReleaseTrainId());
            baseItemLinks.add(baseItemLink);
        }
        return baseItemLinks;
    }

    public Map<String, Object> moveBulkItems(BaseItemBulkItemsDTO baseItemBulkItemsDTO) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            ArrayList<String> failedBatches = new ArrayList<String>();
            boolean isfailedLinking = false;
            for (Map.Entry entry : baseItemBulkItemsDTO.getBaseItemLinksMap().entrySet()) {
                List links = (List)entry.getValue();
                for (String batchId : baseItemBulkItemsDTO.getDestinationBatchIds()) {
                    try {
                        this.linkBackLogItemToBatch(this.convertBaseItemLinkDTOToBaseItemLinkList(links), batchId);
                    }
                    catch (Exception e) {
                        LOGGER.error("error occured while linking items with batch-id : " + batchId, (Throwable)e);
                        failedBatches.add(batchId);
                    }
                }
            }
            response.put("failedBatches", failedBatches);
            if (!isfailedLinking) {
                for (Map.Entry entry : baseItemBulkItemsDTO.getBaseItemLinksMap().entrySet()) {
                    String batchId = (String)entry.getKey();
                    List links = (List)entry.getValue();
                    for (BaseItemLinkDTO link : links) {
                        String backlogItemId = link.getBaseItemId();
                        try {
                            this.unlinkBackLogItemFromBatch(backlogItemId, batchId);
                        }
                        catch (Exception e) {
                            LOGGER.error("error occurred while linking items with batch-id : " + batchId, (Throwable)e);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while moving bulk items -> ", (Throwable)e);
            throw e;
        }
        return response;
    }

    public Map<String, Object> createDataForBatchesProgress(Map<String, Object> requestStr) throws Exception {
        boolean errorCase;
        LocalDate localDate;
        String dateString;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        boolean includeSubBatches = false;
        String interval = "";
        Date startDate = null;
        Date endDate = null;
        String batchId = "";
        String progressCriteria = "";
        String levelSelection = "";
        if (PropertyValidator.isValid((Object)requestStr.get("interval"))) {
            interval = (String)requestStr.get("interval");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("includeSubBatches"))) {
            includeSubBatches = (Boolean)requestStr.get("includeSubBatches");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("batchId"))) {
            batchId = (String)requestStr.get("batchId");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("interval"))) {
            interval = (String)requestStr.get("interval");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("progressCriteria"))) {
            progressCriteria = (String)requestStr.get("progressCriteria");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("levelSelection"))) {
            levelSelection = (String)requestStr.get("levelSelection");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("startDate"))) {
            dateString = (String)requestStr.get("startDate");
            localDate = LocalDate.parse(dateString);
            LocalDateTime dateTimeAtEndOfPreviousDay = localDate.atTime(LocalTime.MIN);
            startDate = Date.from(dateTimeAtEndOfPreviousDay.atZone(ZoneId.systemDefault()).toInstant());
        }
        if (PropertyValidator.isValid((Object)requestStr.get("endDate"))) {
            dateString = (String)requestStr.get("endDate");
            localDate = LocalDate.parse(dateString);
            LocalDateTime dateTimeAtEndOfCurrentDay = localDate.atTime(LocalTime.MAX);
            endDate = Date.from(dateTimeAtEndOfCurrentDay.atZone(ZoneId.systemDefault()).toInstant());
        }
        if (!PropertyValidator.isValid(startDate) || !PropertyValidator.isValid(endDate) || endDate.before(startDate)) {
            resultMap.put("errorCase", true);
            return resultMap;
        }
        Date today = new Date();
        if (!PropertyValidator.isValid((Object)startDate) || !PropertyValidator.isValid((Object)endDate) || endDate.before(startDate) || startDate.after(today)) {
            resultMap.put("errorCase", true);
            return resultMap;
        }
        TimeSeriesSyncStatus baseItemSyncStatus = this.timeSeriesSyncStatusRepository.findByItemType("baseItem");
        Date syncDate = null;
        if (null != baseItemSyncStatus) {
            syncDate = baseItemSyncStatus.getCreatedOn();
            if (startDate.before(syncDate) && endDate.after(syncDate)) {
                startDate = syncDate;
            }
        } else {
            syncDate = startDate;
        }
        TimeSeriesUtils timeSeriesUtils = new TimeSeriesUtils(this.mongoTemplate, this.statusRepository);
        List intervalDates = timeSeriesUtils.divideIntervals(startDate, endDate, interval);
        startDate = (Date)intervalDates.get(0);
        endDate = (Date)intervalDates.get(intervalDates.size() - 1);
        Map timeSeriesDataMap = this.timeSeriesRepository.getItemsForBatchProgress(interval, startDate, endDate, intervalDates, includeSubBatches, batchId, progressCriteria, levelSelection, syncDate);
        Map itemData = (Map)timeSeriesDataMap.get("datedBatchesMap");
        if (timeSeriesDataMap.containsKey("errorCase") && (errorCase = ((Boolean)timeSeriesDataMap.get("errorCase")).booleanValue())) {
            resultMap.put("errorCase", errorCase);
            return resultMap;
        }
        HashSet allBatchIds = new HashSet();
        for (Map.Entry entry : itemData.entrySet()) {
            Map batchEntry = (Map)entry.getValue();
            this.findAllBatchIds(batchEntry, allBatchIds);
        }
        Map datedProgressMap = this.timeSeriesRepository.calculateProgressForBatches(itemData, progressCriteria, intervalDates, includeSubBatches, allBatchIds);
        Map progressMap = (Map)datedProgressMap.get("datedProgressMap");
        Map itemIds = (Map)timeSeriesDataMap.get("itemKeys");
        Map itemTitles = (Map)timeSeriesDataMap.get("itemTitles");
        Map seriesMap = timeSeriesUtils.getSeriesForBatches(progressMap, itemIds.keySet(), intervalDates);
        Map series = (Map)seriesMap.get("series");
        resultMap.put("errorCase", false);
        resultMap.put("itemIdsMap", itemIds);
        resultMap.put("itemTitlesMap", itemTitles);
        resultMap.put("progress", datedProgressMap);
        resultMap.put("intervals", interval);
        resultMap.put("intervalDates", intervalDates);
        resultMap.put("series", series);
        return resultMap;
    }

    public List<Fields> fetchFieldsForBatch() throws Exception {
        ArrayList<Fields> fields = new ArrayList<Fields>();
        fields.add(new Fields("1", "Title", EnumFieldTypes.TEXT_FIELD.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
        fields.add(new Fields("2", "Brief Overview & Business Goals", EnumFieldTypes.SIMPLE_EDITOR.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, "brief-overview.svg"));
        fields.add(new Fields("3", "Impact & Business Benefits", EnumFieldTypes.SIMPLE_EDITOR.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, "impact-business-benefits.svg"));
        fields.add(new Fields("4", "Scope & Exclusions", EnumFieldTypes.SIMPLE_EDITOR.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, "scope-exclusions.svg"));
        fields.add(new Fields("7", "Key Dependencies", EnumFieldTypes.SIMPLE_EDITOR.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, "key-dependencies.svg"));
        fields.add(new Fields("5", "Assumptions", EnumFieldTypes.SIMPLE_EDITOR.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, "assumptions.svg"));
        fields.add(new Fields("1", "Status", EnumFieldTypes.STATUS.getFieldType(), new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, "status.svg"));
        fields.add(new Fields("2", "Responsibles", EnumFieldTypes.USER_PICKER.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, "responsible.svg"));
        fields.add(new Fields("2", "Start Date", EnumFieldTypes.DATE_PICKER.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
        fields.add(new Fields("2", "End Date", EnumFieldTypes.DATE_PICKER.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
        fields.add(new Fields("6", "Business Case & Investments", EnumFieldTypes.SIMPLE_EDITOR.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, "business-case-investments.svg"));
        fields.add(new Fields("8", "Delivery Outline", EnumFieldTypes.SIMPLE_EDITOR.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, "delivery-outline.svg"));
        return fields;
    }

    public List<Fields> fetchFieldsForBatchGroup() throws Exception {
        ArrayList<Fields> fields = new ArrayList<Fields>();
        fields.add(new Fields("1", "Title", EnumFieldTypes.TEXT_FIELD.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
        fields.add(new Fields("3", "Color", EnumFieldTypes.COLOR_PICKER.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
        fields.add(new Fields("4", "Icon", EnumFieldTypes.IMAGE_UPLOADER.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
        fields.add(new Fields("5", "Brief Overview & Business Goals", EnumFieldTypes.SIMPLE_EDITOR.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, "brief-overview.svg"));
        fields.add(new Fields("3", "Impact & Business Benefits", EnumFieldTypes.SIMPLE_EDITOR.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, "impact-business-benefits.svg"));
        fields.add(new Fields("7", "Key Dependencies", EnumFieldTypes.SIMPLE_EDITOR.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, "key-dependencies.svg"));
        fields.add(new Fields("5", "Assumptions", EnumFieldTypes.SIMPLE_EDITOR.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, "assumptions.svg"));
        fields.add(new Fields("1", "Status", "status", new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, "status.svg"));
        fields.add(new Fields("6", "Responsibles", EnumFieldTypes.USER_PICKER.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, "responsible.svg"));
        fields.add(new Fields("2", "Start Date", EnumFieldTypes.DATE_PICKER.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
        fields.add(new Fields("2", "End Date", EnumFieldTypes.DATE_PICKER.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
        fields.add(new Fields("4", "Scope & Exclusions", EnumFieldTypes.SIMPLE_EDITOR.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, "scope-exclusions.svg"));
        fields.add(new Fields("6", "Business Case & Investments", EnumFieldTypes.SIMPLE_EDITOR.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, "business-case-investments.svg"));
        fields.add(new Fields("8", "Delivery Outline", EnumFieldTypes.SIMPLE_EDITOR.getFieldType(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, "delivery-outline.svg"));
        return fields;
    }

    public boolean isConfiguredFieldEmptyForFieldTemplate(String type) {
        return this.fieldTemplateRepository.findFirstByType(type).map(ft -> ft.getConfiguredFields().isEmpty()).orElse(true);
    }

    public HashMap<String, Object> saveBatchCompletionCriteria(String batchId, String criteria) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (PropertyValidator.isValid((Object)batchId) && PropertyValidator.isValid((Object)criteria)) {
            BaseItem batch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)batchId));
            if (batch.getFields().containsKey("selectedCriteria") && batch.getFields().get("selectedCriteria").equals(criteria)) {
                response.put("savedCriteria", batch.getFields().get("selectedCriteria"));
                return response;
            }
            batch.getFields().put("selectedCriteria", criteria);
            batch = (BaseItem)this.baseItemRepository.save((Object)batch);
            response.put("savedCriteria", batch.getFields().get("selectedCriteria"));
        }
        return response;
    }

    private void findAllBatchIds(Map<String, BaseItem> batches, Set<String> allBatchIds) throws Exception {
        allBatchIds.addAll(batches.keySet());
        for (BaseItem entry : batches.values()) {
            this.findAllBatchIds(entry.getBaseItemsMap(), allBatchIds);
        }
    }
}

