/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.jira.ExportUtil;
import com.viztrend.safe.alm.jira.ImportUtil;
import com.viztrend.safe.alm.jira.JiraUtils;
import com.viztrend.safe.alm.jira.bo.JiraBoard;
import com.viztrend.safe.alm.jira.bo.JiraField;
import com.viztrend.safe.alm.jira.bo.JiraFilter;
import com.viztrend.safe.alm.jira.bo.JiraIssue;
import com.viztrend.safe.alm.jira.bo.JiraIssue2;
import com.viztrend.safe.alm.jira.bo.JiraIssueFields;
import com.viztrend.safe.alm.jira.bo.JiraIssueLink;
import com.viztrend.safe.alm.jira.bo.JiraIssueLinkType;
import com.viztrend.safe.alm.jira.bo.JiraIssueLinkTypeArrayWrapper;
import com.viztrend.safe.alm.jira.bo.JiraItemFilter;
import com.viztrend.safe.alm.jira.bo.JiraProject;
import com.viztrend.safe.alm.jira.bo.JiraProjectStatuses;
import com.viztrend.safe.alm.jira.bo.JiraSearch2;
import com.viztrend.safe.alm.jira.bo.JiraSearchRequest;
import com.viztrend.safe.alm.jira.bo.JiraSprint;
import com.viztrend.safe.alm.jira.bo.JiraTransition;
import com.viztrend.safe.alm.jira.bo.JiraTransitionWrapper;
import com.viztrend.safe.alm.jira.bo.JiraUser;
import com.viztrend.safe.alm.jira.bo.JiraVersion;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.enums.EnumStatusCategory;
import com.viztrend.safe.exception.KendisException;
import com.viztrend.safe.persistence.entity.AlmAccUser;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.AlmError;
import com.viztrend.safe.persistence.entity.BacklogMapping;
import com.viztrend.safe.persistence.entity.BacklogMappingLinks;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.EpicFeature;
import com.viztrend.safe.persistence.entity.FieldMapping;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemJiraFieldMap;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.ItemLinkType;
import com.viztrend.safe.persistence.entity.ItemSyncMapper;
import com.viztrend.safe.persistence.entity.JiraAlmAccountMeta;
import com.viztrend.safe.persistence.entity.JiraOauthToken;
import com.viztrend.safe.persistence.entity.JiraProjectIssueTypes;
import com.viztrend.safe.persistence.entity.PushResponse;
import com.viztrend.safe.persistence.entity.Risk;
import com.viztrend.safe.persistence.entity.RiskRegister;
import com.viztrend.safe.persistence.entity.ScoreCard;
import com.viztrend.safe.persistence.entity.ScoreParam;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.SolutionBoardWsjFAlmConfiguration;
import com.viztrend.safe.persistence.entity.State;
import com.viztrend.safe.persistence.entity.StateScheme;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.TeamSprintDependencyLimit;
import com.viztrend.safe.persistence.entity.TeamSprintVelocity;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserBoardLocation;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.AlmConfigurationsRepository;
import com.viztrend.safe.persistence.repository.AlmErrorRepository;
import com.viztrend.safe.persistence.repository.AlmInfoRepository;
import com.viztrend.safe.persistence.repository.ContainerRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.EpicFeaturesRepository;
import com.viztrend.safe.persistence.repository.ItemJiraDependencyRepository;
import com.viztrend.safe.persistence.repository.ItemLinkRepository;
import com.viztrend.safe.persistence.repository.ItemLinkTypeRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.ItemSyncMapperRepository;
import com.viztrend.safe.persistence.repository.JiraAlmAccountMetaRepository;
import com.viztrend.safe.persistence.repository.JiraFieldRepository;
import com.viztrend.safe.persistence.repository.JiraIssueRepository;
import com.viztrend.safe.persistence.repository.JiraProjectIssueTypesRepository;
import com.viztrend.safe.persistence.repository.JiraProjectStatusesRepository;
import com.viztrend.safe.persistence.repository.JiraRepository;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.RiskRepository;
import com.viztrend.safe.persistence.repository.ScoreCardRepository;
import com.viztrend.safe.persistence.repository.ServerCacheRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.StateRepository;
import com.viztrend.safe.persistence.repository.StateSchemeRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TeamContainerRepository;
import com.viztrend.safe.persistence.repository.TeamRepository;
import com.viztrend.safe.persistence.repository.TeamSprintDependencyLimitRepository;
import com.viztrend.safe.persistence.repository.TeamSprintVelocityRepository;
import com.viztrend.safe.persistence.repository.UserBoardLocationRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.ALMSyncService;
import com.viztrend.safe.service.ALMSyncServiceImpl;
import com.viztrend.safe.service.ImportService;
import com.viztrend.safe.service.PlanService;
import com.viztrend.safe.service.ReleaseTrainService;
import com.viztrend.safe.service.ScoreCardService;
import com.viztrend.safe.service.TFSservice;
import com.viztrend.safe.service.UserService;
import com.viztrend.safe.utils.AlmUtils;
import com.viztrend.safe.utils.DateUtils;
import com.viztrend.safe.utils.EncDecUtility;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.MongoSyncUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.utils.WebhookActivityUtil;
import com.viztrend.safe.vos.JiraConnectVO;
import com.viztrend.safe.vos.MappedFieldVO;
import com.viztrend.safe.vos.ResyncParamsVO;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.bson.types.ObjectId;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.supercsv.prefs.CsvPreference;

@Component(value="ALMSyncService")
@Transactional
public class ALMSyncServiceImpl
implements ALMSyncService {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private ImportUtil importUtil;
    @Autowired
    private AppConfig.MongoConfig mongoConfig;
    @Autowired
    private JiraRepository<Serializable> jiraRepository;
    @Autowired
    private UserBoardLocationRepository userBoardLocationRepository;
    @Autowired
    private JiraProjectIssueTypesRepository jiraProjectIssueTypesRepository;
    @Autowired
    private Environment env;
    @Autowired
    ImportService importService;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private StateRepository stateRepository;
    @Autowired
    private StateSchemeRepository stateSchemeRepository;
    @Autowired
    private WorkFlowRepository workFlowRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private JiraFieldRepository jiraFieldRepository;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private ScoreCardRepository scoreCardRepository;
    @Autowired
    private JiraProjectStatusesRepository jiraProjectStatusesRepository;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private TeamSprintDependencyLimitRepository TeamSprintDependencyLimitRepository;
    @Autowired
    private AlmInfoRepository almInfoRepository;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private TeamRepository teamRepository;
    @Autowired
    private ItemJiraDependencyRepository itemJiraDependencyRepository;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private ExportUtil exportUtil;
    @Autowired
    private ItemSyncMapperRepository itemSyncMapperRepository;
    @Autowired
    private AlmErrorRepository almErrorRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private PushResponseRepository pushResponseRepository;
    @Autowired
    private JiraIssueRepository jiraIssueRepository;
    @Autowired
    private JiraAlmAccountMetaRepository jiraAlmAccountMetaRepository;
    @Autowired
    private TeamContainerRepository teamContainerRepository;
    @Autowired
    private ItemLinkRepository itemLinkRepository;
    @Autowired
    private RiskRepository riskRepository;
    @Autowired
    private TeamSprintVelocityRepository teamSprintVelocityRepository;
    @Autowired
    private TFSservice tfsService;
    @Autowired
    private AlmConfigurationsRepository almConfigurationsRepository;
    @Autowired
    UserService userservice;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private PlanService planService;
    @Autowired
    private EpicFeaturesRepository epicFeaturesRepository;
    @Autowired
    private ItemLinkTypeRepository itemLinkTypeRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private ServerCacheRepository serverCacheRepository;
    @Autowired
    private ReleaseTrainService releaseTrainService;
    @Autowired
    private ScoreCardService scoreCardService;
    private static final Logger LOGGER = LoggerFactory.getLogger(ALMSyncServiceImpl.class);

    public List<JiraField> retrieveJiraFields(AlmAccount almAccount, String fieldsJSON) {
        List<JiraField> fields = new ArrayList();
        Gson gson = new Gson();
        if (fieldsJSON == null) {
            fields = this.importUtil.retrieveJiraFieldsList(almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword(), almAccount);
        } else {
            1 T = new /* Unavailable Anonymous Inner Class!! */;
            if (fieldsJSON != null) {
                Collection searchResult = (Collection)gson.fromJson(fieldsJSON, T.getType());
                fields = new ArrayList(searchResult);
            }
        }
        boolean saveAlmAgain = false;
        if (fields != null) {
            for (JiraField field : fields) {
                field.setAlmAccountId(almAccount.getId());
                field.setTenant(almAccount.getTenant());
                if (!PropertyValidator.isValid((Object)field.getSchema()) || !PropertyValidator.isValid((Object)field.getSchema().getCustom())) continue;
                if (!(!field.getSchema().getCustom().contains("gh-epic-link") || field.getName().equals(almAccount.getJiraEpicLinkLabel()) && PropertyValidator.isValid((Object)almAccount.getJiraEpicLinkClause()))) {
                    almAccount.setJiraEpicLinkLabel(field.getName());
                    if (PropertyValidator.isValid((String[])field.getClauseNames()) && field.getClauseNames().length >= 1) {
                        almAccount.setJiraEpicLinkClause(field.getClauseNames()[0]);
                    } else {
                        almAccount.setJiraEpicLinkClause(field.getName());
                    }
                    saveAlmAgain = true;
                } else if (!(!field.getSchema().getCustom().contains("gh-epic-label") || field.getName().equals(almAccount.getJiraEpicNameLabel()) && PropertyValidator.isValid((Object)almAccount.getJiraEpicNameClause()))) {
                    almAccount.setJiraEpicNameLabel(field.getName());
                    if (PropertyValidator.isValid((String[])field.getClauseNames()) && field.getClauseNames().length >= 1) {
                        almAccount.setJiraEpicNameClause(field.getClauseNames()[0]);
                    } else {
                        almAccount.setJiraEpicNameClause(field.getName());
                    }
                    saveAlmAgain = true;
                }
                if (field.getSchema().getCustom().contains("gh-epic-color")) {
                    almAccount.setJiraEpicColor(field.getId());
                    saveAlmAgain = true;
                    continue;
                }
                if (!field.getSchema().getCustom().contains("jsw-issue-color")) continue;
                almAccount.setJiraIssueColor(field.getId());
                saveAlmAgain = true;
            }
            try {
                this.jiraFieldRepository.deleteByAlmAccountIdAndTenant(almAccount.getId(), almAccount.getTenant());
            }
            catch (Exception searchResult) {
                // empty catch block
            }
            this.jiraFieldRepository.save(fields);
            if (saveAlmAgain) {
                AlmAccount accountToBeSaved = this.almAccountRepository.findById(almAccount.getId());
                accountToBeSaved.setJiraEpicLinkLabel(almAccount.getJiraEpicLinkLabel());
                accountToBeSaved.setJiraEpicLinkClause(almAccount.getJiraEpicLinkClause());
                accountToBeSaved.setJiraEpicNameLabel(almAccount.getJiraEpicNameLabel());
                accountToBeSaved.setJiraEpicNameClause(almAccount.getJiraEpicNameClause());
                accountToBeSaved.setJiraEpicColor(almAccount.getJiraEpicColor());
                accountToBeSaved.setJiraIssueColor(almAccount.getJiraIssueColor());
                this.almAccountRepository.save((Object)accountToBeSaved);
            }
        }
        return fields;
    }

    public String retrieveJiraFieldsJSON(AlmAccount almAccount, boolean eagerFetch) {
        String jiraFieldsStr = null;
        try {
            if (!eagerFetch) {
                DBObject vo;
                String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"almAccountId").is((Object)almAccount.getId()));
                DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("jiraAlmAccountMeta").find(query.getQueryObject());
                if (dbCursorPrefix.hasNext() && PropertyValidator.isValid((Object)(vo = dbCursorPrefix.next()))) {
                    jiraFieldsStr = (String)vo.get("jiraFields");
                }
            }
            if (!PropertyValidator.isValid(jiraFieldsStr) || eagerFetch) {
                jiraFieldsStr = this.importUtil.retrieveJiraFieldsJSON(almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword(), almAccount);
                JiraAlmAccountMeta accountMeta = this.jiraAlmAccountMetaRepository.findByAlmAccountId(almAccount.getId());
                if (!PropertyValidator.isValid((Object)accountMeta)) {
                    accountMeta = new JiraAlmAccountMeta(almAccount.getId());
                }
                accountMeta.setJiraFields(jiraFieldsStr);
                accountMeta = (JiraAlmAccountMeta)this.jiraAlmAccountMetaRepository.save((Object)accountMeta);
                this.retrieveJiraFields(almAccount, jiraFieldsStr);
            }
        }
        catch (ViztrendJiraException vJe) {
            LOGGER.error("FAILED.. retrieveJiraFieldsJSON .", (Throwable)vJe);
            throw vJe;
        }
        return jiraFieldsStr;
    }

    public HashMap<String, Object> retrieveJiraFields(List<String> almAccountIds) {
        HashMap<String, Object> fieldsByALM = new HashMap<String, Object>();
        try {
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"almAccountId").in(almAccountIds));
            DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("jiraAlmAccountMeta").find(query.getQueryObject());
            while (dbCursorPrefix.hasNext()) {
                DBObject vo = dbCursorPrefix.next();
                fieldsByALM.put((String)vo.get("almAccountId"), (String)vo.get("jiraFields"));
            }
        }
        catch (Exception vJe) {
            LOGGER.error("FAILED.. retrieveJiraFields .", (Throwable)vJe);
        }
        return fieldsByALM;
    }

    public String validateJiraUser(HashMap<String, Object> param) {
        String[] jiraFields = new String[]{(String)param.get("url"), (String)param.get("username"), (String)param.get("password")};
        AlmAccount almAcc = new AlmAccount();
        almAcc.setId((String)param.get("almAccountId"));
        almAcc.setUrl((String)param.get("url"));
        almAcc.setUsername((String)param.get("username"));
        almAcc.setPassword((String)param.get("password"));
        almAcc.setIsPatOn((Boolean)param.get("isPatOn"));
        almAcc.setClientId((String)param.get("clientId"));
        almAcc.setSecretKey((String)param.get("secretKey"));
        if (PropertyValidator.isValid((Object)param.get("jiraOauthToken"))) {
            Map jiraOauthTokenMap = (Map)new Gson().fromJson((String)param.get("jiraOauthToken"), Map.class);
            JiraOauthToken jiraOauthToken = new JiraOauthToken();
            if (JiraUtils.getBooleanValue(jiraOauthTokenMap.get("isCloud")) || JiraOauthToken.ServerAuthType.AUTH_2_0.name().equals(jiraOauthTokenMap.get("serverAuthType"))) {
                jiraOauthToken = JiraUtils.parseJiraAuthTokenMap((Map)jiraOauthTokenMap);
            } else {
                jiraOauthToken.setConsumerKey((String)jiraOauthTokenMap.get("consumerKey"));
                jiraOauthToken.setPrivateKey((String)jiraOauthTokenMap.get("privateKey"));
                jiraOauthToken.setOauthToken((String)jiraOauthTokenMap.get("oauthToken"));
                jiraOauthToken.setOauthVerfier((String)jiraOauthTokenMap.get("oauthVerfier"));
                jiraOauthToken.setAccessToken((String)jiraOauthTokenMap.get("accessToken"));
            }
            almAcc.setJiraAuthRedirectURL(String.valueOf(param.get("jiraAuthRedirectURL")));
            almAcc.setJiraOauthToken(jiraOauthToken);
            almAcc.setOAuthTokenOwnerUserId((String)param.get("OAuthTokenOwnerUserId"));
            almAcc.setAdminAlmAcc(Boolean.valueOf((Boolean)param.getOrDefault("isAdminAlmAcc", true)));
        }
        String originalUrl = (String)param.get("url");
        Boolean saveNewConnectAccount = Boolean.FALSE;
        if (PropertyValidator.isValid((Object)param.get("useConnect")) && "true".equalsIgnoreCase((String)param.get("useConnect"))) {
            almAcc.setUsingJiraConnect(true);
            almAcc.setAtlassianHostDomainId((String)param.get("jiraHostId"));
            String jiraHostUsername = (String)param.get("jiraHostUsername");
            if (PropertyValidator.isValid((Object)jiraHostUsername)) {
                JiraUser jiraUser = this.importUtil.retrieveJiraUserByEmailId(jiraHostUsername, null, null, almAcc);
                jiraHostUsername = jiraUser.getKey();
                almAcc.setUsername(jiraHostUsername);
                saveNewConnectAccount = Boolean.TRUE;
            } else {
                JiraConnectVO connectVo = this.getConnectAccountUser(almAcc.getAtlassianHostDomainId());
                almAcc.setUsername(connectVo.getJiraKey());
            }
            almAcc.setUrl((String)param.get("jiraHostUrl"));
            LOGGER.warn("LOG: useConnect --> login viaplugin . URL = " + param.get("url"));
        }
        String result = this.importUtil.validateJiraUser(jiraFields[0], jiraFields[1], jiraFields[2], almAcc);
        param.put("jiraOauthToken", PropertyValidator.isValid((Object)almAcc.getJiraOauthToken()) ? almAcc.getJiraOauthToken().toString() : null);
        if (Boolean.TRUE.equals(saveNewConnectAccount)) {
            // empty if block
        }
        return result;
    }

    public HashMap<String, Object> validateAlmAccountUser(AlmAccount almAccount, User user) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            AlmAccUser almAccUser;
            if (user != null && PropertyValidator.isValid((Object)(almAccUser = this.getUserAlmCredntials(almAccount.getId(), user)))) {
                JSONObject profileObject = new JSONObject();
                try {
                    AlmAccount almAccount1 = almAccount;
                    almAccount1.setJiraOauthToken(almAccUser.getJiraOauthToken());
                    almAccount1.setOAuthTokenOwnerUserId(user.getId());
                    almAccount1.setAdminAlmAcc(Boolean.valueOf(false));
                    almAccount1.setIsTaggedUser(Boolean.valueOf(true));
                    almAccount1.setIsPatOnProfile(almAccUser.getIsPatOn());
                    String userJson = this.importUtil.validateJiraUser(almAccount.getUrl(), almAccUser.getAlmUsername(), almAccUser.getAlmPassword(), almAccount1);
                    profileObject.put("validationFailed", false);
                    responseJson.put("userJson", userJson);
                }
                catch (ViztrendJiraException vJe) {
                    LOGGER.error("FAILED.. validateAlmAccountUser while saving...", (Throwable)vJe);
                    profileObject.put("validationFailed", true);
                    if (vJe.getAlmError().getHttpErrorCode() == 403 || vJe.getAlmError().getHttpErrorCode() == 404) {
                        profileObject.put("validationMessage", (Object)vJe.getAlmError().getAlmErrorMessage());
                    } else {
                        if (vJe.getAlmError().getHttpErrorCode() == 500) {
                            profileObject.put("validationMessage", (Object)vJe.getAlmError().getAlmErrorMessage());
                            responseJson.put("exception", (Object)vJe);
                            responseJson.put("validationFailed", true);
                            responseJson.put("profileUser", profileObject);
                            return responseJson;
                        }
                        if (vJe.getAlmError().getHttpErrorCode() == 401) {
                            profileObject.put("validationMessage", (Object)"Invalid Credentials");
                        }
                    }
                    responseJson.put("exception", (Object)vJe);
                    responseJson.put("validationFailed", true);
                }
                responseJson.put("profileUser", profileObject);
                if (almAccount.getUsername().equals(almAccUser.getAlmUsername())) {
                    return responseJson;
                }
            }
            JSONObject almUserObject = new JSONObject();
            try {
                String userJson = this.importUtil.validateJiraUser(almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword(), almAccount);
                almUserObject.put("validationFailed", false);
                responseJson.put("userJson", userJson);
            }
            catch (ViztrendJiraException vJe) {
                LOGGER.error("FAILED.. validateAlmAccountUser while saving...", (Throwable)vJe);
                almUserObject.put("validationFailed", true);
                if (vJe.getAlmError().getHttpErrorCode() == 403 || vJe.getAlmError().getHttpErrorCode() == 404) {
                    almUserObject.put("validationMessage", (Object)vJe.getAlmError().getAlmErrorMessage());
                } else {
                    if (vJe.getAlmError().getHttpErrorCode() == 500) {
                        responseJson.put("validationFailed", true);
                        almUserObject.put("validationMessage", (Object)vJe.getAlmError().getAlmErrorMessage());
                        return responseJson;
                    }
                    if (vJe.getAlmError().getHttpErrorCode() == 401) {
                        almUserObject.put("validationMessage", (Object)"Invalid Credentials");
                    }
                }
                responseJson.put("exception", (Object)vJe);
                responseJson.put("validationFailed", true);
            }
            responseJson.put("almUser", almUserObject);
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return responseJson;
    }

    public List<Object> retrieveJiraFields4Preview(HashMap<String, Object> param) {
        ArrayList<Object> result = new ArrayList<Object>();
        List fields = new ArrayList();
        String[] jiraFields = new String[]{(String)param.get("url"), (String)param.get("username"), (String)param.get("password")};
        AlmAccount almAcc = new AlmAccount();
        almAcc.setUrl((String)param.get("url"));
        almAcc.setUsername((String)param.get("username"));
        almAcc.setPassword((String)param.get("password"));
        almAcc.setIsPatOn((Boolean)param.get("isPatOn"));
        String originalUrl = (String)param.get("url");
        if (PropertyValidator.isValid((Object)param.get("jiraOauthToken"))) {
            Map jiraOauthTokenMap = (Map)new Gson().fromJson((String)param.get("jiraOauthToken"), Map.class);
            JiraOauthToken jiraOauthToken = new JiraOauthToken();
            if (JiraUtils.getBooleanValue(jiraOauthTokenMap.get("isCloud")) || JiraOauthToken.ServerAuthType.AUTH_2_0.name().equals(jiraOauthTokenMap.get("serverAuthType"))) {
                jiraOauthToken = JiraUtils.parseJiraAuthTokenMap((Map)jiraOauthTokenMap);
            } else {
                jiraOauthToken.setConsumerKey((String)jiraOauthTokenMap.get("consumerKey"));
                jiraOauthToken.setPrivateKey((String)jiraOauthTokenMap.get("privateKey"));
                jiraOauthToken.setOauthToken((String)jiraOauthTokenMap.get("oauthToken"));
                jiraOauthToken.setOauthVerfier((String)jiraOauthTokenMap.get("oauthVerfier"));
                jiraOauthToken.setAccessToken((String)jiraOauthTokenMap.get("accessToken"));
            }
            almAcc.setJiraAuthRedirectURL(String.valueOf(param.get("jiraAuthRedirectURL")));
            almAcc.setJiraOauthToken(jiraOauthToken);
        }
        if ("true".equalsIgnoreCase((String)param.get("useConnect"))) {
            almAcc.setUsingJiraConnect(true);
            almAcc.setAtlassianHostDomainId((String)param.get("jiraHostId"));
            JiraConnectVO connectVo = this.getConnectAccountUser(almAcc.getAtlassianHostDomainId());
            almAcc.setUsername(connectVo.getJiraKey());
            almAcc.setUrl((String)param.get("jiraHostUrl"));
        }
        fields = this.importUtil.retrieveJiraFieldsList(jiraFields[0], jiraFields[1], jiraFields[2], almAcc);
        param.put("jiraOauthToken", PropertyValidator.isValid((Object)almAcc.getJiraOauthToken()) ? almAcc.getJiraOauthToken().toString() : null);
        result.add(almAcc);
        if (fields == null) {
            return null;
        }
        result.add(fields);
        return result;
    }

    public List<JiraField> retrieveJiraFields(String jiraInfo) {
        ArrayList<JiraField> fields = new ArrayList();
        Gson gson = new Gson();
        2 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap param = (HashMap)gson.fromJson(jiraInfo, T.getType());
        String[] jiraFields = new String[]{(String)param.get("url"), (String)param.get("username"), (String)param.get("password")};
        AlmAccount almAcc = new AlmAccount();
        almAcc.setUrl((String)param.get("url"));
        almAcc.setUsername((String)param.get("username"));
        almAcc.setPassword((String)param.get("password"));
        if ("true".equals(param.get("isPatOn"))) {
            almAcc.setIsPatOn(Boolean.valueOf(true));
        }
        if ("true".equalsIgnoreCase((String)param.get("useConnect"))) {
            almAcc.setUsingJiraConnect(true);
            almAcc.setAtlassianHostDomainId((String)param.get("jiraHostId"));
            JiraConnectVO connectVo = this.getConnectAccountUser(almAcc.getAtlassianHostDomainId());
            almAcc.setUsername(connectVo.getJiraKey());
            almAcc.setUrl((String)param.get("jiraHostUrl"));
        }
        if ((fields = this.importUtil.retrieveJiraFieldsList(jiraFields[0], jiraFields[1], jiraFields[2], almAcc)) != null) {
            return fields;
        }
        return null;
    }

    public String retrieveJiraProjectFieldsJSON(AlmAccount almAccount, String projectKey) {
        String jiraProjectJson = null;
        try {
            jiraProjectJson = this.importUtil.retrieveJiraProjectCreateMeta(almAccount, projectKey);
        }
        catch (ViztrendJiraException e) {
            LOGGER.debug(StringUtils.getTraceString((Throwable)e));
            if (e.getCode() == 404) {
                JSONObject createMetaObject = new JSONObject();
                JSONArray projectArray = new JSONArray();
                String projectJSON = this.importUtil.retrieveProjectDetails(projectKey, almAccount.getAlmURL(), almAccount.getUsername(), almAccount.getPassword(), almAccount);
                if (PropertyValidator.isValid((Object)projectJSON)) {
                    JSONObject projectObj = new JSONObject(projectJSON);
                    String pKey = projectObj.getString("key");
                    JSONArray issueTypesArray = projectObj.getJSONArray("issueTypes");
                    if (PropertyValidator.isValid((Object)issueTypesArray)) {
                        for (int i = 0; i < issueTypesArray.length(); ++i) {
                            JSONObject issueTypeObj = issueTypesArray.getJSONObject(i);
                            String issueTypeId = (String)issueTypeObj.get("id");
                            HashMap issueTypeFields = this.importUtil.retrieveCreateMetaByProjectAndIssueType(pKey, issueTypeId, almAccount);
                            issueTypeObj.put("fields", (Map)issueTypeFields);
                        }
                    }
                    projectArray.put((Object)projectObj);
                    createMetaObject.put("projects", (Object)projectArray);
                    if (almAccount.isDebug()) {
                        LOGGER.debug(createMetaObject.toString());
                    }
                    jiraProjectJson = createMetaObject.toString();
                }
            }
            throw e;
        }
        return jiraProjectJson;
    }

    public String retrieveJiraProjectFields(AlmAccount almAccount, String projectKeys, Boolean skipError, Boolean fromBacklog) {
        String[] projectKeysArray;
        String jiraProjectJson = null;
        for (String projectKey : projectKeysArray = projectKeys.split(",")) {
            jiraProjectJson = this.retrieveJiraProjectFieldsJSON(almAccount, projectKey);
            Gson gson = new Gson();
            try {
                3 T = new /* Unavailable Anonymous Inner Class!! */;
                HashMap param = (HashMap)gson.fromJson(jiraProjectJson, T.getType());
                ArrayList projects = (ArrayList)param.get("projects");
                for (LinkedTreeMap project : projects) {
                    String projKey = (String)project.get((Object)"key");
                    String issueTypesKey = "issuetypes";
                    if (project.get((Object)issueTypesKey) == null) {
                        issueTypesKey = "issueTypes";
                    }
                    JiraProject jiraProject = this.retrieveJiraProjectWithDetails(projKey, almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword(), almAccount);
                    String issueTypesReference = UUID.randomUUID().toString();
                    JiraProjectIssueTypes projectWithIssueTypes = null;
                    projectWithIssueTypes = fromBacklog != false ? this.jiraProjectIssueTypesRepository.findByAlmAccountIdAndJiraProjectKeyAndFromBacklogIsTrue(almAccount.getId(), (String)project.get((Object)"key")) : this.jiraProjectIssueTypesRepository.findByAlmAccountIdAndJiraProjectKey(almAccount.getId(), (String)project.get((Object)"key"));
                    if (PropertyValidator.isValid((Object)projectWithIssueTypes)) {
                        if (!PropertyValidator.isValid((Object)projectWithIssueTypes.getIssueTypesReference())) {
                            projectWithIssueTypes.setIssueTypes(null);
                            projectWithIssueTypes.setIssueTypesReference(issueTypesReference);
                        } else {
                            issueTypesReference = projectWithIssueTypes.getIssueTypesReference();
                        }
                    } else {
                        projectWithIssueTypes = new JiraProjectIssueTypes(almAccount.getId(), (String)project.get((Object)"id"), (String)project.get((Object)"key"), gson.toJson(project.get((Object)issueTypesKey)), (String)project.get((Object)"name"));
                        projectWithIssueTypes.setIssueTypesReference(issueTypesReference);
                        projectWithIssueTypes.setFromBacklog(fromBacklog.booleanValue());
                    }
                    ArrayList issueTypes = (ArrayList)project.get((Object)issueTypesKey);
                    for (LinkedTreeMap issueType : issueTypes) {
                        LinkedTreeMap fields = (LinkedTreeMap)issueType.get((Object)"fields");
                        if (PropertyValidator.isValid((Object)almAccount.getDueDateField())) {
                            if (!PropertyValidator.isValid((Object)fields.get((Object)almAccount.getDueDateField().getJiraId()))) {
                                if (!PropertyValidator.isValid((Collection)projectWithIssueTypes.getSkipSyncFields())) {
                                    projectWithIssueTypes.setSkipSyncFields(new HashSet());
                                }
                                projectWithIssueTypes.getSkipSyncFields().add(issueType.get((Object)"id") + "_" + "duedate");
                            } else if (PropertyValidator.isValid((Collection)projectWithIssueTypes.getSkipSyncFields()) && projectWithIssueTypes.getSkipSyncFields().contains(issueType.get((Object)"id") + "_" + "duedate")) {
                                projectWithIssueTypes.getSkipSyncFields().remove(issueType.get((Object)"id") + "_" + "duedate");
                            }
                        }
                        if (PropertyValidator.isValid((Object)almAccount.getStartDateField())) {
                            if (!PropertyValidator.isValid((Object)fields.get((Object)almAccount.getStartDateField().getJiraId()))) {
                                if (!PropertyValidator.isValid((Collection)projectWithIssueTypes.getSkipSyncFields())) {
                                    projectWithIssueTypes.setSkipSyncFields(new HashSet());
                                }
                                projectWithIssueTypes.getSkipSyncFields().add(issueType.get((Object)"id") + "_" + "startDate");
                            } else if (PropertyValidator.isValid((Collection)projectWithIssueTypes.getSkipSyncFields()) && projectWithIssueTypes.getSkipSyncFields().contains(issueType.get((Object)"id") + "_" + "startDate")) {
                                projectWithIssueTypes.getSkipSyncFields().remove(issueType.get((Object)"id") + "_" + "startDate");
                            }
                        }
                        if (PropertyValidator.isValid((Object)almAccount.getEndDateField())) {
                            if (!PropertyValidator.isValid((Object)fields.get((Object)almAccount.getEndDateField().getJiraId()))) {
                                if (!PropertyValidator.isValid((Collection)projectWithIssueTypes.getSkipSyncFields())) {
                                    projectWithIssueTypes.setSkipSyncFields(new HashSet());
                                }
                                projectWithIssueTypes.getSkipSyncFields().add(issueType.get((Object)"id") + "_" + "endDate");
                            } else if (PropertyValidator.isValid((Collection)projectWithIssueTypes.getSkipSyncFields()) && projectWithIssueTypes.getSkipSyncFields().contains(issueType.get((Object)"id") + "_" + "endDate")) {
                                projectWithIssueTypes.getSkipSyncFields().remove(issueType.get((Object)"id") + "_" + "endDate");
                            }
                        }
                        JiraField storyPointsField = null;
                        storyPointsField = "next-gen".equals(jiraProject.getStyle()) && PropertyValidator.isValid((Object)almAccount.getNextGenStoryPointField()) ? almAccount.getNextGenStoryPointField() : almAccount.getStoryPointField();
                        if (PropertyValidator.isValid((Object)storyPointsField)) {
                            if (!PropertyValidator.isValid((Object)fields.get((Object)storyPointsField.getJiraId()))) {
                                if (!PropertyValidator.isValid((Collection)projectWithIssueTypes.getSkipSyncFields())) {
                                    projectWithIssueTypes.setSkipSyncFields(new HashSet());
                                }
                                projectWithIssueTypes.getSkipSyncFields().add(issueType.get((Object)"id") + "_" + "Story Points");
                            } else if (PropertyValidator.isValid((Collection)projectWithIssueTypes.getSkipSyncFields()) && projectWithIssueTypes.getSkipSyncFields().contains(issueType.get((Object)"id") + "_" + "Story Points")) {
                                projectWithIssueTypes.getSkipSyncFields().remove(issueType.get((Object)"id") + "_" + "Story Points");
                            }
                        }
                        projectWithIssueTypes.setIssueTypes(null);
                    }
                    try {
                        projectWithIssueTypes.setStyle(jiraProject.getStyle());
                        this.jiraProjectIssueTypesRepository.save((Object)projectWithIssueTypes);
                        String meta = gson.toJson(project.get((Object)issueTypesKey));
                        MongoSyncUtils.removeData((String)projectWithIssueTypes.getIssueTypesReference(), (AppConfig.MongoConfig)this.mongoConfig);
                        MongoSyncUtils.storeData((String)projectWithIssueTypes.getIssueTypesReference(), (String)meta, (AppConfig.MongoConfig)this.mongoConfig);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error while sending email :" + StringUtils.getTraceString((Throwable)ex));
                    }
                }
            }
            catch (ViztrendJiraException vJe) {
                LOGGER.error("FAILED.. retrieveJiraProjectFields while saving...", (Throwable)vJe);
                LOGGER.error("jiraProjectJson", (Object)jiraProjectJson);
                if (skipError.booleanValue()) continue;
                throw vJe;
            }
        }
        return jiraProjectJson;
    }

    public List<JiraSprint> retrieveAllSprintsForJiraBoard(String boardId, String[] jiraInfo) {
        List<Object> boardSprints = new ArrayList<JiraSprint>();
        if (PropertyValidator.isValid((Object)boardId)) {
            Query q = new Query();
            q.addCriteria((CriteriaDefinition)Criteria.where((String)"jiraId").is((Object)boardId));
            JiraBoard jBoard = (JiraBoard)this.jiraRepository.getMongoTemplate().findOne(q, JiraBoard.class);
            boardSprints = this.importUtil.retrieveJiraBoardAllSprints(jBoard.getJiraId(), jiraInfo[0], jiraInfo[1], jiraInfo[2], null);
            if (PropertyValidator.isValid(boardSprints)) {
                this.jiraRepository.saveAllItems(boardSprints);
            }
        }
        return boardSprints;
    }

    public List<JiraVersion> retrieveAllVersionsForJiraProject(String projectKey, String[] jiraInfo) {
        if (PropertyValidator.isValid((Object)projectKey)) {
            JiraProject project = this.retrieveJiraProjectWithDetails(projectKey, jiraInfo[0], jiraInfo[1], jiraInfo[2], null);
            return project.getVersions();
        }
        return new ArrayList<JiraVersion>();
    }

    public JiraVersion updateJiraVersion(JiraVersion version, AlmAccount almAccount) {
        if (PropertyValidator.isValid((Object)version)) {
            return this.exportUtil.updateJiraVersion(version, almAccount);
        }
        return null;
    }

    public List<JiraSprint> retrieveFutureSprintsForJiraBoard(String boardId, AlmAccount almAccount, String sessionBoardId) {
        List<Object> boardSprints = new ArrayList<JiraSprint>();
        if (PropertyValidator.isValid((Object)boardId) && PropertyValidator.isValid(boardSprints = this.importUtil.retrieveJiraBoardFutureSprints(boardId, almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword(), almAccount))) {
            for (JiraSprint jiraSprint : boardSprints) {
                jiraSprint.setAlmAccountId(almAccount.getId());
                jiraSprint.setSessionBoardId(sessionBoardId);
                jiraSprint.setJiraBoardId(boardId);
            }
            this.jiraRepository.saveAllItems(boardSprints);
        }
        return boardSprints;
    }

    public List<JiraSprint> retrieveFutureSprintsForJiraBoardForEdit(String boardId, AlmAccount almAccount) {
        List<Object> boardSprints = new ArrayList<JiraSprint>();
        if (PropertyValidator.isValid((Object)boardId)) {
            boardSprints = this.importUtil.retrieveJiraBoardFutureSprints(boardId, almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword(), almAccount);
        }
        return boardSprints;
    }

    private JiraBoard retrieveJiraBoardDetails(JiraBoard jBoard, String[] jiraInfo) {
        if ((jBoard = this.importUtil.retrieveJiraBoardDetails(jBoard, jiraInfo[0], jiraInfo[1], jiraInfo[2], null)).getLocationProject() != null) {
            Query q = new Query();
            q.addCriteria((CriteriaDefinition)Criteria.where((String)"jiraId").is((Object)jBoard.getLocationProject().getJiraId()));
            JiraProject oldCopy = (JiraProject)this.customRepositoryImpl.getMongoTemplate().findOne(q, JiraProject.class);
            jBoard.getLocationProject().setDetailLoaded(Boolean.TRUE);
            jBoard.getLocationProject().setMongoId(oldCopy.getMongoId());
            this.jiraRepository.saveItem((Object)jBoard.getLocationProject());
        }
        this.jiraRepository.saveItem((Object)jBoard);
        return jBoard;
    }

    public JiraProject getJiraProjectDetails(JiraProject jiraProject, String url, String username, String password) {
        String result = this.importUtil.retrieveProjectDetails(jiraProject.getJiraId(), url, username, password, null);
        Gson gson = new Gson();
        JiraProject jProject = (JiraProject)gson.fromJson(result, JiraProject.class);
        jProject.setMongoId(jiraProject.getMongoId());
        jProject.setDetailLoaded(Boolean.TRUE);
        this.jiraRepository.saveItem((Object)jProject);
        return jProject;
    }

    public JiraProject retrieveJiraProjectWithDetails(String projectKeyOrId, String url, String username, String password, AlmAccount almAcc) {
        LOGGER.debug("retrieveJiraProjectWithDetails: projectKeyOrId: " + projectKeyOrId);
        String result = this.importUtil.retrieveProjectDetails(projectKeyOrId, url, username, password, almAcc);
        Gson gson = new Gson();
        JiraProject jProject = (JiraProject)gson.fromJson(result, JiraProject.class);
        if (PropertyValidator.isValid((Object)jProject)) {
            jProject.setDetailLoaded(Boolean.TRUE);
        }
        return jProject;
    }

    public List<JiraVersion> retrieveJiraVersions(String projectKey, AlmAccount almAcc) {
        return this.importUtil.retrieveJiraVersions(projectKey, almAcc.getUsername(), almAcc.getPassword(), almAcc);
    }

    public JiraVersion retrieveJiraVersion(String versionId, AlmAccount almAcc) {
        return this.importUtil.retrieveJiraVersion(versionId, almAcc);
    }

    public AlmAccUser getUserAlmCredntials(String almAccountId, User user) {
        if (PropertyValidator.isValid((Collection)(user = (User)this.userRepository.findOne((Serializable)((Object)user.getId()))).getAlmCredentials())) {
            for (AlmAccUser userCreds : user.getAlmCredentials()) {
                if (!almAccountId.equals(userCreds.getAlmAccId())) continue;
                return userCreds;
            }
        }
        return null;
    }

    public JiraFilter retrieveJiraFilter(String filterId, AlmAccount almAccount) throws ViztrendJiraException {
        return this.importUtil.retrieveFilterByJiraId(filterId, almAccount.getUsername(), almAccount.getPassword(), almAccount);
    }

    public Map<String, Object> retrievePaginatedJiraFilterList(AlmAccount almAccount, String searchText, int startAt) {
        LOGGER.trace("retrieveJiraFilterList: almAccount: " + almAccount);
        Gson gson = new Gson();
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        HashMap filtersList = new HashMap();
        AlmAccUser almAccUser = this.getUserAlmCredntials(almAccount.getId(), loggedInUser);
        String almUsername = "";
        String almPassword = "";
        if (PropertyValidator.isValid((Object)almAccUser)) {
            if (PropertyValidator.isValid((Object)almAccUser.getJiraOauthToken())) {
                almAccount.setJiraOauthToken(almAccUser.getJiraOauthToken());
                almAccount.setAdminAlmAcc(Boolean.valueOf(false));
                almAccount.setIsTaggedUser(Boolean.valueOf(true));
            } else {
                almAccount.setJiraOauthToken(null);
                almUsername = almAccUser.getAlmUsername();
                almPassword = almAccUser.getAlmPassword();
                almAccount.setIsTaggedUser(Boolean.valueOf(true));
                almAccount.setIsPatOnProfile(almAccUser.getIsPatOn());
            }
            almAccount.setIsTaggedUser(Boolean.valueOf(true));
        } else {
            almAccount.setAdminAlmAcc(Boolean.valueOf(true));
            almUsername = almAccount.getUsername();
            almPassword = almAccount.getPassword();
        }
        almAccount.setOAuthTokenOwnerUserId(loggedInUser.getId());
        List filters = new ArrayList();
        try {
            String[] jiraAccount = new String[]{almAccount.getUrl(), almUsername, almPassword};
            almAccount.setUsername(almUsername);
            almAccount.setPassword(almPassword);
            filtersList = this.importUtil.retrievePaginatedFilters(jiraAccount[0], jiraAccount[1], jiraAccount[2], almAccount, searchText, startAt);
            if (PropertyValidator.isValid((Object)filtersList)) {
                filters = (List)filtersList.get("filters");
                filterMap.put("filters", filters);
                filterMap.put("favourite", Boolean.toString(false));
                filterMap.put("totalCount", (Integer)filtersList.get("totalCount"));
            }
        }
        catch (ViztrendJiraException vJe) {
            if (PropertyValidator.isValid((Object)almAccUser)) {
                vJe.getAlmError().setType("Profile");
            }
            LOGGER.error("FAILED.. retrieveJiraFilterList ..ViztrendJiraException .", (Throwable)vJe);
            throw vJe;
        }
        catch (Exception vJe) {
            LOGGER.error("FAILED.. retrieveJiraFilterList .", (Throwable)vJe);
            throw vJe;
        }
        return filterMap;
    }

    public Map<String, Object> retrieveJiraFilterList(AlmAccount almAccount) {
        LOGGER.trace("retrieveJiraFilterList: almAccount: " + almAccount);
        Gson gson = new Gson();
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        AlmAccUser almAccUser = this.getUserAlmCredntials(almAccount.getId(), loggedInUser);
        String almUsername = "";
        String almPassword = "";
        if (PropertyValidator.isValid((Object)almAccUser)) {
            if (PropertyValidator.isValid((Object)almAccUser.getJiraOauthToken())) {
                almAccount.setJiraOauthToken(almAccUser.getJiraOauthToken());
                almAccount.setIsTaggedUser(Boolean.valueOf(true));
                almAccount.setAdminAlmAcc(Boolean.valueOf(false));
            } else {
                almAccount.setJiraOauthToken(null);
                almUsername = almAccUser.getAlmUsername();
                almPassword = almAccUser.getAlmPassword();
                almAccount.setIsTaggedUser(Boolean.valueOf(true));
                almAccount.setIsPatOnProfile(almAccUser.getIsPatOn());
            }
        } else {
            almAccount.setAdminAlmAcc(Boolean.valueOf(true));
            almUsername = almAccount.getUsername();
            almPassword = almAccount.getPassword();
        }
        almAccount.setOAuthTokenOwnerUserId(loggedInUser.getId());
        List filters = new ArrayList();
        try {
            String[] jiraAccount = new String[]{almAccount.getUrl(), almUsername, almPassword};
            almAccount.setUsername(almUsername);
            almAccount.setPassword(almPassword);
            filters = this.importUtil.retrieveAllFilters(jiraAccount[0], jiraAccount[1], jiraAccount[2], almAccount);
            filterMap.put("filters", filters);
            filterMap.put("favourite", Boolean.toString(false));
            this.retrieveJiraFields(almAccount, null);
        }
        catch (ViztrendJiraException vJe) {
            if (PropertyValidator.isValid((Object)almAccUser)) {
                vJe.getAlmError().setType("Profile");
            }
            LOGGER.error("FAILED.. retrieveJiraFilterList ..ViztrendJiraException .", (Throwable)vJe);
            throw vJe;
        }
        catch (Exception vJe) {
            LOGGER.error("FAILED.. retrieveJiraFilterList .", (Throwable)vJe);
            throw vJe;
        }
        return filterMap;
    }

    public List<JiraFilter> retrieveJiraFilterList4Refresh(AlmAccount almAccount) {
        LOGGER.trace("retrieveJiraFilterList: almAccount: " + almAccount);
        Gson gson = new Gson();
        ArrayList<JiraFilter> filters = new ArrayList();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        AlmAccUser almAccUser = this.getUserAlmCredntials(almAccount.getId(), loggedInUser);
        String almUsername = "";
        String almPassword = "";
        if (PropertyValidator.isValid((Object)almAccUser)) {
            if (PropertyValidator.isValid((Object)almAccUser.getJiraOauthToken())) {
                almAccount.setJiraOauthToken(almAccUser.getJiraOauthToken());
                almAccount.setIsTaggedUser(Boolean.valueOf(true));
                almAccount.setAdminAlmAcc(Boolean.valueOf(false));
            } else {
                almAccount.setJiraOauthToken(null);
                almUsername = almAccUser.getAlmUsername();
                almPassword = almAccUser.getAlmPassword();
                almAccount.setIsTaggedUser(Boolean.valueOf(true));
                almAccount.setIsPatOnProfile(almAccUser.getIsPatOn());
            }
        } else {
            almUsername = almAccount.getUsername();
            almPassword = almAccount.getPassword();
            almAccount.setAdminAlmAcc(Boolean.valueOf(true));
        }
        almAccount.setOAuthTokenOwnerUserId(loggedInUser.getId());
        String[] jiraAccount = new String[]{almAccount.getUrl(), almUsername, almPassword};
        almAccount.setUsername(almUsername);
        almAccount.setPassword(almPassword);
        filters = this.importUtil.retrieveAllFilters(jiraAccount[0], jiraAccount[1], jiraAccount[2], almAccount);
        return filters;
    }

    public List<JiraBoard> retrieveJiraBoardList(AlmAccount almAccount) {
        String[] jiraAccount = new String[]{almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword()};
        List boards = this.importUtil.retrieveJiraBoards(jiraAccount[0], jiraAccount[1], jiraAccount[2], almAccount);
        return boards;
    }

    public List<JiraBoard> retrieveJiraBoardsByProjectId(String projectKeyOrId, AlmAccount almAccount) throws Exception {
        List boards = this.importUtil.retrieveJiraBoardsByProjectId(projectKeyOrId, almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword(), almAccount);
        return boards;
    }

    public List<JiraProject> retrieveJiraProjectList(String[] jiraInfo) {
        List result = this.importUtil.retrieveJiraProjectsList(jiraInfo[0], jiraInfo[1], jiraInfo[2], null);
        return result;
    }

    public List<JiraProject> retrieveJiraProjectList(AlmAccount almAccount) {
        String[] jiraAccount = new String[]{almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword()};
        List result = this.importUtil.retrieveJiraProjectsList(jiraAccount[0], jiraAccount[1], jiraAccount[2], almAccount);
        return result;
    }

    public List<JiraIssue> retrieveDataAgainstJiraJql(String jql, AlmAccount almAcc, String itemTypeToBeConvertedInto, String flaggedField) {
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        Gson gson = new Gson();
        AlmAccUser almAccUser = this.planService.getUserAlmCredntials(almAcc.getId(), loggedInUser);
        String almUsername = "";
        String almPassword = "";
        if (PropertyValidator.isValid((Object)almAccUser)) {
            if (PropertyValidator.isValid((Object)almAccUser.getJiraOauthToken())) {
                almAcc.setJiraOauthToken(almAccUser.getJiraOauthToken());
                almAcc.setAdminAlmAcc(Boolean.valueOf(false));
            } else {
                almAcc.setJiraOauthToken(null);
                almUsername = almAccUser.getAlmUsername();
                almPassword = almAccUser.getAlmPassword();
                almAcc.setIsPatOnProfile(almAccUser.getIsPatOn());
            }
            almAcc.setIsTaggedUser(Boolean.valueOf(true));
        } else {
            almUsername = almAcc.getUsername();
            almPassword = almAcc.getPassword();
            almAcc.setAdminAlmAcc(Boolean.valueOf(true));
        }
        almAcc.setOAuthTokenOwnerUserId(loggedInUser.getId());
        ArrayList<JiraField> fields = new ArrayList<JiraField>();
        fields.add(this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountId("com.pyxis.greenhopper.jira:gh-sprint", almAcc.getId()));
        fields.add(almAcc.getStoryPointField());
        if (PropertyValidator.isValid((Object)almAcc.getNextGenStoryPointField())) {
            fields.add(almAcc.getNextGenStoryPointField());
        }
        fields.add(this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountId("com.pyxis.greenhopper.jira:gh-epic-label", almAcc.getId()));
        fields.add(this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountId("com.pyxis.greenhopper.jira:gh-epic-link", almAcc.getId()));
        fields.add(almAcc.getDueDateField());
        if (PropertyValidator.isValid((Object)flaggedField)) {
            fields.add(new JiraField(flaggedField, flaggedField, flaggedField));
        }
        String result = "";
        result = this.importUtil.retrievePagedJiraDataAgainstFilter(almAcc.getUrl(), jql, almUsername, almPassword, 0, 50, gson, fields, almAcc);
        if (PropertyValidator.isValid((Object)result)) {
            4 P = new /* Unavailable Anonymous Inner Class!! */;
            5 T = new /* Unavailable Anonymous Inner Class!! */;
            Collection issuesColection = (Collection)gson.fromJson(result, P.getType());
            Collection issuesColection2 = (Collection)gson.fromJson(result, T.getType());
            ArrayList<JiraIssue> jIssues = new ArrayList<JiraIssue>(issuesColection);
            ArrayList jIssues2 = new ArrayList(issuesColection2);
            if (PropertyValidator.isValid(jIssues)) {
                for (JiraIssue jIss : jIssues) {
                    JiraIssue2 iss2 = (JiraIssue2)jIssues2.get(jIssues2.indexOf(new JiraIssue2(jIss.getKey())));
                    if (!PropertyValidator.isValid((Object)iss2)) continue;
                    jIss.setMapFields(iss2.getFields());
                    jIss.setItemTypeTobeConvertedInto(itemTypeToBeConvertedInto);
                }
            }
            return jIssues;
        }
        return null;
    }

    private AlmAccount getJiraLoginForApi(AlmAccount alm, User loggedInUser) {
        AlmAccUser almAccUser = this.getUserAlmCredntials(alm.getId(), loggedInUser);
        alm.setUsernameForApi("");
        alm.setPasswordForApi("");
        if (PropertyValidator.isValid((Object)almAccUser)) {
            if (PropertyValidator.isValid((Object)almAccUser.getJiraOauthToken())) {
                alm.setJiraOauthToken(almAccUser.getJiraOauthToken());
                alm.setAdminAlmAcc(Boolean.valueOf(false));
            } else {
                alm.setJiraOauthToken(null);
                alm.setUsernameForApi(almAccUser.getAlmUsername());
                alm.setPasswordForApi(almAccUser.getAlmPassword());
                alm.setIsPatOnProfile(almAccUser.getIsPatOn());
            }
            alm.setIsTaggedUser(Boolean.valueOf(true));
        } else {
            alm.setUsernameForApi(alm.getUsername());
            alm.setPasswordForApi(alm.getPassword());
            alm.setAdminAlmAcc(Boolean.valueOf(true));
        }
        alm.setOAuthTokenOwnerUserId(loggedInUser.getId());
        return alm;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> retrieveDataAgainstJiraFilterForPreview(String filterJson, AlmAccount almAcc, Map<String, String> paramMap) {
        Gson gson = new Gson();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int startAt = 0;
        int pageSize = 100;
        JiraFilter filter = (JiraFilter)gson.fromJson(filterJson, JiraFilter.class);
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        if (PropertyValidator.isValid((Object)(almAcc = this.getJiraLoginForApi(almAcc, loggedInUser)).getUsernameForApi()) && PropertyValidator.isValid((Object)almAcc.getPasswordForApi())) {
            almAcc.setUsername(almAcc.getUsernameForApi());
            almAcc.setPassword(almAcc.getPasswordForApi());
        }
        HashSet<String> projectKeys = new HashSet<String>();
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<JiraIssue2> jiraIssues = new ArrayList<JiraIssue2>();
        Boolean flag = false;
        try {
            JSONObject typesObjectJSON = new JSONObject(paramMap.get("metaMap"));
            if (PropertyValidator.isValid((Object)typesObjectJSON) && typesObjectJSON.has("collabBoardflag")) {
                flag = (Boolean)typesObjectJSON.get("collabBoardflag");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        boolean isART = "releaseTrain".equals(paramMap.get("view"));
        boolean isLast = false;
        boolean isCloud = almAcc.cloud();
        String filterHierarchyLevel = paramMap.getOrDefault("filterHierarchyLevel", null);
        Integer totalRecord = 0;
        Integer jqlCount = 0;
        JiraSearchRequest result = new JiraSearchRequest(null, Boolean.valueOf(isLast));
        JiraSearch2 jiraSearch2 = new JiraSearch2();
        jiraSearch2.setNextPageToken(null);
        jiraSearch2.setIsLast(Boolean.valueOf(isLast));
        boolean skip = false;
        if (isCloud) {
            JSONObject bodyC = new JSONObject();
            bodyC.put("jql", (Object)filter.getJql());
            String count = this.importUtil.retrieveJiraResponse("/rest/api/3/search/approximate-count", almAcc, bodyC.toString());
            bodyC = null;
            if (PropertyValidator.isValid((Object)count) && (jqlCount = Integer.valueOf(Integer.parseInt(String.valueOf((bodyC = new JSONObject(count)).get("count"))))) < 1) {
                skip = true;
            }
        }
        do {
            Iterator iterator;
            block29: {
                String json;
                String endPoint;
                JSONObject body;
                if (paramMap.get("COMPARISON") != null) {
                    body = this.importUtil.buildPayloadForJiraSerach(filter.getJql(), null, pageSize, result.getNextPageToken(), false);
                    endPoint = JiraUtils.decideSearchAPI((String)"/rest/api/3/search/jql", (boolean)isCloud, (JSONObject)body, (int)startAt);
                    json = this.importUtil.retrieveJiraResponse(endPoint, almAcc, body.toString());
                    KendisUtils.pushProgressUpdates((String)"COMPARISON", (String)(paramMap.get("syncId") + "#" + paramMap.get("requestId")), (Object)json, (PushResponseRepository)this.pushResponseRepository, (boolean)true);
                    result = (JiraSearchRequest)gson.fromJson(json, JiraSearchRequest.class);
                    if (!isCloud) {
                        startAt += pageSize;
                        if (result.getTotal() != null) {
                            totalRecord = result.getTotal();
                        }
                    }
                    isLast = result.ended(isCloud, startAt, totalRecord.intValue());
                    continue;
                }
                if (!skip) {
                    body = this.importUtil.buildPayloadForJiraSerach(filter.getJql(), null, pageSize, jiraSearch2.getNextPageToken(), true);
                    endPoint = JiraUtils.decideSearchAPI((String)"/rest/api/3/search/jql", (boolean)isCloud, (JSONObject)body, (int)startAt);
                    json = this.importUtil.retrieveJiraResponse(endPoint, almAcc, body.toString());
                    jiraSearch2 = (JiraSearch2)gson.fromJson(json, JiraSearch2.class);
                    if (!isCloud) {
                        startAt += pageSize;
                        if (jiraSearch2.getTotal() != null) {
                            totalRecord = jiraSearch2.getTotal();
                        }
                    }
                    isLast = jiraSearch2.ended(isCloud, startAt, totalRecord.intValue());
                    if (isART) break;
                    if (PropertyValidator.isValid((Collection)jiraSearch2.getIssues())) {
                        iterator = jiraSearch2.getIssues().iterator();
                        break block29;
                    } else {
                        if (!PropertyValidator.isValid((Object)jiraSearch2) || PropertyValidator.isValid((Collection)jiraSearch2.getIssues()) || !PropertyValidator.isValid((Collection)jiraSearch2.getWarningMessages())) continue;
                        resultMap.put("error", jiraSearch2);
                        almAcc.setUsername(almAcc.getUsernameForApi());
                        almAcc.setPassword(almAcc.getPasswordForApi());
                        continue;
                    }
                }
                isLast = true;
                continue;
            }
            while (iterator.hasNext()) {
                JiraIssue2 jIss = (JiraIssue2)iterator.next();
                if (flag.booleanValue()) {
                    jiraIssues.add(jIss);
                    continue;
                }
                projectKeys.add(jIss.projectKey());
                ids.add(jIss.getId());
            }
        } while (!isLast);
        if (isCloud) {
            totalRecord = jqlCount;
        }
        List projectList = null;
        if (!isART) {
            projectList = this.importUtil.retrieveJiraProjectsListByKeys(almAcc.getUsernameForApi(), almAcc.getPasswordForApi(), almAcc, projectKeys);
        }
        HashSet projectKeysset = new HashSet(projectKeys);
        int matchedIssues = 0;
        int notMatchedIssue = 0;
        if (isART && filterHierarchyLevel != null) {
            String jql = filter.getJql();
            if ((jql.contains("issuetype") || jql.contains("type")) && !jql.contains(filterHierarchyLevel)) {
                notMatchedIssue = totalRecord;
            } else if (jql.contains(filterHierarchyLevel)) {
                matchedIssues = totalRecord;
            } else if (!jql.contains("issuetype")) {
                jql = "issuetype = \"" + filterHierarchyLevel + "\" AND " + filter.getJql();
                if (isCloud) {
                    JSONObject bodyC = new JSONObject();
                    bodyC.put("jql", (Object)jql);
                    String count = this.importUtil.retrieveJiraResponse("/rest/api/3/search/approximate-count", almAcc, bodyC.toString());
                    bodyC = null;
                    if (PropertyValidator.isValid((Object)count)) {
                        bodyC = new JSONObject(count);
                        matchedIssues = Integer.parseInt(String.valueOf(bodyC.get("count")));
                        notMatchedIssue = totalRecord - matchedIssues;
                    }
                } else {
                    JSONObject body = this.importUtil.buildPayloadForJiraSerach(jql, null, pageSize, null, true);
                    String endPoint = JiraUtils.decideSearchAPI((String)"/rest/api/3/search/jql", (boolean)isCloud, (JSONObject)body, (int)startAt);
                    String json = this.importUtil.retrieveJiraResponse(endPoint, almAcc, body.toString());
                    jiraSearch2 = (JiraSearch2)gson.fromJson(json, JiraSearch2.class);
                    matchedIssues = jiraSearch2.getTotal();
                    notMatchedIssue = totalRecord - matchedIssues;
                }
            }
        }
        if (flag.booleanValue()) {
            resultMap.put("jiraIssues", jiraIssues);
            resultMap.put("totalCount", totalRecord);
            return resultMap;
        }
        resultMap.put("itemIds", ids);
        resultMap.put("matchedCount", matchedIssues);
        resultMap.put("notMatchedCount", notMatchedIssue);
        resultMap.put("totalCount", totalRecord);
        resultMap.put("projectKeys", projectKeysset);
        resultMap.put("projects", projectList);
        return resultMap;
    }

    public Map<String, JiraSprint> retrieveJiraSprints(List<String> jiraIds, String almAccId) {
        HashMap<String, JiraSprint> result = new HashMap<String, JiraSprint>();
        try {
            AlmAccount almAcc = AlmUtils.getALMAcount((String)almAccId, (AlmAccountRepository)this.almAccountRepository);
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            AlmAccUser almAccUser = this.planService.getUserAlmCredntials(almAcc.getId(), loggedInUser);
            if (PropertyValidator.isValid((Object)almAccUser)) {
                if (PropertyValidator.isValid((Object)almAccUser.getJiraOauthToken())) {
                    almAcc.setJiraOauthToken(almAccUser.getJiraOauthToken());
                    almAcc.setAdminAlmAcc(Boolean.valueOf(false));
                } else {
                    almAcc.setJiraOauthToken(null);
                }
                almAcc.setIsTaggedUser(Boolean.valueOf(true));
            } else {
                almAcc.setAdminAlmAcc(Boolean.valueOf(true));
            }
            almAcc.setOAuthTokenOwnerUserId(loggedInUser.getId());
            Gson gson = new Gson();
            for (String sprintId : jiraIds) {
                try {
                    JiraSprint sprint = (JiraSprint)gson.fromJson(this.importUtil.retrieveJiraResponse("/rest/agile/1.0/sprint/" + sprintId, almAcc, ""), JiraSprint.class);
                    result.put(sprintId, sprint);
                }
                catch (ViztrendJiraException ve) {
                    JiraSprint temp = new JiraSprint();
                    temp.setName(gson.toJson((Object)ve.getAlmError()));
                    result.put("error_" + sprintId, temp);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while retrieveJQL ::   : " + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public void retrieveJQL(Map<String, String> param) {
        String syncId = param.get("syncId");
        String almAccId = param.get("almAccId");
        Gson gson = new Gson();
        String pushKey = "JQL";
        if (param.containsKey("pushKey")) {
            pushKey = param.get("pushKey");
        }
        try {
            AlmAccount almAcc = AlmUtils.getALMAcount((String)almAccId, (AlmAccountRepository)this.almAccountRepository);
            int startAt = 0;
            int totalRecord = 0;
            int pageSize = 100;
            JiraSearchRequest result = new JiraSearchRequest(null, Boolean.valueOf(false));
            User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
            AlmAccUser almAccUser = this.planService.getUserAlmCredntials(almAcc.getId(), loggedInUser);
            if (PropertyValidator.isValid((Object)almAccUser)) {
                if (PropertyValidator.isValid((Object)almAccUser.getJiraOauthToken())) {
                    almAcc.setJiraOauthToken(almAccUser.getJiraOauthToken());
                    almAcc.setAdminAlmAcc(Boolean.valueOf(false));
                } else {
                    almAcc.setJiraOauthToken(null);
                }
                almAcc.setIsTaggedUser(Boolean.valueOf(true));
            } else {
                almAcc.setAdminAlmAcc(Boolean.valueOf(true));
            }
            almAcc.setOAuthTokenOwnerUserId(loggedInUser.getId());
            JSONObject _body = null;
            String body = param.get("body");
            String endPoint = param.get("url");
            boolean isCloud = almAcc.cloud();
            if (PropertyValidator.isValid((Object)body)) {
                _body = new JSONObject(body);
                endPoint = JiraUtils.decideSearchAPI((String)endPoint, (boolean)isCloud, (JSONObject)_body, (int)0);
            }
            do {
                String payload = "";
                if (_body != null) {
                    if (isCloud) {
                        _body.put("nextPageToken", (Object)(result.getNextPageToken() == null ? null : result.getNextPageToken()));
                    } else {
                        _body.put("startAt", startAt);
                        _body.put("maxResults", pageSize);
                    }
                    payload = _body.toString();
                }
                String json = this.importUtil.retrieveJiraResponse(endPoint, almAcc, payload);
                KendisUtils.pushProgressUpdates((String)pushKey, (String)syncId, (Object)json, (PushResponseRepository)this.pushResponseRepository, (boolean)true);
                result = (JiraSearchRequest)gson.fromJson(json, JiraSearchRequest.class);
                if (isCloud) continue;
                startAt += pageSize;
                if (result.getTotal() == null) continue;
                totalRecord = result.getTotal();
            } while (!result.ended(isCloud, startAt, totalRecord));
        }
        catch (Exception e) {
            HashMap<String, String> exp = new HashMap<String, String>();
            exp.put("error", StringUtils.getTraceString((Throwable)e));
            if (e instanceof ViztrendJiraException) {
                exp.put("almError", (String)((ViztrendJiraException)((Object)e)).getAlmError());
            }
            LOGGER.error("Exception while retrieveJQL ::   : " + exp.get("error"));
            KendisUtils.pushProgressUpdates((String)pushKey, (String)syncId, (Object)gson.toJson(exp), (PushResponseRepository)this.pushResponseRepository, (boolean)true);
        }
        HashMap<String, Boolean> done = new HashMap<String, Boolean>();
        done.put("preview_done", true);
        KendisUtils.pushProgressUpdates((String)pushKey, (String)syncId, (Object)gson.toJson(done), (PushResponseRepository)this.pushResponseRepository, (boolean)false);
    }

    public void retrieveDataAgainstJiraFilter(JiraFilter filter, SessionBoard sessionBoard, Boolean isEnabler, HashSet<String> featuresAlreadyProcessed) {
    }

    private List<ItemJiraDependency> getFeatureDependencyIssues(JiraIssue jIssue, List<String> jiraLinkTypes, String sourceExternalId, List<ItemJiraDependency> dependenciesToSave, Map<String, Object> oldItemJiraDependencyMap, List<ItemJiraDependency> linksToBeDeleted, Map<String, Object> oldJiraIssueMap, List<String> logs) {
        ArrayList<ItemJiraDependency> itemJiraDependencies = new ArrayList<ItemJiraDependency>();
        List issueLinks = jIssue.getFields().getIssuelinks();
        Set<Object> oldLinksKeys = new HashSet();
        if (logs != null) {
            logs.add("Getting feature dependency issues.");
        }
        if (PropertyValidator.isValid(oldItemJiraDependencyMap)) {
            oldLinksKeys = oldItemJiraDependencyMap.keySet();
        }
        HashSet<String> newLinksKeys = new HashSet<String>();
        if (PropertyValidator.isValid((Collection)issueLinks) && PropertyValidator.isValid(jiraLinkTypes)) {
            for (String string : jiraLinkTypes) {
                String[] dependencyLinkTypeArray = string.split("-");
                String dependencyLinkTypeId = dependencyLinkTypeArray[0];
                String dependencyLinkTypeDirection = "";
                if (dependencyLinkTypeArray.length > 1) {
                    dependencyLinkTypeDirection = dependencyLinkTypeArray[1];
                }
                for (JiraIssueLink issueLink : issueLinks) {
                    ItemJiraDependency itemJiraDependency = null;
                    if (issueLink.getType().getId().equals(dependencyLinkTypeId)) {
                        if (logs != null) {
                            logs.add("ISSUE_LINK_TYPE_ID_MATCHED");
                        }
                        itemJiraDependency = new ItemJiraDependency();
                        if ("IN".equalsIgnoreCase(dependencyLinkTypeDirection)) {
                            if (PropertyValidator.isValid((Object)issueLink.getInwardIssue())) {
                                itemJiraDependency.setTargetJiraIssue(issueLink.getInwardIssue());
                            }
                        } else if ("OUT".equalsIgnoreCase(dependencyLinkTypeDirection)) {
                            if (PropertyValidator.isValid((Object)issueLink.getOutwardIssue())) {
                                itemJiraDependency.setTargetJiraIssue(issueLink.getOutwardIssue());
                            }
                        } else if ("".equalsIgnoreCase(dependencyLinkTypeDirection)) {
                            if (PropertyValidator.isValid((Object)issueLink.getInwardIssue())) {
                                itemJiraDependency.setTargetJiraIssue(issueLink.getInwardIssue());
                            }
                            if (PropertyValidator.isValid((Object)issueLink.getOutwardIssue())) {
                                itemJiraDependency.setTargetJiraIssue(issueLink.getOutwardIssue());
                            }
                        }
                        itemJiraDependency.setLinkType(issueLink.getType());
                        itemJiraDependency.setDirection(dependencyLinkTypeDirection);
                    }
                    if (!PropertyValidator.isValid(itemJiraDependency) || !PropertyValidator.isValid((Object)itemJiraDependency.getTargetJiraIssue())) continue;
                    if (logs != null) {
                        logs.add("TARGET_JIRA_ISSUE_SET_IN_ITEM_JIRA_DEPENDENCY");
                    }
                    itemJiraDependency.getTargetJiraIssue().setJiraParentId(jIssue.getJiraId());
                    itemJiraDependency.setJiraDependencyId(issueLink.getId());
                    itemJiraDependency.setSessionBoardId(jIssue.getSessionBoardId());
                    newLinksKeys.add(issueLink.getId());
                    if (PropertyValidator.isValid(oldItemJiraDependencyMap) && PropertyValidator.isValid((Object)oldItemJiraDependencyMap.get(issueLink.getId()))) {
                        ItemJiraDependency oldItemJiraDependency = (ItemJiraDependency)oldItemJiraDependencyMap.get(issueLink.getId());
                        if (oldJiraIssueMap != null) {
                            oldJiraIssueMap.put(oldItemJiraDependency.getTargetJiraIssue().getJiraId(), oldItemJiraDependency.getTargetJiraIssue());
                        }
                        oldItemJiraDependency.setTargetJiraIssue(itemJiraDependency.getTargetJiraIssue());
                        itemJiraDependencies.add(oldItemJiraDependency);
                        if (logs != null) {
                            logs.add("Old item jira dependency is valid and issue link id exists in map.");
                        }
                    } else {
                        itemJiraDependency.setRaisedOn(new Date());
                        itemJiraDependencies.add(itemJiraDependency);
                        if (logs != null) {
                            logs.add("Old item jira dependency does not exist or issue link id does not exist in map.");
                        }
                    }
                    if (dependenciesToSave == null) continue;
                    itemJiraDependency.setSourceExternaId(sourceExternalId);
                    itemJiraDependency.setTargetExternaId(itemJiraDependency.getTargetJiraIssue().getJiraId());
                    dependenciesToSave.add(itemJiraDependency);
                    if (logs == null) continue;
                    logs.add("Adding item jira dependencies in dependencies to save.");
                }
            }
            oldLinksKeys.removeAll(newLinksKeys);
        }
        for (String string : oldLinksKeys) {
            linksToBeDeleted.add((ItemJiraDependency)oldItemJiraDependencyMap.get(string));
        }
        return itemJiraDependencies;
    }

    public Map<String, Object> retrieveDataAgainstJiraFilter2(JiraFilter filter, String almConfigId, List<BacklogMappingLinks> childLinkMappings, String sessionBoardId, String syncId, String sessionId, Map<String, JiraFilter> jiraIssueFilterMap, boolean isBoardResync, Boolean isReadOnly, boolean validateFilter, boolean removeEmptyCards, ResyncParamsVO resyncParams) throws Exception {
        HashMap<String, Object> finalResult = new HashMap<String, Object>();
        if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext())) {
            LOGGER.debug("=============================================================================================================================");
            LOGGER.debug(" \t\t\t\t\t\t\t\t\tRESYNC PROCESS STARTED BY :: " + UserContextUtil.getUserContext().getUsername());
            LOGGER.debug("=============================================================================================================================");
        }
        if (PropertyValidator.isValid((Object)filter)) {
            ArrayList jiraStatuses = new ArrayList();
            AlmConfigurations almConfig = (AlmConfigurations)this.almConfigurationsRepository.findOne((Serializable)((Object)almConfigId));
            AlmAccount almAccount = almConfig.getAlmAccount();
            HashMap existingItemMap = null;
            if (resyncParams == null) {
                resyncParams = new ResyncParamsVO();
            }
            resyncParams.syncId = syncId;
            resyncParams.isReadOnly = Boolean.TRUE.equals(isReadOnly);
            resyncParams.almConfigurations = almConfig;
            resyncParams.sessionBoardId = sessionBoardId;
            resyncParams.removeEmptyCards = removeEmptyCards;
            resyncParams.jiraIssueFilterMap = jiraIssueFilterMap;
            resyncParams.filter = filter;
            resyncParams.newProjects = new LinkedHashSet();
            resyncParams.session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
            resyncParams.sessions = new ArrayList();
            resyncParams.sessions.add(resyncParams.session);
            resyncParams.validateFilter = validateFilter;
            resyncParams.itemTypeParent = Item.Type.Feature.name();
            resyncParams.itemTypeChild = Item.Type.UserStory.name();
            resyncParams.parentKeys = new HashSet();
            resyncParams.childKeys = new HashSet();
            boolean updateParentByEpicId = false;
            this.setupMetaForResync(resyncParams, almAccount);
            if (!resyncParams.liveItemSync.booleanValue()) {
                if (resyncParams.bucketSync.booleanValue()) {
                    if (resyncParams.isSmartSync && resyncParams.isReferesh && !resyncParams.isReadOnly) {
                        existingItemMap = new HashMap();
                    }
                    if (Boolean.TRUE.equals(resyncParams.session.getBucketEnabled()) && PropertyValidator.isValid((Object)resyncParams.session.getBuckets())) {
                        this.fetchBucketChildJiraData(resyncParams, almAccount, jiraStatuses);
                    }
                } else {
                    updateParentByEpicId = this.fetchParentChildJiraData(resyncParams, almAccount, childLinkMappings, existingItemMap);
                }
            }
            Object[] savedItems = new Object[3];
            if (!resyncParams.bucketSync.booleanValue()) {
                LOGGER.debug(" :: Before convertJiraIssuesToKendisItem..  ");
                HashMap<String, String> kendisIdsMap = new HashMap<String, String>();
                if (PropertyValidator.isValid(existingItemMap) && existingItemMap.size() > 0) {
                    for (String key : existingItemMap.keySet()) {
                        Item i = (Item)existingItemMap.get(key);
                        kendisIdsMap.put(i.getId(), i.getJiraId() == null ? i.getId() : i.getJiraId());
                    }
                }
                savedItems = this.convertJiraIssuesToKendisItem(resyncParams, existingItemMap, kendisIdsMap, jiraStatuses);
            }
            finalResult.put("features", savedItems);
            finalResult.put("count", savedItems[2]);
            finalResult.put("statuses", jiraStatuses);
            finalResult.put("almAccount", almAccount);
            if (updateParentByEpicId) {
                this.updateParentOfParentItems(resyncParams.getBoardId(), almAccount);
            }
        }
        return finalResult;
    }

    private Map<String, Status> getStatusMapFromStatuses(List<Status> statuses) {
        HashMap<String, Status> statusMap = new HashMap<String, Status>();
        for (Status status : statuses) {
            String statusKey = status.getItemType() + "_" + status.getJiraIssueTypeId() + "_" + status.getJiraStatusId() + "_" + status.getJiraProjKey();
            statusKey = status.getSessionId() == null && status.getSolutionId() != null ? status.getSolutionId() + "_" + statusKey : status.getSessionId() + "_" + statusKey;
            statusMap.put(statusKey, status);
        }
        return statusMap;
    }

    private Map<String, Status> getLinkStatusMapFromStatuses(List<Status> statuses) {
        HashMap<String, Status> statusMap = new HashMap<String, Status>();
        for (Status status : statuses) {
            if (PropertyValidator.isValid(statusMap.get(status.getCategory()))) continue;
            statusMap.put(status.getCategory(), status);
        }
        return statusMap;
    }

    public List<Item> retrieveAndSaveJiraDependencies(List<String> jiraIds, Collection<JiraIssue2> issues, SessionBoard sessionBoard, String syncId, String eventType, List<String> logs) {
        SecureUser secureUser;
        User loggedInUser;
        AlmAccount taggedAlmAccount;
        Gson gson = new Gson();
        int pageSize = 100;
        int startAt = 0;
        int totalRecord = 0;
        String jql = null;
        if (issues == null) {
            jql = " id IN ( " + String.join((CharSequence)",", jiraIds) + ") ";
        }
        JiraField issueLinkField = new JiraField("issuelinks", "issuelinks", "issuelinks");
        List parentItems = this.itemRepository.findBySessionBoardsIdInAndJiraIdIn(sessionBoard.getId(), jiraIds);
        ArrayList<JiraField> fields = new ArrayList<JiraField>();
        HashMap<String, Item> existingItemMap = new HashMap<String, Item>();
        fields.add(issueLinkField);
        ArrayList allParentJiraDependency = new ArrayList();
        ArrayList linksToBeDeleted = new ArrayList();
        if (PropertyValidator.isValid((Collection)parentItems) && logs != null) {
            logs.add("PARENT_ITEMS_FOUND_USING_SESSION_ID_AND_JIRA_IDS");
        }
        for (Item item : parentItems) {
            existingItemMap.put(item.getJiraId(), item);
        }
        HashMap<String, List> parentJiraDependencyMap = new HashMap<String, List>();
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionBoard.getSession().getId()));
        AlmAccount almAccount = ((AlmConfigurations)session.getAlmConfigurations().get(0)).getAlmAccount();
        if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && PropertyValidator.isValid((Object)(taggedAlmAccount = JiraUtils.getTaggedAlmUser((User)(loggedInUser = (User)(secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUserContextDTO().getContextMap().get("user")), (AlmAccount)almAccount)))) {
            almAccount = taggedAlmAccount;
        }
        boolean isLast = false;
        boolean isCloud = almAccount.cloud();
        JiraSearch2 jiraSearch2 = new JiraSearch2();
        jiraSearch2.setNextPageToken(null);
        jiraSearch2.setIsLast(Boolean.valueOf(isLast));
        do {
            if (jql == null) {
                pageSize = 0;
                isLast = true;
            } else {
                jiraSearch2 = this.importUtil.retrievePagedJiraDataAgainstFilter2(almAccount.getUrl(), jql, almAccount.getUsername(), almAccount.getPassword(), jiraSearch2.getNextPageToken(), startAt, pageSize, gson, fields, almAccount);
                if (!isCloud) {
                    startAt += pageSize;
                    if (jiraSearch2.getTotal() != null) {
                        totalRecord = jiraSearch2.getTotal();
                    }
                }
                isLast = jiraSearch2.ended(isCloud, startAt, totalRecord);
                issues = jiraSearch2.getIssues();
            }
            if (!PropertyValidator.isValid(issues)) continue;
            if (logs != null) {
                logs.add("JIRA_DATA_RETRIEVED_AGAINST_JIRA_IDS");
            }
            totalRecord += issues.size();
            for (JiraIssue2 jiraIssue2 : issues) {
                JiraIssue jiraIssue = new JiraIssue();
                jiraIssue.setFields(new JiraIssueFields());
                jiraIssue.setJiraId(jiraIssue2.getId());
                jiraIssue.setId(jiraIssue2.getId());
                6 P = new /* Unavailable Anonymous Inner Class!! */;
                Collection issueLinks = (Collection)gson.fromJson(gson.toJson(jiraIssue2.getFields().get("issuelinks")), P.getType());
                if (PropertyValidator.isValid((Collection)issueLinks)) {
                    if (logs != null) {
                        logs.add("Searching for issue links: " + WebhookActivityUtil.getInstance().getUniqueLinkTypes(issueLinks));
                    }
                    if (logs != null) {
                        logs.add("ISSUE_LINKS_PRESENT_IN_JIRA_DATA");
                    }
                    jiraIssue.getFields().setIssuelinks(new ArrayList(issueLinks));
                }
                jiraIssue.setSessionBoardId(sessionBoard.getId());
                Item item = (Item)existingItemMap.get(jiraIssue.getJiraId());
                HashMap<String, ItemJiraDependency> oldItemJiraDependencyMap = new HashMap<String, ItemJiraDependency>();
                if (PropertyValidator.isValid((Object)item) && PropertyValidator.isValid((Collection)item.getJiraDependencies())) {
                    for (ItemJiraDependency dependency : item.getJiraDependencies()) {
                        if (!PropertyValidator.isValid((Object)dependency)) continue;
                        oldItemJiraDependencyMap.put(dependency.getJiraDependencyId(), dependency);
                    }
                }
                List dependencyIssues = this.getFeatureDependencyIssues(jiraIssue, session.getJiraLinkTypes(), null, null, oldItemJiraDependencyMap, linksToBeDeleted, new HashMap(), logs);
                if (!PropertyValidator.isValid(existingItemMap.get(jiraIssue.getJiraId()))) continue;
                parentJiraDependencyMap.put(((Item)existingItemMap.get(jiraIssue.getJiraId())).getId(), dependencyIssues);
            }
        } while (!isLast);
        for (Item item : parentItems) {
            List jiraDependencies = (List)parentJiraDependencyMap.get(item.getId());
            if (!PropertyValidator.isValid((Collection)jiraDependencies)) continue;
            for (ItemJiraDependency itemJiraDependency : jiraDependencies) {
                if (!PropertyValidator.isValid((Object)itemJiraDependency.getId())) {
                    itemJiraDependency.setId(ObjectId.get().toString());
                }
                itemJiraDependency.setSourceItemId(item.getId());
                itemJiraDependency.setTenant(almAccount.getTenant());
                if (!existingItemMap.containsKey(itemJiraDependency.getTargetJiraIssue().getJiraId())) continue;
                if (logs != null) {
                    logs.add("EXISTING_ITEM_MAP_CONTAINS_TARGET_JIRA_ISSUE_ID");
                }
                itemJiraDependency.setTargetItemId(((Item)existingItemMap.get(itemJiraDependency.getTargetJiraIssue().getJiraId())).getId());
            }
            item.setJiraDependencies(jiraDependencies);
            allParentJiraDependency.addAll(jiraDependencies);
        }
        if (PropertyValidator.isValid(allParentJiraDependency)) {
            this.itemJiraDependencyRepository.save(allParentJiraDependency);
        }
        if (PropertyValidator.isValid(linksToBeDeleted)) {
            this.itemJiraDependencyRepository.delete(linksToBeDeleted);
        }
        if (PropertyValidator.isValid((Collection)parentItems)) {
            this.itemRepository.save((Iterable)parentItems);
        }
        return parentItems;
    }

    public List<Item> retrieveAndSaveJiraDependenciesForSolutionBoard(List<Item> parentItems, AlmAccount almAccount, List<String> jiraLinkTypes, List<String> jiraIds, SessionBoard sessionBoard, String syncId, String eventType) {
        SecureUser secureUser;
        User loggedInUser;
        AlmAccount taggedAlmAccount;
        String jql = " id IN ( " + String.join((CharSequence)",", jiraIds) + ") ";
        Gson gson = new Gson();
        int pageSize = 100;
        int startAt = 0;
        int totalRecord = 0;
        JiraField issueLinkField = new JiraField("issuelinks", "issuelinks", "issuelinks");
        ArrayList<JiraField> fields = new ArrayList<JiraField>();
        fields.add(issueLinkField);
        ArrayList allParentJiraDependency = new ArrayList();
        ArrayList linksToBeDeleted = new ArrayList();
        HashMap<String, Item> existingItemMap = new HashMap<String, Item>();
        for (Item item : parentItems) {
            existingItemMap.put(item.getJiraId(), item);
        }
        HashMap<String, List> parentJiraDependencyMap = new HashMap<String, List>();
        if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && PropertyValidator.isValid((Object)(taggedAlmAccount = JiraUtils.getTaggedAlmUser((User)(loggedInUser = (User)(secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUserContextDTO().getContextMap().get("user")), (AlmAccount)almAccount)))) {
            almAccount = taggedAlmAccount;
        }
        boolean isLast = false;
        boolean isCloud = almAccount.cloud();
        JiraSearch2 jiraSearch2 = new JiraSearch2();
        jiraSearch2.setNextPageToken(null);
        jiraSearch2.setIsLast(Boolean.valueOf(isLast));
        do {
            jiraSearch2 = this.importUtil.retrievePagedJiraDataAgainstFilter2(almAccount.getUrl(), jql, almAccount.getUsername(), almAccount.getPassword(), jiraSearch2.getNextPageToken(), startAt, pageSize, gson, fields, almAccount);
            if (!isCloud) {
                startAt += pageSize;
                if (jiraSearch2.getTotal() != null) {
                    totalRecord = jiraSearch2.getTotal();
                }
            }
            isLast = jiraSearch2.ended(isCloud, startAt, totalRecord);
            if (!PropertyValidator.isValid((Collection)jiraSearch2.getIssues())) continue;
            totalRecord += jiraSearch2.getIssues().size();
            for (JiraIssue2 jiraIssue2 : jiraSearch2.getIssues()) {
                JiraIssue jiraIssue = new JiraIssue();
                jiraIssue.setFields(new JiraIssueFields());
                jiraIssue.setJiraId(jiraIssue2.getId());
                jiraIssue.setId(jiraIssue2.getId());
                7 P = new /* Unavailable Anonymous Inner Class!! */;
                Collection issueLinks = (Collection)gson.fromJson(gson.toJson(jiraIssue2.getFields().get("issuelinks")), P.getType());
                if (PropertyValidator.isValid((Collection)issueLinks)) {
                    jiraIssue.getFields().setIssuelinks(new ArrayList(issueLinks));
                }
                if (sessionBoard != null) {
                    jiraIssue.setSessionBoardId(sessionBoard.getId());
                }
                Item item = (Item)existingItemMap.get(jiraIssue.getJiraId());
                HashMap<String, ItemJiraDependency> oldItemJiraDependencyMap = new HashMap<String, ItemJiraDependency>();
                if (PropertyValidator.isValid((Object)item) && PropertyValidator.isValid((Collection)item.getJiraDependencies())) {
                    for (ItemJiraDependency dependency : item.getJiraDependencies()) {
                        if (!PropertyValidator.isValid((Object)dependency)) continue;
                        oldItemJiraDependencyMap.put(dependency.getJiraDependencyId(), dependency);
                    }
                }
                List dependencyIssues = this.getFeatureDependencyIssues(jiraIssue, jiraLinkTypes, null, null, oldItemJiraDependencyMap, linksToBeDeleted, new HashMap(), null);
                if (!PropertyValidator.isValid(existingItemMap.get(jiraIssue.getJiraId()))) continue;
                parentJiraDependencyMap.put(((Item)existingItemMap.get(jiraIssue.getJiraId())).getId(), dependencyIssues);
            }
        } while (!isLast);
        for (Item item : parentItems) {
            List jiraDependencies = (List)parentJiraDependencyMap.get(item.getId());
            if (!PropertyValidator.isValid((Collection)jiraDependencies)) continue;
            for (ItemJiraDependency itemJiraDependency : jiraDependencies) {
                if (!PropertyValidator.isValid((Object)itemJiraDependency.getId())) {
                    itemJiraDependency.setId(ObjectId.get().toString());
                }
                itemJiraDependency.setSourceItemId(item.getId());
                itemJiraDependency.setTenant(almAccount.getTenant());
                if (!existingItemMap.containsKey(itemJiraDependency.getTargetJiraIssue().getJiraId())) continue;
                itemJiraDependency.setTargetItemId(((Item)existingItemMap.get(itemJiraDependency.getTargetJiraIssue().getJiraId())).getId());
            }
            item.setJiraDependencies(jiraDependencies);
            allParentJiraDependency.addAll(jiraDependencies);
        }
        if (PropertyValidator.isValid(allParentJiraDependency)) {
            this.itemJiraDependencyRepository.save(allParentJiraDependency);
        }
        if (PropertyValidator.isValid(linksToBeDeleted)) {
            this.itemJiraDependencyRepository.delete(linksToBeDeleted);
        }
        if (PropertyValidator.isValid(parentItems)) {
            this.itemRepository.save(parentItems);
        }
        return parentItems;
    }

    public void saveLinksInJira(Item savedItem, String[] linkType, List<String> targetJiraIds, HashMap<String, Object> mapSourceTarget, String syncId, String requestId, User loggedInUser) {
        String almAccountId = ((AlmConfigurations)((SessionBoard)savedItem.getSessionBoards().get(0)).getSession().getAlmConfigurations().get(0)).getAlmAccount().getId();
        String outwardIssue = "";
        String inwardIssue = "";
        String type = "";
        String sourceId = null;
        if (PropertyValidator.isValid((Object)savedItem.getJiraId())) {
            sourceId = savedItem.getJiraId();
        }
        if (PropertyValidator.isValid((String[])linkType) && linkType.length < 2) {
            inwardIssue = sourceId;
        } else if (PropertyValidator.isValid((Object)linkType[1]) && "OUT".equals(linkType[1])) {
            inwardIssue = sourceId;
        } else {
            outwardIssue = sourceId;
        }
        type = linkType[0];
        for (String targetJiraId : targetJiraIds) {
            if (PropertyValidator.isValid((Object)outwardIssue) && outwardIssue.equals(sourceId)) {
                inwardIssue = targetJiraId;
            } else {
                outwardIssue = targetJiraId;
            }
            if (PropertyValidator.isValid((Object)sourceId) && PropertyValidator.isValid((Object)targetJiraId) && PropertyValidator.isValid((Object)type)) {
                try {
                    this.planService.createIssueLinkInJira2(inwardIssue, outwardIssue, type, almAccountId, syncId);
                }
                catch (ViztrendJiraException e) {
                    LOGGER.error("Error in /save/links.", (Object)StringUtils.getTraceString((Throwable)e));
                }
            }
            LOGGER.debug(targetJiraId + ",");
        }
        targetJiraIds.add(sourceId);
        List items = this.retrieveAndSaveJiraDependencies(targetJiraIds, null, (SessionBoard)savedItem.getSessionBoards().get(0), syncId, "ADD", null);
        if (PropertyValidator.isValid((Collection)items)) {
            ArrayList<ItemLink> linksToUpdate = new ArrayList<ItemLink>();
            for (Item item : items) {
                if (!item.getId().equals(savedItem.getId()) || !PropertyValidator.isValid((Collection)item.getJiraDependencies())) continue;
                for (ItemJiraDependency jD : item.getJiraDependencies()) {
                    ItemLink link;
                    if (!PropertyValidator.isValid((Object)jD)) continue;
                    String jdLinkType = jD.getLinkType().getJiraId() + "-" + jD.getDirection();
                    if (PropertyValidator.isValid((Object)mapSourceTarget.get(jD.getSourceItemId() + "-" + jD.getTargetItemId()))) {
                        link = (ItemLink)mapSourceTarget.get(jD.getSourceItemId() + "-" + jD.getTargetItemId());
                        if (!jdLinkType.equals(link.getType())) continue;
                        link.setAlmLinkId(jD.getJiraDependencyId());
                        linksToUpdate.add(link);
                        continue;
                    }
                    if (!PropertyValidator.isValid((Object)mapSourceTarget.get(jD.getTargetItemId() + "-" + jD.getSourceItemId())) || !jdLinkType.equals((link = (ItemLink)mapSourceTarget.get(jD.getTargetItemId() + "-" + jD.getSourceItemId())).getType())) continue;
                    link.setAlmLinkId(jD.getJiraDependencyId());
                    linksToUpdate.add(link);
                }
            }
            this.customRepositoryImpl.updateMultipleItemLinkOnAlmLinking(linksToUpdate);
            JSONObject pushJson = new JSONObject();
            try {
                ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
                String itemLinks = ow.writeValueAsString(linksToUpdate);
                String itemsString = ow.writeValueAsString((Object)items);
                pushJson.put("itemLink", (Object)itemLinks);
                pushJson.put("sourceJiraId", (Object)sourceId);
                pushJson.put("items", (Object)itemsString);
                pushJson.put("metaMap", true);
                if (PropertyValidator.isValid((Object)requestId)) {
                    this.pushResponseRepository.save((Object)new PushResponse(requestId, pushJson.toString(), Boolean.valueOf(true)));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    public List<Item>[] convertJiraIssuesToKendisItem(AlmConfigurations almConfigurations, String sessionBoardId, String jiraFilterId, String syncId, IssueType issueType, Session session, Map<String, JiraFilter> jiraIssueFilterMap) {
        return null;
    }

    public void updateParentOfParentItems(String boardId, AlmAccount almAccount) {
        Gson gson = new Gson();
        ArrayList subset = new ArrayList();
        ArrayList<JiraField> fields = new ArrayList<JiraField>();
        HashMap relation = new HashMap();
        fields.add(new JiraField(JiraField.FIXED.summary.name(), JiraField.FIXED.summary.name(), JiraField.FIXED.summary.name()));
        fields.add(new JiraField(JiraField.FIXED.status.name(), JiraField.FIXED.status.name(), JiraField.FIXED.status.name()));
        fields.add(new JiraField(JiraField.FIXED.issuetype.name(), JiraField.FIXED.issuetype.name(), JiraField.FIXED.issuetype.name()));
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)almAccount.getTenant()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is((Object)new ObjectId(boardId)));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"jiraFieldByKey.parent.epicId").exists(true));
        query.fields().include("id");
        query.fields().include("jiraId");
        query.fields().include("jiraKey");
        query.fields().include("jiraFieldByKey");
        List items = this.mongoTemplate.find(query, Item.class, KendisUtils.dbName(Item.class));
        subset.add(new HashSet());
        for (Item item : items) {
            String parentId;
            Map parent;
            if (item.getJiraFieldByKey() == null || (parent = (Map)item.getJiraFieldByKey().get(JiraField.FIXED.parent.name())) == null || !PropertyValidator.isValid((Object)(parentId = (String)parent.get("epicId")))) continue;
            if (((Set)subset.get(subset.size() - 1)).size() == 100) {
                subset.add(new HashSet());
            }
            ((Set)subset.get(subset.size() - 1)).add(parentId);
            if (relation.get(parentId) == null) {
                relation.put(parentId, new HashSet());
            }
            ((Set)relation.get(parentId)).add(new ObjectId(item.getId()));
        }
        for (Set set : subset) {
            if (set.size() <= 0) continue;
            String jql = "ID in (" + String.join((CharSequence)",", set) + ")";
            int pageSize = 100;
            int startAt = 0;
            int totalRecord = 0;
            boolean isLast = false;
            Boolean isCloud = almAccount.cloud();
            JiraSearch2 result = new JiraSearch2();
            result.setNextPageToken(null);
            result.setIsLast(Boolean.valueOf(isLast));
            result = this.importUtil.retrievePagedJiraDataAgainstFilter2(almAccount.getUrl(), jql, almAccount.getUsername(), almAccount.getPassword(), result.getNextPageToken(), startAt, pageSize, gson, fields, almAccount);
            if (!isCloud.booleanValue()) {
                startAt += pageSize;
                if (result.getTotal() != null) {
                    totalRecord = result.getTotal();
                }
            }
            isLast = result.ended(isCloud.booleanValue(), startAt, totalRecord);
            List issues = result.getIssues();
            for (JiraIssue2 issue : issues) {
                Set itemIds = null;
                if (relation.get(issue.getId()) != null) {
                    itemIds = (Set)relation.get(issue.getId());
                } else if (relation.get(issue.getKey()) != null) {
                    itemIds = (Set)relation.get(issue.getKey());
                }
                if (!PropertyValidator.isValid((Collection)itemIds)) continue;
                Update update = new Update();
                query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)itemIds));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)almAccount.getTenant()));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is((Object)new ObjectId(boardId)));
                update.set("jiraFieldByKey.parent", (Object)issue.toMap());
                this.mongoTemplate.updateMulti(query, update, Item.class);
            }
        }
    }

    public boolean fetchParentChildJiraData(ResyncParamsVO resyncParams, AlmAccount almAccount, List<BacklogMappingLinks> childLinkMappings, Map<String, Item> existingItemMap) {
        JiraIssue jiraIssue;
        almAccount = resyncParams.almConfigurations.getAlmAccount();
        Map jiraIdsMap = null;
        HashMap projectKeysMap = new HashMap();
        HashSet<String> projectKeys = new HashSet<String>();
        HashSet<String> parentPids = new HashSet<String>();
        JiraIssueLinkType epicChildsLinkType = new JiraIssueLinkType("+1", "", almAccount.getJiraEpicLinkLabel(), almAccount.getJiraEpicLinkLabel(), almAccount.getJiraEpicLinkLabel(), "UP");
        JiraIssueLinkType synapseRTChildsLinkType = new JiraIssueLinkType("synapseRT", "", "synapseRT (Parent-Child)", "synapseRT", "synapseRT", "synapseRT");
        synapseRTChildsLinkType.setId("synapseRT");
        resyncParams.uplevel = null;
        if (resyncParams.session != null && Boolean.TRUE.equals(resyncParams.session.getJiraFeatureParentEnabled())) {
            resyncParams.uplevel = new ArrayList();
            ArrayList<JiraIssueLinkType> p1 = new ArrayList<JiraIssueLinkType>();
            p1.add(new JiraIssueLinkType());
            ((JiraIssueLinkType)p1.get(0)).putJiraIssueLinkType(resyncParams.session.getJiraFeatureParentLinkType(), Boolean.valueOf(false));
            resyncParams.uplevel.add(new BacklogMappingLinks(p1, null));
        }
        boolean byPassChildLink = false;
        boolean updateParentByEpicId = false;
        boolean anyFilter = false;
        String filterKey = null;
        if (resyncParams.session != null && "nexus".equals(resyncParams.session.getSessionType())) {
            byPassChildLink = true;
        }
        resyncParams.byPassChildSave = !resyncParams.isReferesh && resyncParams.isReadOnly && resyncParams.ignoreChild;
        resyncParams.backlogAlmIds = new HashMap();
        HashSet parentLinkFields = new HashSet();
        HashSet featureChildIds = new HashSet();
        HashSet epicIds = new HashSet();
        HashSet parentLinkIds = new HashSet();
        if (PropertyValidator.isValid((Object)resyncParams.filter.getId()) && !resyncParams.filter.getId().contains("AddExisting")) {
            filterKey = resyncParams.filter.getId();
            anyFilter = true;
        }
        Gson gson = new Gson();
        int startAt = 0;
        int pageSize = 100;
        int totalRecord = 0;
        int itemsSync = 0;
        int counted = 0;
        resyncParams.backlogParentId = new HashMap();
        resyncParams.backlogParentId.put(resyncParams.getBoardId(), new HashMap());
        boolean useChunks = false;
        String fql = resyncParams.filter.getJql();
        String syncingGap = null;
        ArrayList<String> debug = new ArrayList<String>();
        if (PropertyValidator.isValid((Collection)resyncParams.filter.getIssueKeys())) {
            pageSize = 1;
            totalRecord = resyncParams.filter.getIssueKeys().size();
            useChunks = true;
        }
        if (resyncParams.isSmartSync && "".equals(syncingGap = resyncParams.filter.lastUpdate())) {
            syncingGap = null;
        }
        boolean isLast = false;
        boolean isCloud = almAccount.cloud();
        String nextPageToken = null;
        do {
            Integer total = 0;
            JiraSearch2 result = null;
            if (useChunks) {
                if (counted < resyncParams.filter.getIssueKeys().size()) {
                    List keys = (List)resyncParams.filter.getIssueKeys().get(counted);
                    fql = "key in (" + String.join((CharSequence)",", keys) + ")";
                    if (resyncParams.isSmartSync) {
                        fql = JiraUtils.smartJQL((String)fql, (String)syncingGap, (Collection)keys);
                    }
                    result = this.importUtil.retrievePagedJiraDataAgainstFilter2(almAccount.getUrl(), fql, almAccount.getUsername(), almAccount.getPassword(), nextPageToken, startAt, keys.size(), gson, resyncParams.fields, almAccount);
                    nextPageToken = result.getNextPageToken();
                    counted += pageSize;
                    startAt += pageSize;
                    if (result.getIssues() != null) {
                        total = total + result.getIssues().size();
                    }
                    isLast = result.ended(false, counted, totalRecord);
                }
            } else {
                if (resyncParams.isSmartSync) {
                    fql = JiraUtils.smartJQL((String)fql, (String)syncingGap, null);
                }
                result = this.importUtil.retrievePagedJiraDataAgainstFilter2(almAccount.getUrl(), fql, almAccount.getUsername(), almAccount.getPassword(), nextPageToken, startAt, pageSize, gson, resyncParams.fields, almAccount);
                nextPageToken = result.getNextPageToken();
                counted += pageSize;
                startAt += pageSize;
                if (!isCloud && result.getTotal() != null) {
                    totalRecord = result.getTotal();
                }
                if (result.getIssues() != null) {
                    total = total + result.getIssues().size();
                }
                isLast = result.ended(isCloud, startAt, totalRecord);
            }
            if (debug != null) {
                debug.add("jql [" + resyncParams.filter.getId() + "] for parent : " + fql);
            }
            HashMap epicKeyJiraIdMap = new HashMap();
            HashMap parentLinkKeyJiraIdMap = new HashMap();
            if (PropertyValidator.isValid(result) && PropertyValidator.isValid((Collection)result.getWarningMessages())) {
                ArrayList<String> deletedJiraItemKeys = new ArrayList<String>();
                for (String error : result.getWarningMessages()) {
                    if (error.indexOf("'key'") <= -1) continue;
                    String jiraKey = error.substring(error.indexOf(" '") + 2, error.indexOf("' "));
                    if (resyncParams != null && resyncParams.checkedKeyForDEL != null && !Boolean.TRUE.equals(resyncParams.checkedKeyForDEL.get(jiraKey))) continue;
                    deletedJiraItemKeys.add(jiraKey);
                }
                if (PropertyValidator.isValid(deletedJiraItemKeys) && !resyncParams.isReadOnly) {
                    this.itemRepository.deleteBySessionBoardsInAndJiraKeyInAndJiraIdIsNotNullAndParentIsNull(resyncParams.getBoardId(), deletedJiraItemKeys);
                }
            }
            if (PropertyValidator.isValid((Collection)result.getIssues())) {
                itemsSync = counted + result.getIssues().size();
                List jIssues2 = result.getIssues();
                for (JiraIssue2 jiraIssue2 : jIssues2) {
                    if (jiraIdsMap != null && jiraIdsMap.containsKey(jiraIssue2.getId())) {
                        jiraIdsMap.remove(jiraIssue2.getId());
                        continue;
                    }
                    jiraIssue = jiraIssue2.getConvertedJiraIssue();
                    if (anyFilter) {
                        jiraIssue.setJiraFilterId(resyncParams.filter.getId());
                    } else if (PropertyValidator.isValid((Object)resyncParams.jiraIssueFilterMap) && !resyncParams.jiraIssueFilterMap.isEmpty()) {
                        JiraFilter jfil = (JiraFilter)resyncParams.jiraIssueFilterMap.get(jiraIssue.getJiraId());
                        if (PropertyValidator.isValid((Collection)jfil.getFeatureLinkMappings())) {
                            childLinkMappings = new ArrayList<BacklogMappingLinks>();
                            childLinkMappings.addAll(jfil.getFeatureLinkMappings());
                        }
                        jiraIssue.setJiraFilterId(jfil.getId());
                    }
                    jiraIssue.setItemTypeTobeConvertedInto(resyncParams.itemTypeParent);
                    String projectKey = jiraIssue.getFields().getProject().getKey();
                    if (resyncParams.sessionBoardId != null) {
                        if (resyncParams.filter.isEnabler()) {
                            jiraIssue.setIsEnabler(Boolean.TRUE);
                        }
                        jiraIssue.setSessionBoardId(resyncParams.sessionBoardId);
                        Object parent = resyncParams.findParent(projectKey, null, (Map)jiraIssue.getMapFields());
                        if (!resyncParams.isReadOnly && parent != null && parent instanceof Map && ((Map)parent).get("epicId") != null) {
                            updateParentByEpicId = true;
                        }
                    } else if (resyncParams.solutionBoard != null) {
                        jiraIssue.setSolutionBoardId(resyncParams.solutionBoard.getId());
                    }
                    if (!byPassChildLink) {
                        resyncParams.processForChildren(jiraIssue2.getKey(), jiraIssue2.getId(), projectKey, jiraIssue2.issuelinks(), almAccount, epicChildsLinkType, childLinkMappings, epicIds, featureChildIds, parentLinkIds, parentLinkFields, projectKeysMap, parentLinkKeyJiraIdMap, epicKeyJiraIdMap, null, this.importUtil);
                    }
                    projectKeys.add(projectKey);
                    parentPids.add(projectKey);
                    resyncParams.jiraIssuesParent.add(jiraIssue);
                    resyncParams.backlogAlmIds.put(jiraIssue.getKey(), jiraIssue.getId());
                    resyncParams.backlogAlmIds.put(jiraIssue.getId(), jiraIssue.getId());
                    if (resyncParams.parentKeys == null) continue;
                    resyncParams.parentKeys.add(jiraIssue.getKey());
                }
                LOGGER.debug(" :: Before Saving JiraIssues.. ");
            }
            HashMap<String, Integer> progressBar = new HashMap<String, Integer>();
            progressBar.put("total", total);
            progressBar.put("completed", itemsSync);
            ObjectMapper mapper = new ObjectMapper();
            try {
                if (!anyFilter) continue;
                KendisUtils.pushProgressUpdates((String)"ResyncProgress", (String)resyncParams.syncId, (Object)mapper.writeValueAsString(progressBar), (PushResponseRepository)this.pushResponseRepository, (boolean)true);
            }
            catch (JsonProcessingException e) {
                String err = this.printResyncExp((Exception)((Object)e), gson, resyncParams, almAccount, filterKey);
                LOGGER.debug(" :: JsonProcessingException ..  " + err);
            }
        } while (!isLast);
        LinkedList jqls = new LinkedList();
        if (!resyncParams.byPassChildSave || debug != null) {
            if (resyncParams.isSmartSync && resyncParams.isReferesh && existingItemMap != null) {
                resyncParams.isAlmBacklog = true;
                resyncParams.isSmartSync = false;
                String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
                HashSet parenJiraIds = new HashSet();
                Map map = this.findJiraItems(tenant, Item.Type.Feature.name(), resyncParams, parenJiraIds, null);
                existingItemMap.putAll(map);
                resyncParams.processForChildren(null, null, "", null, almAccount, epicChildsLinkType, childLinkMappings, epicIds, featureChildIds, parentLinkIds, parentLinkFields, projectKeysMap, null, null, null, this.importUtil);
                resyncParams.isAlmBacklog = false;
                resyncParams.isSmartSync = true;
                epicIds.addAll(parenJiraIds);
                parentLinkIds.addAll(parenJiraIds);
            }
            resyncParams.setChildQueries(syncingGap, jqls, epicIds, featureChildIds, parentLinkIds, parentLinkFields);
            if (debug != null) {
                debug.add("jql [" + resyncParams.filter.getId() + "] for childern : " + jqls.toString());
            }
        }
        if (!byPassChildLink && !resyncParams.byPassChildSave) {
            Map parenChildMap = (Map)resyncParams.backlogParentId.get(resyncParams.getBoardId());
            while (!jqls.isEmpty()) {
                String jql = ((StringBuilder)jqls.pop()).toString();
                if (!PropertyValidator.isValid((Object)jql) || jql.equals("")) continue;
                startAt = 0;
                pageSize = 100;
                totalRecord = 0;
                boolean isLast2 = false;
                JiraSearch2 result = new JiraSearch2();
                result.setNextPageToken(null);
                result.setIsLast(Boolean.valueOf(isLast2));
                do {
                    result = this.importUtil.retrievePagedJiraDataAgainstFilter2(almAccount.getUrl(), jql, almAccount.getUsername(), almAccount.getPassword(), result.getNextPageToken(), startAt, pageSize, gson, resyncParams.fields, almAccount);
                    if (!isCloud) {
                        startAt += pageSize;
                        if (result.getTotal() != null) {
                            totalRecord = result.getTotal();
                        }
                    }
                    isLast2 = result.ended(isCloud, startAt, totalRecord);
                    if (!PropertyValidator.isValid((Collection)result.getIssues())) continue;
                    totalRecord += result.getIssues().size();
                    for (JiraIssue2 jiraIssue2 : result.getIssues()) {
                        if (parenChildMap.get(jiraIssue2.getId()) == null) {
                            List parentIds = resyncParams.processForParent(jiraIssue2.projectKey(), (Map)jiraIssue2.getFields(), null, childLinkMappings, null);
                            if (PropertyValidator.isValid((Collection)parentIds) && PropertyValidator.isValid(parentIds.get(0))) {
                                parenChildMap.put(jiraIssue2.getId(), parentIds.get(0));
                            } else {
                                LOGGER.debug(" :: Jira Child skipped without parent ..  : " + jiraIssue2.getKey());
                                continue;
                            }
                        }
                        if (!resyncParams.isValidChildInFilter(jiraIssue2, parenChildMap, jiraIssue2.getId()).booleanValue()) continue;
                        jiraIssue2.setJiraParentId((String)parenChildMap.get(jiraIssue2.getId()));
                        if (resyncParams.jiraIssuesChild != null) {
                            projectKeys.add(jiraIssue2.projectKey());
                            jiraIssue = jiraIssue2.getConvertedJiraIssue();
                            jiraIssue.setItemTypeTobeConvertedInto(resyncParams.itemTypeChild);
                            jiraIssue.setJiraParentId(jiraIssue2.getJiraParentId());
                            if (resyncParams.sessionBoardId != null) {
                                jiraIssue.setSessionBoardId(resyncParams.getBoardId());
                            } else if (resyncParams.solutionBoard != null) {
                                jiraIssue.setSolutionBoardId(resyncParams.getBoardId());
                            }
                            resyncParams.jiraIssuesChild.add(jiraIssue);
                        }
                        if (resyncParams.childKeys == null) continue;
                        resyncParams.childKeys.add(jiraIssue2.getKey());
                    }
                } while (!isLast2);
            }
        }
        if (resyncParams.isReadOnly && PropertyValidator.isValid(parentPids)) {
            for (String prjKey : parentPids) {
                if (projectKeysMap.get(prjKey) != null) continue;
                resyncParams.newProjects.add(prjKey);
            }
        }
        if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && debug != null) {
            debug.add("=============================================================================================================================");
            KendisUtils.pushProgressUpdates((String)"ResyncDebug", (String)resyncParams.syncId, debug, (PushResponseRepository)this.pushResponseRepository, (boolean)true);
        }
        return updateParentByEpicId;
    }

    public boolean fetchBucketChildJiraData(ResyncParamsVO resyncParams, AlmAccount almAccount, List<Status> jiraStatuses) throws Exception {
        almAccount = resyncParams.almConfigurations.getAlmAccount();
        resyncParams.uplevel = null;
        boolean byPassChildLink = false;
        boolean updateParentByEpicId = false;
        boolean isCloud = almAccount.cloud();
        resyncParams.byPassChildSave = !resyncParams.isReferesh && resyncParams.isReadOnly && resyncParams.ignoreChild;
        resyncParams.backlogAlmIds = new HashMap();
        Gson gson = new Gson();
        int startAt = 0;
        int pageSize = 100;
        int totalRecord = 0;
        resyncParams.backlogParentId = new HashMap();
        resyncParams.backlogParentId.put(resyncParams.getBoardId(), new HashMap());
        if (!byPassChildLink && !resyncParams.byPassChildSave) {
            this.customRepositoryImpl.parseSyncMapperBySprintId(resyncParams);
            Set jSids = resyncParams.syncMappersBySprintId.keySet();
            Set kTypes = resyncParams.session.getBuckets().keySet();
            if (PropertyValidator.isValid(jSids)) {
                List items = this.customRepositoryImpl.findBuckets(resyncParams.session, kTypes, (List)new /* Unavailable Anonymous Inner Class!! */);
                HashMap<String, Item> existingItemMap = new HashMap<String, Item>();
                HashMap<String, String> kendisIdsMap = new HashMap<String, String>();
                for (Item item : items) {
                    existingItemMap.put(item.getIssueType().getId(), item);
                    kendisIdsMap.put(item.getId(), item.getIssueType().getId());
                }
                for (String type : kTypes) {
                    List types;
                    if (existingItemMap.get(type) == null || !PropertyValidator.isValid((Collection)(types = ((IssueType)resyncParams.session.getBuckets().get(type)).getJiraTypes()))) continue;
                    StringBuilder syncingGap = new StringBuilder();
                    if (resyncParams.isSmartSync) {
                        resyncParams.filter.setLastSyncDate(((Item)existingItemMap.get(type)).getLastSyncDate());
                        String time = resyncParams.filter.lastUpdate();
                        if (PropertyValidator.isValid((Object)time)) {
                            syncingGap.append(time).append(" AND ");
                        }
                    }
                    LinkedList<StringBuilder> jqls = new LinkedList<StringBuilder>();
                    jqls.add(new StringBuilder().append((CharSequence)syncingGap).append("sprint in (").append(String.join((CharSequence)",", jSids)).append(")").append(" and ").append("issuetype in (").append(String.join((CharSequence)",", types)).append(")"));
                    StringBuilder pre = new StringBuilder();
                    if (syncingGap != null) {
                        pre.append((CharSequence)syncingGap).append(" AND ");
                    }
                    while (!jqls.isEmpty()) {
                        String jql = ((StringBuilder)jqls.pop()).toString();
                        startAt = 0;
                        pageSize = 100;
                        totalRecord = 0;
                        JiraSearch2 result = new JiraSearch2();
                        result.setNextPageToken(null);
                        result.setIsLast(Boolean.valueOf(false));
                        do {
                            result = this.importUtil.retrievePagedJiraDataAgainstFilter2(almAccount.getUrl(), jql, almAccount.getUsername(), almAccount.getPassword(), result.getNextPageToken(), startAt, pageSize, gson, resyncParams.fields, almAccount);
                            if (!isCloud) {
                                startAt += pageSize;
                                if (result.getTotal() != null) {
                                    totalRecord = result.getTotal();
                                }
                            }
                            if (!PropertyValidator.isValid((Collection)result.getIssues())) continue;
                            totalRecord += result.getIssues().size();
                            for (JiraIssue2 jiraIssue2 : result.getIssues()) {
                                if (resyncParams.jiraIssuesChild != null) {
                                    JiraIssue jiraIssue = jiraIssue2.getConvertedJiraIssue();
                                    jiraIssue.setItemTypeTobeConvertedInto(resyncParams.itemTypeChild);
                                    jiraIssue.setJiraParentId(((Item)existingItemMap.get(type)).getId());
                                    resyncParams.backlogAlmIds.put(jiraIssue.getKey(), type);
                                    resyncParams.backlogAlmIds.put(jiraIssue.getId(), type);
                                    if (resyncParams.sessionBoardId != null) {
                                        jiraIssue.setSessionBoardId(resyncParams.getBoardId());
                                    } else if (resyncParams.solutionBoard != null) {
                                        jiraIssue.setSolutionBoardId(resyncParams.getBoardId());
                                    }
                                    resyncParams.jiraIssuesChild.add(jiraIssue);
                                }
                                if (resyncParams.childKeys == null) continue;
                                resyncParams.childKeys.add(jiraIssue2.getKey());
                            }
                        } while (!result.ended(isCloud, startAt, totalRecord));
                    }
                }
                this.convertJiraIssuesToKendisItem(resyncParams, existingItemMap, kendisIdsMap, jiraStatuses);
            }
        }
        return updateParentByEpicId;
    }

    private String printResyncExp(Exception e, Gson gson, ResyncParamsVO param, AlmAccount almAccount, String jiraFilterId) {
        String err = StringUtils.getTraceString((Throwable)e);
        HashMap<String, String> exp = new HashMap<String, String>();
        exp.put("filterId", jiraFilterId);
        if (almAccount != null) {
            exp.put("almAccountId", almAccount.getId());
        }
        exp.put("kendisError", err);
        if (e instanceof ViztrendJiraException) {
            exp.put("almError", (String)((ViztrendJiraException)((Object)e)).getAlmError());
        }
        KendisUtils.onResyncError((String)param.syncId, null, (String)gson.toJson(exp), (String)param.sessionBoardId, (PushResponseRepository)this.pushResponseRepository);
        return err;
    }

    private Map<String, Item> findJiraItems(String tenant, String type, ResyncParamsVO param, Set<String> keys, Set<String> pids) {
        Query query = new Query();
        ArrayList<ObjectId> bids = new ArrayList<ObjectId>();
        bids.add(new ObjectId(param.sessionBoardId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"jiraId").exists(true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").in(bids));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type));
        if (type.equals(Item.Type.Feature.name())) {
            if (!param.isSmartSync && PropertyValidator.isValid((Object)param.filter.getId()) && !param.filter.getId().contains("AddExisting")) {
                query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"jiraKey").in((Collection)param.parentKeys), Criteria.where((String)"jiraFilter").in(new Object[]{param.filter.getId()})}));
            } else {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"jiraKey").in((Collection)param.parentKeys));
            }
        } else {
            query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"jiraKey").in((Collection)param.childKeys), Criteria.where((String)"parent.$id").in((Collection)KendisUtils.getListAsObjectIds(pids))}));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"parent").exists(true));
        }
        KendisUtils.pushProgressUpdates((String)"ResyncDebug", (String)param.syncId, (Object)("query [" + param.filter.getId() + "] for kendis items in sync :  " + query.toString()), (PushResponseRepository)this.pushResponseRepository, (boolean)true);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").ne((Object)true));
        if (param.isReadOnly) {
            query.fields().include("id");
            query.fields().include("type");
            query.fields().include("jiraKey");
            query.fields().include("jiraId");
            query.fields().include("title");
            query.fields().include("jiraURL");
            query.fields().include("kendisKey");
            query.fields().include("jiraIssueTypeId");
            query.fields().include("parent");
            query.fields().include("jiraFilter");
        }
        List items = this.mongoTemplate.find(query, Item.class, KendisUtils.dbName(Item.class));
        HashMap<String, Item> map = new HashMap<String, Item>();
        for (Item item : items) {
            map.put(item.getJiraId(), item);
            if (keys == null) continue;
            keys.add(item.getJiraId());
        }
        items.clear();
        items = null;
        return map;
    }

    public Object[] convertJiraIssuesToKendisItem(ResyncParamsVO param, Map<String, Item> existingItemMap, Map<String, String> kendisIdsMap, List<Status> newStatuses) throws Exception {
        Object err;
        HashMap<String, HashMap> newChildMap;
        HashMap missingChildMap;
        Map<String, Item> existingChildMap;
        ArrayList<Item> childItems;
        ArrayList<String> debug;
        HashSet resolveStatusDependencies;
        HashSet openStatusDependencies;
        HashMap openOrResolveDependenciesMap;
        HashMap<String, String> oldCategoryByItemIdMap;
        ArrayList linksToBeDeleted;
        HashMap<String, HashMap> newItemMap;
        HashMap<String, HashMap> missingItemMap;
        ArrayList<String> idsToRemove;
        Set<Object> jiraIds;
        HashSet<Item> parentItems;
        HashMap<String, List> parentJiraDependencyMap;
        Map linkStatusMap;
        AlmAccount almAccount;
        String jiraFilterId;
        String tenant;
        Gson gson;
        block141: {
            Item item;
            Date now = new Date();
            gson = new Gson();
            tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            jiraFilterId = param.filter.getId();
            almAccount = param.almConfigurations.getAlmAccount();
            List statuses = this.statusRepository.findBySessionId(param.session.getId());
            List linkStatuses = this.statusRepository.findByWorkFlow(param.session.getDependencyWorkFlow());
            Map statusMap = this.getStatusMapFromStatuses(statuses);
            linkStatusMap = this.getLinkStatusMapFromStatuses(linkStatuses);
            Map fields = this.getMetaForItemFields(param, almAccount);
            parentJiraDependencyMap = new HashMap<String, List>();
            parentItems = new HashSet<Item>();
            jiraIds = new HashSet();
            idsToRemove = new ArrayList<String>();
            HashMap<String, Boolean> itemLinksMap = new HashMap<String, Boolean>();
            List jiraParentIssues = new ArrayList();
            HashMap jiraItemLinksMap = new HashMap();
            HashMap<String, ItemJiraDependency> jiraLinksByIdMap = new HashMap<String, ItemJiraDependency>();
            missingItemMap = new HashMap<String, HashMap>();
            newItemMap = new HashMap<String, HashMap>();
            linksToBeDeleted = new ArrayList();
            oldCategoryByItemIdMap = new HashMap<String, String>();
            openOrResolveDependenciesMap = new HashMap();
            openStatusDependencies = new HashSet();
            resolveStatusDependencies = new HashSet();
            openOrResolveDependenciesMap.put("Open", openStatusDependencies);
            openOrResolveDependenciesMap.put("Resolved", resolveStatusDependencies);
            debug = null;
            if (almAccount.isDebug() || PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && UserContextUtil.getUserContext().getLoggedInUser().isDebug()) {
                debug = new ArrayList<String>();
            }
            if (param.extraFields == null) {
                param.extraFields = new HashSet();
            }
            if (PropertyValidator.isValid((Object)param.session.getJiraFlaggedField())) {
                param.extraFields.add(param.session.getJiraFlaggedField());
            }
            if (PropertyValidator.isValid((Object)jiraFilterId) && !jiraFilterId.contains("AddExisting")) {
                KendisUtils.pushProgressUpdates((String)"ResyncProgress", (String)param.syncId, (Object)"{\"div\":\"convert_feature\"}", (PushResponseRepository)this.pushResponseRepository, (boolean)true);
            }
            if (debug != null) {
                debug.add("=============================================================================================================================");
                debug.add("[" + jiraFilterId + "] syncing filter id");
            }
            if (PropertyValidator.isValid((Object)param.jiraIssueFilterMap)) {
                jiraIds = param.jiraIssueFilterMap.keySet();
            }
            jiraParentIssues = param.jiraIssuesParent;
            ArrayList<Container> boardContainers = null;
            if (!param.isReadOnly && PropertyValidator.isValid((Object)param.sessionBoardId)) {
                BasicDBObject query = new BasicDBObject();
                query.put((Object)"archive", (Object)new BasicDBObject("$ne", (Object)true));
                query.put((Object)"tenant", (Object)tenant);
                query.put((Object)"_id", (Object)new ObjectId(param.sessionBoardId));
                DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(SessionBoard.class));
                DBCursor cursor = collection.find((DBObject)query);
                if (cursor.hasNext()) {
                    boardContainers = new ArrayList<Container>();
                    BasicDBObject board = (BasicDBObject)cursor.next();
                    if (PropertyValidator.isValid((Object)board.get("containers"))) {
                        List sprints = (List)board.get("containers");
                        for (DBRef ref : sprints) {
                            boardContainers.add(new Container(String.valueOf(ref.getId())));
                        }
                    }
                    List boardTeamContainers = this.teamContainerRepository.findByContainerIn(boardContainers);
                    ArrayList<String> tcids = new ArrayList<String>();
                    for (Object teamContainer : boardTeamContainers) {
                        tcids.add(teamContainer.getId());
                    }
                    List itemLinks = this.itemLinkRepository.findBySourceTeamContainerIdInOrTargetTeamContainerIdIn(tcids, tcids);
                    if (PropertyValidator.isValid((Collection)itemLinks)) {
                        for (ItemLink itemLink : itemLinks) {
                            itemLinksMap.put(itemLink.getSourceTeamContainerId(), true);
                            itemLinksMap.put(itemLink.getTargetTeamContainerId(), true);
                        }
                    }
                }
            }
            this.customRepositoryImpl.parseSyncMapperBySprintId(param);
            HashSet parenJiraIds = new HashSet();
            if (existingItemMap == null || !param.bucketSync.booleanValue()) {
                existingItemMap = this.findJiraItems(tenant, Item.Type.Feature.name(), param, parenJiraIds, null);
            }
            if (existingItemMap != null) {
                for (String jiraId : parenJiraIds) {
                    item = (Item)existingItemMap.get(jiraId);
                    if (param.isReadOnly) {
                        HashMap _item = item.toSimpleObject();
                        if (param.isReferesh) {
                            _item.put("notSynced", true);
                        }
                        if ((param.jiraIdsMap == null || param.jiraIdsMap.containsKey(jiraId)) && !param.isReferesh) {
                            missingItemMap.put(jiraId, _item);
                        }
                    }
                    kendisIdsMap.put(item.getId(), jiraId);
                    if (!param.isReadOnly) {
                        if (param.isReferesh || param.forceUpdate) continue;
                        if (param.checkedForDEL != null && !Boolean.TRUE.equals(param.checkedForDEL.get(jiraId))) {
                            kendisIdsMap.remove(item.getId());
                            continue;
                        }
                        idsToRemove.add(item.getId());
                        continue;
                    }
                    idsToRemove.add(item.getId());
                }
            }
            if (!(param.isReadOnly || param.isAutoSync || param.isSmartSync)) {
                KendisUtils.putDeletedItems(missingItemMap, (List)this.itemRepository.deleteBySessionBoardsIdInAndIdIn(param.sessionBoardId, idsToRemove));
            }
            if (PropertyValidator.isValid(jiraParentIssues)) {
                for (JiraIssue jIssue : jiraParentIssues) {
                    if (!param.isReadOnly && !param.isReferesh && param.checkedForADD != null && !Boolean.TRUE.equals(param.checkedForADD.get(jIssue.getJiraId()))) continue;
                    fields.put("sequence", new Double(System.nanoTime() / 100000L) + 1000.0);
                    item = jIssue.getItemFromJiraIssue(fields, param.extraFields, almAccount);
                    item.getJiraFieldByKey().remove(null);
                    if (PropertyValidator.isValid((Object)param.session.getwsjfAlmEnabled()) && PropertyValidator.isValid((Object)param.session.getwsjfAlmFieldKey()) && jIssue.getMapFields().containsKey(param.session.getwsjfAlmFieldKey())) {
                        item.setAlmScoreField((Double)jIssue.getMapFields().get(param.session.getwsjfAlmFieldKey()));
                    }
                    if (item.getSessionBoards() != null && item.getSessionBoards().size() > 0 && item.getSessionBoards().get(0) != null && ((SessionBoard)item.getSessionBoards().get(0)).getSession() == null) {
                        ((SessionBoard)item.getSessionBoards().get(0)).setSession(param.session);
                    }
                    item.setStatus(jIssue.getItemStatus(item, statusMap, newStatuses));
                    if (PropertyValidator.isValid((Object)param.filter.getIssueType())) {
                        item.setIssueType(param.filter.getIssueType());
                    }
                    if (param.filter.getFilterFetchedBy() != null) {
                        item.setFetchedBy(param.filter.getFilterFetchedBy());
                    }
                    if (existingItemMap.containsKey(item.getJiraId())) {
                        Item existingItem = (Item)existingItemMap.get(item.getJiraId());
                        item.setId(existingItem.getId());
                        if (param.removeEmptyCards) {
                            item.applyTeamContainers(existingItem.getTeamContainers(), itemLinksMap);
                        } else {
                            item.setTeamContainers(existingItem.getTeamContainers());
                        }
                        item.setSequence(existingItem.getSequence());
                        item.setBacklogSequence(existingItem.getBacklogSequence());
                        item.setItemLinks(existingItem.getItemLinks());
                        item.setLinkTypes(existingItem.getLinkTypes());
                        item.setLinkType(existingItem.getLinkType());
                        item.setIssueType(existingItem.getIssueType());
                        item.setOriginItemId(existingItem.getOriginItemId());
                        item.setDuplicateOfId(existingItem.getDuplicateOfId());
                        item.setSolutionSourceItemLinks(existingItem.getSolutionSourceItemLinks());
                        item.setSolutionTargetItemLinks(existingItem.getSolutionTargetItemLinks());
                        item.setCreatedOn(existingItem.getCreatedOn());
                        item.setScore(existingItem.getScore());
                        item.setScoreParams(existingItem.getScoreParams());
                        if (!PropertyValidator.isValid((Object)item.getDueDate())) {
                            item.setDueDate(existingItem.getDueDate());
                        }
                        if (!PropertyValidator.isValid((Object)item.getStartDate())) {
                            item.setStartDate(existingItem.getStartDate());
                        }
                        if (!PropertyValidator.isValid((Object)item.getEndDate())) {
                            item.setEndDate(existingItem.getEndDate());
                        }
                        if (!PropertyValidator.isValid((Object)existingItem.getJiraFilter()) && PropertyValidator.isValid((Object)jiraFilterId) && !jiraFilterId.contains("AddExisting")) {
                            item.setJiraFilter(jiraFilterId);
                        }
                        if (PropertyValidator.isValid((Collection)existingItem.getJiraDependencies())) {
                            for (ItemJiraDependency dependency : existingItem.getJiraDependencies()) {
                                if (!PropertyValidator.isValid((Object)dependency)) continue;
                                jiraLinksByIdMap.put(dependency.getJiraDependencyId(), dependency);
                            }
                        }
                        jiraItemLinksMap.put(existingItem.getId(), jiraLinksByIdMap);
                        if (!param.isReadOnly) {
                            this.updateDependencyStatusBasedOnItemStatus(item, existingItem, param.session, linkStatusMap, openOrResolveDependenciesMap);
                        }
                        if (param.liveItemSync.booleanValue() && item.getFetchedBy() == null) {
                            item.setFetchedBy(existingItem.getFetchedBy());
                            item.setJiraFilter(existingItem.getJiraFilter());
                        }
                    } else {
                        if (param.isReferesh) continue;
                        if (param.isReadOnly) {
                            newItemMap.put(item.getJiraId(), item.toSimpleObject());
                        }
                    }
                    if (PropertyValidator.isValid((Object)jiraFilterId) && jiraFilterId.contains("AddExisting")) {
                        item.setLinkTypes(((BacklogMappingLinks)((JiraFilter)param.jiraIssueFilterMap.get(item.getJiraId())).getFeatureLinkMappings().get(0)).getLinkTypes());
                    }
                    if (PropertyValidator.isValid((Object)item.getId())) {
                        KendisUtils.addChanges((boolean)param.isReadOnly, (boolean)true, (Item)item, (Item)((Item)existingItemMap.get(item.getJiraId())));
                        Item oldItem = (Item)existingItemMap.get(item.getJiraId());
                        if (PropertyValidator.isValid((Object)oldItem.getStatus())) {
                            oldCategoryByItemIdMap.put(oldItem.getId(), oldItem.getStatus().getCategory());
                        }
                    } else {
                        item.setId(ObjectId.get().toString());
                        if (item.getCreatedOn() == null) {
                            item.setCreatedOn(now);
                        }
                        kendisIdsMap.put(item.getId(), item.getJiraId());
                        KendisUtils.addChanges((boolean)param.isReadOnly, (boolean)true, (Item)item, null);
                    }
                    existingItemMap.put(item.getJiraId(), item);
                    HashMap oldItemJiraDependencyMap = (HashMap)jiraItemLinksMap.get(item.getId());
                    List dependencyIssues = this.getFeatureDependencyIssues(jIssue, param.session.getJiraLinkTypes(), jIssue.getJiraId(), null, (Map)oldItemJiraDependencyMap, linksToBeDeleted, null, null);
                    if (!param.isReadOnly) {
                        if (item != null && item.getJiraFieldByKey() != null && param != null && param.session != null) {
                            this.scoreCardService.updateScorecardFieldsAccordingToMappedFields(param.session, item, item.getJiraFieldByKey());
                        }
                        HashMap<String, ItemJiraDependency> newJiraLinksByIdMap = new HashMap<String, ItemJiraDependency>();
                        for (Object jD : dependencyIssues) {
                            newJiraLinksByIdMap.put(jD.getJiraDependencyId(), (ItemJiraDependency)jD);
                        }
                        ArrayList<String> itemLinksIdsList = new ArrayList<String>();
                        if (PropertyValidator.isValid((Collection)item.getItemLinks())) {
                            Object itemLink;
                            Object jD;
                            jD = item.getItemLinks().iterator();
                            while (jD.hasNext()) {
                                itemLink = (ItemLink)jD.next();
                                if (!PropertyValidator.isValid((Object)itemLink.getAlmLinkId()) || PropertyValidator.isValid(newJiraLinksByIdMap.get(itemLink.getAlmLinkId()))) continue;
                                itemLinksIdsList.add(itemLink.getAlmLinkId());
                                itemLink.setAlmLinkId(null);
                            }
                            if (PropertyValidator.isValid(itemLinksIdsList)) {
                                List itemLinks = this.itemLinkRepository.findByAlmLinkIdIn(itemLinksIdsList);
                                itemLink = itemLinks.iterator();
                                while (itemLink.hasNext()) {
                                    ItemLink itemLink2 = (ItemLink)itemLink.next();
                                    itemLink2.setAlmLinkId(null);
                                }
                                this.itemLinkRepository.save((Iterable)itemLinks);
                            }
                        }
                    }
                    parentJiraDependencyMap.put(item.getId(), dependencyIssues);
                    parentItems.add(item);
                    missingItemMap.remove(item.getJiraId());
                }
            }
            childItems = new ArrayList<Item>();
            existingChildMap = new HashMap();
            Set jiraChildIssues = new HashSet();
            HashMap<String, HashMap<String, ItemJiraDependency>> jiraSubItemLinksMap = new HashMap<String, HashMap<String, ItemJiraDependency>>();
            jiraChildIssues = param.jiraIssuesChild;
            HashSet childJiraIds = new HashSet();
            missingChildMap = new HashMap();
            newChildMap = new HashMap<String, HashMap>();
            if (!param.byPassChildSave) {
                existingChildMap = this.findJiraItems(tenant, Item.Type.UserStory.name(), param, childJiraIds, kendisIdsMap.keySet());
            }
            for (String jiraId : childJiraIds) {
                Item item2 = (Item)existingChildMap.get(jiraId);
                String index = kendisIdsMap.get(item2.getParent().getId());
                if (PropertyValidator.isValid((Object)jiraId)) {
                    HashMap _item;
                    if (index != null) {
                        boolean logging = false;
                        if (PropertyValidator.isValid((Object)jiraFilterId) && !jiraFilterId.contains("AddExisting") && !jiraFilterId.contains("bucket")) {
                            if (jiraFilterId.equals(item2.getJiraFilter()) || item2.getParent() != null && jiraFilterId.equals(item2.getParent().getJiraFilter())) {
                                logging = true;
                            }
                        } else if (item2.getParent() != null && item2.getParent().getId() != null && kendisIdsMap.get(item2.getParent().getId()) != null) {
                            logging = true;
                        }
                        if (logging && !param.isSmartSync) {
                            if (param.isReadOnly) {
                                missingChildMap.put(jiraId, item2.toSimpleObject());
                            } else {
                                missingChildMap.put(jiraId, new /* Unavailable Anonymous Inner Class!! */);
                            }
                        }
                    }
                    if (index != null || !param.isReferesh || (_item = (HashMap)missingChildMap.get(jiraId)) == null) continue;
                    _item.put("notSynced", true);
                    continue;
                }
                if (index == null || !PropertyValidator.isValid((Collection)item2.getTeamContainers())) continue;
                Item parentItem = (Item)existingItemMap.get(index);
                if (PropertyValidator.isValid((Collection)parentItem.getTeamContainers())) {
                    if (parentItem.getTeamContainers().contains(item2.getTeamContainers().get(0))) continue;
                    parentItem.getTeamContainers().add(item2.getTeamContainers().get(0));
                    continue;
                }
                parentItem.setTeamContainers((List)new /* Unavailable Anonymous Inner Class!! */);
            }
            if (PropertyValidator.isValid((Object)jiraFilterId) && !jiraFilterId.contains("AddExisting")) {
                KendisUtils.pushProgressUpdates((String)"ResyncProgress", (String)param.syncId, (Object)"{\"div\":\"convert_children\"}", (PushResponseRepository)this.pushResponseRepository, (boolean)true);
            }
            if (PropertyValidator.isValid((Collection)param.almConfigurations.getTeamMappings())) {
                for (BacklogMapping bm : param.almConfigurations.getTeamMappings()) {
                    if (!PropertyValidator.isValid((Collection)bm.getJiraFieldMap())) continue;
                    for (ItemJiraFieldMap ijf : bm.getJiraFieldMap()) {
                        param.extraFields.add(ijf);
                    }
                }
            }
            try {
                if (!PropertyValidator.isValid(jiraChildIssues)) break block141;
                for (JiraIssue jIssue : jiraChildIssues) {
                    try {
                        boolean isOLD;
                        String jiraParentId;
                        Double seq = new Double(System.nanoTime() / 100000L) + 1000.0;
                        fields.put("sequence", seq);
                        Item item3 = jIssue.getItemFromJiraIssue(fields, param.extraFields, almAccount);
                        Item parentItem = null;
                        if (item3.getSessionBoards() != null && item3.getSessionBoards().size() > 0 && item3.getSessionBoards().get(0) != null && ((SessionBoard)item3.getSessionBoards().get(0)).getSession() == null) {
                            ((SessionBoard)item3.getSessionBoards().get(0)).setSession(param.session);
                        }
                        item3.setStatus(jIssue.getItemStatus(item3, statusMap, newStatuses));
                        if (param.filter.getFilterFetchedBy() != null) {
                            item3.setFetchedBy(param.filter.getFilterFetchedBy());
                        }
                        if ((jiraParentId = (String)param.backlogAlmIds.get(jIssue.getJiraParentId())) == null && jIssue.getJiraParentId() != null) {
                            jiraParentId = param.getJiraParentKey(jIssue.getMapFields().get(JiraField.FIXED.parent.toString()), "id");
                            if (debug != null) {
                                debug.add("jiraParentId condition 1 : " + jiraParentId);
                            }
                        }
                        if (param.bucketSync.booleanValue() && "ZT-9,ZWMV-22".indexOf(jIssue.getKey()) > -1) {
                            System.out.println("debug");
                        }
                        if (param.bucketSync.booleanValue() && "ZTZ-4".indexOf(jIssue.getKey()) > -1) {
                            System.out.println("debug");
                        }
                        if (jiraParentId == null || param.bucketSync.booleanValue()) {
                            jiraParentId = kendisIdsMap.get(jIssue.getJiraParentId());
                            if (debug != null) {
                                debug.add("jiraParentId condition 2 : " + jiraParentId);
                            }
                        }
                        if (PropertyValidator.isValid((Object)jiraParentId) && PropertyValidator.isValid(existingItemMap.get(jiraParentId))) {
                            item3.setParent((Item)existingItemMap.get(jiraParentId));
                            parentItem = item3.getParent();
                            if (debug != null) {
                                debug.add("jiraParentId condition 3 : " + jiraParentId);
                            }
                        }
                        List subItemExistingTCs = null;
                        Item _us = (Item)existingChildMap.get(jIssue.getJiraId());
                        boolean bl = isOLD = _us != null && _us.getId() != null;
                        if (debug != null) {
                            debug.add("child [" + jIssue.getKey() + "] log for parent : parentId = [" + (item3.getParent() != null ? item3.getParent().getId() + "],[" + item3.getParent().getJiraKey() : "-") + "] checked with jiraParentId = [" + jiraParentId + "], jIssue.getJiraParentId() = [" + jIssue.getJiraParentId() + "]");
                        }
                        if (isOLD) {
                            item3.setId(_us.getId());
                            item3.setOriginItemId(_us.getOriginItemId());
                            item3.setDuplicateOfId(_us.getDuplicateOfId());
                            item3.setItemLinks(_us.getItemLinks());
                            item3.setSequence(_us.getSequence());
                            item3.setBacklogSequence(_us.getBacklogSequence());
                            item3.setSolutionSourceItemLinks(_us.getSolutionSourceItemLinks());
                            item3.setSolutionTargetItemLinks(_us.getSolutionTargetItemLinks());
                            item3.setCreatedOn(_us.getCreatedOn());
                            item3.setStartDate(_us.getStartDate());
                            item3.setEndDate(_us.getEndDate());
                            subItemExistingTCs = _us.getTeamContainers();
                            if (PropertyValidator.isValid((Collection)subItemExistingTCs)) {
                                subItemExistingTCs.removeIf(v -> !PropertyValidator.isValid((Object)v));
                            }
                            if (!PropertyValidator.isValid((Object)item3.getParent())) {
                                item3.setParent(_us.getParent());
                            } else if (param.bucketSync.booleanValue() && _us.getParent() != null && (_us.getParent().getIssueType() == null || !Boolean.TRUE.equals(_us.getParent().getIssueType().getIsBucket()))) {
                                item3.setParent(_us.getParent());
                            }
                            if (!PropertyValidator.isValid((Object)item3.getId())) {
                                item3.setId(ObjectId.get().toString());
                            }
                            parentItem = item3.getParent();
                            if (PropertyValidator.isValid((Collection)_us.getJiraDependencies())) {
                                for (ItemJiraDependency dependency : _us.getJiraDependencies()) {
                                    if (!PropertyValidator.isValid((Object)dependency)) continue;
                                    jiraLinksByIdMap.put(dependency.getJiraDependencyId(), dependency);
                                }
                            }
                            jiraSubItemLinksMap.put(_us.getId(), jiraLinksByIdMap);
                            if (param.liveItemSync.booleanValue() && item3.getFetchedBy() == null) {
                                item3.setFetchedBy(_us.getFetchedBy());
                                item3.setJiraFilter(_us.getJiraFilter());
                            }
                        }
                        if (param.isReferesh && parentItem == null) continue;
                        if (!param.isReadOnly) {
                            if (item3.getParent() != null && !param.isReferesh && param.checkedForADD != null && !Boolean.TRUE.equals(param.checkedForADD.get(item3.getParent().getJiraId()))) {
                                continue;
                            }
                        } else if (param.isReadOnly && !isOLD) {
                            newChildMap.put(jIssue.getJiraId(), item3.toSimpleObject());
                        }
                        if (!isOLD && item3.getCreatedOn() == null) {
                            item3.setId(ObjectId.get().toString());
                            item3.setCreatedOn(now);
                        } else if (PropertyValidator.isValid((Object)_us.getStatus())) {
                            oldCategoryByItemIdMap.put(item3.getId(), _us.getStatus().getCategory());
                        }
                        existingChildMap.put(item3.getJiraId(), item3);
                        HashMap oldSubItemJiraDependencyMap = (HashMap)jiraSubItemLinksMap.get(item3.getId());
                        List dependencyIssues = this.getFeatureDependencyIssues(jIssue, param.session.getJiraLinkTypes(), jIssue.getJiraId(), null, (Map)oldSubItemJiraDependencyMap, linksToBeDeleted, null, null);
                        parentJiraDependencyMap.put(item3.getId(), dependencyIssues);
                        if (!PropertyValidator.isValid((Object)parentItem)) {
                            parentItem = item3.getParent();
                        }
                        if (!PropertyValidator.isValid((Object)parentItem)) {
                            if (debug == null) continue;
                            debug.add("+++++++++++++++fetched child key (parent not found 2): +++++++++ " + jIssue.getKey());
                            continue;
                        }
                        if (!PropertyValidator.isValid((Collection)parentItem.getTeamContainers())) {
                            parentItem.setTeamContainers(new ArrayList());
                        }
                        if (PropertyValidator.isValid(fields.get("Sprint"))) {
                            ArrayList logs;
                            block142: {
                                logs = new ArrayList();
                                try {
                                    JiraUtils.addjustChildTC((Boolean)param.isReadOnly, (Item)item3, (Item)parentItem, (ResyncParamsVO)param, (List)subItemExistingTCs, (TeamContainerRepository)this.teamContainerRepository, null, (Double)seq, (HashMap)jIssue.getMapFields(), (String)((JiraField)fields.get("Sprint")).getJiraId(), logs);
                                }
                                catch (KendisException e) {
                                    if (!"sharedSprint".equals(e.getCode())) break block142;
                                    HashMap<String, String> exp = new HashMap<String, String>();
                                    exp.put("sharedSprint", e.getMessage());
                                    KendisUtils.onResyncError((String)param.syncId, null, (String)gson.toJson(exp), (String)param.sessionBoardId, (PushResponseRepository)this.pushResponseRepository);
                                }
                            }
                            KendisUtils.printLOG((String)String.join((CharSequence)",\n", logs));
                            logs = null;
                        }
                        if (!param.isReadOnly) {
                            List inboundItemLinks;
                            TeamContainer newTeamContainer = null;
                            TeamContainer previousTeamContainer = null;
                            ArrayList<Object> allItemLinks = new ArrayList<Object>();
                            if (PropertyValidator.isValid((Collection)item3.getTeamContainers())) {
                                newTeamContainer = (TeamContainer)item3.getTeamContainers().get(0);
                            }
                            if (PropertyValidator.isValid((Collection)subItemExistingTCs)) {
                                previousTeamContainer = (TeamContainer)subItemExistingTCs.get(0);
                            }
                            HashMap<String, ItemJiraDependency> newJiraLinksByIdMap = new HashMap<String, ItemJiraDependency>();
                            for (Object jD : dependencyIssues) {
                                newJiraLinksByIdMap.put(jD.getJiraDependencyId(), (ItemJiraDependency)jD);
                            }
                            ArrayList<String> itemLinksIdsList = new ArrayList<String>();
                            if (PropertyValidator.isValid((Collection)item3.getItemLinks())) {
                                Object jD;
                                jD = item3.getItemLinks().iterator();
                                while (jD.hasNext()) {
                                    ItemLink itemLink = (ItemLink)jD.next();
                                    if (PropertyValidator.isValid((Object)itemLink.getAlmLinkId()) && !PropertyValidator.isValid(newJiraLinksByIdMap.get(itemLink.getAlmLinkId()))) {
                                        itemLinksIdsList.add(itemLink.getAlmLinkId());
                                        itemLink.setAlmLinkId(null);
                                    }
                                    if (!PropertyValidator.isValid((Object)newTeamContainer) || !PropertyValidator.isValid((Object)previousTeamContainer) || newTeamContainer.getId().equals(previousTeamContainer.getId())) continue;
                                    itemLink.setSourceTeamContainerId(newTeamContainer.getId());
                                    itemLink.setSourceFeatureId(item3.getParent().getId());
                                    allItemLinks.add(itemLink);
                                }
                                if (PropertyValidator.isValid(itemLinksIdsList)) {
                                    List itemLinks = this.itemLinkRepository.findByAlmLinkIdIn(itemLinksIdsList);
                                    for (ItemLink itemLink : itemLinks) {
                                        itemLink.setAlmLinkId(null);
                                    }
                                    this.itemLinkRepository.save((Iterable)itemLinks);
                                }
                            }
                            if (PropertyValidator.isValid((Object)newTeamContainer) && PropertyValidator.isValid((Object)previousTeamContainer) && !newTeamContainer.getId().equals(previousTeamContainer.getId()) && PropertyValidator.isValid((Collection)(inboundItemLinks = this.itemLinkRepository.findByTargetUserStoryId(item3.getId())))) {
                                for (int ind = 0; ind < inboundItemLinks.size(); ++ind) {
                                    ItemLink link = (ItemLink)inboundItemLinks.get(ind);
                                    link.setTargetTeamContainerId(newTeamContainer.getId());
                                    link.setTargetFeatureId(item3.getParent().getId());
                                }
                                allItemLinks.addAll(inboundItemLinks);
                            }
                            if (PropertyValidator.isValid(allItemLinks)) {
                                this.itemLinkRepository.save(allItemLinks);
                            }
                            if (existingChildMap.containsKey(item3.getJiraId())) {
                                this.updateDependencyStatusBasedOnItemStatus(item3, _us, param.session, linkStatusMap, openOrResolveDependenciesMap);
                            }
                            KendisUtils.addChanges((boolean)param.isReadOnly, (boolean)true, (Item)item3, (Item)_us);
                            if (item3.getId() != null) {
                                missingItemMap.remove(item3.getId());
                            }
                            if (parentItem != null) {
                                if (param.bucketSync.booleanValue()) {
                                    parentItem.setLastSyncDate(now);
                                }
                                if (PropertyValidator.isValid((Collection)parentItem.getSessionBoards())) {
                                    parentItems.add(parentItem);
                                }
                            }
                        }
                        if (item3.getJiraFieldByKey() != null) {
                            item3.getJiraFieldByKey().remove(null);
                        }
                        childItems.add(item3);
                        missingChildMap.remove(item3.getJiraId());
                    }
                    catch (Exception e) {
                        String err2 = this.printResyncExp(e, gson, param, almAccount, jiraFilterId);
                        LOGGER.error(" :: Error While converting Jira Child issue ..  " + err2);
                    }
                }
                if (debug != null) {
                    debug.add("+++++++++++++++fetched children list : +++++++++ " + childItems.size());
                }
            }
            catch (Exception e) {
                err = this.printResyncExp(e, gson, param, almAccount, jiraFilterId);
                LOGGER.error(" :: Exception while jira Child issues..  " + (String)err);
            }
        }
        if (!param.isReadOnly) {
            if (!param.isAutoSync && !param.isSmartSync && PropertyValidator.isValid(missingChildMap) && !missingChildMap.isEmpty()) {
                KendisUtils.putDeletedItems(missingItemMap, (List)this.itemRepository.deleteBySessionBoardsInAndJiraIdInAndParentIsNotNull(param.sessionBoardId, missingChildMap.keySet()));
            }
            if (PropertyValidator.isValid(linksToBeDeleted)) {
                this.itemJiraDependencyRepository.delete(linksToBeDeleted);
            }
        }
        if (!param.isReadOnly) {
            if (!param.isAutoSync && !param.isSmartSync && PropertyValidator.isValid(idsToRemove)) {
                KendisUtils.putDeletedItems(missingItemMap, (List)this.itemRepository.deleteByParentIdInAndJiraIdNotNull(idsToRemove));
            }
            if (PropertyValidator.isValid(newStatuses)) {
                List subSetsStatuses = Lists.partition(new ArrayList<Status>(newStatuses), (int)100);
                for (List subSetStatuses : subSetsStatuses) {
                    this.statusRepository.save((Iterable)subSetStatuses);
                    if (debug == null) continue;
                    debug.add("saving statuses");
                }
            }
            this.proccessLinesOnResync(param.session, parentItems, existingItemMap, existingChildMap, parentJiraDependencyMap, linkStatusMap, oldCategoryByItemIdMap, openOrResolveDependenciesMap, openStatusDependencies, resolveStatusDependencies);
            this.proccessLinesOnResync(param.session, childItems, existingItemMap, existingChildMap, parentJiraDependencyMap, linkStatusMap, oldCategoryByItemIdMap, openOrResolveDependenciesMap, openStatusDependencies, resolveStatusDependencies);
            if (PropertyValidator.isValid(linksToBeDeleted)) {
                this.itemJiraDependencyRepository.delete(linksToBeDeleted);
            }
            this.saveItemsInChunks(param, parentItems);
            this.saveItemsInChunks(param, childItems);
            this.customRepositoryImpl.bulkLogs(param.sessionBoardId, parentItems, childItems, missingItemMap, tenant);
        }
        try {
            if (PropertyValidator.isValid((Object)jiraFilterId)) {
                this.jiraIssueRepository.deleteBySessionBoardIdAndJiraFilterId(param.sessionBoardId, jiraFilterId);
            } else {
                this.jiraIssueRepository.deleteBySessionBoardIdAndJiraIdInOrJiraParentIdIn(param.sessionBoardId, jiraIds, jiraIds);
            }
        }
        catch (Exception e) {
            err = this.printResyncExp(e, gson, param, almAccount, jiraFilterId);
            LOGGER.error(" :: Exception deleteBySessionBoardIdAndJiraFilterId..  " + (String)err);
        }
        if (PropertyValidator.isValid((Object)jiraFilterId) && !jiraFilterId.contains("AddExisting")) {
            KendisUtils.pushProgressUpdates((String)"ResyncProgress", (String)param.syncId, (Object)"{\"div\":\"converting_finished\",\"done\":true}", (PushResponseRepository)this.pushResponseRepository, (boolean)true);
            if (debug != null) {
                debug.add(" :: converting_finished  ");
            }
        }
        Object[] result = new Object[]{parentItems, childItems, parentItems.size()};
        param.pushSyncChange(jiraFilterId, newItemMap, newChildMap, missingItemMap, missingChildMap, this.pushResponseRepository);
        if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && debug != null) {
            debug.add("=============================================================================================================================");
            debug.add(" \t\t\t\t\t\t\t\t\tRESYNC PROCESS ENDED :: " + UserContextUtil.getUserContext().getUsername());
            debug.add("=============================================================================================================================");
            KendisUtils.pushProgressUpdates((String)"ResyncDebug", (String)param.syncId, debug, (PushResponseRepository)this.pushResponseRepository, (boolean)true);
        }
        return result;
    }

    private void saveItemsInChunks(ResyncParamsVO param, Collection<Item> items) {
        if (PropertyValidator.isValid(items)) {
            List subSetsParentItems = Lists.partition(new ArrayList<Item>(items), (int)100);
            for (List subSetParentItems : subSetsParentItems) {
                this.itemRepository.save((Iterable)subSetParentItems);
                this.pushSyncIds(param, subSetParentItems);
            }
        }
    }

    private void proccessLinesOnResync(Session session, Collection<Item> list, Map<String, Item> existingItemMap, Map<String, Item> existingChildMap, Map<String, List<ItemJiraDependency>> parentJiraDependencyMap, Map<String, Status> linkStatusMap, Map<String, String> oldCategoryByItemIdMap, Map<String, Set<String>> openOrResolveDependenciesMap, Set<String> openStatusDependencies, Set<String> resolveStatusDependencies) {
        ArrayList autoCloseLinksOfItem = new ArrayList();
        ArrayList autoOpenLinksOfItem = new ArrayList();
        ArrayList<String> autoCloseLinksOfSubItems = new ArrayList<String>();
        ArrayList<String> autoOpenLinksOfSubItems = new ArrayList<String>();
        ArrayList<ItemJiraDependency> allParentJiraDependency = new ArrayList<ItemJiraDependency>();
        for (Item item : list) {
            List<ItemJiraDependency> jiraDependencies = parentJiraDependencyMap.get(item.getId());
            if (!PropertyValidator.isValid(jiraDependencies)) continue;
            for (ItemJiraDependency itemJiraDependency : jiraDependencies) {
                if (!PropertyValidator.isValid((Object)itemJiraDependency)) continue;
                if (!PropertyValidator.isValid((Object)itemJiraDependency.getId())) {
                    Item _item;
                    itemJiraDependency.setId(ObjectId.get().toString());
                    itemJiraDependency.setSourceItemId(item.getId());
                    String jiraId = "";
                    if (PropertyValidator.isValid((Object)itemJiraDependency.getTargetJiraIssue())) {
                        jiraId = itemJiraDependency.getTargetJiraIssue().getJiraId();
                    }
                    if (PropertyValidator.isValid((Object)(_item = existingItemMap.get(jiraId))) && PropertyValidator.isValid((Object)_item.getId())) {
                        itemJiraDependency.setTargetItemId(_item.getId());
                        continue;
                    }
                    if (!existingChildMap.containsKey(jiraId)) continue;
                    itemJiraDependency.setTargetItemId(existingChildMap.get(jiraId).getId());
                    continue;
                }
                String oldCategory = oldCategoryByItemIdMap.get(item.getId());
                String newCategory = item.getStatus().getCategory();
                if (!PropertyValidator.isValid((Object)oldCategory) || !PropertyValidator.isValid((Object)newCategory)) continue;
                if (oldCategory.equalsIgnoreCase(EnumStatusCategory.DONE.getCode()) && !newCategory.equalsIgnoreCase(EnumStatusCategory.DONE.getCode())) {
                    autoOpenLinksOfSubItems.add(item.getId());
                    continue;
                }
                if (oldCategory.equalsIgnoreCase(EnumStatusCategory.DONE.getCode()) || !newCategory.equalsIgnoreCase(EnumStatusCategory.DONE.getCode())) continue;
                autoCloseLinksOfSubItems.add(item.getId());
            }
            item.setJiraDependencies(jiraDependencies);
            allParentJiraDependency.addAll(jiraDependencies);
        }
        this.updateDependencyStatusOnResyncBasedOnItemStatus(autoCloseLinksOfItem, autoOpenLinksOfItem, autoCloseLinksOfSubItems, autoOpenLinksOfSubItems, session, linkStatusMap, openOrResolveDependenciesMap);
        if (PropertyValidator.isValid(allParentJiraDependency)) {
            this.itemJiraDependencyRepository.save(allParentJiraDependency);
        }
        this.customRepositoryImpl.updateJiraDependencyStatusOnItemStatus(openOrResolveDependenciesMap, linkStatusMap, session.getActiveSessionBoard());
    }

    private void pushSyncIds(ResyncParamsVO param, List<Item> items) {
        HashSet<String> keys = new HashSet<String>();
        for (int j = 0; j < items.size(); ++j) {
            keys.add(items.get(j).getJiraKey());
        }
        HashMap push = param.pushData(keys, null);
        push.put("syncItems", true);
        push.put("boardId", param.getBoardId());
        KendisUtils.pushProgressUpdates((String)"ResyncProgress", (String)param.syncId, (Object)push, (PushResponseRepository)this.pushResponseRepository, (boolean)true);
    }

    private void updateDependencyStatusOnResyncBasedOnItemStatus(List<String> autoCloseLinksOfItem, List<String> autoOpenLinksOfItem, List<String> autoCloseLinksOfSubItems, List<String> autoOpenLinksOfSubItems, Session session, Map<String, Status> linkStatusMap, Map<String, Set<String>> openOrResolveDependenciesMap) {
        Status openStatus = linkStatusMap.get("ToDo");
        Status closeStatus = linkStatusMap.get("Done");
        List itemJiraDependencies = null;
        List<ItemJiraDependency> itemJiraDependenciesList = new ArrayList();
        ArrayList<ItemJiraDependency> itemJiraDependencyToBeUpdated = new ArrayList<ItemJiraDependency>();
        if (PropertyValidator.isValid(autoCloseLinksOfItem) || PropertyValidator.isValid(autoCloseLinksOfSubItems) || PropertyValidator.isValid(autoOpenLinksOfItem) || PropertyValidator.isValid(autoOpenLinksOfSubItems)) {
            Set<String> openLinks;
            Set<String> resolveLinks;
            String itemId;
            boolean ignoreIfWrongItem;
            boolean add;
            if (PropertyValidator.isValid(autoCloseLinksOfItem)) {
                itemJiraDependencies = this.itemJiraDependencyRepository.findBySourceItemIdInOrTargetItemIdIn(autoCloseLinksOfItem, autoCloseLinksOfItem);
                if (session.getItemLinkStatusDependentOn().equals(Session.DependencyStatusOption.SourceTarget.toString())) {
                    itemJiraDependenciesList = itemJiraDependencies;
                } else if (session.getItemLinkStatusDependentOn().equals(Session.DependencyStatusOption.Source.toString())) {
                    for (ItemJiraDependency jD : itemJiraDependencies) {
                        add = true;
                        if (PropertyValidator.isValid((Object)jD.getSourceItemId()) && !autoCloseLinksOfItem.contains(jD.getSourceItemId()) && !PropertyValidator.isValid((Object)jD.getTargetItemId())) {
                            add = false;
                        }
                        if (!add) continue;
                        itemJiraDependenciesList.add(jD);
                    }
                } else {
                    for (ItemJiraDependency jD : itemJiraDependencies) {
                        add = true;
                        if (PropertyValidator.isValid((Object)jD.getTargetItemId()) && !autoCloseLinksOfItem.contains(jD.getTargetItemId()) && !PropertyValidator.isValid((Object)jD.getSourceItemId())) {
                            add = false;
                        }
                        if (!add) continue;
                        itemJiraDependenciesList.add(jD);
                    }
                }
                if (PropertyValidator.isValid(itemJiraDependenciesList)) {
                    for (ItemJiraDependency jD : itemJiraDependenciesList) {
                        ignoreIfWrongItem = true;
                        itemId = "";
                        itemId = autoCloseLinksOfItem.contains(jD.getSourceItemId()) ? jD.getSourceItemId() : jD.getTargetItemId();
                        ignoreIfWrongItem = this.tfsService.checkDependencyStatusUpdateOnItemStatusUpdate((Object)jD, itemId, null, session.getItemLinkStatusDependentOn(), session);
                        if (ignoreIfWrongItem) continue;
                        jD.setWfStatus(closeStatus);
                        itemJiraDependencyToBeUpdated.add(jD);
                        resolveLinks = openOrResolveDependenciesMap.get("Resolved");
                        resolveLinks.add(jD.getJiraDependencyId());
                    }
                }
            }
            if (PropertyValidator.isValid(autoOpenLinksOfItem)) {
                itemJiraDependencies = this.itemJiraDependencyRepository.findBySourceItemIdInOrTargetItemIdIn(autoOpenLinksOfItem, autoOpenLinksOfItem);
                if (session.getItemLinkStatusDependentOn().equals(Session.DependencyStatusOption.SourceTarget.toString())) {
                    itemJiraDependenciesList = itemJiraDependencies;
                } else if (session.getItemLinkStatusDependentOn().equals(Session.DependencyStatusOption.Source.toString())) {
                    for (ItemJiraDependency jD : itemJiraDependencies) {
                        add = true;
                        if (PropertyValidator.isValid((Object)jD.getSourceItemId()) && !autoOpenLinksOfItem.contains(jD.getSourceItemId()) && !PropertyValidator.isValid((Object)jD.getTargetItemId())) {
                            add = false;
                        }
                        if (!add) continue;
                        itemJiraDependenciesList.add(jD);
                    }
                } else {
                    for (ItemJiraDependency jD : itemJiraDependencies) {
                        add = true;
                        if (PropertyValidator.isValid((Object)jD.getTargetItemId()) && !autoOpenLinksOfItem.contains(jD.getTargetItemId()) && !PropertyValidator.isValid((Object)jD.getSourceItemId())) {
                            add = false;
                        }
                        if (!add) continue;
                        itemJiraDependenciesList.add(jD);
                    }
                }
                if (PropertyValidator.isValid(itemJiraDependenciesList)) {
                    for (ItemJiraDependency jD : itemJiraDependenciesList) {
                        ignoreIfWrongItem = true;
                        itemId = "";
                        itemId = autoCloseLinksOfItem.contains(jD.getSourceItemId()) ? jD.getSourceItemId() : jD.getTargetItemId();
                        ignoreIfWrongItem = this.tfsService.checkDependencyStatusUpdateOnItemStatusUpdate((Object)jD, itemId, null, session.getItemLinkStatusDependentOn(), session);
                        if (ignoreIfWrongItem) continue;
                        jD.setWfStatus(linkStatusMap.get(openStatus));
                        itemJiraDependencyToBeUpdated.add(jD);
                        openLinks = openOrResolveDependenciesMap.get("Open");
                        openLinks.add(jD.getJiraDependencyId());
                    }
                }
            }
            if (PropertyValidator.isValid(autoCloseLinksOfSubItems)) {
                itemJiraDependencies = this.itemJiraDependencyRepository.findBySourceItemIdInOrTargetItemIdIn(autoCloseLinksOfSubItems, autoCloseLinksOfSubItems);
                if (session.getSubItemLinkStatusDependentOn().equals(Session.DependencyStatusOption.SourceTarget.toString())) {
                    itemJiraDependenciesList = itemJiraDependencies;
                } else if (session.getSubItemLinkStatusDependentOn().equals(Session.DependencyStatusOption.Source.toString())) {
                    for (ItemJiraDependency jD : itemJiraDependencies) {
                        add = true;
                        if (PropertyValidator.isValid((Object)jD.getSourceItemId()) && !autoCloseLinksOfSubItems.contains(jD.getSourceItemId()) && !PropertyValidator.isValid((Object)jD.getTargetItemId())) {
                            add = false;
                        }
                        if (!add) continue;
                        itemJiraDependenciesList.add(jD);
                    }
                } else {
                    for (ItemJiraDependency jD : itemJiraDependencies) {
                        add = true;
                        if (PropertyValidator.isValid((Object)jD.getTargetItemId()) && !autoCloseLinksOfSubItems.contains(jD.getTargetItemId()) && !PropertyValidator.isValid((Object)jD.getSourceItemId())) {
                            add = false;
                        }
                        if (!add) continue;
                        itemJiraDependenciesList.add(jD);
                    }
                }
                if (PropertyValidator.isValid(itemJiraDependenciesList)) {
                    for (ItemJiraDependency jD : itemJiraDependenciesList) {
                        ignoreIfWrongItem = true;
                        itemId = "";
                        itemId = autoCloseLinksOfSubItems.contains(jD.getSourceItemId()) ? jD.getSourceItemId() : jD.getTargetItemId();
                        ignoreIfWrongItem = this.tfsService.checkDependencyStatusUpdateOnItemStatusUpdate((Object)jD, itemId, null, session.getSubItemLinkStatusDependentOn(), session);
                        if (ignoreIfWrongItem) continue;
                        jD.setWfStatus(linkStatusMap.get(closeStatus));
                        itemJiraDependencyToBeUpdated.add(jD);
                        resolveLinks = openOrResolveDependenciesMap.get("Resolved");
                        resolveLinks.add(jD.getJiraDependencyId());
                    }
                }
            }
            if (PropertyValidator.isValid(autoOpenLinksOfSubItems)) {
                itemJiraDependencies = this.itemJiraDependencyRepository.findBySourceItemIdInOrTargetItemIdIn(autoOpenLinksOfSubItems, autoOpenLinksOfSubItems);
                if (session.getSubItemLinkStatusDependentOn().equals(Session.DependencyStatusOption.SourceTarget.toString())) {
                    itemJiraDependenciesList = itemJiraDependencies;
                } else if (session.getSubItemLinkStatusDependentOn().equals(Session.DependencyStatusOption.Source.toString())) {
                    for (ItemJiraDependency jD : itemJiraDependencies) {
                        add = true;
                        if (PropertyValidator.isValid((Object)jD.getSourceItemId()) && !autoOpenLinksOfSubItems.contains(jD.getSourceItemId()) && !PropertyValidator.isValid((Object)jD.getTargetItemId())) {
                            add = false;
                        }
                        if (!add) continue;
                        itemJiraDependenciesList.add(jD);
                    }
                } else {
                    for (ItemJiraDependency jD : itemJiraDependencies) {
                        add = true;
                        if (PropertyValidator.isValid((Object)jD.getTargetItemId()) && !autoOpenLinksOfSubItems.contains(jD.getTargetItemId()) && !PropertyValidator.isValid((Object)jD.getSourceItemId())) {
                            add = false;
                        }
                        if (!add) continue;
                        itemJiraDependenciesList.add(jD);
                    }
                }
                if (PropertyValidator.isValid(itemJiraDependenciesList)) {
                    for (ItemJiraDependency jD : itemJiraDependenciesList) {
                        ignoreIfWrongItem = true;
                        itemId = "";
                        itemId = autoOpenLinksOfSubItems.contains(jD.getSourceItemId()) ? jD.getSourceItemId() : jD.getTargetItemId();
                        ignoreIfWrongItem = this.tfsService.checkDependencyStatusUpdateOnItemStatusUpdate((Object)jD, itemId, null, session.getSubItemLinkStatusDependentOn(), session);
                        if (ignoreIfWrongItem) continue;
                        jD.setWfStatus(linkStatusMap.get(openStatus));
                        itemJiraDependencyToBeUpdated.add(jD);
                        openLinks = openOrResolveDependenciesMap.get("Open");
                        openLinks.add(jD.getJiraDependencyId());
                    }
                }
            }
        }
    }

    private Item updateDependencyStatusBasedOnItemStatus(Item item1, Item savedItem, Session session, Map<String, Status> linkStatusMap, Map<String, Set<String>> openOrResolveDependenciesMap) {
        List itemLinks;
        String key;
        List kendisLinkTypes;
        if (PropertyValidator.isValid((Object)savedItem) && Item.USER_STORY.equals(savedItem.getType()) && PropertyValidator.isValid((Object)session.getSubItemLinkStatusDependentOn()) && !session.getSubItemLinkStatusDependentOn().equals("-1")) {
            boolean resolveSubItemDependencies = false;
            boolean openSubItemDependencies = false;
            if (PropertyValidator.isValid((Object)item1.getStatus()) && PropertyValidator.isValid((Object)item1.getStatus().getCategory()) && PropertyValidator.isValid((Object)savedItem.getStatus()) && PropertyValidator.isValid((Object)savedItem.getStatus().getCategory()) && item1.getStatus().getCategory().equals("Done") && !savedItem.getStatus().getCategory().equals(item1.getStatus().getCategory())) {
                resolveSubItemDependencies = true;
            }
            if (session.getReOpenDependencyIfSubItemReOpen().booleanValue() && PropertyValidator.isValid((Object)item1.getStatus()) && PropertyValidator.isValid((Object)item1.getStatus().getCategory()) && PropertyValidator.isValid((Object)savedItem.getStatus()) && PropertyValidator.isValid((Object)savedItem.getStatus().getCategory()) && savedItem.getStatus().getCategory().equals("Done") && !savedItem.getStatus().getCategory().equals(item1.getStatus().getCategory())) {
                openSubItemDependencies = true;
            }
            if (openSubItemDependencies || resolveSubItemDependencies) {
                kendisLinkTypes = this.itemLinkTypeRepository.findBySystem(Boolean.TRUE);
                key = session.getSubItemLinkStatusDependentOn();
                itemLinks = new ArrayList();
                itemLinks = this.itemLinkRepository.findByTargetUserStoryIdOrSourceUserStoryId(savedItem.getId(), savedItem.getId());
                ArrayList<ItemLink> linksToBeUpdated = new ArrayList<ItemLink>();
                if (PropertyValidator.isValid(itemLinks)) {
                    for (ItemLink itemLink : itemLinks) {
                        boolean ignoreIfWrongItem = true;
                        ignoreIfWrongItem = this.tfsService.checkDependencyStatusUpdateOnItemStatusUpdate((Object)itemLink, item1.getId(), kendisLinkTypes, key, session);
                        if (session.getIgnoreUpdateIfManualResolvedForSubItem().booleanValue() && itemLink.getIsManuallyResolved().booleanValue() || ignoreIfWrongItem) continue;
                        String linkOldStatus = itemLink.getStatus();
                        itemLink.setStatus(resolveSubItemDependencies ? "Resolved" : "Open");
                        itemLink.setWfStatus(resolveSubItemDependencies ? linkStatusMap.get("Done") : linkStatusMap.get("ToDo"));
                        KendisUtils.addChanges((Item)item1, (ItemLink)itemLink, (String)linkOldStatus);
                        if (resolveSubItemDependencies) {
                            itemLink.setResolvedOn(new Date());
                            if (PropertyValidator.isValid((Object)itemLink.getAlmLinkId())) {
                                Set<String> resolveLinks = openOrResolveDependenciesMap.get("Resolved");
                                resolveLinks.add(itemLink.getAlmLinkId());
                            }
                        } else {
                            itemLink.setResolvedOn(null);
                            if (PropertyValidator.isValid((Object)itemLink.getAlmLinkId())) {
                                Set<String> openLinks = openOrResolveDependenciesMap.get("Open");
                                openLinks.add(itemLink.getAlmLinkId());
                            }
                        }
                        itemLink.setIsManuallyResolved(Boolean.valueOf(false));
                        linksToBeUpdated.add(itemLink);
                    }
                    this.itemLinkRepository.save(linksToBeUpdated);
                }
            }
        }
        if (PropertyValidator.isValid((Object)savedItem) && Item.FEATURE.equals(savedItem.getType()) && PropertyValidator.isValid((Object)session.getItemLinkStatusDependentOn()) && !session.getItemLinkStatusDependentOn().equals("-1")) {
            boolean resolveItemDependencies = false;
            boolean openItemDependencies = false;
            if (PropertyValidator.isValid((Object)item1.getStatus()) && PropertyValidator.isValid((Object)item1.getStatus().getCategory()) && PropertyValidator.isValid((Object)savedItem.getStatus()) && PropertyValidator.isValid((Object)savedItem.getStatus().getCategory()) && item1.getStatus().getCategory().equals("Done") && !savedItem.getStatus().getCategory().equals(item1.getStatus().getCategory())) {
                resolveItemDependencies = true;
            }
            if (session.getReOpenDependencyIfItemReOpen().booleanValue() && PropertyValidator.isValid((Object)item1.getStatus()) && PropertyValidator.isValid((Object)item1.getStatus().getCategory()) && PropertyValidator.isValid((Object)savedItem.getStatus()) && PropertyValidator.isValid((Object)savedItem.getStatus().getCategory()) && savedItem.getStatus().getCategory().equals("Done") && !savedItem.getStatus().getCategory().equals(item1.getStatus().getCategory())) {
                openItemDependencies = true;
            }
            if (openItemDependencies || resolveItemDependencies) {
                kendisLinkTypes = this.itemLinkTypeRepository.findBySystem(Boolean.TRUE);
                key = session.getItemLinkStatusDependentOn();
                itemLinks = new ArrayList();
                ArrayList tcIds = new ArrayList();
                if (PropertyValidator.isValid((Collection)savedItem.getTeamContainers())) {
                    savedItem.getTeamContainers().forEach(tc -> {
                        if (PropertyValidator.isValid((Object)tc)) {
                            tcIds.add(tc.getId());
                        }
                    });
                }
                itemLinks.addAll(this.itemLinkRepository.findBySourceTeamContainerIdInOrTargetTeamContainerIdIn(tcIds, tcIds));
                ArrayList<ItemLink> linksToBeUpdated = new ArrayList<ItemLink>();
                if (PropertyValidator.isValid(itemLinks)) {
                    for (ItemLink itemLink : itemLinks) {
                        boolean ignoreIfWrongItem = true;
                        if (session.getItemLinkStatusDependentOn().equals(Session.DependencyStatusOption.Source.toString()) && PropertyValidator.isValid((Object)itemLink.getSourceUserStoryId()) || session.getItemLinkStatusDependentOn().equals(Session.DependencyStatusOption.Target.toString()) && PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId())) continue;
                        ignoreIfWrongItem = this.tfsService.checkDependencyStatusUpdateOnItemStatusUpdate((Object)itemLink, item1.getId(), kendisLinkTypes, key, session);
                        if (session.getIgnoreUpdateIfManualResolvedForItem().booleanValue() && itemLink.getIsManuallyResolved().booleanValue() || ignoreIfWrongItem) continue;
                        String linkOldStatus = itemLink.getStatus();
                        itemLink.setStatus(resolveItemDependencies ? "Resolved" : "Open");
                        itemLink.setWfStatus(resolveItemDependencies ? linkStatusMap.get("Done") : linkStatusMap.get("ToDo"));
                        KendisUtils.addChanges((Item)item1, (ItemLink)itemLink, (String)linkOldStatus);
                        if (resolveItemDependencies) {
                            itemLink.setResolvedOn(new Date());
                            if (PropertyValidator.isValid((Object)itemLink.getAlmLinkId())) {
                                Set<String> resolveLinks = openOrResolveDependenciesMap.get("Resolved");
                                resolveLinks.add(itemLink.getAlmLinkId());
                            }
                        } else {
                            itemLink.setResolvedOn(null);
                            if (PropertyValidator.isValid((Object)itemLink.getAlmLinkId())) {
                                Set<String> openLinks = openOrResolveDependenciesMap.get("Open");
                                openLinks.add(itemLink.getAlmLinkId());
                            }
                        }
                        itemLink.setIsManuallyResolved(Boolean.valueOf(false));
                        linksToBeUpdated.add(itemLink);
                    }
                    if (PropertyValidator.isValid(linksToBeUpdated)) {
                        this.itemLinkRepository.save(linksToBeUpdated);
                    }
                }
            }
        }
        return item1;
    }

    public void setItemsAccordingToItemSyncMapper(String sessionBoardId, List<ItemSyncMapper> itemSyncMappers) {
        ArrayList<String> jiraContainerIds = new ArrayList<String>();
        for (ItemSyncMapper itemSyncMapper : itemSyncMappers) {
            if (!PropertyValidator.isValid((Object)itemSyncMapper.getSprint())) continue;
            jiraContainerIds.add(itemSyncMapper.getSprint().getJiraId());
        }
        ArrayList<SessionBoard> boards = new ArrayList<SessionBoard>();
        HashSet<Item> mappedParentItems = new HashSet<Item>();
        List parentItems = new ArrayList();
        Double sysSequence = new Double(System.nanoTime() / 100000L);
        boards.add(new SessionBoard(sessionBoardId));
        if (PropertyValidator.isValid(jiraContainerIds)) {
            List childItems = this.getItemsByMapJiraFieldId(sessionBoardId, jiraContainerIds);
            if (PropertyValidator.isValid((Collection)childItems)) {
                HashSet<String> parentIds = new HashSet<String>();
                for (Item item : childItems) {
                    if (!PropertyValidator.isValid((Object)item.getParent()) || !PropertyValidator.isValid((Object)item.getParent().getId())) continue;
                    parentIds.add(item.getParent().getId());
                }
                parentItems = this.itemRepository.findItemByIdIn(new ArrayList(parentIds));
                for (Item parentiItem : parentItems) {
                    for (Item childItem : childItems) {
                        if (!parentiItem.getId().equals(childItem.getParent().getId())) continue;
                        childItem.setParent(parentiItem);
                    }
                }
            }
            if (PropertyValidator.isValid((Collection)childItems)) {
                for (Item item : childItems) {
                    try {
                        Item parentItem = null;
                        if (parentItems.indexOf(new Item(item.getParent())) <= -1) continue;
                        parentItem = (Item)parentItems.get(parentItems.indexOf(new Item(item.getParent())));
                        if (!PropertyValidator.isValid((Collection)parentItem.getTeamContainers())) {
                            parentItem.setTeamContainers(new ArrayList());
                        }
                        if (!PropertyValidator.isValid((Object)item.getMapJiraFields()) || !PropertyValidator.isValid(item.getMapJiraFields().get("sprint")) && !PropertyValidator.isValid(item.getMapJiraFields().get("version"))) continue;
                        JiraSprint jSprint = (JiraSprint)item.getMapJiraFields().get("sprint");
                        boolean itemMapped = false;
                        Optional<ItemSyncMapper> itemSyncMapper = itemSyncMappers.stream().filter(x -> PropertyValidator.isValid((Object)x.getSprint()) && x.getSprint().getJiraId().equals(jSprint.getJiraId())).findFirst();
                        if (!itemSyncMapper.isPresent() || !PropertyValidator.isValid((Object)itemSyncMapper.get())) continue;
                        if (PropertyValidator.isValid((Collection)parentItem.getTeamContainers())) {
                            for (TeamContainer parentTeamContainer : parentItem.getTeamContainers()) {
                                if (!PropertyValidator.isValid((Object)parentTeamContainer) || !parentTeamContainer.getTeam().equals((Object)itemSyncMapper.get().getTeam()) || !parentTeamContainer.getContainer().equals((Object)itemSyncMapper.get().getContainer())) continue;
                                if (!PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                                    item.setTeamContainers(new ArrayList());
                                }
                                item.getTeamContainers().add(parentTeamContainer);
                                itemMapped = true;
                                break;
                            }
                        }
                        if (itemMapped) continue;
                        TeamContainer teamContainer = new TeamContainer();
                        teamContainer.setTeam(itemSyncMapper.get().getTeam());
                        teamContainer.setContainer(itemSyncMapper.get().getContainer());
                        teamContainer.setSequence(sysSequence);
                        teamContainer.setSuspendActivity(true);
                        teamContainer = (TeamContainer)this.teamContainerRepository.save((Object)teamContainer);
                        item.setTeamContainers(new ArrayList());
                        item.getTeamContainers().add(teamContainer);
                        parentItem.getTeamContainers().add(teamContainer);
                        mappedParentItems.add(parentItem);
                    }
                    catch (Exception e) {
                        String err = StringUtils.getTraceString((Throwable)e);
                        LOGGER.error(" :: Error While converting Jira Child issue ..  " + err);
                        HashMap<String, String> exp = new HashMap<String, String>();
                        exp.put("kendisError", err);
                    }
                }
                this.itemRepository.save((Iterable)childItems);
                this.itemRepository.save(mappedParentItems);
            }
        }
    }

    public List<Item> getItemsByMapJiraFieldId(String sessionBoardId, List<String> jiraFieldIds) {
        ArrayList<SessionBoard> boards = new ArrayList<SessionBoard>();
        boards.add(new SessionBoard(sessionBoardId));
        Criteria crt = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"sessionBoards").in(boards), new Criteria().orOperator(new Criteria[]{Criteria.where((String)"mapJiraFields.version.jiraId").in(jiraFieldIds), Criteria.where((String)"mapJiraFields.sprint.jiraId").in(jiraFieldIds)})});
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)crt);
        List items = this.mongoTemplate.find(query, Item.class);
        return items;
    }

    private boolean isDifferent(String sublist, String superList) {
        Gson gson = new Gson();
        HashSet<Object> superIds = new HashSet<Object>();
        List superObjects = (List)gson.fromJson(superList, List.class);
        for (Object object : superObjects) {
            superIds.add(((LinkedTreeMap)object).get((Object)"id"));
        }
        HashSet<Object> subIds = new HashSet<Object>();
        List subObjects = (List)gson.fromJson(sublist, List.class);
        for (Object object : subObjects) {
            subIds.add(((LinkedTreeMap)object).get((Object)"id"));
        }
        return !PropertyValidator.isValid((Collection)Sets.difference(subIds, superIds));
    }

    private boolean isDifferentObject(String object1, String object2) {
        try {
            JSONObject obj1 = new JSONObject(object1);
            JSONObject obj2 = new JSONObject(object2);
            return obj1.isNull("id") || obj2.isNull("id") || !obj1.get("id").equals(obj2.get("id"));
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return true;
        }
    }

    private boolean isDifferentArray(String sublist, String superList) {
        Gson gson = new Gson();
        HashSet<String> superIds = new HashSet<String>();
        List superObjects = (List)gson.fromJson(superList, List.class);
        for (Object object : superObjects) {
            superIds.add((String)object);
        }
        HashSet<String> subIds = new HashSet<String>();
        List subObjects = (List)gson.fromJson(sublist, List.class);
        for (Object object : subObjects) {
            subIds.add((String)object);
        }
        return !PropertyValidator.isValid((Collection)Sets.difference(subIds, superIds));
    }

    @Deprecated
    private Item getItemFromJiraIssue(JiraIssue jIssue, Map<String, Object> fields, Set<ItemJiraFieldMap> extraFields) {
        return null;
    }

    public JiraProjectStatuses retrieveProjectStatusesFromJira(String prjKey, AlmAccount almAcc, String sessionId) {
        JiraProjectStatuses prjStatus = new JiraProjectStatuses();
        prjStatus.setProjectKey(prjKey);
        prjStatus.setIssueType(this.importUtil.retrieveJiraStatuses(prjKey, almAcc.getUrl(), almAcc.getUsername(), almAcc.getPassword(), almAcc));
        prjStatus.setSessionBoardId(sessionId);
        return prjStatus;
    }

    public JiraIssue retrieveJiraIssueById(String issueId, AlmAccount almAcc) {
        String response = this.importUtil.retrieveJiraIssueById(almAcc.getUrl(), issueId, almAcc.getUsername(), almAcc.getPassword(), almAcc);
        Gson gson = new Gson();
        JiraIssue jIssue = (JiraIssue)gson.fromJson(response, JiraIssue.class);
        JiraIssue2 jIssue2 = (JiraIssue2)gson.fromJson(response, JiraIssue2.class);
        jIssue.setMapFields(jIssue2.getFields());
        return jIssue;
    }

    public JiraIssue2 retrieveJiraIssue(String issueId, AlmAccount almAcc) {
        String response = this.importUtil.retrieveJiraIssueById(almAcc.getUrl(), issueId, almAcc.getUsername(), almAcc.getPassword(), almAcc);
        Gson gson = new Gson();
        return (JiraIssue2)gson.fromJson(response, JiraIssue2.class);
    }

    public JiraIssue retrieveJiraIssueById(String issueId, String url, String username, String password, AlmAccount almAccount) {
        String response = this.importUtil.retrieveJiraIssueById(url, issueId, username, password, almAccount);
        Gson gson = new Gson();
        JiraIssue jIssue = (JiraIssue)gson.fromJson(response, JiraIssue.class);
        JiraIssue2 jIssue2 = (JiraIssue2)gson.fromJson(response, JiraIssue2.class);
        jIssue.setMapFields(jIssue2.getFields());
        return jIssue;
    }

    public List<JiraTransition> retrieveTransitionsByIssueId(String issueId, AlmAccount almAcc) {
        return this.retrieveTransitionsByIssueId(issueId, almAcc, almAcc.getUsername(), almAcc.getPassword());
    }

    public List<JiraTransition> retrieveTransitionsByIssueId(String issueId, AlmAccount almAcc, String username, String password) {
        String response = this.importUtil.retrieveTransitionsByIssueId(almAcc.getUrl(), issueId, username, password, almAcc);
        Gson gson = new Gson();
        JiraTransitionWrapper transWrapper = (JiraTransitionWrapper)gson.fromJson(response, JiraTransitionWrapper.class);
        return transWrapper.getTransitions();
    }

    public List<AlmAccount> fetchJiraAccount(boolean activeOnly) {
        List almAccounts = activeOnly ? this.almAccountRepository.findByIsActiveOrIsActiveIsNull(true) : this.almAccountRepository.findAll();
        return almAccounts;
    }

    public AlmAccount fetchAlmAccount(String accId) {
        return (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)accId));
    }

    public HashMap<String, Object> linkJiraAccount(AlmAccount alm) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            Boolean isNew = false;
            Object boards = null;
            Object projects = null;
            if (alm.isUsingJiraConnect()) {
                this.customRepositoryImpl.saveItem((Object)alm);
                ArrayList<AlmAccount> alms = new ArrayList<AlmAccount>();
                alms.add(alm.copyWithoutPwd());
                responseJson.put("alms", alms);
                responseJson.put("almAccount", alm.copyWithoutPwd());
            } else {
                if (alm.getUsername() == null && alm.getPassword() == null) {
                    if (alm.getUrl() != null) {
                        Query query = new Query();
                        AlmAccount almCxt = AlmUtils.getALMAcount();
                        if (almCxt.getUrl().equals(alm.getUrl())) {
                            alm = almCxt;
                        } else {
                            query.addCriteria((CriteriaDefinition)Criteria.where((String)"url").regex(alm.getUrl()));
                            alm = (AlmAccount)this.customRepositoryImpl.getMongoTemplate().findOne(query, AlmAccount.class);
                        }
                    }
                } else {
                    isNew = true;
                    if (PropertyValidator.isValid((Object)alm) && !PropertyValidator.isValid((Object)alm.getId())) {
                        alm.setIsPrivate(Boolean.valueOf(false));
                        alm = (AlmAccount)this.almAccountRepository.save((Object)alm);
                    }
                    alm.setIsTaggedUser(Boolean.valueOf(true));
                    this.retrieveJiraFields(alm, null);
                    this.retrieveJiraIssueLinkTypesForAlmAccount(alm);
                }
                if (isNew.booleanValue()) {
                    alm.setPassword(alm.getPassword());
                    try {
                        alm.setPassword(EncDecUtility.encrypt((String)alm.getPassword()));
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    alm.setIsPrivate(Boolean.valueOf(false));
                    alm.setIsTaggedUser(Boolean.valueOf(false));
                    alm = (AlmAccount)this.almAccountRepository.save((Object)alm);
                    ArrayList<AlmAccount> alms = new ArrayList<AlmAccount>();
                    alms.add(alm.copyWithoutPwd());
                    responseJson.put("alms", alms);
                    this.updateUserProfileOnAlmCreate(alm);
                }
                responseJson.put("almAccount", alm.copyWithoutPwd());
            }
            responseJson.put("almAccount", alm.copyWithoutPwd());
            this.userService.setOnboardingMeta("Connect_To_Jira", true);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return responseJson;
    }

    public void updateUserProfileOnAlmCreate(AlmAccount newALM) {
        try {
            User user = (User)this.userRepository.findOne((Serializable)((Object)UserContextUtil.getUserContext().getLoggedInUser().getId()));
            AlmAccount taggedAlmAccount = JiraUtils.getTaggedAlmUser((User)user, (AlmAccount)newALM);
            if (!PropertyValidator.isValid((Object)taggedAlmAccount)) {
                AlmAccUser almAccUser = new AlmAccUser();
                almAccUser.setAlmAccId(newALM.getId());
                almAccUser.setAlmUsername(newALM.getUsername());
                almAccUser.setAlmPassword(newALM.getPassword());
                almAccUser.setIsPatOn(newALM.getIsPatOn());
                almAccUser.setJiraOauthToken(newALM.getJiraOauthToken());
                almAccUser.setAzureOAuthToken(newALM.getAzureOAuthToken());
                if (AlmAccount.JiraAuthType.Auth.equals((Object)newALM.getJiraAuthType())) {
                    almAccUser.setAuthType(AlmAccount.JiraAuthType.Auth.name());
                }
                if (AlmAccount.JiraAuthType.Token.equals((Object)newALM.getJiraAuthType())) {
                    almAccUser.setAuthType(AlmAccount.JiraAuthType.Token.name());
                }
                if (AlmAccount.JiraAuthType.Credentials.equals((Object)newALM.getJiraAuthType())) {
                    almAccUser.setAuthType(AlmAccount.JiraAuthType.Credentials.name());
                }
                if (AlmAccount.AuthType.Auth.equals((Object)newALM.getAuthType())) {
                    almAccUser.setAuthType(AlmAccount.AuthType.Auth.name());
                }
                if (AlmAccount.AuthType.Token.equals((Object)newALM.getAuthType())) {
                    almAccUser.setAuthType(AlmAccount.AuthType.Token.name());
                }
                if (!PropertyValidator.isValid((Collection)user.getAlmCredentials())) {
                    user.setAlmCredentials(new ArrayList());
                }
                user.getAlmCredentials().add(almAccUser);
                this.userRepository.save((Object)user);
                UserContextUtil.getUserContext().getLoggedInUser().setAlmCredentials(user.getAlmCredentials());
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public void updateUserProfileOnAlmEdit(AlmAccount almAccount) {
        try {
            User user = (User)this.userRepository.findOne((Serializable)((Object)UserContextUtil.getUserContext().getLoggedInUser().getId()));
            AlmAccUser almAccUser = this.getUserAlmCredntials(almAccount.getId(), user);
            List almCredentials = user.getAlmCredentials().stream().map(alm -> {
                if (PropertyValidator.isValid((Object)alm.getAlmAccId()) && PropertyValidator.isValid((Object)almAccUser) && alm.getAlmAccId().equals(almAccUser.getAlmAccId())) {
                    alm.setAlmUsername(almAccount.getUsername());
                    alm.setAlmPassword(almAccount.getPassword());
                    almAccUser.setIsPatOn(almAccount.getIsPatOn());
                    alm.setJiraOauthToken(almAccount.getJiraOauthToken());
                    alm.setAzureOAuthToken(almAccount.getAzureOAuthToken());
                    if (PropertyValidator.isValid((Object)almAccount.getJiraAuthType())) {
                        alm.setAuthType(almAccount.getJiraAuthType().name());
                    }
                    if (PropertyValidator.isValid((Object)almAccount.getAuthType())) {
                        alm.setAuthType(almAccount.getAuthType().name());
                    }
                }
                return alm;
            }).collect(Collectors.toList());
            user.setAlmCredentials(almCredentials);
            this.userRepository.save((Object)user);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public void retrieveJiraIssueLinkTypesForAlmAccount(AlmAccount almAccount) {
        Gson gson = new Gson();
        String result = this.importUtil.retrieveIssueLinkTypesList(almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword(), almAccount);
        JiraIssueLinkTypeArrayWrapper linkTypeColection = (JiraIssueLinkTypeArrayWrapper)gson.fromJson(result, JiraIssueLinkTypeArrayWrapper.class);
        List linkTypes = linkTypeColection.getIssueLinkTypes();
        ArrayList<JiraIssueLinkType> resultLinkTypes = new ArrayList<JiraIssueLinkType>();
        for (JiraIssueLinkType lt : linkTypes) {
            JiraIssueLinkType linkType;
            if (lt.getInward().equals(lt.getOutward())) {
                linkType = new JiraIssueLinkType(lt.getJiraId(), lt.getSelf(), lt.getInward(), lt.getInward(), lt.getOutward(), "");
                resultLinkTypes.add(linkType);
                continue;
            }
            linkType = new JiraIssueLinkType(lt.getJiraId(), lt.getSelf(), lt.getInward(), lt.getInward(), lt.getOutward(), "IN");
            resultLinkTypes.add(linkType);
            linkType = new JiraIssueLinkType(lt.getJiraId(), lt.getSelf(), lt.getOutward(), lt.getInward(), lt.getOutward(), "OUT");
            resultLinkTypes.add(linkType);
        }
        if (PropertyValidator.isValid((Object)result)) {
            almAccount.setJiraIssueLinkTypes(resultLinkTypes);
        }
    }

    public HashMap<String, Object> retrieveBoard(String json) {
        Gson gson = new Gson();
        11 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap param = (HashMap)gson.fromJson(json, T.getType());
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        Query q = new Query();
        q.addCriteria((CriteriaDefinition)Criteria.where((String)"jiraId").is(param.get("boardId")));
        JiraBoard board = (JiraBoard)this.customRepositoryImpl.getMongoTemplate().findOne(q, JiraBoard.class);
        if (board.getLocationProject() == null) {
            AlmAccount alm = AlmUtils.getALMAcount();
            board = this.retrieveJiraBoardDetails(board, new String[]{alm.getUrl(), alm.getUsername(), alm.getPassword()});
        }
        responseJson.put("board", board);
        responseJson.put("project", board.getLocationProject());
        responseJson.put("param", param);
        return responseJson;
    }

    public JiraProject retrieveProject(String almAccountId, String projectKeyOrId) {
        Query q = new Query();
        q.addCriteria((CriteriaDefinition)Criteria.where((String)"jiraId").is((Object)projectKeyOrId));
        JiraProject project = (JiraProject)this.customRepositoryImpl.getMongoTemplate().findOne(q, JiraProject.class);
        if (!Boolean.TRUE.equals(project.getDetailLoaded())) {
            AlmAccount alm = AlmUtils.getALMAcount();
            project = this.getJiraProjectDetails(project, alm.getUrl(), alm.getUsername(), alm.getPassword());
        }
        return project;
    }

    public HashMap<String, Object> saveTeamsWithBoards(String json) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        return responseJson;
    }

    public HashMap<String, Object> saveTeam(String json) {
        Gson gson = new Gson();
        Team team = (Team)gson.fromJson(json, Team.class);
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (team.getId() != null) {
            Team oldTeam = (Team)this.teamRepository.findOne((Serializable)((Object)team.getId()));
            team.setBoardId(oldTeam.getBoardId());
            team.setProjectId(oldTeam.getProjectId());
        } else {
            responseJson.put("boards", this.customRepositoryImpl.getMongoTemplate().find(new Query(), JiraBoard.class));
        }
        this.teamRepository.save((Object)team);
        responseJson.put("team", team);
        return responseJson;
    }

    public HashMap<String, Object> deleteTeam(String json) {
        Gson gson = new Gson();
        Team team = (Team)gson.fromJson(json, Team.class);
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("teamId", team.getId());
        this.teamRepository.delete((Object)team);
        return responseJson;
    }

    public HashMap<String, Object> saveFilters(String json) {
        Gson gson = new Gson();
        AlmAccount alm = (AlmAccount)gson.fromJson(json, AlmAccount.class);
        AlmAccount account = AlmUtils.getALMAcount();
        account.setJiraItemFilters(alm.getJiraItemFilters());
        if (account.getJiraItemFilters() != null) {
            // empty if block
        }
        this.customRepositoryImpl.getMongoTemplate().save((Object)account);
        return null;
    }

    public HashMap<String, Object> saveAlmConfigurations(String json) {
        Gson gson = new Gson();
        12 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap param = (HashMap)gson.fromJson(json, T.getType());
        AlmConfigurations almConfig = (AlmConfigurations)gson.fromJson((String)param.get("almConfig"), AlmConfigurations.class);
        this.almConfigurationsRepository.save((Object)almConfig);
        return null;
    }

    public List<AlmConfigurations> saveAlmConfigurations(List<AlmConfigurations> almConfigs) {
        return this.almConfigurationsRepository.save(almConfigs);
    }

    public HashMap<String, Object> retreiveALMProjectsAndBoards() {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        AlmAccount alm = AlmUtils.getALMAcount();
        if (alm.getJiraItemFilters() != null) {
            List<Object> pids = new ArrayList();
            List<Object> bids = new ArrayList();
            pids = alm.getJiraItemFilters().stream().map(JiraItemFilter::getProjectId).collect(Collectors.toList());
            bids = alm.getJiraItemFilters().stream().map(JiraItemFilter::getBoardId).collect(Collectors.toList());
            Query query1 = new Query();
            query1.addCriteria((CriteriaDefinition)Criteria.where((String)"jiraId").in(pids));
            Query query2 = new Query();
            query2.addCriteria((CriteriaDefinition)Criteria.where((String)"jiraId").in(bids));
            responseJson.put("projects", this.customRepositoryImpl.getMongoTemplate().find(query1, JiraProject.class));
            responseJson.put("boards", this.customRepositoryImpl.getMongoTemplate().find(query2, JiraBoard.class));
        }
        return responseJson;
    }

    public void deleteIssueLinkInJira(String issueLinkId, String almAccountId, User loggedInUser) {
        AlmAccount alm = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
        AlmAccUser almAccUser = this.getUserAlmCredntials(alm.getId(), loggedInUser);
        String almUsername = "";
        String almPassword = "";
        if (PropertyValidator.isValid((Object)almAccUser)) {
            if (PropertyValidator.isValid((Object)almAccUser.getJiraOauthToken())) {
                alm.setJiraOauthToken(almAccUser.getJiraOauthToken());
                alm.setAdminAlmAcc(Boolean.valueOf(false));
                alm.setIsTaggedUser(Boolean.valueOf(true));
            } else {
                alm.setJiraOauthToken(null);
                almUsername = almAccUser.getAlmUsername();
                almPassword = almAccUser.getAlmPassword();
                alm.setIsTaggedUser(Boolean.valueOf(true));
                alm.setIsPatOnProfile(almAccUser.getIsPatOn());
            }
        } else {
            almUsername = alm.getUsername();
            almPassword = alm.getPassword();
            alm.setAdminAlmAcc(Boolean.valueOf(true));
        }
        alm.setOAuthTokenOwnerUserId(loggedInUser.getId());
        LOGGER.debug(" :: Deleting issue link in jira " + issueLinkId);
        this.exportUtil.deleteJiraIssueLink(issueLinkId, alm.getUrl(), almUsername, almPassword, alm);
        LOGGER.debug(" :: Issue link Deleted");
    }

    public JiraAlmAccountMeta retrieveJiraAlmAccountMeta(AlmAccount almAccount, boolean eagerFetch, boolean issueLinkTypes, boolean jiraFields, boolean issueTypes) {
        JiraAlmAccountMeta accountMeta = null;
        try {
            String result;
            if (!eagerFetch) {
                accountMeta = this.jiraAlmAccountMetaRepository.findByAlmAccountId(almAccount.getId());
            }
            if (!PropertyValidator.isValid(accountMeta)) {
                accountMeta = new JiraAlmAccountMeta(almAccount.getId());
            }
            if ((eagerFetch || !PropertyValidator.isValid((Object)accountMeta.getIssueLinkTypes())) && issueLinkTypes) {
                result = null;
                result = this.importUtil.retrieveIssueLinkTypesList(almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword(), almAccount);
                accountMeta.setIssueLinkTypes(result);
            }
            if ((eagerFetch || !PropertyValidator.isValid((Object)accountMeta.getJiraFields())) && jiraFields) {
                result = null;
                result = this.importUtil.retrieveJiraFieldsJSON(almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword(), almAccount);
                accountMeta.setJiraFields(result);
            }
            if ((eagerFetch || !PropertyValidator.isValid((Object)accountMeta.getIssueTypes())) && issueTypes) {
                result = null;
                result = this.importUtil.retrieveJiraIssueTypes(almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword(), almAccount);
                accountMeta.setIssueTypes(result);
            }
            accountMeta = (JiraAlmAccountMeta)this.jiraAlmAccountMetaRepository.save((Object)accountMeta);
        }
        catch (ViztrendJiraException vje) {
            LOGGER.debug("Validation error");
            accountMeta.setMessage("Validation Failed");
        }
        catch (Exception e) {
            LOGGER.debug("Error ");
        }
        return accountMeta;
    }

    public List<JiraIssueLinkType> retrieveJiraIssueLinkTypesList(AlmAccount almAccount, boolean eagerFetch) {
        JiraIssueLinkTypeArrayWrapper linkTypeColection;
        List linkTypes = null;
        Gson gson = new Gson();
        String linkTypesStr = null;
        if (!eagerFetch) {
            DBObject vo;
            String tenant = null;
            if (PropertyValidator.isValid((Object)almAccount) && PropertyValidator.isValid((Object)almAccount.getTenant())) {
                tenant = almAccount.getTenant();
            }
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"almAccountId").is((Object)almAccount.getId()));
            DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("jiraAlmAccountMeta").find(query.getQueryObject());
            if (dbCursorPrefix.hasNext() && PropertyValidator.isValid((Object)(vo = dbCursorPrefix.next()))) {
                JiraIssueLinkTypeArrayWrapper linkTypeColection2;
                linkTypesStr = (String)vo.get("issueLinkTypes");
                ItemLinkType itemLinkType = this.itemLinkTypeRepository.findByAlmAccountId(almAccount.getId());
                if (!PropertyValidator.isValid((Object)itemLinkType) && (linkTypeColection2 = (JiraIssueLinkTypeArrayWrapper)gson.fromJson(linkTypesStr, JiraIssueLinkTypeArrayWrapper.class)) != null) {
                    List itemLinkTypes = linkTypeColection2.getIssueLinkTypes();
                    this.saveJiraLinkType(itemLinkTypes, almAccount.getId());
                }
            }
        }
        if (!PropertyValidator.isValid(linkTypesStr) || eagerFetch) {
            try {
                linkTypesStr = this.importUtil.retrieveIssueLinkTypesList(almAccount.getUrl(), almAccount.getUsername(), almAccount.getPassword(), almAccount);
            }
            catch (ViztrendJiraException ex) {
                LOGGER.error(StringUtils.getTraceString((Throwable)ex));
                throw ex;
            }
            JiraAlmAccountMeta accountMeta = this.jiraAlmAccountMetaRepository.findByAlmAccountId(almAccount.getId());
            if (!PropertyValidator.isValid((Object)accountMeta)) {
                accountMeta = new JiraAlmAccountMeta(almAccount.getId());
            }
            accountMeta.setIssueLinkTypes(linkTypesStr);
            accountMeta = (JiraAlmAccountMeta)this.jiraAlmAccountMetaRepository.save((Object)accountMeta);
            ItemLinkType itemLinkType = this.itemLinkTypeRepository.findByAlmAccountId(almAccount.getId());
            if (PropertyValidator.isValid((Object)itemLinkType)) {
                this.itemLinkTypeRepository.deleteByAlmAccountId(almAccount.getId());
                linkTypeColection = (JiraIssueLinkTypeArrayWrapper)gson.fromJson(linkTypesStr, JiraIssueLinkTypeArrayWrapper.class);
                List itemLinkTypes = linkTypeColection.getIssueLinkTypes();
                this.saveJiraLinkType(itemLinkTypes, almAccount.getId());
            }
        }
        ArrayList<JiraIssueLinkType> resultLinkTypes = new ArrayList<JiraIssueLinkType>();
        if (PropertyValidator.isValid(linkTypesStr)) {
            linkTypeColection = (JiraIssueLinkTypeArrayWrapper)gson.fromJson(linkTypesStr, JiraIssueLinkTypeArrayWrapper.class);
            linkTypes = linkTypeColection.getIssueLinkTypes();
            for (JiraIssueLinkType lt : linkTypes) {
                JiraIssueLinkType linkType;
                if (lt.getInward().equals(lt.getOutward())) {
                    linkType = new JiraIssueLinkType(lt.getJiraId(), lt.getSelf(), lt.getInward(), lt.getInward(), lt.getOutward(), "");
                    resultLinkTypes.add(linkType);
                    continue;
                }
                linkType = new JiraIssueLinkType(lt.getJiraId(), lt.getSelf(), lt.getInward(), lt.getInward(), lt.getOutward(), "IN");
                resultLinkTypes.add(linkType);
                linkType = new JiraIssueLinkType(lt.getJiraId(), lt.getSelf(), lt.getOutward(), lt.getInward(), lt.getOutward(), "OUT");
                resultLinkTypes.add(linkType);
            }
            JiraIssueLinkType childrenLinkType = new JiraIssueLinkType("+1", "", almAccount.getJiraEpicLinkLabel(), almAccount.getJiraEpicLinkLabel(), almAccount.getJiraEpicLinkLabel(), "UP");
            resultLinkTypes.add(0, childrenLinkType);
        }
        return resultLinkTypes;
    }

    public MultiValueMap<String, String> retrieveProjectWorkflows(String param) {
        Gson gson = new Gson();
        String[] projectKeys = (String[])gson.fromJson(param, String[].class);
        return null;
    }

    public int deleteJiraIssues(String sessionId) {
        int removedCount = 0;
        List jIssues = this.jiraIssueRepository.findBySessionBoardId(sessionId);
        if (PropertyValidator.isValid((Collection)jIssues)) {
            for (JiraIssue ji : jIssues) {
                this.jiraIssueRepository.delete((Object)ji);
                ++removedCount;
            }
        }
        LOGGER.debug("Just deleted [" + removedCount + "] jira Issues from sessionId=" + sessionId);
        return removedCount;
    }

    public Map<String, Object> checkWhichFiltersWereUpdated(AlmConfigurations almConfigs) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List filters = almConfigs.getFeatureFilter();
        List enablers = almConfigs.getEnablerFilter();
        ArrayList<JiraFilter> updatedFilters = new ArrayList<JiraFilter>();
        ArrayList<JiraFilter> updatedEnablers = new ArrayList<JiraFilter>();
        List freshFilters = new ArrayList();
        Map filtersMap = this.retrieveJiraFilterList(almConfigs.getAlmAccount());
        freshFilters = (List)filtersMap.get("filters");
        if (PropertyValidator.isValid((Collection)filters) && PropertyValidator.isValid(freshFilters)) {
            for (JiraFilter oldFilter : filters) {
                for (JiraFilter freshFilter : freshFilters) {
                    if (!freshFilter.getId().equals(oldFilter.getId()) || freshFilter.getJql().equals(oldFilter.getJql())) continue;
                    updatedFilters.add(freshFilter);
                }
            }
        }
        if (PropertyValidator.isValid((Collection)enablers) && PropertyValidator.isValid(freshFilters)) {
            for (JiraFilter oldFilter : enablers) {
                for (JiraFilter freshFilter : freshFilters) {
                    if (!freshFilter.getId().equals(oldFilter.getId()) || freshFilter.getJql().equals(oldFilter.getJql())) continue;
                    updatedEnablers.add(freshFilter);
                }
            }
        }
        result.put("filter", updatedFilters);
        result.put("enabler", updatedEnablers);
        LOGGER.trace("checkWhichFiltersWereUpdated -->" + result);
        return result;
    }

    public List<AlmError> retrieveAlmErrors(String sessionBoardId) {
        List almErrors = this.almErrorRepository.findBySessionBoardId(sessionBoardId);
        return almErrors;
    }

    public HashMap<String, Object> searchAlmErrors(String searchString, String sessionBoardId, Boolean errFlag, Boolean warningFlag) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (!Boolean.TRUE.equals(errFlag) && !Boolean.TRUE.equals(warningFlag)) {
            responseJson.put("almErrors", this.almErrorRepository.findBySessionBoardIdAndDescriptionIgnoreCaseContaining(sessionBoardId, searchString));
            responseJson.put("almInfo", this.almInfoRepository.findBySessionBoardIdAndDescriptionIgnoreCaseContaining(sessionBoardId, searchString));
        }
        if (Boolean.TRUE.equals(errFlag)) {
            responseJson.put("almErrors", this.almErrorRepository.findBySessionBoardIdAndDescriptionIgnoreCaseContaining(sessionBoardId, searchString));
        }
        if (Boolean.TRUE.equals(warningFlag)) {
            responseJson.put("almInfo", this.almInfoRepository.findBySessionBoardIdAndDescriptionIgnoreCaseContaining(sessionBoardId, searchString));
        }
        responseJson.put("searchString", searchString);
        responseJson.put("errFlag", errFlag);
        responseJson.put("warFlag", warningFlag);
        return responseJson;
    }

    public List<JiraUser> retrieveJiraUsers(AlmAccount almAccount) {
        List result = null;
        try {
            result = this.importUtil.retrieveJiraUser(almAccount.getUrl(), almAccount.getUsername(), almAccount.getUsername(), almAccount.getPassword(), almAccount);
        }
        catch (ViztrendJiraException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public List<JiraConnectVO> getConnectAccounts() {
        String urlPrefix = UserContextUtil.getUserContext().getCurrentCompanyPrefix();
        Object baseUrl = null;
        Object isInstalled = null;
        Object id = null;
        ArrayList<JiraConnectVO> jiraConnectList = new ArrayList<JiraConnectVO>();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"urlPrefix").is((Object)urlPrefix));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("atlassianHostDomain").find(query.getQueryObject());
        while (dbCursorPrefix.hasNext()) {
            Object hostDomainId = null;
            DBObject dbObject = dbCursorPrefix.next();
            DBRef hostRef = (DBRef)dbObject.get("host");
            hostDomainId = dbObject.get("_id");
            query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(hostRef.getId()));
            DBCursor dbCursorDomain = this.customRepositoryImpl.getMongoTemplate().getCollection("atlassianHost").find(query.getQueryObject());
            while (dbCursorDomain.hasNext()) {
                DBObject dbObjectHost = dbCursorDomain.next();
                baseUrl = dbObjectHost.get("baseUrl");
                isInstalled = dbObjectHost.get("addonInstalled");
            }
            if (!PropertyValidator.isValid(isInstalled) || !"true".equalsIgnoreCase(String.valueOf(isInstalled))) continue;
            JiraConnectVO jiraConnectVO = new JiraConnectVO();
            jiraConnectVO.setJiraHostUrl(String.valueOf(baseUrl));
            jiraConnectVO.setId(String.valueOf(hostDomainId));
            jiraConnectList.add(jiraConnectVO);
            query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"atlassianHostDomain.$id").is((Object)new ObjectId(String.valueOf(hostDomainId))));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"kendisUserId").is((Object)UserContextUtil.getUserContext().getLoggedInUser().getUserName()));
            DBCursor dbCursorDomainUser = this.customRepositoryImpl.getMongoTemplate().getCollection("atlassianHostDomainUser").find(query.getQueryObject());
            if (!dbCursorDomainUser.hasNext()) continue;
            DBObject dbObjectHost = dbCursorDomainUser.next();
            jiraConnectVO.setJiraUserName(String.valueOf(dbObjectHost.get("jiraUserId")));
        }
        return jiraConnectList;
    }

    public JiraConnectVO getConnectAccount(String hostDomainIdStr) {
        Object baseUrl = null;
        Object defaultUserKey = null;
        JiraConnectVO jiraConnectVO = null;
        Object isInstalled = null;
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(hostDomainIdStr)));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("atlassianHostDomain").find(query.getQueryObject());
        if (dbCursorPrefix.hasNext()) {
            Object hostDomainId = null;
            DBObject dbObject = dbCursorPrefix.next();
            DBRef hostRef = (DBRef)dbObject.get("host");
            hostDomainId = dbObject.get("_id");
            defaultUserKey = dbObject.get("jiraUserId");
            query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(hostRef.getId()));
            DBCursor dbCursorDomain = this.customRepositoryImpl.getMongoTemplate().getCollection("atlassianHost").find(query.getQueryObject());
            while (dbCursorDomain.hasNext()) {
                DBObject dbObjectHost = dbCursorDomain.next();
                baseUrl = dbObjectHost.get("baseUrl");
                isInstalled = dbObjectHost.get("addonInstalled");
            }
            jiraConnectVO = new JiraConnectVO();
            jiraConnectVO.setJiraHostUrl(String.valueOf(baseUrl));
            jiraConnectVO.setId(String.valueOf(hostDomainId));
            jiraConnectVO.setJiraKey(defaultUserKey.toString());
            if (PropertyValidator.isValid((Object)isInstalled)) {
                jiraConnectVO.setAddonInstalled(new Boolean(String.valueOf(isInstalled)));
            } else {
                jiraConnectVO.setAddonInstalled(new Boolean(false));
            }
            return jiraConnectVO;
        }
        return jiraConnectVO;
    }

    public JiraConnectVO getConnectAccountByCompanyPrefix(String companyPrefix) {
        Object baseUrl = null;
        Object defaultUserKey = null;
        JiraConnectVO jiraConnectVO = null;
        Object isInstalled = null;
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"urlPrefix").is((Object)companyPrefix));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("atlassianHostDomain").find(query.getQueryObject());
        if (dbCursorPrefix.hasNext()) {
            Object hostDomainId = null;
            DBObject dbObject = dbCursorPrefix.next();
            DBRef hostRef = (DBRef)dbObject.get("host");
            hostDomainId = dbObject.get("_id");
            defaultUserKey = dbObject.get("jiraUserId");
            query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(hostRef.getId()));
            DBCursor dbCursorDomain = this.customRepositoryImpl.getMongoTemplate().getCollection("atlassianHost").find(query.getQueryObject());
            while (dbCursorDomain.hasNext()) {
                DBObject dbObjectHost = dbCursorDomain.next();
                baseUrl = dbObjectHost.get("baseUrl");
                isInstalled = dbObjectHost.get("addonInstalled");
            }
            jiraConnectVO = new JiraConnectVO();
            jiraConnectVO.setJiraHostUrl(String.valueOf(baseUrl));
            jiraConnectVO.setId(String.valueOf(hostDomainId));
            jiraConnectVO.setJiraKey(defaultUserKey.toString());
            if (PropertyValidator.isValid((Object)isInstalled)) {
                jiraConnectVO.setAddonInstalled(new Boolean(String.valueOf(isInstalled)));
            } else {
                jiraConnectVO.setAddonInstalled(new Boolean(false));
            }
            return jiraConnectVO;
        }
        return jiraConnectVO;
    }

    public String getJiraSignupInfo(String accountId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"jiraAccountId").is((Object)accountId));
        DBCursor dbCursorDomainUser = this.customRepositoryImpl.getMongoTemplate().getCollection("atlassianHostDomainUser").find(query.getQueryObject());
        if (dbCursorDomainUser.hasNext()) {
            DBObject dbObjectHost = dbCursorDomainUser.next();
            return String.valueOf(dbObjectHost.get("jiraSignupInfo"));
        }
        return null;
    }

    public JiraConnectVO getConnectAccountUser(String hostDomainId) {
        Object jiraUserKey = null;
        if (UserContextUtil.getUserContext() == null) {
            return null;
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"atlassianHostDomain.$id").is((Object)new ObjectId(hostDomainId)).and("kendisUserId").is((Object)UserContextUtil.getUserContext().getUsername()));
        DBCursor dbCursorDomainUser = this.customRepositoryImpl.getMongoTemplate().getCollection("atlassianHostDomainUser").find(query.getQueryObject());
        while (dbCursorDomainUser.hasNext()) {
            DBObject dbObjectHost = dbCursorDomainUser.next();
            jiraUserKey = dbObjectHost.get("jiraUserId");
        }
        JiraConnectVO jiraConnectVO = new JiraConnectVO();
        jiraConnectVO.setJiraKey(String.valueOf(jiraUserKey));
        return jiraConnectVO;
    }

    public void saveAtlassianHostDomainUser(String atlassianHostDomainId, String jiraUserId, String jiraAccountId, String kendisUserId) {
        BasicDBObject atlassianHostDomainUserObjQuery = new BasicDBObject();
        atlassianHostDomainUserObjQuery.put((Object)"jiraUserId", (Object)jiraUserId);
        atlassianHostDomainUserObjQuery.put((Object)"jiraAccountId", (Object)jiraAccountId);
        atlassianHostDomainUserObjQuery.put((Object)"kendisUserId", (Object)kendisUserId);
        DBRef ref = new DBRef("atlassianHostDomain", (Object)new ObjectId(atlassianHostDomainId));
        atlassianHostDomainUserObjQuery.put((Object)"atlassianHostDomain", (Object)ref);
        this.mongoTemplate.save((Object)atlassianHostDomainUserObjQuery, "atlassianHostDomainUser");
    }

    public void activeConnectAccount(JiraConnectVO jiraConnectVO) {
    }

    public String findJiraUserForConnect(JiraConnectVO jiraConnectVO, AlmAccount almAcc) {
        LOGGER.trace("INSIDE findJiraUserForConnect  .");
        almAcc.setByPassJiraUserMatch(true);
        if (UserContextUtil.getUserContext() == null) {
            return this.getConnectAccount(almAcc.getAtlassianHostDomainId()).getJiraKey();
        }
        return this.getConnectAccountUser(almAcc.getAtlassianHostDomainId()).getJiraKey();
    }

    public String searchFromJira(String url, AlmAccount almAccount) throws ViztrendJiraException {
        return this.importUtil.searchFromJira(url, almAccount);
    }

    public ArrayList<JiraIssue> retrieveAndSaveVersionData(AlmAccount almAccount, String versionId) {
        boolean startAt = false;
        int pageSize = 100;
        boolean totalRecord = false;
        String jql = "fixVersion = " + versionId;
        Gson gson = new Gson();
        ArrayList<JiraField> fields = new ArrayList<JiraField>();
        fields.add(new JiraField("id", "id", "id"));
        fields.add(new JiraField("summary", "summary", "summary"));
        ArrayList<JiraIssue> convertedItems = new ArrayList<JiraIssue>();
        LOGGER.error("Invalid request payload. Refer to the REST API (/rest/api/3/search/jql) documentation and try again. ");
        return convertedItems;
    }

    @Deprecated
    public Map<String, Object> refreshData(HashMap<String, Object> param) {
        HashMap<String, Object> finalResult = new HashMap<String, Object>();
        return finalResult;
    }

    public HashMap<String, Object> fetchJiraEpicItems(List<String> jiraIds, JiraFilter filter, AlmAccount almAccount, ResyncParamsVO resyncParams) {
        Gson gson = new Gson();
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        try {
            Object existingItem;
            String link;
            almAccount = this.almAccountRepository.findById(almAccount.getId());
            HashSet<String> jiraIdsForART = new HashSet<String>();
            ArrayList<Item> parentItems = new ArrayList<Item>();
            ArrayList<Item> childItems = new ArrayList<Item>();
            List<Item> existingParent = new ArrayList();
            List existingChild = new ArrayList();
            ArrayList<Item> allNewFeatures = new ArrayList<Item>();
            ArrayList<Item> existingSolutionFeaturesToUpdate = new ArrayList<Item>();
            List kendisOnlyEpics = new ArrayList();
            ArrayList<String> kendisOnlyEpicIds = new ArrayList<String>();
            ArrayList tempNewEpicFeatures = new ArrayList();
            List newStatuses = new ArrayList();
            HashMap<String, Item> existingChildByJiraId = new HashMap<String, Item>();
            HashMap<String, Item> existingParentByJiraId = new HashMap<String, Item>();
            HashMap<String, String> parentIdByJiraKey = new HashMap<String, String>();
            HashMap<String, Item> existingParentByKendisKey = new HashMap<String, Item>();
            HashMap<String, Item> missingParentById = new HashMap<String, Item>();
            HashMap<String, Item> missingChildById = new HashMap<String, Item>();
            HashMap newFeatureSetByEpicKey = new HashMap();
            HashMap<String, Object> existingRelation = new HashMap<String, Object>();
            HashMap<String, Object> existingKendisRelation = new HashMap<String, Object>();
            ArrayList<EpicFeature> newEpicFeatures = new ArrayList<EpicFeature>();
            HashMap childSessionMap = new HashMap();
            List sessions = this.sessionRepository.findByIdIn((List)resyncParams.solutionBoard.getPiSessions());
            resyncParams.almConfigurations.setAlmAccount(almAccount);
            resyncParams.filter = filter;
            resyncParams.newProjects = new LinkedHashSet();
            resyncParams.sessions = sessions;
            resyncParams.links = new HashMap();
            resyncParams.parentKeys = new HashSet();
            resyncParams.childKeys = new HashSet();
            for (BacklogMappingLinks mapping : filter.getFeatureLinkMappings()) {
                resyncParams.links.put(mapping.getProjectKey(), mapping.getLinkTypes());
            }
            resyncParams.itemTypeParent = Item.Type.Epic.name();
            resyncParams.itemTypeChild = Item.Type.Feature.name();
            this.setupMetaForResync(resyncParams, almAccount);
            this.fetchParentChildJiraData(resyncParams, almAccount, filter.getFeatureLinkMappings(), null);
            ArrayList settings = resyncParams.solutionBoard.getSolutionAlmSettings();
            List jiraLinkTypes = new ArrayList();
            ArrayList linksToBeDeleted = new ArrayList();
            ArrayList<ItemJiraDependency> dependenciesToSave = new ArrayList<ItemJiraDependency>();
            if (PropertyValidator.isValid((Collection)settings)) {
                for (Object setting : settings) {
                    if (!Boolean.TRUE.equals(setting.getDependencyEnabled()) || !almAccount.getId().equals(setting.getAlmAccountId()) || !PropertyValidator.isValid((Collection)setting.getLinkTypes())) continue;
                    jiraLinkTypes = setting.getLinkTypes();
                    break;
                }
            }
            List existingEpicFeatures = this.epicFeaturesRepository.findByEpicKeyInAndSolutionBoardIdAndAlmFilterId((Collection)resyncParams.parentKeys, resyncParams.solutionBoard.getId(), resyncParams.filter.getId());
            kendisOnlyEpics = this.itemRepository.findBySolutionBoardAndKendisKeyNotNull(resyncParams.solutionBoard);
            for (Item kendisEpic : kendisOnlyEpics) {
                kendisOnlyEpicIds.add(kendisEpic.getKendisKey());
                existingParentByKendisKey.put(kendisEpic.getKendisKey(), kendisEpic);
            }
            List existingKendisEpicFeatures = this.epicFeaturesRepository.findByEpicKeyInAndSolutionBoardId(kendisOnlyEpicIds, resyncParams.solutionBoard.getId());
            ArrayList<String> featureIdsFromExistingKendisRelations = new ArrayList<String>();
            for (Object epicFeature : existingKendisEpicFeatures) {
                link = epicFeature.getEpicKey() + "_" + epicFeature.getFeatureId() + "_" + (epicFeature.getSessionId() == null ? "" : epicFeature.getSessionId());
                existingKendisRelation.put(link, epicFeature);
                featureIdsFromExistingKendisRelations.add(epicFeature.getFeatureId());
            }
            for (Object epicFeature : existingEpicFeatures) {
                link = epicFeature.getEpicKey() + "_" + epicFeature.getFeatureId() + "_" + (epicFeature.getSessionId() == null ? "" : epicFeature.getSessionId());
                existingRelation.put(link, epicFeature);
                resyncParams.childKeys.add(epicFeature.getFeatureKey());
            }
            List other = null;
            if (PropertyValidator.isValid(jiraIds)) {
                existingParent = this.itemRepository.findBySolutionBoardAndJiraIdInAndType(resyncParams.solutionBoard, jiraIds, Item.Type.Epic.toString());
            } else {
                existingParent = this.itemRepository.findBySolutionBoardAndJiraFilterAndType(resyncParams.solutionBoard, filter.getId(), Item.Type.Epic.toString());
                if (PropertyValidator.isValid((Collection)resyncParams.parentKeys)) {
                    other = this.itemRepository.findBySolutionBoardAndJiraKeyInAndType(resyncParams.solutionBoard, (Collection)resyncParams.parentKeys, Item.Type.Epic.toString());
                }
            }
            for (Item parent : existingParent) {
                existingParentByJiraId.put(parent.getJiraId(), parent);
                parentIdByJiraKey.put(parent.getJiraKey(), parent.getJiraId());
                missingParentById.put(parent.getId(), parent);
            }
            if (PropertyValidator.isValid(other)) {
                for (Item parent : other) {
                    if (missingParentById.containsKey(parent.getId())) continue;
                    existingParentByJiraId.put(parent.getJiraId(), parent);
                    parentIdByJiraKey.put(parent.getJiraKey(), parent.getJiraId());
                    missingParentById.put(parent.getId(), parent);
                }
            }
            ArrayList<ObjectId> activeSessionBoardIds = new ArrayList<ObjectId>();
            ArrayList<String> sessionIds = new ArrayList<String>();
            for (Session session : sessions) {
                activeSessionBoardIds.add(new ObjectId(session.getActiveSessionBoard()));
                sessionIds.add(session.getId());
            }
            if (!resyncParams.byPassChildSave) {
                existingChild = this.customRepositoryImpl.getMongoTemplate().find(KendisUtils.getChildQuery((String)resyncParams.solutionBoard.getId(), activeSessionBoardIds, (Collection)resyncParams.childKeys), Item.class);
                for (Item feature : existingChild) {
                    existingChildByJiraId.put(feature.getJiraKey(), feature);
                    if (!childSessionMap.containsKey(feature.getJiraKey())) {
                        childSessionMap.put(feature.getJiraKey(), new HashSet());
                    }
                    if (PropertyValidator.isValid((Collection)feature.getSessionBoards())) {
                        ((HashSet)childSessionMap.get(feature.getJiraKey())).add(((SessionBoard)feature.getSessionBoards().get(0)).getSession().getId());
                        continue;
                    }
                    missingChildById.put(feature.getId(), feature);
                }
            }
            List statuses = this.statusRepository.findBySolutionIdOrSessionIdIn(resyncParams.solutionBoard.getId(), sessionIds);
            Map statusMap = this.getStatusMapFromStatuses(statuses);
            HashMap<String, Object> fields = new HashMap<String, Object>();
            Double sysSequence = new Double(System.nanoTime() / 100000L);
            String wsjfScoreField = null;
            String wsjfScoreFieldForUnplannedFeatures = null;
            JiraField storyPointField = almAccount.getStoryPointField();
            JiraField dueDateField = almAccount.getDueDateField();
            if (!PropertyValidator.isValid((Object)storyPointField)) {
                storyPointField = this.jiraFieldRepository.findByNameIgnoreCaseAndAlmAccountId("Story Points", almAccount.getId());
            }
            if (!PropertyValidator.isValid((Object)dueDateField)) {
                dueDateField = this.jiraFieldRepository.findByJiraIdIgnoreCaseAndAlmAccountId("duedate", almAccount.getId());
            }
            if (PropertyValidator.isValid((Collection)resyncParams.solutionBoard.getSolutionBoardWsjFAlmConfiguration())) {
                for (SolutionBoardWsjFAlmConfiguration score : resyncParams.solutionBoard.getSolutionBoardWsjFAlmConfiguration()) {
                    if (!PropertyValidator.isValid((Object)score.getType().equals("jira")) || !score.getAlmId().equals(almAccount.getId())) continue;
                    wsjfScoreField = score.getAlmField();
                    wsjfScoreFieldForUnplannedFeatures = score.getAlmFieldForUnplannedFeatures();
                }
            }
            fields.put("Sprint", resyncParams.sprintField);
            fields.put("Story Points", storyPointField);
            fields.put("duedate", dueDateField);
            fields.put("sequence", sysSequence);
            fields.put("score", wsjfScoreField);
            fields.put("scoreUnplannedFeatures", wsjfScoreFieldForUnplannedFeatures);
            existingParent = new ArrayList();
            for (JiraIssue jiraIssue : resyncParams.jiraIssuesParent) {
                Double score;
                fields.put("sequence", (Double)fields.get("sequence") + 1000.0);
                Item item = jiraIssue.getItemFromJiraIssue(fields, resyncParams.extraFields, almAccount);
                item.setAlmId(almAccount.getId());
                if (PropertyValidator.isValid((Object)wsjfScoreField) && PropertyValidator.isValid(jiraIssue.getMapFields().get(wsjfScoreField)) && PropertyValidator.isValid((Object)(score = (Double)jiraIssue.getMapFields().get(wsjfScoreField)))) {
                    item.setAlmScoreField(score);
                }
                HashMap<String, ItemJiraDependency> jiraLinksByIdMap = new HashMap<String, ItemJiraDependency>();
                if (existingParentByJiraId.containsKey(jiraIssue.getJiraId())) {
                    item.setSolutionBoard(resyncParams.solutionBoard);
                    existingItem = (Item)existingParentByJiraId.get(item.getJiraId());
                    item.setId(existingItem.getId());
                    item.setSequence(existingItem.getSequence());
                    item.setBacklogSequence(existingItem.getBacklogSequence());
                    item.setItemLinks(existingItem.getItemLinks());
                    item.setLinkTypes(existingItem.getLinkTypes());
                    item.setLinkType(existingItem.getLinkType());
                    item.setIssueType(existingItem.getIssueType());
                    item.setOriginItemId(existingItem.getOriginItemId());
                    item.setDuplicateOfId(existingItem.getDuplicateOfId());
                    item.setScore(existingItem.getScore());
                    item.setScoreParams(existingItem.getScoreParams());
                    item.setJiraFilter(resyncParams.filter.getId());
                    item.setStatus(jiraIssue.getItemStatus((Item)existingItem, statusMap, newStatuses));
                    item.setSolutionSourceItemLinks(existingItem.getSolutionSourceItemLinks());
                    item.setSolutionTargetItemLinks(existingItem.getSolutionTargetItemLinks());
                    missingParentById.remove(item.getId());
                    if (PropertyValidator.isValid((Collection)existingItem.getJiraDependencies())) {
                        for (ItemJiraDependency dependency : existingItem.getJiraDependencies()) {
                            if (!PropertyValidator.isValid((Object)dependency)) continue;
                            jiraLinksByIdMap.put(dependency.getJiraDependencyId(), dependency);
                        }
                    }
                } else {
                    item.setSolutionBoard(resyncParams.solutionBoard);
                    item.setId(ObjectId.get().toString());
                    existingParentByJiraId.put(jiraIssue.getJiraId(), item);
                    parentIdByJiraKey.put(jiraIssue.getKey(), jiraIssue.getJiraId());
                    item.setStatus(jiraIssue.getItemStatus(item, statusMap, newStatuses));
                    existingParent.add(item);
                    jiraIdsForART.add(item.getJiraId());
                }
                item.setJiraDependencies(this.getFeatureDependencyIssues(jiraIssue, jiraLinkTypes, jiraIssue.getId(), null, jiraLinksByIdMap, linksToBeDeleted, null, null));
                for (ItemJiraDependency link2 : item.getJiraDependencies()) {
                    if (!PropertyValidator.isValid((Object)link2)) continue;
                    if (link2.getId() == null) {
                        link2.setId(ObjectId.get().toString());
                    }
                    link2.setSourceItemId(item.getId());
                    link2.setSolutionId(resyncParams.solutionBoard.getId());
                    dependenciesToSave.add(link2);
                }
                if (!PropertyValidator.isValid((Collection)item.getLinkTypes())) {
                    item.setLinkTypes((List)resyncParams.links.get(item.getJiraProjectKey()));
                }
                if (item.getJiraFieldByKey() != null) {
                    item.getJiraFieldByKey().remove(null);
                }
                parentItems.add(item);
            }
            for (JiraIssue jiraIssue : resyncParams.jiraIssuesChild) {
                String jid;
                Double score;
                boolean doneSkip = true;
                fields.put("sequence", (Double)fields.get("sequence") + 1000.0);
                Item item = jiraIssue.getItemFromJiraIssue(fields, resyncParams.extraFields, almAccount);
                item.setAlmId(almAccount.getId());
                if (existingChildByJiraId.containsKey(item.getJiraKey())) {
                    item.setSolutionBoard(resyncParams.solutionBoard);
                    existingItem = (Item)existingChildByJiraId.get(item.getJiraKey());
                    item.setId(existingItem.getId());
                    item.setSequence(existingItem.getSequence());
                    item.setBacklogSequence(existingItem.getBacklogSequence());
                    item.setItemLinks(existingItem.getItemLinks());
                    item.setLinkTypes(existingItem.getLinkTypes());
                    item.setLinkType(existingItem.getLinkType());
                    item.setIssueType(existingItem.getIssueType());
                    item.setOriginItemId(existingItem.getOriginItemId());
                    item.setDuplicateOfId(existingItem.getDuplicateOfId());
                    item.setScore(existingItem.getScore());
                    item.setScoreParams(existingItem.getScoreParams());
                    item.setStatus(jiraIssue.getItemStatus((Item)existingItem, statusMap, newStatuses));
                    if (PropertyValidator.isValid((Collection)existingItem.getSessionBoards())) {
                        doneSkip = false;
                    } else {
                        item.setJiraFilter(resyncParams.filter.getId());
                    }
                    item.setSolutionSourceItemLinks(existingItem.getSolutionSourceItemLinks());
                    item.setSolutionTargetItemLinks(existingItem.getSolutionTargetItemLinks());
                    existingSolutionFeaturesToUpdate.add(item);
                    missingChildById.remove(item.getId());
                } else {
                    item.setId(ObjectId.get().toString());
                    item.setSolutionBoard(resyncParams.solutionBoard);
                    existingChildByJiraId.put(item.getJiraKey(), item);
                    item.setStatus(jiraIssue.getItemStatus(item, statusMap, newStatuses));
                    allNewFeatures.add(item);
                    jiraIdsForART.add(item.getJiraId());
                }
                if (!PropertyValidator.isValid((Collection)item.getSessionBoards()) && PropertyValidator.isValid((Object)wsjfScoreFieldForUnplannedFeatures) && PropertyValidator.isValid(jiraIssue.getMapFields().get(wsjfScoreFieldForUnplannedFeatures)) && PropertyValidator.isValid((Object)(score = (Double)jiraIssue.getMapFields().get(wsjfScoreFieldForUnplannedFeatures)))) {
                    item.setAlmScoreField(score);
                }
                String key = null;
                Item parent = (Item)existingParentByJiraId.get(jiraIssue.getJiraParentId());
                if (parent == null && (jid = (String)parentIdByJiraKey.get(jiraIssue.getJiraParentId())) != null) {
                    parent = (Item)existingParentByJiraId.get(jid);
                }
                if (!newFeatureSetByEpicKey.containsKey(key = parent == null ? jiraIssue.getJiraParentId() : parent.getJiraId() + "_" + parent.getJiraKey())) {
                    newFeatureSetByEpicKey.put(key, new HashSet());
                }
                if (childSessionMap.containsKey(item.getJiraKey())) {
                    Set ss = (Set)childSessionMap.get(item.getJiraKey());
                    if (PropertyValidator.isValid((Collection)ss)) {
                        for (String s : ss) {
                            ((Set)newFeatureSetByEpicKey.get(key)).add(item.getJiraKey() + "_" + s);
                        }
                    } else {
                        ((Set)newFeatureSetByEpicKey.get(key)).add(item.getJiraKey() + "_");
                    }
                } else {
                    ((Set)newFeatureSetByEpicKey.get(key)).add(item.getJiraKey() + "_");
                }
                if (item.getJiraFieldByKey() != null) {
                    item.getJiraFieldByKey().remove(null);
                }
                if (!doneSkip) continue;
                childItems.add(item);
            }
            if (PropertyValidator.isValid(newStatuses)) {
                newStatuses = this.statusRepository.save(newStatuses);
            }
            if (!resyncParams.isReadOnly) {
                Object key;
                if (PropertyValidator.isValid(parentItems)) {
                    List subSetsParentItems = Lists.partition(new ArrayList(parentItems), (int)100);
                    ArrayList tempParentItems = new ArrayList();
                    for (List subSetParentItems : subSetsParentItems) {
                        tempParentItems.addAll(this.itemRepository.save((Iterable)subSetParentItems));
                    }
                    parentItems = tempParentItems;
                }
                if (PropertyValidator.isValid(childItems)) {
                    List subSetsChildItems = Lists.partition(new ArrayList(childItems), (int)100);
                    ArrayList tempChildItems = new ArrayList();
                    for (List subSetChildItems : subSetsChildItems) {
                        tempChildItems.addAll(this.itemRepository.save((Iterable)subSetChildItems));
                    }
                }
                ArrayList<String> delIds = new ArrayList<String>();
                Set keys = missingParentById.keySet();
                for (String key2 : keys) {
                    delIds.add(((Item)missingParentById.get(key2)).getId());
                    jiraIdsForART.add(((Item)missingParentById.get(key2)).getJiraId());
                }
                keys = missingChildById.keySet();
                for (String key2 : keys) {
                    delIds.add(((Item)missingChildById.get(key2)).getId());
                    jiraIdsForART.add(((Item)missingChildById.get(key2)).getJiraId());
                }
                this.itemRepository.deleteByIdIn(delIds);
                for (Iterator epic : newFeatureSetByEpicKey.keySet()) {
                    String[] id_Key = ((String)((Object)epic)).split("_");
                    String epicKey = id_Key[1];
                    Set newFeatureKeys = newFeatureSetByEpicKey.containsKey(epic) ? (Set)newFeatureSetByEpicKey.get(epic) : new HashSet();
                    if (!PropertyValidator.isValid(newFeatureKeys)) continue;
                    for (String key3 : newFeatureKeys) {
                        EpicFeature epicFeature = new EpicFeature();
                        epicFeature.setEpicKey(epicKey);
                        epicFeature.setEpicId(((Item)existingParentByJiraId.get(id_Key[0])).getId());
                        String[] featureKey = key3.split("_");
                        epicFeature.setFeatureKey(featureKey[0]);
                        Item child = (Item)existingChildByJiraId.get(featureKey[0]);
                        epicFeature.setFeatureId(child.getId());
                        epicFeature.setSolutionBoardId(resyncParams.solutionBoard.getId());
                        epicFeature.setAlmFilterId(resyncParams.filter.getId());
                        if (featureKey.length > 1) {
                            epicFeature.setSessionId(featureKey[1]);
                        }
                        newEpicFeatures.add(epicFeature);
                        String link3 = epicFeature.getEpicKey() + "_" + epicFeature.getFeatureId() + "_" + (epicFeature.getSessionId() == null ? "" : epicFeature.getSessionId());
                        if (!existingRelation.containsKey(link3)) continue;
                        epicFeature.setId(((EpicFeature)existingRelation.get(link3)).getId());
                        existingRelation.remove(link3);
                    }
                }
                if (PropertyValidator.isValid(newEpicFeatures)) {
                    List subSetsNewEpicFeatures = Lists.partition(new ArrayList(newEpicFeatures), (int)100);
                    for (List subSetEpics : subSetsNewEpicFeatures) {
                        tempNewEpicFeatures.addAll(this.epicFeaturesRepository.save((Iterable)subSetEpics));
                        LOGGER.debug(" epic feature relationship ....  ");
                    }
                }
                ArrayList<String> newEfFeatureIds = new ArrayList<String>();
                for (EpicFeature epicFeature : newEpicFeatures) {
                    newEfFeatureIds.add(epicFeature.getFeatureId());
                }
                HashMap kendisEpicFeaturesToRemove = new HashMap();
                for (Map.Entry ef : existingKendisRelation.entrySet()) {
                    key = ((String)ef.getKey()).split("_");
                    if (!featureIdsFromExistingKendisRelations.contains(key[1]) || !newEfFeatureIds.contains(key[1])) continue;
                    kendisEpicFeaturesToRemove.put(ef.getKey(), ef.getValue());
                }
                existingRelation.putAll(kendisEpicFeaturesToRemove);
                this.epicFeaturesRepository.delete(existingRelation.values());
                if (PropertyValidator.isValid(dependenciesToSave)) {
                    for (ItemJiraDependency link2 : dependenciesToSave) {
                        if (!PropertyValidator.isValid((Object)link2.getTargetJiraIssue())) continue;
                        key = link2.getTargetJiraIssue().getKey();
                        String id = link2.getTargetJiraIssue().getId();
                        if (existingParentByJiraId.containsKey(id)) {
                            link2.setTargetItemId(((Item)existingParentByJiraId.get(id)).getId());
                            continue;
                        }
                        if (!existingChildByJiraId.containsKey(key)) continue;
                        link2.setTargetItemId(((Item)existingChildByJiraId.get(key)).getId());
                    }
                    this.itemJiraDependencyRepository.save(dependenciesToSave);
                }
                if (PropertyValidator.isValid(linksToBeDeleted)) {
                    this.itemJiraDependencyRepository.delete(linksToBeDeleted);
                }
                this.releaseTrainService.syncWithBoards(almAccount.getTenant(), almAccount, jiraIdsForART);
            }
            responseMap.put("newFeatures", allNewFeatures);
            if ("ResyncData".equals(resyncParams.event)) {
                responseMap.put("updatedFeatures", existingSolutionFeaturesToUpdate);
                responseMap.put("epics", parentItems);
            } else {
                responseMap.put("updatedFeatures", new ArrayList());
                responseMap.put("epics", existingParent);
            }
            responseMap.put("epicFeatureMap", newEpicFeatures);
        }
        catch (Exception e) {
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error(" :: JsonProcessingException ..  " + err);
            HashMap<String, String> exp = new HashMap<String, String>();
            if (resyncParams.filter != null) {
                exp.put("filterId", resyncParams.filter.getId());
            }
            if (almAccount != null) {
                exp.put("almAccountId", almAccount.getId());
            }
            exp.put("kendisError", err);
            if (e instanceof ViztrendJiraException) {
                exp.put("almError", (String)((ViztrendJiraException)((Object)e)).getAlmError());
            }
            KendisUtils.onResyncError((String)resyncParams.syncId, null, (String)gson.toJson(exp), (String)resyncParams.getBoardId(), (PushResponseRepository)this.pushResponseRepository);
        }
        return responseMap;
    }

    public Map<String, Object> getMetaForItemFields(ResyncParamsVO resyncParams, AlmAccount almAccount) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        JiraField storyPointField = almAccount.getStoryPointField();
        JiraField dueDateField = almAccount.getDueDateField();
        JiraField startDateField = almAccount.getStartDateField();
        JiraField endDateField = almAccount.getEndDateField();
        if (!PropertyValidator.isValid((Object)storyPointField)) {
            storyPointField = this.jiraFieldRepository.findByNameIgnoreCaseAndAlmAccountId("Story Points", almAccount.getId());
        }
        if (!PropertyValidator.isValid((Object)dueDateField)) {
            dueDateField = this.jiraFieldRepository.findByJiraIdIgnoreCaseAndAlmAccountId("duedate", almAccount.getId());
        }
        if (!PropertyValidator.isValid((Object)startDateField)) {
            startDateField = this.jiraFieldRepository.findByJiraIdIgnoreCaseAndAlmAccountId("startDate", almAccount.getId());
        }
        if (!PropertyValidator.isValid((Object)endDateField)) {
            endDateField = this.jiraFieldRepository.findByJiraIdIgnoreCaseAndAlmAccountId("endDate", almAccount.getId());
        }
        fields.put("jiraFilterId", resyncParams.filter.getId());
        fields.put("sessionBoardId", resyncParams.sessionBoardId);
        fields.put("Sprint", resyncParams.sprintField);
        fields.put("Story Points", storyPointField);
        fields.put("duedate", dueDateField);
        fields.put("startDate", startDateField);
        fields.put("endDate", endDateField);
        if (PropertyValidator.isValid((Object)almAccount.getNextGenStoryPointField())) {
            List jiraProjectIssueTypes = this.jiraProjectIssueTypesRepository.findProjectStyleByAlmAccountId(almAccount.getId());
            HashMap jiraProjectStylesByKey = new HashMap();
            if (PropertyValidator.isValid((Collection)jiraProjectIssueTypes)) {
                jiraProjectIssueTypes.forEach(issueType -> jiraProjectStylesByKey.put(issueType.getJiraProjectKey(), issueType.getStyle()));
            }
            fields.put("jiraProjectStylesByKey", jiraProjectStylesByKey);
            fields.put("NG Story Points", almAccount.getNextGenStoryPointField());
        }
        return fields;
    }

    public void setupMetaForResync(ResyncParamsVO resyncParams, AlmAccount almAccount) {
        AlmAccount taggedAlmAccount;
        if (PropertyValidator.isValid((Object)resyncParams.userMapping)) {
            User user;
            AlmAccount taggedAlmAccount2;
            resyncParams.keyText = (String)resyncParams.userMapping.get(resyncParams.filter.getId());
            if (resyncParams.keyText == null) {
                resyncParams.keyText = resyncParams.filter.getFilterFetchedBy() != null && resyncParams.filter.getFilterFetchedBy().getId() != null ? (String)resyncParams.userMapping.get("0_" + resyncParams.filter.getFilterFetchedBy().getId()) : (String)resyncParams.userMapping.get("0_0");
            }
            if (resyncParams.keyText != null && !"0".equals(resyncParams.keyText) && PropertyValidator.isValid((Object)(taggedAlmAccount2 = JiraUtils.getTaggedAlmUser((User)(user = (User)this.userRepository.findOne((Serializable)((Object)resyncParams.keyText))), (AlmAccount)almAccount)))) {
                almAccount = taggedAlmAccount2;
                almAccount.setIsSelectedOnResync(Boolean.valueOf(true));
            }
        } else if (PropertyValidator.isValid((Object)resyncParams.filter.getFilterFetchedBy()) && PropertyValidator.isValid((Object)(taggedAlmAccount = JiraUtils.getTaggedAlmUser((User)resyncParams.filter.getFilterFetchedBy(), (AlmAccount)almAccount)))) {
            almAccount = taggedAlmAccount;
        }
        resyncParams.almConfigurations.setAlmAccount(almAccount);
        if (PropertyValidator.isValid((Object)resyncParams.filter.getId()) && !resyncParams.filter.getId().contains("AddExisting")) {
            JiraFilter jiraFilterLatest;
            this.jiraIssueRepository.deleteBySessionBoardIdAndJiraFilterId(resyncParams.getBoardId(), resyncParams.filter.getId());
            if (!Boolean.TRUE.equals(resyncParams.filter.getCustom()) && resyncParams.validateFilter && PropertyValidator.isValid((Object)(jiraFilterLatest = this.importUtil.retrieveFilterByJiraId(resyncParams.filter.getId(), almAccount.getUsername(), almAccount.getPassword(), almAccount))) && PropertyValidator.isValid((Object)jiraFilterLatest.getJql())) {
                resyncParams.filter.setJql(jiraFilterLatest.getJql());
            }
        } else if (PropertyValidator.isValid((Object)resyncParams.jiraIssueFilterMap) && !resyncParams.jiraIssueFilterMap.isEmpty()) {
            this.jiraIssueRepository.deleteBySessionBoardIdAndJiraIdInOrJiraParentIdIn(resyncParams.getBoardId(), resyncParams.jiraIssueFilterMap.keySet(), resyncParams.jiraIssueFilterMap.keySet());
        }
        resyncParams.fields = new ArrayList();
        resyncParams.fields.add(almAccount.getStoryPointField());
        if (PropertyValidator.isValid((Object)almAccount.getNextGenStoryPointField())) {
            resyncParams.fields.add(almAccount.getNextGenStoryPointField());
        }
        if (PropertyValidator.isValid((Object)almAccount.getStartDateField())) {
            resyncParams.fields.add(almAccount.getStartDateField());
        }
        if (PropertyValidator.isValid((Object)almAccount.getEndDateField())) {
            resyncParams.fields.add(almAccount.getEndDateField());
        }
        if (PropertyValidator.isValid((Object)almAccount.getDueDateField())) {
            resyncParams.fields.add(almAccount.getDueDateField());
        }
        resyncParams.sprintField = this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountId("com.pyxis.greenhopper.jira:gh-sprint", almAccount.getId());
        resyncParams.epicLinkField = this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountId("com.pyxis.greenhopper.jira:gh-epic-link", almAccount.getId());
        JiraField field1 = this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountId("com.pyxis.greenhopper.jira:gh-epic-label", almAccount.getId());
        JiraField field2 = this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountId("com.pyxis.greenhopper.jira:gh-epic-color", almAccount.getId());
        JiraField field3 = this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountId("com.pyxis.greenhopper.jira:jsw-issue-color", almAccount.getId());
        JiraField field4 = this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountId("com.atlassian.teams:rm-teams-custom-field-team", almAccount.getId());
        JiraField field5 = this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountId("com.atlassian.jpo:jpo-custom-field-parent", almAccount.getId());
        if (PropertyValidator.isValid((Object)resyncParams.epicLinkField)) {
            resyncParams.fields.add(resyncParams.epicLinkField);
        }
        if (PropertyValidator.isValid((Object)resyncParams.sprintField)) {
            resyncParams.fields.add(resyncParams.sprintField);
        }
        if (PropertyValidator.isValid((Object)field1)) {
            resyncParams.fields.add(field1);
        }
        if (PropertyValidator.isValid((Object)field2)) {
            resyncParams.fields.add(field2);
        }
        if (PropertyValidator.isValid((Object)field3)) {
            resyncParams.fields.add(field3);
        }
        if (PropertyValidator.isValid((Object)field4)) {
            resyncParams.fields.add(field4);
        }
        if (PropertyValidator.isValid((Object)field5)) {
            resyncParams.fields.add(field5);
        }
        resyncParams.extraFields = new HashSet();
        if (resyncParams.sessions != null) {
            if (resyncParams.sessions.size() > 0) {
                for (Session session : resyncParams.sessions) {
                    resyncParams.extraFields.addAll(session.combineAdditionalFields(resyncParams.fields, null, true, null));
                    if (!PropertyValidator.isValid((Object)resyncParams.sprintField)) continue;
                    resyncParams.extraFields.add(new ItemJiraFieldMap(resyncParams.sprintField.getJiraId(), null, "JSONArray"));
                }
            } else {
                resyncParams.extraFields.addAll(new Session().combineAdditionalFields(resyncParams.fields, null, true, null));
                if (PropertyValidator.isValid((Object)resyncParams.sprintField)) {
                    resyncParams.extraFields.add(new ItemJiraFieldMap(resyncParams.sprintField.getJiraId(), null, "JSONArray"));
                }
            }
        } else {
            resyncParams.fields.add(new JiraField(JiraField.FIXED.reporter.name(), JiraField.FIXED.reporter.name(), JiraField.FIXED.reporter.name()));
            resyncParams.fields.add(new JiraField(JiraField.FIXED.assignee.name(), JiraField.FIXED.assignee.name(), JiraField.FIXED.assignee.name()));
            resyncParams.fields.add(new JiraField(JiraField.FIXED.issuetype.name(), JiraField.FIXED.issuetype.name(), JiraField.FIXED.issuetype.name()));
            resyncParams.fields.add(new JiraField(JiraField.FIXED.parent.name(), JiraField.FIXED.parent.name(), JiraField.FIXED.parent.name()));
            resyncParams.fields.add(new JiraField(JiraField.FIXED.summary.name(), JiraField.FIXED.summary.name(), JiraField.FIXED.summary.name()));
            resyncParams.fields.add(new JiraField(JiraField.FIXED.project.name(), JiraField.FIXED.project.name(), JiraField.FIXED.project.name()));
            resyncParams.fields.add(new JiraField(JiraField.FIXED.status.name(), JiraField.FIXED.status.name(), JiraField.FIXED.status.name()));
            resyncParams.fields.add(new JiraField(JiraField.FIXED.issuelinks.name(), JiraField.FIXED.issuelinks.name(), JiraField.FIXED.issuelinks.name()));
            resyncParams.fields.add(new JiraField(JiraField.FIXED.fixVersions.name(), JiraField.FIXED.fixVersions.name(), JiraField.FIXED.fixVersions.name()));
        }
        HashSet<JiraField> extraFields = null;
        if (PropertyValidator.isValid((Collection)resyncParams.almConfigurations.getTeamMappings())) {
            extraFields = new HashSet<JiraField>();
            for (BacklogMapping bm : resyncParams.almConfigurations.getTeamMappings()) {
                if (!PropertyValidator.isValid((Collection)bm.getJiraFieldMap())) continue;
                for (ItemJiraFieldMap ijf : bm.getJiraFieldMap()) {
                    extraFields.add(new JiraField(ijf.getKey(), ijf.getKey(), ijf.getKey()));
                }
            }
        }
        if (PropertyValidator.isValid(extraFields)) {
            resyncParams.fields.addAll(extraFields);
        }
        if (PropertyValidator.isValid((Object)resyncParams.solutionBoard) && PropertyValidator.isValid((Collection)resyncParams.solutionBoard.getSolutionBoardWsjFAlmConfiguration())) {
            for (SolutionBoardWsjFAlmConfiguration score : resyncParams.solutionBoard.getSolutionBoardWsjFAlmConfiguration()) {
                resyncParams.fields.add(new JiraField(score.getAlmField(), score.getAlmField(), score.getAlmField()));
                resyncParams.fields.add(new JiraField(score.getAlmFieldForUnplannedFeatures(), score.getAlmFieldForUnplannedFeatures(), score.getAlmFieldForUnplannedFeatures()));
            }
        }
        resyncParams.fields.add(new JiraField(JiraField.FIXED.updated.name(), JiraField.FIXED.updated.name(), JiraField.FIXED.updated.name()));
        resyncParams.fields.add(new JiraField(JiraField.FIXED.created.name(), JiraField.FIXED.created.name(), JiraField.FIXED.created.name()));
        if (!resyncParams.liveItemSync.booleanValue()) {
            resyncParams.jiraIssuesParent = new ArrayList();
            resyncParams.jiraIssuesChild = new HashSet();
        }
    }

    @Deprecated
    private void adjustSubItemTCs(Item subItem, Item parentItem, AlmConfigurations almConfigurations, List<ItemSyncMapper> syncMappers, JiraIssue jiraIssue, Map<String, Object> configFields) {
    }

    public void createScoreCard(Session session, Session savedSession) {
        if (Boolean.TRUE.equals(session.getWsjfEnabled())) {
            ScoreCard savedScoreCard = this.scoreCardRepository.findBySessionId(savedSession.getId());
            if (!PropertyValidator.isValid((Object)savedScoreCard)) {
                HashMap<String, ScoreParam> params = new HashMap<String, ScoreParam>();
                ScoreParam param1 = new ScoreParam();
                param1.setKey("param1");
                param1.setName("User-Business Value");
                param1.setAbbreviation("UBV");
                ArrayList<Object> allowedList = new ArrayList<Object>();
                ArrayList<Object> allowedListForJobSize = new ArrayList<Object>();
                allowedList.add("");
                for (int i = 1; i <= 20; ++i) {
                    allowedList.add(i);
                }
                param1.setAllowedValues(allowedList);
                param1.setMax((Object)20);
                param1.setMin((Object)1);
                param1.setDefaultValue((Object)0);
                param1.setDisplayType("DropDown");
                param1.setDataType("Integer");
                ScoreParam param2 = new ScoreParam();
                param2.setKey("param2");
                param2.setName("Time Criticality");
                param2.setAbbreviation("TC");
                param2.setMax((Object)20);
                param2.setMin((Object)1);
                param2.setAllowedValues(allowedList);
                param2.setDefaultValue((Object)0);
                param2.setDataType("Integer");
                param2.setDisplayType("DropDown");
                ScoreParam param3 = new ScoreParam();
                param3.setKey("param3");
                param3.setName("Risk Reduction(RR)/Opportunity Enablement(OE)");
                param3.setAbbreviation("RR/OE");
                param3.setMax((Object)20);
                param3.setMin((Object)1);
                param3.setAllowedValues(allowedList);
                param3.setDefaultValue((Object)0);
                param3.setDisplayType("DropDown");
                param3.setDataType("Integer");
                ScoreParam param4 = new ScoreParam();
                allowedListForJobSize.add("");
                if ("param4" != null) {
                    for (int i = 1; i <= 99; ++i) {
                        allowedListForJobSize.add(i);
                    }
                }
                param4.setKey("param4");
                param4.setName("Job Size");
                param4.setAbbreviation("Job Size");
                param4.setMax((Object)99);
                param4.setMin((Object)1);
                param4.setAllowedValues(allowedListForJobSize);
                param4.setDefaultValue((Object)0);
                param4.setDisplayType("TextField");
                param4.setDataType("Integer");
                params.put("param1", param1);
                params.put("param2", param2);
                params.put("param3", param3);
                params.put("param4", param4);
                savedScoreCard = new ScoreCard();
                savedScoreCard.setTitle(ScoreCard.Type.WSJF.toString() + "_" + savedSession.getTitle());
                savedScoreCard.setType(ScoreCard.Type.WSJF.toString());
                savedScoreCard.setSessionId(savedSession.getId());
                savedScoreCard.setCustom(false);
                savedScoreCard.setParams(params);
                savedScoreCard.setMaxCriteriaCardLimit(Integer.valueOf(20));
                savedScoreCard.setFormula("abc");
                this.scoreCardRepository.save((Object)savedScoreCard);
            }
            savedSession.setScoreCard(savedScoreCard);
        } else if (PropertyValidator.isValid((Object)session.getScoreCard())) {
            savedSession.setScoreCard(null);
        }
    }

    public void saveMappings(Session session, List<FieldMapping> fieldMappings) {
        ScoreCard savedScoreCard;
        if (session == null || fieldMappings == null) {
            return;
        }
        if (Boolean.TRUE.equals(session.getWsjfEnabled()) && PropertyValidator.isValid((Object)(savedScoreCard = this.scoreCardRepository.findBySessionId(session.getId())))) {
            savedScoreCard.setMappings(fieldMappings);
            this.scoreCardRepository.save((Object)savedScoreCard);
        }
    }

    public List<TeamSprintDependencyLimit> getTeamSprintDependencies(SessionBoard sessionBoard) {
        List dependencyLimit = null;
        dependencyLimit = this.TeamSprintDependencyLimitRepository.findBySessionId(sessionBoard.getSession().getId());
        if (!PropertyValidator.isValid((Collection)dependencyLimit)) {
            for (Team team : sessionBoard.getTeams()) {
                for (Container container : sessionBoard.getContainers()) {
                    TeamSprintDependencyLimit teamSprintLimit = new TeamSprintDependencyLimit();
                    teamSprintLimit.setSessionId(sessionBoard.getSession().getId());
                    teamSprintLimit.setSprintId(container.getId());
                    teamSprintLimit.setTeamId(team.getId());
                    dependencyLimit.add(teamSprintLimit);
                }
            }
            this.TeamSprintDependencyLimitRepository.save((Iterable)dependencyLimit);
        }
        return dependencyLimit;
    }

    public List<TeamSprintDependencyLimit> getTeamSprintDependencies(String sessionId) {
        List dependencyLimit = null;
        dependencyLimit = this.TeamSprintDependencyLimitRepository.findBySessionId(sessionId);
        return dependencyLimit;
    }

    public void updateTeamSprintDependencyOnAddTeam(SessionBoard sessionBoard, Team savedTeam) {
        ArrayList<TeamSprintDependencyLimit> dependencyLimit = new ArrayList<TeamSprintDependencyLimit>();
        TeamSprintDependencyLimit oldDependencyLimit = this.TeamSprintDependencyLimitRepository.findOneBySessionId(sessionBoard.getSession().getId());
        for (Container container : sessionBoard.getContainers()) {
            TeamSprintDependencyLimit teamSprintLimit = new TeamSprintDependencyLimit();
            teamSprintLimit.setSprintId(container.getId());
            teamSprintLimit.setSessionId(sessionBoard.getSession().getId());
            teamSprintLimit.setTeamId(savedTeam.getId());
            if (oldDependencyLimit != null) {
                teamSprintLimit.setLimit(oldDependencyLimit.getLimit());
            }
            dependencyLimit.add(teamSprintLimit);
        }
        this.TeamSprintDependencyLimitRepository.save(dependencyLimit);
    }

    public void updateTeamSprintDependencyOnAddContainer(SessionBoard sessionBoard, Container savedContainer) {
        ArrayList<TeamSprintDependencyLimit> dependencyLimit = new ArrayList<TeamSprintDependencyLimit>();
        TeamSprintDependencyLimit oldDependencyLimit = this.TeamSprintDependencyLimitRepository.findOneBySessionId(sessionBoard.getSession().getId());
        for (Team team : sessionBoard.getTeams()) {
            TeamSprintDependencyLimit teamSprintLimit = new TeamSprintDependencyLimit();
            teamSprintLimit.setSprintId(savedContainer.getId());
            teamSprintLimit.setSessionId(sessionBoard.getSession().getId());
            teamSprintLimit.setTeamId(team.getId());
            if (oldDependencyLimit != null) {
                teamSprintLimit.setLimit(oldDependencyLimit.getLimit());
            }
            dependencyLimit.add(teamSprintLimit);
        }
        this.TeamSprintDependencyLimitRepository.save(dependencyLimit);
    }

    public void setLinkMeta(ItemJiraDependency oldLink, ItemJiraDependency newLink) {
        oldLink.setDescription(newLink.getDescription());
        oldLink.setRaisedOn(newLink.getRaisedOn());
        oldLink.setReporter(newLink.getReporter());
        oldLink.setResponsible(newLink.getResponsible());
        oldLink.setRichDescription(newLink.getRichDescription());
        oldLink.setDueDate(newLink.getDueDate());
        oldLink.setWfStatus(newLink.getWfStatus());
        oldLink.setConversations(newLink.getConversations());
        oldLink.setWatcherList(newLink.getWatcherList());
        oldLink.setLineDirection(newLink.getLineDirection());
        oldLink.setLineDirectionSaveAs(newLink.getLineDirectionSaveAs());
        if (PropertyValidator.isValid((Object)oldLink.isStatusManuallySet()) || !oldLink.isStatusManuallySet()) {
            oldLink.setStatusManuallySet(true);
        }
        if (PropertyValidator.isValid((Object)oldLink.getDirection()) && PropertyValidator.isValid((Object)newLink.getLinkType())) {
            oldLink.setType(newLink.getLinkType().getJiraId() + "-" + oldLink.getDirection());
        }
    }

    public void syncDependencyMeta(ItemJiraDependency oldLink, ItemLink newLink) {
        oldLink.setDescription(newLink.getDescription());
        oldLink.setRaisedOn(newLink.getRaisedOn());
        oldLink.setReporter(newLink.getReporter());
        oldLink.setResponsible(newLink.getResponsible());
        oldLink.setRichDescription(newLink.getRichDescription());
        oldLink.setDueDate(newLink.getDueDate());
        oldLink.setWfStatus(newLink.getWfStatus());
        oldLink.setConversations(newLink.getConversations());
        oldLink.setWatcherList(newLink.getWatcherList());
        if (PropertyValidator.isValid((Object)oldLink.isStatusManuallySet()) || !oldLink.isStatusManuallySet()) {
            oldLink.setStatusManuallySet(true);
        }
    }

    public void syncDependencyMeta(ItemLink oldLink, ItemJiraDependency newLink) {
        oldLink.setDescription(newLink.getDescription());
        oldLink.setRaisedOn(newLink.getRaisedOn());
        oldLink.setReporter(newLink.getReporter());
        oldLink.setResponsible(newLink.getResponsible());
        oldLink.setRichDescription(newLink.getRichDescription());
        oldLink.setDueDate(newLink.getDueDate());
        oldLink.setWfStatus(newLink.getWfStatus());
        oldLink.setConversations(newLink.getConversations());
        oldLink.setWatcherList(newLink.getWatcherList());
    }

    public Object syncKendisAndAlmLink(Object link) {
        if (link instanceof ItemLink) {
            ItemLink itemLink = (ItemLink)link;
            List jiraDependencies = this.itemJiraDependencyRepository.findByJiraDependencyId(itemLink.getAlmLinkId());
            if (PropertyValidator.isValid((Collection)jiraDependencies)) {
                for (ItemJiraDependency jD : jiraDependencies) {
                    this.syncDependencyMeta(jD, itemLink);
                }
                this.itemJiraDependencyRepository.save((Iterable)jiraDependencies);
                return jiraDependencies;
            }
        } else if (link instanceof ItemJiraDependency) {
            ItemJiraDependency itemJiraDependency = (ItemJiraDependency)link;
            Item item = this.itemRepository.findById(itemJiraDependency.getSourceItemId() != null ? itemJiraDependency.getSourceItemId() : itemJiraDependency.getTargetItemId());
            ItemLink itemLink = null;
            if (PropertyValidator.isValid((Object)item) && PropertyValidator.isValid((Collection)item.getSessionBoards())) {
                itemLink = this.itemLinkRepository.findByAlmLinkIdAndSessionBoardId(itemJiraDependency.getJiraDependencyId(), ((SessionBoard)item.getSessionBoards().get(0)).getId());
            } else if (PropertyValidator.isValid((Object)itemJiraDependency.getSessionBoardId())) {
                itemLink = this.itemLinkRepository.findByAlmLinkIdAndSessionBoardId(itemJiraDependency.getJiraDependencyId(), itemJiraDependency.getSessionBoardId());
            }
            if (PropertyValidator.isValid(itemLink)) {
                this.syncDependencyMeta(itemLink, itemJiraDependency);
                this.itemLinkRepository.save((Object)itemLink);
                return itemLink;
            }
            return null;
        }
        return null;
    }

    public HashMap<String, Object> deleteKendisAndAlmLink(Object link, Item item, String id) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (PropertyValidator.isValid((Collection)item.getSessionBoards())) {
            ItemLink itemLink;
            ItemJiraDependency jD;
            List jiraDependencies;
            ItemLink itemLink2;
            if (link instanceof ItemLink && PropertyValidator.isValid((Object)(itemLink2 = (ItemLink)link).getAlmLinkId()) && PropertyValidator.isValid((Collection)(jiraDependencies = this.itemJiraDependencyRepository.findByJiraDependencyIdAndSessionBoardId(itemLink2.getAlmLinkId(), ((SessionBoard)item.getSessionBoards().get(0)).getId())))) {
                item.getJiraDependencies().removeAll(jiraDependencies);
                Item targetItem = this.itemRepository.findById(id);
                if (PropertyValidator.isValid((Object)targetItem)) {
                    targetItem.getJiraDependencies().removeAll(jiraDependencies);
                    this.itemRepository.save((Object)targetItem);
                }
                this.itemJiraDependencyRepository.delete((Iterable)jiraDependencies);
                response.put("jiraDependencies", jiraDependencies);
                return response;
            }
            if (link instanceof ItemJiraDependency && PropertyValidator.isValid((Object)(jD = (ItemJiraDependency)link).getJiraDependencyId()) && PropertyValidator.isValid((Object)(itemLink = this.itemLinkRepository.findByAlmLinkIdAndSessionBoardId(jD.getJiraDependencyId(), ((SessionBoard)item.getSessionBoards().get(0)).getId())))) {
                Item sourceItem = this.itemRepository.findById(itemLink.getSourceUserStoryId() != null ? itemLink.getSourceUserStoryId() : (itemLink.getSourceItemId() != null ? itemLink.getSourceItemId() : itemLink.getSourceFeatureId()));
                if (PropertyValidator.isValid((Object)sourceItem)) {
                    sourceItem.getItemLinks().remove(itemLink);
                    this.itemRepository.save((Object)sourceItem);
                }
                this.itemLinkRepository.delete((Object)itemLink);
                response.put("id", itemLink.getId());
                return response;
            }
        }
        return null;
    }

    public List<JiraProject> retrieveJiraProjectsByKeys(AlmAccount almAcc, Set<String> projectKeys) {
        try {
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            AlmAccUser almAccUser = this.planService.getUserAlmCredntials(almAcc.getId(), loggedInUser);
            String almUsername = "";
            String almPassword = "";
            if (PropertyValidator.isValid((Object)almAccUser)) {
                if (PropertyValidator.isValid((Object)almAccUser.getJiraOauthToken())) {
                    almAcc.setJiraOauthToken(almAccUser.getJiraOauthToken());
                    almAcc.setIsTaggedUser(Boolean.valueOf(true));
                    almAcc.setAdminAlmAcc(Boolean.valueOf(false));
                } else {
                    almAcc.setJiraOauthToken(null);
                    almUsername = almAccUser.getAlmUsername();
                    almPassword = almAccUser.getAlmPassword();
                    almAcc.setIsTaggedUser(Boolean.valueOf(true));
                    almAcc.setIsPatOnProfile(almAccUser.getIsPatOn());
                }
            } else {
                almUsername = almAcc.getUsername();
                almPassword = almAcc.getPassword();
                almAcc.setAdminAlmAcc(Boolean.valueOf(true));
            }
            almAcc.setOAuthTokenOwnerUserId(loggedInUser.getId());
            List projectList = this.importUtil.retrieveJiraProjectsListByKeys(almUsername, almPassword, almAcc, projectKeys);
            return projectList;
        }
        catch (Exception ex) {
            LOGGER.error("FAILED.. retrieveJiraProjectsByKeys .", (Throwable)ex);
            throw ex;
        }
    }

    public void saveJiraLinkType(List<JiraIssueLinkType> linkTypes, String almAccountId) {
        for (JiraIssueLinkType lt : linkTypes) {
            ItemLinkType inItemLinkType = new ItemLinkType(lt.getJiraId(), lt.getJiraId() + "-IN", lt.getInward(), almAccountId, lt.getSelf());
            this.itemLinkTypeRepository.save((Object)inItemLinkType);
            ItemLinkType outItemLinkType = new ItemLinkType(lt.getJiraId(), lt.getJiraId() + "-OUT", lt.getOutward(), almAccountId, lt.getSelf());
            this.itemLinkTypeRepository.save((Object)outItemLinkType);
        }
    }

    public Map<String, Object> retrieveJiraPaginatedProjects(AlmAccount almAccount, String projectName, int startAt) {
        HashMap response = new HashMap();
        if (PropertyValidator.isValid((Object)almAccount)) {
            response = this.importUtil.retrievePaginatedJiraProjectsList(almAccount, projectName, startAt);
        }
        return response;
    }

    public HashMap<String, Object> retrievePaginatedJiraBoardList(AlmAccount almAccount, String boardName, int startAt) throws Exception {
        HashMap boards = new HashMap();
        if (PropertyValidator.isValid((Object)almAccount)) {
            boards = this.importUtil.retrievePaginatedJiraBoards(almAccount, boardName, startAt);
        }
        return boards;
    }

    public synchronized UserBoardLocation saveUserBoardLocation(UserBoardLocation userBoardLocation) {
        UserBoardLocation boardLocation = this.userBoardLocationRepository.findByUserId(userBoardLocation.getUserId());
        if (PropertyValidator.isValid((Object)boardLocation)) {
            userBoardLocation.setId(boardLocation.getId());
            if (!PropertyValidator.isValid((Object)userBoardLocation.getSessionId())) {
                userBoardLocation.setSessionId(boardLocation.getSessionId());
            }
            if (!PropertyValidator.isValid((Object)userBoardLocation.getDirection())) {
                userBoardLocation.setPoints(boardLocation.getDirection());
            }
            if (!PropertyValidator.isValid((Object)userBoardLocation.getLocation()) && userBoardLocation.isFixedLocation()) {
                userBoardLocation.setLocation(boardLocation.getLocation());
            }
        }
        userBoardLocation = (UserBoardLocation)this.userBoardLocationRepository.save((Object)userBoardLocation);
        PushSender.sendMsg((String)UserContextUtil.getUserContext().getCurrentCompanyId(), (String)new Gson().toJson((Object)userBoardLocation));
        return userBoardLocation;
    }

    public static String getJiraAccessibleResource(AlmAccount almAccount, String resourceId) {
        JiraOauthToken jiraOauthToken = almAccount.getJiraOauthToken();
        String cloudId = null;
        if (PropertyValidator.isValid((Object)jiraOauthToken) && !JiraUtils.isValidCloudToken((JiraOauthToken)jiraOauthToken) && PropertyValidator.isValid((Object)almAccount.getId())) {
            jiraOauthToken = JiraUtils.refreshJiraAuthToken((JiraOauthToken)jiraOauthToken, (String)almAccount.getId());
            almAccount.setJiraOauthToken(jiraOauthToken);
            if (PropertyValidator.isValid((Object)jiraOauthToken)) {
                if (almAccount.getIsTaggedUser().booleanValue()) {
                    JiraUtils.updateJiraOauthInAlmAccUser((String)almAccount.getId(), (JiraOauthToken)jiraOauthToken, null);
                } else {
                    JiraUtils.updateJiraOauthInAlmAccount((JiraOauthToken)jiraOauthToken, (String)almAccount.getId());
                }
            } else {
                return null;
            }
        }
        CloseableHttpClient httpclient = HttpClients.createMinimal();
        HttpGet get = new HttpGet("https://api.atlassian.com/oauth/token/accessible-resources");
        get.setHeader("Authorization", "Bearer " + jiraOauthToken.getAccessToken());
        get.setHeader("Accept", "application/json");
        try {
            HttpResponse getResponse = httpclient.execute((HttpUriRequest)get);
            String content = JiraUtils.convertStreamToString((InputStream)getResponse.getEntity().getContent());
            if (getResponse.getStatusLine().getStatusCode() == 200) {
                JSONObject contentJson = new JSONArray(content).getJSONObject(0);
                cloudId = contentJson.getString(resourceId);
            } else {
                LOGGER.error("Status: " + getResponse.getStatusLine().getStatusCode() + "Reason: " + getResponse.getStatusLine().getReasonPhrase());
                LOGGER.error(content);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return cloudId;
    }

    public List<UserBoardLocation> getAllActivePlayers(UserBoardLocation userBoardLocation) {
        LOGGER.info("Getting List of Active Players...");
        LinkedList userBoardLocationList = this.userBoardLocationRepository.findByActiveOrderByUpdatedOnAsc(true);
        UserBoardLocation ownPlayer = this.userBoardLocationRepository.findByUserId(userBoardLocation.getUserId());
        if (PropertyValidator.isValid((Object)ownPlayer) && !ownPlayer.isActive()) {
            userBoardLocationList.add(ownPlayer);
        }
        LOGGER.info("Active Players List Size->" + userBoardLocationList.size());
        return userBoardLocationList;
    }

    public UserBoardLocation getPlayerByUserId(String userId) {
        LOGGER.info("Getting Player Info By UserId...");
        UserBoardLocation boardLocation = this.userBoardLocationRepository.findByUserId(userId);
        if (PropertyValidator.isValid((Object)boardLocation)) {
            return boardLocation;
        }
        LOGGER.info(boardLocation.toString());
        LOGGER.info("No Player Record found with given userId->" + userId);
        return null;
    }

    public UserBoardLocation syncPlayerState(String userId, boolean playerState) {
        UserBoardLocation boardLocation = this.userBoardLocationRepository.findByUserId(userId);
        boardLocation.setActive(playerState);
        boardLocation = (UserBoardLocation)this.userBoardLocationRepository.save((Object)boardLocation);
        PushSender.sendMsg((String)UserContextUtil.getUserContext().getCurrentCompanyId(), (String)new Gson().toJson((Object)boardLocation));
        LOGGER.info(boardLocation.toString());
        return boardLocation;
    }

    public static void main(String[] args) {
    }

    public void generarteSampleBoards() {
        try {
            LOGGER.debug("Sample Boards Creation Start");
            ArrayList teamIds = new ArrayList();
            HashMap teamIdsMap = new HashMap();
            ArrayList containerIds = new ArrayList();
            HashMap containerIdsMap = new HashMap();
            HashMap sessionIdsMap = new HashMap();
            List workFlows = this.workFlowRepository.findAll();
            WorkFlow itemWorkFlow = null;
            WorkFlow riskWorkFlow = null;
            WorkFlow dependencyWorkFlow = null;
            State draftState = this.stateRepository.findByTitle("Draft");
            List states = this.stateRepository.findAllByOrderBySequenceAsc();
            StateScheme stateScheme = this.stateSchemeRepository.findByIsDefaultIsTrue();
            WorkSpace defaultWorkSpace = this.workSpaceRepository.findByIsDefaultIsTrue();
            SessionBoard sessionBoard = new SessionBoard();
            Session session = new Session();
            List newTeams = new ArrayList<Team>();
            List<Object> newContainers = new ArrayList<Container>();
            for (WorkFlow wf : workFlows) {
                if (WorkFlow.WorkFlowType.General.toString().equals(wf.getWorkflowType())) {
                    itemWorkFlow = wf;
                }
                if (WorkFlow.WorkFlowType.Risk.toString().equals(wf.getWorkflowType())) {
                    riskWorkFlow = wf;
                }
                if (!WorkFlow.WorkFlowType.Dependency.toString().equals(wf.getWorkflowType())) continue;
                dependencyWorkFlow = wf;
            }
            session.setTitle("Sample Board ");
            session.setItemWorkFlow(itemWorkFlow);
            session.setSubItemWorkFlow(itemWorkFlow);
            session.setDependencyWorkFlow(dependencyWorkFlow);
            session.setCreatedOn(new Date());
            session.setUpdatedOn(new Date());
            session.setStateScheme(stateScheme);
            session.setHidePiJourney(Boolean.valueOf(false));
            session.setNewSystemLinkTypes(Boolean.valueOf(true));
            session.setDependencyPrefix("DEP");
            session.setParentItemColor("#ffffff");
            session.setChildItemColor("#ffffff");
            session.setParentItemTextColor("#000000");
            session.setChildItemTextColor("#000000");
            session.setOriginIdSynched(Boolean.valueOf(true));
            session.setSessionType("SafePI");
            session.setWorkSpace(defaultWorkSpace);
            newTeams.add(new Team(null, "Team Mercury", "#e87e04", "MRC", null, null));
            newTeams.add(new Team(null, "Team Venus", "#446cb3", "VEN", null, null));
            newTeams.add(new Team(null, "Team Mars", "#019875", "MARS", null, null));
            newTeams.add(new Team(null, "Third Parties", "#f85359", "3P", null, null));
            int sprintDays = -16;
            newContainers.add(new Container("Sprint 1", "S1", DateUtils.addDays((Date)new Date(), (int)sprintDays), DateUtils.addDays((Date)new Date(), (int)(sprintDays + 14)), Boolean.valueOf(false)));
            newContainers.add(new Container("Sprint 2", "S2", DateUtils.addDays((Date)new Date(), (int)(sprintDays += 15)), DateUtils.addDays((Date)new Date(), (int)(sprintDays + 14)), Boolean.valueOf(false)));
            newContainers.add(new Container("Sprint 3", "S3", DateUtils.addDays((Date)new Date(), (int)(sprintDays += 15)), DateUtils.addDays((Date)new Date(), (int)(sprintDays + 14)), Boolean.valueOf(false)));
            newContainers.add(new Container("Sprint 4", "S4", DateUtils.addDays((Date)new Date(), (int)(sprintDays += 15)), DateUtils.addDays((Date)new Date(), (int)(sprintDays + 14)), Boolean.valueOf(false)));
            newTeams = this.teamRepository.save(newTeams);
            newContainers = this.containerRepository.save(newContainers);
            String[] teamSequence = new String[newTeams.size()];
            for (int index = 0; index < newTeams.size(); ++index) {
                teamSequence[index] = ((Team)newTeams.get(index)).getId();
            }
            sessionBoard.setTeamSequence(teamSequence);
            sessionBoard.setId(ObjectId.get().toString());
            sessionBoard.setStatus(SessionBoard.OPEN);
            sessionBoard.setState(draftState);
            sessionBoard.setTeams(newTeams);
            sessionBoard.setContainers(newContainers);
            sessionBoard.setSession(session);
            sessionBoard.setCreationDate(new Date());
            sessionBoard.setCreatedOn(new Date());
            sessionBoard.setObjectiveIds(null);
            sessionBoard.setObjectivesMap(null);
            session.setActiveSessionBoard(sessionBoard.getId());
            session.setWorkSpace(defaultWorkSpace);
            session = (Session)this.sessionRepository.save((Object)session);
            sessionBoard.setSession(session);
            sessionBoard = (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard);
            this.importSampleData(sessionBoard);
            sessionBoard.setState((State)states.get(1));
            this.changeState(sessionBoard);
            LOGGER.debug("Sample Boards Creation End");
        }
        catch (Exception ex) {
            LOGGER.debug("Error While Creating Sample Boards");
            LOGGER.debug(StringUtils.getTraceString((Throwable)ex));
        }
    }

    public HashMap<String, String> getObjectiveHeaderKeys() {
        HashMap<String, String> headerKeys = new HashMap<String, String>();
        headerKeys.put("objectiveGroupName", "Objective Group Name");
        headerKeys.put("title", "Title");
        headerKeys.put("objectiveType", "Objective Type");
        headerKeys.put("bvPlan", "BV Plan");
        headerKeys.put("bvActual", "BV Actual");
        headerKeys.put("linkedItems", "Linked Items");
        return headerKeys;
    }

    public HashMap<String, String> getItemHeaderKeys() {
        HashMap<String, String> headerKeys = new HashMap<String, String>();
        headerKeys.put("Feature_kendisKey", "Feature Key");
        headerKeys.put("Feature_externalReferenceURL", "Feature Link");
        headerKeys.put("Feature_title", "Feature Summary");
        headerKeys.put("Feature_status", "Feature Status");
        headerKeys.put("Feature_dueDate", "Feature Due Date");
        headerKeys.put("UserStory_kendisKey", "Story Key");
        headerKeys.put("UserStory_externalReferenceURL", "Story Link");
        headerKeys.put("UserStory_title", "Story Summary");
        headerKeys.put("UserStory_status", "Story Status");
        headerKeys.put("UserStory_storyPoints", "Story Points");
        headerKeys.put("team", "Team Name");
        headerKeys.put("continer", "Sprint Name");
        return headerKeys;
    }

    public void importSampleData(SessionBoard sessionBoard) {
        MappedFieldVO columnMapping;
        HashMap<String, Object> param = new HashMap<String, Object>();
        String dateFormat = "dd MMM yyyy hh:mm aa";
        param.put("dateFormat", dateFormat);
        param.put("importType", "servicenow");
        param.put("csvType", "STANDARD_PREFERENCE");
        param.put("filePath", "D:\\temp\\sampleboard1.csv");
        param.put("sessionBoardId", sessionBoard.getId());
        param.put("isDefaultData", true);
        CsvPreference preference = CsvPreference.STANDARD_PREFERENCE;
        HashMap headerKeys = this.getItemHeaderKeys();
        HashMap headerValues = this.getItemHeaderKeys();
        ArrayList<MappedFieldVO> mapFieldsList = new ArrayList<MappedFieldVO>();
        Set keys = headerKeys.keySet();
        for (String key : keys) {
            columnMapping = new MappedFieldVO((String)headerKeys.get(key), (String)headerValues.get(key), Boolean.valueOf(true), key);
            if (key.toLowerCase().indexOf("date") > -1) {
                columnMapping.setDateFormate(dateFormat);
            }
            mapFieldsList.add(columnMapping);
        }
        this.importService.executeImport(param, sessionBoard, mapFieldsList, preference);
        headerKeys = this.getObjectiveHeaderKeys();
        headerValues = this.getObjectiveHeaderKeys();
        mapFieldsList = new ArrayList();
        keys = headerKeys.keySet();
        for (String key : keys) {
            columnMapping = new MappedFieldVO((String)headerKeys.get(key), (String)headerValues.get(key), Boolean.valueOf(true), key);
            if (key.toLowerCase().indexOf("date") > -1) {
                columnMapping.setDateFormate(dateFormat);
            }
            mapFieldsList.add(columnMapping);
        }
        param.put("filePath", "D:\\temp\\objectives1.csv");
        param.put("importType", "objectives");
        this.importService.executeImport(param, sessionBoard, mapFieldsList, preference);
    }

    /*
     * WARNING - void declaration
     */
    public SessionBoard changeState(SessionBoard requestBoard) {
        HashMap<String, SessionBoard> responseJson = new HashMap<String, SessionBoard>();
        String boardId = requestBoard.getId();
        String stateId = requestBoard.getState().getId();
        SessionBoard savedSessionBoard = null;
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        savedSessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)boardId));
        SessionBoard newSessionBoard = new SessionBoard();
        newSessionBoard.setId(ObjectId.get().toString());
        try {
            void var28_36;
            List list;
            ItemLink itemLink;
            String newItemId;
            List risks;
            String currentSessionId = savedSessionBoard.getSession().getId();
            List newTeams = savedSessionBoard.getTeams();
            List newContainers = savedSessionBoard.getContainers();
            ArrayList<ItemLink> newItemLinks = new ArrayList<ItemLink>();
            ArrayList<ItemLink> newSolutionSourceItemLinks = new ArrayList<ItemLink>();
            ArrayList<ItemLink> newSolutionTargetItemLinks = new ArrayList<ItemLink>();
            ArrayList newSolutionTargetItemLinksForEpics = new ArrayList();
            ArrayList<Item> newItems = new ArrayList<Item>();
            ArrayList<TeamContainer> newTeamContainers = new ArrayList<TeamContainer>();
            ArrayList containerIds = new ArrayList();
            HashMap containerIdsMap = new HashMap();
            sessionBoards.add(savedSessionBoard);
            List items = this.itemRepository.findBySessionBoardsIn(sessionBoards);
            for (Item item : items) {
                Iterator iterator;
                List teamContainers = item.getTeamContainers();
                if (PropertyValidator.isValid((Collection)teamContainers)) {
                    for (TeamContainer tc : teamContainers) {
                        Optional<TeamContainer> duplicateTca;
                        if (!PropertyValidator.isValid((Object)tc) || (duplicateTca = newTeamContainers.stream().filter(x -> tc.getId().equals(x.getId())).findFirst()).isPresent()) continue;
                        newTeamContainers.add(tc);
                    }
                }
                Iterator itemLinks = item.getItemLinks();
                ArrayList solutionSourceItemLinks = item.getSolutionSourceItemLinks();
                ArrayList solutionTargetItemLinks = item.getSolutionTargetItemLinks();
                if (PropertyValidator.isValid((Collection)((Object)itemLinks))) {
                    iterator = itemLinks.iterator();
                    while (iterator.hasNext()) {
                        ItemLink itemLink22 = (ItemLink)iterator.next();
                        newItemLinks.add(itemLink22);
                    }
                }
                if (PropertyValidator.isValid((Collection)solutionSourceItemLinks)) {
                    for (Object itemLink2 : solutionSourceItemLinks) {
                        newSolutionSourceItemLinks.add((ItemLink)itemLink2);
                    }
                }
                if (!PropertyValidator.isValid((Collection)solutionTargetItemLinks)) continue;
                iterator = solutionTargetItemLinks.iterator();
                while (iterator.hasNext()) {
                    Object itemLink2;
                    itemLink2 = (ItemLink)iterator.next();
                    newSolutionTargetItemLinks.add((ItemLink)itemLink2);
                }
            }
            newContainers.forEach(f -> {
                String newContainerId = ObjectId.get().toString();
                containerIds.add(f.getId());
                containerIdsMap.put(f.getId(), newContainerId);
                f.setDuplicateOfId(f.getId());
                if (!PropertyValidator.isValid((Object)f.getOriginItemId())) {
                    f.setOriginItemId(f.getId());
                }
                f.setId(newContainerId);
            });
            RiskRegister riskRegiter = savedSessionBoard.getSession().getRiskRegister();
            if (PropertyValidator.isValid((Object)riskRegiter) && PropertyValidator.isValid((Collection)(risks = this.riskRepository.findByRiskRegister(riskRegiter)))) {
                ArrayList risksToSave = new ArrayList();
                for (Risk risk : risks) {
                    if (!PropertyValidator.isValid((Collection)risk.getBoardSprints())) continue;
                    risk.getBoardSprints().forEach(bs -> {
                        String newSprintId = (String)containerIdsMap.get(bs.getSprintId());
                        if (PropertyValidator.isValid((Object)newSprintId)) {
                            bs.setSprintId(newSprintId);
                            risksToSave.add(risk);
                        }
                    });
                }
                if (PropertyValidator.isValid(risksToSave)) {
                    this.riskRepository.save(risksToSave);
                }
            }
            List solutionEpicItemsLinks = this.itemLinkRepository.findBySourceContainerIdInOrTargetContainerIdInAndSolutionIdExists(containerIds, containerIds, true);
            Object modTeamContainers = new ArrayList<TeamContainer>();
            for (TeamContainer tc : newTeamContainers) {
                if (!PropertyValidator.isValid((Object)tc) || !PropertyValidator.isValid((Object)tc.getContainer()) || !PropertyValidator.isValid((Object)tc.getContainer().getId())) continue;
                for (Container newContainer : newContainers) {
                    if (!tc.getContainer().getId().equals(newContainer.getDuplicateOfId())) continue;
                    tc.setContainer(newContainer);
                }
                modTeamContainers.add(tc);
            }
            modTeamContainers.forEach(f -> {
                f.setDuplicateOfId(f.getId());
                if (!PropertyValidator.isValid((Object)f.getOriginItemId())) {
                    f.setOriginItemId(f.getId());
                }
                f.setId(ObjectId.get().toString());
            });
            HashMap<String, String> userstoryIdsMap = new HashMap<String, String>();
            HashMap<String, String> featureIdsMap = new HashMap<String, String>();
            ArrayList<ItemLink> newItemLinksNotNullList = new ArrayList<ItemLink>();
            ArrayList<ItemLink> newSolutionItemLinksNotNullList = new ArrayList<ItemLink>();
            for (ItemLink itemLink3 : newItemLinks) {
                String newUserStoryId;
                if (itemLink3 == null) continue;
                Optional<TeamContainer> optional = modTeamContainers.stream().filter(x -> itemLink3.getSourceTeamContainerId() != null && itemLink3.getSourceTeamContainerId().equals(x.getDuplicateOfId())).findFirst();
                Optional<TeamContainer> targetTc = modTeamContainers.stream().filter(x -> itemLink3.getTargetTeamContainerId() != null && itemLink3.getTargetTeamContainerId().equals(x.getDuplicateOfId())).findFirst();
                if (optional.isPresent()) {
                    itemLink3.setSourceTeamContainerId(optional.get().getId());
                    if (PropertyValidator.isValid((Object)itemLink3.getSourceUserStoryId())) {
                        if (userstoryIdsMap.containsKey(itemLink3.getSourceUserStoryId())) {
                            itemLink3.setSourceUserStoryId((String)userstoryIdsMap.get(itemLink3.getSourceUserStoryId()));
                        } else {
                            newUserStoryId = ObjectId.get().toString();
                            userstoryIdsMap.put(itemLink3.getSourceUserStoryId(), newUserStoryId);
                            itemLink3.setSourceUserStoryId(newUserStoryId);
                        }
                    }
                    if (PropertyValidator.isValid((Object)itemLink3.getSourceItemId())) {
                        if (featureIdsMap.containsKey(itemLink3.getSourceItemId())) {
                            itemLink3.setSourceItemId((String)featureIdsMap.get(itemLink3.getSourceItemId()));
                        } else {
                            newItemId = ObjectId.get().toString();
                            featureIdsMap.put(itemLink3.getSourceItemId(), newItemId);
                            itemLink3.setSourceItemId(newItemId);
                        }
                    }
                }
                if (targetTc.isPresent()) {
                    itemLink3.setTargetTeamContainerId(targetTc.get().getId());
                    if (PropertyValidator.isValid((Object)itemLink3.getTargetUserStoryId())) {
                        if (userstoryIdsMap.containsKey(itemLink3.getTargetUserStoryId())) {
                            itemLink3.setTargetUserStoryId((String)userstoryIdsMap.get(itemLink3.getTargetUserStoryId()));
                        } else {
                            newUserStoryId = ObjectId.get().toString();
                            userstoryIdsMap.put(itemLink3.getTargetUserStoryId(), newUserStoryId);
                            itemLink3.setTargetUserStoryId(newUserStoryId);
                        }
                    }
                    if (PropertyValidator.isValid((Object)itemLink3.getTargetItemId())) {
                        if (featureIdsMap.containsKey(itemLink3.getTargetItemId())) {
                            itemLink3.setTargetItemId((String)featureIdsMap.get(itemLink3.getTargetItemId()));
                        } else {
                            newItemId = ObjectId.get().toString();
                            featureIdsMap.put(itemLink3.getTargetItemId(), newItemId);
                            itemLink3.setTargetItemId(newItemId);
                        }
                    }
                }
                itemLink3.setOriginItemId(itemLink3.getOriginItemId() == null ? itemLink3.getId() : itemLink3.getOriginItemId());
                itemLink3.setDuplicateOfId(itemLink3.getId());
                itemLink3.setSessionBoardId(newSessionBoard.getId());
                itemLink3.setId(ObjectId.get().toString());
                newItemLinksNotNullList.add(itemLink3);
            }
            HashMap<String, ItemLink> solutionLinkMap = new HashMap<String, ItemLink>();
            for (ItemLink itemLink4 : newSolutionSourceItemLinks) {
                if (itemLink4 == null) continue;
                if (PropertyValidator.isValid((Object)itemLink4.getSourceItemId())) {
                    if (featureIdsMap.containsKey(itemLink4.getSourceItemId())) {
                        itemLink4.setSourceItemId((String)featureIdsMap.get(itemLink4.getSourceItemId()));
                    } else {
                        String newItemId2 = ObjectId.get().toString();
                        featureIdsMap.put(itemLink4.getSourceItemId(), newItemId2);
                        itemLink4.setSourceItemId(newItemId2);
                    }
                    solutionLinkMap.put(itemLink4.getId(), itemLink4);
                }
                newSolutionItemLinksNotNullList.add(itemLink4);
            }
            for (ItemLink itemLink5 : newSolutionTargetItemLinks) {
                itemLink = (ItemLink)solutionLinkMap.get(itemLink5.getId());
                if (itemLink == null) {
                    itemLink = itemLink5;
                }
                if (itemLink == null) continue;
                if (PropertyValidator.isValid((Object)itemLink.getTargetItemId())) {
                    if (featureIdsMap.containsKey(itemLink.getTargetItemId())) {
                        itemLink.setTargetItemId((String)featureIdsMap.get(itemLink.getTargetItemId()));
                    } else {
                        newItemId = ObjectId.get().toString();
                        featureIdsMap.put(itemLink.getTargetItemId(), newItemId);
                        itemLink.setTargetItemId(newItemId);
                    }
                }
                if (PropertyValidator.isValid(solutionLinkMap.get(itemLink5.getId()))) continue;
                newSolutionItemLinksNotNullList.add(itemLink);
                solutionLinkMap.put(itemLink.getId(), itemLink);
            }
            for (ItemLink itemLink6 : solutionEpicItemsLinks) {
                itemLink = (ItemLink)solutionLinkMap.get(itemLink6.getId());
                if (itemLink == null) {
                    itemLink = itemLink6;
                }
                if (itemLink == null) continue;
                boolean linkUpdated = false;
                if (PropertyValidator.isValid((Object)itemLink.getSourceContainerId()) && containerIdsMap.containsKey(itemLink.getSourceContainerId())) {
                    itemLink.setSourceContainerId((String)containerIdsMap.get(itemLink.getSourceContainerId()));
                    linkUpdated = true;
                }
                if (PropertyValidator.isValid((Object)itemLink.getTargetContainerId()) && containerIdsMap.containsKey(itemLink.getTargetContainerId())) {
                    itemLink.setTargetContainerId((String)containerIdsMap.get(itemLink.getTargetContainerId()));
                    linkUpdated = true;
                }
                if (PropertyValidator.isValid(solutionLinkMap.get(itemLink6.getId())) || !linkUpdated) continue;
                newSolutionItemLinksNotNullList.add(itemLink);
                solutionLinkMap.put(itemLink.getId(), itemLink);
            }
            solutionLinkMap = null;
            if (PropertyValidator.isValid((Object)requestBoard.getState().getIsFinal()) && requestBoard.getState().getIsFinal().booleanValue()) {
                newSessionBoard.setStatus(SessionBoard.CLOSED);
            } else {
                newSessionBoard.setStatus(SessionBoard.OPEN);
            }
            newSessionBoard.setState(new State(stateId));
            newSessionBoard.setContainers(newContainers);
            newSessionBoard.setTeams(newTeams);
            newSessionBoard.setTeamSequence(savedSessionBoard.getTeamSequence());
            newSessionBoard.setObjectiveIds(savedSessionBoard.getObjectiveIds());
            newSessionBoard.setObjectivesMap(savedSessionBoard.getObjectivesMap());
            newSessionBoard.setCreationDate(new Date());
            newSessionBoard.setSession(savedSessionBoard.getSession());
            newSessionBoard.setCreatedOn(new Date());
            newSessionBoard.setCreatedBy(UserContextUtil.getUserContext().getLoggedInUser().getUserName());
            Object var28_34 = null;
            if (Boolean.TRUE.equals(savedSessionBoard.getSession().getAlmEnabled()) && PropertyValidator.isValid((Collection)(list = this.itemSyncMapperRepository.findBySessionBoard(savedSessionBoard)))) {
                for (ItemSyncMapper itemSyncMapper : list) {
                    itemSyncMapper.setSessionBoard(newSessionBoard);
                    Optional<Container> container = newContainers.stream().filter(x -> itemSyncMapper.getContainer().getId().equals(x.getDuplicateOfId())).findFirst();
                    if (!container.isPresent()) continue;
                    itemSyncMapper.setContainer(container.get());
                }
            }
            List list2 = this.teamSprintVelocityRepository.findBySessionBoardId(savedSessionBoard.getId());
            list2.forEach(f -> f.setDuplicateOfId(f.getId()));
            for (TeamSprintVelocity newTsv : list2) {
                Optional<Container> container = newContainers.stream().filter(x -> newTsv.getSprintId().equals(x.getDuplicateOfId())).findFirst();
                if (container.isPresent()) {
                    newTsv.setSprintId(container.get().getId());
                }
                newTsv.setId(ObjectId.get().toString());
                newTsv.setSessionBoardId(newSessionBoard.getId());
            }
            ArrayList<SessionBoard> newSessionBoardList = new ArrayList<SessionBoard>();
            newSessionBoardList.add(newSessionBoard);
            for (Object item : items) {
                if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                    for (TeamContainer tc : item.getTeamContainers()) {
                        Iterator iterator = modTeamContainers.iterator();
                        while (iterator.hasNext()) {
                            TeamContainer xtc = (TeamContainer)iterator.next();
                            if (!PropertyValidator.isValid((Object)tc) || !PropertyValidator.isValid((Object)xtc) || !tc.getId().equals(xtc.getDuplicateOfId())) continue;
                            tc.setId(xtc.getId());
                        }
                    }
                }
                item.setSessionBoards(newSessionBoardList);
                newItems.add((Item)item);
            }
            List dependencyLimit = this.TeamSprintDependencyLimitRepository.findBySessionId(savedSessionBoard.getSession().getId());
            if (PropertyValidator.isValid((Collection)dependencyLimit)) {
                for (TeamSprintDependencyLimit teamSprintLimit : dependencyLimit) {
                    Optional<Container> container = newContainers.stream().filter(x -> teamSprintLimit != null && teamSprintLimit.getSprintId() != null && teamSprintLimit.getSprintId().equals(x.getDuplicateOfId())).findFirst();
                    if (!container.isPresent()) continue;
                    teamSprintLimit.setSprintId(container.get().getId());
                }
                this.TeamSprintDependencyLimitRepository.save((Iterable)dependencyLimit);
            }
            ArrayList<Item> itemsWithParent = new ArrayList<Item>();
            ArrayList<ItemJiraDependency> itemJiraDependencies = new ArrayList<ItemJiraDependency>();
            HashMap<String, String> oldIdsMap = new HashMap<String, String>();
            HashMap<String, String> itemDuplicateOfMap = new HashMap<String, String>();
            for (Item item : newItems) {
                String newItemId3 = ObjectId.get().toString();
                oldIdsMap.put(item.getId(), newItemId3);
                item.setDuplicateOfId(item.getId());
                if (!PropertyValidator.isValid((Object)item.getOriginItemId())) {
                    item.setOriginItemId(item.getId());
                }
                if (Item.USER_STORY.equals(item.getType())) {
                    if (userstoryIdsMap.containsKey(item.getId())) {
                        oldIdsMap.put(item.getId(), (String)userstoryIdsMap.get(item.getId()));
                        item.setId((String)userstoryIdsMap.get(item.getId()));
                    } else {
                        oldIdsMap.put(item.getId(), newItemId3);
                        item.setId(newItemId3);
                    }
                } else if (featureIdsMap.containsKey(item.getId())) {
                    oldIdsMap.put(item.getId(), (String)featureIdsMap.get(item.getId()));
                    item.setId((String)featureIdsMap.get(item.getId()));
                } else {
                    oldIdsMap.put(item.getId(), newItemId3);
                    item.setId(newItemId3);
                }
                item.setSuspendActivity(true);
                itemDuplicateOfMap.put(item.getDuplicateOfId(), item.getId());
            }
            boolean ind = false;
            for (Item item : newItems) {
                if (Item.USER_STORY.equals(item.getType()) && PropertyValidator.isValid((Object)item.getParent()) && itemDuplicateOfMap.containsKey(item.getParent().getId())) {
                    item.setParent(new Item((String)itemDuplicateOfMap.get(item.getParent().getId())));
                    itemsWithParent.add(item);
                }
                if (!PropertyValidator.isValid((Collection)item.getJiraDependencies())) continue;
                for (ItemJiraDependency itemJiraDependency : item.getJiraDependencies()) {
                    if (!PropertyValidator.isValid((Object)itemJiraDependency)) continue;
                    if (PropertyValidator.isValid((Object)itemJiraDependency.getSourceItemId()) && oldIdsMap.containsKey(itemJiraDependency.getSourceItemId())) {
                        itemJiraDependency.setId(ObjectId.get().toString());
                        itemJiraDependency.setSourceItemId((String)oldIdsMap.get(itemJiraDependency.getSourceItemId()));
                    }
                    if (PropertyValidator.isValid((Object)itemJiraDependency.getTargetItemId()) && oldIdsMap.containsKey(itemJiraDependency.getTargetItemId())) {
                        itemJiraDependency.setId(ObjectId.get().toString());
                        itemJiraDependency.setTargetItemId((String)oldIdsMap.get(itemJiraDependency.getTargetItemId()));
                    }
                    itemJiraDependency.setSessionBoardId(newSessionBoard.getId());
                    itemJiraDependencies.add(itemJiraDependency);
                }
            }
            newSessionBoard.copyObjectives(itemDuplicateOfMap);
            RiskRegister riskRegister = savedSessionBoard.getSession().getRiskRegister();
            List linkedRisks = null;
            if (PropertyValidator.isValid((Object)riskRegister) && PropertyValidator.isValid((Object)riskRegister.getId())) {
                linkedRisks = this.riskRepository.findAllByRiskRegisterId(riskRegister.getId());
                for (Risk risk : linkedRisks) {
                    List linkedItemIds = risk.getLinkedItemsIds();
                    if (!PropertyValidator.isValid((Collection)linkedItemIds)) continue;
                    for (int i = 0; i < linkedItemIds.size(); ++i) {
                        if (linkedItemIds.get(i) == null || itemDuplicateOfMap == null || itemDuplicateOfMap.get(linkedItemIds.get(i)) == null || risk.getLinkedItemsById() == null || risk.getLinkedItemsById().get(linkedItemIds.get(i)) == null) continue;
                        HashMap linkedItemById = (HashMap)risk.getLinkedItemsById().get(linkedItemIds.get(i));
                        risk.getLinkedItemsById().remove(linkedItemIds.get(i));
                        linkedItemIds.set(i, itemDuplicateOfMap.get(linkedItemIds.get(i)));
                        risk.getLinkedItemsById().put(linkedItemIds.get(i), linkedItemById);
                    }
                }
                if (PropertyValidator.isValid((Collection)linkedRisks)) {
                    List subSetsLinkedRisks = Lists.partition(new ArrayList(linkedRisks), (int)100);
                    ArrayList tempLinkedRisks = new ArrayList();
                    for (List subSetLinkedRisks : subSetsLinkedRisks) {
                        tempLinkedRisks.addAll(this.riskRepository.save((Iterable)subSetLinkedRisks));
                        LOGGER.debug(" subSetsLinkedRisks ....  ");
                    }
                }
            }
            LOGGER.debug(" Before stateChangeForBaseItems....  ");
            this.planService.stateChangeForBaseItems(oldIdsMap, currentSessionId);
            LOGGER.debug(" After stateChangeForBaseItems....  ");
            if (PropertyValidator.isValid((Collection)newContainers)) {
                newContainers = this.containerRepository.save((Iterable)newContainers);
            }
            if (PropertyValidator.isValid(modTeamContainers)) {
                List subSetsModTeamContainers = Lists.partition(new ArrayList(modTeamContainers), (int)100);
                Iterator tempModTeamContainers = new ArrayList();
                for (List subSetModTeamContainer : subSetsModTeamContainers) {
                    tempModTeamContainers.addAll(this.teamContainerRepository.save((Iterable)subSetModTeamContainer));
                    LOGGER.debug(" subSetModTeamContainer....  ");
                }
                modTeamContainers = tempModTeamContainers;
            }
            if (PropertyValidator.isValid(newItemLinksNotNullList)) {
                List subSetsNewItemLinksNotNullList = Lists.partition(new ArrayList(newItemLinksNotNullList), (int)100);
                for (List subSetNewItemLinksNotNullList : subSetsNewItemLinksNotNullList) {
                    this.itemLinkRepository.save((Iterable)subSetNewItemLinksNotNullList);
                    LOGGER.debug(" subSetNewItemLinksNotNullList....  ");
                }
            }
            if (PropertyValidator.isValid(newSolutionItemLinksNotNullList)) {
                List subSetsNewSolutionSourceItemLinksNotNullList = Lists.partition(new ArrayList(newSolutionItemLinksNotNullList), (int)100);
                for (List subSetNewSolutionSourceItemLinksNotNullList : subSetsNewSolutionSourceItemLinksNotNullList) {
                    this.itemLinkRepository.save((Iterable)subSetNewSolutionSourceItemLinksNotNullList);
                    LOGGER.debug(" subSetNewSolutionSourceItemLinksNotNullList....  ");
                }
            }
            newSessionBoard = (SessionBoard)this.sessionBoardRepository.save((Object)newSessionBoard);
            if (PropertyValidator.isValid((Collection)var28_36)) {
                List subSetsMappers = Lists.partition(new ArrayList(var28_36), (int)100);
                for (List subSetMappers : subSetsMappers) {
                    this.itemSyncMapperRepository.save((Iterable)subSetMappers);
                    LOGGER.debug(" subSetMappers....  ");
                }
            }
            if (PropertyValidator.isValid((Collection)list2)) {
                List subSetsTSVList = Lists.partition(new ArrayList(list2), (int)100);
                for (List subSetTSVList : subSetsTSVList) {
                    this.teamSprintVelocityRepository.save((Iterable)subSetTSVList);
                    LOGGER.debug(" subSetTSVList....  ");
                }
            }
            if (PropertyValidator.isValid(itemJiraDependencies)) {
                List subSetsItemJiraDependencies = Lists.partition(new ArrayList(itemJiraDependencies), (int)100);
                for (Object subSetItemJiraDependencies : subSetsItemJiraDependencies) {
                    this.itemJiraDependencyRepository.save((Iterable)subSetItemJiraDependencies);
                    LOGGER.debug(" subSetItemJiraDependencies....  ");
                }
            }
            if (PropertyValidator.isValid(newItems)) {
                List subSetsNewItems = Lists.partition(new ArrayList(newItems), (int)100);
                ArrayList tempNewItems = new ArrayList();
                for (List subSetNewItems : subSetsNewItems) {
                    tempNewItems.addAll(this.itemRepository.save((Iterable)subSetNewItems));
                    LOGGER.debug(" subSetNewItems....  ");
                }
            }
            if (PropertyValidator.isValid(itemsWithParent)) {
                List subSetsItemsWithParent = Lists.partition(new ArrayList(itemsWithParent), (int)100);
                for (List subSetItemsWithParent : subSetsItemsWithParent) {
                    this.itemRepository.save((Iterable)subSetItemsWithParent);
                    LOGGER.debug(" subSetItemsWithParent....  ");
                }
            }
            this.customRepositoryImpl.setSessionBoardParent(savedSessionBoard.getId(), newSessionBoard.getId());
            this.customRepositoryImpl.lockSessionBoard(savedSessionBoard.getId(), Boolean.valueOf(true));
            this.customRepositoryImpl.updateSessionBoardsParent(boardId, newSessionBoard.getId());
            this.customRepositoryImpl.updateActiveSessionBoard(newSessionBoard.getSession().getId(), newSessionBoard.getId());
            newSessionBoard = (SessionBoard)this.sessionBoardRepository.save((Object)newSessionBoard);
            this.customRepositoryImpl.removeSessionLock(currentSessionId);
            JSONObject pushJson = new JSONObject();
            try {
                pushJson.put("type", (Object)"Board");
                pushJson.put("newStateId", (Object)stateId);
                pushJson.put("newBoardId", (Object)newSessionBoard.getId());
                pushJson.put("metaMap", (Object)requestBoard.getMetaMap());
                PushSender.sendMsg((String)pushJson.toString());
                responseJson.put("sessionBoard", newSessionBoard);
            }
            catch (JSONException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            if (e instanceof ViztrendJiraException) {
                ViztrendJiraException vJe = (ViztrendJiraException)((Object)e);
                if (HttpStatus.LOCKED.toString().equals(String.valueOf(vJe.getCode()))) {
                    return null;
                }
            }
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            AlmError almerr = new AlmError();
            almerr.setAlmErrorMessage(StringUtils.getTraceString((Throwable)e));
            almerr.setHttpErrorCode(Integer.valueOf(400));
            return null;
        }
    }
}

