/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.repository;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.viztrend.safe.api.dto.BacklogGroupItemsInfoDTO;
import com.viztrend.safe.api.dto.RTFetchServiceRequestDTO;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.enums.EnumStatusCategory;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.Board;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Dashboard;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ObjectiveCustomView;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TimeSeriesDTO;
import com.viztrend.safe.persistence.entity.TimeSeriesLog;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.entity.roadmap.RoadmapSection;
import com.viztrend.safe.persistence.repository.BaseItemRepository;
import com.viztrend.safe.persistence.repository.BoardRepository;
import com.viztrend.safe.persistence.repository.EnumRoadMapGroupHunting;
import com.viztrend.safe.persistence.repository.ObjectiveCustomViewRepository;
import com.viztrend.safe.persistence.repository.RoadmapSectionRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TeamRepository;
import com.viztrend.safe.persistence.repository.TimeSeriesRepository;
import com.viztrend.safe.service.RTItemFetchService;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.TimeSeriesUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class TimeSeriesRepositoryImpl
implements TimeSeriesRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeSeriesRepositoryImpl.class);
    private final DecimalFormat df = new DecimalFormat("#.#");
    private final MongoTemplate mongoTemplate;
    private final StatusRepository statusRepository;
    private final BaseItemRepository baseItemRepository;
    private final TeamRepository teamRepository;
    private final RoadmapSectionRepository roadmapSectionRepository;
    private final BoardRepository boardRepository;
    private final RTItemFetchService itemFetchService;
    private final ObjectiveCustomViewRepository objectiveCustomViewRepository;
    TimeSeriesUtils timeSeriesUtils;

    @Autowired
    public TimeSeriesRepositoryImpl(MongoTemplate mongoTemplate, StatusRepository statusRepository, BaseItemRepository baseItemRepository, TeamRepository teamRepository, ObjectiveCustomViewRepository objectiveCustomViewRepository, RoadmapSectionRepository roadmapSectionRepository, BoardRepository boardRepository, RTItemFetchService itemFetchService) {
        this.mongoTemplate = mongoTemplate;
        this.statusRepository = statusRepository;
        this.baseItemRepository = baseItemRepository;
        this.teamRepository = teamRepository;
        this.roadmapSectionRepository = roadmapSectionRepository;
        this.boardRepository = boardRepository;
        this.itemFetchService = itemFetchService;
        this.objectiveCustomViewRepository = objectiveCustomViewRepository;
    }

    public List<TimeSeriesDTO> getStartAndEndStatusTimesInRange(Date startDate, Date endDate, String tenant, String startStatusId, String endStatusId) throws Exception {
        Date start = new Date();
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject("meta.tenant", (Object)tenant).append("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lt", (Object)endDate)).append("changes.status.id", (Object)new BasicDBObject("$in", Arrays.asList(startStatusId, endStatusId))));
        BasicDBObject addFieldsStage = new BasicDBObject("$addFields", (Object)new BasicDBObject("startStatusTime", (Object)new BasicDBObject("$min", (Object)new BasicDBObject("$cond", Arrays.asList(new BasicDBObject("$eq", Arrays.asList("$changes.status.id", startStatusId)), "$eventTime", null)))).append("endStatusTime", (Object)new BasicDBObject("$min", (Object)new BasicDBObject("$cond", Arrays.asList(new BasicDBObject("$eq", Arrays.asList("$changes.status.id", endStatusId)), "$eventTime", null)))));
        BasicDBObject startStatusProject = new BasicDBObject().append("_id", (Object)"$changes.status.id").append("itemId", (Object)"$itemId").append("startStatusTime", (Object)1);
        BasicDBObject endStatusProject = new BasicDBObject().append("_id", (Object)"$changes.status.id").append("itemId", (Object)"$itemId").append("endStatusTime", (Object)1);
        List<BasicDBObject> startStatus = Arrays.asList(new BasicDBObject("$match", (Object)new BasicDBObject("changes.status.id", (Object)startStatusId)), new BasicDBObject("$project", (Object)startStatusProject));
        List<BasicDBObject> endStatus = Arrays.asList(new BasicDBObject("$match", (Object)new BasicDBObject("changes.status.id", (Object)endStatusId)), new BasicDBObject("$project", (Object)endStatusProject));
        BasicDBObject facetStage = new BasicDBObject("$facet", (Object)new BasicDBObject("startStatus", startStatus).append("endStatus", endStatus));
        BasicDBObject combined = new BasicDBObject("$project", (Object)new BasicDBObject("combined", (Object)new BasicDBObject("$concatArrays", Arrays.asList("$startStatus", "$endStatus"))));
        BasicDBObject unwindCombined = new BasicDBObject("$unwind", (Object)"$combined");
        BasicDBObject replaceRoot = new BasicDBObject("$replaceRoot", (Object)new BasicDBObject("newRoot", (Object)"$combined"));
        BasicDBObject groupPush = new BasicDBObject("$push", (Object)new BasicDBObject().append("startStatusTime", (Object)"$startStatusTime").append("endStatusTime", (Object)"$endStatusTime"));
        BasicDBObject groupStage = new BasicDBObject("$group", (Object)new BasicDBObject().append("_id", (Object)"$itemId").append("events", (Object)groupPush));
        List<DBObject> pipeline = Arrays.asList(matchStage, addFieldsStage, facetStage, combined, unwindCombined, replaceRoot, groupStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(TimeSeriesLog.class));
        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        Cursor dbCursor = collection.aggregate(pipeline, ao);
        ArrayList<TimeSeriesDTO> itemData = new ArrayList<TimeSeriesDTO>();
        while (dbCursor.hasNext()) {
            DBObject o = (DBObject)dbCursor.next();
            TimeSeriesDTO result = new TimeSeriesDTO();
            result.setItemId((String)o.get("_id"));
            if (PropertyValidator.isValid((Object)o.get("events"))) {
                List events = (List)o.get("events");
                ArrayList<Date> startStatusTime = new ArrayList<Date>();
                ArrayList<Date> endStatusTime = new ArrayList<Date>();
                for (Map event : events) {
                    Date startDateTime = (Date)event.get("startStatusTime");
                    Date endDateTime = (Date)event.get("endStatusTime");
                    if (PropertyValidator.isValid((Object)startDateTime)) {
                        startStatusTime.add(startDateTime);
                    }
                    if (!PropertyValidator.isValid((Object)endDateTime)) continue;
                    endStatusTime.add(endDateTime);
                }
                result.setStartStatusTime(startStatusTime);
                result.setEndStatusTime(endStatusTime);
            }
            itemData.add(result);
        }
        Date end = new Date();
        LOGGER.info("==================================================");
        LOGGER.info("\t\tProcessing Time : " + (end.getTime() - start.getTime()));
        LOGGER.info("==================================================");
        return itemData;
    }

    public Map<String, Object> getItemsForTheGivingDurition(Date startDate, Date endDate, String sessionBoardIds, String tenant, TimeSeriesDTO.Interval interval, List<String> dataIds, Optional<ArrayList<String>> optionalTeamId, Optional<ArrayList<String>> optionalSprintId) {
        BasicDBObject matchQuery = new BasicDBObject();
        StringBuilder combinedData = new StringBuilder();
        for (int i = 0; i < dataIds.size(); ++i) {
            if (i == 0) {
                combinedData.append(dataIds.get(i));
                continue;
            }
            combinedData.append(", ").append(dataIds.get(i));
        }
        String res = combinedData.toString();
        List<String> list = Arrays.asList(res.split(","));
        matchQuery.append("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lt", (Object)endDate)).append("changes.status.id", (Object)new BasicDBObject("$in", list)).append("meta.sessionBoardId", (Object)sessionBoardIds).append("meta.tenant", (Object)tenant);
        if (optionalTeamId.isPresent()) {
            BasicDBObject teamCondition = new BasicDBObject("$elemMatch", (Object)new BasicDBObject("team.id", (Object)new BasicDBObject("$in", optionalTeamId.get())));
            matchQuery.append("teamContainers", (Object)teamCondition);
        }
        if (optionalSprintId.isPresent()) {
            BasicDBObject containerCondition = new BasicDBObject("$elemMatch", (Object)new BasicDBObject("container.id", (Object)new BasicDBObject("$in", optionalSprintId.get())));
            matchQuery.append("teamContainers", (Object)containerCondition);
        }
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)matchQuery);
        BasicDBObject sortByEventTimeDesc = new BasicDBObject("$sort", (Object)new BasicDBObject("eventTime", (Object)-1));
        BasicDBObject groupByLatestState = new BasicDBObject("$group", (Object)new BasicDBObject().append("_id", (Object)new BasicDBObject("date", (Object)new BasicDBObject("$dateToString", (Object)new BasicDBObject("format", (Object)"%Y-%m-%d").append("date", (Object)"$eventTime"))).append("itemId", (Object)"$itemId")).append("latestStatusId", (Object)new BasicDBObject("$first", (Object)"$changes.status.id")));
        BasicDBObject groupByDateAndStatus = new BasicDBObject("$group", (Object)new BasicDBObject().append("_id", (Object)new BasicDBObject("date", (Object)"$_id.date").append("statusId", (Object)"$latestStatusId")).append("itemIds", (Object)new BasicDBObject("$push", (Object)"$_id.itemId")));
        BasicDBObject groupByDate = new BasicDBObject("$group", (Object)new BasicDBObject().append("_id", (Object)"$_id.date").append("statusItems", (Object)new BasicDBObject("$push", (Object)new BasicDBObject().append("k", (Object)"$_id.statusId").append("v", (Object)"$itemIds"))));
        BasicDBObject projectStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)0).append("date", (Object)"$_id").append("data", (Object)new BasicDBObject("$arrayToObject", (Object)"$statusItems")));
        List<BasicDBObject> pipeline = Arrays.asList(matchStage, sortByEventTimeDesc, groupByLatestState, groupByDateAndStatus, groupByDate, projectStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(TimeSeriesLog.class));
        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        Cursor dbCursor = collection.aggregate(pipeline, ao);
        HashMap<String, Object> itemData = new HashMap<String, Object>();
        while (dbCursor.hasNext()) {
            DBObject result = (DBObject)dbCursor.next();
            itemData.put(String.valueOf(result.get("date")), result.get("data"));
        }
        return itemData;
    }

    public List<TimeSeriesDTO> getItemCountForIdsInRange(Date startDate, Date endDate, String tenant, TimeSeriesDTO.ChartType type, TimeSeriesDTO.Interval interval, List<String> dataIds) throws Exception {
        Date start = new Date();
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject("meta.tenant", (Object)tenant).append("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lt", (Object)endDate)).append(type.getValue(), (Object)new BasicDBObject("$in", dataIds)));
        BasicDBObject durationInterval = new BasicDBObject("$dateToString", (Object)new BasicDBObject().append("format", (Object)interval.getValue()).append("date", (Object)"$eventTime"));
        BasicDBObject projectStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("durationInterval", (Object)durationInterval).append("typeId", (Object)("$" + type.getValue())));
        BasicDBObject groupStage1 = new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)new BasicDBObject().append("typeId", (Object)"$typeId").append("durationInterval", (Object)"$durationInterval")).append("count", (Object)new BasicDBObject("$sum", (Object)1)));
        BasicDBObject groupStage2 = new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)"$_id.typeId").append("itemCountForDuration", (Object)new BasicDBObject("$push", (Object)new BasicDBObject().append("durationInterval", (Object)"$_id.durationInterval").append("count", (Object)"$count"))));
        List<DBObject> pipeline = Arrays.asList(matchStage, projectStage, groupStage1, groupStage2);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(TimeSeriesLog.class));
        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        Cursor dbCursor = collection.aggregate(pipeline, ao);
        ArrayList<TimeSeriesDTO> itemData = new ArrayList<TimeSeriesDTO>();
        while (dbCursor.hasNext()) {
            DBObject o = (DBObject)dbCursor.next();
            TimeSeriesDTO result = new TimeSeriesDTO();
            result.setId((String)o.get("_id"));
            BasicDBList itemCountForDuration = (BasicDBList)o.get("itemCountForDuration");
            if (PropertyValidator.isValid((Collection)itemCountForDuration)) {
                HashMap<String, Integer> durationCount = new HashMap<String, Integer>();
                for (Object object : itemCountForDuration) {
                    DBObject dbObject = (DBObject)object;
                    durationCount.put((String)dbObject.get("durationInterval"), (Integer)dbObject.get("count"));
                }
                result.setItemCountForDuration(durationCount);
            }
            itemData.add(result);
        }
        Date end = new Date();
        LOGGER.info("==================================================");
        LOGGER.info("\t\tProcessing Time : " + (end.getTime() - start.getTime()));
        LOGGER.info("==================================================");
        return itemData;
    }

    public Map<String, TimeSeriesDTO> getStatusIdAndEventTimeForEachItem(Date startDate, Date endDate, String tenant, List<String> itemIds, List<String> statusIds) {
        Date start = new Date();
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject("meta.tenant", (Object)tenant).append("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lt", (Object)endDate)).append("itemId", (Object)new BasicDBObject("$in", itemIds)).append("changes.status.id", (Object)new BasicDBObject("$in", statusIds)));
        BasicDBObject groupStage = new BasicDBObject("$group", (Object)new BasicDBObject().append("_id", (Object)"$itemId").append("statuses", (Object)new BasicDBObject().append("$push", (Object)new BasicDBObject().append("statusId", (Object)"$changes.status.id").append("eventTime", (Object)"$eventTime"))));
        List<DBObject> pipeline = Arrays.asList(matchStage, groupStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(TimeSeriesLog.class));
        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        Cursor dbCursor = collection.aggregate(pipeline, ao);
        HashMap<String, TimeSeriesDTO> itemData = new HashMap<String, TimeSeriesDTO>();
        while (dbCursor.hasNext()) {
            DBObject o = (DBObject)dbCursor.next();
            TimeSeriesDTO result = new TimeSeriesDTO();
            result.setItemId((String)o.get("_id"));
            BasicDBList statuses = (BasicDBList)o.get("statuses");
            HashMap<String, String> itemStatuses = new HashMap<String, String>();
            if (PropertyValidator.isValid((Collection)statuses)) {
                for (Object object : statuses) {
                    DBObject dbObject = (DBObject)object;
                    itemStatuses.put((String)dbObject.get("statusId"), dbObject.get("eventTime").toString());
                }
                result.setStatusMap(itemStatuses);
            }
            itemData.put(result.getItemId(), result);
        }
        Date end = new Date();
        LOGGER.info("==================================================");
        LOGGER.info("\t\tProcessing Time : " + (end.getTime() - start.getTime()));
        LOGGER.info("==================================================");
        return itemData;
    }

    public Map<String, Object> getItemsBasedOnStartEndStatus(String sessionBoardIds, String tenant, List<String> startingStatusId, List<String> endingStatusId, String interval, List<Status> statusList, List<String> selectedIssueType, String boardItemsFilter, String radioButtonSelection, Map<String, String> itemTags) {
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        HashMap<String, Long> result = new HashMap<String, Long>();
        TimeSeriesUtils timeSeriesUtils = new TimeSeriesUtils(this.mongoTemplate, this.statusRepository);
        List startingStatusMatch = new ArrayList();
        List endingStatusMatch = new ArrayList();
        Map releventDates = new LinkedHashMap();
        HashMap itemDatesMap = new HashMap();
        ArrayList<String> searchedItemIds = new ArrayList<String>();
        HashMap<String, List> itemStatusMap = new HashMap<String, List>();
        Query queryForSessionBoard = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sessionBoardIds)));
        queryForSessionBoard.fields().include("session");
        queryForSessionBoard.fields().include("teams");
        queryForSessionBoard.fields().include("creationDate");
        SessionBoard sessionBoard = (SessionBoard)this.mongoTemplate.findOne(queryForSessionBoard, SessionBoard.class);
        releventDates = timeSeriesUtils.getSprintDates(sessionBoard);
        Map sprintDates = timeSeriesUtils.getSprintDates(sessionBoard);
        ArrayList allSprints = new ArrayList(sprintDates.keySet());
        String endingStatusCategory = null;
        if (PropertyValidator.isValid(allSprints) && PropertyValidator.isValid((Object)sprintDates)) {
            long secondStartTime = System.currentTimeMillis();
            List allstartingSelectedStatuses = timeSeriesUtils.getStatusListOfaTitle(startingStatusId, statusList);
            List allendingSelectedStatuses = timeSeriesUtils.getStatusListOfaTitle(endingStatusId, statusList);
            if (PropertyValidator.isValid(itemTags)) {
                searchedItemIds.addAll(itemTags.keySet());
            }
            startingStatusMatch = timeSeriesUtils.getFilteredItemsListByStatus(searchedItemIds, allstartingSelectedStatuses, sessionBoard.getCreationDate(), (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1), tenant, "itemTimeSeries", sessionBoard.getId());
            timeSeriesUtils.checkItemExistanceInCollection(startingStatusMatch);
            LOGGER.info("Method :" + this.getClass().getName() + ".getItemsForFlowLine: Start Status Items Fetching execution lasted (seconds):" + (float)(System.currentTimeMillis() - secondStartTime) / 1000.0f);
            long endStartTime = System.currentTimeMillis();
            if (radioButtonSelection.equals("statusCategory")) {
                endingStatusMatch = timeSeriesUtils.getFilteredItemsListByStatusCategory(searchedItemIds, allendingSelectedStatuses, sessionBoard.getCreationDate(), (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1), tenant, "itemTimeSeries", sessionBoard.getId());
                timeSeriesUtils.checkItemExistanceInCollection(endingStatusMatch);
            } else {
                endingStatusMatch = timeSeriesUtils.getFilteredItemsListByStatus(searchedItemIds, allendingSelectedStatuses, sessionBoard.getCreationDate(), (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1), tenant, "itemTimeSeries", sessionBoard.getId());
                timeSeriesUtils.checkItemExistanceInCollection(endingStatusMatch);
            }
            LOGGER.info("Method :" + this.getClass().getName() + ".getItemsForFlowLine: End Status Items Fetching execution lasted (seconds):" + (float)(System.currentTimeMillis() - endStartTime) / 1000.0f);
            ArrayList<String> endingStatusIdsList = new ArrayList<String>();
            for (String string : endingStatusId) {
                endingStatusIdsList.add(string);
            }
            long endCategoryTime = System.currentTimeMillis();
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").in(endingStatusIdsList));
            query.fields().include("category");
            Status endingCategoryStatus = (Status)this.mongoTemplate.findOne(query, Status.class);
            LOGGER.info("Method :" + this.getClass().getName() + ".getItemsForFlowLine: End Status Category execution lasted (seconds):" + (float)(System.currentTimeMillis() - endStartTime) / 1000.0f);
            endingStatusCategory = endingCategoryStatus.getCategory();
            long plannedUnPlannedTime = System.currentTimeMillis();
            if (!startingStatusMatch.isEmpty() && !endingStatusMatch.isEmpty()) {
                if (boardItemsFilter.equals("unplanned-items")) {
                    startingStatusMatch = timeSeriesUtils.retrieveAndCheckTeamContainerForUnPlanned(startingStatusMatch, tenant);
                    endingStatusMatch = timeSeriesUtils.retrieveAndCheckTeamContainerForUnPlanned(endingStatusMatch, tenant);
                } else if (boardItemsFilter.equals("planned-items")) {
                    startingStatusMatch = timeSeriesUtils.retrieveAndCheckTeamContainerForPlanned(startingStatusMatch, tenant);
                    endingStatusMatch = timeSeriesUtils.retrieveAndCheckTeamContainerForPlanned(endingStatusMatch, tenant);
                }
            }
        }
        if (!startingStatusMatch.isEmpty() && !endingStatusMatch.isEmpty()) {
            if ("unplanned-items".equals(boardItemsFilter)) {
                startingStatusMatch = timeSeriesUtils.retrieveAndCheckTeamContainerForUnPlanned(startingStatusMatch, tenant);
                endingStatusMatch = timeSeriesUtils.retrieveAndCheckTeamContainerForUnPlanned(endingStatusMatch, tenant);
            } else if ("planned-items".equals(boardItemsFilter)) {
                startingStatusMatch = timeSeriesUtils.retrieveAndCheckTeamContainerForPlanned(startingStatusMatch, tenant);
                endingStatusMatch = timeSeriesUtils.retrieveAndCheckTeamContainerForPlanned(endingStatusMatch, tenant);
            }
        }
        Map earliestStartingStatusMap = timeSeriesUtils.populateEarliestStatusMap(startingStatusMatch, selectedIssueType, sessionBoardIds);
        Map farthestEndingStatusMap = timeSeriesUtils.populateFarthestStatusMap(endingStatusMatch, selectedIssueType, sessionBoardIds);
        List doneCategoryStatusesIds = statusList.stream().filter(status -> "Done".equals(status.getCategory())).map(BaseEntity::getId).collect(Collectors.toList());
        List matchingItemsMap = new ArrayList();
        HashSet<String> itemIds = new HashSet<String>();
        HashMap<String, TimeSeriesLog> latestStatusMap = new HashMap<String, TimeSeriesLog>();
        if (!itemIds.isEmpty()) {
            Query latestStatusQuery = new Query((CriteriaDefinition)Criteria.where((String)"itemId").in(itemIds)).with(new Sort(Sort.Direction.DESC, new String[]{"eventTime"}));
            List latestStatusList = Optional.ofNullable(this.mongoTemplate.find(latestStatusQuery, TimeSeriesLog.class, "itemTimeSeries")).orElse(Collections.emptyList());
            timeSeriesUtils.checkItemExistanceInCollection(latestStatusList);
            for (TimeSeriesLog log : latestStatusList) {
                latestStatusMap.put(log.getItemId(), log);
            }
        }
        HashMap<String, Long> itemsDaysMap = new HashMap<String, Long>();
        matchingItemsMap = timeSeriesUtils.populateMatchingItemsMap(doneCategoryStatusesIds, endingStatusId, earliestStartingStatusMap, farthestEndingStatusMap);
        if (itemIds.isEmpty()) {
            for (Map map : matchingItemsMap) {
                ArrayList keys = new ArrayList(map.keySet());
                if (keys.isEmpty()) continue;
                itemIds.add(((TimeSeriesLog)keys.get(0)).getItemId());
            }
        }
        Query itemQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)itemIds.stream().map(ObjectId::new).collect(Collectors.toList())));
        itemQuery.fields().include("jiraIssueTypeId").include("tfsItemType").include("jiraFieldByKey.created").include("tfsFieldByKey.CreatedDate").include("createdOn").include("status");
        List list = Optional.ofNullable(this.mongoTemplate.find(itemQuery, Item.class)).orElse(Collections.emptyList());
        Map<String, Item> itemMap = list.stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item, (existing, replacement) -> existing));
        for (int i = 0; i < matchingItemsMap.size(); ++i) {
            for (Map.Entry entry : ((Map)matchingItemsMap.get(i)).entrySet()) {
                Item selectedItem;
                if (((TimeSeriesLog)entry.getKey()).getEventTime().after(((TimeSeriesLog)entry.getValue()).getEventTime()) || !PropertyValidator.isValid((Object)(selectedItem = itemMap.get(((TimeSeriesLog)entry.getKey()).getItemId())))) continue;
                long millisecondsDifference = TimeSeriesUtils.stripTime((Date)((TimeSeriesLog)entry.getValue()).getEventTime()).getTime() - TimeSeriesUtils.stripTime((Date)((TimeSeriesLog)entry.getKey()).getEventTime()).getTime();
                long daysDifference = millisecondsDifference / 86400000L;
                long unstrippedMiliSeconds = ((TimeSeriesLog)entry.getValue()).getEventTime().getTime() - ((TimeSeriesLog)entry.getKey()).getEventTime().getTime();
                if (daysDifference < 1L && unstrippedMiliSeconds > 0L) {
                    daysDifference = 1L;
                }
                if (daysDifference <= 0L) continue;
                itemsDaysMap.put("itemId_" + ((TimeSeriesLog)entry.getValue()).getItemId() + ":team", daysDifference);
                ArrayList<String> dates = new ArrayList<String>();
                dates.add(((TimeSeriesLog)entry.getKey()).getEventTime().toString());
                dates.add(((TimeSeriesLog)entry.getValue()).getEventTime().toString());
                itemDatesMap.put("itemId_" + ((TimeSeriesLog)entry.getKey()).getItemId() + ":team", dates);
                result.put(((TimeSeriesLog)entry.getKey()).getItemId(), daysDifference);
            }
        }
        TreeMap<String, Long> intervals = new TreeMap<String, Long>((o1, o2) -> {
            String[] parts1 = o1.split("-");
            String[] parts2 = o2.split("-");
            int start1 = Integer.parseInt(parts1[0]);
            int start2 = Integer.parseInt(parts2[0]);
            return Integer.compare(start1, start2);
        });
        if (interval != null) {
            int intervalNumber = Integer.parseInt(interval);
            long biggestDifference = result.values().stream().max(Long::compare).orElse(0L);
            long smallestDifference = result.values().stream().min(Long::compare).orElse(0L);
            smallestDifference = smallestDifference - (long)intervalNumber < 0L ? 0L : (smallestDifference -= (long)intervalNumber);
            if (intervalNumber > 0 && !result.isEmpty()) {
                int i = (int)smallestDifference;
                while ((long)i <= biggestDifference + (long)intervalNumber) {
                    intervals.put(i + "-" + (i + intervalNumber), 0L);
                    i += intervalNumber + 1;
                }
                for (Map.Entry entry : intervals.entrySet()) {
                    String[] parts = ((String)entry.getKey()).split("-");
                    int intervalStart = Integer.parseInt(parts[0]);
                    int intervalEnd = Integer.parseInt(parts[1]);
                    for (Map.Entry newEntry : result.entrySet()) {
                        int valueToMap = ((Long)newEntry.getValue()).intValue();
                        if (valueToMap < intervalStart || valueToMap > intervalEnd) continue;
                        HashMap temp = new HashMap();
                        temp.put(entry.getKey(), "cycletime");
                        Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                        tempItemIdsSet.add(newEntry.getKey());
                        itemIdswrtInterval.put(temp, tempItemIdsSet);
                        intervals.put((String)entry.getKey(), (Long)entry.getValue() + 1L);
                    }
                }
            } else if (intervalNumber <= 0) {
                for (Map.Entry days : result.entrySet()) {
                    HashMap temp = new HashMap();
                    temp.put(days.getKey(), "cycletime");
                    Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                    tempItemIdsSet.add(days.getKey());
                    itemIdswrtInterval.put(temp, tempItemIdsSet);
                    String key = String.valueOf(days.getValue());
                    intervals.put(key, intervals.getOrDefault(key, 0L) + 1L);
                }
            }
        } else {
            for (Map.Entry days : result.entrySet()) {
                HashMap temp = new HashMap();
                temp.put(days.getKey(), "cycletime");
                Set tempItemIdsSet = itemIdswrtInterval.getOrDefault(temp, new HashSet());
                tempItemIdsSet.add(days.getKey());
                itemIdswrtInterval.put(temp, tempItemIdsSet);
                String key = String.valueOf(days.getValue());
                intervals.put(key, intervals.getOrDefault(key, 0L) + 1L);
            }
        }
        if ("statusCategory".equals(radioButtonSelection)) {
            for (Item item2 : list) {
                List tempStatus = itemStatusMap.getOrDefault(item2.getId(), new ArrayList());
                if (!PropertyValidator.isValid((Object)item2.getStatus())) continue;
                tempStatus.add(item2.getStatus().getTitle() + "status_category:" + item2.getStatus().getCategory());
                itemStatusMap.put(item2.getId(), tempStatus);
            }
        }
        HashMap<String, Object> resultObject = new HashMap<String, Object>();
        resultObject.put("itemStatusMap", itemStatusMap);
        resultObject.put("intervals", intervals);
        resultObject.put("itemDaysMap", itemsDaysMap);
        resultObject.put("itemIdsMap", itemIdswrtInterval);
        resultObject.put("itemDatesMap", itemDatesMap);
        return resultObject;
    }

    public Map<String, Object> getItemsBasedOnCreationDate(String sessionBoardIds, String tenant, String interval, List<Status> statusList, List<String> selectedIssueType, String boardItemsFilter, List<String> statuses, Map<String, String> itemTags) {
        HashMap result = new HashMap();
        TimeSeriesUtils timeSeriesUtils = new TimeSeriesUtils(this.mongoTemplate, this.statusRepository);
        HashMap itemsDaysMap = new HashMap();
        HashMap itemDatesMap = new HashMap();
        List endingStatusMatch = new ArrayList();
        ArrayList<String> searchedItemIds = new ArrayList<String>();
        Map releventDates = new LinkedHashMap();
        Query queryForSessionBoard = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sessionBoardIds)));
        queryForSessionBoard.fields().include("session");
        queryForSessionBoard.fields().include("teams");
        queryForSessionBoard.fields().include("creationDate");
        SessionBoard sessionBoard = (SessionBoard)this.mongoTemplate.findOne(queryForSessionBoard, SessionBoard.class);
        List allSelectedStatuses = timeSeriesUtils.getStatusListOfaTitle(statuses, statusList);
        releventDates = timeSeriesUtils.getSprintDates(sessionBoard);
        Map sprintDates = timeSeriesUtils.getSprintDates(sessionBoard);
        ArrayList allSprints = new ArrayList(sprintDates.keySet());
        Object endingStatusCategory = null;
        if (PropertyValidator.isValid(allSprints) && PropertyValidator.isValid((Object)sprintDates)) {
            if (PropertyValidator.isValid(itemTags)) {
                searchedItemIds.addAll(itemTags.keySet());
            }
            endingStatusMatch = timeSeriesUtils.getFilteredItemsListByStatus(searchedItemIds, allSelectedStatuses, sessionBoard.getCreationDate(), (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1), tenant, "itemTimeSeries", sessionBoard.getId());
            timeSeriesUtils.checkItemExistanceInCollection(endingStatusMatch);
            if (!endingStatusMatch.isEmpty()) {
                if ("unplanned-items".equals(boardItemsFilter)) {
                    endingStatusMatch = timeSeriesUtils.retrieveAndCheckTeamContainerForUnPlanned(endingStatusMatch, tenant);
                } else if ("planned-items".equals(boardItemsFilter)) {
                    endingStatusMatch = timeSeriesUtils.retrieveAndCheckTeamContainerForPlanned(endingStatusMatch, tenant);
                }
            }
            Set itemIds = endingStatusMatch.stream().map(TimeSeriesLog::getItemId).collect(Collectors.toSet());
            Query itemQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)itemIds.stream().map(ObjectId::new).collect(Collectors.toList())));
            itemQuery.fields().include("jiraIssueTypeId").include("tfsItemType").include("jiraFieldByKey.created").include("tfsFieldByKey.CreatedDate").include("createdOn");
            List allItems = Optional.ofNullable(this.mongoTemplate.find(itemQuery, Item.class)).orElse(Collections.emptyList());
            Map<String, Item> itemMap = allItems.stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item, (existing, replacement) -> existing));
            HashMap farthestEndingStatusMap = new HashMap();
            for (TimeSeriesLog endingStatus : endingStatusMatch) {
                Item selectedItem;
                String itemId = endingStatus.getItemId();
                if (farthestEndingStatusMap.containsKey(itemId) && !endingStatus.getEventTime().after(((TimeSeriesLog)farthestEndingStatusMap.get(itemId)).getEventTime()) || (selectedItem = itemMap.get(itemId)) == null) continue;
                if (!selectedIssueType.isEmpty()) {
                    if (selectedItem.getJiraIssueTypeId() != null && selectedIssueType.contains(selectedItem.getJiraIssueTypeId())) {
                        if (PropertyValidator.isValid((Object)selectedItem.getJiraFieldByKey())) {
                            this.processItemCreationDate(itemsDaysMap, result, endingStatus, selectedItem.getJiraFieldByKey(), itemDatesMap, "created");
                            continue;
                        }
                        timeSeriesUtils.getItemDifferenceMapwrtCreationDate(selectedItem, endingStatus, result, itemsDaysMap, itemDatesMap);
                        continue;
                    }
                    if (selectedItem.getTfsItemType() == null || !selectedIssueType.contains(selectedItem.getTfsItemType())) continue;
                    if (PropertyValidator.isValid((Object)selectedItem.getTfsFieldByKey())) {
                        this.processItemCreationDate(itemsDaysMap, result, endingStatus, selectedItem.getTfsFieldByKey(), itemDatesMap, "CreatedDate");
                        continue;
                    }
                    timeSeriesUtils.getItemDifferenceMapwrtCreationDate(selectedItem, endingStatus, result, itemsDaysMap, itemDatesMap);
                    continue;
                }
                if (selectedItem.getJiraFieldByKey() != null) {
                    this.processItemCreationDate(itemsDaysMap, result, endingStatus, selectedItem.getJiraFieldByKey(), itemDatesMap, "created");
                    continue;
                }
                if (selectedItem.getTfsFieldByKey() != null) {
                    this.processItemCreationDate(itemsDaysMap, result, endingStatus, selectedItem.getTfsFieldByKey(), itemDatesMap, "CreatedDate");
                    continue;
                }
                if (selectedItem.getCreatedOn() == null) continue;
                timeSeriesUtils.getItemDifferenceMapwrtCreationDate(selectedItem, endingStatus, result, itemsDaysMap, itemDatesMap);
            }
        }
        Map<String, Object> responseObject = new HashMap();
        responseObject = timeSeriesUtils.getIntervalForLeadTime(interval, result);
        responseObject.put("itemDaysMap", itemsDaysMap);
        responseObject.put("itemDatesMap", itemDatesMap);
        return responseObject;
    }

    private void processItemCreationDate(Map<String, Long> itemsDaysMap, Map<String, Long> result, TimeSeriesLog endingStatus, Map<String, Object> fieldByKey, Map<String, List<String>> itemDatesMap, String dateKey) {
        String creationDate;
        if (fieldByKey != null && (creationDate = (String)fieldByKey.get(dateKey)) != null) {
            Instant instant = TimeSeriesUtils.parseDate((String)creationDate);
            if (PropertyValidator.isValid((Object)instant)) {
                Date creationDateFinal = Date.from(instant);
                LocalDateTime creationDateTime = creationDateFinal.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().withSecond(0).withNano(0);
                LocalDateTime endingDateTime = endingStatus.getEventTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().withSecond(0).withNano(0);
                if (creationDateFinal.before(endingStatus.getEventTime()) || endingDateTime.equals(creationDateTime)) {
                    long millisecondsDifference = endingStatus.getEventTime().getTime() - creationDateFinal.getTime();
                    long daysDifference = millisecondsDifference / 86400000L;
                    if (daysDifference < 1L && millisecondsDifference > 0L || endingDateTime.equals(creationDateTime) || endingStatus.getEventTime().getTime() - creationDateFinal.getTime() > 0L && millisecondsDifference < 1L) {
                        daysDifference = 1L;
                    }
                    if (daysDifference > 0L) {
                        result.put(endingStatus.getItemId(), daysDifference);
                        itemsDaysMap.put("itemId_" + endingStatus.getItemId() + ":team", daysDifference);
                        ArrayList<String> dates = new ArrayList<String>();
                        dates.add(creationDateFinal.toString());
                        dates.add(endingStatus.getEventTime().toString());
                        itemDatesMap.put("itemId_" + endingStatus.getItemId() + ":team", dates);
                    }
                }
            }
        }
    }

    public Map<String, Object> getItemsForFlowLine(SessionBoard sessionBoard, String sessionBoardIds, String tenant, List<String> startingStatusId, List<String> endingStatusId, String interval, List<Status> statusList, List<String> selectedIssueType, String groupBy, String radioButtonSelection, String boardItemsFilter, Dashboard dashboard, Map<String, String> itemTags) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map itemsDaysMap = new HashMap();
        TimeSeriesUtils timeSeriesUtils = new TimeSeriesUtils(this.mongoTemplate, this.statusRepository);
        ArrayList allIntervals = new ArrayList();
        Map<String, List<Date>> releventDates = new LinkedHashMap();
        long logStartTime = System.currentTimeMillis();
        block5 : switch (interval) {
            case "sprints": {
                releventDates = timeSeriesUtils.getSprintDates(sessionBoard);
                break;
            }
            case "weekly": {
                Map sprintDates = timeSeriesUtils.getSprintDates(sessionBoard);
                ArrayList allSprints = new ArrayList(sprintDates.keySet());
                if (allSprints.isEmpty()) break;
                Date startDate = (Date)((List)sprintDates.get(allSprints.get(0))).get(0);
                Date endDate = (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1);
                long startTime = startDate.getTime();
                long endTime = endDate.getTime();
                for (long weekStart = startTime; weekStart <= endTime; weekStart += 604800000L) {
                    Date weekStartDate = new Date(weekStart);
                    Date weekEndDate = new Date(Math.min(weekStart + 518400000L, endTime));
                    if (weekStartDate.after(new Date())) break block5;
                    releventDates.put("Week " + (releventDates.size() + 1), Arrays.asList(weekStartDate, weekEndDate));
                }
                break;
            }
            case "monthly": {
                Calendar calendar = Calendar.getInstance();
                Map sprintDates = timeSeriesUtils.getSprintDates(sessionBoard);
                ArrayList allSprints = new ArrayList(sprintDates.keySet());
                if (allSprints.isEmpty()) break;
                calendar.setTime((Date)((List)sprintDates.get(allSprints.get(0))).get(0));
                releventDates = timeSeriesUtils.getAllMonthswrtFirstAndLastEntry(calendar, (Date)((List)sprintDates.get(allSprints.get(0))).get(0), (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1));
                break;
            }
        }
        LOGGER.info("Method :" + this.getClass().getName() + ".getItemsForFlowLine: Intervals Fetching execution lasted (seconds):" + (float)(System.currentTimeMillis() - logStartTime) / 1000.0f);
        Map sprintDates = timeSeriesUtils.getSprintDates(sessionBoard);
        ArrayList allSprints = new ArrayList(sprintDates.keySet());
        List startingStatusMatch = new ArrayList();
        List endingStatusMatch = new ArrayList();
        String endingStatusCategory = null;
        ArrayList<String> searchedItemIds = new ArrayList<String>();
        if (PropertyValidator.isValid(allSprints) && PropertyValidator.isValid((Object)sprintDates)) {
            if (PropertyValidator.isValid(itemTags)) {
                searchedItemIds.addAll(itemTags.keySet());
            }
            long secondStartTime = System.currentTimeMillis();
            startingStatusMatch = timeSeriesUtils.getFilteredItemsListByStatus(searchedItemIds, startingStatusId, sessionBoard.getCreationDate(), (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1), tenant, "itemTimeSeries", sessionBoard.getId());
            timeSeriesUtils.checkItemExistanceInCollection(startingStatusMatch);
            LOGGER.info("Method :" + this.getClass().getName() + ".getItemsForFlowLine: Start Status Items Fetching execution lasted (seconds):" + (float)(System.currentTimeMillis() - secondStartTime) / 1000.0f);
            long endStartTime = System.currentTimeMillis();
            if (radioButtonSelection.equals("statusCategory")) {
                endingStatusMatch = timeSeriesUtils.getFilteredItemsListByStatusCategory(searchedItemIds, endingStatusId, sessionBoard.getCreationDate(), (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1), tenant, "itemTimeSeries", sessionBoard.getId());
                timeSeriesUtils.checkItemExistanceInCollection(endingStatusMatch);
            } else {
                endingStatusMatch = timeSeriesUtils.getFilteredItemsListByStatus(searchedItemIds, endingStatusId, sessionBoard.getCreationDate(), (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1), tenant, "itemTimeSeries", sessionBoard.getId());
                timeSeriesUtils.checkItemExistanceInCollection(endingStatusMatch);
            }
            LOGGER.info("Method :" + this.getClass().getName() + ".getItemsForFlowLine: End Status Items Fetching execution lasted (seconds):" + (float)(System.currentTimeMillis() - endStartTime) / 1000.0f);
            ArrayList<String> endingStatusIdsList = new ArrayList<String>();
            for (String status : endingStatusId) {
                endingStatusIdsList.add(status);
            }
            long endCategoryTime = System.currentTimeMillis();
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").in(endingStatusIdsList));
            query.fields().include("category");
            Status endingCategoryStatus = (Status)this.mongoTemplate.findOne(query, Status.class);
            LOGGER.info("Method :" + this.getClass().getName() + ".getItemsForFlowLine: End Status Category execution lasted (seconds):" + (float)(System.currentTimeMillis() - endStartTime) / 1000.0f);
            endingStatusCategory = endingCategoryStatus.getCategory();
            long plannedUnPlannedTime = System.currentTimeMillis();
            if (!startingStatusMatch.isEmpty() && !endingStatusMatch.isEmpty()) {
                if (boardItemsFilter.equals("unplanned-items")) {
                    startingStatusMatch = timeSeriesUtils.retrieveAndCheckTeamContainerForUnPlanned(startingStatusMatch, tenant);
                    endingStatusMatch = timeSeriesUtils.retrieveAndCheckTeamContainerForUnPlanned(endingStatusMatch, tenant);
                } else if (boardItemsFilter.equals("planned-items")) {
                    startingStatusMatch = timeSeriesUtils.retrieveAndCheckTeamContainerForPlanned(startingStatusMatch, tenant);
                    endingStatusMatch = timeSeriesUtils.retrieveAndCheckTeamContainerForPlanned(endingStatusMatch, tenant);
                }
            }
            LOGGER.info("Method :" + this.getClass().getName() + ".getItemsForFlowLine: Planned Unplanned execution lasted (seconds):" + (float)(System.currentTimeMillis() - plannedUnPlannedTime) / 1000.0f);
        }
        Map earliestStartingStatusMap = new HashMap();
        Map farthestEndingStatusMap = new HashMap();
        List matchingItemsMap = new ArrayList();
        HashMap teamStatusMap = new HashMap();
        HashMap issueTypeStatusMap = new HashMap();
        HashMap plannedUnplannedStatusMap = new HashMap();
        HashMap jiraProjectIssueTypeMap = new HashMap();
        HashMap tfsProjectIssueTypeMap = new HashMap();
        HashMap areaPathMap = new HashMap();
        HashMap parentEpicMap = new HashMap();
        HashMap customFieldsMap = new HashMap();
        HashMap tempCustomFieldsMap = new HashMap();
        Map itemTeamsMap = new HashMap();
        Map itemSprintsMap = new HashMap();
        Map itemGroupbyMap = new HashMap();
        Map allGroupBysMap = new HashMap();
        Map groupbyIdColorMap = new HashMap();
        Set itemIds = new HashSet();
        timeSeriesUtils = new TimeSeriesUtils(this.mongoTemplate, this.statusRepository);
        long earliestStatusMapTime = System.currentTimeMillis();
        earliestStartingStatusMap = timeSeriesUtils.populateEarliestStatusMap(startingStatusMatch, selectedIssueType, sessionBoardIds);
        LOGGER.info("Method :" + this.getClass().getName() + ".getItemsForFlowLine: earliestStartingStatusMap execution lasted (seconds):" + (float)(System.currentTimeMillis() - earliestStatusMapTime) / 1000.0f);
        long farthestStatusMapTime = System.currentTimeMillis();
        if (radioButtonSelection.equals("statusCategory")) {
            for (Map.Entry entry : earliestStartingStatusMap.entrySet()) {
                endingStatusMatch.remove(entry.getValue());
            }
            farthestEndingStatusMap = timeSeriesUtils.populateFarthestStatusCategoryMap(endingStatusMatch, selectedIssueType, sessionBoardIds, endingStatusId, endingStatusCategory);
        } else {
            farthestEndingStatusMap = timeSeriesUtils.populateFarthestStatusMap(endingStatusMatch, selectedIssueType, sessionBoardIds);
        }
        LOGGER.info("Method :" + this.getClass().getName() + ".getItemsForFlowLine: farthestEndingStatusMap execution lasted (seconds):" + (float)(System.currentTimeMillis() - farthestStatusMapTime) / 1000.0f);
        List doneCategoryStatusesIds = new ArrayList();
        doneCategoryStatusesIds = timeSeriesUtils.getDoneStatusIds(statusList);
        long matchingItemsMapTime = System.currentTimeMillis();
        matchingItemsMap = timeSeriesUtils.populateMatchingItemsMap(doneCategoryStatusesIds, endingStatusId, earliestStartingStatusMap, farthestEndingStatusMap);
        LOGGER.info("Method :" + this.getClass().getName() + ".getItemsForFlowLine: Matching Items Map execution lasted (seconds):" + (float)(System.currentTimeMillis() - matchingItemsMapTime) / 1000.0f);
        String customFieldType = "";
        switch (groupBy) {
            case "teams": {
                long teamGroupTime = System.currentTimeMillis();
                Map tempMap = timeSeriesUtils.getTeamGroupByMatchingItemsMap(matchingItemsMap, sessionBoardIds);
                LOGGER.info("Method :" + this.getClass().getName() + ".getItemsForFlowLine: Team Group By Time execution lasted (seconds):" + (float)(System.currentTimeMillis() - teamGroupTime) / 1000.0f);
                teamStatusMap = (HashMap)tempMap.get("teamGroupByMatchingItemsMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                groupbyIdColorMap = (Map)tempMap.get("teamIdColorMap");
                Map tempResult = timeSeriesUtils.getTeamGroupDateAgainstInterval((Map)teamStatusMap, releventDates, allIntervals, interval, allGroupBysMap, sessionBoard);
                itemIds = (Set)tempResult.get("itemIds");
                itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("itemTeamsMap", itemTeamsMap);
                result.put("itemSprintsMap", itemSprintsMap);
                result.put("itemGroupByMap", itemGroupbyMap);
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                result.put("itemStatusMap", tempResult.get("itemStatusMap"));
                break;
            }
            case "cardType": {
                long cardGroupTime = System.currentTimeMillis();
                Map tempMap = timeSeriesUtils.getCardTypeGroupByMatchingItemsMap(matchingItemsMap, sessionBoardIds);
                LOGGER.info("Method :" + this.getClass().getName() + ".getItemsForFlowLine: Card Group By Time execution lasted (seconds):" + (float)(System.currentTimeMillis() - cardGroupTime) / 1000.0f);
                issueTypeStatusMap = (HashMap)tempMap.get("issueGroupByMatchingItemsMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                groupbyIdColorMap = (Map)tempMap.get("cardtypeColorMap");
                long flowTimeLogicTime = System.currentTimeMillis();
                Map tempResult = timeSeriesUtils.getCardTypeGroupDataAgainstInterval((Map)issueTypeStatusMap, releventDates, allIntervals, interval, allGroupBysMap);
                itemIds = (Set)tempResult.get("itemIds");
                LOGGER.info("Method :" + this.getClass().getName() + ".getItemsForFlowLine: Flow Time Logic execution lasted (seconds):" + (float)(System.currentTimeMillis() - cardGroupTime) / 1000.0f);
                itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("itemTeamsMap", itemTeamsMap);
                result.put("itemSprintsMap", itemSprintsMap);
                result.put("itemGroupByMap", itemGroupbyMap);
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            case "plannedUnplanned": {
                Map tempMap = timeSeriesUtils.getPlannedUnPlannedGroupByMatchingItemsMap(matchingItemsMap, sessionBoardIds);
                plannedUnplannedStatusMap = (HashMap)tempMap.get("plannedUnplannedStatusMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                Map tempResult = timeSeriesUtils.getplannedUnplannedGroupDataAgainstInterval((Map)plannedUnplannedStatusMap, releventDates, allIntervals, interval, allGroupBysMap);
                itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("itemTeamsMap", itemTeamsMap);
                result.put("itemSprintsMap", itemSprintsMap);
                result.put("itemGroupByMap", itemGroupbyMap);
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                break;
            }
            case "jiraProject": {
                Map tempMap = timeSeriesUtils.getJiraProjectGroupByMatchingItemsMap(matchingItemsMap, sessionBoardIds, dashboard);
                jiraProjectIssueTypeMap = (HashMap)tempMap.get("jiraProjectIssueTypeMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                groupbyIdColorMap = (Map)tempMap.get("jiraProjectColorMap");
                Map tempResult = timeSeriesUtils.getJiraProjectGroupDataAgainstInterval((Map)jiraProjectIssueTypeMap, releventDates, allIntervals, interval, allGroupBysMap);
                itemIds = (Set)tempResult.get("itemIds");
                itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("itemTeamsMap", itemTeamsMap);
                result.put("itemSprintsMap", itemSprintsMap);
                result.put("itemGroupByMap", itemGroupbyMap);
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            case "tfsProject": {
                Map tempMap = timeSeriesUtils.getTFSProjectGroupByMatchingItemsMap(matchingItemsMap, sessionBoardIds, dashboard);
                tfsProjectIssueTypeMap = (HashMap)tempMap.get("tfsProjectIssueTypeMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                groupbyIdColorMap = (Map)tempMap.get("tfsProjectColorMap");
                Map tempResult = timeSeriesUtils.getTFSProjectGroupDataAgainstInterval((Map)tfsProjectIssueTypeMap, releventDates, allIntervals, interval, allGroupBysMap, sessionBoard.getSession().getId());
                itemIds = (Set)tempResult.get("itemIds");
                itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("itemTeamsMap", itemTeamsMap);
                result.put("itemSprintsMap", itemSprintsMap);
                result.put("itemGroupByMap", itemGroupbyMap);
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            case "areaPath": {
                Map tempMap = timeSeriesUtils.getAreaPathGroupByMatchingItemsMap(matchingItemsMap, sessionBoardIds, dashboard);
                areaPathMap = (HashMap)tempMap.get("areaPathMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                groupbyIdColorMap = (Map)tempMap.get("areaPathColorMap");
                Map tempResult = timeSeriesUtils.getAreaPathGroupDataAgainstInterval((Map)areaPathMap, releventDates, allIntervals, interval, allGroupBysMap);
                itemIds = (Set)tempResult.get("itemIds");
                itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("itemTeamsMap", itemTeamsMap);
                result.put("itemSprintsMap", itemSprintsMap);
                result.put("itemGroupByMap", itemGroupbyMap);
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            case "epic": {
                Map tempMap = timeSeriesUtils.getParentEpicGroupByMatchingItemsMap(matchingItemsMap, sessionBoardIds);
                parentEpicMap = (HashMap)tempMap.get("parentEpicMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                Map tempResult = timeSeriesUtils.getParentEpicGroupDataAgainstInterval((Map)parentEpicMap, releventDates, allIntervals, interval, allGroupBysMap);
                itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("itemTeamsMap", itemTeamsMap);
                result.put("itemSprintsMap", itemSprintsMap);
                result.put("itemGroupByMap", itemGroupbyMap);
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            default: {
                Map tempResult;
                Map.Entry firstEntry;
                TimeSeriesLog earliestItem;
                String[] parts = groupBy.split("-");
                String groupByvalue = parts[1];
                if (!matchingItemsMap.isEmpty() && (earliestItem = (TimeSeriesLog)(firstEntry = ((Map)matchingItemsMap.get(0)).entrySet().iterator().next()).getKey()).getItemId() != null) {
                    Map tempMap;
                    Query queryForItem = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(earliestItem.getItemId())));
                    Item tempItem = (Item)this.mongoTemplate.findOne(queryForItem, Item.class);
                    if (tempItem.getJiraFieldByKey() != null) {
                        customFieldType = "jiraCustomFields";
                        tempMap = timeSeriesUtils.getJiraCustomFieldGroupByMatchingItemsMap(matchingItemsMap, groupByvalue, sessionBoardIds);
                        tempCustomFieldsMap = (HashMap)tempMap.get("customFieldsMap");
                        allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                    } else if (tempItem.getTfsFieldByKey() != null) {
                        customFieldType = "tfsCustomFields";
                        tempMap = timeSeriesUtils.getTFSCustomFieldGroupByMatchingItemsMap(matchingItemsMap, groupByvalue, sessionBoardIds);
                        customFieldsMap = (HashMap)tempMap.get("customFieldsMap");
                        allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                    }
                }
                if (customFieldType.equals("jiraCustomFields")) {
                    tempResult = timeSeriesUtils.getJiraCustomFieldGroupDataAgainstInterval(tempCustomFieldsMap, releventDates, allIntervals, interval, allGroupBysMap);
                    itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                    itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                    itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                    itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                    result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                    result.put("itemTeamsMap", itemTeamsMap);
                    result.put("itemSprintsMap", itemSprintsMap);
                    result.put("itemGroupByMap", itemGroupbyMap);
                    result.put("intervals", tempResult.get("intervals"));
                    result.put("categories", tempResult.get("categories"));
                    break;
                }
                if (!customFieldType.equals("tfsCustomFields")) break;
                tempResult = timeSeriesUtils.getTFSCustomFieldGroupDataAgainstInterval(customFieldsMap, releventDates, allIntervals, interval, allGroupBysMap);
                itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("itemTeamsMap", itemTeamsMap);
                result.put("itemSprintsMap", itemSprintsMap);
                result.put("itemGroupByMap", itemGroupbyMap);
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
            }
        }
        if ("statusCategory".equals(radioButtonSelection) && PropertyValidator.isValid(itemIds)) {
            ArrayList<ObjectId> itemIdsObjectList = new ArrayList<ObjectId>();
            for (String itemId : itemIds) {
                itemIdsObjectList.add(new ObjectId(itemId));
            }
            HashMap<String, List> itemStatusMap = new HashMap<String, List>();
            Query queryForItem = new Query((CriteriaDefinition)Criteria.where((String)"id").in(itemIdsObjectList));
            queryForItem.fields().include("status");
            List itemsList = this.mongoTemplate.find(queryForItem, Item.class);
            for (Item item : itemsList) {
                List tempStatus = itemStatusMap.getOrDefault(item.getId(), new ArrayList());
                if (!PropertyValidator.isValid((Object)item.getStatus())) continue;
                tempStatus.add(item.getStatus().getTitle() + "status_category:" + item.getStatus().getCategory());
                itemStatusMap.put(item.getId(), tempStatus);
            }
            result.put("itemStatusMap", itemStatusMap);
        }
        result.put("allGroupBys", allGroupBysMap);
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("groupIdColorMap", groupbyIdColorMap);
        return result;
    }

    public Map<String, Object> getItemsForFlowEfficiency(SessionBoard sessionBoard, String sessionBoardIds, String tenant, List<String> startingStatusId, List<String> endingStatusId, List<String> activeStatuses, List<Status> statusList, String interval, List<String> selectedIssueType, String groupBy, boolean creationDateEnabled, String boardItemsFilter, Dashboard dashboard, Map<String, String> itemTags) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map itemsDaysMap = new HashMap();
        Map itemTeamsMap = new HashMap();
        Map itemSprintsMap = new HashMap();
        Map itemGroupbyMap = new HashMap();
        Map groupbyIdColorMap = new HashMap();
        ArrayList<String> searchedItemIds = new ArrayList<String>();
        this.timeSeriesUtils = new TimeSeriesUtils(this.mongoTemplate, this.statusRepository);
        if (PropertyValidator.isValid(itemTags)) {
            searchedItemIds.addAll(itemTags.keySet());
        }
        Map sprintDates = this.timeSeriesUtils.getSprintDates(sessionBoard);
        ArrayList allSprints = new ArrayList(sprintDates.keySet());
        if (!creationDateEnabled) {
            Map<String, List<Date>> releventDates = new LinkedHashMap();
            ArrayList allIntervals = new ArrayList();
            block5 : switch (interval) {
                case "sprints": {
                    releventDates = this.timeSeriesUtils.getSprintDates(sessionBoard);
                    break;
                }
                case "weekly": {
                    if (allSprints.isEmpty()) break;
                    Date startDate = (Date)((List)sprintDates.get(allSprints.get(0))).get(0);
                    Date endDate = (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1);
                    long startTime = startDate.getTime();
                    long endTime = endDate.getTime();
                    for (long weekStart = startTime; weekStart <= endTime; weekStart += 604800000L) {
                        Date weekStartDate = new Date(weekStart);
                        Date weekEndDate = new Date(Math.min(weekStart + 518400000L, endTime));
                        if (weekStartDate.after(new Date())) break block5;
                        releventDates.put("Week " + (releventDates.size() + 1), Arrays.asList(weekStartDate, weekEndDate));
                    }
                    break;
                }
                case "monthly": {
                    Calendar calendar = Calendar.getInstance();
                    if (allSprints.isEmpty()) break;
                    calendar.setTime((Date)((List)sprintDates.get(allSprints.get(0))).get(0));
                    releventDates = this.timeSeriesUtils.getAllMonthswrtFirstAndLastEntry(calendar, (Date)((List)sprintDates.get(allSprints.get(0))).get(0), (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1));
                    break;
                }
            }
            List startingStatusMatch = new ArrayList();
            List endingStatusMatch = new ArrayList();
            if (PropertyValidator.isValid((Object)sprintDates) && PropertyValidator.isValid(allSprints)) {
                startingStatusMatch = this.timeSeriesUtils.getFilteredItemsListByStatus(searchedItemIds, startingStatusId, sessionBoard.getCreationDate(), (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1), tenant, "itemTimeSeries", sessionBoard.getId());
                endingStatusMatch = this.timeSeriesUtils.getFilteredItemsListByStatus(searchedItemIds, endingStatusId, sessionBoard.getCreationDate(), (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1), tenant, "itemTimeSeries", sessionBoard.getId());
                this.timeSeriesUtils.checkItemExistanceInCollection(startingStatusMatch);
                this.timeSeriesUtils.checkItemExistanceInCollection(endingStatusMatch);
            }
            if (!startingStatusMatch.isEmpty() && !endingStatusMatch.isEmpty()) {
                if (boardItemsFilter.equals("unplanned-items")) {
                    startingStatusMatch = this.timeSeriesUtils.retrieveAndCheckTeamContainerForUnPlanned(startingStatusMatch, tenant);
                    endingStatusMatch = this.timeSeriesUtils.retrieveAndCheckTeamContainerForUnPlanned(endingStatusMatch, tenant);
                } else if (boardItemsFilter.equals("planned-items")) {
                    startingStatusMatch = this.timeSeriesUtils.retrieveAndCheckTeamContainerForPlanned(startingStatusMatch, tenant);
                    endingStatusMatch = this.timeSeriesUtils.retrieveAndCheckTeamContainerForPlanned(endingStatusMatch, tenant);
                }
            }
            Map earliestStartingStatusMap = new HashMap();
            Map farthestEndingStatusMap = new HashMap();
            List matchingItemsMap = new ArrayList();
            this.timeSeriesUtils = new TimeSeriesUtils(this.mongoTemplate, this.statusRepository);
            earliestStartingStatusMap = this.timeSeriesUtils.populateEarliestStatusMap(startingStatusMatch, selectedIssueType, sessionBoardIds);
            farthestEndingStatusMap = this.timeSeriesUtils.populateFarthestStatusMap(endingStatusMatch, selectedIssueType, sessionBoardIds);
            List doneCategoryStatusesIds = new ArrayList();
            doneCategoryStatusesIds = this.timeSeriesUtils.getDoneStatusIds(statusList);
            matchingItemsMap = this.timeSeriesUtils.populateMatchingItemsMap(doneCategoryStatusesIds, endingStatusId, earliestStartingStatusMap, farthestEndingStatusMap);
            Set itemOfMatchingItemsMap = matchingItemsMap.stream().map(matchingItemsMap1 -> (TimeSeriesLog)matchingItemsMap1.keySet().iterator().next()).collect(Collectors.toSet());
            List activeStatusList = this.timeSeriesUtils.populateActiveStatusTimeSeries(sessionBoard, tenant, activeStatuses, sessionBoardIds, itemOfMatchingItemsMap, sprintDates);
            this.timeSeriesUtils.checkItemExistanceInCollection(activeStatusList);
            HashMap teamStatusMap = new HashMap();
            HashMap issueTypeStatusMap = new HashMap();
            HashMap plannedUnplannedStatusMap = new HashMap();
            HashMap jiraProjectIssueTypeMap = new HashMap();
            HashMap tfsProjectIssueTypeMap = new HashMap();
            HashMap areaPathMap = new HashMap();
            HashMap parentEpicMap = new HashMap();
            HashMap customFieldsMap = new HashMap();
            HashMap tempCustomFieldsMap = new HashMap();
            Map allGroupBysMap = new HashMap();
            String customFieldType = "";
            int counter = 0;
            Date sDate = new Date();
            Date eDate = new Date();
            int relevantDatesSize = releventDates.size();
            for (Map.Entry entry : releventDates.entrySet()) {
                if (counter == 0) {
                    sDate = (Date)((List)entry.getValue()).get(0);
                }
                if (counter == relevantDatesSize - 1) {
                    eDate = (Date)((List)entry.getValue()).get(1);
                }
                ++counter;
            }
            switch (groupBy) {
                case "teams": {
                    Map tempMap = this.timeSeriesUtils.getTeamGroupByMatchingItemsMap(matchingItemsMap, sessionBoardIds);
                    teamStatusMap = (HashMap)tempMap.get("teamGroupByMatchingItemsMap");
                    allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                    groupbyIdColorMap = (Map)tempMap.get("teamIdColorMap");
                    Map tempResult = this.timeSeriesUtils.getTeamEfficiencyDataAgainstInterval((Map)teamStatusMap, activeStatusList, releventDates, allIntervals, interval, sessionBoardIds, sDate, eDate, tenant);
                    itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                    itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                    itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                    itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                    result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                    result.put("itemTeamsMap", itemTeamsMap);
                    result.put("itemSprintsMap", itemSprintsMap);
                    result.put("itemGroupByMap", itemGroupbyMap);
                    result.put("intervals", tempResult.get("intervals"));
                    result.put("categories", tempResult.get("categories"));
                    result.put("itemActiveCountsMap", tempResult.get("itemActiveCountsMap"));
                    result.put("itemTotalCountsMap", tempResult.get("itemTotalCountsMap"));
                    result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                    break;
                }
                case "cardType": {
                    Map tempMap = this.timeSeriesUtils.getCardTypeGroupByMatchingItemsMap(matchingItemsMap, sessionBoardIds);
                    issueTypeStatusMap = (HashMap)tempMap.get("issueGroupByMatchingItemsMap");
                    allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                    groupbyIdColorMap = (Map)tempMap.get("cardtypeColorMap");
                    Map tempResult = this.timeSeriesUtils.getCardTypeEfficiencyDataAgainstInterval((Map)issueTypeStatusMap, activeStatusList, releventDates, allIntervals, interval, sessionBoardIds, sDate, eDate, tenant);
                    itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                    itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                    itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                    itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                    result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                    result.put("itemTeamsMap", itemTeamsMap);
                    result.put("itemSprintsMap", itemSprintsMap);
                    result.put("itemGroupByMap", itemGroupbyMap);
                    result.put("intervals", tempResult.get("intervals"));
                    result.put("categories", tempResult.get("categories"));
                    result.put("itemActiveCountsMap", tempResult.get("itemActiveCountsMap"));
                    result.put("itemTotalCountsMap", tempResult.get("itemTotalCountsMap"));
                    result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                    break;
                }
                case "plannedUnplanned": {
                    Map tempMap = this.timeSeriesUtils.getPlannedUnPlannedGroupByMatchingItemsMap(matchingItemsMap, sessionBoardIds);
                    plannedUnplannedStatusMap = (HashMap)tempMap.get("plannedUnplannedStatusMap");
                    allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                    Map tempResult = this.timeSeriesUtils.getplannedUnplannedEfficiencyDataAgainstInterval((Map)plannedUnplannedStatusMap, activeStatusList, releventDates, allIntervals, interval);
                    itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                    itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                    itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                    itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                    result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                    result.put("itemTeamsMap", itemTeamsMap);
                    result.put("itemSprintsMap", itemSprintsMap);
                    result.put("itemGroupByMap", itemGroupbyMap);
                    result.put("intervals", tempResult.get("intervals"));
                    result.put("categories", tempResult.get("categories"));
                    result.put("itemActiveCountsMap", tempResult.get("itemActiveCountsMap"));
                    result.put("itemTotalCountsMap", tempResult.get("itemTotalCountsMap"));
                    break;
                }
                case "jiraProject": {
                    Map tempMap = this.timeSeriesUtils.getJiraProjectGroupByMatchingItemsMap(matchingItemsMap, sessionBoardIds, dashboard);
                    jiraProjectIssueTypeMap = (HashMap)tempMap.get("jiraProjectIssueTypeMap");
                    allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                    groupbyIdColorMap = (Map)tempMap.get("jiraProjectColorMap");
                    Map tempResult = this.timeSeriesUtils.getJiraProjectEfficiencyDataAgainstInterval((Map)jiraProjectIssueTypeMap, activeStatusList, releventDates, allIntervals, interval, sessionBoardIds, sDate, eDate, tenant);
                    itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                    itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                    itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                    itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                    result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                    result.put("itemTeamsMap", itemTeamsMap);
                    result.put("itemSprintsMap", itemSprintsMap);
                    result.put("itemGroupByMap", itemGroupbyMap);
                    result.put("intervals", tempResult.get("intervals"));
                    result.put("categories", tempResult.get("categories"));
                    result.put("itemActiveCountsMap", tempResult.get("itemActiveCountsMap"));
                    result.put("itemTotalCountsMap", tempResult.get("itemTotalCountsMap"));
                    result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                    break;
                }
                case "tfsProject": {
                    Map tempMap = this.timeSeriesUtils.getTFSProjectGroupByMatchingItemsMap(matchingItemsMap, sessionBoardIds, dashboard);
                    tfsProjectIssueTypeMap = (HashMap)tempMap.get("tfsProjectIssueTypeMap");
                    allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                    groupbyIdColorMap = (Map)tempMap.get("tfsProjectColorMap");
                    Map tempResult = this.timeSeriesUtils.getTFSProjectEfficiencyDataAgainstInterval((Map)tfsProjectIssueTypeMap, activeStatusList, releventDates, allIntervals, interval, sessionBoardIds, sDate, eDate, tenant);
                    itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                    itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                    itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                    itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                    result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                    result.put("itemTeamsMap", itemTeamsMap);
                    result.put("itemSprintsMap", itemSprintsMap);
                    result.put("itemGroupByMap", itemGroupbyMap);
                    result.put("intervals", tempResult.get("intervals"));
                    result.put("categories", tempResult.get("categories"));
                    result.put("itemActiveCountsMap", tempResult.get("itemActiveCountsMap"));
                    result.put("itemTotalCountsMap", tempResult.get("itemTotalCountsMap"));
                    result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                    break;
                }
                case "areaPath": {
                    Map tempMap = this.timeSeriesUtils.getAreaPathGroupByMatchingItemsMap(matchingItemsMap, sessionBoardIds, dashboard);
                    areaPathMap = (HashMap)tempMap.get("areaPathMap");
                    allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                    groupbyIdColorMap = (Map)tempMap.get("areaPathColorMap");
                    Map tempResult = this.timeSeriesUtils.getAreaPathEfficiencyDataAgainstInterval((Map)areaPathMap, activeStatusList, releventDates, allIntervals, interval, sessionBoardIds, sDate, eDate, tenant);
                    itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                    itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                    itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                    itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                    result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                    result.put("itemTeamsMap", itemTeamsMap);
                    result.put("itemSprintsMap", itemSprintsMap);
                    result.put("itemGroupByMap", itemGroupbyMap);
                    result.put("intervals", tempResult.get("intervals"));
                    result.put("categories", tempResult.get("categories"));
                    result.put("itemActiveCountsMap", tempResult.get("itemActiveCountsMap"));
                    result.put("itemTotalCountsMap", tempResult.get("itemTotalCountsMap"));
                    result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                    break;
                }
                case "epic": {
                    Map tempMap = this.timeSeriesUtils.getParentEpicGroupByMatchingItemsMap(matchingItemsMap, sessionBoardIds);
                    parentEpicMap = (HashMap)tempMap.get("parentEpicMap");
                    allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                    Map tempResult = this.timeSeriesUtils.getParentEpicEfficiencyDataAgainstInterval((Map)parentEpicMap, activeStatusList, releventDates, allIntervals, interval);
                    itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                    itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                    itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                    itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                    result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                    result.put("itemTeamsMap", itemTeamsMap);
                    result.put("itemSprintsMap", itemSprintsMap);
                    result.put("itemGroupByMap", itemGroupbyMap);
                    result.put("intervals", tempResult.get("intervals"));
                    result.put("categories", tempResult.get("categories"));
                    result.put("itemActiveCountsMap", tempResult.get("itemActiveCountsMap"));
                    result.put("itemTotalCountsMap", tempResult.get("itemTotalCountsMap"));
                    result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                    break;
                }
                default: {
                    Map.Entry firstEntry;
                    TimeSeriesLog earliestItem;
                    String[] parts = groupBy.split("-");
                    String groupByvalue = parts[1];
                    if (matchingItemsMap.size() <= 0 || (earliestItem = (TimeSeriesLog)(firstEntry = ((Map)matchingItemsMap.get(0)).entrySet().iterator().next()).getKey()).getItemId() == null) break;
                    Query queryForItem = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(earliestItem.getItemId())));
                    Item tempItem = (Item)this.mongoTemplate.findOne(queryForItem, Item.class);
                    if (tempItem.getJiraFieldByKey() != null) {
                        customFieldType = "jiraCustomFields";
                        Map tempMap = this.timeSeriesUtils.getJiraCustomFieldGroupByMatchingItemsMap(matchingItemsMap, groupByvalue, sessionBoardIds);
                        tempCustomFieldsMap = (HashMap)tempMap.get("customFieldsMap");
                        allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                        Map tempResult = this.timeSeriesUtils.getJiraCustomFieldsEfficiencyDataAgainstInterval((Map)tempCustomFieldsMap, activeStatusList, releventDates, allIntervals, interval);
                        itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                        itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                        itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                        itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                        result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                        result.put("itemTeamsMap", itemTeamsMap);
                        result.put("itemSprintsMap", itemSprintsMap);
                        result.put("itemGroupByMap", itemGroupbyMap);
                        result.put("intervals", tempResult.get("intervals"));
                        result.put("categories", tempResult.get("categories"));
                        result.put("itemActiveCountsMap", tempResult.get("itemActiveCountsMap"));
                        result.put("itemTotalCountsMap", tempResult.get("itemTotalCountsMap"));
                        break;
                    }
                    if (tempItem.getTfsFieldByKey() == null) break;
                    customFieldType = "tfsCustomFields";
                    Map tempMap = this.timeSeriesUtils.getTFSCustomFieldGroupByMatchingItemsMap(matchingItemsMap, groupByvalue, sessionBoardIds);
                    customFieldsMap = (HashMap)tempMap.get("customFieldsMap");
                    allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                    Map tempResult = this.timeSeriesUtils.getTFSCustomFieldsEfficiencyDataAgainstInterval((Map)customFieldsMap, activeStatusList, releventDates, allIntervals, interval);
                    itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                    itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                    itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                    itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                    result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                    result.put("itemTeamsMap", itemTeamsMap);
                    result.put("itemSprintsMap", itemSprintsMap);
                    result.put("itemGroupByMap", itemGroupbyMap);
                    result.put("intervals", tempResult.get("intervals"));
                    result.put("categories", tempResult.get("categories"));
                    result.put("itemActiveCountsMap", tempResult.get("itemActiveCountsMap"));
                    result.put("itemTotalCountsMap", tempResult.get("itemTotalCountsMap"));
                }
            }
            result.put("allGroupBys", allGroupBysMap);
        } else if (creationDateEnabled) {
            this.timeSeriesUtils = new TimeSeriesUtils(this.mongoTemplate, this.statusRepository);
            List endingStatusMatch = new ArrayList();
            if (PropertyValidator.isValid((Object)sprintDates) && PropertyValidator.isValid(allSprints)) {
                endingStatusMatch = this.timeSeriesUtils.getFilteredItemsListByStatus(searchedItemIds, endingStatusId, sessionBoard.getCreationDate(), (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1), tenant, "itemTimeSeries", sessionBoard.getId());
                this.timeSeriesUtils.checkItemExistanceInCollection(endingStatusMatch);
            }
            Map<String, List<Date>> releventDates = new LinkedHashMap();
            ArrayList allIntervals = new ArrayList();
            block33 : switch (interval) {
                case "sprints": {
                    releventDates = this.timeSeriesUtils.getSprintDates(sessionBoard);
                    break;
                }
                case "weekly": {
                    if (allSprints.isEmpty()) break;
                    Date startDate = (Date)((List)sprintDates.get(allSprints.get(0))).get(0);
                    Date endDate = (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1);
                    long startTime = startDate.getTime();
                    long endTime = endDate.getTime();
                    for (long weekStart = startTime; weekStart <= endTime; weekStart += 604800000L) {
                        Date weekStartDate = new Date(weekStart);
                        Date weekEndDate = new Date(Math.min(weekStart + 518400000L, endTime));
                        if (weekStartDate.after(new Date())) break block33;
                        releventDates.put("Week " + (releventDates.size() + 1), Arrays.asList(weekStartDate, weekEndDate));
                    }
                    break;
                }
                case "monthly": {
                    Calendar calendar = Calendar.getInstance();
                    if (allSprints.isEmpty()) break;
                    calendar.setTime((Date)((List)sprintDates.get(allSprints.get(0))).get(0));
                    releventDates = this.timeSeriesUtils.getAllMonthswrtFirstAndLastEntry(calendar, (Date)((List)sprintDates.get(allSprints.get(0))).get(0), (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1));
                    break;
                }
            }
            Map farthestEndingStatusMap = new HashMap();
            farthestEndingStatusMap = this.timeSeriesUtils.populateFarthestStatusMap(endingStatusMatch, selectedIssueType, sessionBoardIds);
            HashSet itemOfMatchingItemsMap = new HashSet(farthestEndingStatusMap.values());
            List activeStatusList = this.timeSeriesUtils.populateActiveStatusTimeSeries(sessionBoard, tenant, activeStatuses, sessionBoardIds, itemOfMatchingItemsMap, releventDates);
            this.timeSeriesUtils.checkItemExistanceInCollection(activeStatusList);
            Iterator iterator = itemOfMatchingItemsMap.iterator();
            while (iterator.hasNext()) {
                TimeSeriesLog item = (TimeSeriesLog)iterator.next();
                boolean itemFound = false;
                for (TimeSeriesLog activeStatus : activeStatusList) {
                    if (!activeStatus.getItemId().equals(item.getItemId())) continue;
                    itemFound = true;
                    break;
                }
                if (itemFound) continue;
                iterator.remove();
            }
            boolean itemFoundinFarthest = false;
            Iterator i1 = farthestEndingStatusMap.entrySet().iterator();
            while (i1.hasNext()) {
                Map.Entry entry = i1.next();
                String itemId = ((TimeSeriesLog)entry.getValue()).getItemId();
                for (TimeSeriesLog item : itemOfMatchingItemsMap) {
                    if (!item.getItemId().equals(itemId)) continue;
                    itemFoundinFarthest = true;
                    break;
                }
                if (!itemFoundinFarthest) {
                    i1.remove();
                }
                itemFoundinFarthest = false;
            }
            HashMap teamStatusMap = new HashMap();
            HashMap issueTypeStatusMap = new HashMap();
            HashMap plannedUnplannedStatusMap = new HashMap();
            HashMap jiraProjectIssueTypeMap = new HashMap();
            HashMap tfsProjectIssueTypeMap = new HashMap();
            HashMap areaPathMap = new HashMap();
            HashMap parentEpicMap = new HashMap();
            HashMap customFieldsMap = new HashMap();
            Map allGroupBysMap = new HashMap();
            String customFieldType = "";
            this.timeSeriesUtils = new TimeSeriesUtils(this.mongoTemplate, this.statusRepository);
            Date endDate = new Date();
            boolean counter = false;
            Map.Entry[] entries = releventDates.entrySet().toArray(new Map.Entry[0]);
            List lastValue = (List)entries[entries.length - 1].getValue();
            endDate = (Date)lastValue.get(1);
            switch (groupBy) {
                case "teams": {
                    Map tempMap = this.timeSeriesUtils.getTeamGroupByFurthestItemsMap(farthestEndingStatusMap);
                    teamStatusMap = (HashMap)tempMap.get("teamGroupByMatchingItemsMap");
                    allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                    groupbyIdColorMap = (Map)tempMap.get("teamIdColorMap");
                    Map tempResult = this.timeSeriesUtils.getTeamEfficiencybyCreationDate((Map)teamStatusMap, activeStatusList, releventDates, allIntervals, interval, sessionBoardIds, tenant, sessionBoard.getCreationDate(), endDate);
                    itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                    itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                    itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                    itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                    result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                    result.put("itemTeamsMap", itemTeamsMap);
                    result.put("itemSprintsMap", itemSprintsMap);
                    result.put("itemGroupByMap", itemGroupbyMap);
                    result.put("intervals", tempResult.get("intervals"));
                    result.put("categories", tempResult.get("categories"));
                    result.put("itemActiveCountsMap", tempResult.get("itemActiveCountsMap"));
                    result.put("itemTotalCountsMap", tempResult.get("itemTotalCountsMap"));
                    result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                    break;
                }
                case "cardType": {
                    Map tempMap = this.timeSeriesUtils.getCardTypeGroupByFurthestItemsMap(farthestEndingStatusMap);
                    issueTypeStatusMap = (HashMap)tempMap.get("issueTypeStatusMap");
                    allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                    groupbyIdColorMap = (Map)tempMap.get("cardtypeColorMap");
                    Map tempResult = this.timeSeriesUtils.getCardTypeEfficiencybyCreationDate((Map)issueTypeStatusMap, activeStatusList, releventDates, allIntervals, interval, sessionBoardIds, tenant, sessionBoard.getCreationDate(), endDate);
                    itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                    itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                    itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                    itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                    result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                    result.put("itemTeamsMap", itemTeamsMap);
                    result.put("itemSprintsMap", itemSprintsMap);
                    result.put("itemGroupByMap", itemGroupbyMap);
                    result.put("intervals", tempResult.get("intervals"));
                    result.put("categories", tempResult.get("categories"));
                    result.put("itemActiveCountsMap", tempResult.get("itemActiveCountsMap"));
                    result.put("itemTotalCountsMap", tempResult.get("itemTotalCountsMap"));
                    result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                    break;
                }
                case "plannedUnplanned": {
                    Map tempMap = this.timeSeriesUtils.getPlannedUnPlannedGroupByFurthestItemsMap(farthestEndingStatusMap);
                    plannedUnplannedStatusMap = (HashMap)tempMap.get("plannedUnplannedStatusMap");
                    allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                    Map tempResult = this.timeSeriesUtils.getPlannedUnplannedEfficiencybyCreationDate((Map)plannedUnplannedStatusMap, activeStatusList, releventDates, allIntervals, interval, sessionBoardIds, tenant, sessionBoard.getCreationDate(), endDate);
                    itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                    itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                    itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                    itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                    result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                    result.put("itemTeamsMap", itemTeamsMap);
                    result.put("itemSprintsMap", itemSprintsMap);
                    result.put("itemGroupByMap", itemGroupbyMap);
                    result.put("intervals", tempResult.get("intervals"));
                    result.put("categories", tempResult.get("categories"));
                    result.put("itemActiveCountsMap", tempResult.get("itemActiveCountsMap"));
                    result.put("itemTotalCountsMap", tempResult.get("itemTotalCountsMap"));
                    break;
                }
                case "jiraProject": {
                    Map tempMap = this.timeSeriesUtils.getJiraProjectGroupByFurthestItemsMap(farthestEndingStatusMap, dashboard);
                    jiraProjectIssueTypeMap = (HashMap)tempMap.get("jiraProjectIssueTypeMap");
                    allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                    groupbyIdColorMap = (Map)tempMap.get("jiraProjectColorMap");
                    Map tempResult = this.timeSeriesUtils.getJiraProjectEfficiencybyCreationDate((Map)jiraProjectIssueTypeMap, activeStatusList, releventDates, allIntervals, interval, sessionBoardIds, tenant, sessionBoard.getCreationDate(), endDate);
                    itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                    itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                    itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                    itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                    result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                    result.put("itemTeamsMap", itemTeamsMap);
                    result.put("itemSprintsMap", itemSprintsMap);
                    result.put("itemGroupByMap", itemGroupbyMap);
                    result.put("intervals", tempResult.get("intervals"));
                    result.put("categories", tempResult.get("categories"));
                    result.put("itemActiveCountsMap", tempResult.get("itemActiveCountsMap"));
                    result.put("itemTotalCountsMap", tempResult.get("itemTotalCountsMap"));
                    result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                    break;
                }
                case "tfsProject": {
                    Map tempMap = this.timeSeriesUtils.getTFSProjectGroupByFurthestItemsMap(farthestEndingStatusMap, dashboard);
                    tfsProjectIssueTypeMap = (HashMap)tempMap.get("tfsProjectIssueTypeMap");
                    allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                    groupbyIdColorMap = (Map)tempMap.get("tfsProjectColorMap");
                    Map tempResult = this.timeSeriesUtils.getTFSProjectEfficiencybyCreationDate((Map)tfsProjectIssueTypeMap, activeStatusList, releventDates, allIntervals, interval, sessionBoardIds, tenant, sessionBoard.getCreationDate(), endDate);
                    itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                    itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                    itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                    itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                    result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                    result.put("itemTeamsMap", itemTeamsMap);
                    result.put("itemSprintsMap", itemSprintsMap);
                    result.put("itemGroupByMap", itemGroupbyMap);
                    result.put("intervals", tempResult.get("intervals"));
                    result.put("categories", tempResult.get("categories"));
                    result.put("itemActiveCountsMap", tempResult.get("itemActiveCountsMap"));
                    result.put("itemTotalCountsMap", tempResult.get("itemTotalCountsMap"));
                    result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                    break;
                }
                case "areaPath": {
                    Map tempMap = this.timeSeriesUtils.getAreaPathGroupByFurthestItemsMap(farthestEndingStatusMap, dashboard);
                    areaPathMap = (HashMap)tempMap.get("areaPathMap");
                    allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                    groupbyIdColorMap = (Map)tempMap.get("areaPathColorMap");
                    Map tempResult = this.timeSeriesUtils.getAreaPathEfficiencybyCreationDate((Map)areaPathMap, activeStatusList, releventDates, allIntervals, interval, sessionBoardIds, tenant, sessionBoard.getCreationDate(), endDate);
                    itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                    itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                    itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                    itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                    result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                    result.put("itemTeamsMap", itemTeamsMap);
                    result.put("itemSprintsMap", itemSprintsMap);
                    result.put("itemGroupByMap", itemGroupbyMap);
                    result.put("intervals", tempResult.get("intervals"));
                    result.put("categories", tempResult.get("categories"));
                    result.put("itemActiveCountsMap", tempResult.get("itemActiveCountsMap"));
                    result.put("itemTotalCountsMap", tempResult.get("itemTotalCountsMap"));
                    result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                    break;
                }
                case "epic": {
                    Map tempMap = this.timeSeriesUtils.getParentEpicGroupByFurthestItemsMap(farthestEndingStatusMap);
                    parentEpicMap = (HashMap)tempMap.get("parentEpicMap");
                    allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                    Map tempResult = this.timeSeriesUtils.getParentEpicEfficiencybyCreationDate((Map)parentEpicMap, activeStatusList, releventDates, allIntervals, interval, sessionBoardIds, tenant, sessionBoard.getCreationDate(), endDate);
                    itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                    itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                    itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                    itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                    result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                    result.put("itemTeamsMap", itemTeamsMap);
                    result.put("itemSprintsMap", itemSprintsMap);
                    result.put("itemGroupByMap", itemGroupbyMap);
                    result.put("intervals", tempResult.get("intervals"));
                    result.put("categories", tempResult.get("categories"));
                    result.put("itemActiveCountsMap", tempResult.get("itemActiveCountsMap"));
                    result.put("itemTotalCountsMap", tempResult.get("itemTotalCountsMap"));
                    result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                    break;
                }
                default: {
                    Map.Entry firstEntry;
                    TimeSeriesLog earliestItem;
                    String[] parts = groupBy.split("-");
                    String groupByvalue = parts[1];
                    if (farthestEndingStatusMap.size() <= 0 || (earliestItem = (TimeSeriesLog)(firstEntry = farthestEndingStatusMap.entrySet().iterator().next()).getValue()).getItemId() == null) break;
                    customFieldType = "jiraCustomFields";
                    Query queryForItem = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(earliestItem.getItemId())));
                    Item tempItem = (Item)this.mongoTemplate.findOne(queryForItem, Item.class);
                    if (tempItem.getJiraFieldByKey() != null) {
                        Map tempMap = this.timeSeriesUtils.getJiraCustomFieldsGroupByFurthestItemsMap(farthestEndingStatusMap, groupByvalue);
                        customFieldsMap = (HashMap)tempMap.get("customFieldsMap");
                        allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                        Map tempResult = this.timeSeriesUtils.getJiraCustomFieldEfficiencybyCreationDate((Map)customFieldsMap, activeStatusList, releventDates, allIntervals, interval, sessionBoardIds, tenant, sessionBoard.getCreationDate(), endDate);
                        itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                        itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                        itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                        itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                        result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                        result.put("itemTeamsMap", itemTeamsMap);
                        result.put("itemSprintsMap", itemSprintsMap);
                        result.put("itemGroupByMap", itemGroupbyMap);
                        result.put("intervals", tempResult.get("intervals"));
                        result.put("categories", tempResult.get("categories"));
                        result.put("itemActiveCountsMap", tempResult.get("itemActiveCountsMap"));
                        result.put("itemTotalCountsMap", tempResult.get("itemTotalCountsMap"));
                        break;
                    }
                    if (tempItem.getTfsFieldByKey() == null) break;
                    customFieldType = "tfsCustomFields";
                    Map tempMap = this.timeSeriesUtils.getTFSCustomFieldsGroupByFurthestItemsMap(farthestEndingStatusMap, groupByvalue);
                    customFieldsMap = (HashMap)tempMap.get("customFieldsMap");
                    allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                    Map tempResult = this.timeSeriesUtils.getTFSCustomFieldEfficiencybyCreationDate((Map)customFieldsMap, activeStatusList, releventDates, allIntervals, interval, sessionBoardIds, tenant, sessionBoard.getCreationDate(), endDate);
                    itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                    itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                    itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                    itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                    result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                    result.put("itemTeamsMap", itemTeamsMap);
                    result.put("itemSprintsMap", itemSprintsMap);
                    result.put("itemGroupByMap", itemGroupbyMap);
                    result.put("intervals", tempResult.get("intervals"));
                    result.put("categories", tempResult.get("categories"));
                    result.put("itemActiveCountsMap", tempResult.get("itemActiveCountsMap"));
                    result.put("itemTotalCountsMap", tempResult.get("itemTotalCountsMap"));
                }
            }
            result.put("allGroupBys", allGroupBysMap);
        }
        result.put("groupIdColorMap", groupbyIdColorMap);
        result.put("itemsDaysMap", itemsDaysMap);
        return result;
    }

    public Map<String, Object> getItemsForFlowVelocity(SessionBoard sessionBoard, String sessionBoardIds, String tenant, List<String> listOfActiveStatus, List<Status> statusList, String interval, List<String> selectedIssueType, String groupBy, String boardItemsFilter, Date startDate, Date endDate, Dashboard dashboard, Map<String, String> itemTags, String radioTypeSelection) throws ExecutionException, InterruptedException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map itemsDaysMap = new HashMap();
        Map itemTeamsMap = new HashMap();
        Map itemSprintsMap = new HashMap();
        Map itemGroupbyMap = new HashMap();
        HashMap teamStatusMap = new HashMap();
        HashMap issueTypeStatusMap = new HashMap();
        HashMap plannedUnplannedStatusMap = new HashMap();
        HashMap jiraProjectIssueTypeMap = new HashMap();
        HashMap tfsProjectIssueTypeMap = new HashMap();
        HashMap areaPathMap = new HashMap();
        HashMap parentEpicMap = new HashMap();
        HashMap customFieldsMap = new HashMap();
        Map groupbyIdColorMap = new HashMap();
        Map allGroupBysMap = new HashMap();
        String customFieldType = "";
        ArrayList<String> searchedItemIds = new ArrayList<String>();
        Set itemIds = new HashSet();
        if (PropertyValidator.isValid(itemTags)) {
            searchedItemIds.addAll(itemTags.keySet());
        }
        this.timeSeriesUtils = new TimeSeriesUtils(this.mongoTemplate, this.statusRepository);
        Map sprintDates = this.timeSeriesUtils.getSprintDates(sessionBoard);
        ArrayList allSprints = new ArrayList(sprintDates.keySet());
        List completionStatusItemsList = new ArrayList();
        if (PropertyValidator.isValid((Object)sprintDates) && PropertyValidator.isValid(allSprints)) {
            completionStatusItemsList = this.timeSeriesUtils.getFilteredItemsListByStatus(searchedItemIds, listOfActiveStatus, sessionBoard.getCreationDate(), (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1), tenant, "itemTimeSeries", sessionBoard.getId());
            this.timeSeriesUtils.checkItemExistanceInCollection(completionStatusItemsList);
        }
        if (!completionStatusItemsList.isEmpty()) {
            switch (boardItemsFilter) {
                case "unplanned-items": {
                    List filteredItems = this.timeSeriesUtils.retrieveAndCheckTeamContainerForUnPlanned(new ArrayList(completionStatusItemsList), tenant);
                    completionStatusItemsList = filteredItems != null ? filteredItems : new ArrayList();
                    break;
                }
                case "planned-items": {
                    List filteredItems = this.timeSeriesUtils.retrieveAndCheckTeamContainerForPlanned(new ArrayList(completionStatusItemsList), tenant);
                    completionStatusItemsList = filteredItems != null ? filteredItems : new ArrayList();
                }
            }
        }
        Map completionStatusItemsMap = this.timeSeriesUtils.populateFarthestStatusMapForVelocity(completionStatusItemsList, selectedIssueType, sessionBoardIds);
        Map releventDates = new LinkedHashMap();
        Sort sort = new Sort(Sort.Direction.ASC, new String[]{"eventTime"});
        Date firstEntryDate = new Date();
        switch (groupBy) {
            case "teams": {
                Map tempMap = this.timeSeriesUtils.getTeamGroupByFurthestItemsMap(completionStatusItemsMap);
                teamStatusMap = (HashMap)tempMap.get("teamGroupByMatchingItemsMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                groupbyIdColorMap = (Map)tempMap.get("teamIdColorMap");
                break;
            }
            case "cardType": {
                Map tempMap = this.timeSeriesUtils.getCardTypeGroupByFurthestItemsMap(completionStatusItemsMap);
                issueTypeStatusMap = (HashMap)tempMap.get("issueTypeStatusMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                groupbyIdColorMap = (Map)tempMap.get("cardtypeColorMap");
                break;
            }
            case "plannedUnplanned": {
                Map tempMap = this.timeSeriesUtils.getPlannedUnPlannedGroupByFurthestItemsMap(completionStatusItemsMap);
                plannedUnplannedStatusMap = (HashMap)tempMap.get("plannedUnplannedStatusMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                break;
            }
            case "jiraProject": {
                Map tempMap = this.timeSeriesUtils.getJiraProjectGroupByFurthestItemsMap(completionStatusItemsMap, dashboard);
                jiraProjectIssueTypeMap = (HashMap)tempMap.get("jiraProjectIssueTypeMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                groupbyIdColorMap = (Map)tempMap.get("jiraProjectColorMap");
                break;
            }
            case "tfsProject": {
                Map tempMap = this.timeSeriesUtils.getTFSProjectGroupByFurthestItemsMap(completionStatusItemsMap, dashboard);
                tfsProjectIssueTypeMap = (HashMap)tempMap.get("tfsProjectIssueTypeMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                groupbyIdColorMap = (Map)tempMap.get("tfsProjectColorMap");
                break;
            }
            case "areaPath": {
                Map tempMap = this.timeSeriesUtils.getAreaPathGroupByFurthestItemsMap(completionStatusItemsMap, dashboard);
                areaPathMap = (HashMap)tempMap.get("areaPathMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                groupbyIdColorMap = (Map)tempMap.get("areaPathColorMap");
                break;
            }
            case "epic": {
                Map tempMap = this.timeSeriesUtils.getParentEpicGroupByFurthestItemsMap(completionStatusItemsMap);
                parentEpicMap = (HashMap)tempMap.get("parentEpicMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                break;
            }
            default: {
                Map tempMap;
                Map.Entry firstEntry;
                TimeSeriesLog earliestItem;
                String[] parts = groupBy.split("-");
                String groupByvalue = parts[1];
                if (completionStatusItemsList.size() <= 0 || (earliestItem = (TimeSeriesLog)(firstEntry = completionStatusItemsMap.entrySet().iterator().next()).getValue()).getItemId() == null) break;
                customFieldType = "jiraCustomFields";
                Query queryForItem = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(earliestItem.getItemId())));
                Item tempItem = (Item)this.mongoTemplate.findOne(queryForItem, Item.class);
                if (tempItem.getJiraFieldByKey() != null) {
                    tempMap = this.timeSeriesUtils.getJiraCustomFieldsGroupByFurthestItemsMap(completionStatusItemsMap, groupByvalue);
                    customFieldsMap = (HashMap)tempMap.get("customFieldsMap");
                    allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                    break;
                }
                if (tempItem.getTfsFieldByKey() == null) break;
                customFieldType = "tfsCustomFields";
                tempMap = this.timeSeriesUtils.getTFSCustomFieldsGroupByFurthestItemsMap(completionStatusItemsMap, groupByvalue);
                customFieldsMap = (HashMap)tempMap.get("customFieldsMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
            }
        }
        ArrayList allIntervals = new ArrayList();
        releventDates = this.timeSeriesUtils.getDatesOfCFD(interval, sessionBoard, firstEntryDate, startDate, endDate);
        result.put("categories", releventDates.keySet());
        switch (groupBy) {
            case "teams": {
                Map tempResult = this.timeSeriesUtils.getTeamVelocitybyCompletion((Map)teamStatusMap, releventDates, allIntervals, interval, listOfActiveStatus);
                itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                itemIds = (Set)tempResult.get("itemIds");
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("itemTeamsMap", itemTeamsMap);
                result.put("itemSprintsMap", itemSprintsMap);
                result.put("itemGroupByMap", itemGroupbyMap);
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            case "cardType": {
                Map tempResult = this.timeSeriesUtils.getCardTypeVelocitybyCompletion((Map)issueTypeStatusMap, releventDates, allIntervals, interval, listOfActiveStatus);
                itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                itemIds = (Set)tempResult.get("itemIds");
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("itemTeamsMap", itemTeamsMap);
                result.put("itemSprintsMap", itemSprintsMap);
                result.put("itemGroupByMap", itemGroupbyMap);
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            case "plannedUnplanned": {
                Map tempResult = this.timeSeriesUtils.getPlannedUnplannedVelocitybyCompletion((Map)plannedUnplannedStatusMap, releventDates, allIntervals, interval, listOfActiveStatus);
                itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("itemTeamsMap", itemTeamsMap);
                result.put("itemSprintsMap", itemSprintsMap);
                result.put("itemGroupByMap", itemGroupbyMap);
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                break;
            }
            case "jiraProject": {
                Map tempResult = this.timeSeriesUtils.getJiraProjectVelocitybyCompletion((Map)jiraProjectIssueTypeMap, releventDates, allIntervals, interval, listOfActiveStatus);
                itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                itemIds = (Set)tempResult.get("itemIds");
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("itemTeamsMap", itemTeamsMap);
                result.put("itemSprintsMap", itemSprintsMap);
                result.put("itemGroupByMap", itemGroupbyMap);
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            case "tfsProject": {
                Map tempResult = this.timeSeriesUtils.getTFSProjectVelocitybyCompletion((Map)tfsProjectIssueTypeMap, releventDates, allIntervals, interval, listOfActiveStatus);
                itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                itemIds = (Set)tempResult.get("itemIds");
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("itemTeamsMap", itemTeamsMap);
                result.put("itemSprintsMap", itemSprintsMap);
                result.put("itemGroupByMap", itemGroupbyMap);
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            case "areaPath": {
                Map tempResult = this.timeSeriesUtils.getStringTypeVelocitybyCompletion((Map)areaPathMap, releventDates, allIntervals, interval, listOfActiveStatus);
                itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                itemIds = (Set)tempResult.get("itemIds");
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("itemTeamsMap", itemTeamsMap);
                result.put("itemSprintsMap", itemSprintsMap);
                result.put("itemGroupByMap", itemGroupbyMap);
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            case "epic": {
                Map tempResult = this.timeSeriesUtils.getStringTypeVelocitybyCompletion((Map)parentEpicMap, releventDates, allIntervals, interval, listOfActiveStatus);
                itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("itemTeamsMap", itemTeamsMap);
                result.put("itemSprintsMap", itemSprintsMap);
                result.put("itemGroupByMap", itemGroupbyMap);
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            default: {
                Map tempResult;
                if (customFieldType.equals("jiraCustomFields")) {
                    tempResult = this.timeSeriesUtils.getStringTypeVelocitybyCompletion(customFieldsMap, releventDates, allIntervals, interval, listOfActiveStatus);
                    itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                    itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                    itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                    itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                    result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                    result.put("itemTeamsMap", itemTeamsMap);
                    result.put("itemSprintsMap", itemSprintsMap);
                    result.put("itemGroupByMap", itemGroupbyMap);
                    result.put("intervals", tempResult.get("intervals"));
                    result.put("categories", tempResult.get("categories"));
                    break;
                }
                if (!customFieldType.equals("tfsCustomFields")) break;
                tempResult = this.timeSeriesUtils.getStringTypeVelocitybyCompletion(customFieldsMap, releventDates, allIntervals, interval, listOfActiveStatus);
                itemsDaysMap = (Map)tempResult.get("itemsDaysMap");
                itemTeamsMap = (Map)tempResult.get("itemTeamsMap");
                itemSprintsMap = (Map)tempResult.get("itemSprintsMap");
                itemGroupbyMap = (Map)tempResult.get("itemGroupByMap");
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("itemTeamsMap", itemTeamsMap);
                result.put("itemSprintsMap", itemSprintsMap);
                result.put("itemGroupByMap", itemGroupbyMap);
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
            }
        }
        if (PropertyValidator.isValid(itemTeamsMap) && PropertyValidator.isValid(allGroupBysMap)) {
            Iterator iterator = allGroupBysMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String teamName = (String)entry.getValue();
                boolean teamExists = itemTeamsMap.keySet().stream().anyMatch(key -> key.contains(":" + teamName));
                if (teamExists) continue;
                iterator.remove();
            }
        }
        if ("statusCategory".equals(radioTypeSelection) && PropertyValidator.isValid(itemIds)) {
            ArrayList<ObjectId> itemIdsObjectList = new ArrayList<ObjectId>();
            for (String itemId : itemIds) {
                itemIdsObjectList.add(new ObjectId(itemId));
            }
            HashMap<String, List> itemStatusMap = new HashMap<String, List>();
            Query queryForItem = new Query((CriteriaDefinition)Criteria.where((String)"id").in(itemIdsObjectList));
            queryForItem.fields().include("status");
            List itemsList = this.mongoTemplate.find(queryForItem, Item.class);
            for (Item item : itemsList) {
                List tempStatus = itemStatusMap.getOrDefault(item.getId(), new ArrayList());
                if (!PropertyValidator.isValid((Object)item.getStatus())) continue;
                tempStatus.add(item.getStatus().getTitle() + "status_category:" + item.getStatus().getCategory());
                itemStatusMap.put(item.getId(), tempStatus);
            }
            result.put("itemStatusMap", itemStatusMap);
        }
        result.put("itemsDaysMap", itemsDaysMap);
        result.put("allGroupBys", allGroupBysMap);
        result.put("groupIdColorMap", groupbyIdColorMap);
        return result;
    }

    public Map<String, Object> getItemsForFlowLoad(SessionBoard sessionBoard, String sessionBoardIds, String tenant, List<String> activeStatusids, List<String> waitingStatusIds, List<Status> statusList, String interval, List<String> selectedIssueType, String groupBy, Date dateStart, Date dateEnd, String boardItemsFilter, Dashboard dashboard, Map<String, String> itemTags) throws ExecutionException, InterruptedException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap itemsDaysMap = new HashMap();
        Map groupbyIdColorMap = new HashMap();
        this.timeSeriesUtils = new TimeSeriesUtils(this.mongoTemplate, this.statusRepository);
        ArrayList<String> searchedItemIds = new ArrayList<String>();
        if (PropertyValidator.isValid(itemTags)) {
            searchedItemIds.addAll(itemTags.keySet());
        }
        List startingStatusMatch = new ArrayList();
        List endingStatusMatch = new ArrayList();
        Map sprintDates = this.timeSeriesUtils.getSprintDates(sessionBoard);
        ArrayList allSprints = new ArrayList(sprintDates.keySet());
        if (PropertyValidator.isValid((Object)sprintDates) && PropertyValidator.isValid(allSprints)) {
            startingStatusMatch = this.timeSeriesUtils.getFilteredItemsListByStatus(searchedItemIds, activeStatusids, sessionBoard.getCreationDate(), (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1), tenant, "itemTimeSeries", sessionBoard.getId());
            endingStatusMatch = this.timeSeriesUtils.getFilteredItemsListByStatus(searchedItemIds, waitingStatusIds, sessionBoard.getCreationDate(), (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1), tenant, "itemTimeSeries", sessionBoard.getId());
        }
        if (!startingStatusMatch.isEmpty() && !endingStatusMatch.isEmpty()) {
            if (boardItemsFilter.equals("unplanned-items")) {
                startingStatusMatch = this.timeSeriesUtils.retrieveAndCheckTeamContainerForUnPlanned(startingStatusMatch, tenant);
                endingStatusMatch = this.timeSeriesUtils.retrieveAndCheckTeamContainerForUnPlanned(endingStatusMatch, tenant);
            } else if (boardItemsFilter.equals("planned-items")) {
                startingStatusMatch = this.timeSeriesUtils.retrieveAndCheckTeamContainerForPlanned(startingStatusMatch, tenant);
                endingStatusMatch = this.timeSeriesUtils.retrieveAndCheckTeamContainerForPlanned(endingStatusMatch, tenant);
            }
        }
        ArrayList<String> combinedStatusIds = new ArrayList<String>(activeStatusids);
        combinedStatusIds.addAll(waitingStatusIds);
        HashMap matchingItemsMap = new HashMap();
        this.timeSeriesUtils = new TimeSeriesUtils(this.mongoTemplate, this.statusRepository);
        Map activeStatusMap = new HashMap();
        Map waitingStatusMap = new HashMap();
        activeStatusMap = this.timeSeriesUtils.populateEarliestStatusMap(startingStatusMatch, selectedIssueType, sessionBoardIds);
        waitingStatusMap = this.timeSeriesUtils.populateFarthestStatusMap(endingStatusMatch, selectedIssueType, sessionBoardIds);
        HashMap<String, List> combinedMap = new HashMap<String, List>();
        for (Map.Entry entry : activeStatusMap.entrySet()) {
            combinedMap.computeIfAbsent((String)entry.getKey(), k -> new ArrayList()).add(entry.getValue());
        }
        for (Map.Entry entry : waitingStatusMap.entrySet()) {
            combinedMap.computeIfAbsent((String)entry.getKey(), k -> new ArrayList()).add(entry.getValue());
        }
        Map<String, List<Date>> releventDates = new LinkedHashMap();
        ArrayList combinedList = new ArrayList();
        for (Map.Entry entry : activeStatusMap.entrySet()) {
            combinedList.add(new AbstractMap.SimpleEntry(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry entry : waitingStatusMap.entrySet()) {
            combinedList.add(new AbstractMap.SimpleEntry(entry.getKey(), entry.getValue()));
        }
        HashMap teamStatusMap = new HashMap();
        HashMap issueTypeStatusMap = new HashMap();
        HashMap plannedUnplannedStatusMap = new HashMap();
        HashMap jiraProjectIssueTypeMap = new HashMap();
        HashMap tfsProjectIssueTypeMap = new HashMap();
        HashMap areaPathMap = new HashMap();
        HashMap parentEpicMap = new HashMap();
        HashMap customFieldsMap = new HashMap();
        Map allGroupBysMap = new HashMap();
        String customFieldType = "";
        switch (groupBy) {
            case "teams": {
                Map tempMap = this.timeSeriesUtils.getTeamGroupByForFlowLoad(combinedMap);
                teamStatusMap = (HashMap)tempMap.get("teamGroupByMatchingItemsMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                groupbyIdColorMap = (Map)tempMap.get("teamIdColorMap");
                break;
            }
            case "cardType": {
                Map tempMap = this.timeSeriesUtils.getCardTypeGroupForFlowLoad(combinedMap);
                issueTypeStatusMap = (HashMap)tempMap.get("issueTypeStatusMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                groupbyIdColorMap = (Map)tempMap.get("cardtypeColorMap");
                break;
            }
            case "jiraProject": {
                Map tempMap = this.timeSeriesUtils.getJiraProjectGroupByForFlowload(combinedMap, dashboard);
                jiraProjectIssueTypeMap = (HashMap)tempMap.get("jiraProjectIssueTypeMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                groupbyIdColorMap = (Map)tempMap.get("jiraProjectColorMap");
                break;
            }
            case "tfsProject": {
                Map tempMap = this.timeSeriesUtils.getTFSProjectGroupByForFlowload(combinedMap, dashboard);
                tfsProjectIssueTypeMap = (HashMap)tempMap.get("tfsProjectIssueTypeMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                groupbyIdColorMap = (Map)tempMap.get("tfsProjectColorMap");
                break;
            }
            case "areaPath": {
                Map tempMap = this.timeSeriesUtils.getAreaPathGroupByForFlowload(combinedMap, dashboard);
                areaPathMap = (HashMap)tempMap.get("areaPathMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                groupbyIdColorMap = (Map)tempMap.get("areaPathColorMap");
                break;
            }
            case "epic": {
                Map tempMap = this.timeSeriesUtils.getParentEpicGroupByForFlowload(combinedMap);
                parentEpicMap = (HashMap)tempMap.get("parentEpicMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                break;
            }
        }
        List allIntervals = new ArrayList();
        block22 : switch (interval) {
            case "sprints": {
                releventDates = this.timeSeriesUtils.getSprintDates(sessionBoard);
                break;
            }
            case "weekly": {
                if (allSprints.isEmpty()) break;
                Date startDate = (Date)((List)sprintDates.get(allSprints.get(0))).get(0);
                Date endDate = (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1);
                long startTime = startDate.getTime();
                long endTime = endDate.getTime();
                for (long weekStart = startTime; weekStart <= endTime; weekStart += 604800000L) {
                    Date weekStartDate = new Date(weekStart);
                    Date weekEndDate = new Date(Math.min(weekStart + 518400000L, endTime));
                    if (weekStartDate.after(new Date())) break block22;
                    releventDates.put("Week " + (releventDates.size() + 1), Arrays.asList(weekStartDate, weekEndDate));
                }
                break;
            }
            case "monthly": {
                Calendar calendar = Calendar.getInstance();
                if (allSprints.isEmpty()) break;
                calendar.setTime((Date)((List)sprintDates.get(allSprints.get(0))).get(0));
                releventDates = this.timeSeriesUtils.getAllMonthswrtFirstAndLastEntry(calendar, (Date)((List)sprintDates.get(allSprints.get(0))).get(0), (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1));
                break;
            }
            case "days": {
                allIntervals = this.timeSeriesUtils.getAllDates(dateStart, dateEnd);
            }
        }
        switch (groupBy) {
            case "teams": {
                Map tempResult = this.timeSeriesUtils.getTeamLoadByCompletion((Map)teamStatusMap, releventDates, allIntervals, interval, activeStatusids, waitingStatusIds, allGroupBysMap);
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("activeIntervals", tempResult.get("activeIntervals"));
                result.put("waitingIntervals", tempResult.get("waitingIntervals"));
                result.put("itemStatusMap", tempResult.get("itemStatusMap"));
                result.put("itemTeamsMap", tempResult.get("itemTeamsMap"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            case "cardType": {
                Map tempResult = this.timeSeriesUtils.getCardTypeLoadByCompletion((Map)issueTypeStatusMap, releventDates, allIntervals, interval, activeStatusids, waitingStatusIds, allGroupBysMap);
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("activeIntervals", tempResult.get("activeIntervals"));
                result.put("waitingIntervals", tempResult.get("waitingIntervals"));
                result.put("itemStatusMap", tempResult.get("itemStatusMap"));
                result.put("itemTeamsMap", tempResult.get("itemTeamsMap"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            case "plannedUnplanned": {
                Map tempResult = this.timeSeriesUtils.getStringLoadByCompletion(plannedUnplannedStatusMap, releventDates, allIntervals, interval, activeStatusids, waitingStatusIds, allGroupBysMap);
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("activeIntervals", tempResult.get("activeIntervals"));
                result.put("waitingIntervals", tempResult.get("waitingIntervals"));
                result.put("itemStatusMap", tempResult.get("itemStatusMap"));
                result.put("itemTeamsMap", tempResult.get("itemTeamsMap"));
                break;
            }
            case "jiraProject": {
                Map tempResult = this.timeSeriesUtils.getJiraProjectLoadByCompletion((Map)jiraProjectIssueTypeMap, releventDates, allIntervals, interval, activeStatusids, waitingStatusIds, allGroupBysMap);
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("activeIntervals", tempResult.get("activeIntervals"));
                result.put("waitingIntervals", tempResult.get("waitingIntervals"));
                result.put("itemStatusMap", tempResult.get("itemStatusMap"));
                result.put("itemTeamsMap", tempResult.get("itemTeamsMap"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            case "tfsProject": {
                Map tempResult = this.timeSeriesUtils.getTFSProjectLoadByCompletion((Map)tfsProjectIssueTypeMap, releventDates, allIntervals, interval, activeStatusids, waitingStatusIds, allGroupBysMap);
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("activeIntervals", tempResult.get("activeIntervals"));
                result.put("waitingIntervals", tempResult.get("waitingIntervals"));
                result.put("itemStatusMap", tempResult.get("itemStatusMap"));
                result.put("itemTeamsMap", tempResult.get("itemTeamsMap"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            case "areaPath": {
                Map tempResult = this.timeSeriesUtils.getStringLoadByCompletion((Map)areaPathMap, releventDates, allIntervals, interval, activeStatusids, waitingStatusIds, allGroupBysMap);
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("activeIntervals", tempResult.get("activeIntervals"));
                result.put("waitingIntervals", tempResult.get("waitingIntervals"));
                result.put("itemStatusMap", tempResult.get("itemStatusMap"));
                result.put("itemTeamsMap", tempResult.get("itemTeamsMap"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            case "epic": {
                Map tempResult = this.timeSeriesUtils.getStringLoadByCompletion((Map)parentEpicMap, releventDates, allIntervals, interval, activeStatusids, waitingStatusIds, allGroupBysMap);
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("activeIntervals", tempResult.get("activeIntervals"));
                result.put("waitingIntervals", tempResult.get("waitingIntervals"));
                result.put("itemStatusMap", tempResult.get("itemStatusMap"));
                result.put("itemTeamsMap", tempResult.get("itemTeamsMap"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            default: {
                if (!customFieldType.equals("jiraCustomFields") && !customFieldType.equals("tfsCustomFields")) break;
                Map tempResult = this.timeSeriesUtils.getStringLoadByCompletion(customFieldsMap, releventDates, allIntervals, interval, activeStatusids, waitingStatusIds, allGroupBysMap);
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("activeIntervals", tempResult.get("activeIntervals"));
                result.put("waitingIntervals", tempResult.get("waitingIntervals"));
                result.put("itemStatusMap", tempResult.get("itemStatusMap"));
                result.put("itemTeamsMap", tempResult.get("itemTeamsMap"));
            }
        }
        result.put("allGroupBys", allGroupBysMap);
        result.put("groupIdColorMap", groupbyIdColorMap);
        return result;
    }

    public Map<String, Object> getFlowLoad(SessionBoard sessionBoard, String sessionBoardIds, String tenant, List<String> activeStatusids, List<String> waitingStatusIds, List<Status> statusList, String interval, List<String> selectedIssueType, String groupBy, Date dateStart, Date dateEnd, String boardItemsFilter, Dashboard dashboard, Map<String, String> itemTags, String radioTypeSelection) throws Exception {
        HashMap<String, Object> result;
        block99: {
            long startTime = System.currentTimeMillis();
            LOGGER.info("Going to execute getFlowLoad() at: " + (float)(startTime - startTime) / 1000.0f);
            result = new HashMap<String, Object>();
            HashMap<String, Map> sprintsCount = new HashMap<String, Map>();
            List<TimeSeriesLog> matchedItems = new ArrayList();
            HashMap finalMap = new HashMap();
            ArrayList<String> searchedItemIds = new ArrayList<String>();
            Map allGroupBysMap = new HashMap();
            Map groupbyIdColorMap = new HashMap();
            HashMap finalActiveMap = new HashMap();
            if (PropertyValidator.isValid(itemTags)) {
                searchedItemIds.addAll(itemTags.keySet());
            }
            this.timeSeriesUtils = new TimeSeriesUtils(this.mongoTemplate, this.statusRepository);
            Map sprintDates = this.timeSeriesUtils.getSprintDatesWithFuture(sessionBoard);
            ArrayList allSprints = new ArrayList(sprintDates.keySet());
            List allIntervals = new ArrayList();
            Map<String, List<Date>> releventDates = new LinkedHashMap();
            block7 : switch (interval) {
                case "sprints": {
                    releventDates = this.timeSeriesUtils.getSprintDatesIdMap(sessionBoard);
                    break;
                }
                case "weekly": {
                    if (allSprints.isEmpty()) break;
                    Date startDate = (Date)((List)sprintDates.get(allSprints.get(0))).get(0);
                    Date endDate = (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1);
                    long startTimee = startDate.getTime();
                    long endTime = endDate.getTime();
                    for (long i = startTimee; i <= endTime; i += 604800000L) {
                        Date date = new Date(i);
                        Date weekEndDate = new Date(Math.min(i + 518400000L, endTime));
                        if (date.after(new Date())) break block7;
                        releventDates.put("Week " + (releventDates.size() + 1), Arrays.asList(date, weekEndDate));
                    }
                    break;
                }
                case "monthly": {
                    Calendar calendar = Calendar.getInstance();
                    if (allSprints.isEmpty()) break;
                    calendar.setTime((Date)((List)sprintDates.get(allSprints.get(0))).get(0));
                    releventDates = this.timeSeriesUtils.getAllMonthswrtFirstAndLastEntry(calendar, (Date)((List)sprintDates.get(allSprints.get(0))).get(0), (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1));
                    break;
                }
                case "days": {
                    allIntervals = this.timeSeriesUtils.getAllDates(dateStart, dateEnd);
                }
            }
            LOGGER.info("Going to fetch all statuses at: " + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
            ArrayList<TimeSeriesLog> resultList = new ArrayList<TimeSeriesLog>();
            Set allStatusTitles = new HashSet();
            try {
                HashMap teamStatusMap;
                Object status;
                String statusSequence;
                Session session;
                List<Object> statusOrder = new ArrayList();
                if (sessionBoard != null && (session = sessionBoard.getSession()) != null && session.getItemWorkFlow() != null && (statusSequence = session.getItemWorkFlow().getStatusSequence()) != null) {
                    statusOrder = Arrays.asList(statusSequence.split(","));
                }
                if (!PropertyValidator.isValid(statusOrder = this.timeSeriesUtils.getStatusCategoryOrder(statusOrder))) {
                    statusOrder = new ArrayList();
                    statusOrder.add(EnumStatusCategory.OPEN.getCode());
                    statusOrder.add(EnumStatusCategory.INPROGRESS.getCode());
                    statusOrder.add(EnumStatusCategory.DONE.getCode());
                    statusOrder.add(EnumStatusCategory.MISC.getCode());
                }
                allStatusTitles = this.timeSeriesUtils.sortStatusesByWorkflow(activeStatusids, statusOrder, radioTypeSelection);
                LOGGER.info("All status titles fetched at: " + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
                HashSet activeStatusCategories = new HashSet();
                activeStatusCategories.addAll(allStatusTitles);
                Set waitingStatusCategories = this.timeSeriesUtils.sortStatusesByWorkflow(waitingStatusIds, statusOrder, radioTypeSelection);
                allStatusTitles.addAll(waitingStatusCategories);
                HashSet<Object> filteredStatusIds = new HashSet<Object>();
                if (radioTypeSelection.equalsIgnoreCase("status")) {
                    BasicDBObject query = new BasicDBObject();
                    query.put((Object)"$and", Arrays.asList(new BasicDBObject("title", (Object)new BasicDBObject("$in", allStatusTitles)), new BasicDBObject("tenant", (Object)tenant), new BasicDBObject("sessionId", (Object)sessionBoard.getSession().getId())));
                    DBCollection statusCollection = this.mongoTemplate.getCollection("status");
                    DBCursor dBCursor = statusCollection.find((DBObject)query);
                    while (dBCursor.hasNext()) {
                        String string;
                        DBObject dBObject = (DBObject)dBCursor.next();
                        if (!PropertyValidator.isValid((Object)dBObject.get("_id"))) continue;
                        if (dBObject.get("_id") instanceof ObjectId) {
                            ObjectId objectId = (ObjectId)dBObject.get("_id");
                            if (!PropertyValidator.isValid((Object)objectId)) continue;
                            filteredStatusIds.add(objectId.toString());
                            continue;
                        }
                        if (!(dBObject.get("_id") instanceof String) || !PropertyValidator.isValid((Object)(string = (String)dBObject.get("_id")))) continue;
                        filteredStatusIds.add(string);
                    }
                    LOGGER.info("Active status titles fetched at: " + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (PropertyValidator.isValid((Object)sessionBoard.getSession().getItemWorkFlow()) && PropertyValidator.isValid((Object)sessionBoard.getSession().getItemWorkFlow().getId())) {
                        arrayList.add(sessionBoard.getSession().getItemWorkFlow().getId());
                    }
                    if (PropertyValidator.isValid((Object)sessionBoard.getSession().getSubItemWorkFlow()) && PropertyValidator.isValid((Object)sessionBoard.getSession().getSubItemWorkFlow().getId())) {
                        arrayList.add(sessionBoard.getSession().getSubItemWorkFlow().getId());
                    }
                    List list = arrayList.stream().map(ObjectId::new).collect(Collectors.toList());
                    query = new BasicDBObject();
                    query.put((Object)"$and", Arrays.asList(new BasicDBObject("title", (Object)new BasicDBObject("$in", allStatusTitles)), new BasicDBObject("tenant", (Object)tenant), new BasicDBObject("workFlow.$id", (Object)new BasicDBObject("$in", list))));
                    statusCollection = this.mongoTemplate.getCollection("status");
                    DBCursor dBCursor2 = statusCollection.find((DBObject)query);
                    while (dBCursor2.hasNext()) {
                        Iterator<Object> statusId;
                        status = (DBObject)dBCursor2.next();
                        if (!PropertyValidator.isValid((Object)status.get("_id"))) continue;
                        if (status.get("_id") instanceof ObjectId) {
                            ObjectId statusObjId = (ObjectId)status.get("_id");
                            if (!PropertyValidator.isValid((Object)statusObjId)) continue;
                            filteredStatusIds.add(statusObjId.toString());
                            continue;
                        }
                        if (!(status.get("_id") instanceof String) || !PropertyValidator.isValid((Object)(statusId = (String)status.get("_id")))) continue;
                        filteredStatusIds.add(statusId);
                    }
                }
                LOGGER.info("All status ids fetched at: " + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
                HashSet<String> plannedItems = new HashSet<String>();
                if (PropertyValidator.isValid(allSprints)) {
                    BasicDBObject filter = new BasicDBObject();
                    filter.put((Object)"eventTime", (Object)new BasicDBObject("$gte", (Object)sessionBoard.getCreationDate()).append("$lte", ((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1)));
                    filter.put((Object)"meta.tenant", (Object)tenant);
                    filter.put((Object)"meta.sessionBoardId", (Object)sessionBoard.getId());
                    DBCollection dBCollection = this.mongoTemplate.getCollection("itemTimeSeries");
                    DBCursor dBCursor = dBCollection.find((DBObject)filter);
                    while (dBCursor.hasNext()) {
                        TimeSeriesLog timeSeriesLog = new TimeSeriesLog();
                        DBObject dbObject = dBCursor.next();
                        timeSeriesLog.setId(dbObject.get("_id").toString());
                        timeSeriesLog.setEventTime((Date)dbObject.get("eventTime"));
                        timeSeriesLog.setJiraKey((String)dbObject.get("jiraKey"));
                        timeSeriesLog.setChanges((Map)dbObject.get("changes"));
                        timeSeriesLog.setMeta((Map)dbObject.get("meta"));
                        timeSeriesLog.setTfsId((String)dbObject.get("tfsId"));
                        timeSeriesLog.setItemId((String)dbObject.get("itemId"));
                        timeSeriesLog.setTeamContainers((List)dbObject.get("teamContainers"));
                        resultList.add(timeSeriesLog);
                    }
                    this.timeSeriesUtils.checkItemExistanceInCollection(resultList);
                } else {
                    Map tempMap = this.timeSeriesUtils.getTeamGroupByLatestItemsMap(finalActiveMap);
                    teamStatusMap = (HashMap)tempMap.get("teamGroupByMatchingItemsMap");
                    allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                    groupbyIdColorMap = (Map)tempMap.get("teamIdColorMap");
                    HashMap hashMap = new HashMap();
                    HashMap hashMap2 = new HashMap();
                    Map map = this.timeSeriesUtils.getTeamDist((Map)teamStatusMap, sprintsCount, allIntervals, releventDates, hashMap, selectedIssueType, hashMap2, plannedItems);
                    LinkedHashMap tempReleventDates = new LinkedHashMap();
                    for (Map.Entry entry : releventDates.entrySet()) {
                        tempReleventDates.put(((Container)hashMap.get(entry.getKey())).getTitle(), entry.getValue());
                    }
                    result.put("relevantDates", TimeSeriesUtils.handleTimeZone(tempReleventDates));
                    result.put("intervals", map.get("intervals"));
                    result.put("categories", map.get("categories"));
                    result.put("issueTypeMap", map.get("issueTypeMap"));
                    result.put("itemStatusMap", map.get("itemStatusMap"));
                    result.put("issueSprintMap", map.get("issueSprintMap"));
                    result.put("itemIdsMap", map.get("itemIdsMap"));
                    result.put("groupIdColorMap", groupbyIdColorMap);
                }
                LOGGER.info("All timeseries entries fetched at: " + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
                if (PropertyValidator.isValid(searchedItemIds)) {
                    for (TimeSeriesLog timeSeriesLog : resultList) {
                        if (!searchedItemIds.contains(timeSeriesLog.getItemId())) continue;
                        matchedItems.add(timeSeriesLog);
                    }
                } else {
                    matchedItems = resultList;
                }
                if (!matchedItems.isEmpty()) {
                    if (boardItemsFilter.equals("unplanned-items")) {
                        matchedItems = this.timeSeriesUtils.retrieveAndCheckTeamContainerForUnPlanned(matchedItems, tenant);
                    } else if (boardItemsFilter.equals("planned-items")) {
                        matchedItems = this.timeSeriesUtils.retrieveAndCheckTeamContainerForPlanned(matchedItems, tenant);
                    }
                }
                LOGGER.info("All team containers fetched at:" + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
                HashSet<String> containerIds = new HashSet<String>();
                for (Map.Entry entry : releventDates.entrySet()) {
                    List list = (List)entry.getValue();
                    Date endingDate = (Date)list.get(1);
                    for (TimeSeriesLog timeSeriesLog : matchedItems) {
                        List teamContainerMirror = timeSeriesLog.getTeamContainers();
                        if (!PropertyValidator.isValid((Collection)teamContainerMirror)) continue;
                        for (int i = 0; i < teamContainerMirror.size(); ++i) {
                            BasicDBObject containerDbObj;
                            BasicDBObject basicDBObject;
                            DBObject dbObject = (DBObject)teamContainerMirror.get(i);
                            if (!(dbObject instanceof BasicDBObject) || !PropertyValidator.isValid((Object)(basicDBObject = (BasicDBObject)dbObject)) || !PropertyValidator.isValid((Object)(containerDbObj = (BasicDBObject)basicDBObject.get("container")))) continue;
                            containerIds.add(containerDbObj.getString("_id"));
                        }
                    }
                }
                LOGGER.info("All containers fetched at:" + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
                HashMap<String, List> hashMap = new HashMap<String, List>();
                for (TimeSeriesLog timeSeriesLog : matchedItems) {
                    List timeSeriesLogsList = hashMap.getOrDefault(timeSeriesLog.getItemId(), new ArrayList());
                    timeSeriesLogsList.add(timeSeriesLog);
                    hashMap.put(timeSeriesLog.getItemId(), timeSeriesLogsList);
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    status = new HashMap();
                    for (TimeSeriesLog timeSeriesLog : (List)entry.getValue()) {
                        if (!timeSeriesLog.getChanges().containsKey("status")) {
                            timeSeriesLog.getChanges().put("status", status);
                            continue;
                        }
                        status = (Map)timeSeriesLog.getChanges().get("status");
                    }
                }
                LOGGER.info("Status populated in all items at: " + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
                for (Map.Entry entry : hashMap.entrySet()) {
                    List currentList = (List)entry.getValue();
                    Collections.sort(currentList, new /* Unavailable Anonymous Inner Class!! */);
                    hashMap.put((String)entry.getKey(), currentList);
                }
                if (!PropertyValidator.isValid(releventDates.keySet())) break block99;
                Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(releventDates.keySet()));
                query.with(new Sort(Sort.Direction.ASC, new String[]{"startDate"}));
                List list = this.mongoTemplate.find(query, Container.class);
                LinkedHashMap<String, Container> containerMap = new LinkedHashMap<String, Container>();
                for (Container container : list) {
                    Date startDate = container.getStartDate();
                    Date endDate = container.getEndDate();
                    if (!PropertyValidator.isValid((Object)startDate) || !PropertyValidator.isValid((Object)endDate)) continue;
                    for (Map.Entry entry : hashMap.entrySet()) {
                        List allInnerEntries = (List)entry.getValue();
                        allInnerEntries.sort(Comparator.comparing(TimeSeriesLog::getEventTime));
                        for (TimeSeriesLog timeSeriesLog : allInnerEntries) {
                            String sprintId;
                            Object sprintIdObj;
                            BasicDBObject obj;
                            BasicDBObject containerObj;
                            List teamContainerMirrors;
                            List allEntries = (List)hashMap.get(timeSeriesLog.getItemId());
                            TimeSeriesLog latestEntry = (TimeSeriesLog)allEntries.get(allEntries.size() - 1);
                            Map changes = latestEntry.getChanges();
                            boolean archive = false;
                            if (changes.containsKey("archive")) {
                                archive = (Boolean)changes.get("archive");
                            }
                            if (archive) continue;
                            if (timeSeriesLog.getEventTime().after(startDate) && timeSeriesLog.getEventTime().before(endDate) && PropertyValidator.isValid((Collection)timeSeriesLog.getTeamContainers())) {
                                teamContainerMirrors = timeSeriesLog.getTeamContainers();
                                for (Object teamContainer : teamContainerMirrors) {
                                    if (!(teamContainer instanceof BasicDBObject) || !PropertyValidator.isValid((Object)(containerObj = (BasicDBObject)(obj = (BasicDBObject)teamContainer).get("container"))) || !PropertyValidator.isValid((Object)(sprintIdObj = containerObj.get("_id")))) continue;
                                    sprintId = "";
                                    if (sprintIdObj instanceof String) {
                                        sprintId = (String)sprintIdObj;
                                    } else if (sprintIdObj instanceof ObjectId) {
                                        sprintId = ((ObjectId)sprintIdObj).toString();
                                    }
                                    Map currentMap = sprintsCount.getOrDefault(sprintId, new HashMap());
                                    List currentEntries = currentMap.getOrDefault("items", new ArrayList());
                                    boolean itemAdded = false;
                                    for (int i = 0; i < currentEntries.size(); ++i) {
                                        TimeSeriesLog currentEntry = (TimeSeriesLog)currentEntries.get(i);
                                        if (!currentEntry.getItemId().equalsIgnoreCase(timeSeriesLog.getItemId())) continue;
                                        if (timeSeriesLog.getEventTime().after(currentEntry.getEventTime())) {
                                            currentEntries.set(i, timeSeriesLog);
                                            itemAdded = true;
                                        }
                                        itemAdded = true;
                                        break;
                                    }
                                    if (!itemAdded && PropertyValidator.isValid((Object)startDate) && PropertyValidator.isValid((Object)endDate)) {
                                        currentEntries.add(timeSeriesLog);
                                    }
                                    currentMap.put("items", currentEntries);
                                    sprintsCount.put(sprintId, currentMap);
                                }
                                continue;
                            }
                            teamContainerMirrors = timeSeriesLog.getTeamContainers();
                            if (!PropertyValidator.isValid((Collection)teamContainerMirrors)) continue;
                            for (Object teamContainer : teamContainerMirrors) {
                                TimeSeriesLog currentEntry;
                                int i;
                                boolean itemAdded;
                                List currentEntries;
                                Map currentMap;
                                if (!(teamContainer instanceof BasicDBObject) || !PropertyValidator.isValid((Object)(containerObj = (BasicDBObject)(obj = (BasicDBObject)teamContainer).get("container"))) || !PropertyValidator.isValid((Object)(sprintIdObj = containerObj.get("_id")))) continue;
                                sprintId = "";
                                if (sprintIdObj instanceof String) {
                                    sprintId = (String)sprintIdObj;
                                } else if (sprintIdObj instanceof ObjectId) {
                                    sprintId = ((ObjectId)sprintIdObj).toString();
                                }
                                Date today = new Date();
                                List attchedSprintDates = (List)releventDates.get(sprintId);
                                if (!PropertyValidator.isValid((Collection)attchedSprintDates)) continue;
                                Date attachedEndDate = (Date)attchedSprintDates.get(1);
                                if (PropertyValidator.isValid((Object)attachedEndDate) && attachedEndDate.after(today)) {
                                    currentMap = sprintsCount.getOrDefault(sprintId, new HashMap());
                                    currentEntries = currentMap.getOrDefault("items", new ArrayList());
                                    itemAdded = false;
                                    for (i = 0; i < currentEntries.size(); ++i) {
                                        currentEntry = (TimeSeriesLog)currentEntries.get(i);
                                        if (!currentEntry.getItemId().equalsIgnoreCase(timeSeriesLog.getItemId())) continue;
                                        if (timeSeriesLog.getEventTime().after(currentEntry.getEventTime())) {
                                            currentEntries.set(i, timeSeriesLog);
                                            itemAdded = true;
                                        }
                                        itemAdded = true;
                                        break;
                                    }
                                    if (!itemAdded && PropertyValidator.isValid((Object)startDate) && PropertyValidator.isValid((Object)endDate)) {
                                        currentEntries.add(timeSeriesLog);
                                    }
                                    currentMap.put("items", currentEntries);
                                    sprintsCount.put(sprintId, currentMap);
                                    continue;
                                }
                                if (timeSeriesLog.getEventTime().before(today)) {
                                    currentMap = sprintsCount.getOrDefault(sprintId, new HashMap());
                                    currentEntries = currentMap.getOrDefault("items", new ArrayList());
                                    itemAdded = false;
                                    for (i = 0; i < currentEntries.size(); ++i) {
                                        currentEntry = (TimeSeriesLog)currentEntries.get(i);
                                        if (!currentEntry.getItemId().equalsIgnoreCase(timeSeriesLog.getItemId())) continue;
                                        if (timeSeriesLog.getEventTime().after(currentEntry.getEventTime())) {
                                            currentEntries.set(i, timeSeriesLog);
                                            itemAdded = true;
                                        }
                                        itemAdded = true;
                                        break;
                                    }
                                    if (!itemAdded && PropertyValidator.isValid((Object)startDate) && PropertyValidator.isValid((Object)endDate)) {
                                        currentEntries.add(timeSeriesLog);
                                    }
                                    currentMap.put("items", currentEntries);
                                    sprintsCount.put(sprintId, currentMap);
                                    continue;
                                }
                                currentMap = sprintsCount.getOrDefault(sprintId, new HashMap());
                                currentEntries = currentMap.getOrDefault("items", new ArrayList());
                                itemAdded = false;
                                for (i = 0; i < currentEntries.size(); ++i) {
                                    currentEntry = (TimeSeriesLog)currentEntries.get(i);
                                    if (!currentEntry.getItemId().equalsIgnoreCase(timeSeriesLog.getItemId())) continue;
                                    if (timeSeriesLog.getEventTime().after(currentEntry.getEventTime())) {
                                        currentEntries.set(i, timeSeriesLog);
                                        itemAdded = true;
                                    }
                                    itemAdded = true;
                                    break;
                                }
                                if (!itemAdded && PropertyValidator.isValid((Object)startDate) && PropertyValidator.isValid((Object)endDate)) {
                                    currentEntries.add(timeSeriesLog);
                                }
                                currentMap.put("items", currentEntries);
                                sprintsCount.put(sprintId, currentMap);
                            }
                        }
                    }
                    containerMap.put(container.getId(), container);
                }
                LOGGER.info("All entries grouped according to sprints at: " + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
                for (Map.Entry entry : sprintsCount.entrySet()) {
                    Map currentSprintEntries = (Map)entry.getValue();
                    for (Map.Entry innerEntry : currentSprintEntries.entrySet()) {
                        List list2 = (List)innerEntry.getValue();
                        Iterator<Object> iterator = list2.iterator();
                        while (iterator.hasNext()) {
                            String category;
                            TimeSeriesLog timeSeriesLog = (TimeSeriesLog)iterator.next();
                            Map map = (Map)timeSeriesLog.getChanges().get("status");
                            if (filteredStatusIds.contains(map.get("_id")) && filteredStatusIds.contains(map.get("_id"))) {
                                iterator.remove();
                                continue;
                            }
                            if (!radioTypeSelection.equalsIgnoreCase("statusCategory") || !PropertyValidator.isValid((Object)(category = (String)map.get("category"))) || allStatusTitles.contains(category)) continue;
                            iterator.remove();
                        }
                    }
                }
                LOGGER.info("Items filtered according to status at: " + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
                HashMap<String, TimeSeriesLog> activeStatusMap = new HashMap<String, TimeSeriesLog>();
                if (PropertyValidator.isValid(sprintsCount)) {
                    for (Map.Entry entry : sprintsCount.entrySet()) {
                        Map currentSprintEntries = (Map)entry.getValue();
                        Object latestStatusEntry = null;
                        HashSet<String> hashSet = new HashSet<String>();
                        for (Map.Entry entry2 : currentSprintEntries.entrySet()) {
                            List list3 = (List)entry2.getValue();
                            for (TimeSeriesLog item : list3) {
                                hashSet.add(item.getItemId());
                                activeStatusMap.put(item.getId(), item);
                            }
                            finalMap.put(entry.getKey(), hashSet.size());
                        }
                    }
                }
                for (Map.Entry entry : activeStatusMap.entrySet()) {
                    finalActiveMap.put(((TimeSeriesLog)entry.getValue()).getId(), entry.getValue());
                    if (!PropertyValidator.isValid((Collection)((TimeSeriesLog)entry.getValue()).getTeamContainers())) continue;
                    plannedItems.add(((TimeSeriesLog)entry.getValue()).getItemId());
                }
                switch (groupBy) {
                    case "teams": {
                        Map tempMap = this.timeSeriesUtils.getTeamGroupByLatestItemsMap(finalActiveMap);
                        teamStatusMap = (HashMap)tempMap.get("teamGroupByMatchingItemsMap");
                        allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                        groupbyIdColorMap = (Map)tempMap.get("teamIdColorMap");
                        Map tempResult = this.timeSeriesUtils.getTeamLoad((Map)teamStatusMap, sprintsCount, allIntervals, releventDates, containerMap, selectedIssueType, activeStatusids, waitingStatusIds, activeStatusCategories, waitingStatusCategories, radioTypeSelection, hashMap, plannedItems);
                        LinkedHashMap linkedHashMap = new LinkedHashMap();
                        for (Map.Entry entry : releventDates.entrySet()) {
                            linkedHashMap.put(((Container)containerMap.get(entry.getKey())).getTitle(), entry.getValue());
                        }
                        result.put("relevantDates", TimeSeriesUtils.handleTimeZone(linkedHashMap));
                        result.put("itemTeamsMap", tempResult.get("itemTeamsMap"));
                        result.put("intervals", tempResult.get("intervals"));
                        result.put("categories", tempResult.get("categories"));
                        result.put("issueTypeMap", tempResult.get("issueTypeMap"));
                        result.put("itemStatusMap", tempResult.get("itemStatusMap"));
                        result.put("issueSprintMap", tempResult.get("issueSprintMap"));
                        result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                        result.put("groupIdColorMap", groupbyIdColorMap);
                        result.put("activeIntervals", tempResult.get("activeIntervals"));
                        result.put("waitingIntervals", tempResult.get("waitingIntervals"));
                        break;
                    }
                    case "cardType": {
                        HashMap issueTypeStatusMap = new HashMap();
                        Map tempMap = this.timeSeriesUtils.getCardTypeGroupByFurthestItemsMap(finalActiveMap);
                        issueTypeStatusMap = (HashMap)tempMap.get("issueTypeStatusMap");
                        allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                        groupbyIdColorMap = (Map)tempMap.get("teamIdColorMap");
                        Map map = this.timeSeriesUtils.getCardTypeLoad((Map)issueTypeStatusMap, sprintsCount, allIntervals, releventDates, containerMap, selectedIssueType, activeStatusids, waitingStatusIds, hashMap);
                        HashMap tempReleventDates = new HashMap();
                        for (Map.Entry entry : releventDates.entrySet()) {
                            if (!tempReleventDates.containsKey(containerMap.get(entry.getKey()))) continue;
                            tempReleventDates.put(((Container)containerMap.get(entry.getKey())).getTitle(), entry.getValue());
                        }
                        result.put("relevantDates", TimeSeriesUtils.handleTimeZone(tempReleventDates));
                        result.put("intervals", map.get("intervals"));
                        result.put("categories", map.get("categories"));
                        result.put("issueTypeMap", map.get("issueTypeMap"));
                        result.put("itemStatusMap", map.get("itemStatusMap"));
                        result.put("issueSprintMap", map.get("issueSprintMap"));
                        result.put("itemIdsMap", map.get("itemIdsMap"));
                        result.put("groupIdColorMap", groupbyIdColorMap);
                        result.put("activeIntervals", map.get("activeIntervals"));
                        result.put("waitingIntervals", map.get("waitingIntervals"));
                        result.put("itemTeamsMap", map.get("itemTeamsMap"));
                        break;
                    }
                    case "jiraProject": {
                        HashMap issueTypeStatusMap = new HashMap();
                        Map tempMap = this.timeSeriesUtils.getJiraProjectGroupByFurthestItemsMap(finalActiveMap, dashboard);
                        issueTypeStatusMap = (HashMap)tempMap.get("jiraProjectIssueTypeMap");
                        allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                        groupbyIdColorMap = (Map)tempMap.get("teamIdColorMap");
                        Map map = this.timeSeriesUtils.getJiraProjectDist((Map)issueTypeStatusMap, sprintsCount, allIntervals, releventDates, containerMap, selectedIssueType, hashMap);
                        HashMap tempReleventDates = new HashMap();
                        for (Map.Entry entry : releventDates.entrySet()) {
                            tempReleventDates.put(((Container)containerMap.get(entry.getKey())).getTitle(), entry.getValue());
                        }
                        result.put("relevantDates", TimeSeriesUtils.handleTimeZone(tempReleventDates));
                        result.put("intervals", map.get("intervals"));
                        result.put("categories", map.get("categories"));
                        result.put("issueTypeMap", map.get("issueTypeMap"));
                        result.put("itemStatusMap", map.get("itemStatusMap"));
                        result.put("issueSprintMap", map.get("issueSprintMap"));
                        result.put("itemIdsMap", map.get("itemIdsMap"));
                        result.put("groupIdColorMap", groupbyIdColorMap);
                        result.put("activeIntervals", map.get("activeIntervals"));
                        result.put("waitingIntervals", map.get("waitingIntervals"));
                        result.put("itemTeamsMap", map.get("itemTeamsMap"));
                        break;
                    }
                    case "tfsProject": {
                        HashMap issueTypeStatusMap = new HashMap();
                        Map tempMap = this.timeSeriesUtils.getTFSProjectGroupByFurthestItemsMap(finalActiveMap, dashboard);
                        issueTypeStatusMap = (HashMap)tempMap.get("tfsProjectIssueTypeMap");
                        allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                        groupbyIdColorMap = (Map)tempMap.get("teamIdColorMap");
                        Map map = this.timeSeriesUtils.getTFSProjectDist((Map)issueTypeStatusMap, sprintsCount, allIntervals, releventDates, containerMap, selectedIssueType);
                        HashMap tempReleventDates = new HashMap();
                        for (Map.Entry entry : releventDates.entrySet()) {
                            tempReleventDates.put(((Container)containerMap.get(entry.getKey())).getTitle(), entry.getValue());
                        }
                        result.put("relevantDates", TimeSeriesUtils.handleTimeZone(tempReleventDates));
                        result.put("intervals", map.get("intervals"));
                        result.put("categories", map.get("categories"));
                        result.put("issueTypeMap", map.get("issueTypeMap"));
                        result.put("itemStatusMap", map.get("itemStatusMap"));
                        result.put("issueSprintMap", map.get("issueSprintMap"));
                        result.put("groupIdColorMap", groupbyIdColorMap);
                        result.put("activeIntervals", map.get("activeIntervals"));
                        result.put("waitingIntervals", map.get("waitingIntervals"));
                        result.put("itemTeamsMap", map.get("itemTeamsMap"));
                        break;
                    }
                    case "areaPath": {
                        HashMap issueTypeStatusMap = new HashMap();
                        Map tempMap = this.timeSeriesUtils.getAreaPathGroupByFurthestItemsMap(finalActiveMap, dashboard);
                        issueTypeStatusMap = (HashMap)tempMap.get("areaPathMap");
                        allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                        groupbyIdColorMap = (Map)tempMap.get("teamIdColorMap");
                        Map map = this.timeSeriesUtils.getStringDist((Map)issueTypeStatusMap, sprintsCount, allIntervals, releventDates, containerMap, selectedIssueType);
                        HashMap tempReleventDates = new HashMap();
                        for (Map.Entry entry : releventDates.entrySet()) {
                            tempReleventDates.put(((Container)containerMap.get(entry.getKey())).getTitle(), entry.getValue());
                        }
                        result.put("relevantDates", TimeSeriesUtils.handleTimeZone(tempReleventDates));
                        result.put("itemTeamsMap", map.get("itemTeamsMap"));
                        result.put("intervals", map.get("intervals"));
                        result.put("categories", map.get("categories"));
                        result.put("issueTypeMap", map.get("issueTypeMap"));
                        result.put("itemStatusMap", map.get("itemStatusMap"));
                        result.put("issueSprintMap", map.get("issueSprintMap"));
                        result.put("itemIdsMap", map.get("itemIdsMap"));
                        result.put("groupIdColorMap", groupbyIdColorMap);
                        result.put("activeIntervals", map.get("activeIntervals"));
                        result.put("waitingIntervals", map.get("waitingIntervals"));
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error processing getFlowLoad()" + StringUtils.getTraceString((Throwable)e));
            }
        }
        return result;
    }

    public Map<String, Object> getItemsForFlowDistribution(SessionBoard sessionBoard, String sessionBoardIds, String tenant, List<String> listOfActiveStatus, List<Status> statusList, String interval, List<String> selectedIssueType, String groupBy, Date dateStart, Date dateEnd, String yAxis, Map<String, String> issueTypeMap, String boardItemsFilter, Dashboard dashboard, Map<String, String> itemTags) throws ExecutionException, InterruptedException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap itemsDaysMap = new HashMap();
        Map groupbyIdColorMap = new HashMap();
        ArrayList<String> searchedItemIds = new ArrayList<String>();
        if (PropertyValidator.isValid(itemTags)) {
            searchedItemIds.addAll(itemTags.keySet());
        }
        this.timeSeriesUtils = new TimeSeriesUtils(this.mongoTemplate, this.statusRepository);
        List startingStatusMatch = new ArrayList();
        Map sprintDates = this.timeSeriesUtils.getSprintDates(sessionBoard);
        ArrayList allSprints = new ArrayList(sprintDates.keySet());
        if (PropertyValidator.isValid((Object)sprintDates) && PropertyValidator.isValid(allSprints)) {
            startingStatusMatch = this.timeSeriesUtils.getFilteredItemsListByStatus(searchedItemIds, listOfActiveStatus, sessionBoard.getCreationDate(), (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1), tenant, "itemTimeSeries", sessionBoard.getId());
        }
        if (!startingStatusMatch.isEmpty()) {
            if (boardItemsFilter.equals("unplanned-items")) {
                startingStatusMatch = this.timeSeriesUtils.retrieveAndCheckTeamContainerForUnPlanned(startingStatusMatch, tenant);
            } else if (boardItemsFilter.equals("planned-items")) {
                startingStatusMatch = this.timeSeriesUtils.retrieveAndCheckTeamContainerForPlanned(startingStatusMatch, tenant);
            }
        }
        this.timeSeriesUtils = new TimeSeriesUtils(this.mongoTemplate, this.statusRepository);
        Map activeStatusMap = new HashMap();
        activeStatusMap = this.timeSeriesUtils.populateFarthestStatusMapForVelocity(startingStatusMatch, selectedIssueType, sessionBoardIds);
        Map<String, List<Date>> releventDates = new LinkedHashMap();
        HashMap teamStatusMap = new HashMap();
        HashMap issueTypeStatusMap = new HashMap();
        HashMap plannedUnplannedStatusMap = new HashMap();
        HashMap jiraProjectIssueTypeMap = new HashMap();
        HashMap tfsProjectIssueTypeMap = new HashMap();
        HashMap areaPathMap = new HashMap();
        HashMap parentEpicMap = new HashMap();
        HashMap customFieldsMap = new HashMap();
        Map allGroupBysMap = new HashMap();
        String customFieldType = "";
        switch (groupBy) {
            case "teams": {
                Map tempMap = this.timeSeriesUtils.getTeamGroupByFurthestItemsMap(activeStatusMap);
                teamStatusMap = (HashMap)tempMap.get("teamGroupByMatchingItemsMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                groupbyIdColorMap = (Map)tempMap.get("teamIdColorMap");
                break;
            }
            case "cardType": {
                Map tempMap = this.timeSeriesUtils.getCardTypeGroupByFurthestItemsMap(activeStatusMap);
                issueTypeStatusMap = (HashMap)tempMap.get("issueTypeStatusMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                groupbyIdColorMap = (Map)tempMap.get("cardtypeColorMap");
                break;
            }
            case "plannedUnplanned": {
                Map tempMap = this.timeSeriesUtils.getPlannedUnPlannedGroupByFurthestItemsMap(activeStatusMap);
                plannedUnplannedStatusMap = (HashMap)tempMap.get("plannedUnplannedStatusMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                break;
            }
            case "jiraProject": {
                Map tempMap = this.timeSeriesUtils.getJiraProjectGroupByFurthestItemsMap(activeStatusMap, dashboard);
                jiraProjectIssueTypeMap = (HashMap)tempMap.get("jiraProjectIssueTypeMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                groupbyIdColorMap = (Map)tempMap.get("jiraProjectColorMap");
                break;
            }
            case "tfsProject": {
                Map tempMap = this.timeSeriesUtils.getTFSProjectGroupByFurthestItemsMap(activeStatusMap, dashboard);
                tfsProjectIssueTypeMap = (HashMap)tempMap.get("tfsProjectIssueTypeMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                groupbyIdColorMap = (Map)tempMap.get("tfsProjectColorMap");
                break;
            }
            case "areaPath": {
                Map tempMap = this.timeSeriesUtils.getAreaPathGroupByFurthestItemsMap(activeStatusMap, dashboard);
                areaPathMap = (HashMap)tempMap.get("areaPathMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                groupbyIdColorMap = (Map)tempMap.get("areaPathColorMap");
                break;
            }
            case "epic": {
                Map tempMap = this.timeSeriesUtils.getParentEpicGroupByFurthestItemsMap(activeStatusMap);
                parentEpicMap = (HashMap)tempMap.get("parentEpicMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                break;
            }
            default: {
                Map tempMap;
                TimeSeriesLog earliestItem;
                String[] parts = groupBy.split("-");
                String groupByvalue = parts[1];
                if (startingStatusMatch.isEmpty() || (earliestItem = (TimeSeriesLog)startingStatusMatch.get(0)).getItemId() == null) break;
                Query queryForItem = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(earliestItem.getItemId())));
                Item tempItem = (Item)this.mongoTemplate.findOne(queryForItem, Item.class);
                if (tempItem.getJiraFieldByKey() != null) {
                    customFieldType = "jiraCustomFields";
                    tempMap = this.timeSeriesUtils.getJiraCustomFieldsGroupByFurthestItemsMap(activeStatusMap, groupByvalue);
                    customFieldsMap = (HashMap)tempMap.get("customFieldsMap");
                    allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                    break;
                }
                if (tempItem.getTfsFieldByKey() == null) break;
                customFieldType = "tfsCustomFields";
                tempMap = this.timeSeriesUtils.getTFSCustomFieldsGroupByFurthestItemsMap(activeStatusMap, groupByvalue);
                customFieldsMap = (HashMap)tempMap.get("customFieldsMap");
                allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
            }
        }
        List allIntervals = new ArrayList();
        block24 : switch (interval) {
            case "sprints": {
                releventDates = this.timeSeriesUtils.getSprintDates(sessionBoard);
                break;
            }
            case "weekly": {
                if (allSprints.isEmpty()) break;
                Date startDate = (Date)((List)sprintDates.get(allSprints.get(0))).get(0);
                Date endDate = (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1);
                long startTime = startDate.getTime();
                long endTime = endDate.getTime();
                for (long weekStart = startTime; weekStart <= endTime; weekStart += 604800000L) {
                    Date weekStartDate = new Date(weekStart);
                    Date weekEndDate = new Date(Math.min(weekStart + 518400000L, endTime));
                    if (weekStartDate.after(new Date())) break block24;
                    releventDates.put("Week " + (releventDates.size() + 1), Arrays.asList(weekStartDate, weekEndDate));
                }
                break;
            }
            case "monthly": {
                Calendar calendar = Calendar.getInstance();
                if (allSprints.isEmpty()) break;
                calendar.setTime((Date)((List)sprintDates.get(allSprints.get(0))).get(0));
                releventDates = this.timeSeriesUtils.getAllMonthswrtFirstAndLastEntry(calendar, (Date)((List)sprintDates.get(allSprints.get(0))).get(0), (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1));
                break;
            }
            case "days": {
                allIntervals = this.timeSeriesUtils.getAllDates(dateStart, dateEnd);
            }
        }
        switch (groupBy) {
            case "teams": {
                Map tempResult = this.timeSeriesUtils.getTeamDistribution((Map)teamStatusMap, releventDates, allIntervals, interval, listOfActiveStatus, issueTypeMap, yAxis);
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("issueTypeMap", tempResult.get("issueTypeMap"));
                result.put("itemStatusMap", tempResult.get("itemStatusMap"));
                result.put("issueSprintMap", tempResult.get("issueSprintMap"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            case "cardType": {
                Map tempResult = this.timeSeriesUtils.getCardTypeDistribution((Map)issueTypeStatusMap, releventDates, allIntervals, interval, listOfActiveStatus, issueTypeMap, yAxis);
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("issueTypeMap", tempResult.get("issueTypeMap"));
                result.put("itemStatusMap", tempResult.get("itemStatusMap"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            case "plannedUnplanned": {
                Map tempResult = this.timeSeriesUtils.getPlannedUnPlannedDistribution((Map)plannedUnplannedStatusMap, releventDates, allIntervals, interval, listOfActiveStatus, issueTypeMap, yAxis);
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("issueTypeMap", tempResult.get("issueTypeMap"));
                result.put("itemStatusMap", tempResult.get("itemStatusMap"));
                break;
            }
            case "jiraProject": {
                Map tempResult = this.timeSeriesUtils.getjiraProjectDistribution((Map)jiraProjectIssueTypeMap, releventDates, allIntervals, interval, listOfActiveStatus, issueTypeMap, yAxis);
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("issueTypeMap", tempResult.get("issueTypeMap"));
                result.put("itemStatusMap", tempResult.get("itemStatusMap"));
                result.put("issueSprintMap", tempResult.get("issueSprintMap"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            case "tfsProject": {
                Map tempResult = this.timeSeriesUtils.getTFSProjectDistribution((Map)tfsProjectIssueTypeMap, releventDates, allIntervals, interval, listOfActiveStatus, issueTypeMap, yAxis);
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("issueTypeMap", tempResult.get("issueTypeMap"));
                result.put("itemStatusMap", tempResult.get("itemStatusMap"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            case "areaPath": {
                Map tempResult = this.timeSeriesUtils.getPlannedUnPlannedDistribution((Map)areaPathMap, releventDates, allIntervals, interval, listOfActiveStatus, issueTypeMap, yAxis);
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("issueTypeMap", tempResult.get("issueTypeMap"));
                result.put("itemStatusMap", tempResult.get("itemStatusMap"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            case "epic": {
                Map tempResult = this.timeSeriesUtils.getPlannedUnPlannedDistribution((Map)parentEpicMap, releventDates, allIntervals, interval, listOfActiveStatus, issueTypeMap, yAxis);
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("issueTypeMap", tempResult.get("issueTypeMap"));
                result.put("itemStatusMap", tempResult.get("itemStatusMap"));
                result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                break;
            }
            default: {
                if (!customFieldType.equals("jiraCustomFields") && !customFieldType.equals("tfsCustomFields")) break;
                Map tempResult = this.timeSeriesUtils.getPlannedUnPlannedDistribution(customFieldsMap, releventDates, allIntervals, interval, listOfActiveStatus, issueTypeMap, yAxis);
                result.put("relevantDates", TimeSeriesUtils.handleTimeZone(releventDates));
                result.put("intervals", tempResult.get("intervals"));
                result.put("categories", tempResult.get("categories"));
                result.put("issueTypeMap", tempResult.get("issueTypeMap"));
                result.put("itemStatusMap", tempResult.get("itemStatusMap"));
            }
        }
        result.put("selectedIssueTypeMap", issueTypeMap);
        result.put("allGroupBys", allGroupBysMap);
        result.put("groupIdColorMap", groupbyIdColorMap);
        return result;
    }

    public Map<String, Object> getFlowDistribution(SessionBoard sessionBoard, String sessionBoardIds, String tenant, List<String> listOfActiveStatus, List<Status> statusList, String interval, List<String> selectedIssueType, String groupBy, Date dateStart, Date dateEnd, String yAxis, Map<String, String> issueTypeMap, String boardItemsFilter, Dashboard dashboard, Map<String, String> itemTags, String radioTypeSelection) throws Exception {
        HashMap<String, Object> result;
        block99: {
            long startTime = System.currentTimeMillis();
            LOGGER.info("Going to execute getFlowDistribution() at: " + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
            result = new HashMap<String, Object>();
            HashMap<String, Map> sprintsCount = new HashMap<String, Map>();
            List<TimeSeriesLog> matchedItems = new ArrayList();
            HashMap finalMap = new HashMap();
            ArrayList<String> searchedItemIds = new ArrayList<String>();
            Map allGroupBysMap = new HashMap();
            Map groupbyIdColorMap = new HashMap();
            HashMap finalActiveMap = new HashMap();
            HashSet<String> plannedItems = new HashSet<String>();
            if (PropertyValidator.isValid(itemTags)) {
                searchedItemIds.addAll(itemTags.keySet());
            }
            this.timeSeriesUtils = new TimeSeriesUtils(this.mongoTemplate, this.statusRepository);
            Map sprintDates = this.timeSeriesUtils.getSprintDatesWithFuture(sessionBoard);
            ArrayList allSprints = new ArrayList(sprintDates.keySet());
            List allIntervals = new ArrayList();
            Map<String, List<Date>> releventDates = new LinkedHashMap();
            block7 : switch (interval) {
                case "sprints": {
                    releventDates = this.timeSeriesUtils.getSprintDatesIdMap(sessionBoard);
                    break;
                }
                case "weekly": {
                    if (allSprints.isEmpty()) break;
                    Date startDate = (Date)((List)sprintDates.get(allSprints.get(0))).get(0);
                    Date endDate = (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1);
                    long startTimee = startDate.getTime();
                    long l = endDate.getTime();
                    for (long weekStart = startTimee; weekStart <= l; weekStart += 604800000L) {
                        Date date = new Date(weekStart);
                        Date weekEndDate = new Date(Math.min(weekStart + 518400000L, l));
                        if (date.after(new Date())) break block7;
                        releventDates.put("Week " + (releventDates.size() + 1), Arrays.asList(date, weekEndDate));
                    }
                    break;
                }
                case "monthly": {
                    Calendar calendar = Calendar.getInstance();
                    if (allSprints.isEmpty()) break;
                    calendar.setTime((Date)((List)sprintDates.get(allSprints.get(0))).get(0));
                    releventDates = this.timeSeriesUtils.getAllMonthswrtFirstAndLastEntry(calendar, (Date)((List)sprintDates.get(allSprints.get(0))).get(0), (Date)((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1));
                    break;
                }
                case "days": {
                    allIntervals = this.timeSeriesUtils.getAllDates(dateStart, dateEnd);
                }
            }
            LOGGER.info("Going to fetch all statuses at: " + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
            ArrayList<TimeSeriesLog> resultList = new ArrayList<TimeSeriesLog>();
            Set allStatusTitles = new HashSet();
            HashSet<String> filteredStatusIds = new HashSet<String>();
            try {
                HashMap teamStatusMap;
                String string;
                Session session;
                List<Object> statusOrder = new ArrayList();
                if (sessionBoard != null && (session = sessionBoard.getSession()) != null && session.getItemWorkFlow() != null && (string = session.getItemWorkFlow().getStatusSequence()) != null) {
                    statusOrder = Arrays.asList(string.split(","));
                }
                if (!PropertyValidator.isValid(statusOrder = this.timeSeriesUtils.getStatusCategoryOrder(statusOrder))) {
                    statusOrder = new ArrayList();
                    statusOrder.add(EnumStatusCategory.OPEN.getCode());
                    statusOrder.add(EnumStatusCategory.INPROGRESS.getCode());
                    statusOrder.add(EnumStatusCategory.DONE.getCode());
                    statusOrder.add(EnumStatusCategory.MISC.getCode());
                }
                allStatusTitles = this.timeSeriesUtils.sortStatusesByWorkflow(listOfActiveStatus, statusOrder, radioTypeSelection);
                LOGGER.info("All status titles fetched at:" + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
                if (radioTypeSelection.equalsIgnoreCase("status")) {
                    BasicDBObject query = new BasicDBObject();
                    query.put((Object)"$and", Arrays.asList(new BasicDBObject("title", (Object)new BasicDBObject("$in", allStatusTitles)), new BasicDBObject("tenant", (Object)tenant), new BasicDBObject("sessionId", (Object)sessionBoard.getSession().getId())));
                    DBCollection dBCollection = this.mongoTemplate.getCollection("status");
                    DBCursor dBCursor = dBCollection.find((DBObject)query);
                    while (dBCursor.hasNext()) {
                        String statusId;
                        DBObject dBObject = (DBObject)dBCursor.next();
                        if (!PropertyValidator.isValid((Object)dBObject.get("_id"))) continue;
                        if (dBObject.get("_id") instanceof ObjectId) {
                            ObjectId statusObjId = (ObjectId)dBObject.get("_id");
                            if (!PropertyValidator.isValid((Object)statusObjId)) continue;
                            filteredStatusIds.add(statusObjId.toString());
                            continue;
                        }
                        if (!(dBObject.get("_id") instanceof String) || !PropertyValidator.isValid((Object)(statusId = (String)dBObject.get("_id")))) continue;
                        filteredStatusIds.add(statusId);
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (PropertyValidator.isValid((Object)sessionBoard.getSession().getItemWorkFlow()) && PropertyValidator.isValid((Object)sessionBoard.getSession().getItemWorkFlow().getId())) {
                        arrayList.add(sessionBoard.getSession().getItemWorkFlow().getId());
                    }
                    if (PropertyValidator.isValid((Object)sessionBoard.getSession().getSubItemWorkFlow()) && PropertyValidator.isValid((Object)sessionBoard.getSession().getSubItemWorkFlow().getId())) {
                        arrayList.add(sessionBoard.getSession().getSubItemWorkFlow().getId());
                    }
                    List workflowObjIds = arrayList.stream().map(ObjectId::new).collect(Collectors.toList());
                    query = new BasicDBObject();
                    query.put((Object)"$and", Arrays.asList(new BasicDBObject("title", (Object)new BasicDBObject("$in", allStatusTitles)), new BasicDBObject("tenant", (Object)tenant), new BasicDBObject("workFlow.$id", (Object)new BasicDBObject("$in", workflowObjIds))));
                    DBCollection dBCollection2 = this.mongoTemplate.getCollection("status");
                    DBCursor dBCursor2 = dBCollection2.find((DBObject)query);
                    while (dBCursor2.hasNext()) {
                        String string2;
                        Iterator status = (DBObject)dBCursor2.next();
                        if (!PropertyValidator.isValid((Object)status.get("_id"))) continue;
                        if (status.get("_id") instanceof ObjectId) {
                            ObjectId objectId = (ObjectId)status.get("_id");
                            if (!PropertyValidator.isValid((Object)objectId)) continue;
                            filteredStatusIds.add(objectId.toString());
                            continue;
                        }
                        if (!(status.get("_id") instanceof String) || !PropertyValidator.isValid((Object)(string2 = (String)status.get("_id")))) continue;
                        filteredStatusIds.add(string2);
                    }
                }
                LOGGER.info("All status ids fetched at:" + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
                if (PropertyValidator.isValid(allSprints)) {
                    BasicDBObject filter = new BasicDBObject();
                    filter.put((Object)"eventTime", (Object)new BasicDBObject("$gte", (Object)sessionBoard.getCreationDate()).append("$lte", ((List)sprintDates.get(allSprints.get(allSprints.size() - 1))).get(1)));
                    filter.put((Object)"meta.tenant", (Object)tenant);
                    filter.put((Object)"meta.sessionBoardId", (Object)sessionBoard.getId());
                    DBCollection dBCollection = this.mongoTemplate.getCollection("itemTimeSeries");
                    DBCursor dBCursor = dBCollection.find((DBObject)filter);
                    while (dBCursor.hasNext()) {
                        TimeSeriesLog timeSeriesLog = new TimeSeriesLog();
                        DBObject dbObject = dBCursor.next();
                        timeSeriesLog.setId(dbObject.get("_id").toString());
                        timeSeriesLog.setEventTime((Date)dbObject.get("eventTime"));
                        timeSeriesLog.setJiraKey((String)dbObject.get("jiraKey"));
                        timeSeriesLog.setChanges((Map)dbObject.get("changes"));
                        timeSeriesLog.setMeta((Map)dbObject.get("meta"));
                        timeSeriesLog.setTfsId((String)dbObject.get("tfsId"));
                        timeSeriesLog.setItemId((String)dbObject.get("itemId"));
                        timeSeriesLog.setTeamContainers((List)dbObject.get("teamContainers"));
                        resultList.add(timeSeriesLog);
                    }
                    this.timeSeriesUtils.checkItemExistanceInCollection(resultList);
                } else {
                    Map tempMap = this.timeSeriesUtils.getTeamGroupByLatestItemsMap(finalActiveMap);
                    teamStatusMap = (HashMap)tempMap.get("teamGroupByMatchingItemsMap");
                    allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                    groupbyIdColorMap = (Map)tempMap.get("teamIdColorMap");
                    HashMap hashMap = new HashMap();
                    HashMap hashMap2 = new HashMap();
                    Map map = this.timeSeriesUtils.getTeamDist((Map)teamStatusMap, sprintsCount, allIntervals, releventDates, hashMap, selectedIssueType, hashMap2, plannedItems);
                    LinkedHashMap tempReleventDates = new LinkedHashMap();
                    for (Map.Entry entry : releventDates.entrySet()) {
                        tempReleventDates.put(((Container)hashMap.get(entry.getKey())).getTitle(), entry.getValue());
                    }
                    result.put("relevantDates", TimeSeriesUtils.handleTimeZone(tempReleventDates));
                    result.put("intervals", map.get("intervals"));
                    result.put("categories", map.get("categories"));
                    result.put("issueTypeMap", map.get("issueTypeMap"));
                    result.put("itemStatusMap", map.get("itemStatusMap"));
                    result.put("issueSprintMap", map.get("issueSprintMap"));
                    result.put("itemIdsMap", map.get("itemIdsMap"));
                    result.put("groupIdColorMap", groupbyIdColorMap);
                }
                LOGGER.info("All items fetched from time series at:" + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
                if (PropertyValidator.isValid(searchedItemIds)) {
                    for (TimeSeriesLog timeSeriesLog : resultList) {
                        if (!searchedItemIds.contains(timeSeriesLog.getItemId())) continue;
                        matchedItems.add(timeSeriesLog);
                    }
                } else {
                    matchedItems = resultList;
                }
                if (!matchedItems.isEmpty()) {
                    if (boardItemsFilter.equals("unplanned-items")) {
                        matchedItems = this.timeSeriesUtils.retrieveAndCheckTeamContainerForUnPlanned(matchedItems, tenant);
                    } else if (boardItemsFilter.equals("planned-items")) {
                        matchedItems = this.timeSeriesUtils.retrieveAndCheckTeamContainerForPlanned(matchedItems, tenant);
                    }
                }
                HashSet<String> containerIds = new HashSet<String>();
                for (Map.Entry entry : releventDates.entrySet()) {
                    List list = (List)entry.getValue();
                    Date endingDate = (Date)list.get(1);
                    for (TimeSeriesLog timeSeriesLog : matchedItems) {
                        List teamContainerMirror = timeSeriesLog.getTeamContainers();
                        if (!PropertyValidator.isValid((Collection)teamContainerMirror)) continue;
                        for (int i = 0; i < teamContainerMirror.size(); ++i) {
                            BasicDBObject containerDbObj;
                            BasicDBObject basicDBObject;
                            DBObject dbObject = (DBObject)teamContainerMirror.get(i);
                            if (!(dbObject instanceof BasicDBObject) || !PropertyValidator.isValid((Object)(basicDBObject = (BasicDBObject)dbObject)) || !PropertyValidator.isValid((Object)(containerDbObj = (BasicDBObject)basicDBObject.get("container")))) continue;
                            containerIds.add(containerDbObj.getString("_id"));
                        }
                    }
                }
                LOGGER.info("All containers fetched at:" + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
                HashMap<String, List> hashMap = new HashMap<String, List>();
                for (TimeSeriesLog timeSeriesLog : matchedItems) {
                    List timeSeriesLogsList = hashMap.getOrDefault(timeSeriesLog.getItemId(), new ArrayList());
                    timeSeriesLogsList.add(timeSeriesLog);
                    hashMap.put(timeSeriesLog.getItemId(), timeSeriesLogsList);
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    Map status = new HashMap();
                    for (TimeSeriesLog timeSeriesLog : (List)entry.getValue()) {
                        if (!timeSeriesLog.getChanges().containsKey("status")) {
                            timeSeriesLog.getChanges().put("status", status);
                            continue;
                        }
                        status = (Map)timeSeriesLog.getChanges().get("status");
                    }
                }
                LOGGER.info("All status populated in all entries at:" + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
                for (Map.Entry entry : hashMap.entrySet()) {
                    List currentList = (List)entry.getValue();
                    Collections.sort(currentList, new /* Unavailable Anonymous Inner Class!! */);
                    hashMap.put((String)entry.getKey(), currentList);
                }
                if (!PropertyValidator.isValid(releventDates.keySet())) break block99;
                Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(releventDates.keySet()));
                query.with(new Sort(Sort.Direction.ASC, new String[]{"startDate"}));
                List list = this.mongoTemplate.find(query, Container.class);
                LinkedHashMap<String, Container> containerMap = new LinkedHashMap<String, Container>();
                for (Container container : list) {
                    Date startDate = container.getStartDate();
                    Date endDate = container.getEndDate();
                    if (!PropertyValidator.isValid((Object)startDate) || !PropertyValidator.isValid((Object)endDate)) continue;
                    for (Map.Entry entry : hashMap.entrySet()) {
                        List allInnerEntries = (List)entry.getValue();
                        allInnerEntries.sort(Comparator.comparing(TimeSeriesLog::getEventTime));
                        for (TimeSeriesLog timeSeriesLog : allInnerEntries) {
                            String sprintId;
                            Object sprintIdObj;
                            BasicDBObject obj;
                            BasicDBObject containerObj;
                            List teamContainerMirrors;
                            List allEntries = (List)hashMap.get(timeSeriesLog.getItemId());
                            TimeSeriesLog latestEntry = (TimeSeriesLog)allEntries.get(allEntries.size() - 1);
                            Map changes = latestEntry.getChanges();
                            boolean archive = false;
                            if (changes.containsKey("archive")) {
                                archive = (Boolean)changes.get("archive");
                            }
                            if (archive) continue;
                            if (timeSeriesLog.getEventTime().after(startDate) && timeSeriesLog.getEventTime().before(endDate) && PropertyValidator.isValid((Collection)timeSeriesLog.getTeamContainers())) {
                                teamContainerMirrors = timeSeriesLog.getTeamContainers();
                                for (Object teamContainer : teamContainerMirrors) {
                                    if (!(teamContainer instanceof BasicDBObject) || !PropertyValidator.isValid((Object)(containerObj = (BasicDBObject)(obj = (BasicDBObject)teamContainer).get("container"))) || !PropertyValidator.isValid((Object)(sprintIdObj = containerObj.get("_id")))) continue;
                                    sprintId = "";
                                    if (sprintIdObj instanceof String) {
                                        sprintId = (String)sprintIdObj;
                                    } else if (sprintIdObj instanceof ObjectId) {
                                        sprintId = ((ObjectId)sprintIdObj).toString();
                                    }
                                    Map currentMap = sprintsCount.getOrDefault(sprintId, new HashMap());
                                    List currentEntries = currentMap.getOrDefault("items", new ArrayList());
                                    boolean itemAdded = false;
                                    for (int i = 0; i < currentEntries.size(); ++i) {
                                        TimeSeriesLog currentEntry = (TimeSeriesLog)currentEntries.get(i);
                                        if (!currentEntry.getItemId().equalsIgnoreCase(timeSeriesLog.getItemId())) continue;
                                        if (timeSeriesLog.getEventTime().after(currentEntry.getEventTime())) {
                                            currentEntries.set(i, timeSeriesLog);
                                            itemAdded = true;
                                        }
                                        itemAdded = true;
                                        break;
                                    }
                                    if (!itemAdded && PropertyValidator.isValid((Object)startDate) && PropertyValidator.isValid((Object)endDate)) {
                                        currentEntries.add(timeSeriesLog);
                                    }
                                    currentMap.put("items", currentEntries);
                                    sprintsCount.put(sprintId, currentMap);
                                }
                                continue;
                            }
                            teamContainerMirrors = timeSeriesLog.getTeamContainers();
                            if (!PropertyValidator.isValid((Collection)teamContainerMirrors)) continue;
                            for (Object teamContainer : teamContainerMirrors) {
                                TimeSeriesLog currentEntry;
                                int i;
                                boolean itemAdded;
                                List currentEntries;
                                Map currentMap;
                                if (!(teamContainer instanceof BasicDBObject) || !PropertyValidator.isValid((Object)(containerObj = (BasicDBObject)(obj = (BasicDBObject)teamContainer).get("container"))) || !PropertyValidator.isValid((Object)(sprintIdObj = containerObj.get("_id")))) continue;
                                sprintId = "";
                                if (sprintIdObj instanceof String) {
                                    sprintId = (String)sprintIdObj;
                                } else if (sprintIdObj instanceof ObjectId) {
                                    sprintId = ((ObjectId)sprintIdObj).toString();
                                }
                                Date today = new Date();
                                List attchedSprintDates = (List)releventDates.get(sprintId);
                                if (!PropertyValidator.isValid((Collection)attchedSprintDates)) continue;
                                Date attachedEndDate = (Date)attchedSprintDates.get(1);
                                if (PropertyValidator.isValid((Object)attachedEndDate) && attachedEndDate.after(today)) {
                                    currentMap = sprintsCount.getOrDefault(sprintId, new HashMap());
                                    currentEntries = currentMap.getOrDefault("items", new ArrayList());
                                    itemAdded = false;
                                    for (i = 0; i < currentEntries.size(); ++i) {
                                        currentEntry = (TimeSeriesLog)currentEntries.get(i);
                                        if (!currentEntry.getItemId().equalsIgnoreCase(timeSeriesLog.getItemId())) continue;
                                        if (timeSeriesLog.getEventTime().after(currentEntry.getEventTime())) {
                                            currentEntries.set(i, timeSeriesLog);
                                            itemAdded = true;
                                        }
                                        itemAdded = true;
                                        break;
                                    }
                                    if (!itemAdded && PropertyValidator.isValid((Object)startDate) && PropertyValidator.isValid((Object)endDate)) {
                                        currentEntries.add(timeSeriesLog);
                                    }
                                    currentMap.put("items", currentEntries);
                                    sprintsCount.put(sprintId, currentMap);
                                    continue;
                                }
                                if (timeSeriesLog.getEventTime().before(today)) {
                                    currentMap = sprintsCount.getOrDefault(sprintId, new HashMap());
                                    currentEntries = currentMap.getOrDefault("items", new ArrayList());
                                    itemAdded = false;
                                    for (i = 0; i < currentEntries.size(); ++i) {
                                        currentEntry = (TimeSeriesLog)currentEntries.get(i);
                                        if (!currentEntry.getItemId().equalsIgnoreCase(timeSeriesLog.getItemId())) continue;
                                        if (timeSeriesLog.getEventTime().after(currentEntry.getEventTime())) {
                                            currentEntries.set(i, timeSeriesLog);
                                            itemAdded = true;
                                        }
                                        itemAdded = true;
                                        break;
                                    }
                                    if (!itemAdded && PropertyValidator.isValid((Object)startDate) && PropertyValidator.isValid((Object)endDate)) {
                                        currentEntries.add(timeSeriesLog);
                                    }
                                    currentMap.put("items", currentEntries);
                                    sprintsCount.put(sprintId, currentMap);
                                    continue;
                                }
                                currentMap = sprintsCount.getOrDefault(sprintId, new HashMap());
                                currentEntries = currentMap.getOrDefault("items", new ArrayList());
                                itemAdded = false;
                                for (i = 0; i < currentEntries.size(); ++i) {
                                    currentEntry = (TimeSeriesLog)currentEntries.get(i);
                                    if (!currentEntry.getItemId().equalsIgnoreCase(timeSeriesLog.getItemId())) continue;
                                    if (timeSeriesLog.getEventTime().after(currentEntry.getEventTime())) {
                                        currentEntries.set(i, timeSeriesLog);
                                        itemAdded = true;
                                    }
                                    itemAdded = true;
                                    break;
                                }
                                if (!itemAdded && PropertyValidator.isValid((Object)startDate) && PropertyValidator.isValid((Object)endDate)) {
                                    currentEntries.add(timeSeriesLog);
                                }
                                currentMap.put("items", currentEntries);
                                sprintsCount.put(sprintId, currentMap);
                            }
                        }
                    }
                    containerMap.put(container.getId(), container);
                }
                LOGGER.info("All items grouped according to sprints at:" + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
                for (Map.Entry entry : sprintsCount.entrySet()) {
                    Map currentSprintEntries = (Map)entry.getValue();
                    for (Map.Entry innerEntry : currentSprintEntries.entrySet()) {
                        List list2 = (List)innerEntry.getValue();
                        Iterator<Object> iterator = list2.iterator();
                        while (iterator.hasNext()) {
                            String category;
                            TimeSeriesLog timeSeriesLog = (TimeSeriesLog)iterator.next();
                            Map map = (Map)timeSeriesLog.getChanges().get("status");
                            if (radioTypeSelection.equalsIgnoreCase("status") && !filteredStatusIds.contains(map.get("id"))) {
                                iterator.remove();
                                continue;
                            }
                            if (!radioTypeSelection.equalsIgnoreCase("statusCategory") || !PropertyValidator.isValid((Object)(category = (String)map.get("category"))) || allStatusTitles.contains(category)) continue;
                            iterator.remove();
                        }
                    }
                }
                LOGGER.info("All items filtered according to status at:" + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
                HashMap<String, TimeSeriesLog> activeStatusMap = new HashMap<String, TimeSeriesLog>();
                if (PropertyValidator.isValid(sprintsCount)) {
                    for (Map.Entry entry : sprintsCount.entrySet()) {
                        Map currentSprintEntries = (Map)entry.getValue();
                        Object latestStatusEntry = null;
                        HashSet<String> hashSet = new HashSet<String>();
                        for (Map.Entry entry2 : currentSprintEntries.entrySet()) {
                            List list3 = (List)entry2.getValue();
                            for (TimeSeriesLog item : list3) {
                                hashSet.add(item.getItemId());
                                activeStatusMap.put(item.getId(), item);
                            }
                            finalMap.put(entry.getKey(), hashSet.size());
                        }
                    }
                }
                for (Map.Entry entry : activeStatusMap.entrySet()) {
                    finalActiveMap.put(((TimeSeriesLog)entry.getValue()).getId(), entry.getValue());
                    plannedItems.add(((TimeSeriesLog)entry.getValue()).getItemId());
                }
                switch (groupBy) {
                    case "teams": {
                        Map tempMap = this.timeSeriesUtils.getTeamGroupByLatestItemsMap(finalActiveMap);
                        teamStatusMap = (HashMap)tempMap.get("teamGroupByMatchingItemsMap");
                        allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                        groupbyIdColorMap = (Map)tempMap.get("teamIdColorMap");
                        Map tempResult = this.timeSeriesUtils.getTeamDist((Map)teamStatusMap, sprintsCount, allIntervals, releventDates, containerMap, selectedIssueType, hashMap, plannedItems);
                        LinkedHashMap linkedHashMap = new LinkedHashMap();
                        for (Map.Entry entry : releventDates.entrySet()) {
                            linkedHashMap.put(((Container)containerMap.get(entry.getKey())).getTitle(), entry.getValue());
                        }
                        result.put("relevantDates", TimeSeriesUtils.handleTimeZone(linkedHashMap));
                        result.put("intervals", tempResult.get("intervals"));
                        result.put("categories", tempResult.get("categories"));
                        result.put("issueTypeMap", tempResult.get("issueTypeMap"));
                        result.put("itemStatusMap", tempResult.get("itemStatusMap"));
                        result.put("issueSprintMap", tempResult.get("issueSprintMap"));
                        result.put("itemIdsMap", tempResult.get("itemIdsMap"));
                        result.put("groupIdColorMap", groupbyIdColorMap);
                        break;
                    }
                    case "cardType": {
                        HashMap issueTypeStatusMap = new HashMap();
                        Map tempMap = this.timeSeriesUtils.getCardTypeGroupByFurthestItemsMap(finalActiveMap);
                        issueTypeStatusMap = (HashMap)tempMap.get("issueTypeStatusMap");
                        allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                        groupbyIdColorMap = (Map)tempMap.get("teamIdColorMap");
                        Map map = this.timeSeriesUtils.getCardTypeDist((Map)issueTypeStatusMap, sprintsCount, allIntervals, releventDates, containerMap, selectedIssueType, hashMap);
                        HashMap tempReleventDates = new HashMap();
                        for (Map.Entry entry : releventDates.entrySet()) {
                            if (!tempReleventDates.containsKey(containerMap.get(entry.getKey()))) continue;
                            tempReleventDates.put(((Container)containerMap.get(entry.getKey())).getTitle(), entry.getValue());
                        }
                        result.put("relevantDates", TimeSeriesUtils.handleTimeZone(tempReleventDates));
                        result.put("intervals", map.get("intervals"));
                        result.put("categories", map.get("categories"));
                        result.put("issueTypeMap", map.get("issueTypeMap"));
                        result.put("itemStatusMap", map.get("itemStatusMap"));
                        result.put("issueSprintMap", map.get("issueSprintMap"));
                        result.put("itemIdsMap", map.get("itemIdsMap"));
                        result.put("groupIdColorMap", groupbyIdColorMap);
                        break;
                    }
                    case "jiraProject": {
                        HashMap issueTypeStatusMap = new HashMap();
                        Map tempMap = this.timeSeriesUtils.getJiraProjectGroupByFurthestItemsMap(finalActiveMap, dashboard);
                        issueTypeStatusMap = (HashMap)tempMap.get("jiraProjectIssueTypeMap");
                        allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                        groupbyIdColorMap = (Map)tempMap.get("teamIdColorMap");
                        Map map = this.timeSeriesUtils.getJiraProjectDist((Map)issueTypeStatusMap, sprintsCount, allIntervals, releventDates, containerMap, selectedIssueType, hashMap);
                        HashMap tempReleventDates = new HashMap();
                        for (Map.Entry entry : releventDates.entrySet()) {
                            tempReleventDates.put(((Container)containerMap.get(entry.getKey())).getTitle(), entry.getValue());
                        }
                        result.put("relevantDates", TimeSeriesUtils.handleTimeZone(tempReleventDates));
                        result.put("intervals", map.get("intervals"));
                        result.put("categories", map.get("categories"));
                        result.put("issueTypeMap", map.get("issueTypeMap"));
                        result.put("itemStatusMap", map.get("itemStatusMap"));
                        result.put("issueSprintMap", map.get("issueSprintMap"));
                        result.put("itemIdsMap", map.get("itemIdsMap"));
                        result.put("groupIdColorMap", groupbyIdColorMap);
                        break;
                    }
                    case "tfsProject": {
                        HashMap issueTypeStatusMap = new HashMap();
                        Map tempMap = this.timeSeriesUtils.getTFSProjectGroupByFurthestItemsMap(finalActiveMap, dashboard);
                        issueTypeStatusMap = (HashMap)tempMap.get("tfsProjectIssueTypeMap");
                        allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                        groupbyIdColorMap = (Map)tempMap.get("teamIdColorMap");
                        Map map = this.timeSeriesUtils.getTFSProjectDist((Map)issueTypeStatusMap, sprintsCount, allIntervals, releventDates, containerMap, selectedIssueType);
                        HashMap tempReleventDates = new HashMap();
                        for (Map.Entry entry : releventDates.entrySet()) {
                            tempReleventDates.put(((Container)containerMap.get(entry.getKey())).getTitle(), entry.getValue());
                        }
                        result.put("relevantDates", TimeSeriesUtils.handleTimeZone(tempReleventDates));
                        result.put("intervals", map.get("intervals"));
                        result.put("categories", map.get("categories"));
                        result.put("issueTypeMap", map.get("issueTypeMap"));
                        result.put("itemStatusMap", map.get("itemStatusMap"));
                        result.put("issueSprintMap", map.get("issueSprintMap"));
                        result.put("groupIdColorMap", groupbyIdColorMap);
                        break;
                    }
                    case "areaPath": {
                        HashMap issueTypeStatusMap = new HashMap();
                        Map tempMap = this.timeSeriesUtils.getAreaPathGroupByFurthestItemsMap(finalActiveMap, dashboard);
                        issueTypeStatusMap = (HashMap)tempMap.get("areaPathMap");
                        allGroupBysMap = (Map)tempMap.get("allGroupBysMap");
                        groupbyIdColorMap = (Map)tempMap.get("teamIdColorMap");
                        Map map = this.timeSeriesUtils.getStringDist((Map)issueTypeStatusMap, sprintsCount, allIntervals, releventDates, containerMap, selectedIssueType);
                        HashMap tempReleventDates = new HashMap();
                        for (Map.Entry entry : releventDates.entrySet()) {
                            tempReleventDates.put(((Container)containerMap.get(entry.getKey())).getTitle(), entry.getValue());
                        }
                        result.put("relevantDates", TimeSeriesUtils.handleTimeZone(tempReleventDates));
                        result.put("intervals", map.get("intervals"));
                        result.put("categories", map.get("categories"));
                        result.put("issueTypeMap", map.get("issueTypeMap"));
                        result.put("itemStatusMap", map.get("itemStatusMap"));
                        result.put("issueSprintMap", map.get("issueSprintMap"));
                        result.put("itemIdsMap", map.get("itemIdsMap"));
                        result.put("groupIdColorMap", groupbyIdColorMap);
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error processing getFlowDistribution()" + StringUtils.getTraceString((Throwable)e));
            }
        }
        return result;
    }

    public Map<String, Object> getCFDItems(String tenant, List<String> individualSelectedStatusIds, List<String> individualActiveStatusIds, List<String> individualWaitingStatusIds, List<String> individualCompletedStatusIds, String xAxis, Date startDate, Date endDate, SessionBoard sessionBoard, String advanceCriteria, List<String> selectedAdvanceCriteria, Boolean toggleAvgArrivalTime, Boolean toggleAvgCycleTime, Boolean toggleAvgLeadTime, Boolean toggleAvgThroughputTime, Boolean toggleAdvanceCalculation, Boolean toggleAdvanceCriteria, Boolean toggleAvgWIPTime, List<String> selectedIssueType, Map<String, String> issueTypeMap, String radioButtonSelection, String boardItemsFilter, Dashboard dashboard, Map<String, String> itemTags) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set allStatusTitles = new LinkedHashSet();
        Map sprintCounts = new LinkedHashMap();
        Map relevantDates = new LinkedHashMap();
        HashMap itemsStatusMap = new HashMap();
        HashMap allGroupBysMap = new HashMap();
        HashMap allIssueTypesMap = new HashMap();
        List<Object> statusOrder = new ArrayList();
        LinkedHashMap itemIdswrtInterval = new LinkedHashMap();
        TimeSeriesUtils timeSeriesUtils = new TimeSeriesUtils(this.mongoTemplate, this.statusRepository);
        HashMap<String, String> groupbyIdColorMap = new HashMap<String, String>();
        HashMap globalColorsMap = dashboard.getGlobalColorsMap();
        HashMap<String, List> itemStatusMap = new HashMap<String, List>();
        HashSet itemIds = new HashSet();
        try {
            if (!PropertyValidator.isValid((Object)globalColorsMap)) {
                globalColorsMap = new HashMap();
            }
            Sort sort = new Sort(Sort.Direction.ASC, new String[]{"eventTime"});
            long startTime = System.currentTimeMillis();
            if (PropertyValidator.isValid((Object)startDate) && PropertyValidator.isValid((Object)endDate)) {
                String statusSequence;
                Session session;
                BasicDBObject queryToRetrieveFirstEntry = new BasicDBObject().append("changes.status.id", (Object)new BasicDBObject("$in", individualSelectedStatusIds)).append("meta.tenant", (Object)tenant).append("meta.sessionBoardId", (Object)sessionBoard.getId()).append("eventTime", (Object)new BasicDBObject("$gte", (Object)sessionBoard.getCreationDate()).append("$lte", (Object)endDate));
                Iterator<Object> fieldsToInclude = new BasicDBObject("eventTime", (Object)1);
                DBCursor cursor = this.mongoTemplate.getCollection("itemTimeSeries").find((DBObject)queryToRetrieveFirstEntry, fieldsToInclude).limit(1);
                TimeSeriesLog firstEntry = cursor.hasNext() ? (TimeSeriesLog)this.mongoTemplate.getConverter().read(TimeSeriesLog.class, (Object)cursor.next()) : null;
                LOGGER.info("Method :" + this.getClass().getName() + ".getCFDItems: First Entry execution lasted (seconds):" + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
                long secondStartTime = System.currentTimeMillis();
                if (sessionBoard != null && (session = sessionBoard.getSession()) != null && session.getItemWorkFlow() != null && (statusSequence = session.getItemWorkFlow().getStatusSequence()) != null) {
                    statusOrder = Arrays.asList(statusSequence.split(","));
                }
                if (!PropertyValidator.isValid(statusOrder = timeSeriesUtils.getStatusCategoryOrder(statusOrder))) {
                    statusOrder = new ArrayList();
                    statusOrder.add(EnumStatusCategory.OPEN.getCode());
                    statusOrder.add(EnumStatusCategory.INPROGRESS.getCode());
                    statusOrder.add(EnumStatusCategory.DONE.getCode());
                    statusOrder.add(EnumStatusCategory.MISC.getCode());
                }
                allStatusTitles = timeSeriesUtils.sortStatusesByWorkflow(individualSelectedStatusIds, statusOrder, radioButtonSelection);
                HashMap<String, String> statusStatusCatMap = new HashMap<String, String>();
                List ids = individualSelectedStatusIds.stream().filter(Objects::nonNull).map(status -> DBUtils.isHexString((String)status) ? new ObjectId(status) : status).collect(Collectors.toList());
                Query queryForStatusCat = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
                queryForStatusCat.fields().include("title").include("category");
                queryForStatusCat.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
                List statuses = this.mongoTemplate.find(queryForStatusCat, Status.class);
                for (Object status2 : statuses) {
                    statusStatusCatMap.put(status2.getTitle(), status2.getCategory());
                }
                LOGGER.info("Method :" + this.getClass().getName() + ".getCFDItems: Sort statuses execution lasted (seconds):" + (float)(System.currentTimeMillis() - secondStartTime) / 1000.0f);
                if (radioButtonSelection.equals("statusCategory")) {
                    for (String statusCategory : allStatusTitles) {
                        if (globalColorsMap.containsKey(statusCategory + "_category")) {
                            groupbyIdColorMap.put(statusCategory, (String)globalColorsMap.get(statusCategory + "_category"));
                            continue;
                        }
                        groupbyIdColorMap.put(statusCategory, TimeSeriesUtils.getRandomHexColor(globalColorsMap, (String)"statusCategory", (String)statusCategory));
                        globalColorsMap.put(statusCategory, groupbyIdColorMap.get(statusCategory));
                    }
                } else if (radioButtonSelection.equals("status")) {
                    for (Object status2 : allStatusTitles) {
                        if (globalColorsMap.containsKey(status2)) {
                            if (PropertyValidator.isValid(globalColorsMap.get(status2))) {
                                groupbyIdColorMap.put((String)status2, (String)globalColorsMap.get(status2));
                                continue;
                            }
                            groupbyIdColorMap.put((String)status2, TimeSeriesUtils.getRandomHexColor(globalColorsMap, (String)"status", (String)status2));
                            globalColorsMap.put((String)status2, groupbyIdColorMap.get(status2));
                            continue;
                        }
                        groupbyIdColorMap.put((String)status2, TimeSeriesUtils.getRandomHexColor(globalColorsMap, (String)"status", (String)status2));
                        globalColorsMap.put((String)status2, groupbyIdColorMap.get(status2));
                    }
                }
                if (firstEntry != null) {
                    Date firstEntryDate = TimeSeriesUtils.stripTime((Date)firstEntry.getEventTime());
                    Date dateToday = TimeSeriesUtils.stripTime((Date)new Date());
                    long thirdStartTime = System.currentTimeMillis();
                    if (firstEntryDate != null && !firstEntryDate.after(dateToday)) {
                        relevantDates = timeSeriesUtils.getDatesOfCFD(xAxis, sessionBoard, firstEntryDate, startDate, endDate);
                        result.put("categories", relevantDates.keySet());
                    }
                    LOGGER.info("Method :" + this.getClass().getName() + ".getCFDItems: Dates Fetchin of PI  execution lasted (seconds):" + (float)(System.currentTimeMillis() - thirdStartTime) / 1000.0f);
                    HashMap intervalStatusItemMap = new HashMap();
                    String previousKey = null;
                    long fourthStartTime = System.currentTimeMillis();
                    for (Map.Entry entry : relevantDates.entrySet()) {
                        String key = (String)entry.getKey();
                        List dates = (List)entry.getValue();
                        if (dates != null) {
                            if (xAxis.equals("sprints") || xAxis.equals("weekly") || xAxis.equals("monthly")) {
                                timeSeriesUtils.populateStatusMapForSprintWeekMonth(advanceCriteria, allStatusTitles, allGroupBysMap, allIssueTypesMap, dates, intervalStatusItemMap, individualSelectedStatusIds, issueTypeMap, selectedAdvanceCriteria, selectedIssueType, sessionBoard, sort, relevantDates, key, previousKey, radioButtonSelection, tenant, boardItemsFilter, itemTags, itemIds);
                            } else if (xAxis.equals("days")) {
                                timeSeriesUtils.populateStatusMapForDays(advanceCriteria, allStatusTitles, allGroupBysMap, allIssueTypesMap, dates, intervalStatusItemMap, individualSelectedStatusIds, issueTypeMap, selectedAdvanceCriteria, selectedIssueType, sessionBoard, sort, relevantDates, key, previousKey, radioButtonSelection, tenant, boardItemsFilter, itemTags, itemIds);
                            }
                        }
                        previousKey = key;
                    }
                    LOGGER.info("Method :" + this.getClass().getName() + ".getCFDItems: CFD Logic execution lasted (seconds):" + (float)(System.currentTimeMillis() - fourthStartTime) / 1000.0f);
                    long fifthStartTime = System.currentTimeMillis();
                    sprintCounts = timeSeriesUtils.populateMapOfCountOfStatuses(allStatusTitles, intervalStatusItemMap, itemIdswrtInterval);
                    LOGGER.info("Method :" + this.getClass().getName() + ".getCFDItems: Final Step execution lasted (seconds):" + (float)(System.currentTimeMillis() - fifthStartTime) / 1000.0f);
                    if (toggleAdvanceCalculation.booleanValue()) {
                        if (toggleAvgCycleTime.booleanValue()) {
                            double avgCycleTime = timeSeriesUtils.calculateAverageCycleTime(individualActiveStatusIds, individualCompletedStatusIds, sessionBoard, tenant);
                            result.put("avgCycleTime", avgCycleTime);
                        }
                        if (toggleAvgLeadTime.booleanValue()) {
                            double avgLeadTime = timeSeriesUtils.calculateAverageLeadTime(individualCompletedStatusIds, sessionBoard, tenant);
                            result.put("avgLeadTime", avgLeadTime);
                        }
                        if (toggleAvgArrivalTime.booleanValue()) {
                            double avgArrivalTime = timeSeriesUtils.calculateAverageArrivalTime(endDate, individualWaitingStatusIds, relevantDates, sessionBoard, startDate, tenant, xAxis);
                            result.put("avgArrivalTime", avgArrivalTime);
                        }
                        if (toggleAvgThroughputTime.booleanValue()) {
                            double avgThroughputTime = timeSeriesUtils.calculateAverageThroughputTime(endDate, individualCompletedStatusIds, relevantDates, sessionBoard, startDate, tenant, xAxis);
                            result.put("avgThroughputTime", avgThroughputTime);
                        }
                        if (toggleAvgWIPTime.booleanValue()) {
                            double avgWIPTime = timeSeriesUtils.calculateAverageWIPTime(endDate, individualWaitingStatusIds, relevantDates, sessionBoard, startDate, tenant, xAxis);
                            result.put("avgWIPTime", avgWIPTime);
                        }
                    }
                }
            }
            if (sprintCounts.isEmpty()) {
                Date firstEntryDate = new Date();
                relevantDates = timeSeriesUtils.getDatesOfCFD(xAxis, sessionBoard, firstEntryDate, startDate, endDate);
                result.put("categories", relevantDates.keySet());
                for (String interval : relevantDates.keySet()) {
                    for (String statusTitle : allStatusTitles) {
                        HashMap<String, String> intervalMap = new HashMap<String, String>();
                        intervalMap.put(interval, statusTitle);
                        sprintCounts.put(intervalMap, 0L);
                    }
                }
            }
            if ("statusCategory".equals(radioButtonSelection) && PropertyValidator.isValid(itemIds)) {
                ArrayList<ObjectId> itemIdsObjectList = new ArrayList<ObjectId>();
                for (String itemId : itemIds) {
                    itemIdsObjectList.add(new ObjectId(itemId));
                }
                Query queryForItem = new Query((CriteriaDefinition)Criteria.where((String)"id").in(itemIdsObjectList));
                queryForItem.fields().include("status");
                List itemsList = this.mongoTemplate.find(queryForItem, Item.class);
                for (Item item : itemsList) {
                    List tempStatus = itemStatusMap.getOrDefault(item.getId(), new ArrayList());
                    if (!PropertyValidator.isValid((Object)item.getStatus())) continue;
                    tempStatus.add(item.getStatus().getTitle() + "status_category:" + item.getStatus().getCategory());
                    itemStatusMap.put(item.getId(), tempStatus);
                }
                result.put("itemStatusMap", itemStatusMap);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getCFDItems()" + StringUtils.getTraceString((Throwable)e));
        }
        result.put("allGroupBysMap", allGroupBysMap);
        result.put("intervals", sprintCounts);
        result.put("allIssueTypesMap", allIssueTypesMap);
        result.put("itemIdsMap", itemIdswrtInterval);
        result.put("intervalDates", relevantDates);
        result.put("groupIdColorMap", groupbyIdColorMap);
        dashboard.setGlobalColorsMap((Map)result.get("groupIdColorMap"));
        Query queryForSavingDashboard = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(dashboard.getId())));
        Update update = new Update();
        update.set("globalColorsMap", globalColorsMap);
        this.mongoTemplate.updateFirst(queryForSavingDashboard, update, Dashboard.class);
        return result;
    }

    public Map<String, Object> getBacklogItemTimeSeriesWithLevel(String interval, String okrFilter, Date startDate, Date endDate, String criteriaCalculation, List<String> groupIds, List<Date> intervalDates, boolean isPiView, boolean isOkrEnabled, Map<String, Object> excludeItemsData, boolean unCommittedObjectivesEnabled, Date syncDate, String sessionBoardId, String sessionId, boolean isArtView) throws Exception {
        LOGGER.info("Going to build objective group n-th level hierarchy with start date :{} and end date :{}", (Object)startDate, (Object)endDate);
        Date start = new Date();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String baseItemCollection = "baseItemTimeSeries";
        String backlogItemCollection = "backlogItemTimeSeries";
        if (isPiView) {
            backlogItemCollection = "itemTimeSeries";
        }
        HashMap<String, String> itemKeys = new HashMap<String, String>();
        HashMap<String, String> itemTitles = new HashMap<String, String>();
        try {
            List groups;
            Map<String, BaseItem> cvGroupMap;
            String tenant = UserContextUtil.getUserContext().getLoggedInUser().getTenant();
            this.timeSeriesUtils = new TimeSeriesUtils(this.mongoTemplate, this.statusRepository);
            Calendar cal = Calendar.getInstance();
            cal.setTime(endDate);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 59);
            endDate = cal.getTime();
            cal.setTime(syncDate);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            syncDate = cal.getTime();
            cal.setTime(startDate);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            startDate = cal.getTime();
            BasicDBObject query = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", groupIds)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lte", (Object)endDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("changes.archive", (Object)new BasicDBObject("$ne", (Object)true)), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
            BasicDBObject queryEarliest = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", groupIds)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$lt", (Object)startDate).append("$gt", (Object)syncDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("changes.archive", (Object)new BasicDBObject("$ne", (Object)true)), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
            List mappedObjGrps = this.timeSeriesUtils.fetchBaseItems((DBObject)queryEarliest, baseItemCollection, false, -1);
            mappedObjGrps.addAll(this.timeSeriesUtils.fetchBaseItems((DBObject)query, baseItemCollection, true, 1));
            if (mappedObjGrps.isEmpty()) {
                LOGGER.info("No objective group found, returning.");
                resultMap.put("errorCase", true);
                return resultMap;
            }
            LOGGER.info("Objective groups of size: {} found", (Object)mappedObjGrps.size());
            Map datedObjGrpsMap = this.timeSeriesUtils.mapBaseItemLogsToDates(mappedObjGrps, intervalDates, interval);
            HashSet objectiveIdsList = new HashSet();
            HashSet<String> objectiveGroupIds = new HashSet<String>();
            for (BaseItem baseItem : mappedObjGrps) {
                objectiveIdsList.addAll(baseItem.getBaseItemLinks().stream().filter(l -> EnumKendis.CHILD_GROUP_OBJECTIVE.getCode().equalsIgnoreCase(l.getLinkType())).map(BaseItemLink::getBaseItemId).distinct().collect(Collectors.toList()));
                itemKeys.put(baseItem.getId(), baseItem.getTitle());
                itemTitles.put(baseItem.getId(), baseItem.getTitle());
                objectiveGroupIds.add(baseItem.getId());
            }
            if (isArtView && !(cvGroupMap = (groups = this.baseItemRepository.findByIdIn(new ArrayList(objectiveGroupIds))).stream().filter(grp -> PropertyValidator.isValid((Object)grp.getLinkedCustomView())).collect(Collectors.toMap(BaseItem::getLinkedCustomView, grp -> grp, (existing, duplicate) -> duplicate))).isEmpty()) {
                List views = this.objectiveCustomViewRepository.findAllByIdIn(new ArrayList<String>(cvGroupMap.keySet()));
                Map<String, ObjectiveCustomView> viewMap = views.stream().filter(PropertyValidator::isValid).collect(Collectors.toMap(BaseEntity::getId, view -> view));
                cvGroupMap.forEach((viewId, cvGroup) -> {
                    ObjectiveCustomView linkedView = (ObjectiveCustomView)viewMap.get(viewId);
                    if (linkedView != null) {
                        itemTitles.put(cvGroup.getId(), linkedView.getTitle());
                    }
                });
            }
            if (isPiView) {
                String teamId;
                HashSet<String> teamIds = new HashSet<String>();
                HashMap<String, String> groupWithTeamMap = new HashMap<String, String>();
                List objectiveGroups = this.baseItemRepository.findByIdIn(groupIds);
                for (BaseItem objGroup : objectiveGroups) {
                    for (BaseItemLink link : objGroup.getBaseItemLinks()) {
                        if (!EnumKendis.SESSION_LINK_OBJECTIVE.getCode().equalsIgnoreCase(link.getLinkType()) || !PropertyValidator.isValid((Object)link.getLinkType())) continue;
                        teamId = link.getTeamId();
                        teamIds.add(teamId);
                        groupWithTeamMap.put(objGroup.getId(), teamId);
                    }
                }
                if (PropertyValidator.isValid(teamIds)) {
                    HashMap<String, Team> teamsMap = new HashMap<String, Team>();
                    List allTeams = this.teamRepository.findByIdIn(new ArrayList(teamIds));
                    for (Team team : allTeams) {
                        teamsMap.put(team.getId(), team);
                    }
                    for (String groupId : itemKeys.keySet()) {
                        teamId = (String)groupWithTeamMap.get(groupId);
                        Team team = (Team)teamsMap.get(teamId);
                        if (!PropertyValidator.isValid((Object)team)) continue;
                        itemTitles.put(groupId, team.getTitle());
                    }
                }
            }
            if (!objectiveIdsList.isEmpty()) {
                BasicDBObject objQuery = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", objectiveIdsList)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lte", (Object)endDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
                BasicDBObject objQueryEarliest = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)new BasicDBObject("$in", objectiveIdsList)), new BasicDBObject("eventTime", (Object)new BasicDBObject("$lt", (Object)startDate).append("$gt", (Object)syncDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
                List mappedObjs = this.timeSeriesUtils.fetchBaseItems((DBObject)objQueryEarliest, baseItemCollection, false, -1);
                mappedObjs.addAll(this.timeSeriesUtils.fetchBaseItems((DBObject)objQuery, baseItemCollection, true, 1));
                if (!unCommittedObjectivesEnabled) {
                    List filteredObjs;
                    HashSet<String> unCommittedObjectives = new HashSet<String>();
                    DBCollection collection = this.mongoTemplate.getCollection("baseItem");
                    List list = objectiveIdsList.stream().map(ObjectId::new).collect(Collectors.toList());
                    BasicDBObject queryObj = new BasicDBObject("_id", (Object)new BasicDBObject("$in", list));
                    DBCursor cursor = collection.find((DBObject)queryObj);
                    while (cursor.hasNext()) {
                        DBObject dbObject = (DBObject)cursor.next();
                        String type = (String)dbObject.get("type");
                        if (!"Objective-Uncommitted".equalsIgnoreCase(type)) continue;
                        ObjectId objectiveId = (ObjectId)dbObject.get("_id");
                        unCommittedObjectives.add(objectiveId.toString());
                    }
                    mappedObjs = filteredObjs = mappedObjs.stream().filter(o -> !unCommittedObjectives.contains(o.getId())).collect(Collectors.toList());
                }
                if ("current".equalsIgnoreCase(criteriaCalculation)) {
                    Map<String, List<BaseItem>> groupedById = mappedObjs.stream().collect(Collectors.groupingBy(BaseEntity::getId));
                    for (List list : groupedById.values()) {
                        BaseItem latestItem = list.stream().max(Comparator.comparing(BaseEntity::getCreatedOn)).orElse(null);
                        if (latestItem == null) continue;
                        String latestCompletionCriteria = latestItem.getCompletionCriteria();
                        for (BaseItem item : list) {
                            item.setCompletionCriteria(latestCompletionCriteria);
                        }
                    }
                }
                ArrayList fields = new ArrayList();
                Map datedObjectivesMap = this.timeSeriesUtils.fetchObjectivesCompleteData(mappedObjs, itemKeys, itemTitles, baseItemCollection, backlogItemCollection, intervalDates, interval, criteriaCalculation, tenant, startDate, endDate, isPiView, fields, isOkrEnabled, excludeItemsData, syncDate, sessionBoardId, sessionId);
                datedObjectivesMap.forEach((key, value) -> {
                    if (null != value && null != datedObjGrpsMap.get(key)) {
                        for (BaseItem item : ((Map)datedObjGrpsMap.get(key)).values()) {
                            for (BaseItemLink link : item.getBaseItemLinks()) {
                                String baseItemId;
                                if (!EnumKendis.CHILD_GROUP_OBJECTIVE.getCode().equalsIgnoreCase(link.getLinkType()) || link.isArchive() || !PropertyValidator.isValid((Object)link.getBaseItemId()) || !value.containsKey(baseItemId = link.getBaseItemId())) continue;
                                BaseItem objective = (BaseItem)value.get(baseItemId);
                                for (BaseItemLink objLink : objective.getBaseItemLinks()) {
                                    if (!EnumKendis.SESSION_LINK_OBJECTIVE.getCode().equalsIgnoreCase(objLink.getLinkType()) && !EnumKendis.ART_LINK_OBJECTIVE.getCode().equalsIgnoreCase(objLink.getLinkType()) || objLink.isArchive()) continue;
                                    item.getBaseItemsMap().put(((BaseItem)value.get(baseItemId)).getId(), value.get(baseItemId));
                                }
                            }
                        }
                    }
                });
            }
            resultMap.put("datedBaseItemsMap", datedObjGrpsMap);
            resultMap.put("itemKeys", itemKeys);
            resultMap.put("itemTitles", itemTitles);
            Date end = new Date();
            LOGGER.info("==================================================");
            LOGGER.info("\t\tProcessing Time : " + (end.getTime() - start.getTime()));
            LOGGER.info("==================================================");
            return resultMap;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            throw ex;
        }
    }

    public Map<String, Object> calculateProgressForOKRs(Map<Date, Map<String, BaseItem>> datedBaseItemMap, String okrSelection, String criteria, String criteriaCalculation, String objCompletionCriteria, boolean isPiView, boolean isOkrEnabled, Map<String, Object> excludeItemsData) throws Exception {
        LOGGER.info("Going to calculate progress for given hierarchy for each interval");
        HashSet<String> allItemIds = new HashSet<String>();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        LinkedHashMap datedProgressMap = new LinkedHashMap();
        for (Map.Entry<Date, Map<String, BaseItem>> baseItem : datedBaseItemMap.entrySet()) {
            Map<String, BaseItem> objGrps = baseItem.getValue();
            Date date = baseItem.getKey();
            HashMap itemProgressMap = new HashMap();
            for (Map.Entry<String, BaseItem> objGrpMapEntry : objGrps.entrySet()) {
                double objGrpProgress;
                allItemIds.add(objGrpMapEntry.getValue().getId());
                Map objMap = objGrpMapEntry.getValue().getBaseItemsMap();
                HashMap<String, Object> objProgressMap = new HashMap<String, Object>();
                String teamId = "";
                for (BaseItemLink baseItemLink : objGrpMapEntry.getValue().getBaseItemLinks()) {
                    if (!EnumKendis.SESSION_LINK_OBJECTIVE.getCode().equalsIgnoreCase(baseItemLink.getLinkType()) || null == baseItemLink.getTeamId()) continue;
                    teamId = baseItemLink.getTeamId();
                    break;
                }
                for (Map.Entry entry : objMap.entrySet()) {
                    BaseItem obj = (BaseItem)entry.getValue();
                    allItemIds.add(obj.getId());
                    Map baseItemProgress = this.calculateObjectiveProgress(obj, allItemIds, objCompletionCriteria, isPiView, teamId, excludeItemsData);
                    objProgressMap.put(obj.getId(), baseItemProgress);
                }
                if (!objMap.isEmpty()) {
                    if (!isPiView || "OBJ_KR_WEIGHTS_FORMULA".equalsIgnoreCase(objCompletionCriteria)) {
                        double done = 0.0;
                        double total = 0.0;
                        for (Map.Entry objProgress : objMap.entrySet()) {
                            String objId = (String)objProgress.getKey();
                            double objWeightage = 1.0;
                            for (BaseItemLink link : objGrpMapEntry.getValue().getBaseItemLinks()) {
                                if (!EnumKendis.CHILD_GROUP_OBJECTIVE.getCode().equalsIgnoreCase(link.getLinkType()) || !objId.equalsIgnoreCase(link.getBaseItemId()) || !PropertyValidator.isValid((Object)link.getWeightage())) continue;
                                objWeightage = link.getWeightage();
                            }
                            if (!(objWeightage > 0.0)) continue;
                            if (!Double.isNaN(((BaseItem)objProgress.getValue()).getProgress())) {
                                done += objWeightage * ((BaseItem)objProgress.getValue()).getProgress();
                            }
                            total += objWeightage;
                        }
                        objGrpProgress = done / total;
                    } else {
                        objGrpProgress = this.calculateObjectiveGroupProgress(objProgressMap);
                    }
                } else {
                    objGrpProgress = 0.0;
                }
                objProgressMap.put("objGrpProgress", (double)Math.round(objGrpProgress * 10.0) / 10.0);
                itemProgressMap.put(objGrpMapEntry.getKey(), objProgressMap);
            }
            datedProgressMap.put(date, itemProgressMap);
        }
        resultMap.put("allItemIds", allItemIds);
        resultMap.put("datedProgressMap", datedProgressMap);
        return resultMap;
    }

    public double calculateObjectiveGroupProgress(Map<String, Object> objProgressMap) throws Exception {
        double done = 0.0;
        double total = 0.0;
        for (Object objProgress : objProgressMap.values()) {
            Map objMap = (Map)objProgress;
            Map objItems = (Map)objMap.get("objProgressMap");
            done += ((Double)objItems.get("totalDone")).doubleValue();
            total += ((Double)objItems.get("totalSize")).doubleValue();
        }
        double objGroupProgress = done / total * 100.0;
        return Double.isNaN(objGroupProgress) ? 0.0 : objGroupProgress;
    }

    public Map<String, Object> calculateObjectiveProgress(BaseItem obj, Set<String> allItemIds, String objCompletionCriteria, boolean isPiView, String teamId, Map<String, Object> excludeItemsData) throws Exception {
        Double progress;
        Map progressMap;
        String id;
        Double weightage;
        LOGGER.debug("Calculating progress for objective with key: {} and id: {} ", (Object)obj.getKey(), (Object)obj.getId());
        HashMap<String, Double> KRWeightageMap = new HashMap<String, Double>();
        HashMap<String, Double> objWeightageMap = new HashMap<String, Double>();
        HashMap<String, Object> objProgress = new HashMap<String, Object>();
        Map KRProgressMap = new HashMap();
        HashMap<String, Map> objLinkedObjs = new HashMap<String, Map>();
        String criteria = isPiView && !"OBJ_KR_WEIGHTS_FORMULA".equalsIgnoreCase(objCompletionCriteria) ? objCompletionCriteria : obj.getCompletionCriteria();
        double linkedItemsProgress = 0.0;
        double totalWeightage = 0.0;
        int linkedItemsCount = 0;
        Double linkedItemsWeightage = 0.0;
        if (!obj.getBacklogItemsMap().isEmpty()) {
            HashSet<String> attachedReleaseTrains = new HashSet<String>();
            for (Object link : obj.getBaseItemLinks()) {
                if (EnumKendis.SESSION_LINK_OBJECTIVE.getCode().equalsIgnoreCase(link.getLinkType())) {
                    isPiView = true;
                }
                if (EnumKendis.BACKLOG_ITEM.getCode().equalsIgnoreCase(link.getLinkType())) {
                    isPiView = false;
                }
                if (!EnumKendis.BACKLOG_ITEM.getCode().equalsIgnoreCase(link.getLinkType())) continue;
                if (PropertyValidator.isValid((Object)link.getReleaseTrainId())) {
                    attachedReleaseTrains.add(link.getReleaseTrainId());
                    continue;
                }
                LOGGER.debug("ReleaseTrainId missing for item with key: {} and id: {} and createdOn :{}", new Object[]{obj.getKey(), obj.getId(), obj.getCreatedOn()});
            }
            Map map = this.calculateBacklogItemsProgress(obj.getBacklogItemsMap(), criteria, teamId, isPiView, attachedReleaseTrains);
            linkedItemsProgress = (Double)map.get("linkedItemsProgress");
            linkedItemsWeightage = obj.getLinkedCardWeights();
            linkedItemsCount = obj.getBacklogItemsMap().size();
            objProgress.put("objProgressMap", map);
            totalWeightage += obj.getLinkedCardWeights().doubleValue();
        } else {
            HashMap<String, Double> objProgressMap = new HashMap<String, Double>();
            objProgressMap.put("totalDone", 0.0);
            objProgressMap.put("totalSize", 0.0);
            objProgress.put("objProgressMap", objProgressMap);
        }
        if (!obj.getBaseItemsMap().isEmpty()) {
            KRProgressMap = this.calculateKeyResultProgress(obj.getBaseItemsMap(), allItemIds, objCompletionCriteria, isPiView, teamId, excludeItemsData);
            HashMap KRProgresses = new HashMap();
            KRProgresses.putAll(KRProgressMap);
            objProgress.put("linkedKRsProgress", KRProgresses);
            List list = obj.getBaseItemLinks();
            for (String itemId : KRProgressMap.keySet()) {
                Double weightage2 = list.stream().filter(l -> itemId.equalsIgnoreCase(l.getBaseItemId())).map(BaseItemLink::getWeightage).findFirst().orElse(0.0);
                totalWeightage += weightage2.doubleValue();
                KRWeightageMap.put(itemId, weightage2);
                allItemIds.add(itemId);
            }
        }
        if (!obj.getObjectivesMap().isEmpty()) {
            for (BaseItem baseItem : obj.getObjectivesMap().values()) {
                allItemIds.add(baseItem.getId());
                List links = obj.getBaseItemLinks();
                weightage = links.stream().filter(l -> linkedObj.getId().equalsIgnoreCase(l.getBaseItemId())).map(BaseItemLink::getWeightage).findFirst().orElse(0.0);
                Map linkedObjProgress = this.calculateObjectiveProgress(baseItem, allItemIds, objCompletionCriteria, isPiView, teamId, excludeItemsData);
                objLinkedObjs.put(baseItem.getId(), linkedObjProgress);
                totalWeightage += weightage.doubleValue();
                objWeightageMap.put(baseItem.getId(), weightage);
            }
            objProgress.put("linkedObjsProgress", objLinkedObjs);
        }
        if (0.0 != linkedItemsProgress) {
            objProgress.put("linkedItemsProgress", (double)Math.round(linkedItemsProgress * 10.0) / 10.0);
        }
        double totalProgress = linkedItemsProgress * linkedItemsWeightage / totalWeightage;
        if (!KRWeightageMap.isEmpty()) {
            for (Map.Entry entry : KRWeightageMap.entrySet()) {
                id = (String)entry.getKey();
                weightage = (Double)entry.getValue();
                progressMap = (Map)KRProgressMap.get(id);
                progress = (Double)progressMap.get("progress");
                totalProgress += progress * weightage / totalWeightage;
            }
        }
        if (!objWeightageMap.isEmpty()) {
            for (Map.Entry entry : objWeightageMap.entrySet()) {
                id = (String)entry.getKey();
                weightage = (Double)entry.getValue();
                progressMap = (Map)objLinkedObjs.get(id);
                progress = (Double)progressMap.get("progress");
                totalProgress += progress * weightage / totalWeightage;
            }
        }
        objProgress.put("progress", (double)Math.round(totalProgress * 10.0) / 10.0);
        objProgress.put("linkedItemsCount", linkedItemsCount);
        obj.setProgress(totalProgress);
        return objProgress;
    }

    public Map<String, Object> getItemsForOKRProgress(Map<String, Object> progressMap, String interval, List<Date> intervalDates, String radioTypeSelection) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map datedProgressMap = (Map)progressMap.get("datedProgressMap");
        ArrayList dates = new ArrayList(datedProgressMap.keySet());
        Set allItemIds = (Set)progressMap.get("allItemIds");
        HashMap<String, ArrayList<Double>> series = new HashMap<String, ArrayList<Double>>();
        for (String itemId : allItemIds) {
            series.put(itemId, new ArrayList<Double>(Collections.nCopies(dates.size(), 0.0)));
        }
        for (int i = 0; i < dates.size(); ++i) {
            Date date = (Date)dates.get(i);
            LOGGER.debug("Calculating progress for date: {}", (Object)date);
            Map dailyProgress = (Map)datedProgressMap.get(date);
            if (null == dailyProgress || dailyProgress.isEmpty()) continue;
            for (Map.Entry objGrpsProgress : dailyProgress.entrySet()) {
                Map objGrpEntry = (Map)objGrpsProgress.getValue();
                double objGrpProgressValue = (Double)objGrpEntry.get("objGrpProgress");
                if (series.containsKey(objGrpsProgress.getKey())) {
                    ((List)series.get(objGrpsProgress.getKey())).set(i, objGrpProgressValue);
                }
                for (String itemId : allItemIds) {
                    if (!objGrpEntry.containsKey(itemId)) continue;
                    Map objEntry = (Map)objGrpEntry.get(itemId);
                    if (objEntry.containsKey("linkedKRsProgress")) {
                        Map linkedKRsProgress = (Map)objEntry.get("linkedKRsProgress");
                        for (Map.Entry linkedKR : linkedKRsProgress.entrySet()) {
                            Map krData = (Map)linkedKR.getValue();
                            if (!krData.containsKey("KRLinkedObjs")) continue;
                            Map KRLinkedObjs = (Map)krData.get("KRLinkedObjs");
                            for (Map.Entry KRLinkedObj : KRLinkedObjs.entrySet()) {
                                Map objData = (Map)KRLinkedObj.getValue();
                                double progress = 0.0;
                                if (PropertyValidator.isValid(objData.get("progress"))) {
                                    progress = (Double)objData.get("progress");
                                }
                                if (!series.containsKey(KRLinkedObj.getKey())) continue;
                                ((List)series.get(KRLinkedObj.getKey())).set(i, progress);
                            }
                        }
                    }
                    if (objEntry.containsKey("linkedObjsProgress")) {
                        this.fetchLinkedObjSeries(objEntry, i, series);
                    }
                    double objProgress = (Double)objEntry.get("progress");
                    ((List)series.get(itemId)).set(i, objProgress);
                }
            }
        }
        result.put("series", series);
        result.put("intervalDates", datedProgressMap.keySet());
        return result;
    }

    private void fetchLinkedObjSeries(Map<String, Object> objEntry, int i, Map<String, List<Double>> series) throws Exception {
        Map linkedObjsProgress = (Map)objEntry.get("linkedObjsProgress");
        for (Map.Entry linkedObj : linkedObjsProgress.entrySet()) {
            Map objData = (Map)linkedObj.getValue();
            double progress = 0.0;
            if (PropertyValidator.isValid(objData.get("progress"))) {
                progress = (Double)objData.get("progress");
            }
            if (series.containsKey(linkedObj.getKey())) {
                series.get(linkedObj.getKey()).set(i, progress);
            }
            if (!objData.containsKey("linkedObjsProgress")) continue;
            this.fetchLinkedObjSeries(objData, i, series);
        }
    }

    public Map<String, Double> calculateBacklogItemsProgress(Map<String, List<BacklogItem>> backlogItemsMap, String criteria, String teamId, boolean isPiView, Set<String> attachedReleaseTrains) throws Exception {
        HashMap<String, Double> backlogItemsProgressMap = new HashMap<String, Double>();
        double baseItemProgress = 0.0;
        double totalDone = 0.0;
        double totalSize = 0.0;
        switch (criteria) {
            case "LINKED_ITEM_STATUS": {
                for (Map.Entry<String, List<BacklogItem>> backlogItemMapEntrySet : backlogItemsMap.entrySet()) {
                    List<BacklogItem> backlogItems = backlogItemMapEntrySet.getValue();
                    for (BacklogItem backlogItem : backlogItems) {
                        if (PropertyValidator.isValid((Object)backlogItem.getStatus()) && EnumStatusCategory.DONE.getCode().equalsIgnoreCase(backlogItem.getStatus().getCategory())) {
                            totalDone += 1.0;
                        }
                        totalSize += 1.0;
                    }
                }
                baseItemProgress = totalDone / totalSize * 100.0;
                break;
            }
            case "CHILDREN_LINKED_ITEM_STATUS": {
                double totalChilds = 0.0;
                if (isPiView) {
                    LOGGER.debug("is Pi obj");
                    ArrayList<String> itemIdsList = new ArrayList<String>();
                    for (List<BacklogItem> backlogItems : backlogItemsMap.values()) {
                        for (BacklogItem backlogItem : backlogItems) {
                            if ("UserStory".equalsIgnoreCase(backlogItem.getAlmType()) && !itemIdsList.contains(backlogItem.getId())) {
                                totalChilds += 1.0;
                                if (PropertyValidator.isValid((Object)backlogItem.getStatus()) && EnumStatusCategory.DONE.getCode().equalsIgnoreCase(backlogItem.getStatus().getCategory())) {
                                    totalDone += 1.0;
                                }
                                itemIdsList.add(backlogItem.getId());
                            }
                            for (List nestedBacklogItems : backlogItem.getBacklogItemsMap().values()) {
                                for (BacklogItem nestedBacklogItem : nestedBacklogItems) {
                                    if (!"UserStory".equalsIgnoreCase(nestedBacklogItem.getAlmType()) || itemIdsList.contains(nestedBacklogItem.getId())) continue;
                                    totalChilds += 1.0;
                                    if (PropertyValidator.isValid((Object)nestedBacklogItem.getStatus()) && EnumStatusCategory.DONE.getCode().equalsIgnoreCase(nestedBacklogItem.getStatus().getCategory())) {
                                        totalDone += 1.0;
                                    }
                                    itemIdsList.add(nestedBacklogItem.getId());
                                }
                            }
                        }
                    }
                } else {
                    LOGGER.debug("is global obj");
                    for (String releaseTrain : attachedReleaseTrains) {
                        LOGGER.debug("Traversing for releaseTrainId: {}", (Object)releaseTrain);
                        ArrayList<String> countedAlmKeys = new ArrayList<String>();
                        for (List<BacklogItem> backlogItems : backlogItemsMap.values()) {
                            for (BacklogItem backlogItem : backlogItems) {
                                if (countedAlmKeys.contains(backlogItem.getAlmKey())) continue;
                                if (!PropertyValidator.isValid((Object)backlogItem.getAlmKey())) {
                                    countedAlmKeys.add(backlogItem.getTitle());
                                } else {
                                    countedAlmKeys.add(backlogItem.getAlmKey());
                                }
                                LOGGER.debug("Traversing backlogitem with almKey: {} and id: {}", (Object)backlogItem.getAlmKey(), (Object)backlogItem.getId());
                                Map featuresMap = backlogItem.getBacklogItemsMap();
                                for (Map.Entry featureEntrySet : featuresMap.entrySet()) {
                                    List stories = (List)featureEntrySet.getValue();
                                    for (BacklogItem story : stories) {
                                        LOGGER.debug("Nested Backlog item with key: {} and id: {} found", (Object)story.getAlmKey(), (Object)story.getId());
                                        int rowStatus = 1;
                                        if (PropertyValidator.isValid((Collection)story.getBaseItemLinks())) {
                                            for (BaseItemLink link : story.getBaseItemLinks()) {
                                                if (!PropertyValidator.isValid((Object)link.getLinkType()) || !PropertyValidator.isValid((Object)link.getReleaseTrainId()) || !EnumKendis.ART_MAIN_LINK.getCode().equalsIgnoreCase(link.getLinkType()) || !releaseTrain.equalsIgnoreCase(link.getReleaseTrainId())) continue;
                                                rowStatus = link.getRowStatus();
                                            }
                                        }
                                        if (rowStatus != 0) continue;
                                        totalChilds += 1.0;
                                        if (!PropertyValidator.isValid((Object)story.getStatus()) || !EnumStatusCategory.DONE.getCode().equalsIgnoreCase(story.getStatus().getCategory())) continue;
                                        LOGGER.debug("Counting backlogitem children with almKey: {} and id: {} as done", (Object)story.getAlmKey(), (Object)story.getId());
                                        totalDone += 1.0;
                                    }
                                }
                            }
                        }
                    }
                }
                baseItemProgress = totalDone / totalChilds * 100.0;
                totalSize = totalChilds;
                break;
            }
            case "CHILDREN_LINKED_ITEM_ESTIMATE": {
                double[] results = new double[]{0.0, 0.0};
                if (isPiView) {
                    ArrayList<String> itemIdsList = new ArrayList<String>();
                    for (List<BacklogItem> backlogItems : backlogItemsMap.values()) {
                        for (BacklogItem backlogItem : backlogItems) {
                            if ("UserStory".equalsIgnoreCase(backlogItem.getAlmType()) && !itemIdsList.contains(backlogItem.getId())) {
                                results[1] = results[1] + backlogItem.getStoryPoints();
                                if (PropertyValidator.isValid((Object)backlogItem.getStatus()) && EnumStatusCategory.DONE.getCode().equalsIgnoreCase(backlogItem.getStatus().getCategory())) {
                                    results[0] = results[0] + backlogItem.getStoryPoints();
                                }
                                itemIdsList.add(backlogItem.getId());
                            }
                            for (List nestedBacklogItems : backlogItem.getBacklogItemsMap().values()) {
                                for (BacklogItem nestedBacklogItem : nestedBacklogItems) {
                                    if (!"UserStory".equalsIgnoreCase(nestedBacklogItem.getAlmType()) || itemIdsList.contains(nestedBacklogItem.getId())) continue;
                                    results[1] = results[1] + nestedBacklogItem.getStoryPoints();
                                    if (PropertyValidator.isValid((Object)nestedBacklogItem.getStatus()) && EnumStatusCategory.DONE.getCode().equalsIgnoreCase(nestedBacklogItem.getStatus().getCategory())) {
                                        results[0] = results[0] + nestedBacklogItem.getStoryPoints();
                                    }
                                    itemIdsList.add(nestedBacklogItem.getId());
                                }
                            }
                        }
                    }
                } else {
                    for (String releaseTrain : attachedReleaseTrains) {
                        LOGGER.debug("Traversing for releaseTrainId: {}", (Object)releaseTrain);
                        ArrayList<String> countedAlmKeys = new ArrayList<String>();
                        for (List<BacklogItem> items : backlogItemsMap.values()) {
                            for (BacklogItem item : items) {
                                if (countedAlmKeys.contains(item.getAlmKey())) continue;
                                if (!PropertyValidator.isValid((Object)item.getAlmKey())) {
                                    countedAlmKeys.add(item.getId());
                                } else {
                                    countedAlmKeys.add(item.getAlmKey());
                                }
                                LOGGER.debug("Traversing backlogitem with almKey: {} and id: {}", (Object)item.getAlmKey(), (Object)item.getId());
                                if (item.getBacklogItemsMap().isEmpty()) continue;
                                for (List nestedBacklogItems : item.getBacklogItemsMap().values()) {
                                    for (BacklogItem nestedBacklogItem : nestedBacklogItems) {
                                        LOGGER.debug("Nested Backlog item with key: {} and id: {} found", (Object)nestedBacklogItem.getAlmKey(), (Object)nestedBacklogItem.getId());
                                        int rowStatus = Optional.ofNullable(nestedBacklogItem).map(i -> i.getBaseItemLinks()).orElse(Collections.emptyList()).stream().filter(l -> l != null && EnumKendis.ART_MAIN_LINK.getCode().equalsIgnoreCase(l.getLinkType()) && releaseTrain.equalsIgnoreCase(l.getReleaseTrainId())).map(BaseEntity::getRowStatus).findFirst().orElse(1);
                                        if (rowStatus != 0) continue;
                                        results[1] = results[1] + nestedBacklogItem.getStoryPoints();
                                        if (!PropertyValidator.isValid((Object)nestedBacklogItem.getStatus()) || !EnumStatusCategory.DONE.getCode().equalsIgnoreCase(nestedBacklogItem.getStatus().getCategory())) continue;
                                        LOGGER.debug("Counting backlogitem children with almKey: {} and id: {} as done", (Object)nestedBacklogItem.getAlmKey(), (Object)nestedBacklogItem.getId());
                                        results[0] = results[0] + nestedBacklogItem.getStoryPoints();
                                    }
                                }
                            }
                        }
                    }
                }
                if (results[1] > 0.0) {
                    baseItemProgress = results[0] / results[1] * 100.0;
                }
                totalDone = results[0];
                totalSize = results[1];
                break;
            }
            case "TEAM_STORY_STATUS": {
                double totalChilds = 0.0;
                ArrayList<String> itemIdsList = new ArrayList<String>();
                for (List<BacklogItem> backlogItems : backlogItemsMap.values()) {
                    for (BacklogItem backlogItem : backlogItems) {
                        for (List nestedBacklogItems : backlogItem.getBacklogItemsMap().values()) {
                            for (BacklogItem nestedBacklogItem : nestedBacklogItems) {
                                if (!"UserStory".equalsIgnoreCase(nestedBacklogItem.getAlmType()) || itemIdsList.contains(nestedBacklogItem.getId()) || null == nestedBacklogItem.getTeamData() || nestedBacklogItem.getTeamData().isEmpty()) continue;
                                for (Team team : nestedBacklogItem.getTeamData()) {
                                    if (!teamId.equalsIgnoreCase(team.getId())) continue;
                                    totalChilds += 1.0;
                                    if (PropertyValidator.isValid((Object)nestedBacklogItem.getStatus()) && EnumStatusCategory.DONE.getCode().equalsIgnoreCase(nestedBacklogItem.getStatus().getCategory())) {
                                        totalDone += 1.0;
                                    }
                                    itemIdsList.add(nestedBacklogItem.getId());
                                }
                            }
                            if (!"UserStory".equalsIgnoreCase(backlogItem.getAlmType()) || itemIdsList.contains(backlogItem.getId()) || null == backlogItem.getTeamData() || backlogItem.getTeamData().isEmpty()) continue;
                            for (Team team : backlogItem.getTeamData()) {
                                if (!teamId.equalsIgnoreCase(team.getId())) continue;
                                totalChilds += 1.0;
                                if (PropertyValidator.isValid((Object)backlogItem.getStatus()) && EnumStatusCategory.DONE.getCode().equalsIgnoreCase(backlogItem.getStatus().getCategory())) {
                                    totalDone += 1.0;
                                }
                                itemIdsList.add(backlogItem.getId());
                            }
                        }
                    }
                }
                baseItemProgress = totalDone / totalChilds * 100.0;
                totalSize = totalChilds;
                break;
            }
            case "TEAM_STORY_ESTIMATE": {
                double totalChilds = 0.0;
                ArrayList<String> itemIdsList = new ArrayList<String>();
                for (List<BacklogItem> backlogItems : backlogItemsMap.values()) {
                    for (BacklogItem backlogItem : backlogItems) {
                        for (List nestedBacklogItems : backlogItem.getBacklogItemsMap().values()) {
                            for (BacklogItem nestedBacklogItem : nestedBacklogItems) {
                                if (!"UserStory".equalsIgnoreCase(nestedBacklogItem.getAlmType()) || itemIdsList.contains(nestedBacklogItem.getId()) || null == nestedBacklogItem.getTeamData() || nestedBacklogItem.getTeamData().isEmpty()) continue;
                                for (Team team : nestedBacklogItem.getTeamData()) {
                                    if (!teamId.equalsIgnoreCase(team.getId())) continue;
                                    totalChilds += nestedBacklogItem.getStoryPoints().doubleValue();
                                    if (PropertyValidator.isValid((Object)nestedBacklogItem.getStatus()) && EnumStatusCategory.DONE.getCode().equalsIgnoreCase(nestedBacklogItem.getStatus().getCategory())) {
                                        totalDone += nestedBacklogItem.getStoryPoints().doubleValue();
                                    }
                                    itemIdsList.add(nestedBacklogItem.getId());
                                }
                            }
                        }
                        if (!"UserStory".equalsIgnoreCase(backlogItem.getAlmType()) || itemIdsList.contains(backlogItem.getId()) || null == backlogItem.getTeamData() || backlogItem.getTeamData().isEmpty()) continue;
                        for (Team team : backlogItem.getTeamData()) {
                            if (!teamId.equalsIgnoreCase(team.getId())) continue;
                            totalChilds += backlogItem.getStoryPoints().doubleValue();
                            if (PropertyValidator.isValid((Object)backlogItem.getStatus()) && EnumStatusCategory.DONE.getCode().equalsIgnoreCase(backlogItem.getStatus().getCategory())) {
                                totalDone += backlogItem.getStoryPoints().doubleValue();
                            }
                            itemIdsList.add(backlogItem.getId());
                        }
                    }
                }
                baseItemProgress = totalDone / totalChilds * 100.0;
                totalSize = totalChilds;
            }
        }
        backlogItemsProgressMap.put("linkedItemsProgress", Double.isNaN(baseItemProgress) ? 0.0 : (double)Math.round(baseItemProgress * 10.0) / 10.0);
        backlogItemsProgressMap.put("totalDone", totalDone);
        backlogItemsProgressMap.put("totalSize", totalSize);
        return backlogItemsProgressMap;
    }

    private Map<String, Object> calculateKeyResultProgress(Map<String, BaseItem> baseItemsMap, Set<String> allItemIds, String objCompletionCriteria, boolean isPiView, String teamId, Map<String, Object> excludeItemsData) throws Exception {
        HashMap<String, Object> KRProgressMap = new HashMap<String, Object>();
        for (Map.Entry<String, BaseItem> item : baseItemsMap.entrySet()) {
            String progressCriteria;
            HashSet<String> attachedReleaseTrains = new HashSet<String>();
            HashMap<String, Serializable> krData = new HashMap<String, Serializable>();
            BaseItem itemObj = item.getValue();
            if (!PropertyValidator.isValid((Object)itemObj.getFields()) || !itemObj.getFields().containsKey("progressCriteria")) continue;
            switch (progressCriteria = (String)itemObj.getFields().get("progressCriteria")) {
                case "By Items": {
                    LOGGER.info("Calculating progress for KR with id: " + itemObj.getId());
                    for (BaseItemLink link : itemObj.getBaseItemLinks()) {
                        if (!EnumKendis.BACKLOG_ITEM.getCode().equalsIgnoreCase(link.getLinkType())) continue;
                        if (PropertyValidator.isValid((Object)link.getReleaseTrainId())) {
                            attachedReleaseTrains.add(link.getReleaseTrainId());
                            continue;
                        }
                        LOGGER.debug("ReleaseTrainId missing for item with key: {} and id: {} and createdOn :{}", new Object[]{itemObj.getKey(), itemObj.getId(), itemObj.getCreatedOn()});
                    }
                    String criteria = itemObj.getCompletionCriteria();
                    Map krProgressMap = this.calculateBacklogItemsProgress(item.getValue().getBacklogItemsMap(), criteria, teamId, isPiView, attachedReleaseTrains);
                    double progress = (Double)krProgressMap.get("linkedItemsProgress");
                    if (PropertyValidator.isValid(krProgressMap.get("totalDone"))) {
                        double totalDone = (Double)krProgressMap.get("totalDone");
                        LOGGER.info("Total Done items against KR: " + totalDone);
                    }
                    if (PropertyValidator.isValid(krProgressMap.get("totalSize"))) {
                        double totalSize = (Double)krProgressMap.get("totalSize");
                        LOGGER.info("Total Linked items against KR: " + totalSize);
                    }
                    krData.put("progress", Double.valueOf((double)Math.round(progress * 10.0) / 10.0));
                    KRProgressMap.put(item.getKey(), krData);
                    break;
                }
                case "Target": {
                    krData.put("progress", Double.valueOf((double)Math.round(itemObj.getProgress() * 10.0) / 10.0));
                    KRProgressMap.put(item.getKey(), krData);
                    break;
                }
                case "By Objectives": {
                    double totalProgress = 0.0;
                    HashMap<String, Map> KRLinkedObjs = new HashMap<String, Map>();
                    if (null != itemObj.getBaseItemsMap().values()) {
                        for (BaseItem obj : itemObj.getBaseItemsMap().values()) {
                            allItemIds.add(obj.getId());
                            Map objProgress = this.calculateObjectiveProgress(obj, allItemIds, objCompletionCriteria, isPiView, teamId, excludeItemsData);
                            if (PropertyValidator.isValid(objProgress.get("progress"))) {
                                double objectiveProgress = (double)Math.round((Double)objProgress.get("progress") * 10.0) / 10.0;
                                totalProgress += objectiveProgress;
                            }
                            KRLinkedObjs.put(obj.getId(), objProgress);
                        }
                        totalProgress /= (double)itemObj.getBaseItemsMap().values().size();
                    }
                    krData.put("progress", Double.valueOf((double)Math.round(totalProgress * 10.0) / 10.0));
                    krData.put("KRLinkedObjs", KRLinkedObjs);
                    KRProgressMap.put(item.getKey(), krData);
                }
            }
        }
        return KRProgressMap;
    }

    public Map<String, Object> getItemsForBatchProgress(String interval, Date startDate, Date endDate, List<Date> intervalDates, boolean includeSubBatches, String batchId, String progressCriteria, String levelSelection, Date syncDate) throws Exception {
        LOGGER.info("Going to build batches n-th level hierarchy with start date :{} and end date :{}", (Object)startDate, (Object)endDate);
        Date start = new Date();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String baseItemCollection = "baseItemTimeSeries";
        String backlogItemCollection = "backlogItemTimeSeries";
        HashMap itemKeys = new HashMap();
        HashMap itemTitles = new HashMap();
        try {
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
            this.timeSeriesUtils = new TimeSeriesUtils(this.mongoTemplate, this.statusRepository);
            startDate = intervalDates.get(0);
            Calendar cal = Calendar.getInstance();
            endDate = intervalDates.get(intervalDates.size() - 1);
            cal.setTime(endDate);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 59);
            endDate = cal.getTime();
            cal.setTime(syncDate);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            syncDate = cal.getTime();
            cal.setTime(startDate);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            startDate = cal.getTime();
            BasicDBObject query = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)batchId), new BasicDBObject("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lte", (Object)endDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("changes.archive", (Object)new BasicDBObject("$ne", (Object)true)), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
            BasicDBObject queryEarliest = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("itemId", (Object)batchId), new BasicDBObject("eventTime", (Object)new BasicDBObject("$lt", (Object)startDate).append("$gt", (Object)syncDate)), new BasicDBObject("meta.tenant", (Object)tenant), new BasicDBObject("changes.archive", (Object)new BasicDBObject("$ne", (Object)true)), new BasicDBObject("staticFields", (Object)new BasicDBObject("$exists", (Object)true))));
            List mappedBatch = this.timeSeriesUtils.fetchBaseItems((DBObject)queryEarliest, baseItemCollection, false, -1);
            mappedBatch.addAll(this.timeSeriesUtils.fetchBaseItems((DBObject)query, baseItemCollection, true, 1));
            if (mappedBatch.isEmpty()) {
                LOGGER.info("No batch found, returning.");
                resultMap.put("errorCase", true);
                return resultMap;
            }
            LOGGER.info("Batch of size: {} found", (Object)mappedBatch.size());
            int level = 1;
            HashSet traversedIds = new HashSet();
            Map datedBatchesMap = this.timeSeriesUtils.fetchBatchesCompleteData(mappedBatch, itemKeys, itemTitles, baseItemCollection, backlogItemCollection, intervalDates, interval, tenant, startDate, endDate, progressCriteria, includeSubBatches, levelSelection, level, syncDate, batchId, traversedIds);
            resultMap.put("datedBatchesMap", datedBatchesMap);
            resultMap.put("itemKeys", itemKeys);
            resultMap.put("itemTitles", itemTitles);
            Date end = new Date();
            LOGGER.info("==================================================");
            LOGGER.info("\t\tProcessing Time : " + (end.getTime() - start.getTime()));
            LOGGER.info("==================================================");
            return resultMap;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            throw ex;
        }
    }

    public Map<String, Object> calculateProgressForBatches(Map<Date, Map<String, BaseItem>> datedBaseItemMap, String progressCriteria, List<Date> intervalDates, boolean includeSubBatches, Set<String> allBatchIds) {
        LOGGER.info("Going to calculate progress for given hierarchy for each interval");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        LinkedHashMap datedProgressMap = new LinkedHashMap();
        List allBatches = this.baseItemRepository.findByIdIn(new ArrayList<String>(allBatchIds));
        HashMap<String, BaseItem> fetchedBatches = new HashMap<String, BaseItem>();
        for (BaseItem batch : allBatches) {
            fetchedBatches.put(batch.getId(), batch);
        }
        for (Date date : intervalDates) {
            Map<String, BaseItem> batches = datedBaseItemMap.get(date);
            Map batchProgressMap = new HashMap();
            if (null != batches && !batches.isEmpty()) {
                for (Map.Entry<String, BaseItem> batchEntry : batches.entrySet()) {
                    batchProgressMap = this.timeSeriesUtils.calculateBatchProgress(batchEntry.getValue(), progressCriteria, includeSubBatches, fetchedBatches);
                    datedProgressMap.put(date, batchProgressMap);
                }
                continue;
            }
            datedProgressMap.put(date, batchProgressMap);
        }
        resultMap.put("allBatchIds", allBatchIds);
        resultMap.put("datedProgressMap", datedProgressMap);
        return resultMap;
    }

    public Map<String, Object> getItemsForRoadMapProgress(String interval, Date startDate, Date endDate, List<Date> intervalDates, Date syncDate, String roadMapId, String progressCriteria, String releaseTrainId, List<String> backlogItemsIds, String itemsSelection, String hierachLevel, String requestId, Map<String, Object> filters, String type, String itemType, String groupBy, String groupValueType, String optionType) throws Exception {
        Date key;
        List fetchedRoadmapSections;
        HashMap<String, String> sectionsInfo;
        Object value;
        ArrayList items;
        Map result;
        LOGGER.info("Going to build roadmap n-th level hierarchy with start date :{} and end date :{}", (Object)startDate, (Object)endDate);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String boardCollection = "board";
        String backlogItemCollection = "backlogItemTimeSeries";
        HashMap<String, String> itemKeys = new HashMap<String, String>();
        HashMap<String, String> itemTitles = new HashMap<String, String>();
        HashMap<String, String> itemColors = new HashMap<String, String>();
        String tenant = UserContextUtil.getUserContext().getLoggedInUser().getTenant();
        this.timeSeriesUtils = new TimeSeriesUtils(this.mongoTemplate, this.statusRepository);
        Calendar cal = Calendar.getInstance();
        cal.setTime(endDate);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 59);
        endDate = cal.getTime();
        cal.setTime(syncDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        syncDate = cal.getTime();
        cal.setTime(startDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        startDate = cal.getTime();
        Board fetchedRoadmap = this.boardRepository.findByIdOrKeyOrderByNameAsc(roadMapId, "");
        if (!PropertyValidator.isValid((Object)fetchedRoadmap)) {
            LOGGER.info("No roadmap found, returning.");
            resultMap.put("errorCase", true);
            return resultMap;
        }
        itemKeys.put(fetchedRoadmap.getId(), fetchedRoadmap.getKey());
        itemTitles.put(fetchedRoadmap.getId(), fetchedRoadmap.getName());
        HashMap<String, Object> fetchBacklogItemsParams = new HashMap<String, Object>();
        fetchBacklogItemsParams.put("hierachLevel", hierachLevel);
        fetchBacklogItemsParams.put("requestId", requestId);
        fetchBacklogItemsParams.put("filter", filters);
        fetchBacklogItemsParams.put("groupBy", groupBy);
        fetchBacklogItemsParams.put("requestId", requestId);
        fetchBacklogItemsParams.put("boardId", roadMapId);
        if ("number".equalsIgnoreCase(groupValueType)) {
            fetchBacklogItemsParams.put("type", "number");
        }
        Map getBacklogItemsIdsWithLevelResponse = this.itemFetchService.getBacklogItemsWithLevel(releaseTrainId, fetchBacklogItemsParams);
        HashMap<String, String> groupWithTitleMap = new HashMap<String, String>();
        HashSet<Object> groupIds = new HashSet<Object>();
        HashMap<String, BacklogGroupItemsInfoDTO> backlogGroupItemsInfo = new HashMap<String, BacklogGroupItemsInfoDTO>();
        if (PropertyValidator.isValid((Object)getBacklogItemsIdsWithLevelResponse) && PropertyValidator.isValid((Object)(result = (Map)getBacklogItemsIdsWithLevelResponse.get("result"))) && PropertyValidator.isValid((Collection)(items = (ArrayList)result.get("items")))) {
            for (Object e : items) {
                List excludeGroupIds;
                DBObject dbObject = (DBObject)e;
                BacklogGroupItemsInfoDTO backlogGroupItemsInfoDTO = new BacklogGroupItemsInfoDTO();
                int count = (Integer)dbObject.get("count");
                DBObject objId = (DBObject)dbObject.get("_id");
                String groupId = "";
                if (PropertyValidator.isValid((Object)objId.get("id")) && objId.get("id") instanceof String && count > 0) {
                    String string = (String)objId.get("id");
                    groupIds.add(string);
                    groupWithTitleMap.put(string, string);
                    groupId = string;
                } else if (PropertyValidator.isValid((Object)objId.get("id")) && objId.get("id") instanceof BasicDBObject && count > 0) {
                    BasicDBObject basicDBObject = (BasicDBObject)objId.get("id");
                    if (basicDBObject.containsKey("displayName")) {
                        String displayName = (String)basicDBObject.get("displayName");
                        groupWithTitleMap.put(displayName, displayName);
                        groupIds.add(displayName);
                        groupId = displayName;
                    } else if (basicDBObject.containsKey("value")) {
                        value = (String)basicDBObject.get("value");
                        groupWithTitleMap.put((String)value, (String)value);
                        groupIds.add(value);
                        groupId = value;
                    }
                } else if (PropertyValidator.isValid((Object)objId.get("id")) && objId.get("id") instanceof Double && count > 0) {
                    String string = ((Double)objId.get("id")).toString();
                    groupWithTitleMap.put(string, string);
                    groupIds.add((Double)objId.get("id"));
                    groupId = string;
                } else if (PropertyValidator.isValid((Object)objId.get("id")) && objId.get("id") instanceof Integer && count > 0) {
                    String string = ((Integer)objId.get("id")).toString();
                    groupWithTitleMap.put(string, string);
                    groupIds.add((Integer)objId.get("id"));
                    groupId = string;
                } else if (PropertyValidator.isValid((Object)objId.get("id")) && objId.get("id") instanceof Boolean && count > 0) {
                    String string = ((Boolean)objId.get("id")).toString();
                    groupWithTitleMap.put(string, string);
                    groupIds.add((Boolean)objId.get("id"));
                    groupId = string;
                } else if (PropertyValidator.isValid((Object)objId.get("id")) && objId.get("id") instanceof BasicDBList && count > 0) {
                    BasicDBList basicDBList = (BasicDBList)objId.get("id");
                    for (Iterator obj : basicDBList) {
                        if (obj instanceof String) {
                            String value3 = (String)((Object)obj);
                            groupWithTitleMap.put(value3, value3);
                            groupIds.add(value3);
                            groupId = value3;
                            continue;
                        }
                        if (!(obj instanceof BasicDBObject)) continue;
                        BasicDBObject basicDBObject = (BasicDBObject)obj;
                        String value4 = "";
                        if (basicDBObject.containsKey("name")) {
                            value4 = (String)basicDBObject.get("name");
                        } else if (basicDBObject.containsKey("value")) {
                            value4 = (String)basicDBObject.get("value");
                        }
                        groupWithTitleMap.put(value4, value4);
                        groupIds.add(value4);
                        groupId = value4;
                    }
                } else {
                    groupIds.add("null");
                    groupId = "null";
                }
                List list = (List)dbObject.get("multiIds");
                if (PropertyValidator.isValid((Collection)list)) {
                    Iterator obj;
                    ArrayList<String> multiGroup = new ArrayList<String>();
                    obj = list.iterator();
                    while (obj.hasNext()) {
                        String multi = (String)obj.next();
                        multiGroup.add(multi);
                    }
                    if ("null".equalsIgnoreCase(groupId)) {
                        multiGroup.add(null);
                    } else {
                        multiGroup.add(groupId);
                    }
                    backlogGroupItemsInfoDTO.setGroupIds(multiGroup);
                }
                if (PropertyValidator.isValid((Collection)(excludeGroupIds = (List)dbObject.get("excludeGroupIds")))) {
                    ArrayList<String> excludeGroups = new ArrayList<String>();
                    for (String exclude : excludeGroupIds) {
                        excludeGroups.add(exclude);
                    }
                    backlogGroupItemsInfoDTO.setExcludeGroupIds(excludeGroups);
                }
                backlogGroupItemsInfo.put(groupId, backlogGroupItemsInfoDTO);
            }
        }
        RTFetchServiceRequestDTO rTFetchServiceRequestDTO = new RTFetchServiceRequestDTO();
        rTFetchServiceRequestDTO.setBoardId(roadMapId);
        rTFetchServiceRequestDTO.setFilter(filters);
        rTFetchServiceRequestDTO.setGroupBy(groupBy);
        rTFetchServiceRequestDTO.setGroupIds(new ArrayList(groupIds));
        rTFetchServiceRequestDTO.setGroupType(groupBy);
        rTFetchServiceRequestDTO.setGroupValueType(groupValueType);
        rTFetchServiceRequestDTO.setHierachLevel(Integer.valueOf(hierachLevel).intValue());
        rTFetchServiceRequestDTO.setReleaseTrainId(releaseTrainId);
        rTFetchServiceRequestDTO.setRequestId(requestId);
        rTFetchServiceRequestDTO.setOptionType(optionType);
        rTFetchServiceRequestDTO.setBacklogGroupItemsInfo(backlogGroupItemsInfo);
        HashMap<Object, List> groupedBacklogItemsMap = new HashMap<Object, List>();
        for (Object e : groupIds) {
            Map itemsResultMap;
            fetchBacklogItemsParams.put("groupId", e);
            Map params = this.itemFetchService.prepareParams(rTFetchServiceRequestDTO, e);
            Map map = this.itemFetchService.fetchGroupItems(rTFetchServiceRequestDTO, e, params);
            if (!PropertyValidator.isValid((Object)map) || !PropertyValidator.isValid((Object)(itemsResultMap = (Map)map.get("result")))) continue;
            List groupItems = (List)itemsResultMap.get("items");
            for (DBObject dBObject : groupItems) {
                String itemId = null;
                if (dBObject.containsField("id")) {
                    itemId = (String)dBObject.get("id");
                } else if (dBObject.containsField("_id")) {
                    itemId = (String)dBObject.get("_id");
                }
                if (!backlogItemsIds.contains(itemId)) {
                    backlogItemsIds.add(itemId);
                }
                groupedBacklogItemsMap.computeIfAbsent(e, l -> new ArrayList()).add(itemId);
            }
        }
        if ("Section".equalsIgnoreCase(groupBy)) {
            groupIds = new HashSet();
            groupIds.add(roadMapId);
        }
        if (!PropertyValidator.isValid((Object)(sectionsInfo = EnumRoadMapGroupHunting.fetchGroupBy((String)groupBy).returnRoadmapSectionInfo(new ArrayList(groupIds), this.mongoTemplate)))) {
            sectionsInfo = groupWithTitleMap;
        }
        ArrayList<RoadmapSection> arrayList = new ArrayList<RoadmapSection>();
        for (Map.Entry entry : sectionsInfo.entrySet()) {
            RoadmapSection roadmapSection = new RoadmapSection();
            roadmapSection.setParentRoadmapId(roadMapId);
            roadmapSection.setName((String)entry.getValue());
            roadmapSection.setId((String)entry.getKey());
            roadmapSection.setCreatedOn(syncDate);
            arrayList.add(roadmapSection);
            itemTitles.put(roadmapSection.getId(), roadmapSection.getName());
            itemKeys.put(roadmapSection.getId(), roadmapSection.getName());
        }
        if (groupIds.contains("null")) {
            RoadmapSection roadmapSection = new RoadmapSection();
            roadmapSection.setParentRoadmapId(roadMapId);
            roadmapSection.setName("No Group");
            roadmapSection.setId("null");
            roadmapSection.setCreatedOn(syncDate);
            arrayList.add(roadmapSection);
            itemTitles.put(roadmapSection.getId(), roadmapSection.getName());
            itemKeys.put(roadmapSection.getId(), roadmapSection.getName());
        }
        if ("null".equalsIgnoreCase(groupBy) && PropertyValidator.isValid((Collection)(fetchedRoadmapSections = this.roadmapSectionRepository.findByParentRoadmapId(roadMapId)))) {
            for (RoadmapSection roadmapSection : fetchedRoadmapSections) {
                if (PropertyValidator.isValid((Object)roadmapSection.getDefaultSection()) && roadmapSection.getDefaultSection().booleanValue()) {
                    itemColors.put("null", roadmapSection.getColor());
                    continue;
                }
                itemColors.put(roadmapSection.getId(), roadmapSection.getColor());
            }
        }
        ArrayList<Board> mappedRoadmaps = new ArrayList<Board>();
        mappedRoadmaps.add(fetchedRoadmap);
        Map map = this.timeSeriesUtils.mapBoardLogsToDates(mappedRoadmaps, intervalDates, interval);
        Map datedRoadmapSectionsMap = this.timeSeriesUtils.mapRoadMapSectionsToDates(arrayList, intervalDates, interval);
        Map datedBacklogItemsMap = this.timeSeriesUtils.fetchRoadmapLinkedBacklogItems(backlogItemsIds, tenant, startDate, endDate, syncDate, intervalDates, interval, releaseTrainId);
        if (null != datedBacklogItemsMap && null != datedRoadmapSectionsMap && PropertyValidator.isValid(sectionsInfo)) {
            for (Map.Entry entry : datedBacklogItemsMap.entrySet()) {
                value = (Map)entry.getValue();
                key = (Date)entry.getKey();
                if (null == value || null == datedBacklogItemsMap.get(key)) continue;
                for (BacklogItem item : ((Map)datedBacklogItemsMap.get(key)).values()) {
                    boolean archive = item.isArchive();
                    Map fields = item.getFields();
                    Map roadMapSectionsEntry = (Map)datedRoadmapSectionsMap.get(key);
                    if (archive) continue;
                    for (Map.Entry groupEntry : groupedBacklogItemsMap.entrySet()) {
                        List groupItems;
                        Object groupIdObj = groupEntry.getKey();
                        String groupId = "";
                        if (groupIdObj instanceof String) {
                            groupId = (String)groupIdObj;
                        } else if (groupIdObj instanceof Double) {
                            groupId = ((Double)groupIdObj).toString();
                        } else if (groupIdObj instanceof Integer) {
                            groupId = ((Integer)groupIdObj).toString();
                        } else if (groupIdObj instanceof Boolean) {
                            groupId = ((Boolean)groupIdObj).toString();
                        }
                        if (!(groupItems = (List)groupEntry.getValue()).contains(item.getId())) continue;
                        if ("planned".equalsIgnoreCase(itemsSelection)) {
                            if (!PropertyValidator.isValid((Object)fields) || !PropertyValidator.isValid(fields.get("StartDate")) || !PropertyValidator.isValid(fields.get("EndDate"))) continue;
                            if (roadMapSectionsEntry.containsKey(groupId)) {
                                ((RoadmapSection)roadMapSectionsEntry.get(groupId)).getBacklogItemMap().computeIfAbsent(item.getId(), l -> new ArrayList()).add(item);
                                continue;
                            }
                            LOGGER.debug("No group found against groupId :{}", (Object)groupId);
                            continue;
                        }
                        if ("unplanned".equalsIgnoreCase(itemsSelection)) {
                            if (PropertyValidator.isValid((Object)fields) && (!PropertyValidator.isValid((Object)fields) || PropertyValidator.isValid(fields.get("StartDate")) || PropertyValidator.isValid(fields.get("EndDate")))) continue;
                            if (roadMapSectionsEntry.containsKey(groupId)) {
                                ((RoadmapSection)roadMapSectionsEntry.get(groupId)).getBacklogItemMap().computeIfAbsent(item.getId(), l -> new ArrayList()).add(item);
                                continue;
                            }
                            LOGGER.debug("No group found against groupId :{}", (Object)groupId);
                            continue;
                        }
                        if (!"all".equalsIgnoreCase(itemsSelection)) continue;
                        if (roadMapSectionsEntry.containsKey(groupId)) {
                            ((RoadmapSection)roadMapSectionsEntry.get(groupId)).getBacklogItemMap().computeIfAbsent(item.getId(), l -> new ArrayList()).add(item);
                            continue;
                        }
                        LOGGER.debug("No group found against groupId :{}", (Object)groupId);
                    }
                }
            }
        }
        if (null != map && null != datedRoadmapSectionsMap) {
            for (Map.Entry entry : map.entrySet()) {
                value = (Map)entry.getValue();
                key = (Date)entry.getKey();
                if (null == value || null == datedRoadmapSectionsMap.get(key)) continue;
                for (RoadmapSection roadmapSection : ((Map)datedRoadmapSectionsMap.get(key)).values()) {
                    String parentRoadMapId = roadmapSection.getParentRoadmapId();
                    if (!value.containsKey(parentRoadMapId) || roadmapSection.getBacklogItemMap().size() <= 0) continue;
                    ((Board)value.get(parentRoadMapId)).getRoadmapSectionMap().put(roadmapSection.getId(), roadmapSection);
                }
            }
        }
        resultMap.put("datedBaseItemsMap", map);
        resultMap.put("itemKeys", itemKeys);
        resultMap.put("itemTitles", itemTitles);
        resultMap.put("itemColors", itemColors);
        return resultMap;
    }

    public Map<String, Object> calculateProgressForRoadMaps(Map<Date, Map<String, Board>> datedRoadmapsMap, String progressCriteria, List<Date> intervalDates, String roadMapId, Set<String> attachedReleaseTrains) throws Exception {
        LOGGER.info("Going to calculate progress for given hierarchy for each interval");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        LinkedHashMap datedProgressMap = new LinkedHashMap();
        for (Date date : intervalDates) {
            Map<String, Board> roadmaps = datedRoadmapsMap.get(date);
            Map roadmapProgressMap = new LinkedHashMap();
            for (Map.Entry<String, Board> roadmapEntry : roadmaps.entrySet()) {
                if (null == roadmaps || roadmaps.isEmpty()) continue;
                roadmapProgressMap = this.timeSeriesUtils.calculateRoadmapProgress(roadmapEntry.getValue(), progressCriteria, attachedReleaseTrains);
            }
            datedProgressMap.put(date, roadmapProgressMap);
        }
        resultMap.put("datedProgressMap", datedProgressMap);
        return resultMap;
    }
}

