/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.repository;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.State;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.repository.StatsServiceDAO;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class StatsServiceDAOImpl
implements StatsServiceDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatsServiceDAOImpl.class);
    @Autowired
    private MongoTemplate mongoTemplate;

    public List<SessionBoard> findSessionBoardsByIdIn(List<ObjectId> sessionBoardIds, String tenant) throws Exception {
        if (!PropertyValidator.isValid(sessionBoardIds)) {
            return new LinkedList<SessionBoard>();
        }
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject().append("_id", (Object)new BasicDBObject("$in", sessionBoardIds)).append("archive", (Object)false).append("tenant", (Object)tenant));
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("objectivesMap", (Object)1).append("teams", (Object)1).append("session", (Object)1).append("state", (Object)1));
        List<DBObject> pipeLine = Arrays.asList(matchStage, projectionStage);
        AggregationOptions options = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(SessionBoard.class));
        LinkedList<SessionBoard> sessionBoards = new LinkedList<SessionBoard>();
        LinkedList sessionIds = new LinkedList();
        LinkedList teamIds = new LinkedList();
        LinkedList stateIds = new LinkedList();
        HashMap sessionMap = new HashMap();
        HashMap teamMap = new HashMap();
        HashMap stateMap = new HashMap();
        try (Cursor cursor = collection.aggregate(pipeLine, options);){
            while (cursor.hasNext()) {
                BasicDBObject dbObject = (BasicDBObject)cursor.next();
                SessionBoard sessionBoard2 = new SessionBoard();
                sessionBoard2.setId(DBUtils.getIdFromDBObject((BasicDBObject)dbObject, (String[])new String[0]));
                this.handleSessionRef(dbObject, sessionIds, sessionBoard2);
                this.handleTeamsRef(dbObject, teamIds, sessionBoard2);
                this.handleStateRef(dbObject, stateIds, sessionBoard2);
                sessionBoards.add(sessionBoard2);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        CompletableFuture<Void> sessionFuture = CompletableFuture.runAsync(() -> this.findSessionsById(sessionMap, sessionIds));
        CompletableFuture<Void> teamFuture = CompletableFuture.runAsync(() -> this.findTeamsById(teamMap, teamIds));
        CompletableFuture<Void> stateFuture = CompletableFuture.runAsync(() -> this.findStatesById(stateMap, stateIds));
        CompletableFuture.allOf(sessionFuture, teamFuture, stateFuture).get();
        sessionBoards.forEach(sessionBoard -> {
            if (sessionBoard.getSession() != null) {
                sessionBoard.setSession((Session)sessionMap.get(sessionBoard.getSession().getId()));
            }
            if (sessionBoard.getTeams() != null) {
                List updatedTeams = sessionBoard.getTeams().stream().map(team -> {
                    Team updatedTeam = (Team)teamMap.get(team.getId());
                    return updatedTeam != null ? updatedTeam : team;
                }).collect(Collectors.toList());
                sessionBoard.setTeams(updatedTeams);
            }
            if (sessionBoard.getState() != null) {
                sessionBoard.setState((State)stateMap.get(sessionBoard.getState().getId()));
            }
        });
        return sessionBoards;
    }

    private void handleTeamsRef(BasicDBObject sessionBoardObj, List<ObjectId> teamIds, SessionBoard sessionBoard) {
        if (!PropertyValidator.isValid((Object)sessionBoardObj.get("teams"))) {
            return;
        }
        List teamRef = (List)sessionBoardObj.get("teams");
        LinkedList teams = new LinkedList();
        teamRef.forEach(teamRefObj -> {
            teamIds.add(new ObjectId(teamRefObj.getId().toString()));
            teams.add(new Team(teamRefObj.getId().toString()));
        });
        sessionBoard.setTeams(teams);
    }

    private void handleSessionRef(BasicDBObject sessionBoardObj, List<ObjectId> sessionIds, SessionBoard sessionBoard) {
        if (!PropertyValidator.isValid((Object)sessionBoardObj.get("session"))) {
            return;
        }
        DBRef sessionRef = (DBRef)sessionBoardObj.get("session");
        sessionIds.add(new ObjectId(sessionRef.getId().toString()));
        sessionBoard.setSession(new Session(sessionRef.getId().toString()));
    }

    private void handleStateRef(BasicDBObject sessionBoardObj, List<ObjectId> stateIds, SessionBoard sessionBoard) {
        if (!PropertyValidator.isValid((Object)sessionBoardObj.get("state"))) {
            return;
        }
        DBRef stateRef = (DBRef)sessionBoardObj.get("state");
        stateIds.add(new ObjectId(stateRef.getId().toString()));
        sessionBoard.setState(new State(stateRef.getId().toString()));
    }

    private void findSessionsById(Map<String, Session> sessionMap, List<ObjectId> sessionIds) {
        DBCollection sessionCollection = this.mongoTemplate.getCollection(KendisUtils.dbName(Session.class));
        BasicDBObject sessionMatch = new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("$in", sessionIds)));
        BasicDBObject projection = new BasicDBObject("$project", (Object)new BasicDBObject("_id", (Object)1).append("loadOldObjectivesView", (Object)1));
        List<DBObject> pipeline = Arrays.asList(sessionMatch, projection);
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor sessionCursor = sessionCollection.aggregate(pipeline, aggregationOptions);){
            while (sessionCursor.hasNext()) {
                BasicDBObject sessionDBObject = (BasicDBObject)sessionCursor.next();
                Session session = new Session(DBUtils.getIdFromDBObject((BasicDBObject)sessionDBObject, (String[])new String[0]));
                session.setLoadOldObjectivesView(Boolean.valueOf(sessionDBObject.getBoolean("loadOldObjectivesView", true)));
                sessionMap.put(session.getId(), session);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
    }

    private void findTeamsById(Map<String, Team> teamMap, List<ObjectId> teamIds) {
        DBCollection teamCollection = this.mongoTemplate.getCollection(KendisUtils.dbName(Team.class));
        BasicDBObject teamMatch = new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("$in", teamIds)));
        BasicDBObject projection = new BasicDBObject("$project", (Object)new BasicDBObject("_id", (Object)1).append("title", (Object)1).append("label", (Object)1).append("color", (Object)1));
        List<DBObject> pipeline = Arrays.asList(teamMatch, projection);
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor teamCursor = teamCollection.aggregate(pipeline, aggregationOptions);){
            while (teamCursor.hasNext()) {
                BasicDBObject teamDBObject = (BasicDBObject)teamCursor.next();
                Team team = new Team(teamDBObject);
                teamMap.put(team.getId(), team);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
    }

    private void findStatesById(Map<String, State> stateMap, List<ObjectId> stateIds) {
        DBCollection stateCollection = this.mongoTemplate.getCollection(KendisUtils.dbName(State.class));
        BasicDBObject stateMatch = new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("$in", stateIds)));
        BasicDBObject projection = new BasicDBObject("$project", (Object)new BasicDBObject("_id", (Object)1).append("title", (Object)1));
        List<DBObject> pipeline = Arrays.asList(stateMatch, projection);
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor stateCursor = stateCollection.aggregate(pipeline, aggregationOptions);){
            while (stateCursor.hasNext()) {
                BasicDBObject stateDBObject = (BasicDBObject)stateCursor.next();
                String id = DBUtils.getIdFromDBObject((BasicDBObject)stateDBObject, (String[])new String[0]);
                State state = new State(id);
                state.setTitle(stateDBObject.getString("title"));
                stateMap.put(state.getId(), state);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
    }
}

