/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.repository;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.repository.BaseItemRepository;
import com.viztrend.safe.persistence.repository.ObjectiveServiceDAO;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.vos.ObjectiveServiceVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class ObjectiveServiceDAOImpl
implements ObjectiveServiceDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectiveServiceDAOImpl.class);
    private final MongoTemplate mongoTemplate;
    private final BaseItemRepository baseItemRepository;
    private final SessionRepository sessionRepository;

    @Autowired
    public ObjectiveServiceDAOImpl(MongoTemplate mongoTemplate, BaseItemRepository baseItemRepository, SessionRepository sessionRepository) {
        this.baseItemRepository = baseItemRepository;
        this.mongoTemplate = mongoTemplate;
        this.sessionRepository = sessionRepository;
    }

    public void loadBaseItemLinksBySessionIdInAndType(List<String> sessionIds, Map<String, List<BaseItemLink>> objectiveAndOkrBaseItemLinks, Map<String, List<BaseItemLink>> baseItemLinks, Map<String, Map<String, BaseItemLink>> groupBaseItemIds) {
        HashMap baseItemLinksMap = new HashMap();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"linkType").in((Collection)Arrays.stream(ObjectiveServiceDAO.defaultLinkTypeCodes).collect(Collectors.toList())));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionId").in(sessionIds));
        List allBaseItemLinks = this.mongoTemplate.find(query, BaseItemLink.class);
        for (BaseItemLink baseItemLink : allBaseItemLinks) {
            if (!baseItemLinksMap.containsKey(baseItemLink.getSessionId())) {
                baseItemLinksMap.put(baseItemLink.getSessionId(), new LinkedList());
            }
            ((List)baseItemLinksMap.get(baseItemLink.getSessionId())).add(baseItemLink);
        }
        for (String sessionId : baseItemLinksMap.keySet()) {
            List baseItemLinksOfSession = (List)baseItemLinksMap.get(sessionId);
            objectiveAndOkrBaseItemLinks.put(sessionId, new LinkedList());
            baseItemLinks.put(sessionId, new LinkedList());
            groupBaseItemIds.put(sessionId, new HashMap());
            for (BaseItemLink baseItemLink : baseItemLinksOfSession) {
                if (PropertyValidator.isValid((Object)baseItemLink) && PropertyValidator.isValid((Object)baseItemLink.getItemId())) {
                    objectiveAndOkrBaseItemLinks.get(sessionId).add(baseItemLink);
                }
                if (PropertyValidator.isValid((Object)baseItemLink.getType()) && baseItemLink.getType().equals("Objective-Group")) {
                    baseItemLinks.get(sessionId).add(baseItemLink);
                }
                groupBaseItemIds.get(sessionId).put(baseItemLink.getId(), baseItemLink);
            }
        }
    }

    public Map<String, List<BaseItem>> findObjectiveGroupListForSessionByBaseItemLinks(Map<String, List<BaseItemLink>> baseItemLinksAgainstSessionId) {
        HashMap<String, List<BaseItem>> baseItemsMap = new HashMap<String, List<BaseItem>>();
        List baseItemLinks = baseItemLinksAgainstSessionId.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        List objectiveGroupList = this.baseItemRepository.findByBaseItemLinksInOrderBySequenceAsc(baseItemLinks);
        Map baseItemLinkIdToBaseItemMap = this.groupBaseItemsByBaseItemLinks(objectiveGroupList);
        for (Map.Entry<String, List<BaseItemLink>> entry : baseItemLinksAgainstSessionId.entrySet()) {
            String sessionId = entry.getKey();
            baseItemsMap.put(sessionId, new LinkedList());
            for (BaseItemLink baseItemLink : entry.getValue()) {
                if (!baseItemLinkIdToBaseItemMap.containsKey(baseItemLink)) continue;
                LinkedList baseItems = new LinkedList((Collection)baseItemLinkIdToBaseItemMap.get(baseItemLink));
                ((List)baseItemsMap.get(sessionId)).addAll(baseItems);
            }
        }
        return baseItemsMap;
    }

    public Map<String, List<BaseItem>> loadBaseItemsForAllSessions(List<ObjectiveServiceVO> objectiveServiceVO, boolean isOkrData) {
        HashMap<String, List<BaseItem>> baseItemsForSession = new HashMap<String, List<BaseItem>>();
        try {
            LinkedList baseItemIds = new LinkedList();
            objectiveServiceVO.forEach(objVo -> baseItemIds.addAll(isOkrData ? objVo.getKeyResultsIds() : objVo.getObjectiveIds()));
            Query query = new Query();
            Sort sort = new Sort(Sort.Direction.ASC, new String[]{"sequence"});
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(baseItemIds)).with(sort);
            List baseItems = this.mongoTemplate.find(query, BaseItem.class);
            Map<String, BaseItem> baseItemMap = baseItems.stream().collect(Collectors.toMap(BaseEntity::getId, b -> b));
            objectiveServiceVO.forEach(objVo -> {
                List objectIds;
                List list = objectIds = isOkrData ? objVo.getKeyResultsIds() : objVo.getObjectiveIds();
                if (PropertyValidator.isValid((Collection)objectIds)) {
                    objectIds.forEach(id -> {
                        String itemId = id.toString();
                        if (baseItemMap.containsKey(itemId)) {
                            BaseItem baseItem = (BaseItem)baseItemMap.get(itemId);
                            baseItemsForSession.computeIfAbsent(objVo.getSessionId(), k -> new LinkedList()).add(baseItem);
                        }
                    });
                }
            });
        }
        catch (Exception exception) {
            LOGGER.error(StringUtils.getTraceString((Throwable)exception));
            throw exception;
        }
        return baseItemsForSession;
    }

    public Map<String, List<Session>> findSessionsByBaseItemLinksOfAllSessions(List<ObjectiveServiceVO> objectiveServiceVOList) {
        HashMap<String, List<Session>> sessionMap = new HashMap<String, List<Session>>();
        HashSet<String> sessionIds = new HashSet<String>();
        for (ObjectiveServiceVO objectiveServiceVO : objectiveServiceVOList) {
            List baseItemLinks = objectiveServiceVO.getObjectiveAndOkrBaseItemLinks();
            if (!PropertyValidator.isValid((Collection)baseItemLinks)) continue;
            for (BaseItemLink baseItemLink : baseItemLinks) {
                if (!PropertyValidator.isValid((Object)baseItemLink.getSessionId())) continue;
                sessionIds.add(baseItemLink.getSessionId());
            }
        }
        List sessions = this.sessionRepository.findByIdIn(new ArrayList(sessionIds));
        Map<String, Session> sessionMapById = sessions.stream().collect(Collectors.toMap(BaseEntity::getId, s -> s));
        objectiveServiceVOList.forEach(objVo -> {
            String sessionId = objVo.getSessionId();
            List baseItemLinks = objVo.getObjectiveAndOkrBaseItemLinks();
            if (PropertyValidator.isValid((Collection)baseItemLinks)) {
                for (BaseItemLink baseItemLink : baseItemLinks) {
                    if (!PropertyValidator.isValid((Object)baseItemLink.getSessionId())) continue;
                    sessionMap.computeIfAbsent(sessionId, k -> new LinkedList()).add(sessionMapById.get(baseItemLink.getSessionId()));
                }
            }
        });
        return sessionMap;
    }

    public Map<String, SessionBoard> findSessionBoardsMapByIdIn(List<String> sessionBoardIds, String tenant) {
        List ids = KendisUtils.getListAsObjectIds(sessionBoardIds);
        HashMap<String, SessionBoard> sessionBoardMap = new HashMap<String, SessionBoard>();
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("$in", (Object)ids)).append("tenant", (Object)tenant).append("archive", (Object)false));
        BasicDBObject projectStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("teams", (Object)1).append("session", (Object)1));
        List<DBObject> pipeline = Arrays.asList(matchStage, projectStage);
        AggregationOptions options = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(SessionBoard.class));
        try (Cursor cursor = collection.aggregate(pipeline, options);){
            while (cursor.hasNext()) {
                BasicDBObject dbObject = (BasicDBObject)cursor.next();
                SessionBoard sessionBoard = new SessionBoard();
                sessionBoard.setId(DBUtils.getIdFromDBObject((BasicDBObject)dbObject, (String[])new String[0]));
                if (PropertyValidator.isValid((Object)dbObject.get("teams"))) {
                    List teamsObj = (List)dbObject.get("teams");
                    LinkedList<Team> teams = new LinkedList<Team>();
                    for (DBRef teamObj : teamsObj) {
                        teams.add(new Team(teamObj.getId().toString()));
                    }
                    sessionBoard.setTeams(teams);
                }
                if (!PropertyValidator.isValid((Object)dbObject.get("session"))) continue;
                DBRef sessionObj = (DBRef)dbObject.get("session");
                String sessionId = sessionObj.getId().toString();
                sessionBoard.setSession(new Session(sessionId));
                sessionBoardMap.put(sessionId, sessionBoard);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return sessionBoardMap;
    }

    private Map<BaseItemLink, Set<BaseItem>> groupBaseItemsByBaseItemLinks(List<BaseItem> baseItems) {
        HashMap<BaseItemLink, Set<BaseItem>> baseItemLinkToBaseItemMap = new HashMap<BaseItemLink, Set<BaseItem>>();
        if (!PropertyValidator.isValid(baseItems)) {
            return baseItemLinkToBaseItemMap;
        }
        for (BaseItem baseItem : baseItems) {
            for (BaseItemLink baseItemLink : baseItem.getBaseItemLinks()) {
                baseItemLinkToBaseItemMap.computeIfAbsent(baseItemLink, k -> new HashSet()).add(baseItem);
            }
        }
        return baseItemLinkToBaseItemMap;
    }
}

