/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.repository;

import com.viztrend.safe.controller.PlanController;
import com.viztrend.safe.persistence.repository.JiraRepository;
import com.viztrend.safe.utils.StringUtils;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component(value="jiraRepository")
public class JiraRepositoryImpl<T>
implements JiraRepository<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlanController.class);
    @Autowired
    private MongoTemplate mongoTemplate;

    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    public void setMongoTemplate(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public void saveItem(Object baseEntity) {
        try {
            this.mongoTemplate.save(baseEntity);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public void deleteItem(Object baseEntity) {
        try {
            this.mongoTemplate.remove(baseEntity);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public void saveAllItems(Collection<? extends Object> baseEntities) {
        try {
            this.mongoTemplate.insertAll(baseEntities);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }
}

