/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity.dto;

import com.viztrend.safe.controller.HealthController;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.dto.LdapUser;
import com.viztrend.safe.persistence.entity.dto.UserContextDTO;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.UserContextUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;

public class SecureUser
extends org.springframework.security.core.userdetails.User {
    private static final long serialVersionUID = 1L;
    private UserContextDTO userContextDTO;
    private Map<?, ?> oauthInfoMap;
    private boolean skipTenant;
    private boolean debug = false;
    private boolean loginWithError = false;
    private String error;
    private Map<String, String> oauthAuthMap = new HashMap();

    public Map<String, String> getOauthAuthMap() {
        return this.oauthAuthMap;
    }

    public void setOauthAuthMap(Map<String, String> oauthAuthMap) {
        this.oauthAuthMap = oauthAuthMap;
    }

    public SecureUser(String username, String password) {
        super(username, password, true, true, true, true, (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ADMIN", "ACTUATOR"}));
    }

    public SecureUser(String username, String password, boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, Collection<? extends GrantedAuthority> authorities) {
        super(username, password, enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities);
    }

    public UserContextDTO getUserContextDTO() {
        return this.userContextDTO;
    }

    public void setUserContextDTO(UserContextDTO userContextDTO) {
        this.userContextDTO = userContextDTO;
    }

    public Map<?, ?> getOauthInfoMap() {
        return this.oauthInfoMap;
    }

    public void setOauthInfoMap(Map<?, ?> oauthInfoMap) {
        this.oauthInfoMap = oauthInfoMap;
    }

    public String getCurrentCompanyId() {
        Company currentCompany = this.getCurrentCompany();
        if (PropertyValidator.isValid((Object)currentCompany)) {
            return currentCompany.getId();
        }
        return null;
    }

    public Company getCurrentCompany() {
        SecureUser secureUser = UserContextUtil.getUserContext();
        if (secureUser != null && PropertyValidator.isValid((Object)secureUser.getUserContextDTO()) && PropertyValidator.isValid((Object)secureUser.getUserContextDTO().getContextMap())) {
            List companies = (List)secureUser.getUserContextDTO().getContextMap().get("companies");
            Object currentTenant = secureUser.getUserContextDTO().getContextMap().get("tenant");
            if (PropertyValidator.isValid(currentTenant)) {
                String currentTenantStr = currentTenant.toString();
                for (Company company : companies) {
                    if (!company.getTenant().equals(currentTenantStr)) continue;
                    return company;
                }
            } else {
                return (Company)companies.get(0);
            }
        }
        return null;
    }

    public String getCurrentCompanyPrefix() {
        return this.getCurrentCompany().getUrlPrefix();
    }

    public String getMfaCodeSec() {
        return ((User)UserContextUtil.getUserContext().getUserContextDTO().getContextMap().get("user")).getMfaCodeSec();
    }

    public String getAccessUrl() {
        SecureUser secureUser = UserContextUtil.getUserContext();
        String urlScheme = secureUser.getUserContextDTO().getContextMap().get("urlScheme").toString();
        String serverDomain = secureUser.getUserContextDTO().getContextMap().get("serverDomain").toString();
        return urlScheme + "://" + this.getCurrentCompany().getUrlPrefix() + "." + serverDomain;
    }

    public LdapUser getldapUser() {
        SecureUser secureUser = UserContextUtil.getUserContext();
        return (LdapUser)secureUser.getUserContextDTO().getContextMap().get("ldapUser");
    }

    public User getLoggedInUser() {
        SecureUser secureUser;
        if (UserContextUtil.getUserContext() != null && (secureUser = UserContextUtil.getUserContext()).getUserContextDTO() != null && secureUser.getUserContextDTO().getContextMap() != null) {
            User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            loggedInUser.setTenant(String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant")));
            return loggedInUser;
        }
        return null;
    }

    public boolean isLocalDeployment() {
        SecureUser secureUser = UserContextUtil.getUserContext();
        String isLocalDeployment = secureUser.getUserContextDTO().getContextMap().get("isLocalDeployment").toString();
        return isLocalDeployment.equals("true");
    }

    public boolean isSkipTenant() {
        return this.skipTenant;
    }

    public void setSkipTenant(boolean skipTenant) {
        this.skipTenant = skipTenant;
    }

    public boolean isDebug() {
        return HealthController.isDebug();
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isLoginWithError() {
        return this.loginWithError;
    }

    public void setLoginWithError(boolean loginWithError) {
        this.loginWithError = loginWithError;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }
}

