/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.utils.PropertyValidator;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class TimeSeriesDTO
extends BaseEntity {
    private Map<String, String> chartOptions;
    private Map<String, List<String>> queryDataIds;
    private Date startDate;
    private Date endDate;
    private String tenant;
    private List<Integer> dateSortedItemCounts;
    private Map<String, Integer> itemCountForDuration;
    private String itemId;
    private List<Long> startToEndDurationInDays;
    private List<Date> startStatusTime;
    private List<Date> endStatusTime;
    private Map<String, String> statusMap;

    public TimeSeriesDTO() {
    }

    public TimeSeriesDTO(TimeSeriesDTO item) {
        this.itemId = item.itemId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public Map<String, String> getChartOptions() {
        return this.chartOptions;
    }

    public void setChartOptions(Map<String, String> chartOptions) {
        this.chartOptions = chartOptions;
    }

    public Map<String, List<String>> getQueryDataIds() {
        return this.queryDataIds;
    }

    public void setQueryDataIds(Map<String, List<String>> queryDataIds) {
        this.queryDataIds = queryDataIds;
    }

    public void addStartToEndDurationInDays(LocalDateTime startDate, LocalDateTime endDate) {
        if (!PropertyValidator.isValid((Collection)this.startToEndDurationInDays)) {
            this.startToEndDurationInDays = new ArrayList();
        }
        long daysUntilInterval = ChronoUnit.DAYS.between(startDate, endDate);
        this.startToEndDurationInDays.add(daysUntilInterval);
    }

    public List<Integer> getDateSortedItemCounts() {
        return this.dateSortedItemCounts;
    }

    public void setDateSortedItemCounts(List<Integer> dateSortedItemCounts) {
        this.dateSortedItemCounts = dateSortedItemCounts;
    }

    public Map<String, Integer> getItemCountForDuration() {
        return this.itemCountForDuration;
    }

    public void setItemCountForDuration(Map<String, Integer> itemCountForDuration) {
        this.itemCountForDuration = itemCountForDuration;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public List<Long> getStartToEndDurationInDays() {
        return this.startToEndDurationInDays;
    }

    public void setStartToEndDurationInDays(List<Long> startToEndDurationInDays) {
        this.startToEndDurationInDays = startToEndDurationInDays;
    }

    public List<Date> getStartStatusTime() {
        return this.startStatusTime;
    }

    public void setStartStatusTime(List<Date> startStatusTime) {
        this.startStatusTime = startStatusTime;
    }

    public List<Date> getEndStatusTime() {
        return this.endStatusTime;
    }

    public void setEndStatusTime(List<Date> endStatusTime) {
        this.endStatusTime = endStatusTime;
    }

    public Map<String, String> getStatusMap() {
        return this.statusMap;
    }

    public void setStatusMap(Map<String, String> statusMap) {
        this.statusMap = statusMap;
    }
}

