/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.viztrend.safe.annotations.GenerateFieldlog;
import com.viztrend.safe.annotations.PushField;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Team;
import java.util.HashMap;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.DBRef;

public class TeamContainer
extends BaseEntity {
    @PushField
    @GenerateFieldlog
    @DBRef(lazy=true)
    private Team team;
    @PushField
    @GenerateFieldlog
    @DBRef(lazy=true)
    private Container container;
    private Double sequence = new Double(System.nanoTime() / 100000L);
    @Transient
    private Boolean isActive = false;
    @Transient
    private Boolean reviewMode = false;
    @Transient
    private String fid;
    private String sessionBoardId;

    public TeamContainer() {
    }

    public TeamContainer(String id) {
        super(id);
    }

    public TeamContainer(String id, Team team, Container container) {
        Container minContainer;
        Team minTeam;
        this.id = id;
        this.team = minTeam = new Team(team.getId());
        this.container = minContainer = new Container(container.getId());
    }

    public TeamContainer(Team team, Container container) {
        this.team = team;
        this.container = container;
    }

    public TeamContainer(String id, Team team, Container container, Double sequence, String originItemId, String duplicateOf) {
        super(id);
        this.team = new Team(team.getId(), team.getTitle(), team.getOriginItemId(), team.getDuplicateOfId());
        this.container = new Container(container.getId(), container.getTitle(), container.getSequence(), container.getOriginItemId(), container.getDuplicateOfId());
        this.sequence = sequence;
        this.setOriginItemId(originItemId);
        this.setDuplicateOfId(duplicateOf);
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public Double getSequence() {
        return this.sequence;
    }

    public void setSequence(Double sequence) {
        this.sequence = sequence;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TeamContainer other = (TeamContainer)obj;
        return this.getId() == null || other.getId() == null || this.getId().equals(other.getId());
    }

    public HashMap<String, ? super Object> toSimpleObject() {
        HashMap<String, Object> rowData = new HashMap<String, Object>();
        rowData.put("id", this.id);
        rowData.put("team", this.team.toSimpleObject());
        rowData.put("container", this.container.toSimpleObject());
        return rowData;
    }

    public String getFid() {
        return this.fid;
    }

    public void setFid(String fid) {
        this.fid = fid;
    }

    public Boolean getReviewMode() {
        return this.reviewMode;
    }

    public void setReviewMode(Boolean reviewMode) {
        this.reviewMode = reviewMode;
    }

    public String getSessionBoardId() {
        return this.sessionBoardId;
    }

    public void setSessionBoardId(String sessionBoardId) {
        this.sessionBoardId = sessionBoardId;
    }
}

