/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.mongodb.BasicDBObject;
import com.viztrend.safe.alm.jira.bo.JiraSprint;
import com.viztrend.safe.alm.jira.bo.JiraVersion;
import com.viztrend.safe.annotations.PushField;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.Sprint;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.utils.DBUtils;
import java.util.HashMap;
import java.util.List;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.DBRef;

public class Team
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @Transient
    private String action;
    @PushField
    private String title;
    private String label;
    private String color;
    private String boardId;
    private String projectId;
    private String issueTypeId;
    private boolean syncedFlag;
    @Transient
    private boolean deleteFromSystem;
    private Double sequence = new Double(System.nanoTime() / 100000L);
    @DBRef(lazy=false)
    private List<WorkSpace> workSpaces;
    @Transient
    private List<Sprint> sprints;
    @Transient
    private List<JiraSprint> jiraSprints;
    @Transient
    private List<JiraVersion> jiraVersions;
    @Transient
    private String tempId;

    public Team() {
    }

    public Team(String id) {
        super(id);
    }

    public Team(String id, String title) {
        super(id);
        this.title = title;
    }

    public Team(BasicDBObject teamObj) {
        this.id = DBUtils.getIdFromDBObject((BasicDBObject)teamObj, (String[])new String[0]);
        this.title = teamObj.getString("title");
        this.label = teamObj.getString("label");
        this.color = teamObj.getString("color");
        this.boardId = teamObj.getString("boardId");
        this.projectId = teamObj.getString("projectId");
        this.issueTypeId = teamObj.getString("issueTypeId");
    }

    public Team(String id, String title, String originItemId, String duplicateOf) {
        this.id = id;
        this.title = title;
        this.setOriginItemId(originItemId);
        this.setDuplicateOfId(duplicateOf);
    }

    public Team(String id, String title, String color, String originItemId, String duplicateOf) {
        this.id = id;
        this.title = title;
        this.color = color;
        this.setOriginItemId(originItemId);
        this.setDuplicateOfId(duplicateOf);
    }

    public Team(String id, String title, String color, String label, String originItemId, String duplicateOf) {
        this.id = id;
        this.title = title;
        this.color = color;
        this.label = label;
        this.setOriginItemId(originItemId);
        this.setDuplicateOfId(duplicateOf);
    }

    public String getTitle() {
        return this.title;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBoardId() {
        return this.boardId;
    }

    public void setBoardId(String boardId) {
        this.boardId = boardId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getIssueTypeId() {
        return this.issueTypeId;
    }

    public void setIssueTypeId(String issueTypeId) {
        this.issueTypeId = issueTypeId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Team [");
        if (this.title != null) {
            builder.append("title=");
            builder.append(this.title);
            builder.append(", ");
        }
        if (this.id != null) {
            builder.append("id=");
            builder.append(this.id);
        }
        if (this.tempId != null) {
            builder.append("tempId=");
            builder.append(this.tempId);
            builder.append(", ");
        }
        if (this.label != null) {
            builder.append("label=");
            builder.append(this.label);
            builder.append(", ");
        }
        if (this.boardId != null) {
            builder.append("boardId=");
            builder.append(this.boardId);
            builder.append(", ");
        }
        if (this.projectId != null) {
            builder.append("projectId=");
            builder.append(this.projectId);
            builder.append(", ");
        }
        if (this.issueTypeId != null) {
            builder.append("issueTypeId=");
            builder.append(this.issueTypeId);
            builder.append(", ");
        }
        if (this.sprints != null) {
            builder.append("sprints=");
            builder.append(this.sprints);
            builder.append(", ");
        }
        if (this.jiraSprints != null) {
            builder.append("jiraSprints=");
            builder.append(this.jiraSprints);
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    public List<Sprint> getSprints() {
        return this.sprints;
    }

    public void setSprints(List<Sprint> sprints) {
        this.sprints = sprints;
    }

    public String getTempId() {
        return this.tempId;
    }

    public void setTempId(String tempId) {
        this.tempId = tempId;
    }

    public List<JiraSprint> getJiraSprints() {
        return this.jiraSprints;
    }

    public void setJiraSprints(List<JiraSprint> jiraSprints) {
        this.jiraSprints = jiraSprints;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Team)) {
            return false;
        }
        Team other = (Team)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public HashMap<String, ? super Object> toSimpleObject() {
        HashMap<String, String> rowData = new HashMap<String, String>();
        rowData.put("id", this.id);
        rowData.put("title", this.title);
        rowData.put("label", this.label);
        rowData.put("color", this.color);
        return rowData;
    }

    public List<JiraVersion> getJiraVersions() {
        return this.jiraVersions;
    }

    public void setJiraVersions(List<JiraVersion> jiraVersions) {
        this.jiraVersions = jiraVersions;
    }

    public boolean isSyncedFlag() {
        return this.syncedFlag;
    }

    public void setSyncedFlag(boolean syncedFlag) {
        this.syncedFlag = syncedFlag;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Double getSequence() {
        return this.sequence;
    }

    public void setSequence(Double sequence) {
        this.sequence = sequence;
    }

    public List<WorkSpace> getWorkSpaces() {
        return this.workSpaces;
    }

    public void setWorkSpaces(List<WorkSpace> workSpaces) {
        this.workSpaces = workSpaces;
    }

    public boolean getDeleteFromSystem() {
        return this.deleteFromSystem;
    }

    public void setDeleteFromSystem(boolean deleteFromSystem) {
        this.deleteFromSystem = deleteFromSystem;
    }
}

