/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.viztrend.safe.alm.entity.ALMFilter;
import com.viztrend.safe.annotations.GenerateLog;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.RiskRegister;
import com.viztrend.safe.persistence.entity.ScoreCard;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.SolutionAlmSettings;
import com.viztrend.safe.persistence.entity.SolutionArea;
import com.viztrend.safe.persistence.entity.SolutionBoardWsjFAlmConfiguration;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.utils.PropertyValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.DBRef;

@GenerateLog
public class SolutionBoard
extends BaseEntity {
    private String title;
    private String prefix;
    private String prefixColor;
    private String type;
    private String parentItem = "Capability";
    private String childItem = "Feature";
    private Boolean okrEnabled = Boolean.FALSE;
    private Boolean uncommittedObjEnabled = Boolean.TRUE;
    private String parentItemColor;
    private String childItemColor;
    private String parentItemTextColor;
    private String childItemTextColor;
    private ArrayList<String> piSessions;
    private ArrayList<HashMap<String, String>> piBoards;
    private List<String> tfsProjects;
    private List<String> jiraProjects;
    private Boolean wsjfEnabled = Boolean.FALSE;
    private List<SolutionBoardWsjFAlmConfiguration> SolutionBoardWsjFAlmConfiguration;
    @Transient
    private List<SessionBoard> piSessionBoards;
    private List<ALMFilter> almFilters;
    @DBRef
    private WorkSpace workSpace;
    @DBRef
    private SolutionArea solutionArea;
    @DBRef
    private ScoreCard scoreCard;
    @DBRef
    private WorkFlow dependencyWorkFlow;
    private String lineArrowDirection;
    private ArrayList<SolutionAlmSettings> solutionAlmSettings;
    private String epicSchemeId;
    @DBRef
    private List<RiskRegister> riskRegisters;
    private List<String> favouriteForUsers = new ArrayList();
    @Transient
    private boolean favouriteForCuurrentUser = false;

    public SolutionBoard() {
    }

    public SolutionBoard(String id) {
        super(id);
    }

    public void copy(SolutionBoard solutionBoard) {
        if (PropertyValidator.isValid((Object)solutionBoard.title)) {
            this.title = solutionBoard.title;
        }
        if (PropertyValidator.isValid((Object)solutionBoard.type)) {
            this.type = solutionBoard.type;
        }
        if (PropertyValidator.isValid((Object)solutionBoard.prefix)) {
            this.prefix = solutionBoard.prefix;
        }
        if (PropertyValidator.isValid((Object)solutionBoard.prefixColor)) {
            this.prefixColor = solutionBoard.prefixColor;
        }
        if (PropertyValidator.isValid((Object)solutionBoard.parentItem)) {
            this.parentItem = solutionBoard.parentItem;
        }
        if (PropertyValidator.isValid((Object)solutionBoard.parentItem)) {
            this.parentItem = solutionBoard.parentItem;
        }
        if (PropertyValidator.isValid((Object)solutionBoard.childItem)) {
            this.childItem = solutionBoard.childItem;
        }
        if (PropertyValidator.isValid((Object)solutionBoard.parentItemColor)) {
            this.parentItemColor = solutionBoard.parentItemColor;
        }
        if (PropertyValidator.isValid((Object)solutionBoard.childItemColor)) {
            this.childItemColor = solutionBoard.childItemColor;
        }
        if (PropertyValidator.isValid((Object)solutionBoard.parentItemTextColor)) {
            this.parentItemTextColor = solutionBoard.parentItemTextColor;
        }
        if (PropertyValidator.isValid((Object)solutionBoard.childItemTextColor)) {
            this.childItemTextColor = solutionBoard.childItemTextColor;
        }
        if (PropertyValidator.isValid((Collection)solutionBoard.piSessions)) {
            this.piSessions = solutionBoard.piSessions;
        }
        if (PropertyValidator.isValid((Collection)solutionBoard.piBoards)) {
            this.piBoards = solutionBoard.piBoards;
        }
        if (PropertyValidator.isValid((Collection)solutionBoard.tfsProjects)) {
            this.tfsProjects = solutionBoard.tfsProjects;
        }
        if (PropertyValidator.isValid((Collection)solutionBoard.jiraProjects)) {
            this.jiraProjects = solutionBoard.jiraProjects;
        }
        if (PropertyValidator.isValid((Collection)solutionBoard.piSessionBoards)) {
            this.piSessionBoards = solutionBoard.piSessionBoards;
        }
        if (PropertyValidator.isValid((Collection)solutionBoard.almFilters)) {
            this.almFilters = solutionBoard.almFilters;
        }
        if (PropertyValidator.isValid((Object)solutionBoard.workSpace)) {
            this.workSpace = solutionBoard.workSpace;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public WorkSpace getWorkSpace() {
        return this.workSpace;
    }

    public void setWorkSpace(WorkSpace workSpace) {
        this.workSpace = workSpace;
    }

    public ArrayList<String> getPiSessions() {
        return this.piSessions;
    }

    public void setPiSessions(ArrayList<String> piSessions) {
        this.piSessions = piSessions;
    }

    public List<SessionBoard> getPiSessionBoards() {
        return this.piSessionBoards;
    }

    public void setPiSessionBoards(List<SessionBoard> piSessionsBoards) {
        this.piSessionBoards = piSessionsBoards;
    }

    public List<String> getTfsProjects() {
        return this.tfsProjects;
    }

    public void setTfsProjects(List<String> tfsProjects) {
        this.tfsProjects = tfsProjects;
    }

    public List<String> getJiraProjects() {
        return this.jiraProjects;
    }

    public void setJiraProjects(List<String> jiraProjects) {
        this.jiraProjects = jiraProjects;
    }

    public List<ALMFilter> getAlmFilters() {
        return this.almFilters;
    }

    public void setAlmFilters(List<ALMFilter> almFilters) {
        this.almFilters = almFilters;
    }

    public ArrayList<HashMap<String, String>> getPiBoards() {
        return this.piBoards;
    }

    public void setPiBoards(ArrayList<HashMap<String, String>> piBoards) {
        this.piBoards = piBoards;
    }

    public String getParentItem() {
        return this.parentItem;
    }

    public void setParentItem(String parentItem) {
        this.parentItem = parentItem;
    }

    public String getChildItem() {
        return this.childItem;
    }

    public void setChildItem(String childItem) {
        this.childItem = childItem;
    }

    public String getParentItemColor() {
        return this.parentItemColor;
    }

    public void setParentItemColor(String parentItemColor) {
        this.parentItemColor = parentItemColor;
    }

    public String getChildItemColor() {
        return this.childItemColor;
    }

    public void setChildItemColor(String childItemColor) {
        this.childItemColor = childItemColor;
    }

    public String getParentItemTextColor() {
        return this.parentItemTextColor;
    }

    public void setParentItemTextColor(String parentItemTextColor) {
        this.parentItemTextColor = parentItemTextColor;
    }

    public String getChildItemTextColor() {
        return this.childItemTextColor;
    }

    public void setChildItemTextColor(String childItemTextColor) {
        this.childItemTextColor = childItemTextColor;
    }

    public ArrayList<SolutionAlmSettings> getSolutionAlmSettings() {
        return this.solutionAlmSettings;
    }

    public void setSolutionAlmSettings(ArrayList<SolutionAlmSettings> solutionAlmSettings) {
        this.solutionAlmSettings = solutionAlmSettings;
    }

    public Boolean getWsjfEnabled() {
        return this.wsjfEnabled;
    }

    public void setWsjfEnabled(Boolean wsjfEnabled) {
        this.wsjfEnabled = wsjfEnabled;
    }

    public List<SolutionBoardWsjFAlmConfiguration> getSolutionBoardWsjFAlmConfiguration() {
        return this.SolutionBoardWsjFAlmConfiguration;
    }

    public void setSolutionBoardWsjFAlmConfiguration(List<SolutionBoardWsjFAlmConfiguration> solutionBoardWsjFAlmConfiguration) {
        this.SolutionBoardWsjFAlmConfiguration = solutionBoardWsjFAlmConfiguration;
    }

    public ScoreCard getScoreCard() {
        return this.scoreCard;
    }

    public void setScoreCard(ScoreCard scoreCard) {
        this.scoreCard = scoreCard;
    }

    public String getEpicSchemeId() {
        return this.epicSchemeId;
    }

    public void setEpicSchemeId(String epicSchemeId) {
        this.epicSchemeId = epicSchemeId;
    }

    public WorkFlow getDependencyWorkFlow() {
        return this.dependencyWorkFlow;
    }

    public void setDependencyWorkFlow(WorkFlow dependencyWorkFlow) {
        this.dependencyWorkFlow = dependencyWorkFlow;
    }

    public Boolean getOkrEnabled() {
        return this.okrEnabled;
    }

    public void setOkrEnabled(Boolean okrEnabled) {
        this.okrEnabled = okrEnabled;
    }

    public Boolean getUncommittedObjEnabled() {
        return this.uncommittedObjEnabled;
    }

    public void setUncommittedObjEnabled(Boolean uncommittedObjEnabled) {
        this.uncommittedObjEnabled = uncommittedObjEnabled;
    }

    public String getLineArrowDirection() {
        return this.lineArrowDirection;
    }

    public void setLineArrowDirection(String lineArrowDirection) {
        this.lineArrowDirection = lineArrowDirection;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefixColor() {
        return this.prefixColor;
    }

    public void setPrefixColor(String prefixColor) {
        this.prefixColor = prefixColor;
    }

    public List<RiskRegister> getRiskRegisters() {
        return this.riskRegisters;
    }

    public void setRiskRegisters(List<RiskRegister> riskRegisters) {
        this.riskRegisters = riskRegisters;
    }

    public SolutionArea getSolutionArea() {
        return this.solutionArea;
    }

    public void setSolutionArea(SolutionArea solutionArea) {
        this.solutionArea = solutionArea;
    }

    public List<String> getFavouriteForUsers() {
        return this.favouriteForUsers;
    }

    public void setFavouriteForUsers(List<String> favouriteForUsers) {
        this.favouriteForUsers = favouriteForUsers;
    }

    public boolean isFavouriteForCuurrentUser() {
        return this.favouriteForCuurrentUser;
    }

    public void setFavouriteForCuurrentUser(boolean favouriteForCuurrentUser) {
        this.favouriteForCuurrentUser = favouriteForCuurrentUser;
    }
}

