/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.viztrend.safe.annotations.PushField;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.PiSite;
import com.viztrend.safe.persistence.entity.SOSDateTime;
import com.viztrend.safe.persistence.entity.Scrum;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.DBRef;

public class ScrumOfScrums
extends BaseEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScrumOfScrums.class);
    private static final long serialVersionUID = 5149770426329400467L;
    @PushField
    private Integer rangeType = 2;
    @PushField
    private Integer frequency = 1;
    @PushField
    private Date finalDate;
    @PushField
    private Date startDate;
    @PushField
    private Date endDate;
    @PushField
    private Long startDateMillis;
    @PushField
    private Long endDateMillis;
    @PushField
    private Long closeDateMillis;
    @PushField
    private Long reminderMillis;
    @PushField
    private Date endedOn;
    @PushField
    private Date lockedOn;
    @PushField
    private boolean isUpdated = Boolean.FALSE;
    @PushField
    private Set<String> remainderList;
    @PushField
    private Date selectedDayDate;
    @PushField
    private boolean autoCloseSOS;
    @PushField
    private Long timeDiff;
    @PushField
    private Long timeDiffDayEnd;
    @PushField
    private String cid;
    @PushField
    private String sessionId;
    @DBRef
    @PushField
    private List<Scrum> scrums;
    @DBRef
    @PushField
    private WorkFlow impedimentWorkFlow;
    @DBRef
    @PushField
    private WorkFlow actionPointWorkFlow;
    @DBRef
    @PushField
    private WorkFlow severityWorkFlow;
    @PushField
    private String freezedSosStatId;
    @PushField
    private Object roomLink;
    @PushField
    private Object activeRoomLink;
    @PushField
    private String timeZoneName;
    @PushField
    private Object progressType;
    @PushField
    private List<SOSDateTime> furtureSosList;
    @PushField
    private HashMap<String, Object> emailConfiguration;
    @PushField
    private HashMap<String, Object> selectedDays;
    @PushField
    private int topImpedimentCount = 3;
    @PushField
    private int reminderMinutes = 30;
    @DBRef
    @PushField
    private List<PiSite> sites;
    @PushField
    private String allTeamLabel;
    @Transient
    private String freezAnalyticsData;
    @Transient
    private Date clientStartDate;
    @Transient
    private Date clientEndDate;
    @Transient
    private Long clientTimeOffset;
    @Transient
    private String localZone;
    private Boolean reminderSent = false;

    public ScrumOfScrums() {
    }

    public ScrumOfScrums(String id) {
        super(id);
    }

    public ScrumOfScrums(Integer rangeType, Integer frequency, Date finalDate, Date startDate, Date endDate, Date endedOn, Date lockedOn, Long timeDiff, Long timeDiffDayEnd, String cid, String sessionId, List<Scrum> scrums, WorkFlow impedimentWorkFlow, WorkFlow actionPointWorkFlow, WorkFlow severityWorkFlow, Object roomLink, Object progressType, HashMap<String, Object> selectedDays, List<SOSDateTime> furtureSosList, String timeZoneName, boolean isUpdated, HashMap<String, Object> emailConfiguration, boolean autoCloseSOS, int topImpedimentCount, List<PiSite> sites, int reminderMinutes, String allTeamLabel) {
        this.rangeType = rangeType;
        this.frequency = frequency;
        this.finalDate = finalDate;
        this.startDate = startDate;
        this.endDate = endDate;
        this.endedOn = endedOn;
        this.lockedOn = lockedOn;
        this.timeDiff = timeDiff;
        this.timeDiffDayEnd = timeDiffDayEnd;
        this.cid = cid;
        this.sessionId = sessionId;
        this.scrums = scrums;
        this.impedimentWorkFlow = impedimentWorkFlow;
        this.actionPointWorkFlow = actionPointWorkFlow;
        this.severityWorkFlow = severityWorkFlow;
        this.roomLink = roomLink;
        this.progressType = progressType;
        this.selectedDays = selectedDays;
        this.furtureSosList = furtureSosList;
        this.emailConfiguration = emailConfiguration;
        this.isUpdated = isUpdated;
        this.autoCloseSOS = autoCloseSOS;
        this.timeZoneName = timeZoneName;
        this.topImpedimentCount = topImpedimentCount;
        this.sites = sites;
        this.reminderMinutes = reminderMinutes;
        this.allTeamLabel = allTeamLabel;
        if (PropertyValidator.isValid(furtureSosList) && furtureSosList.get(0).getRoomLink() != null) {
            this.activeRoomLink = furtureSosList.get(0).getRoomLink();
        }
        HashSet<String> remainder = new HashSet<String>();
        if (PropertyValidator.isValid(emailConfiguration)) {
            if (Boolean.TRUE.equals(emailConfiguration.get("Highlights"))) {
                remainder.add("Highlights");
            }
            if (Boolean.TRUE.equals(emailConfiguration.get(WorkFlow.WorkFlowType.Impediment.name()))) {
                remainder.add(WorkFlow.WorkFlowType.Impediment.name());
            }
            if (Boolean.TRUE.equals(emailConfiguration.get(WorkFlow.WorkFlowType.ActionPoint.name()))) {
                remainder.add(WorkFlow.WorkFlowType.ActionPoint.name());
            }
        }
        this.remainderList = remainder;
    }

    public ScrumOfScrums nextSoS(Date now, User user) {
        ScrumOfScrums sos = new ScrumOfScrums(this.rangeType, this.frequency, this.finalDate, this.startDate, this.endDate, this.endedOn, this.lockedOn, this.timeDiff, this.timeDiffDayEnd, this.cid, this.sessionId, this.scrums, this.impedimentWorkFlow, this.actionPointWorkFlow, this.severityWorkFlow, this.roomLink, this.progressType, this.selectedDays, this.furtureSosList, this.timeZoneName, false, this.emailConfiguration, this.autoCloseSOS, this.topImpedimentCount, this.sites, this.reminderMinutes, this.allTeamLabel);
        try {
            int i;
            sos.setId(ObjectId.get().toString());
            sos.setCreatedOn(now);
            sos.setCreatedBy(user.getUserName());
            sos.setTenant(this.getTenant());
            sos.setDuplicateOfId(this.getId());
            sos.setOriginItemId(this.getOriginItemId() == null ? this.getId() : this.getOriginItemId());
            sos.setEndedOn(null);
            sos.setReminderMillis(null);
            if (PropertyValidator.isValid((Collection)this.scrums)) {
                sos.setScrums(new ArrayList());
                for (Scrum scrum : this.scrums) {
                    Scrum newScrum = new Scrum(ObjectId.get().toString());
                    newScrum.setCreatedOn(now);
                    newScrum.setCreatedBy(user.getUserName());
                    newScrum.setDuplicateOfId(scrum.getId());
                    newScrum.setOriginItemId(scrum.getOriginItemId() == null ? scrum.getId() : scrum.getOriginItemId());
                    if (PropertyValidator.isValid((Object)scrum.getTeam()) && scrum.getTeam().getId() != null) {
                        newScrum.setTeam(new Team(scrum.getTeam().getId()));
                    }
                    newScrum.setScrumMaster(scrum.getScrumMaster());
                    newScrum.setProductOwner(scrum.getProductOwner());
                    newScrum.setOtherParticipants(scrum.getOtherParticipants());
                    newScrum.initializeRemainderListFromEmailConfig(this.emailConfiguration);
                    sos.getScrums().add(newScrum);
                }
            }
            Calendar start = Calendar.getInstance();
            Calendar end = Calendar.getInstance();
            start.setTimeInMillis(this.getEndDate().getTime());
            end.setTimeInMillis(start.getTimeInMillis());
            if (this.rangeType.equals(6)) {
                end.add(5, 7 * this.frequency);
            } else {
                end.add(2, this.frequency);
            }
            if (sos.getFurtureSosList().size() > 0 && (i = sos.findIndexOfNextStart()) > -1) {
                SOSDateTime comingSos = (SOSDateTime)sos.getFurtureSosList().remove(i);
                sos.setStartDate(comingSos.getStartDate());
                sos.setEndDate(comingSos.getEndDate());
                sos.calcEmailTime(sos.getTimeDiff());
            }
        }
        catch (Exception ex) {
            LOGGER.debug(StringUtils.getTraceString((Throwable)ex));
        }
        return sos;
    }

    public int findIndexOfNextStart() {
        int ret = -1;
        if (this.furtureSosList != null) {
            for (int i = 0; i < this.furtureSosList.size(); ++i) {
                if (!PropertyValidator.isValid(this.furtureSosList.get(i)) || ((SOSDateTime)this.furtureSosList.get(i)).isSkipped()) continue;
                ret = i;
                break;
            }
        }
        return ret;
    }

    public void calcEmailTime(Long diff) {
        this.setStartDateMillis(Long.valueOf(this.getStartDate().getTime() + diff));
        this.setEndDateMillis(Long.valueOf(this.getEndDate().getTime() + diff));
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.getEndDateMillis());
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 0);
        this.setCloseDateMillis(Long.valueOf(cal.getTimeInMillis() + this.getTimeDiffDayEnd()));
        if (PropertyValidator.isValid((Object)this.getReminderMinutes())) {
            this.setReminderMillis(Long.valueOf(this.getStartDateMillis() - TimeUnit.MINUTES.toMillis(this.getReminderMinutes())));
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public List<Scrum> getScrums() {
        return this.scrums;
    }

    public Object getRoomLink() {
        return this.roomLink;
    }

    public void setRoomLink(Object roomLink) {
        this.roomLink = roomLink;
    }

    public void setScrums(List<Scrum> scrums) {
        this.scrums = scrums;
    }

    public WorkFlow getImpedimentWorkFlow() {
        return this.impedimentWorkFlow;
    }

    public void setImpedimentWorkFlow(WorkFlow impedimentWorkFlow) {
        this.impedimentWorkFlow = impedimentWorkFlow;
    }

    public WorkFlow getActionPointWorkFlow() {
        return this.actionPointWorkFlow;
    }

    public WorkFlow getSeverityWorkFlow() {
        return this.severityWorkFlow;
    }

    public void setSeverityWorkFlow(WorkFlow severityWorkFlow) {
        this.severityWorkFlow = severityWorkFlow;
    }

    public void setActionPointWorkFlow(WorkFlow actionPointWorkFlow) {
        this.actionPointWorkFlow = actionPointWorkFlow;
    }

    public String getFreezAnalyticsData() {
        return this.freezAnalyticsData;
    }

    public void setFreezAnalyticsData(String freezAnalyticsData) {
        this.freezAnalyticsData = freezAnalyticsData;
    }

    public List<SOSDateTime> getFurtureSosList() {
        return this.furtureSosList;
    }

    public void setFurtureSosList(List<SOSDateTime> furtureSosList) {
        this.furtureSosList = furtureSosList;
    }

    public Object getSelectedDays() {
        return this.selectedDays;
    }

    public Integer getRangeType() {
        return this.rangeType;
    }

    public void setRangeType(Integer rangeType) {
        this.rangeType = rangeType;
    }

    public Integer getFrequency() {
        return this.frequency;
    }

    public void setFrequency(Integer frequency) {
        this.frequency = frequency;
    }

    public Date getFinalDate() {
        return this.finalDate;
    }

    public void setFinalDate(Date finalDate) {
        this.finalDate = finalDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getSelectedDayDate() {
        return this.selectedDayDate;
    }

    public void setSelectedDayDate(Date selectedDayDate) {
        this.selectedDayDate = selectedDayDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getTimeDiff() {
        return this.timeDiff;
    }

    public void setTimeDiff(Long timeDiff) {
        this.timeDiff = timeDiff;
    }

    public Long getTimeDiffDayEnd() {
        return this.timeDiffDayEnd;
    }

    public void setTimeDiffDayEnd(Long timeDiffDayEnd) {
        this.timeDiffDayEnd = timeDiffDayEnd;
    }

    public String getCid() {
        return this.cid;
    }

    public void setCid(String cid) {
        this.cid = cid;
    }

    public Date getEndedOn() {
        return this.endedOn;
    }

    public void setEndedOn(Date endedOn) {
        this.endedOn = endedOn;
    }

    public Date getLockedOn() {
        return this.lockedOn;
    }

    public String getTimeZoneName() {
        return this.timeZoneName;
    }

    public void setTimeZoneName(String timeZoneName) {
        this.timeZoneName = timeZoneName;
    }

    public String getLocalZone() {
        return this.localZone;
    }

    public void setLocalZone(String localZone) {
        this.localZone = localZone;
    }

    public void setLockedOn(Date lockedOn) {
        this.lockedOn = lockedOn;
    }

    public Object getProgressType() {
        return this.progressType;
    }

    public void setProgressType(Object progressType) {
        this.progressType = progressType;
    }

    public void setSelectedDays(HashMap<String, Object> selectedDays) {
        this.selectedDays = selectedDays;
    }

    public String getFreezedSosStatId() {
        return this.freezedSosStatId;
    }

    public void setFreezedSosStatId(String freezedSosStatId) {
        this.freezedSosStatId = freezedSosStatId;
    }

    public boolean isAutoCloseSOS() {
        return this.autoCloseSOS;
    }

    public void setAutoCloseSOS(boolean autoCloseSOS) {
        this.autoCloseSOS = autoCloseSOS;
    }

    public HashMap<String, Object> getEmailConfiguration() {
        return this.emailConfiguration;
    }

    public void setEmailConfiguration(HashMap<String, Object> emailConfiguration) {
        this.emailConfiguration = emailConfiguration;
    }

    public boolean isUpdated() {
        return this.isUpdated;
    }

    public void setUpdated(boolean isUpdated) {
        this.isUpdated = isUpdated;
    }

    public Long getStartDateMillis() {
        return this.startDateMillis;
    }

    public void setStartDateMillis(Long startDateMillis) {
        this.startDateMillis = startDateMillis;
    }

    public Long getEndDateMillis() {
        return this.endDateMillis;
    }

    public void setEndDateMillis(Long endDateMillis) {
        this.endDateMillis = endDateMillis;
    }

    public Long getCloseDateMillis() {
        return this.closeDateMillis;
    }

    public void setCloseDateMillis(Long closeDateMillis) {
        this.closeDateMillis = closeDateMillis;
    }

    public int getTopImpedimentCount() {
        return this.topImpedimentCount;
    }

    public void setTopImpedimentCount(int topImpedimentCount) {
        this.topImpedimentCount = topImpedimentCount;
    }

    public List<PiSite> getSites() {
        return this.sites;
    }

    public void setSites(List<PiSite> sites) {
        this.sites = sites;
    }

    public int getReminderMinutes() {
        return this.reminderMinutes;
    }

    public void setReminderMinutes(int reminderMinutes) {
        this.reminderMinutes = reminderMinutes;
    }

    public String getAllTeamLabel() {
        return this.allTeamLabel;
    }

    public void setAllTeamLabel(String allTeamLabel) {
        this.allTeamLabel = allTeamLabel;
    }

    public Date getClientStartDate() {
        return this.clientStartDate;
    }

    public void setClientStartDate(Date clientStartDate) {
        this.clientStartDate = clientStartDate;
    }

    public Date getClientEndDate() {
        return this.clientEndDate;
    }

    public void setClientEndDate(Date clientEndDate) {
        this.clientEndDate = clientEndDate;
    }

    public Long getClientTimeOffset() {
        return this.clientTimeOffset;
    }

    public void setClientTimeOffset(Long clientTimeOffset) {
        this.clientTimeOffset = clientTimeOffset;
    }

    public Long getReminderMillis() {
        return this.reminderMillis;
    }

    public void setReminderMillis(Long reminderMillis) {
        this.reminderMillis = reminderMillis;
    }

    public Set<String> getRemainderList() {
        return this.remainderList;
    }

    public void setRemainderList(Set<String> remainderList) {
        this.remainderList = remainderList;
    }

    public Object getActiveRoomLink() {
        return this.activeRoomLink;
    }

    public void setActiveRoomLink(Object activeRoomLink) {
        this.activeRoomLink = activeRoomLink;
    }

    public Boolean getReminderSent() {
        return this.reminderSent;
    }

    public void setReminderSent(Boolean reminderSent) {
        this.reminderSent = reminderSent;
    }
}

