/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.viztrend.safe.annotations.GenerateFieldlog;
import com.viztrend.safe.annotations.GenerateLog;
import com.viztrend.safe.annotations.PushField;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BoardSprints;
import com.viztrend.safe.persistence.entity.BoardTeam;
import com.viztrend.safe.persistence.entity.Conversation;
import com.viztrend.safe.persistence.entity.ExternalLink;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.RiskMatrixCoordinate;
import com.viztrend.safe.persistence.entity.RiskRegister;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.TFSAttributes;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.Watcher;
import com.viztrend.safe.utils.PropertyValidator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.DBRef;

@GenerateLog
@JsonIgnoreProperties(ignoreUnknown=true)
public class Risk
extends BaseEntity {
    @Transient
    private String appUrl;
    @PushField
    private Integer riskNumber;
    @PushField
    @GenerateFieldlog
    private String riskTitle;
    @GenerateFieldlog
    private String riskDesc;
    @GenerateFieldlog
    private String mitigationActions;
    private Boolean notifyWatchers = Boolean.TRUE;
    @DBRef
    private RiskRegister riskRegister;
    @PushField
    @Transient
    private List<Item> linkedItems = new ArrayList();
    @Transient
    private List<Conversation> conversations = new ArrayList();
    @PushField
    @GenerateFieldlog
    private List<String> linkedItemsIds;
    private Map<String, Object> linkedItemsById;
    @DBRef
    private List<Watcher> watcherList = new ArrayList();
    private List<ExternalLink> externalLinks = new ArrayList();
    @PushField
    private List<BoardTeam> boardTeams;
    @PushField
    private List<BoardSprints> boardSprints;
    @PushField
    private List<Map> linkedPiBoards;
    @PushField
    private List<Map> linkedSolutionBoards;
    @PushField
    private List<Map> linkedOrgCollections;
    @GenerateFieldlog
    private RiskMatrixCoordinate impact;
    @PushField
    @GenerateFieldlog
    @DBRef
    private Status status;
    @GenerateFieldlog
    private RiskMatrixCoordinate probability;
    @PushField
    @GenerateFieldlog
    private Date raisedDate;
    @PushField
    @GenerateFieldlog
    private Date resolutionDate;
    @GenerateFieldlog
    @DBRef
    private User responsible;
    private Map<String, Object> fields;
    @DBRef
    private Map<String, String> activeBoardIds;
    private Integer conversationCount = 0;
    @PushField
    TFSAttributes tfsAttributes;
    @PushField
    private String almId;
    @PushField
    private Boolean errorInAlmSync = Boolean.FALSE;
    @PushField
    private String almErrorMessage;
    @PushField
    @DBRef
    private User fetchedBy;
    @Transient
    private boolean sendToAlm = false;

    public Map<String, Object> toSimpleObject() {
        HashMap<String, Object> simpleObject = new HashMap<String, Object>();
        if (PropertyValidator.isValid((Object)this.status)) {
            HashMap<String, String> status = new HashMap<String, String>();
            status.put("id", this.status.getId());
            status.put("title", this.status.getTitle());
            simpleObject.put("status", status);
        }
        simpleObject.put("id", this.id);
        simpleObject.put("riskNumber", this.riskNumber);
        simpleObject.put("riskTitle", this.riskTitle);
        if (PropertyValidator.isValid((Object)this.tfsAttributes)) {
            HashMap<String, String> tfsAttrib = new HashMap<String, String>();
            tfsAttrib.put("tfsId", this.tfsAttributes.getTfsId());
            tfsAttrib.put("tfsURL", this.tfsAttributes.getTfsURL());
            tfsAttrib.put("tfsItemTypeIcon", this.tfsAttributes.getTfsItemTypeIcon());
            simpleObject.put("tfsAttributes", tfsAttrib);
        }
        return simpleObject;
    }

    public Integer getRiskNumber() {
        return this.riskNumber;
    }

    public void setRiskNumber(Integer riskNumber) {
        this.riskNumber = riskNumber;
    }

    public String getRiskDesc() {
        return this.riskDesc;
    }

    public void setRiskDesc(String riskDesc) {
        this.riskDesc = riskDesc;
    }

    public RiskRegister getRiskRegister() {
        return this.riskRegister;
    }

    public List<Watcher> getWatcherList() {
        return this.watcherList;
    }

    public void setWatcherList(List<Watcher> watcherList) {
        this.watcherList = watcherList;
    }

    public String getMitigationActions() {
        return this.mitigationActions;
    }

    public void setMitigationActions(String mitigationActions) {
        this.mitigationActions = mitigationActions;
    }

    public void setRiskRegister(RiskRegister riskRegister) {
        this.riskRegister = riskRegister;
    }

    public Integer getConversationCount() {
        return this.conversationCount;
    }

    public void setConversationCount(Integer conversationCount) {
        this.conversationCount = conversationCount;
    }

    public List<String> getLinkedItemsIds() {
        return this.linkedItemsIds;
    }

    public void setLinkedItemsIds(List<String> linkedItemsIds) {
        this.linkedItemsIds = linkedItemsIds;
    }

    public List<ExternalLink> getExternalLinks() {
        return this.externalLinks;
    }

    public void setExternalLinks(List<ExternalLink> externalLinks) {
        this.externalLinks = externalLinks;
    }

    public String getAppUrl() {
        return this.appUrl;
    }

    public void setAppUrl(String appUrl) {
        this.appUrl = appUrl;
    }

    public String getRiskTitle() {
        return this.riskTitle;
    }

    public void setRiskTitle(String riskTitle) {
        this.riskTitle = riskTitle;
    }

    public List<Item> getLinkedItems() {
        return this.linkedItems;
    }

    public void setLinkedItems(List<Item> linkedItems) {
        this.linkedItems = linkedItems;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Date getRaisedDate() {
        return this.raisedDate;
    }

    public void setRaisedDate(Date raisedDate) {
        this.raisedDate = raisedDate;
    }

    public RiskMatrixCoordinate getImpact() {
        return this.impact;
    }

    public void setImpact(RiskMatrixCoordinate impact) {
        this.impact = impact;
    }

    public RiskMatrixCoordinate getProbability() {
        return this.probability;
    }

    public void setProbability(RiskMatrixCoordinate probability) {
        this.probability = probability;
    }

    public Date getResolutionDate() {
        return this.resolutionDate;
    }

    public void setResolutionDate(Date resolutionDate) {
        this.resolutionDate = resolutionDate;
    }

    public User getResponsible() {
        return this.responsible;
    }

    public List<Conversation> getConversations() {
        return this.conversations;
    }

    public void setConversations(List<Conversation> conversations) {
        this.conversations = conversations;
    }

    public void setResponsible(User responsible) {
        this.responsible = responsible;
    }

    public Boolean getNotifyWatchers() {
        return this.notifyWatchers;
    }

    public void setNotifyWatchers(Boolean notifyWatchers) {
        this.notifyWatchers = notifyWatchers;
    }

    public Map<String, Object> getLinkedItemsById() {
        return this.linkedItemsById;
    }

    public void setLinkedItemsById(Map<String, Object> linkedItemsById) {
        this.linkedItemsById = linkedItemsById;
    }

    public List<BoardTeam> getBoardTeams() {
        return this.boardTeams;
    }

    public void setBoardTeams(List<BoardTeam> boardTeams) {
        this.boardTeams = boardTeams;
    }

    public List<BoardSprints> getBoardSprints() {
        return this.boardSprints;
    }

    public void setBoardSprints(List<BoardSprints> boardSprints) {
        this.boardSprints = boardSprints;
    }

    public void adjustLinkedItemIds() {
        if (PropertyValidator.isValid((Object)this.linkedItemsById)) {
            if (this.linkedItemsIds == null) {
                this.linkedItemsIds = new ArrayList();
            }
            HashMap map = new HashMap();
            for (int i = 0; i < this.linkedItemsIds.size(); ++i) {
                map.put(this.linkedItemsIds.get(i), true);
            }
            Set ids = this.linkedItemsById.keySet();
            for (String id : ids) {
                if (map.containsKey(id)) continue;
                this.linkedItemsIds.add(id);
            }
        }
    }

    public Map<String, String> getActiveBoardIds() {
        return this.activeBoardIds;
    }

    public void setActiveBoardIds(Map<String, String> activeBoardIds) {
        this.activeBoardIds = activeBoardIds;
    }

    public String getAlmId() {
        return this.almId;
    }

    public void setAlmId(String almId) {
        this.almId = almId;
    }

    public Boolean getErrorInAlmSync() {
        return this.errorInAlmSync;
    }

    public void setErrorInAlmSync(Boolean errorInAlmSync) {
        this.errorInAlmSync = errorInAlmSync;
    }

    public String getAlmErrorMessage() {
        return this.almErrorMessage;
    }

    public void setAlmErrorMessage(String almErrorMessage) {
        this.almErrorMessage = almErrorMessage;
    }

    public User getFetchedBy() {
        return this.fetchedBy;
    }

    public void setFetchedBy(User fetchedBy) {
        this.fetchedBy = fetchedBy;
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, Object> fields) {
        this.fields = fields;
    }

    public List<Map> getLinkedPiBoards() {
        return this.linkedPiBoards;
    }

    public void setLinkedPiBoards(List<Map> linkedPiBoards) {
        this.linkedPiBoards = linkedPiBoards;
    }

    public List<Map> getLinkedSolutionBoards() {
        return this.linkedSolutionBoards;
    }

    public void setLinkedSolutionBoards(List<Map> linkedSolutionBoards) {
        this.linkedSolutionBoards = linkedSolutionBoards;
    }

    public List<Map> getLinkedOrgCollections() {
        return this.linkedOrgCollections;
    }

    public void setLinkedOrgCollections(List<Map> linkedOrgCollections) {
        this.linkedOrgCollections = linkedOrgCollections;
    }

    public TFSAttributes getTfsAttributes() {
        return this.tfsAttributes;
    }

    public void setTfsAttributes(TFSAttributes tfsAttributes) {
        this.tfsAttributes = tfsAttributes;
    }

    public boolean isSendToAlm() {
        return this.sendToAlm;
    }

    public void setSendToAlm(boolean sendToAlm) {
        this.sendToAlm = sendToAlm;
    }
}

