/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.ReleaseTemplateItem;
import com.viztrend.safe.persistence.entity.roadmap.RoadmapItem;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.springframework.data.mongodb.core.mapping.DBRef;

public class ReleaseTemplate
extends BaseEntity {
    private String title;
    private String description;
    @DBRef
    private ArrayList<ReleaseTemplateItem> phases;

    public ArrayList<RoadmapItem> createPhaseWith(Date startDate, Date endDate) {
        ArrayList<RoadmapItem> phases = new ArrayList<RoadmapItem>();
        for (int i = 0; i < this.phases.size(); ++i) {
            ReleaseTemplateItem phase = (ReleaseTemplateItem)this.phases.get(i);
            RoadmapItem roadmapItem = new RoadmapItem();
            roadmapItem.setTitle(phase.getTitle());
            roadmapItem.setDescription(phase.getDescription());
            if (phase.getType() == ReleaseTemplateItem.Type.MILESTONE) {
                roadmapItem.setType(RoadmapItem.Type.MILESTONE);
            } else {
                roadmapItem.setType(RoadmapItem.Type.PHASE);
            }
            Calendar calender = Calendar.getInstance();
            if (i == 0) {
                roadmapItem.setStartDate(startDate);
                if (roadmapItem.getType() == RoadmapItem.Type.PHASE) {
                    calender.setTime(startDate);
                    calender.add(5, phase.getDurationInDays() - 1);
                    Date _endDate = calender.getTime();
                    _endDate.setSeconds(_endDate.getSeconds() + 86399);
                    roadmapItem.setEndDate(_endDate);
                }
            } else {
                Date date;
                RoadmapItem preItem = phases.get(i - 1);
                if (preItem.getType() == RoadmapItem.Type.MILESTONE) {
                    date = preItem.getStartDate();
                    calender.setTime(date);
                    calender.add(5, phase.getStartAfterDays() + 1);
                } else {
                    date = this.normalizeDate(preItem.getEndDate());
                    calender.setTime(date);
                    calender.add(5, phase.getStartAfterDays() + 1);
                }
                Date _startDate = calender.getTime();
                roadmapItem.setStartDate(_startDate);
                if (roadmapItem.getType() == RoadmapItem.Type.PHASE) {
                    calender.setTime(_startDate);
                    calender.add(5, phase.getDurationInDays() - 1);
                    Date _endDate = calender.getTime();
                    _endDate.setSeconds(_endDate.getSeconds() + 86399);
                    roadmapItem.setEndDate(_endDate);
                }
            }
            phases.add(roadmapItem);
        }
        return phases;
    }

    private Date normalizeDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(10, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ArrayList<ReleaseTemplateItem> getPhases() {
        return this.phases;
    }

    public void setPhases(ArrayList<ReleaseTemplateItem> phases) {
        this.phases = phases;
    }
}

