/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.mongodb.BasicDBObject;
import com.viztrend.safe.persistence.entity.AnswerTemplate;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.Questionnaire;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.utils.DBUtils;
import org.springframework.data.mongodb.core.mapping.DBRef;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Question
extends BaseEntity {
    private String questionText;
    @DBRef
    private Questionnaire questionnaire;
    private String answerTemplateId;
    private AnswerTemplate answerTemplate;
    @DBRef
    private Team team;
    private String urlToken;

    public Question() {
    }

    public Question(BasicDBObject object) {
        this.id = DBUtils.getIdFromDBObject((BasicDBObject)object, (String[])new String[0]);
        this.questionText = object.getString("questionText");
        this.answerTemplateId = object.getString("answerTemplateId");
        this.urlToken = object.getString("urlToken");
        if (!DBUtils.isEmptyObject((Object)object.get("questionnaire"))) {
            this.questionnaire = new Questionnaire((BasicDBObject)object.get("questionnaire"));
        }
        if (!DBUtils.isEmptyObject((Object)object.get("answerTemplate"))) {
            this.answerTemplate = new AnswerTemplate((BasicDBObject)object.get("answerTemplate"));
        }
        if (!DBUtils.isEmptyObject((Object)object.get("team"))) {
            this.team = new Team((BasicDBObject)object.get("team"));
        }
    }

    public String getUrlToken() {
        return this.urlToken;
    }

    public void setUrlToken(String urlToken) {
        this.urlToken = urlToken;
    }

    public String getAnswerTemplateId() {
        return this.answerTemplateId;
    }

    public void setAnswerTemplateId(String answerTemplateId) {
        this.answerTemplateId = answerTemplateId;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public AnswerTemplate getAnswerTemplate() {
        return this.answerTemplate;
    }

    public void setAnswerTemplate(AnswerTemplate answerTemplate) {
        this.answerTemplate = answerTemplate;
    }

    public Questionnaire getQuestionnaire() {
        return this.questionnaire;
    }

    public void setQuestionnaire(Questionnaire questionnaire) {
        this.questionnaire = questionnaire;
    }

    public String getQuestionText() {
        return this.questionText;
    }

    public void setQuestionText(String questionText) {
        this.questionText = questionText;
    }
}

