/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.Gson;
import com.viztrend.safe.persistence.entity.JiraOauthToken;
import com.viztrend.safe.utils.PropertyValidator;
import java.io.Serializable;
import java.util.HashMap;

public class JiraOauthToken
implements Serializable {
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String oauthToken;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String oauthVerfier;
    private String consumerKey;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String privateKey;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String accessToken;
    private String scope;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String refreshToken;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String expiresAt;
    private boolean isCloud = false;
    private ServerAuthType serverAuthType = ServerAuthType.AUTH_1_0;
    private String cloudId;

    public String getOauthToken() {
        return this.oauthToken;
    }

    public void setOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
    }

    public String getOauthVerfier() {
        return this.oauthVerfier;
    }

    public void setOauthVerfier(String oauthVerfier) {
        this.oauthVerfier = oauthVerfier;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public static boolean isEmptyJiraAuth2Token(JiraOauthToken jiraOauthToken) {
        if (!PropertyValidator.isValid((Object)jiraOauthToken)) {
            return true;
        }
        return !PropertyValidator.isValid((Object)jiraOauthToken.getAccessToken()) || !PropertyValidator.isValid((Object)jiraOauthToken.getRefreshToken());
    }

    public String toString() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("oauthToken", this.oauthToken);
        map.put("oauthVerfier", this.oauthVerfier);
        map.put("consumerKey", this.consumerKey);
        map.put("privateKey", this.privateKey);
        map.put("accessToken", this.accessToken);
        map.put("cloudId", this.cloudId);
        map.put("refreshToken", this.refreshToken);
        map.put("expiresAt", this.expiresAt);
        map.put("scope", this.scope);
        map.put("isCloud", Boolean.toString(this.isCloud));
        map.put("serverAuthType", this.serverAuthType.name());
        Gson gson = new Gson();
        String jsonauthMapJSON = gson.toJson(map);
        return jsonauthMapJSON;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
    }

    @JsonProperty(value="isCloud")
    public boolean isCloud() {
        return this.isCloud;
    }

    public void setCloud(boolean isCloud) {
        this.isCloud = isCloud;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public ServerAuthType getServerAuthType() {
        return this.serverAuthType;
    }

    public void setServerAuthType(ServerAuthType serverAuthType) {
        this.serverAuthType = serverAuthType;
    }

    public String getCloudId() {
        return this.cloudId;
    }

    public void setCloudId(String cloudId) {
        this.cloudId = cloudId;
    }
}

