/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.mongodb.BasicDBObject;
import com.viztrend.safe.annotations.PushField;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.PropertyValidator;
import java.util.Date;
import java.util.HashMap;
import org.springframework.data.annotation.Transient;

public class Container
extends BaseEntity {
    private static final long serialVersionUID = 6178565640747506394L;
    @Transient
    private String action;
    @PushField
    private String title;
    private String label;
    private String description;
    private String type;
    private Date startDate;
    private Date endDate;
    private Date startedOn;
    private Date endedOn;
    private Long startTime;
    private Long endTime;
    private Integer velocity;
    private Boolean isIPSprint = false;
    @Transient
    private Team team;
    @Transient
    private Container target;
    @Transient
    private String tempId;
    private Boolean processingSprintReport = false;
    private String sessionBoardId;
    private Double sequence = new Double(System.nanoTime());

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Container [");
        if (this.title != null) {
            builder.append("title=");
            builder.append(this.title);
            builder.append(", ");
        }
        if (this.id != null) {
            builder.append("id=");
            builder.append(this.id);
        }
        if (this.tempId != null) {
            builder.append("tempId=");
            builder.append(this.tempId);
            builder.append(", ");
        }
        if (this.velocity != null) {
            builder.append("velocity=");
            builder.append(this.velocity);
            builder.append(", ");
        }
        if (this.type != null) {
            builder.append("type=");
            builder.append(this.type);
            builder.append(", ");
        }
        if (this.startDate != null) {
            builder.append("startDate=");
            builder.append(this.startDate);
            builder.append(", ");
        }
        if (this.endDate != null) {
            builder.append("endDate=");
            builder.append(this.endDate);
            builder.append(", ");
        }
        if (this.team != null) {
            builder.append("team=");
            builder.append(this.team);
            builder.append(", ");
        }
        if (this.description != null) {
            builder.append("description=");
            builder.append(this.description);
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    public Container() {
    }

    public Container(BasicDBObject object) {
        this.id = DBUtils.getIdFromDBObject((BasicDBObject)object, (String[])new String[0]);
        this.title = object.getString("title");
        this.label = object.getString("label");
        this.startDate = object.getDate("startDate");
        this.startedOn = object.getDate("startedOn");
        this.clientTimeZone = object.getString("clientTimeZone");
        this.endDate = object.getDate("endDate");
        this.endedOn = object.getDate("endedOn");
        this.isIPSprint = object.getBoolean("isIPSprint");
        if (PropertyValidator.isValid((Object)object.get("sequence"))) {
            this.sequence = object.getDouble("sequence");
        }
    }

    public Container(Container container) {
        this.id = container.getId();
        this.title = container.getTitle();
        this.label = container.getLabel();
        this.startDate = container.getStartDate();
        this.startedOn = container.getStartedOn();
        this.clientTimeZone = container.getClientTimeZone();
        this.endDate = container.getEndDate();
        this.endedOn = container.getEndedOn();
        this.isIPSprint = container.getIsIPSprint();
        this.sequence = container.getSequence();
    }

    public Container(String title, String label, Date startDate, Date endDate, Boolean isIPSprint) {
        this.title = title;
        this.label = label;
        this.startDate = startDate;
        this.endDate = endDate;
        this.isIPSprint = isIPSprint;
    }

    public Container(String id, String title, Double sequence, String originItemId, String duplicateOf) {
        this.id = id;
        this.title = title;
        this.sequence = sequence;
        this.setOriginItemId(originItemId);
        this.setDuplicateOfId(duplicateOf);
    }

    public Container(String id) {
        super(id);
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTempId() {
        return this.tempId;
    }

    public void setTempId(String tempId) {
        this.tempId = tempId;
    }

    public Integer getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Integer velocity) {
        this.velocity = velocity;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Container)) {
            return false;
        }
        Container other = (Container)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public HashMap<String, ? super Object> toSimpleObject() {
        HashMap<String, Object> rowData = new HashMap<String, Object>();
        rowData.put("id", this.id);
        rowData.put("title", this.title);
        rowData.put("startDate", this.startDate);
        rowData.put("endDate", this.endDate);
        rowData.put("isIPSprint", this.isIPSprint);
        rowData.put("label", this.label);
        rowData.put("originItemId", this.getOriginItemId());
        return rowData;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Double getSequence() {
        return this.sequence;
    }

    public void setSequence(Double sequence) {
        this.sequence = sequence;
    }

    public Boolean getIsIPSprint() {
        return this.isIPSprint;
    }

    public void setIsIPSprint(Boolean isIPSprint) {
        this.isIPSprint = isIPSprint;
    }

    public Container getTarget() {
        return this.target;
    }

    public void setTarget(Container target) {
        this.target = target;
    }

    public Date getStartedOn() {
        return this.startedOn;
    }

    public void setStartedOn(Date startedOn) {
        this.startedOn = startedOn;
    }

    public Date getEndedOn() {
        return this.endedOn;
    }

    public void setEndedOn(Date endedOn) {
        this.endedOn = endedOn;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public String getSessionBoardId() {
        return this.sessionBoardId;
    }

    public void setSessionBoardId(String sessionBoardId) {
        this.sessionBoardId = sessionBoardId;
    }

    public Boolean getProcessingSprintReport() {
        return this.processingSprintReport;
    }

    public void setProcessingSprintReport(Boolean processingSprintReport) {
        this.processingSprintReport = processingSprintReport;
    }
}

