/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.Board;
import com.viztrend.safe.persistence.entity.BoardConfiguration;
import com.viztrend.safe.persistence.entity.FilterCriteria;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.Lane;
import com.viztrend.safe.persistence.entity.ObjectiveCustomView;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.roadmap.RoadmapSection;
import com.viztrend.safe.utils.PropertyValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.mapping.DBRef;

public class Board
extends BaseEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(Board.class);
    private String key;
    private String name;
    private String description;
    private String itemType = Item.FEATURE.toString();
    private Boolean hasSwimLanes = Boolean.FALSE;
    private String viewType = EnumBoardType.KANBAN.toString();
    private Integer level;
    private Boolean enableMapping;
    private BoardConfiguration configurations;
    private String backlogColumnTitle;
    @DBRef
    private FilterCriteria filterCriteria;
    private String boardType;
    @DBRef
    private List<Lane> lanes;
    @DBRef
    private WorkSpace workSpace;
    @DBRef
    private ObjectiveCustomView objectiveCustomView;
    private List<String> linkedBacklogItems = new ArrayList();
    private List<String> plannedItems = new ArrayList();
    private List<String> timelineVisiblePiBoards = new ArrayList();
    private Integer timelineBarMode = 0;
    private Integer timelineUnplannedItemsMode = 0;
    private Integer timelineIterationDate = 0;
    private Integer timelineDatePreferences = 0;
    private List<String> timelineColumns = new ArrayList();
    private List<String> kanbanMappingOrder = new ArrayList();
    private Integer iterationPathDates = 0;
    private Integer datePreference = 0;
    private boolean defaultOkrRoadmap = false;
    Map<String, RoadmapSection> roadmapSectionMap = new HashMap();

    public ObjectiveCustomView getObjectiveCustomView() {
        return this.objectiveCustomView;
    }

    public void setObjectiveCustomView(ObjectiveCustomView objectiveCustomView) {
        this.objectiveCustomView = objectiveCustomView;
    }

    public Board() {
    }

    public Board(String id) {
        super(id);
    }

    public Board(Board other) {
        this.id = other.id;
        this.description = other.description;
        this.key = other.key;
        this.name = other.name;
        this.itemType = other.itemType;
        this.setArchive(other.isArchive());
        this.createdOn = other.createdOn;
        if (PropertyValidator.isValid((Collection)other.linkedBacklogItems)) {
            this.linkedBacklogItems = new ArrayList(other.linkedBacklogItems);
        }
        if (PropertyValidator.isValid((Object)other.lastUpdate)) {
            this.lastUpdate = new HashMap(other.lastUpdate);
        }
        if (PropertyValidator.isValid((Object)other.roadmapSectionMap)) {
            this.roadmapSectionMap = new HashMap(other.roadmapSectionMap);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WorkSpace getWorkSpace() {
        return this.workSpace;
    }

    public void setWorkSpace(WorkSpace workSpace) {
        this.workSpace = workSpace;
    }

    public List<Lane> getLanes() {
        return this.lanes;
    }

    public void setLanes(List<Lane> lanes) {
        this.lanes = lanes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public Boolean getHasSwimLanes() {
        return this.hasSwimLanes;
    }

    public void setHasSwimLanes(Boolean hasSwimLanes) {
        this.hasSwimLanes = hasSwimLanes;
    }

    public String getBoardType() {
        return this.boardType;
    }

    public void setBoardType(String boardType) {
        this.boardType = boardType;
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public String getViewType() {
        return this.viewType;
    }

    public void setViewType(String viewType) {
        this.viewType = viewType;
    }

    public FilterCriteria getFilterCriteria() {
        return this.filterCriteria;
    }

    public void setFilterCriteria(FilterCriteria filterCriteria) {
        this.filterCriteria = filterCriteria;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public BoardConfiguration getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(BoardConfiguration configurations) {
        this.configurations = configurations;
    }

    public List<String> getLinkedBacklogItems() {
        return this.linkedBacklogItems;
    }

    public void setLinkedBacklogItems(List<String> linkedBacklogItems) {
        this.linkedBacklogItems = linkedBacklogItems;
    }

    public List<String> getPlannedItems() {
        return this.plannedItems;
    }

    public void setPlannedItems(List<String> plannedItems) {
        this.plannedItems = plannedItems;
    }

    public Boolean getEnableMapping() {
        return this.enableMapping;
    }

    public void setEnableMapping(Boolean enableMapping) {
        this.enableMapping = enableMapping;
    }

    public List<String> getTimelineVisiblePiBoards() {
        return this.timelineVisiblePiBoards;
    }

    public void setTimelineVisiblePiBoards(List<String> timelineVisiblePiBoards) {
        this.timelineVisiblePiBoards = timelineVisiblePiBoards;
    }

    public Integer getTimelineBarMode() {
        return this.timelineBarMode;
    }

    public void setTimelineBarMode(Integer timelineBarMode) {
        this.timelineBarMode = timelineBarMode;
    }

    public Integer getTimelineUnplannedItemsMode() {
        return this.timelineUnplannedItemsMode;
    }

    public void setTimelineUnplannedItemsMode(Integer timelineUnplannedItemsMode) {
        this.timelineUnplannedItemsMode = timelineUnplannedItemsMode;
    }

    public List<String> getTimelineColumns() {
        return this.timelineColumns;
    }

    public void setTimelineColumns(List<String> timelineColumns) {
        this.timelineColumns = timelineColumns;
    }

    public String getBacklogColumnTitle() {
        return this.backlogColumnTitle;
    }

    public void setBacklogColumnTitle(String backlogColumnTitle) {
        this.backlogColumnTitle = backlogColumnTitle;
    }

    public List<String> getKanbanMappingOrder() {
        return this.kanbanMappingOrder;
    }

    public void setKanbanMappingOrder(List<String> kanbanMappingOrder) {
        this.kanbanMappingOrder = kanbanMappingOrder;
    }

    public Integer getDatePreference() {
        return this.datePreference;
    }

    public void setDatePreference(Integer datePreference) {
        this.datePreference = datePreference;
    }

    public Integer getIterationPathDates() {
        return this.iterationPathDates;
    }

    public void setIterationPathDates(Integer iterationPathDates) {
        this.iterationPathDates = iterationPathDates;
    }

    public Integer getTimelineIterationDate() {
        return this.timelineIterationDate;
    }

    public void setTimelineIterationDate(Integer timelineIterationDate) {
        this.timelineIterationDate = timelineIterationDate;
    }

    public Integer getTimelineDatePreferences() {
        return this.timelineDatePreferences;
    }

    public void setTimelineDatePreferences(Integer timelineDatePreferences) {
        this.timelineDatePreferences = timelineDatePreferences;
    }

    public boolean isDefaultOkrRoadmap() {
        return this.defaultOkrRoadmap;
    }

    public void setDefaultOkrRoadmap(boolean defaultOkrRoadmap) {
        this.defaultOkrRoadmap = defaultOkrRoadmap;
    }

    public Map<String, RoadmapSection> getRoadmapSectionMap() {
        return this.roadmapSectionMap;
    }

    public void setRoadmapSectionMap(Map<String, RoadmapSection> roadmapSectionMap) {
        this.roadmapSectionMap = roadmapSectionMap;
    }
}

