/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.viztrend.safe.annotations.GenerateFieldlog;
import com.viztrend.safe.annotations.GenerateLog;
import com.viztrend.safe.annotations.PushField;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.FieldsLayout;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.Risk;
import com.viztrend.safe.utils.PropertyValidator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.DBRef;

@GenerateLog
public class BaseItemLink
extends BaseEntity
implements Cloneable {
    private static final long serialVersionUID = 6007521251768393999L;
    private String customId;
    @PushField
    @GenerateFieldlog
    private String sessionId;
    @PushField
    @GenerateFieldlog
    private String sessionBoardId;
    @PushField
    private String solutionId;
    @PushField
    private String scrumOfScrumId;
    @PushField
    private String teamId;
    @PushField
    private String sprintId;
    @PushField
    private String teamContainerId;
    @PushField
    @GenerateFieldlog
    private String linkType;
    @PushField
    @GenerateFieldlog
    private String baseItemId;
    @PushField
    @GenerateFieldlog
    private ObjectId backlogItemId;
    @PushField
    private Map<String, Object> linkedBaseItemById;
    @PushField
    @Transient
    private BaseItem linkedBaseItem;
    @PushField
    private String itemId;
    @PushField
    private String almItemId;
    @PushField
    private String almType;
    @PushField
    private String type;
    @PushField
    private Map<String, Object> linkedItemById;
    @PushField
    private Set<String> workSpaceIds;
    @PushField
    @Transient
    private Item linkedItem;
    @PushField
    private String riskId;
    @PushField
    @GenerateFieldlog
    private String laneId;
    @PushField
    @GenerateFieldlog
    private String kanbanId;
    @PushField
    private String releaseTrainId;
    private Integer backlogLevel;
    @PushField
    private Map<String, Object> linkedRiskById;
    @Transient
    @PushField
    private Risk linkedRisk;
    @PushField
    private Double sequence = new Double(System.nanoTime() / 100000L);
    @Transient
    @PushField
    private boolean deleted;
    @PushField
    private Boolean isSystemLink;
    @Transient
    private Object oldState;
    @PushField
    private Double weightage = 1.0;
    @PushField
    @DBRef
    private FieldsLayout layout;
    @PushField
    @DBRef
    private FieldsLayout childLayout;

    public BaseItemLink() {
    }

    public BaseItemLink(String id) {
        super(id);
    }

    public BaseItemLink(String sessionId, String linkType, String teamId, String baseItemId, String type) {
        this.sessionId = sessionId;
        this.linkType = linkType;
        this.teamId = teamId;
        this.baseItemId = baseItemId;
        this.type = type;
    }

    public BaseItemLink(String sessionId, String linkType, String baseItemId) {
        this.sessionId = sessionId;
        this.linkType = linkType;
        this.baseItemId = baseItemId;
    }

    public BaseItemLink(String releaseTrainId, String type) {
        this.releaseTrainId = releaseTrainId;
        this.type = type;
    }

    public BaseItemLink(String sessionId, String linkType, String teamId, String type) {
        this.sessionId = sessionId;
        this.linkType = linkType;
        this.teamId = teamId;
        this.type = type;
    }

    public BaseItemLink(Set<String> workSpaceIds) {
        this.workSpaceIds = workSpaceIds;
    }

    public BaseItemLink(String sessionId, String solutionId, String scrumOfScrumId, String teamId, String sprintId, String baseItemId, Map<String, Object> linkedBaseItemById, BaseItem linkedBaseItem, String itemId, Map<String, Object> linkedItemById, Item linkedItem, String riskId, Map<String, Object> linkedRiskById, Risk linkedRisk, Double sequence, boolean deleted, Boolean isSystemLink, Double weightage) {
        this.sessionId = sessionId;
        this.solutionId = solutionId;
        this.scrumOfScrumId = scrumOfScrumId;
        this.teamId = teamId;
        this.sprintId = sprintId;
        this.baseItemId = baseItemId;
        this.linkedBaseItemById = linkedBaseItemById;
        this.linkedBaseItem = linkedBaseItem;
        this.itemId = itemId;
        this.linkedItemById = linkedItemById;
        this.linkedItem = linkedItem;
        this.riskId = riskId;
        this.linkedRiskById = linkedRiskById;
        this.linkedRisk = linkedRisk;
        this.sequence = sequence;
        this.deleted = deleted;
        this.isSystemLink = isSystemLink;
        this.weightage = weightage;
    }

    public BaseItemLink(BaseItemLink baseItemLink) {
        this.sessionId = baseItemLink.sessionId;
        this.solutionId = baseItemLink.solutionId;
        this.scrumOfScrumId = baseItemLink.scrumOfScrumId;
        this.teamId = baseItemLink.teamId;
        this.sprintId = baseItemLink.sprintId;
        this.baseItemId = baseItemLink.baseItemId;
        this.linkedBaseItemById = baseItemLink.linkedBaseItemById;
        this.linkedBaseItem = baseItemLink.linkedBaseItem;
        this.itemId = baseItemLink.itemId;
        this.linkedItemById = baseItemLink.linkedItemById;
        this.linkedItem = baseItemLink.linkedItem;
        this.riskId = baseItemLink.riskId;
        this.linkedRiskById = baseItemLink.linkedRiskById;
        this.linkedRisk = baseItemLink.linkedRisk;
        this.sequence = baseItemLink.sequence;
        this.deleted = baseItemLink.deleted;
        this.isSystemLink = baseItemLink.isSystemLink;
        this.weightage = baseItemLink.weightage;
    }

    public BaseItemLink copy() {
        BaseItemLink link = new BaseItemLink(this.sessionId, this.solutionId, this.scrumOfScrumId, this.teamId, this.sprintId, this.baseItemId, this.linkedBaseItemById, this.linkedBaseItem, this.baseItemId, this.linkedItemById, this.linkedItem, this.riskId, this.linkedRiskById, this.linkedRisk, this.sequence, this.deleted, this.isSystemLink, this.weightage);
        link.setId(ObjectId.get().toString());
        link.setTenant(this.getTenant());
        link.setDuplicateOfId(this.getId());
        link.setOriginItemId(this.getOriginItemId() == null ? this.getId() : this.getOriginItemId());
        this.setDuplicateToId(link.getId());
        return link;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseItemLink other = (BaseItemLink)obj;
        return this.getId() == null || other.getId() == null || this.getId().equals(other.getId());
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionBoardId() {
        return this.sessionBoardId;
    }

    public void setSessionBoardId(String sessionBoardId) {
        this.sessionBoardId = sessionBoardId;
    }

    public String getSolutionId() {
        return this.solutionId;
    }

    public void setSolutionId(String solutionId) {
        this.solutionId = solutionId;
    }

    public String getScrumOfScrumId() {
        return this.scrumOfScrumId;
    }

    public void setScrumOfScrumId(String scrumOfScrumId) {
        this.scrumOfScrumId = scrumOfScrumId;
    }

    public String getTeamId() {
        return this.teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public String getSprintId() {
        return this.sprintId;
    }

    public void setSprintId(String sprintId) {
        this.sprintId = sprintId;
    }

    public String getBaseItemId() {
        return this.baseItemId;
    }

    public void setBaseItemId(String baseItemId) {
        this.baseItemId = baseItemId;
    }

    public Map<String, Object> getLinkedBaseItemById() {
        return this.linkedBaseItemById;
    }

    public void setLinkedBaseItemById(Map<String, Object> linkedBaseItemById) {
        this.linkedBaseItemById = linkedBaseItemById;
    }

    public BaseItem getLinkedBaseItem() {
        return this.linkedBaseItem;
    }

    public void setLinkedBaseItem(BaseItem linkedBaseItem) {
        this.linkedBaseItem = linkedBaseItem;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getAlmItemId() {
        return this.almItemId;
    }

    public void setAlmItemId(String almItemId) {
        this.almItemId = almItemId;
    }

    public String getAlmType() {
        return this.almType;
    }

    public void setAlmType(String almType) {
        this.almType = almType;
    }

    public Map<String, Object> getLinkedItemById() {
        return this.linkedItemById;
    }

    public void setLinkedItemById(Map<String, Object> linkedItemById) {
        this.linkedItemById = linkedItemById;
    }

    public Item getLinkedItem() {
        return this.linkedItem;
    }

    public void setLinkedItem(Item linkedItem) {
        this.linkedItem = linkedItem;
    }

    public String getRiskId() {
        return this.riskId;
    }

    public void setRiskId(String riskId) {
        this.riskId = riskId;
    }

    public Map<String, Object> getLinkedRiskById() {
        return this.linkedRiskById;
    }

    public void setLinkedRiskById(Map<String, Object> linkedRiskById) {
        this.linkedRiskById = linkedRiskById;
    }

    public Risk getLinkedRisk() {
        return this.linkedRisk;
    }

    public void setLinkedRisk(Risk linkedRisk) {
        this.linkedRisk = linkedRisk;
    }

    public Double getSequence() {
        return this.sequence;
    }

    public void setSequence(Double sequence) {
        this.sequence = sequence;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public Boolean getIsSystemLink() {
        return this.isSystemLink;
    }

    public void setIsSystemLink(Boolean isSystemLink) {
        this.isSystemLink = isSystemLink;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Double getWeightage() {
        return this.weightage;
    }

    public void setWeightage(Double weightage) {
        this.weightage = weightage;
    }

    public String getLaneId() {
        return this.laneId;
    }

    public void setLaneId(String laneId) {
        this.laneId = laneId;
    }

    public String getKanbanId() {
        return this.kanbanId;
    }

    public void setKanbanId(String kanbanId) {
        this.kanbanId = kanbanId;
    }

    public String getReleaseTrainId() {
        return this.releaseTrainId;
    }

    public void setReleaseTrainId(String releaseTrainId) {
        this.releaseTrainId = releaseTrainId;
    }

    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkType(String linkType) {
        this.linkType = linkType;
    }

    public void adjustLinkedItemIds() {
        if (PropertyValidator.isValid((Object)this.linkedItemById)) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put(this.itemId, true);
        }
    }

    public Integer getBacklogLevel() {
        return this.backlogLevel;
    }

    public void setBacklogLevel(Integer backlogLevel) {
        this.backlogLevel = backlogLevel;
    }

    public ObjectId getBacklogItemId() {
        return this.backlogItemId;
    }

    public void setBacklogItemId(ObjectId backlogItemId) {
        this.backlogItemId = backlogItemId;
    }

    public Set<String> getWorkSpaceIds() {
        return this.workSpaceIds;
    }

    public void setWorkSpaceIds(Set<String> workSpaceIds) {
        this.workSpaceIds = workSpaceIds;
    }

    public String getTeamContainerId() {
        return this.teamContainerId;
    }

    public void setTeamContainerId(String teamContainerId) {
        this.teamContainerId = teamContainerId;
    }

    public String getCustomId() {
        return this.customId;
    }

    public void setCustomId(String customId) {
        this.customId = customId;
    }

    public FieldsLayout getLayout() {
        return this.layout;
    }

    public void setLayout(FieldsLayout layout) {
        this.layout = layout;
    }

    public FieldsLayout getChildLayout() {
        return this.childLayout;
    }

    public void setChildLayout(FieldsLayout childLayout) {
        this.childLayout = childLayout;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

