/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.google.gson.Gson;
import com.viztrend.safe.utils.PropertyValidator;
import java.io.Serializable;
import java.util.HashMap;
import org.springframework.stereotype.Component;

@Component
public class AzureOAuthToken
implements Serializable {
    private static final long serialVersionUID = 8403642808502396822L;
    public static final String CLIENT_ASSERTION_TYPE = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    public static final String GRANT_TYPE_OAUTH = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    public static final String GRANT_TYPE_REFRESH_TOKEN = "refresh_token";
    String accessToken;
    String tokenType;
    String expiresAt;
    String refreshToken;
    String clientId;

    public AzureOAuthToken() {
    }

    public AzureOAuthToken(String accessToken, String tokenType, String expiresAt, String refreshToken) {
        this.accessToken = accessToken;
        this.tokenType = tokenType;
        this.expiresAt = expiresAt;
        this.refreshToken = refreshToken;
    }

    public AzureOAuthToken(HashMap<String, Object> map) {
        this.accessToken = (String)map.get("accessToken");
        this.expiresAt = (String)map.get("expiresAt");
        this.refreshToken = (String)map.get("refreshToken");
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public String getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public static boolean isEmptyToken(AzureOAuthToken azureOAuthToken) {
        if (!PropertyValidator.isValid((Object)azureOAuthToken)) {
            return true;
        }
        return !PropertyValidator.isValid((Object)azureOAuthToken.getAccessToken()) || !PropertyValidator.isValid((Object)azureOAuthToken.getRefreshToken());
    }

    public String toString() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("accessToken", this.accessToken);
        map.put("refreshToken", this.refreshToken);
        map.put("expiresAt", this.expiresAt);
        Gson gson = new Gson();
        String jsonauthMapJSON = gson.toJson(map);
        return jsonauthMapJSON;
    }
}

