/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mongodb.BasicDBObject;
import com.viztrend.safe.alm.jira.bo.JiraField;
import com.viztrend.safe.alm.jira.bo.JiraIssueLinkType;
import com.viztrend.safe.alm.jira.bo.JiraItemFilter;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AzureOAuthToken;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.JiraOauthToken;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.EqualsHashCodeHelper;
import com.viztrend.safe.utils.PropertyValidator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.data.annotation.Transient;

public class AlmAccount
extends BaseEntity {
    private String type;
    private String name;
    private String url;
    private String username;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String password;
    private String webhookURL;
    private Integer webhookId;
    @Transient
    private String usernameForApi;
    @Transient
    private String passwordForApi;
    private Boolean isPrivate = Boolean.FALSE;
    @Transient
    private Boolean isTaggedUser = Boolean.FALSE;
    @Transient
    private Boolean isAdminAlmAcc = Boolean.TRUE;
    @Transient
    private String OAuthTokenOwnerUserId = null;
    private Boolean isActive = Boolean.TRUE;
    private JiraOauthToken jiraOauthToken;
    private String clientId;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String secretKey;
    private String authUrl;
    private JiraField storyPointField;
    private JiraField nextGenStoryPointField;
    private JiraField dueDateField;
    private JiraField startDateField;
    private JiraField endDateField;
    private String atlassianHostDomainId;
    private boolean usingJiraConnect = Boolean.FALSE;
    private boolean isTokenBased = Boolean.FALSE;
    private boolean debug = Boolean.FALSE;
    @Transient
    private List<JiraItemFilter> jiraItemFilters;
    private boolean byPassJiraUserMatch = false;
    private List<JiraIssueLinkType> jiraIssueLinkTypes;
    private String jiraEpicLinkLabel = "Epic Link";
    private String jiraEpicLinkClause = "Epic Link";
    private String jiraEpicNameLabel = "Epic Name";
    private String jiraEpicNameClause = "Epic Name";
    private String jiraEpicColor = "Epic Color";
    private String jiraIssueColor = "Issue Color";
    private JiraAuthType jiraAuthType;
    private AuthType authType;
    private Boolean forceUsingAuth = Boolean.FALSE;
    private String jiraOauthconsumerKey;
    private String jiraOauthprivateKey;
    private String jiraOauthCallbackKey;
    private String jiraAuthRedirectURL;
    private String almURL;
    @Transient
    private Boolean isSelectedOnResync;
    private Map<String, String> testingWebhookForTFS;
    private AzureOAuthToken azureOAuthToken;
    private String directoryId;
    private Boolean excludeMiscStatuses = Boolean.FALSE;
    private Boolean isPatOn;
    @Transient
    private Boolean isPatOnProfile;

    public AlmAccount() {
    }

    public AlmAccount(String id) {
        super(id);
    }

    public AlmAccount(String id, String almAccountType, String name) {
        super(id);
        this.type = almAccountType;
        this.name = name;
    }

    public AlmAccount(BasicDBObject object) {
        this.id = DBUtils.getIdFromDBObject((BasicDBObject)object, (String[])new String[0]);
        this.type = object.getString("type");
        this.name = object.getString("name");
        this.url = object.getString("url");
        this.username = object.getString("username");
        this.almURL = object.getString("almUrl");
        this.jiraAuthRedirectURL = object.getString("jiraAuthRedirectURL");
    }

    public AlmAccount(String type, String name, String url, String username, String password, List<JiraItemFilter> jiraItemFilters) {
        this.type = type;
        this.name = name;
        this.url = url;
        this.username = username;
        this.password = password;
        this.jiraItemFilters = jiraItemFilters;
    }

    public AlmAccount(String type, String name, String url, String username, List<JiraItemFilter> jiraItemFilters) {
        this.type = type;
        this.name = name;
        this.url = url;
        this.username = username;
        this.jiraItemFilters = jiraItemFilters;
    }

    public AlmAccount(String type, String name, String url, String userName, String webhookURL, JiraField storyPointField, JiraField nextGenStoryPointField, JiraField dueDateField, String atlassianHostDomainId, boolean usingJiraConnect, List<JiraItemFilter> jiraItemFilters) {
        this.type = type;
        this.name = name;
        this.url = url;
        this.username = userName;
        this.webhookURL = webhookURL;
        this.storyPointField = storyPointField;
        this.nextGenStoryPointField = nextGenStoryPointField;
        this.dueDateField = dueDateField;
        this.atlassianHostDomainId = atlassianHostDomainId;
        this.usingJiraConnect = usingJiraConnect;
        this.jiraItemFilters = jiraItemFilters;
    }

    public AlmAccount copyWithoutPwd() {
        AlmAccount alm = new AlmAccount(this.type, this.name, this.url, this.username, this.webhookURL, this.storyPointField, this.nextGenStoryPointField, this.dueDateField, this.atlassianHostDomainId, this.usingJiraConnect, this.jiraItemFilters);
        alm.setId(this.id);
        alm.setJiraEpicLinkLabel(this.jiraEpicLinkLabel);
        alm.setJiraEpicNameLabel(this.jiraEpicNameLabel);
        alm.setIsPrivate(this.isPrivate);
        alm.setCreatedBy(this.createdBy);
        alm.setCreatedOn(this.createdOn);
        alm.setUpdatedBy(this.updatedBy);
        alm.setUpdatedOn(this.updatedOn);
        alm.setJiraAuthRedirectURL(this.jiraAuthRedirectURL);
        return alm;
    }

    public boolean usePAT() {
        return Boolean.TRUE.equals(this.isTaggedUser) ? Boolean.TRUE.equals(this.isPatOnProfile) : Boolean.TRUE.equals(this.isPatOn);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @JsonIgnore
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsernameForApi() {
        return this.usernameForApi;
    }

    public void setUsernameForApi(String usernameForApi) {
        this.usernameForApi = usernameForApi;
    }

    public String getPasswordForApi() {
        return this.passwordForApi;
    }

    public void setPasswordForApi(String passwordForApi) {
        this.passwordForApi = passwordForApi;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<JiraItemFilter> getJiraItemFilters() {
        return this.jiraItemFilters;
    }

    public void setJiraItemFilters(List<JiraItemFilter> jiraItemFilters) {
        this.jiraItemFilters = jiraItemFilters;
    }

    public String getWebhookURL() {
        return this.webhookURL;
    }

    public void setWebhookURL(String webhookURL) {
        this.webhookURL = webhookURL;
    }

    public JiraField getStoryPointField() {
        return this.storyPointField;
    }

    public void setStoryPointField(JiraField storyPointField) {
        this.storyPointField = storyPointField;
    }

    public Boolean getAdminAlmAcc() {
        return this.isAdminAlmAcc;
    }

    public void setAdminAlmAcc(Boolean adminUser) {
        this.isAdminAlmAcc = adminUser;
    }

    public JiraField getNextGenStoryPointField() {
        return this.nextGenStoryPointField;
    }

    public void setNextGenStoryPointField(JiraField nextGenStoryPointField) {
        this.nextGenStoryPointField = nextGenStoryPointField;
    }

    public JiraField getDueDateField() {
        return this.dueDateField;
    }

    public void setDueDateField(JiraField dueDateField) {
        this.dueDateField = dueDateField;
    }

    public boolean isUsingJiraConnect() {
        return this.usingJiraConnect;
    }

    public void setUsingJiraConnect(boolean usingJiraConnect) {
        this.usingJiraConnect = usingJiraConnect;
    }

    public String getAtlassianHostDomainId() {
        return this.atlassianHostDomainId;
    }

    public void setAtlassianHostDomainId(String atlassianHostDomainId) {
        this.atlassianHostDomainId = atlassianHostDomainId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AlmAccount [");
        if (this.name != null) {
            builder.append("name=");
            builder.append(this.name);
            builder.append(", ");
        }
        builder.append("usingJiraConnect=");
        builder.append(this.usingJiraConnect);
        builder.append(", ");
        if (this.username != null) {
            builder.append("username=");
            builder.append(this.username);
            builder.append(", ");
        }
        if (this.url != null) {
            builder.append("url=");
            builder.append(this.url);
            builder.append(", ");
        }
        if (this.atlassianHostDomainId != null) {
            builder.append("atlassianHostDomainId=");
            builder.append(this.atlassianHostDomainId);
            builder.append(", ");
        }
        if (this.type != null) {
            builder.append("type=");
            builder.append(this.type);
            builder.append(", ");
        }
        if (this.jiraItemFilters != null) {
            builder.append("jiraItemFilters=");
            builder.append(this.jiraItemFilters);
            builder.append(", ");
        }
        if (this.webhookURL != null) {
            builder.append("webhookURL=");
            builder.append(this.webhookURL);
            builder.append(", ");
        }
        if (this.storyPointField != null) {
            builder.append("storyPointField=");
            builder.append(this.storyPointField);
            builder.append(", ");
        }
        if (this.dueDateField != null) {
            builder.append("dueDateField=");
            builder.append(this.dueDateField);
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean isByPassJiraUserMatch() {
        return this.byPassJiraUserMatch;
    }

    public void setByPassJiraUserMatch(boolean byPassJiraUserMatch) {
        this.byPassJiraUserMatch = byPassJiraUserMatch;
    }

    public List<JiraIssueLinkType> getJiraIssueLinkTypes() {
        return this.jiraIssueLinkTypes;
    }

    public void setJiraIssueLinkTypes(List<JiraIssueLinkType> jiraIssueLinkTypes) {
        this.jiraIssueLinkTypes = jiraIssueLinkTypes;
    }

    public String getJiraEpicLinkLabel() {
        return this.jiraEpicLinkLabel;
    }

    public void setJiraEpicLinkLabel(String jiraEpicLinkLabel) {
        this.jiraEpicLinkLabel = jiraEpicLinkLabel;
    }

    public String getJiraEpicNameLabel() {
        return this.jiraEpicNameLabel;
    }

    public void setJiraEpicNameLabel(String jiraEpicNameLabel) {
        this.jiraEpicNameLabel = jiraEpicNameLabel;
    }

    public String getJiraEpicLinkClause() {
        if (!PropertyValidator.isValid((Object)this.jiraEpicLinkClause)) {
            return this.jiraEpicLinkLabel;
        }
        return this.jiraEpicLinkClause;
    }

    public void setJiraEpicLinkClause(String jiraEpicLinkClause) {
        this.jiraEpicLinkClause = jiraEpicLinkClause;
    }

    public String getJiraEpicNameClause() {
        if (!PropertyValidator.isValid((Object)this.jiraEpicNameClause)) {
            return this.jiraEpicNameLabel;
        }
        return this.jiraEpicNameClause;
    }

    public void setJiraEpicNameClause(String jiraEpicNameClause) {
        this.jiraEpicNameClause = jiraEpicNameClause;
    }

    public boolean isTokenBased() {
        return this.isTokenBased;
    }

    public void setTokenBased(boolean isTokenBased) {
        this.isTokenBased = isTokenBased;
    }

    public Boolean getIsPrivate() {
        return this.isPrivate;
    }

    public void setIsPrivate(Boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    public Boolean getIsTaggedUser() {
        return this.isTaggedUser;
    }

    public void setIsTaggedUser(Boolean isTaggedUser) {
        this.isTaggedUser = isTaggedUser;
    }

    public JiraOauthToken getJiraOauthToken() {
        return this.jiraOauthToken;
    }

    public void setJiraOauthToken(JiraOauthToken jiraOauthToken) {
        this.jiraOauthToken = jiraOauthToken;
    }

    public String getJiraOauthconsumerKey() {
        return this.jiraOauthconsumerKey;
    }

    public void setJiraOauthconsumerKey(String jiraOauthconsumerKey) {
        this.jiraOauthconsumerKey = jiraOauthconsumerKey;
    }

    public String getJiraOauthprivateKey() {
        return this.jiraOauthprivateKey;
    }

    public void setJiraOauthprivateKey(String jiraOauthprivateKey) {
        this.jiraOauthprivateKey = jiraOauthprivateKey;
    }

    public JiraAuthType getJiraAuthType() {
        return this.jiraAuthType;
    }

    public void setJiraAuthType(JiraAuthType jiraAuthType) {
        this.jiraAuthType = jiraAuthType;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public void setAuthType(AuthType authType) {
        this.authType = authType;
    }

    public Boolean getForceUsingAuth() {
        return this.forceUsingAuth;
    }

    public void setForceUsingAuth(Boolean forceUsingAuth) {
        this.forceUsingAuth = forceUsingAuth;
    }

    public String getJiraOauthCallbackKey() {
        return this.jiraOauthCallbackKey;
    }

    public void setJiraOauthCallbackKey(String jiraOauthCallbackKey) {
        this.jiraOauthCallbackKey = jiraOauthCallbackKey;
    }

    public Boolean getIsSelectedOnResync() {
        return this.isSelectedOnResync;
    }

    public void setIsSelectedOnResync(Boolean isSelectedOnResync) {
        this.isSelectedOnResync = isSelectedOnResync;
    }

    public String getJiraAuthRedirectURL() {
        return this.jiraAuthRedirectURL;
    }

    public void setJiraAuthRedirectURL(String jiraAuthRedirectURL) {
        this.jiraAuthRedirectURL = jiraAuthRedirectURL;
    }

    public String getAlmURL() {
        this.almURL = this.jiraAuthRedirectURL != null ? this.jiraAuthRedirectURL : this.url;
        return this.almURL;
    }

    public void setAlmURL(String almURL) {
        this.almURL = almURL;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Map<String, String> getTestingWebhookForTFS() {
        return this.testingWebhookForTFS;
    }

    public void setTestingWebhookForTFS(Map<String, String> testingWebhookForTFS) {
        this.testingWebhookForTFS = testingWebhookForTFS;
    }

    public AzureOAuthToken getAzureOAuthToken() {
        return this.azureOAuthToken;
    }

    public void setAzureOAuthToken(AzureOAuthToken azureOAuthToken) {
        this.azureOAuthToken = azureOAuthToken;
    }

    public String getOAuthTokenOwnerUserId() {
        return this.OAuthTokenOwnerUserId;
    }

    public void setOAuthTokenOwnerUserId(String OAuthTokenOwnerUserId) {
        this.OAuthTokenOwnerUserId = OAuthTokenOwnerUserId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    public void setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
    }

    public String getJiraEpicColor() {
        return this.jiraEpicColor;
    }

    public void setJiraEpicColor(String jiraEpicColor) {
        this.jiraEpicColor = jiraEpicColor;
    }

    public String getJiraIssueColor() {
        return this.jiraIssueColor;
    }

    public void setJiraIssueColor(String jiraIssueColor) {
        this.jiraIssueColor = jiraIssueColor;
    }

    public Integer getWebhookId() {
        return this.webhookId;
    }

    public void setWebhookId(Integer webhookId) {
        this.webhookId = webhookId;
    }

    public JiraField getStartDateField() {
        return this.startDateField;
    }

    public void setStartDateField(JiraField startDateField) {
        this.startDateField = startDateField;
    }

    public JiraField getEndDateField() {
        return this.endDateField;
    }

    public void setEndDateField(JiraField endDateField) {
        this.endDateField = endDateField;
    }

    public String getDirectoryId() {
        return this.directoryId;
    }

    public void setDirectoryId(String directoryId) {
        this.directoryId = directoryId;
    }

    public Boolean getExcludeMiscStatuses() {
        return this.excludeMiscStatuses;
    }

    public void setExcludeMiscStatuses(Boolean excludeMiscStatuses) {
        this.excludeMiscStatuses = excludeMiscStatuses;
    }

    public Boolean getIsPatOn() {
        return this.isPatOn;
    }

    public void setIsPatOn(Boolean isPatOn) {
        this.isPatOn = isPatOn;
    }

    public Boolean getIsPatOnProfile() {
        return this.isPatOnProfile;
    }

    public void setIsPatOnProfile(Boolean isPatOnProfile) {
        this.isPatOnProfile = isPatOnProfile;
    }

    public boolean cloud() {
        return PropertyValidator.isValid((Object)this.url) && this.url.endsWith("atlassian.net");
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        return EqualsHashCodeHelper.equals((Object)this, (Object)o);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), EqualsHashCodeHelper.hashCode((Object)this));
    }
}

