/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.init;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.viztrend.safe.alm.jira.TFSResponse;
import com.viztrend.safe.init.CustomAuthenticationProvider;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

/*
 * Exception performing whole class analysis ignored.
 */
public class TFSOauth2ADFilter2
extends AbstractAuthenticationProcessingFilter {
    private CustomAuthenticationProvider customAuthenticationProvider;
    private static Gson gson = new GsonBuilder().create();
    private static HttpClient httpclient = HttpClients.createMinimal();
    private static final Logger LOGGER = LoggerFactory.getLogger(TFSOauth2ADFilter2.class);
    private UserRepository userRepository;
    private static String tokenUrl = "https://login.microsoftonline.com/common/oauth2/v2.0//token";
    private static String authUrl = "https://login.microsoftonline.com/common/oauth2/v2.0/authorize";
    private static String scope = "vso.build vso.code vso.connected_server vso.dashboards vso.entitlements vso.extension vso.extension.data vso.gallery vso.graph vso.identity vso.loadtest vso.machinegroup_manage vso.memberentitlementmanagement vso.notification_diagnostics vso.packaging vso.project vso.release vso.security_manage vso.serviceendpoint vso.symbols vso.taskgroups_read vso.test vso.tokenadministration vso.tokens vso.variablegroups_read vso.wiki vso.work";
    private static String clientId;
    private static String clientSec;
    private static String redirectUrl;

    public TFSOauth2ADFilter2(String path, CustomAuthenticationProvider customAuthenticationProvider) {
        super(path);
        this.customAuthenticationProvider = customAuthenticationProvider;
    }

    public synchronized Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) {
        String state = "new";
        String nonce = "678910";
        if (UserContextUtil.getUserContext() != null && UserContextUtil.getUserContext().getUserContextDTO().getContextMap().get("tfs_refresh_token") != null) {
            try {
                response.sendRedirect("/");
            }
            catch (IOException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            return null;
        }
        String code = request.getParameter("code");
        if (PropertyValidator.isValid((Object)code)) {
            Map resultMap = null;
            Map userInfoMap = null;
            try {
                resultMap = TFSOauth2ADFilter2.getAccessToken((String)"authorization_code", (String)code);
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            String access_token = String.valueOf(resultMap.get("access_token"));
            String refresh_token = String.valueOf(resultMap.get("refresh_token"));
            String idToken = String.valueOf(resultMap.get("id_token"));
            if (PropertyValidator.isValid((Object)idToken)) {
                userInfoMap = TFSOauth2ADFilter2.getUserInfo((String)idToken);
            }
            if (UserContextUtil.getUserContext() != null) {
                this.setTokenInContext(refresh_token);
                try {
                    response.sendRedirect("/tfsgettest");
                }
                catch (IOException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
                return null;
            }
            String principal = String.valueOf(userInfoMap.get("preferred_username"));
            String displayName = String.valueOf(userInfoMap.get("name"));
            SecureUser secureUser = this.customAuthenticationProvider.getUserContext(principal);
            if (secureUser == null) {
                secureUser = new SecureUser(principal, "");
                HashMap<String, String> infoMap = new HashMap<String, String>();
                infoMap.put("name", displayName);
                infoMap.put("email", principal);
                secureUser.setOauthInfoMap(infoMap);
            }
            if (secureUser.getUserContextDTO() != null) {
                secureUser.getUserContextDTO().getContextMap().put("tfs", "true");
                secureUser.getUserContextDTO().getContextMap().put("tfs_refresh_token", refresh_token);
            }
            UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)secureUser, (Object)"", secureUser.getAuthorities());
            return usernamePasswordAuthenticationToken;
        }
        String newLocal = authUrl + "?client_id=" + clientId + "&response_type=code&response_mode=form_post&state=" + state + "&prompt=select_account&scope=openid+offline_access+profile+email+user.read&nonce=" + nonce + "&redirect_uri=" + redirectUrl;
        try {
            response.sendRedirect(newLocal);
            return null;
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    private void setTokenInContext(String token) {
        User user = this.userRepository.findById(UserContextUtil.getUserContext().getLoggedInUser().getId());
        UserContextUtil.getUserContext().getUserContextDTO().getContextMap().put("tfs_refresh_token", token);
        this.userRepository.save((Object)user);
    }

    public static Map<?, ?> getAccessToken(String grandType, String accessCode) throws Exception {
        HttpPost httppost = new HttpPost(tokenUrl);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(2);
        if (grandType.equals("refresh_token")) {
            params.add(new BasicNameValuePair("grant_type", "refresh_token"));
            params.add(new BasicNameValuePair("refresh_token", accessCode));
        } else {
            params.add(new BasicNameValuePair("grant_type", grandType));
            params.add(new BasicNameValuePair("code", accessCode));
        }
        params.add(new BasicNameValuePair("client_id", clientId));
        params.add(new BasicNameValuePair("client_secret", clientSec));
        params.add(new BasicNameValuePair("redirect_uri", redirectUrl));
        UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(params, "UTF-8");
        httppost.setEntity((HttpEntity)urlEncodedFormEntity);
        httppost.setHeader("Content-Type", "application/x-www-form-urlencoded");
        HttpResponse postResponse = httpclient.execute((HttpUriRequest)httppost);
        LOGGER.debug("request body:" + TFSOauth2ADFilter2.convertStreamToString((InputStream)httppost.getEntity().getContent()));
        HttpEntity entity = postResponse.getEntity();
        try (InputStream instream = entity.getContent();){
            Map resultMap = (Map)gson.fromJson(TFSOauth2ADFilter2.convertStreamToString((InputStream)instream), Map.class);
            if (UserContextUtil.getUserContext() != null) {
                UserContextUtil.getUserContext().getUserContextDTO().getContextMap().put("tfs_refresh_token", resultMap.get("refresh_token"));
            }
            Map map = resultMap;
            return map;
        }
    }

    static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public static TFSResponse executeGetRequest(String url, String accessToken) {
        HttpGet get = new HttpGet(url);
        get.addHeader("Authorization", accessToken);
        get.addHeader("Content-type", "application/json-patch+json");
        try {
            HttpResponse response = httpclient.execute((HttpUriRequest)get);
            Integer status = response.getStatusLine().getStatusCode();
            String content = TFSOauth2ADFilter2.convertStreamToString((InputStream)response.getEntity().getContent());
            TFSResponse tFSResponse = new TFSResponse();
            tFSResponse.setContent(content);
            tFSResponse.setStatusCode(status);
            return tFSResponse;
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public static TFSResponse executePatchRequest(String url, String accessToken, String body) {
        HttpPatch post = new HttpPatch(url);
        String json = body;
        try {
            StringEntity entity = new StringEntity(json);
            post.setEntity((HttpEntity)entity);
            post.setHeader("Content-type", "application/json-patch+json");
            post.addHeader("Authorization", accessToken);
            HttpResponse postResponse = httpclient.execute((HttpUriRequest)post);
            Integer status = postResponse.getStatusLine().getStatusCode();
            String reason = postResponse.getStatusLine().getReasonPhrase();
            String content = TFSOauth2ADFilter2.convertStreamToString((InputStream)postResponse.getEntity().getContent());
            TFSResponse tFSResponse = new TFSResponse();
            tFSResponse.setContent(content);
            tFSResponse.setReason(reason);
            tFSResponse.setStatusCode(status);
            return tFSResponse;
        }
        catch (Exception ex) {
            LOGGER.error("Error while sending email :" + StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    public static TFSResponse executePostRequest(String url, String accessToken, String body) {
        HttpPost post = new HttpPost(url);
        String json = body;
        try {
            StringEntity entity = new StringEntity(json);
            post.setEntity((HttpEntity)entity);
            post.setHeader("Content-type", "application/json");
            post.addHeader("Authorization", accessToken);
            HttpResponse postResponse = httpclient.execute((HttpUriRequest)post);
            Integer status = postResponse.getStatusLine().getStatusCode();
            String content = TFSOauth2ADFilter2.convertStreamToString((InputStream)postResponse.getEntity().getContent());
            TFSResponse tFSResponse = new TFSResponse();
            tFSResponse.setContent(content);
            tFSResponse.setStatusCode(status);
            return tFSResponse;
        }
        catch (Exception ex) {
            LOGGER.error("Error while sending email :" + StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    public static void setClientId(String clientId) {
        TFSOauth2ADFilter2.clientId = clientId;
    }

    public static void setClientSec(String clientSec) {
        TFSOauth2ADFilter2.clientSec = clientSec;
    }

    public static void setRedirectUrl(String redirectUrl) {
        TFSOauth2ADFilter2.redirectUrl = redirectUrl;
    }

    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    private static Map getUserInfo(String jwtToken) {
        System.out.println("------------ Decode JWT ------------");
        String[] split_string = jwtToken.split("\\.");
        String base64EncodedHeader = split_string[0];
        String base64EncodedBody = split_string[1];
        String base64EncodedSignature = split_string[2];
        System.out.println("~~~~~~~~~ JWT Header ~~~~~~~");
        Base64 base64Url = new Base64(true);
        String header = new String(base64Url.decode(base64EncodedHeader));
        System.out.println("JWT Header : " + header);
        System.out.println("~~~~~~~~~ JWT Body ~~~~~~~");
        String body = new String(base64Url.decode(base64EncodedBody));
        System.out.println("JWT Body : " + body);
        return (Map)new Gson().fromJson(body, Map.class);
    }
}

