/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.init;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.viztrend.safe.init.CustomAuthenticationProvider;
import com.viztrend.safe.persistence.entity.Oauth2Config;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.Oauth2ConfigRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

/*
 * Exception performing whole class analysis ignored.
 */
public class OktaOauth2Filter
extends AbstractAuthenticationProcessingFilter {
    private CustomAuthenticationProvider customAuthenticationProvider;
    private static Gson gson = new GsonBuilder().create();
    private static HttpClient httpclient = HttpClients.createMinimal();
    private static final Logger LOGGER = LoggerFactory.getLogger(OktaOauth2Filter.class);
    private UserRepository userRepository;
    private Oauth2ConfigRepository oauth2ConfigRepository;
    private static String scope = "openid+profile+email";

    public OktaOauth2Filter(String path, CustomAuthenticationProvider customAuthenticationProvider) {
        super(path);
        this.customAuthenticationProvider = customAuthenticationProvider;
    }

    public synchronized Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) {
        String state = "new";
        String code = request.getParameter("code");
        String tokenUrl = null;
        String authUrl = null;
        String clientId = null;
        String clientSec = null;
        String redirectUrl = null;
        String oktaDomain = null;
        List oauth2ConfigList = this.oauth2ConfigRepository.findByProvider("okta");
        if (PropertyValidator.isValid((Collection)oauth2ConfigList)) {
            Oauth2Config oauth2Config = (Oauth2Config)oauth2ConfigList.get(0);
            oktaDomain = oauth2Config.getDomain() + ".okta.com";
            tokenUrl = "https://" + oktaDomain + "/oauth2/v1/token";
            authUrl = "https://" + oktaDomain + "/oauth2/v1/authorize";
            clientId = oauth2Config.getClientId();
            clientSec = oauth2Config.getClientSecret();
            redirectUrl = oauth2Config.getRedirectUrl();
        }
        if (PropertyValidator.isValid((Object)code)) {
            Map resultMap = null;
            try {
                resultMap = OktaOauth2Filter.getAccessToken((String)code, clientId, clientSec, redirectUrl, tokenUrl);
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            String access_token = String.valueOf(resultMap.get("access_token"));
            String userInfoJson = OktaOauth2Filter.executeGetRequest((String)("https://" + oktaDomain + "/oauth2/v1/userinfo"), (String)("Bearer " + access_token));
            LOGGER.debug("userInfoJson -- >" + userInfoJson);
            Map userInfoMap = (Map)gson.fromJson(userInfoJson, Map.class);
            String email = String.valueOf(userInfoMap.get("email"));
            String displayName = String.valueOf(userInfoMap.get("name"));
            String givenName = String.valueOf(userInfoMap.get("given_name"));
            String FamilyName = String.valueOf(userInfoMap.get("family_name"));
            SecureUser secureUser = this.customAuthenticationProvider.getUserContext(email);
            if (secureUser == null) {
                secureUser = new SecureUser(email, "");
                HashMap<String, String> infoMap = new HashMap<String, String>();
                infoMap.put("name", displayName);
                infoMap.put("email", email);
                infoMap.put("firstName", givenName);
                infoMap.put("lastName", FamilyName);
                secureUser.setOauthInfoMap(infoMap);
            }
            UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)secureUser, (Object)"", secureUser.getAuthorities());
            return usernamePasswordAuthenticationToken;
        }
        String newLocal = authUrl + "?client_id=" + clientId + "&response_type=code&state=" + state + "&scope=" + scope + "&redirect_uri=" + redirectUrl;
        try {
            response.sendRedirect(newLocal);
            return null;
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public static Map<?, ?> getAccessToken(String accessCode, String clientId, String clientSec, String redirectUrl, String tokenUrl) throws Exception {
        HttpPost httppost = new HttpPost(tokenUrl);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(2);
        params.add(new BasicNameValuePair("client_id", clientId));
        params.add(new BasicNameValuePair("client_secret", clientSec));
        params.add(new BasicNameValuePair("grant_type", "authorization_code"));
        params.add(new BasicNameValuePair("redirect_uri", redirectUrl));
        params.add(new BasicNameValuePair("code", accessCode));
        UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(params, "UTF-8");
        httppost.setEntity((HttpEntity)urlEncodedFormEntity);
        HttpResponse postResponse = httpclient.execute((HttpUriRequest)httppost);
        HttpEntity entity = postResponse.getEntity();
        try (InputStream instream = entity.getContent();){
            Map resultMap;
            Map map = resultMap = (Map)gson.fromJson(OktaOauth2Filter.convertStreamToString((InputStream)instream), Map.class);
            return map;
        }
    }

    static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public static String executeGetRequest(String url, String accessToken) {
        HttpGet get = new HttpGet(url);
        get.addHeader("Authorization", accessToken);
        get.addHeader("Content-type", "application/json-patch+json");
        try {
            HttpResponse getResponse = httpclient.execute((HttpUriRequest)get);
            return OktaOauth2Filter.convertStreamToString((InputStream)getResponse.getEntity().getContent());
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public static <T> String executePostRequest(String url, String accessToken, String body) {
        HttpPost post = new HttpPost(url);
        String json = body;
        try {
            StringEntity entity = new StringEntity(json);
            post.setEntity((HttpEntity)entity);
            post.setHeader("Content-type", "application/json-patch+json");
            post.addHeader("Authorization", accessToken);
            HttpResponse postResponse = httpclient.execute((HttpUriRequest)post);
            return OktaOauth2Filter.convertStreamToString((InputStream)postResponse.getEntity().getContent());
        }
        catch (Exception ex) {
            LOGGER.error("Error while sending email :" + StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public Oauth2ConfigRepository getOauth2ConfigRepository() {
        return this.oauth2ConfigRepository;
    }

    public void setOauth2ConfigRepository(Oauth2ConfigRepository oauth2ConfigRepository) {
        this.oauth2ConfigRepository = oauth2ConfigRepository;
    }
}

