/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.init;

import com.google.gson.Gson;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.SecurityPolicy;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.utils.EncDecUtility;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.SystemUtil;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component
class CustomAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private Environment env;
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomAuthenticationSuccessHandler.class);
    @Autowired
    private CompanyRepository companyRepository;
    public static final String REQ_SESSION_COOKIE_MAX_AGE_SECS = "REQ_SESSION_COOKIE_MAX_AGE_SECS";
    private static final int DEFAULT_IDLE_MIN = 120;
    private static final int DEFAULT_MAXAGE_MIN = 2880;

    CustomAuthenticationSuccessHandler() {
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        HttpSession session = request.getSession(false);
        if (session != null) {
            Company company = this.resolveCompany();
            if (company != null) {
                LOGGER.debug("Company is:" + company.getUrlPrefix());
            }
            SecurityPolicy sp = company != null ? company.getSecurityPolicy() : null;
            int idleMin = sp != null && sp.getSessionInactivityTimeout() != null ? sp.getSessionInactivityTimeout() : 120;
            LOGGER.debug("Idle time is:" + idleMin + " minutes");
            int maxAgeMin = sp != null && sp.getSessionMaxAge() != null ? sp.getSessionMaxAge() : 2880;
            LOGGER.debug("MaxAge is:" + maxAgeMin + " minutes");
            session.setMaxInactiveInterval(Math.max(1, idleMin) * 60);
            int cookieMaxAgeSecs = Math.max(1, maxAgeMin) * 60;
            request.setAttribute(REQ_SESSION_COOKIE_MAX_AGE_SECS, (Object)cookieMaxAgeSecs);
            String jsid = session.getId();
            boolean prod = "prod".equals(this.env.getProperty("app.env"));
            String domain = prod ? this.env.getProperty("server.domain") : null;
            StringBuilder sb = new StringBuilder();
            sb.append("JSESSIONID=").append(jsid).append("; Path=/").append("; Max-Age=").append(cookieMaxAgeSecs).append("; HttpOnly");
            if (prod) {
                sb.append("; Secure");
            }
            if (domain != null && !domain.isEmpty()) {
                sb.append("; Domain=").append(domain);
            }
            response.addHeader("Set-Cookie", sb.toString());
        }
        SecureUser secureUser = UserContextUtil.getUserContext();
        String origin = SystemUtil.getOrigin((HttpServletRequest)request);
        if (!PropertyValidator.isValid((Object)origin)) {
            origin = "";
        }
        if (PropertyValidator.isValid((Object)origin) && !origin.contains(request.getServerName())) {
            origin = secureUser.getldapUser() != null && secureUser.getldapUser().getOrigin() != null ? secureUser.getldapUser().getOrigin() : "https://" + request.getServerName();
        }
        if (secureUser.isLoginWithError()) {
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println("<html>");
            out.println("<head><title>Unauthorized</title></head>");
            out.println("<body>");
            out.println("<h1>Unauthorized</h1>");
            out.println("<p>Users or guest users limit exceeded, please contact admin.</p>");
            out.println("<a href=\"/signout\">Logout</a>");
            out.println("</body>");
            out.println("</html>");
            return;
        }
        if (secureUser.getUserContextDTO() == null) {
            String oauthInfo = null;
            try {
                oauthInfo = EncDecUtility.encryptSimple((String)new Gson().toJson((Object)UserContextUtil.getUserContext().getOauthInfoMap()));
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            response.sendRedirect(origin + "/welcome?signupinfo=" + oauthInfo);
        } else {
            if ("true".equals(secureUser.getUserContextDTO().getContextMap().get("tfs"))) {
                Cookie cookie = new Cookie("auth_method", "tfs");
                cookie.setPath("/");
                response.addCookie(cookie);
            }
            Company updatedCompany = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompanyId());
            boolean isPremiumBilling = false;
            isPremiumBilling = !PropertyValidator.isValid((Object)updatedCompany.getPaymentPackageConfig()) ? true : (!PropertyValidator.isValid((Object)updatedCompany.getPaymentPackageConfig().getMFA()) ? updatedCompany.getIsPremium().booleanValue() : updatedCompany.getPaymentPackageConfig().getMFA().booleanValue());
            if (isPremiumBilling) {
                User user = this.userRepository.findByUserNameIgnoreCase(secureUser.getUsername());
                SecurityPolicy securityPolicy = updatedCompany.getSecurityPolicy();
                boolean isForceMfaForAllCompanyUsers = PropertyValidator.isValid((Object)securityPolicy) && PropertyValidator.isValid((Object)securityPolicy.isForceMfaForAllUsers()) && securityPolicy.isForceMfaForAllUsers();
                boolean skipMfa = PropertyValidator.isValid((Object)UserContextUtil.getUserContext().getldapUser());
                if (!skipMfa && user.getMfaCodeSec() != null) {
                    UserContextUtil.getUserContext().getLoggedInUser().setRequireMFACode(true);
                    user.setRequireMFACode(true);
                    this.userRepository.save((Object)user);
                    response.sendRedirect(origin + "/mfa");
                } else if (!skipMfa && (isForceMfaForAllCompanyUsers || PropertyValidator.isValid((Object)user.getforcedMFA()) && user.getforcedMFA().booleanValue())) {
                    UserContextUtil.getUserContext().getLoggedInUser().setRequireMFACode(true);
                    user.setRequireMFACode(true);
                    this.userRepository.save((Object)user);
                    response.sendRedirect(origin + "/mfaactivation");
                } else {
                    UserContextUtil.getUserContext().getLoggedInUser().setRequireMFACode(false);
                    response.sendRedirect(origin + "/");
                }
            } else {
                UserContextUtil.getUserContext().getLoggedInUser().setRequireMFACode(false);
                response.sendRedirect(origin + "/");
            }
        }
    }

    private Company resolveCompany() {
        List list;
        Object companiesObj;
        Object companyCtx;
        SecureUser su = UserContextUtil.getUserContext();
        if (su == null) {
            return null;
        }
        if (su.getUserContextDTO() != null && su.getUserContextDTO().getContextMap() != null && (companyCtx = su.getUserContextDTO().getContextMap().get("company")) instanceof Map && (companiesObj = ((Map)companyCtx).get("companies")) instanceof List && (list = (List)companiesObj).size() == 1 && list.get(0) instanceof Company) {
            return (Company)list.get(0);
        }
        String companyId = su.getCurrentCompanyId();
        return companyId != null ? this.companyRepository.findById(companyId) : null;
    }
}

