/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.init;

import com.viztrend.safe.persistence.entity.AppAuditLog;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.utils.EncDecUtility;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.stereotype.Component;

@Component
class CustomAuthenticationFailureHandler
implements AuthenticationFailureHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomAuthenticationFailureHandler.class);
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private CompanyRepository companyRepository;
    @Autowired
    MongoTemplate mongoTemplate;

    CustomAuthenticationFailureHandler() {
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        User user;
        String errMsg = null;
        String origin = request.getHeader("origin");
        String attemptedUser = request.getParameter("u");
        int tressPassTries = -1;
        if (attemptedUser != null && PropertyValidator.isValid((Object)(user = this.userRepository.findByUserNameIgnoreCase(attemptedUser))) && !user.isLocked()) {
            for (UserCompany uc : user.getUserCompanies()) {
                Company c;
                if (!PropertyValidator.isValid((Object)uc) || !uc.getIsActive().booleanValue() || !PropertyValidator.isValid((Object)(c = this.companyRepository.findById(uc.getCompany().getId()))) || !PropertyValidator.isValid((Object)c.getSecurityPolicy())) continue;
                tressPassTries = c.getSecurityPolicy().getTressPassTries();
            }
            if (tressPassTries != -1) {
                int currTreePassCount = user.getTressPassCount();
                if (currTreePassCount >= tressPassTries) {
                    user.setLocked(true);
                    this.userRepository.save((Object)user);
                    exception = new /* Unavailable Anonymous Inner Class!! */;
                } else {
                    user.setTressPassCount(user.getTressPassCount() + 1);
                    this.userRepository.save((Object)user);
                    exception = new /* Unavailable Anonymous Inner Class!! */;
                }
            }
        }
        if (!PropertyValidator.isValid((Object)origin)) {
            origin = "";
        }
        if (exception.getMessage().contains("UserDetailsService returned null") || exception.getMessage().contains("Bad credentials")) {
            errMsg = "The email or password entered is incorrect";
            String ip = request.getHeader("X-Forwarded-For");
            if (ip == null || "".equals(ip)) {
                ip = request.getRemoteAddr();
            }
            try {
                AppAuditLog appAuditLog = new AppAuditLog();
                appAuditLog.setEventBy(attemptedUser);
                appAuditLog.setEventSource(ip);
                this.mongoTemplate.insert((Object)appAuditLog);
            }
            catch (Exception ex) {
                LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            }
        } else {
            errMsg = exception.getMessage();
        }
        try {
            errMsg = EncDecUtility.encryptSimple((String)errMsg);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        response.sendRedirect(origin + "/login?error=" + errMsg);
        exception.printStackTrace();
    }
}

