/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.init;

import com.google.common.collect.ImmutableList;
import com.google.common.net.InternetDomainName;
import com.okta.saml.Application;
import com.okta.saml.SAMLLogoutRequest;
import com.okta.saml.SAMLRequest;
import com.okta.saml.SAMLResponse;
import com.okta.saml.SAMLValidator;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.init.CustomAuthenticationProvider;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.Group;
import com.viztrend.safe.persistence.entity.SAMLConfig;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.dto.LdapUser;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.GroupRepository;
import com.viztrend.safe.persistence.repository.InvitationRepository;
import com.viztrend.safe.persistence.repository.SAMLConfigRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.service.UserService;
import com.viztrend.safe.utils.EncDecUtility;
import com.viztrend.safe.utils.MongoSyncUtils;
import com.viztrend.safe.utils.PropertyValidator;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.RequestAbstractType;
import org.opensaml.saml2.core.Response;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.security.SecurityConfiguration;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.signature.impl.SignatureBuilder;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.rememberme.PersistentRememberMeToken;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class AzureSamlRequestFilter
extends AbstractAuthenticationProcessingFilter {
    protected static final String SAML_REQUEST = "SAMLRequest";
    protected static final String SAML_RESPONSE = "SAMLResponse";
    protected static final String RELAY_STATE = "RelayState";
    public static final String C14NEXC = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String RSA_SHA256 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    public static final String POST_SAML_SIGNED_AUTH = "/login/saml/postSAMLSignedAuth";
    public static final String POST_SAML_SIGNED_LOGOUT = "/logout/saml/postSAMLSignedLogout";
    public static final String KENDIS_SAML_LOGIN_URL = "/login/saml";
    public static final String KENDIS_SAML_LOGOUT_URL = "/logout/saml";
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureSamlRequestFilter.class);
    protected SAMLValidator validator;
    private CustomAuthenticationProvider customAuthenticationProvider;
    private UserRepository userRepository;
    private InvitationRepository invitationRepository;
    private GroupRepository groupRepository;
    private SAMLConfigRepository samlConfigRepository;
    private String file;
    private CompanyRepository companyRepository;
    private boolean isLocalDeployment = false;
    private UserService userService;
    private AppConfig.MongoConfig mongoConfig;
    PersistentTokenRepository tokenRepository;

    public void setTokenRepository(PersistentTokenRepository tokenRepository) {
        this.tokenRepository = tokenRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AzureSamlRequestFilter(String path, CustomAuthenticationProvider customAuthenticationProvider, SAMLConfigRepository samlConfigRepository, Environment env) {
        super(path);
        this.customAuthenticationProvider = customAuthenticationProvider;
        this.samlConfigRepository = samlConfigRepository;
        this.isLocalDeployment = env.getProperty("isLocalDeployment").equals("true");
        try {
            try (InputStream stream = Application.class.getResourceAsStream("/valid-config.xml");){
                this.file = AzureSamlRequestFilter.convertStreamToString((InputStream)stream);
            }
            this.validator = new SAMLValidator();
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
    }

    protected AzureSamlRequestFilter(RequestMatcher requiresAuthenticationRequestMatcher) {
        super(requiresAuthenticationRequestMatcher);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        Company company = null;
        ImmutableList parts = InternetDomainName.from((String)request.getServerName()).parts();
        String subDomain = null;
        Application app = null;
        com.okta.saml.Configuration configuration = null;
        LOGGER.debug("parts ---- " + parts);
        if (!this.isLocalDeployment && parts.size() > 1) {
            subDomain = (String)parts.get(0);
            LOGGER.debug("subdomain to fetch company ---- " + subDomain);
            company = this.companyRepository.findByUrlPrefix(subDomain);
        } else {
            company = (Company)this.companyRepository.findAll().get(0);
        }
        if (company == null) {
            PrintWriter writer = response.getWriter();
            response.setHeader("Content-Type", "text/html");
            writer.write("<html><body>No SAML configuration found.</body></html>");
            return null;
        }
        String replaceFile = this.file;
        SAMLConfig config = this.samlConfigRepository.findByTenant(company.getTenant());
        LOGGER.debug("inside get method ...... ");
        LOGGER.debug("config is  ...... " + config);
        if (config == null) {
            PrintWriter writer = response.getWriter();
            response.setHeader("Content-Type", "text/html");
            writer.write("<html><body>No SAML configuration found.</body></html>");
            return null;
        }
        this.logger.debug((Object)("SAML Config :" + config));
        if (PropertyValidator.isValid((Object)config)) {
            replaceFile = replaceFile.replaceAll("identity_provider_issuer", config.getIdentityProviderIssuer());
            replaceFile = replaceFile.replaceAll("xcertificate", config.getXcertificate());
            replaceFile = replaceFile.replaceAll("identity_provider_single_sign", config.getIdentityProviderSingleSign());
            if (config.getIdentityProviderSingleSignOut() != null) {
                replaceFile = replaceFile.replaceAll("identity_provider_single_log_out", config.getIdentityProviderSingleSignOut());
            }
        } else {
            return null;
        }
        this.logger.debug((Object)("SAML Config after replace :" + replaceFile));
        try {
            this.logger.debug((Object)("Before getting configuration :" + replaceFile));
            configuration = this.validator.getConfiguration(replaceFile);
        }
        catch (SecurityPolicyException e) {
            PrintWriter writer = response.getWriter();
            response.setHeader("Content-Type", "text/html");
            writer.write("<html><body>" + e.getMessage() + "</body></html>");
            return null;
        }
        app = configuration.getDefaultApplication();
        app.setConfig(config);
        if (configuration.getDefaultEntityID() == null) {
            LOGGER.error("Default application has not been configured in configuration.");
        } else if (app == null) {
            LOGGER.error("Could not find default application in configuration: " + configuration.getDefaultEntityID());
        }
        if (request.getMethod().equals("POST") && (request.getRequestURI().endsWith("/login/saml/postSAMLSignedAuth") || request.getRequestURI().endsWith("/logout/saml/postSAMLSignedLogout"))) {
            response.setStatus(307);
            if (request.getRequestURI().endsWith("/login/saml/postSAMLSignedAuth")) {
                response.setHeader("Location", app.getAuthenticationURL());
            } else if (request.getRequestURI().endsWith("/logout/saml/postSAMLSignedLogout")) {
                response.setHeader("Location", app.getLogoutURL());
            }
        } else {
            if (request.getMethod().equals("POST")) {
                ArrayList tempList;
                Map samlResponse = null;
                try {
                    samlResponse = this.doPost(request, response, configuration);
                }
                catch (Exception ex) {
                    LOGGER.error("Error in saml response :" + com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
                    PrintWriter writer = response.getWriter();
                    response.setHeader("Content-Type", "text/html");
                    writer.write("<html><body>Invalid SAML configuration." + ex.getMessage() + "</body></html>");
                    return null;
                }
                LOGGER.debug("saml response ------- :" + samlResponse);
                LOGGER.debug("saml response :" + samlResponse);
                if (samlResponse == null) {
                    PrintWriter writer = response.getWriter();
                    response.setHeader("Content-Type", "text/html");
                    writer.write("<html><body>Invalid SAML configuration.</body></html>");
                    return null;
                }
                String firstName = null;
                String lastName = null;
                String email = null;
                if (PropertyValidator.isValid(samlResponse.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress"))) {
                    email = String.valueOf(samlResponse.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress"));
                } else if (PropertyValidator.isValid(samlResponse.get("login"))) {
                    email = String.valueOf(samlResponse.get("login"));
                }
                firstName = PropertyValidator.isValid(samlResponse.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname")) ? String.valueOf(samlResponse.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname")) : (PropertyValidator.isValid(samlResponse.get("firstName")) ? String.valueOf(samlResponse.get("firstName")) : "unknow");
                lastName = PropertyValidator.isValid(samlResponse.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname")) ? String.valueOf(samlResponse.get("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname")) : (PropertyValidator.isValid(samlResponse.get("lastName")) ? String.valueOf(samlResponse.get("lastName")) : "unknow");
                LdapUser ldapUser = new LdapUser();
                if (PropertyValidator.isValid(samlResponse.get("groups"))) {
                    if (samlResponse.get("groups") instanceof List) {
                        ldapUser.setGroups((List)samlResponse.get("groups"));
                    } else if (samlResponse.get("groups") instanceof Object) {
                        tempList = new ArrayList();
                        tempList.add(samlResponse.get("groups"));
                        ldapUser.setGroups(tempList);
                    }
                } else if (PropertyValidator.isValid(samlResponse.get("http://schemas.microsoft.com/ws/2008/06/identity/claims/groups"))) {
                    if (samlResponse.get("http://schemas.microsoft.com/ws/2008/06/identity/claims/groups") instanceof List) {
                        ldapUser.setGroups((List)samlResponse.get("http://schemas.microsoft.com/ws/2008/06/identity/claims/groups"));
                    } else if (samlResponse.get("http://schemas.microsoft.com/ws/2008/06/identity/claims/groups") instanceof Object) {
                        tempList = new ArrayList();
                        tempList.add(samlResponse.get("http://schemas.microsoft.com/ws/2008/06/identity/claims/groups"));
                        ldapUser.setGroups(tempList);
                    }
                } else if (PropertyValidator.isValid((Object)config.getGroup())) {
                    ArrayList<String> gpList = new ArrayList<String>();
                    gpList.add(config.getGroup().getTitle());
                    ldapUser.setGroups(gpList);
                }
                ldapUser.setProvider("okta");
                String samlUserId = null;
                if (samlResponse.get("saml_user_id") != null) {
                    samlUserId = samlResponse.get("saml_user_id").toString();
                }
                if (email != null) {
                    User dbUserOld = this.userRepository.findByUserNameIgnoreCase(email);
                    HashSet groups = new HashSet();
                    groups.addAll(ldapUser.getGroups());
                    if (PropertyValidator.isValid(groups)) {
                        LOGGER.debug("loggedin user gorups -- >" + Arrays.toString(groups.toArray()));
                    }
                    List groupList = this.groupRepository.findByTitleInOrExternalReferenceInAndTenant(new ArrayList(groups), new ArrayList(groups), company.getTenant());
                    List externalReferencesMatched = groupList.stream().map(Group::getExternalReference).filter(groups::contains).collect(Collectors.toList());
                    if (dbUserOld == null) {
                        User dbUser = new User();
                        UserCompany uc = new UserCompany();
                        uc.setCompany(company);
                        dbUser.setUserCompanies(new ArrayList());
                        dbUser.getUserCompanies().add(uc);
                        dbUser.setExternalReferenceGroups(externalReferencesMatched);
                        ArrayList<Group> matchedGroupsFiltered = new ArrayList<Group>();
                        if (PropertyValidator.isValid((Collection)groupList)) {
                            for (Group gp : groupList) {
                                if (gp.isArchive() || !gp.getTenant().equals(company.getTenant())) continue;
                                matchedGroupsFiltered.add(gp);
                                if (!gp.isForGuestUsers()) continue;
                                LOGGER.debug("setting user as guest");
                                dbUser.setIsGuest(Boolean.valueOf(true));
                                ((UserCompany)dbUser.getUserCompanies().get(0)).setIsGuest(Boolean.valueOf(true));
                            }
                        }
                        LOGGER.debug("check for group match ---- > :" + PropertyValidator.isValid(matchedGroupsFiltered) + " config status ---- > :" + config.isAddAsInActiveUser());
                        if (!PropertyValidator.isValid(matchedGroupsFiltered) && config.isAddAsInActiveUser()) {
                            ((UserCompany)dbUser.getUserCompanies().get(0)).setIsActive(Boolean.valueOf(false));
                        }
                        Map packageDetailsCount = this.userService.getPackageLimitCount(company);
                        Long usersCount = packageDetailsCount.getOrDefault("userCount", 0L);
                        Long pkgUsersCount = (Long)packageDetailsCount.get("pkgUserCount");
                        Long guestUserCount = packageDetailsCount.getOrDefault("guestUserCount", 0L);
                        Long pkgGuestUsersCount = (Long)packageDetailsCount.get("pkgGuestUserCount");
                        LOGGER.debug("package guest users:" + pkgGuestUsersCount + " active guest users:" + guestUserCount);
                        LOGGER.debug("active users count + pending invitation count is ---- > " + usersCount + " | package users count ---- > " + pkgUsersCount);
                        boolean isLimitExceeded = true;
                        if (!dbUser.getIsActive().booleanValue()) {
                            isLimitExceeded = false;
                        } else if (dbUser.getIsGuest().booleanValue() && (pkgGuestUsersCount == null || pkgGuestUsersCount - guestUserCount > 0L)) {
                            isLimitExceeded = false;
                        } else if (!(dbUser.getIsGuest().booleanValue() || pkgUsersCount - usersCount <= 0L && pkgUsersCount != -1L)) {
                            isLimitExceeded = false;
                        }
                        if (isLimitExceeded) {
                            String param = null;
                            try {
                                Long limitCount = dbUser.getIsGuest() != false ? pkgGuestUsersCount : pkgUsersCount;
                                param = EncDecUtility.encrypt((String)(limitCount + ":" + email + ":" + dbUser.getIsGuest()));
                            }
                            catch (Exception e) {
                                LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
                            }
                            response.sendRedirect("/userslimit?t=" + param);
                            return null;
                        }
                        dbUser.setTenant(company.getTenant());
                        dbUser.setUserName(email.toLowerCase());
                        dbUser.setFullName(StringUtils.defaultString((String)firstName) + " " + StringUtils.defaultString((String)lastName));
                        dbUser.setFirstName(firstName);
                        dbUser.setLastName(lastName);
                        dbUser.setPassword(UUID.randomUUID().toString());
                        dbUser.setLdap(false);
                        dbUser.setOkta(true);
                        dbUser.setEmail(email);
                        dbUser.setSamlUserId(samlUserId);
                        dbUser = (User)this.userRepository.save((Object)dbUser);
                    } else {
                        dbUserOld.setSamlUserId(samlUserId);
                        dbUserOld.setExternalReferenceGroups(externalReferencesMatched);
                        this.userRepository.save((Object)dbUserOld);
                    }
                    SecureUser secureUser = this.customAuthenticationProvider.getUserContext(email);
                    if (config.getCallBack() != null) {
                        try {
                            URI uri = new URI(config.getCallBack());
                            String origin = null;
                            String port = uri.getPort() == -1 ? "" : "" + uri.getPort();
                            origin = PropertyValidator.isValid((Object)port) ? uri.getScheme() + "://" + uri.getHost() + ":" + uri.getPort() : uri.getScheme() + "://" + uri.getHost();
                            ldapUser.setOrigin(origin);
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                    secureUser.getUserContextDTO().getContextMap().put("ldapUser", ldapUser);
                    UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)secureUser, (Object)"", secureUser.getAuthorities());
                    String series = UUID.randomUUID().toString();
                    String tokenValue = UUID.randomUUID().toString();
                    Date currentDate = new Date();
                    List companies = (List)secureUser.getUserContextDTO().getContextMap().get("companies");
                    if (companies != null && !companies.isEmpty()) {
                        PersistentRememberMeToken token;
                        Company userCompany = (Company)companies.get(0);
                        if (userCompany != null) {
                            LOGGER.debug("Found user company:", (Object)userCompany.getUrlPrefix());
                            if (userCompany.getSecurityPolicy() == null || userCompany.getSecurityPolicy().getSessionMaxAge() == null && userCompany.getSecurityPolicy().getSessionInactivityTimeout() == null) {
                                LOGGER.debug("Going to set remember-me cookie as no security policy or session timeout is set for company");
                                token = new PersistentRememberMeToken(email, series, tokenValue, currentDate);
                                this.tokenRepository.createNewToken(token);
                                String encodedCookie = this.encodeCookie(new String[]{series, tokenValue});
                                int maxAge = 604800;
                                response.setHeader("Set-Cookie", "remember-me=" + encodedCookie + "; Path=/; Max-Age=" + maxAge + "; Secure; HttpOnly; SameSite=None");
                            } else if (company.getSecurityPolicy() != null) {
                                LOGGER.debug("Going to set max age as security policy is set for company");
                                if (company.getSecurityPolicy().getSessionMaxAge() != null) {
                                    int maxAge = company.getSecurityPolicy().getSessionMaxAge();
                                    request.setAttribute("REQ_SESSION_COOKIE_MAX_AGE_SECS", (Object)(maxAge * 60));
                                }
                            }
                        } else {
                            LOGGER.debug("No company found for user in map");
                            token = new PersistentRememberMeToken(email, series, tokenValue, currentDate);
                            this.tokenRepository.createNewToken(token);
                            String encodedCookie = this.encodeCookie(new String[]{series, tokenValue});
                            int maxAge = 604800;
                            response.setHeader("Set-Cookie", "remember-me=" + encodedCookie + "; Path=/; Max-Age=" + maxAge + "; Secure; HttpOnly; SameSite=None");
                        }
                    } else {
                        LOGGER.debug("No company found in map");
                        PersistentRememberMeToken token = new PersistentRememberMeToken(email, series, tokenValue, currentDate);
                        this.tokenRepository.createNewToken(token);
                        String encodedCookie = this.encodeCookie(new String[]{series, tokenValue});
                        int maxAge = 604800;
                        response.setHeader("Set-Cookie", "remember-me=" + encodedCookie + "; Path=/; Max-Age=" + maxAge + "; Secure; HttpOnly; SameSite=None");
                    }
                    return usernamePasswordAuthenticationToken;
                }
                PrintWriter writer = response.getWriter();
                response.setHeader("Content-Type", "text/html");
                writer.write("<html><body><b>SAML authenticated successfully</b><br/><br/><br/>Please add following attributes while you are registering SAML APP.<br/>'login' (User Login or Email Id).<br/>'firstName' (User First Name).<br/>'lastName' (User Last Name).</body></html>");
                return null;
            }
            if (request.getMethod().equals("GET")) {
                this.doGet(request, response, app, config.getAuthnContextClassRef());
            }
        }
        return null;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response, Application app, String authnContextClassRef) throws ServletException, IOException {
        try {
            if (!PropertyValidator.isValid((Object)app.getConfig().getSignKeyStoreId())) {
                String url = null;
                if (request.getRequestURI().contains("/login/saml")) {
                    SAMLRequest samlRequest = this.validator.getSAMLRequest(app, false, authnContextClassRef);
                    String encodedSaml = this.encode(samlRequest.toString());
                    url = app.getAuthenticationURL();
                    url = PropertyValidator.isValid((Object)new URL(url).getQuery()) ? url + "&SAMLRequest=" + URLEncoder.encode(encodedSaml, "UTF-8") : url + "?SAMLRequest=" + URLEncoder.encode(encodedSaml, "UTF-8");
                } else if (request.getRequestURI().contains("/logout/saml")) {
                    String samlUserId = request.getParameter("samlId");
                    SAMLLogoutRequest samlLogoutRequest = this.validator.getSAMLLogoutRequest(app, false, authnContextClassRef, samlUserId);
                    String encodedSamlLogoutRequest = this.encode(samlLogoutRequest.toString());
                    url = app.getLogoutURL();
                    url = PropertyValidator.isValid((Object)new URL(url).getQuery()) ? url + "&SAMLRequest=" + URLEncoder.encode(encodedSamlLogoutRequest, "UTF-8") : url + "?SAMLRequest=" + URLEncoder.encode(encodedSamlLogoutRequest, "UTF-8");
                }
                LOGGER.debug("Redirecting to :" + url);
                response.sendRedirect(url);
            } else {
                String formAction = "";
                String encodedSamlRequest = null;
                if (request.getRequestURI().contains("/login/saml")) {
                    SAMLRequest samlRequest = this.validator.getSAMLRequest(app, false, authnContextClassRef);
                    encodedSamlRequest = this.signSamlRequest((RequestAbstractType)samlRequest.getAuthnRequest(), app);
                    formAction = "/login/saml/postSAMLSignedAuth";
                } else if (request.getRequestURI().contains("/logout/saml")) {
                    String samlUserId = request.getParameter("samlId");
                    SAMLLogoutRequest samlLogoutRequest = this.validator.getSAMLLogoutRequest(app, false, authnContextClassRef, samlUserId);
                    encodedSamlRequest = this.signSamlRequest((RequestAbstractType)samlLogoutRequest.getLogoutRequest(), app);
                    formAction = "/logout/saml/postSAMLSignedLogout";
                }
                response.setContentType("text/html");
                PrintWriter out = response.getWriter();
                out.println("<html>");
                out.println("<head>");
                out.println("<title>Redirecting to idp ..</title>");
                out.println("</head>");
                out.println("<body bgcolor=\"white\">");
                out.println("<form id='frm_samlpost' method='post' action=\"" + formAction + "\">");
                out.println("<input type='hidden' name='SAMLRequest' value=\"" + encodedSamlRequest + "\">");
                out.println("</form>");
                out.println("<script>");
                out.println("document.addEventListener('DOMContentLoaded', function(event) {document.getElementById('frm_samlpost').submit();})");
                out.println("</script>");
                out.println("</body>");
                out.println("</html>");
            }
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            response.setStatus(500);
        }
    }

    private String encode(String samlRequest) throws UnsupportedEncodingException, IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Deflater deflater = new Deflater(-1, true);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)os, deflater);
        deflaterOutputStream.write(samlRequest.getBytes("UTF-8"));
        deflaterOutputStream.close();
        os.close();
        return Base64.encodeBase64String((byte[])os.toByteArray());
    }

    public static void main(String[] args) {
        HashSet<String> groups = new HashSet<String>();
        groups.add("a");
        groups.add("b");
        LOGGER.debug("User Groups :" + Arrays.toString(groups.toArray()));
    }

    protected Map doPost(HttpServletRequest request, HttpServletResponse response, com.okta.saml.Configuration configuration) throws Exception {
        XMLObject parsedResponse;
        String assertion = request.getParameter("SAMLResponse");
        if (assertion == null) {
            throw new Exception("SAMLResponse parameter missing");
        }
        assertion = new String(Base64.decodeBase64((byte[])assertion.getBytes("UTF-8")), Charset.forName("UTF-8"));
        LOGGER.debug("configuration is :" + configuration);
        LOGGER.debug("assertion is :" + assertion);
        if (configuration == null) {
            response.sendRedirect("/login/saml");
        }
        if (LogoutResponse.class.isInstance(parsedResponse = this.parseSAML(assertion))) {
            response.sendRedirect("/login");
            return null;
        }
        if (Response.class.isInstance(parsedResponse)) {
            SAMLResponse sAMLResponse = new SAMLResponse(assertion, configuration);
            Map attibs = sAMLResponse.getAttributes();
            HashMap userAttibs = new HashMap();
            for (Object key : attibs.keySet()) {
                List attribList = (List)attibs.get(key);
                if (attribList.size() > 1) {
                    userAttibs.put(key, attribList);
                    continue;
                }
                userAttibs.put(key, attribList.get(0));
            }
            userAttibs.put("saml_user_id", sAMLResponse.getUserID());
            return userAttibs;
        }
        throw new Exception("SAMLResponse not parseable");
    }

    private static Credential getCredential(Application app, InputStream privateKeyStrem) {
        try {
            char[] pass = app.getConfig().getSingKeyPass().toCharArray();
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(privateKeyStrem, pass);
            KeyStore.PrivateKeyEntry pkEntry = null;
            pkEntry = (KeyStore.PrivateKeyEntry)ks.getEntry(app.getConfig().getSignKeyAlias(), new KeyStore.PasswordProtection(pass));
            PrivateKey pk = pkEntry.getPrivateKey();
            BasicX509Credential basicCredential = new BasicX509Credential();
            basicCredential.setPrivateKey(pk);
            return basicCredential;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private String signSamlRequest(RequestAbstractType request, Application app) throws SecurityException, SignatureException, MarshallingException, UnsupportedEncodingException, FileNotFoundException {
        InputStream inputStream = MongoSyncUtils.retrieveStreamDataById((String)app.getConfig().getKeyStoreFileId(), (AppConfig.MongoConfig)this.mongoConfig);
        SignatureBuilder signFactory = new SignatureBuilder();
        Signature signature = (Signature)signFactory.buildObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        signature.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        Credential creds = AzureSamlRequestFilter.getCredential((Application)app, (InputStream)inputStream);
        signature.setSigningCredential(creds);
        SecurityConfiguration secConfig = org.opensaml.xml.Configuration.getGlobalSecurityConfiguration();
        SecurityHelper.prepareSignatureParams((Signature)signature, (Credential)creds, (SecurityConfiguration)secConfig, null);
        request.setSignature(signature);
        org.opensaml.xml.Configuration.getMarshallerFactory().getMarshaller((XMLObject)request).marshall((XMLObject)request);
        Signer.signObject((Signature)signature);
        Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)request);
        Element dom = marshaller.marshall((XMLObject)request);
        StringWriter stringWriter = new StringWriter();
        XMLHelper.writeNode((Node)dom, (Writer)stringWriter);
        String encodedPostSaml = Base64Support.encode((byte[])stringWriter.toString().getBytes("UTF-8"), (boolean)false);
        return encodedPostSaml;
    }

    private static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is, "UTF-8").useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    private XMLObject parseSAML(String response) throws SecurityPolicyException {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(response.getBytes("UTF-8"));
            Element root = new BasicParserPool().parse((InputStream)bais).getDocumentElement();
            return Configuration.getUnmarshallerFactory().getUnmarshaller(root).unmarshall(root);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            throw new SecurityPolicyException("Problem parsing the response.");
        }
    }

    public CustomAuthenticationProvider getCustomAuthenticationProvider() {
        return this.customAuthenticationProvider;
    }

    public void setCustomAuthenticationProvider(CustomAuthenticationProvider customAuthenticationProvider) {
        this.customAuthenticationProvider = customAuthenticationProvider;
    }

    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public SAMLConfigRepository getSamlConfigRepository() {
        return this.samlConfigRepository;
    }

    public void setSamlConfigRepository(SAMLConfigRepository samlConfigRepository) {
        this.samlConfigRepository = samlConfigRepository;
    }

    public CompanyRepository getCompanyRepository() {
        return this.companyRepository;
    }

    public void setCompanyRepository(CompanyRepository companyRepository) {
        this.companyRepository = companyRepository;
    }

    private String getFile() {
        try {
            String line;
            String fileName = "D:\\downloads\\miniweb\\htdocs\\response.xml";
            File file = new File(fileName);
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            StringBuffer sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            return sb.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public GroupRepository getGroupRepository() {
        return this.groupRepository;
    }

    public void setGroupRepository(GroupRepository groupRepository) {
        this.groupRepository = groupRepository;
    }

    public InvitationRepository getInvitationRepository() {
        return this.invitationRepository;
    }

    public void setInvitationRepository(InvitationRepository invitationRepository) {
        this.invitationRepository = invitationRepository;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public AppConfig.MongoConfig getMongoConfig() {
        return this.mongoConfig;
    }

    public void setMongoConfig(AppConfig.MongoConfig mongoConfig) {
        this.mongoConfig = mongoConfig;
    }

    private String encodeCookie(String[] tokens) {
        String cookieValue = String.join((CharSequence)":", tokens);
        return java.util.Base64.getEncoder().encodeToString(cookieValue.getBytes());
    }
}

