/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.google.gson.Gson;
import com.viztrend.safe.alm.jira.bo.JiraWebhookMappedData;
import com.viztrend.safe.alm.jira.bo.JiraWebhookPayload;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.JiraWebhookRepository;
import com.viztrend.safe.persistence.repository.WebhookActivityRepository;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/webhook"})
@RestController
public class WebhookController {
    @Autowired
    JiraWebhookRepository jiraWebhookRepository;
    @Autowired
    private WebhookActivityRepository webhookActivityRepository;
    @Autowired
    AlmAccountRepository almAccountRepository;
    @Autowired
    CompanyRepository companyRepository;
    @Autowired
    private Environment env;
    @Autowired
    private Gson gson;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebhookController.class);
    private static final Logger LOGGER_WH_HEALTH = LoggerFactory.getLogger((String)"wh_health");
    private static Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private Map jWebHookPayloadMap = new HashMap();
    BlockingQueue<List<String>> queue = new LinkedBlockingQueue(10000);

    @RequestMapping(value={"/{accId}"}, method={RequestMethod.POST})
    public ResponseEntity<String> saveJiraItem(@PathVariable(value="accId") String accId, @RequestBody String jsonpayload) {
        if ("true".equals(this.env.getProperty("maintenance"))) {
            return ResponseEntity.status((int)503).body((Object)"Maintenance mode");
        }
        return this.useInMemoryQueue(accId, jsonpayload);
    }

    private ResponseEntity<String> useInMemoryQueue(String accId, String jsonpayload) {
        try {
            if (this.queue.remainingCapacity() > 0) {
                ArrayList<String> payloadLst = new ArrayList<String>();
                payloadLst.add(accId);
                payloadLst.add(jsonpayload);
                this.queue.put(payloadLst);
                return ResponseEntity.ok((Object)"Webhook queued successfully");
            }
            return ResponseEntity.ok((Object)"Webhook skipped due to capacity ");
        }
        catch (InterruptedException e) {
            LOGGER.error("Error processing JIRA (Local) webhook for account: " + accId, (Throwable)e);
            return ResponseEntity.status((int)500).body((Object)"Internal server error");
        }
    }

    private ResponseEntity<String> useSQS(String accId, String jsonpayload) {
        try {
            boolean success = false;
            if (success) {
                return ResponseEntity.ok((Object)"Webhook queued successfully");
            }
            return ResponseEntity.status((int)500).body((Object)"Failed to queue webhook");
        }
        catch (Exception e) {
            LOGGER.error("Error processing JIRA webhook for account: " + accId, (Throwable)e);
            return ResponseEntity.status((int)500).body((Object)"Internal server error");
        }
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    public Map receivePayload() {
        if (PropertyValidator.isValid((Object)this.jWebHookPayloadMap)) {
            return this.jWebHookPayloadMap;
        }
        return null;
    }

    @RequestMapping(value={"/health"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getAllErrorEntries() {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        try {
            String tenant = UserContextUtil.getUserContext().getLoggedInUser().getTenant();
            List allWebhookActivities = this.webhookActivityRepository.findByTenant(tenant);
            responseJson.put("webhookActivity", allWebhookActivities);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error("Error occurred in getting all webhook activities: ", (Throwable)ex);
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
    }

    private JiraWebhookMappedData onReceiveJiraJson(String almAccountId, String webhookJsonString) {
        AlmAccount account;
        JiraWebhookMappedData jWhkdumpVO = null;
        if (this.env.getProperty("isLocalDeployment").equals("true")) {
            LOGGER.debug("Webhook received  bytes:: " + webhookJsonString.length() + " :: almId :: " + almAccountId);
        }
        JiraWebhookPayload jWebHookPayload = (JiraWebhookPayload)this.gson.fromJson(webhookJsonString, JiraWebhookPayload.class);
        if (this.env.getProperty("isLocalDeployment").equals("true")) {
            JiraWebhookPayload jWebHookPayloadNew = new JiraWebhookPayload();
            jWebHookPayloadNew.setWebhookEvent(jWebHookPayload.getWebhookEvent());
            jWebHookPayloadNew.setTimestamp(new Date().getTime() + "");
            this.jWebHookPayloadMap.put(almAccountId, jWebHookPayloadNew);
        }
        if (jWebHookPayload.checkEvent() && PropertyValidator.isValid((Object)(account = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId)))) && account.getIsActive().booleanValue()) {
            String tenant = account.getTenant();
            Company company = this.companyRepository.findByTenant(tenant);
            LOGGER_WH_HEALTH.debug("Webhook received from :" + company.getUrlPrefix() + " :: ALM Account Id :" + account.getId());
            LOGGER_WH_HEALTH.debug("Webhook received Data :" + webhookJsonString);
            if (PropertyValidator.isValid((Object)company)) {
                long diff = 1L;
                long diff2 = 1L;
                if (company.getExpiryDate() != null) {
                    diff = company.getExpiryDate().getTime() - cal.getTime().getTime();
                } else if (company.getNextPaymentDate() != null) {
                    diff2 = company.getNextPaymentDate().getTime() - cal.getTime().getTime();
                }
                if (diff > 0L && diff2 > 0L) {
                    jWhkdumpVO = new JiraWebhookMappedData();
                    jWhkdumpVO.setJiraWebhookPayload(jWebHookPayload);
                    jWhkdumpVO.fillInfo(almAccountId, tenant, webhookJsonString);
                }
            }
        }
        return jWhkdumpVO;
    }

    @Scheduled(fixedRate=1L)
    public void processWebhook() {
        try {
            JiraWebhookMappedData jWhkdumpVO;
            List webhookJsonLst;
            if (!this.queue.isEmpty() && (webhookJsonLst = (List)this.queue.take()) != null && PropertyValidator.isValid((Object)(jWhkdumpVO = this.onReceiveJiraJson(((String)webhookJsonLst.get(0)).toString(), ((String)webhookJsonLst.get(1)).toString())))) {
                this.jiraWebhookRepository.save((Object)jWhkdumpVO);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }
}

