/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.vos.CheckInMessageVO;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.stereotype.Controller;

@Controller
public class WebSocketController {
    private HashMap<String, Set<String>> checkInConnectedUsers = new HashMap();
    private HashMap<String, String> checkInCurrentStatusMap = new HashMap();

    @MessageMapping(value={"/sendmsg"})
    @SendTo(value={"/topic/synitem"})
    public String greeting(String message) throws Exception {
        return message;
    }

    @MessageMapping(value={"/checkin.connectUser"})
    @SendTo(value={"/topic/checkin"})
    public CheckInMessageVO connectUser(@Payload CheckInMessageVO checkInMessageVO, SimpMessageHeaderAccessor simpMessageHeaderAccessor) {
        simpMessageHeaderAccessor.getSessionAttributes().put("username", checkInMessageVO.getUserName());
        if (this.isEditingSameCheck(checkInMessageVO)) {
            return checkInMessageVO;
        }
        Set userList = this.checkInConnectedUsers.getOrDefault(checkInMessageVO.getCheckInId(), new HashSet());
        userList.add(checkInMessageVO.getUserName());
        this.checkInConnectedUsers.put(checkInMessageVO.getCheckInId(), userList);
        checkInMessageVO.setStatus(this.checkInCurrentStatusMap.getOrDefault(checkInMessageVO.getCheckInId(), CheckInMessageVO.CheckInStatusType.EDITABLE.name()));
        checkInMessageVO.setUserList(userList);
        return checkInMessageVO;
    }

    private boolean isEditingSameCheck(CheckInMessageVO checkInMessageVO) {
        Set userList;
        String anyLastAction = (String)this.checkInCurrentStatusMap.get(checkInMessageVO.getCheckInId());
        if (PropertyValidator.isValid((Object)anyLastAction) && CheckInMessageVO.CheckInStatusType.READONLY.name().equals(anyLastAction) && PropertyValidator.isValid((Collection)(userList = (Set)this.checkInConnectedUsers.get(checkInMessageVO.getCheckInId())))) {
            checkInMessageVO.setUserName((String)userList.iterator().next());
            return true;
        }
        return false;
    }

    @MessageMapping(value={"/checkin.editing"})
    @SendTo(value={"/topic/checkin"})
    public CheckInMessageVO editCheckin(@Payload CheckInMessageVO checkInMessageVO) {
        if (checkInMessageVO.getMessageType().equals((Object)CheckInMessageVO.CheckInMessageType.EDITING)) {
            if (this.isEditingSameCheck(checkInMessageVO)) {
                return checkInMessageVO;
            }
            this.checkInCurrentStatusMap.put(checkInMessageVO.getCheckInId(), CheckInMessageVO.CheckInStatusType.READONLY.name());
        } else if (checkInMessageVO.getMessageType().equals((Object)CheckInMessageVO.CheckInMessageType.SAVED) || checkInMessageVO.getMessageType().equals((Object)CheckInMessageVO.CheckInMessageType.CANCEL)) {
            boolean freeFree = false;
            Set users = (Set)this.checkInConnectedUsers.get(checkInMessageVO.getCheckInId());
            if (PropertyValidator.isValid((Collection)users)) {
                users.remove(checkInMessageVO.getUserName());
            }
            if (!PropertyValidator.isValid((Collection)users)) {
                this.checkInCurrentStatusMap.remove(checkInMessageVO.getCheckInId());
            }
        }
        return checkInMessageVO;
    }

    @MessageMapping(value={"/checkin.reaction"})
    @SendTo(value={"/topic/checkin"})
    public CheckInMessageVO reactToCheckIn(@Payload CheckInMessageVO checkInMessageVO) {
        return checkInMessageVO;
    }

    @MessageMapping(value={"/checkin.userLeft"})
    @SendTo(value={"/topic/checkin"})
    public CheckInMessageVO userDisconnected(@Payload CheckInMessageVO checkInMessageVO) {
        Set userList = (Set)this.checkInConnectedUsers.get(checkInMessageVO.getCheckInId());
        if (PropertyValidator.isValid((Collection)userList)) {
            userList.remove(checkInMessageVO.getUserName());
        }
        this.checkInConnectedUsers.put(checkInMessageVO.getCheckInId(), userList);
        checkInMessageVO.setUserList(userList);
        return checkInMessageVO;
    }
}

