/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.viztrend.safe.controller.KhufiaKari;
import com.viztrend.safe.controller.UserController;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.Customize;
import com.viztrend.safe.persistence.entity.Group;
import com.viztrend.safe.persistence.entity.Invitation;
import com.viztrend.safe.persistence.entity.PasswordHistory;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.WorkSpaceAccessRole;
import com.viztrend.safe.persistence.entity.dto.LdapUser;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.BlackListUserDomainRepository;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.GroupRepository;
import com.viztrend.safe.persistence.repository.InvitationRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceAccessRoleRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.LDAPService;
import com.viztrend.safe.utils.EncDecUtility;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.LocalMailSender;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.time.DateUtils;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user"})
public class UserController {
    @Autowired
    UserRepository userRepository;
    @Autowired
    CompanyRepository companyRepository;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    WorkSpaceAccessRoleRepository workSpaceAccessRoleRepository;
    @Autowired
    WorkSpaceRepository workSpaceRepository;
    @Autowired
    CustomRepository customRepository;
    @Autowired
    InvitationRepository invitationRepository;
    @Autowired
    BlackListUserDomainRepository blackListUserDomainRepository;
    @Autowired
    private LocalMailSender mailSender;
    @Autowired
    @Qualifier(value="LDAPServiceImpl")
    private LDAPService ldapService;
    @Autowired
    @Qualifier(value="oktaServiceImpl")
    private LDAPService oktaLdapService;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private Environment env;
    @Autowired
    private PasswordEncoder passwordEncoder;
    private static final Logger LOGGER = LoggerFactory.getLogger(UserController.class);

    @RequestMapping(value={"/ldapsearch"}, method={RequestMethod.GET})
    public Map searchUser(@RequestParam String searchStr) {
        HashMap<String, Object> combineList = new HashMap<String, Object>();
        try {
            List ldapUsers = this.ldapService.search(searchStr);
            ArrayList<User> users = new ArrayList<User>();
            ArrayList<Group> groups = new ArrayList<Group>();
            for (LdapUser ldapUser : ldapUsers) {
                if (ldapUser.getType().equals("user")) {
                    User user = new User();
                    user.setId(UUID.randomUUID().toString());
                    user.setUserName(ldapUser.getId());
                    user.setFirstName(ldapUser.getFirstName());
                    user.setLastName(ldapUser.getLastName());
                    if (ldapUser.getLastName() != null) {
                        user.setFullName(ldapUser.getFirstName() + " " + ldapUser.getLastName());
                    } else {
                        user.setFullName(ldapUser.getFirstName());
                    }
                    user.setPassword(UUID.randomUUID().toString());
                    user.setLdap(true);
                    user.setEmail(ldapUser.getEmail());
                    users.add(user);
                    continue;
                }
                if (!ldapUser.getType().equals("group")) continue;
                Group group = new Group();
                group.setId(UUID.randomUUID().toString());
                group.setLdap(true);
                group.setTitle(ldapUser.getId());
                groups.add(group);
            }
            combineList.put("users", users);
            combineList.put("groups", groups);
        }
        catch (Exception ex) {
            String error = StringUtils.getTraceString((Throwable)ex);
            combineList.put("error", error.substring(0, error.indexOf("\n")));
            LOGGER.error(error);
        }
        return combineList;
    }

    @RequestMapping(value={"/oktasearch"}, method={RequestMethod.GET})
    public Map searchOktaUser(@RequestParam String searchStr) {
        try {
            List ldapUsers = this.oktaLdapService.search(searchStr);
            HashMap combineList = new HashMap();
            ArrayList<User> users = new ArrayList<User>();
            ArrayList<Group> groups = new ArrayList<Group>();
            for (LdapUser ldapUser : ldapUsers) {
                if (ldapUser.getType().equals("user")) {
                    User user = new User();
                    user.setId(UUID.randomUUID().toString());
                    user.setUserName(ldapUser.getId());
                    user.setFirstName(ldapUser.getFirstName());
                    user.setLastName(ldapUser.getLastName());
                    if (ldapUser.getLastName() != null) {
                        user.setFullName(ldapUser.getFirstName() + " " + ldapUser.getLastName());
                    } else {
                        user.setFullName(ldapUser.getFirstName());
                    }
                    user.setPassword(UUID.randomUUID().toString());
                    user.setLdap(true);
                    user.setOkta(true);
                    user.setEmail(ldapUser.getEmail());
                    users.add(user);
                    continue;
                }
                if (!ldapUser.getType().equals("group")) continue;
                Group group = new Group();
                group.setId(UUID.randomUUID().toString());
                group.setLdap(true);
                group.setOkta(true);
                group.setTitle(ldapUser.getId());
                group.setDescription(ldapUser.getDn());
                groups.add(group);
            }
            combineList.put("users", users);
            combineList.put("groups", groups);
            return combineList;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<Object> signupUser(@RequestBody User user) {
        String duplicateMSg = "User with similar ID already exist";
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            String domain = user.getUserName().substring(user.getUserName().indexOf("@") + 1);
            if (PropertyValidator.isValid((Collection)this.blackListUserDomainRepository.findByDomainIgnoreCase(domain))) {
                responseJson.put("error", true);
                responseJson.put("message", "Your email domain is blacklisted");
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            User oldUser = this.userRepository.findByUserNameIgnoreCase(user.getUserName());
            if (oldUser != null) {
                responseJson.put("error", true);
                responseJson.put("message", duplicateMSg);
            } else {
                SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
                user.setTenant(tenant);
                user.setPassword(EncDecUtility.bCryptPasswordEncoder((String)user.getPassword()));
                user = (User)this.userRepository.save((Object)user);
                if (user.getId() != null) {
                    responseJson.put("success", true);
                } else {
                    responseJson.put("error", true);
                    responseJson.put("message", "Something went wrong, Try again");
                }
            }
        }
        catch (Exception ex) {
            responseJson.put("error", true);
            if (ex instanceof DuplicateKeyException) {
                responseJson.put("message", duplicateMSg);
            } else {
                responseJson.put("message", "Something went wrong, Try again");
            }
            LOGGER.error("error while signupUser", (Throwable)ex);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/setup/verify"})
    @ResponseBody
    public ResponseEntity<Object> isDomainAvailable(@RequestBody HashMap<String, Object> info) {
        String url = (String)info.get("url");
        String uname = (String)info.get("uname");
        if (!this.env.getProperty("isLocalDeployment").equals("true") && PropertyValidator.isValid((Object)url)) {
            Company alreadyCompany = this.companyRepository.findByUrlPrefixIgnoreCase(url);
            if (PropertyValidator.isValid((Object)alreadyCompany)) {
                info.put("success_url", false);
                info.put("message_url", "Unfortunately this URL already exists. Please add another");
            } else {
                info.put("success_url", true);
                info.put("message_url", "Success! This URL is available");
            }
        }
        if (PropertyValidator.isValid((Object)uname)) {
            User temp = new User();
            temp.setEmail(uname);
            if (!temp.hasValidEmail().booleanValue()) {
                HashMap<String, Object> responseJson = new HashMap<String, Object>();
                responseJson.put("msg", "Please provide a valid email address");
                responseJson.put("email", temp.getEmail());
                responseJson.put("code", -200);
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            User alreadyUser = this.userRepository.findByUserNameIgnoreCase(uname);
            Boolean notFounder = true;
            if (PropertyValidator.isValid((Object)alreadyUser)) {
                List existingCompanies = alreadyUser.getUserCompanies();
                for (int i = 0; i < existingCompanies.size(); ++i) {
                    UserCompany existingCompany = (UserCompany)existingCompanies.get(i);
                    if (!existingCompany.getIsCompanyFounder().booleanValue()) continue;
                    notFounder = false;
                    break;
                }
            }
            if (notFounder.booleanValue()) {
                info.put("success_uname", true);
                info.put("message_uname", "");
            } else {
                info.put("success_uname", false);
                info.put("message_uname", "User with this email already exists");
            }
        }
        return new ResponseEntity(info, HttpStatus.OK);
    }

    @RequestMapping(value={"/setup/debugmode/{cid}"})
    @ResponseBody
    public ResponseEntity<Object> switchToDebugMode(@PathVariable(value="cid") String cid) {
        HashMap<String, Boolean> response = new HashMap<String, Boolean>();
        try {
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            if (loggedInUser.getUserName().equals("sysadmin@kendis.io")) {
                Company company = PropertyValidator.isValid((Object)cid) && !"reset".equals(cid) ? new Company(cid) : new Company("5ec393c7979409244c96fa06");
                User user = this.userRepository.findByUserName(loggedInUser.getUserName());
                UserCompany uc = new UserCompany();
                uc.setCompany(company);
                uc.setIsAdmin(Boolean.valueOf(true));
                user.setUserCompanies(new ArrayList());
                user.getUserCompanies().add(uc);
                user.setAlmCredentials(null);
                this.userRepository.save((Object)user);
                response.put("success", true);
            }
        }
        catch (Exception e) {
            response.put("success", false);
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/setup"})
    @ResponseBody
    public ResponseEntity<Object> setupUser(@RequestBody String reqbody) {
        HashMap<String, Object> responseBody = new HashMap<String, Object>();
        String companyPrefix = "";
        Gson gson = new Gson();
        1 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap paramMap = (HashMap)gson.fromJson(reqbody, T.getType());
        String userJson = (String)paramMap.get("user");
        String captcha = (String)paramMap.get("token");
        String isJiraSignUp = (String)paramMap.get("isJiraSignUp");
        ObjectMapper mapper = new ObjectMapper();
        User user = null;
        try {
            user = (User)mapper.readValue(userJson, User.class);
        }
        catch (JsonParseException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        catch (JsonMappingException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        if (!("true".equals(isJiraSignUp) || this.env.getProperty("isLocalDeployment").equals("true") || KendisUtils.isCaptchaValid((String)"6LepnWwUAAAAANBT0IhdChDtop_MsDUdXhnm7WcI", (String)captcha))) {
            responseBody.put("success", false);
            responseBody.put("captcha", false);
            responseBody.put("message", "Please verify that you are not a robot.");
            return new ResponseEntity(responseBody, HttpStatus.OK);
        }
        if (!PropertyValidator.isValid((Object)user.getNameSpace())) {
            Company comp;
            block24: {
                Company alreadyCompany;
                String tenant = UUID.randomUUID().toString();
                comp = ((UserCompany)user.getUserCompanies().get(0)).getCompany();
                companyPrefix = comp.getUrlPrefix();
                if (!this.env.getProperty("isLocalDeployment").equals("true") && PropertyValidator.isValid((Object)(alreadyCompany = this.companyRepository.findByUrlPrefix(companyPrefix)))) {
                    responseBody.put("success", false);
                    responseBody.put("message", "Unfortunately this URL already exists. Please add another");
                    return new ResponseEntity(responseBody, HttpStatus.OK);
                }
                String domain = user.getUserName().substring(user.getUserName().indexOf("@") + 1);
                if (PropertyValidator.isValid((Collection)this.blackListUserDomainRepository.findByDomainIgnoreCase(domain))) {
                    responseBody.put("error", true);
                    responseBody.put("message", "Your email domain is blacklisted");
                    return new ResponseEntity(responseBody, HttpStatus.OK);
                }
                User alreadyUser = this.userRepository.findByUserNameIgnoreCase(user.getUserName());
                if (PropertyValidator.isValid((Object)alreadyUser)) {
                    List existingCompanies = alreadyUser.getUserCompanies();
                    Boolean notFounder = true;
                    for (int i = 0; i < existingCompanies.size(); ++i) {
                        UserCompany existingCompany = (UserCompany)existingCompanies.get(i);
                        if (!existingCompany.getIsCompanyFounder().booleanValue()) continue;
                        notFounder = false;
                        break;
                    }
                    if (notFounder.booleanValue()) {
                        comp.setTenant(tenant);
                        comp.setCustomization(new Customize());
                        comp.setExpiryDate(DateUtils.addDays((Date)new Date(), (int)10));
                        comp = (Company)this.companyRepository.save((Object)comp);
                        UserCompany userCompany = (UserCompany)user.getUserCompanies().get(0);
                        userCompany.setCompany(comp);
                        List _userCompanies = alreadyUser.getUserCompanies();
                        _userCompanies.add(userCompany);
                        alreadyUser.setUserCompanies(_userCompanies);
                        alreadyUser = (User)this.userRepository.save((Object)alreadyUser);
                        alreadyUser.setPassword(null);
                        responseBody.put("success", true);
                        responseBody.put("user", alreadyUser);
                    } else {
                        responseBody.put("success", false);
                        responseBody.put("message", "User with this email already exists");
                    }
                    return new ResponseEntity(responseBody, HttpStatus.OK);
                }
                comp.setTenant(tenant);
                if (!this.env.getProperty("isLocalDeployment").equals("true")) {
                    comp.setUrlPrefix(comp.getUrlPrefix().trim().toLowerCase().replaceAll("[^a-z0-9]", ""));
                }
                comp.setSignupSource(String.valueOf(paramMap.get("signupsource")));
                comp.setCustomization(new Customize());
                comp.setExpiryDate(DateUtils.addDays((Date)new Date(), (int)10));
                comp.setUserCount(5L);
                comp.setDuration(1L);
                if (this.env.getProperty("isLocalDeployment").equals("true")) {
                    String paymentKey = null;
                    Long expiryTimeForLocalDep = DateUtils.addDays((Date)new Date(), (int)8).getTime();
                    try {
                        paymentKey = new KhufiaKari().encrypt("trial:5:" + expiryTimeForLocalDep + ":1");
                    }
                    catch (Exception e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                    comp.setPaymentKey(paymentKey);
                }
                try {
                    if (!this.env.getProperty("isLocalDeployment").equals("true")) {
                        comp = (Company)this.companyRepository.save((Object)comp);
                        break block24;
                    }
                    if (this.env.getProperty("isLocalDeployment").equals("true") && this.companyRepository.findAll().size() < 1) {
                        comp = (Company)this.companyRepository.save((Object)comp);
                        break block24;
                    }
                    responseBody.put("success", false);
                    responseBody.put("message", "Your company account is already created");
                    return new ResponseEntity(responseBody, HttpStatus.OK);
                }
                catch (Exception ex) {
                    LOGGER.error("Error while sending email :" + StringUtils.getTraceString((Throwable)ex));
                    if (ex.getMessage().contains("DuplicateKeyException")) {
                        responseBody.put("success", false);
                        responseBody.put("message", "Unfortunately this URL already exists. Please add another");
                        return new ResponseEntity(responseBody, HttpStatus.OK);
                    }
                    responseBody.put("success", false);
                    responseBody.put("message", "Seem some problem there please contact support");
                    return new ResponseEntity(responseBody, HttpStatus.OK);
                }
            }
            ((UserCompany)user.getUserCompanies().get(0)).setCompany(comp);
            user.setTenant(null);
        } else {
            user.setTenant(null);
        }
        user.setPassword(EncDecUtility.bCryptPasswordEncoder((String)user.getPassword()));
        user = (User)this.userRepository.save((Object)user);
        user.setPassword(null);
        responseBody.put("success", true);
        responseBody.put("user", user);
        responseBody.put("companyPrefix", companyPrefix);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("email", user.getUserName());
        data.put("subject", "Welcome to Kendis");
        String baseUrl = this.getHttpScheme() + "://" + ((UserCompany)user.getUserCompanies().get(0)).getCompany().getUrlPrefix() + "." + this.env.getProperty("server.domain");
        data.put("link", baseUrl);
        data.put("emailTemplate", "welcomeTemplate");
        if ("kendis.io".equals(this.env.getProperty("server.domain"))) {
            data.put("bcc", this.env.getProperty("email.admin"));
        }
        if (!this.env.getProperty("isLocalDeployment").equals("true")) {
            this.sendMail(data);
        }
        return new ResponseEntity(responseBody, HttpStatus.OK);
    }

    @RequestMapping(value={"/fetchingLoggedInUser"}, method={RequestMethod.GET})
    @ResponseBody
    public User fetchTestUser(@RequestBody String requestBody) {
        List users = this.userRepository.findAll();
        if (users == null) {
            return null;
        }
        if (users.isEmpty()) {
            return null;
        }
        return (User)users.get(0);
    }

    @RequestMapping(value={"/confirmemail"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> confirmEmail(@RequestBody String requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            Gson gson = new Gson();
            2 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap paramMap = (HashMap)gson.fromJson(requestBody, T.getType());
            String originURL = (String)paramMap.get("originURL");
            String userName = (String)paramMap.get("userName");
            User _user = this.userRepository.findByUserNameIgnoreCase(userName);
            if (_user != null) {
                JSONObject jObj = new JSONObject();
                jObj.put("id", (Object)_user.getId());
                long time = System.currentTimeMillis();
                jObj.put("time", time);
                String param = jObj.toString();
                String resetPasswordEnc = EncDecUtility.encryptSimple((String)param);
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("email", _user.getEmail());
                data.put("id", _user.getId());
                data.put("subject", "Password Request");
                data.put("link", originURL + "/resetpassword?t=" + resetPasswordEnc);
                data.put("emailTemplate", "resetPasswordTemplate");
                this.sendMail(data);
                responseJson.put("success", true);
                _user.setResetPasswordEncryption(resetPasswordEnc);
                this.userRepository.save((Object)_user);
            } else {
                responseJson.put("error", true);
                responseJson.put("message", "Sorry, we couldn\u2019t find an account with that email");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/validatepassword"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> verifyPassword(@RequestBody String password) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        try {
            if (UserContextUtil.getUserContext() != null) {
                Gson gson = new Gson();
                User user = UserContextUtil.getUserContext().getLoggedInUser();
                3 T = new /* Unavailable Anonymous Inner Class!! */;
                HashMap requestMap = (HashMap)gson.fromJson(password, T.getType());
                String pas = (String)requestMap.get("password");
                boolean isPassInHistory = this.passwordEncoder.matches((CharSequence)pas, user.getPassword());
                responseJson.put("result", isPassInHistory);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/updatepassword"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updatePassword(@RequestBody User user) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            User _user = null;
            String value = user.getEmail();
            String new_password = user.getPassword();
            if (value != null && new_password.length() < 46) {
                JSONObject jObj = new JSONObject(EncDecUtility.decryptSimple((String)value));
                if (jObj != null && jObj.has("id") && jObj.has("time")) {
                    String id = jObj.getString("id");
                    Long time = jObj.getLong("time");
                    Date currDate = new Date();
                    Date prevDate = new Date();
                    prevDate.setTime(time);
                    prevDate = DateUtils.addHours((Date)prevDate, (int)2);
                    int dateEquality = currDate.compareTo(prevDate);
                    if (dateEquality > 0) {
                        responseJson.put("error", true);
                        responseJson.put("message", "Reset request expired.");
                    } else {
                        _user = this.userRepository.findById(id);
                        if (_user != null) {
                            if (value.equals(_user.getResetPasswordEncryption())) {
                                if (!new_password.equalsIgnoreCase(_user.getEmail())) {
                                    if (PropertyValidator.isValid((Collection)_user.getUserCompanies())) {
                                        for (UserCompany uc : _user.getUserCompanies()) {
                                            if (uc.getCompany().getSecurityPolicy() == null) continue;
                                            if (!PropertyValidator.isValid((Collection)_user.getPasswordHistory())) {
                                                ArrayList<PasswordHistory> psshistList = new ArrayList<PasswordHistory>();
                                                psshistList.add(new PasswordHistory(_user.getPassword(), new Date()));
                                                _user.setPasswordHistory(psshistList);
                                            }
                                            if (uc.getCompany().getSecurityPolicy().isEnablePasswordHistory()) {
                                                for (PasswordHistory ph : _user.getPasswordHistory()) {
                                                    boolean isPassInHistory = this.passwordEncoder.matches((CharSequence)new_password, ph.getPassword());
                                                    if (!isPassInHistory) continue;
                                                    responseJson.put("error", true);
                                                    responseJson.put("message", "You cannot change with previously used password");
                                                    return new ResponseEntity(responseJson, HttpStatus.OK);
                                                }
                                            }
                                            _user.getPasswordHistory().add(new PasswordHistory(_user.getPassword(), new Date()));
                                        }
                                    }
                                    _user.setPassword(EncDecUtility.bCryptPasswordEncoder((String)new_password));
                                    _user.setResetPasswordEncryption(null);
                                    _user = (User)this.userRepository.save((Object)_user);
                                    responseJson.put("success", true);
                                } else {
                                    responseJson.put("error", true);
                                    responseJson.put("message", "You cannot use your email address in your password ");
                                }
                            } else {
                                responseJson.put("error", true);
                                responseJson.put("message", "Reset password link does not exist or invalid link.");
                            }
                        } else {
                            responseJson.put("error", true);
                            responseJson.put("message", "User no longer exists");
                        }
                    }
                } else {
                    responseJson.put("error", true);
                    responseJson.put("message", "Something went wrong");
                }
            } else {
                responseJson.put("error", true);
                responseJson.put("message", "Something went wrong");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/verifyinvite"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> verifyInvite(@RequestBody String token) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            Invitation invitation = this.invitationRepository.findById(token);
            if (PropertyValidator.isValid((Object)invitation)) {
                String cid;
                JSONObject jObj = new JSONObject(invitation.getInviteJson());
                responseJson.put("success", true);
                User alreadyUser = this.userRepository.findByUserNameIgnoreCase(jObj.getString("email"));
                if (PropertyValidator.isValid((Object)alreadyUser)) {
                    cid = jObj.getString("companyId");
                    List userCompanies = alreadyUser.getUserCompanies();
                    for (int i = 0; i < userCompanies.size(); ++i) {
                        if (!((UserCompany)userCompanies.get(i)).getCompany().getId().equals(cid) || ((UserCompany)userCompanies.get(i)).getIsArchive().booleanValue()) continue;
                        responseJson.put("alreadyInCompany", true);
                        break;
                    }
                    responseJson.put("alreadyUser", true);
                    responseJson.put("userName", jObj.getString("userName"));
                    responseJson.put("fullName", jObj.getString("fullName"));
                    responseJson.put("firstName", alreadyUser.getFirstName());
                    responseJson.put("lastName", alreadyUser.getLastName());
                } else {
                    responseJson.put("alreadyUser", false);
                }
                cid = jObj.getString("companyId");
                Company comp = this.companyRepository.findById(cid);
                if (jObj.has("fullName")) {
                    responseJson.put("fullName", jObj.getString("fullName"));
                }
                responseJson.put("userEmail", jObj.getString("email"));
                responseJson.put("companyName", comp.getName());
                responseJson.put("companyPrefix", comp.getUrlPrefix());
            } else {
                responseJson.put("success", false);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/acceptinvite"})
    @ResponseBody
    public ResponseEntity<Object> addInvitedUser(@RequestBody String requestString) {
        HashMap<String, Object> responseBody = new HashMap<String, Object>();
        ObjectMapper mapper = new ObjectMapper();
        String token = "";
        User user = null;
        String companyPrefix = "";
        try {
            User userToNotifyBack;
            JSONObject payload = null;
            if (!PropertyValidator.isValid((Object)requestString)) {
                responseBody.put("success", false);
                responseBody.put("msg", "Something went wrong. Please try again");
                return new ResponseEntity(responseBody, HttpStatus.OK);
            }
            payload = new JSONObject(requestString);
            token = payload.getString("token");
            user = (User)mapper.readValue(payload.getString("user"), User.class);
            if (!PropertyValidator.isValid((Object)user) || !PropertyValidator.isValid((Object)token)) {
                responseBody.put("success", false);
                responseBody.put("msg", "Something went wrong. Please try again");
                return new ResponseEntity(responseBody, HttpStatus.OK);
            }
            Invitation inviteObj = this.invitationRepository.findById(token);
            BasicDBObject jiraHostDomainUserDoc = null;
            Group group = null;
            Company alreadyCompany = null;
            boolean isJiraInvitation = false;
            Collection accessRoles = null;
            Set groupIds = null;
            boolean notifyUser = false;
            if (PropertyValidator.isValid((Object)inviteObj)) {
                JSONObject inviteJson = new JSONObject(inviteObj.getInviteJson());
                Gson g = new Gson();
                4 P = new /* Unavailable Anonymous Inner Class!! */;
                ObjectMapper m = new ObjectMapper();
                if (inviteJson.has("accessRoles") && PropertyValidator.isValid((Object)inviteJson.getString("accessRoles"))) {
                    accessRoles = (Collection)m.readValue(inviteJson.getString("accessRoles"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                }
                if (inviteJson.has("groups") && PropertyValidator.isValid((Object)inviteJson.getString("groups"))) {
                    groupIds = (Set)m.readValue(inviteJson.getString("groups"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                }
                if (inviteJson.has("notifyUser") && PropertyValidator.isValid((Object)inviteJson.getString("notifyUser"))) {
                    notifyUser = Boolean.parseBoolean(inviteJson.getString("notifyUser"));
                }
                alreadyCompany = this.companyRepository.findById(inviteJson.getString("companyId"));
                user.setEmail(inviteJson.getString("email"));
                if (inviteJson.has("jira_user_key") && inviteJson.has("jira_host_domain_id") && inviteJson.has("group_id")) {
                    String jiraUserKey = inviteJson.getString("jira_user_key");
                    String JirHostDomainId = inviteJson.getString("jira_host_domain_id");
                    String groupId = inviteJson.getString("group_id");
                    isJiraInvitation = true;
                    if (groupId != null) {
                        user.setGroups(new HashSet());
                        user.getGroups().add(groupId);
                        group = (Group)this.groupRepository.findOne((Serializable)((Object)groupId));
                    }
                    user.setIsJiraPluginUser(Boolean.valueOf(true));
                    Object atlassianHostDomainUserId = null;
                    Query query = new Query();
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"atlassianHostDomain.$id").is((Object)new ObjectId(JirHostDomainId)).and("jiraUserId").is((Object)jiraUserKey));
                    DBCursor dbCursor = this.mongoTemplate.getCollection("atlassianHostDomainUser").find(query.getQueryObject());
                    if (dbCursor.hasNext()) {
                        DBObject dbObj = dbCursor.next();
                        atlassianHostDomainUserId = dbObj.get("_id");
                    }
                    jiraHostDomainUserDoc = new BasicDBObject();
                    if (atlassianHostDomainUserId != null) {
                        jiraHostDomainUserDoc.put((Object)"_id", atlassianHostDomainUserId);
                    }
                    jiraHostDomainUserDoc.put((Object)"_class", (Object)"com.kendis.jira.plugin.AtlassianHostDomainUser");
                    jiraHostDomainUserDoc.put((Object)"jiraUserId", (Object)jiraUserKey);
                    jiraHostDomainUserDoc.put((Object)"kendisUserId", (Object)inviteJson.getString("userName"));
                    BasicDBObject jiraHostDomainDoc = new BasicDBObject();
                    ObjectId hostDomainId = new ObjectId(JirHostDomainId);
                    jiraHostDomainDoc.put((Object)"$ref", (Object)"atlassianHostDomain");
                    jiraHostDomainDoc.put((Object)"$id", (Object)hostDomainId);
                    jiraHostDomainUserDoc.put((Object)"atlassianHostDomain", (Object)jiraHostDomainDoc);
                }
            }
            if (PropertyValidator.isValid(alreadyCompany)) {
                User alreadyUser = this.userRepository.findByUserNameIgnoreCase(user.getEmail());
                companyPrefix = alreadyCompany.getUrlPrefix();
                if (PropertyValidator.isValid((Object)alreadyUser)) {
                    Iterator<UserCompany> userCompanies = alreadyUser.getUserCompanies();
                    UserCompany userCompany = (UserCompany)user.getUserCompanies().get(0);
                    Iterator iterator = userCompanies.iterator();
                    while (iterator.hasNext()) {
                        UserCompany _userCompany = (UserCompany)iterator.next();
                        if (!_userCompany.getCompany().getId().equals(userCompany.getCompany().getId())) continue;
                        responseBody.put("success", false);
                        responseBody.put("msg", "User already in this company");
                        return new ResponseEntity(responseBody, HttpStatus.OK);
                    }
                    userCompany.setCompany(alreadyCompany);
                    userCompanies.add(userCompany);
                    alreadyUser.setUserCompanies(userCompanies);
                    user = alreadyUser;
                } else {
                    ((UserCompany)user.getUserCompanies().get(0)).setCompany(alreadyCompany);
                    user.setPassword(EncDecUtility.bCryptPasswordEncoder((String)user.getPassword()));
                    user.setIsSuperAdmin(Boolean.valueOf(false));
                    user.setIsAdmin(Boolean.valueOf(false));
                }
            }
            if (!PropertyValidator.isValid((Object)user.getNameSpace())) {
                String tenant = UUID.randomUUID().toString();
                user.setTenant(tenant);
            } else {
                user.setTenant(user.getNameSpace());
            }
            if (PropertyValidator.isValid(groupIds)) {
                user.setGroups(groupIds);
            }
            user = (User)this.userRepository.save((Object)user);
            if (PropertyValidator.isValid(groupIds)) {
                List groups = this.groupRepository.findByIdIn(groupIds);
                for (Group group2 : groups) {
                    if (!PropertyValidator.isValid((Collection)group2.getUsers())) {
                        group2.setUsers(new HashSet());
                    }
                    group2.getUsers().add(user.getId());
                }
                this.groupRepository.save((Iterable)groups);
            }
            if (PropertyValidator.isValid(accessRoles)) {
                ArrayList<WorkSpaceAccessRole> accessRolesToBeSaved = new ArrayList<WorkSpaceAccessRole>();
                for (WorkSpaceAccessRole accessRole : accessRoles) {
                    if (!this.workSpaceRepository.existsByIdAndArchiveFalse(accessRole.getWorkSpace().getId())) continue;
                    accessRole.setUser(new User(user.getId()));
                    accessRole.setTenant(alreadyCompany.getTenant());
                    accessRolesToBeSaved.add(accessRole);
                }
                this.workSpaceAccessRoleRepository.save(accessRolesToBeSaved);
            }
            if (group != null) {
                if (!PropertyValidator.isValid((Collection)group.getUsers())) {
                    group.setUsers(new HashSet());
                }
                group.getUsers().add(user.getId());
                this.groupRepository.save(group);
            }
            if (isJiraInvitation) {
                this.mongoTemplate.getCollection("atlassianHostDomainUser").save(jiraHostDomainUserDoc);
            }
            user.setPassword(null);
            this.invitationRepository.deleteById(token);
            responseBody.put("success", true);
            responseBody.put("companyPrefix", companyPrefix);
            HashMap<String, String> data = new HashMap<String, String>();
            if (notifyUser && PropertyValidator.isValid((Object)(userToNotifyBack = this.userRepository.findByUserName(inviteObj.getCreatedBy())))) {
                data = new HashMap();
                data.put("notifyingUser", userToNotifyBack.getFirstName());
                data.put("joiningUserName", user.getFirstName());
                this.mailSender.sendMail(userToNotifyBack.getEmail(), user.getFirstName() + " has accepted Invitation to join Kendis", "notifyUserTemplate", data, true);
            }
            data = new HashMap();
            data.put("email", user.getUserName());
            data.put("subject", "Welcome to Kendis");
            data.put("emailTemplate", "invitationAcceptanceTemplate");
            data.put("companyName", alreadyCompany.getName());
            String baseUrl = this.getHttpScheme() + "://" + ((UserCompany)user.getUserCompanies().get(0)).getCompany().getUrlPrefix() + "." + this.env.getProperty("server.domain");
            if (this.env.getProperty("isLocalDeployment").equals("true")) {
                baseUrl = UserContextUtil.getUserContext().getCurrentCompany().getUrl();
            }
            data.put("link", baseUrl);
            this.sendMail(data);
        }
        catch (Exception e) {
            LOGGER.error("addInvitedUser: error occured ", (Throwable)e);
        }
        return new ResponseEntity(responseBody, HttpStatus.OK);
    }

    @RequestMapping(value={"/getsocialinfo"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getSocialInfo(@RequestBody String token) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            JSONObject jsonObj;
            responseJson.put("success", false);
            if (PropertyValidator.isValid((Object)token) && PropertyValidator.isValid((Object)(jsonObj = new JSONObject(EncDecUtility.decryptSimple((String)token))))) {
                responseJson.put("success", true);
                User alreadyUser = this.userRepository.findByUserName(jsonObj.getString("email"));
                if (PropertyValidator.isValid((Object)alreadyUser)) {
                    responseJson.put("alreadyUser", true);
                } else {
                    responseJson.put("userName", jsonObj.getString("email"));
                    responseJson.put("fullName", jsonObj.getString("name"));
                    responseJson.put("userEmail", jsonObj.getString("email"));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private void sendMail(Map<String, Object> data) {
        HashMap<String, Object> _data = null;
        if (PropertyValidator.isValid((Object)data.get("link"))) {
            _data = new HashMap<String, Object>();
            _data.put("accessUrl", data.get("link"));
            _data.put("email", data.get("email"));
            if (PropertyValidator.isValid((Object)data.get("companyName"))) {
                _data.put("companyName", data.get("companyName"));
            }
        }
        if (PropertyValidator.isValid((Object)data.get("bcc"))) {
            this.mailSender.sendMail(data.get("email").toString(), data.get("bcc").toString(), data.get("subject").toString(), data.get("emailTemplate").toString(), _data, true);
        } else {
            this.mailSender.sendMail(data.get("email").toString(), data.get("subject").toString(), data.get("emailTemplate").toString(), _data, true);
        }
    }

    private String getHttpScheme() {
        if (this.env.getProperty("redirect.from.http.server.port") != null) {
            return "https";
        }
        return "http";
    }

    public static void main(String[] args) {
        System.out.println("sdafdsfDSmmd #$%#$ 34n34543".trim().toLowerCase().replaceAll("[^a-z0-9]", ""));
    }
}

