/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.google.gson.Gson;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFSDBFile;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.controller.UploadController;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.Customize;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.StateRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.service.AttachmentService;
import com.viztrend.safe.service.ImportService;
import com.viztrend.safe.utils.MongoSyncUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.S3Utils;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.Attachment;
import com.viztrend.safe.vos.MappedFieldVO;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.GridFsResource;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.supercsv.io.CsvMapReader;
import org.supercsv.io.CsvMapWriter;
import org.supercsv.prefs.CsvPreference;

@Controller
public class UploadController {
    private static final Logger LOGGER = LoggerFactory.getLogger(UploadController.class);
    @Autowired
    ImportService importService;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private StateRepository stateRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private CompanyRepository companyRepository;
    @Autowired
    private AppConfig.MongoConfig mongoConfig;
    @Autowired
    private Environment env;
    @Autowired
    private GridFsTemplate gridFsTemplate;
    @Autowired
    private AttachmentService attachmentService;

    @PostMapping(value={"/upload/items"})
    public String singleFileUpload(@RequestParam(value="file") MultipartFile file, RedirectAttributes redirectAttributes, HttpServletRequest request, HttpServletResponse response, @RequestParam String sessionBoardId, @RequestParam String csvType) throws Exception {
        String origin = request.getHeader("origin");
        if (file.isEmpty()) {
            redirectAttributes.addFlashAttribute("message", (Object)"Please select a file to upload");
            return "redirect:" + origin + "/";
        }
        HashMap data = new HashMap();
        try {
            byte[] bytes = file.getBytes();
            Path path = Paths.get(this.env.getProperty("temp.file.location") + file.getOriginalFilename(), new String[0]);
            String fileCompletePath = path.toAbsolutePath().toString();
            if (fileCompletePath.endsWith(".csv")) {
                Files.write(path, bytes, new OpenOption[0]);
                data = this.getCsvHeaders(fileCompletePath, null);
            } else if (fileCompletePath.endsWith(".xls")) {
                path = Paths.get(this.env.getProperty("temp.file.location") + file.getOriginalFilename().replaceAll(".xls", ".csv"), new String[0]);
                fileCompletePath = path.toAbsolutePath().toString();
                data = this.getHeadersXLS(fileCompletePath, bytes);
            } else if (fileCompletePath.endsWith(".xlsx")) {
                path = Paths.get(this.env.getProperty("temp.file.location") + file.getOriginalFilename().replaceAll(".xlsx", ".csv"), new String[0]);
                fileCompletePath = path.toAbsolutePath().toString();
                data = this.getHeadersXLSX(fileCompletePath, bytes);
            }
            redirectAttributes.addFlashAttribute("csvType", data.get("csvType"));
            redirectAttributes.addFlashAttribute("headers", data.get("headers"));
            redirectAttributes.addFlashAttribute("sessionBoard", (Object)sessionBoardId);
            redirectAttributes.addFlashAttribute("path", (Object)fileCompletePath);
            redirectAttributes.addFlashAttribute("message", (Object)(file.getOriginalFilename() + " has been successfully uploaded."));
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        String redirectUrl = request.getScheme() + "://localhost:8080/importcsv?id=" + sessionBoardId;
        return "redirect:" + origin + "/importcsv";
    }

    private HashMap<String, Object> getCsvHeaders(String filePath, CsvPreference preference) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String csvType = "";
        String[] header = new String[]{};
        try {
            CsvMapReader inFile = null;
            File file = new File(filePath);
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader is = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
            if (preference == null) {
                boolean notMatched = false;
                BufferedReader br = new BufferedReader(is);
                String line = br.readLine();
                header = line.split(String.valueOf((char)CsvPreference.TAB_PREFERENCE.getDelimiterChar()));
                if (header.length < 2) {
                    notMatched = true;
                } else {
                    csvType = "TAB_PREFERENCE";
                }
                if (notMatched) {
                    notMatched = false;
                    header = line.split(String.valueOf((char)CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE.getDelimiterChar()));
                    if (header.length < 2) {
                        notMatched = true;
                    } else {
                        csvType = "EXCEL_NORTH_EUROPE_PREFERENCE";
                    }
                }
                if (notMatched) {
                    notMatched = false;
                    header = line.split(String.valueOf((char)CsvPreference.STANDARD_PREFERENCE.getDelimiterChar()));
                    if (header.length < 2) {
                        notMatched = true;
                    } else {
                        csvType = "STANDARD_PREFERENCE";
                    }
                }
                br.close();
            } else {
                inFile = new CsvMapReader((Reader)is, preference);
                header = inFile.getHeader(true);
                inFile.close();
                csvType = preference.toString();
            }
            fis.close();
            is.close();
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        data.put("headers", header);
        data.put("csvType", csvType);
        return data;
    }

    private HashMap<String, Object> getHeadersXLS(String filePath, byte[] bytes) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String[] completeHeader = new String[]{};
        try {
            int index = 0;
            ArrayList<String> headerList = new ArrayList<String>();
            FileOutputStream os = new FileOutputStream(filePath);
            CsvMapWriter writer = new CsvMapWriter((Writer)new OutputStreamWriter((OutputStream)os, "UTF-8"), CsvPreference.EXCEL_PREFERENCE);
            ByteArrayInputStream fis = new ByteArrayInputStream(bytes);
            HSSFWorkbook wb = new HSSFWorkbook((InputStream)fis);
            HSSFSheet sheet = wb.getSheetAt(0);
            HSSFFormulaEvaluator formulaEvaluator = wb.getCreationHelper().createFormulaEvaluator();
            DataFormatter formatter = new DataFormatter();
            for (Row row : sheet) {
                int i;
                String val;
                HashMap rowData = new HashMap();
                if (index == 0) {
                    for (Cell cell : row) {
                        val = formatter.formatCellValue(cell);
                        headerList.add(val);
                    }
                    completeHeader = new String[headerList.size()];
                    for (i = 0; i < headerList.size(); ++i) {
                        completeHeader[i] = (String)headerList.get(i);
                    }
                    writer.writeHeader(completeHeader);
                } else {
                    for (i = 0; i < headerList.size(); ++i) {
                        Cell cell;
                        cell = row.getCell(i);
                        if (cell != null) {
                            val = formatter.formatCellValue(cell);
                            rowData.put(headerList.get(i), val);
                            continue;
                        }
                        rowData.put(headerList.get(i), "");
                    }
                    writer.write(rowData, completeHeader);
                }
                ++index;
            }
            writer.close();
            os.close();
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        data.put("headers", completeHeader);
        data.put("csvType", "EXCEL_PREFERENCE");
        return data;
    }

    private HashMap<String, Object> getHeadersXLSX(String filePath, byte[] bytes) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String[] completeHeader = new String[]{};
        try {
            int index = 0;
            ArrayList<String> headerList = new ArrayList<String>();
            FileOutputStream os = new FileOutputStream(filePath);
            CsvMapWriter writer = new CsvMapWriter((Writer)new OutputStreamWriter((OutputStream)os, "UTF-8"), CsvPreference.EXCEL_PREFERENCE);
            ByteArrayInputStream fis = new ByteArrayInputStream(bytes);
            XSSFWorkbook wb = new XSSFWorkbook((InputStream)fis);
            XSSFSheet sheet = wb.getSheetAt(0);
            Iterator itr = sheet.iterator();
            DataFormatter formatter = new DataFormatter();
            while (itr.hasNext()) {
                String val;
                Row row = (Row)itr.next();
                HashMap rowData = new HashMap();
                if (index == 0) {
                    Iterator cellIterator = row.cellIterator();
                    while (cellIterator.hasNext()) {
                        Cell cell = (Cell)cellIterator.next();
                        if (cell != null) {
                            val = formatter.formatCellValue(cell);
                            headerList.add(val);
                            continue;
                        }
                        headerList.add("");
                    }
                    completeHeader = new String[headerList.size()];
                    for (int i = 0; i < headerList.size(); ++i) {
                        completeHeader[i] = (String)headerList.get(i);
                    }
                    writer.writeHeader(completeHeader);
                } else {
                    for (int i = 0; i < headerList.size(); ++i) {
                        Cell cell = row.getCell(i);
                        if (cell != null) {
                            val = formatter.formatCellValue(cell);
                            rowData.put(headerList.get(i), val);
                            continue;
                        }
                        rowData.put(headerList.get(i), "");
                    }
                    writer.write(rowData, completeHeader);
                }
                ++index;
            }
            writer.close();
            os.close();
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        data.put("headers", completeHeader);
        data.put("csvType", "EXCEL_PREFERENCE");
        return data;
    }

    @PostMapping(value={"/saveCSVMap"})
    @ResponseBody
    public ResponseEntity<Object> saveCSVMapping(@RequestBody String requestBody, HttpServletRequest request, HttpServletResponse response) {
        Gson gson = new Gson();
        1 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap param = (HashMap)gson.fromJson(requestBody, T.getType());
        ArrayList<MappedFieldVO> mapFieldsList = new ArrayList<MappedFieldVO>();
        if (PropertyValidator.isValid(param.get("summary")) && !param.get("summary").equals("-1")) {
            mapFieldsList.add(new MappedFieldVO((String)param.get("summary"), "Summary", Boolean.valueOf(true)));
        }
        if (PropertyValidator.isValid(param.get("dueDate")) && !param.get("dueDate").equals("-1")) {
            mapFieldsList.add(new MappedFieldVO((String)param.get("dueDate"), "Due Date", Boolean.valueOf(true)));
        }
        if (PropertyValidator.isValid(param.get("jiraKey")) && !param.get("jiraKey").equals("-1")) {
            mapFieldsList.add(new MappedFieldVO((String)param.get("jiraKey"), "Key", Boolean.valueOf(true)));
        }
        if (PropertyValidator.isValid(param.get("status")) && !param.get("status").equals("-1")) {
            mapFieldsList.add(new MappedFieldVO((String)param.get("status"), "Status", Boolean.valueOf(true)));
        }
        String csvType = (String)param.get("csvType");
        CsvPreference preference = CsvPreference.EXCEL_PREFERENCE;
        if (csvType.equals("STANDARD_PREFERENCE")) {
            preference = CsvPreference.STANDARD_PREFERENCE;
        } else if (csvType.equals("EXCEL_PREFERENCE")) {
            preference = CsvPreference.EXCEL_PREFERENCE;
        } else if (csvType.equals("EXCEL_NORTH_EUROPE_PREFERENCE")) {
            preference = CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE;
        } else if (csvType.equals("TAB_PREFERENCE")) {
            preference = CsvPreference.TAB_PREFERENCE;
        }
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)((String)param.get("sessionBoardId"))));
        this.importService.executeImport((Map)param, sessionBoard, mapFieldsList, preference);
        return new ResponseEntity((Object)"ok", HttpStatus.OK);
    }

    @RequestMapping(value={"/picture"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> setUserPicture(@RequestParam(value="file") MultipartFile file, @RequestParam(value="uid") String userId, RedirectAttributes redirectAttributes, HttpServletRequest request) {
        User user = this.userRepository.findById(userId);
        try {
            LOGGER.debug("Adding prifle pic :" + file.getName());
            user.setPicturePath("profile_" + UserContextUtil.getUUId() + ".png");
            byte[] bytes = file.getBytes();
            if (Boolean.parseBoolean(this.env.getProperty("isLocalDeployment"))) {
                Path path = Paths.get(this.env.getProperty("attachment.location") + "/" + user.getPicturePath(), new String[0]);
                Files.write(path, bytes, new OpenOption[0]);
            } else {
                Attachment attachmentVO = new Attachment();
                attachmentVO.setAttachmentData(file.getBytes());
                attachmentVO.setFilepath(user.getPicturePath());
                S3Utils.uploadFile((Attachment)attachmentVO);
            }
            LOGGER.debug("uploaded to S3  :" + user.getPicturePath());
            user = (User)this.userRepository.save((Object)user);
            LOGGER.debug("Saved to DB  :" + user.getPicturePath());
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User loggeduser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            if (loggeduser.getId().equals(user.getId())) {
                loggeduser.setPicturePath(user.getPicturePath());
            }
        }
        catch (Exception e) {
            LOGGER.debug(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity((Object)user, HttpStatus.OK);
    }

    @RequestMapping(value={"/attachment"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> uploadAttachment(@RequestParam(value="file") MultipartFile file, @RequestParam(value="fileName") String fileName, @RequestParam(value="fileExt") String fileExt, RedirectAttributes redirectAttributes, HttpServletRequest request) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        try {
            Attachment attachmentVO;
            LOGGER.debug("Adding prifle pic :" + file.getName());
            String filePath = "attachment_" + UserContextUtil.getUUId() + "." + fileExt;
            byte[] bytes = file.getBytes();
            if (Boolean.parseBoolean(this.env.getProperty("isLocalDeployment"))) {
                Path path = Paths.get(this.env.getProperty("attachment.location") + "/" + filePath, new String[0]);
                Files.write(path, bytes, new OpenOption[0]);
            } else {
                attachmentVO = new Attachment();
                attachmentVO.setAttachmentData(file.getBytes());
                attachmentVO.setReferenceKey(UUID.randomUUID().toString());
                attachmentVO.setFilepath(filePath);
                attachmentVO.setFilename(file.getOriginalFilename());
                attachmentVO.setContentType(file.getContentType());
                S3Utils.uploadFile((Attachment)attachmentVO);
            }
            LOGGER.debug("uploaded to S3  :" + filePath);
            attachmentVO = new Attachment();
            attachmentVO.setFilepath(filePath);
            attachmentVO.setMimeType(file.getContentType());
            attachmentVO.setFilename(fileName);
            attachmentVO.setCreatedOn(new Date());
            attachmentVO.setFilesize(Long.valueOf(file.getSize()));
            LOGGER.debug("Saved to DB  :" + filePath);
            responseJson.put("success", true);
            responseJson.put("attachment", (Boolean)attachmentVO);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.debug(StringUtils.getTraceString((Throwable)e));
            responseJson.put("success", false);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
    }

    @RequestMapping(value={"/logo/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> setCompanyLogo(@RequestParam(value="file") MultipartFile file, RedirectAttributes redirectAttributes, HttpServletRequest request) {
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        Company _comp = (Company)this.companyRepository.findOne((Serializable)((Object)cid));
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", false);
        try {
            if (PropertyValidator.isValid((Object)_comp)) {
                Customize customize = _comp.getCustomization();
                if (!PropertyValidator.isValid((Object)customize)) {
                    customize = new Customize();
                }
                customize.setLogoPath("logo_" + UserContextUtil.getUUId() + ".png");
                if (Boolean.parseBoolean(this.env.getProperty("isLocalDeployment"))) {
                    byte[] bytes = file.getBytes();
                    Path path = Paths.get(this.env.getProperty("attachment.location") + "/" + customize.getLogoPath(), new String[0]);
                    Files.write(path, bytes, new OpenOption[0]);
                } else {
                    Attachment attachmentVO = new Attachment();
                    attachmentVO.setAttachmentData(file.getBytes());
                    attachmentVO.setFilepath(customize.getLogoPath());
                    S3Utils.uploadFile((Attachment)attachmentVO);
                }
                _comp.setCustomization(customize);
                this.companyRepository.save((Object)_comp);
                responseJson.put("success", true);
                responseJson.put("customize", (Boolean)customize);
                SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                User loggeduser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
                List userCompanies = loggeduser.getUserCompanies();
                for (UserCompany userCompany : userCompanies) {
                    if (!userCompany.getCompany().getId().equals(cid)) continue;
                    userCompany.getCompany().setCustomization(customize);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/icon/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> setCompanyIcon(@RequestParam(value="file") MultipartFile file, RedirectAttributes redirectAttributes, HttpServletRequest request) {
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        Company _comp = (Company)this.companyRepository.findOne((Serializable)((Object)cid));
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", false);
        try {
            if (PropertyValidator.isValid((Object)_comp)) {
                Customize customize = _comp.getCustomization();
                if (!PropertyValidator.isValid((Object)customize)) {
                    customize = new Customize();
                }
                customize.setIconPath("icon_" + UserContextUtil.getUUId() + ".png");
                if (Boolean.parseBoolean(this.env.getProperty("isLocalDeployment"))) {
                    byte[] bytes = file.getBytes();
                    Path path = Paths.get(this.env.getProperty("attachment.location") + "/" + customize.getIconPath(), new String[0]);
                    Files.write(path, bytes, new OpenOption[0]);
                } else {
                    Attachment attachmentVO = new Attachment();
                    attachmentVO.setAttachmentData(file.getBytes());
                    attachmentVO.setFilepath(customize.getIconPath());
                    S3Utils.uploadFile((Attachment)attachmentVO);
                }
                _comp.setCustomization(customize);
                this.companyRepository.save((Object)_comp);
                responseJson.put("success", true);
                responseJson.put("customize", (Boolean)customize);
                SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                User loggeduser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
                List userCompanies = loggeduser.getUserCompanies();
                for (UserCompany userCompany : userCompanies) {
                    if (!userCompany.getCompany().getId().equals(cid)) continue;
                    userCompany.getCompany().setCustomization(customize);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/upload/keystore"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> uploadkeystore(@RequestParam(value="file") MultipartFile file, RedirectAttributes redirectAttributes, HttpServletRequest request) {
        HashMap<String, String> response = new HashMap<String, String>();
        try {
            if (file.isEmpty()) {
                redirectAttributes.addFlashAttribute("message", (Object)"Please select a file to upload");
                response.put("error", "Empty File");
            } else {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getBytes());
                String savedFileId = MongoSyncUtils.storeDataBytes((String)file.getOriginalFilename(), (String)file.getOriginalFilename(), (String)"application/pkcs-12", (InputStream)inputStream, (AppConfig.MongoConfig)this.mongoConfig);
                response.put("key", file.getOriginalFilename());
                response.put("fileId", savedFileId);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> uploadUsers(@RequestParam(value="file") MultipartFile file, @RequestParam(value="fileName") String fileName, @RequestParam(value="csvType") String csvType, RedirectAttributes redirectAttributes, HttpServletRequest request) {
        HashMap response = new HashMap();
        try {
            if (file.isEmpty()) {
                redirectAttributes.addFlashAttribute("message", (Object)"Please select a file to upload");
                response.put("error", "Empty File");
            } else {
                byte[] bytes = file.getBytes();
                Path path = Paths.get(this.env.getProperty("temp.file.location") + file.getOriginalFilename(), new String[0]);
                String fileCompletePath = path.toAbsolutePath().toString();
                if (fileCompletePath.endsWith(".csv")) {
                    Files.write(path, bytes, new OpenOption[0]);
                    response = this.getCsvHeaders(fileCompletePath, null);
                } else if (fileCompletePath.endsWith(".xls")) {
                    path = Paths.get(this.env.getProperty("temp.file.location") + file.getOriginalFilename().replaceAll(".xls", ".csv"), new String[0]);
                    fileCompletePath = path.toAbsolutePath().toString();
                    response = this.getHeadersXLS(fileCompletePath, bytes);
                } else if (fileCompletePath.endsWith(".xlsx")) {
                    path = Paths.get(this.env.getProperty("temp.file.location") + file.getOriginalFilename().replaceAll(".xlsx", ".csv"), new String[0]);
                    fileCompletePath = path.toAbsolutePath().toString();
                    response = this.getHeadersXLSX(fileCompletePath, bytes);
                }
                Date now = new Date();
                ArrayList<String> formates = new ArrayList<String>();
                ArrayList<String> dates = new ArrayList<String>();
                formates.add("dd MMM yyyy hh:mm aa");
                formates.add("dd/MMM/yy hh:mm aa");
                formates.add("dd/MM/yyyy HH:mm");
                formates.add("MM/dd/yyyy HH:mm");
                formates.add("dd-MM-yyyy HH:mm");
                formates.add("MM-dd-yyyy HH:mm");
                formates.add("dd/MMM/yy");
                formates.add("dd/MM/yyyy");
                formates.add("MM/dd/yyyy");
                formates.add("dd-MM-yyyy");
                formates.add("MM-dd-yyyy");
                formates.add("d MMM yy");
                formates.add("EEE, MMM d, ''yy");
                formates.add("yyyy.MM.dd");
                formates.add("dd.MM.yyyy");
                formates.add("MM.dd.yyyy");
                formates.add("MM/dd/yy");
                formates.add("dd/MM/yy");
                formates.add("yy/dd/MM");
                formates.add("yy/MM/dd");
                formates.add("dd-MM-yy");
                formates.add("yyyy-MM-dd");
                formates.add("dd-MMM-yy");
                SimpleDateFormat date_parser = null;
                for (String formate : formates) {
                    date_parser = new SimpleDateFormat(formate);
                    dates.add(date_parser.format(now));
                }
                response.put("csvType", response.get("csvType"));
                response.put("filePath", fileCompletePath);
                response.put("formates", formates);
                response.put("dates", dates);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/import/{importType}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> importUsers(@PathVariable(value="importType") String importType, @RequestBody HashMap<String, Object> requestBody, HttpServletRequest request, HttpServletResponse response) {
        HashMap responseObject = new HashMap();
        try {
            HashMap data;
            Gson gson = new Gson();
            HashMap<String, Object> param = requestBody;
            String dateFormat = null;
            if (param.containsKey("dateFormat")) {
                dateFormat = (String)param.get("dateFormat");
            }
            param.put("importType", importType);
            ArrayList<MappedFieldVO> mapFieldsList = new ArrayList<MappedFieldVO>();
            HashMap headerKeys = (HashMap)param.get("headerKeys");
            HashMap headerValues = (HashMap)param.get("headerValues");
            Set keys = headerKeys.keySet();
            for (String key : keys) {
                MappedFieldVO columnMapping = new MappedFieldVO((String)headerKeys.get(key), (String)headerValues.get(key), Boolean.valueOf(true), key);
                if (key.toLowerCase().indexOf("date") > -1) {
                    columnMapping.setDateFormate(dateFormat);
                }
                mapFieldsList.add(columnMapping);
            }
            String csvType = (String)param.get("csvType");
            CsvPreference preference = CsvPreference.EXCEL_PREFERENCE;
            if (csvType.equals("STANDARD_PREFERENCE")) {
                preference = CsvPreference.STANDARD_PREFERENCE;
            } else if (csvType.equals("EXCEL_PREFERENCE")) {
                preference = CsvPreference.EXCEL_PREFERENCE;
            } else if (csvType.equals("EXCEL_NORTH_EUROPE_PREFERENCE")) {
                preference = CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE;
            } else if (csvType.equals("TAB_PREFERENCE")) {
                preference = CsvPreference.TAB_PREFERENCE;
            }
            SessionBoard sessionBoard = null;
            if (!"users".equals(importType)) {
                sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)((String)param.get("sessionBoardId"))));
            }
            if (PropertyValidator.isValid((Object)(data = (HashMap)this.importService.executeImport(param, sessionBoard, mapFieldsList, preference)))) {
                return new ResponseEntity((Object)data, HttpStatus.OK);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseObject, HttpStatus.OK);
    }

    @RequestMapping(value={"/removepicture"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> removePicture(@RequestBody String data) throws JSONException {
        String resMsg = "Something went wrong! Unable to delete";
        HashMap<String, Object> responseObject = new HashMap<String, Object>();
        try {
            JSONObject jObj = new JSONObject(data);
            User user = this.userRepository.findById(jObj.getString("uid"));
            user.setPicturePath(null);
            user = (User)this.userRepository.save((Object)user);
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User loggeduser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            if (loggeduser.getId().equals(user.getId())) {
                loggeduser.setPicturePath(null);
            }
            resMsg = "Picture removed successfully";
            responseObject.put("user", user);
            responseObject.put("uid", jObj.getString("uid"));
            responseObject.put("success", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        responseObject.put("msg", resMsg);
        return new ResponseEntity(responseObject, HttpStatus.OK);
    }

    @PostMapping(value={"/upload/upload-image"})
    public ResponseEntity<String> uploadImage(@RequestParam(value="file") MultipartFile file) {
        try {
            String fileId = this.attachmentService.uploadImage(file);
            LOGGER.debug("Upload image file: {}", (Object)fileId);
            return ResponseEntity.ok((Object)fileId);
        }
        catch (Exception e) {
            LOGGER.debug(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.status((int)500).body((Object)("Upload failed: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/upload/retrieve-image/{id}"}, produces={"image/jpeg"})
    public ResponseEntity<byte[]> retrieveImage(@PathVariable String id) {
        try {
            GridFSDBFile file = this.mongoConfig.gridFsTemplate().findOne(new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id)));
            if (file == null) {
                return ResponseEntity.notFound().build();
            }
            GridFsResource resource = this.gridFsTemplate.getResource(file.getFilename());
            DBObject metadata = file.getMetaData();
            String contentType = "image/png";
            if (metadata != null && metadata.get("_contentType") != null) {
                contentType = metadata.get("_contentType").toString();
            }
            return ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).body((Object)IOUtils.toByteArray((InputStream)resource.getInputStream()));
        }
        catch (Exception e) {
            LOGGER.debug(StringUtils.getTraceString((Throwable)e));
            ResponseEntity.status((int)500).body((Object)("Retreival failed: " + e.getMessage()));
            return ResponseEntity.notFound().build();
        }
    }
}

