/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.viztrend.safe.alm.jira.bo.TFSWebhookMappedData;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.TFSWebhookRepository;
import com.viztrend.safe.utils.PropertyValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/tfswebhook"})
@RestController
public class TFSWebHookController {
    @Autowired
    TFSWebhookRepository tfsWebhookRepository;
    @Autowired
    private Environment env;
    @Autowired
    AlmAccountRepository almAccountRepository;
    @Autowired
    CompanyRepository companyRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(TFSWebHookController.class);
    private BlockingQueue<List<String>> queue = new LinkedBlockingQueue(10000);
    private static Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));

    @RequestMapping(value={"/{accId}"}, method={RequestMethod.POST})
    public ResponseEntity<String> getJiraItem(@PathVariable(value="accId") String accId, @RequestBody String jsonpayload, HttpServletRequest request) {
        if ("true".equals(this.env.getProperty("maintenance"))) {
            return ResponseEntity.status((int)503).body((Object)"Maintenance mode");
        }
        return this.useInMemoryQueue(accId, jsonpayload, "" + request.getHeader("x-vss-activityid"), "" + request.getHeader("x-vss-subscriptionid"));
    }

    private ResponseEntity<String> useInMemoryQueue(String accId, String jsonpayload, String xVssActivityid, String xVssSubscriptionid) {
        try {
            if (this.queue.remainingCapacity() > 0) {
                ArrayList<String> payloadLst = new ArrayList<String>();
                payloadLst.add(accId);
                payloadLst.add(jsonpayload);
                payloadLst.add(xVssActivityid);
                payloadLst.add(xVssSubscriptionid);
                this.queue.put(payloadLst);
                return ResponseEntity.ok((Object)"Webhook queued successfully");
            }
            return ResponseEntity.ok((Object)"Webhook skipped due to capacity ");
        }
        catch (InterruptedException e) {
            LOGGER.error("Error processing TFS (Local) webhook for account: " + accId, (Throwable)e);
            return ResponseEntity.status((int)500).body((Object)"Internal server error");
        }
    }

    private ResponseEntity<String> useSQS(String accId, String jsonpayload, String xVssActivityid, String xVssSubscriptionid) {
        try {
            boolean success = false;
            if (success) {
                return ResponseEntity.ok((Object)"Webhook queued successfully");
            }
            return ResponseEntity.status((int)500).body((Object)"Failed to queue webhook");
        }
        catch (Exception e) {
            LOGGER.error("Error processing JIRA webhook for account: " + accId, (Throwable)e);
            return ResponseEntity.status((int)500).body((Object)"Internal server error");
        }
    }

    @Scheduled(fixedRate=1L)
    public void processWebhook() {
        try {
            List webhookJsonLst;
            if (!this.queue.isEmpty() && (webhookJsonLst = (List)this.queue.take()) != null) {
                String tenant;
                Company company;
                AlmAccount account;
                String almAccountId = ((String)webhookJsonLst.get(0)).toString();
                String webhookJsonString = ((String)webhookJsonLst.get(1)).toString();
                String xVssSubscriptionid = ((String)webhookJsonLst.get(2)).toString();
                String xVssActivityid = ((String)webhookJsonLst.get(3)).toString();
                if (this.env.getProperty("isLocalDeployment").equals("true")) {
                    LOGGER.debug("Webhook received  :: " + webhookJsonString + ":: almId ::" + almAccountId);
                }
                if (PropertyValidator.isValid((Object)(account = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId)))) && account.isDebug()) {
                    LOGGER.debug("------------------------------------------- WEBHOOK RECIEVED ----------------------");
                    LOGGER.debug("Webhook received  :: " + almAccountId);
                    LOGGER.debug(webhookJsonString);
                }
                if (PropertyValidator.isValid((Object)account) && account.getIsActive().booleanValue() && PropertyValidator.isValid((Object)(company = this.companyRepository.findByTenant(tenant = account.getTenant())))) {
                    long diff = 1L;
                    long diff2 = 1L;
                    if (company.getExpiryDate() != null) {
                        diff = company.getExpiryDate().getTime() - cal.getTime().getTime();
                    } else if (company.getNextPaymentDate() != null) {
                        diff2 = company.getNextPaymentDate().getTime() - cal.getTime().getTime();
                    }
                    if (diff > 0L && diff2 > 0L) {
                        TFSWebhookMappedData mappedData = new TFSWebhookMappedData();
                        mappedData.fillInfo(almAccountId, tenant, webhookJsonString, xVssActivityid, xVssSubscriptionid);
                        this.tfsWebhookRepository.save((Object)mappedData);
                        if (PropertyValidator.isValid((Object)account) && account.isDebug()) {
                            LOGGER.debug("------------------------------------------- WEBHOOK PERSISTED ----------------------");
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.POST})
    public void receivePayload(@RequestBody String jsonpayload) {
        System.out.println(jsonpayload);
    }

    @RequestMapping(value={"/testtfs"})
    public void receivePayload() {
        System.out.println("TFS hello world.");
    }

    static {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }
}

