/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.viztrend.safe.annotations.SchedLock;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.controller.SosController;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.enums.EnumStatusCategory;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.AuditLog;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemLog;
import com.viztrend.safe.persistence.entity.PiJourney;
import com.viztrend.safe.persistence.entity.PiProgramRole;
import com.viztrend.safe.persistence.entity.PiSite;
import com.viztrend.safe.persistence.entity.SOSDateTime;
import com.viztrend.safe.persistence.entity.Scrum;
import com.viztrend.safe.persistence.entity.ScrumOfScrums;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.WorkSpaceAccessRole;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.AuditLogRepository;
import com.viztrend.safe.persistence.repository.BaseItemLinkRepository;
import com.viztrend.safe.persistence.repository.BaseItemRepository;
import com.viztrend.safe.persistence.repository.ContainerRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.ItemLogRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.PiJourneyRepository;
import com.viztrend.safe.persistence.repository.PiProgramRoleRepository;
import com.viztrend.safe.persistence.repository.PiSiteRepository;
import com.viztrend.safe.persistence.repository.ScrumOfScrumsRepository;
import com.viztrend.safe.persistence.repository.ScrumRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceAccessRoleRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.ChangeLogSyncService;
import com.viztrend.safe.service.ExternalEntitiesService;
import com.viztrend.safe.service.NotificationService;
import com.viztrend.safe.service.ObjectiveService;
import com.viztrend.safe.service.StatsService;
import com.viztrend.safe.strategy.PushInclusionStrategy;
import com.viztrend.safe.utils.AlmUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.LocalMailSender;
import com.viztrend.safe.utils.MongoSyncUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.File;
import java.io.Serializable;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/sos"})
@Controller
public class SosController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SosController.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private ScrumOfScrumsRepository sosRepository;
    @Autowired
    private ScrumRepository scrumRepository;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private CustomRepository customRepository;
    @Autowired
    private WorkFlowRepository workFlowRepository;
    @Autowired
    private BaseItemLinkRepository baseItemLinkRepository;
    @Autowired
    private BaseItemRepository baseItemRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private LocalMailSender localMailSender;
    @Autowired
    private WorkSpaceAccessRoleRepository accessRoleRepository;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ItemLogRepository itemLogRepository;
    @Autowired
    private ExternalEntitiesService externalEntitiesService;
    @Autowired
    private AuditLogRepository auditLogRepository;
    @Autowired
    private PiJourneyRepository piJourneyRepository;
    @Autowired
    private PiProgramRoleRepository piProgramRoleRepository;
    @Autowired
    private PiSiteRepository piSiteRepository;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private AppConfig.MongoConfig mongoConfig;
    @Autowired
    private StatsService statsService;
    @Autowired
    private ObjectiveService objectiveService;
    @Autowired
    private ChangeLogSyncService changeLogService;
    private final ExecutorService executorService = Executors.newFixedThreadPool(5);

    @Scheduled(fixedRate=300000L)
    @SchedLock(name="processSOS")
    public void processSOS() {
        try {
            Date now = new Date();
            long dateInMillis = now.getTime();
            Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
            HashMap<String, String> pushJson = new HashMap<String, String>();
            pushJson.put("event", sosEnums.ScrumOfScrums.name());
            pushJson.put("action", sosEnums.endedSoS.name());
            String metaMap = gson.toJson(pushJson);
            gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
            Query query = new Query();
            Criteria criteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"closeDateMillis").gte((Object)dateInMillis).andOperator(new Criteria[]{Criteria.where((String)"closeDateMillis").lt((Object)(dateInMillis + 300000L))})});
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"endedOn").is(null));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"lockedOn").is(null));
            query.addCriteria((CriteriaDefinition)criteria);
            List sosList = this.mongoTemplate.find(query, ScrumOfScrums.class);
            if (PropertyValidator.isValid((Collection)sosList)) {
                ArrayList<ScrumOfScrums> sosToSave = new ArrayList<ScrumOfScrums>();
                for (ScrumOfScrums sos : sosList) {
                    int next;
                    sos.setMetaMap(metaMap);
                    sos.setEndedOn(sos.getEndDate());
                    if (PropertyValidator.isValid((Object)sos.getReminderMinutes()) && (next = sos.findIndexOfNextStart()) > -1) {
                        sos.setUpdated(false);
                        sos.setReminderMillis(Long.valueOf(((SOSDateTime)sos.getFurtureSosList().get(next)).getStartDate().getTime() + sos.getTimeDiff() - TimeUnit.MINUTES.toMillis(sos.getReminderMinutes())));
                    }
                    sosToSave.add(sos);
                }
                this.sosRepository.save(sosToSave);
            }
            query = new Query();
            criteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"reminderMillis").gte((Object)dateInMillis).andOperator(new Criteria[]{Criteria.where((String)"reminderMillis").lt((Object)(dateInMillis + 300000L))})});
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"endedOn").is(null));
            query.addCriteria((CriteriaDefinition)criteria);
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"reminderSent").ne((Object)true));
            sosList = this.mongoTemplate.find(query, ScrumOfScrums.class);
            if (PropertyValidator.isValid((Collection)sosList)) {
                for (ScrumOfScrums sos : sosList) {
                    try {
                        this.sendTeamSpecificReminderEmails(sos);
                        this.customRepository.updateSosReminderSent(sos.getId());
                        LOGGER.debug("Processed reminder emails for SOS: {}", (Object)sos.getId());
                    }
                    catch (Exception e) {
                        LOGGER.error("Error sending reminder emails for SOS {}: {}", (Object)(sos != null ? sos.getId() : "unknown"), (Object)StringUtils.getTraceString((Throwable)e));
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
    }

    public void sendTeamSpecificReminderEmails(ScrumOfScrums sos) {
        try {
            if (PropertyValidator.isValid((Object)sos) && PropertyValidator.isValid((Collection)sos.getScrums())) {
                for (Scrum scrum : sos.getScrums()) {
                    if (!PropertyValidator.isValid((Collection)scrum.getRemainderList()) || scrum.getRemainderList().size() <= 0) continue;
                    this.externalEntitiesService.sendScrumSpecificReminderEmail(sos, scrum);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in sendTeamSpecificReminderEmails for SOS {}: {}", (Object)(sos != null ? sos.getId() : "unknown"), (Object)StringUtils.getTraceString((Throwable)e));
            throw e;
        }
    }

    @RequestMapping(value={"/active-sos-list"}, method={RequestMethod.POST})
    public ResponseEntity<Object> fetchActiveScrumOfScrumsList(@RequestBody HashMap<String, Object> requestBody) {
        HashMap<String, ArrayList> responseJson = new HashMap<String, ArrayList>();
        try {
            String sessionId = (String)requestBody.get("sessionId");
            ArrayList activeSosList = this.sosRepository.findBySessionId(sessionId);
            responseJson.put("sosList", activeSosList);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/check-active"}, method={RequestMethod.POST})
    public ResponseEntity<Object> checkActiveScrumOfScrums(@RequestBody HashMap<String, Object> requestBody) {
        HashMap<String, Exception> responseJson = new HashMap<String, Exception>();
        try {
            if (PropertyValidator.isValid((Object)requestBody.get("id"))) {
                ScrumOfScrums sos = (ScrumOfScrums)this.sosRepository.findOne((Serializable)((Object)((String)requestBody.get("id"))));
                this.externalEntitiesService.sendSOSReminderEmail(sos);
            }
            this.processSOS();
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/load-active"}, method={RequestMethod.POST})
    public ResponseEntity<Object> activeScrumOfScrums(@RequestBody HashMap<String, Object> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        List timeZoneList = new ArrayList();
        try {
            responseJson.put("SERVE_TIME_ZONE", AlmUtils.getServerTimeZone());
            responseJson.put("month_code", 2);
            responseJson.put("day_code", 6);
            String sosDate = (String)requestBody.get("sosDate");
            ScrumOfScrums activeScurm = null;
            List sosList = new ArrayList();
            HashMap<String, Integer> rangeCodes = new HashMap<String, Integer>();
            rangeCodes.put("Week", 6);
            rangeCodes.put("Month", 2);
            responseJson.put("RANGE_CODES", rangeCodes);
            if (!PropertyValidator.isValid((Object)requestBody.get("sessionId"))) {
                responseJson.put("success", false);
                responseJson.put("reason", "Invalid Input");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            String sessionId = (String)requestBody.get("sessionId");
            sosList = sosDate != null ? this.sosRepository.findBySessionId(sessionId) : this.sosRepository.findBySessionIdAndEndedOnExistsOrderByEndedOnDesc(sessionId, Boolean.valueOf(false));
            timeZoneList = this.externalEntitiesService.getTimeZoneList();
            if (PropertyValidator.isValid(timeZoneList)) {
                responseJson.put("timeZoneList", timeZoneList);
            }
            if (!PropertyValidator.isValid((Collection)sosList)) {
                sosList = this.sosRepository.findBySessionIdAndEndedOnExistsOrderByEndedOnDesc(sessionId, Boolean.valueOf(true));
                if (PropertyValidator.isValid((Collection)sosList)) {
                    responseJson.put(sosEnums.endedSoS.name(), true);
                }
            } else {
                responseJson.put(sosEnums.endedSoS.name(), false);
            }
            if (PropertyValidator.isValid((Collection)sosList)) {
                if (sosDate != null) {
                    SimpleDateFormat todayDateFormat = new SimpleDateFormat("d-MMM-yyyy");
                    Calendar cal = Calendar.getInstance();
                    LocalDateTime dt = LocalDateTime.ofInstant(cal.toInstant(), cal.getTimeZone().toZoneId());
                    ZonedDateTime zone1 = dt.atZone(cal.getTimeZone().toZoneId());
                    for (ScrumOfScrums sos : sosList) {
                        ZonedDateTime zone2 = dt.atZone(ZoneId.of(sos.getTimeZoneName()));
                        long diff = Duration.between(zone2, zone1).toMillis();
                        if (!todayDateFormat.format(sos.getStartDateMillis() + diff).equals(sosDate) || activeScurm != null) continue;
                        activeScurm = sos;
                    }
                }
                if (activeScurm == null) {
                    activeScurm = (ScrumOfScrums)sosList.get(0);
                }
                responseJson.put("sos", activeScurm);
            }
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/work-flows/{sessionId}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> retireveWorkFlowsForSOS(@PathVariable(value="sessionId") String sessionId) {
        HashMap<String, Cloneable> responseJson = new HashMap<String, Cloneable>();
        try {
            PiJourney piJourney;
            ArrayList<WorkFlow> workFlows1 = this.workFlowRepository.findAllByWorkflowType(WorkFlow.WorkFlowType.Impediment.name());
            ArrayList<WorkFlow> workFlows2 = this.workFlowRepository.findAllByWorkflowType(WorkFlow.WorkFlowType.ActionPoint.name());
            ArrayList<WorkFlow> workFlows3 = this.workFlowRepository.findAllByWorkflowType(WorkFlow.WorkFlowType.Severity.name());
            if (!PropertyValidator.isValid((Collection)workFlows1)) {
                workFlows1 = new ArrayList<WorkFlow>();
                workFlows1.add(this.customRepository.createDefaultWorkflow("Default Impediment Workflow", WorkFlow.WorkFlowType.Impediment.name()));
            }
            if (!PropertyValidator.isValid((Collection)workFlows2)) {
                workFlows2 = new ArrayList<WorkFlow>();
                workFlows2.add(this.customRepository.createDefaultWorkflow("Default Action Item Workflow", WorkFlow.WorkFlowType.ActionPoint.name()));
            }
            if (!PropertyValidator.isValid((Collection)workFlows3)) {
                workFlows3 = new ArrayList<WorkFlow>();
                workFlows3.add(this.customRepository.createDefaultWorkflow("Default Severity Workflow", WorkFlow.WorkFlowType.Severity.name()));
            }
            if (PropertyValidator.isValid((Object)sessionId) && PropertyValidator.isValid((Object)(piJourney = this.piJourneyRepository.findBySessionId(sessionId)))) {
                List programRoles = this.piProgramRoleRepository.findByPiJourneyId(piJourney.getId());
                HashMap teamRoleMap = new HashMap();
                for (PiProgramRole pr : programRoles) {
                    if (!PropertyValidator.isValid((Object)pr.getSystemRole())) continue;
                    String role = pr.getSystemRole().getTitle();
                    String teamId = "";
                    teamId = PropertyValidator.isValid((Object)pr.getTeamId()) ? pr.getTeamId() : "-1";
                    HashMap<String, User> userRole = new HashMap<String, User>();
                    if (role.equals("Scrum Master")) {
                        userRole.put(role, pr.getUser());
                        if (PropertyValidator.isValid(teamRoleMap.get(teamId))) {
                            userRole.putAll((Map)teamRoleMap.get(teamId));
                        }
                        teamRoleMap.put(teamId, userRole);
                        continue;
                    }
                    if (!role.equals("Product Owner")) continue;
                    userRole.put(role, pr.getUser());
                    if (PropertyValidator.isValid(teamRoleMap.get(teamId))) {
                        userRole.putAll((Map)teamRoleMap.get(teamId));
                    }
                    teamRoleMap.put(teamId, userRole);
                }
                responseJson.put("roles", teamRoleMap);
            }
            responseJson.put(WorkFlow.WorkFlowType.Impediment.name(), workFlows1);
            responseJson.put(WorkFlow.WorkFlowType.ActionPoint.name(), workFlows2);
            responseJson.put(WorkFlow.WorkFlowType.Severity.name(), workFlows3);
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage());
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/update-sosMeta/{type}"}, method={RequestMethod.POST})
    public void updateScrumOfScrumMeta(@RequestBody ScrumOfScrums sos, @PathVariable String type) {
        try {
            if (PropertyValidator.isValid((Object)sos) && PropertyValidator.isValid((Object)sos.getId())) {
                sos = (ScrumOfScrums)this.sosRepository.findOne((Serializable)((Object)sos.getId()));
                sos.setUpdated(true);
                if (!type.isEmpty() && PropertyValidator.isValid((Collection)sos.getRemainderList()) && sos.getRemainderList().size() > 0) {
                    sos.getRemainderList().remove(type);
                    sos.setRemainderList(sos.getRemainderList());
                    sos.setUpdated(true);
                    this.sosRepository.save((Object)sos);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage());
        }
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseEntity<Object> updateScrumOfScrums(@RequestBody ScrumOfScrums sos) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        HashMap<String, Object> pushJson = new HashMap<String, Object>();
        HashMap pushMeta = new HashMap();
        HashMap<String, ScrumOfScrums> pushData = new HashMap<String, ScrumOfScrums>();
        ObjectMapper mapper = new ObjectMapper();
        1 T = new /* Unavailable Anonymous Inner Class!! */;
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
        boolean isNewSos = false;
        try {
            ScrumOfScrums savedSOS;
            pushMeta = (HashMap)gson.fromJson(sos.getMetaMap(), T.getType());
            pushJson.put("metaMap", sos.getMetaMap());
            pushJson.put("push", "Self");
            List restrictions = KendisUtils.getRestrictions((WorkSpaceRepository)this.workSpaceRepository, (WorkSpaceAccessRoleRepository)this.accessRoleRepository, null);
            if (KendisUtils.isActionAllowed((String)"configure-sos", (List)restrictions)) {
                ScrumOfScrums newSOS;
                List sosLinks;
                savedSOS = null;
                List<Object> savedScrums = new ArrayList<Object>();
                List<PiSite> savedSites = new ArrayList<Object>();
                if (PropertyValidator.isValid((Object)sos.getId())) {
                    savedSOS = (ScrumOfScrums)this.sosRepository.findOne((Serializable)((Object)sos.getId()));
                    if (PropertyValidator.isValid((Collection)sos.getScrums())) {
                        ArrayList<Object> newScrums = new ArrayList<Object>();
                        for (Object scrum : sos.getScrums()) {
                            if (!PropertyValidator.isValid((Object)scrum.getId())) {
                                newScrums.add(scrum);
                                continue;
                            }
                            savedScrums.add(scrum);
                        }
                        ArrayList<Object> allScrums = new ArrayList<Object>();
                        allScrums.addAll(savedScrums);
                        allScrums.addAll(newScrums);
                        savedScrums = this.scrumRepository.save(allScrums);
                        savedSOS.setScrums(savedScrums);
                    }
                    if (PropertyValidator.isValid((Collection)sos.getSites())) {
                        ArrayList<Object> newSites = new ArrayList<Object>();
                        ArrayList<String> sitesToDelete = new ArrayList<String>();
                        for (Object site : sos.getSites()) {
                            if (!PropertyValidator.isValid((Object)site.getId())) {
                                newSites.add(site);
                                continue;
                            }
                            if (PropertyValidator.isValid((Object)site.getId()) && !site.getDeleted()) {
                                savedSites.add((PiSite)site);
                                continue;
                            }
                            if (!PropertyValidator.isValid((Object)site.getId())) continue;
                            sitesToDelete.add(site.getId());
                        }
                        String defaultTimeZone = "";
                        if (PropertyValidator.isValid(savedSites)) {
                            defaultTimeZone = ((PiSite)savedSites.get(0)).getTimeZone();
                        }
                        for (PiSite piSite : newSites) {
                            TimeZone timeZone = TimeZone.getTimeZone(piSite.getTimeZone());
                            piSite.setDstSavings(timeZone.getDSTSavings());
                            piSite.setRawOffset(timeZone.getRawOffset());
                            if (!piSite.getIsDefault().booleanValue()) continue;
                            defaultTimeZone = piSite.getTimeZone();
                        }
                        savedSOS.setTimeZoneName(defaultTimeZone);
                        ArrayList<Object> allSites = new ArrayList<Object>();
                        allSites.addAll(savedSites);
                        allSites.addAll(newSites);
                        savedSites = this.piSiteRepository.save(allSites);
                        this.piSiteRepository.deleteByIdIn(sitesToDelete);
                        savedSOS.setSites(savedSites);
                    }
                    isNewSos = false;
                } else {
                    ScrumOfScrums activeScurm = null;
                    String sessionId = "";
                    ArrayList sosList = new ArrayList();
                    if (!PropertyValidator.isValid((Object)sos.getSessionId())) {
                        responseJson.put("success", false);
                        responseJson.put("reason", "Invalid Input");
                        return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
                    }
                    sessionId = sos.getSessionId();
                    sosList = this.sosRepository.findBySessionId(sessionId);
                    if (PropertyValidator.isValid((Collection)sosList)) {
                        if (activeScurm == null) {
                            activeScurm = (ScrumOfScrums)sosList.get(0);
                        }
                        responseJson.put("sos", activeScurm);
                        return new ResponseEntity(responseJson, HttpStatus.OK);
                    }
                    savedSOS = new ScrumOfScrums();
                    savedSOS.setCid(UserContextUtil.getUserContext().getCurrentCompanyId());
                    if (PropertyValidator.isValid((Collection)sos.getScrums())) {
                        savedScrums.addAll(sos.getScrums());
                    }
                    savedScrums = this.scrumRepository.save(savedScrums);
                    savedSOS.setScrums(savedScrums);
                    isNewSos = true;
                }
                if (PropertyValidator.isValid((Object)sos.getSessionId())) {
                    savedSOS.setSessionId(sos.getSessionId());
                }
                if (PropertyValidator.isValid((Object)sos.getImpedimentWorkFlow())) {
                    savedSOS.setImpedimentWorkFlow(sos.getImpedimentWorkFlow());
                }
                if (PropertyValidator.isValid((Object)sos.getActionPointWorkFlow())) {
                    savedSOS.setActionPointWorkFlow(sos.getActionPointWorkFlow());
                }
                if (PropertyValidator.isValid((Object)sos.getSeverityWorkFlow())) {
                    savedSOS.setSeverityWorkFlow(sos.getSeverityWorkFlow());
                }
                if (PropertyValidator.isValid((Collection)sos.getScrums())) {
                    savedSOS.setScrums(savedScrums);
                }
                if (PropertyValidator.isValid((Object)sos.getProgressType())) {
                    savedSOS.setProgressType(sos.getProgressType());
                }
                if (PropertyValidator.isValid((Object)sos.getSelectedDays())) {
                    savedSOS.setSelectedDays((HashMap)sos.getSelectedDays());
                }
                if (PropertyValidator.isValid((Collection)sos.getFurtureSosList())) {
                    savedSOS.setFurtureSosList(sos.getFurtureSosList());
                }
                if (PropertyValidator.isValid((Object)sos.getEmailConfiguration())) {
                    savedSOS.setEmailConfiguration(sos.getEmailConfiguration());
                    HashSet<String> remainder = new HashSet<String>();
                    if (PropertyValidator.isValid((Object)sos.getEmailConfiguration())) {
                        if (Boolean.TRUE.equals(sos.getEmailConfiguration().get("Highlights"))) {
                            remainder.add("Highlights");
                        }
                        if (Boolean.TRUE.equals(sos.getEmailConfiguration().get(WorkFlow.WorkFlowType.Impediment.name()))) {
                            remainder.add(WorkFlow.WorkFlowType.Impediment.name());
                        }
                        if (Boolean.TRUE.equals(sos.getEmailConfiguration().get(WorkFlow.WorkFlowType.ActionPoint.name()))) {
                            remainder.add(WorkFlow.WorkFlowType.ActionPoint.name());
                        }
                    }
                    savedSOS.setRemainderList(remainder);
                }
                if (PropertyValidator.isValid((Object)sos.getAllTeamLabel())) {
                    savedSOS.setAllTeamLabel(sos.getAllTeamLabel());
                }
                if (PropertyValidator.isValid((Object)sos.getRoomLink())) {
                    savedSOS.setRoomLink(sos.getRoomLink());
                }
                if (PropertyValidator.isValid((Object)sos.getActiveRoomLink())) {
                    savedSOS.setActiveRoomLink(sos.getActiveRoomLink());
                }
                if (PropertyValidator.isValid((Object)sos.isAutoCloseSOS())) {
                    savedSOS.setAutoCloseSOS(sos.isAutoCloseSOS());
                }
                if (PropertyValidator.isValid((Object)sos.getTimeDiff())) {
                    savedSOS.setTimeDiff(sos.getTimeDiff());
                }
                if (PropertyValidator.isValid((Object)sos.getReminderMinutes())) {
                    savedSOS.setReminderMinutes(sos.getReminderMinutes());
                }
                if (PropertyValidator.isValid((Object)sos.getLockedOn())) {
                    savedSOS.setLockedOn(sos.getLockedOn());
                }
                if (PropertyValidator.isValid((Object)sos.getEndedOn())) {
                    savedSOS.setEndedOn(sos.getEndedOn());
                }
                if (PropertyValidator.isValid((Object)sos.getFinalDate())) {
                    savedSOS.setFinalDate(sos.getFinalDate());
                }
                if (PropertyValidator.isValid((Object)sos.getStartDate())) {
                    savedSOS.setStartDate(sos.getStartDate());
                    savedSOS.setStartDateMillis(Long.valueOf(sos.getStartDate().getTime()));
                }
                if (PropertyValidator.isValid((Object)sos.getEndDate())) {
                    savedSOS.setEndDate(sos.getEndDate());
                    savedSOS.setEndDateMillis(Long.valueOf(sos.getEndDate().getTime()));
                }
                if (PropertyValidator.isValid((Object)sos.getTopImpedimentCount())) {
                    savedSOS.setTopImpedimentCount(sos.getTopImpedimentCount());
                }
                if (PropertyValidator.isValid((Object)sos.getRangeType())) {
                    savedSOS.setRangeType(sos.getRangeType());
                }
                if (PropertyValidator.isValid((Object)sos.getFrequency())) {
                    savedSOS.setFrequency(sos.getFrequency());
                }
                if (PropertyValidator.isValid((Collection)savedSOS.getScrums())) {
                    for (Object scrum : savedSOS.getScrums()) {
                        scrum.initializeRemainderListFromEmailConfig(savedSOS.getEmailConfiguration());
                    }
                    this.scrumRepository.save((Iterable)savedSOS.getScrums());
                }
                if (isNewSos) {
                    if (PropertyValidator.isValid((Collection)sos.getSites())) {
                        savedSites.addAll(sos.getSites());
                        HashMap<String, Boolean> mergeMap = new HashMap<String, Boolean>();
                        for (PiSite site : savedSites) {
                            mergeMap.put(site.getCity() + site.getProvince() + site.getCountry(), true);
                        }
                        for (PiSite site : sos.getSites()) {
                            String key = site.getCity() + site.getProvince() + site.getCountry();
                            if (mergeMap.containsKey(key)) continue;
                            savedSites.add(site);
                            mergeMap.put(key, true);
                        }
                    }
                    String defaultTimeZone = ((PiSite)savedSites.get(0)).getTimeZone();
                    for (PiSite site : savedSites) {
                        TimeZone timeZone = TimeZone.getTimeZone(site.getTimeZone());
                        site.setDstSavings(timeZone.getDSTSavings());
                        site.setRawOffset(timeZone.getRawOffset());
                        if (!site.getIsDefault().booleanValue()) continue;
                        defaultTimeZone = site.getTimeZone();
                    }
                    savedSOS.setTimeZoneName(defaultTimeZone);
                    savedSites = this.piSiteRepository.save(savedSites);
                    savedSOS.setSites(savedSites);
                }
                Calendar cal = Calendar.getInstance();
                LocalDateTime dt = LocalDateTime.now();
                ZonedDateTime fromZonedDateTime = dt.atZone(ZoneId.of(sos.getLocalZone()));
                ZonedDateTime toZonedDateTime = dt.atZone(ZoneId.of(savedSOS.getTimeZoneName()));
                long l = Duration.between(fromZonedDateTime, toZonedDateTime).toMillis();
                long serverDiff = Duration.between(dt.atZone(ZoneId.of(cal.getTimeZone().getID())), toZonedDateTime).toMillis();
                savedSOS.setTimeDiffDayEnd(Long.valueOf(serverDiff));
                savedSOS.setTimeDiff(Long.valueOf(l));
                savedSOS.calcEmailTime(Long.valueOf(l));
                savedSOS = (ScrumOfScrums)this.sosRepository.save((Object)savedSOS);
                if (isNewSos && PropertyValidator.isValid((Object)sos.getSessionId()) && PropertyValidator.isValid((Collection)(sosLinks = this.baseItemLinkRepository.findBySessionId(sos.getSessionId())))) {
                    for (BaseItemLink baseItemLink : sosLinks) {
                        baseItemLink.setScrumOfScrumId(savedSOS.getId());
                    }
                    this.baseItemLinkRepository.save((Iterable)sosLinks);
                }
                if (!isNewSos && Boolean.TRUE.equals(pushMeta.get("loadNext")) && PropertyValidator.isValid((Object)(newSOS = this.loadNewScrumOfScrums(savedSOS)))) {
                    savedSOS = newSOS;
                }
            } else {
                return this.onNotAllowed("configure-sos");
            }
            responseJson.put("sos", savedSOS);
            pushJson.put("action", "configurationUpdate");
            pushData.put("sos", savedSOS);
            pushJson.put("data", pushData);
            PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"load-analytics/{auditLogId}"}, method={RequestMethod.POST})
    public ResponseEntity<Object> loadScrumAnalytics(@PathVariable String auditLogId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            if (PropertyValidator.isValid((Object)auditLogId)) {
                AuditLog auditLog = (AuditLog)this.auditLogRepository.findOne((Serializable)((Object)auditLogId));
                String analyticsData = "";
                if ("SOS_FILE_REF".equals(auditLog.getEventType())) {
                    analyticsData = MongoSyncUtils.retrieveData((String)auditLog.getAuditData(), (AppConfig.MongoConfig)this.mongoConfig);
                } else if ("SOS_FILE_REF_MAP".equals(auditLog.getEventType())) {
                    String fileRefs = MongoSyncUtils.retrieveData((String)auditLog.getAuditData(), (AppConfig.MongoConfig)this.mongoConfig);
                    response.put("fileRefs", fileRefs);
                } else {
                    analyticsData = auditLog.getAuditData();
                }
                response.put("analyticsData", analyticsData);
                return new ResponseEntity(response, HttpStatus.ACCEPTED);
            }
        }
        catch (Exception ex) {
            response.put("kendisError", ex);
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity(response, HttpStatus.BAD_REQUEST);
        }
        return null;
    }

    @RequestMapping(value={"get-stats"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getStatsByFileReference(@RequestBody Map<String, String> requestBody) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String key = requestBody.get("key");
        String value = requestBody.get("value");
        String sprintKey = requestBody.get("sprintKey");
        try {
            if (PropertyValidator.isValid((Object)key) && PropertyValidator.isValid((Object)value)) {
                String analyticsData = MongoSyncUtils.retrieveData((String)key, (AppConfig.MongoConfig)this.mongoConfig);
                response.put(value, analyticsData);
                if (PropertyValidator.isValid((Object)sprintKey)) {
                    String activeSprint = MongoSyncUtils.retrieveData((String)sprintKey, (AppConfig.MongoConfig)this.mongoConfig);
                    response.put("activeSprint", activeSprint);
                }
                return new ResponseEntity(response, HttpStatus.OK);
            }
        }
        catch (Exception ex) {
            response.put("kendisError", ex);
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity(response, HttpStatus.BAD_REQUEST);
        }
        return null;
    }

    public ScrumOfScrums loadNewScrumOfScrums(@RequestBody ScrumOfScrums sos) {
        Date now = new Date();
        User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
        ScrumOfScrums nextSOS = null;
        List newScrums = new ArrayList();
        ScrumOfScrums savedSOS = (ScrumOfScrums)this.sosRepository.findOne((Serializable)((Object)sos.getId()));
        if (PropertyValidator.isValid((Collection)savedSOS.getFurtureSosList()) && savedSOS.findIndexOfNextStart() > -1) {
            nextSOS = savedSOS.nextSoS(now, loggedInUser);
            newScrums = nextSOS.getScrums();
            this.moveImpediments(now, loggedInUser, newScrums, nextSOS.getId(), savedSOS.getId());
            this.sosRepository.save((Object)nextSOS);
            return nextSOS;
        }
        return null;
    }

    @RequestMapping(value={"/mark-complete/{syncId}"}, method={RequestMethod.POST})
    public ResponseEntity<Object> markComplete(@RequestBody Map<String, Object> requestBody, @PathVariable(value="syncId") String syncId) {
        Date now = new Date();
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        HashMap emailContent = new HashMap();
        HashMap<String, Object> pushJson = new HashMap<String, Object>();
        ObjectMapper mapper = new ObjectMapper();
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
        User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
        HashMap<String, String> pushMeta = new HashMap<String, String>();
        HashMap<String, Object> pushData = new HashMap<String, Object>();
        HashMap emailRequestObject = new HashMap();
        ScrumOfScrums nextSOS = new ScrumOfScrums();
        List newScrums = new ArrayList();
        List restrictions = KendisUtils.getRestrictions((WorkSpaceRepository)this.workSpaceRepository, (WorkSpaceAccessRoleRepository)this.accessRoleRepository, (String)((String)requestBody.get("workSpaceId")));
        pushMeta.put("event", sosEnums.ScrumOfScrums.name());
        pushMeta.put("syncId", syncId);
        pushJson.put("metaMap", gson.toJson(pushMeta));
        pushJson.put("push", "Self");
        pushJson.put("action", "markComplete");
        try {
            ItemLog markedCompleteLog;
            ScrumOfScrums savedSOS;
            if (KendisUtils.isActionAllowed((String)"mark-complete", (List)restrictions)) {
                String sosId = (String)requestBody.get("id");
                savedSOS = (ScrumOfScrums)this.sosRepository.findOne((Serializable)((Object)sosId));
                AuditLog auditLog = new AuditLog();
                HashMap riskAnalyticsResponse = new HashMap();
                HashMap riskAnalyticsPayload = (HashMap)requestBody.get("riskanalytics");
                if (PropertyValidator.isValid((Object)riskAnalyticsPayload)) {
                    riskAnalyticsResponse = this.statsService.getRiskStatsBySprintAndTeam(riskAnalyticsPayload);
                }
                String riskAnalyticsFile = UUID.randomUUID().toString();
                JSONObject riskAnalyticsJson = new JSONObject((Map)riskAnalyticsResponse);
                String riskAnalyticsResponseString = riskAnalyticsJson.toString();
                MongoSyncUtils.storeData((String)riskAnalyticsFile, (String)riskAnalyticsResponseString, (AppConfig.MongoConfig)this.mongoConfig);
                HashMap deliveryByTeamPayload = (HashMap)requestBody.get("deliveryByTeam");
                String sessionId = (String)requestBody.get("sessionId");
                String sessionBoardId = (String)requestBody.get("sessionBoardId");
                String sprintId = (String)requestBody.get("sprintId");
                Boolean autoCloseSOS = (Boolean)requestBody.get("autoCloseSOS");
                HashMap deliveryByTeamResponse = new HashMap();
                if (PropertyValidator.isValid((Object)deliveryByTeamPayload)) {
                    deliveryByTeamResponse = this.statsService.getDataByTeam(sessionId, (Map)deliveryByTeamPayload);
                }
                String deliveryByTeamResponseFile = UUID.randomUUID().toString();
                JSONObject deliveryByTeamJson = new JSONObject((Map)deliveryByTeamResponse);
                String deliveryByTeamResponseString = deliveryByTeamJson.toString();
                MongoSyncUtils.storeData((String)deliveryByTeamResponseFile, (String)deliveryByTeamResponseString, (AppConfig.MongoConfig)this.mongoConfig);
                HashMap objectiveResponse = new HashMap();
                objectiveResponse = this.objectiveService.loadObjectivesListBySessionId(sessionId, null, sessionBoardId);
                String objectiveResponseFile = UUID.randomUUID().toString();
                JSONObject objectiveResponseJson = new JSONObject((Map)objectiveResponse);
                String objectiveResponseString = objectiveResponseJson.toString();
                MongoSyncUtils.storeData((String)objectiveResponseFile, (String)objectiveResponseString, (AppConfig.MongoConfig)this.mongoConfig);
                HashMap<String, Container> activeSprintResponse = new HashMap<String, Container>();
                Container sprint = (Container)this.containerRepository.findOne((Serializable)((Object)sprintId));
                activeSprintResponse.put("activeSprint", sprint);
                String activeSprintResponseFile = UUID.randomUUID().toString();
                Gson spGson = new GsonBuilder().setDateFormat(8).create();
                String activeSprintResponseString = spGson.toJson(activeSprintResponse);
                MongoSyncUtils.storeData((String)activeSprintResponseFile, (String)activeSprintResponseString, (AppConfig.MongoConfig)this.mongoConfig);
                HashMap<String, String> fileReferences = new HashMap<String, String>();
                fileReferences.put("riskAnalyticsFile", riskAnalyticsFile);
                fileReferences.put("deliveryByTeamResponseFile", deliveryByTeamResponseFile);
                fileReferences.put("objectiveResponseFile", objectiveResponseFile);
                fileReferences.put("activeSprintResponseFile", activeSprintResponseFile);
                String fileReferencesString = new Gson().toJson(fileReferences);
                String fileReferenceKey = UUID.randomUUID().toString();
                MongoSyncUtils.storeData((String)fileReferenceKey, (String)fileReferencesString, (AppConfig.MongoConfig)this.mongoConfig);
                auditLog.setAuditData(fileReferenceKey);
                auditLog.setEventType("SOS_FILE_REF_MAP");
                auditLog = (AuditLog)this.auditLogRepository.save((Object)auditLog);
                if (savedSOS.getEndedOn() == null) {
                    savedSOS.setEndedOn(new Date());
                }
                if (PropertyValidator.isValid((Collection)savedSOS.getFurtureSosList()) && savedSOS.findIndexOfNextStart() > -1) {
                    nextSOS = savedSOS.nextSoS(now, loggedInUser);
                    newScrums = nextSOS.getScrums();
                    this.moveImpediments(now, loggedInUser, newScrums, nextSOS.getId(), savedSOS.getId());
                    this.sosRepository.save((Object)nextSOS);
                    responseJson.put("sos", nextSOS);
                    responseJson.put("lastSos", false);
                    pushData.put("sos", nextSOS);
                    pushData.put("lastSos", false);
                    pushJson.put("data", pushData);
                } else {
                    responseJson.put("sos", savedSOS);
                    responseJson.put("lastSos", true);
                    pushData.put("sos", savedSOS);
                    pushData.put("lastSos", true);
                }
                savedSOS.setUpdated(true);
                savedSOS.setFreezedSosStatId(auditLog.getId());
                this.sosRepository.save((Object)savedSOS);
                User user = UserContextUtil.getUserContext().getLoggedInUser();
                markedCompleteLog = new ItemLog();
                markedCompleteLog.setEventTime(new Date());
                markedCompleteLog.setActivityBy(user.getFullName());
                markedCompleteLog.setDetail((Object)savedSOS);
                if (Boolean.TRUE.equals(autoCloseSOS)) {
                    markedCompleteLog.setEventType("AUTO-MARKED-COMPLETE");
                } else {
                    markedCompleteLog.setEventType("MARKED-COMPLETE");
                }
            } else {
                return this.onNotAllowed("mark-complete");
            }
            markedCompleteLog.setItemType(sosEnums.ScrumOfScrums.name());
            markedCompleteLog.setItemId(savedSOS.getId());
            this.itemLogRepository.save((Object)markedCompleteLog);
            PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/lock-{toggle}/{syncId}"}, method={RequestMethod.POST})
    public ResponseEntity<Object> lockUnLocrumOfScrums(@RequestBody ScrumOfScrums sos, @PathVariable(value="toggle") String toggle, @PathVariable(value="syncId") String syncId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        HashMap<String, Object> pushJson = new HashMap<String, Object>();
        ObjectMapper mapper = new ObjectMapper();
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
        HashMap<String, String> pushMeta = new HashMap<String, String>();
        HashMap<String, ScrumOfScrums> pushData = new HashMap<String, ScrumOfScrums>();
        pushMeta.put("event", sosEnums.ScrumOfScrums.name());
        pushMeta.put("syncId", syncId);
        pushJson.put("metaMap", gson.toJson(pushMeta));
        pushJson.put("push", "Self");
        pushJson.put("action", "lockToggle");
        try {
            ScrumOfScrums savedSOS = (ScrumOfScrums)this.sosRepository.findOne((Serializable)((Object)sos.getId()));
            if ("on".equals(toggle)) {
                if (savedSOS.getLockedOn() == null) {
                    savedSOS.setLockedOn(new Date());
                }
            } else if ("off".equals(toggle) && savedSOS.getLockedOn() != null) {
                savedSOS.setLockedOn(null);
            }
            savedSOS = (ScrumOfScrums)this.sosRepository.save((Object)savedSOS);
            responseJson.put("sos", savedSOS);
            pushData.put("sos", savedSOS);
            pushJson.put("data", pushData);
            PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"scrum/updatenotes"}, method={RequestMethod.POST})
    public ResponseEntity<Object> updateScrumNotes(@RequestBody HashMap<String, Object> requestBody) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        List receipientList = new ArrayList();
        HashMap<String, Object> emailRequestObject = new HashMap<String, Object>();
        try {
            List restrictions = KendisUtils.getRestrictions((WorkSpaceRepository)this.workSpaceRepository, (WorkSpaceAccessRoleRepository)this.accessRoleRepository, (String)((String)requestBody.get("workSpaceId")));
            if (PropertyValidator.isValid((Object)requestBody.get("scrumId")) && KendisUtils.isActionAllowed((String)"edit-highlights", (List)restrictions)) {
                String syncId = requestBody.get("syncId").toString();
                receipientList = (List)requestBody.get("mentionUsers");
                Scrum scrum = (Scrum)this.scrumRepository.findOne((Serializable)((Object)requestBody.get("scrumId").toString()));
                scrum.setNotes(requestBody.get("text").toString().trim());
                ScrumOfScrums sos = (ScrumOfScrums)this.sosRepository.findOne((Serializable)((Object)requestBody.get("sosId").toString()));
                if (PropertyValidator.isValid((Collection)sos.getRemainderList()) && sos.getRemainderList().size() > 0 && sos.getRemainderList().contains("Highlights")) {
                    sos.getRemainderList().remove("Highlights");
                    sos.setRemainderList(sos.getRemainderList());
                    sos.setUpdated(true);
                    this.sosRepository.save((Object)sos);
                }
                if (PropertyValidator.isValid((Collection)scrum.getRemainderList()) && scrum.getRemainderList().size() > 0 && scrum.getRemainderList().contains("Highlights")) {
                    scrum.getRemainderList().remove("Highlights");
                    scrum.setRemainderList(scrum.getRemainderList());
                }
                this.scrumRepository.save((Object)scrum);
                Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
                HashMap<String, String> pushJson = new HashMap<String, String>();
                ObjectMapper mapper = new ObjectMapper();
                HashMap<String, String> pushMeta = new HashMap<String, String>();
                pushMeta.put("event", sosEnums.ScrumOfScrums.name());
                pushMeta.put("syncId", syncId);
                pushJson.put("metaMap", gson.toJson(pushMeta));
                pushJson.put("push", "Self");
                pushJson.put("action", "notesUpdate");
                pushJson.put("data", (String)scrum);
                emailRequestObject.put("emailList", receipientList);
                emailRequestObject.put("emailType", "mention-user");
                emailRequestObject.put("Item-type", "Highlight");
                emailRequestObject.put("Item-detail", scrum.getNotes());
                if (PropertyValidator.isValid(receipientList) && receipientList.size() > 0) {
                    this.externalEntitiesService.sendEmailNotitication(emailRequestObject);
                }
                PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
                responseJson.put("success", true);
                responseJson.put("scrum", (Boolean)scrum);
                return new ResponseEntity(responseJson, HttpStatus.ACCEPTED);
            }
            return this.onNotAllowed("edit-highlights");
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity(responseJson, HttpStatus.ACCEPTED);
        }
    }

    @RequestMapping(value={"/container/update"})
    public ResponseEntity<Object> saveContainer(@RequestBody Map<String, Object> request, HttpServletRequest httpRequest) {
        HashMap response;
        block14: {
            response = new HashMap();
            try {
                List restrictions = KendisUtils.getRestrictions((WorkSpaceRepository)this.workSpaceRepository, (WorkSpaceAccessRoleRepository)this.accessRoleRepository, null);
                Map startDates = (Map)request.get("startDate");
                Map endDates = (Map)request.get("endDate");
                String sessionBoardId = (String)request.get("sessionBoardId");
                if (KendisUtils.isActionAllowed((String)"configure-sos", (List)restrictions) || PropertyValidator.isValid((Object)httpRequest.getParameter("ignore-configure-sos"))) {
                    List containers = this.containerRepository.findByIdIn(startDates.keySet());
                    if (PropertyValidator.isValid((Collection)containers)) {
                        Session session;
                        for (Container container : containers) {
                            container.setStartDate(new Date((Long)startDates.get(container.getId())));
                            container.setEndDate(new Date((Long)endDates.get(container.getId())));
                        }
                        containers = this.containerRepository.save((Iterable)containers);
                        SessionBoard sessionBoard = this.sessionBoardRepository.findById(sessionBoardId);
                        if (PropertyValidator.isValid((Object)sessionBoard) && PropertyValidator.isValid((Object)(session = sessionBoard.getSession()).isAutoFillStartEndDate()) && session.isAutoFillStartEndDate()) {
                            Date smallestDate = null;
                            Date largestDate = null;
                            for (int i = 0; i < sessionBoard.getContainers().size(); ++i) {
                                Container sprint = (Container)sessionBoard.getContainers().get(i);
                                if (PropertyValidator.isValid((Object)sprint.getStartDate())) {
                                    if (smallestDate == null) {
                                        smallestDate = sprint.getStartDate();
                                    } else if (sprint.getStartDate().getTime() < smallestDate.getTime()) {
                                        smallestDate = sprint.getStartDate();
                                    }
                                }
                                if (!PropertyValidator.isValid((Object)sprint.getEndDate())) continue;
                                if (largestDate == null) {
                                    largestDate = sprint.getEndDate();
                                    continue;
                                }
                                if (sprint.getEndDate().getTime() <= largestDate.getTime()) continue;
                                largestDate = sprint.getEndDate();
                            }
                            if (PropertyValidator.isValid(smallestDate)) {
                                session.setStartDate(smallestDate);
                            }
                            if (PropertyValidator.isValid(largestDate)) {
                                session.setEndDate(largestDate);
                            }
                            this.sessionRepository.save((Object)session);
                        }
                        return new ResponseEntity((Object)containers, HttpStatus.OK);
                    }
                    break block14;
                }
                return this.onNotAllowed("configure-sos");
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"scrum/deleteImpediment/{itemId}"}, method={RequestMethod.POST})
    public ResponseEntity<Object> deleteImpediment(@PathVariable(value="itemId") String itemId, @RequestBody HashMap<String, Object> requestBody) {
        try {
            String syncId = requestBody.get("syncId").toString();
            List restrictions = KendisUtils.getRestrictions((WorkSpaceRepository)this.workSpaceRepository, (WorkSpaceAccessRoleRepository)this.accessRoleRepository, (String)((String)requestBody.get("workSpaceId")));
            String type = "";
            HashMap<String, String> pushJson = new HashMap<String, String>();
            BaseItem baseItem = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)itemId));
            if (PropertyValidator.isValid((Object)baseItem)) {
                if (baseItem.getType().equals(WorkFlow.WorkFlowType.Impediment.name())) {
                    type = "impediments";
                    pushJson.put("itemType", "Impediment");
                } else if (baseItem.getType().equals(WorkFlow.WorkFlowType.ActionPoint.name())) {
                    type = "action-points";
                    pushJson.put("itemType", "ActionPoint");
                } else if (EnumKendis.MILESTONE.getCode().equals(baseItem.getType()) || EnumKendis.PHASES.getCode().equals(baseItem.getType())) {
                    type = EnumKendis.MILESTONE.getCode();
                    type = type.toLowerCase();
                    pushJson.put("itemType", EnumKendis.MILESTONE.getCode());
                }
                if (!KendisUtils.isActionAllowed((String)("delete-" + type), (List)restrictions)) {
                    return this.onNotAllowed("delete-" + type);
                }
                baseItem.setArchive(true);
                this.baseItemRepository.save((Object)baseItem);
                Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
                ObjectMapper mapper = new ObjectMapper();
                HashMap<String, String> pushMeta = new HashMap<String, String>();
                pushMeta.put("event", sosEnums.ScrumOfScrums.name());
                pushMeta.put("syncId", syncId);
                pushJson.put("metaMap", gson.toJson(pushMeta));
                pushJson.put("push", "Self");
                pushJson.put("action", "impedimentAndActionPointDelete");
                HashMap<String, BaseItem> pushData = new HashMap<String, BaseItem>();
                pushData.put("savedImpediment", baseItem);
                this.externalEntitiesService.sendEmailToWatchersAndResponsible(baseItem, "delete-imp");
                pushJson.put("data", gson.toJson(pushData));
                PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
                return new ResponseEntity((Object)"success", HttpStatus.OK);
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return null;
    }

    @RequestMapping(value={"fetch-boards"}, method={RequestMethod.GET})
    public ResponseEntity<Object> fetchBoardsTeamsAndSprints() {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            List allSessions = this.sessionRepository.findTitleByRowStatus(Integer.valueOf(0));
            response.put("sessionList", allSessions);
            HashMap<String, List> sessionTeamMapById = new HashMap<String, List>();
            HashMap<String, List> sessionContainerMapById = new HashMap<String, List>();
            ArrayList<String> sessionBoardIds = new ArrayList<String>();
            for (Session session : allSessions) {
                sessionBoardIds.add(session.getActiveSessionBoard());
            }
            List sessionBoards = this.sessionBoardRepository.findSessionBoardByIdIn(sessionBoardIds);
            for (SessionBoard sessionBoard : sessionBoards) {
                List teamList = sessionBoard.getTeams();
                List containerList = sessionBoard.getContainers();
                sessionTeamMapById.put(sessionBoard.getSession().getId(), teamList);
                sessionContainerMapById.put(sessionBoard.getSession().getId(), containerList);
            }
            response.put("sessionTeams", sessionTeamMapById);
            response.put("sessionContainers", sessionContainerMapById);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/pdf"})
    @ResponseBody
    public ResponseEntity<Object> printSos(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String css = request.getParameter("content");
        return new ResponseEntity((Object)css, HttpStatus.OK);
    }

    private String getLoggedInUserTenant() {
        SecureUser secureUser = UserContextUtil.getUserContext();
        return String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
    }

    @RequestMapping(value={"/export"}, method={RequestMethod.POST})
    private ResponseEntity<Object> exportSOS(@RequestBody HashMap<String, Object> requestBody) {
        String downloadName = "";
        HashMap<String, String> response = new HashMap<String, String>();
        try {
            if (PropertyValidator.isValid((Object)requestBody.get("sosPageHTML"))) {
                String html = (String)requestBody.get("sosPageHTML");
                String filePath = this.localMailSender.generateSosPDF(html);
                File responsefile = new File(filePath);
                HttpHeaders headers = new HttpHeaders();
                headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
                headers.add("Pragma", "no-cache");
                headers.add("Expires", "0");
                headers.add("Content-Disposition", "attachment; filename=" + responsefile.getName());
                LOGGER.debug("download invoice step 4");
                if (PropertyValidator.isValid((Object)filePath)) {
                    SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
                    downloadName = AlmUtils.cleanText((String)("SOS" + formatter.format(new Date()))) + ".pdf";
                    if (PropertyValidator.isValid((Object)downloadName)) {
                        response.put("srcPath", URLEncoder.encode(filePath, "UTF-8"));
                        response.put("name", downloadName);
                        return new ResponseEntity(response, HttpStatus.OK);
                    }
                    response.put("message", "Something went wrong");
                    return new ResponseEntity(response, HttpStatus.BAD_REQUEST);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return new ResponseEntity(response, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/update-base-item-links/{syncId}/{sessionId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateBaseItemLink(@RequestBody BaseItem inputItem, @PathVariable(value="syncId") String syncId, @PathVariable(value="sessionId") String sessionId) {
        BaseItem savedItem = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)inputItem.getId()));
        if (!PropertyValidator.isValid((Object)savedItem)) {
            HashMap<String, Object> responseJson = new HashMap<String, Object>();
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        ArrayList<String> inputItemLinkedItemIds = new ArrayList<String>();
        List savedItemLinks = savedItem.getBaseItemLinks();
        ArrayList<BaseItemLink> newItemLinks = new ArrayList<BaseItemLink>();
        ArrayList<String> newLinkedItemIds = new ArrayList<String>();
        List<Object> updatedBaseItemLinks = new ArrayList<BaseItemLink>();
        ArrayList<String> baseItemLinkIdsToDelete = new ArrayList<String>();
        if (!PropertyValidator.isValid((Collection)inputItem.getBaseItemLinks())) {
            if (PropertyValidator.isValid((Object)sessionId)) {
                for (BaseItemLink itemLink : savedItemLinks) {
                    if (!itemLink.getSessionId().equals(sessionId) || !PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
                    baseItemLinkIdsToDelete.add(itemLink.getId());
                }
            } else {
                for (BaseItemLink itemLink : savedItemLinks) {
                    if (!PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
                    baseItemLinkIdsToDelete.add(itemLink.getId());
                }
            }
            for (BaseItemLink itemLink : savedItemLinks) {
                if (PropertyValidator.isValid((Object)itemLink.getItemId())) {
                    String itemId = itemLink.getId();
                    if (baseItemLinkIdsToDelete.contains(itemId)) continue;
                    updatedBaseItemLinks.add(itemLink);
                    continue;
                }
                updatedBaseItemLinks.add(itemLink);
            }
            this.baseItemLinkRepository.deleteByIdIn(baseItemLinkIdsToDelete);
            savedItem.setBaseItemLinks(updatedBaseItemLinks);
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)savedItem.getTenant()).and("_id").is((Object)new ObjectId(savedItem.getId())));
            Update update = new Update();
            this.mongoTemplate.updateMulti(query, update, "baseItem");
            savedItem = (BaseItem)this.baseItemRepository.save((Object)savedItem);
        } else {
            ArrayList<String> savedBaseItemLinkIdsFromInputItem = new ArrayList<String>();
            ArrayList<String> savedBaseItemLinkIds = new ArrayList<String>();
            for (Object itemLink : inputItem.getBaseItemLinks()) {
                if (PropertyValidator.isValid((Object)itemLink.getItemId())) {
                    inputItemLinkedItemIds.add(itemLink.getItemId());
                }
                if (!PropertyValidator.isValid((Object)itemLink.getId())) {
                    newItemLinks.add((BaseItemLink)itemLink);
                    if (!PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
                    newLinkedItemIds.add(itemLink.getItemId());
                    continue;
                }
                savedBaseItemLinkIdsFromInputItem.add(itemLink.getId());
            }
            for (Object itemLink : savedItemLinks) {
                if (PropertyValidator.isValid((Object)sessionId) && PropertyValidator.isValid((Object)itemLink.getSessionId())) {
                    if (!itemLink.getSessionId().equals(sessionId) || !PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
                    savedBaseItemLinkIds.add(itemLink.getId());
                    continue;
                }
                if (!PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
                savedBaseItemLinkIds.add(itemLink.getId());
            }
            baseItemLinkIdsToDelete = new ArrayList(savedBaseItemLinkIds);
            baseItemLinkIdsToDelete.removeAll(savedBaseItemLinkIdsFromInputItem);
            if (PropertyValidator.isValid(baseItemLinkIdsToDelete)) {
                this.baseItemLinkRepository.deleteByIdIn(baseItemLinkIdsToDelete);
            }
            for (Object itemLink : savedItemLinks) {
                if (PropertyValidator.isValid((Object)itemLink.getItemId())) {
                    String itemId = itemLink.getId();
                    if (baseItemLinkIdsToDelete.contains(itemId)) continue;
                    if (savedBaseItemLinkIdsFromInputItem.contains(itemLink.getId()) && itemLink.isArchive()) {
                        itemLink.setArchive(false);
                    }
                    updatedBaseItemLinks.add(itemLink);
                    continue;
                }
                if (savedBaseItemLinkIdsFromInputItem.contains(itemLink.getId()) && itemLink.getLinkType().equals("parent_okr") && itemLink.isArchive()) {
                    itemLink.setArchive(false);
                }
                updatedBaseItemLinks.add(itemLink);
            }
            if (PropertyValidator.isValid(newItemLinks)) {
                newItemLinks.sort(Comparator.comparing(BaseItemLink::getSequence));
                HashSet<Double> seenSequences = new HashSet<Double>();
                for (BaseItemLink link : newItemLinks) {
                    double currentSequence = link.getSequence();
                    while (seenSequences.contains(currentSequence)) {
                        currentSequence += 1.0;
                    }
                    link.setSequence(Double.valueOf(currentSequence));
                    seenSequences.add(currentSequence);
                }
                updatedBaseItemLinks.addAll(newItemLinks);
            }
            updatedBaseItemLinks = this.baseItemLinkRepository.save(updatedBaseItemLinks);
            savedItem.setBaseItemLinks(updatedBaseItemLinks);
            savedItem = (BaseItem)this.baseItemRepository.save((Object)savedItem);
        }
        HashMap linkedItemsAndUpdatedItem = this.filterExternalItems(savedItem, inputItem);
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
        HashMap<String, Object> pushJson = new HashMap<String, Object>();
        ObjectMapper mapper = new ObjectMapper();
        HashMap pushMeta = new HashMap();
        if (savedItem.getType().equals(EnumKendis.OBJECTIVE_KEY_RESULT.getCode()) || savedItem.getType().contains(EnumKendis.OBJECTIVE.getCode()) && PropertyValidator.isValid((Object)inputItem.getMetaMap())) {
            2 T = new /* Unavailable Anonymous Inner Class!! */;
            pushMeta = (HashMap)gson.fromJson(inputItem.getMetaMap(), T.getType());
        }
        if (savedItem.getType().contains("Objective") || savedItem.getType().equals("KR")) {
            pushMeta.put("event", EnumKendis.NEW_OBJECTIVES.getCode());
            List itemList = (List)linkedItemsAndUpdatedItem.get("linkedItems");
            if (PropertyValidator.isValid((Collection)itemList)) {
                ArrayList<String> parentIds = new ArrayList<String>();
                for (Object item2 : itemList) {
                    if (!item2.getType().equals("Feature")) continue;
                    parentIds.add(item2.getId());
                }
                Map parentChildItemsMap = this.externalEntitiesService.fetchChildItemsGroupedByParentId(parentIds, this.getLoggedInUserTenant());
                if (PropertyValidator.isValid((Object)parentChildItemsMap)) {
                    for (Item item3 : itemList) {
                        if (!item3.getType().equals("Feature") || !PropertyValidator.isValid((Collection)((Collection)parentChildItemsMap.get(item3.getId())))) continue;
                        item3.setSubItems((List)parentChildItemsMap.get(item3.getId()));
                    }
                    savedItem.getBaseItemLinks().sort(Comparator.comparing(BaseItemLink::getSequence));
                    HashMap<String, Integer> baseItemLinkOrder = new HashMap<String, Integer>();
                    for (int i = 0; i < savedItem.getBaseItemLinks().size(); ++i) {
                        baseItemLinkOrder.put(((BaseItemLink)savedItem.getBaseItemLinks().get(i)).getItemId(), i);
                    }
                    itemList.sort(Comparator.comparingInt(item -> baseItemLinkOrder.getOrDefault(item.getId(), Integer.MAX_VALUE)));
                    linkedItemsAndUpdatedItem.put("linkedItems", itemList);
                }
            }
        } else {
            pushMeta.put("event", sosEnums.ScrumOfScrums.name());
        }
        this.executorService.submit(() -> {
            try {
                this.changeLogService.updateItemAndChild(newLinkedItemIds);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        pushMeta.put("syncId", syncId);
        pushJson.put("metaMap", gson.toJson((Object)pushMeta));
        pushJson.put("push", "Self");
        pushJson.put("action", "itemLinking");
        pushJson.put("data", linkedItemsAndUpdatedItem);
        try {
            PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
        }
        catch (JsonProcessingException e) {
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error(err);
        }
        return new ResponseEntity((Object)linkedItemsAndUpdatedItem, HttpStatus.OK);
    }

    @RequestMapping(value={"/remove-base-item-link"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteBaseItemLink(@RequestBody HashMap<String, Object> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String itemId = (String)requestBody.get("itemId");
        String baseItemId = (String)requestBody.get("id");
        String itemType = (String)requestBody.get("itemType");
        BaseItem savedItem = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)baseItemId));
        if (!PropertyValidator.isValid((Object)savedItem)) {
            responseJson = new HashMap();
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid Input");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        List linkedItems = savedItem.getBaseItemLinks();
        HashMap<String, BaseItemLink> linkedItemMap = new HashMap<String, BaseItemLink>();
        for (BaseItemLink itemLink : linkedItems) {
            if (!PropertyValidator.isValid((Object)itemType)) {
                if (!PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
                linkedItemMap.put(itemLink.getItemId(), itemLink);
                continue;
            }
            if (!itemType.equals("BaseItem") || !PropertyValidator.isValid((Object)itemLink.getBaseItemId())) continue;
            linkedItemMap.put(itemLink.getBaseItemId(), itemLink);
        }
        BaseItemLink linkedItemToRemove = (BaseItemLink)linkedItemMap.get(itemId);
        if (PropertyValidator.isValid((Object)linkedItemToRemove)) {
            linkedItemToRemove.setArchive(true);
            this.baseItemLinkRepository.save((Object)linkedItemToRemove);
            this.baseItemRepository.save((Object)savedItem);
            responseJson.put("savedImpediment", savedItem);
        }
        if (requestBody.containsKey("metaMap")) {
            HashMap<String, Object> pushJson = new HashMap<String, Object>();
            HashMap pushMeta = new HashMap();
            HashMap<String, Object> linkedItemToRemoveAndUpdatedItem = new HashMap<String, Object>();
            Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
            pushMeta = (HashMap)requestBody.get("metaMap");
            linkedItemToRemoveAndUpdatedItem.put("savedImpediment", savedItem);
            linkedItemToRemoveAndUpdatedItem.put("linkedItemToRemove", linkedItemToRemove);
            if (savedItem.getType().contains("Objective") || savedItem.getType().equals("KR")) {
                pushMeta.put("event", EnumKendis.NEW_OBJECTIVES.getCode());
            }
            pushJson.put("metaMap", gson.toJson((Object)pushMeta));
            pushJson.put("push", "Self");
            pushJson.put("action", "removeLinkedItem");
            pushJson.put("data", linkedItemToRemoveAndUpdatedItem);
            ObjectMapper mapper = new ObjectMapper();
            try {
                PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
            }
            catch (JsonProcessingException e) {
                String err = StringUtils.getTraceString((Throwable)e);
                LOGGER.error(err);
            }
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"scrum/update-item-sequence/{syncId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateItemSequence(@RequestBody HashMap<String, Object> requestBody, @PathVariable(value="syncId") String syncId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        HashMap<String, Object> pushJson = new HashMap<String, Object>();
        HashMap<String, String> pushMeta = new HashMap<String, String>();
        ObjectMapper mapper = new ObjectMapper();
        String baseItemLinkId = (String)requestBody.get("baseItemLinkId");
        String itemId = (String)requestBody.get("itemId");
        Object k = requestBody.get("sequence");
        Double sequence = null;
        if (k instanceof Number) {
            sequence = ((Number)k).doubleValue();
        }
        List restrictions = KendisUtils.getRestrictions((WorkSpaceRepository)this.workSpaceRepository, (WorkSpaceAccessRoleRepository)this.accessRoleRepository, (String)((String)requestBody.get("workSpaceId")));
        String type = "";
        BaseItem baseItem = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)itemId));
        if (PropertyValidator.isValid((Object)baseItem)) {
            if (baseItem.getType().equals(WorkFlow.WorkFlowType.Impediment.name())) {
                type = "impediments";
            } else if (baseItem.getType().equals(WorkFlow.WorkFlowType.ActionPoint.name())) {
                type = "action-points";
            }
            if (KendisUtils.isActionAllowed((String)("edit-" + type), (List)restrictions)) {
                BaseItemLink baseItemLink = (BaseItemLink)this.baseItemLinkRepository.findOne((Serializable)((Object)baseItemLinkId));
                if (!PropertyValidator.isValid((Object)baseItemLink)) {
                    responseJson.put("success", false);
                    responseJson.put("reason", "Invalid Input");
                    return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
                }
                baseItemLink.setSequence(sequence);
                this.baseItemLinkRepository.save((Object)baseItemLink);
                baseItem = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)itemId));
                pushMeta.put("event", sosEnums.ScrumOfScrums.name());
                pushMeta.put("syncId", syncId);
                Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
                pushJson.put("metaMap", gson.toJson(pushMeta));
                pushJson.put("push", "Self");
                pushJson.put("action", "impedimentAndActionPointUpdate");
                HashMap<String, BaseItem> pushData = new HashMap<String, BaseItem>();
                pushData.put("savedImpediment", baseItem);
                pushJson.put("data", pushData);
                try {
                    PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
                }
                catch (JsonProcessingException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            } else {
                return this.onNotAllowed("edit-" + type);
            }
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(value={"scrum/get-mark-complete-log"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getMarkCompleteLog(@RequestBody HashMap<String, Object> requestBody) {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        String sessionId = (String)requestBody.get("sessionId");
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"detail.sessionId").is((Object)sessionId).andOperator(new Criteria[]{Criteria.where((String)"itemType").is((Object)sosEnums.ScrumOfScrums.name())}));
        query.with(new Sort(Sort.Direction.DESC, new String[]{"createdOn"}));
        List markedCompleteLogs = this.mongoTemplate.find(query, ItemLog.class);
        responseJson.put("markedCompleteLog", markedCompleteLogs);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"detail-view/get-base-items/{itemId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> fetchItemBaseItems(@PathVariable(value="itemId") String itemId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        Query query = new Query();
        if (PropertyValidator.isValid((Object)itemId)) {
            List baseItemLinksOfItem = this.baseItemLinkRepository.findByItemId(itemId);
            if (PropertyValidator.isValid((Collection)baseItemLinksOfItem)) {
                ArrayList<ObjectId> baseItemContainerIds = new ArrayList<ObjectId>();
                for (BaseItemLink ic : baseItemLinksOfItem) {
                    baseItemContainerIds.add(new ObjectId(ic.getId()));
                }
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"baseItemLinks.$id").in(baseItemContainerIds));
                List baseItemList = this.mongoTemplate.find(query, BaseItem.class);
                responseJson.put("baseItems", baseItemList);
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            responseJson.put("baseItems", new ArrayList());
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        responseJson.put("success", false);
        responseJson.put("message", "item id required");
        return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/get-status-workflow-info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchStatusWorkflowInfo(@RequestBody HashMap<String, Object> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String sessionId = (String)requestBody.get("sessionId");
        String sosId = (String)requestBody.get("sosId");
        if (!PropertyValidator.isValid((Object)sessionId) || !PropertyValidator.isValid((Object)sosId)) {
            responseJson.put("success", false);
            responseJson.put("reason", "Invalid session id or sos id");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
        ScrumOfScrums sos = (ScrumOfScrums)this.sosRepository.findOne((Serializable)((Object)sosId));
        responseJson.put("boardName", session.getTitle());
        responseJson.put("boardId", session.getActiveSessionBoard());
        responseJson.put("sosDate", sos.getStartDate());
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-site-info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchSiteInfo(@RequestBody PiSite site) {
        HashMap<String, PiSite> responseJson = new HashMap<String, PiSite>();
        TimeZone timeZone = TimeZone.getTimeZone(site.getTimeZone());
        site.setDstSavings(timeZone.getDSTSavings());
        site.setRawOffset(timeZone.getRawOffset());
        responseJson.put("site", site);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private HashMap<String, Object> filterExternalItems(BaseItem savedImpediment, BaseItem impediment) {
        HashMap externalItemIds = new HashMap();
        List savedImpedimentContainers = savedImpediment.getBaseItemLinks();
        List impedimentContainers = impediment.getBaseItemLinks();
        List<Object> impedimentSessionIds = new ArrayList();
        for (BaseItemLink impdtContainer : savedImpedimentContainers) {
            if (!PropertyValidator.isValid((Object)impdtContainer.getSessionId())) continue;
            impedimentSessionIds.add(impdtContainer.getSessionId());
        }
        impedimentSessionIds = impedimentSessionIds.stream().distinct().collect(Collectors.toList());
        List sessions = this.sessionRepository.findSessionsByIdIn(impedimentSessionIds);
        ArrayList<String> savedLinkedItemsIds = new ArrayList<String>();
        HashMap savedLinkedItemsById = new HashMap();
        ArrayList<Item> savedLinkedItems = new ArrayList<Item>();
        ArrayList<String> linkedItemsIds = new ArrayList<String>();
        HashMap linkedItemsById = new HashMap();
        ArrayList<Item> linkedItems = new ArrayList<Item>();
        for (BaseItemLink itemLink : savedImpedimentContainers) {
            if (!PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
            savedLinkedItemsIds.add(itemLink.getItemId());
            if (PropertyValidator.isValid((Object)itemLink.getLinkedItemById())) {
                savedLinkedItemsById.putAll(itemLink.getLinkedItemById());
            }
            if (!PropertyValidator.isValid(linkedItems)) continue;
            savedLinkedItems.add(itemLink.getLinkedItem());
        }
        for (BaseItemLink itemLink : impedimentContainers) {
            if (!PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
            linkedItemsIds.add(itemLink.getItemId());
            if (PropertyValidator.isValid((Object)itemLink.getLinkedItemById())) {
                linkedItemsById.putAll(itemLink.getLinkedItemById());
            }
            if (!PropertyValidator.isValid((Object)itemLink.getLinkedItemById())) continue;
            linkedItems.add(itemLink.getLinkedItem());
        }
        List itemsList = this.setActiveBoardItems(savedImpediment, sessions, externalItemIds, new HashMap());
        if (PropertyValidator.isValid((Collection)itemsList)) {
            HashMap filteredKeys;
            if (!savedImpediment.getType().contains("Objective") && !savedImpediment.getType().equals("KR")) {
                this.setFeatureStoryPoints(savedLinkedItems);
            }
            if (PropertyValidator.isValid(filteredKeys = savedLinkedItemsById)) {
                externalItemIds.putAll(filteredKeys);
            }
            if (PropertyValidator.isValid(linkedItemsById)) {
                externalItemIds.putAll(linkedItemsById);
            }
            for (BaseItemLink itemLink : savedImpedimentContainers) {
                if (!PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
                HashMap newLinkedItemById = new HashMap();
                newLinkedItemById.put(itemLink.getItemId(), externalItemIds.get(itemLink.getItemId()));
                itemLink.setLinkedItemById(newLinkedItemById);
            }
            savedImpedimentContainers = this.baseItemLinkRepository.save((Iterable)savedImpedimentContainers);
            savedImpediment.setBaseItemLinks(savedImpedimentContainers);
            savedImpediment = (BaseItem)this.baseItemRepository.save((Object)savedImpediment);
            for (BaseItemLink itemLink : savedImpediment.getBaseItemLinks()) {
                itemLink.adjustLinkedItemIds();
            }
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (!savedImpediment.getType().contains("Objective") && !savedImpediment.getType().equals("KR")) {
            this.setFeatureStoryPoints(itemsList);
        }
        if (PropertyValidator.isValid((Object)savedImpediment.getStatus()) && (savedImpediment.getType().contains("Objective") || savedImpediment.getType().equals("KR"))) {
            Status status = new Status(savedImpediment.getStatus().getId(), savedImpediment.getStatus().getTitle(), savedImpediment.getStatus().getColor(), savedImpediment.getStatus().getCategory());
            savedImpediment.setStatus(status);
        }
        response.put("savedImpediment", savedImpediment);
        response.put("linkedItems", itemsList);
        return response;
    }

    private List<Item> setActiveBoardItems(BaseItem impediment, List<Session> sessions, Map<String, Object> externalIds, Map<String, Item> externalItemsMap) {
        ArrayList<ObjectId> activeSessionBoardIds = new ArrayList<ObjectId>();
        if (PropertyValidator.isValid(sessions)) {
            for (Session s : sessions) {
                activeSessionBoardIds.add(new ObjectId(s.getActiveSessionBoard()));
            }
        }
        List impedimentContainers = impediment.getBaseItemLinks();
        List<Object> linkedItemsIds = new ArrayList<String>();
        HashMap linkedItemsById = new HashMap();
        List<Object> linkedItems = new ArrayList<Item>();
        for (BaseItemLink itemLink : impedimentContainers) {
            if (!PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
            linkedItemsIds.add(itemLink.getItemId());
            if (PropertyValidator.isValid((Object)itemLink.getLinkedItemById())) {
                linkedItemsById.putAll(itemLink.getLinkedItemById());
            }
            if (!PropertyValidator.isValid(linkedItems)) continue;
            linkedItems.add(itemLink.getLinkedItem());
        }
        List objectIds = KendisUtils.getListAsObjectIds(linkedItemsIds);
        if (externalIds == null) {
            externalIds = new HashMap<String, Object>();
        }
        if (PropertyValidator.isValid(activeSessionBoardIds) && PropertyValidator.isValid(linkedItemsIds)) {
            List itemList;
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{Criteria.where((String)"_id").in((Collection)objectIds), Criteria.where((String)"originItemId").in(linkedItemsIds), Criteria.where((String)"duplicateOfId").in(linkedItemsIds)}), Criteria.where((String)"sessionBoards.$id").in(activeSessionBoardIds)}));
            query.fields().include("title").include("key").include("type").include("storyPoints").include("tfsId").include("kendisKey").include("tfsURL").include("status").include("teamContainers").include("jiraId").include("jiraKey").include("jiraURL").include("issueType").include("jiraIssueTypeId").include("tfsItemType").include("tfsItemTypeIcon").include("sessionBoards").include("originItemId").include("duplicateOfId").include("externalReferenceURL").include("status");
            if (!impediment.getType().contains("Objective") && !impediment.getType().equals("KR")) {
                query.fields().include("parent");
            }
            if (PropertyValidator.isValid((Collection)(itemList = this.mongoTemplate.find(query, Item.class)))) {
                List itemIds = itemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                linkedItemsIds = itemIds;
                linkedItems = itemList;
                for (Item item : itemList) {
                    if (PropertyValidator.isValid((Collection)item.getSessionBoards())) {
                        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
                        for (SessionBoard sb : item.getSessionBoards()) {
                            SessionBoard sessionBoard = new SessionBoard(sb.getId(), sb.getSession());
                            sessionBoards.add(sessionBoard);
                        }
                        item.setSessionBoards(sessionBoards);
                    }
                    if (PropertyValidator.isValid((Object)item.getStatus()) && (impediment.getType().contains("Objective") || impediment.getType().equals("KR"))) {
                        Status status = new Status(item.getStatus().getId(), item.getStatus().getTitle(), item.getStatus().getColor(), item.getStatus().getCategory());
                        item.setStatus(status);
                    }
                    itemIds.add(item.getId());
                    if (PropertyValidator.isValid((Object)item.getJiraId())) {
                        String externalLink = this.getItemLink(item);
                        item.setExternalReferenceURL(externalLink);
                    }
                    if (externalIds != null) {
                        externalIds.put(item.getId(), this.toSimpleObject(item));
                    }
                    if (externalItemsMap == null || linkedItemsById == null) continue;
                    linkedItemsById.remove(item.getId());
                    if (PropertyValidator.isValid((Object)item.getJiraId())) {
                        externalItemsMap.put(item.getJiraKey(), item);
                        continue;
                    }
                    if (!PropertyValidator.isValid((Object)item.getTfsId())) continue;
                    externalItemsMap.put(item.getTfsId(), item);
                }
            } else {
                linkedItemsIds = new ArrayList();
            }
        }
        if (externalItemsMap != null && linkedItemsById != null) {
            List itemList;
            Set ids = linkedItemsById.keySet();
            ArrayList<String> keys = new ArrayList<String>();
            HashMap<String, String> idByKey = new HashMap<String, String>();
            for (String id : ids) {
                Map obj = (Map)linkedItemsById.get(id);
                String localId = (String)obj.get("localId");
                if (PropertyValidator.isValid((Object)localId)) continue;
                String key = (String)obj.get("key");
                idByKey.put(key + "_" + (String)obj.get("session_id"), id);
                keys.add(key);
            }
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{Criteria.where((String)"jiraKey").in(keys), Criteria.where((String)"tfsId").in(keys)}), Criteria.where((String)"sessionBoards.$id").in(activeSessionBoardIds), Criteria.where((String)"_id").nin((Collection)objectIds)}));
            query.fields().include("title").include("key").include("type").include("storyPoints").include("tfsId").include("kendisKey").include("tfsURL").include("status").include("teamContainers").include("jiraId").include("jiraKey").include("jiraURL").include("issueType").include("jiraIssueTypeId").include("tfsItemType").include("tfsItemTypeIcon").include("sessionBoards").include("originItemId").include("duplicateOfId").include("externalReferenceURL").include("status");
            if (!impediment.getType().contains("Objective") && !impediment.getType().equals("KR")) {
                query.fields().include("parent");
            }
            if (PropertyValidator.isValid((Collection)(itemList = this.mongoTemplate.find(query, Item.class)))) {
                for (Item item : itemList) {
                    if (PropertyValidator.isValid((Collection)item.getSessionBoards())) {
                        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
                        for (SessionBoard sb : item.getSessionBoards()) {
                            SessionBoard sessionBoard = new SessionBoard(sb.getId(), sb.getSession());
                            sessionBoards.add(sessionBoard);
                        }
                        item.setSessionBoards(sessionBoards);
                    }
                    if (PropertyValidator.isValid((Object)item.getStatus()) && (impediment.getType().contains("Objective") || impediment.getType().equals("KR"))) {
                        Status status = new Status(item.getStatus().getId(), item.getStatus().getTitle(), item.getStatus().getColor(), item.getStatus().getCategory());
                        item.setStatus(status);
                    }
                    String externalLink = this.getItemLink(item);
                    item.setExternalReferenceURL(externalLink);
                    if (!PropertyValidator.isValid((Collection)item.getSessionBoards())) continue;
                    String sId = ((SessionBoard)item.getSessionBoards().get(0)).getSession().getId();
                    if (PropertyValidator.isValid((Object)item.getJiraId())) {
                        if (idByKey.containsKey(item.getJiraKey() + "_" + sId)) {
                            linkedItemsById.remove(idByKey.get(item.getJiraKey() + "_" + sId));
                        }
                    } else if (PropertyValidator.isValid((Object)item.getTfsId()) && idByKey.containsKey(item.getTfsId() + "_" + sId)) {
                        linkedItemsById.remove(idByKey.get(item.getTfsId() + "_" + sId));
                    }
                    if (externalIds.containsKey(item.getId())) continue;
                    linkedItems.add(item);
                    linkedItemsIds.add(item.getId());
                }
            }
            if (PropertyValidator.isValid(ids = linkedItemsById.keySet())) {
                linkedItemsIds.addAll(ids);
            }
        }
        return linkedItems;
    }

    private String getItemLink(Item item) {
        String externalLink = "";
        if (!PropertyValidator.isValid((Collection)item.getSessionBoards())) {
            return null;
        }
        SessionBoard sessionBoard = (SessionBoard)item.getSessionBoards().get(0);
        Session session = sessionBoard.getSession();
        String referenceBaseUrl = null;
        if (session.getAlmEnabled().booleanValue()) {
            if (PropertyValidator.isValid((Collection)session.getAlmConfigurations())) {
                referenceBaseUrl = PropertyValidator.isValid((Object)((AlmConfigurations)session.getAlmConfigurations().get(0)).getAlmAccount().getJiraAuthRedirectURL()) ? ((AlmConfigurations)session.getAlmConfigurations().get(0)).getAlmAccount().getJiraAuthRedirectURL() + "/browse" : ((AlmConfigurations)session.getAlmConfigurations().get(0)).getAlmAccount().getUrl() + "/browse";
            } else if (PropertyValidator.isValid((Object)session.getTfsAlmConfigurations())) {
                referenceBaseUrl = item.getTfsURL();
            }
        } else {
            referenceBaseUrl = session.getJiraBaseURL() != null ? session.getJiraBaseURL() : "";
        }
        if (item.getJiraKey() != null && item.getJiraId() != null) {
            externalLink = referenceBaseUrl.equals("") ? "javascript:void(0);" : referenceBaseUrl + "/" + item.getJiraKey();
        } else if (item.getJiraKey() != null && item.getExternalReferenceURL() != null) {
            externalLink = item.getExternalReferenceURL();
        } else if (item.getJiraKey() != null) {
            externalLink = referenceBaseUrl.equals("") ? "javascript:void(0);" : referenceBaseUrl + "/" + item.getJiraKey();
        }
        return externalLink;
    }

    public HashMap<String, ? super Object> toSimpleObject(Item item) {
        HashMap<String, String> rowData = new HashMap<String, String>();
        if (PropertyValidator.isValid((Object)item.getJiraId())) {
            rowData.put("jiraId", item.getJiraId());
            rowData.put("jiraKey", item.getJiraKey());
            rowData.put("key", item.getJiraKey());
        }
        if (PropertyValidator.isValid((Object)item.getTfsId())) {
            rowData.put("tfsId", item.getTfsId());
            rowData.put("key", item.getTfsId());
            rowData.put("tfsURL", item.getTfsURL());
        }
        if (!PropertyValidator.isValid((Object)item.getTfsId()) && !PropertyValidator.isValid((Object)item.getJiraId())) {
            if (PropertyValidator.isValid((Object)item.getJiraKey())) {
                rowData.put("key", item.getJiraKey());
            } else if (PropertyValidator.isValid((Object)item.getKendisKey())) {
                rowData.put("key", item.getKendisKey());
            } else {
                rowData.put("key", "");
            }
            rowData.put("localId", item.getId());
        } else if (PropertyValidator.isValid((Object)item.getExternalReferenceURL())) {
            rowData.put("externalReferenceURL", this.getItemLink(item));
        } else {
            rowData.put("externalReferenceURL", item.getExternalReferenceURL());
        }
        if (PropertyValidator.isValid((Collection)item.getSessionBoards()) && PropertyValidator.isValid(item.getSessionBoards().get(0)) && PropertyValidator.isValid((Object)((SessionBoard)item.getSessionBoards().get(0)).getSession())) {
            rowData.put("sessionBoard_id", ((SessionBoard)item.getSessionBoards().get(0)).getId());
            rowData.put("session_id", ((SessionBoard)item.getSessionBoards().get(0)).getSession().getId());
            rowData.put("session_title", ((SessionBoard)item.getSessionBoards().get(0)).getSession().getTitle());
        }
        return rowData;
    }

    private void setFeatureStoryPoints(List<Item> items) throws RuntimeException {
        for (Item item : items) {
            if (!PropertyValidator.isValid((Object)item) || !item.getType().equals("Feature")) continue;
            Double storyPoints = 0.0;
            List childList = this.itemRepository.findByParentId(item.getId());
            for (Item childItem : childList) {
                if (!PropertyValidator.isValid((Object)childItem)) continue;
                storyPoints = storyPoints + childItem.getStoryPoints();
            }
            item.setStoryPoints(storyPoints);
        }
    }

    @Deprecated
    private List<Session> fetchWorkspaceSessions() {
        User user = UserContextUtil.getUserContext().getLoggedInUser();
        List<Object> piBoards = new ArrayList<Session>();
        HashSet workSpaces = new HashSet();
        List<WorkSpaceAccessRole> workSpaceAccessRoles = new ArrayList();
        if (PropertyValidator.isValid((Object)user) && (user.getIsAdmin().booleanValue() || user.getIsSuperAdmin().booleanValue())) {
            workSpaces = Sets.newHashSet((Iterable)this.workSpaceRepository.findByIsModuleIsFalseOrIsModuleIsNull());
            LOGGER.debug("Workspaces  fetched :: " + workSpaces.size());
            for (WorkSpace workSpace : workSpaces) {
                WorkSpaceAccessRole accessRole = new WorkSpaceAccessRole();
                accessRole.setWorkSpace(workSpace);
                accessRole.setUser(user);
                workSpaceAccessRoles.add(accessRole);
            }
        } else {
            workSpaceAccessRoles = this.customRepository.findWorkspaceAccessRoles(user);
            for (WorkSpaceAccessRole workSpaceAccessRole : workSpaceAccessRoles) {
                if (!PropertyValidator.isValid((Object)workSpaceAccessRole.getWorkSpace())) continue;
                workSpaces.add(workSpaceAccessRole.getWorkSpace());
            }
        }
        if (PropertyValidator.isValid((Collection)workSpaces)) {
            piBoards = this.sessionRepository.findByWorkSpaceIn(new ArrayList(workSpaces));
        }
        return piBoards;
    }

    private ResponseEntity<Object> onNotAllowed(String msg) {
        HashMap<String, String> responseJson = new HashMap<String, String>();
        responseJson.put("rightsError", msg);
        return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
    }

    private void moveImpediments(Date now, User user, List<Scrum> scrums, String newSoSId, String oldSoSId) {
        if (PropertyValidator.isValid(scrums)) {
            HashMap<String, String> oldScrumId = new HashMap<String, String>();
            for (Scrum scrum : scrums) {
                oldScrumId.put(scrum.getDuplicateOfId(), scrum.getId());
            }
            boolean itemsUpdated = false;
            Query query = new Query();
            ArrayList<String> types = new ArrayList<String>();
            ArrayList<ObjectId> linkIds = new ArrayList<ObjectId>();
            ArrayList<Object> linksToSave = new ArrayList<Object>();
            HashMap<String, Integer> linksMap = new HashMap<String, Integer>();
            List oldLinks = this.baseItemLinkRepository.findByScrumOfScrumId(oldSoSId);
            for (int i = 0; i < oldLinks.size(); ++i) {
                linkIds.add(new ObjectId(((BaseItemLink)oldLinks.get(i)).getId()));
                linksMap.put(((BaseItemLink)oldLinks.get(i)).getId(), i);
            }
            types.add(WorkFlow.WorkFlowType.Impediment.name());
            types.add(WorkFlow.WorkFlowType.ActionPoint.name());
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"baseItemLinks.$id").in(linkIds));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").in(types));
            List impediments = this.mongoTemplate.find(query, BaseItem.class);
            for (BaseItem impediment : impediments) {
                List links;
                if (impediment.getStatus().getCategory().equals(EnumStatusCategory.DONE.getCode()) || !PropertyValidator.isValid((Collection)(links = impediment.getBaseItemLinks()))) continue;
                int size = links.size();
                for (int i = 0; i < size; ++i) {
                    BaseItemLink link;
                    Integer index;
                    if (!linksMap.containsKey(((BaseItemLink)links.get(i)).getId()) || (index = (Integer)linksMap.get(((BaseItemLink)links.get(i)).getId())) <= -1 || oldLinks.size() <= index || PropertyValidator.isValid((Object)(link = ((BaseItemLink)oldLinks.get(index)).copy()).getIsSystemLink())) continue;
                    link.setCreatedOn(now);
                    link.setCreatedBy(user.getUserName());
                    link.setScrumOfScrumId(newSoSId);
                    linksToSave.add(link);
                    linksToSave.add(oldLinks.get(index));
                    impediment.getBaseItemLinks().add(link);
                    itemsUpdated = true;
                }
            }
            if (itemsUpdated) {
                this.baseItemLinkRepository.save(linksToSave);
                this.baseItemRepository.save((Iterable)impediments);
            }
            this.scrumRepository.save(scrums);
        }
    }

    @RequestMapping(value={"/check-sos/configured/{sessionId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> checkSosConfigured(@PathVariable(value="sessionId") String sessionId) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        if (!PropertyValidator.isValid((Object)sessionId)) {
            responseJson.put("sosStatus", false);
            return new ResponseEntity((Object)"Invalid Session Id", HttpStatus.BAD_REQUEST);
        }
        ScrumOfScrums ofScrums = this.sosRepository.findScrumOfScrumBySessionId(sessionId);
        if (ofScrums == null) {
            responseJson.put("sosStatus", false);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        responseJson.put("sosStatus", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PreDestroy
    private void shutdownExecutorAfterCompletion() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

