/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.entity.ALMFilter;
import com.viztrend.safe.alm.jira.TFSResponse;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.alm.jira.bo.JiraFilter;
import com.viztrend.safe.alm.jira.bo.JiraIssue;
import com.viztrend.safe.alm.tfs.TFSFilter;
import com.viztrend.safe.alm.tfs.TFSMeta;
import com.viztrend.safe.alm.tfs.TFSProject;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.controller.SolutionController;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.BacklogMappingLinks;
import com.viztrend.safe.persistence.entity.EpicFeature;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.ScoreCard;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.SolutionAlmSettings;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.entity.SolutionBoardWsjFAlmConfiguration;
import com.viztrend.safe.persistence.entity.State;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkFlowItemType;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.WorkSpaceAccessRole;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.ALMFilterRepository;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.EpicFeaturesRepository;
import com.viztrend.safe.persistence.repository.FieldTemplateRepository;
import com.viztrend.safe.persistence.repository.FieldsRepository;
import com.viztrend.safe.persistence.repository.ItemJiraDependencyRepository;
import com.viztrend.safe.persistence.repository.ItemLinkRepository;
import com.viztrend.safe.persistence.repository.ItemLinkTypeRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.ScoreCardRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.SolutionBoardRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TFSProjectRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WorkFlowItemTypeRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceAccessRoleRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.ALMSyncService;
import com.viztrend.safe.service.ExportService;
import com.viztrend.safe.service.ReleaseTrainService;
import com.viztrend.safe.service.SolutionService;
import com.viztrend.safe.service.TFSservice;
import com.viztrend.safe.strategy.PushInclusionStrategy;
import com.viztrend.safe.utils.AlmUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.bson.types.ObjectId;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/solution"})
@RestController
public class SolutionController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolutionController.class);
    @Autowired
    private ExportService exportService;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private SolutionService solutionService;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private WorkFlowRepository workFlowRepository;
    @Autowired
    private ItemLinkRepository itemLinkRepository;
    @Autowired
    private AppConfig.MongoConfig mongoConfig;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private WorkSpaceAccessRoleRepository accessRoleRepository;
    @Autowired
    private SolutionBoardRepository solutionBoardRepository;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private ALMFilterRepository almFilterRepository;
    @Autowired
    private TFSUtils tfsUtils;
    @Autowired
    private TFSservice tfSservice;
    @Autowired
    private ALMSyncService almSyncService;
    @Autowired
    private TFSProjectRepository tfsProjectRepository;
    @Autowired
    private WorkFlowItemTypeRepository workFlowItemTypeRepository;
    @Autowired
    private PushResponseRepository pushResponseRepository;
    @Autowired
    private EpicFeaturesRepository epicFeaturesRepository;
    @Autowired
    private ScoreCardRepository scoreCardRepository;
    @Autowired
    private FieldTemplateRepository fieldTemplateRepository;
    @Autowired
    private FieldsRepository fieldsRepository;
    @Autowired
    private ReleaseTrainService releaseTrainService;
    @Autowired
    private CustomRepository customRepository;
    @Autowired
    private ItemLinkTypeRepository itemLinkTypeRepository;
    @Autowired
    private ItemJiraDependencyRepository itemJiraDependencyRepository;
    @Autowired
    private CustomRepositoryImpl customRepositoryImpl;
    @Autowired
    MongoTemplate mongoTemplate;

    @RequestMapping(value={"/enableDisableAlmDependency"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> enableDisableAlmDependency(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, String> responseJson = new HashMap<String, String>();
        Boolean enable = (Boolean)payload.get("enable");
        String almAccountId = (String)payload.get("almAccountId");
        String solutionId = (String)payload.get("solutionId");
        SolutionBoard solutionBoard = (SolutionBoard)this.solutionBoardRepository.findOne((Serializable)((Object)solutionId));
        ArrayList<SolutionAlmSettings> solutionAlmSettings = solutionBoard.getSolutionAlmSettings();
        if (!PropertyValidator.isValid((Collection)solutionAlmSettings)) {
            solutionAlmSettings = new ArrayList<SolutionAlmSettings>();
            solutionBoard.setSolutionAlmSettings(solutionAlmSettings);
        }
        SolutionAlmSettings solutionAlmSetting = null;
        for (SolutionAlmSettings settings : solutionAlmSettings) {
            if (!settings.getAlmAccountId().equals(almAccountId)) continue;
            solutionAlmSetting = settings;
            break;
        }
        if (solutionAlmSetting == null) {
            solutionAlmSetting = new SolutionAlmSettings(solutionId, almAccountId);
            solutionAlmSettings.add(solutionAlmSetting);
        }
        if (enable != null) {
            if (enable.booleanValue()) {
                solutionAlmSetting.setDependencyEnabled(Boolean.TRUE);
                ArrayList linkTypes = (ArrayList)payload.get("linkTypes");
                solutionAlmSetting.setLinkTypes((List)linkTypes);
            } else {
                solutionAlmSetting.setLinkTypes(null);
                solutionAlmSetting.setDependencyEnabled(Boolean.FALSE);
            }
        }
        this.solutionBoardRepository.save((Object)solutionBoard);
        responseJson.put("status", "success");
        responseJson.put("solutionAlmSettings", (String)solutionAlmSetting);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/updateDepedenceArrow"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateDepedenceArrow(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, String> responseJson = new HashMap<String, String>();
        String solutionId = (String)payload.get("solutionId");
        String lineArrowDirection = (String)payload.get("lineArrowDirection");
        SolutionBoard solutionBoard = this.solutionBoardRepository.findById(solutionId);
        solutionBoard.setLineArrowDirection(lineArrowDirection);
        this.solutionBoardRepository.save((Object)solutionBoard);
        responseJson.put("status", "success");
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/searchSolutionBoards"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> searchSolutionBoards(@RequestBody HashMap<String, Object> payload) {
        HashMap responseJson = new HashMap();
        try {
            String search = (String)payload.get("search");
            responseJson = this.solutionService.searchSolutionBoards(search);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/getArchivedSolutionBoards"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getArchivedSolutionBoards() {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.solutionService.getArchivedSolutionBoards();
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/filters/{almAccountId}"})
    @ResponseBody
    public ResponseEntity<Object> getFilters(@PathVariable(value="almAccId") String almAccId, HttpServletRequest request) {
        try {
            AlmAccount almAcc = AlmUtils.getALMAcount((String)almAccId, (AlmAccountRepository)this.almAccountRepository);
            HashMap responseJson = new HashMap();
            if (PropertyValidator.isValid((Object)almAcc)) {
                Map filtersMap = this.almSyncService.retrieveJiraFilterList(almAcc);
                responseJson.put("filters", filtersMap.get("filters"));
                responseJson.put("favourite", filtersMap.get("favourite"));
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/tfsAlmMeta/{almId}"})
    @ResponseBody
    public ResponseEntity<Object> getAlmMeta(@PathVariable String almId) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId));
        HashMap linkTypesResult = this.tfSservice.retrieveJiraIssueLinkTypesList(almAccount, false);
        if (PropertyValidator.isValid(linkTypesResult.get("tfsALMErrorCode"))) {
            responseJson.put("success", false);
            responseJson.put("tfsALMErrorCode", (Boolean)linkTypesResult.get("tfsALMErrorCode"));
            responseJson.put("tfsALMErrorMessage", (Boolean)linkTypesResult.get("tfsALMErrorMessage"));
        } else {
            TFSMeta tfsMeta = new TFSMeta();
            tfsMeta.setLinkTypes((String)linkTypesResult.get("linkTypes"));
            responseJson.put("tfsMeta", (Boolean)tfsMeta);
            responseJson.put("success", true);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/tfsqueries/{almId}/{pid}"})
    @ResponseBody
    public ResponseEntity<Object> getTFSQueries(@PathVariable String almId, @PathVariable String pid) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId));
            responseJson.put("queries", this.tfsUtils.getProjectQueries(pid, "all", "1", almAccount));
        }
        catch (ViztrendJiraException vJe) {
            responseJson.put("success", false);
            responseJson.put("error", vJe.getAlmError());
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap<String, Object> getTfsQueryDetails(String pid, String qid, String isquery, AlmAccount almAccount) throws JSONException {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String responseStr = "";
        if (isquery.equals("true")) {
            TFSResponse tfsResponse = this.tfsUtils.getWorkItemsByTFSQueryString(qid, almAccount, false);
            if (!PropertyValidator.isValid((Object)tfsResponse)) {
                responseJson.put("status", "failure");
                responseJson.put("reason", "Invalid WIQL");
                return responseJson;
            }
            responseStr = tfsResponse.getContent();
        } else {
            responseStr = this.tfsUtils.getWorkItemsByTFSQueryId(pid, qid, almAccount);
        }
        JSONObject responseObj = new JSONObject(responseStr);
        String queryType = responseObj.getString("queryType");
        ArrayList<String> itemIds = new ArrayList<String>();
        ArrayList<String> relations = new ArrayList<String>();
        if (queryType.equals("flat")) {
            JSONArray workItemsArray = responseObj.getJSONArray("workItems");
            for (int i = 0; i < workItemsArray.length(); ++i) {
                JSONObject wiObject = workItemsArray.getJSONObject(i);
                String itemId = wiObject.getString("id");
                itemIds.add(itemId);
            }
        } else {
            JSONObject responseObject = new JSONObject();
            JSONArray workItemsArray = new JSONArray();
            JSONArray workItemsRelationsArray = responseObj.getJSONArray("workItemRelations");
            ArrayList<String> subItemIds = new ArrayList<String>();
            for (int i = 0; i < workItemsRelationsArray.length(); ++i) {
                JSONObject wirObject = workItemsRelationsArray.getJSONObject(i);
                Object sourceObject = null;
                JSONObject targetObject = null;
                String relation = null;
                if (wirObject.isNull("source") && !wirObject.isNull("target")) {
                    targetObject = wirObject.getJSONObject("target");
                }
                if (!wirObject.isNull("rel")) {
                    relation = wirObject.getString("rel");
                }
                if (PropertyValidator.isValid(targetObject)) {
                    JSONObject workItemObject = new JSONObject();
                    String itemId = targetObject.getString("id");
                    String itemURL = targetObject.getString("url");
                    itemIds.add(itemId);
                    workItemObject.put("id", (Object)itemId);
                    workItemObject.put("url", (Object)itemURL);
                    workItemsArray.put((Object)workItemObject);
                }
                if (PropertyValidator.isValid((Object)targetObject)) {
                    String itemId = targetObject.getString("id");
                    subItemIds.add(itemId);
                }
                if (!PropertyValidator.isValid((Object)relation)) continue;
                relations.add(relation);
            }
            responseObject.put("workItems", (Object)workItemsArray);
            responseObject.put("queryType", (Object)responseObj.getString("queryType"));
            responseStr = responseObject.toString();
        }
        String tfsProjectStr = this.tfsUtils.getTFSProjectsByPage(almAccount);
        HashMap<String, String> projectsMap = new HashMap<String, String>();
        if (PropertyValidator.isValid((Object)tfsProjectStr)) {
            JSONObject dataObjects = new JSONObject(tfsProjectStr);
            String count = dataObjects.getString("count");
            JSONArray projectsArray = dataObjects.getJSONArray("value");
            for (int i = 0; i < projectsArray.length(); ++i) {
                JSONObject projectObject = projectsArray.getJSONObject(i);
                String projectId = projectObject.getString("id");
                String projectName = projectObject.getString("name");
                projectsMap.put(projectName, projectId);
            }
        }
        List subSetIds = Lists.partition(new ArrayList(itemIds), (int)100);
        HashSet projects = new HashSet();
        HashMap projectsMapResponse = new HashMap();
        for (List subItemIds : subSetIds) {
            String idsItemStr = String.join((CharSequence)",", subItemIds);
            String itemsStr = this.tfsUtils.getItems("1", idsItemStr, almAccount);
            try {
                JSONObject dataObjects = new JSONObject(itemsStr);
                JSONArray itemsArray = dataObjects.getJSONArray("value");
                for (int i = 0; i < itemsArray.length(); ++i) {
                    JSONObject itemObject = itemsArray.getJSONObject(i);
                    JSONObject tfsFields = itemObject.getJSONObject("fields");
                    String areaPath = tfsFields.getString("System.AreaLevel1");
                    projectsMapResponse.put(areaPath, projectsMap.get(areaPath));
                }
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
        }
        Iterator<Object> iterator = projectsMapResponse.keySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                responseJson.put("status", "success");
                responseJson.put("items", responseStr);
                responseJson.put("projects", projects);
                responseJson.put("relations", relations);
                return responseJson;
            }
            String projectName = (String)iterator.next();
            HashMap project = new HashMap();
            project.put("id", projectsMapResponse.get(projectName));
            project.put("name", projectName);
            projects.add(project);
        }
    }

    @RequestMapping(value={"/tfsquery"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getTFSQueryResults(@RequestBody HashMap<String, Object> payload) {
        HashMap responseJson = new HashMap();
        try {
            String almId = (String)payload.get("almId");
            String pid = (String)payload.get("pid");
            String qid = (String)payload.get("qid");
            String isquery = (String)payload.get("isquery");
            AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId));
            responseJson = this.getTfsQueryDetails(pid, qid, isquery, almAccount);
        }
        catch (ViztrendJiraException vJe) {
            responseJson.put("status", "failure");
            responseJson.put("reason", "Invalid response from server");
            responseJson.put("error", vJe.getAlmError());
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/fetchTFSFilterItems"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchTFSFilterItems(@RequestBody HashMap<String, Object> reqbody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String almAccountId = null;
        String filterStr = (String)reqbody.get("filter");
        String sessionBoardId = (String)reqbody.get("sessionBoardId");
        String shouldSave = (String)reqbody.get("shouldSave");
        List loadedProjects = (List)reqbody.get("loadProjects");
        String metaMap = (String)reqbody.get("metaMap");
        ObjectMapper mapper = new ObjectMapper();
        TFSFilter filter = null;
        try {
            filter = (TFSFilter)mapper.readValue(filterStr, TFSFilter.class);
        }
        catch (JsonParseException jsonParseException) {
        }
        catch (JsonMappingException jsonMappingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ArrayList<String> tfsIds = new ArrayList<String>();
        almAccountId = (String)reqbody.get("almAccountId");
        AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
        if (PropertyValidator.isValid((Object)shouldSave) && PropertyValidator.isValid((Object)filter)) {
            filter.setFilterFetchedBy(this.tfsUtils.getProfileAlmUser(almAccount));
            ALMFilter almFilter = new ALMFilter();
            almFilter.setTfsFilter(filter);
            almFilter.setAlmAccount(new AlmAccount(almAccountId));
            almFilter = (ALMFilter)this.almFilterRepository.save((Object)almFilter);
        }
        if (PropertyValidator.isValid((Object)filter.getFilterFetchedBy())) {
            AlmAccount taggedAlmAccount = TFSUtils.getTaggedAlmUser((User)filter.getFilterFetchedBy(), (AlmAccount)almAccount);
            if (PropertyValidator.isValid((Object)taggedAlmAccount)) {
                almAccount = taggedAlmAccount;
            }
        } else {
            almAccount.setIsTaggedUser(Boolean.valueOf(true));
        }
        Boolean success = false;
        try {
            if (filter != null) {
                String tfsItemIdsStr;
                if (PropertyValidator.isValid((Object)filter.getIsWiql()) && filter.getIsWiql() == Boolean.TRUE) {
                    String queryStr = "{query:\"" + filter.getQueryJSON() + "\"}";
                    TFSResponse tfsResponse = this.tfsUtils.getWorkItemsByTFSQueryString(queryStr, almAccount, false);
                    tfsItemIdsStr = tfsResponse.getContent();
                } else {
                    tfsItemIdsStr = this.tfsUtils.getWorkItemsByTFSQueryId(filter.getTfsProjectId(), filter.getTfsId(), almAccount);
                }
                try {
                    JSONArray workItemsArray;
                    JSONObject jsonObject = new JSONObject(tfsItemIdsStr);
                    String queryType = jsonObject.getString("queryType");
                    ArrayList<String> relations = new ArrayList<String>();
                    if (queryType.equals("flat")) {
                        workItemsArray = jsonObject.getJSONArray("workItems");
                        for (int i = 0; i < workItemsArray.length(); ++i) {
                            JSONObject wiObject = workItemsArray.getJSONObject(i);
                            String itemId = wiObject.getString("id");
                            tfsIds.add(itemId);
                        }
                    } else {
                        workItemsArray = new JSONArray();
                        JSONArray workItemsRelationsArray = jsonObject.getJSONArray("workItemRelations");
                        ArrayList<String> subItemIds = new ArrayList<String>();
                        for (int i = 0; i < workItemsRelationsArray.length(); ++i) {
                            JSONObject wirObject = workItemsRelationsArray.getJSONObject(i);
                            Object sourceObject = null;
                            JSONObject targetObject = null;
                            String relation = null;
                            if (wirObject.isNull("source") && !wirObject.isNull("target")) {
                                targetObject = wirObject.getJSONObject("target");
                            }
                            if (!wirObject.isNull("rel")) {
                                relation = wirObject.getString("rel");
                            }
                            if (PropertyValidator.isValid(targetObject)) {
                                JSONObject workItemObject = new JSONObject();
                                String itemId = targetObject.getString("id");
                                String itemURL = targetObject.getString("url");
                                tfsIds.add(itemId);
                                workItemObject.put("id", (Object)itemId);
                                workItemObject.put("url", (Object)itemURL);
                                workItemsArray.put((Object)workItemObject);
                            }
                            if (PropertyValidator.isValid((Object)targetObject)) {
                                String itemId = targetObject.getString("id");
                                subItemIds.add(itemId);
                            }
                            if (!PropertyValidator.isValid((Object)relation)) continue;
                            relations.add(relation);
                        }
                    }
                    String tfsProjectStr = this.tfsUtils.getTFSProjectsByPage(almAccount);
                    HashMap<String, String> projectsMap = new HashMap<String, String>();
                    if (PropertyValidator.isValid((Object)tfsProjectStr)) {
                        JSONObject dataObjects = new JSONObject(tfsProjectStr);
                        JSONArray projectsArray = dataObjects.getJSONArray("value");
                        for (int i = 0; i < projectsArray.length(); ++i) {
                            JSONObject projectObject = projectsArray.getJSONObject(i);
                            String projectId = projectObject.getString("id");
                            String projectName = projectObject.getString("name");
                            projectsMap.put(projectName, projectId);
                        }
                    }
                    List subSetIds = Lists.partition(new ArrayList(tfsIds), (int)100);
                    HashMap projectsMapResponse = new HashMap();
                    for (List subItemIds : subSetIds) {
                        String idsItemStr = String.join((CharSequence)",", subItemIds);
                        String itemsStr = this.tfsUtils.getItems("1", idsItemStr, almAccount);
                        try {
                            JSONObject dataObjects = new JSONObject(itemsStr);
                            JSONArray itemsArray = dataObjects.getJSONArray("value");
                            for (int i = 0; i < itemsArray.length(); ++i) {
                                JSONObject itemObject = itemsArray.getJSONObject(i);
                                JSONObject tfsFields = itemObject.getJSONObject("fields");
                                String areaPath = tfsFields.getString("System.AreaLevel1");
                                projectsMapResponse.put(areaPath, projectsMap.get(areaPath));
                            }
                        }
                        catch (JSONException e1) {
                            e1.printStackTrace();
                        }
                    }
                    ArrayList projectsNeedToBeLoaded = new ArrayList();
                    for (String projectName : projectsMapResponse.keySet()) {
                        HashMap<String, String> project = new HashMap<String, String>();
                        String pid = (String)projectsMapResponse.get(projectName);
                        if (loadedProjects.contains(pid)) continue;
                        project.put("id", pid);
                        project.put("name", projectName);
                        projectsNeedToBeLoaded.add(project);
                    }
                    if (projectsNeedToBeLoaded.size() > 0) {
                        responseJson.put("reason", "projectsNotLoaded");
                        responseJson.put("projects", projectsNeedToBeLoaded);
                    } else {
                        success = true;
                        responseJson.put("success", true);
                    }
                }
                catch (JSONException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
            if (success.booleanValue()) {
                JSONObject pushJson = new JSONObject();
                pushJson.put("isTFS", true);
                pushJson.put("metaMap", (Object)metaMap);
                PushSender.sendMsg((String)pushJson.toString());
            }
            responseJson.put("success", success);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (ViztrendJiraException vJe) {
            responseJson.put("success", false);
            responseJson.put("error", vJe.getAlmError());
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        catch (JSONException e) {
            responseJson.put("success", false);
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/filter/{filterId}"})
    @ResponseBody
    public ResponseEntity<Object> getFilterData(@PathVariable(value="filterId") String almAccId, HttpServletRequest request) {
        try {
            HashMap responseJson = new HashMap();
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/getAllAccessibleBoards"})
    @ResponseBody
    public ResponseEntity<Object> getAllAccessibleBoards() {
        try {
            HashMap responseJson = new HashMap();
            responseJson = this.solutionService.getAllAccessibleBoards(null);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/boards"})
    @ResponseBody
    public ResponseEntity<Object> getBoards(@RequestBody Map<String, Object> requestBody) {
        String requestId = (String)requestBody.get("requestId");
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User currentUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            List solutionBoards = new ArrayList();
            List piBoards = null;
            ArrayList<Session> activePiBoards = new ArrayList<Session>();
            HashSet workSpaces = new HashSet();
            ArrayList<WorkSpaceAccessRole> workSpaceAccessRoles = new ArrayList<WorkSpaceAccessRole>();
            if (PropertyValidator.isValid((Object)currentUser) && (currentUser.getIsAdmin().booleanValue() || currentUser.getIsSuperAdmin().booleanValue())) {
                workSpaces = Sets.newHashSet((Iterable)this.workSpaceRepository.findAll());
                for (WorkSpace workSpace : workSpaces) {
                    WorkSpaceAccessRole accessRole = new WorkSpaceAccessRole();
                    accessRole.setWorkSpace(workSpace);
                    accessRole.setUser(currentUser);
                    workSpaceAccessRoles.add(accessRole);
                }
            } else {
                Query query = new Query();
                List groupIds = currentUser.getGroups().stream().map(ObjectId::new).collect(Collectors.toList());
                Criteria criteria = new Criteria();
                criteria.orOperator(new Criteria[]{Criteria.where((String)"user.$id").is((Object)new ObjectId(currentUser.getId())), Criteria.where((String)"group.$id").in(groupIds)});
                query.addCriteria((CriteriaDefinition)criteria);
                DBCursor dbCursorPrefix = this.customRepository.getMongoTemplate().getCollection("workSpaceAccessRole").find(query.getQueryObject());
                List accessRoles = dbCursorPrefix.toArray();
                if (PropertyValidator.isValid((Collection)accessRoles)) {
                    ArrayList<String> workSpaceIds = new ArrayList<String>();
                    for (DBObject workSpaceAccessRole : accessRoles) {
                        DBRef workSpaceRef = (DBRef)workSpaceAccessRole.get("workSpace");
                        if (!PropertyValidator.isValid((Object)workSpaceRef) || !PropertyValidator.isValid((Object)workSpaceRef.getId())) continue;
                        workSpaceIds.add(String.valueOf(workSpaceRef.getId()));
                    }
                    if (!workSpaceIds.isEmpty()) {
                        workSpaces = Sets.newHashSet((Iterable)this.workSpaceRepository.findByIdIn(workSpaceIds));
                    }
                }
            }
            if (PropertyValidator.isValid((Collection)workSpaces)) {
                piBoards = this.sessionRepository.findSessionsByWorkSpaceIn(new ArrayList(workSpaces));
                if (PropertyValidator.isValid((Collection)piBoards)) {
                    for (Session piBoard : piBoards) {
                        if (piBoard.getRowStatus() != 0) continue;
                        activePiBoards.add(piBoard);
                        WorkSpace tempWorkspace = new WorkSpace();
                        tempWorkspace.setId(piBoard.getWorkSpace().getId());
                        piBoard.setWorkSpace(tempWorkspace);
                    }
                }
                solutionBoards = this.solutionBoardRepository.findAll();
            }
            List almAccount = this.almSyncService.fetchJiraAccount(true);
            List usersAll = this.userRepository.findUsersByUserCompanies_Company_IdAndUserCompanies_isArchive(UserContextUtil.getUserContext().getCurrentCompany().getId(), Boolean.valueOf(false));
            responseJson.put("solutionBoards", solutionBoards);
            responseJson.put("piBoards", activePiBoards);
            responseJson.put("almAccounts", almAccount);
            responseJson.put("users", usersAll);
            responseJson.put("success", true);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            responseJson.put("success", false);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/starredBoards"})
    @ResponseBody
    public ResponseEntity<Object> getStarredBoards() {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.solutionService.getStarredBoards();
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/starABoard"})
    @ResponseBody
    public ResponseEntity<Object> starABoard(@RequestBody Map<String, Object> requestBody) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.solutionService.starABoard(requestBody);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/tfsAlmMeta1/{solutionId}"})
    @ResponseBody
    public ResponseEntity<Object> getAlmMeta1(@PathVariable String solutionId) {
        HashMap responseJson = new HashMap();
        SolutionBoard solutionBoard = this.solutionBoardRepository.findById(solutionId);
        List sessions = this.sessionRepository.findByIdIn((List)solutionBoard.getPiSessions());
        ArrayList linkTypesArray = new ArrayList();
        if (PropertyValidator.isValid((Collection)sessions)) {
            for (Session session : sessions) {
                AlmAccount almAccount = null;
                if (PropertyValidator.isValid((Collection)session.getAlmConfigurations())) {
                    almAccount = ((AlmConfigurations)session.getAlmConfigurations().get(0)).getAlmAccount();
                    continue;
                }
                if (!PropertyValidator.isValid((Object)session.getTfsAlmConfigurations())) continue;
                almAccount = session.getTfsAlmConfigurations().getAlmAccount();
                HashMap linkTypesResult = this.tfSservice.retrieveJiraIssueLinkTypesList(almAccount, false);
                String linkTypes = (String)linkTypesResult.get("linkTypes");
                HashMap<String, Object> linkType = new HashMap<String, Object>();
                linkType.put("alm", almAccount);
                linkType.put("linkTypes", linkTypes);
                linkType.put("session", session);
                linkTypesArray.add(linkType);
            }
        }
        responseJson.put("linkTypes", linkTypesArray);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/pi-boards-states"})
    @ResponseBody
    public ResponseEntity<Object> getPiBoardsStates(@RequestBody Map<String, Object> requestBody) {
        List activeSessionBoards;
        List sessionIds = (List)requestBody.get("sessionIds");
        List piBoards = this.sessionRepository.findByIdIn(sessionIds);
        ArrayList<String> sessionBoardIds = new ArrayList<String>();
        if (PropertyValidator.isValid((Collection)piBoards)) {
            for (Session piBoard : piBoards) {
                if (piBoard.getRowStatus() != 0) continue;
                sessionBoardIds.add(piBoard.getActiveSessionBoard());
            }
        }
        if (PropertyValidator.isValid((Collection)(activeSessionBoards = this.sessionBoardRepository.findByIdIn(sessionBoardIds)))) {
            HashMap activeSessionBoardsMap = new HashMap();
            activeSessionBoards.forEach(sb -> activeSessionBoardsMap.put(sb.getId(), sb));
            for (Session piBoard : piBoards) {
                SessionBoard activeSessionBoard = (SessionBoard)activeSessionBoardsMap.get(piBoard.getActiveSessionBoard());
                if (!PropertyValidator.isValid((Object)activeSessionBoard)) continue;
                State state = activeSessionBoard.getState();
                State stateMin = new State();
                stateMin.setId(state.getId());
                stateMin.setTitle(state.getTitle());
                piBoard.setActiveState(stateMin);
            }
        }
        HashMap<String, List> responseJson = new HashMap<String, List>();
        responseJson.put("piBoards", piBoards);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/board/{id}"})
    @ResponseBody
    public ResponseEntity<Object> getBoard(@PathVariable(value="id") String id) {
        SolutionBoard board = (SolutionBoard)this.solutionBoardRepository.findOne((Serializable)((Object)id));
        HashMap<String, List> responseJson = new HashMap<String, List>();
        if (PropertyValidator.isValid((Object)board) && PropertyValidator.isValid((Collection)board.getPiSessions())) {
            HashMap<String, Object> linkType;
            Object linkTypes;
            ArrayList sessionBoardIds = new ArrayList();
            List sessions = this.sessionRepository.findByIdIn((List)board.getPiSessions());
            HashMap validSessions = new HashMap();
            sessions.forEach(session -> {
                validSessions.put(session.getId(), session.getId());
                sessionBoardIds.add(session.getActiveSessionBoard());
            });
            List sessionBoards = this.sessionBoardRepository.findByIdIn(sessionBoardIds);
            if (PropertyValidator.isValid((Collection)sessionBoards)) {
                for (SessionBoard sessionBoard : sessionBoards) {
                    boolean addWorkflow = false;
                    if (!PropertyValidator.isValid((Object)sessionBoard.getSession().getDependencyWorkFlow())) {
                        List workFlowList = this.workFlowRepository.findAllByWorkflowType("Dependency");
                        if (PropertyValidator.isValid((Collection)workFlowList)) {
                            sessionBoard.getSession().setDependencyWorkFlow((WorkFlow)workFlowList.get(0));
                        } else {
                            sessionBoard.getSession().setDependencyWorkFlow(this.tfSservice.createDefaultDependencyWorkflow());
                        }
                        addWorkflow = true;
                    }
                    if (addWorkflow) {
                        this.sessionRepository.save((Object)sessionBoard.getSession());
                    }
                    List dependencyStatuses = this.statusRepository.findByWorkFlow(sessionBoard.getSession().getDependencyWorkFlow());
                    WorkFlow workFlow = sessionBoard.getSession().getDependencyWorkFlow();
                    ArrayList sortedStatuses = new ArrayList();
                    HashMap<String, Status> sortedStatusesMap = new HashMap<String, Status>();
                    if (PropertyValidator.isValid((Object)workFlow.getStatusSequence())) {
                        String[] sortedStatusIds = workFlow.getStatusSequence().split(",");
                        String[] stringArray = dependencyStatuses.iterator();
                        while (stringArray.hasNext()) {
                            Status status = (Status)stringArray.next();
                            sortedStatusesMap.put(status.getId(), status);
                        }
                        for (String statusId : sortedStatusIds) {
                            sortedStatuses.add(sortedStatusesMap.get(statusId));
                        }
                        sessionBoard.getSession().getDependencyWorkFlow().setStatuses(sortedStatuses);
                        continue;
                    }
                    sessionBoard.getSession().getDependencyWorkFlow().setStatuses(dependencyStatuses);
                }
            }
            board.setPiSessionBoards(new ArrayList());
            board.getPiSessionBoards().addAll(sessionBoards);
            ArrayList piBoardAlmLinkTypes = new ArrayList();
            ArrayList<HashMap> selectedTfsCustomFields = new ArrayList<HashMap>();
            HashMap<String, String> duplicationCheckMap = new HashMap<String, String>();
            for (Object sessionBoard : board.getPiSessionBoards()) {
                AlmAccount almAccount;
                List tfsProjects;
                if (PropertyValidator.isValid((Object)sessionBoard.getSession().getDependencyWorkFlow())) {
                    List dependencyStatuses = this.statusRepository.findByWorkFlow(sessionBoard.getSession().getDependencyWorkFlow());
                    WorkFlow workFlow = sessionBoard.getSession().getDependencyWorkFlow();
                    ArrayList sortedStatuses = new ArrayList();
                    HashMap sortedStatusesMap = new HashMap();
                    if (PropertyValidator.isValid((Object)workFlow.getStatusSequence())) {
                        String[] sortedStatusIds = workFlow.getStatusSequence().split(",");
                        for (Status status : dependencyStatuses) {
                            sortedStatusesMap.put(status.getId(), status);
                        }
                        for (String statusId : sortedStatusIds) {
                            sortedStatuses.add(sortedStatusesMap.get(statusId));
                        }
                        sessionBoard.getSession().getDependencyWorkFlow().setStatuses(sortedStatuses);
                    } else {
                        sessionBoard.getSession().getDependencyWorkFlow().setStatuses(dependencyStatuses);
                    }
                }
                if (PropertyValidator.isValid((Object)sessionBoard.getSession().getTfsAlmConfigurations()) && PropertyValidator.isValid((Collection)(tfsProjects = this.tfsProjectRepository.findProjectBySessionId(sessionBoard.getSession().getId())))) {
                    for (TFSProject tfsProject : tfsProjects) {
                        if (!PropertyValidator.isValid((Collection)tfsProject.getSelectedFields())) continue;
                        for (HashMap tfsFeild : tfsProject.getSelectedFields()) {
                            String referenceName = (String)tfsFeild.get("referenceName");
                            if (duplicationCheckMap.containsKey(referenceName)) continue;
                            duplicationCheckMap.put(referenceName, referenceName);
                            selectedTfsCustomFields.add(tfsFeild);
                        }
                    }
                }
                if (PropertyValidator.isValid((Object)sessionBoard.getSession().getTfsAlmConfigurations())) {
                    almAccount = sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount();
                    HashMap linkTypesResult = this.tfSservice.retrieveJiraIssueLinkTypesList(almAccount, false);
                    linkTypes = (String)linkTypesResult.get("linkTypes");
                    linkType = new HashMap<String, Object>();
                    linkType.put("alm", almAccount);
                    linkType.put("sessionBoardId", sessionBoard.getId());
                    linkType.put("linkTypes", linkTypes);
                    piBoardAlmLinkTypes.add(linkType);
                    continue;
                }
                if (!PropertyValidator.isValid((Collection)sessionBoard.getSession().getAlmConfigurations())) continue;
                almAccount = ((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getAlmAccount();
                List linkTypes2 = this.almSyncService.retrieveJiraIssueLinkTypesList(almAccount, false);
                HashMap<String, Object> linkType2 = new HashMap<String, Object>();
                linkType2.put("alm", almAccount);
                linkType2.put("sessionBoardId", sessionBoard.getId());
                linkType2.put("linkTypes", linkTypes2);
                piBoardAlmLinkTypes.add(linkType2);
            }
            responseJson.put("piBoardTfsSelectedFeilds", selectedTfsCustomFields);
            responseJson.put("piBoardAlmLinkTypes", piBoardAlmLinkTypes);
            ArrayList solutionAlmSettings = new ArrayList();
            if (PropertyValidator.isValid((Collection)board.getSolutionAlmSettings())) {
                for (SolutionAlmSettings settings : board.getSolutionAlmSettings()) {
                    AlmAccount almAccount = this.almAccountRepository.findById(settings.getAlmAccountId());
                    if (almAccount.getType().equals("tfs")) {
                        HashMap linkTypesResult = this.tfSservice.retrieveJiraIssueLinkTypesList(almAccount, false);
                        String linkTypes3 = (String)linkTypesResult.get("linkTypes");
                        HashMap<String, Object> linkType3 = new HashMap<String, Object>();
                        linkType3.put("alm", almAccount);
                        linkType3.put("linkTypes", linkTypes3);
                        solutionAlmSettings.add(linkType3);
                        continue;
                    }
                    if (!almAccount.getType().equals("jira")) continue;
                    linkTypes = this.almSyncService.retrieveJiraIssueLinkTypesList(almAccount, false);
                    linkType = new HashMap();
                    linkType.put("alm", almAccount);
                    linkType.put("linkTypes", linkTypes);
                    solutionAlmSettings.add(linkType);
                }
            }
            responseJson.put("almSettingsAlmLinkTypes", solutionAlmSettings);
            ArrayList<String> piSessions = new ArrayList<String>();
            ArrayList<HashMap> piBoards = new ArrayList<HashMap>();
            for (String sessionId : board.getPiSessions()) {
                if (!PropertyValidator.isValid(validSessions.get(sessionId))) continue;
                piSessions.add(sessionId);
            }
            for (HashMap piboard : board.getPiBoards()) {
                if (!PropertyValidator.isValid(validSessions.get(piboard.get("sessionId")))) continue;
                piBoards.add(piboard);
            }
            board.setPiBoards(piBoards);
            board.setPiSessions(piSessions);
            boolean addWorkflow = false;
            if (!PropertyValidator.isValid((Object)board.getDependencyWorkFlow())) {
                List workFlowList = this.workFlowRepository.findAllByWorkflowType("Dependency");
                if (PropertyValidator.isValid((Collection)workFlowList)) {
                    board.setDependencyWorkFlow((WorkFlow)workFlowList.get(0));
                } else {
                    board.setDependencyWorkFlow(this.tfSservice.createDefaultDependencyWorkflow());
                }
                addWorkflow = true;
            }
            if (addWorkflow) {
                this.solutionBoardRepository.save((Object)board);
            }
            List dependencyStatuses = this.statusRepository.findByWorkFlow(board.getDependencyWorkFlow());
            WorkFlow workFlow = board.getDependencyWorkFlow();
            ArrayList sortedStatuses = new ArrayList();
            HashMap<String, Status> sortedStatusesMap = new HashMap<String, Status>();
            if (PropertyValidator.isValid((Object)workFlow.getStatusSequence())) {
                String[] sortedStatusIds = workFlow.getStatusSequence().split(",");
                for (Status status : dependencyStatuses) {
                    sortedStatusesMap.put(status.getId(), status);
                }
                for (String statusId : sortedStatusIds) {
                    sortedStatuses.add(sortedStatusesMap.get(statusId));
                }
                board.getDependencyWorkFlow().setStatuses(sortedStatuses);
            } else {
                board.getDependencyWorkFlow().setStatuses(dependencyStatuses);
            }
        }
        ArrayList<User> users = new ArrayList<User>();
        List usersAll = this.userRepository.findByUserCompanies_Company_Id(UserContextUtil.getUserContext().getCurrentCompany().getId());
        for (User user : usersAll) {
            if (!this.isLoggedInCompanyUser(user)) continue;
            users.add(user);
        }
        responseJson.put("users", users);
        responseJson.put("board", (List)board);
        List kendisLinkTypes = this.itemLinkTypeRepository.findBySystem(Boolean.TRUE);
        if (!PropertyValidator.isValid((Collection)kendisLinkTypes)) {
            kendisLinkTypes = this.tfSservice.createNewKendisLinkTypes();
        }
        responseJson.put("kendisLinkTypes", kendisLinkTypes);
        List tfsProjects = this.tfsProjectRepository.findBySolutionId(board.getId());
        if (PropertyValidator.isValid((Collection)tfsProjects)) {
            for (int i = 0; i < tfsProjects.size(); ++i) {
                TFSProject project = (TFSProject)tfsProjects.get(i);
                List itemTypes = this.workFlowItemTypeRepository.findBySolutionIdAndTfsProjectId(board.getId(), project.getTfsId());
                project.setItemTypes(itemTypes);
                WorkFlow workflow = this.workFlowRepository.findBySolutionIdAndTfsProjectId(board.getId(), project.getTfsId());
                project.setWorkFlow(workflow);
                List workflowStatuses = this.statusRepository.findByWorkFlow(workflow);
                if (PropertyValidator.isValid((Collection)workflowStatuses)) {
                    workflowStatuses.forEach(st -> {
                        WorkFlowItemType itemType = new WorkFlowItemType();
                        itemType.setId(st.getWorkFlowItemType().getId());
                        itemType.setTitle(st.getWorkFlowItemType().getTitle());
                        st.setWorkFlowItemType(itemType);
                    });
                }
                workflow.setStatuses(workflowStatuses);
            }
        }
        responseJson.put("tfsProjects", tfsProjects);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/item/{id}"})
    @ResponseBody
    public ResponseEntity<Object> getItem(@PathVariable(value="id") String id) {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        List subItems = this.itemRepository.findByParent(new Item(id));
        responseJson.put("subItems", subItems);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/piboard/{solutionId}/{sessionBoardId}"})
    public Map<String, Object> getPIBoard(@PathVariable(value="solutionId") String solutionId, @PathVariable(value="sessionBoardId") String sessionBoardId) {
        return this.solutionService.getPiBoardData(sessionBoardId, solutionId);
    }

    @RequestMapping(value={"/board/delete"})
    @ResponseBody
    public ResponseEntity<Object> deleteBoard(@RequestBody Map<String, Object> requestBody) {
        String solutionId = (String)requestBody.get("solutionId");
        HashMap<String, String> responseJson = new HashMap<String, String>();
        SolutionBoard solution = (SolutionBoard)this.solutionBoardRepository.findOne((Serializable)((Object)solutionId));
        if (PropertyValidator.isValid((Object)solution)) {
            List itemLinks = this.itemLinkRepository.findBySolutionId(solutionId);
            this.removeItemLinksFromItems(itemLinks, "board", null);
            this.itemRepository.deleteBySolutionBoardIdAndSessionBoardsIsNull(solutionId);
            this.epicFeaturesRepository.deleteBySolutionBoardId(solutionId);
            this.solutionBoardRepository.delete((Serializable)((Object)solutionId));
            responseJson.put("status", "success");
            responseJson.put("solutionId", solutionId);
        } else {
            responseJson.put("status", "failure");
            responseJson.put("code", "0");
            responseJson.put("reason", "Solution Board does't exist");
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/board/togglearchive"})
    @ResponseBody
    public ResponseEntity<Object> archiveBoard(@RequestBody Map<String, Object> requestBody) {
        String solutionId = (String)requestBody.get("solutionId");
        Boolean archive = (Boolean)requestBody.get("archive");
        HashMap<String, String> responseJson = new HashMap<String, String>();
        SolutionBoard solution = (SolutionBoard)this.solutionBoardRepository.findOne((Serializable)((Object)solutionId));
        if (PropertyValidator.isValid((Object)solution)) {
            if (PropertyValidator.isValid((Object)archive) && archive.booleanValue()) {
                solution.setRowStatus(1);
            } else {
                solution.setRowStatus(0);
            }
            this.solutionBoardRepository.save((Object)solution);
            responseJson.put("status", "success");
            responseJson.put("solutionId", solutionId);
        } else {
            responseJson.put("status", "failure");
            responseJson.put("code", "0");
            responseJson.put("reason", "Solution Board does't exist");
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/board/save"})
    @ResponseBody
    public ResponseEntity<Object> saveBoard(@RequestBody SolutionBoard board) {
        String metaMap = board.getMetaMap();
        try {
            List sessions;
            HashMap removedSessionMap = new HashMap();
            HashMap addedSessionMap = new HashMap();
            if (PropertyValidator.isValid((Object)board.getId())) {
                SolutionBoard savedBoard = this.solutionBoardRepository.findByIdIn(board.getId());
                if (PropertyValidator.isValid((Collection)board.getPiBoards())) {
                    ArrayList savedPiBoards = savedBoard.getPiBoards();
                    if (PropertyValidator.isValid((Collection)savedPiBoards)) {
                        savedPiBoards.forEach(piboard -> removedSessionMap.put(piboard.get("sessionId"), Boolean.TRUE));
                    }
                    ArrayList newPiBoards = board.getPiBoards();
                    ArrayList piSessions = new ArrayList();
                    if (PropertyValidator.isValid((Collection)newPiBoards)) {
                        newPiBoards.forEach(piboard -> {
                            piSessions.add(piboard.get("sessionId"));
                            if (PropertyValidator.isValid(removedSessionMap.get(piboard.get("sessionId")))) {
                                removedSessionMap.remove(piboard.get("sessionId"));
                            } else {
                                addedSessionMap.put(piboard.get("sessionId"), Boolean.TRUE);
                            }
                        });
                    }
                    board.setPiSessions(piSessions);
                }
                savedBoard.copy(board);
                board = savedBoard;
            }
            board = (SolutionBoard)this.solutionBoardRepository.save((Object)board);
            ArrayList allSessionIds = new ArrayList();
            if (PropertyValidator.isValid((Collection)board.getPiBoards())) {
                for (HashMap piBoard : board.getPiBoards()) {
                    allSessionIds.add(piBoard.get("sessionId"));
                }
            }
            if (!removedSessionMap.isEmpty()) {
                for (String id : removedSessionMap.keySet()) {
                    this.removePiFromSolutionBoard(id, board);
                }
            }
            if (PropertyValidator.isValid((Collection)(sessions = this.sessionRepository.findByIdIn(allSessionIds)))) {
                ArrayList<String> sessionBoardIds = new ArrayList<String>();
                for (Session session : sessions) {
                    if (PropertyValidator.isValid(addedSessionMap.get(session.getId()))) {
                        this.addPiInSolutionBoard(session, board);
                    }
                    if (!PropertyValidator.isValid((Object)session.getActiveSessionBoard())) continue;
                    sessionBoardIds.add(session.getActiveSessionBoard());
                }
                List sessionBoards = this.sessionBoardRepository.findByIdIn(sessionBoardIds);
                board.setPiSessionBoards(sessionBoards);
                HashMap<String, Object> responseJson = new HashMap<String, Object>();
                responseJson.put("board", board);
                responseJson.put("status", "success");
                JSONObject pushJson = new JSONObject();
                try {
                    pushJson.put("type", (Object)"Solution");
                    pushJson.put("metaMap", (Object)metaMap);
                    PushSender.sendMsg((String)pushJson.toString());
                }
                catch (JSONException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            HashMap<String, String> responseJson = new HashMap<String, String>();
            responseJson.put("status", "failure");
            responseJson.put("code", "0");
            responseJson.put("reason", "No Pi board attached.");
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    private void removePiFromSolutionBoard(String sessionId, SolutionBoard solutionBoard) {
        List itemLinks = this.itemLinkRepository.findBySourceSessionIdOrTargetSessionIdAndSolutionId(sessionId, sessionId, solutionBoard.getId());
        this.removeItemLinksFromItems(itemLinks, "pi", null);
        this.epicFeaturesRepository.deleteBySolutionBoardIdAndSessionId(solutionBoard.getId(), sessionId);
    }

    private void addPiInSolutionBoard(Session session, SolutionBoard solutionBoard) {
    }

    private void removeItemLinksFromItems(List<ItemLink> itemLinks, String caller, List<String> ignoreList) {
        int i;
        ArrayList list;
        HashMap ignoreMap = new HashMap();
        if (PropertyValidator.isValid(ignoreList)) {
            ignoreList.forEach(id -> ignoreMap.put(id, Boolean.TRUE));
        }
        ArrayList<Item> itemsToSave = new ArrayList<Item>();
        ArrayList sourceItemIds = new ArrayList();
        ArrayList targeItemIds = new ArrayList();
        HashMap itemLinkMapById = new HashMap();
        HashMap tempMapId = new HashMap();
        if (PropertyValidator.isValid(itemLinks)) {
            itemLinks.forEach(link -> {
                itemLinkMapById.put(link.getId(), Boolean.TRUE);
                if (tempMapId.get(link.getSourceItemId()) == null) {
                    sourceItemIds.add(link.getSourceItemId());
                    tempMapId.put(link.getSourceItemId(), Boolean.TRUE);
                }
                if (tempMapId.get(link.getTargetItemId()) == null) {
                    targeItemIds.add(link.getTargetItemId());
                    tempMapId.put(link.getTargetItemId(), Boolean.TRUE);
                }
            });
        }
        List sourceItems = null;
        List targetItems = null;
        if (caller.equals("board")) {
            sourceItems = this.itemRepository.findItemByIdInAndSessionBoardsIsNotNull(sourceItemIds);
            targetItems = this.itemRepository.findItemByIdInAndSessionBoardsIsNotNull(targeItemIds);
        } else if (caller.equals("pi")) {
            sourceItems = this.itemRepository.findItemByIdIn(sourceItemIds);
            targetItems = this.itemRepository.findItemByIdIn(targeItemIds);
        } else if (caller.equals("items")) {
            sourceItems = this.itemRepository.findItemByIdIn(sourceItemIds);
            targetItems = this.itemRepository.findItemByIdIn(targeItemIds);
        }
        if (PropertyValidator.isValid((Collection)sourceItems)) {
            for (Item item : sourceItems) {
                if (PropertyValidator.isValid(ignoreMap.get(item.getId())) || !PropertyValidator.isValid((Collection)(list = item.getSolutionSourceItemLinks()))) continue;
                for (i = 0; i < list.size(); ++i) {
                    if (!PropertyValidator.isValid(itemLinkMapById.get(((ItemLink)list.get(i)).getId()))) continue;
                    list.remove(i);
                    --i;
                }
                itemsToSave.add(item);
            }
        }
        if (PropertyValidator.isValid((Collection)targetItems)) {
            for (Item item : targetItems) {
                if (PropertyValidator.isValid(ignoreMap.get(item.getId())) || !PropertyValidator.isValid((Collection)(list = item.getSolutionTargetItemLinks()))) continue;
                for (i = 0; i < list.size(); ++i) {
                    if (!PropertyValidator.isValid(itemLinkMapById.get(((ItemLink)list.get(i)).getId()))) continue;
                    list.remove(i);
                    --i;
                }
                itemsToSave.add(item);
            }
        }
        if (PropertyValidator.isValid(itemsToSave)) {
            this.itemRepository.save(itemsToSave);
        }
        if (PropertyValidator.isValid(itemLinks)) {
            this.itemLinkRepository.delete(itemLinks);
        }
    }

    @RequestMapping(value={"/board/linkPi/{sid}/{pid}"})
    @ResponseBody
    public ResponseEntity<Object> linkPiBoard(@PathVariable(value="sid") String sid, @RequestBody HashMap<String, String> body) {
        SolutionBoard solutionBoard = (SolutionBoard)this.solutionBoardRepository.findOne((Serializable)((Object)sid));
        ArrayList<String> sessionIds = solutionBoard.getPiSessions();
        if (!PropertyValidator.isValid((Collection)sessionIds)) {
            sessionIds = new ArrayList<String>();
        }
        sessionIds.add(body.get("sessionId"));
        solutionBoard.setPiSessions(sessionIds);
        ArrayList<HashMap<String, String>> piBoards = solutionBoard.getPiBoards();
        if (!PropertyValidator.isValid((Collection)piBoards)) {
            piBoards = new ArrayList<HashMap<String, String>>();
        }
        piBoards.add(body);
        solutionBoard.setPiBoards(piBoards);
        this.solutionBoardRepository.save((Object)solutionBoard);
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)body.get("sessionId")));
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)session.getActiveSessionBoard()));
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("session", session);
        responseJson.put("sessionBoard", sessionBoard);
        responseJson.put("piBoard", body);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/board/updatePi/{sid}"})
    @ResponseBody
    public ResponseEntity<Object> updatePiBoardInSolution(@PathVariable(value="sid") String sid, @RequestBody HashMap<String, String> body) {
        SolutionBoard solutionBoard = (SolutionBoard)this.solutionBoardRepository.findOne((Serializable)((Object)sid));
        ArrayList piBoards = solutionBoard.getPiBoards();
        ArrayList<HashMap> _piBoards = new ArrayList<HashMap>();
        if (PropertyValidator.isValid((Collection)piBoards)) {
            for (HashMap piBoard : piBoards) {
                if (((String)piBoard.get("sessionId")).equals(body.get("sessionId"))) {
                    piBoard.put("color", body.get("color"));
                    piBoard.put("prefix", body.get("prefix"));
                    piBoard.put("sequence", body.get("sequence"));
                }
                _piBoards.add(piBoard);
            }
        }
        solutionBoard.setPiBoards(_piBoards);
        this.solutionBoardRepository.save((Object)solutionBoard);
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("status", "success");
        responseJson.put("piBoard", body);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/saveExistingEpic"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveExistingEpic(@RequestBody String requestStr) {
        try {
            LOGGER.debug("Inside epic import save result");
            HashMap<String, Item> responseJson = new HashMap<String, Item>();
            Gson g = new Gson();
            1 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)g.fromJson(requestStr, T.getType());
            String jIssueJson = (String)reqbody.get("jIssue");
            String itemId = (String)reqbody.get("itemId");
            ObjectMapper map = new ObjectMapper();
            try {
                JiraIssue jIssue = (JiraIssue)map.readValue(jIssueJson, JiraIssue.class);
                Item epicItem = new Item();
                epicItem.setTitle(jIssue.getFields().getSummary());
                epicItem.setType(jIssue.getItemTypeTobeConvertedInto());
                epicItem.setJiraId(jIssue.getId());
                epicItem.setJiraKey(jIssue.getKey());
                epicItem.setJiraProjectKey(jIssue.getFields().getProject().getKey());
                epicItem.setJiraIssueTypeId(jIssue.getFields().getIssuetype().getId());
                epicItem = (Item)this.itemRepository.save((Object)epicItem);
                responseJson.put("epicItem", epicItem);
                Item featureItem = (Item)this.itemRepository.findOne((Serializable)((Object)itemId));
                featureItem.setParent(epicItem);
                this.itemRepository.save((Object)featureItem);
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            catch (JsonParseException jsonParseException) {
            }
            catch (JsonMappingException jsonMappingException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        catch (Exception e) {
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @ResponseBody
    public ResponseEntity<Object> resyncBoard(List<String> sessionBoardIds) throws Exception {
        List sessionBoards = this.sessionBoardRepository.findByIdIn(sessionBoardIds);
        for (SessionBoard sessionBoard : sessionBoards) {
            HashMap<String, JiraFilter> featureChildLinkTypeMap = new HashMap<String, JiraFilter>();
            ArrayList<BacklogMappingLinks> featureChildMappingLinks = new ArrayList<BacklogMappingLinks>();
            ArrayList<String> jiraKeys = new ArrayList<String>();
            HashSet<String> filterIds = new HashSet<String>();
            AlmConfigurations configurations = null;
            Session session = sessionBoard.getSession();
            if (PropertyValidator.isValid((Collection)session.getAlmConfigurations())) {
                configurations = (AlmConfigurations)session.getAlmConfigurations().get(0);
                List items = this.itemRepository.findBySessionBoardsIdInAndJiraIdIsNotNullAndType(sessionBoard.getId(), Item.Type.Feature.toString());
                Iterator iterator = items.iterator();
                while (iterator.hasNext()) {
                    Item item = (Item)iterator.next();
                    if (!PropertyValidator.isValid((Object)item.getJiraId()) || !PropertyValidator.isValid((Object)item.getJiraKey())) continue;
                    jiraKeys.add(item.getJiraKey());
                    if (PropertyValidator.isValid((Object)item.getJiraFilter()) && !item.getJiraFilter().contains("AddExisting")) {
                        filterIds.add(item.getJiraFilter());
                        continue;
                    }
                    BacklogMappingLinks bmlink = new BacklogMappingLinks();
                    bmlink.setLinkTypes(item.getLinkTypes());
                    bmlink.setProjectKey(item.getJiraProjectKey());
                    featureChildMappingLinks = new ArrayList();
                    featureChildMappingLinks.add(bmlink);
                    JiraFilter jfilter = new JiraFilter();
                    jfilter.setId(item.getJiraFilter());
                    jfilter.setFeatureLinkMappings(featureChildMappingLinks);
                    featureChildLinkTypeMap.put(item.getJiraId(), jfilter);
                }
            }
            if (PropertyValidator.isValid(filterIds)) {
                for (String filterId : filterIds) {
                    if (!PropertyValidator.isValid((Collection)configurations.getFeatureFilter())) continue;
                    for (JiraFilter filter : configurations.getFeatureFilter()) {
                        if (!filterId.equals(filter.getId())) continue;
                        this.almSyncService.retrieveDataAgainstJiraFilter2(filter, configurations.getId(), filter.getFeatureLinkMappings(), sessionBoard.getId(), null, sessionBoard.getSession().getId(), null, false, Boolean.valueOf(false), false, false, null);
                    }
                }
                continue;
            }
            if (!PropertyValidator.isValid(jiraKeys)) continue;
            String jiraKeysStr = String.join((CharSequence)",", jiraKeys);
            String jql = " key IN (" + jiraKeysStr + ") ";
            JiraFilter filter = new JiraFilter();
            filter.setIndividualSync(true);
            filter.setJql(jql);
            this.almSyncService.retrieveDataAgainstJiraFilter2(filter, configurations.getId(), null, sessionBoard.getId(), null, sessionBoard.getSession().getId(), featureChildLinkTypeMap, false, Boolean.valueOf(false), false, false, null);
        }
        return null;
    }

    @RequestMapping(value={"/exportDependencies"})
    @ResponseBody
    public ResponseEntity<Object> exportDependencies(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, String> response = new HashMap<String, String>();
        try {
            String solutionName = (String)payload.get("solutionName");
            String type = (String)payload.get("type");
            String headers = (String)payload.get("linkHeaders");
            List data = (List)payload.get("linkData");
            int exportType = 1;
            if (type.equals("csv")) {
                exportType = 0;
            }
            String filePath = this.exportService.exportSolutionDepsData(headers, data, exportType, "kendis");
            String cleanedSessionTitle = AlmUtils.cleanText((String)solutionName);
            String downloadName = AlmUtils.cleanText((String)(cleanedSessionTitle + AlmUtils.cleanText((String)"_dependencies"))) + "." + type;
            response.put("srcPath", filePath);
            response.put("name", URLEncoder.encode(downloadName, "UTF-8"));
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/item/create/itemlinks1/{solutionId}"})
    @ResponseBody
    public ResponseEntity<Object> createItemLink1(@PathVariable(value="solutionId") String solutionId, @RequestBody Item sourceItem) {
        SolutionBoard solutionBoard = (SolutionBoard)this.solutionBoardRepository.findOne((Serializable)((Object)solutionId));
        HashMap response = this.solutionService.createItemLinks1(sourceItem, solutionBoard, sourceItem.getMetaMap());
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @RequestMapping(value={"/item/create/itemlinks"})
    @ResponseBody
    public ResponseEntity<Object> createItemLink(@RequestBody HashMap<String, Object> payload) {
        try {
            HashMap sourceItemMap = (HashMap)payload.get("sourceItem");
            ArrayList itemLinksMap = (ArrayList)payload.get("itemLinks");
            String solutionId = (String)payload.get("solutionId");
            SolutionBoard solutionBoard = (SolutionBoard)this.solutionBoardRepository.findOne((Serializable)((Object)solutionId));
            ObjectMapper mapper = new ObjectMapper();
            String metaMap = (String)payload.get("metaMap");
            Item sourceItem = (Item)mapper.convertValue((Object)sourceItemMap, Item.class);
            ArrayList itemLinks = (ArrayList)mapper.convertValue((Object)itemLinksMap, (JavaType)mapper.getTypeFactory().constructCollectionType(ArrayList.class, ItemLink.class));
            HashMap response = this.solutionService.createItemLinks(itemLinks, sourceItem, solutionBoard, metaMap);
            return new ResponseEntity((Object)response, HttpStatus.OK);
        }
        catch (Exception e) {
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("status", "failure");
            response.put("statusCode", "0");
            response.put("reason", "Invalid Input");
            return new ResponseEntity(response, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/item/delete/almlink"})
    @ResponseBody
    public ResponseEntity<Object> deleteAlmLink(@RequestBody HashMap<String, Object> payload) {
        String itemId = (String)payload.get("itemId");
        String solutionId = (String)payload.get("solutionId");
        String almId = (String)payload.get("almId");
        String linkId = (String)payload.get("linkId");
        Item item = this.itemRepository.findById(itemId);
        String metaMap = (String)payload.get("metaMap");
        HashMap response = this.solutionService.deleteAlmLink(item, linkId, solutionId, almId, metaMap);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @RequestMapping(value={"/item/delete/almlink1"})
    @ResponseBody
    public ResponseEntity<Object> deleteAlmLink1(@RequestBody HashMap<String, Object> payload) {
        String itemId = (String)payload.get("itemId");
        String solutionId = (String)payload.get("solutionId");
        String almId = (String)payload.get("almId");
        String linkId = (String)payload.get("linkId");
        Item item = this.itemRepository.findById(itemId);
        String metaMap = (String)payload.get("metaMap");
        HashMap response = this.solutionService.deleteAlmLink1(item, linkId, solutionId, almId, metaMap);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @RequestMapping(value={"/item/delete/itemlinks"})
    @ResponseBody
    public ResponseEntity<Object> deleteItemLink(@RequestBody HashMap<String, Object> payload) {
        try {
            ArrayList itemLinksMap = (ArrayList)payload.get("itemLinks");
            ObjectMapper mapper = new ObjectMapper();
            ArrayList itemLinks = (ArrayList)mapper.convertValue((Object)itemLinksMap, (JavaType)mapper.getTypeFactory().constructCollectionType(ArrayList.class, ItemLink.class));
            String metaMap = (String)payload.get("metaMap");
            HashMap response = this.solutionService.deleteItemLinks(itemLinks, metaMap);
            return new ResponseEntity((Object)response, HttpStatus.OK);
        }
        catch (Exception e) {
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("status", "failure");
            response.put("statusCode", "0");
            response.put("reason", "Invalid Input");
            return new ResponseEntity(response, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/item/delete/itemlinks1"})
    @ResponseBody
    public ResponseEntity<Object> deleteItemLink1(@RequestBody Item item) {
        HashMap<String, Object> responseJson;
        block26: {
            responseJson = new HashMap<String, Object>();
            try {
                Gson g = new Gson();
                2 T = new /* Unavailable Anonymous Inner Class!! */;
                HashMap requestMap = (HashMap)g.fromJson(item.getMetaMap(), T.getType());
                Item savedItem = null;
                if (PropertyValidator.isValid((Object)item.getId())) {
                    savedItem = (Item)this.itemRepository.findOne((Serializable)((Object)item.getId()));
                }
                if (savedItem == null) {
                    ArrayList itemLinks = new ArrayList();
                    itemLinks.add(item.getItemLinks().get(0));
                    List items = this.itemRepository.findByItemLinksIn(itemLinks);
                    if (PropertyValidator.isValid((Collection)items)) {
                        savedItem = (Item)items.get(0);
                    }
                }
                ItemLink linkToDel = (ItemLink)item.getItemLinks().get(0);
                ItemLink savedLinkToDel = null;
                if (!PropertyValidator.isValid((Object)savedItem) || !PropertyValidator.isValid((Collection)savedItem.getItemLinks())) {
                    this.itemLinkRepository.delete(item.getItemLinks().get(0));
                    responseJson.put("success", true);
                    responseJson.put("linkId", ((ItemLink)item.getItemLinks().get(0)).getId());
                    return new ResponseEntity(responseJson, HttpStatus.OK);
                }
                for (ItemLink il : savedItem.getItemLinks()) {
                    if (!PropertyValidator.isValid((Object)il) || !PropertyValidator.isValid((Object)il.getId()) || !il.getId().equals(((ItemLink)item.getItemLinks().get(0)).getId())) continue;
                    savedLinkToDel = il;
                    break;
                }
                if (savedLinkToDel == null) break block26;
                String savedItemTfsId = savedItem.getTfsId();
                String targetItemId = savedLinkToDel.getTargetFeatureId() != null ? savedLinkToDel.getTargetFeatureId() : savedLinkToDel.getTargetItemId();
                Item targetItem = this.itemRepository.findById(targetItemId);
                ArrayList<ItemJiraDependency> jiraDepToDel = new ArrayList<ItemJiraDependency>();
                if (PropertyValidator.isValid((Object)savedLinkToDel.getAlmLinkId())) {
                    ItemJiraDependency link;
                    int i;
                    if (PropertyValidator.isValid((Collection)savedItem.getJiraDependencies())) {
                        for (i = 0; i < savedItem.getJiraDependencies().size(); ++i) {
                            link = (ItemJiraDependency)savedItem.getJiraDependencies().get(i);
                            if (!PropertyValidator.isValid((Object)link.getJiraDependencyId()) || !link.getJiraDependencyId().equals(savedLinkToDel.getAlmLinkId())) continue;
                            jiraDepToDel.add(link);
                            savedItem.getJiraDependencies().remove(i);
                            this.itemRepository.save((Object)savedItem);
                            break;
                        }
                    }
                    if (PropertyValidator.isValid((Object)targetItem) && PropertyValidator.isValid((Collection)targetItem.getJiraDependencies())) {
                        for (i = 0; i < targetItem.getJiraDependencies().size(); ++i) {
                            link = (ItemJiraDependency)targetItem.getJiraDependencies().get(i);
                            if (!PropertyValidator.isValid((Object)link.getJiraDependencyId()) || !link.getJiraDependencyId().equals(savedLinkToDel.getAlmLinkId())) continue;
                            jiraDepToDel.add(link);
                            targetItem.getJiraDependencies().remove(i);
                            this.itemRepository.save((Object)targetItem);
                            break;
                        }
                    }
                    if (PropertyValidator.isValid(jiraDepToDel)) {
                        this.itemJiraDependencyRepository.delete(jiraDepToDel);
                        responseJson.put("linkedAlmLinks", jiraDepToDel);
                    }
                }
                Object linkedAlmLinks = null;
                if (PropertyValidator.isValid((Object)savedLinkToDel.getAlmLinkId()) && linkToDel.isRemoveAlmLink()) {
                    AlmAccount almAccount = null;
                    if (PropertyValidator.isValid((Collection)savedItem.getSessionBoards())) {
                        if (PropertyValidator.isValid((Object)((SessionBoard)savedItem.getSessionBoards().get(0)).getSession().getTfsAlmConfigurations())) {
                            almAccount = ((SessionBoard)savedItem.getSessionBoards().get(0)).getSession().getTfsAlmConfigurations().getAlmAccount();
                        } else if (PropertyValidator.isValid((Collection)((SessionBoard)savedItem.getSessionBoards().get(0)).getSession().getAlmConfigurations())) {
                            almAccount = ((AlmConfigurations)((SessionBoard)savedItem.getSessionBoards().get(0)).getSession().getAlmConfigurations().get(0)).getAlmAccount();
                        }
                    } else {
                        almAccount = this.almAccountRepository.findById(savedItem.getAlmId());
                    }
                    if (PropertyValidator.isValid((Object)almAccount)) {
                        if (almAccount.getType().equals("tfs")) {
                            if (((ItemLink)item.getItemLinks().get(0)).isRemoveAlmLink()) {
                                AlmAccount safeAlmAccount = almAccount;
                                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                            }
                        } else if (((ItemLink)item.getItemLinks().get(0)).isRemoveAlmLink() && PropertyValidator.isValid(jiraDepToDel)) {
                            User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
                            String jiraIssueLinkId = ((ItemJiraDependency)jiraDepToDel.get(0)).getJiraDependencyId();
                            String almAccountId = almAccount.getId();
                            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                        }
                    }
                }
                this.itemLinkRepository.delete((Object)savedLinkToDel);
                savedItem.getItemLinks().remove(savedLinkToDel);
                savedItem.putLastUpdatedValue(Item.Actions.itemLinkRemoved.name(), (Object)savedLinkToDel);
                this.itemRepository.save((Object)savedItem);
                Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
                String itemStr = gsonExclusive.toJson((Object)savedItem, new /* Unavailable Anonymous Inner Class!! */.getType());
                JSONObject pushJson = new JSONObject();
                try {
                    JSONObject metaMapJson = new JSONObject(item.getMetaMap());
                    JSONObject itemJson = new JSONObject(itemStr);
                    metaMapJson.put("item", (Object)itemJson);
                    metaMapJson.put("linkId", (Object)savedLinkToDel.getId());
                    pushJson.put("type", (Object)"Links");
                    pushJson.put("metaMap", (Object)metaMapJson.toString());
                    PushSender.sendMsg((String)pushJson.toString());
                }
                catch (JSONException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
                responseJson.put("success", true);
                responseJson.put("linkId", savedLinkToDel.getId());
                responseJson.put("item", savedItem);
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        responseJson.put("success", false);
        return new ResponseEntity(responseJson, HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/item/update/itemlinks"})
    @ResponseBody
    public ResponseEntity<Object> updateItemLink(@RequestBody HashMap<String, Object> payload) {
        try {
            ArrayList itemLinksMap = (ArrayList)payload.get("itemLinks");
            String itemId = (String)payload.get("itemId");
            String sessionBoardId = (String)payload.get("sessionBoardId");
            String metaMap = (String)payload.get("metaMap");
            ObjectMapper mapper = new ObjectMapper();
            ArrayList itemLinks = (ArrayList)mapper.convertValue((Object)itemLinksMap, (JavaType)mapper.getTypeFactory().constructCollectionType(ArrayList.class, ItemLink.class));
            HashMap response = this.solutionService.updateItemLink(sessionBoardId, itemId, itemLinks, metaMap);
            return new ResponseEntity((Object)response, HttpStatus.OK);
        }
        catch (Exception e) {
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("status", "failure");
            response.put("statusCode", "0");
            response.put("reason", "Invalid Input");
            return new ResponseEntity(response, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/save/almlink"})
    @ResponseBody
    public ResponseEntity<Object> saveJiraLink(@RequestBody ItemJiraDependency dependency) {
        ItemJiraDependency reverseDependency;
        String metaMap = dependency.getMetaMap();
        ArrayList<ItemJiraDependency> linksToSave = new ArrayList<ItemJiraDependency>();
        ItemJiraDependency oldLink = (ItemJiraDependency)this.itemJiraDependencyRepository.findOne((Serializable)((Object)dependency.getId()));
        if (PropertyValidator.isValid((Object)oldLink)) {
            this.almSyncService.setLinkMeta(oldLink, dependency);
            linksToSave.add(oldLink);
        }
        if (PropertyValidator.isValid((Object)oldLink.getSourceItemId()) && PropertyValidator.isValid((Object)oldLink.getTargetItemId()) && PropertyValidator.isValid((Object)(reverseDependency = this.itemJiraDependencyRepository.findBySourceItemIdAndTargetItemId(oldLink.getTargetItemId(), oldLink.getSourceItemId())))) {
            this.almSyncService.setLinkMeta(reverseDependency, dependency);
            linksToSave.add(reverseDependency);
        }
        HashMap<String, ArrayList<ItemJiraDependency>> response = new HashMap<String, ArrayList<ItemJiraDependency>>();
        this.almSyncService.syncKendisAndAlmLink((Object)oldLink);
        for (ItemJiraDependency link : linksToSave) {
            if (!dependency.getWfStatus().getCategory().equalsIgnoreCase("Done")) continue;
            link.setResolvedOn(new Date());
        }
        this.itemJiraDependencyRepository.save(linksToSave);
        response.put("linksToSave", linksToSave);
        JSONObject pushJson = new JSONObject();
        try {
            pushJson.put("type", (Object)"Links");
            pushJson.put("metaMap", (Object)metaMap);
            PushSender.sendMsg((String)pushJson.toString());
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/items/{solutionId}"})
    @ResponseBody
    public ResponseEntity<Object> getSolutionItems(@PathVariable(value="solutionId") String solutionId) {
        HashMap response = this.solutionService.getSolutionData(solutionId);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @RequestMapping(value={"/gettfsprojects"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getTFSProjects(@RequestBody Map<String, String> payload) {
        String tfsProjectId = payload.get("tfsProjectId");
        String projectId = payload.get("projectId");
        String solutionId = payload.get("solutionId");
        TFSProject project = null;
        if (PropertyValidator.isValid((Object)projectId)) {
            project = this.tfsProjectRepository.findBySolutionIdAndId(solutionId, projectId);
        } else if (PropertyValidator.isValid((Object)tfsProjectId)) {
            project = this.tfsProjectRepository.findBySolutionIdAndTfsId(solutionId, tfsProjectId);
        }
        if (PropertyValidator.isValid(project)) {
            List itemTypes = this.workFlowItemTypeRepository.findBySolutionIdAndTfsProjectId(solutionId, project.getTfsId());
            project.setItemTypes(itemTypes);
            WorkFlow workflow = this.workFlowRepository.findBySolutionIdAndTfsProjectId(solutionId, project.getTfsId());
            project.setWorkFlow(workflow);
            List workflowStatuses = this.statusRepository.findByWorkFlow(workflow);
            if (PropertyValidator.isValid((Collection)workflowStatuses)) {
                workflowStatuses.forEach(st -> {
                    WorkFlowItemType itemType = new WorkFlowItemType();
                    itemType.setId(st.getWorkFlowItemType().getId());
                    itemType.setTitle(st.getWorkFlowItemType().getTitle());
                    st.setWorkFlowItemType(itemType);
                });
            }
            workflow.setStatuses(workflowStatuses);
            HashMap<String, String> responseJson = new HashMap<String, String>();
            responseJson.put("status", "success");
            responseJson.put("project", (String)project);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        HashMap<String, String> responseJson = new HashMap<String, String>();
        responseJson.put("status", "failure");
        responseJson.put("reason", "Project not found");
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/resynctfsprojects"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> resyncTFSProjects(@RequestBody Map<String, String> payload) {
        HashMap responseJson = new HashMap();
        String projectId = payload.get("projectId");
        String solutionId = payload.get("solutionId");
        String requestId = payload.get("requestId");
        String metaMap = payload.get("metaMap");
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/deletetfsprojects"})
    @ResponseBody
    public ResponseEntity<Object> deleteTfsProject(@RequestBody Map<String, Object> payload) {
        HashMap<String, Object> responseJson;
        String solutionId = (String)payload.get("solutionId");
        String projectId = (String)payload.get("projectId");
        Boolean checkOnly = (Boolean)payload.get("deleteCheck");
        TFSProject tfsProject = (TFSProject)this.tfsProjectRepository.findOne((Serializable)((Object)projectId));
        if (!PropertyValidator.isValid((Object)tfsProject)) {
            HashMap<String, String> responseJson2 = new HashMap<String, String>();
            responseJson2.put("status", "failure");
            responseJson2.put("reason", "Project not found");
            return new ResponseEntity(responseJson2, HttpStatus.OK);
        }
        SolutionBoard solutionBoard = (SolutionBoard)this.solutionBoardRepository.findOne((Serializable)((Object)solutionId));
        if (!PropertyValidator.isValid((Object)solutionBoard)) {
            HashMap<String, String> responseJson3 = new HashMap<String, String>();
            responseJson3.put("status", "failure");
            responseJson3.put("reason", "Solution board not found");
            return new ResponseEntity(responseJson3, HttpStatus.OK);
        }
        long itemsCount = this.itemRepository.countByTfsProjectIdAndSolutionBoardId(tfsProject.getTfsId(), solutionId);
        long filterCount = 0L;
        if (PropertyValidator.isValid((Collection)solutionBoard.getAlmFilters())) {
            for (ALMFilter almFilter : solutionBoard.getAlmFilters()) {
                if (almFilter.getTfsFilter() == null || (almFilter.getTfsFilter().getTfsProjectId() == null || !almFilter.getTfsFilter().getTfsProjectId().equals(tfsProject.getTfsId())) && (almFilter.getTfsFilter().getTfsProject() == null || !almFilter.getTfsFilter().getTfsProject().equals(tfsProject.getName()))) continue;
                ++filterCount;
            }
        }
        if (itemsCount > 0L) {
            responseJson = new HashMap<String, Object>();
            responseJson.put("status", "failure");
            responseJson.put("reason", "Item(s) exist");
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        if (filterCount > 0L) {
            responseJson = new HashMap();
            responseJson.put("status", "failure");
            responseJson.put("reason", "Filter(s) exist");
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        if (PropertyValidator.isValid((Object)checkOnly)) {
            responseJson = new HashMap();
            responseJson.put("status", "success");
            responseJson.put("removed", false);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        this.workFlowRepository.deleteBySolutionIdAndTfsProjectId(solutionId, tfsProject.getTfsId());
        this.workFlowItemTypeRepository.deleteBySolutionIdAndTfsProjectId(solutionId, tfsProject.getTfsId());
        this.statusRepository.deleteBySolutionIdAndTfsProjectId(solutionId, tfsProject.getTfsId());
        this.tfsProjectRepository.deleteBySolutionIdAndTfsId(solutionId, tfsProject.getTfsId());
        responseJson = new HashMap();
        responseJson.put("status", "success");
        responseJson.put("projectId", projectId);
        responseJson.put("removed", true);
        String metaMap = (String)payload.get("metaMap");
        if (PropertyValidator.isValid((Object)metaMap)) {
            JSONObject pushJson = new JSONObject();
            try {
                pushJson.put("type", (Object)"ALM");
                pushJson.put("metaMap", (Object)metaMap);
                PushSender.sendMsg((String)pushJson.toString());
            }
            catch (JSONException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/linktfsprojects"})
    @ResponseBody
    public ResponseEntity<Object> linkTfsProject(@RequestBody Map<String, String> payload) {
        HashMap<String, String> response = new HashMap<String, String>();
        String solutionId = payload.get("solutionId");
        String tfsProjectId = payload.get("tfsProjectId");
        String almAccountId = payload.get("almAccountId");
        String metaMap = payload.get("metaMap");
        String requestId = payload.get("requestId");
        TFSProject tfsProject = this.tfsProjectRepository.findBySolutionIdAndTfsId(solutionId, tfsProjectId);
        if (PropertyValidator.isValid((Object)tfsProject)) {
            response.put("status", "fialure");
            response.put("code", "0");
            response.put("reason", "This project is already linked.");
        } else {
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            response.put("status", "success");
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/tfssearch"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getTFSSearchResults(@RequestBody String payload) {
        HashMap<String, String> responseJson = new HashMap<String, String>();
        try {
            String almAccountId = null;
            Gson g = new Gson();
            8 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)g.fromJson(payload, T.getType());
            String tfsIds = (String)reqbody.get("ids");
            almAccountId = (String)reqbody.get("almAccountId");
            AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
            responseJson.put("status", "success");
            responseJson.put("tfsitems", this.tfsUtils.getItems("1", tfsIds, almAccount));
        }
        catch (ViztrendJiraException vJe) {
            responseJson.put("status", "failure");
            responseJson.put("reason", (String)vJe.getAlmError());
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/savetfsitems"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchTFSItems(@RequestBody HashMap<String, Object> reqbody) {
        HashMap<String, String> responseJson = new HashMap<String, String>();
        String itemIdsStr = (String)reqbody.get("itemIds");
        String solutionBoardId = (String)reqbody.get("solutionBoardId");
        String almAccountId = (String)reqbody.get("almAccountId");
        String filterStr = null;
        TFSFilter filter = null;
        if (reqbody.get("filter") != null) {
            filterStr = (String)reqbody.get("filter");
        }
        AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
        String metaMap = (String)reqbody.get("metaMap");
        ObjectMapper mapper = new ObjectMapper();
        ArrayList linkTypes = (ArrayList)reqbody.get("linkTypes");
        try {
            try {
                if (filterStr != null) {
                    filter = (TFSFilter)mapper.readValue(filterStr, TFSFilter.class);
                }
            }
            catch (JsonParseException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            catch (JsonMappingException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            catch (IOException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        catch (ViztrendJiraException vJe) {
            responseJson.put("status", "failure");
            responseJson.put("reason", (String)vJe.getAlmError());
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        SolutionBoard solutionBoard = (SolutionBoard)this.solutionBoardRepository.findOne((Serializable)((Object)solutionBoardId));
        if (PropertyValidator.isValid((Object)itemIdsStr)) {
            List<String> itemIds;
            List existingItems;
            if (PropertyValidator.isValid((Object)filter)) {
                AlmAccount taggedAlmAccount;
                filter.setFilterFetchedBy(this.tfsUtils.getProfileAlmUser(almAccount));
                if (PropertyValidator.isValid((Object)filter.getFilterFetchedBy()) && PropertyValidator.isValid((Object)(taggedAlmAccount = TFSUtils.getTaggedAlmUser((User)filter.getFilterFetchedBy(), (AlmAccount)almAccount)))) {
                    almAccount = taggedAlmAccount;
                }
            }
            if (PropertyValidator.isValid((Collection)(existingItems = this.itemRepository.findByTfsIdInAndSolutionBoard(itemIds = Arrays.asList(itemIdsStr.split("\\s*,\\s*")), solutionBoard)))) {
                responseJson.put("status", "failure");
                responseJson.put("reason", "One or more item(s) already exist on solution board.");
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            HashMap result = this.tfSservice.fetchTFSEpicItems(itemIds, (List)linkTypes, solutionBoard, null, almAccount, null, Boolean.valueOf(false));
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/filter/save/{solutionId}"})
    @ResponseBody
    public ResponseEntity<Object> saveFilter(@PathVariable(value="solutionId") String solutionId, @RequestBody HashMap<String, Object> payload) {
        try {
            HashMap<String, String> response = new HashMap<String, String>();
            ArrayList itemIds = (ArrayList)payload.get("itemIds");
            String requestId = (String)payload.get("requestId");
            String metaMap = (String)payload.get("metaMap");
            ObjectMapper mapper = new ObjectMapper();
            ALMFilter _almFilter = null;
            Object param = payload.get("filter");
            String classType = param.getClass().getName().toLowerCase();
            if (classType.indexOf("string") > -1) {
                Gson gson = new Gson();
                _almFilter = (ALMFilter)gson.fromJson((String)param, ALMFilter.class);
            } else if (classType.indexOf("map") > -1) {
                HashMap filterMap = (HashMap)param;
                _almFilter = (ALMFilter)mapper.convertValue((Object)filterMap, ALMFilter.class);
            }
            ALMFilter almFilter = _almFilter;
            if (PropertyValidator.isValid((Object)solutionId) && PropertyValidator.isValid((Object)almFilter)) {
                SolutionBoard board = this.solutionBoardRepository.findByIdIn(solutionId);
                boolean alreadyExist = false;
                if (PropertyValidator.isValid((Object)almFilter.getTfsFilter())) {
                    if (PropertyValidator.isValid((Collection)board.getAlmFilters())) {
                        for (ALMFilter filter : board.getAlmFilters()) {
                            if (!PropertyValidator.isValid((Object)filter.getTfsFilter()) || !filter.getTfsFilter().getTfsId().equals(almFilter.getTfsFilter().getTfsId())) continue;
                            alreadyExist = true;
                            break;
                        }
                    }
                } else if (PropertyValidator.isValid((Object)almFilter.getJiraFilter()) && PropertyValidator.isValid((Collection)board.getAlmFilters())) {
                    for (ALMFilter filter : board.getAlmFilters()) {
                        if (!PropertyValidator.isValid((Object)filter.getJiraFilter()) || !filter.getJiraFilter().getId().equals(almFilter.getJiraFilter().getId())) continue;
                        alreadyExist = true;
                        break;
                    }
                }
                if (!alreadyExist) {
                    if (!PropertyValidator.isValid((Collection)board.getAlmFilters())) {
                        board.setAlmFilters(new ArrayList());
                    }
                    board.getAlmFilters().add(almFilter);
                    this.solutionBoardRepository.save((Object)board);
                    new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                    response.put("status", "success");
                    response.put("almFilter", (String)almFilter);
                } else {
                    response.put("status", "failure");
                    response.put("statusCode", "0");
                    response.put("reason", "Filter already exist");
                }
            } else {
                response.put("status", "failure");
                response.put("statusCode", "0");
                response.put("reason", "Invalid Input");
            }
            return new ResponseEntity(response, HttpStatus.OK);
        }
        catch (Exception e) {
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("status", "failure");
            response.put("statusCode", "0");
            response.put("reason", "Invalid Input");
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(response, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/item/delete"})
    @ResponseBody
    public ResponseEntity<Object> deleteSolutionItem(@RequestBody Map<String, String> payload) {
        String solutionId = payload.get("solutionId");
        String itemId = payload.get("itemId");
        String metaMap = payload.get("metaMap");
        HashMap<String, String> response = new HashMap<String, String>();
        Item item = this.itemRepository.findById(itemId);
        if (PropertyValidator.isValid((Object)item)) {
            ArrayList<String> epicKeys;
            String key;
            ArrayList links = new ArrayList();
            if (PropertyValidator.isValid((Collection)item.getSolutionSourceItemLinks())) {
                item.getSolutionSourceItemLinks().forEach(link -> links.add(link));
            }
            if (PropertyValidator.isValid((Collection)item.getSolutionTargetItemLinks())) {
                item.getSolutionTargetItemLinks().forEach(link -> links.add(link));
            }
            ArrayList<String> itemIds = new ArrayList<String>();
            itemIds.add(itemId);
            this.removeItemLinksFromItems(links, "items", itemIds);
            AlmAccount alm = null;
            if (PropertyValidator.isValid((Object)item.getAlmId())) {
                alm = this.almAccountRepository.findById(item.getAlmId());
            }
            ArrayList<Item> removed = new ArrayList<Item>();
            if (item.getType().equals(Item.EPIC)) {
                key = item.getTfsId() != null ? item.getTfsId() : (item.getJiraId() != null ? item.getJiraKey() : item.getId());
                epicKeys = new ArrayList<String>();
                epicKeys.add(key);
                ArrayList<String> subItemsKeys = new ArrayList<String>();
                List epicFeatures = this.epicFeaturesRepository.findByEpicKeyInAndSolutionBoardId(epicKeys, solutionId);
                if (PropertyValidator.isValid((Collection)epicFeatures)) {
                    for (EpicFeature epicFeature : epicFeatures) {
                        if (epicFeature.getSessionId() != null) continue;
                        subItemsKeys.add(epicFeature.getFeatureKey());
                    }
                    this.epicFeaturesRepository.delete((Iterable)epicFeatures);
                }
                if (PropertyValidator.isValid(subItemsKeys)) {
                    removed.addAll(this.itemRepository.deleteByJiraKeyInOrTfsIdInAndSolutionBoardIdAndSessionBoardsIsNull(subItemsKeys, subItemsKeys, solutionId));
                }
                this.itemRepository.delete((Object)item);
                removed.add(item);
            } else {
                key = item.getTfsId() != null ? item.getTfsId() : (item.getJiraId() != null ? item.getJiraKey() : item.getId());
                epicKeys = new ArrayList();
                epicKeys.add(key);
                List epicFeatures = this.epicFeaturesRepository.findByFeatureKeyInAndSolutionBoardId(epicKeys, solutionId);
                if (PropertyValidator.isValid((Collection)epicFeatures)) {
                    this.epicFeaturesRepository.delete((Iterable)epicFeatures);
                }
                this.itemRepository.delete((Object)item);
                removed.add(item);
            }
            if (PropertyValidator.isValid(removed) && PropertyValidator.isValid((Object)alm)) {
                this.syncTagsForBacklog(alm, removed);
            }
            JSONObject pushJson = new JSONObject();
            try {
                pushJson.put("type", (Object)"Items");
                pushJson.put("metaMap", (Object)metaMap);
                PushSender.sendMsg((String)pushJson.toString());
            }
            catch (JSONException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        } else {
            response.put("status", "failure");
            response.put("statusCode", "0");
            response.put("reason", "Item does't exist.");
            return new ResponseEntity(response, HttpStatus.BAD_REQUEST);
        }
        response.put("status", "success");
        response.put("itemId", item.getId());
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/filter/delete"})
    @ResponseBody
    public ResponseEntity<Object> deleteFilter(@RequestBody Map<String, String> payload) {
        String solutionId = payload.get("solutionId");
        String filterAlmId = payload.get("almFilterId");
        String metaMap = payload.get("metaMap");
        HashMap<String, String> response = new HashMap<String, String>();
        SolutionBoard solutionBoard = this.solutionBoardRepository.findByIdIn(solutionId);
        ALMFilter almFilter = null;
        int filterIndex = -1;
        if (PropertyValidator.isValid((Collection)solutionBoard.getAlmFilters())) {
            for (int index = 0; index < solutionBoard.getAlmFilters().size(); ++index) {
                ALMFilter filter = (ALMFilter)solutionBoard.getAlmFilters().get(index);
                if ((!PropertyValidator.isValid((Object)filter.getTfsFilter()) || !filter.getTfsFilter().getTfsId().equals(filterAlmId)) && (!PropertyValidator.isValid((Object)filter.getJiraFilter()) || !filter.getJiraFilter().getId().equals(filterAlmId))) continue;
                almFilter = filter;
                filterIndex = index;
                break;
            }
        } else {
            response.put("status", "failure");
            response.put("statusCode", "0");
            response.put("reason", "Solution board does't exist.");
            return new ResponseEntity(response, HttpStatus.BAD_REQUEST);
        }
        if (PropertyValidator.isValid(almFilter)) {
            List deletedLinks = this.epicFeaturesRepository.deleteByAlmFilterIdAndSolutionBoardId(filterAlmId, solutionBoard.getId());
            this.removeFilterItems(almFilter, solutionId, deletedLinks);
            if (PropertyValidator.isValid((Object)almFilter.getTfsFilter())) {
                response.put("type", "tfs");
            } else {
                response.put("type", "jira");
            }
            solutionBoard.getAlmFilters().remove(filterIndex);
            this.solutionBoardRepository.save((Object)solutionBoard);
            response.put("status", "success");
            response.put("solutionId", solutionBoard.getId());
            response.put("almFilterId", filterAlmId);
            JSONObject pushJson = new JSONObject();
            try {
                pushJson.put("type", (Object)"Filter");
                pushJson.put("metaMap", (Object)metaMap);
                PushSender.sendMsg((String)pushJson.toString());
            }
            catch (JSONException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            return new ResponseEntity(response, HttpStatus.OK);
        }
        response.put("status", "failure");
        response.put("statusCode", "0");
        response.put("reason", "Filter does't exist.");
        return new ResponseEntity(response, HttpStatus.BAD_REQUEST);
    }

    private void removeFilterItems(ALMFilter almFilter, String solutionId, List<EpicFeature> deletedLinks) {
        HashMap<String, ArrayList<String>> targetMaps = new HashMap<String, ArrayList<String>>();
        HashMap<String, ArrayList<String>> sourceMaps = new HashMap<String, ArrayList<String>>();
        HashMap<String, Item> filterItemMap = new HashMap<String, Item>();
        List items = null;
        items = PropertyValidator.isValid((Object)almFilter.getTfsFilter()) ? this.itemRepository.findByTfsFilterAndSolutionBoardId(almFilter.getTfsFilter().getTfsId(), solutionId) : this.itemRepository.findByJiraFilterAndSolutionBoardId(almFilter.getJiraFilter().getId(), solutionId);
        ArrayList<String> subItemsKeys = new ArrayList<String>();
        if (PropertyValidator.isValid((Collection)items)) {
            for (Item item : items) {
                ArrayList linksIds;
                filterItemMap.put(item.getId(), item);
                if (PropertyValidator.isValid((Collection)item.getSolutionSourceItemLinks())) {
                    for (ItemLink link : item.getSolutionSourceItemLinks()) {
                        linksIds = (ArrayList)targetMaps.get(link.getTargetItemId());
                        if (!PropertyValidator.isValid((Collection)linksIds)) {
                            linksIds = new ArrayList();
                            targetMaps.put(link.getTargetItemId(), linksIds);
                        }
                        linksIds.add(link.getId());
                    }
                }
                if (!PropertyValidator.isValid((Collection)item.getSolutionTargetItemLinks())) continue;
                for (ItemLink link : item.getSolutionTargetItemLinks()) {
                    linksIds = (ArrayList)sourceMaps.get(link.getTargetItemId());
                    if (!PropertyValidator.isValid((Collection)linksIds)) {
                        linksIds = new ArrayList();
                        sourceMaps.put(link.getTargetItemId(), linksIds);
                    }
                    linksIds.add(link.getId());
                }
            }
            for (EpicFeature epicFeature : deletedLinks) {
                if (epicFeature.getSessionId() != null) continue;
                subItemsKeys.add(epicFeature.getFeatureKey());
            }
        }
        ArrayList<String> itemsNotInFilter = new ArrayList<String>();
        HashSet mapsKeys = new HashSet();
        mapsKeys.addAll(targetMaps.keySet());
        for (String key : mapsKeys) {
            if (PropertyValidator.isValid(filterItemMap.get(key))) {
                targetMaps.remove(key);
                continue;
            }
            itemsNotInFilter.add(key);
        }
        mapsKeys = new HashSet();
        mapsKeys.addAll(sourceMaps.keySet());
        for (String key : mapsKeys) {
            if (PropertyValidator.isValid(filterItemMap.get(key))) {
                sourceMaps.remove(key);
                continue;
            }
            itemsNotInFilter.add(key);
        }
        if (PropertyValidator.isValid(itemsNotInFilter)) {
            List otherItems = this.itemRepository.findByIdIn(itemsNotInFilter);
            for (Item item : otherItems) {
                List targetLinkIds;
                List sourceLinkIds = (List)sourceMaps.get(item.getId());
                if (PropertyValidator.isValid((Collection)sourceLinkIds)) {
                    item.setSolutionSourceItemLinks(this.removeLinkFromArrayWithIds(item.getSolutionSourceItemLinks(), sourceLinkIds));
                }
                if (!PropertyValidator.isValid((Collection)(targetLinkIds = (List)targetMaps.get(item.getId())))) continue;
                item.setSolutionTargetItemLinks(this.removeLinkFromArrayWithIds(item.getSolutionTargetItemLinks(), targetLinkIds));
            }
            this.itemRepository.save((Iterable)otherItems);
        }
        List removed = null;
        removed = PropertyValidator.isValid((Object)almFilter.getTfsFilter()) ? this.itemRepository.deleteByTfsFilterAndSolutionBoardIdAndSessionBoardsIsNull(almFilter.getTfsFilter().getTfsId(), solutionId) : this.itemRepository.deleteByJiraFilterAndSolutionBoardIdAndSessionBoardsIsNull(almFilter.getJiraFilter().getId(), solutionId);
        if (PropertyValidator.isValid((Collection)removed)) {
            removed.addAll(this.itemRepository.deleteByJiraKeyInOrTfsIdInAndSolutionBoardIdAndSessionBoardsIsNull(subItemsKeys, subItemsKeys, solutionId));
            this.syncTagsForBacklog(almFilter.getAlmAccount(), removed);
        }
    }

    private void syncTagsForBacklog(AlmAccount alm, List<Item> removed) {
        HashSet<String> idsForArt = new HashSet<String>();
        for (Item item : removed) {
            if (item.getJiraId() != null) {
                idsForArt.add(item.getJiraId());
                continue;
            }
            if (item.getTfsId() == null) continue;
            idsForArt.add(item.getTfsId());
        }
        this.releaseTrainService.syncWithBoards(alm.getTenant(), alm, idsForArt);
    }

    private ArrayList<ItemLink> removeLinkFromArrayWithIds(ArrayList<ItemLink> itemLinks, List<String> linkIds) {
        if (!PropertyValidator.isValid(itemLinks)) {
            return itemLinks;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String id : linkIds) {
            map.put(id, "true");
        }
        for (int i = 0; i < itemLinks.size(); ++i) {
            ItemLink link = itemLinks.get(i);
            if (!PropertyValidator.isValid(map.get(link.getId()))) continue;
            itemLinks.remove(i);
            --i;
        }
        if (itemLinks.isEmpty()) {
            itemLinks = null;
        }
        return itemLinks;
    }

    @RequestMapping(value={"/resync-score"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> resyncScore(@RequestBody HashMap<String, Object> payload) {
        Map idsByFilter = (Map)payload.get("idsByFilter");
        String solBoardId = (String)payload.get("id");
        String requestId = (String)payload.get("requestId");
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return null;
    }

    @RequestMapping(value={"/resync/{solutionId}"})
    @ResponseBody
    public ResponseEntity<Object> resync(@PathVariable(value="solutionId") String solutionId, @RequestBody HashMap<String, Object> payload) {
        String metaMap = (String)payload.get("metaMap");
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return null;
    }

    private boolean isLoggedInCompanyUser(User user) {
        String loggedinCompanyId = UserContextUtil.getUserContext().getCurrentCompany().getId();
        for (UserCompany userCompany : user.getUserCompanies()) {
            if (userCompany.getCompany() == null || !userCompany.getCompany().getId().equals(loggedinCompanyId) || !userCompany.getIsActive().booleanValue()) continue;
            return true;
        }
        return false;
    }

    @RequestMapping(value={"/childList/{id}"})
    @ResponseBody
    public ResponseEntity<?> findStoriesByParentId(@PathVariable(value="id") String id) {
        Item item = this.itemRepository.findById(id);
        String key = "";
        ArrayList<String> keys = new ArrayList<String>();
        key = item.getTfsId() == null ? item.getJiraKey() : item.getTfsId();
        keys.add(key);
        List stories = this.solutionService.fetchChild(keys, item.getSolutionBoard(), true);
        return ResponseEntity.ok((Object)stories);
    }

    @RequestMapping(value={"/changeEpic"})
    @ResponseBody
    public ResponseEntity<Object> changeEpic(@RequestBody HashMap<String, Object> payload) {
        try {
            return ResponseEntity.ok((Object)this.solutionService.changeEpic(payload));
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/removeEpic"})
    @ResponseBody
    public ResponseEntity<Object> removeEpic(@RequestBody HashMap<String, Object> payload) {
        try {
            return ResponseEntity.ok((Object)this.solutionService.removeEpic(payload));
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/addWsjfConfig"})
    @ResponseBody
    public ResponseEntity<Object> addWsjfConfiguration(@RequestBody HashMap<String, Object> payload) {
        String solutionBoardId = (String)payload.get("solutionBoardId");
        String almId = (String)payload.get("almId");
        String almTitle = (String)payload.get("almTitle");
        String wsjfField = (String)payload.get("selectedWsjfField");
        String wsjfFieldForUnplannedFeatures = (String)payload.get("selectedWsjfFieldForUnplannedFeatures");
        String type = (String)payload.get("type");
        boolean applyToAllFlag = (Boolean)payload.get("applyToAllProjects");
        boolean applyToAllFlagForUnplannedFeatures = (Boolean)payload.get("applyToAllProjectsForUnplannedFeatures");
        boolean wsjfAlmEnabled = (Boolean)payload.get("wsjfAlmEnabled");
        HashMap<String, Object> response = new HashMap<String, Object>();
        List tfsProjectIds = null;
        SolutionBoardWsjFAlmConfiguration wsjfConfig = new SolutionBoardWsjFAlmConfiguration();
        SolutionBoard solutionBoard = this.solutionBoardRepository.findByIdIn(solutionBoardId);
        boolean isObjectPresent = false;
        if (PropertyValidator.isValid((Object)solutionBoard)) {
            ArrayList<SolutionBoardWsjFAlmConfiguration> wsjfConfigList = null;
            wsjfConfigList = (ArrayList<SolutionBoardWsjFAlmConfiguration>)solutionBoard.getSolutionBoardWsjFAlmConfiguration();
            if (PropertyValidator.isValid((Collection)wsjfConfigList)) {
                for (SolutionBoardWsjFAlmConfiguration obj : wsjfConfigList) {
                    if (!obj.getAlmId().equals(almId)) continue;
                    obj.setAlmTitle(almTitle);
                    obj.setAlmId(almId);
                    obj.setAlmField(wsjfField);
                    obj.setAlmFieldForUnplannedFeatures(wsjfFieldForUnplannedFeatures);
                    obj.setApplyToAll(applyToAllFlag);
                    obj.setApplyToAllForUnplannedFeatures(applyToAllFlagForUnplannedFeatures);
                    obj.setType(type);
                    obj.setWsjfAlmEnabled(wsjfAlmEnabled);
                    isObjectPresent = true;
                    response.put("wsjfConfig", obj);
                }
            } else {
                wsjfConfigList = new ArrayList<SolutionBoardWsjFAlmConfiguration>();
            }
            if (!isObjectPresent) {
                wsjfConfig.setAlmTitle(almTitle);
                wsjfConfig.setAlmId(almId);
                wsjfConfig.setAlmField(wsjfField);
                wsjfConfig.setAlmFieldForUnplannedFeatures(wsjfFieldForUnplannedFeatures);
                wsjfConfig.setApplyToAll(applyToAllFlag);
                wsjfConfig.setApplyToAllForUnplannedFeatures(applyToAllFlagForUnplannedFeatures);
                wsjfConfig.setType(type);
                wsjfConfig.setWsjfAlmEnabled(wsjfAlmEnabled);
                wsjfConfigList.add(wsjfConfig);
                response.put("wsjfConfig", wsjfConfig);
            }
            solutionBoard.setSolutionBoardWsjFAlmConfiguration(wsjfConfigList);
            if (!PropertyValidator.isValid((Object)solutionBoard.getScoreCard())) {
                ScoreCard savedScoreCard = this.scoreCardRepository.findByType(ScoreCard.Type.WSJF.toString());
                solutionBoard.setScoreCard(savedScoreCard);
            }
            if ((applyToAllFlag || applyToAllFlagForUnplannedFeatures) && type.equals("tfs")) {
                tfsProjectIds = this.setWsjfFieldForSolutionBoardTfsProjects(solutionBoardId, almId, wsjfField, wsjfFieldForUnplannedFeatures, Boolean.valueOf(applyToAllFlag), Boolean.valueOf(applyToAllFlagForUnplannedFeatures));
            } else if ((applyToAllFlag || applyToAllFlagForUnplannedFeatures) && type.equals("jira")) {
                this.setWsjfFieldForSolutionBoardJiraProjects(solutionBoard, almId, wsjfField, wsjfFieldForUnplannedFeatures, Boolean.valueOf(applyToAllFlag), Boolean.valueOf(applyToAllFlagForUnplannedFeatures));
            }
            solutionBoard = (SolutionBoard)this.solutionBoardRepository.save((Object)solutionBoard);
            response.put("wsjfAlmEnabled", wsjfAlmEnabled);
            response.put("tfsProjectIds", tfsProjectIds);
            return new ResponseEntity(response, HttpStatus.OK);
        }
        return new ResponseEntity(null, HttpStatus.OK);
    }

    public List<String> setWsjfFieldForSolutionBoardJiraProjects(SolutionBoard solutionBoard, String almId, String wsjfField, String wsjfFieldForUnplannedFeatures, Boolean applyToAllFlag, Boolean applyToAllFlagForUnplannedFeatures) {
        solutionBoard.getAlmFilters().forEach(obj -> {
            if (obj.getAlmAccount().getId().equals(almId)) {
                List featureLinkMappings = obj.getJiraFilter().getFeatureLinkMappings();
                featureLinkMappings.forEach(linkMap -> {
                    if (applyToAllFlag.booleanValue() && applyToAllFlagForUnplannedFeatures.booleanValue()) {
                        linkMap.setWsjfProjectField(wsjfField);
                        linkMap.setWsjfProjectFieldForUnplannedFeatures(wsjfFieldForUnplannedFeatures);
                    } else if (applyToAllFlag.booleanValue() && !applyToAllFlagForUnplannedFeatures.booleanValue()) {
                        linkMap.setWsjfProjectField(wsjfField);
                    } else if (!applyToAllFlag.booleanValue() && applyToAllFlagForUnplannedFeatures.booleanValue()) {
                        linkMap.setWsjfProjectFieldForUnplannedFeatures(wsjfFieldForUnplannedFeatures);
                    }
                });
            }
        });
        return null;
    }

    public List<String> setWsjfFieldForSolutionBoardTfsProjects(String solutionBoardId, String almId, String wsjfField, String wsjfFieldForUnplannedFeatures, Boolean applyToAllFlag, Boolean applyToAllFlagForUnplannedFeatures) {
        ArrayList<String> tfsProjectIds = new ArrayList<String>();
        List tfsProjects = this.tfsProjectRepository.findBySolutionIdAndAlmAccountId(solutionBoardId, almId);
        tfsProjects.forEach(project -> {
            if (applyToAllFlag.booleanValue() && applyToAllFlagForUnplannedFeatures.booleanValue()) {
                project.setWsjfAlmField(wsjfField);
                project.setWsjfAlmFieldForUnplannedFeatures(wsjfFieldForUnplannedFeatures);
            } else if (applyToAllFlag.booleanValue() && !applyToAllFlagForUnplannedFeatures.booleanValue()) {
                project.setWsjfAlmField(wsjfField);
            } else if (!applyToAllFlag.booleanValue() && applyToAllFlagForUnplannedFeatures.booleanValue()) {
                project.setWsjfAlmFieldForUnplannedFeatures(wsjfFieldForUnplannedFeatures);
            }
            tfsProjectIds.add(project.getId());
        });
        this.tfsProjectRepository.save((Iterable)tfsProjects);
        return tfsProjectIds;
    }

    @RequestMapping(value={"/toggleWsjf"})
    @ResponseBody
    public ResponseEntity<Object> toggleWsjf(@RequestBody HashMap<String, Object> payload) {
        String solutionBoardId = (String)payload.get("solutionBoardId");
        boolean enableWsjf = (Boolean)payload.get("wsjf");
        SolutionBoard solutionBoard = this.solutionBoardRepository.findByIdIn(solutionBoardId);
        if (!enableWsjf && PropertyValidator.isValid((Collection)solutionBoard.getSolutionBoardWsjFAlmConfiguration())) {
            solutionBoard.setSolutionBoardWsjFAlmConfiguration(null);
        }
        solutionBoard.setWsjfEnabled(Boolean.valueOf(enableWsjf));
        this.solutionBoardRepository.save((Object)solutionBoard);
        return new ResponseEntity((Object)enableWsjf, HttpStatus.OK);
    }

    @RequestMapping(value={"/getJiraFields"})
    @ResponseBody
    public ResponseEntity<Object> getJiraFields(@RequestBody HashMap<String, Object> payload) {
        String almAccountIds = (String)payload.get("almAccountIds");
        String[] almAccountIdArr = null;
        HashMap response = new HashMap();
        almAccountIdArr = almAccountIds.split(",");
        HashMap<String, String> jiraFieldsMappedById = new HashMap<String, String>();
        for (String almId : almAccountIdArr) {
            AlmAccount almAccount = AlmUtils.getALMAcount((String)almId, (AlmAccountRepository)this.almAccountRepository);
            if (!PropertyValidator.isValid((Object)almAccount)) continue;
            String jiraFields = this.almSyncService.retrieveJiraFieldsJSON(almAccount, false);
            jiraFieldsMappedById.put(almId, jiraFields);
        }
        response.put("jiraFieldsMappedById", jiraFieldsMappedById);
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/save-item"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveEpic(@RequestBody Item item) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            Item savedItem = (Item)this.itemRepository.save((Object)item);
            responseJson.put("item", savedItem);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            System.out.print(e);
            responseJson.put("Error", true);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
    }

    @RequestMapping(value={"/link-features"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> linkFeatures(@RequestBody Map<String, Object> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            String inputEpicFeatures = (String)requestBody.get("newEpicFeatures");
            ObjectMapper map = new ObjectMapper();
            List epicFeatures = null;
            try {
                if (PropertyValidator.isValid((Object)inputEpicFeatures)) {
                    epicFeatures = (List)map.readValue(inputEpicFeatures, (JavaType)map.getTypeFactory().constructCollectionType(List.class, EpicFeature.class));
                }
            }
            catch (IOException e) {
                LOGGER.debug(e.getMessage());
            }
            List toDeleteEpicFeatures = (List)requestBody.get("toDeleteEpicFeatures");
            List savedEpicFeatures = this.epicFeaturesRepository.save((Iterable)epicFeatures);
            this.epicFeaturesRepository.deleteByIdIn(toDeleteEpicFeatures);
            responseJson.put("item", savedEpicFeatures);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            System.out.print(e);
            responseJson.put("Error", true);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
    }

    @RequestMapping(value={"/get-item-status"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> itemStatus(@RequestBody List<String> itemIds) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (PropertyValidator.isValid(itemIds)) {
            List items = this.itemRepository.findByIdIn(itemIds);
            HashMap<String, Status> itemStatusMap = new HashMap<String, Status>();
            for (Item item : items) {
                itemStatusMap.put(item.getId(), item.getStatus());
            }
            responseJson.put("itemStatuses", itemStatusMap);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        responseJson.put("error", true);
        responseJson.put("reason", "Invalid Item IDs");
        return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/get-dependencies-export"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> exportFeatureDependencies(@RequestBody Map<String, Object> requestBody) {
        HashMap<String, String> response = new HashMap<String, String>();
        try {
            Map<String, Object> responseJson = new HashMap();
            ArrayList boards = (ArrayList)requestBody.get("boards");
            ArrayList depData = (ArrayList)requestBody.get("depData");
            responseJson = this.customRepository.calculateDataForFeatureDependenciesByFeatureTab(depData, boards);
            responseJson.put("boards", boards);
            responseJson.put("solutionBoardTitle", requestBody.get("solutionBoardTitle"));
            String filePath = this.exportService.exportSolutionFeatureDepExcel(responseJson);
            String cleanedSessionTitle = AlmUtils.cleanText((String)"Feature Dependencies");
            String downloadName = AlmUtils.cleanText((String)cleanedSessionTitle) + ".xlsx";
            response.put("srcPath", filePath);
            response.put("name", URLEncoder.encode(downloadName, "UTF-8"));
        }
        catch (Exception e1) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e1));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/save-bulk/links"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveBulkLinks(@RequestBody Map map) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            this.tfSservice.saveBulkLinks(map);
            result.put("message", "success");
        }
        catch (ViztrendJiraException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            result.put("message", e.getMessage());
            return new ResponseEntity(result, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            result.put("message", e.getMessage());
            String solutionBoardId = (String)map.get("solutionBoardId");
            this.customRepositoryImpl.removeSolutionBoardLock(solutionBoardId, EnumKendis.DEPENDENCY.getCode());
            return new ResponseEntity(result, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/solutionBoards/search"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> solutionBoardsSearch(@RequestBody HashMap<String, Object> reqbody) {
        try {
            SecureUser secureUser = UserContextUtil.getUserContext();
            String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
            String searchQuery = (String)reqbody.get("query");
            Map result = this.solutionService.searchSolutionBoards(searchQuery, tenant);
            if (((Boolean)result.get("success")).booleanValue()) {
                return new ResponseEntity((Object)result, HttpStatus.OK);
            }
            return new ResponseEntity((Object)result, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            LOGGER.error("Error in solutionBoardsSearch controller: ", (Object)StringUtils.getTraceString((Throwable)e));
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("error", "Internal server error");
            return new ResponseEntity(errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    static /* synthetic */ TFSservice access$000(SolutionController x0) {
        return x0.tfSservice;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    static /* synthetic */ ALMSyncService access$200(SolutionController x0) {
        return x0.almSyncService;
    }

    static /* synthetic */ SolutionService access$300(SolutionController x0) {
        return x0.solutionService;
    }

    static /* synthetic */ PushResponseRepository access$400(SolutionController x0) {
        return x0.pushResponseRepository;
    }

    static /* synthetic */ AppConfig.MongoConfig access$500(SolutionController x0) {
        return x0.mongoConfig;
    }

    static /* synthetic */ SolutionBoardRepository access$600(SolutionController x0) {
        return x0.solutionBoardRepository;
    }

    static /* synthetic */ HashMap access$700(SolutionController x0, String x1, String x2, String x3, AlmAccount x4) throws JSONException {
        return x0.getTfsQueryDetails(x1, x2, x3, x4);
    }

    static /* synthetic */ ItemLinkRepository access$800(SolutionController x0) {
        return x0.itemLinkRepository;
    }

    static /* synthetic */ void access$900(SolutionController x0, List x1, String x2, List x3) {
        x0.removeItemLinksFromItems(x1, x2, x3);
    }
}

