/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.viztrend.safe.alm.jira.bo.JiraIssue;
import com.viztrend.safe.alm.jira.bo.JiraVersion;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ReleaseTemplate;
import com.viztrend.safe.persistence.entity.ReleaseTemplateItem;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.State;
import com.viztrend.safe.persistence.entity.StateScheme;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.roadmap.Roadmap;
import com.viztrend.safe.persistence.entity.roadmap.RoadmapItem;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.ContainerRepository;
import com.viztrend.safe.persistence.repository.JiraIssueRepository;
import com.viztrend.safe.persistence.repository.ReleaseTemplateItemRepository;
import com.viztrend.safe.persistence.repository.ReleaseTemplateRepository;
import com.viztrend.safe.persistence.repository.RoadmapItemRepository;
import com.viztrend.safe.persistence.repository.RoadmapRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.StateRepository;
import com.viztrend.safe.persistence.repository.StateSchemeRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.ALMSyncServiceImpl;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/roadmaps"})
@Controller
public class RoadmapsController {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private RoadmapRepository roadmapRepository;
    @Autowired
    private RoadmapItemRepository roadmapItemRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private StateRepository stateRepository;
    @Autowired
    private StateSchemeRepository stateSchemeRepository;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private ALMSyncServiceImpl almSyncServiceImpl;
    @Autowired
    private JiraIssueRepository jiraIssueRepository;
    @Autowired
    private ReleaseTemplateRepository releaseTemplateRepository;
    @Autowired
    private ReleaseTemplateItemRepository releaseTemplateItemRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(RoadmapsController.class);

    @RequestMapping(value={"/meta"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getMeta() {
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        User user = UserContextUtil.getUserContext().getLoggedInUser();
        HashMap<String, Object> meta = new HashMap<String, Object>();
        Query query = new Query();
        query.with(new Sort(Sort.Direction.ASC, new String[]{"updatedOn"}));
        meta.put("roadmaps", this.mongoTemplate.find(query, Roadmap.class));
        meta.put("cid", cid);
        meta.put("user", user);
        return new ResponseEntity(meta, HttpStatus.OK);
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> save(@RequestBody Roadmap roadmap) {
        roadmap = (Roadmap)this.roadmapRepository.save((Object)roadmap);
        return new ResponseEntity((Object)roadmap, HttpStatus.OK);
    }

    @RequestMapping(value={"/delete/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Object> deleteRoadmap(@PathVariable(value="id") String id) {
        if (PropertyValidator.isValid((Object)id)) {
            Roadmap roadmap = (Roadmap)this.roadmapRepository.findOne((Serializable)((Object)id));
            if (roadmap.getType() == Roadmap.Type.CROSS_PROJECT_RELEASES || roadmap.getType() == Roadmap.Type.CUSTOM) {
                List items = this.roadmapItemRepository.findByRoadmap(roadmap);
                this.roadmapItemRepository.delete((Iterable)items);
            }
            this.roadmapRepository.delete((Serializable)((Object)id));
            return new ResponseEntity((Object)id, HttpStatus.OK);
        }
        return new ResponseEntity(null, HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/newRoadmapMeta"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getNewRoadmapMeta(@RequestBody Roadmap roadmap) {
        HashMap<String, List> meta = new HashMap<String, List>();
        if (roadmap.getType() == Roadmap.Type.KENDIS_PI_BOARDS) {
            meta.put("boards", this.sessionRepository.findAll());
        }
        return new ResponseEntity(meta, HttpStatus.OK);
    }

    @RequestMapping(value={"/getRoadmapItems/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getRoadmapItems(@PathVariable String id) {
        Roadmap roadmap = (Roadmap)this.roadmapRepository.findOne((Serializable)((Object)id));
        ArrayList parents = new ArrayList();
        HashMap reponseMap = new HashMap();
        if (roadmap.getType() == Roadmap.Type.CUSTOM || roadmap.getType() == Roadmap.Type.CROSS_PROJECT_RELEASES) {
            List items = this.roadmapItemRepository.findByRoadmapOrderByLevel(roadmap);
            parents.addAll(items);
            if (roadmap.getType() == Roadmap.Type.CROSS_PROJECT_RELEASES) {
                items.forEach(item -> {
                    if (item.getLevel() == 1 && PropertyValidator.isValid((Object)item.getLinkedId())) {
                        ArrayList issues = this.jiraIssueRepository.findByVersionIdAndRoadmapItemId(item.getLinkedId(), item.getId());
                        item.setJiraIssues(issues);
                    }
                });
            }
        } else if (roadmap.getType() == Roadmap.Type.KENDIS_PI_BOARDS) {
            ArrayList ids = null;
            Object boards = roadmap.getFilters().get("boards");
            if (boards != null) {
                ids = (ArrayList)boards;
            }
            if (ids != null && ids.size() > 0) {
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").in((Collection)ids));
                List items = this.mongoTemplate.find(query, Session.class);
                List parentBoards = this.sessionBoardRepository.findBySessionInAndParentBoardIsNullOrderByCreatedOnDesc(items);
                parents.addAll(parentBoards);
                ArrayList sids = new ArrayList();
                parentBoards.forEach(board -> sids.add(board.getId()));
                List phases = this.roadmapItemRepository.findByRoadmapAndPiIdIn(roadmap, sids);
                reponseMap.put("phases", phases);
            }
            List workspaces = this.workSpaceRepository.findByIsModuleIsFalseOrIsModuleIsNull();
            reponseMap.put("workspaces", workspaces);
        }
        reponseMap.put("parents", parents);
        reponseMap.put("roadmap", roadmap);
        return new ResponseEntity(reponseMap, HttpStatus.OK);
    }

    @RequestMapping(value={"/container/save/{sessionBoardId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveContainer(@RequestBody Container container, @PathVariable String sessionBoardId) {
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
        Boolean isNewItem = false;
        if (container.getId() == null) {
            isNewItem = true;
        }
        Container _container = (Container)this.containerRepository.save((Object)container);
        Boolean updateParent = false;
        if (isNewItem.booleanValue()) {
            ArrayList<Container> containers = (ArrayList<Container>)sessionBoard.getContainers();
            if (containers == null) {
                containers = new ArrayList<Container>();
            }
            containers.add(_container);
            sessionBoard.setContainers(containers);
            this.sessionBoardRepository.save((Object)sessionBoard);
        }
        HashMap<String, Object> reponse = new HashMap<String, Object>();
        reponse.put("container", _container);
        reponse.put("sessionBoard", sessionBoard);
        return new ResponseEntity(reponse, HttpStatus.OK);
    }

    @RequestMapping(value={"/roadmapitem/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveRoadmapItem(@RequestBody RoadmapItem roadmapItem) {
        HashMap<String, ArrayList<Object>> response = new HashMap<String, ArrayList<Object>>();
        if (PropertyValidator.isValid((Object)roadmapItem)) {
            RoadmapItem item;
            Boolean updateParent = false;
            RoadmapItem parent = null;
            if (roadmapItem.getId() == null) {
                if (PropertyValidator.isValid((Object)roadmapItem.getParent())) {
                    parent = (RoadmapItem)this.roadmapItemRepository.findOne((Serializable)((Object)roadmapItem.getParent().getId()));
                    parent.setChildsCount(parent.getChildsCount() + 1);
                    updateParent = true;
                }
                ReleaseTemplate releaseTemplate = null;
                if (PropertyValidator.isValid((Object)roadmapItem.getType()) && roadmapItem.getType().equals((Object)RoadmapItem.Type.RELEASE) && PropertyValidator.isValid((Object)roadmapItem.getReleaseTemplateId())) {
                    releaseTemplate = (ReleaseTemplate)this.releaseTemplateRepository.findOne((Serializable)((Object)roadmapItem.getReleaseTemplateId()));
                    roadmapItem.setChildsCount(releaseTemplate.getPhases().size());
                }
                ArrayList<RoadmapItem> childs = roadmapItem.getChilds();
                roadmapItem.setChilds(null);
                item = (RoadmapItem)this.roadmapItemRepository.save((Object)roadmapItem);
                if (PropertyValidator.isValid((Collection)childs)) {
                    childs.forEach(child -> {
                        child.setParent(item);
                        if (PropertyValidator.isValid((Object)child.getLinkedId())) {
                            String almId = (String)child.getLinkedItem().get("almId");
                            AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId));
                            ArrayList jiraIssues = this.loadAndSaveJiraVersionContent(almAccount, child.getLinkedId(), item.getId());
                            child.setJiraIssues(jiraIssues);
                        }
                    });
                    this.roadmapItemRepository.save((Iterable)childs);
                }
                if (releaseTemplate != null) {
                    ArrayList phases = releaseTemplate.createPhaseWith(item.getStartDate(), item.getEndDate());
                    for (int i = 0; i < phases.size(); ++i) {
                        RoadmapItem phase = (RoadmapItem)phases.get(i);
                        phase.setParent(item);
                        phase.setRoadmap(item.getRoadmap());
                        phase.setLevel(2);
                    }
                    this.roadmapItemRepository.save((Iterable)phases);
                    if (childs == null) {
                        childs = new ArrayList<RoadmapItem>();
                    }
                    childs.addAll(phases);
                }
                response.put("childs", childs);
            } else {
                item = (RoadmapItem)this.roadmapItemRepository.save((Object)roadmapItem);
            }
            if (PropertyValidator.isValid((Object)roadmapItem.getParent())) {
                // empty if block
            }
            if (parent != null && updateParent.booleanValue()) {
                this.roadmapItemRepository.save((Object)parent);
            }
            if (item.getLinkedId() != null && item.getLinkedType().equals("JiraVersion")) {
                JiraVersion version = new JiraVersion();
                version.setJiraId(item.getLinkedId());
                version.setId(item.getLinkedId());
                version.setProjectId((String)item.getLinkedItem().get("projectId"));
                version.setProjectKey((String)item.getLinkedItem().get("projectKey"));
                SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");
                if (item.getStartDate() != null) {
                    version.setStartDate(formater.format(item.getStartDate()));
                }
                if (item.getEndDate() != null) {
                    version.setReleaseDate(formater.format(item.getEndDate()));
                }
                version.setName(item.getTitle());
                String almId = (String)item.getLinkedItem().get("almId");
                AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId));
                this.almSyncServiceImpl.updateJiraVersion(version, almAccount);
            }
            response.put("item", (ArrayList<Object>)item);
            return new ResponseEntity(response, HttpStatus.OK);
        }
        return new ResponseEntity(response, HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/roadmapitem/bulkSave"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveRoadmapItems(@RequestBody List<RoadmapItem> roadmapItems) {
        roadmapItems = this.roadmapItemRepository.save(roadmapItems);
        return new ResponseEntity((Object)roadmapItems, HttpStatus.OK);
    }

    @RequestMapping(value={"/sessionBoard/save/{roadmapId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveSessionBoard(@RequestBody SessionBoard sessionBoard, @PathVariable String roadmapId) {
        Session session = sessionBoard.getSession();
        Boolean isNewItem = false;
        if (session.getId() == null) {
            isNewItem = true;
            List statesSchemes = this.stateSchemeRepository.findAll();
            if (statesSchemes.size() > 0) {
                List states = this.stateRepository.findByStateScheme((StateScheme)statesSchemes.get(0));
                if (states.size() > 0) {
                    sessionBoard.setState((State)states.get(0));
                }
                session.setStateScheme((StateScheme)statesSchemes.get(0));
            }
        }
        Session _session = (Session)this.sessionRepository.save((Object)session);
        sessionBoard.setSession(_session);
        SessionBoard newSessionBoard = (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard);
        Roadmap roadmap = (Roadmap)this.roadmapRepository.findOne((Serializable)((Object)roadmapId));
        if (isNewItem.booleanValue()) {
            ArrayList<String> boards = (ArrayList<String>)roadmap.getFilters().get("boards");
            if (boards == null) {
                boards = new ArrayList<String>();
            }
            boards.add(session.getId());
            roadmap.getFilters().put("boards", boards);
            this.roadmapRepository.save((Object)roadmap);
        }
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put("roadmap", roadmap);
        meta.put("sessionBoard", newSessionBoard);
        return new ResponseEntity(meta, HttpStatus.OK);
    }

    @RequestMapping(value={"/roadmapitem/delete/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Object> deleteRoadmapItem(@PathVariable(value="id") String id) {
        if (PropertyValidator.isValid((Object)id)) {
            RoadmapItem item = (RoadmapItem)this.roadmapItemRepository.findOne((Serializable)((Object)id));
            if (PropertyValidator.isValid((Object)item.getParent())) {
                RoadmapItem parent = (RoadmapItem)this.roadmapItemRepository.findOne((Serializable)((Object)item.getParent().getId()));
                parent.setChildsCount(parent.getChildsCount() - 1);
            }
            ArrayList<RoadmapItem> items = new ArrayList<RoadmapItem>();
            items.add(item);
            if (item.getChildsCount() > 0) {
                List childs = this.roadmapItemRepository.findByParentId(item.getId());
                items.addAll(childs);
            }
            if (item.getLevel() == 1 && PropertyValidator.isValid((Object)item.getLinkedId())) {
                this.jiraIssueRepository.deleteByVersionIdAndRoadmapItemId(item.getLinkedId(), item.getId());
            }
            this.roadmapItemRepository.delete(items);
            return new ResponseEntity((Object)id, HttpStatus.OK);
        }
        return new ResponseEntity(null, HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/roadmapitem/details/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getRoadmapItemDetails(@PathVariable(value="id") String id) {
        HashMap<String, List> meta = new HashMap<String, List>();
        List childs = this.roadmapItemRepository.findByParentId(id);
        meta.put("childs", childs);
        return new ResponseEntity(meta, HttpStatus.OK);
    }

    @RequestMapping(value={"/roadmapitem/session/update"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateSession(@RequestBody Session session) {
        Session updatedSession = (Session)this.sessionRepository.save((Object)session);
        return new ResponseEntity((Object)updatedSession, HttpStatus.OK);
    }

    @RequestMapping(value={"/jiraProjects"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> loadJiraProject(@RequestBody AlmAccount almAccount) {
        return new ResponseEntity((Object)this.almSyncServiceImpl.retrieveJiraProjectList(almAccount), HttpStatus.OK);
    }

    @RequestMapping(value={"/jiraProjectVersions/{prokectKey}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> jiraProjectVersions(@RequestBody AlmAccount almAccount, @PathVariable(value="prokectKey") String projectKey) {
        List versions = this.almSyncServiceImpl.retrieveJiraVersions(projectKey, almAccount);
        return new ResponseEntity((Object)versions, HttpStatus.OK);
    }

    @RequestMapping(value={"/roadmapitem/linkItem/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> linkRoadmapItem(@RequestBody HashMap<String, Object> linkedItemInfo, @PathVariable(value="id") String id) {
        RoadmapItem item = (RoadmapItem)this.roadmapItemRepository.findOne((Serializable)((Object)id));
        item.setLinkedId((String)linkedItemInfo.get("id"));
        item.setLinkedType((String)linkedItemInfo.get("type"));
        HashMap linkedItem = (HashMap)linkedItemInfo.get("item");
        item.setLinkedItem(linkedItem);
        String startDateStr = (String)linkedItem.get("startDate");
        String endDateStr = (String)linkedItem.get("endDate");
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = new SimpleDateFormat("yyyy-MM-dd").parse(startDateStr);
        }
        catch (ParseException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        try {
            endDate = new SimpleDateFormat("yyyy-MM-dd").parse(endDateStr);
        }
        catch (ParseException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        if (endDate != null) {
            endDate.setSeconds(endDate.getSeconds() + 86399);
        }
        item.setStartDate(startDate);
        item.setEndDate(endDate);
        item.setTitle((String)linkedItem.get("title"));
        if (PropertyValidator.isValid((Object)item.getParent())) {
            // empty if block
        }
        item = (RoadmapItem)this.roadmapItemRepository.save((Object)item);
        String almId = (String)linkedItem.get("almId");
        AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId));
        ArrayList jiraIssues = this.loadAndSaveJiraVersionContent(almAccount, (String)linkedItemInfo.get("id"), id);
        item.setJiraIssues(jiraIssues);
        return new ResponseEntity((Object)item, HttpStatus.OK);
    }

    @RequestMapping(value={"/roadmapitem/resyncLinkItem"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> resyncLinkRoadmapItem(@RequestBody RoadmapItem item) {
        AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)((String)item.getLinkedItem().get("almId"))));
        try {
            JiraVersion version = this.almSyncServiceImpl.retrieveJiraVersion(item.getLinkedId(), almAccount);
            String startDateStr = version.getStartDate();
            String endDateStr = version.getReleaseDate();
            Date startDate = null;
            Date endDate = null;
            try {
                startDate = new SimpleDateFormat("yyyy-MM-dd").parse(startDateStr);
            }
            catch (ParseException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            try {
                endDate = new SimpleDateFormat("yyyy-MM-dd").parse(endDateStr);
            }
            catch (ParseException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            if (endDate != null) {
                endDate.setSeconds(endDate.getSeconds() + 86399);
            }
            item.setStartDate(startDate);
            item.setEndDate(endDate);
            item.setTitle(version.getName());
            item.getLinkedItem().put("startDate", version.getStartDate());
            item.getLinkedItem().put("endDate", version.getReleaseDate());
            item.getLinkedItem().put("title", version.getName());
            if (PropertyValidator.isValid((Object)item.getParent())) {
                boolean updateParent = false;
                RoadmapItem parent = (RoadmapItem)this.roadmapItemRepository.findOne((Serializable)((Object)item.getParent().getId()));
                if (startDate != null && item.getStartDate().before(parent.getStartDate())) {
                    parent.setStartDate(item.getStartDate());
                    updateParent = true;
                }
                if (endDate != null && item.getEndDate().after(parent.getEndDate())) {
                    parent.setEndDate(item.getEndDate());
                    updateParent = true;
                }
                if (updateParent) {
                    this.roadmapItemRepository.save((Object)parent);
                }
            }
            item = (RoadmapItem)this.roadmapItemRepository.save((Object)item);
            return new ResponseEntity((Object)item, HttpStatus.OK);
        }
        catch (Exception exception) {
            return new ResponseEntity((Object)item, HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/roadmapitem/removeLink/{id}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<Object> removeLinkRoadmapItem(@PathVariable(value="id") String id) {
        RoadmapItem item = (RoadmapItem)this.roadmapItemRepository.findOne((Serializable)((Object)id));
        if (PropertyValidator.isValid((Object)item.getLinkedId())) {
            this.jiraIssueRepository.deleteByVersionIdAndRoadmapItemId(item.getLinkedId(), item.getId());
            item.setLinkedId(null);
            item.setLinkedType(null);
            item.setLinkedItem(null);
            this.roadmapItemRepository.save((Object)item);
        }
        return new ResponseEntity((Object)item, HttpStatus.OK);
    }

    @RequestMapping(value={"/releaseTemplates"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getReleaseTemplates() {
        List item = this.releaseTemplateRepository.findAll();
        return new ResponseEntity((Object)item, HttpStatus.OK);
    }

    @RequestMapping(value={"/releaseTemplates/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveReleaseTemplates(@RequestBody ReleaseTemplate releaseTemplate) {
        List phases = this.releaseTemplateItemRepository.save((Iterable)releaseTemplate.getPhases());
        ArrayList _phases = new ArrayList();
        _phases.addAll(phases);
        releaseTemplate.setPhases(_phases);
        releaseTemplate = (ReleaseTemplate)this.releaseTemplateRepository.save((Object)releaseTemplate);
        return new ResponseEntity((Object)releaseTemplate, HttpStatus.OK);
    }

    @RequestMapping(value={"/releaseTemplates/delete/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Object> deleteReleaseTemplates(@PathVariable(value="id") String id) {
        ReleaseTemplate releaseTemplate = (ReleaseTemplate)this.releaseTemplateRepository.findOne((Serializable)((Object)id));
        this.releaseTemplateItemRepository.delete((Iterable)releaseTemplate.getPhases());
        this.releaseTemplateRepository.delete((Object)releaseTemplate);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("id", id);
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/releasePhase/delete/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Object> deleteReleasePhase(@PathVariable(value="id") String id, @RequestBody ReleaseTemplate releaseTemplate) {
        HashMap response = new HashMap();
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/releasePhase/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveReleasePhase(@RequestBody ReleaseTemplateItem releaseTemplateItem) {
        releaseTemplateItem = (ReleaseTemplateItem)this.releaseTemplateItemRepository.save((Object)releaseTemplateItem);
        return new ResponseEntity((Object)releaseTemplateItem, HttpStatus.OK);
    }

    @RequestMapping(value={"/roadmapitem/boardItem/{query}/{sessionBoardId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> searchBoardFeatures(@PathVariable(value="query") String searchQuery, @PathVariable(value="sessionBoardId") String sessionBoardId) {
        String options = "i";
        String pattern = searchQuery;
        Criteria searchCriteria = new Criteria();
        if (PropertyValidator.isValid((Object)searchQuery)) {
            searchCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"title").regex(pattern, options), Criteria.where((String)"jiraKey").regex(pattern, options)});
        }
        Criteria sessionCriteria = Criteria.where((String)"sessionBoards.$id").is((Object)sessionBoardId);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)sessionCriteria);
        query.addCriteria((CriteriaDefinition)searchCriteria);
        List items = this.mongoTemplate.find(query, Item.class);
        return new ResponseEntity((Object)items, HttpStatus.OK);
    }

    @RequestMapping(value={"/roadmapitem/boardItem/{sessionBoardId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> loadBoardFeatures(@PathVariable(value="sessionBoardId") String sessionBoardId) {
        HashMap<String, List> response = new HashMap<String, List>();
        Criteria sessionCriteria = Criteria.where((String)"sessionBoards.$id").is((Object)new ObjectId(sessionBoardId));
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)sessionCriteria);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)Item.FEATURE));
        List items = this.mongoTemplate.find(query, Item.class);
        response.put("features", items);
        query = new Query();
        query.addCriteria((CriteriaDefinition)sessionCriteria);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)Item.USER_STORY));
        items = this.mongoTemplate.find(query, Item.class);
        response.put("childs", items);
        return new ResponseEntity(response, HttpStatus.OK);
    }

    private ArrayList<JiraIssue> loadAndSaveJiraVersionContent(AlmAccount almAccount, String versionId, String roadmapItemId) {
        ArrayList jiraItems = this.almSyncServiceImpl.retrieveAndSaveVersionData(almAccount, versionId);
        jiraItems.forEach(item -> {
            item.setVersionId(versionId);
            item.setRoadmapItemId(roadmapItemId);
        });
        this.jiraIssueRepository.save((Iterable)jiraItems);
        return jiraItems;
    }

    private Date normalizeDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(10, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }
}

