/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.pusher.rest.Pusher;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.jira.ExportUtil;
import com.viztrend.safe.alm.jira.ImportUtil;
import com.viztrend.safe.alm.jira.JiraUtils;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.alm.jira.bo.JiraFilter;
import com.viztrend.safe.alm.jira.bo.JiraProject;
import com.viztrend.safe.annotations.SchedLock;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.controller.HealthController;
import com.viztrend.safe.controller.RestController;
import com.viztrend.safe.init.TFSOauth2Filter;
import com.viztrend.safe.persistence.entity.AlmAccUser;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.AlmError;
import com.viztrend.safe.persistence.entity.AppInitConfig;
import com.viztrend.safe.persistence.entity.AuditLog;
import com.viztrend.safe.persistence.entity.AzureOAuthToken;
import com.viztrend.safe.persistence.entity.BacklogMappingLinks;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.Customize;
import com.viztrend.safe.persistence.entity.ExternalLinks;
import com.viztrend.safe.persistence.entity.Group;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.JiraOauthToken;
import com.viztrend.safe.persistence.entity.JiraProjectIssueTypes;
import com.viztrend.safe.persistence.entity.KendisStats;
import com.viztrend.safe.persistence.entity.Objective;
import com.viztrend.safe.persistence.entity.ObjectiveValue;
import com.viztrend.safe.persistence.entity.PasswordHistory;
import com.viztrend.safe.persistence.entity.PaymentPackageConfig;
import com.viztrend.safe.persistence.entity.PiContainerCapacity;
import com.viztrend.safe.persistence.entity.PiJourney;
import com.viztrend.safe.persistence.entity.PiTeamCapacity;
import com.viztrend.safe.persistence.entity.PrivacyStatement;
import com.viztrend.safe.persistence.entity.PushResponse;
import com.viztrend.safe.persistence.entity.ServerCache;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamSprintVelocity;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.AlmConfigurationsRepository;
import com.viztrend.safe.persistence.repository.AppInitConfigRepository;
import com.viztrend.safe.persistence.repository.AuditLogRepository;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.ContainerRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.ExternalLinksRepository;
import com.viztrend.safe.persistence.repository.GroupRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.JiraProjectIssueTypesRepository;
import com.viztrend.safe.persistence.repository.KendisStatsRepository;
import com.viztrend.safe.persistence.repository.PiTeamCapacityRepository;
import com.viztrend.safe.persistence.repository.PrivacyStatementRepository;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.RoleRepository;
import com.viztrend.safe.persistence.repository.ServerCacheRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.StateRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TeamRepository;
import com.viztrend.safe.persistence.repository.TeamSprintVelocityRepository;
import com.viztrend.safe.persistence.repository.TokenRepository;
import com.viztrend.safe.persistence.repository.UserApiKeyRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceAccessRoleRepository;
import com.viztrend.safe.service.ALMSyncService;
import com.viztrend.safe.service.ALMSyncServiceImpl;
import com.viztrend.safe.service.APIService;
import com.viztrend.safe.service.ExportService;
import com.viztrend.safe.service.MongoService;
import com.viztrend.safe.service.PiJourneyService;
import com.viztrend.safe.service.ReleaseTrainServiceImpl;
import com.viztrend.safe.service.UserService;
import com.viztrend.safe.service.WebHookSyncService;
import com.viztrend.safe.service.WebHookSyncServiceImpl;
import com.viztrend.safe.utils.AlmUtils;
import com.viztrend.safe.utils.Constants;
import com.viztrend.safe.utils.EncDecUtility;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.LocalMailSender;
import com.viztrend.safe.utils.MongoSyncUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.SystemUtil;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.ResyncParamsVO;
import com.viztrend.safe.vos.WebhookResponseVO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.bson.types.ObjectId;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.socket.config.WebSocketMessageBrokerStats;

@org.springframework.web.bind.annotation.RestController
public class RestController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestController.class);
    private static final Logger LOGGERHEALTH = LoggerFactory.getLogger((String)"health");
    @Autowired
    private PiJourneyService piJourneyService;
    @Autowired
    private ServerCacheRepository serverCacheRepository;
    @Autowired
    private AuditLogRepository auditLogRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    ALMSyncService aLMSyncService;
    @Autowired
    private LocalMailSender mailSender;
    @Autowired
    private LocalMailSender localMailSender;
    @Autowired
    WebHookSyncService webHookSyncService;
    @Autowired
    ExportUtil epUtil;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private PushResponseRepository pushResponseRepository;
    @Autowired
    private WorkSpaceAccessRoleRepository workSpaceAccessRoleRepository;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    RoleRepository roleRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private TeamRepository teamRepository;
    @Autowired
    private Environment env;
    @Autowired
    private PrivacyStatementRepository privacyStatementRepository;
    @Autowired
    private CompanyRepository companyRepository;
    @Autowired
    private ExportService exportService;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private ALMSyncService ALMSyncService;
    @Autowired
    private ImportUtil importUtil;
    @Autowired
    private TFSUtils tfsUtils;
    @Autowired
    private KendisStatsRepository kendisStatsRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private JiraProjectIssueTypesRepository jiraProjectIssueTypesRepository;
    @Autowired
    private AppConfig.MongoConfig mongoConfig;
    @Autowired
    private TokenRepository tokenRepository;
    @Autowired
    private SessionRegistry sessionRegistry;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private TeamSprintVelocityRepository teamSprintVelocityRepository;
    @Autowired
    private CustomRepositoryImpl<Object> customRepositoryImpl;
    @Autowired
    private StateRepository stateRepository;
    @Autowired
    private CustomRepository<Object> customRepository;
    @Autowired
    WebSocketMessageBrokerStats webSocketMessageBrokerStats;
    @Autowired
    private AppInitConfigRepository appInitConfigRepository;
    @Autowired
    private AlmConfigurationsRepository almConfigurationsRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private ReleaseTrainServiceImpl releaseTrainServiceImpl;
    @Autowired
    private PiTeamCapacityRepository piTeamCapacityRepository;
    @Autowired
    private UserApiKeyRepository userApiKeyRepository;
    @Autowired
    private MongoService mongoService;
    @Autowired
    private ExternalLinksRepository externalLinksRepository;
    @Autowired
    private APIService apiService;
    private Pusher pusher = null;
    private String channelPrefix = "private-";

    @PostConstruct
    public void init() {
        try {
            List appInitConfigList = this.appInitConfigRepository.findAll();
            if (PropertyValidator.isValid((Collection)appInitConfigList) && PropertyValidator.isValid((Object)((AppInitConfig)appInitConfigList.get(0)).getPusherEncKey())) {
                String pusherEncKey = ((AppInitConfig)appInitConfigList.get(0)).getPusherEncKey();
                if (EncDecUtility.isKMSEncryption((String)pusherEncKey)) {
                    pusherEncKey = EncDecUtility.decryptKMS((String)pusherEncKey);
                }
                this.pusher = new Pusher(this.env.getProperty("pusher.app_id"), this.env.getProperty("pusher.key"), this.env.getProperty("pusher.secret"), pusherEncKey);
            } else {
                this.pusher = new Pusher(this.env.getProperty("pusher.app_id"), this.env.getProperty("pusher.key"), this.env.getProperty("pusher.secret"));
            }
            this.pusher.setCluster(this.env.getProperty("pusher.cluster"));
            this.pusher.setEncrypted(true);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    public String getWebSocketMessageBrokerStats(@RequestParam String test) {
        StringBuffer sb = new StringBuffer();
        sb.append("WebSocketSessionStatsInfo():&nbsp;" + this.webSocketMessageBrokerStats.getWebSocketSessionStatsInfo());
        sb.append("<br/><br/>ClientInboundExecutorStatsInfo():&nbsp;  " + this.webSocketMessageBrokerStats.getClientInboundExecutorStatsInfo());
        sb.append("<br/><br/>ClientOutboundExecutorStatsInfo():&nbsp;   " + this.webSocketMessageBrokerStats.getClientOutboundExecutorStatsInfo());
        sb.append("<br/><br/>LoggingPeriod():&nbsp;   " + this.webSocketMessageBrokerStats.getLoggingPeriod());
        sb.append("<br/><br/>SockJsTaskSchedulerStatsInfo():&nbsp;   " + this.webSocketMessageBrokerStats.getSockJsTaskSchedulerStatsInfo());
        sb.append("<br/><br/>StompBrokerRelayStatsInfo():&nbsp;   " + this.webSocketMessageBrokerStats.getStompBrokerRelayStatsInfo());
        sb.append("<br/><br/>StompSubProtocolStatsInfo():&nbsp;  " + this.webSocketMessageBrokerStats.getStompSubProtocolStatsInfo());
        return sb.toString();
    }

    @RequestMapping(value={"/push/stream"}, method={RequestMethod.POST})
    public void pushStream(@RequestBody Map req) {
        if (this.pusher != null) {
            String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
            String channel = this.channelPrefix + cid;
            String event = String.valueOf(req.get("event_type"));
            this.pusher.trigger(channel, event, (Object)req);
        }
    }

    @RequestMapping(value={"/pusher/auth"}, method={RequestMethod.POST})
    public String authPushStream(HttpServletRequest request, HttpServletResponse response) {
        if (this.pusher != null && (this.channelPrefix + UserContextUtil.getUserContext().getCurrentCompanyId()).equals(request.getParameter("channel_name"))) {
            String authBody = this.pusher.authenticate(request.getParameter("socket_id"), request.getParameter("channel_name"));
            return authBody;
        }
        return null;
    }

    @RequestMapping(value={"/mongo/version"})
    public String getMongoVersion() {
        try {
            return this.mongoService.getMongoDBVersion();
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return "0";
        }
    }

    @RequestMapping(value={"/ping"}, method={RequestMethod.GET})
    public ResponseEntity<String> ping() {
        if (UserContextUtil.getUserContext() != null && PropertyValidator.isValid((Object)UserContextUtil.getUserContext().getLoggedInUser())) {
            return ResponseEntity.ok((Object)"Session is active");
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).body((Object)"Session has expired");
    }

    public List<SessionInformation> getUsersFromSessionRegistry(@RequestParam String test) {
        try {
            this.sessionRegistry.getSessionInformation(test).expireNow();
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return this.sessionRegistry.getAllSessions((Object)UserContextUtil.getUserContext(), false);
    }

    @RequestMapping(value={"/savePrivacyStatement"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> savePrivacyStatement(@RequestBody PrivacyStatement statement) {
        HashMap<String, PrivacyStatement> response = new HashMap<String, PrivacyStatement>();
        try {
            this.privacyStatementRepository.save((Object)statement);
            response.put("privacyStatement", statement);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/remove/statement"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> removePrivacyStatement(@RequestBody PrivacyStatement statement) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            if (PropertyValidator.isValid((Object)statement)) {
                this.privacyStatementRepository.delete((Serializable)((Object)statement.getId()));
            }
            response.put("success", true);
            response.put("id", statement.getId());
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/privacystatement"})
    @ResponseBody
    public ResponseEntity<Object> privacyStatement(HttpServletRequest request) {
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        try {
            PaymentPackageConfig config;
            Company company = null;
            if (this.env.getProperty("isLocalDeployment").equals("true")) {
                List companies = this.companyRepository.findAll();
                company = this.companyRepository.findById(((Company)companies.get(0)).getId());
            } else {
                String urlPrefix = request.getServerName().split("\\.")[0];
                company = this.companyRepository.findByUrlPrefix(urlPrefix);
            }
            List privacyStatements = new ArrayList();
            if (company != null && PropertyValidator.isValid((Object)(config = company.getPaymentPackageConfig())) && PropertyValidator.isValid((Object)config.getPrivacyStatement()) && config.getPrivacyStatement().booleanValue()) {
                privacyStatements = this.privacyStatementRepository.findByTenant(company.getTenant());
            }
            response.put("privacyStatements", (Serializable)((Object)privacyStatements));
        }
        catch (Exception e) {
            response.put("success", Boolean.valueOf(false));
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/username/{param}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<Object> signupUser(@PathVariable(value="param") String param, @RequestBody User user) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (param.equals("check")) {
            if (user.getUserName() != null) {
                if ((user = this.userRepository.findByUserNameIgnoreCase(user.getUserName())) != null) {
                    responseJson.put("error", true);
                    responseJson.put("message", "User with this email already exist");
                }
            } else {
                responseJson.put("error", true);
                responseJson.put("message", "Invalid email");
            }
        } else if (param.equals("new")) {
            user.setTenant(UUID.randomUUID().toString());
            user.setIsSuperAdmin(Boolean.valueOf(true));
            user.setIsAdmin(Boolean.valueOf(true));
            user = (User)this.userRepository.save((Object)user);
            if (user.getId() != null) {
                responseJson.put("success", true);
            } else {
                responseJson.put("error", true);
                responseJson.put("message", "Something went wrong, Try again");
            }
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private Map<String, Object> getUserWithData(User user) {
        ArrayList<String> users = new ArrayList<String>();
        users.add(user.getId());
        List groups = this.groupRepository.findByUsersIn(users);
        HashSet<String> gids = new HashSet<String>();
        for (int i = 0; i < groups.size(); ++i) {
            gids.add(((Group)groups.get(i)).getId());
        }
        user.setGroups(gids);
        List workSpaces = this.customRepository.findWorkspaceAccessRoles(user);
        List userApiKeys = this.userApiKeyRepository.findByUserIdAndRevoked(user.getId(), false);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("user", user);
        data.put("workSpaces", workSpaces);
        data.put("groups", groups);
        data.put("userApiKeys", userApiKeys);
        List accounts = this.aLMSyncService.fetchJiraAccount(false);
        if (PropertyValidator.isValid((Collection)accounts)) {
            if (PropertyValidator.isValid((Collection)user.getAlmCredentials())) {
                AlmAccUser accUser = (AlmAccUser)user.getAlmCredentials().get(0);
                boolean almAccountFound = false;
                for (AlmAccount account : accounts) {
                    if (!accUser.getAlmAccId().equals(account.getId())) continue;
                    almAccountFound = true;
                }
                if (!almAccountFound) {
                    user.getAlmCredentials().remove(0);
                }
            }
            data.put("almList", accounts);
        }
        data.put("upload", this.env.getProperty("attachment.location"));
        return data;
    }

    @RequestMapping(value={"/profile"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getUserProfile(@RequestBody String req) {
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        User dbUser = (User)this.userRepository.findOne((Serializable)((Object)user.getId()));
        user.setRequireMFACode(dbUser.isRequireMFACode());
        user.setMfaCodeSec(dbUser.getMfaCodeSec());
        user.setrecoveryMFACode(dbUser.getrecoveryMFACode());
        user.setreckeyUpdatedDate(dbUser.getreckeyUpdatedDate());
        user.setAlmCredentials(dbUser.getAlmCredentials());
        if (user.getEmail() == null) {
            user.setEmail("");
        }
        if (user.getLastName() == null) {
            user.setLastName("");
        }
        if (user.getFullName() == null) {
            user.setFullName(user.getFirstName());
            if (PropertyValidator.isValid((Object)user.getLastName())) {
                user.setFullName(user.getFirstName() + " " + user.getLastName());
            }
        }
        Map data = this.getUserWithData(user);
        return new ResponseEntity((Object)data, HttpStatus.OK);
    }

    @RequestMapping(value={"/update/recoverycode"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateRecoveryCode(@RequestBody String recCode) {
        try {
            if (recCode.endsWith("=")) {
                recCode = recCode.substring(0, recCode.length() - 1);
            }
            User savedUser = this.userRepository.findById(UserContextUtil.getUserContext().getLoggedInUser().getId());
            savedUser.setrecoveryMFACode(recCode);
            savedUser.setreckeyUpdatedDate(new Date());
            UserContextUtil.getUserContext().getLoggedInUser().setreckeyUpdatedDate(new Date());
            this.userRepository.save((Object)savedUser);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @RequestMapping(value={"/update/mfa"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateMFA(@RequestBody User user) {
        try {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            Date date = new Date();
            User savedUser = this.userRepository.findById(user.getId());
            savedUser.setRequireMFACode(user.isRequireMFACode());
            savedUser.setMfaCodeSec(user.getMfaCodeSec());
            savedUser.setrecoveryMFACode(user.getrecoveryMFACode());
            savedUser.setMfaCreatedDate(date);
            savedUser.setreckeyUpdatedDate(date);
            savedUser.setforcedMFA(Boolean.valueOf(false));
            vars.put("createdDate", date);
            vars.put("email", savedUser.getEmail());
            this.localMailSender.sendMail(savedUser.getEmail(), "Two-factor authentication enabled for your Kendis account", "mfaEnable", vars, true);
            UserContextUtil.getUserContext().getLoggedInUser().setMfaCodeSec(user.getMfaCodeSec());
            UserContextUtil.getUserContext().getLoggedInUser().setMfaCreatedDate(date);
            this.userRepository.save((Object)savedUser);
        }
        catch (Exception ex) {
            LOGGER.error("Update MFA", (Throwable)ex);
        }
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @RequestMapping(value={"/verify/userPassword"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> verifyUserPassword(@RequestBody Map<String, String> request) {
        String userId = request.get("id");
        String password = request.get("password");
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            User user = this.userRepository.findById(userId);
            if (PropertyValidator.isValid((Object)user)) {
                boolean result = this.passwordEncoder.matches((CharSequence)password, user.getPassword());
                if (result) {
                    responseJson.put("success", true);
                } else {
                    responseJson.put("success", false);
                    responseJson.put("msg", "Password does not match");
                }
            }
        }
        catch (Exception ex) {
            responseJson.put("error", true);
            return new ResponseEntity(responseJson, HttpStatus.UNAUTHORIZED);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/update/user"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateUser(@RequestBody User user) {
        boolean isPasswordChange = false;
        boolean isPasswordsame = false;
        boolean isPasswordLarge = false;
        String oldUserName = null;
        Object isUserNameUpdated = null;
        Map<String, Boolean> data = new HashMap<String, String>();
        ArrayList<String> emails = new ArrayList<String>();
        emails.add(user.getEmail());
        ArrayList unames = new ArrayList();
        ArrayList<String> ids = new ArrayList<String>();
        try {
            User savedUser = this.userRepository.findById(user.getId());
            oldUserName = savedUser.getUserName();
            ids.add(savedUser.getId());
            if (PropertyValidator.isValid((Object)user.getEmail()) && !user.getEmail().equals(savedUser.getEmail())) {
                emails.add(user.getEmail());
                List duplicate = this.userRepository.findByIdNotInAndEmailInOrUserNameIn(ids, emails, unames);
                if (PropertyValidator.isValid((Collection)duplicate)) {
                    data.put("msg", (Boolean)((Object)"Email already exits"));
                    return new ResponseEntity(data, HttpStatus.OK);
                }
                if (!user.hasValidEmail().booleanValue()) {
                    data.put("msg", (Boolean)((Object)"Invalid email"));
                    return new ResponseEntity(data, HttpStatus.OK);
                }
                savedUser.setEmail(user.getEmail());
                if (UserContextUtil.getUserContext().getldapUser() == null) {
                    savedUser.setUserName(user.getEmail());
                }
            }
            if (PropertyValidator.isValid((Object)user.getPassword()) && user.getPassword().length() < 46 && !user.getPassword().equalsIgnoreCase(user.getEmail())) {
                boolean result = this.passwordEncoder.matches((CharSequence)user.getOldPassword(), savedUser.getPassword());
                Company company = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompanyId());
                if (!result) {
                    data.put("msg", (Boolean)((Object)"Wrong Old Password"));
                    return new ResponseEntity(data, HttpStatus.OK);
                }
                if (PropertyValidator.isValid((Object)company.getSecurityPolicy())) {
                    if (!PropertyValidator.isValid((Collection)savedUser.getPasswordHistory())) {
                        ArrayList<PasswordHistory> psshistList = new ArrayList<PasswordHistory>();
                        psshistList.add(new PasswordHistory(savedUser.getPassword(), new Date()));
                        savedUser.setPasswordHistory((List)psshistList);
                    }
                    if (company.getSecurityPolicy().isEnablePasswordHistory()) {
                        for (PasswordHistory ph : savedUser.getPasswordHistory()) {
                            boolean isPassInHistory = this.passwordEncoder.matches((CharSequence)user.getPassword(), ph.getPassword());
                            if (!isPassInHistory) continue;
                            data.put("msg", (Boolean)((Object)"You cannot change with previously used password"));
                            return new ResponseEntity(data, HttpStatus.OK);
                        }
                    }
                    savedUser.getPasswordHistory().add(new PasswordHistory(EncDecUtility.bCryptPasswordEncoder((String)user.getOldPassword()), new Date()));
                }
                savedUser.setPassword(EncDecUtility.bCryptPasswordEncoder((String)user.getPassword()));
                isPasswordChange = true;
            } else if (PropertyValidator.isValid((Object)user.getPassword()) && user.getPassword().length() > 46) {
                isPasswordLarge = true;
            } else if (PropertyValidator.isValid((Object)user.getPassword()) && user.getPassword().equalsIgnoreCase(user.getEmail())) {
                isPasswordsame = true;
            }
            savedUser.setFullName(user.getFullName());
            savedUser.setFirstName(user.getFirstName());
            savedUser.setLastName(user.getLastName());
            BasicDBObject atlassianHostDomainUserObjQuery = new BasicDBObject();
            atlassianHostDomainUserObjQuery.put((Object)"kendisUserId", (Object)oldUserName);
            BasicDBObject atlassianHostDomainUserObj = new BasicDBObject();
            DBCursor cursor = this.mongoTemplate.getCollection("atlassianHostDomainUser").find((DBObject)atlassianHostDomainUserObjQuery);
            if (cursor.hasNext()) {
                atlassianHostDomainUserObj = cursor.next();
                atlassianHostDomainUserObj.put("kendisUserId", (Object)user.getUserName());
                this.mongoTemplate.getCollection("atlassianHostDomainUser").update((DBObject)atlassianHostDomainUserObjQuery, (DBObject)atlassianHostDomainUserObj);
            }
            savedUser = (User)this.userRepository.save((Object)savedUser);
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User logged = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            if (logged.getId().equals(savedUser.getId())) {
                secureUser.getUserContextDTO().getContextMap().put("user", savedUser);
            }
            data = this.getUserWithData(savedUser);
            data.put("isUserNameUpdated", (Boolean)isUserNameUpdated);
            data.put("isPasswordLarge", isPasswordLarge);
            data.put("isPasswordsame", isPasswordsame);
        }
        catch (Exception e) {
            LOGGER.error("updateUserAlmAccount", (Throwable)e);
        }
        return new ResponseEntity(data, HttpStatus.OK);
    }

    @RequestMapping(value={"alm/oAuth/generateToken"}, method={RequestMethod.GET})
    @ResponseBody
    public void getAlmAuthToken(HttpServletRequest request, HttpServletResponse response) {
        String error = request.getParameter("error");
        String serverCacheKey = request.getParameter("state");
        String cacheForProfileKey = UserContextUtil.getUserContext().getLoggedInUser().getId() + serverCacheKey;
        ServerCache serverCache = this.serverCacheRepository.findByKey(cacheForProfileKey);
        String scheme = request.getScheme();
        String host = request.getHeader("Host");
        String contextPath = request.getContextPath();
        if (!PropertyValidator.isValid((Object)serverCache)) {
            try {
                response.sendRedirect("/authError?error=No cache found against state.&authType=azure");
            }
            catch (Exception exception) {
                LOGGER.error(StringUtils.getTraceString((Throwable)exception));
            }
        }
        HashMap kv = (HashMap)new Gson().fromJson(serverCache.getValue(), HashMap.class);
        String baseUrl = (String)kv.get("kendisCallback");
        String baseUrlHash = (String)kv.get("kendisCallbackHash");
        boolean isProfile = PropertyValidator.isValid(kv.get("isProfile")) ? (Boolean)kv.get("isProfile") : false;
        String almAccountId = (String)kv.get("almAccountId");
        String userId = (String)kv.get("userId");
        if (PropertyValidator.isValid((Object)error)) {
            String redirectPath;
            Gson gson = new Gson();
            kv.put("errorMessage", error);
            kv.put("type", "tfs");
            String jsonauthMapJSON = gson.toJson((Object)kv);
            serverCache.setValue(jsonauthMapJSON);
            this.serverCacheRepository.save((Object)serverCache);
            if (isProfile) {
                String appendQuery = "profileKey=" + serverCacheKey + "&almId=" + almAccountId + "&userId=" + userId + "&errorCode=1";
                redirectPath = baseUrl.contains("?") ? baseUrl + "&" + appendQuery + baseUrlHash : baseUrl + "?" + appendQuery + baseUrlHash;
            } else {
                baseUrl = scheme + "://" + host + contextPath;
                String query = "/administration?tfskey=" + serverCacheKey + "#almaccounts";
                redirectPath = baseUrl + "?" + query;
            }
            try {
                response.sendRedirect(redirectPath);
            }
            catch (IOException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        } else {
            AlmAccount almAccount;
            String code = request.getParameter("code");
            String clientSecret = (String)kv.get("secretKey");
            String clientId = (String)kv.get("clientId");
            String almBaseUrl = (String)kv.get("almBaseUrl");
            String oAuthCallbackUrl = (String)kv.get("authUrl");
            if (!PropertyValidator.isValid((Object)clientSecret) && PropertyValidator.isValid((Object)(almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId)))) && PropertyValidator.isValid((Object)almAccount.getAzureOAuthToken())) {
                clientSecret = almAccount.getSecretKey();
                oAuthCallbackUrl = almAccount.getAuthUrl();
            }
            try {
                CloseableHttpClient httpClient = HttpClients.createMinimal();
                HttpPost post = new HttpPost("https://app.vssps.visualstudio.com/oauth2/token");
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                params.add(new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
                params.add(new BasicNameValuePair("client_assertion", URLEncoder.encode(clientSecret, StandardCharsets.UTF_8.toString())));
                params.add(new BasicNameValuePair("grant_type", "urn:ietf:params:oauth:grant-type:jwt-bearer"));
                params.add(new BasicNameValuePair("assertion", URLEncoder.encode(code, StandardCharsets.UTF_8.toString())));
                params.add(new BasicNameValuePair("redirect_uri", oAuthCallbackUrl));
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params);
                post.setEntity((HttpEntity)entity);
                post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                HttpResponse postResponse = httpClient.execute((HttpUriRequest)post);
                String content = TFSOauth2Filter.convertStreamToString((InputStream)postResponse.getEntity().getContent());
                JSONObject jsonResponse = new JSONObject(content);
                if (!jsonResponse.isNull("access_token")) {
                    AlmAccount almAccount2 = new AlmAccount();
                    almAccount2.setId(almAccountId);
                    almAccount2.setUrl(baseUrl);
                    AzureOAuthToken azureOAuthToken = new AzureOAuthToken();
                    azureOAuthToken.setAccessToken(jsonResponse.getString("access_token"));
                    azureOAuthToken.setRefreshToken(jsonResponse.getString("refresh_token"));
                    azureOAuthToken.setExpiresAt(TFSUtils.getAzureTokenExpiry((String)jsonResponse.getString("expires_in")));
                    almAccount2.setAzureOAuthToken(azureOAuthToken);
                    almAccount2.setClientId(clientId);
                    almAccount2.setAuthUrl(oAuthCallbackUrl);
                    almAccount2.setSecretKey(clientSecret);
                    almAccount2.setUrl(almBaseUrl);
                    if (isProfile) {
                        almAccount2.setIsTaggedUser(Boolean.valueOf(true));
                        almAccount2.setAdminAlmAcc(Boolean.valueOf(false));
                    }
                    String result = this.tfsUtils.validateAzureDevopsUser(almAccount2);
                    String username = null;
                    if (PropertyValidator.isValid((Object)result)) {
                        1 type = new /* Unavailable Anonymous Inner Class!! */;
                        Map tfsUser = (Map)new Gson().fromJson(result, type.getType());
                        username = (String)tfsUser.get("emailAddress");
                    }
                    List organizations = this.tfsUtils.getOrganizationListFromTFSToken(almAccount2);
                    this.tfsUtils.cacheToken(jsonResponse, serverCache, username, organizations);
                    if (PropertyValidator.isValid((Object)baseUrl)) {
                        String query;
                        if (isProfile) {
                            query = "profileKey=" + serverCacheKey + "&almId=" + almAccountId + "&userId=" + userId;
                            baseUrl = baseUrl.contains("?") ? baseUrl + "&" + query + baseUrlHash : baseUrl + "?" + query + baseUrlHash;
                            response.sendRedirect(baseUrl);
                        } else {
                            baseUrl = scheme + "://" + host + contextPath;
                            query = "/administration?tfskey=" + serverCacheKey + "#almaccounts";
                            response.sendRedirect(baseUrl + query);
                        }
                    }
                } else {
                    int errorCode = 1;
                    if (jsonResponse.has("Error")) {
                        kv.put("errorMessage", jsonResponse.get("Error"));
                        kv.put("errorDetails", jsonResponse.get("ErrorDescription"));
                    }
                    Gson gson = new Gson();
                    String jsonauthMapJSON = gson.toJson((Object)kv);
                    serverCache.setValue(jsonauthMapJSON);
                    this.serverCacheRepository.save((Object)serverCache);
                    String resultPath = "";
                    if (isProfile) {
                        String appendQuery = "profileKey=" + serverCacheKey + "&almId=" + almAccountId + "&userId=" + userId + "&errorCode=" + errorCode;
                        resultPath = baseUrl.contains("?") ? baseUrl + "&" + appendQuery + baseUrlHash : baseUrl + "?" + appendQuery + baseUrlHash;
                    } else {
                        baseUrl = scheme + "://" + host + contextPath;
                        String query = "/administration?tfskey=" + serverCacheKey + "&errorCode=" + errorCode + "#almaccounts";
                        resultPath = baseUrl + query;
                    }
                    try {
                        response.sendRedirect(resultPath);
                    }
                    catch (IOException e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error(String.valueOf(e));
            }
            catch (Exception ex) {
                int errorCode = 1;
                String errorMessage = "";
                String errorDetails = "";
                if (ex instanceof UnknownHostException) {
                    errorCode = 2;
                    errorMessage = ex.getMessage();
                    errorDetails = StringUtils.getTraceString((Throwable)ex);
                } else if (ex instanceof HttpResponseException) {
                    errorCode = 3;
                    errorMessage = ex.getMessage();
                    errorDetails = StringUtils.getTraceString((Throwable)ex);
                } else if (ex instanceof ConnectException) {
                    errorCode = 4;
                    errorMessage = ex.getMessage();
                    errorDetails = StringUtils.getTraceString((Throwable)ex);
                } else {
                    errorMessage = ex.getMessage();
                    errorDetails = StringUtils.getTraceString((Throwable)ex);
                }
                kv.put("errorMessage", errorMessage);
                kv.put("errorDetails", errorDetails);
                Gson gson = new Gson();
                String jsonauthMapJSON = gson.toJson((Object)kv);
                serverCache.setValue(jsonauthMapJSON);
                this.serverCacheRepository.save((Object)serverCache);
                String resultPath = "";
                if (isProfile) {
                    String appendQuery = "profileKey=" + serverCacheKey + "&almId=" + almAccountId + "&userId=" + userId + "&errorCode=" + errorCode;
                    resultPath = baseUrl.contains("?") ? baseUrl + "&" + appendQuery + baseUrlHash : baseUrl + "?" + appendQuery + baseUrlHash;
                } else {
                    baseUrl = scheme + "://" + host + contextPath;
                    String query = "/administration?tfskey=" + serverCacheKey + "#almaccounts";
                    resultPath = baseUrl + query;
                }
                try {
                    response.sendRedirect(resultPath);
                }
                catch (IOException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)ex));
                }
            }
        }
    }

    @RequestMapping(value={"alm/entraId/generateToken"}, method={RequestMethod.GET})
    @ResponseBody
    public void getAlmEntraIdToken(HttpServletRequest request, HttpServletResponse response) {
        String error = request.getParameter("error");
        String serverCacheKey = request.getParameter("state");
        String cacheForProfileKey = UserContextUtil.getUserContext().getLoggedInUser().getId() + serverCacheKey;
        ServerCache serverCache = this.serverCacheRepository.findByKey(cacheForProfileKey);
        String scheme = request.getScheme();
        String host = request.getHeader("Host");
        String contextPath = request.getContextPath();
        if (!PropertyValidator.isValid((Object)serverCache)) {
            try {
                response.sendRedirect("/authError?error=No cache found against state.&authType=azure");
            }
            catch (Exception exception) {
                LOGGER.error(StringUtils.getTraceString((Throwable)exception));
            }
        }
        HashMap kv = (HashMap)new Gson().fromJson(serverCache.getValue(), HashMap.class);
        String baseUrl = (String)kv.get("kendisCallback");
        String baseUrlHash = (String)kv.get("kendisCallbackHash");
        boolean isProfile = PropertyValidator.isValid(kv.get("isProfile")) ? (Boolean)kv.get("isProfile") : false;
        String almAccountId = (String)kv.get("almAccountId");
        String userId = (String)kv.get("userId");
        if (PropertyValidator.isValid((Object)error)) {
            String redirectPath;
            Gson gson = new Gson();
            kv.put("errorMessage", error);
            kv.put("type", "tfs");
            String jsonauthMapJSON = gson.toJson((Object)kv);
            serverCache.setValue(jsonauthMapJSON);
            this.serverCacheRepository.save((Object)serverCache);
            if (isProfile) {
                String appendQuery = "profileKey=" + serverCacheKey + "&almId=" + almAccountId + "&userId=" + userId + "&errorCode=1";
                redirectPath = baseUrl.contains("?") ? baseUrl + "&" + appendQuery + baseUrlHash : baseUrl + "?" + appendQuery + baseUrlHash;
            } else {
                baseUrl = scheme + "://" + host + contextPath;
                String query = "/administration?tfskey=" + serverCacheKey + "#almaccounts";
                redirectPath = baseUrl + "?" + query;
            }
            try {
                response.sendRedirect(redirectPath);
            }
            catch (IOException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        } else {
            AlmAccount almAccount;
            String code = request.getParameter("code");
            String clientSecret = (String)kv.get("secretKey");
            String clientId = (String)kv.get("clientId");
            String almBaseUrl = (String)kv.get("almBaseUrl");
            String oAuthCallbackUrl = (String)kv.get("authUrl");
            String directoryId = (String)kv.get("directoryId");
            if (!PropertyValidator.isValid((Object)clientSecret) && PropertyValidator.isValid((Object)(almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId)))) && PropertyValidator.isValid((Object)almAccount.getAzureOAuthToken())) {
                clientSecret = almAccount.getSecretKey();
                oAuthCallbackUrl = almAccount.getAuthUrl();
            }
            try {
                CloseableHttpClient httpClient = HttpClients.createMinimal();
                HttpPost post = new HttpPost("https://login.microsoftonline.com/" + directoryId + "/oauth2/v2.0/token");
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                params.add(new BasicNameValuePair("client_id", clientId));
                params.add(new BasicNameValuePair("client_secret", clientSecret));
                params.add(new BasicNameValuePair("grant_type", "authorization_code"));
                params.add(new BasicNameValuePair("code", code));
                params.add(new BasicNameValuePair("redirect_uri", oAuthCallbackUrl));
                params.add(new BasicNameValuePair("scope", "offline_access https://app.vssps.visualstudio.com/.default"));
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params);
                post.setEntity((HttpEntity)entity);
                post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                HttpResponse postResponse = httpClient.execute((HttpUriRequest)post);
                String content = TFSOauth2Filter.convertStreamToString((InputStream)postResponse.getEntity().getContent());
                JSONObject jsonResponse = new JSONObject(content);
                if (!jsonResponse.isNull("access_token")) {
                    AlmAccount almAccount2 = new AlmAccount();
                    almAccount2.setId(almAccountId);
                    almAccount2.setUrl(baseUrl);
                    AzureOAuthToken azureOAuthToken = new AzureOAuthToken();
                    azureOAuthToken.setAccessToken(jsonResponse.getString("access_token"));
                    azureOAuthToken.setRefreshToken(jsonResponse.getString("refresh_token"));
                    azureOAuthToken.setExpiresAt(TFSUtils.getAzureTokenExpiry((String)jsonResponse.getString("expires_in")));
                    almAccount2.setAzureOAuthToken(azureOAuthToken);
                    almAccount2.setClientId(clientId);
                    almAccount2.setAuthUrl(oAuthCallbackUrl);
                    almAccount2.setSecretKey(clientSecret);
                    almAccount2.setUrl(almBaseUrl);
                    almAccount2.setDirectoryId(directoryId);
                    if (isProfile) {
                        almAccount2.setIsTaggedUser(Boolean.valueOf(true));
                        almAccount2.setAdminAlmAcc(Boolean.valueOf(false));
                    }
                    String result = this.tfsUtils.validateAzureDevopsUser(almAccount2);
                    String username = null;
                    if (PropertyValidator.isValid((Object)result)) {
                        2 type = new /* Unavailable Anonymous Inner Class!! */;
                        Map tfsUser = (Map)new Gson().fromJson(result, type.getType());
                        username = (String)tfsUser.get("emailAddress");
                    }
                    List organizations = this.tfsUtils.getOrganizationListFromTFSToken(almAccount2);
                    this.tfsUtils.cacheToken(jsonResponse, serverCache, username, organizations);
                    if (PropertyValidator.isValid((Object)baseUrl)) {
                        String query;
                        if (isProfile) {
                            query = "profileKey=" + serverCacheKey + "&almId=" + almAccountId + "&userId=" + userId;
                            baseUrl = baseUrl.contains("?") ? baseUrl + "&" + query + baseUrlHash : baseUrl + "?" + query + baseUrlHash;
                            response.sendRedirect(baseUrl);
                        } else {
                            baseUrl = scheme + "://" + host + contextPath;
                            query = "/administration?tfskey=" + serverCacheKey + "#almaccounts";
                            response.sendRedirect(baseUrl + query);
                        }
                    }
                } else {
                    int errorCode = 1;
                    if (jsonResponse.has("Error")) {
                        kv.put("errorMessage", jsonResponse.get("Error"));
                        kv.put("errorDetails", jsonResponse.get("ErrorDescription"));
                    }
                    Gson gson = new Gson();
                    String jsonauthMapJSON = gson.toJson((Object)kv);
                    serverCache.setValue(jsonauthMapJSON);
                    this.serverCacheRepository.save((Object)serverCache);
                    String resultPath = "";
                    if (isProfile) {
                        String appendQuery = "profileKey=" + serverCacheKey + "&almId=" + almAccountId + "&userId=" + userId + "&errorCode=" + errorCode;
                        resultPath = baseUrl.contains("?") ? baseUrl + "&" + appendQuery + baseUrlHash : baseUrl + "?" + appendQuery + baseUrlHash;
                    } else {
                        baseUrl = scheme + "://" + host + contextPath;
                        String query = "/administration?tfskey=" + serverCacheKey + "&errorCode=" + errorCode + "#almaccounts";
                        resultPath = baseUrl + query;
                    }
                    try {
                        response.sendRedirect(resultPath);
                    }
                    catch (IOException e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error(String.valueOf(e));
            }
            catch (Exception ex) {
                int errorCode = 1;
                String errorMessage = "";
                String errorDetails = "";
                if (ex instanceof UnknownHostException) {
                    errorCode = 2;
                    errorMessage = ex.getMessage();
                    errorDetails = StringUtils.getTraceString((Throwable)ex);
                } else if (ex instanceof HttpResponseException) {
                    errorCode = 3;
                    errorMessage = ex.getMessage();
                    errorDetails = StringUtils.getTraceString((Throwable)ex);
                } else if (ex instanceof ConnectException) {
                    errorCode = 4;
                    errorMessage = ex.getMessage();
                    errorDetails = StringUtils.getTraceString((Throwable)ex);
                } else {
                    errorMessage = ex.getMessage();
                    errorDetails = StringUtils.getTraceString((Throwable)ex);
                }
                kv.put("errorMessage", errorMessage);
                kv.put("errorDetails", errorDetails);
                Gson gson = new Gson();
                String jsonauthMapJSON = gson.toJson((Object)kv);
                serverCache.setValue(jsonauthMapJSON);
                this.serverCacheRepository.save((Object)serverCache);
                String resultPath = "";
                if (isProfile) {
                    String appendQuery = "profileKey=" + serverCacheKey + "&almId=" + almAccountId + "&userId=" + userId + "&errorCode=" + errorCode;
                    resultPath = baseUrl.contains("?") ? baseUrl + "&" + appendQuery + baseUrlHash : baseUrl + "?" + appendQuery + baseUrlHash;
                } else {
                    baseUrl = scheme + "://" + host + contextPath;
                    String query = "/administration?tfskey=" + serverCacheKey + "#almaccounts";
                    resultPath = baseUrl + query;
                }
                try {
                    response.sendRedirect(resultPath);
                }
                catch (IOException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)ex));
                }
            }
        }
    }

    public void getProjects(String organizationName, String accessToken) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + accessToken);
        headers.set("Content-Type", "application/json");
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity((MultiValueMap)headers);
        ResponseEntity projects = restTemplate.exchange("https://dev.azure.com/" + organizationName + "/_apis/projects", HttpMethod.GET, httpEntity, String.class, new Object[0]);
        System.out.println(projects);
    }

    @RequestMapping(value={"/alm/user/{uid}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<Object> updateUserAlmAccount(@PathVariable(value="uid") String userId, @RequestBody AlmAccUser param) {
        List almCredentials;
        User user = this.userRepository.findById(userId);
        boolean userJiraAuth = false;
        boolean useAzureAuth = false;
        if (PropertyValidator.isValid((Object)param.getJiraOauthToken())) {
            userJiraAuth = true;
            if (!PropertyValidator.isValid((Object)param.getJiraOauthToken().getAccessToken()) && PropertyValidator.isValid((Collection)(almCredentials = user.getAlmCredentials()))) {
                for (AlmAccUser cred : almCredentials) {
                    if (!cred.getAlmAccId().equals(param.getAlmAccId())) continue;
                    param.setJiraOauthToken(cred.getJiraOauthToken());
                    break;
                }
            }
        } else if (PropertyValidator.isValid((Object)param.getAzureOAuthToken())) {
            useAzureAuth = true;
            if (!PropertyValidator.isValid((Object)param.getAzureOAuthToken().getAccessToken()) && PropertyValidator.isValid((Collection)(almCredentials = user.getAlmCredentials()))) {
                for (AlmAccUser cred : almCredentials) {
                    if (!cred.getAlmAccId().equals(param.getAlmAccId())) continue;
                    param.setAzureOAuthToken(cred.getAzureOAuthToken());
                    break;
                }
            }
        } else if (!PropertyValidator.isValid((Object)param.getAlmPassword()) && PropertyValidator.isValid((Collection)(almCredentials = user.getAlmCredentials()))) {
            for (AlmAccUser cred : almCredentials) {
                if (!cred.getAlmAccId().equals(param.getAlmAccId())) continue;
                param.setAlmPassword(cred.getAlmPassword());
                break;
            }
        }
        if (!userJiraAuth && !useAzureAuth) {
            if (!EncDecUtility.isKMSEncryption((String)param.getAlmPassword()) && !this.env.getProperty("isLocalDeployment").equals("true")) {
                try {
                    param.setAlmPassword(EncDecUtility.encryptKMS((String)EncDecUtility.decrypt((String)param.getAlmPassword())));
                }
                catch (Exception e) {
                    LOGGER.error("Password/Token already encrypted");
                }
            }
            try {
                EncDecUtility.decrypt((String)param.getAlmPassword());
            }
            catch (Exception e2) {
                try {
                    param.setAlmPassword(EncDecUtility.encrypt((String)param.getAlmPassword()));
                }
                catch (Exception e1) {
                    LOGGER.error("catch again Password/Token already encrypted");
                }
            }
        }
        try {
            if (!PropertyValidator.isValid((Collection)user.getAlmCredentials())) {
                user.setAlmCredentials(new ArrayList());
            }
            if ("EDIT".equals(param.getAction())) {
                for (int i = 0; i < user.getAlmCredentials().size(); ++i) {
                    if (!param.getAlmAccId().equals(((AlmAccUser)user.getAlmCredentials().get(i)).getAlmAccId())) continue;
                    ((AlmAccUser)user.getAlmCredentials().get(i)).setAzureOAuthToken(param.getAzureOAuthToken());
                    ((AlmAccUser)user.getAlmCredentials().get(i)).setAlmUsername(param.getAlmUsername());
                    ((AlmAccUser)user.getAlmCredentials().get(i)).setAlmPassword(param.getAlmPassword());
                    ((AlmAccUser)user.getAlmCredentials().get(i)).setIsPatOn(param.getIsPatOn());
                    ((AlmAccUser)user.getAlmCredentials().get(i)).setJiraOauthToken(param.getJiraOauthToken());
                    ((AlmAccUser)user.getAlmCredentials().get(i)).setAuthType(param.getAuthType());
                    break;
                }
            } else if ("CREATE".equals(param.getAction())) {
                boolean exists = false;
                for (int i = 0; i < user.getAlmCredentials().size(); ++i) {
                    if (!param.getAlmAccId().equals(((AlmAccUser)user.getAlmCredentials().get(i)).getAlmAccId())) continue;
                    exists = true;
                    ((AlmAccUser)user.getAlmCredentials().get(i)).setAlmUsername(param.getAlmUsername());
                    ((AlmAccUser)user.getAlmCredentials().get(i)).setAlmPassword(param.getAlmPassword());
                    ((AlmAccUser)user.getAlmCredentials().get(i)).setIsPatOn(param.getIsPatOn());
                    ((AlmAccUser)user.getAlmCredentials().get(i)).setJiraOauthToken(param.getJiraOauthToken());
                    ((AlmAccUser)user.getAlmCredentials().get(i)).setAzureOAuthToken(param.getAzureOAuthToken());
                    ((AlmAccUser)user.getAlmCredentials().get(i)).setAuthType(param.getAuthType());
                    break;
                }
                if (!exists) {
                    user.getAlmCredentials().add(param);
                }
            } else if ("DELETE".equals(param.getAction())) {
                for (int i = 0; i < user.getAlmCredentials().size(); ++i) {
                    if (!param.getAlmAccId().equals(((AlmAccUser)user.getAlmCredentials().get(i)).getAlmAccId())) continue;
                    if (!userJiraAuth) {
                        if (PropertyValidator.isValid((Object)param.getAlmUsername()) && PropertyValidator.isValid((Object)((AlmAccUser)user.getAlmCredentials().get(i)).getAlmUsername())) {
                            if (!param.getAlmUsername().equals(((AlmAccUser)user.getAlmCredentials().get(i)).getAlmUsername())) continue;
                            user.getAlmCredentials().remove(i);
                        } else {
                            user.getAlmCredentials().remove(i);
                        }
                    } else {
                        user.getAlmCredentials().remove(i);
                    }
                    break;
                }
            }
            user = (User)this.userRepository.save((Object)user);
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User loggeduser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            if (loggeduser.getId().equals(user.getId())) {
                loggeduser.setAlmCredentials(user.getAlmCredentials());
            }
        }
        catch (Exception e) {
            LOGGER.error("updateUserAlmAccount", (Throwable)e);
        }
        return new ResponseEntity((Object)user, HttpStatus.OK);
    }

    @RequestMapping(value={"/alm/userconnect/{uid}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<Object> updateUserConnectAlmAccount(@PathVariable(value="uid") String userId, @RequestBody String payload) {
        User user = this.userRepository.findById(userId);
        if (PropertyValidator.isValid((Object)payload)) {
            try {
                String jiraHostUsername;
                Gson gson = new Gson();
                3 T = new /* Unavailable Anonymous Inner Class!! */;
                HashMap param = (HashMap)gson.fromJson(payload, T.getType());
                if (!PropertyValidator.isValid(param.get("password")) && PropertyValidator.isValid(param.get("almAccountId"))) {
                    AlmAccount editAlm = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)((String)param.get("almAccountId"))));
                    param.put("password", editAlm.getPassword());
                    param.put("isPatOn", editAlm.getIsPatOn());
                }
                String userJson = this.aLMSyncService.validateJiraUser(param);
                if ("true".equalsIgnoreCase((String)param.get("useConnect")) && PropertyValidator.isValid((Object)(jiraHostUsername = (String)param.get("jiraHostUsername")))) {
                    4 U = new /* Unavailable Anonymous Inner Class!! */;
                    HashMap myself = (HashMap)gson.fromJson(userJson, U.getType());
                    this.ALMSyncService.saveAtlassianHostDomainUser((String)param.get("jiraHostId"), jiraHostUsername, (String)myself.get("accountId"), user.getUserName());
                }
            }
            catch (ViztrendJiraException vJe) {
                return new ResponseEntity((Object)vJe.getAlmError(), HttpStatus.BAD_REQUEST);
            }
        }
        return new ResponseEntity((Object)user, HttpStatus.OK);
    }

    @RequestMapping(value={"/alms/{type}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<Object> getAlmAccounts(@PathVariable(value="type") String type, @RequestBody String param) {
        if (type != null) {
            try {
                if (type.equals("jira")) {
                    return new ResponseEntity((Object)this.aLMSyncService.fetchJiraAccount(true), HttpStatus.OK);
                }
            }
            catch (ViztrendJiraException vJe) {
                return new ResponseEntity((Object)vJe.getAlmError(), HttpStatus.BAD_REQUEST);
            }
        }
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/alm/{type}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getAlmAccounts(@PathVariable(value="type") String type) {
        if (type != null) {
            try {
                if (type.equals("jira") || type.equals("tfs")) {
                    return new ResponseEntity((Object)this.aLMSyncService.fetchJiraAccount(true), HttpStatus.OK);
                }
            }
            catch (ViztrendJiraException vJe) {
                return new ResponseEntity((Object)vJe.getAlmError(), HttpStatus.BAD_REQUEST);
            }
        }
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/jira-fields"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchFieldsByAlm(@RequestBody HashMap<String, List<String>> param) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        List<String> almAccountIds = param.get("almAccountIds");
        List jiraProjectIssueTypes = this.jiraProjectIssueTypesRepository.findByAlmAccountIdInAndJiraProjectKeyIn(almAccountIds, param.get("projectKeys"));
        for (JiraProjectIssueTypes jpType : jiraProjectIssueTypes) {
            if (!PropertyValidator.isValid((Object)jpType.getIssueTypesReference())) continue;
            jpType.setIssueTypes(MongoSyncUtils.retrieveData((String)jpType.getIssueTypesReference(), (AppConfig.MongoConfig)this.mongoConfig));
        }
        response.put("jiraProjectIssueTypes", jiraProjectIssueTypes);
        response.put("jiraFields", this.aLMSyncService.retrieveJiraFields(almAccountIds));
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/webhooks/{accId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getWebhook(@PathVariable(value="accId") String accId, @RequestBody String originURL) {
        if (accId != null) {
            Gson g = new Gson();
            5 T = new /* Unavailable Anonymous Inner Class!! */;
            try {
                HashMap reqbody = (HashMap)g.fromJson(originURL, T.getType());
                AlmAccount almAcc = AlmUtils.getALMAcount((String)accId, (AlmAccountRepository)this.almAccountRepository);
                WebhookResponseVO webhookObj = this.webHookSyncService.checkJiraWebhookExist(accId, almAcc, (String)reqbody.get("originURL"));
                if (PropertyValidator.isValid((Object)webhookObj)) {
                    return new ResponseEntity((Object)webhookObj, HttpStatus.OK);
                }
            }
            catch (ViztrendJiraException vJe) {
                return new ResponseEntity((Object)vJe.getAlmError(), HttpStatus.BAD_REQUEST);
            }
        }
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/alm/{accountId}/webhooks/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteWebhook(@PathVariable(value="accountId") String accountId, @RequestBody String jiraWebhookUrl) {
        if (accountId != null) {
            AlmAccount almAcc = AlmUtils.getALMAcount((String)accountId, (AlmAccountRepository)this.almAccountRepository);
            almAcc.setWebhookURL(jiraWebhookUrl);
            return new ResponseEntity((Object)this.webHookSyncService.deleteWebhook(almAcc), HttpStatus.OK);
        }
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/alm/workflows"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getProjectWorkflows(@RequestBody String param) {
        if (PropertyValidator.isValid((Object)param)) {
            try {
                return new ResponseEntity(this.aLMSyncService.retrieveProjectWorkflows(param), HttpStatus.OK);
            }
            catch (ViztrendJiraException vJe) {
                return new ResponseEntity((Object)vJe.getAlmError(), HttpStatus.BAD_REQUEST);
            }
        }
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/poll/{requestId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getPollResponse(@PathVariable(value="requestId") String requestId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        PushResponse response = this.pushResponseRepository.findByRequestId(requestId);
        if (PropertyValidator.isValid((Object)response)) {
            if (PropertyValidator.isValid((Object)response.getFileReferenceKey())) {
                if ("JSON".equals(response.getContentType())) {
                    responseJson.put("data", MongoSyncUtils.retrieveData((String)response.getFileReferenceKey(), (AppConfig.MongoConfig)this.mongoConfig));
                } else {
                    responseJson.put("content", MongoSyncUtils.retrieveData((String)response.getFileReferenceKey(), (AppConfig.MongoConfig)this.mongoConfig));
                }
                MongoSyncUtils.removeData((String)response.getFileReferenceKey(), (AppConfig.MongoConfig)this.mongoConfig);
            } else {
                responseJson.put("content", response.getContent());
                responseJson.put("data", response.getData());
            }
            responseJson.put("requestId", response.getRequestId());
            responseJson.put("completed", response.getResponseCompleted());
            responseJson.put("status", 0);
            this.pushResponseRepository.delete((Serializable)((Object)response.getId()));
        } else {
            responseJson.put("status", -1);
            responseJson.put("requestId", requestId);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/alm/projects/{almAccId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getProjectsForKeys(@PathVariable(value="almAccId") String almAccId, @RequestBody HashMap<String, Object> param) {
        AlmAccount almAcc;
        List projects = new ArrayList();
        HashSet projectKeys = new HashSet();
        AlmConfigurations almConfig = null;
        String almConfigId = "";
        HashMap<String, String> jiraMpById = new HashMap<String, String>();
        if (almAccId != null && PropertyValidator.isValid((Object)(almAcc = AlmUtils.getALMAcount((String)almAccId, (AlmAccountRepository)this.almAccountRepository)))) {
            try {
                if (PropertyValidator.isValid(param)) {
                    projectKeys = new HashSet((List)param.get("keys"));
                    almConfigId = (String)param.get("almConfigId");
                    almConfig = (AlmConfigurations)this.almConfigurationsRepository.findOne((Serializable)((Object)almConfigId));
                    projects = this.aLMSyncService.retrieveJiraProjectsByKeys(almAcc, projectKeys);
                    for (JiraProject jiraProject : projects) {
                        jiraMpById.put(jiraProject.getKey(), jiraProject.getName());
                    }
                    for (JiraFilter filter : almConfig.getFeatureFilter()) {
                        for (BacklogMappingLinks projectLinkMapping : filter.getFeatureLinkMappings()) {
                            if (projectLinkMapping.getProjectName() != null && !projectLinkMapping.getProjectName().isEmpty() || (String)jiraMpById.get(projectLinkMapping.getProjectKey()) == null) continue;
                            projectLinkMapping.setProjectName((String)jiraMpById.get(projectLinkMapping.getProjectKey()));
                        }
                    }
                    this.almConfigurationsRepository.save((Object)almConfig);
                }
            }
            catch (ViztrendJiraException vJe) {
                LOGGER.error(StringUtils.getTraceString((Throwable)vJe));
                return new ResponseEntity((Object)vJe, HttpStatus.BAD_REQUEST);
            }
            catch (Exception ex) {
                LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            }
        }
        return new ResponseEntity(almConfig, HttpStatus.OK);
    }

    @RequestMapping(value={"/alm/preview/{almAccId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getDataForPreview(@PathVariable(value="almAccId") String almAccId, @RequestBody Object param) {
        AlmAccount almAcc;
        if (almAccId != null && PropertyValidator.isValid((Object)(almAcc = AlmUtils.getALMAcount((String)almAccId, (AlmAccountRepository)this.almAccountRepository)))) {
            try {
                HashMap validationJson;
                Map paramMap = new HashMap();
                String classType = param.getClass().getName().toLowerCase();
                if (classType.indexOf("string") > -1) {
                    Gson gson = new Gson();
                    6 T = new /* Unavailable Anonymous Inner Class!! */;
                    paramMap = (Map)gson.fromJson((String)param, T.getType());
                } else if (classType.indexOf("map") > -1) {
                    paramMap = (Map)param;
                }
                String metaMap = (String)paramMap.get("metaMap");
                String fitlers = (String)paramMap.get("filter");
                boolean itemsLink = paramMap.get("itemLink") != null;
                Map items = this.aLMSyncService.retrieveDataAgainstJiraFilterForPreview(fitlers, almAcc, paramMap);
                if (itemsLink) {
                    items.put("itemLinks", this.aLMSyncService.retrieveJiraIssueLinkTypesList(almAcc, false));
                }
                ObjectMapper mapper = new ObjectMapper();
                String itemsStr = null;
                if (classType.indexOf("string") > -1) {
                    items.remove("itemIds");
                }
                itemsStr = mapper.writeValueAsString((Object)items);
                JSONObject pushJson = new JSONObject();
                try {
                    pushJson.put("metaMap", (Object)metaMap);
                    pushJson.put("data", (Object)itemsStr);
                    pushJson.put("preview_done", (Object)"true");
                    pushJson.put("type", (Object)"Board");
                    pushJson.put("push", (Object)"Self");
                    if (!PropertyValidator.isValid(paramMap.get("requestId"))) {
                        PushSender.sendMsg((String)pushJson.toString());
                    } else {
                        this.pushResponseRepository.save((Object)new PushResponse((String)paramMap.get("requestId"), pushJson.toString(), Boolean.valueOf(true)));
                    }
                }
                catch (JSONException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
                HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
                if (items.get("error") != null && (validationJson = this.aLMSyncService.validateAlmAccountUser(almAcc, null)).containsKey("exception") && validationJson.containsKey("validationFailed")) {
                    return new ResponseEntity(validationJson.get("exception"), HttpStatus.BAD_REQUEST);
                }
                responseJson.put("success", true);
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            catch (ViztrendJiraException vJe) {
                return new ResponseEntity((Object)vJe, HttpStatus.BAD_REQUEST);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/alm/preview-jql"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getJqLDataForPreview(HttpServletRequest request, @RequestBody Map<String, String> param) {
        String accessDomain = request.getServerName();
        if (SystemUtil.isCloudDomain((String)accessDomain)) {
            if (UserContextUtil.getUserContext().getLoggedInUser().getUserName().equals("sysadmin@kendis.io")) {
                this.aLMSyncService.retrieveJQL(param);
            }
        } else {
            this.aLMSyncService.retrieveJQL(param);
        }
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @RequestMapping(value={"/alm/preview-jira-{property}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getJqLDataForSprint(HttpServletRequest request, @RequestBody Map<String, String> param, @PathVariable(value="property") String property) {
        String body = param.get("body");
        body = body.replace("#jql", property + " IN (" + param.get("jql") + ") AND issuetype != 'Sub-task'");
        param.put("body", body);
        param.remove("jql");
        this.aLMSyncService.retrieveJQL(param);
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @RequestMapping(value={"/alm/preview-meta-by-jira-issues"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getJqLDataForAnyField(HttpServletRequest request, @RequestBody Map<String, String> param) {
        String body = param.get("body");
        String property = param.get("property");
        if (PropertyValidator.isValid((Object)property) && property.indexOf("customfield_") > -1) {
            property = "cf[" + property.replace("customfield_", "") + "]";
        }
        body = body.replace("#jql", property + " IS NOT EMPTY ");
        param.put("body", body);
        param.remove("jql");
        param.remove("property");
        this.aLMSyncService.retrieveJQL(param);
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @RequestMapping(value={"/alm/preview-search"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getSearchDataFormJira(HttpServletRequest request, @RequestBody Map<String, String> param) {
        param.remove("jql");
        this.aLMSyncService.retrieveJQL(param);
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @RequestMapping(value={"/alm/fetchJiraItemsScore"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getJqLDataForScore(HttpServletRequest request, @RequestBody Map<String, String> param) {
        String body = param.get("body");
        body = body.replace("#jql", "Id IN (" + param.get("ids") + ")");
        param.put("body", body);
        param.remove("jql");
        param.put("pushKey", "WSJF_DATA");
        this.aLMSyncService.retrieveJQL(param);
        System.out.println(request);
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @RequestMapping(value={"/alm/linkTypes/{requestId}/{almAccId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getLinkTypes(@PathVariable(value="requestId") String requestId, @PathVariable(value="almAccId") String almAccId, HttpServletRequest request) {
        AlmAccount almAcc;
        boolean jobStarted = false;
        if (almAccId != null && PropertyValidator.isValid((Object)(almAcc = AlmUtils.getALMAcount((String)almAccId, (AlmAccountRepository)this.almAccountRepository)))) {
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            jobStarted = true;
        }
        if (!jobStarted) {
            this.pushResponseRepository.save((Object)new PushResponse(requestId, new HashMap(), Boolean.valueOf(true)));
            AlmError almerr = new AlmError();
            almerr.setAlmErrorMessage("ALM account not found");
            almerr.setHttpErrorCode(Integer.valueOf(404));
            return new ResponseEntity((Object)almerr, HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @RequestMapping(value={"/alm/filterList/{almAccId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getJiraFilterList(@PathVariable(value="almAccId") String almAccId) {
        AlmAccount almAcc;
        if (almAccId != null && PropertyValidator.isValid((Object)(almAcc = AlmUtils.getALMAcount((String)almAccId, (AlmAccountRepository)this.almAccountRepository)))) {
            try {
                return new ResponseEntity((Object)this.aLMSyncService.retrieveJiraFilterList(almAcc), HttpStatus.OK);
            }
            catch (ViztrendJiraException vJe) {
                return new ResponseEntity((Object)vJe.getAlmError(), HttpStatus.BAD_REQUEST);
            }
        }
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid ALM account");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/alm/filterListRefresh/{requestId}/{almAccId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getJiraFilterListRefresh(@PathVariable(value="requestId") String requestId, @PathVariable(value="almAccId") String almAccId) {
        AlmAccount almAcc;
        boolean jobStarted = false;
        if (almAccId != null && PropertyValidator.isValid((Object)(almAcc = AlmUtils.getALMAcount((String)almAccId, (AlmAccountRepository)this.almAccountRepository)))) {
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            jobStarted = true;
        }
        if (!jobStarted) {
            this.pushResponseRepository.save((Object)new PushResponse(requestId, new HashMap(), Boolean.valueOf(true)));
            AlmError almerr = new AlmError();
            almerr.setAlmErrorMessage("Invalid ALM account");
            almerr.setHttpErrorCode(Integer.valueOf(400));
            return new ResponseEntity((Object)almerr, HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @RequestMapping(value={"/alm/boardAndTypesList/{requestId}/{almAccId}/{projectIdOrKey}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> retrieveBoardAndTypesList(@PathVariable(value="requestId") String requestId, @PathVariable(value="almAccId") String almAccId, @PathVariable(value="projectIdOrKey") String projectIdOrKey) {
        if (almAccId != null) {
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            return new ResponseEntity(null, HttpStatus.OK);
        }
        this.pushResponseRepository.save((Object)new PushResponse(requestId, new HashMap(), Boolean.valueOf(true)));
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/alm/projectsAndTypesList"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> retrieveProjectAndTypesList(@RequestBody String requestStr) {
        Gson g = new Gson();
        10 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(requestStr, T.getType());
        String almAccId = (String)reqbody.get("almAccId");
        String requestId = (String)reqbody.get("requestId");
        String jiraBoardId = (String)reqbody.get("jiraBoardId");
        Boolean iskanban = "1".equals((String)reqbody.get("kanban"));
        String sessionBoardId = (String)reqbody.get("sessionBoardId");
        String metaMap = (String)reqbody.get("metaMap");
        if (almAccId != null) {
            try {
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                return new ResponseEntity(new HashMap(), HttpStatus.OK);
            }
            catch (ViztrendJiraException vJe) {
                return new ResponseEntity(vJe.getAlmError() != null ? vJe.getAlmError() : vJe, HttpStatus.BAD_REQUEST);
            }
        }
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/alm/{almAccId}/projects/{projectIdOrKey}/types"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> retrieveProjectTypes(HttpServletRequest request, @PathVariable(value="almAccId") String almAccId, @PathVariable(value="projectIdOrKey") String projectIdOrKey) {
        if (almAccId != null) {
            try {
                AlmAccount almAcc = AlmUtils.getALMAcount((String)almAccId, (AlmAccountRepository)this.almAccountRepository);
                if ("true".equals(request.getParameter("fields"))) {
                    if ("true".equals(request.getParameter("local"))) {
                        HashMap responseJson = new HashMap();
                        this.releaseTrainServiceImpl.fetchJiraIssueTypes(almAcc.getId(), (List)new /* Unavailable Anonymous Inner Class!! */, responseJson);
                        List project = (List)responseJson.get("jiraProjectIssueTypes");
                        if (PropertyValidator.isValid((Collection)project) && project.size() > 0 && PropertyValidator.isValid((Object)((JiraProjectIssueTypes)project.get(0)).getIssueTypes())) {
                            return new ResponseEntity(project.get(0), HttpStatus.OK);
                        }
                        return new ResponseEntity((Object)this.aLMSyncService.retrieveJiraProjectFields(almAcc, projectIdOrKey, Boolean.valueOf(true), Boolean.valueOf(true)), HttpStatus.OK);
                    }
                    return new ResponseEntity((Object)this.aLMSyncService.retrieveJiraProjectFieldsJSON(almAcc, projectIdOrKey), HttpStatus.OK);
                }
                JiraProject project = this.aLMSyncService.retrieveJiraProjectWithDetails(projectIdOrKey, almAcc.getUrl(), almAcc.getUsername(), almAcc.getPassword(), almAcc);
                List typesList = project.getIssueTypes();
                return new ResponseEntity((Object)typesList, HttpStatus.OK);
            }
            catch (ViztrendJiraException vJe) {
                return new ResponseEntity(vJe.getAlmError() != null ? vJe.getAlmError() : vJe, HttpStatus.BAD_REQUEST);
            }
        }
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/alm/{almAccId}/projects/{projectIdOrKey}/statuses"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> retrieveProjectStatuses(HttpServletRequest request, @PathVariable(value="almAccId") String almAccId, @PathVariable(value="projectIdOrKey") String projectIdOrKey) {
        if (almAccId != null) {
            try {
                AlmAccount almAcc = AlmUtils.getALMAcount((String)almAccId, (AlmAccountRepository)this.almAccountRepository);
                return new ResponseEntity((Object)this.aLMSyncService.retrieveProjectStatusesFromJira(projectIdOrKey, almAcc, null), HttpStatus.OK);
            }
            catch (ViztrendJiraException vJe) {
                return new ResponseEntity(vJe.getAlmError() != null ? vJe.getAlmError() : vJe, HttpStatus.BAD_REQUEST);
            }
        }
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/alm/{action}statuses"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> laodProjectStatuses(HttpServletRequest request, @PathVariable(value="action") String action, @RequestBody ResyncParamsVO syncUtils) {
        try {
            boolean sync = false;
            Set keys = syncUtils.projects.keySet();
            AlmAccount alm = syncUtils.almConfigurations.getAlmAccount();
            if ("load-".equals(action)) {
                List statuses = null;
                statuses = syncUtils.isAlmBacklog ? this.statusRepository.findByJiraProjKeyInAndAlmId(syncUtils.projects.keySet(), alm.getId()) : this.statusRepository.findByJiraProjKeyInAndSessionId(syncUtils.projects.keySet(), syncUtils.session.getId());
                if (PropertyValidator.isValid((Collection)statuses)) {
                    return new ResponseEntity((Object)statuses, HttpStatus.OK);
                }
                sync = true;
            } else if ("sync-".equals(action)) {
                sync = true;
            }
            AlmAccount almAcc = AlmUtils.getALMAcount((String)alm.getId(), (AlmAccountRepository)this.almAccountRepository);
            if (sync) {
                syncUtils.almConfigurations = new AlmConfigurations(almAcc);
                return new ResponseEntity((Object)this.releaseTrainServiceImpl.syncJiraStatuses(syncUtils, true), HttpStatus.OK);
            }
            return new ResponseEntity((Object)this.aLMSyncService.retrieveProjectStatusesFromJira((String)keys.iterator().next(), almAcc, null), HttpStatus.OK);
        }
        catch (ViztrendJiraException vJe) {
            return new ResponseEntity(vJe.getAlmError() != null ? vJe.getAlmError() : vJe, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/alm/projectVersions/{almAccId}/{projectKeys}/bulk"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> retrieveProjectVersion(@PathVariable(value="almAccId") String almAccId, @PathVariable(value="projectKeys") String projectKeys) {
        HashMap<String, List> projectVersions = new HashMap<String, List>();
        if (almAccId != null) {
            try {
                String[] projectKeysArr;
                AlmAccount almAcc = AlmUtils.getALMAcount((String)almAccId, (AlmAccountRepository)this.almAccountRepository);
                for (String projectKey : projectKeysArr = projectKeys.split(",")) {
                    JiraProject project = this.aLMSyncService.retrieveJiraProjectWithDetails(projectKey, almAcc.getUrl(), almAcc.getUsername(), almAcc.getPassword(), almAcc);
                    if (project == null) continue;
                    List typesList = project.getVersions();
                    projectVersions.put(projectKey, typesList);
                }
                return new ResponseEntity(projectVersions, HttpStatus.OK);
            }
            catch (ViztrendJiraException vJe) {
                return new ResponseEntity((Object)vJe.getAlmError(), HttpStatus.BAD_REQUEST);
            }
        }
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/alm/{almAccId}/projects/{projectKeys}/bulktypes"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> retrieveBulkProjectsItemTypes(@PathVariable(value="almAccId") String almAccId, @PathVariable(value="projectKeys") String projectKeys) {
        HashMap<String, List> itemTypes = new HashMap<String, List>();
        if (almAccId != null) {
            try {
                String[] projectKeysArr;
                AlmAccount almAcc = AlmUtils.getALMAcount((String)almAccId, (AlmAccountRepository)this.almAccountRepository);
                for (String projectKey : projectKeysArr = projectKeys.split(",")) {
                    JiraProject project = this.aLMSyncService.retrieveJiraProjectWithDetails(projectKey, almAcc.getUrl(), almAcc.getUsername(), almAcc.getPassword(), almAcc);
                    List typesList = project.getIssueTypes();
                    itemTypes.put(projectKey, typesList);
                }
                return new ResponseEntity(itemTypes, HttpStatus.OK);
            }
            catch (ViztrendJiraException vJe) {
                return new ResponseEntity((Object)vJe.getAlmError(), HttpStatus.BAD_REQUEST);
            }
        }
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/alm/boardList/{almAccId}/{project}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> retrieveBoardList(@PathVariable(value="almAccId") String almAccId, @PathVariable(value="projectIdOrKey") String projectIdOrKey) {
        if (almAccId != null) {
            AlmAccount almAcc = AlmUtils.getALMAcount((String)almAccId, (AlmAccountRepository)this.almAccountRepository);
            try {
                return new ResponseEntity((Object)this.aLMSyncService.retrieveJiraBoardsByProjectId(projectIdOrKey, almAcc), HttpStatus.OK);
            }
            catch (Exception e) {
                return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
            }
        }
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/alm/sprintList/{requestId}/{almAccId}/{jiraBoardId}/{sessionBoardId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> retrieveSprintList(@PathVariable(value="requestId") String requestId, @PathVariable(value="almAccId") String almAccId, @PathVariable(value="jiraBoardId") String jiraBoardId, @PathVariable(value="sessionBoardId") String sessionBoardId) {
        if (almAccId != null) {
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            return new ResponseEntity(null, HttpStatus.OK);
        }
        this.pushResponseRepository.save((Object)new PushResponse(requestId, new HashMap(), Boolean.valueOf(true)));
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/alm/boardconfig/{requestId}/{almAccId}/{jiraBoardId}/{sessionBoardId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> retrieveJiraBoardConfig(@PathVariable(value="requestId") String requestId, @PathVariable(value="almAccId") String almAccId, @PathVariable(value="jiraBoardId") String jiraBoardId, @PathVariable(value="sessionBoardId") String sessionBoardId) {
        if (almAccId != null) {
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            return new ResponseEntity(null, HttpStatus.OK);
        }
        this.pushResponseRepository.save((Object)new PushResponse(requestId, new HashMap(), Boolean.valueOf(true)));
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/alm/sprintList/{almAccId}/{jiraBoardIds}/bulk"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> retrieveBoardSprints(@PathVariable(value="almAccId") String almAccId, @PathVariable(value="jiraBoardIds") String jiraBoardIds) {
        HashMap<String, List> boardSprints = new HashMap<String, List>();
        if (almAccId != null) {
            AlmAccount almAcc = AlmUtils.getALMAcount((String)almAccId, (AlmAccountRepository)this.almAccountRepository);
            try {
                String[] boards;
                for (String board : boards = jiraBoardIds.split(",")) {
                    boardSprints.put(board, this.aLMSyncService.retrieveFutureSprintsForJiraBoardForEdit(board, almAcc));
                }
            }
            catch (ViztrendJiraException vJe) {
                return new ResponseEntity(vJe.getAlmError() != null ? vJe.getAlmError() : vJe, HttpStatus.BAD_REQUEST);
            }
            return new ResponseEntity(boardSprints, HttpStatus.OK);
        }
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/alm/projectList/{almAccId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> retrieveProjectList(@PathVariable(value="almAccId") String almAccId) {
        if (almAccId != null) {
            AlmAccount almAcc = AlmUtils.getALMAcount((String)almAccId, (AlmAccountRepository)this.almAccountRepository);
            try {
                return new ResponseEntity((Object)this.aLMSyncService.retrieveJiraProjectList(almAcc), HttpStatus.OK);
            }
            catch (ViztrendJiraException vJe) {
                return new ResponseEntity((Object)vJe.getAlmError(), HttpStatus.BAD_REQUEST);
            }
        }
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/alm/{almAccId}/webhooks"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> createWebhook(@PathVariable(value="almAccId") String almAccId) {
        if (almAccId != null) {
            AlmAccount almAcc = AlmUtils.getALMAcount((String)almAccId, (AlmAccountRepository)this.almAccountRepository);
            try {
                return new ResponseEntity((Object)this.webHookSyncService.createWebhook(almAcc), HttpStatus.OK);
            }
            catch (ViztrendJiraException vJe) {
                return new ResponseEntity((Object)vJe.getAlmError(), HttpStatus.BAD_REQUEST);
            }
        }
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/alm/link"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<Object> linkAlmAccounts(@RequestBody AlmAccount almaccount) {
        if (PropertyValidator.isValid((Object)almaccount)) {
            try {
                return new ResponseEntity((Object)this.aLMSyncService.linkJiraAccount(almaccount), HttpStatus.OK);
            }
            catch (ViztrendJiraException vJe) {
                return new ResponseEntity((Object)vJe.getAlmError(), HttpStatus.BAD_REQUEST);
            }
        }
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/alm/board"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<Object> retrieveBoard(@RequestBody String param) {
        if (param != null) {
            return new ResponseEntity((Object)this.aLMSyncService.retrieveBoard(param), HttpStatus.OK);
        }
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/alm/filter"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<Object> saveFilters(@RequestBody String param) {
        return new ResponseEntity(null, HttpStatus.METHOD_NOT_ALLOWED);
    }

    @RequestMapping(value={"/serverCache/set"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> setServerCache(@RequestBody ServerCache _serverCache) {
        ServerCache server;
        ServerCache _server = this.serverCacheRepository.findByKey(_serverCache.getKey());
        if (PropertyValidator.isValid((Object)_server)) {
            _server.setValue(_serverCache.getValue());
            server = (ServerCache)this.serverCacheRepository.save((Object)_server);
        } else {
            server = (ServerCache)this.serverCacheRepository.save((Object)_serverCache);
        }
        return new ResponseEntity((Object)server, HttpStatus.OK);
    }

    @RequestMapping(value={"/serverCache/get/{key}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getServerCache(@PathVariable(value="key") String key) {
        ServerCache server = this.serverCacheRepository.findByKey(key);
        return new ResponseEntity((Object)server, HttpStatus.OK);
    }

    @RequestMapping(value={"/serverCache/getAndDelete/{key}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getAndDeleteServerCache(@PathVariable(value="key") String key) {
        ServerCache server = this.serverCacheRepository.findByKey(key);
        this.serverCacheRepository.deleteByKey(key);
        return new ResponseEntity((Object)server, HttpStatus.OK);
    }

    @RequestMapping(value={"/alm/fieldList"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getPingJiraFields(@RequestBody String payload) {
        if (PropertyValidator.isValid((Object)payload)) {
            try {
                Gson gson = new Gson();
                15 T = new /* Unavailable Anonymous Inner Class!! */;
                HashMap param = (HashMap)gson.fromJson(payload, T.getType());
                String almAccountId = (String)param.get("almAccountId");
                String isProfile = (String)param.get("isProfile");
                if (isProfile == null) {
                    isProfile = "false";
                    param.put("isAdminAlmAcc", true);
                } else {
                    param.put("isAdminAlmAcc", false);
                }
                if (PropertyValidator.isValid((Object)isProfile) && isProfile.equals("true")) {
                    SecureUser secureUser;
                    User loggeduser;
                    User user;
                    List almCredentials;
                    if (PropertyValidator.isValid(param.get("jiraOauthToken"))) {
                        SecureUser secureUser2;
                        User loggeduser2;
                        User user2;
                        List almCredentials2;
                        Map jiraOauthTokenMap = (Map)new Gson().fromJson((String)param.get("jiraOauthToken"), Map.class);
                        if (!PropertyValidator.isValid(jiraOauthTokenMap.get("privateKey")) && !PropertyValidator.isValid(jiraOauthTokenMap.get("accessToken")) && PropertyValidator.isValid((Collection)(almCredentials2 = (user2 = this.userRepository.findById((loggeduser2 = (User)(secureUser2 = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUserContextDTO().getContextMap().get("user")).getId())).getAlmCredentials()))) {
                            for (AlmAccUser cred : almCredentials2) {
                                if (!cred.getAlmAccId().equals(almAccountId)) continue;
                                if (!PropertyValidator.isValid((Object)cred.getJiraOauthToken())) break;
                                param.put("jiraOauthToken", cred.getJiraOauthToken().toString());
                                if (!JiraOauthToken.ServerAuthType.AUTH_2_0.equals((Object)cred.getJiraOauthToken().getServerAuthType())) break;
                                param.put("OAuthTokenOwnerUserId", user2.getId());
                                break;
                            }
                        }
                        if (JiraUtils.getBooleanValue(jiraOauthTokenMap.get("isCloud"))) {
                            AlmAccount almAccount = new AlmAccount();
                            if (PropertyValidator.isValid((Object)almAccountId)) {
                                AlmAccount editAlm;
                                almAccount = editAlm = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
                                param.put("jiraAuthRedirectURL", String.valueOf(editAlm.getJiraAuthRedirectURL()));
                            }
                            jiraOauthTokenMap = (Map)new Gson().fromJson((String)param.get("jiraOauthToken"), Map.class);
                            JiraOauthToken jiraOauthToken = JiraUtils.parseJiraAuthTokenMap((Map)jiraOauthTokenMap);
                            almAccount.setJiraOauthToken(jiraOauthToken);
                            param.put("url", ALMSyncServiceImpl.getJiraAccessibleResource((AlmAccount)almAccount, (String)"url"));
                            if (PropertyValidator.isValid((Object)almAccount.getJiraOauthToken())) {
                                param.put("jiraOauthToken", almAccount.getJiraOauthToken().toString());
                            } else {
                                param.put("jiraOauthToken", "");
                            }
                        }
                    } else if (!PropertyValidator.isValid(param.get("password")) && PropertyValidator.isValid((Object)almAccountId) && PropertyValidator.isValid((Collection)(almCredentials = (user = this.userRepository.findById((loggeduser = (User)(secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUserContextDTO().getContextMap().get("user")).getId())).getAlmCredentials()))) {
                        for (AlmAccUser cred : almCredentials) {
                            if (!cred.getAlmAccId().equals(almAccountId)) continue;
                            param.put("password", cred.getAlmPassword());
                            param.put("isPatOn", cred.getIsPatOn());
                            break;
                        }
                    }
                } else {
                    AlmAccount almAccount = new AlmAccount();
                    if (PropertyValidator.isValid(param.get("jiraOauthToken"))) {
                        Map jiraOauthTokenMap = (Map)new Gson().fromJson((String)param.get("jiraOauthToken"), Map.class);
                        if (PropertyValidator.isValid((Object)almAccountId)) {
                            AlmAccount editAlm;
                            almAccount = editAlm = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
                            if (!PropertyValidator.isValid(param.get("jiraAuthRedirectURL"))) {
                                param.put("jiraAuthRedirectURL", String.valueOf(editAlm.getJiraAuthRedirectURL()));
                            }
                            if (JiraOauthToken.ServerAuthType.AUTH_2_0.name().equals(jiraOauthTokenMap.get("serverAuthType")) && JiraUtils.isInCompleteJiraAuthToken((Map)jiraOauthTokenMap, (String[])Constants.JIRA_SERVER_AUTH_2_TOKEN_ATTRIBUTES)) {
                                param.put("jiraOauthToken", editAlm.getJiraOauthToken().toString());
                                almAccount.setOAuthTokenOwnerUserId(UserContextUtil.getUserContext().getLoggedInUser().getId());
                            } else if (!JiraOauthToken.ServerAuthType.AUTH_2_0.name().equals(jiraOauthTokenMap.get("serverAuthType")) && (!PropertyValidator.isValid(jiraOauthTokenMap.get("privateKey")) || JiraUtils.getBooleanValue(jiraOauthTokenMap.get("isCloud")) && JiraUtils.isInCompleteJiraAuthToken((Map)jiraOauthTokenMap, (String[])Constants.JIRA_CLOUD_AUTH_TOKEN_ATTRIBUTES))) {
                                param.put("jiraOauthToken", editAlm.getJiraOauthToken().toString());
                            }
                        }
                        if (JiraUtils.getBooleanValue((jiraOauthTokenMap = (Map)new Gson().fromJson((String)param.get("jiraOauthToken"), Map.class)).get("isCloud")) || JiraOauthToken.ServerAuthType.AUTH_2_0.name().equals(jiraOauthTokenMap.get("serverAuthType"))) {
                            JiraOauthToken jiraOauthToken = JiraUtils.parseJiraAuthTokenMap((Map)jiraOauthTokenMap);
                            almAccount.setJiraOauthToken(jiraOauthToken);
                            if (PropertyValidator.isValid((Object)almAccount.getJiraOauthToken())) {
                                param.put("jiraOauthToken", almAccount.getJiraOauthToken().toString());
                            } else {
                                param.put("jiraOauthToken", "");
                            }
                            if (JiraUtils.getBooleanValue(jiraOauthTokenMap.get("isCloud"))) {
                                param.put("url", ALMSyncServiceImpl.getJiraAccessibleResource((AlmAccount)almAccount, (String)"url"));
                            }
                        }
                    } else if (!PropertyValidator.isValid(param.get("password")) && PropertyValidator.isValid((Object)almAccountId)) {
                        AlmAccount editAlm = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
                        param.put("password", editAlm.getPassword());
                        param.put("isPatOn", editAlm.getIsPatOn());
                    }
                }
                this.aLMSyncService.validateJiraUser(param);
                String[] jiraFields = new String[]{(String)param.get("url"), (String)param.get("username"), (String)param.get("password")};
                return new ResponseEntity((Object)this.aLMSyncService.retrieveJiraFields4Preview(param), HttpStatus.OK);
            }
            catch (ViztrendJiraException vJe) {
                return new ResponseEntity((Object)vJe.getAlmError(), HttpStatus.BAD_REQUEST);
            }
        }
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid payload");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/alm/search/{almAccId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> searchJiraIssues(@PathVariable(value="almAccId") String almAccId, @RequestBody String param) {
        AlmAccount almAcc;
        if (almAccId != null && PropertyValidator.isValid((Object)(almAcc = AlmUtils.getALMAcount((String)almAccId, (AlmAccountRepository)this.almAccountRepository))) && PropertyValidator.isValid((Object)param)) {
            try {
                JSONObject requestBody = new JSONObject(param);
                String jql = "summary ~ \"" + requestBody.getString("searchString") + "\" ";
                if (AlmUtils.isValidJiraKey((String)requestBody.getString("searchString")).booleanValue()) {
                    jql = " key=\"" + requestBody.getString("searchString") + "\" ";
                }
                String projectId = null;
                String flaggedField = null;
                if (!requestBody.isNull("projId")) {
                    projectId = requestBody.getString("projId");
                }
                if (!requestBody.isNull("flaggedField")) {
                    flaggedField = requestBody.getString("flaggedField");
                }
                if (PropertyValidator.isValid((Object)projectId)) {
                    jql = jql + " AND project = " + projectId;
                }
                String itemTypeTobeConvertedInto = requestBody.getString("itemTypeTobeConvertedInto");
                List result = this.aLMSyncService.retrieveDataAgainstJiraJql(jql, almAcc, itemTypeTobeConvertedInto, flaggedField);
                return new ResponseEntity((Object)result, HttpStatus.OK);
            }
            catch (ViztrendJiraException vJe) {
                return new ResponseEntity((Object)vJe, HttpStatus.BAD_REQUEST);
            }
            catch (JSONException e) {
                LOGGER.error("FAILED: searchJiraIssues ", (Throwable)e);
            }
        }
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/alm/projectsAndLinks/{almAccId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> retrieveProjectAndLinkTypes(@PathVariable(value="almAccId") String almAccId) {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        if (almAccId != null) {
            AlmAccount almAcc = AlmUtils.getALMAcount((String)almAccId, (AlmAccountRepository)this.almAccountRepository);
            try {
                responseJson.put("linkTypes", this.aLMSyncService.retrieveJiraIssueLinkTypesList(almAcc, false));
                responseJson.put("projectList", this.aLMSyncService.retrieveJiraProjectList(almAcc));
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            catch (ViztrendJiraException vJe) {
                return new ResponseEntity((Object)vJe.getAlmError(), HttpStatus.BAD_REQUEST);
            }
        }
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/alm/{almAccId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getJiraUsers(@PathVariable(value="almAccId") String almAccId, @RequestBody String param) {
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid request payload. Refer to the REST API (/rest/api/3/search/jql) documentation and try again. ");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/app/version"})
    public String getAppVersion() {
        return SystemUtil.getAppVersion();
    }

    @RequestMapping(value={"/app/art/{enable}"})
    public Boolean enableArt(@PathVariable(value="enable") String enabled, HttpServletRequest request) {
        if (SystemUtil.isProductionCloudDomain((String)request.getServerName()) || this.env.getProperty("isLocalDeployment").equals("true")) {
            return null;
        }
        Company company = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompanyId());
        if ("true".equalsIgnoreCase(enabled)) {
            company.setEnableArt(true);
        } else {
            company.setEnableArt(false);
        }
        company = (Company)this.companyRepository.save((Object)company);
        return company.isEnableArt();
    }

    @RequestMapping(value={"/app/health"})
    @ResponseBody
    public ResponseEntity<Object> getReplicaState1(HttpServletRequest request) {
        boolean healthy = false;
        try {
            long startTime = System.currentTimeMillis();
            long threadId = Thread.currentThread().getId();
            LOGGERHEALTH.info("health check test thread Id:" + threadId + " Node Id:" + SystemUtil.getReplicaState());
            boolean elb = "true".equals(request.getParameter("elb"));
            Object result = this.mongoTemplate.getDb().getStats().get("ok");
            if (result.equals(1.0) || result.equals(1)) {
                healthy = true;
                if (elb) {
                    WebHookSyncServiceImpl.elbLastActive = System.currentTimeMillis();
                }
                LOGGERHEALTH.info("health check success ELB:" + elb + " thread Id:" + threadId + " Node Id:" + SystemUtil.getReplicaState() + " in (seconds) :" + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
            } else {
                LOGGERHEALTH.error("health check Failed **** thread Id:" + threadId + " Node Id:" + SystemUtil.getReplicaState() + " in (seconds) :" + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        if (healthy) {
            return new ResponseEntity((Object)SystemUtil.getReplicaState(), HttpStatus.OK);
        }
        return new ResponseEntity((Object)"error", HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/app/loggedin"})
    public String getLoggedInInfo() {
        if (UserContextUtil.getUserContext() != null && UserContextUtil.getUserContext().getLoggedInUser() != null) {
            return UserContextUtil.getUserContext().getLoggedInUser().getUserName();
        }
        return null;
    }

    @RequestMapping(value={"/reset/{type}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> resetCustomization(@PathVariable(value="type") String type) {
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        Company _comp = (Company)this.companyRepository.findOne((Serializable)((Object)cid));
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("success", false);
        try {
            if (PropertyValidator.isValid((Object)_comp)) {
                Customize customize = _comp.getCustomization();
                if (!PropertyValidator.isValid((Object)customize)) {
                    customize = new Customize();
                }
                if ("color".equals(type)) {
                    customize.setHeaderColor("#09c199");
                } else if ("logo".equals(type)) {
                    customize.setLogoPath("");
                } else if ("icon".equals(type)) {
                    customize.setIconPath("");
                }
                responseJson.put("type", type);
                _comp.setCustomization(customize);
                this.companyRepository.save((Object)_comp);
                responseJson.put("success", true);
                responseJson.put("customize", customize);
                SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                User loggeduser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
                List userCompanies = loggeduser.getUserCompanies();
                for (UserCompany userCompany : userCompanies) {
                    if (!userCompany.getCompany().getId().equals(cid)) continue;
                    userCompany.getCompany().setCustomization(customize);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/objective/{boardId}/{action}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveObjective(@PathVariable(value="boardId") String boardId, @PathVariable(value="action") String action, @RequestBody HashMap<String, Object> json) {
        Objective objective = new Objective((String)json.get("title"), (String)json.get("teamId"), (List)json.get("values"));
        try {
            SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)boardId));
            HashMap<String, Objective> oMap = sessionBoard.getObjectivesMap();
            if (!PropertyValidator.isValid((Object)oMap)) {
                oMap = new HashMap<String, Objective>();
                sessionBoard.setObjectiveIds(new ArrayList());
            }
            int found = -1;
            if (action.equals("create")) {
                if (PropertyValidator.isValid((Object)objective.getTeamId()) && !"0".equals(objective.getTeamId())) {
                    for (int i = 0; i < sessionBoard.getObjectiveIds().size(); ++i) {
                        Objective o = (Objective)sessionBoard.getObjectivesMap().get(sessionBoard.getObjectiveIds().get(i));
                        if (!objective.getTeamId().equals(o.getTeamId())) continue;
                        found = i;
                        if (!PropertyValidator.isValid((Collection)o.getValues())) {
                            o.setValues(new ArrayList());
                        }
                        if (PropertyValidator.isValid((Collection)objective.getValues())) {
                            o.getValues().addAll(objective.getValues());
                        }
                        objective = o;
                        break;
                    }
                }
                if (found < 0) {
                    objective.setId(UUID.randomUUID().toString());
                    oMap.put(objective.getId(), objective);
                    sessionBoard.getObjectiveIds().add(0, objective.getId());
                    found = sessionBoard.getObjectiveIds().size() - 1;
                }
            } else if (action.equals("sort")) {
                sessionBoard.setObjectiveIds((List)json.get("ids"));
                found = 0;
            } else {
                objective.setId((String)json.get("id"));
                oMap.get(objective.getId());
                found = sessionBoard.getObjectiveIds().indexOf(objective.getId());
                if (found > -1) {
                    if (action.equals("delete")) {
                        oMap.remove(objective.getId());
                        sessionBoard.getObjectiveIds().remove(found);
                    } else if (action.equals("update")) {
                        ((Objective)oMap.get(objective.getId())).copy(objective);
                    }
                }
            }
            if (found > -1) {
                sessionBoard.setObjectivesMap(oMap);
                sessionBoard = (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard);
                if (!action.equals("delete")) {
                    objective = (Objective)sessionBoard.getObjectivesMap().get(objective.getId());
                }
                if (action.equals("sort")) {
                    return new ResponseEntity((Object)sessionBoard.getObjectiveIds(), HttpStatus.OK);
                }
            }
        }
        catch (Exception e) {
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity((Object)objective, HttpStatus.OK);
    }

    @RequestMapping(value={"/objective-update/{boardId}/{action}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveObjectiveOV(@PathVariable(value="boardId") String boardId, @PathVariable(value="action") String action, @RequestBody HashMap<String, Object> json) {
        Objective objective = new Objective((String)json.get("title"), (String)json.get("teamId"), (List)json.get("values"));
        try {
            Objective savedObjective;
            SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)boardId));
            HashMap oMap = sessionBoard.getObjectivesMap();
            if (!PropertyValidator.isValid((Object)oMap)) {
                oMap = new HashMap();
                sessionBoard.setObjectiveIds(new ArrayList());
            }
            if (!PropertyValidator.isValid((Collection)(savedObjective = (Objective)oMap.get((String)json.get("id"))).getValues())) {
                savedObjective.setValues(new ArrayList());
            }
            if (action.equals("parent")) {
                savedObjective.setTitle(objective.getTitle());
                savedObjective.setTeamId(objective.getTeamId());
            } else if (action.equals("add-ov")) {
                if (PropertyValidator.isValid((Collection)objective.getValues()) && PropertyValidator.isValid(objective.getValues().get(0))) {
                    savedObjective.getValues().add(objective.getValues().get(0));
                }
            } else {
                int index = -1;
                ObjectiveValue ovTobeUpdate = null;
                if (PropertyValidator.isValid((Collection)objective.getValues()) && PropertyValidator.isValid(objective.getValues().get(0))) {
                    ovTobeUpdate = (ObjectiveValue)objective.getValues().get(0);
                    index = savedObjective.getValues().indexOf(new ObjectiveValue(ovTobeUpdate.getId()));
                }
                if (index > -1) {
                    if (action.equals("delete-ov")) {
                        savedObjective.getValues().remove(index);
                    } else if (action.equals("edit-ov")) {
                        if (PropertyValidator.isValid((Object)ovTobeUpdate)) {
                            ((ObjectiveValue)savedObjective.getValues().get(index)).setTitle(ovTobeUpdate.getTitle());
                            ((ObjectiveValue)savedObjective.getValues().get(index)).setType(ovTobeUpdate.getType());
                            ((ObjectiveValue)savedObjective.getValues().get(index)).setActualValue(ovTobeUpdate.getActualValue());
                            ((ObjectiveValue)savedObjective.getValues().get(index)).setPlanValue(ovTobeUpdate.getPlanValue());
                        }
                    } else if (action.equals("link-unlink-ov")) {
                        List ids;
                        LOGGER.debug("inside -- link-unlink-ov");
                        if (!PropertyValidator.isValid((Collection)((ObjectiveValue)savedObjective.getValues().get(index)).getItemIds())) {
                            ((ObjectiveValue)savedObjective.getValues().get(index)).setItemIds(new ArrayList());
                        }
                        if (!PropertyValidator.isValid((Object)((ObjectiveValue)savedObjective.getValues().get(index)).getExternalItemIds())) {
                            ((ObjectiveValue)savedObjective.getValues().get(index)).setExternalItemIds(new HashMap());
                        }
                        if (PropertyValidator.isValid((Collection)(ids = (List)json.get("linkOvItemIds")))) {
                            for (String id : ids) {
                                if (((ObjectiveValue)savedObjective.getValues().get(index)).getItemIds().indexOf(id) >= 0) continue;
                                ((ObjectiveValue)savedObjective.getValues().get(index)).getItemIds().add(id);
                                if (!PropertyValidator.isValid((Object)ovTobeUpdate) || !PropertyValidator.isValid((Object)ovTobeUpdate.getExternalItemIds()) || !ovTobeUpdate.getExternalItemIds().containsKey(id)) continue;
                                ((ObjectiveValue)savedObjective.getValues().get(index)).getExternalItemIds().put(id, ovTobeUpdate.getExternalItemIds().get(id));
                            }
                        }
                        if (PropertyValidator.isValid((Collection)(ids = (List)json.get("unlinkOvItemIds")))) {
                            ArrayList<String> keys = new ArrayList<String>();
                            for (String id : ids) {
                                if (!((ObjectiveValue)savedObjective.getValues().get(index)).getItemIds().remove(id)) {
                                    LOGGER.debug("inside -- link-unlink-ov -- collecting jira Keys");
                                    keys.add(id);
                                }
                                if (!PropertyValidator.isValid((Object)((ObjectiveValue)savedObjective.getValues().get(index)).getExternalItemIds())) continue;
                                ((ObjectiveValue)savedObjective.getValues().get(index)).getExternalItemIds().remove(id);
                            }
                            if (PropertyValidator.isValid(keys)) {
                                LOGGER.debug("inside -- link-unlink-ov -- force deletion");
                                this.removeItemIdFromObjectivLink(((ObjectiveValue)savedObjective.getValues().get(index)).getItemIds(), keys, json);
                            }
                        }
                    } else if (action.equals("link-ov")) {
                        if (PropertyValidator.isValid((Object)ovTobeUpdate)) {
                            ((ObjectiveValue)savedObjective.getValues().get(index)).setExternalItemIds(ovTobeUpdate.getExternalItemIds());
                            ((ObjectiveValue)savedObjective.getValues().get(index)).setItemIds(ovTobeUpdate.getItemIds());
                        }
                    } else if (action.equals("unlink-ov")) {
                        if (PropertyValidator.isValid((Object)ovTobeUpdate) && PropertyValidator.isValid((Collection)ovTobeUpdate.getItemIds()) && PropertyValidator.isValid((Collection)((ObjectiveValue)savedObjective.getValues().get(index)).getItemIds())) {
                            LOGGER.debug("inside -- unlink-ov");
                            if (!((ObjectiveValue)savedObjective.getValues().get(index)).getItemIds().remove(ovTobeUpdate.getItemIds().get(0))) {
                                LOGGER.debug("inside -- unlink-ov -- force deletion");
                                ArrayList keys = new ArrayList();
                                keys.add(ovTobeUpdate.getItemIds().get(0));
                                this.removeItemIdFromObjectivLink(((ObjectiveValue)savedObjective.getValues().get(index)).getItemIds(), keys, json);
                            }
                            if (PropertyValidator.isValid((Object)((ObjectiveValue)savedObjective.getValues().get(index)).getExternalItemIds())) {
                                ((ObjectiveValue)savedObjective.getValues().get(index)).getExternalItemIds().remove(ovTobeUpdate.getItemIds().get(0));
                            }
                        }
                    } else if (action.equals("sort-ov")) {
                        String nextOVId = (String)json.get("nextOVId");
                        if (PropertyValidator.isValid((Object)ovTobeUpdate) && PropertyValidator.isValid((Object)ovTobeUpdate.getType()) && index < savedObjective.getValues().size()) {
                            ((ObjectiveValue)savedObjective.getValues().get(index)).setType(ovTobeUpdate.getType());
                        }
                        if (PropertyValidator.isValid((Object)nextOVId)) {
                            savedObjective.setValues(this.sortObjectiveData(index, savedObjective.getValues(), (Object)new ObjectiveValue(nextOVId)));
                        } else {
                            savedObjective.setValues(this.sortObjectiveData(index, savedObjective.getValues(), null));
                        }
                    }
                }
            }
            sessionBoard.setObjectivesMap(oMap);
            sessionBoard = (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard);
            this.userService.setOnboardingMeta("Manage_Objectives", true);
            this.pushObjectives((Object)savedObjective, boardId, action, json);
            return new ResponseEntity((Object)savedObjective, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    private void removeItemIdFromObjectivLink(List<String> linkedItemIds, List<String> jiraKeys, String sessionBoardId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getCurrentCompany().getTenant()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"jiraKey").in(jiraKeys));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"jiraId").exists(true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is((Object)new ObjectId(sessionBoardId)));
        DBCursor dbCursorPrefix = this.mongoTemplate.getCollection("item").find(query.getQueryObject());
        List items = dbCursorPrefix.toArray();
        if (PropertyValidator.isValid((Collection)items)) {
            for (DBObject _item : items) {
                linkedItemIds.remove(String.valueOf(_item.get("_id")));
            }
        }
    }

    private void removeItemIdFromObjectivLink(List<String> linkedItemIds, List<String> ids, HashMap<String, Object> json) {
        if (PropertyValidator.isValid((Object)json.get("changedItemIds"))) {
            Map map = (Map)json.get("changedItemIds");
            for (String id : ids) {
                if (!map.containsKey(id)) continue;
                linkedItemIds.remove(String.valueOf(map.get(id)));
            }
        }
    }

    @RequestMapping(value={"/objective-sort/{boardId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> sortObjective(@PathVariable(value="boardId") String boardId, @RequestBody HashMap<String, Object> json) {
        try {
            SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)boardId));
            String oid = (String)json.get("id");
            String nextObjectiveId = (String)json.get("nextObjectiveId");
            if (!PropertyValidator.isValid((Collection)sessionBoard.getObjectiveIds())) {
                sessionBoard.setObjectiveIds(new ArrayList());
            }
            int index = sessionBoard.getObjectiveIds().indexOf(oid);
            if (PropertyValidator.isValid((Object)nextObjectiveId)) {
                sessionBoard.setObjectiveIds(this.sortObjectiveData(index, sessionBoard.getObjectiveIds(), (Object)nextObjectiveId));
            } else {
                sessionBoard.setObjectiveIds(this.sortObjectiveData(index, sessionBoard.getObjectiveIds(), null));
            }
            sessionBoard = (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard);
            return new ResponseEntity((Object)sessionBoard.getObjectiveIds(), HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    private List sortObjectiveData(int index, List list, Object next) {
        Object ov = list.remove(index);
        if (PropertyValidator.isValid((Object)next)) {
            int nextIndex = list.indexOf(next);
            if (nextIndex > -1) {
                ArrayList one = new ArrayList(list.subList(0, nextIndex));
                ArrayList two = new ArrayList(list.subList(nextIndex, list.size()));
                one.add(ov);
                one.addAll(two);
                list = one;
            } else {
                list.add(ov);
            }
        } else {
            list.add(ov);
        }
        return list;
    }

    @RequestMapping(value={"/export/objective/{type}"})
    @ResponseBody
    public ResponseEntity<Object> exportReport(@PathVariable(value="type") String type, @RequestBody HashMap<String, Object> json) {
        try {
            String boardId = (String)json.get("boardId");
            List columns = (List)json.get("columns");
            SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)boardId));
            HashMap oMap = sessionBoard.getObjectivesMap();
            List oids = sessionBoard.getObjectiveIds();
            ArrayList itemIds = new ArrayList();
            ArrayList<String> teamIds = new ArrayList<String>();
            List items = new ArrayList();
            HashMap<String, Object> map = new HashMap<String, Object>();
            HashMap childmap = new HashMap();
            if (PropertyValidator.isValid((Collection)oids)) {
                int i;
                for (i = 0; i < oids.size(); ++i) {
                    List ovalues = ((Objective)oMap.get(oids.get(i))).getValues();
                    if (PropertyValidator.isValid((Collection)ovalues)) {
                        for (int j = 0; j < ovalues.size(); ++j) {
                            if (!PropertyValidator.isValid((Collection)((ObjectiveValue)ovalues.get(j)).getItemIds()) || !PropertyValidator.isValid((Collection)((ObjectiveValue)ovalues.get(j)).getItemIds())) continue;
                            for (int ii = 0; ii < ((ObjectiveValue)ovalues.get(j)).getItemIds().size(); ++ii) {
                                if (!PropertyValidator.isValid(((ObjectiveValue)ovalues.get(j)).getItemIds().get(ii))) continue;
                                itemIds.add(((ObjectiveValue)ovalues.get(j)).getItemIds().get(ii));
                            }
                        }
                    }
                    if (!PropertyValidator.isValid((Object)((Objective)oMap.get(oids.get(i))).getTeamId()) || PropertyValidator.isValid((Object)((Objective)oMap.get(oids.get(i))).getTitle())) continue;
                    teamIds.add(((Objective)oMap.get(oids.get(i))).getTeamId());
                }
                if (itemIds.size() > 0) {
                    items = this.itemRepository.findByIdIn(itemIds);
                    for (i = 0; i < items.size(); ++i) {
                        map.put(((Item)items.get(i)).getId(), items.get(i));
                    }
                    items = this.itemRepository.findByParentIdIn(itemIds);
                    for (i = 0; i < items.size(); ++i) {
                        if (childmap.get(((Item)items.get(i)).getParent().getId()) == null) {
                            childmap.put(((Item)items.get(i)).getParent().getId(), new ArrayList());
                        }
                        ((List)childmap.get(((Item)items.get(i)).getParent().getId())).add(items.get(i));
                    }
                    map.put("childmap", childmap);
                }
                if (teamIds.size() > 0) {
                    for (i = 0; i < sessionBoard.getTeams().size(); ++i) {
                        map.put(((Team)sessionBoard.getTeams().get(i)).getId(), sessionBoard.getTeams().get(i));
                    }
                }
            }
            String extension = "xls";
            int exportType = 1;
            if (PropertyValidator.isValid((Object)type) && "csv".equalsIgnoreCase(type)) {
                extension = "csv";
                exportType = 0;
            }
            HashMap infoMap = new HashMap();
            String filePath = this.exportService.exportObjectiveData(exportType, sessionBoard, map, columns);
            String downloadName = AlmUtils.cleanText((String)(sessionBoard.getSession().getTitle() + "_" + AlmUtils.cleanText((String)"objectives"))) + "." + extension;
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("srcPath", filePath);
            data.put("name", URLEncoder.encode(downloadName, "UTF-8"));
            return new ResponseEntity(data, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    private void pushObjectives(Object data, String boardId, String action, HashMap<String, Object> json) {
        try {
            if (PropertyValidator.isValid((Object)json.get("syncId"))) {
                Gson gson = new Gson();
                String cid = UserContextUtil.getUserContext().getCurrentCompany().getId();
                HashMap<String, Object> pushJson = new HashMap<String, Object>();
                HashMap<String, Object> meta = new HashMap<String, Object>();
                meta.put("event", "Objectives");
                meta.put("boardId", boardId);
                meta.put("syncId", json.get("syncId"));
                pushJson.put("type", "Objectives");
                pushJson.put("push", "Self");
                pushJson.put("metaMap", gson.toJson(meta));
                pushJson.put("ObjectiveData", data);
                PushSender.sendMsg((String)gson.toJson(pushJson));
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    @RequestMapping(value={"/download"}, method={RequestMethod.GET})
    public ResponseEntity<ByteArrayResource> downloadReport(HttpServletRequest request) {
        try {
            if (request.getParameter("cid") != null && request.getParameter("cid").equals(UserContextUtil.getUserContext().getCurrentCompanyId())) {
                String filePath = request.getParameter("srcPath");
                String downloadName = request.getParameter("name");
                String tmpFileLoc = this.env.getProperty("temp.file.location");
                int index = filePath.lastIndexOf(File.separator);
                filePath = tmpFileLoc + filePath.substring(index + 1);
                File responsefile = new File(filePath);
                Path path = Paths.get(filePath, new String[0]);
                ByteArrayResource resource = new ByteArrayResource(Files.readAllBytes(path));
                HttpHeaders headers = new HttpHeaders();
                headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
                headers.add("Pragma", "no-cache");
                headers.add("Expires", "0");
                headers.add("Content-Disposition", "attachment; filename=\"" + downloadName + "\"");
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength(responsefile.length()).contentType(MediaType.parseMediaType((String)"application/octet-stream")).body((Object)resource);
            }
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return null;
    }

    @Scheduled(fixedRate=20000L)
    public void deleteTempFiles() {
        String tmpFileLoc = this.env.getProperty("temp.file.location");
        Object[] files = new File(tmpFileLoc).listFiles();
        if (PropertyValidator.isValid((Object[])files)) {
            for (Object file : files) {
                try {
                    BasicFileAttributes attributes = Files.readAttributes(((File)file).toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    Calendar nowDate = Calendar.getInstance();
                    nowDate.add(12, 1);
                    long diff = nowDate.getTimeInMillis() - attributes.creationTime().toMillis();
                    diff = diff / 1000L / 60L;
                    if (diff <= 1L) continue;
                    ((File)file).delete();
                }
                catch (IOException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
        }
    }

    @RequestMapping(value={"/debug/{debug}"})
    public Map setDebug(@PathVariable(value="debug") String debug) throws Exception {
        if (!this.env.getProperty("isLocalDeployment").equals("true")) {
            return null;
        }
        HashMap<String, Boolean> kv = new HashMap<String, Boolean>();
        if (debug.equals("check")) {
            kv.put("debug", HealthController.isDebug());
            return kv;
        }
        if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext())) {
            if (debug.equals("true")) {
                HealthController.changeLoggerDebug((boolean)true);
                this.customRepository.enableAlmAccountsDebugMode(true);
            } else {
                HealthController.changeLoggerDebug((boolean)false);
                this.customRepository.enableAlmAccountsDebugMode(false);
            }
            kv.put("debug", UserContextUtil.getUserContext().isDebug());
        } else {
            kv.put("loginRequired", true);
        }
        return kv;
    }

    @RequestMapping(value={"/signoutothers"})
    public void logoutFromOtherSessions(HttpServletRequest request, HttpServletResponse response) {
        this.customSignout(request.getSession().getId());
    }

    @RequestMapping(value={"/signoutall"})
    public void logoutFromAllSessions(HttpServletRequest request, HttpServletResponse response) {
        this.customSignout(null);
        try {
            response.sendRedirect("/signout");
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    private void customSignout(String excludeSession) {
        BasicDBObject queryObj = new BasicDBObject();
        queryObj.put("principal", (Object)UserContextUtil.getUserContext().getUsername());
        DBCursor cursor = this.mongoTemplate.getDb().getCollection("sessions").find((DBObject)queryObj);
        ArrayList<String> sessionIds = new ArrayList<String>();
        while (cursor.hasNext()) {
            DBObject obj = cursor.next();
            sessionIds.add(String.valueOf(obj.get("_id")));
        }
        for (String sessionId : sessionIds) {
            if (sessionId.equals(excludeSession)) continue;
            this.sessionRegistry.removeSessionInformation(sessionId);
            BasicDBObject queryObjSession = new BasicDBObject();
            queryObjSession.put("_id", (Object)sessionId);
            this.mongoTemplate.getDb().getCollection("sessions").remove((DBObject)queryObjSession);
        }
        this.tokenRepository.deleteByUsername(UserContextUtil.getUserContext().getUsername());
        for (SessionInformation session : this.sessionRegistry.getAllSessions((Object)UserContextUtil.getUserContext(), false)) {
            if (session.getSessionId().equals(excludeSession)) continue;
            session.expireNow();
        }
    }

    @RequestMapping(value={"/survey/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveSurveyData(@RequestBody String surveyData) {
        KendisStats stats = this.kendisStatsRepository.findByCompanyId(UserContextUtil.getUserContext().getCurrentCompanyId());
        if (stats != null) {
            stats.setSurveyData(surveyData);
            Map kv = (Map)new Gson().fromJson(surveyData, Map.class);
            kv.put("company", UserContextUtil.getUserContext().getCurrentCompany().getName());
            kv.put("prefix", UserContextUtil.getUserContext().getCurrentCompany().getUrlPrefix());
            kv.put("user", UserContextUtil.getUserContext().getLoggedInUser().getUserName());
            kv.put("contact", UserContextUtil.getUserContext().getLoggedInUser().getContact());
            String to = this.env.getProperty("email.admin");
            LOGGER.debug("sending survey email to :" + to);
            this.mailSender.sendMail(to, "New Signup - " + UserContextUtil.getUserContext().getCurrentCompany().getName(), "surveyTemplate", kv, true);
            LOGGER.debug("email sent with vars  :" + kv.toString());
            this.kendisStatsRepository.save((Object)stats);
            this.userService.createOnboardGuide();
            return new ResponseEntity((Object)"", HttpStatus.OK);
        }
        return new ResponseEntity((Object)"", HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/chkforvalidemail"})
    public boolean checkValidEmail(@RequestParam String _u) throws Exception {
        return this.userRepository.findByUserNameIgnoreCase(_u) != null;
    }

    @RequestMapping(value={"/myns"}, method={RequestMethod.GET})
    public String getMyNS(HttpServletRequest request) {
        if (!SystemUtil.isProductionCloudDomain((String)request.getServerName())) {
            SecureUser secureUser = UserContextUtil.getUserContext();
            return String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        }
        return null;
    }

    @RequestMapping(value={"/load-{type}-items"})
    @ResponseBody
    public ResponseEntity<Object> retrieveStories(HttpServletRequest request, @PathVariable(value="type") String type, @RequestBody Map<String, List<String>> param) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("done", Boolean.TRUE.toString().equals(request.getParameter("done")));
        try {
            DBObject projection;
            Query query = new Query();
            List<String> list = null;
            String refTC = "teamContainers.$id";
            String refJD = "jiraDependencies.$id";
            String refLK = "itemLinks.$id";
            list = param.get("fields");
            if (PropertyValidator.isValid(list)) {
                for (String string : list) {
                    query.fields().include(string);
                }
            }
            if (PropertyValidator.isValid((Object)(projection = query.getFieldsObject()))) {
                if (projection.containsField("jiraDependencies")) {
                    refJD = "jiraDependencies._id";
                } else {
                    query.fields().include(refJD);
                }
                if (projection.containsField("itemLinks")) {
                    refLK = "itemLinks._id";
                } else {
                    query.fields().include(refLK);
                }
                if (projection.containsField("teamContainers")) {
                    refTC = "teamContainers._id";
                } else {
                    query.fields().include(refTC);
                }
            } else {
                query.fields().include("");
            }
            list = param.get("parentIds");
            if (PropertyValidator.isValid(list)) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"parent.$id").in((Collection)KendisUtils.getListAsObjectIds(list)));
            }
            list = param.get("planned");
            if (PropertyValidator.isValid((Collection)param.get("planned"))) {
                if (list.indexOf("true") > -1) {
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)refTC).exists(true));
                } else if (list.indexOf("false") > -1) {
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)refTC).exists(false));
                }
            }
            if (PropertyValidator.isValid(list = param.get("lines"))) {
                if (list.indexOf("alm") > -1) {
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)refJD).exists(true));
                }
                if (list.indexOf("kendis") > -1) {
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)refLK).exists(true));
                }
            }
            ArrayList<String> types = new ArrayList<String>();
            if ("parent".equals(type)) {
                types.add(Item.Type.Feature.name());
            } else if ("child".equals(type)) {
                types.add(Item.Type.UserStory.name());
            }
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").in(types));
            responseJson.put("items", this.customRepositoryImpl.findItemsByAggregation(null, KendisUtils.getListAsObjectIds((Collection)param.get("boardIds")), null, null, query));
        }
        catch (Exception e) {
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error("retrieveItemsByIds", (Object)err);
            return new ResponseEntity((Object)err, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/load-items"})
    @ResponseBody
    public ResponseEntity<Object> retrieveItems(@RequestBody Map<String, List<String>> param) {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        try {
            Query query = new Query();
            Criteria c5 = null;
            if (PropertyValidator.isValid((Collection)param.get("types"))) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").in(param.get("types")));
            }
            if (PropertyValidator.isValid((Collection)param.get("originItemIds"))) {
                c5 = Criteria.where((String)"originItemId").in((Collection)param.get("originItemIds"));
            }
            Criteria c1 = Criteria.where((String)"_id").in((Collection)KendisUtils.getListAsObjectIds((Collection)param.get("itemIds")));
            Criteria c2 = Criteria.where((String)"parent.$id").in((Collection)KendisUtils.getListAsObjectIds((Collection)param.get("parentIds")));
            Criteria c3 = Criteria.where((String)"jiraKey").in((Collection)param.get("keys"));
            Criteria c4 = Criteria.where((String)"tfsId").in((Collection)param.get("keys"));
            Criteria criteria = new Criteria();
            if (c5 == null) {
                criteria.orOperator(new Criteria[]{c1, c2, c3, c4});
            } else {
                criteria.orOperator(new Criteria[]{c1, c2, c3, c4, c5});
            }
            query.addCriteria((CriteriaDefinition)criteria);
            responseJson.put("items", this.customRepositoryImpl.findItemsByAggregation(null, KendisUtils.getListAsObjectIds((Collection)param.get("boardIds")), null, null, query));
        }
        catch (Exception e) {
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error("retrieveItemsByIds", (Object)err);
            return new ResponseEntity((Object)err, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/load-lines"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> loadBoardLinesCall(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        HashSet statusIds = null;
        if (payload.containsKey("statusIds")) {
            statusIds = new HashSet((ArrayList)payload.get("statusIds"));
        }
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("wfStatus");
        fields.add("responsible");
        fields.add("reporter");
        if (statusIds == null) {
            statusIds = new HashSet();
        }
        try {
            List list = (List)payload.get("itemLinksIds");
            if (PropertyValidator.isValid((Collection)list)) {
                responseJson.put("itemLinks", this.customRepositoryImpl.getByObjectId(KendisUtils.getListAsObjectIds2((Collection)list), ItemLink.class, fields, statusIds));
            }
            if (PropertyValidator.isValid((Collection)(list = (List)payload.get("jiraDependenciesIds")))) {
                List jiraDependencies = this.customRepositoryImpl.getByObjectId(KendisUtils.getListAsObjectIds2((Collection)list), ItemJiraDependency.class, fields, statusIds);
                if (PropertyValidator.isValid((Collection)jiraDependencies)) {
                    for (DBObject jiraDep : jiraDependencies) {
                        String tfsLinkType;
                        if (PropertyValidator.isValid((Object)jiraDep.get("jiraDependencyId")) || !PropertyValidator.isValid((Object)jiraDep.get("sourceItemId")) || !PropertyValidator.isValid((Object)jiraDep.get("targetItemId")) || !PropertyValidator.isValid((Object)(tfsLinkType = (String)jiraDep.get("tfsLinkType")))) continue;
                        DBObject targetTfsItem = (DBObject)jiraDep.get("targetTFSItem");
                        DBObject sourceTfsItem = (DBObject)jiraDep.get("sourceTFSItem");
                        String[] type = tfsLinkType.split("-");
                        List<String> typeList = Arrays.asList(type);
                        if (typeList != null && typeList.size() > 1 && PropertyValidator.isValid((Object)sourceTfsItem.get("tfsId")) && PropertyValidator.isValid((Object)targetTfsItem.get("tfsId"))) {
                            if (typeList.get(1).equals("Reverse")) {
                                jiraDep.put("jiraDependencyId", (Object)(targetTfsItem.get("tfsId") + "-" + sourceTfsItem.get("tfsId")));
                                continue;
                            }
                            jiraDep.put("jiraDependencyId", (Object)(sourceTfsItem.get("tfsId") + "-" + targetTfsItem.get("tfsId")));
                            continue;
                        }
                        jiraDep.put("jiraDependencyId", (Object)(sourceTfsItem.get("tfsId") + "-" + targetTfsItem.get("tfsId")));
                    }
                }
                responseJson.put("jiraDependencies", jiraDependencies);
            }
            if (PropertyValidator.isValid(statusIds)) {
                responseJson.put("statuses", this.customRepositoryImpl.getByObjectId(KendisUtils.getListAsObjectIds2(statusIds), Status.class, null, null));
                responseJson.put("users", this.customRepositoryImpl.getByObjectId(KendisUtils.getListAsObjectIds2(statusIds), User.class, null, null));
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/load-boards"})
    @ResponseBody
    public ResponseEntity<Object> retrieveBoards(@RequestBody Map<String, List<String>> param) {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        try {
            List bids = KendisUtils.getListAsObjectIds(param.get("boardIds"));
            List boards = this.customRepositoryImpl.getByObjectId((Collection)bids, SessionBoard.class);
            ArrayList<String> snsids = new ArrayList<String>();
            ArrayList<String> tids = new ArrayList<String>();
            ArrayList<String> sids = new ArrayList<String>();
            for (DBObject dbo : boards) {
                String refId;
                String boardId = String.valueOf(dbo.get("_id"));
                dbo.put("id", (Object)boardId);
                dbo.removeField("_id");
                List list2 = (List)dbo.get("teams");
                dbo.put("teams", new ArrayList());
                for (DBRef ref : list2) {
                    refId = String.valueOf(ref.getId());
                    tids.add(refId);
                    ((List)dbo.get("teams")).add(refId);
                }
                list2 = (List)dbo.get("containers");
                dbo.put("containers", new ArrayList());
                for (DBRef ref : list2) {
                    refId = String.valueOf(ref.getId());
                    sids.add(refId);
                    ((List)dbo.get("containers")).add(refId);
                }
                DBRef ref = (DBRef)dbo.get("session");
                dbo.put("session", (Object)String.valueOf(ref.getId()));
                snsids.add((String)dbo.get("session"));
            }
            responseJson.put("boards", boards);
            responseJson.put("sessions", this.sessionRepository.findMinimalSessionsByIdIn(snsids));
            responseJson.put("containers", this.containerRepository.findByIdIn(sids));
            responseJson.put("teams", this.teamRepository.findByIdIn(tids));
        }
        catch (Exception e) {
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error("retrieveBoardsByIds", (Object)err);
            return new ResponseEntity((Object)err, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/itemsByIds"})
    @ResponseBody
    public ResponseEntity<Object> retrieveItemsByIds(@RequestBody Map<String, List<String>> param) {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getCurrentCompany().getTenant()));
            if (PropertyValidator.isValid((Collection)param.get("types"))) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").in(param.get("types")));
            }
            if (PropertyValidator.isValid((Collection)param.get("boardIds"))) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").in((Collection)KendisUtils.getListAsObjectIds((Collection)param.get("boardIds"))));
            }
            Criteria criteria = new Criteria();
            criteria.orOperator(new Criteria[]{Criteria.where((String)"_id").in((Collection)KendisUtils.getListAsObjectIds((Collection)param.get("itemIds"))), Criteria.where((String)"parent.$id").in((Collection)KendisUtils.getListAsObjectIds((Collection)param.get("parentIds"))), Criteria.where((String)"jiraKey").in((Collection)param.get("keys")), Criteria.where((String)"tfsId").in((Collection)param.get("keys"))});
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").ne((Object)true));
            query.addCriteria((CriteriaDefinition)criteria);
            List items = this.mongoTemplate.find(query, Item.class);
            responseJson.put("items", items);
        }
        catch (Exception e) {
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error("retrieveItemsByIds", (Object)err);
            return new ResponseEntity((Object)err, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    public void startCommitedLoadAfterDelay(SessionBoard sessionBoard, long delayTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 11);
        calendar.set(12, 59);
        calendar.set(13, 0);
        Date time = calendar.getTime();
        Date now = new Date();
        Long delay = time.getTime() - now.getTime();
        new Timer().schedule((TimerTask)new /* Unavailable Anonymous Inner Class!! */, delay);
    }

    @SchedLock(name="processStartEndSprint")
    @Scheduled(fixedRate=300000L)
    @RequestMapping(value={"/check-sprint-dates"}, method={RequestMethod.GET})
    public void processStartEndSprint() {
        try {
            17 states = new /* Unavailable Anonymous Inner Class!! */;
            this.customRepositoryImpl.autoStartEndSprint(null, (List)states, null, null, false);
            this.customRepositoryImpl.autoStartEndSprint(null, (List)states, null, null, true);
        }
        catch (Exception e) {
            LOGGER.debug(StringUtils.getTraceString((Throwable)e));
        }
    }

    @ResponseBody
    private ResponseEntity<Object> runCommitedLoad(HashMap<String, Object> request) {
        try {
            LOGGER.debug("..... start-end Sprint ..... controller.....");
            HashMap<String, Object> mapBidByTidSid = new HashMap<String, Object>();
            String bid = (String)request.get("boardId");
            List tids = (List)request.get("teamIds");
            List sids = (List)request.get("containerIds");
            String syncId = (String)request.get("syncId");
            Boolean isSpillOver = Boolean.TRUE.equals(request.get("spill"));
            User user = UserContextUtil.getUserContext().getLoggedInUser();
            SessionBoard board = this.sessionBoardRepository.findBoardById(bid);
            mapBidByTidSid.put("debug", request.get("debug"));
            mapBidByTidSid.put("end_action", request.get("end_action"));
            KendisUtils.putStartEndSprintParam(mapBidByTidSid, (SessionBoard)board, (List)tids, (List)sids);
            return new ResponseEntity((Object)this.customRepositoryImpl.saveSpillOverOver(user.getUserName(), mapBidByTidSid, tids, sids, null, syncId, isSpillOver, null, null, true), HttpStatus.OK);
        }
        catch (Exception e) {
            String exp = StringUtils.getTraceString((Throwable)e);
            LOGGER.error("/save/commitedLoad...... : " + exp);
            return new ResponseEntity((Object)exp, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/save/commitedLoad"})
    @ResponseBody
    public ResponseEntity<Object> startCommitedLoad(@RequestBody HashMap<String, Object> request) {
        if (request.get("thread") == null) {
            return this.runCommitedLoad(request);
        }
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return null;
    }

    @RequestMapping(value={"/spillOver"})
    public ResponseEntity<Object> saveSpillOver(@RequestBody Map<String, AuditLog> auditMap) {
        try {
            if (PropertyValidator.isValid(auditMap)) {
                List logs = this.auditLogRepository.findByIdIn(auditMap.keySet());
                for (AuditLog log : logs) {
                    log.setAuditData(auditMap.get(log.getId()).getAuditData());
                }
                logs = this.auditLogRepository.save((Iterable)logs);
            }
            return new ResponseEntity(auditMap, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e), (Object)"spillOver failed with exeption");
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/save/velocity"})
    @ResponseBody
    public ResponseEntity<Object> saveVelocity(@RequestBody TeamSprintVelocity teamSprintVelocity) {
        TeamSprintVelocity tsv;
        String syncId = teamSprintVelocity.getMetaMap();
        if (PropertyValidator.isValid((Object)teamSprintVelocity) && PropertyValidator.isValid((Object)teamSprintVelocity.getId()) && PropertyValidator.isValid((Object)(tsv = (TeamSprintVelocity)this.teamSprintVelocityRepository.findOne((Serializable)((Object)teamSprintVelocity.getId()))))) {
            if (PropertyValidator.isValid((Object)teamSprintVelocity.getVelocity())) {
                tsv.setVelocity(teamSprintVelocity.getVelocity());
            }
            if (PropertyValidator.isValid((Object)teamSprintVelocity.getCommitedLoad())) {
                tsv.setCommitedLoad(teamSprintVelocity.getCommitedLoad());
            }
            teamSprintVelocity = tsv;
        }
        tsv = (TeamSprintVelocity)this.teamSprintVelocityRepository.save((Object)teamSprintVelocity);
        JSONObject pushJson = new JSONObject();
        try {
            HashMap<String, String> metaMap = new HashMap<String, String>();
            Gson gson = new Gson();
            pushJson.put("type", (Object)"Board");
            metaMap.put("event", "Velocity");
            metaMap.put("type", "Board");
            metaMap.put("boardId", tsv.getSessionBoardId());
            metaMap.put("syncId", syncId);
            pushJson.put("metaMap", (Object)gson.toJson(metaMap));
            pushJson.put("velocities", (Object)("[" + gson.toJson((Object)tsv, TeamSprintVelocity.class) + "]"));
            PushSender.sendMsg((String)pushJson.toString());
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", true);
        responseJson.put("velocity", (Boolean)tsv);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private Boolean persistPiTeamCapacity(String sessionId, String sessionBoardId, TeamSprintVelocity teamSprintVelocity) {
        try {
            HashMap responseJson;
            if (PropertyValidator.isValid((Object)teamSprintVelocity) && PropertyValidator.isValid((Object)sessionId) && PropertyValidator.isValid((Object)sessionBoardId) && (responseJson = this.piJourneyService.getPiJourneyData(sessionId, sessionBoardId)) != null) {
                PiJourney piJourney = (PiJourney)responseJson.get("journey");
                Team queryTeam = new Team();
                queryTeam.setId(teamSprintVelocity.getTeamId());
                PiTeamCapacity piTeamCapacity = this.piTeamCapacityRepository.findByPiJourneyIdAndSessionIdAndTeam(piJourney.getId(), sessionId, queryTeam);
                if (!piTeamCapacity.getShowTeamLevelCapacity().booleanValue()) {
                    return false;
                }
                if (piTeamCapacity != null && piTeamCapacity.getTeamCapacity() != null) {
                    for (PiContainerCapacity piContainerCapacity : piTeamCapacity.getTeamCapacity()) {
                        if (!Objects.equals(piContainerCapacity.getContainerId(), teamSprintVelocity.getSprintId())) continue;
                        piContainerCapacity.setCapacity(Float.valueOf((float)teamSprintVelocity.getVelocity().doubleValue()));
                        break;
                    }
                    this.piTeamCapacityRepository.save((Object)piTeamCapacity);
                }
            }
            return true;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return false;
        }
    }

    @RequestMapping(value={"/session-timezone"})
    public ResponseEntity<Object> saveSessionTimeZone(@RequestBody SessionBoard sessionBoard) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        try {
            boolean timeChanegd = false;
            SessionBoard saved = this.sessionBoardRepository.findById(sessionBoard.getId());
            if (sessionBoard.getTzEnabled() != null) {
                saved.setTzEnabled(sessionBoard.getTzEnabled());
            }
            if (sessionBoard.getTzSite() != null) {
                saved.setTzSite(sessionBoard.getTzSite());
                timeChanegd = true;
            }
            if (sessionBoard.getTzStartTime() != null) {
                saved.setTzStartTime(sessionBoard.getTzStartTime());
                timeChanegd = true;
            }
            if (sessionBoard.getTzEndTime() != null) {
                saved.setTzEndTime(sessionBoard.getTzEndTime());
                timeChanegd = true;
            }
            if (sessionBoard.getTzStartTimeDiff() != null) {
                saved.setTzStartTimeDiff(sessionBoard.getTzStartTimeDiff());
                timeChanegd = true;
            }
            if (sessionBoard.getTzEndTimeDiff() != null) {
                saved.setTzEndTimeDiff(sessionBoard.getTzEndTimeDiff());
                timeChanegd = true;
            }
            if (saved.getTzStartTime() == null) {
                saved.setTzStartTime("18:15");
            }
            if (saved.getTzEndTime() == null) {
                saved.setTzEndTime("18:00");
            }
            String zoneId = sessionBoard.getLocalZone();
            SessionBoard board = (SessionBoard)this.sessionBoardRepository.save((Object)saved);
            List sprints = board.calcSchedulerTime(zoneId, board.getContainers());
            if (PropertyValidator.isValid((Collection)sprints)) {
                this.containerRepository.save((Iterable)sprints);
                if (timeChanegd) {
                    // empty if block
                }
            }
            responseJson.put("success", true);
            responseJson.put("sessionBoard", (Boolean)saved);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/session-sprintReport"})
    public ResponseEntity<Object> save(@RequestBody String requestJson) {
        if (PropertyValidator.isValid((Object)requestJson)) {
            Gson g = new Gson();
            19 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)g.fromJson(requestJson, T.getType());
            String boardId = (String)reqbody.get("sessionBoardId");
            String scheduleType = (String)reqbody.get("scheduleType");
            List selectedUsers = (List)reqbody.get("selectedUsers");
            SessionBoard saved = this.sessionBoardRepository.findById(boardId);
            if (PropertyValidator.isValid((Object)scheduleType)) {
                saved.setScheduleType(scheduleType);
            }
            if (PropertyValidator.isValid((Collection)selectedUsers)) {
                saved.setUserListForSprintReportEmail(selectedUsers);
            }
        }
        return null;
    }

    @RequestMapping(value={"/download-pdf/{param}"})
    public ResponseEntity<ByteArrayResource> downloadPDF(@PathVariable(value="param", required=false) String param) {
        try {
            param = EncDecUtility.decryptSimple((String)param);
            Gson gson = new Gson();
            Map map = (Map)gson.fromJson(param, Map.class);
            String uuId = (String)map.get("_uuId");
            String b64Image = MongoSyncUtils.retrieveData((String)uuId, (AppConfig.MongoConfig)this.mongoConfig);
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put("imgData", b64Image);
            String downloadName = "report";
            String fileLoc = this.localMailSender.generatePDFWithImage("share_PDF_template", dataMap, downloadName);
            downloadName = downloadName + ".pdf";
            File responsefile = new File(fileLoc);
            Path path = Paths.get(fileLoc, new String[0]);
            ByteArrayResource resource = new ByteArrayResource(Files.readAllBytes(path));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=\"" + downloadName + "\"");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength(responsefile.length()).contentType(MediaType.parseMediaType((String)"application/octet-stream")).body((Object)resource);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"/externalLinks"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> externalLinks() {
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        try {
            List externalLinks = new ArrayList();
            String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
            Company comp = this.companyRepository.findById(cid);
            externalLinks = this.externalLinksRepository.findByTenant(comp.getTenant());
            response.put("externalLinks", (Serializable)((Object)externalLinks));
        }
        catch (Exception e) {
            response.put("success", Boolean.valueOf(false));
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/saveExternalLink"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveExternalLink(@RequestBody ExternalLinks externalLink) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            this.externalLinksRepository.save((Object)externalLink);
            String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
            Company comp = this.companyRepository.findById(cid);
            if (comp.getCustomization().getExternalLinksPresent() != null) {
                if (!comp.getCustomization().getExternalLinksPresent().booleanValue()) {
                    this.customRepository.updateExternalLinksPresent("customization.externalLinksPresent", true);
                }
            } else {
                this.customRepository.updateExternalLinksPresent("customization.externalLinksPresent", true);
            }
            response.put("externalLink", externalLink);
        }
        catch (Exception e) {
            response.put("success", false);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/remove/externalLink"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> removeExternalLink(@RequestBody ExternalLinks externalLink) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            if (PropertyValidator.isValid((Object)externalLink)) {
                this.externalLinksRepository.delete((Serializable)((Object)externalLink.getId()));
            }
            if (this.externalLinksRepository.findOne((Serializable)((Object)UserContextUtil.getUserContext().getCurrentCompany().getTenant())) == null) {
                this.customRepository.updateExternalLinksPresent("customization.externalLinksPresent", false);
            }
            response.put("success", true);
            response.put("id", externalLink.getId());
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    static /* synthetic */ PushResponseRepository access$000(RestController x0) {
        return x0.pushResponseRepository;
    }

    static /* synthetic */ AlmAccountRepository access$100(RestController x0) {
        return x0.almAccountRepository;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }

    static /* synthetic */ ImportUtil access$300(RestController x0) {
        return x0.importUtil;
    }

    static /* synthetic */ AppConfig.MongoConfig access$400(RestController x0) {
        return x0.mongoConfig;
    }

    static /* synthetic */ ResponseEntity access$500(RestController x0, HashMap x1) {
        return x0.runCommitedLoad(x1);
    }
}

