/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.enums.EnumActivityType;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.enums.EnumStatusCategory;
import com.viztrend.safe.persistence.entity.AlmAccUser;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.AuditLog;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Group;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.ItemLog;
import com.viztrend.safe.persistence.entity.ItemLogMap;
import com.viztrend.safe.persistence.entity.ItemTypeScheme;
import com.viztrend.safe.persistence.entity.PushResponse;
import com.viztrend.safe.persistence.entity.Report;
import com.viztrend.safe.persistence.entity.ReportChart;
import com.viztrend.safe.persistence.entity.ScoreCard;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.State;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.BaseItemLinkRepository;
import com.viztrend.safe.persistence.repository.BaseItemRepository;
import com.viztrend.safe.persistence.repository.ContainerRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.GroupRepository;
import com.viztrend.safe.persistence.repository.IssueTypeRepository;
import com.viztrend.safe.persistence.repository.ItemLogMapRepository;
import com.viztrend.safe.persistence.repository.ItemLogRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.ReportChartRepository;
import com.viztrend.safe.persistence.repository.ReportRepository;
import com.viztrend.safe.persistence.repository.ScoreCardRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.StateRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TeamContainerRepository;
import com.viztrend.safe.persistence.repository.TeamRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceAccessRoleRepository;
import com.viztrend.safe.service.ALMSyncService;
import com.viztrend.safe.service.CustomFieldService;
import com.viztrend.safe.service.ExportService;
import com.viztrend.safe.service.ImportService;
import com.viztrend.safe.service.PlanService;
import com.viztrend.safe.service.SprintReportServics;
import com.viztrend.safe.service.StatsService;
import com.viztrend.safe.service.TFSservice;
import com.viztrend.safe.utils.AlmUtils;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.LocalMailSender;
import com.viztrend.safe.utils.MongoSyncUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.SystemUtil;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.UserVO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.bson.types.ObjectId;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/reports"})
@Controller
public class ReportsController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportsController.class);
    @Autowired
    ImportService importService;
    @Autowired
    private StateRepository stateRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private IssueTypeRepository issueTypeRepository;
    @Autowired
    private TeamRepository teamRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private PlanService planService;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private ReportRepository reportRepository;
    @Autowired
    private ScoreCardRepository scoreCardRepository;
    @Autowired
    private ReportChartRepository reportChartRepository;
    @Autowired
    private ExportService exportService;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private TeamContainerRepository teamContainerRepository;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private Environment env;
    @Autowired
    private AppConfig.MongoConfig mongoConfig;
    @Autowired
    private LocalMailSender mailSender;
    @Autowired
    private WorkSpaceAccessRoleRepository accessRoleRepository;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private ALMSyncService almSyncService;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private SprintReportServics sprintReportServics;
    @Autowired
    private StatsService statsService;
    @Autowired
    private PushResponseRepository pushResponseRepository;
    @Autowired
    private ItemLogRepository itemLogRepository;
    @Autowired
    private ItemLogMapRepository itemLogMapRepository;
    @Autowired
    private TFSUtils tfsUtils;
    @Autowired
    private TFSservice tfSservice;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private BaseItemLinkRepository baseItemLinkRepository;
    @Autowired
    private BaseItemRepository baseItemRepository;
    @Autowired
    private CustomFieldService customFieldService;

    private List<DBObject> getItemsForDIfferentBoards(List<ObjectId> allActiveSessionBoards, Map<String, Boolean> validParent, Map<String, Status> statusMapById, Map<String, TeamContainer> mappedTc, Map<String, String> nextStateIds, Map<String, String> nextStateIdsRemoved) {
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.fields().include("_id");
        query.fields().include("originItemId");
        query.fields().include("nextStateId");
        query.fields().include("parent");
        query.fields().include("title");
        query.fields().include("subItemEstimate");
        query.fields().include("status");
        query.fields().include("jiraKey");
        query.fields().include("jiraId");
        query.fields().include("tfsId");
        query.fields().include("tfsURL");
        query.fields().include("itemLinks");
        query.fields().include("sessionBoards");
        query.fields().include("jiraDependencies");
        query.fields().include("teamContainers");
        query.fields().include("issueType");
        query.fields().include("createdOn");
        query.fields().include("updatedOn");
        query.fields().include("dueDate");
        query.fields().include("storyPoints");
        query.fields().include("externalReferenceURL");
        query.fields().include("createdBy");
        query.fields().include("duplicateOfId");
        query.fields().include("updatedBy");
        query.fields().include("type");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").in(allActiveSessionBoards));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query.getQueryObject());
        ArrayList<DBObject> rawItems = new ArrayList<DBObject>();
        HashSet<String> statusIds = new HashSet<String>();
        HashSet<String> tcIds = new HashSet<String>();
        List statuses = null;
        while (dbCursorPrefix.hasNext()) {
            List tcs;
            DBObject dbo = dbCursorPrefix.next();
            String id = String.valueOf(dbo.get("_id"));
            DBRef statusRef = (DBRef)dbo.get("status");
            if (statusRef != null && statusRef.getId() != null) {
                statusIds.add(String.valueOf(statusRef.getId()));
            }
            if (Item.Type.Feature.name().equals(dbo.get("type"))) {
                validParent.put(id, true);
            }
            if (PropertyValidator.isValid((Collection)(tcs = (List)dbo.get("teamContainers")))) {
                int size = tcs.size();
                if (Item.Type.UserStory.name().equals(dbo.get("type"))) {
                    size = 1;
                } else if (Item.Type.Feature.name().equals(dbo.get("type"))) {
                    size = tcs.size();
                }
                for (int i = 0; i < size; ++i) {
                    tcIds.add(String.valueOf(((DBRef)tcs.get(i)).getId()));
                }
            }
            rawItems.add(dbo);
            if (nextStateIds != null && nextStateIdsRemoved != null) {
                if (dbo.containsField("duplicateOfId")) {
                    nextStateIds.put((String)dbo.get("duplicateOfId"), id);
                    nextStateIdsRemoved.remove((String)dbo.get("duplicateOfId"));
                }
                nextStateIdsRemoved.remove(id);
                continue;
            }
            if (nextStateIds != null || nextStateIdsRemoved == null) continue;
            if (dbo.containsField("nextStateId")) {
                nextStateIdsRemoved.put((String)dbo.get("nextStateId"), id);
                continue;
            }
            nextStateIdsRemoved.put(id, id);
        }
        statuses = this.statusRepository.findByIdIn(statusIds);
        if (PropertyValidator.isValid((Collection)statuses)) {
            for (Status status : statuses) {
                statusMapById.put(status.getId(), status);
            }
            statuses.clear();
        }
        if (PropertyValidator.isValid(tcIds)) {
            List tcs = this.teamContainerRepository.findByIdIn(tcIds);
            if (PropertyValidator.isValid((Collection)tcs)) {
                for (TeamContainer tc : tcs) {
                    mappedTc.put(tc.getId(), tc);
                    if (nextStateIds == null || tc.getContainer() == null || tc.getContainer().getDuplicateOfId() == null) continue;
                    nextStateIds.put(tc.getContainer().getDuplicateOfId(), tc.getContainer().getId());
                }
            }
            tcIds.clear();
            tcs.clear();
        }
        return rawItems;
    }

    private List<DBObject> getTeamCapacity(List<String> sessionBoardIds) {
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoardId").in(sessionBoardIds));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("teamSprintVelocity").find(query.getQueryObject());
        return dbCursorPrefix.toArray();
    }

    @RequestMapping(value={"/deliverybyteam/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getDataByTeam(@PathVariable(value="id") String sessionId, @RequestBody Map<String, Object> requestStr) {
        HashMap response = new HashMap();
        try {
            response = this.statsService.getDataByTeam(sessionId, requestStr);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @RequestMapping(value={"/boardscomparison"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getItems(@RequestBody String requestStr) throws IOException {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.statsService.getItems(requestStr);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/selectedBoards"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getSelectedBoards(@RequestBody Map<String, String> requestStr) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.statsService.getSelectedBoards(requestStr);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/pireport/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getPiReport(@PathVariable(value="id") String sessionId, @RequestBody Map<String, Object> requestStr) {
        HashMap response = new HashMap();
        try {
            response = this.statsService.getPiReport(sessionId, requestStr);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @RequestMapping(value={"/itemPath/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public HashMap<String, Object> getItemPath(@PathVariable(value="id") String itemId) {
        try {
            HashMap itemPathCompleatLog = new HashMap();
            itemPathCompleatLog = this.statsService.getItemPath(itemId);
            return itemPathCompleatLog;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    @RequestMapping(value={"/sprint-report-genration/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public AuditLog generateSprintReport(@PathVariable(value="id") String sessionId, @RequestBody Map<String, Object> requestStr) {
        try {
            String sprintId = (String)requestStr.get("sprintId");
            String description = (String)requestStr.get("description");
            String settings = (String)requestStr.get("settings");
            AuditLog sprintReport = this.sprintReportServics.sprintReportGenration(sessionId, sprintId, description, settings, null);
            return sprintReport;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    @RequestMapping(value={"/get-processing-sprint-report-flag/{sprintId}"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean getprocessingSprintReportFlag(@PathVariable(value="sprintId") String sprintId) {
        boolean processingSprintReportFlag = false;
        try {
            Container activeSprint = this.containerRepository.findById(sprintId);
            if (activeSprint.getProcessingSprintReport().booleanValue()) {
                processingSprintReportFlag = activeSprint.getProcessingSprintReport();
            }
            return processingSprintReportFlag;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return processingSprintReportFlag;
        }
    }

    @RequestMapping(value={"/get-sprint-report/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public DBObject getSprintReport(@PathVariable(value="id") String sessionId, @RequestBody Map<String, Object> requestStr) {
        try {
            String sprintId = (String)requestStr.get("sprintId");
            DBObject sprintReport = this.sprintReportServics.getSprintReport(sessionId, sprintId);
            return sprintReport;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    @RequestMapping(value={"/get-sprint-report-version/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ArrayList<Object> getSprintReportVersion(@PathVariable(value="id") String sessionId, @RequestBody Map<String, Object> requestStr) {
        try {
            String sprintId = (String)requestStr.get("sprintId");
            ArrayList sprintReportVersion = this.sprintReportServics.getSprintReportVersion(sessionId, sprintId);
            return sprintReportVersion;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    @RequestMapping(value={"/get-sprint-report-selected-version/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public AuditLog getSprintReportSelectedVersion(@PathVariable(value="id") String auditLogId) {
        try {
            AuditLog sprintReport = this.sprintReportServics.sprintReportSelectedVersion(auditLogId);
            return sprintReport;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    @RequestMapping(value={"/save-sprint-report-description"}, method={RequestMethod.POST})
    @ResponseBody
    public AuditLog saveSprintReportDescription(@RequestBody Map<String, Object> requestStr) {
        try {
            String auditLogId = (String)requestStr.get("auditLogId");
            AuditLog sprintReport = this.sprintReportServics.saveSprintReportExtraData(auditLogId, requestStr);
            return sprintReport;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    @RequestMapping(value={"/riskanalytics"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getRiskAnalytics(@RequestBody HashMap<String, Object> requestPayload) {
        HashMap itemPathCompleatLog = new HashMap();
        try {
            itemPathCompleatLog = this.statsService.getRiskStatsBySprintAndTeam(requestPayload);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return new ResponseEntity((Object)itemPathCompleatLog, HttpStatus.OK);
    }

    @RequestMapping(value={"/meta"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getMeta(@RequestBody String requestPayload) {
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        User user = UserContextUtil.getUserContext().getLoggedInUser();
        HashMap<String, Object> meta = new HashMap<String, Object>();
        Query query = new Query();
        query.with(new Sort(Sort.Direction.DESC, new String[]{"updatedOn"}));
        ArrayList<String> users = new ArrayList<String>();
        users.add(user.getId());
        List userGroups = this.groupRepository.findByUsersIn(users);
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group g : userGroups) {
            groupIds.add(g.getId());
        }
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)("sharedWith." + user.getId())).is((Object)true), Criteria.where((String)"sharedWithGroups").in(groupIds)});
        query.addCriteria((CriteriaDefinition)criteria);
        List reports = this.mongoTemplate.find(query, Report.class);
        meta.put("reports", reports);
        meta.put("users", this.userRepository.findByUserCompanies_Company_IdAndUserCompanies_isArchive(cid, Boolean.valueOf(false)));
        meta.put("boards", this.planService.getAllAccessableBoardsWithMinimumData(null));
        meta.put("itemTypes", this.issueTypeRepository.findAllByOrderBySequenceAsc());
        meta.put("teams", this.planService.getAllCompanyTeamWithLimitedData());
        meta.put("states", this.planService.getAllCompanyStatesWithLimitedData());
        meta.put("cid", cid);
        PageRequest pageable = new PageRequest(0, 10000);
        Page page = this.groupRepository.findAll((Pageable)pageable);
        List groups = page.getContent();
        meta.put("groups", groups);
        ScoreCard savedScoreCard = this.scoreCardRepository.findByType(ScoreCard.Type.WSJF.toString());
        meta.put("scoreCard", savedScoreCard);
        meta.put("kendisFields", this.customFieldService.getKendisCustomFieldsFromDefaultLayout(EnumKendis.KENDIS_ONLY_CARD.getCode()));
        return new ResponseEntity(meta, HttpStatus.OK);
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveReport(@RequestBody Report report) {
        this.reportRepository.save((Object)report);
        return new ResponseEntity((Object)report, HttpStatus.OK);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteReport(@RequestBody Report report) {
        if (PropertyValidator.isValid((Object)report) && PropertyValidator.isValid((Object)report.getId())) {
            this.reportRepository.delete((Serializable)((Object)report.getId()));
            return new ResponseEntity((Object)report.getId(), HttpStatus.OK);
        }
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @RequestMapping(value={"/key"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> checkKey(@RequestBody String key) {
        List existing = this.reportRepository.findByUrlKey(key);
        if (PropertyValidator.isValid((Collection)existing)) {
            return new ResponseEntity((Object)Boolean.TRUE, HttpStatus.OK);
        }
        return new ResponseEntity((Object)Boolean.FALSE, HttpStatus.OK);
    }

    @RequestMapping(value={"/dependencies/{almId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> dependencies(@RequestBody List<String> tcIds, @PathVariable String almId) {
        AlmAccount almaccount;
        HashMap<String, List> reponse = new HashMap<String, List>();
        List items = this.itemRepository.findByTeamContainersIdIn(tcIds);
        reponse.put("linkedItems", items);
        if (PropertyValidator.isValid((Object)almId) && PropertyValidator.isValid((Object)(almaccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId))))) {
            reponse.put("jiraIssueLinkTypes", this.almSyncService.retrieveJiraIssueLinkTypesList(almaccount, false));
        }
        return new ResponseEntity(reponse, HttpStatus.OK);
    }

    @RequestMapping(value={"/report/meta"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> sessionBoards(@RequestBody Report report) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashMap filters = report.getFilters();
        if (PropertyValidator.isValid((Object)filters)) {
            String sessionId = (String)filters.get("sessionId");
            if (PropertyValidator.isValid((Object)sessionId)) {
                List items = this.planService.getSessionBoards(sessionId);
                response.put("sessionBoards", items);
                ArrayList<Container> sprints = new ArrayList<Container>();
                HashMap<String, String> tempSprintMap = new HashMap<String, String>();
                for (SessionBoard sb : items) {
                    List containers = sb.getContainers();
                    for (Container container : containers) {
                        if (tempSprintMap.get(container.getTitle()) != null) continue;
                        tempSprintMap.put(container.getTitle(), "true");
                        sprints.add(container);
                    }
                }
                Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
                if (PropertyValidator.isValid((Object)session.getTfsAlmConfigurations())) {
                    AlmAccount almAccount = session.getTfsAlmConfigurations().getAlmAccount();
                    HashMap linkTypesResult = this.tfSservice.retrieveJiraIssueLinkTypesList(almAccount, false);
                    if (PropertyValidator.isValid(linkTypesResult.get("tfsALMErrorCode"))) {
                        response.put("tfsALMErrorCode", linkTypesResult.get("tfsALMErrorCode"));
                        response.put("tfsALMErrorMessage", linkTypesResult.get("tfsALMErrorMessage"));
                    } else {
                        response.put("tfsLinkTypes", (String)linkTypesResult.get("linkTypes"));
                    }
                }
                ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
                ids.add(new ObjectId(session.getItemWorkFlow().getId()));
                ids.add(new ObjectId(session.getSubItemWorkFlow().getId()));
                Query query = new Query();
                Criteria criteria = new Criteria();
                criteria.orOperator(new Criteria[]{Criteria.where((String)"sessionId").is((Object)sessionId), Criteria.where((String)"workFlow.$id").in(ids)});
                query.addCriteria((CriteriaDefinition)criteria);
                List statuses = this.mongoTemplate.find(query, Status.class);
                response.put("statuses", statuses);
                response.put("sprints", sprints);
            } else {
                List sbiIDs = (List)filters.get("sessionBoards");
                List sessionBoards = this.sessionBoardRepository.findByIdIn(sbiIDs);
                ArrayList<ObjectId> workflowIds = new ArrayList<ObjectId>();
                ArrayList<String> sessionIds = new ArrayList<String>();
                ArrayList<Container> sprints = new ArrayList<Container>();
                HashMap<String, String> tempSprintMap = new HashMap<String, String>();
                Session tfsSession = null;
                if (PropertyValidator.isValid((Collection)sessionBoards)) {
                    for (SessionBoard sb : sessionBoards) {
                        Session session = sb.getSession();
                        sessionIds.add(session.getId());
                        workflowIds.add(new ObjectId(session.getItemWorkFlow().getId()));
                        workflowIds.add(new ObjectId(session.getSubItemWorkFlow().getId()));
                        List containers = sb.getContainers();
                        for (Container container : containers) {
                            if (tempSprintMap.get(container.getTitle()) != null) continue;
                            tempSprintMap.put(container.getTitle(), "true");
                            sprints.add(container);
                        }
                        if (!PropertyValidator.isValid((Object)session.getTfsAlmConfigurations())) continue;
                        tfsSession = session;
                    }
                }
                if (PropertyValidator.isValid(tfsSession)) {
                    AlmAccount almAccount = tfsSession.getTfsAlmConfigurations().getAlmAccount();
                    HashMap linkTypesResult = this.tfSservice.retrieveJiraIssueLinkTypesList(almAccount, false);
                    if (PropertyValidator.isValid(linkTypesResult.get("tfsALMErrorCode"))) {
                        response.put("tfsALMErrorCode", linkTypesResult.get("tfsALMErrorCode"));
                        response.put("tfsALMErrorMessage", linkTypesResult.get("tfsALMErrorMessage"));
                    } else {
                        response.put("tfsLinkTypes", (String)linkTypesResult.get("linkTypes"));
                    }
                }
                Query query = new Query();
                Criteria criteria = new Criteria();
                criteria.orOperator(new Criteria[]{Criteria.where((String)"sessionId").in(sessionIds), Criteria.where((String)"workFlow.$id").in(workflowIds)});
                query.addCriteria((CriteriaDefinition)criteria);
                List statuses = this.mongoTemplate.find(query, Status.class);
                response.put("statuses", statuses);
                response.put("sprints", sprints);
            }
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/prepareBoardData/{sessionId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> prepareBoardDataForReport(@PathVariable String sessionId) {
        List sessionBoards = this.planService.getSessionBoards(sessionId);
        if (sessionBoards.size() <= 1) {
            HashMap response = new HashMap();
            return new ResponseEntity(response, HttpStatus.OK);
        }
        Collections.sort(sessionBoards, (o1, o2) -> o1.getCreationDate().compareTo(o2.getCreationDate()));
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
        if (PropertyValidator.isValid((Object)session)) {
            LOGGER.debug("REPORT INDEX REQ || SESSION : " + session.getTitle());
            if (session.getOriginIdSynched().booleanValue()) {
                LOGGER.debug("REPORT INDEX REQ || SESSION Alreay Synced");
            } else {
                LOGGER.debug("REPORT INDEX REQ || SESSION No Synced");
            }
        }
        HashMap<String, Item> itemMapByIdOrOrigionId = new HashMap<String, Item>();
        HashMap<String, Item> itemMapByJiraKey = new HashMap<String, Item>();
        HashMap teamContainerMap = new HashMap();
        HashMap containerMap = new HashMap();
        HashMap teamContainerMapDuplicateCheck = new HashMap();
        ArrayList<Item> bulkSaveItems = new ArrayList<Item>();
        ArrayList bulkSaveContainers = new ArrayList();
        ArrayList bulkSaveTeamContainers = new ArrayList();
        for (int sessionBoardIndex = 0; sessionBoardIndex < sessionBoards.size(); ++sessionBoardIndex) {
            SessionBoard sessionBoard = (SessionBoard)sessionBoards.get(sessionBoardIndex);
            LOGGER.debug("REPORT INDEX RES || SESSION BOARD " + sessionBoardIndex);
            LOGGER.debug("REPORT INDEX RES || FIXING CONTAINERS");
            int sbIndex = sessionBoardIndex;
            List containers = sessionBoard.getContainers();
            if (PropertyValidator.isValid((Collection)containers)) {
                containers.forEach(container -> {
                    Container duplicateC;
                    containerMap.put(container.getId(), container);
                    if (sbIndex > 0 && PropertyValidator.isValid((Object)container.getDuplicateOfId()) && PropertyValidator.isValid((Object)(duplicateC = (Container)containerMap.get(container.getDuplicateOfId())))) {
                        if (PropertyValidator.isValid((Object)duplicateC.getOriginItemId())) {
                            container.setOriginItemId(duplicateC.getOriginItemId());
                        } else {
                            container.setOriginItemId(duplicateC.getId());
                        }
                        bulkSaveContainers.add(container);
                    }
                });
            }
            List items = this.itemRepository.findBySessionBoardsIdIn(sessionBoard.getId());
            LOGGER.debug("REPORT INDEX RES || FIXING CONTAINERS");
            for (int itemIndex = 0; itemIndex < items.size(); ++itemIndex) {
                Item duplicateOf;
                List teamContainers;
                Item item = (Item)items.get(itemIndex);
                itemMapByIdOrOrigionId.put(item.getId(), item);
                if (PropertyValidator.isValid((Object)item.getJiraKey()) && !PropertyValidator.isValid(itemMapByJiraKey.get(item.getJiraKey()))) {
                    itemMapByJiraKey.put(item.getJiraKey(), item);
                }
                if (itemIndex < 10) {
                    LOGGER.debug("REPORT INDEX RES || ITEM " + itemIndex);
                    LOGGER.debug("REPORT INDEX RES || ORIG ID : " + item.getOriginItemId());
                    LOGGER.debug("REPORT INDEX RES || DUPL ID : " + item.getDuplicateOfId());
                }
                if (PropertyValidator.isValid((Collection)(teamContainers = item.getTeamContainers()))) {
                    teamContainers.forEach(tc -> {
                        TeamContainer duplicateTC;
                        teamContainerMap.put(tc.getId(), tc);
                        if (sbIndex > 0 && PropertyValidator.isValid((Object)tc.getDuplicateOfId()) && PropertyValidator.isValid((Object)(duplicateTC = (TeamContainer)teamContainerMap.get(tc.getDuplicateOfId())))) {
                            if (PropertyValidator.isValid((Object)duplicateTC.getOriginItemId())) {
                                tc.setOriginItemId(duplicateTC.getOriginItemId());
                            } else {
                                tc.setOriginItemId(duplicateTC.getId());
                            }
                            if (!PropertyValidator.isValid(teamContainerMapDuplicateCheck.get(tc.getId()))) {
                                teamContainerMapDuplicateCheck.put(tc.getId(), true);
                                bulkSaveTeamContainers.add(tc);
                            }
                        }
                    });
                }
                if (sessionBoardIndex <= 0) continue;
                if (PropertyValidator.isValid((Object)item.getDuplicateOfId())) {
                    duplicateOf = (Item)itemMapByIdOrOrigionId.get(item.getDuplicateOfId());
                    if (!PropertyValidator.isValid((Object)duplicateOf)) continue;
                    if (PropertyValidator.isValid((Object)duplicateOf.getOriginItemId())) {
                        item.setOriginItemId(duplicateOf.getOriginItemId());
                    } else {
                        item.setOriginItemId(duplicateOf.getId());
                    }
                    bulkSaveItems.add(item);
                    continue;
                }
                if (!PropertyValidator.isValid((Object)item.getJiraKey()) || !PropertyValidator.isValid((Object)(duplicateOf = (Item)itemMapByJiraKey.get(item.getJiraKey())))) continue;
                if (PropertyValidator.isValid((Object)duplicateOf.getOriginItemId())) {
                    item.setOriginItemId(duplicateOf.getOriginItemId());
                } else {
                    item.setOriginItemId(duplicateOf.getId());
                }
                bulkSaveItems.add(item);
            }
        }
        LOGGER.debug("REPORT INDEX RES || SAVING ITEMS");
        if (PropertyValidator.isValid(bulkSaveItems)) {
            this.itemRepository.save(bulkSaveItems);
        }
        LOGGER.debug("REPORT INDEX RES || SAVING CONTAINERS");
        if (PropertyValidator.isValid(bulkSaveContainers)) {
            this.containerRepository.save(bulkSaveContainers);
        }
        LOGGER.debug("REPORT INDEX RES || SAVING TC");
        if (PropertyValidator.isValid(bulkSaveTeamContainers)) {
            this.teamContainerRepository.save(bulkSaveTeamContainers);
        }
        session.setOriginIdSynched(Boolean.valueOf(true));
        this.planService.saveSession(session);
        return new ResponseEntity((Object)session, HttpStatus.OK);
    }

    @RequestMapping(value={"/filters"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> applyFilters(@RequestBody Report report) {
        HashMap<String, List> response = new HashMap<String, List>();
        response.put("parent", new ArrayList());
        response.put("child", new ArrayList());
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        try {
            Item item;
            List allSessionBoardIds;
            HashMap filters = report.getFilters();
            List ids = report.getListAsObjectIds((List)filters.get("sessionBoards"));
            List sbiIDs = (List)filters.get("sessionBoards");
            List sessionBoards = this.sessionBoardRepository.findByIdIn(sbiIDs);
            HashMap<String, SessionBoard> sessionBoardMapById = new HashMap<String, SessionBoard>();
            HashMap teamMapById = new HashMap();
            HashMap containerMapById = new HashMap();
            ArrayList<ObjectId> worflowIds = new ArrayList<ObjectId>();
            ArrayList<String> sessionIds = new ArrayList<String>();
            HashMap<String, String> tempMap = new HashMap<String, String>();
            HashSet fields = new HashSet();
            if (PropertyValidator.isValid((Collection)sessionBoards)) {
                for (int i = 0; i < sessionBoards.size(); ++i) {
                    List con;
                    SessionBoard sb = (SessionBoard)sessionBoards.get(i);
                    sb.setSession(sb.getSession());
                    if (report.getType() == 1) {
                        if (i == 0) {
                            sessionIds.add(sb.getSession().getId());
                            worflowIds.add(new ObjectId(sb.getSession().getItemWorkFlow().getId()));
                            worflowIds.add(new ObjectId(sb.getSession().getSubItemWorkFlow().getId()));
                        }
                    } else {
                        sessionIds.add(sb.getSession().getId());
                        if (tempMap.get(sb.getSession().getItemWorkFlow().getId()) == null) {
                            worflowIds.add(new ObjectId(sb.getSession().getItemWorkFlow().getId()));
                            tempMap.put(sb.getSession().getItemWorkFlow().getId(), "");
                        }
                        if (tempMap.get(sb.getSession().getSubItemWorkFlow().getId()) == null) {
                            worflowIds.add(new ObjectId(sb.getSession().getSubItemWorkFlow().getId()));
                            tempMap.put(sb.getSession().getSubItemWorkFlow().getId(), "");
                        }
                        sb.getSession().setClientTimeZone(report.getClientTimeZone());
                        fields.addAll(sb.getSession().combineAdditionalFields(null, null, true, null));
                    }
                    if (PropertyValidator.isValid((Collection)(con = sb.getSession().getAlmConfigurations()))) {
                        ((AlmConfigurations)con.get(0)).getAlmAccount();
                    }
                    sessionBoardMapById.put(sb.getId(), sb);
                    List containers = sb.getContainers();
                    List teams = sb.getTeams();
                    containers.forEach(container -> containerMapById.put(container.getId(), container));
                    teams.forEach(team -> teamMapById.put(team.getId(), team));
                }
            }
            tempMap = null;
            ArrayList allStatuses = new ArrayList();
            HashMap statusMapById = new HashMap();
            List issueTypes = this.issueTypeRepository.findAll();
            HashMap issueTypeMapById = new HashMap();
            issueTypes.forEach(issueType -> issueTypeMapById.put(issueType.getId(), issueType));
            ArrayList itemLinks = new ArrayList();
            HashMap itemLinkMapById = new HashMap();
            ArrayList jiraLinks = new ArrayList();
            HashMap jiraLinkMapById = new HashMap();
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query.fields().include("_id");
            query.fields().include("originItemId");
            query.fields().include("parent");
            query.fields().include("title");
            query.fields().include("subItemEstimate");
            query.fields().include("status");
            query.fields().include("jiraKey");
            query.fields().include("tfsId");
            query.fields().include("tfsURL");
            query.fields().include("itemLinks");
            query.fields().include("sessionBoards");
            query.fields().include("jiraDependencies");
            query.fields().include("teamContainers");
            query.fields().include("issueType");
            query.fields().include("createdOn");
            query.fields().include("updatedOn");
            query.fields().include("dueDate");
            query.fields().include("storyPoints");
            query.fields().include("externalReferenceURL");
            query.fields().include("createdBy");
            query.fields().include("updatedBy");
            query.fields().include("type");
            query.fields().include("jiraFieldByKey");
            query.fields().include("score");
            if (report.getType() == 0) {
                if (PropertyValidator.isValid((Collection)ids)) {
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").in((Collection)ids));
                }
            } else {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is(ids.get(0)));
            }
            int filterCount = this.applyFilterOnQuery(query, report, filters, Boolean.valueOf(true), worflowIds, sessionIds, sessionBoards);
            DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query.getQueryObject());
            List parentsState1 = dbCursorPrefix.toArray();
            ArrayList<DBObject> parentsState2 = new ArrayList<DBObject>();
            if (report.getType() == 1 && (allSessionBoardIds = report.getListAsObjectIds((List)filters.get("sessionBoards"))).size() > 1) {
                ArrayList<String> state1ItemIdsStr = new ArrayList<String>();
                ArrayList<ObjectId> state1ItemIdsObj = new ArrayList<ObjectId>();
                for (DBObject item2 : parentsState1) {
                    String originItemId = (String)item2.get("originItemId");
                    if (originItemId == null) {
                        state1ItemIdsObj.add((ObjectId)item2.get("_id"));
                        state1ItemIdsStr.add(String.valueOf(item2.get("_id")));
                        continue;
                    }
                    state1ItemIdsStr.add(originItemId);
                    state1ItemIdsObj.add(new ObjectId(originItemId));
                }
                query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)Item.FEATURE));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is(allSessionBoardIds.get(1)));
                Criteria criteria = new Criteria();
                criteria.orOperator(new Criteria[]{Criteria.where((String)"_id").in(state1ItemIdsObj), Criteria.where((String)"originItemId").in(state1ItemIdsStr)});
                query.addCriteria((CriteriaDefinition)criteria);
                dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query.getQueryObject());
                List state2ItemsWithSameIds = dbCursorPrefix.toArray();
                parentsState2.addAll(state2ItemsWithSameIds);
                if (filterCount == 0) {
                    query = new Query();
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is(allSessionBoardIds.get(1)));
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)Item.FEATURE));
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").nin(state1ItemIdsObj));
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"originItemId").nin(state1ItemIdsStr));
                    dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query.getQueryObject());
                    List missingParents = dbCursorPrefix.toArray();
                    if (missingParents.size() > 0) {
                        Object item3;
                        ArrayList<String> state2ItemIds = new ArrayList<String>();
                        ArrayList<ObjectId> state2ItemIdsObjs = new ArrayList<ObjectId>();
                        Iterator iterator = missingParents.iterator();
                        while (iterator.hasNext()) {
                            item3 = (DBObject)iterator.next();
                            String originItemId = (String)item3.get("originItemId");
                            if (originItemId == null) {
                                state2ItemIdsObjs.add((ObjectId)item3.get("_id"));
                                state2ItemIds.add(String.valueOf(item3.get("_id")));
                                continue;
                            }
                            state2ItemIds.add(originItemId);
                            state2ItemIdsObjs.add(new ObjectId(originItemId));
                        }
                        query = new Query();
                        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
                        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
                        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is(allSessionBoardIds.get(0)));
                        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)Item.FEATURE));
                        query.fields().include("_id");
                        query.fields().include("originItemId");
                        criteria = new Criteria();
                        criteria.orOperator(new Criteria[]{Criteria.where((String)"_id").in(state2ItemIds), Criteria.where((String)"originItemId").in(state2ItemIds)});
                        query.addCriteria((CriteriaDefinition)criteria);
                        dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query.getQueryObject());
                        List state1ItemsWithSameIds = dbCursorPrefix.toArray();
                        item3 = missingParents.iterator();
                        while (item3.hasNext()) {
                            DBObject item2 = (DBObject)item3.next();
                            String uid2 = (String)item2.get("originItemId");
                            if (uid2 == null) {
                                uid2 = String.valueOf(item2.get("_id"));
                            }
                            Boolean found = false;
                            for (DBObject item1 : state1ItemsWithSameIds) {
                                String uid1 = (String)item1.get("originItemId");
                                if (uid1 == null) {
                                    uid1 = String.valueOf(item1.get("_id"));
                                }
                                if (!uid2.equals(uid1)) continue;
                                found = true;
                                break;
                            }
                            if (found.booleanValue()) continue;
                            parentsState2.add(item2);
                        }
                    }
                }
            }
            ArrayList<Item> parentItems = new ArrayList<Item>();
            HashMap<String, Item> parentItemsMap = new HashMap<String, Item>();
            ArrayList<ObjectId> parentIdsState1 = new ArrayList<ObjectId>();
            ArrayList<ObjectId> parentIdsState2 = new ArrayList<ObjectId>();
            ArrayList<String> itemIds = new ArrayList<String>();
            if (PropertyValidator.isValid((Collection)parentsState1)) {
                for (DBObject vo : parentsState1) {
                    item = this.createItemForReport(vo, sessionBoardMapById, statusMapById, allStatuses, itemLinkMapById, itemLinks, jiraLinkMapById, jiraLinks, teamMapById, containerMapById, issueTypeMapById);
                    itemIds.add(item.getId());
                    if (!item.putCustomeValuesAsText((Map)vo.get("jiraFieldByKey"), fields, filters)) continue;
                    parentItems.add(item);
                    parentIdsState1.add((ObjectId)vo.get("_id"));
                    parentItemsMap.put(item.getId(), item);
                }
            }
            if (PropertyValidator.isValid(parentsState2)) {
                for (DBObject vo : parentsState2) {
                    item = this.createItemForReport(vo, sessionBoardMapById, statusMapById, allStatuses, itemLinkMapById, itemLinks, jiraLinkMapById, jiraLinks, teamMapById, containerMapById, issueTypeMapById);
                    itemIds.add(item.getId());
                    if (!item.putCustomeValuesAsText((Map)vo.get("jiraFieldByKey"), fields, filters)) continue;
                    parentItems.add(item);
                    parentIdsState2.add((ObjectId)vo.get("_id"));
                    parentItemsMap.put(item.getId(), item);
                }
            }
            ArrayList allChilds = new ArrayList();
            query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"parent.$id").in(parentIdsState1));
            if (PropertyValidator.isValid((Object)report.getType()) && report.getType() == 1) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is(ids.get(0)));
            } else {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").in((Collection)ids));
            }
            filterCount = this.applyFilterOnQuery(query, report, filters, Boolean.valueOf(false), worflowIds, sessionIds, sessionBoards);
            dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query.getQueryObject());
            ArrayList state1ChildIdsStr = new ArrayList();
            ArrayList state1ChildIdsObj = new ArrayList();
            List childs = dbCursorPrefix.toArray();
            if (PropertyValidator.isValid((Collection)childs)) {
                allChilds.addAll(childs);
                childs.forEach(child -> {
                    String originItemId = (String)child.get("originItemId");
                    if (originItemId == null) {
                        state1ChildIdsObj.add((ObjectId)child.get("_id"));
                        state1ChildIdsStr.add(String.valueOf(child.get("_id")));
                    } else {
                        state1ChildIdsStr.add(originItemId);
                        state1ChildIdsObj.add(new ObjectId(originItemId));
                    }
                });
            }
            if (PropertyValidator.isValid((Object)report.getType()) && report.getType() == 1) {
                query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"parent.$id").in(parentIdsState2));
                if (ids != null && ids.size() > 1) {
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is(ids.get(1)));
                }
                if (filterCount > 0) {
                    Criteria criteria = new Criteria();
                    criteria.orOperator(new Criteria[]{Criteria.where((String)"_id").in(state1ChildIdsObj), Criteria.where((String)"originItemId").in(state1ChildIdsStr)});
                    query.addCriteria((CriteriaDefinition)criteria);
                }
                if (PropertyValidator.isValid((Collection)(childs = (dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query.getQueryObject())).toArray()))) {
                    allChilds.addAll(childs);
                }
            }
            ArrayList filteredParents = new ArrayList();
            HashMap<String, String> filteredParentsMap = new HashMap<String, String>();
            ArrayList<Item> childItems = new ArrayList<Item>();
            int jiraFilterCount = 0;
            if (PropertyValidator.isValid(allChilds)) {
                for (DBObject vo : allChilds) {
                    Item item4 = this.createItemForReport(vo, sessionBoardMapById, statusMapById, allStatuses, itemLinkMapById, itemLinks, jiraLinkMapById, jiraLinks, teamMapById, containerMapById, issueTypeMapById);
                    itemIds.add(item4.getId());
                    filters.put("jiraFilterCount", jiraFilterCount);
                    if (!item4.putCustomeValuesAsText((Map)vo.get("jiraFieldByKey"), fields, filters)) continue;
                    childItems.add(item4);
                    if ((filterCount += ((Integer)filters.get("jiraFilterCount")).intValue()) <= 0 || filteredParentsMap.get(item4.getParent().getId()) != null) continue;
                    filteredParents.add(parentItemsMap.get(item4.getParent().getId()));
                    filteredParentsMap.put(item4.getParent().getId(), item4.getParent().getId());
                }
            }
            if (filterCount > 0) {
                response.put("parent", filteredParents);
            } else {
                response.put("parent", parentItems);
            }
            List baseItemLinks = this.baseItemLinkRepository.findByItemIdIn(itemIds);
            List baseItems = this.baseItemRepository.findByBaseItemLinksIn(baseItemLinks);
            response.put("baseItemLinks", baseItemLinks);
            response.put("baseItems", baseItems);
            ItemTypeScheme milestoneScheme = this.tfSservice.getItemTypeScheme(EnumKendis.MILESTONE.getCode());
            ItemTypeScheme phaseScheme = this.tfSservice.getItemTypeScheme(EnumKendis.PHASES.getCode());
            response.put("milestoneScheme", (List)milestoneScheme);
            response.put("phaseScheme", (List)phaseScheme);
            response.put("child", childItems);
            response.put("statuses", this.statusRepository.findByIdIn(allStatuses));
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    private int applyFilterOnQuery(Query query, Report report, HashMap<String, Object> filters, Boolean parent, ArrayList<ObjectId> workflowIds, ArrayList<String> sessionIds, List<SessionBoard> sessionBoards) throws ParseException {
        int filterCount = 0;
        if (parent.booleanValue()) {
            Date end;
            Object values;
            List cards;
            List ids = null;
            ArrayList<String> types = new ArrayList<String>();
            types.add(Item.FEATURE);
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").in(types));
            String options = "i";
            String pattern = null;
            boolean isTag = false;
            Criteria whrTag = new Criteria();
            if (PropertyValidator.isValid((Object)filters.get("tags"))) {
                ++filterCount;
                pattern = String.join((CharSequence)"|", (List)filters.get("tags"));
                whrTag = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"title").regex(pattern, options), Criteria.where((String)"jiraKey").regex(pattern, options), Criteria.where((String)"tfsId").regex(pattern, options)});
            }
            if (PropertyValidator.isValid((Collection)(cards = (List)filters.get("issueType")))) {
                ++filterCount;
                ids = report.getListAsObjectIds(cards);
                Criteria whr = new Criteria();
                if (cards.indexOf("-1") > -1) {
                    if (PropertyValidator.isValid((Object)pattern)) {
                        whr.orOperator(new Criteria[]{Criteria.where((String)"issueType.$id").in((Collection)ids), Criteria.where((String)"issueType").is(null)});
                        whr.andOperator(new Criteria[]{whrTag});
                        isTag = true;
                    } else {
                        whr.orOperator(new Criteria[]{Criteria.where((String)"issueType.$id").in((Collection)ids), Criteria.where((String)"issueType").is(null)});
                    }
                    query.addCriteria((CriteriaDefinition)whr);
                } else {
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"issueType.$id").in((Collection)ids));
                }
            }
            if (PropertyValidator.isValid((Object)pattern) && !isTag) {
                query.addCriteria((CriteriaDefinition)whrTag);
            }
            if (PropertyValidator.isValid((Object)filters.get("score"))) {
                values = Double.parseDouble((String)filters.get("score"));
                ++filterCount;
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"score").is(values));
            }
            if (PropertyValidator.isValid((Object)filters.get("param1"))) {
                values = (String)filters.get("param1");
                ++filterCount;
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"scoreParams.param1").is(values));
            }
            if (PropertyValidator.isValid((Object)filters.get("param2"))) {
                values = (String)filters.get("param2");
                ++filterCount;
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"scoreParams.param2").is(values));
            }
            if (PropertyValidator.isValid((Object)filters.get("param3"))) {
                values = (String)filters.get("param3");
                ++filterCount;
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"scoreParams.param3").is(values));
            }
            if (PropertyValidator.isValid((Object)filters.get("param4"))) {
                values = (String)filters.get("param4");
                ++filterCount;
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"scoreParams.param4").is(values));
            }
            if (PropertyValidator.isValid((Object)filters.get("updatedBy"))) {
                ++filterCount;
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"updatedBy").in((Collection)((List)filters.get("updatedBy"))));
            }
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            long oneDay = 86400000L;
            if (PropertyValidator.isValid((Object)filters.get("updatedOnStart")) && PropertyValidator.isValid((Object)filters.get("updatedOnEnd"))) {
                ++filterCount;
                end = sdf.parse((String)filters.get("updatedOnEnd"));
                end = new Date(end.getTime() + oneDay);
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"updatedOn").gte((Object)sdf.parse((String)filters.get("updatedOnStart"))).andOperator(new Criteria[]{Criteria.where((String)"updatedOn").lt((Object)end)}));
            }
            if (PropertyValidator.isValid((Object)filters.get("dueDateStart")) && PropertyValidator.isValid((Object)filters.get("dueDateEnd"))) {
                ++filterCount;
                end = sdf.parse((String)filters.get("dueDateEnd"));
                end = new Date(end.getTime() + oneDay);
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"dueDate").gte((Object)sdf.parse((String)filters.get("dueDateStart"))).andOperator(new Criteria[]{Criteria.where((String)"dueDate").lt((Object)end)}));
            }
            if (PropertyValidator.isValid((Object)filters.get("statusCategories"))) {
                List values2 = (List)filters.get("statusCategories");
                values2.removeIf(v -> !PropertyValidator.isValid((Object)v));
                if (PropertyValidator.isValid((Collection)values2)) {
                    ++filterCount;
                    Query whr = new Query();
                    whr.addCriteria((CriteriaDefinition)Criteria.where((String)"title").in((Collection)values2));
                    Criteria criteria = new Criteria();
                    criteria.orOperator(new Criteria[]{Criteria.where((String)"sessionId").in(sessionIds), Criteria.where((String)"workFlow.$id").in(workflowIds)});
                    whr.addCriteria((CriteriaDefinition)criteria);
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"status.$id").in((Collection)this.mongoTemplate.getCollection("status").distinct("_id", whr.getQueryObject())));
                }
            }
            if (PropertyValidator.isValid((Object)filters.get("flagged"))) {
                ++filterCount;
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"flagged").is((Object)Boolean.parseBoolean((String)filters.get("flagged"))));
            }
            ArrayList teamContainers = new ArrayList();
            List teamIds = report.getListAsObjectIds((List)filters.get("teams"));
            List containerTitles = (List)filters.get("sprints");
            if (PropertyValidator.isValid((Collection)teamIds) || PropertyValidator.isValid((Collection)containerTitles)) {
                List tcs;
                Query whr = new Query();
                if (PropertyValidator.isValid((Collection)teamIds)) {
                    ++filterCount;
                    whr.addCriteria((CriteriaDefinition)Criteria.where((String)"team.$id").in((Collection)teamIds));
                }
                if (PropertyValidator.isValid((Collection)containerTitles)) {
                    ++filterCount;
                    HashMap<String, String> conMap = new HashMap<String, String>();
                    for (String title : containerTitles) {
                        conMap.put(title, "true");
                    }
                    ArrayList<Object> containerIds = new ArrayList<Object>();
                    for (SessionBoard sb : sessionBoards) {
                        List cons = sb.getContainers();
                        for (Container con : cons) {
                            if (conMap.get(con.getTitle()) == null) continue;
                            try {
                                containerIds.add(new ObjectId(con.getId()));
                            }
                            catch (Exception ex) {
                                containerIds.add(con.getId());
                            }
                        }
                    }
                    whr.addCriteria((CriteriaDefinition)Criteria.where((String)"container.$id").in(containerIds));
                }
                if (PropertyValidator.isValid((Collection)(tcs = this.mongoTemplate.getCollection("teamContainer").distinct("_id", whr.getQueryObject())))) {
                    teamContainers.addAll(tcs);
                }
                if (teamContainers.size() > 0) {
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"teamContainers.$id").in(teamContainers));
                } else {
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"teamContainers.$id").is((Object)"harde-coded-value"));
                }
            }
        } else {
            Date end;
            Object ids = null;
            if (PropertyValidator.isValid((Object)filters.get("updatedBy_child"))) {
                ++filterCount;
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"updatedBy").in((Collection)((List)filters.get("updatedBy_child"))));
            }
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            long oneDay = 86400000L;
            if (PropertyValidator.isValid((Object)filters.get("updatedOn_childStart")) && PropertyValidator.isValid((Object)filters.get("updatedOn_childEnd"))) {
                ++filterCount;
                end = sdf.parse((String)filters.get("updatedOn_childEnd"));
                end = new Date(end.getTime() + oneDay);
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"updatedOn").gte((Object)sdf.parse((String)filters.get("updatedOn_childStart"))).andOperator(new Criteria[]{Criteria.where((String)"updatedOn").lt((Object)end)}));
            }
            if (PropertyValidator.isValid((Object)filters.get("dueDate_childStart")) && PropertyValidator.isValid((Object)filters.get("dueDate_childEnd"))) {
                ++filterCount;
                end = sdf.parse((String)filters.get("dueDate_childEnd"));
                end = new Date(end.getTime() + oneDay);
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"dueDate").gte((Object)sdf.parse((String)filters.get("dueDate_childStart"))).andOperator(new Criteria[]{Criteria.where((String)"dueDate").lt((Object)end)}));
            }
            if (PropertyValidator.isValid((Object)filters.get("statusCategories_child"))) {
                ++filterCount;
                Query whr = new Query();
                whr.addCriteria((CriteriaDefinition)Criteria.where((String)"title").in((Collection)((List)filters.get("statusCategories_child"))));
                Criteria criteria = new Criteria();
                criteria.orOperator(new Criteria[]{Criteria.where((String)"sessionId").in(sessionIds), Criteria.where((String)"workFlow.$id").in(workflowIds)});
                whr.addCriteria((CriteriaDefinition)criteria);
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"status.$id").in((Collection)this.mongoTemplate.getCollection("status").distinct("_id", whr.getQueryObject())));
            }
            if (PropertyValidator.isValid((Object)filters.get("flagged_child"))) {
                ++filterCount;
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"flagged").is((Object)Boolean.parseBoolean((String)filters.get("flagged_child"))));
            }
            ArrayList teamContainers = new ArrayList();
            List teamIds = report.getListAsObjectIds((List)filters.get("teams_child"));
            List containerTitles = (List)filters.get("sprints_child");
            if (PropertyValidator.isValid((Collection)teamIds) || PropertyValidator.isValid((Collection)containerTitles)) {
                List tcs;
                Query whr = new Query();
                if (PropertyValidator.isValid((Collection)teamIds)) {
                    ++filterCount;
                    whr.addCriteria((CriteriaDefinition)Criteria.where((String)"team.$id").in((Collection)teamIds));
                }
                if (PropertyValidator.isValid((Collection)containerTitles)) {
                    ++filterCount;
                    HashMap<String, String> conMap = new HashMap<String, String>();
                    for (String title : containerTitles) {
                        conMap.put(title, "true");
                    }
                    ArrayList<Object> containerIds = new ArrayList<Object>();
                    for (SessionBoard sb : sessionBoards) {
                        List cons = sb.getContainers();
                        for (Container con : cons) {
                            if (conMap.get(con.getTitle()) == null) continue;
                            try {
                                containerIds.add(new ObjectId(con.getId()));
                            }
                            catch (Exception ex) {
                                containerIds.add(con.getId());
                            }
                        }
                    }
                    whr.addCriteria((CriteriaDefinition)Criteria.where((String)"container.$id").in(containerIds));
                }
                if (PropertyValidator.isValid((Collection)(tcs = this.mongoTemplate.getCollection("teamContainer").distinct("_id", whr.getQueryObject())))) {
                    teamContainers.addAll(tcs);
                }
                if (teamContainers.size() > 0) {
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"teamContainers.$id").in(teamContainers));
                } else {
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"teamContainers.$id").is((Object)"harde-coded-value"));
                }
            }
        }
        return filterCount;
    }

    private Item createItemForReport(DBObject vo, HashMap<String, SessionBoard> sessionBoardMapById, HashMap<String, String> statusMapById, ArrayList<String> allStatuses, HashMap<String, String> itemLinkMapById, ArrayList<String> itemLinks, HashMap<String, String> jiraLinkMapById, ArrayList<String> jiraLinks, HashMap<String, Team> teamMapById, HashMap<String, Container> containerMapById, HashMap<String, IssueType> issueTypeMapById) {
        List sessionBoardsRef = (List)vo.get("sessionBoards");
        String id = ((DBRef)sessionBoardsRef.get(0)).getId().toString();
        SessionBoard sessionBoard = sessionBoardMapById.get(id);
        Item parent = null;
        DBRef parentRef = (DBRef)vo.get("parent");
        if (PropertyValidator.isValid((Object)parentRef)) {
            parent = new Item(String.valueOf(parentRef.getId()));
        }
        DBRef statusRef = (DBRef)vo.get("status");
        Status status = new Status();
        if (PropertyValidator.isValid((Object)statusRef)) {
            String statusId = String.valueOf(statusRef.getId());
            status = new Status();
            status.setId(statusId);
            if (statusMapById.get(statusId) == null) {
                statusMapById.put(statusId, statusId);
                allStatuses.add(statusId);
            }
        } else {
            LOGGER.debug("Status ref is null for Item :: " + String.valueOf(vo.get("_id")));
        }
        IssueType issueType = null;
        DBRef issueTypeRef = (DBRef)vo.get("issueType");
        if (PropertyValidator.isValid((Object)issueTypeRef)) {
            String issueTypeId = String.valueOf(issueTypeRef.getId());
            issueType = issueTypeMapById.get(issueTypeId);
        }
        ArrayList _itemLinks = new ArrayList();
        List itemLinksRef = (List)vo.get("itemLinks");
        if (PropertyValidator.isValid((Collection)itemLinksRef)) {
            itemLinksRef.forEach(linkRef -> {
                String linkId = String.valueOf(linkRef.getId());
                ItemLink link = new ItemLink();
                link.setId(linkId);
                _itemLinks.add(link);
            });
        }
        ArrayList _jiraLinks = new ArrayList();
        List jiraLinksRef = (List)vo.get("jiraDependencies");
        if (PropertyValidator.isValid((Collection)jiraLinksRef)) {
            jiraLinksRef.forEach(linkRef -> {
                String linkId = String.valueOf(linkRef.getId());
                ItemJiraDependency link = new ItemJiraDependency();
                link.setId(linkId);
                _jiraLinks.add(link);
            });
        }
        List teamContainersRef = (List)vo.get("teamContainers");
        ArrayList<TeamContainer> teamContainers = new ArrayList<TeamContainer>();
        if (PropertyValidator.isValid((Collection)teamContainersRef)) {
            for (int i = 0; i < teamContainersRef.size(); ++i) {
                DBRef tcRef = (DBRef)teamContainersRef.get(i);
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(tcRef.getId()));
                DBCursor dbCursorDomain = this.customRepositoryImpl.getMongoTemplate().getCollection("teamContainer").find(query.getQueryObject());
                if (!dbCursorDomain.hasNext()) continue;
                DBObject tcObject = dbCursorDomain.next();
                DBRef teamRef = (DBRef)tcObject.get("team");
                DBRef containerRef = (DBRef)tcObject.get("container");
                Team team = teamMapById.get(String.valueOf(teamRef.getId()));
                Container container = containerMapById.get(String.valueOf(containerRef.getId()));
                TeamContainer teamContainer = new TeamContainer();
                teamContainer.setId(String.valueOf(tcObject.get("_id")));
                teamContainer.setOriginItemId((String)tcObject.get("originItemId"));
                teamContainer.setTeam(team);
                teamContainer.setContainer(container);
                if (!PropertyValidator.isValid((Object)team) || !PropertyValidator.isValid((Object)team.getId()) || !PropertyValidator.isValid((Object)container) || !PropertyValidator.isValid((Object)container.getId())) continue;
                teamContainers.add(teamContainer);
            }
        }
        return new Item(vo, sessionBoard, status, issueType, parent, _itemLinks, _jiraLinks, teamContainers, null);
    }

    @RequestMapping(value={"/export/{type}"})
    @ResponseBody
    public ResponseEntity<Object> exportReport(@PathVariable(value="type") String type, @RequestBody Report report) {
        ResponseEntity result = this.applyFilters(report);
        HashMap response = (HashMap)result.getBody();
        try {
            String downloadName;
            int itt;
            String extension = "xls";
            int exportType = 1;
            if (PropertyValidator.isValid((Object)type) && "csv".equalsIgnoreCase(type)) {
                extension = "csv";
                exportType = 0;
            }
            List fatures = (List)response.get("parent");
            List statuses = (List)response.get("statuses");
            HashMap statusesMap = new HashMap();
            if (PropertyValidator.isValid((Collection)statuses)) {
                statuses.forEach(st -> statusesMap.put(st.getId(), st));
            }
            HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
            ArrayList parents = new ArrayList();
            if (PropertyValidator.isValid((Collection)fatures)) {
                HashMap<String, Item> states;
                HashMap itemLinksByTargetTeamContainerIds = new HashMap();
                HashMap itemByTeamContainerIds = new HashMap();
                for (itt = 0; itt < fatures.size(); ++itt) {
                    int itemIndex = -1;
                    Item item = (Item)fatures.get(itt);
                    if (PropertyValidator.isValid((Object)item.getStatus())) {
                        item.setStatus((Status)statusesMap.get(item.getStatus().getId()));
                    }
                    if (!PropertyValidator.isValid((Collection)item.getSessionBoards())) {
                        item.setSessionBoards(new ArrayList());
                    }
                    if (!PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                        item.setTeamContainers(new ArrayList());
                    }
                    if (!PropertyValidator.isValid((Collection)item.getItemLinks())) {
                        item.setItemLinks(new ArrayList());
                    }
                    String comparisonKey = null;
                    String stateKey = null;
                    if (report.getType() == 0) {
                        if (PropertyValidator.isValid((Object)item.getJiraId())) {
                            comparisonKey = item.getJiraId();
                        }
                        stateKey = "0";
                    } else {
                        comparisonKey = item.getOriginItemId();
                        if (comparisonKey == null) {
                            comparisonKey = item.getId();
                        }
                        stateKey = ((SessionBoard)item.getSessionBoards().get(0)).getId();
                    }
                    if (comparisonKey != null) {
                        String key = PropertyValidator.isValid((Collection)item.getSessionBoards()) ? ((SessionBoard)item.getSessionBoards().get(0)).getSession().getParentItem() : "";
                        String string = key = item.getIssueType() == null ? key : item.getIssueType().getTitle();
                        if (tempMap.get(comparisonKey) == null) {
                            HashMap<String, Object> itemEntry = new HashMap<String, Object>();
                            itemEntry.put("id", item.getId());
                            if (item.getJiraId() != null) {
                                itemEntry.put("jiraId", item.getJiraId());
                            }
                            states = new HashMap<String, Item>();
                            states.put(stateKey, item);
                            itemEntry.put("states", states);
                            parents.add(itemEntry);
                            tempMap.put(comparisonKey, itt);
                            item.setIssueTypes(new HashMap());
                            item.getIssueTypes().put(key, true);
                            itemIndex = parents.size() - 1;
                        } else {
                            int index = (Integer)tempMap.get(comparisonKey);
                            HashMap itemEntry = (HashMap)parents.get(index);
                            HashMap states2 = (HashMap)itemEntry.get("states");
                            if (report.getType() == 0) {
                                Item addedItem = (Item)states2.get(stateKey);
                                if (addedItem.getSessionBoards() != null && item.getSessionBoards() != null) {
                                    addedItem.getSessionBoards().addAll(item.getSessionBoards());
                                }
                                if (addedItem.getTeamContainers() != null && item.getTeamContainers() != null) {
                                    addedItem.getTeamContainers().addAll(item.getTeamContainers());
                                }
                                if (addedItem.getItemLinks() != null && item.getItemLinks() != null) {
                                    addedItem.getItemLinks().addAll(item.getItemLinks());
                                }
                                if (addedItem.getIssueTypes() == null) {
                                    addedItem.setIssueTypes(new HashMap());
                                }
                                addedItem.getIssueTypes().put(key, true);
                            } else {
                                states2.put(stateKey, item);
                            }
                            itemIndex = index;
                        }
                    } else {
                        HashMap<String, Object> itemEntry = new HashMap<String, Object>();
                        itemEntry.put("id", item.getId());
                        HashMap<String, Item> states3 = new HashMap<String, Item>();
                        states3.put(stateKey, item);
                        itemEntry.put("states", states3);
                        parents.add(itemEntry);
                        itemIndex = parents.size() - 1;
                    }
                    ArrayList itemsLinks = new ArrayList();
                    if (PropertyValidator.isValid((Collection)item.getItemLinks())) {
                        for (int i = 0; i < item.getItemLinks().size(); ++i) {
                            if (!PropertyValidator.isValid(item.getItemLinks().get(i))) continue;
                            if (itemLinksByTargetTeamContainerIds.get(((ItemLink)item.getItemLinks().get(i)).getTargetTeamContainerId()) == null) {
                                itemLinksByTargetTeamContainerIds.put(((ItemLink)item.getItemLinks().get(i)).getTargetTeamContainerId(), new ArrayList());
                            }
                            ((ArrayList)itemLinksByTargetTeamContainerIds.get(((ItemLink)item.getItemLinks().get(i)).getTargetTeamContainerId())).add(item.getItemLinks().get(i));
                        }
                    }
                    if (!PropertyValidator.isValid((Collection)item.getTeamContainers())) continue;
                    for (int i = 0; i < item.getTeamContainers().size(); ++i) {
                        if (itemByTeamContainerIds.get(((TeamContainer)item.getTeamContainers().get(i)).getId()) == null) {
                            itemByTeamContainerIds.put(((TeamContainer)item.getTeamContainers().get(i)).getId(), new ArrayList());
                        }
                        HashMap<String, Object> _map = new HashMap<String, Object>();
                        _map.put("index", itemIndex);
                        _map.put("stateKey", stateKey);
                        ((ArrayList)itemByTeamContainerIds.get(((TeamContainer)item.getTeamContainers().get(i)).getId())).add(_map);
                    }
                }
                if (report.getType() == 0) {
                    Set keys = itemLinksByTargetTeamContainerIds.keySet();
                    for (String targetTC_Id : keys) {
                        if (itemByTeamContainerIds.get(targetTC_Id) == null) continue;
                        for (int i = 0; i < ((ArrayList)itemByTeamContainerIds.get(targetTC_Id)).size(); ++i) {
                            HashMap _map = (HashMap)((ArrayList)itemByTeamContainerIds.get(targetTC_Id)).get(i);
                            Integer itemIndex = (Integer)_map.get("index");
                            if (itemIndex == null || itemIndex >= parents.size()) continue;
                            HashMap itemEntry = (HashMap)parents.get(itemIndex);
                            states = (HashMap<String, Item>)itemEntry.get("states");
                            Item item = (Item)states.get(_map.get("stateKey"));
                            item.getItemLinks().addAll((Collection)itemLinksByTargetTeamContainerIds.get(targetTC_Id));
                        }
                    }
                }
            }
            List child = (List)response.get("child");
            HashMap infoMap = new HashMap();
            if (PropertyValidator.isValid((Collection)child)) {
                for (itt = 0; itt < child.size(); ++itt) {
                    HashMap<String, Serializable> info;
                    Item item = (Item)child.get(itt);
                    if (PropertyValidator.isValid((Object)item.getStatus())) {
                        item.setStatus((Status)statusesMap.get(item.getStatus().getId()));
                    }
                    String fid = item.getParent().getId();
                    if (report.getType() == 0 && item.getParent().getJiraId() != null && tempMap.get(item.getParent().getJiraId()) != null) {
                        int index = (Integer)tempMap.get(item.getParent().getJiraId());
                        fid = ((Item)fatures.get(index)).getId();
                    }
                    if ((info = (HashMap<String, Serializable>)infoMap.get(fid)) == null) {
                        info = new HashMap<String, Serializable>();
                        info.put("c_ToDo", Integer.valueOf(0));
                        info.put("c_InProgress", Integer.valueOf(0));
                        info.put("c_Done", Integer.valueOf(0));
                        info.put("sp_ToDo", Double.valueOf(0.0));
                        info.put("sp_InProgress", Double.valueOf(0.0));
                        info.put("sp_Done", Double.valueOf(0.0));
                        info.put("childIndexes", new ArrayList());
                    }
                    String category = "";
                    if (PropertyValidator.isValid((Object)item.getStatus())) {
                        category = item.getStatus().getCategory();
                    }
                    Integer count = 0;
                    if (info.get("c_" + category) != null) {
                        count = (Integer)info.get("c_" + category);
                    }
                    info.put("c_" + category, Integer.valueOf(1 + count));
                    Double storyPoints = item.getStoryPoints() != null ? item.getStoryPoints() : 0.0;
                    Double _storyPoints = 0.0;
                    if (info.get("sp_" + category) != null) {
                        _storyPoints = (Double)info.get("sp_" + category);
                    }
                    info.put("sp_" + category, Double.valueOf(storyPoints + _storyPoints));
                    ((List)info.get("childIndexes")).add(itt);
                    infoMap.put(fid, info);
                }
            }
            String filePath = this.exportService.exportReportData(exportType, parents, child, infoMap, report);
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MMM/yyyy HH:mm");
            if (report.getType() == 1) {
                String state1Tile = "";
                if (report.getComparisonStates().size() > 0) {
                    state1Tile = "_" + ((State)report.getComparisonStates().get(0)).getTitle();
                }
                String state2Tile = "";
                if (report.getComparisonStates().size() > 1) {
                    state2Tile = "_vs_" + ((State)report.getComparisonStates().get(1)).getTitle();
                }
                downloadName = "" + AlmUtils.cleanText((String)report.getTitle()) + state1Tile + state2Tile + "_" + formatter.format(new Date()) + "." + extension;
            } else {
                downloadName = "" + AlmUtils.cleanText((String)report.getTitle()) + "_" + formatter.format(new Date()) + "." + extension;
            }
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("srcPath", URLEncoder.encode(filePath, "UTF-8"));
            data.put("name", downloadName);
            return new ResponseEntity(data, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public String getItemId(Item item) {
        if (item.getJiraId() != null) {
            return item.getJiraId();
        }
        return item.getId();
    }

    @RequestMapping(value={"/item/{id}"})
    @ResponseBody
    public ResponseEntity<Object> getItem(@PathVariable(value="id") String id) {
        Item item = new Item((Item)this.itemRepository.findOne((Serializable)((Object)id)), Boolean.valueOf(true));
        return new ResponseEntity((Object)item, HttpStatus.OK);
    }

    @RequestMapping(value={"/itemJiraDepdencies/{id}"})
    @ResponseBody
    public ResponseEntity<Object> getItemJiraDep(@PathVariable(value="id") String id) {
        SessionBoard sb;
        Session session;
        Item item = new Item((Item)this.itemRepository.findOne((Serializable)((Object)id)), Boolean.valueOf(true));
        if (PropertyValidator.isValid((Collection)item.getJiraDependencies()) && PropertyValidator.isValid((Object)(session = (Session)this.sessionRepository.findOne((Serializable)((Object)(sb = (SessionBoard)item.getSessionBoards().get(0)).getSession().getId()))).getTfsAlmConfigurations())) {
            AlmAccount almAccount;
            String reponseStr;
            String itemIDs = null;
            for (ItemJiraDependency depedency : item.getJiraDependencies()) {
                if (!PropertyValidator.isValid((Object)depedency.getTargetTFSItem()) || PropertyValidator.isValid((Object)depedency.getTargetTFSItem().getTitle())) continue;
                if (itemIDs == null) {
                    itemIDs = "" + depedency.getTargetTFSItem().getTfsId();
                    continue;
                }
                itemIDs = itemIDs + "," + depedency.getTargetTFSItem().getTfsId();
            }
            if (PropertyValidator.isValid(itemIDs) && PropertyValidator.isValid((Object)(reponseStr = this.tfsUtils.getItems("1", itemIDs, almAccount = session.getTfsAlmConfigurations().getAlmAccount())))) {
                try {
                    JSONObject dataObjects = new JSONObject(reponseStr);
                    JSONArray itemsArray = dataObjects.getJSONArray("value");
                    HashMap<String, JSONObject> itemsMap = new HashMap<String, JSONObject>();
                    if (PropertyValidator.isValid((Object)itemsArray)) {
                        for (int i = 0; i < itemsArray.length(); ++i) {
                            JSONObject itemObject = itemsArray.getJSONObject(i);
                            itemsMap.put(itemObject.getString("id"), itemObject);
                        }
                    }
                    for (ItemJiraDependency depedency : item.getJiraDependencies()) {
                        JSONObject itemObject;
                        if (!PropertyValidator.isValid((Object)depedency.getTargetTFSItem()) || PropertyValidator.isValid((Object)depedency.getTargetTFSItem().getTitle()) || !PropertyValidator.isValid((Object)(itemObject = (JSONObject)itemsMap.get(depedency.getTargetTFSItem().getTfsId())))) continue;
                        JSONObject tfsFields = itemObject.getJSONObject("fields");
                        depedency.getTargetTFSItem().setTitle(tfsFields.getString("System.Title"));
                        depedency.getTargetTFSItem().setStatus(tfsFields.getString("System.State"));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return new ResponseEntity((Object)item, HttpStatus.OK);
    }

    private Item createItemForReportSmart(DBObject vo, HashMap<String, Status> statusMapById, ArrayList<String> allStatuses, HashMap<String, String> itemLinkMapById, ArrayList<String> itemLinks, HashMap<String, String> jiraLinkMapById, ArrayList<String> jiraLinks, HashMap<String, Team> teamMapById, HashMap<String, Container> containerMapById, HashMap<String, IssueType> issueTypeMapById) {
        Item parent = null;
        DBRef parentRef = (DBRef)vo.get("parent");
        if (PropertyValidator.isValid((Object)parentRef)) {
            parent = new Item(String.valueOf(parentRef.getId()));
        }
        DBRef statusRef = (DBRef)vo.get("status");
        Status status = new Status();
        if (PropertyValidator.isValid((Object)statusRef)) {
            String statusId = String.valueOf(statusRef.getId());
            status.setId(statusId);
            if (statusMapById.get(statusId) == null) {
                Query statusQuery = new Query();
                statusQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(statusRef.getId()));
                DBCursor dbCursorDomain = this.customRepositoryImpl.getMongoTemplate().getCollection("status").find(statusQuery.getQueryObject());
                if (dbCursorDomain.hasNext()) {
                    DBObject statusObject = dbCursorDomain.next();
                    status.setTitle((String)statusObject.get("title"));
                    status.setColor((String)statusObject.get("color"));
                    status.setColor((String)statusObject.get("color"));
                    status.setCategory((String)statusObject.get("category"));
                }
                statusMapById.put(statusId, status);
                allStatuses.add(statusId);
            } else {
                status = statusMapById.get(statusId);
            }
        } else {
            LOGGER.debug("Status ref is null for Item :: " + String.valueOf(vo.get("_id")));
        }
        IssueType issueType = null;
        DBRef issueTypeRef = (DBRef)vo.get("issueType");
        if (PropertyValidator.isValid((Object)issueTypeRef)) {
            String issueTypeId = String.valueOf(issueTypeRef.getId());
            issueType = issueTypeMapById.get(issueTypeId);
        }
        ArrayList<ItemLink> _itemLinks = new ArrayList<ItemLink>();
        List itemLinksRef = (List)vo.get("itemLinks");
        if (PropertyValidator.isValid((Collection)itemLinksRef)) {
            for (DBRef linkRef2 : itemLinksRef) {
                Query query1 = new Query();
                String linkId = String.valueOf(linkRef2.getId());
                ItemLink link = new ItemLink();
                link.setId(linkId);
                query1.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(linkRef2.getId()));
                DBCursor dbCursorDomain = this.customRepositoryImpl.getMongoTemplate().getCollection("itemLink").find(query1.getQueryObject());
                if (dbCursorDomain.hasNext()) {
                    DBObject itemLinkObject = dbCursorDomain.next();
                    link.setStatus((String)itemLinkObject.get("status"));
                    link.setDescription((String)itemLinkObject.get("description"));
                    link.setSourceTeamContainerId((String)itemLinkObject.get("sourceTeamContainerId"));
                    link.setTargetTeamContainerId((String)itemLinkObject.get("targetTeamContainerId"));
                    link.setSourceUserStoryId((String)itemLinkObject.get("sourceUserStoryId"));
                    link.setTargetUserStoryId((String)itemLinkObject.get("targetUserStoryId"));
                    if (itemLinkObject.get("raisedOn") != null) {
                        link.setRaisedOn((Date)itemLinkObject.get("raisedOn"));
                    }
                    if (itemLinkObject.get("resolvedOn") != null) {
                        link.setResolvedOn((Date)itemLinkObject.get("resolvedOn"));
                    }
                    if (itemLinkObject.get("createdOn") != null) {
                        link.setCreatedOn((Date)itemLinkObject.get("createdOn"));
                    }
                    if (itemLinkObject.get("updatedOn") != null) {
                        link.setUpdatedOn((Date)itemLinkObject.get("updatedOn"));
                    }
                    if (itemLinkObject.get("dueDate") != null) {
                        link.setDueDate((Date)itemLinkObject.get("dueDate"));
                    }
                    if (itemLinkObject.get("initialTargetSprintId") != null) {
                        link.setInitialTargetSprintId((String)itemLinkObject.get("initialTargetSprintId"));
                    }
                    if (itemLinkObject.get("customId") != null) {
                        link.setCustomId(((Integer)itemLinkObject.get("customId")).intValue());
                    }
                    link.setType((String)itemLinkObject.get("type"));
                    link.setTitle((String)itemLinkObject.get("title"));
                    if (itemLinkObject.containsField("wfStatus")) {
                        DBRef wfs = (DBRef)itemLinkObject.get("wfStatus");
                        link.setWfStatus(statusMapById.get(String.valueOf(wfs.getId())));
                    }
                }
                if (itemLinkMapById.get(linkId) == null) {
                    itemLinkMapById.put(linkId, linkId);
                    itemLinks.add(linkId);
                }
                _itemLinks.add(link);
            }
        }
        ArrayList _jiraLinks = new ArrayList();
        List jiraLinksRef = (List)vo.get("jiraDependencies");
        if (PropertyValidator.isValid((Collection)jiraLinksRef)) {
            jiraLinksRef.forEach(linkRef -> {
                String linkId = String.valueOf(linkRef.getId());
                ItemJiraDependency link = new ItemJiraDependency();
                link.setId(linkId);
                if (jiraLinkMapById.get(linkId) == null) {
                    jiraLinkMapById.put(linkId, linkId);
                    jiraLinks.add(linkId);
                }
                _jiraLinks.add(link);
            });
        }
        List teamContainersRef = (List)vo.get("teamContainers");
        ArrayList<TeamContainer> teamContainers = new ArrayList<TeamContainer>();
        if (PropertyValidator.isValid((Collection)teamContainersRef)) {
            for (int i = 0; i < teamContainersRef.size(); ++i) {
                DBRef tcRef = (DBRef)teamContainersRef.get(i);
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(tcRef.getId()));
                DBCursor dbCursorDomain = this.customRepositoryImpl.getMongoTemplate().getCollection("teamContainer").find(query.getQueryObject());
                if (!dbCursorDomain.hasNext()) continue;
                DBObject tcObject = dbCursorDomain.next();
                DBRef teamRef = (DBRef)tcObject.get("team");
                DBRef containerRef = (DBRef)tcObject.get("container");
                if (teamRef == null || containerRef == null) continue;
                Double sequence = (Double)tcObject.get("sequence");
                Team team = teamMapById.get(String.valueOf(teamRef.getId()));
                Container container = containerMapById.get(String.valueOf(containerRef.getId()));
                TeamContainer teamContainer = new TeamContainer();
                teamContainer.setId(String.valueOf(tcObject.get("_id")));
                teamContainer.setOriginItemId((String)tcObject.get("originItemId"));
                teamContainer.setDuplicateOfId((String)tcObject.get("duplicateOfId"));
                teamContainer.setTeam(team);
                teamContainer.setContainer(container);
                teamContainer.setSequence(sequence);
                if (!PropertyValidator.isValid((Object)team) || !PropertyValidator.isValid((Object)team.getId()) || !PropertyValidator.isValid((Object)container) || !PropertyValidator.isValid((Object)container.getId())) continue;
                teamContainers.add(teamContainer);
            }
        }
        return new Item(vo, null, status, issueType, parent, _itemLinks, _jiraLinks, teamContainers, null);
    }

    @RequestMapping(value={"/charts"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getActivityDataByRange(@RequestBody HashMap<String, String> param) {
        Thread t = new Thread(() -> this.doChartsCalculation(param));
        t.start();
        return null;
    }

    private ResponseEntity<Object> doChartsCalculation(HashMap<String, String> param) {
        String syncId = param.get("syncId");
        String requestId = null;
        try {
            boolean exists;
            HashMap<String, Integer> tcMap = new HashMap<String, Integer>();
            HashMap mappedStatus = new HashMap();
            HashMap<String, Map> progress = new HashMap<String, Map>();
            progress.put("progress" + Item.Type.Feature.toString(), this.getEmptyMapOfIntArray());
            progress.put("progress" + Item.Type.UserStory.toString(), this.getEmptyMapOfIntArray());
            progress.put("unPlanProgress" + Item.Type.Feature.toString(), this.getEmptyMapOfIntArray());
            progress.put("unPlanProgress" + Item.Type.UserStory.toString(), this.getEmptyMapOfIntArray());
            HashMap mapStryPt = new HashMap();
            mapStryPt.put(EnumStatusCategory.OPEN.getCode(), new HashMap());
            mapStryPt.put(EnumStatusCategory.INPROGRESS.getCode(), new HashMap());
            mapStryPt.put(EnumStatusCategory.DONE.getCode(), new HashMap());
            mapStryPt.put(EnumStatusCategory.MISC.getCode(), new HashMap());
            HashMap childmap = new HashMap();
            HashMap<String, Serializable> itemMeta = new HashMap<String, Serializable>();
            itemMeta.put("childmap", childmap);
            boolean tab1 = false;
            boolean tab2 = false;
            boolean tab3 = false;
            boolean tab4 = false;
            boolean tab5 = false;
            if ("0".equals(param.get("selectedTabIndex"))) {
                tab1 = true;
            }
            if ("1".equals(param.get("selectedTabIndex"))) {
                tab2 = true;
            }
            if ("2".equals(param.get("selectedTabIndex"))) {
                tab3 = true;
            }
            if ("3".equals(param.get("selectedTabIndex"))) {
                tab4 = true;
            }
            if ("4".equals(param.get("selectedTabIndex"))) {
                tab5 = true;
            }
            if ("-1".equals(param.get("selectedTabIndex"))) {
                tab1 = true;
                tab2 = true;
                tab3 = true;
                tab4 = true;
                tab5 = true;
            }
            HashMap<String, Object> boardsMap = new HashMap<String, Object>();
            ArrayList<String> bids = null;
            if (PropertyValidator.isValid((Object)param.get("boardId"))) {
                bids = new ArrayList<String>();
                bids.add(param.get("boardId"));
            }
            SessionBoard board = null;
            String trackingBid = null;
            List sessionBoards = this.sessionBoardRepository.findByIdIn(bids);
            if (PropertyValidator.isValid((Collection)sessionBoards)) {
                board = (SessionBoard)sessionBoards.get(0);
                if (board != null && board.getState() != null && board.getState().getSequence() != null && board.getState().getSequence() > 1) {
                    trackingBid = board.getId();
                }
                boardsMap.put(board.getId(), board);
            }
            ArrayList<ItemLink> links = new ArrayList<ItemLink>();
            ArrayList<HashMap> itemList = new ArrayList<HashMap>();
            int i = 0;
            int openLinks = 0;
            int doneLinks = 0;
            int planFeature = 0;
            int planStories = 0;
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("metaMap", "{}");
            response.put("boards", sessionBoards);
            response.put("progress", progress);
            response.put("items", itemList);
            response.put("storyPoints", mapStryPt);
            response.put("links", links);
            response.put("mapItemTC", tcMap);
            response.put("itemMeta", itemMeta);
            response.put("planFeatureCount", planFeature);
            response.put("planStoriesCount", planStories);
            response.put("openLinksCount", openLinks);
            response.put("doneLinksCount", doneLinks);
            String filePath = null;
            if (syncId != null) {
                String[] syncIdArray = syncId.split("#");
                requestId = syncIdArray[1];
                filePath = "SmartReport=" + UserContextUtil.getUserContext().getCurrentCompany().getTenant() + "_" + param.get("pathCode") + ".ser";
            }
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is((Object)new ObjectId((String)bids.get(0))));
            DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query.getQueryObject());
            dbCursorPrefix.sort((DBObject)new BasicDBObject("sequence", (Object)1));
            List allItems = dbCursorPrefix.toArray();
            HashMap teamMapById = new HashMap();
            HashMap containerMapById = new HashMap();
            List containers = board.getContainers();
            List teams = board.getTeams();
            containers.forEach(container -> containerMapById.put(container.getId(), container));
            teams.forEach(team -> teamMapById.put(team.getId(), team));
            ArrayList allStatuses = new ArrayList();
            HashMap<String, Status> statusMapById = new HashMap<String, Status>();
            List issueTypes = this.issueTypeRepository.findAll();
            HashMap issueTypeMapById = new HashMap();
            issueTypes.forEach(issueType -> issueTypeMapById.put(issueType.getId(), issueType));
            ArrayList itemLinks = new ArrayList();
            HashMap itemLinkMapById = new HashMap();
            ArrayList jiraLinks = new ArrayList();
            HashMap jiraLinkMapById = new HashMap();
            List linkedBoards = null;
            linkedBoards = PropertyValidator.isValid((Object)board.getParentBoard()) ? this.sessionBoardRepository.findByIdOrParentBoardOrderByCreatedOnAsc(board.getParentBoard(), board.getParentBoard()) : this.sessionBoardRepository.findByIdOrParentBoardOrderByCreatedOnAsc(board.getId(), board.getId());
            if (PropertyValidator.isValid((Collection)linkedBoards)) {
                for (int j = 0; j < linkedBoards.size(); ++j) {
                    if (!PropertyValidator.isValid((Object)((SessionBoard)linkedBoards.get(j)).getParentBoard())) continue;
                    if (((SessionBoard)linkedBoards.get(j)).getState() != null && board.getState() != null && ((SessionBoard)linkedBoards.get(j)).getState().getSequence() <= board.getState().getSequence()) {
                        bids.add(((SessionBoard)linkedBoards.get(j)).getId());
                    }
                    boardsMap.put(((SessionBoard)linkedBoards.get(j)).getId(), linkedBoards.get(j));
                }
            }
            ArrayList<Item> boardItems = new ArrayList<Item>();
            HashSet<String> statusIds = new HashSet<String>();
            HashMap<String, Boolean> parentMap = new HashMap<String, Boolean>();
            for (DBObject vo : allItems) {
                Object statusRef;
                if (Item.Type.Feature.name().equals((String)vo.get("type"))) {
                    parentMap.put(String.valueOf(vo.get("_id")), true);
                }
                if (!PropertyValidator.isValid((Object)(statusRef = (DBRef)vo.get("status")))) continue;
                statusIds.add(String.valueOf(statusRef.getId()));
            }
            HashSet<String> wfIds = new HashSet<String>();
            if (board != null && board.getSession() != null && board.getSession().getDependencyWorkFlow() != null && board.getSession().getDependencyWorkFlow().getId() != null) {
                wfIds.add(board.getSession().getDependencyWorkFlow().getId());
            }
            List statuses = this.statusRepository.findByIdInOrWorkFlowIdIn(statusIds, wfIds);
            statusIds.clear();
            if (PropertyValidator.isValid((Collection)statuses)) {
                for (Status status : statuses) {
                    statusMapById.put(status.getId(), status);
                }
                statuses.clear();
            }
            for (DBObject vo : allItems) {
                Item item = null;
                try {
                    List sessionBoardsRef;
                    String id;
                    SessionBoard itemBorad;
                    item = this.createItemForReportSmart(vo, statusMapById, allStatuses, itemLinkMapById, itemLinks, jiraLinkMapById, jiraLinks, teamMapById, containerMapById, issueTypeMapById);
                    if (!(Item.Type.UserStory.name().equals(item.getType()) ? item.getParent() != null && Boolean.TRUE.equals(parentMap.get(item.getParent().getId())) : Item.Type.Feature.name().equals(item.getType()))) continue;
                    boardItems.add(item);
                    if (!PropertyValidator.isValid((Object)item.getStatus())) {
                        Status status = new Status();
                        status.setCategory("Misc");
                        status.setId("none");
                        status.setTitle("--");
                        item.setStatus(status);
                    }
                    HashMap trimedItem = item.toSimpleObject();
                    trimedItem.put("id", item.getId());
                    trimedItem.put("status", item.getStatus().toSimpleObject());
                    trimedItem.put("storyPoints", item.getStoryPoints());
                    trimedItem.put("type", item.getType());
                    if (item.getParent() != null) {
                        HashMap<String, String> parentItemMap = new HashMap<String, String>();
                        parentItemMap.put("id", item.getParent().getId());
                        trimedItem.put("parent", parentItemMap);
                    }
                    if ((itemBorad = (SessionBoard)boardsMap.get(id = ((DBRef)(sessionBoardsRef = (List)vo.get("sessionBoards")).get(0)).getId().toString())) != null && itemBorad.getState() != null && itemBorad.getState().getSequence() != null) {
                        boolean countIt = false;
                        if (itemBorad.getState().getSequence() > 1 && itemBorad.getStateChangeDate() != null && item.getCreatedOn() != null && item.getCreatedOn().getTime() > itemBorad.getStateChangeDate().getTime()) {
                            countIt = true;
                        }
                        if (countIt) {
                            if (Item.Type.UserStory.name().equals(item.getType())) {
                                ++planStories;
                                trimedItem.put("afterPlanning", true);
                                trimedItem.put("createdOn", item.getCreatedOn());
                            } else if (Item.Type.Feature.name().equals(item.getType())) {
                                ++planFeature;
                                trimedItem.put("afterPlanning", true);
                                trimedItem.put("createdOn", item.getCreatedOn());
                            }
                        }
                    }
                    item.setSessionBoards(null);
                    List tcs = item.getTeamContainers();
                    if (PropertyValidator.isValid((Collection)tcs) && PropertyValidator.isValid(tcs.get(0))) {
                        if (PropertyValidator.isValid((Object)item.getStatus()) && PropertyValidator.isValid((Object)item.getStatus().getCategory())) {
                            ((ArrayList)((Map)progress.get("progress" + item.getType())).get(item.getStatus().getCategory())).add(i);
                        }
                        if (Item.Type.UserStory.name().equals(item.getType())) {
                            if (PropertyValidator.isValid((Object)item.getStoryPoints()) && PropertyValidator.isValid((Object)item.getStatus()) && PropertyValidator.isValid((Object)item.getStatus().getCategory())) {
                                String spid = ((TeamContainer)tcs.get(0)).getContainer().getId();
                                if (((Map)mapStryPt.get(item.getStatus().getCategory())).get(spid) == null) {
                                    ((Map)mapStryPt.get(item.getStatus().getCategory())).put(spid, 0.0);
                                }
                                ((Map)mapStryPt.get(item.getStatus().getCategory())).put(spid, item.getStoryPoints() + (Double)((Map)mapStryPt.get(item.getStatus().getCategory())).get(spid));
                            }
                            if (tab1 || tab2 || tab3 || tab4) {
                                tcMap.put("itemIndex_" + item.getId(), i);
                                trimedItem.put("teamContainers", new /* Unavailable Anonymous Inner Class!! */);
                            }
                        } else if (Item.Type.Feature.name().equals(item.getType()) && (tab1 || tab2 || tab3 || tab4)) {
                            int j = 0;
                            ArrayList<HashMap> tcList = new ArrayList<HashMap>();
                            for (TeamContainer tc : tcs) {
                                if (!PropertyValidator.isValid((Object)tc)) continue;
                                tcMap.put("itemIndex_" + tc.getId(), i);
                                tcMap.put("tcIndex_" + tc.getId(), j);
                                ++j;
                                tcList.add(tc.toSimpleObject());
                            }
                            trimedItem.put("teamContainers", tcList);
                        }
                        if (tab3 || tab4) {
                            ArrayList<HashMap> linkList = new ArrayList<HashMap>();
                            List list = item.getItemLinks();
                            if (PropertyValidator.isValid((Collection)list)) {
                                for (ItemLink itemLink : list) {
                                    if (!PropertyValidator.isValid((Object)itemLink) || !PropertyValidator.isValid((Object)itemLink.getStatus())) continue;
                                    links.add(itemLink);
                                    linkList.add(itemLink.toSimpleObject());
                                    if (itemLink.getStatus().equals("Open")) {
                                        ++openLinks;
                                        continue;
                                    }
                                    ++doneLinks;
                                }
                                trimedItem.put("itemLinks", linkList);
                            }
                        }
                    } else if (PropertyValidator.isValid((Object)item.getStatus()) && PropertyValidator.isValid((Object)item.getStatus().getCategory())) {
                        ((ArrayList)((Map)progress.get("unPlanProgress" + item.getType())).get(item.getStatus().getCategory())).add(i);
                    }
                    if (tab1 || tab2 || tab5) {
                        itemMeta.put(((Item)boardItems.get(i)).getId(), Integer.valueOf(i));
                        if (PropertyValidator.isValid((Object)((Item)boardItems.get(i)).getParent()) && PropertyValidator.isValid((Object)((Item)boardItems.get(i)).getParent().getId())) {
                            if (childmap.get(((Item)boardItems.get(i)).getParent().getId()) == null) {
                                childmap.put(((Item)boardItems.get(i)).getParent().getId(), new ArrayList());
                            }
                            ((List)childmap.get(((Item)boardItems.get(i)).getParent().getId())).add(i);
                        }
                    }
                    itemList.add(trimedItem);
                    ++i;
                }
                catch (Exception exx) {
                    LOGGER.error("item id.... " + (item != null ? item.getId() : "item is null") + "\n....exp ...." + StringUtils.getTraceString((Throwable)exx));
                }
            }
            response.put("planFeatureCount", planFeature);
            response.put("planStoriesCount", planStories);
            response.put("openLinksCount", openLinks);
            response.put("doneLinksCount", doneLinks);
            if ((tab3 || tab4) && board.getSession() != null) {
                if (board.getSession().getAlmConfigurations() != null && board.getSession().getAlmConfigurations().size() > 0) {
                    response.put("jiraLinksTypes", this.almSyncService.retrieveJiraIssueLinkTypesList(((AlmConfigurations)board.getSession().getAlmConfigurations().get(0)).getAlmAccount(), false));
                } else if (board.getSession().getTfsAlmConfigurations() != null && board.getSession().getTfsAlmConfigurations().getAlmAccount() != null) {
                    response.put("tfsLinksTypes", this.tfsUtils.getRelationShipTypes(board.getSession().getTfsAlmConfigurations().getAlmAccount()));
                }
            }
            if (syncId == null) {
                List logMaps;
                if (PropertyValidator.isValid(bids) && PropertyValidator.isValid((Collection)(logMaps = this.itemLogMapRepository.findBySessionBoardIdInAndTenantIsNull(bids)))) {
                    this.itemLogMapRepository.save((Iterable)logMaps);
                }
                response.put("currentRange", this.queryActivity(syncId, param, "currentRangeStart", "currentRangeEnd", mappedStatus, bids, trackingBid));
                response.put("lastRange", this.queryActivity(syncId, param, "lastRangeStart", "lastRangeEnd", mappedStatus, bids, trackingBid));
                return new ResponseEntity(response, HttpStatus.OK);
            }
            param.put("emptyLogs", "true");
            HashMap empty = this.queryActivity(syncId, param, "currentRangeStart", "currentRangeEnd", mappedStatus, bids, trackingBid);
            response.put("emptyLogs", empty);
            response.put("refreshing", true);
            ObjectMapper mapper = new ObjectMapper();
            this.pushResponseRepository.save((Object)new PushResponse(requestId, mapper.writeValueAsString(response), Boolean.valueOf(false)));
            response = new HashMap();
            param.remove("emptyLogs");
            if (PropertyValidator.isValid((Object)param.get("refreshData"))) {
                MongoSyncUtils.removeData((String)filePath, (AppConfig.MongoConfig)this.mongoConfig);
            }
            if (exists = MongoSyncUtils.isDataFound((String)filePath, (AppConfig.MongoConfig)this.mongoConfig)) {
                this.onReportChartsResponse(syncId, "filePath", (Object)filePath, Boolean.valueOf(true));
                return new ResponseEntity(null, HttpStatus.OK);
            }
            response.put("updating", true);
            this.pushResponseRepository.save((Object)new PushResponse(requestId, response, Boolean.valueOf(false)));
            response.put("currentRange", this.queryActivity(syncId, param, "currentRangeStart", "currentRangeEnd", mappedStatus, bids, trackingBid));
            response.put("lastRange", this.queryActivity(syncId, param, "lastRangeStart", "lastRangeEnd", mappedStatus, bids, trackingBid));
            response.put("reportDate", new Date());
            response.put("refreshing", false);
            response.put("updating", false);
            this.onReportChartsResponse(syncId, "filePath", (Object)this.serializeObject(syncId, response, filePath), Boolean.valueOf(true));
            return new ResponseEntity(null, HttpStatus.OK);
        }
        catch (Exception e) {
            HashMap<String, Exception> err = new HashMap<String, Exception>();
            err.put("exception", e);
            this.onReportChartsResponse(param.get("errSyncId"), "error", err, Boolean.valueOf(true));
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
    }

    private List<ItemLogMap> buildLogsQuery(HashMap<String, String> param, String name1, String name2, List<String> bids, Date start, Date end) {
        boolean tab1 = false;
        boolean tab2 = false;
        boolean tab3 = false;
        boolean boardIdExists = PropertyValidator.isValid((Object)param.get("boardId"));
        ArrayList<String> actions = new ArrayList<String>();
        actions.add(ItemLog.UniquePrefix.archive.name());
        if (PropertyValidator.isValid((Object)param.get("selectedTabIndex"))) {
            if ("0".equals(param.get("selectedTabIndex"))) {
                tab1 = true;
                actions.add(ItemLog.UniquePrefix.byStatus.name());
            } else if ("1".equals(param.get("selectedTabIndex"))) {
                tab2 = true;
                actions.add(ItemLog.UniquePrefix.byPlan.name());
                actions.add(ItemLog.UniquePrefix.byTC.name());
                actions.add(ItemLog.UniquePrefix.byT.name());
                actions.add(ItemLog.UniquePrefix.byC.name());
                actions.add(ItemLog.UniquePrefix.byPoints.name());
            } else if (!"2".equals(param.get("selectedTabIndex")) && "-1".equals(param.get("selectedTabIndex"))) {
                tab1 = true;
                actions.add(ItemLog.UniquePrefix.byStatus.name());
                tab2 = true;
                actions.add(ItemLog.UniquePrefix.byPlan.name());
                actions.add(ItemLog.UniquePrefix.byTC.name());
                actions.add(ItemLog.UniquePrefix.byT.name());
                actions.add(ItemLog.UniquePrefix.byC.name());
                actions.add(ItemLog.UniquePrefix.byPoints.name());
            }
        }
        param.put("tab1", String.valueOf(tab1));
        param.put("tab2", String.valueOf(tab2));
        param.put("tab3", String.valueOf(tab3));
        return this.getItemLogData(start, end, bids, actions, boardIdExists, UserContextUtil.getUserContext().getLoggedInUser().getTenant());
    }

    List<ItemLogMap> getItemLogData(Date start, Date end, List<String> bids, List<String> actions, boolean boardIdExists, String tenant) {
        LinkedList<ItemLogMap> itemLogMaps = new LinkedList<ItemLogMap>();
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"eventTime", (Object)new BasicDBObject("$gte", (Object)start));
        query.put((Object)"$and", Collections.singletonList(new BasicDBObject("eventTime", (Object)new BasicDBObject("$lt", (Object)end))));
        if (boardIdExists) {
            query.put((Object)"sessionBoard.$id", (Object)new BasicDBObject("$in", (Object)KendisUtils.getListAsObjectIds(bids)));
        }
        if (PropertyValidator.isValid(actions)) {
            query.put((Object)"$or", Collections.singletonList(new BasicDBObject("_id", (Object)new BasicDBObject("$regex", (Object)String.join((CharSequence)"|", actions)).append("$options", (Object)"i"))));
        }
        query.put((Object)"archive", (Object)new BasicDBObject("$ne", (Object)true));
        query.put((Object)"tenant", (Object)tenant);
        BasicDBObject sort = new BasicDBObject("eventTime", (Object)-1);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(ItemLogMap.class));
        LinkedList<ObjectId> itemLogIds = new LinkedList<ObjectId>();
        try (DBCursor cursor = collection.find((DBObject)query).sort((DBObject)sort);){
            while (cursor.hasNext()) {
                BasicDBObject obj = (BasicDBObject)cursor.next();
                if (!PropertyValidator.isValid((Object)obj.get("itemLog"))) continue;
                DBRef itemLogRef = (DBRef)obj.get("itemLog");
                itemLogIds.add(new ObjectId(itemLogRef.getId().toString()));
                ItemLogMap itemLogMap2 = new ItemLogMap();
                ItemLog itemLog = new ItemLog(itemLogRef.getId().toString());
                itemLogMap2.setItemLog(itemLog);
                itemLogMaps.add(itemLogMap2);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        BasicDBObject matchQuery = new BasicDBObject("$match", (Object)new BasicDBObject().append("_id", (Object)new BasicDBObject("$in", itemLogIds)).append("tenant", (Object)tenant).append("archive", (Object)false));
        Map itemLogByIdMap = this.getItemLogsFromIds(matchQuery, null);
        itemLogMaps.forEach(itemLogMap -> {
            ItemLog itemLog = (ItemLog)itemLogByIdMap.get(itemLogMap.getItemLog().getId());
            itemLogMap.setItemLog(itemLog);
        });
        return itemLogMaps;
    }

    private Map<String, ItemLog> getItemLogsFromIds(BasicDBObject matchQuery, BasicDBObject sortStage) {
        HashMap<String, ItemLog> itemLogs = new HashMap<String, ItemLog>();
        BasicDBObject projection = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("itemId", (Object)1).append("changes", (Object)1).append("detail", (Object)1).append("eventType", (Object)1).append("eventTime", (Object)1));
        ArrayList<BasicDBObject> pipeline = new ArrayList<BasicDBObject>(Arrays.asList(matchQuery, projection));
        if (PropertyValidator.isValid((Object)sortStage)) {
            pipeline.add(sortStage);
        }
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(ItemLog.class));
        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor cursor = collection.aggregate(pipeline, ao);){
            while (cursor.hasNext()) {
                BasicDBObject obj = (BasicDBObject)cursor.next();
                String id = DBUtils.getIdFromDBObject((BasicDBObject)obj, (String[])new String[]{"_id"});
                ItemLog itemLog = new ItemLog(id);
                itemLog.setItemId(obj.getString("itemId"));
                itemLog.setEventType(obj.getString("eventType"));
                itemLog.setEventTime(obj.getDate("eventTime"));
                itemLog.setChanges(obj.getString("changes"));
                if (PropertyValidator.isValid((Object)obj.get("detail"))) {
                    itemLog.setDetail(obj.get("detail"));
                }
                itemLogs.put(itemLog.getId(), itemLog);
            }
        }
        return itemLogs;
    }

    private HashMap<String, Object> queryActivity(String syncId, HashMap<String, String> param, String name1, String name2, HashMap<String, Status> mappedStatus, List<String> bids, String trackingBid) throws Exception {
        long oneDay = 86400000L;
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
        Date start = sdf.parse(param.get(name1));
        Date end = sdf.parse(param.get(name2));
        end = new Date(end.getTime() + oneDay);
        List logs = new ArrayList();
        ArrayList<String> ids = new ArrayList<String>();
        HashMap teams = new HashMap();
        Gson gsonExclusive = new Gson();
        Type mapType = new /* Unavailable Anonymous Inner Class!! */.getType();
        HashMap byStatus = new HashMap();
        HashMap<String, Serializable> bySPT = new HashMap<String, Serializable>();
        bySPT.put("indices", new ArrayList());
        bySPT.put("sum", Double.valueOf(0.0));
        HashMap byTC = new HashMap();
        byTC.put("indices", new ArrayList());
        byTC.put("indicesTeamChanged", new ArrayList());
        byTC.put("indicesContainerChanged", new ArrayList());
        HashMap byScope = new HashMap();
        byScope.put("indices", new ArrayList());
        HashMap byDep = new HashMap();
        byDep.put("indicesDep_Open", new ArrayList());
        byDep.put("indicesAddedDep_Open", new ArrayList());
        byDep.put("indicesDep_Resolved", new ArrayList());
        byDep.put("indicesAddedDep_Resolved", new ArrayList());
        HashMap<String, String> itemLatestActivity = new HashMap<String, String>();
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("status", byStatus);
        response.put("teams", teams);
        response.put("TC", byTC);
        response.put("SPT", bySPT);
        response.put("scope", byScope);
        response.put("DEP", byDep);
        boolean tab1 = false;
        boolean tab2 = false;
        boolean tab3 = false;
        if (!param.containsKey("emptyLogs")) {
            logs = this.buildLogsQuery(param, name1, name2, bids, start, end);
            tab1 = Boolean.parseBoolean(param.get("tab1"));
            tab2 = Boolean.parseBoolean(param.get("tab2"));
            tab3 = Boolean.parseBoolean(param.get("tab3"));
        }
        String logId = null;
        for (ItemLogMap itemLogMap : logs) {
            ItemLog itemLog = itemLogMap.getItemLog();
            if (!PropertyValidator.isValid((Object)itemLog)) continue;
            ids.add(itemLog.getItemId());
            Map changes = (Map)gsonExclusive.fromJson(itemLog.getChanges(), mapType);
            logId = itemLog.getId();
            if (itemLog.getDetail() == null) continue;
            Map item = (Map)itemLog.getDetail();
            String itemId = (String)item.get("id");
            String originItemId = (String)item.get("originItemId");
            if (originItemId != null) {
                itemId = originItemId;
            }
            String itemType = (String)item.get("type");
            Double itemStoryPoints = (Double)item.get("storyPoints");
            List itemLinks = (List)item.get("itemLinks");
            List itemTcList = (List)item.get("teamContainers");
            Object status = item.get("status");
            String uniqueByStatus = ItemLog.UniquePrefix.byStatus.name() + itemId;
            String uniqueByTC = ItemLog.UniquePrefix.byTC.name() + itemId;
            String uniqueByT = ItemLog.UniquePrefix.byT.name() + itemId;
            String uniqueByC = ItemLog.UniquePrefix.byC.name() + itemId;
            String uniqueByPlan = ItemLog.UniquePrefix.byPlan.name() + itemId;
            String uniqueByPoints = ItemLog.UniquePrefix.byPoints.name() + itemId;
            String uniqueByLinks = ItemLog.UniquePrefix.byLinks.name();
            String _event = itemLog.getEventType();
            if (_event.equals(EnumActivityType.DELETED.getCode()) && Boolean.TRUE.equals(changes.get(ItemLog.Changes.archive.name()))) {
                itemLatestActivity.put(uniqueByStatus, "1");
                itemLatestActivity.put(uniqueByTC, "1");
                itemLatestActivity.put(uniqueByT, "1");
                itemLatestActivity.put(uniqueByC, "1");
                itemLatestActivity.put(uniqueByPlan, "1");
                itemLatestActivity.put(uniqueByPoints, "1");
            }
            if (tab1 && itemLatestActivity.get(uniqueByStatus) == null && changes.get(ItemLog.Changes.status.name()) != null && status != null && status instanceof Map) {
                this.countChangesByTeams(String.valueOf(logId), itemTcList, ((Map)status).get("category") + "_" + itemType, uniqueByStatus, itemLatestActivity, teams, byStatus);
            }
            if (tab2) {
                boolean isTracking = false;
                boolean extraLog = false;
                Map state = (Map)item.get("sessionBoardState");
                try {
                    if (PropertyValidator.isValid((Object)state) && PropertyValidator.isValid(state.get("sequence")) && (Integer)state.get("sequence") > 1) {
                        isTracking = true;
                    } else if (state == null) {
                        isTracking = trackingBid != null;
                    }
                }
                catch (Exception exx) {
                    LOGGER.error("item id.... " + (item != null ? item.get("_id") : "item is null") + "\n....exp ...." + StringUtils.getTraceString((Throwable)exx));
                }
                if (itemLatestActivity.get(uniqueByPlan) == null && changes.get(ItemLog.Changes.teamContainers.name()) != null && PropertyValidator.isValid((Collection)itemTcList) && isTracking && (changes.get(ItemLog.Changes.teamChanged.name()) != null || Item.Type.Feature.name().equals(itemType))) {
                    this.countChangesByTeams(String.valueOf(logId), itemTcList, "scope_" + itemType, uniqueByPlan, itemLatestActivity, teams, byTC);
                }
                if (isTracking) {
                    boolean tcRemoved;
                    boolean bl = tcRemoved = _event.equals(EnumActivityType.DELETED.getCode()) && !Boolean.TRUE.equals(changes.get(ItemLog.Changes.archive.name()));
                    if (_event.equals(EnumActivityType.BULK.getCode()) && Boolean.FALSE.equals(changes.get(ItemLog.Changes.phoenixSequence.name()))) {
                        tcRemoved = true;
                    }
                    if (tcRemoved) {
                        if (Item.Type.UserStory.name().equals(itemType)) {
                            if (itemLatestActivity.get(uniqueByT) == null) {
                                ((List)byTC.get("indicesTeamChanged")).add(logId);
                                itemLatestActivity.put(uniqueByT, "1");
                            }
                            if (itemLatestActivity.get(uniqueByC) == null) {
                                ((List)byTC.get("indicesContainerChanged")).add(logId);
                                itemLatestActivity.put(uniqueByC, "1");
                            }
                        } else if (itemLatestActivity.get(uniqueByTC) == null && (tcRemoved || changes.get(ItemLog.Changes.phoenixSequence.name()) != null && item.get(ItemLog.Changes.phoenixSequence.name()) != null)) {
                            ((List)byScope.get("indices")).add(logId);
                            itemLatestActivity.put(uniqueByTC, this.getPhoenixId(item) + "_" + logId);
                        }
                    } else {
                        if (changes.get(ItemLog.Changes.phoenixSequence.name()) != null && item.get(ItemLog.Changes.phoenixSequence.name()) != null) {
                            if (itemLatestActivity.get(uniqueByTC) == null) {
                                ((List)byScope.get("indices")).add(logId);
                                itemLatestActivity.put(uniqueByTC, this.getPhoenixId(item) + "_" + logId);
                            } else {
                                extraLog = true;
                            }
                        }
                        if (!(itemLatestActivity.get(uniqueByT) != null && itemLatestActivity.get(uniqueByC) != null || !PropertyValidator.isValid((Collection)itemTcList) && !_event.equals(EnumActivityType.BULK.getCode()) || changes.get(ItemLog.Changes.containerChanged.name()) == null && changes.get(ItemLog.Changes.teamChanged.name()) == null)) {
                            ((List)byTC.get("indices")).add(logId);
                            if (itemLatestActivity.get(uniqueByT) == null && changes.get(ItemLog.Changes.teamChanged.name()) != null) {
                                ((List)byTC.get("indicesTeamChanged")).add(logId);
                                itemLatestActivity.put(uniqueByT, "1");
                                if (itemTcList.size() > 0 && itemTcList.get(0) != null && ((Map)itemTcList.get(0)).get("team") != null) {
                                    itemLatestActivity.put(uniqueByT, this.getObjectIdInTC((Map)((Map)itemTcList.get(0)).get("team")) + "_" + logId);
                                }
                            }
                            if (itemLatestActivity.get(uniqueByC) == null && changes.get(ItemLog.Changes.containerChanged.name()) != null) {
                                ((List)byTC.get("indicesContainerChanged")).add(logId);
                                itemLatestActivity.put(uniqueByC, "1");
                                if (itemTcList.size() > 0 && itemTcList.get(0) != null && ((Map)itemTcList.get(0)).get("container") != null) {
                                    itemLatestActivity.put(uniqueByC, this.getObjectIdInTC((Map)((Map)itemTcList.get(0)).get("container")) + "_" + logId);
                                }
                            }
                            itemLatestActivity.put(uniqueByTC, logId + "");
                        }
                    }
                    if (Item.Type.UserStory.name().equals(itemType) && itemLatestActivity.get(uniqueByPoints) == null && !EnumActivityType.CREATED.getCode().equals(_event) && changes.get(ItemLog.Changes.storyPoints.name()) != null) {
                        bySPT.put("sum", Double.valueOf((itemStoryPoints == null ? 0.0 : itemStoryPoints) + (Double)bySPT.get("sum")));
                        ((List)bySPT.get("indices")).add(logId);
                        itemLatestActivity.put(uniqueByPoints, "1");
                    }
                } else if (state != null) {
                    String oldStateLog = itemId + "" + state.get("sequence");
                    if (itemLatestActivity.containsKey(oldStateLog)) {
                        extraLog = true;
                    } else if (!itemLatestActivity.containsKey(itemId + "old")) {
                        extraLog = true;
                        oldStateLog = itemId + "old";
                    }
                    itemLatestActivity.put(oldStateLog, "1");
                }
                if (extraLog) {
                    List parsed;
                    if (itemLatestActivity.containsKey(uniqueByTC)) {
                        String[] seq_index = ((String)itemLatestActivity.get(uniqueByTC)).split("_");
                        parsed = (List)byScope.get("indices");
                        if (parsed != null && parsed.size() > 0 && seq_index.length > 1 && this.getPhoenixId(item).equals(seq_index[0])) {
                            parsed.remove(seq_index[1]);
                            itemLatestActivity.remove(uniqueByTC);
                        }
                    }
                    if (Item.Type.UserStory.name().equals(itemType)) {
                        if (itemLatestActivity.containsKey(uniqueByT)) {
                            String[] seq_index = ((String)itemLatestActivity.get(uniqueByT)).split("_");
                            parsed = (List)byTC.get("indicesTeamChanged");
                            if (parsed != null && parsed.size() > 0 && seq_index.length > 1 && itemTcList != null && itemTcList.size() > 0 && this.getObjectIdInTC((Map)((Map)itemTcList.get(0)).get("team")).equals(seq_index[0])) {
                                parsed.remove(seq_index[1]);
                                itemLatestActivity.remove(uniqueByT);
                            }
                        }
                        if (itemLatestActivity.containsKey(uniqueByC)) {
                            String[] seq_index = ((String)itemLatestActivity.get(uniqueByC)).split("_");
                            parsed = (List)byTC.get("indicesContainerChanged");
                            if (parsed != null && parsed.size() > 0 && seq_index.length > 1 && itemTcList != null && itemTcList.size() > 0 && this.getObjectIdInTC((Map)((Map)itemTcList.get(0)).get("container")).equals(seq_index[0])) {
                                parsed.remove(seq_index[1]);
                                itemLatestActivity.remove(uniqueByC);
                            }
                        }
                    }
                }
            }
            if (!tab3 || changes.get(ItemLog.Changes.itemLinks.name()) == null || itemLinks == null || itemLinks.size() <= 0) continue;
            for (int i = 0; i < itemLinks.size(); ++i) {
                Map link = (Map)itemLinks.get(i);
                if (link == null) continue;
                String originLinkId = (String)link.get("originItemId");
                if (!PropertyValidator.isValid((Object)originLinkId)) {
                    originLinkId = (String)link.get("id");
                }
                String uniquKey = uniqueByLinks + originLinkId;
                if (link.containsKey("wfStatus")) {
                    Map map = (Map)link.get("wfStatus");
                    link.put("status", "Done".equals(map.get("category")) ? "Resolved" : "Open");
                }
                String graphKey = "Dep_" + link.get("status");
                String loc = logId + "," + i;
                if (itemLatestActivity.get(uniquKey) == null && Boolean.TRUE.equals(changes.get(ItemLog.Changes.itemLinks.name()))) {
                    Long createdOn;
                    List tc;
                    String src_tid = null;
                    String trg_tid = null;
                    Map linkedItem = (Map)link.get("sourceItem");
                    if (linkedItem != null) {
                        tc = (List)linkedItem.get("teamContainers");
                        if (tc != null && tc.size() > 0) {
                            src_tid = (String)((Map)((Map)tc.get(0)).get("team")).get("id");
                            src_tid = src_tid + (String)((Map)((Map)tc.get(0)).get("container")).get("id");
                        }
                        this.countChangesByTeams(loc, tc, graphKey, uniquKey, itemLatestActivity, teams, byDep);
                    }
                    if ((linkedItem = (Map)link.get("targetItem")) != null) {
                        tc = (List)linkedItem.get("teamContainers");
                        if (tc != null && tc.size() > 0) {
                            trg_tid = (String)((Map)((Map)tc.get(0)).get("team")).get("id");
                            trg_tid = trg_tid + (String)((Map)((Map)tc.get(0)).get("container")).get("id");
                        }
                        if (!trg_tid.equals(trg_tid)) {
                            this.countChangesByTeams(loc, tc, graphKey, uniquKey, itemLatestActivity, teams, byDep);
                        }
                    }
                    if ((createdOn = (Long)link.get("createdOn")) != null && createdOn >= start.getTime() && createdOn <= end.getTime()) {
                        ((List)byDep.get("indicesAdded" + graphKey)).add(loc);
                    }
                    ((List)byDep.get("indices" + graphKey)).add(loc);
                }
                itemLatestActivity.put(uniquKey, "1");
            }
        }
        return response;
    }

    private String getPhoenixId(Map<String, Object> item) {
        Map object = (Map)item.get("phoenixTC");
        if (object != null) {
            if ((object = (Map)object.get("container")).containsKey("originItemId")) {
                return (String)object.get("originItemId");
            }
            return (String)object.get("id");
        }
        return "";
    }

    private String getObjectIdInTC(Map<String, Object> object) {
        if (object != null) {
            if (object.containsKey("originItemId")) {
                return (String)object.get("originItemId");
            }
            return (String)object.get("id");
        }
        return "";
    }

    private void countChangesByTeams(String index, List<Map<String, Object>> itemTcList, String graphKey, String uniquKey, Map<String, String> itemLatestActivity, Map<String, Object> teams, Map<String, Object> chartData) {
        HashMap<String, ArrayList<String>> chartMap = (HashMap<String, ArrayList<String>>)chartData.get(graphKey);
        if (chartData.get(graphKey) == null) {
            chartMap = new HashMap<String, ArrayList<String>>();
        }
        String tid = null;
        HashMap<String, Boolean> tcMap = new HashMap<String, Boolean>();
        if (itemTcList != null) {
            for (int i = 0; i < itemTcList.size(); ++i) {
                Map tm = (Map)itemTcList.get(i).get("team");
                if (tm == null || tcMap.get(tid = (String)tm.get("id")) != null) continue;
                teams.put(tid, tm);
                ArrayList<String> cat = (ArrayList<String>)chartMap.get(tid);
                if (cat == null) {
                    cat = new ArrayList<String>();
                }
                cat.add(index);
                chartMap.put(tid, cat);
                tcMap.put(tid, true);
            }
        }
        tid = "ALL";
        HashMap<String, String> tm = new HashMap<String, String>();
        tm.put("id", tid);
        teams.put(tid, tm);
        ArrayList<String> cat = (ArrayList<String>)chartMap.get(tid);
        if (cat == null) {
            cat = new ArrayList<String>();
        }
        cat.add(index);
        chartMap.put(tid, cat);
        tcMap.clear();
        tcMap = null;
        chartData.put(graphKey, chartMap);
        itemLatestActivity.put(uniquKey, "1");
    }

    @RequestMapping(value={"/last/{action}/values"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getLastValues(@RequestBody HashMap<String, ObjectId> param, @PathVariable String action) {
        try {
            HashMap<String, ItemLog> map = new HashMap<String, ItemLog>();
            Collection<ObjectId> ids = param.values();
            if (PropertyValidator.isValid(ids)) {
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"detail").ne(null));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
                query.with(new Sort(Sort.Direction.DESC, new String[]{"eventTime"}));
                List logs = this.mongoTemplate.find(query, ItemLog.class);
                for (ItemLog itemLog : logs) {
                    if (param.get(itemLog.getItemId()) == null || map.get(itemLog.getItemId()) != null) continue;
                    map.put(itemLog.getItemId(), itemLog);
                }
            }
            HashMap<String, HashMap<String, ItemLog>> response = new HashMap<String, HashMap<String, ItemLog>>();
            response.put(action, map);
            return new ResponseEntity(response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/last1/{action}/values"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getLastValues1(@RequestBody HashMap<String, Object> param, @PathVariable String action) {
        try {
            Collection<Object> ids;
            HashMap<String, ItemLog> map = new HashMap<String, ItemLog>();
            HashMap mapLogs = (HashMap)param.get("mapLogs");
            if (PropertyValidator.isValid((Object)mapLogs)) {
                ids = mapLogs.keySet();
                Gson gsonExclusive = new Gson();
                Type mapType = new /* Unavailable Anonymous Inner Class!! */.getType();
                if (PropertyValidator.isValid(ids)) {
                    BasicDBObject query = new BasicDBObject();
                    query.put((Object)"detail", (Object)new BasicDBObject("$ne", null));
                    query.put((Object)"itemId", (Object)new BasicDBObject("$in", ids));
                    query.put((Object)"tenant", (Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant());
                    query.put((Object)"archive", (Object)false);
                    ArrayList<String> actions = new ArrayList<String>();
                    if (PropertyValidator.isValid((Object)action)) {
                        actions.add("\"" + action + "\":");
                        if (actions.size() > 0) {
                            query.put((Object)"$or", Collections.singletonList(new BasicDBObject("changes", (Object)new BasicDBObject("$regex", (Object)String.join((CharSequence)"|", actions)).append("$options", (Object)"i"))));
                        }
                    }
                    BasicDBObject matchStage = new BasicDBObject("$match", (Object)query);
                    BasicDBObject sortStage = new BasicDBObject("$sort", (Object)new BasicDBObject("eventTime", (Object)-1));
                    Map logs = this.getItemLogsFromIds(matchStage, sortStage);
                    SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
                    for (ItemLog itemLog : logs.values()) {
                        Map changes;
                        Map item;
                        Map state;
                        if (mapLogs.get(itemLog.getItemId()) == null || itemLog.getEventTime().getTime() >= (Long)mapLogs.get(itemLog.getItemId()) || map.get(itemLog.getItemId()) != null || sdf.format(itemLog.getEventTime()).equals(sdf.format(mapLogs.get(itemLog.getItemId()))) && (state = (Map)(item = (Map)itemLog.getDetail()).get("sessionBoardState")) != null && (Integer)state.get("sequence") > 1 && item.get("duplicateOfId") != null || (changes = (Map)gsonExclusive.fromJson(itemLog.getChanges(), mapType)).get(action) == null) continue;
                        map.put(itemLog.getItemId(), itemLog);
                    }
                }
            }
            ids = (List)param.get("ids");
            List oldStateItems = null;
            if (PropertyValidator.isValid(ids)) {
                SessionBoard sb;
                Session s = new Session();
                s.setId((String)param.get("sessionId"));
                State state = this.stateRepository.findOneBySequence((Integer)param.get("stateSequence"));
                if (PropertyValidator.isValid((Object)state) && PropertyValidator.isValid((Object)(sb = this.sessionBoardRepository.findOneBySessionAndState(s, state)))) {
                    ArrayList<String> sbIds = new ArrayList<String>();
                    sbIds.add(sb.getId());
                    oldStateItems = this.itemRepository.findByOriginItemIdInAndSessionBoardsIdIn(ids, sbIds);
                }
            }
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put(action, map);
            if (PropertyValidator.isValid(oldStateItems)) {
                response.put("oldStateItems", oldStateItems);
            } else {
                response.put("oldStateItems", new ArrayList());
            }
            return new ResponseEntity(response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/lead-time"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> loadBoardCFG(@RequestBody HashMap<String, Object> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            List bids = KendisUtils.getListAsObjectIds((Collection)((List)requestBody.get("sessionBoard.$id")));
            long oneDay = 86400000L;
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
            Date start = sdf.parse((String)requestBody.get("start"));
            Date end = sdf.parse((String)requestBody.get("end"));
            end = new Date(end.getTime() + oneDay);
            String chart = (String)requestBody.get("chart");
            if ("LeadTime".equals(chart)) {
                responseJson.put("result", this.customRepositoryImpl.findItemLog(tenant, start, end, "status", "sessionBoard.$id", (Collection)bids, ItemLog.class, Integer.valueOf(Integer.parseInt((String)requestBody.get("test")))));
            } else {
                responseJson.put("result", this.customRepositoryImpl.findItemLogForAddedInSession(tenant, start, end, "sessionBoard.$id", (Collection)bids, ItemLog.class, Boolean.parseBoolean((String)requestBody.get("test"))));
            }
        }
        catch (Exception e) {
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error(err);
            responseJson.put("kendisError", e);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/exportChartdetail/{type}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> exportChartDetail(@PathVariable(value="type") String type, @RequestBody HashMap<String, Object> requestBody) {
        try {
            return this.exportService.exportChartDetail(type, requestBody);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
    }

    private String getHttpScheme() {
        if (this.env.getProperty("redirect.from.http.server.port") != null) {
            return "https";
        }
        return "http";
    }

    @Scheduled(cron="0 0 * * * *")
    public void processReports() {
        if (SystemUtil.isProductionEnv() || this.env.getProperty("isLocalDeployment").equals("true")) {
            this.notifyReports(null);
        }
    }

    @RequestMapping(value={"/notification-setting"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getNotificationSetting(@RequestBody HashMap<String, String> param) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("serverTimeZone", AlmUtils.getServerTimeZone());
        ReportChart reportChart = null;
        try {
            User user = UserContextUtil.getUserContext().getLoggedInUser();
            String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
            String tenant = UserContextUtil.getUserContext().getLoggedInUser().getTenant();
            if (PropertyValidator.isValid((Object)param.get("sessionBoardId"))) {
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoard.$id").is((Object)new ObjectId(param.get("sessionBoardId"))));
                List ids = KendisUtils.getListAsObjectIds((String)user.getId());
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"users.$id").in((Collection)ids));
                query.with(new Sort(Sort.Direction.DESC, new String[]{"updatedOn"}));
                reportChart = (ReportChart)this.mongoTemplate.findOne(query, ReportChart.class);
                response.put("notification", reportChart);
            }
            if (PropertyValidator.isValid((Object)param.get("workSpaceId"))) {
                List ws_access = this.accessRoleRepository.findByWorkSpace(new WorkSpace(param.get("workSpaceId")));
                List company_users = this.nativeFindByUserCompanies_Company_IdAndUserCompanies_isArchive(cid, tenant, false, null);
                List users = KendisUtils.filterUsersByWorkSpace((String)cid, (List)company_users, (List)ws_access);
                List userVos = users.stream().map(dbUser -> {
                    UserVO userVO = new UserVO();
                    userVO.setId(dbUser.getId());
                    userVO.setFullName(dbUser.getFullName());
                    userVO.setAlmCredentials(dbUser.getAlmCredentials());
                    userVO.setIsActive(dbUser.getIsActive());
                    return userVO;
                }).collect(Collectors.toList());
                response.put("users", userVos);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/notification-save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveForNotication(@RequestBody ReportChart notification) {
        try {
            HashMap<String, ReportChart> response = new HashMap<String, ReportChart>();
            notification = (ReportChart)this.reportChartRepository.save((Object)notification);
            response.put("notification", notification);
            return new ResponseEntity(response, HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/notify"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> notifyReports(@RequestParam(name="testId") String testId) {
        try {
            String[] days = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
            Calendar cal = Calendar.getInstance();
            String day = days[cal.get(7) - 1];
            int hour = cal.get(11);
            LOGGER.debug("Running process Report..........................................current hour : " + day + " " + hour + "." + cal.get(12));
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            Date startDate = cal.getTime();
            SimpleDateFormat f = new SimpleDateFormat("dd-MMM-yyyy");
            String reportStart = f.format(startDate);
            cal.add(10, 144);
            Date endDate = cal.getTime();
            String reportEnd = f.format(endDate);
            Query query = new Query();
            if (PropertyValidator.isValid((Object)testId)) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(testId)));
            } else {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"day").is((Object)day));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"hourGMT").is((Object)hour));
            }
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"lastDate").gte((Object)sdf.parse(reportStart)));
            List reportCharts = this.mongoTemplate.find(query, ReportChart.class);
            HashMap<String, String> linksMap = new HashMap<String, String>();
            if (PropertyValidator.isValid((Collection)reportCharts)) {
                HashSet<String> uids = new HashSet<String>();
                ArrayList<User> users = new ArrayList<User>();
                LOGGER.info("..........................................repors to send : " + reportCharts.size());
                for (ReportChart reportChart : reportCharts) {
                    Company comp = reportChart.getCompany();
                    String baseUrl = this.getHttpScheme() + "://" + comp.getUrlPrefix() + "." + this.env.getProperty("server.domain");
                    if (this.env.getProperty("isLocalDeployment").equals("true")) {
                        baseUrl = UserContextUtil.getUserContext().getCurrentCompany().getUrl();
                    }
                    String rangeEnd = reportEnd;
                    String title = "Weekly Report";
                    if (reportChart.getSessionBoard().getSession() != null) {
                        if (reportChart.getSessionBoard().getSession().getEndDate() != null) {
                            rangeEnd = f.format(reportChart.getSessionBoard().getSession().getEndDate());
                        }
                        title = "Weekly Report</a> of <a target='_blank' href='" + baseUrl + "/session?id=" + reportChart.getSessionBoard().getId() + "' >" + reportChart.getSessionBoard().getSession().getTitle();
                    }
                    reportChart.setLink("<a href='" + baseUrl + "/charts?print=1&id=" + reportChart.getSessionBoard().getId() + "&start=" + reportStart + "&end=" + rangeEnd + "' target='_blank'>" + title + "</a>");
                    List sendTo = reportChart.getUsers();
                    if (!PropertyValidator.isValid((Collection)sendTo)) continue;
                    for (User user : sendTo) {
                        uids.add(user.getId());
                        if (linksMap.get(user.getId()) == null) {
                            linksMap.put(user.getId(), reportChart.getLink());
                        } else {
                            linksMap.put(user.getId(), "<br/>" + (String)linksMap.get(user.getId()));
                        }
                        users.add(user);
                    }
                }
                if (PropertyValidator.isValid(users)) {
                    for (User user : users) {
                        String links;
                        if (!PropertyValidator.isValid((Object)user.getEmail()) || (links = (String)linksMap.get(user.getId())) == null) continue;
                        HashMap<String, String> mailParam = new HashMap<String, String>();
                        mailParam.put("firstname", user.getFirstName());
                        mailParam.put("links", links);
                        this.mailSender.sendMail(user.getEmail(), "Weekly Report Notification", "weeklyReportTemplate", mailParam, true);
                    }
                }
            }
            return new ResponseEntity(linksMap, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    private void onReportChartsResponse(String syncId, String payloadKey, Object payload, Boolean responseCompleted) {
        try {
            if (syncId == null) {
                return;
            }
            String requestId = null;
            if (PropertyValidator.isValid((Object)syncId) && syncId.contains("#")) {
                String[] syncIdArray = syncId.split("#");
                syncId = syncIdArray[0];
                requestId = syncIdArray[1];
            }
            HashMap<String, Object> pushJson = new HashMap<String, Object>();
            pushJson.put("type", "Board");
            pushJson.put("push", "Self");
            pushJson.put("done", true);
            pushJson.put(payloadKey, payload);
            pushJson.put("metaMap", "{\"event\":\"ReportCharts\", \"syncId\":\"" + syncId + "\"}");
            ObjectMapper mapper = new ObjectMapper();
            if (!PropertyValidator.isValid((Object)requestId)) {
                PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
            } else {
                this.pushResponseRepository.save((Object)new PushResponse(requestId, mapper.writeValueAsString(pushJson), responseCompleted));
            }
        }
        catch (Exception e) {
            LOGGER.error("\n\n onReportChartsResponse : \n" + StringUtils.getTraceString((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serializeObjectDB(String syncId, Map map, String filePath) throws IOException {
        FileOutputStream fileStream = null;
        try {
            if (syncId == null) {
                String string = null;
                return string;
            }
            Files.deleteIfExists(Paths.get(this.env.getProperty("temp.file.location") + filePath, new String[0]));
            ObjectMapper mapper = new ObjectMapper();
            fileStream = new FileOutputStream(new File(this.env.getProperty("temp.file.location") + filePath));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileStream, "UTF-8");
            writer.write(mapper.writeValueAsString((Object)map));
            writer.close();
            String string = filePath;
            return string;
        }
        catch (IOException e) {
            LOGGER.error("\n\nserializeObject : \n" + StringUtils.getTraceString((Throwable)e));
        }
        finally {
            if (fileStream != null && PropertyValidator.isValid((Object)fileStream)) {
                fileStream.close();
            }
        }
        return null;
    }

    public String serializeObject(String syncId, Map map, String filePath) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        MongoSyncUtils.storeData((String)filePath, (String)mapper.writeValueAsString((Object)map), (AppConfig.MongoConfig)this.mongoConfig);
        return filePath;
    }

    @RequestMapping(value={"/read"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> readResponseFromDBFile(@RequestBody Map<String, String> filePathMap) {
        try {
            String filePath = filePathMap.get("filePath");
            return new ResponseEntity((Object)MongoSyncUtils.retrieveData((String)filePath, (AppConfig.MongoConfig)this.mongoConfig), HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("\nreadResponseFromDBFile : \n" + StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.OK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String serializeObject_OLD(String syncId, Map map, String filePath) throws IOException {
        FileOutputStream fileStream = null;
        try {
            if (syncId == null) {
                String string = null;
                return string;
            }
            Files.deleteIfExists(Paths.get(this.env.getProperty("temp.file.location") + filePath, new String[0]));
            ObjectMapper mapper = new ObjectMapper();
            fileStream = new FileOutputStream(new File(this.env.getProperty("temp.file.location") + filePath));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileStream, "UTF-8");
            writer.write(mapper.writeValueAsString((Object)map));
            writer.close();
            String string = filePath;
            return string;
        }
        catch (IOException e) {
            LOGGER.error("\n\nserializeObject : \n" + StringUtils.getTraceString((Throwable)e));
        }
        finally {
            if (fileStream != null && PropertyValidator.isValid((Object)fileStream)) {
                fileStream.close();
            }
        }
        return null;
    }

    @Deprecated
    @RequestMapping(value={"/read_OLD"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> readResponseFromFile(@RequestBody Map<String, String> filePathMap) {
        try {
            String filePath = filePathMap.get("filePath");
            File file = new File(this.env.getProperty("temp.file.location") + filePath);
            FileInputStream is = new FileInputStream(file);
            byte[] bits = new byte[(int)file.length()];
            is.read(bits);
            is.close();
            return new ResponseEntity((Object)new String(bits, "UTF-8"), HttpStatus.OK);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("\n\nreadResponseFromFile : \n" + StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)"ReadingFileBeforeCreate", HttpStatus.OK);
        }
        catch (IOException e) {
            LOGGER.error("\n\nreadResponseFromFile : \n" + StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.OK);
        }
    }

    @RequestMapping(value={"/log-details"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getLogDetails(@RequestBody List<String> logIds) {
        try {
            HashMap<String, Collection<Object>> data = new HashMap<String, Collection<Object>>();
            BasicDBObject matchQuery = new BasicDBObject("$match", (Object)new BasicDBObject().append("_id", (Object)new BasicDBObject("$in", (Object)KendisUtils.getListAsObjectIds(logIds))).append("tenant", (Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()).append("archive", (Object)false));
            Map itemLogMap = this.getItemLogsFromIds(matchQuery, null);
            data.put("logs", itemLogMap.values());
            data.put("logIds", logIds);
            return new ResponseEntity(data, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/pdf"}, method={RequestMethod.POST})
    public ResponseEntity<Object> generatePdfReport(@RequestParam(value="file") MultipartFile file, @RequestParam(value="fileName") String name, @RequestParam(value="width") String width, @RequestParam(value="height") String height) {
        try {
            Date now = new Date();
            String filePath = this.env.getProperty("temp.file.location") + "/" + now.getTime() + ".pdf";
            PDDocument doc = new PDDocument();
            ByteArrayInputStream bais = new ByteArrayInputStream(file.getBytes());
            BufferedImage bim = ImageIO.read(bais);
            PDImageXObject pdImage = LosslessFactory.createFromImage((PDDocument)doc, (BufferedImage)bim);
            PDRectangle rect = new PDRectangle(0.0f, 0.0f, Float.parseFloat(width), Float.parseFloat(height));
            PDPage page = new PDPage(rect);
            doc.addPage(page);
            PDPageContentStream contents = new PDPageContentStream(doc, page);
            contents.drawImage(pdImage, 0.0f, 0.0f, (float)pdImage.getWidth(), (float)pdImage.getHeight());
            contents.close();
            doc.save(filePath);
            doc.close();
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("srcPath", URLEncoder.encode(filePath, "UTF-8"));
            data.put("name", name + ".pdf");
            return new ResponseEntity(data, HttpStatus.OK);
        }
        catch (Exception e) {
            String exp = StringUtils.getTraceString((Throwable)e);
            LOGGER.error(exp);
            return new ResponseEntity((Object)exp, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/solution-analytics"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> retrieveSolutionAnalytics(@RequestBody Map<String, Object> request) {
        try {
            boolean exists;
            String syncId = (String)request.get("syncId");
            String filePath = "solution-analytics=" + UserContextUtil.getUserContext().getCurrentCompany().getTenant() + "_" + request.get("solutionId") + ".ser";
            if (PropertyValidator.isValid((Object)request.get("refreshData"))) {
                MongoSyncUtils.removeData((String)filePath, (AppConfig.MongoConfig)this.mongoConfig);
            }
            if (exists = MongoSyncUtils.isDataFound((String)filePath, (AppConfig.MongoConfig)this.mongoConfig)) {
                this.onReportChartsResponse(syncId, "filePath", (Object)filePath, Boolean.valueOf(true));
                return new ResponseEntity(null, HttpStatus.OK);
            }
            HashMap response = this.calulateSolutionAnalytics(request);
            response.put("reportDate", new Date());
            this.onReportChartsResponse(syncId, "filePath", (Object)this.serializeObject(syncId, (Map)response, filePath), Boolean.valueOf(true));
        }
        catch (Exception e) {
            HashMap<String, Exception> err = new HashMap<String, Exception>();
            err.put("exception", e);
            this.onReportChartsResponse((String)request.get("syncId"), "error", err, Boolean.valueOf(true));
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(null, HttpStatus.OK);
    }

    public HashMap<String, Object> calulateSolutionAnalytics(@RequestBody Map<String, Object> request) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        HashMap scopChanges = new HashMap();
        HashMap dataByBoardId = new HashMap();
        try {
            List worflowsIds = (List)request.get("worflowsIds");
            List activeSessionBoardIds = (List)request.get("activeSessionBoardIds");
            Map boardByBoardId = (Map)request.get("boardByBoardId");
            Map stateSeqByRefId = (Map)request.get("stateByBoardId");
            Map sprintIndex = (Map)request.get("sprintIndex");
            ArrayList<ObjectId> lastSessionBoardObjectIds = new ArrayList<ObjectId>();
            List activeSessionBoardObjectIds = KendisUtils.getListAsObjectIds((Collection)activeSessionBoardIds);
            responseJson.put("stats", dataByBoardId);
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"sequence").in(stateSeqByRefId.values()));
            DBCursor dbCursorPrefix = this.mongoTemplate.getCollection("state").find(query.getQueryObject());
            List states = dbCursorPrefix.toArray();
            ArrayList<ObjectId> stateIds = new ArrayList<ObjectId>();
            for (Object dbo : states) {
                String id = String.valueOf(dbo.get("_id"));
                stateIds.add(new ObjectId(id));
                stateSeqByRefId.put("state_" + id, (Integer)dbo.get("sequence"));
            }
            query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"parentBoard").in((Collection)activeSessionBoardIds));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").nin((Collection)KendisUtils.getListAsObjectIds((Collection)activeSessionBoardIds)));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"state.$id").in(stateIds));
            dbCursorPrefix = this.mongoTemplate.getCollection("sessionBoard").find(query.getQueryObject());
            List allBoards = dbCursorPrefix.toArray();
            for (DBObject board : allBoards) {
                String boardId = String.valueOf(board.get("_id"));
                DBRef ref = (DBRef)board.get("session");
                String sessionId = String.valueOf(ref.getId());
                ref = (DBRef)board.get("state");
                if (Boolean.TRUE.equals(board.get("createWithNewStateChangeLogic"))) {
                    boardByBoardId.put("reverse_" + boardId, "true");
                }
                Integer val1 = (Integer)stateSeqByRefId.get(sessionId);
                Integer val2 = (Integer)stateSeqByRefId.get("state_" + ref.getId());
                if (val1 == null || val2 == null || !val1.equals(val2)) continue;
                lastSessionBoardObjectIds.add(new ObjectId(boardId));
                boardByBoardId.put(boardId, (String)board.get("parentBoard"));
                List sprints = (List)board.get("containers");
                if (!PropertyValidator.isValid((Collection)sprints)) continue;
                for (int i = 0; i < sprints.size(); ++i) {
                    sprintIndex.put(boardId + "_" + String.valueOf(((DBRef)sprints.get(i)).getId()), i);
                    sprintIndex.put((String)boardByBoardId.get(boardId) + "_" + String.valueOf(((DBRef)sprints.get(i)).getId()), i);
                }
            }
            HashMap statusMapById = new HashMap();
            HashMap mappedTc = new HashMap();
            HashMap nextStateIds = new HashMap();
            HashMap nextStateIdsRemoved = new HashMap();
            HashMap validParent = new HashMap();
            List oldItems = this.getItemsForDIfferentBoards(lastSessionBoardObjectIds, validParent, statusMapById, mappedTc, null, nextStateIdsRemoved);
            List rawItems = this.getItemsForDIfferentBoards(activeSessionBoardObjectIds, validParent, statusMapById, mappedTc, nextStateIds, nextStateIdsRemoved);
            this.breakDownItems(false, oldItems, dataByBoardId, sprintIndex, boardByBoardId, validParent, statusMapById, mappedTc, nextStateIds, nextStateIdsRemoved);
            this.breakDownItems(true, rawItems, dataByBoardId, sprintIndex, boardByBoardId, validParent, statusMapById, mappedTc, null, null);
            responseJson.put("capacities", this.getTeamCapacity(activeSessionBoardIds));
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return responseJson;
    }

    private Map getEmptyMap(Object initValue) {
        if (initValue == null) {
            HashMap map = new HashMap();
            map.put(EnumStatusCategory.OPEN.getCode(), new HashSet());
            map.put(EnumStatusCategory.INPROGRESS.getCode(), new HashSet());
            map.put(EnumStatusCategory.DONE.getCode(), new HashSet());
            map.put(EnumStatusCategory.MISC.getCode(), new HashSet());
            return map;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(EnumStatusCategory.OPEN.getCode(), initValue);
        map.put(EnumStatusCategory.INPROGRESS.getCode(), initValue);
        map.put(EnumStatusCategory.DONE.getCode(), initValue);
        map.put(EnumStatusCategory.MISC.getCode(), initValue);
        return map;
    }

    private List<User> nativeFindByUserCompanies_Company_IdAndUserCompanies_isArchive(String companyId, String tenant, boolean isArchive, String[] fields) {
        if (!PropertyValidator.isValid((Object)companyId)) {
            return Collections.emptyList();
        }
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject().append("userCompanies.company.$id", (Object)new ObjectId(companyId)).append("tenant", (Object)tenant).append("archive", (Object)false).append("userCompanies.isArchive", (Object)isArchive));
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("fullName", (Object)1).append("userCompanies.company", (Object)1).append("userCompanies.isAdmin", (Object)1).append("almCredentials.almAccId", (Object)1).append("almCredentials.almUsername", (Object)1).append("isAdmin", (Object)1).append("groups", (Object)1));
        List<DBObject> pipeline = Arrays.asList(matchStage, projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(User.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        LinkedList<User> users = new LinkedList<User>();
        try (Cursor dbCursor = collection.aggregate(pipeline, aggregationOptions);){
            while (dbCursor.hasNext()) {
                BasicDBObject dbObject = (BasicDBObject)dbCursor.next();
                User user = new User();
                user.setId(DBUtils.getIdFromDBObject((BasicDBObject)dbObject, (String[])new String[0]));
                user.setFullName(dbObject.getString("fullName"));
                user.setIsAdmin(Boolean.valueOf(dbObject.getBoolean("isAdmin")));
                if (PropertyValidator.isValid((Object)dbObject.get("userCompanies"))) {
                    BasicDBList userCompaniesDbList = (BasicDBList)dbObject.get("userCompanies");
                    LinkedList userCompanies = new LinkedList();
                    userCompaniesDbList.forEach(userCompObj -> {
                        UserCompany userCompany = new UserCompany();
                        BasicDBObject userCompanyDbObject = (BasicDBObject)userCompObj;
                        DBRef companyRef = (DBRef)userCompanyDbObject.get("company");
                        Company company = new Company();
                        company.setId(companyRef.getId().toString());
                        userCompany.setCompany(company);
                        userCompany.setIsAdmin(Boolean.valueOf(userCompanyDbObject.getBoolean("isAdmin")));
                        userCompanies.add(userCompany);
                    });
                    user.setUserCompanies(userCompanies);
                }
                if (PropertyValidator.isValid((Object)dbObject.get("almCredentials"))) {
                    BasicDBList almCredentialsDbList = (BasicDBList)dbObject.get("almCredentials");
                    LinkedList almCredentials = new LinkedList();
                    almCredentialsDbList.forEach(almAccObj -> {
                        BasicDBObject almAccDbObject = (BasicDBObject)almAccObj;
                        AlmAccUser almAccUser = new AlmAccUser();
                        almAccUser.setAlmUsername(almAccDbObject.getString("almUsername"));
                        almAccUser.setAlmAccId(almAccDbObject.getString("almAccId"));
                        almCredentials.add(almAccUser);
                    });
                    user.setAlmCredentials(almCredentials);
                }
                if (PropertyValidator.isValid((Object)dbObject.get("groups"))) {
                    List groupsList = (List)dbObject.get("groups");
                    user.setGroups(new HashSet(groupsList));
                }
                users.add(user);
            }
        }
        return users;
    }

    private Map getEmptyMapOfIntArray() {
        HashMap map = new HashMap();
        map.put(EnumStatusCategory.OPEN.getCode(), new ArrayList());
        map.put(EnumStatusCategory.INPROGRESS.getCode(), new ArrayList());
        map.put(EnumStatusCategory.DONE.getCode(), new ArrayList());
        map.put(EnumStatusCategory.MISC.getCode(), new ArrayList());
        return map;
    }

    private HashMap<String, Object> breakDownItems(boolean isActiveData, List<DBObject> rawItems, HashMap<String, Object> dataByBoardId, Map<String, Integer> sprintIndex, Map<String, String> boardByBoardId, Map<String, Boolean> validParent, Map<String, Status> statusMapById, Map<String, TeamContainer> mappedTc, Map<String, String> nextStateIds, Map<String, String> nextStateIdsRemoved) {
        for (DBObject dbo : rawItems) {
            boolean reverse = false;
            List itemSessionBoard = (List)dbo.get("sessionBoards");
            String itemBoardId = String.valueOf(((DBRef)itemSessionBoard.get(0)).getId());
            String activeBoardId = boardByBoardId.get(itemBoardId);
            String itemId = String.valueOf(dbo.get("_id"));
            String itemType = (String)dbo.get("type");
            DBRef statusRef = (DBRef)dbo.get("status");
            TeamContainer tc = this.getLastSprint((List)dbo.get("teamContainers"), itemType, mappedTc, sprintIndex, activeBoardId);
            String nextStateId = (String)dbo.get("nextStateId");
            String activeSprintId = "1";
            String nextSprintId = "1";
            if (tc != null && tc.getContainer() != null && tc.getContainer().getId() != null) {
                activeSprintId = tc.getContainer().getId();
                nextSprintId = tc.getContainer().getNextStateId();
            }
            boolean unplanned = "1".equals(activeSprintId);
            String nxtTC = null;
            boolean skipScopeChange = false;
            if (nextStateId == null && nextStateIds != null) {
                if (nextStateIds.get(itemId) != null) {
                    nextStateId = nextStateIds.get(itemId);
                    if (!unplanned) {
                        nxtTC = nextStateIds.get(activeSprintId);
                    }
                    reverse = true;
                }
                if (nextStateIdsRemoved.get(itemId) != null) {
                    skipScopeChange = true;
                }
            } else if (nextStateId != null && nextStateIdsRemoved != null && nextStateIdsRemoved.get(nextStateId) != null) {
                skipScopeChange = true;
            }
            Double points = null;
            HashMap<String, Object> data = null;
            Status status = null;
            Map temp = null;
            String key = "";
            if (Item.Type.UserStory.name().equals(itemType)) {
                points = (Double)dbo.get("storyPoints");
                DBRef parent = (DBRef)dbo.get("parent");
                if (PropertyValidator.isValid((Object)parent) && PropertyValidator.isValid((Object)parent.getId()) && validParent.get(String.valueOf(parent.getId())) == null) continue;
            }
            if (PropertyValidator.isValid((Object)statusRef)) {
                String statusId = String.valueOf(statusRef.getId());
                status = statusMapById.get(statusId);
            }
            if (!PropertyValidator.isValid(status)) continue;
            if (dbo.containsField("jiraId")) {
                key = "_" + (String)dbo.get("jiraKey");
            } else if (dbo.containsField("tfsId")) {
                key = "_" + (String)dbo.get("tfsId");
            }
            data = (HashMap<String, Object>)dataByBoardId.get(activeBoardId);
            if (data == null) {
                data = new HashMap<String, Object>();
                data.put(Item.Type.Feature.name(), this.getEmptyMap(null));
                data.put(Item.Type.Feature.name() + "_planned", this.getEmptyMap(null));
                data.put(Item.Type.Feature.name() + "_added", new HashMap());
                data.put(Item.Type.Feature.name() + "_removed", new HashMap());
                data.put(Item.Type.Feature.name() + "_changed", new HashMap());
                data.put(Item.Type.Feature.name() + "_back", new HashMap());
                data.put(Item.Type.Feature.name() + "_total", 0);
                data.put(Item.Type.Feature.name() + "_ptotal", 0);
                data.put(Item.Type.UserStory.name(), this.getEmptyMap(null));
                data.put(Item.Type.UserStory.name() + "_planned", this.getEmptyMap(null));
                data.put(Item.Type.UserStory.name() + "_added", new HashMap());
                data.put(Item.Type.UserStory.name() + "_removed", new HashMap());
                data.put(Item.Type.UserStory.name() + "_changed", new HashMap());
                data.put(Item.Type.UserStory.name() + "_back", new HashMap());
                data.put(Item.Type.UserStory.name() + "_total", 0);
                data.put(Item.Type.UserStory.name() + "_ptotal", 0);
                data.put("storyPoints", this.getEmptyMap((Object)0.0));
                data.put("storyPoints_planned", this.getEmptyMap((Object)0.0));
                data.put("storyPoints_added", new HashMap());
                data.put("storyPoints_total", 0.0);
                dataByBoardId.put(activeBoardId, data);
            }
            if (isActiveData) {
                String _key;
                temp = (Map)data.get(itemType);
                ((Set)temp.get(status.getCategory())).add(itemId);
                if (points != null) {
                    temp = (Map)data.get("storyPoints");
                    temp.put(status.getCategory(), (Double)temp.get(status.getCategory()) + points);
                }
                if (!unplanned) {
                    temp = (Map)data.get(itemType + "_planned");
                    ((Set)temp.get(status.getCategory())).add(itemId);
                    if (points != null) {
                        temp = (Map)data.get("storyPoints_planned");
                        temp.put(status.getCategory(), (Double)temp.get(status.getCategory()) + points);
                    }
                }
                temp = (Map)data.get(itemType + "_removed");
                String string = _key = key.equals("") ? itemId : "-1" + key;
                if (temp.get(_key) == null) {
                    temp = (Map)data.get(itemType + "_added");
                    temp.put(_key, itemId);
                } else {
                    temp.remove(_key);
                }
                if (points != null && points > 0.0) {
                    temp = (Map)data.get("storyPoints_added");
                    if (temp.get(_key) != null) {
                        if (temp.get(_key).equals(points) || temp.get(_key).equals(-points.doubleValue())) {
                            temp.remove(_key);
                        } else {
                            temp.put(_key, (Double)temp.get(_key) + points);
                        }
                    } else {
                        temp.put(_key, points);
                    }
                    data.put("storyPoints_total", (Double)data.get("storyPoints_total") + points);
                }
                data.put(itemType + "_total", (Integer)data.get(itemType + "_total") + 1);
            } else {
                temp = (Map)data.get(itemType + "_removed");
                if (key.equals("")) {
                    temp.put(nextStateId == null ? itemId : nextStateId, itemId);
                } else {
                    temp.put("-1" + key, itemId);
                }
                if (points != null && points > 0.0 && !skipScopeChange) {
                    temp = (Map)data.get("storyPoints_added");
                    if (key.equals("")) {
                        temp.put(nextStateId == null ? itemId : nextStateId, -points.doubleValue());
                    } else {
                        temp.put("-1" + key, -points.doubleValue());
                    }
                }
            }
            if (isActiveData) {
                Object val;
                if (!unplanned) {
                    if (data.get(itemType + "_" + activeSprintId) == null) {
                        data.put(itemType + "_" + activeSprintId, this.getEmptyMap(null));
                        if (points != null) {
                            data.put("storyPoints_" + activeSprintId, this.getEmptyMap((Object)0.0));
                        }
                    }
                    temp = (Map)data.get(itemType + "_" + activeSprintId);
                    ((Set)temp.get(status.getCategory())).add(itemId);
                    if (points != null) {
                        temp = (Map)data.get("storyPoints_" + activeSprintId);
                        if (temp == null) {
                            temp = this.getEmptyMap((Object)0.0);
                            data.put("storyPoints_" + activeSprintId, temp);
                        }
                        temp.put(status.getCategory(), (Double)temp.get(status.getCategory()) + points);
                    }
                }
                if ((val = (temp = (Map)data.get(itemType + "_changed")).remove(itemId + key + "_" + activeSprintId)) == null) continue;
                data.put(itemType + "_ptotal", (Integer)data.get(itemType + "_ptotal") + 1);
                continue;
            }
            if (nextStateId == null || skipScopeChange) continue;
            temp = (Map)data.get(itemType + "_changed");
            if (reverse) {
                temp.put(nextStateId + key + "_" + (nxtTC == null ? "1" : nxtTC), nextStateId);
                continue;
            }
            temp.put(nextStateId + key + "_" + nextSprintId, nextStateId);
        }
        return dataByBoardId;
    }

    private TeamContainer getLastSprint(List<DBRef> tcs, String itemType, Map<String, TeamContainer> mappedTc, Map<String, Integer> sprintIndex, String activeBoardId) {
        TeamContainer tc = null;
        if (PropertyValidator.isValid(tcs)) {
            int size = tcs.size();
            if (Item.Type.UserStory.name().equals(itemType)) {
                size = 1;
            } else if (Item.Type.Feature.name().equals(itemType)) {
                size = tcs.size();
            }
            Integer phoenix = -1;
            for (int i = 0; i < size; ++i) {
                TeamContainer val = mappedTc.get(String.valueOf(tcs.get(i).getId()));
                if (val == null || val.getContainer() == null || val.getContainer().getId() == null) continue;
                if (Item.Type.UserStory.name().equals(itemType)) {
                    tc = val;
                    break;
                }
                Integer seq = sprintIndex.get(activeBoardId + "_" + val.getContainer().getId());
                if (seq == null || seq <= phoenix || phoenix >= tcs.size()) continue;
                phoenix = seq;
                tc = val;
            }
        }
        return tc;
    }
}

