/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.jira.bo.JiraFilter;
import com.viztrend.safe.api.dto.RTFetchServiceRequestDTO;
import com.viztrend.safe.api.dto.RTItemsOperationsDTO;
import com.viztrend.safe.controller.ReleaseTrainController;
import com.viztrend.safe.dto.BacklogItemChildrenCountsRequestDTO;
import com.viztrend.safe.dto.BacklogItemChildrenCountsResponseDTO;
import com.viztrend.safe.exception.KendisException;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.BacklogHierarchy;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.Board;
import com.viztrend.safe.persistence.entity.Criteria;
import com.viztrend.safe.persistence.entity.FilterCriteria;
import com.viztrend.safe.persistence.entity.GroupConfig;
import com.viztrend.safe.persistence.entity.Lane;
import com.viztrend.safe.persistence.entity.PiSite;
import com.viztrend.safe.persistence.entity.PushResponse;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.WorkSpaceType;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.BacklogItemRepository;
import com.viztrend.safe.persistence.repository.BoardRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.service.AttachmentService;
import com.viztrend.safe.service.BatchesCalculationService;
import com.viztrend.safe.service.CustomFieldService;
import com.viztrend.safe.service.MilestoneCalculationService;
import com.viztrend.safe.service.RTItemFetchService;
import com.viztrend.safe.service.RTItemOperationsService;
import com.viztrend.safe.service.ReleaseTrainService;
import com.viztrend.safe.service.RoadmapSectionService;
import com.viztrend.safe.utils.JsonUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.Attachment;
import com.viztrend.safe.vos.ResyncParamsVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RequestMapping(value={"/releasetrain"})
@RestController
public class ReleaseTrainController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReleaseTrainController.class);
    @Autowired
    private ReleaseTrainService releaseTrainService;
    @Autowired
    private RTItemOperationsService itemOperationsService;
    @Autowired
    private BoardRepository boardRepository;
    @Autowired
    private RTItemFetchService itemFetchService;
    @Autowired
    private PushResponseRepository pushResponseRepository;
    @Autowired
    private BacklogItemRepository backlogItemRepository;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private CustomRepositoryImpl customRepositoryImpl;
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private MilestoneCalculationService milestoneCalculationService;
    @Autowired
    private RoadmapSectionService roadmapSectionService;
    @Autowired
    private BatchesCalculationService batchesCalculationService;
    @Autowired
    MongoTemplate mongoTemplate;
    private final ConcurrentHashMap<String, Boolean> exportCancelFlag = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/multi-arts-backlog"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getMultiReleaseTrainBacklogItems(@RequestBody String request) {
        ResponseEntity responseEntity;
        Gson g = new Gson();
        Map responseJson = null;
        String requestId = null;
        try {
            1 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(request, T.getType());
            List artIds = (List)requestBody.get("artIds");
            requestId = (String)requestBody.get("requestId");
            Map requests = (Map)requestBody.get("requests");
            if (artIds == null || artIds.isEmpty()) {
                throw new KendisException("No ARTs found");
            }
            if (requestId == null || requestId.isEmpty()) {
                throw new KendisException("No Request Id found");
            }
            if (requests == null || requests.isEmpty()) {
                throw new KendisException("No Requests found");
            }
            for (String artId : artIds) {
                Date start = new Date();
                LOGGER.info("==================== < artId: " + artId + " >===================");
                LOGGER.info("==================================================");
                LOGGER.info("             Start at : " + start.getTime());
                LOGGER.info("==================================================");
                responseJson = this.itemFetchService.getBacklogItemsWithLevel(artId, (Map)requests.get(artId));
                JsonUtils.removeClassKey((Map)responseJson, (String)"_class");
                JsonUtils.removeClassKey((Map)responseJson, (String)"fetchedBy");
                responseJson.put("artId", artId);
                this.pushResponseRepository.save((Object)new PushResponse(requestId, (Object)responseJson, Boolean.valueOf(false)));
                Date end = new Date();
                LOGGER.info("==================================================");
                LOGGER.info("\t\t\t\tEnd at : " + (end.getTime() - start.getTime()));
                LOGGER.info("==================================================");
            }
            responseJson.put("completed", true);
            this.pushResponseRepository.save((Object)new PushResponse(requestId, (Object)responseJson, Boolean.valueOf(true)));
            responseEntity = new ResponseEntity((Object)responseJson, HttpStatus.OK);
            responseJson.put("completed", true);
        }
        catch (Exception e) {
            ResponseEntity responseEntity2;
            try {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
                responseEntity2 = new ResponseEntity(null, HttpStatus.BAD_REQUEST);
                responseJson.put("completed", true);
            }
            catch (Throwable throwable) {
                responseJson.put("completed", true);
                this.pushResponseRepository.save((Object)new PushResponse(requestId, (Object)responseJson, Boolean.valueOf(true)));
                throw throwable;
            }
            this.pushResponseRepository.save((Object)new PushResponse(requestId, (Object)responseJson, Boolean.valueOf(true)));
            return responseEntity2;
        }
        this.pushResponseRepository.save((Object)new PushResponse(requestId, (Object)responseJson, Boolean.valueOf(true)));
        return responseEntity;
    }

    @RequestMapping(value={"/otherCollectionBoards"}, method={RequestMethod.POST})
    public ResponseEntity<Object> otherCollectionBoards(@RequestBody Map<String, Object> request) {
        Map result = null;
        try {
            result = this.releaseTrainService.otherCollectionBoards(request);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @RequestMapping(value={"/archive/board/{id}"}, method={RequestMethod.POST})
    public ResponseEntity<Object> archiveBoard(@PathVariable(value="id") String id, @RequestBody Map<String, Object> request) {
        Map result = null;
        boolean isArchive = false;
        try {
            isArchive = (Boolean)request.get("archiveFlag");
            result = this.releaseTrainService.archiveOrUnarchiveBoard(id, isArchive);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}/attachment/get"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getAboutARTAttachment(@PathVariable(value="id") String id) {
        List retrievedAttachments = null;
        try {
            HashMap<String, Object> responseJson = new HashMap<String, Object>();
            String workspaceId = id;
            retrievedAttachments = this.attachmentService.getAttachments(workspaceId);
            if (retrievedAttachments != null) {
                retrievedAttachments = this.attachmentService.fetchAttachmentData(retrievedAttachments);
                responseJson.put("isSuccess", true);
                responseJson.put("retrievedAttachments", retrievedAttachments);
            } else {
                responseJson.put("isSuccess", false);
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/attachment/remove"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> removeAboutARTAttachments(@RequestBody Map<String, Object> request) {
        boolean isRemoveSuccess = false;
        long deleteCount = 0L;
        try {
            HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
            Map images = (Map)request.get("attachmentsToRemove");
            String workspaceId = (String)request.get("id");
            if (((Boolean)request.get("isImage")).booleanValue()) {
                deleteCount = this.attachmentService.removeAttachmentasImage(images);
            }
            if (deleteCount > 0L) {
                this.attachmentService.removeAttachmentfromWorkspace(workspaceId, (String)images.get("id"), (String)images.get("referenceKey"));
            }
            isRemoveSuccess = this.attachmentService.removeAttachmentData((String)images.get("referenceKey"));
            responseJson.put("isRemoveSuccess", isRemoveSuccess);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/attachment/save-sequence"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveSequenceAboutARTAttachments(@RequestBody Map<String, Object> request) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)request.get("sequences")) || !PropertyValidator.isValid((Object)request.get("workspaceId"))) {
            responseJson.put("success", false);
            responseJson.put("message", "Invalid data");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        List sequences = (List)request.get("sequences");
        String workSpaceId = (String)request.get("workspaceId");
        boolean result = this.attachmentService.saveAttachmentSequences(sequences, workSpaceId);
        responseJson.put("success", result);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/attachment/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveAboutARTAttachments(@RequestBody Map<String, Object> request) {
        boolean isWriteSuccess = true;
        ArrayList<String> successAttachmentIds = new ArrayList<String>();
        String writtenAttachmentId = null;
        List savedAttachments = null;
        try {
            HashMap<String, Object> responseJson = new HashMap<String, Object>();
            List images = (List)request.get("images");
            List retrievedImages = null;
            String id = (String)request.get("id");
            if (((Boolean)request.get("isImage")).booleanValue()) {
                savedAttachments = this.attachmentService.saveAttachmentasImage(images);
            }
            isWriteSuccess = this.attachmentService.addAttachmentstoWorkspace(savedAttachments, id);
            for (int i = 0; i < savedAttachments.size() && isWriteSuccess; ++i) {
                writtenAttachmentId = this.attachmentService.writeAttachmentData((Attachment)savedAttachments.get(i));
                if (!PropertyValidator.isValid((Object)writtenAttachmentId) || !writtenAttachmentId.equals(((Attachment)savedAttachments.get(i)).getId())) continue;
                successAttachmentIds.add(writtenAttachmentId);
            }
            retrievedImages = this.attachmentService.getAttachments(id);
            retrievedImages = this.attachmentService.fetchAttachmentData(retrievedImages);
            responseJson.put("successAttachmentIds", successAttachmentIds);
            responseJson.put("isWriteSuccess", isWriteSuccess);
            responseJson.put("retrievedImages", retrievedImages);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/{id}/description"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getAboutReleaseTrainDescription(@PathVariable(value="id") String id) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.getAboutReleaseTrainDescription(id);
            if (responseJson.get("workspaceType") != null) {
                WorkSpaceType wstype = (WorkSpaceType)responseJson.get("workspaceType");
                responseJson.put("icon", wstype.getIcon());
            }
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/{id}/description/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveAboutReleaseTrainDescription(@RequestBody Map<String, Object> request, @PathVariable String id) {
        try {
            Map responseJson = null;
            Gson g = new Gson();
            2 T = new /* Unavailable Anonymous Inner Class!! */;
            String description = (String)request.get("description");
            responseJson = this.releaseTrainService.saveAboutReleaseTrainDescription(id, description);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/{id}/batchListView"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getWorkspaceBatches(@PathVariable(value="id") String workspaceId) {
        try {
            HashMap<String, List> responseJson = new HashMap<String, List>();
            List batchesList = this.releaseTrainService.getBatchList(workspaceId);
            responseJson.put("batchList", batchesList);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/check-lock/{id}/{almId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getReleaseTrainPiBoards(@PathVariable(value="id") String id, @PathVariable(value="almId") String almId) {
        try {
            return new ResponseEntity((Object)this.customRepositoryImpl.isLockedObjectFound(id + "_" + almId, "Backlog sync", Long.valueOf(600000L)), HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getReleaseTrain(@RequestBody Map<String, Object> request) {
        try {
            Map responseJson = null;
            String id = (String)request.get("id");
            responseJson = this.releaseTrainService.getReleaseTrain(id);
            WorkSpace releaseTrain = (WorkSpace)responseJson.get("releaseTrain");
            if (releaseTrain != null) {
                this.sendLazyBoards(releaseTrain.getId(), releaseTrain.getWorkflow() == null ? null : releaseTrain.getWorkflow().getId(), responseJson, request);
            }
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @GetMapping(value={"/fetch-projects-for-collection"})
    public ResponseEntity<?> fetchProjectsForCollection(@RequestParam(value="collectionKey") String collectionKey, @RequestParam(value="almAccountId") String almAccountId, @RequestParam(value="almAccountType") String almAccountType) {
        try {
            Map responseJson = this.releaseTrainService.getWorkSpaceProjects(collectionKey, almAccountId, almAccountType);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/{id}/backlog/ids"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getReleaseTrainBacklogItemsIds(@PathVariable(value="id") String id, @RequestBody String request) {
        try {
            Gson g = new Gson();
            3 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(request, T.getType());
            Map responseJson = null;
            Date start = new Date();
            LOGGER.info("==================================================");
            LOGGER.info("             Start at : " + start.getTime());
            LOGGER.info("==================================================");
            responseJson = this.itemFetchService.getBacklogItemsIdsWithLevel(id, requestBody);
            Date end = new Date();
            LOGGER.info("==================================================");
            LOGGER.info("\t\t\t\tEnd at : " + (end.getTime() - start.getTime()));
            LOGGER.info("==================================================");
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/backlog-groups-stream"})
    public ResponseEntity<StreamingResponseBody> streamReleaseTrainBacklogGroupedItems(@RequestBody RTFetchServiceRequestDTO request) {
        StreamingResponseBody responseBody;
        LOGGER.info("==================== Streaming Grouped Items Started ===================");
        try {
            responseBody = outputStream -> {
                try {
                    this.itemFetchService.streamBacklogItemsGrouped(request, outputStream);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body((Object)responseBody);
    }

    @RequestMapping(value={"/item/details"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getItemDetails(@RequestBody String request) {
        try {
            Gson g = new Gson();
            4 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(request, T.getType());
            Map responseJson = null;
            responseJson = this.releaseTrainService.fetchBacklogItemByKey(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/backlog-item/link-item"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> linkBacklogItemWithItems(@RequestBody String payload) {
        Map responseJson = null;
        try {
            Gson g = new Gson();
            5 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            responseJson = this.itemOperationsService.linkItemsWithBacklogItem(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/backlog-item/unlink-item"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> unlinkBacklogItemWithItems(@RequestBody String payload) {
        Map responseJson = null;
        try {
            Gson g = new Gson();
            6 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            responseJson = this.itemOperationsService.unlinkItemsWithBacklogItem(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/backlog-item/relation"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> createBacklogItemRelation(@RequestBody String payload) {
        Map responseJson = null;
        try {
            Gson g = new Gson();
            7 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            responseJson = this.itemOperationsService.createBacklogItemRelation(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/backlog-item/completion"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> calculateMilestoneCompletion(@RequestBody String payload) {
        HashMap responseJson = new HashMap();
        try {
            Gson g = new Gson();
            8 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Callable<Void> task = () -> {
                try {
                    String syncId = (String)requestBody.get("syncId");
                    Map result = this.milestoneCalculationService.calculateMilestoneCompletion(requestBody);
                    this.onBackgroundTaskCompleted(result, syncId, "CompletionCalculationCompleted");
                }
                catch (Exception e) {
                    LOGGER.error("Error in background task: ", (Throwable)e);
                }
                return null;
            };
            Future<Void> future = executorService.submit(task);
            executorService.shutdown();
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/backlog-item/remove-relation"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> removeBacklogItemRelation(@RequestBody String payload) {
        Map responseJson = null;
        try {
            Gson g = new Gson();
            9 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            responseJson = this.itemOperationsService.removeBacklogItemRelation(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/backlog-item/fetch-relations"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchBacklogItemRelation(@RequestBody String payload) {
        Map responseJson = null;
        try {
            Gson g = new Gson();
            10 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            responseJson = this.itemOperationsService.fetchBacklogItemRelation(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/fetch-release-train-hierarchies-and-filters"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getReleaseTrainItemHierarchy(@RequestBody HashMap<String, Object> requestBody) {
        Map<String, Exception> responseJson = new HashMap<String, Exception>();
        try {
            LOGGER.debug("*****getReleaseTrainItemHierarchy**** -----> START");
            responseJson = this.releaseTrainService.getReleaseTrainItemHierarchy(requestBody);
            LOGGER.debug("*****getReleaseTrainItemHierarchy**** ----->  END");
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            responseJson.put("Error", e);
            LOGGER.error("*****getReleaseTrainItemHierarchy**** -----> Exception Occurred. ---------------" + StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/save-backlog-item-settings"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveBackLogItemDefaultSettings(@RequestBody HashMap<String, Object> requestBody) {
        HashMap responseJson = new HashMap();
        try {
            LOGGER.debug("*****saveBackLogItemColumns**** -----> START");
            responseJson = this.releaseTrainService.saveBackLogItemDefaultSettings(requestBody);
            LOGGER.debug("*****saveBackLogItemColumns**** ----->  END");
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            responseJson.put("Error occurred at server side: ", e);
            LOGGER.error("*****saveBackLogItemColumns**** -----> Exception Occurred. ---------------" + StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/fetch-backlog-items-settings"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchBacklogItemsSettings(@RequestBody Map<String, String> requestBody) {
        Map<String, Exception> responseJson = new HashMap<String, Exception>();
        try {
            LOGGER.debug("*****fetchBacklogItemsColumns**** -----> START");
            responseJson = this.releaseTrainService.fetchBacklogItemsSettings(requestBody);
            LOGGER.debug("*****fetchBacklogItemsColumns**** ----->  END");
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            responseJson.put("Error", e);
            LOGGER.error("*****fetchBacklogItemsColumns**** -----> Exception Occurred. ---------------" + StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/fetch-filters-by-hierarchy-level/{releaseTrainId}/{hierarchyLevel}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> fetchFiltersByHierarchyLevel(@PathVariable(value="releaseTrainId") String releaseTrainId, @PathVariable(value="hierarchyLevel") Integer hierarchyLevel) {
        Map<String, Exception> responseJson = new HashMap<String, Exception>();
        try {
            LOGGER.debug("*****fetchFiltersByHierarchyLevel**** -----> START");
            responseJson = this.releaseTrainService.fetchFiltersByHierarchyLevel(releaseTrainId, hierarchyLevel);
            LOGGER.debug("*****fetchFiltersByHierarchyLevel**** ----->  END");
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            responseJson.put("Error", e);
            LOGGER.error("*****fetchFiltersByHierarchyLevel**** -----> Exception Occurred. ---------------" + StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/item-bread-crumbs/{releaseTrainId}/{itemId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getItemBreadCrumbs(@PathVariable(value="releaseTrainId") String releaseTrainId, @PathVariable(value="itemId") String itemId) {
        Map<String, Exception> responseJson = new HashMap<String, Exception>();
        try {
            LOGGER.debug("*****getItemBreadCrumbs**** -----> START");
            responseJson = this.releaseTrainService.getItemBreadCrumbs(releaseTrainId, itemId);
            LOGGER.debug("*****getItemBreadCrumbs**** ----->  END");
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            responseJson.put("Error", e);
            LOGGER.error("*****getItemBreadCrumbs**** -----> Exception Occurred. ---------------" + StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/{id}/piboards"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getReleaseTrainPiBoards(@PathVariable(value="id") String id) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.getReleaseTrainPiBoards(id);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/{id}/solutionBoards"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getReleaseSolutionBoards(@PathVariable(value="id") String id) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.getReleaseTrainSolutionBoards(id);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/{id}/solutionBoards/piboards"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getReleaseSolutionBoardsAndPiBoards(@PathVariable(value="id") String id) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.getReleaseSolutionBoardsAndPiBoards(id);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/{id}/kanban/boards"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getReleaseTrainKanbanBoards(@PathVariable(value="id") String id, @RequestBody String request) {
        try {
            Gson g = new Gson();
            11 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(request, T.getType());
            requestBody.put("id", id);
            Map responseJson = null;
            responseJson = this.releaseTrainService.getReleaseTrainKanbanBoards((Map)requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/status"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getStatuses(@RequestBody String request) {
        try {
            Gson g = new Gson();
            12 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(request, T.getType());
            String almAccountId = (String)requestBody.get("almId");
            Map responseJson = null;
            responseJson = this.releaseTrainService.getAllStatuses(almAccountId);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/{id}/backlog-stream"})
    public ResponseEntity<StreamingResponseBody> streamReleaseTrainBacklogitems(@RequestBody RTFetchServiceRequestDTO request, @PathVariable(value="id") String id) {
        StreamingResponseBody responseBody;
        LOGGER.info("==================== Streaming Started ===================");
        try {
            responseBody = outputStream -> {
                try {
                    this.itemFetchService.streamBacklogItems(outputStream, request, id, 1000, 1000);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body((Object)responseBody);
    }

    @RequestMapping(value={"/{id}/backlog"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getReleaseTrainBacklogItems(@PathVariable(value="id") String id, @RequestBody String request) {
        try {
            Gson g = new Gson();
            13 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(request, T.getType());
            Map responseJson = null;
            Map teamResponseJson = null;
            Date start = new Date();
            LOGGER.info("==================================================");
            LOGGER.info("             Start at : " + start.getTime());
            LOGGER.info("==================================================");
            responseJson = this.itemFetchService.getBacklogItemsWithLevel(id, (Map)requestBody);
            teamResponseJson = this.itemFetchService.getTeamsWithLevel(id, (Map)requestBody);
            responseJson.put("teamsWithColor", teamResponseJson.get("teamsWithColor"));
            Date end = new Date();
            LOGGER.info("==================================================");
            LOGGER.info("\t\t\t\tEnd at : " + (end.getTime() - start.getTime()));
            LOGGER.info("==================================================");
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/{id}/syncBacklog"}, method={RequestMethod.POST})
    public ResponseEntity<Object> syncBacklogItems(@PathVariable(value="id") String id, @RequestBody String requestBody) {
        Gson g = new Gson();
        14 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap request = (HashMap)g.fromJson(requestBody, T.getType());
        String syncId = (String)request.get("syncId");
        String requestId = (String)request.get("requestId");
        int pageSize = Integer.parseInt((String)request.get("pageSize"));
        int totalCount = Integer.parseInt((String)request.get("totalItems"));
        ArrayList allItems = new ArrayList();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(() -> {
            try {
                for (int start = 0; start < totalCount; start += pageSize) {
                    if (Boolean.TRUE.equals(this.exportCancelFlag.get(requestId))) {
                        if (PropertyValidator.isValid((Object)requestId)) {
                            this.exportCancelFlag.remove(requestId);
                        }
                        LOGGER.info("Ungrouped export cancelled: " + requestId);
                        this.sendCancellationConfirmation(requestId, syncId, "onBacklogPollingComplete");
                        return;
                    }
                    HashMap<String, String> pagedRequest = new HashMap<String, String>(request);
                    pagedRequest.put("pageStart", String.valueOf(start));
                    pagedRequest.put("pageSize", String.valueOf(pageSize));
                    Map partialResult = this.itemFetchService.getBacklogItemsWithLevel(id, pagedRequest);
                    int processedCount = Math.min(start + pageSize, totalCount);
                    this.sendProgressUpdate(requestId, id, processedCount, totalCount, partialResult, "onBacklogPollingProgress");
                    Thread.sleep(1000L);
                }
                HashMap<String, String> finalResult = new HashMap<String, String>();
                finalResult.put("status", "complete");
                finalResult.put("syncId", syncId);
                finalResult.put("releaseTrainId", id);
                this.onBackgroundTaskCompleted(finalResult, syncId, "onBacklogPollingComplete");
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            finally {
                executorService.shutdown();
            }
        });
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "Backlog sync started");
        response.put("syncId", syncId);
        return ResponseEntity.ok(response);
    }

    @RequestMapping(value={"/sync/backlogGroupItems"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> syncBacklogGroupItems(@RequestBody String requestBody) {
        Gson g = new Gson();
        15 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap request = (HashMap)g.fromJson(requestBody, T.getType());
        String syncId = (String)request.get("syncId");
        String requestId = (String)request.get("requestId");
        String releaseTrainId = (String)request.get("releaseTrainId");
        List groups = (List)request.get("groups");
        request.remove("syncId");
        request.remove("requestId");
        request.remove("releaseTrainId");
        request.remove("groups");
        int totalItemsCount = groups.stream().mapToInt(group -> ((Number)group.get("count")).intValue()).sum();
        AtomicInteger processedItemsCount = new AtomicInteger(0);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(() -> {
            try {
                int totalGroups = groups.size();
                int currentGroupIndex = 0;
                for (Map group : groups) {
                    List excludeGroupIds;
                    List multiIds;
                    if (Boolean.TRUE.equals(this.exportCancelFlag.get(requestId))) {
                        if (PropertyValidator.isValid((Object)requestId)) {
                            this.exportCancelFlag.remove(requestId);
                        }
                        LOGGER.info("Export cancelled: " + requestId);
                        this.sendCancellationConfirmation(requestId, syncId, "onBulkGroupProgress");
                        return;
                    }
                    ++currentGroupIndex;
                    Map idMap = (Map)group.get("_id");
                    Object idValue = idMap.get("id");
                    String groupId = String.valueOf(idValue);
                    Double groupCount = (Double)group.get("count");
                    Object idTitle = idMap.get("title");
                    String groupTitle = String.valueOf(idTitle);
                    request.remove("groupId");
                    request.remove("excludeSubGroupIds");
                    request.remove("subGroupIds");
                    if (PropertyValidator.isValid((Object)groupId)) {
                        request.put("groupId", idValue);
                    }
                    if ((multiIds = (List)group.get("multiIds")) != null && !multiIds.isEmpty()) {
                        ArrayList multipleGroups = new ArrayList();
                        multipleGroups.add(null);
                        multipleGroups.addAll(multiIds);
                        request.put("subGroupIds", multipleGroups);
                    }
                    if ((excludeGroupIds = (List)group.get("excludeGroupIds")) != null && !excludeGroupIds.isEmpty()) {
                        request.put("excludeSubGroupIds", excludeGroupIds);
                    }
                    this.fetchItemsByIds(request, requestId, currentGroupIndex, groupCount.intValue(), groupTitle, groupId, releaseTrainId, totalItemsCount, processedItemsCount, syncId);
                }
                HashMap<String, Object> finalResult = new HashMap<String, Object>();
                finalResult.put("status", "completed");
                finalResult.put("percentage", 100);
                finalResult.put("syncId", syncId);
                finalResult.put("releaseTrainId", releaseTrainId);
                this.onBackgroundTaskCompleted(finalResult, syncId, "onBulkGroupProgress");
            }
            catch (Exception e) {
                LOGGER.error("Error in bulk group processing: " + StringUtils.getTraceString((Throwable)e));
            }
            finally {
                executorService.shutdown();
            }
        });
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "Backlog sync started");
        response.put("syncId", syncId);
        return ResponseEntity.ok(response);
    }

    private void fetchItemsByIds(HashMap<String, Object> groupRequest, String requestId, int currentGroup, int groupCount, String groupTitle, String groupId, String releaseTrainId, int totalItemsCount, AtomicInteger processedItemsCount, String syncId) {
        try {
            if (groupCount == 0) {
                this.sendGroupProgress(requestId, groupId, currentGroup, groupTitle, 100, 0, 0, null, releaseTrainId, totalItemsCount, processedItemsCount);
                return;
            }
            int chunkSize = 500;
            int totalProcessed = 0;
            if (groupCount > chunkSize) {
                for (int i = 0; i < groupCount; i += chunkSize) {
                    List itemObjects;
                    if (Boolean.TRUE.equals(this.exportCancelFlag.get(requestId))) {
                        if (PropertyValidator.isValid((Object)requestId)) {
                            this.exportCancelFlag.remove(requestId);
                        }
                        this.sendCancellationConfirmation(requestId, syncId, "onBulkGroupProgress");
                        return;
                    }
                    int currentChunkSize = Math.min(chunkSize, groupCount - i);
                    HashMap<String, Object> chunkRequest = new HashMap<String, Object>(groupRequest);
                    chunkRequest.put("pageStart", String.valueOf(i));
                    chunkRequest.put("pageSize", String.valueOf(currentChunkSize));
                    Map chunkResponse = this.itemFetchService.getBacklogGroupItems(releaseTrainId, chunkRequest);
                    int chunkItemsCount = 0;
                    if (chunkResponse != null && chunkResponse.containsKey("items") && (itemObjects = (List)chunkResponse.get("items")) != null) {
                        chunkItemsCount = itemObjects.size();
                    }
                    processedItemsCount.addAndGet(chunkItemsCount);
                    int progressPercentage = (int)((double)(totalProcessed += chunkItemsCount) * 100.0 / (double)groupCount);
                    this.sendGroupProgress(requestId, groupId, currentGroup, groupTitle, progressPercentage, totalProcessed, groupCount, (Object)chunkResponse, releaseTrainId, totalItemsCount, processedItemsCount);
                }
            } else {
                List itemObjects;
                if (Boolean.TRUE.equals(this.exportCancelFlag.get(requestId))) {
                    if (PropertyValidator.isValid((Object)requestId)) {
                        this.exportCancelFlag.remove(requestId);
                    }
                    LOGGER.info("Export cancelled: " + requestId);
                    this.sendCancellationConfirmation(requestId, syncId, "onBulkGroupProgress");
                    return;
                }
                Map response = this.itemFetchService.getBacklogGroupItems(releaseTrainId, groupRequest);
                int itemsCount = 0;
                if (response != null && response.containsKey("items") && (itemObjects = (List)response.get("items")) != null) {
                    itemsCount = itemObjects.size();
                }
                processedItemsCount.addAndGet(itemsCount);
                this.sendGroupProgress(requestId, groupId, currentGroup, groupTitle, 100, itemsCount, groupCount, (Object)response, releaseTrainId, totalItemsCount, processedItemsCount);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error fetching items for group " + groupTitle + ": " + StringUtils.getTraceString((Throwable)e));
        }
    }

    private void sendGroupProgress(String requestId, String groupId, int currentGroup, String groupTitle, int groupProgress, int processedItems, int totalItems, Object responseData, String releaseTrainId, int totalItemsCount, AtomicInteger processedItemsCount) throws Exception {
        HashMap<String, Object> progressData = new HashMap<String, Object>();
        progressData.put("currentGroup", currentGroup);
        progressData.put("groupTitle", groupTitle);
        progressData.put("groupId", groupId);
        progressData.put("releaseTrainId", releaseTrainId);
        progressData.put("groupProgress", groupProgress);
        progressData.put("processedItems", processedItems);
        progressData.put("totalItems", totalItems);
        progressData.put("overallProgress", (int)((double)processedItemsCount.get() * 100.0 / (double)totalItemsCount));
        if (responseData != null) {
            if (responseData instanceof Map) {
                progressData.put("results", responseData);
            } else if (responseData instanceof List) {
                HashMap<String, Object> results = new HashMap<String, Object>();
                results.put("items", responseData);
                progressData.put("results", results);
            }
        }
        this.onBackgroundTaskCompleted(progressData, requestId, "onBulkGroupProgress");
        if (responseData != null && processedItems < 100) {
            Thread.sleep(1000L);
        } else {
            Thread.sleep(2000L);
        }
    }

    private void sendProgressUpdate(String syncId, String releaseTrainId, int current, int total, Map<String, Object> results, String event) {
        HashMap<String, Object> progressData = new HashMap<String, Object>();
        progressData.put("current", current);
        progressData.put("total", total);
        progressData.put("releaseTrainId", releaseTrainId);
        progressData.put("percentage", (int)((double)current * 100.0 / (double)total));
        if (results != null) {
            progressData.put("results", results);
        }
        this.onBackgroundTaskCompleted(progressData, syncId, event);
    }

    @RequestMapping(value={"/cancel/export"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> cancelOperation(@RequestBody String requestBody) {
        try {
            Gson g = new Gson();
            16 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap request = (HashMap)g.fromJson(requestBody, T.getType());
            String requestId = (String)request.get("requestId");
            String syncId = (String)request.get("syncId");
            String event = (String)request.get("event");
            this.exportCancelFlag.put(requestId, true);
            LOGGER.info("Cancel request received for requestId: " + requestId);
            this.sendCancellationConfirmation(requestId, syncId, event);
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("message", "Cancellation signal sent");
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            LOGGER.error("Error processing cancellation request: " + StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    private void sendCancellationConfirmation(String requestId, String syncId, String event) {
        HashMap<String, String> cancellationData = new HashMap<String, String>();
        cancellationData.put("status", "cancelled");
        cancellationData.put("message", "Export operation was cancelled");
        cancellationData.put("requestId", requestId);
        this.onBackgroundTaskCompleted(cancellationData, syncId, event);
    }

    @RequestMapping(value={"/backlog/items"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getReleaseTrainBacklogItemsWithId(@RequestBody String request) {
        try {
            Gson g = new Gson();
            17 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(request, T.getType());
            Map responseJson = null;
            responseJson = this.itemFetchService.getBacklogItems(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    public void sendLazyBoards(@PathVariable(value="id") String id, String workFlowId, Map<String, Object> responseJson, @RequestBody Map<String, Object> request) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    @RequestMapping(value={"/backlog/backlogItemChildren"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getBacklogItemChildren(@RequestBody String request) {
        try {
            Gson g = new Gson();
            19 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(request, T.getType());
            String releaseTrainId = (String)requestBody.get("releaseTrainId");
            Map responseJson = null;
            responseJson = this.itemFetchService.getBacklogItemsChildren(releaseTrainId, requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/backlog/backlogItemChildrenCounts"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<BacklogItemChildrenCountsResponseDTO> getBacklogItemChildrenCounts(@RequestBody BacklogItemChildrenCountsRequestDTO requestDTO) {
        try {
            Map countsMap = this.itemFetchService.getBacklogItemsChildrenCounts(requestDTO.getReleaseTrainId(), requestDTO.getItemIds(), requestDTO.getIterationPathDates(), requestDTO.getDatePreference(), requestDTO.getBoardId(), requestDTO.getAlmAccountType(), requestDTO.getTfsIterationMap());
            BacklogItemChildrenCountsResponseDTO responseDTO = new BacklogItemChildrenCountsResponseDTO((Map)countsMap.get("counts"));
            return new ResponseEntity((Object)responseDTO, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/backlog/backlogGroupItems"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> backlogGroupItems(@RequestBody String request) {
        try {
            Gson g = new Gson();
            20 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(request, T.getType());
            String releaseTrainId = (String)requestBody.get("releaseTrainId");
            Map responseJson = null;
            responseJson = this.itemFetchService.getBacklogGroupItems(releaseTrainId, (Map)requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/{id}/teamConfiguration"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getReleaseTrainTeams(@PathVariable(value="id") String id) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.getReleaseTrainTeams(id);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/kanban/save/fields/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveKanbanWidgetFields(@PathVariable(value="id") String id, @RequestBody List<Map<String, Object>> fields) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.saveKanbanWidgetFields(id, fields);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/kanban/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveKanbanBoard(@RequestBody Board board) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.saveBoard(board);
            Board savedBoard = (Board)responseJson.get("board");
            if (savedBoard.getViewType().equals(Board.EnumBoardType.KANBAN.toString())) {
                ArrayList<Lane> lanes = new ArrayList<Lane>();
                Lane lane1 = new Lane();
                lane1.setName("To-Do");
                lane1.setColumns(2);
                lane1.setIndex(0);
                lane1.setOrientation("vertical");
                lane1.setMinColumns(1);
                lane1.setWipLimit(0);
                lane1.setBoardId(savedBoard.getId());
                lane1.setHeaderColor("#ffffff");
                lane1.setContainerColor("#ffffff");
                lane1.setTitleColor("#1E2835");
                lane1.setSortBy("manual");
                Lane lane2 = new Lane();
                lane2.setName("In-Progress");
                lane2.setColumns(2);
                lane2.setIndex(1);
                lane2.setOrientation("vertical");
                lane2.setMinColumns(1);
                lane2.setWipLimit(0);
                lane2.setBoardId(savedBoard.getId());
                lane2.setHeaderColor("#ffffff");
                lane2.setContainerColor("#ffffff");
                lane2.setTitleColor("#1E2835");
                lane2.setSortBy("manual");
                Lane lane3 = new Lane();
                lane3.setName("Done");
                lane3.setColumns(2);
                lane3.setIndex(2);
                lane3.setOrientation("vertical");
                lane3.setMinColumns(1);
                lane3.setWipLimit(0);
                lane3.setBoardId(savedBoard.getId());
                lane3.setHeaderColor("#ffffff");
                lane3.setContainerColor("#ffffff");
                lane3.setTitleColor("#1E2835");
                lane3.setSortBy("manual");
                lanes.add(lane1);
                lanes.add(lane2);
                lanes.add(lane3);
                this.releaseTrainService.saveAllLanes(lanes);
            }
            if (savedBoard.getViewType().equals(Board.EnumBoardType.ROADMAP.toString())) {
                this.roadmapSectionService.createDefaultSection(savedBoard.getId());
            }
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/kanban/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getKanbanBoard(@PathVariable(value="id") String id) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.getBoard(id);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/board/settings"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateTimelineVisiblePiBoards(@RequestBody String request) {
        try {
            Map responseJson = null;
            Gson g = new Gson();
            21 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)g.fromJson(request, T.getType());
            responseJson = this.releaseTrainService.updateBoardSettings((Map)reqbody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/roadmap/settings"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateRoadmapSettings(@RequestBody String request) {
        try {
            Gson g = new Gson();
            22 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)g.fromJson(request, T.getType());
            this.releaseTrainService.updateRoadmapSettings(reqbody);
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/board/kanbanMappingOrder"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> kanbanMappingOrder(@RequestBody String payload) {
        try {
            Map responseJson = null;
            Gson g = new Gson();
            23 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            responseJson = this.releaseTrainService.kanbanMappingOrder((Map)requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/kanban/board/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveBoard(@RequestBody String request) {
        try {
            27 P;
            Collection lanesCollection;
            Board boardFromDb;
            Map<String, Object> responseJson = null;
            Gson g = new Gson();
            Gson gson = new Gson();
            24 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)g.fromJson(request, T.getType());
            String lanesJSON = (String)reqbody.get("lanes");
            String boardJSON = (String)reqbody.get("board");
            String boardId = (String)reqbody.get("boardId");
            String deletedLanesJSON = (String)reqbody.get("deletedLanes");
            Boolean enableMapping = (Boolean)reqbody.get("enableMapping");
            25 A = new /* Unavailable Anonymous Inner Class!! */;
            Collection deletedLanes = (Collection)gson.fromJson(deletedLanesJSON, A.getType());
            26 B = new /* Unavailable Anonymous Inner Class!! */;
            Board board = (Board)gson.fromJson(boardJSON, B.getType());
            if (PropertyValidator.isValid((Object)boardId)) {
                boardFromDb = this.boardRepository.findByIdOrKeyOrderByNameAsc(boardId, boardId);
                boardFromDb.setEnableMapping(enableMapping);
                this.boardRepository.save((Object)boardFromDb);
            }
            if (PropertyValidator.isValid((Object)board)) {
                boardFromDb = this.boardRepository.findByIdOrKeyOrderByNameAsc(board.getId(), board.getKey());
                boardFromDb.setName(board.getName());
                boardFromDb.setBacklogColumnTitle(board.getBacklogColumnTitle());
                if (PropertyValidator.isValid((Object)board.getFilterCriteria())) {
                    if (board.getFilterCriteria().getId().equals("0")) {
                        boardFromDb.setFilterCriteria(null);
                    } else {
                        boardFromDb.setFilterCriteria(board.getFilterCriteria());
                    }
                }
                Board savedBoard = (Board)this.boardRepository.save((Object)boardFromDb);
                responseJson = new HashMap<String, Board>();
                responseJson.put("board", savedBoard);
            }
            if (PropertyValidator.isValid((Collection)(lanesCollection = (Collection)gson.fromJson(lanesJSON, (P = new /* Unavailable Anonymous Inner Class!! */).getType())))) {
                HashSet<String> lanesDifference = new HashSet<String>();
                if (PropertyValidator.isValid((Collection)deletedLanes)) {
                    lanesDifference.addAll(deletedLanes);
                }
                for (Lane lane2 : lanesCollection) {
                    if (!PropertyValidator.isValid((String[])lane2.getReceiveItemsFromLanes())) continue;
                    responseJson = this.releaseTrainService.moveItemsToParentLane(lane2.getId(), lane2.getReceiveItemsFromLanes());
                    for (String laneId : lane2.getReceiveItemsFromLanes()) {
                        lanesDifference.add(laneId);
                    }
                }
                HashSet allLaneIds = new HashSet();
                lanesCollection.forEach(lane -> allLaneIds.add(lane.getId()));
                Sets.SetView laneIdsToBeDeleted = Sets.difference(lanesDifference, allLaneIds);
                if (PropertyValidator.isValid((Collection)laneIdsToBeDeleted)) {
                    this.releaseTrainService.deleteLanes((Set)laneIdsToBeDeleted);
                } else {
                    for (Lane lane3 : lanesCollection) {
                        if (!PropertyValidator.isValid((String[])lane3.getReceiveItemsFromLanes())) continue;
                        this.releaseTrainService.moveItemsToParentLane(lane3.getId(), lane3.getReceiveItemsFromLanes());
                    }
                }
                this.releaseTrainService.saveAllLanes(lanesCollection);
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/kanban/lane/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveBoardLane(@RequestBody String request) {
        try {
            Map responseJson = null;
            Gson gson = new Gson();
            28 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)gson.fromJson(request, T.getType());
            String id = (String)reqbody.get("id");
            String name = (String)reqbody.get("name");
            String boardId = (String)reqbody.get("boardId");
            String orientation = (String)reqbody.get("orientation");
            Double index = (Double)reqbody.get("index");
            String split = reqbody.get("split") != null ? (String)reqbody.get("split") : null;
            Double columns = (Double)reqbody.get("columns");
            Double level = (Double)reqbody.get("level");
            Double minColumns = (Double)reqbody.get("minColumns");
            String parentLaneId = reqbody.get("parentLaneId") != null ? (String)reqbody.get("parentLaneId") : null;
            Criteria criteria = (Criteria)gson.fromJson(String.valueOf(reqbody.get("criteria")), Criteria.class);
            Lane lane = new Lane();
            lane.setId(id);
            lane.setName(name);
            lane.setOrientation(orientation);
            lane.setParentLaneId(parentLaneId);
            lane.setBoardId(boardId);
            lane.setSplit(split);
            lane.setCriteria(criteria);
            lane.setIndex(index.intValue());
            lane.setColumns(columns.intValue());
            lane.setParentLaneId(parentLaneId);
            lane.setMinColumns(minColumns.intValue());
            lane.setLevel(level.intValue());
            responseJson = this.releaseTrainService.saveLane(lane);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/item-parent/{artId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> loadItem(@PathVariable(value="artId") String artId, @RequestBody BacklogItem backlogItem) {
        try {
            BaseItemLink link;
            BacklogItem item = this.backlogItemRepository.findById(backlogItem.getId());
            if (PropertyValidator.isValid((Object)item) && item.getParentRelationMap() != null && item.getParentRelationMap().get(artId) != null && (link = (BaseItemLink)((List)item.getParentRelationMap().get(artId)).iterator().next()).getBacklogItemId() != null) {
                return new ResponseEntity((Object)this.backlogItemRepository.findById(String.valueOf(link.getBacklogItemId())), HttpStatus.OK);
            }
            return new ResponseEntity(null, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/item/move"})
    @ResponseBody
    public ResponseEntity<Object> saveItemDrag(@RequestBody String request) {
        try {
            Map responseJson = null;
            Gson gson = new Gson();
            29 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)gson.fromJson(request, T.getType());
            responseJson = this.itemOperationsService.moveKanbanItem(reqbody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @PutMapping(value={"/item/update-field"})
    ResponseEntity<Object> updateItemField(@RequestBody RTItemsOperationsDTO rtItemsOperationsDTO) {
        try {
            BacklogItem responseJson = this.itemOperationsService.updateItemField(rtItemsOperationsDTO);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/item/remove"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> removeItem(@RequestBody String request) {
        try {
            Map responseJson = null;
            Gson gson = new Gson();
            30 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)gson.fromJson(request, T.getType());
            String itemId = (String)reqbody.get("itemId");
            String laneId = (String)reqbody.get("laneId");
            String kanbanId = (String)reqbody.get("kanbanId");
            Double sequence = (Double)reqbody.get("sequence");
            responseJson = this.itemOperationsService.removeKanbanLaneFromItem(itemId, laneId, kanbanId, sequence);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/item/removeFromBoard"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> removeFromBoard(@RequestBody String request) {
        try {
            Map responseJson = null;
            Gson gson = new Gson();
            31 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)gson.fromJson(request, T.getType());
            String itemId = (String)reqbody.get("itemId");
            List boardsToRemove = (List)reqbody.get("boardsToRemove");
            responseJson = this.itemOperationsService.removeBoardFromItem(itemId, boardsToRemove);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/backlog/search"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> backlogSearch(@RequestBody String payload) {
        try {
            Gson g = new Gson();
            32 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            Map responseJson = null;
            responseJson = this.itemFetchService.searchBacklogItems(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/item/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveBacklogItem(@RequestBody String payload) {
        try {
            Gson g = new Gson();
            33 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            Map responseJson = null;
            responseJson = this.itemOperationsService.saveItem(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/milestone/bulkArchive"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> archiveMilestones(@RequestBody String payload) {
        HashMap responseJson = new HashMap();
        Gson g = new Gson();
        34 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
        String syncId = (String)requestBody.get("syncId");
        Map result = this.itemOperationsService.archieveMilestone(requestBody);
        this.onBackgroundTaskCompleted(result, syncId, "ArchiveItemsCompleted");
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/item/bulkArchieve"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> archieveBacklogItems(@RequestBody String payload) {
        HashMap responseJson = new HashMap();
        Gson g = new Gson();
        35 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/item/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteBacklogItems(@RequestBody String payload) {
        HashMap responseJson = new HashMap();
        Gson g = new Gson();
        37 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/save-jira-filter"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveJiraFilter(@RequestBody ResyncParamsVO param) {
        try {
            Gson gson = new Gson();
            param.filter = (JiraFilter)gson.fromJson(param.filterStr, JiraFilter.class);
            Object responseJson = null;
            this.releaseTrainService.saveJiraFilter(param);
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/load-tfs-projects/{almId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> loadTfsProjects(@PathVariable(value="almId") String almId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            String tfsProjects = this.releaseTrainService.loadTfsProjects(almId);
            responseJson.put("tfsProjects", tfsProjects);
            responseJson.put("success", true);
        }
        catch (ViztrendJiraException e2) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e2));
            responseJson.put("success", false);
            responseJson.put("almError", (Object)e2);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/link-tfs-project"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> linkTfsProjects(@RequestBody String payload) {
        HashMap responseJson = new HashMap();
        Gson g = new Gson();
        40 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
        String tfsProjectId = (String)requestBody.get("tfsProjectId");
        String metaMap = (String)requestBody.get("metaMap");
        String syncId = (String)requestBody.get("syncId");
        String almId = (String)requestBody.get("almId");
        String releaseTrainKey = (String)requestBody.get("releaseTrainKey");
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/resync-tfs-project"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> resyncTfsProjects(@RequestBody String payload) {
        HashMap responseJson = new HashMap();
        Gson g = new Gson();
        42 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
        String syncId = (String)requestBody.get("syncId");
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/delete-tfs-project"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteTfsProjects(@RequestBody String payload) {
        HashMap responseJson = new HashMap();
        Gson g = new Gson();
        44 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
        String tfsProjectId = (String)requestBody.get("tfsProjectId");
        String metaMap = (String)requestBody.get("metaMap");
        String syncId = (String)requestBody.get("syncId");
        String almId = (String)requestBody.get("almId");
        String workspaceKey = (String)requestBody.get("workspaceKey");
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/enableLocalProjectSettings"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> enableLocalProjectSettings(@RequestBody String payload) {
        try {
            Gson g = new Gson();
            46 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            Map responseJson = null;
            responseJson = this.releaseTrainService.enableLocalProjectSettings((Map)requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/delete-filter"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteFilter(@RequestBody String payload) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        Gson g = new Gson();
        47 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
        String almId = (String)requestBody.get("almId");
        String metaMap = (String)requestBody.get("metaMap");
        String filterId = (String)requestBody.get("filterId");
        String syncId = (String)requestBody.get("syncId");
        String releaseTrainId = (String)requestBody.get("releaseTrainId");
        try {
            Map result = this.releaseTrainService.deleteFilters(filterId, releaseTrainId, almId, null);
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            responseJson.put("success", false);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
    }

    @RequestMapping(value={"/fetch-save-tfs-filter"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchSaveTfsFilter(@RequestBody String payload) {
        HashMap responseJson = new HashMap();
        Gson g = new Gson();
        48 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
        String itemIdsStr = (String)requestBody.get("itemIds");
        String almId = (String)requestBody.get("almId");
        String metaMap = (String)requestBody.get("metaMap");
        String filterJson = (String)requestBody.get("filter");
        String syncId = (String)requestBody.get("syncId");
        String releaseTrainId = (String)requestBody.get("releaseTrainId");
        String backlogLevelStr = (String)requestBody.get("backlogLevel");
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/resync-tfs-items"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> resyncTfsItems(@RequestBody String payload) {
        HashMap responseJson = new HashMap();
        Gson g = new Gson();
        50 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/add-existing-tfs-items"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> addExistingTfsItems(@RequestBody String payload) {
        HashMap responseJson = new HashMap();
        Gson g = new Gson();
        52 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private void onBackgroundTaskCompleted(Map<String, Object> result, String syncId, String event) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            String content = mapper.writeValueAsString(result);
            String requestId = null;
            if (PropertyValidator.isValid((Object)syncId) && syncId.contains("#")) {
                String[] syncIdArray = syncId.split("#");
                syncId = syncIdArray[0];
                requestId = syncIdArray[1];
            }
            JSONObject pushJson = new JSONObject();
            pushJson = new JSONObject();
            pushJson.put("type", (Object)"Auto");
            pushJson.put("push", (Object)"Self");
            pushJson.put("done", true);
            pushJson.put("requestParam", (Object)content);
            pushJson.put("metaMap", (Object)("{\"event\":\"" + event + "\", \"syncId\":\"" + syncId + "\"}"));
            String pushJsonStr = pushJson.toString();
            if (!PropertyValidator.isValid((Object)requestId)) {
                PushSender.sendMsg((String)pushJsonStr);
            } else {
                this.pushResponseRepository.save((Object)new PushResponse(requestId, pushJsonStr, Boolean.valueOf(true)));
            }
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        catch (JsonProcessingException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    @RequestMapping(value={"/getAlmAccounts"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getAlmAccounts() {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.getAlmAccounts();
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/link/almAccount"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> linkAlmAccount(@RequestBody String request) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.linkAlmAccount(request);
            AlmAccount almAccount = (AlmAccount)responseJson.get("linkAlmAccount");
            if (PropertyValidator.isValid((Object)almAccount)) {
                if (almAccount.getType().equalsIgnoreCase("Jira")) {
                    responseJson.put("linkedJiraProjects", this.releaseTrainService.fetchLinkedJiraProjects(almAccount));
                } else {
                    responseJson.put("linkedTfsProjects", this.releaseTrainService.fetchLinkedTfsProjects(almAccount.getId(), (String)responseJson.get("releaseTrainKey")));
                }
            }
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/save/alm-hierarchy"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveALMHierarchy(@RequestBody BacklogHierarchy backlogHierarchy) {
        try {
            HashMap<String, BacklogHierarchy> responseJson = new HashMap<String, BacklogHierarchy>();
            responseJson.put("backlogHierarchy", this.releaseTrainService.saveALMHierarchy(backlogHierarchy));
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/fetch/hierarchies"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getHierarchies() {
        try {
            Map<String, List> responseJson = new HashMap();
            List backlogHierarchyList = this.releaseTrainService.getBacklogHierarchies();
            responseJson = this.releaseTrainService.createHierarchyMeta(backlogHierarchyList);
            responseJson.put("list", backlogHierarchyList);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/can-delete-level"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> checkLevelDeletion(@RequestBody String payload) {
        try {
            Map responseJson = null;
            Gson g = new Gson();
            54 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            responseJson = this.releaseTrainService.checkLevelDeletion((Map)requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get/tfsProcess/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getTfsProcess(@PathVariable(value="id") String id) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.getTfsProcess(id);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get/tfsProcess/workItemTypes"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getTfsProcessWorkItemTypes(@RequestBody String requestBody) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.getTfsProcessWorkItemType(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get/tfsFields/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getTfsFields(@PathVariable(value="id") String id) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.getAllTFSFields(id);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/save/tfsField/{id}/{releaseTrainId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveTfsField(@PathVariable(value="id") String id, @PathVariable(value="releaseTrainId") String releaseTrainId, @RequestBody HashMap<String, Object> requestBody) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.saveTfsFields(id, releaseTrainId, requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get/jiraFields/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getJiraFields(@PathVariable(value="id") String id) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.getAllJiraFields(id);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/save/jiraFields/{almId}/{releaseTrainId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveJiraFields(@PathVariable(value="almId") String id, @PathVariable(value="releaseTrainId") String releaseTrainId, @RequestBody HashMap<String, Object> requestBody) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.savejiraFields(id, releaseTrainId, requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/save/jiraProject"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveJiraProjects(@RequestBody String requestBody) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.saveJiraProject(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/remove/jiraProject"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> removeJiraProjects(@RequestBody String requestBody) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.removeJiraProject(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/resync-jira-items"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> resyncJiraItems(@RequestBody ResyncParamsVO param) {
        try {
            Object responseJson = null;
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get/jira-meta"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getJiraMeta(@RequestBody String requestBody) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.getJiraMeta(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/link-jira-projects/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getLinkedJiraProjects(@PathVariable(value="id") String id) {
        try {
            HashMap<String, List> responseJson = new HashMap<String, List>();
            responseJson.put("linkedJiraProjects", this.releaseTrainService.fetchLinkedJiraProjects(new AlmAccount(id)));
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/add-existing-jira-items"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> AddExistingJiraItems(@RequestBody ResyncParamsVO param, @RequestParam(value="boardId") String boardId) {
        try {
            Map responseJson = null;
            boolean isFetch = true;
            if (PropertyValidator.isValid((Object)param.itemIds)) {
                responseJson = this.releaseTrainService.searchExistingBackLogJiraItems(param.itemIds, param.almConfigurations.getAlmAccount().getId(), param.releaseTrainId);
                isFetch = (Boolean)responseJson.get("success");
            }
            if (isFetch) {
                this.itemOperationsService.linkMultipleInJira(param);
                Collection backlogItems = this.releaseTrainService.fetchJiraItems(param);
                if (PropertyValidator.isValid((Object)boardId)) {
                    this.releaseTrainService.linkJiraBacklogItemsToBoard(boardId, param.releaseTrainId, backlogItems, param.itemIds, param.almConfigurations.getAlmAccount().getId());
                }
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/search/kendis-items"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> searchKendisItems(@RequestBody Map<String, Object> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            String searchQuery = (String)requestBody.get("searchQuery");
            String releaseTrainId = (String)requestBody.get("releaseTrainId");
            Integer hierarchyLevel = (Integer)requestBody.get("hierarchyLevel");
            String excludeParentId = (String)requestBody.get("excludeParentId");
            if (!PropertyValidator.isValid((Object)searchQuery) || searchQuery.trim().isEmpty()) {
                responseJson.put("success", false);
                responseJson.put("message", "Search query is required");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            if (!PropertyValidator.isValid((Object)releaseTrainId)) {
                responseJson.put("success", false);
                responseJson.put("message", "Release train ID is required");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            List items = this.releaseTrainService.searchKendisOnlyItems(searchQuery, releaseTrainId, hierarchyLevel, excludeParentId);
            responseJson.put("success", true);
            responseJson.put("items", items);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("Error searching Kendis items: ", (Throwable)e);
            responseJson.put("success", false);
            responseJson.put("message", "Error occurred while searching items");
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/add-existing-kendis-items"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> addExistingKendisItems(@RequestBody Map<String, Object> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            Map parent;
            String itemIds = (String)requestBody.get("itemIds");
            String releaseTrainId = (String)requestBody.get("releaseTrainId");
            String parentId = null;
            String boardId = (String)requestBody.get("boardId");
            Integer backlogLevel = (Integer)requestBody.get("backlogLevel");
            if (requestBody.containsKey("parent") && (parent = (Map)requestBody.get("parent")) != null) {
                parentId = (String)parent.get("id");
            }
            if (!PropertyValidator.isValid((Object)itemIds)) {
                responseJson.put("success", false);
                responseJson.put("message", "Item IDs are required");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            if (!PropertyValidator.isValid((Object)releaseTrainId)) {
                responseJson.put("success", false);
                responseJson.put("message", "Release train ID is required");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            Map result = this.releaseTrainService.addExistingKendisItems(itemIds, releaseTrainId, parentId, boardId, backlogLevel);
            responseJson.put("success", true);
            responseJson.put("items", result.get("items"));
            responseJson.put("message", "Items added successfully");
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("Error adding existing Kendis items: ", (Throwable)e);
            responseJson.put("success", false);
            responseJson.put("message", "Error occurred while adding items");
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/search/potential-parents"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> searchPotentialParents(@RequestBody Map<String, Object> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            String searchQuery = (String)requestBody.get("searchQuery");
            String releaseTrainId = (String)requestBody.get("releaseTrainId");
            Integer hierarchyLevel = (Integer)requestBody.get("hierarchyLevel");
            String excludeItemId = (String)requestBody.get("excludeItemId");
            if (!PropertyValidator.isValid((Object)searchQuery) || searchQuery.trim().isEmpty()) {
                responseJson.put("success", false);
                responseJson.put("message", "Search query is required");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            if (!PropertyValidator.isValid((Object)releaseTrainId)) {
                responseJson.put("success", false);
                responseJson.put("message", "Release train ID is required");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            List items = this.releaseTrainService.searchPotentialParents(searchQuery, releaseTrainId, hierarchyLevel, excludeItemId);
            responseJson.put("success", true);
            responseJson.put("items", items);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("Error searching potential parents: ", (Throwable)e);
            responseJson.put("success", false);
            responseJson.put("message", "Error occurred while searching potential parents");
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/add-parent-to-item"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> addParentToItem(@RequestBody Map<String, Object> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            String itemId = (String)requestBody.get("itemId");
            String parentId = (String)requestBody.get("parentId");
            String releaseTrainId = (String)requestBody.get("releaseTrainId");
            if (!PropertyValidator.isValid((Object)itemId)) {
                responseJson.put("success", false);
                responseJson.put("message", "Item ID is required");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            if (!PropertyValidator.isValid((Object)parentId)) {
                responseJson.put("success", false);
                responseJson.put("message", "Parent ID is required");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            if (!PropertyValidator.isValid((Object)releaseTrainId)) {
                responseJson.put("success", false);
                responseJson.put("message", "Release train ID is required");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            Map result = this.releaseTrainService.addParentToItem(itemId, parentId, releaseTrainId);
            responseJson.put("success", true);
            responseJson.put("item", result.get("item"));
            responseJson.put("parent", result.get("parent"));
            responseJson.put("message", "Parent added successfully");
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("Error adding parent to item: ", (Throwable)e);
            responseJson.put("success", false);
            responseJson.put("message", "Error occurred while adding parent");
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/compatible-collections"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getCompatibleCollections(@RequestBody Map<String, Object> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            String currentReleaseTrainId = (String)requestBody.get("currentReleaseTrainId");
            if (!PropertyValidator.isValid((Object)currentReleaseTrainId)) {
                responseJson.put("success", false);
                responseJson.put("message", "Current release train ID is required");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            List collections = this.releaseTrainService.getCompatibleCollections(currentReleaseTrainId);
            responseJson.put("success", true);
            responseJson.put("collections", collections);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("Error getting compatible collections: ", (Throwable)e);
            responseJson.put("success", false);
            responseJson.put("message", "Error occurred while loading compatible collections");
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/add-item-to-collection"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> addItemToCollection(@RequestBody Map<String, Object> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            String itemId = (String)requestBody.get("itemId");
            String sourceReleaseTrainId = (String)requestBody.get("sourceReleaseTrainId");
            String targetReleaseTrainId = (String)requestBody.get("targetReleaseTrainId");
            Boolean addWithHierarchy = (Boolean)requestBody.get("addWithHierarchy");
            if (!PropertyValidator.isValid((Object)itemId)) {
                responseJson.put("error", true);
                responseJson.put("message", "Item ID is required");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            if (!PropertyValidator.isValid((Object)sourceReleaseTrainId)) {
                responseJson.put("error", true);
                responseJson.put("message", "Source release train ID is required");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            if (!PropertyValidator.isValid((Object)targetReleaseTrainId)) {
                responseJson.put("error", true);
                responseJson.put("message", "Target release train ID is required");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            if (addWithHierarchy == null) {
                addWithHierarchy = false;
            }
            Map result = this.releaseTrainService.addItemToCollection(itemId, sourceReleaseTrainId, targetReleaseTrainId, addWithHierarchy);
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("Error adding item to collection: ", (Throwable)e);
            responseJson.put("success", false);
            responseJson.put("message", "Error occurred while adding item");
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/criteria/filters/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveCriteriaFilter(@RequestBody FilterCriteria filterCriteria) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.saveFilterCriteria(filterCriteria);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/delete/criteria"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteCriteria(@RequestBody HashMap<String, Object> requestBody) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.deleteCriteria(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/solution-board-workspaces"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getWorkSpacesForSolutionBoard(@RequestBody String request) {
        try {
            Gson g = new Gson();
            56 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(request, T.getType());
            ArrayList responseJson = this.releaseTrainService.getWorkSpacesForSolutionBoard((Map)requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/release-trains"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getAllReleaseTrains(@RequestBody String request) {
        try {
            Gson g = new Gson();
            57 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(request, T.getType());
            Map responseJson = null;
            responseJson = this.releaseTrainService.getAllReleaseTrains((Map)requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/releaseTrainsWithSameHeirarchy"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getreleaseTrainsWithSameHeirarchy(@RequestBody String request) {
        try {
            Gson g = new Gson();
            58 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(request, T.getType());
            Map responseJson = null;
            responseJson = this.releaseTrainService.getAllReleaseTrains((Map)requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/ignorelist/add"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> releaseTrainIgnoreListAdd(@RequestBody String payload) {
        Gson g = new Gson();
        59 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
        String releaseTrainId = (String)requestBody.get("releaseTrainId");
        String itemTfsId = (String)requestBody.get("itemTfsId");
        Map result = new HashMap();
        try {
            result = this.releaseTrainService.releaseTrainIgnoreListAdd(releaseTrainId, itemTfsId);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/ignorelist/remove"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> releaseTrainIgnoreListRemove(@RequestBody String payload) {
        Gson g = new Gson();
        60 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
        String releaseTrainId = (String)requestBody.get("releaseTrainId");
        String itemTfsId = (String)requestBody.get("itemTfsId");
        Map result = new HashMap();
        try {
            result = this.releaseTrainService.releaseTrainIgnoreListRemove(releaseTrainId, itemTfsId);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/ignorelist/clear"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> releaseTrainIgnoreListClear(@RequestBody String payload) {
        Gson g = new Gson();
        61 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
        String releaseTrainId = (String)requestBody.get("releaseTrainId");
        Map result = new HashMap();
        try {
            result = this.releaseTrainService.releaseTrainIgnoreListClear(releaseTrainId);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/archive/workspace/{archive}/{workspaceId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> archiveWorspace(@PathVariable(value="archive") Boolean archive, @PathVariable(value="workspaceId") String workspaceId) {
        try {
            Map responseJson = this.releaseTrainService.archiveWorkspace(workspaceId, archive);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/getAllBackLogItems"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getItemsByBoardItem() {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        List backlogItems = this.backlogItemRepository.findAll();
        ArrayList features = new ArrayList();
        ArrayList stories = new ArrayList();
        responseJson.put("stories", stories);
        responseJson.put("features", backlogItems);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-query-backlog-items/{queryText}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getQueryBacklogItems(@PathVariable(value="queryText") String queryText) {
        try {
            Object responseJson = null;
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get/workspace-meta/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getWorkSpaceMeta(@PathVariable(value="id") String workspaceId) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.getWorkpaceMeta(workspaceId);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get/roles-permissions"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getRolesPermissions(@RequestBody String payload) {
        try {
            Gson g = new Gson();
            62 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            Map responseJson = null;
            responseJson = this.releaseTrainService.getRolesAndPermissionMeta(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get/workspace-module/{type}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getWorkspaceModule(@PathVariable(value="type") String type) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.getWorkspaceModule(type);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/sort/art"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> sortART(@RequestBody String payload) {
        try {
            Gson g = new Gson();
            63 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            Map responseJson = null;
            responseJson = this.releaseTrainService.sortArt(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/filters/validate/linking"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> validateFilterLinking(@RequestBody FilterCriteria filterCriteria) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.validateFiltersLinking(filterCriteria);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/getAllReleaseTrainsByWsType/{workspaceTypeId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getAllReleaseTrainsByWsType(@PathVariable(value="workspaceTypeId") String workspaceTypeId) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.getAllReleaseTrainsByWsType(workspaceTypeId);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/getAllWorkSpaceTypes"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getAllWorkSpaceTypes() {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.getAllWorkSpaceTypes();
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/release-trains-without-pi"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getReleaseTrainsWithoutPIs() {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.getAllReleaseTrainsWithoutPIs();
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/workspace/add-site/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> addSiteInWorkspace(@PathVariable(value="id") String workspaceId, @RequestBody PiSite site) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.addSiteInWorkspace(workspaceId, site);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/workspace/remove-site/{id}/{siteId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Object> removeSiteFromWorkspace(@PathVariable(value="id") String workspaceId, @PathVariable(value="siteId") String siteId) {
        try {
            Map responseJson = null;
            responseJson = this.releaseTrainService.removeSiteFromWorkspace(workspaceId, siteId);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get-items-statuses"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getItemsStatuses(@RequestBody String payload) {
        Map responseJson = null;
        try {
            Gson g = new Gson();
            64 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            responseJson = this.itemFetchService.getBatchItemsCompletion(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/milestones/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveMilestone(@RequestBody String payload) {
        try {
            Map responseJson = null;
            Gson g = new Gson();
            65 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            responseJson = this.itemOperationsService.saveMilestone(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/get-milestones-linked-with-pi/{boardId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getMilestonesLinkedWithPi(@PathVariable(value="boardId") String boardId) {
        Map<String, Exception> responseJson = new HashMap<String, Exception>();
        try {
            responseJson = this.releaseTrainService.getMilestonesLinkedToPiBoard(boardId);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/link-pi-items-with-milestones"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> linkPiItemsWithMilestones(@RequestBody Map<String, Object> requestBody) {
        Map<String, Exception> responseJson = new HashMap();
        try {
            responseJson = this.releaseTrainService.linkPiItemsWithMilestones(requestBody);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            responseJson.put("kendisError", e);
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/getMilestonesStatuses"})
    @ResponseBody
    public ResponseEntity<Object> getMilestonesStatuses() {
        Map<String, Exception> responseJson = new HashMap();
        try {
            responseJson = this.releaseTrainService.getMilestonesStatuses();
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            responseJson.put("kendisError", e);
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/fetch-pi-items-linked-with-milestone"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchPiItemsLinkedWithMilestone(@RequestBody Map<String, Object> requestBody) {
        Map<String, Exception> responseJson = new HashMap();
        try {
            responseJson = this.releaseTrainService.fetchPiItemsLinkedWithMilestone(requestBody);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            responseJson.put("kendisError", e);
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/unlink-pi-items-linked-with-milestone"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> unlinkPiItemsLinkedWithMilestone(@RequestBody Map<String, Object> requestBody) {
        Map<String, Exception> responseJson = new HashMap();
        try {
            responseJson = this.releaseTrainService.unlinkPiItemsLinkedWithMilestone(requestBody);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            responseJson.put("kendisError", e);
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/delete-milestone-from-pi"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteMilestoneFromPi(@RequestBody Map<String, Object> requestBody) {
        Map<String, Exception> responseJson = new HashMap();
        try {
            responseJson = this.releaseTrainService.deleteMilestoneFromPi(requestBody);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            responseJson.put("kendisError", e);
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/backlog-item/get-attached-release-trains"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchAttachedReleaseTrains(@RequestBody String payload) {
        try {
            Map responseJson = null;
            Gson g = new Gson();
            66 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            responseJson = this.itemOperationsService.fetchAttachedReleaseTrains(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/searchFromALM"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> searchFromALM(@RequestBody String payload) {
        Map responseJson = null;
        try {
            Gson g = new Gson();
            67 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            responseJson = this.releaseTrainService.searchFromALM((Map)requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/gc/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveGroupConfig(@RequestBody GroupConfig groupConfig) {
        Map responseJson = null;
        try {
            responseJson = this.releaseTrainService.saveGroupConfig(groupConfig);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/gc/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteGroupConfig(@RequestBody String payload) {
        Map responseJson = null;
        try {
            Gson g = new Gson();
            68 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            responseJson = this.releaseTrainService.deleteGroupConfig((Map)requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get/items-by-ids"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getItemsByIds(@RequestBody Map<String, Object> requestJson) {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        try {
            List itemIds = (List)requestJson.get("itemIds");
            responseJson.put("items", this.itemFetchService.fetchBacklogItemsByIds(itemIds));
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/unlink-item-from-timeline"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> unlinkItemFromTimeline(@RequestBody String payload) {
        Map responseJson = null;
        try {
            Gson g = new Gson();
            69 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            responseJson = this.releaseTrainService.unlinkBacklogItemFromTimeline((Map)requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/save-milestone-date-history-tag"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveMilestoneDateHistoryTag(@RequestBody String payload) {
        Map responseJson = null;
        try {
            Gson g = new Gson();
            70 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            responseJson = this.releaseTrainService.saveMilestoneDateHistoryTags((Map)requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/batches/calculate-completion"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> calculateBatchCompletion(@RequestBody String payload) {
        Object responseJson = null;
        try {
            Gson g = new Gson();
            71 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Callable<Void> task = () -> {
                try {
                    String syncId = (String)requestBody.get("syncId");
                    Map result = this.batchesCalculationService.calculateBatchCompletion((Map)requestBody);
                    this.onBackgroundTaskCompleted(result, syncId, "CompletionCalculationCompleted");
                }
                catch (Exception e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
                return null;
            };
            Future<Void> future = executorService.submit(task);
            executorService.shutdown();
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/batches/calculate-bulk-completion"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> calculateBulkBatchCompletion(@RequestBody String payload) {
        Object responseJson = null;
        try {
            Gson g = new Gson();
            72 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Callable<Void> task = () -> {
                try {
                    String syncId = (String)requestBody.get("syncId");
                    Map result = this.batchesCalculationService.calculateBatchCompletionInBulk((Map)requestBody);
                    this.onBackgroundTaskCompleted(result, syncId, "CompletionCalculationCompleted");
                }
                catch (Exception e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
                return null;
            };
            Future<Void> future = executorService.submit(task);
            executorService.shutdown();
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/searchCollections"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> searchCollections(@RequestBody HashMap<String, Object> reqbody) {
        try {
            SecureUser secureUser = UserContextUtil.getUserContext();
            String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
            String searchQuery = (String)reqbody.get("query");
            Map result = this.releaseTrainService.searchCollections(searchQuery, tenant);
            if (((Boolean)result.get("success")).booleanValue()) {
                return new ResponseEntity((Object)result, HttpStatus.OK);
            }
            return new ResponseEntity((Object)result, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            LOGGER.error("Error in searchCollections controller: ", (Object)StringUtils.getTraceString((Throwable)e));
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("error", "Internal server error");
            return new ResponseEntity(errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/resolve-group-id-for-transition"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> resolveGroupIdForItemTransition(@RequestBody Map<String, String> request) {
        try {
            String itemId = request.get("itemId");
            String releaseTrainId = request.get("releaseTrainId");
            String targetState = request.get("targetState");
            String targetGroupBy = request.get("targetGroupBy");
            String boardId = request.get("boardId");
            if (itemId == null || releaseTrainId == null || targetState == null || targetGroupBy == null) {
                HashMap<String, Object> errorResponse = new HashMap<String, Object>();
                errorResponse.put("success", false);
                errorResponse.put("message", "Missing required parameters: itemId, releaseTrainId, targetState, targetGroupBy");
                return new ResponseEntity(errorResponse, HttpStatus.BAD_REQUEST);
            }
            Map result = this.itemFetchService.resolveGroupIdForItemTransition(itemId, releaseTrainId, targetState, targetGroupBy, boardId);
            if (((Boolean)result.get("success")).booleanValue()) {
                return new ResponseEntity((Object)result, HttpStatus.OK);
            }
            return new ResponseEntity((Object)result, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            LOGGER.error("Error in resolveGroupIdForItemTransition controller: ", (Object)StringUtils.getTraceString((Throwable)e));
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Internal server error: " + e.getMessage());
            return new ResponseEntity(errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/{id}/links/data"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveLinksMeta(@PathVariable(value="id") String id, @RequestBody String payload) {
        Object responseJson = null;
        boolean status = false;
        try {
            Gson g = new Gson();
            73 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            status = this.releaseTrainService.saveLinksMeta(id, (Map)requestBody);
            return new ResponseEntity((Object)status, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)status, HttpStatus.BAD_REQUEST);
        }
    }

    static /* synthetic */ ReleaseTrainService access$000(ReleaseTrainController x0) {
        return x0.releaseTrainService;
    }

    static /* synthetic */ RTItemOperationsService access$100(ReleaseTrainController x0) {
        return x0.itemOperationsService;
    }

    static /* synthetic */ void access$200(ReleaseTrainController x0, Map x1, String x2, String x3) {
        x0.onBackgroundTaskCompleted(x1, x2, x3);
    }

    static /* synthetic */ Logger access$300() {
        return LOGGER;
    }
}

