/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.google.gson.Gson;
import com.viztrend.safe.persistence.entity.Questionnaire;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.repository.QuestionnaireRepository;
import com.viztrend.safe.service.ConfidenceVoteSurveyService;
import com.viztrend.safe.utils.PropertyValidator;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RequestMapping(value={"/publicconfidencevotesurvey"})
@Controller
public class PublicConfidenceVoteController {
    @Autowired
    private ConfidenceVoteSurveyService confidenceVoteSurveyService;
    @Autowired
    private QuestionnaireRepository questionnaireRepository;

    @RequestMapping(value={"/{methodName}"}, method={RequestMethod.POST})
    public Object publicConfidenceVoteSurveyApi(@PathVariable(value="methodName") String methodName, @RequestBody HashMap<String, Object> requestParams) {
        Questionnaire questionnaire;
        Session session;
        Type paramMapType;
        String token;
        String decryptedToken;
        Gson gson;
        HashMap map;
        String questionnaireId = "";
        String questionId = "";
        String userId = "";
        HashMap answersPayload = new HashMap();
        if (PropertyValidator.isValid((Object)requestParams.get("vote")) && PropertyValidator.isValid((Object)(map = (HashMap)(gson = new Gson()).fromJson(decryptedToken = this.confidenceVoteSurveyService.decryptToken(token = (String)requestParams.get("vote")), paramMapType = new /* Unavailable Anonymous Inner Class!! */.getType())))) {
            questionnaireId = (String)map.get("id");
            questionId = (String)map.get("question");
            userId = (String)map.get("userId");
        }
        if (requestParams.containsKey("answers")) {
            answersPayload = (HashMap)requestParams.get("answers");
        }
        if (methodName.equals("verifyEmail")) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            if (!PropertyValidator.isValid((Object)questionId)) {
                boolean voteSubmission = this.confidenceVoteSurveyService.getAnswersByUser(questionnaireId, userId, null);
                response.put("voteSubmitted", voteSubmission);
            } else {
                boolean voteSubmission = this.confidenceVoteSurveyService.getAnswerForTeamByUser(questionId, userId);
                response.put("voteSubmitted", voteSubmission);
                response.put("questionId", questionId);
            }
            return new ResponseEntity(response, HttpStatus.OK);
        }
        if (methodName.equals("fetchSessionByConfidenceVote")) {
            session = this.confidenceVoteSurveyService.getSessionByConfidenceVoteId(questionnaireId);
            if (!PropertyValidator.isValid((Object)session)) {
                return new ResponseEntity(HttpStatus.NO_CONTENT);
            }
            HashMap<String, Object> sessionDTO = new HashMap<String, Object>();
            sessionDTO.put("id", session.getId());
            sessionDTO.put("title", session.getTitle());
            sessionDTO.put("confidenceVoteSurvey", session.getConfidenceVoteSurvey());
            return new ResponseEntity(sessionDTO, HttpStatus.OK);
        }
        if (methodName.equals("fetchSession")) {
            session = this.confidenceVoteSurveyService.getSessionByConfidenceVoteId(questionnaireId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            HashMap<String, Object> sessionDTO = new HashMap<String, Object>();
            if (PropertyValidator.isValid((Object)session)) {
                sessionDTO.put("id", session.getId());
                sessionDTO.put("title", session.getTitle());
                sessionDTO.put("confidenceVoteSurvey", session.getConfidenceVoteSurvey());
            }
            response.put("session", sessionDTO);
            if (PropertyValidator.isValid((Object)questionId)) {
                response.put("questionId", questionId);
            }
            return new ResponseEntity(response, HttpStatus.OK);
        }
        if (methodName.equals("fetchQuestions")) {
            List questionList = this.confidenceVoteSurveyService.getQuestionList(questionnaireId);
            List questionVOs = this.confidenceVoteSurveyService.convertQuestionToQuestionVO(questionList);
            return new ResponseEntity((Object)questionVOs, HttpStatus.OK);
        }
        if (methodName.equals("fetchAnswers")) {
            List answers = this.confidenceVoteSurveyService.getAnswers(questionnaireId, null);
            List answerVOs = this.confidenceVoteSurveyService.convertAnswerToAnswerVO(answers);
            return new ResponseEntity((Object)answerVOs, HttpStatus.OK);
        }
        if (methodName.equals("submitVote")) {
            questionnaire = this.questionnaireRepository.findById(questionnaireId);
            Map answersAndAnswerCounts = new HashMap();
            answersAndAnswerCounts = this.confidenceVoteSurveyService.saveVote(answersPayload, questionnaireId, questionnaire.getTenant());
            if (answersAndAnswerCounts.containsKey("error")) {
                return new ResponseEntity(HttpStatus.BAD_REQUEST);
            }
            return new ResponseEntity(answersAndAnswerCounts, HttpStatus.OK);
        }
        if (methodName.equals("fetchAnswerCount")) {
            Map answerCount = this.confidenceVoteSurveyService.getAnswersCount(questionnaireId, null);
            return new ResponseEntity((Object)answerCount, HttpStatus.OK);
        }
        if (methodName.equals("checkVoteSubmissionForTeam")) {
            boolean voteSubmission = this.confidenceVoteSurveyService.getAnswerForTeamByUser(questionId, userId);
            return new ResponseEntity((Object)voteSubmission, HttpStatus.OK);
        }
        if (methodName.equals("fetchQuestionnaire")) {
            questionnaire = this.confidenceVoteSurveyService.fetchQuestionnaire(questionnaireId);
            if (!PropertyValidator.isValid((Object)questionnaire)) {
                return new ResponseEntity(HttpStatus.NO_CONTENT);
            }
            return new ResponseEntity((Object)questionnaire, HttpStatus.OK);
        }
        if (methodName.equals("fetchTeams")) {
            session = this.confidenceVoteSurveyService.getSessionByConfidenceVoteId(questionnaireId);
            List teamList = this.confidenceVoteSurveyService.getTeams(session.getId());
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("teams", teamList);
            if (PropertyValidator.isValid((Object)questionId)) {
                response.put("questionId", questionId);
            }
            return new ResponseEntity(response, HttpStatus.OK);
        }
        return null;
    }
}

