/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.WriteResult;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.jira.ImportUtil;
import com.viztrend.safe.alm.jira.JiraUtils;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.alm.jira.bo.JiraField;
import com.viztrend.safe.alm.jira.bo.JiraFilter;
import com.viztrend.safe.alm.jira.bo.JiraIssueLinkType;
import com.viztrend.safe.alm.jira.bo.JiraSprint;
import com.viztrend.safe.alm.tfs.TFSBacklogMappingLinks;
import com.viztrend.safe.alm.tfs.TFSFilter;
import com.viztrend.safe.alm.tfs.TFSProject;
import com.viztrend.safe.alm.tfs.TFSTeamMapping;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.controller.KhufiaKari;
import com.viztrend.safe.controller.PlanController;
import com.viztrend.safe.enums.EnumFeatureConfigMeta;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.enums.EnumPermission;
import com.viztrend.safe.enums.EnumStatusCategory;
import com.viztrend.safe.exception.KendisException;
import com.viztrend.safe.persistence.entity.AlmAccUser;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.AlmError;
import com.viztrend.safe.persistence.entity.Answer;
import com.viztrend.safe.persistence.entity.AppInitConfig;
import com.viztrend.safe.persistence.entity.AuditLog;
import com.viztrend.safe.persistence.entity.BacklogMapping;
import com.viztrend.safe.persistence.entity.BacklogMappingLinks;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BoardFilter;
import com.viztrend.safe.persistence.entity.BoardSprints;
import com.viztrend.safe.persistence.entity.BoardTeam;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.CompanyFeatureMetaConfig;
import com.viztrend.safe.persistence.entity.Config;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.EpicFeature;
import com.viztrend.safe.persistence.entity.FeatureSetupProgress;
import com.viztrend.safe.persistence.entity.Group;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemJiraFieldMap;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.ItemLog;
import com.viztrend.safe.persistence.entity.ItemSyncMapper;
import com.viztrend.safe.persistence.entity.ItemTypeScheme;
import com.viztrend.safe.persistence.entity.JiraProjectIssueTypes;
import com.viztrend.safe.persistence.entity.KendisStats;
import com.viztrend.safe.persistence.entity.ObjectiveCustomView;
import com.viztrend.safe.persistence.entity.PaymentPackageConfig;
import com.viztrend.safe.persistence.entity.PiAgenda;
import com.viztrend.safe.persistence.entity.PiAgendaDay;
import com.viztrend.safe.persistence.entity.PiContainerCapacity;
import com.viztrend.safe.persistence.entity.PiDay;
import com.viztrend.safe.persistence.entity.PiJourney;
import com.viztrend.safe.persistence.entity.PiJourneyEvent;
import com.viztrend.safe.persistence.entity.PiProgramRole;
import com.viztrend.safe.persistence.entity.PiSite;
import com.viztrend.safe.persistence.entity.PiSos;
import com.viztrend.safe.persistence.entity.PiTeamCapacity;
import com.viztrend.safe.persistence.entity.PiUserCapacity;
import com.viztrend.safe.persistence.entity.PushResponse;
import com.viztrend.safe.persistence.entity.Question;
import com.viztrend.safe.persistence.entity.ResponseSequence;
import com.viztrend.safe.persistence.entity.Risk;
import com.viztrend.safe.persistence.entity.Role;
import com.viztrend.safe.persistence.entity.ScoreCard;
import com.viztrend.safe.persistence.entity.ScoreParam;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.SolutionArea;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.entity.Sprint;
import com.viztrend.safe.persistence.entity.State;
import com.viztrend.safe.persistence.entity.StateCategory;
import com.viztrend.safe.persistence.entity.StateScheme;
import com.viztrend.safe.persistence.entity.StatsExclusion;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.TFSAlmConfigurations;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.TeamSprintDependencyLimit;
import com.viztrend.safe.persistence.entity.TeamSprintVelocity;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserBoardLocation;
import com.viztrend.safe.persistence.entity.UserBoardPreferences;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.Watcher;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkFlowItemType;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.WorkSpaceAccessRole;
import com.viztrend.safe.persistence.entity.WsjfFilterCriteria;
import com.viztrend.safe.persistence.entity.dto.LdapUser;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.AlmConfigurationsRepository;
import com.viztrend.safe.persistence.repository.AlmErrorRepository;
import com.viztrend.safe.persistence.repository.AlmInfoRepository;
import com.viztrend.safe.persistence.repository.AnswerRepository;
import com.viztrend.safe.persistence.repository.AppInitConfigRepository;
import com.viztrend.safe.persistence.repository.AuditLogRepository;
import com.viztrend.safe.persistence.repository.CompanyFeatureMetaConfigRepository;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.ConfigRepository;
import com.viztrend.safe.persistence.repository.ContainerRepository;
import com.viztrend.safe.persistence.repository.ConversationRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.EpicFeaturesRepository;
import com.viztrend.safe.persistence.repository.FeatureSetupProgressRepository;
import com.viztrend.safe.persistence.repository.GroupRepository;
import com.viztrend.safe.persistence.repository.IssueTypeRepository;
import com.viztrend.safe.persistence.repository.ItemJiraDependencyRepository;
import com.viztrend.safe.persistence.repository.ItemLinkRepository;
import com.viztrend.safe.persistence.repository.ItemLinkTypeRepository;
import com.viztrend.safe.persistence.repository.ItemLogRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.ItemSyncMapperRepository;
import com.viztrend.safe.persistence.repository.ItemTypeRepository;
import com.viztrend.safe.persistence.repository.JiraFieldRepository;
import com.viztrend.safe.persistence.repository.JiraIssueLinkTypeRepository;
import com.viztrend.safe.persistence.repository.JiraIssueRepository;
import com.viztrend.safe.persistence.repository.JiraProjectIssueTypesRepository;
import com.viztrend.safe.persistence.repository.KendisStatsRepository;
import com.viztrend.safe.persistence.repository.NotificationRepository;
import com.viztrend.safe.persistence.repository.PiAgendaDayRepository;
import com.viztrend.safe.persistence.repository.PiAgendaRepository;
import com.viztrend.safe.persistence.repository.PiDayRepository;
import com.viztrend.safe.persistence.repository.PiJourneyEventRepository;
import com.viztrend.safe.persistence.repository.PiJourneyRepository;
import com.viztrend.safe.persistence.repository.PiProgramRoleRepository;
import com.viztrend.safe.persistence.repository.PiSiteRepository;
import com.viztrend.safe.persistence.repository.PiSosRepository;
import com.viztrend.safe.persistence.repository.PiTeamBreakoutRepository;
import com.viztrend.safe.persistence.repository.PiTeamCapacityRepository;
import com.viztrend.safe.persistence.repository.PiUserCapacityRepository;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.QuestionRepository;
import com.viztrend.safe.persistence.repository.ReportRepository;
import com.viztrend.safe.persistence.repository.RiskRepository;
import com.viztrend.safe.persistence.repository.RoleRepository;
import com.viztrend.safe.persistence.repository.ScoreCardRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.SolutionBoardRepository;
import com.viztrend.safe.persistence.repository.SprintRepository;
import com.viztrend.safe.persistence.repository.StateCategoryRepository;
import com.viztrend.safe.persistence.repository.StateRepository;
import com.viztrend.safe.persistence.repository.StateSchemeRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TFSAlmConfigurationsRepository;
import com.viztrend.safe.persistence.repository.TFSFilterRepository;
import com.viztrend.safe.persistence.repository.TFSProjectRepository;
import com.viztrend.safe.persistence.repository.TeamContainerRepository;
import com.viztrend.safe.persistence.repository.TeamRepository;
import com.viztrend.safe.persistence.repository.TeamSprintDependencyLimitRepository;
import com.viztrend.safe.persistence.repository.TeamSprintVelocityRepository;
import com.viztrend.safe.persistence.repository.UserApiKeyRepository;
import com.viztrend.safe.persistence.repository.UserBoardPreferenceRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WorkFlowItemTypeRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceAccessRoleRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.persistence.repository.WsjfFilterCriteriaRepository;
import com.viztrend.safe.service.ALMSyncService;
import com.viztrend.safe.service.CustomFieldService;
import com.viztrend.safe.service.ExportService;
import com.viztrend.safe.service.ExternalEntitiesService;
import com.viztrend.safe.service.JiraSyncServiceImpl;
import com.viztrend.safe.service.NotificationService;
import com.viztrend.safe.service.PiJourneyBoardService;
import com.viztrend.safe.service.PiJourneyService;
import com.viztrend.safe.service.PlanService;
import com.viztrend.safe.service.ReleaseTrainService;
import com.viztrend.safe.service.ScoreCardService;
import com.viztrend.safe.service.SolutionService;
import com.viztrend.safe.service.TFSservice;
import com.viztrend.safe.service.TimeCapsuleService;
import com.viztrend.safe.service.UserService;
import com.viztrend.safe.service.WebHookSyncService;
import com.viztrend.safe.service.WorkSpaceTypeService;
import com.viztrend.safe.strategy.PushInclusionStrategy;
import com.viztrend.safe.utils.AlmErrorUtils;
import com.viztrend.safe.utils.AlmUtils;
import com.viztrend.safe.utils.DateUtils;
import com.viztrend.safe.utils.EncDecUtility;
import com.viztrend.safe.utils.IntercommUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.LocalMailSender;
import com.viztrend.safe.utils.MongoSyncUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.SystemUtil;
import com.viztrend.safe.utils.SystemVarsUtils;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.JiraConnectVO;
import com.viztrend.safe.vos.ResyncParamsVO;
import com.viztrend.safe.vos.SearchVO;
import com.viztrend.safe.vos.SessionBoardVo;
import com.viztrend.safe.vos.WebhookResponseVO;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.bson.types.ObjectId;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/plan"})
@RestController
public class PlanController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlanController.class);
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private AuditLogRepository auditLogRepository;
    @Autowired
    private WorkSpaceAccessRoleRepository accessRoleRepository;
    @Autowired
    private StateCategoryRepository stateCategoryRepository;
    @Autowired
    private StateRepository stateRepository;
    @Autowired
    private TFSProjectRepository tfsProjectRepository;
    @Autowired
    private TFSFilterRepository tfsFilterRepository;
    @Autowired
    private WorkFlowItemTypeRepository workFlowItemTypeRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private ScoreCardRepository scoreCardRepository;
    @Autowired
    private WsjfFilterCriteriaRepository wsjfFilterCriteriaRepository;
    @Autowired
    private WorkFlowRepository workFlowRepository;
    @Autowired
    private StateSchemeRepository stateSchemeRepository;
    @Autowired
    private ItemTypeRepository itemTypeRepository;
    @Autowired
    private ItemLinkRepository itemLinkRepository;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private KendisStatsRepository kendisStatsRepository;
    @Autowired
    private PiJourneyService piJourneyService;
    @Autowired
    private RiskRepository riskRepository;
    @Autowired
    private TeamRepository teamRepository;
    @Autowired
    private ConversationRepository conversationRepository;
    @Autowired
    private AppConfig.MongoConfig mongoConfig;
    @Autowired
    private JiraProjectIssueTypesRepository jiraProjectIssueTypesRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private TeamSprintVelocityRepository teamSprintVelocityRepository;
    @Autowired
    private TeamSprintDependencyLimitRepository TeamSprintDependencyLimitRepository;
    @Autowired
    private WebHookSyncService webHookSyncService;
    @Autowired
    private TeamContainerRepository teamContainerRepository;
    @Autowired
    private SprintRepository sprintRepository;
    @Autowired
    private PlanService planService;
    @Autowired
    private PushResponseRepository pushResponseRepository;
    @Autowired
    private ItemLogRepository itemLogRepository;
    @Autowired
    private ExportService exportService;
    @Autowired
    ALMSyncService aLMSyncService;
    @Autowired
    JiraIssueLinkTypeRepository jiraIssueLinkTypeRepository;
    @Autowired
    private CustomRepository<Object> customRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private WorkSpaceAccessRoleRepository workSpaceAccessRoleRepository;
    @Autowired
    RoleRepository roleRepository;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    private ALMSyncService almSyncService;
    @Autowired
    private TFSservice tfSservice;
    @Autowired
    private NotificationRepository notificationRepository;
    @Autowired
    private ItemSyncMapperRepository itemSyncMapperRepository;
    @Autowired
    private LocalMailSender mailSender;
    @Autowired
    private ConfigRepository configRepository;
    @Autowired
    private AlmConfigurationsRepository almConfigurationsRepository;
    @Autowired
    private TFSAlmConfigurationsRepository tfsAlmConfigurationsRepository;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private AlmErrorRepository almErrorRepository;
    @Autowired
    private AlmInfoRepository almInfoRepository;
    @Autowired
    private JiraFieldRepository jiraFieldRepository;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private JiraIssueRepository jiraIssueRepository;
    @Autowired
    private IssueTypeRepository issueTypeRepository;
    @Autowired
    private ReportRepository reportRepository;
    @Autowired
    private ItemJiraDependencyRepository itemJiraDependencyRepository;
    @Autowired
    private EpicFeaturesRepository epicFeaturesRepository;
    @Autowired
    private SolutionService solutionService;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private Environment env;
    @Autowired
    private TFSUtils tfsUtils;
    @Autowired
    private PiJourneyBoardService piJourneyBoardService;
    @Autowired
    private CompanyFeatureMetaConfigRepository companyFeatureMetaConfigRepository;
    @Autowired
    private SolutionBoardRepository solutionBoardRepository;
    @Autowired
    AppInitConfigRepository appInitConfigRepository;
    @Autowired
    private ExternalEntitiesService externalEntitiesService;
    @Autowired
    FeatureSetupProgressRepository featureSetupProgressRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private UserBoardPreferenceRepository userBoardPreferenceRepository;
    @Autowired
    private PiAgendaRepository piAgendaRepository;
    @Autowired
    private PiProgramRoleRepository piProgramRoleRepository;
    @Autowired
    private PiTeamBreakoutRepository piTeamBreakoutRepository;
    @Autowired
    private PiSosRepository piSosRepository;
    @Autowired
    private PiJourneyRepository piJourneyRepository;
    @Autowired
    private QuestionRepository questionRepository;
    @Autowired
    private PiAgendaDayRepository piAgendaDayRepository;
    @Autowired
    private PiJourneyEventRepository piJourneyEventRepository;
    @Autowired
    private PiDayRepository piDayRepository;
    @Autowired
    private PiTeamCapacityRepository piTeamCapacityRepository;
    @Autowired
    private PiUserCapacityRepository piUserCapacityRepository;
    @Autowired
    private ItemLinkTypeRepository itemLinkTypeRepository;
    @Autowired
    private PiSiteRepository piSiteRepository;
    @Autowired
    private AnswerRepository answerRepository;
    @Autowired
    private ImportUtil importUtil;
    @Autowired
    private WorkSpaceTypeService workSpaceTypeService;
    @Autowired
    private UserApiKeyRepository userApiKeyRepository;
    @Autowired
    private TimeCapsuleService timeCapsuleService;
    @Autowired
    private ScoreCardService scoreCardService;
    @Autowired
    private ReleaseTrainService releaseTrainService;
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private JiraSyncServiceImpl jiraSyncServiceImpl;
    protected Item savedItem = null;
    protected Item item = null;
    @Autowired
    private CompanyRepository companyRepository;

    @RequestMapping(value={"backlog/items"})
    public List<Item> getItems() {
        return this.itemRepository.findAll();
    }

    @RequestMapping(value={"states"})
    public List<State> getStates() {
        return this.stateRepository.findAll();
    }

    private WorkFlow getDefaultWorkFlow() {
        return this.planService.getDefaultWorkFlow();
    }

    private StateScheme getDefaultStateScheme() {
        StateScheme defaultStateScheme = this.stateSchemeRepository.findByIsDefaultIsTrue();
        return defaultStateScheme;
    }

    private SessionBoard saveSessionBoard(SessionBoardVo sBVo) {
        SessionBoard sessionBoard = new SessionBoard();
        if (PropertyValidator.isValid((Object)sBVo.getId())) {
            LOGGER.trace("Going to update board. " + sBVo);
            sessionBoard = this.planService.editSessionBoard(sBVo);
        } else {
            Session sessionWrapper = new Session();
            sessionWrapper.setTitle(sBVo.getTitle());
            sessionWrapper.setJiraBaseURL(sBVo.getJiraBaseURL());
            sessionWrapper.setAlmEnabled(sBVo.getAlmEnabled());
            sessionWrapper.setUseEnabler(sBVo.getUseEnabler());
            if (PropertyValidator.isValid((Object)sBVo.getUseEnabler()) && PropertyValidator.isValid((Object)sBVo.getEnablerColor())) {
                sessionWrapper.setEnablerColor(sBVo.getEnablerColor());
            }
            sessionWrapper.setParentItem(sBVo.getParentItem());
            sessionWrapper.setChildItem(sBVo.getChildItem());
            sessionWrapper.setEnablerItem(sBVo.getEnablerItem());
            sessionWrapper.setWorkSpace(new WorkSpace(sBVo.getWorkSpaceId()));
            sessionWrapper.setJiraContainer(sBVo.getJiraContainer());
            if (Boolean.TRUE.equals(sBVo.getAlmEnabled())) {
                if (((AlmConfigurations)sBVo.getAlmConfigurations().get(0)).getAlmAccount().isUsingJiraConnect()) {
                    JiraConnectVO connectVO = this.almSyncService.getConnectAccount(((AlmConfigurations)sBVo.getAlmConfigurations().get(0)).getAlmAccount().getAtlassianHostDomainId());
                    if (PropertyValidator.isValid((Object)connectVO) && PropertyValidator.isValid((Object)connectVO.getJiraHostUrl())) {
                        sessionWrapper.setJiraBaseURL(AlmUtils.getJiraBrowseURL((String)connectVO.getJiraHostUrl()));
                    } else {
                        LOGGER.error("You should never see this.");
                    }
                } else {
                    sessionWrapper.setJiraBaseURL(AlmUtils.getJiraBrowseURL((String)((AlmConfigurations)sBVo.getAlmConfigurations().get(0)).getAlmAccount().getUrl()));
                }
            } else {
                sessionWrapper.setJiraBaseURL(sBVo.getJiraBaseURL());
            }
            sessionWrapper.setItemWorkFlow(new WorkFlow(sBVo.getItemWorkFlowId()));
            sessionWrapper.setSubItemWorkFlow(new WorkFlow(sBVo.getSubItemWorkFlowId()));
            sessionWrapper.setStateScheme(this.getDefaultStateScheme());
            State draftState = this.stateRepository.findByTitle("Draft");
            LOGGER.info("saveBoard --> draftState: " + draftState.toString());
            sessionBoard.setState(draftState);
            sessionBoard.setCreationDate(new Date());
            sessionBoard.setSuspendActivity(true);
            if (sBVo.getAlmEnabled().booleanValue()) {
                sBVo.setTeams(this.planService.saveTeamsWithSprints(sBVo.getTeams(), (AlmConfigurations)sBVo.getAlmConfigurations().get(0), null));
                sBVo.setAlmConfigurations(this.almSyncService.saveAlmConfigurations(sBVo.getAlmConfigurations()));
                sessionWrapper.setAlmConfigurations(sBVo.getAlmConfigurations());
                sessionBoard.setTeams(sBVo.getTeams());
                sessionWrapper = (Session)this.sessionRepository.save((Object)sessionWrapper);
                sessionBoard.setSession(sessionWrapper);
                LOGGER.info("saveBoard --> state to save : " + sessionBoard.getState().toString());
                sessionBoard = (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard);
                sBVo.setId(sessionBoard.getId());
                LOGGER.info("BEFORE Going to fetch ALL DATA");
                this.jiraIssueRepository.deleteBySessionBoardIdAndConvertedToItem(sessionBoard.getId(), Boolean.valueOf(false));
                HashSet featuresAlreadyProcessed = new HashSet();
                this.planService.saveItemSyncMappers(sBVo, (AlmConfigurations)sBVo.getAlmConfigurations().get(0), sessionBoard);
            } else {
                sessionWrapper = (Session)this.sessionRepository.save((Object)sessionWrapper);
                sessionBoard.setSession(sessionWrapper);
                sessionBoard.setTeams(this.planService.saveTeamsWithSprints(sBVo.getTeams(), null, null));
                if (PropertyValidator.isValid((Collection)sBVo.getContainers())) {
                    for (Container cont : sBVo.getContainers()) {
                        cont.setSuspendActivity(true);
                    }
                }
                sessionBoard.setContainers(this.containerRepository.save((Iterable)sBVo.getContainers()));
                sessionBoard = (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard);
            }
        }
        if (sBVo.getAlmEnabled().booleanValue() && PropertyValidator.isValid((Object)sessionBoard.getId()) && !Boolean.TRUE.equals(sBVo.getIsWebhookExist())) {
            try {
                AlmAccount almAcc = AlmUtils.getALMAcount((String)((AlmConfigurations)sBVo.getAlmConfigurations().get(0)).getAlmAccount().getId(), (AlmAccountRepository)this.almAccountRepository);
                String webhook = this.webHookSyncService.createWebhook(sBVo.getKendisBaseURL(), almAcc);
                Gson gson = new Gson();
                1 T = new /* Unavailable Anonymous Inner Class!! */;
                HashMap paramMap = (HashMap)gson.fromJson(webhook, T.getType());
                String jiraWebhookURL = (String)paramMap.get("self");
                ((AlmConfigurations)sBVo.getAlmConfigurations().get(0)).getAlmAccount().setWebhookURL(jiraWebhookURL);
                this.customRepositoryImpl.getMongoTemplate().save((Object)((AlmConfigurations)sBVo.getAlmConfigurations().get(0)).getAlmAccount());
            }
            catch (ViztrendJiraException e) {
                SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
                LOGGER.error("FAILED: Creating Webhook. " + e.getMessage() + "\n " + e.getAlmError());
                this.almErrorRepository.save((Object)AlmErrorUtils.buildAlmErrorObj(null, (String)sessionBoard.getId(), (User)user, (ViztrendJiraException)e, (Boolean)false));
            }
        }
        this.customRepository.updateActiveSessionBoard(sessionBoard.getSession().getId(), sessionBoard.getId());
        JSONObject pushJson = new JSONObject();
        try {
            pushJson.put("type", (Object)"Board");
            pushJson.put("id", (Object)sessionBoard.getId());
            pushJson.put("push", (Object)"Self");
            pushJson.put("metaMap", (Object)("{\"event\":\"Save\", \"boardId\":\"" + sessionBoard.getId() + "\", \"syncId\":\"" + sBVo.getSyncId() + "\"}"));
            PushSender.sendMsg((String)pushJson.toString());
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return sessionBoard;
    }

    @RequestMapping(value={"/team/items"})
    public List<Item> getTeamItems(@RequestBody Item item) {
        return this.itemRepository.findBySessionBoardsAndTeamContainersIn(item.getSessionBoards(), item.getTeamContainers());
    }

    @RequestMapping(value={"/item/{id}"})
    public Item getItem(@PathVariable(value="id") String id) {
        return (Item)this.itemRepository.findOne((Serializable)((Object)id));
    }

    @RequestMapping(value={"/item-fields/{id}"})
    public Item getItemFields(@PathVariable(value="id") String id) {
        return this.itemRepository.findItemFieldsById(id);
    }

    @RequestMapping(value={"/remove-bulk"})
    @ResponseBody
    public ResponseEntity<Object> removeItem(@RequestBody Map<String, Object> request) {
        HashMap<String, Serializable> responseJson = new HashMap<String, Serializable>();
        try {
            List ids = (List)request.get("ids");
            List removed = this.itemRepository.deleteByIdIn((Collection)ids);
            if (PropertyValidator.isValid((Collection)removed)) {
                responseJson.put("success", Boolean.valueOf(true));
            }
        }
        catch (Exception e) {
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error(err);
            responseJson.put("kendisError", e);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/remove/item"})
    @ResponseBody
    public ResponseEntity<Object> removeItem(HttpServletRequest request, @RequestBody Item itemToRemove) {
        List itemLinks = null;
        User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
        String metaMap = itemToRemove.getMetaMap();
        if (PropertyValidator.isValid((Object)(itemToRemove = this.itemRepository.findById(itemToRemove.getId())).getType()) && itemToRemove.getType().equals("Feature")) {
            if (PropertyValidator.isValid((Collection)itemToRemove.getTeamContainers())) {
                ArrayList<String> tcIds = new ArrayList<String>();
                for (Object tc : itemToRemove.getTeamContainers()) {
                    if (tc == null) continue;
                    tcIds.add(tc.getId());
                }
                itemLinks = this.itemLinkRepository.findBySourceTeamContainerIdInOrTargetTeamContainerIdIn(tcIds, tcIds);
                if (PropertyValidator.isValid((Collection)itemLinks)) {
                    KendisUtils.archiveItemLinks((ItemLinkRepository)this.itemLinkRepository, (List)itemLinks);
                    List itemsNeedToUpdated = this.itemRepository.findByItemLinksIn(itemLinks);
                    if (PropertyValidator.isValid((Collection)itemsNeedToUpdated)) {
                        Object tc;
                        tc = itemsNeedToUpdated.iterator();
                        while (tc.hasNext()) {
                            Item item2 = (Item)tc.next();
                            item2.getItemLinks().removeAll(itemLinks);
                        }
                        this.itemRepository.save((Iterable)itemsNeedToUpdated);
                    }
                }
            }
            this.customRepository.updateAlmErrorFlag(itemToRemove.getId(), false);
            this.almErrorRepository.deleteByItemId(itemToRemove.getId());
            this.customRepository.setBulkArchiveUserStoriesByParent(itemToRemove, true);
        } else {
            List linkedItems;
            itemLinks = this.itemLinkRepository.findByTargetUserStoryIdOrSourceUserStoryId((itemToRemove = (Item)this.itemRepository.findOne((Serializable)((Object)itemToRemove.getId()))).getId(), itemToRemove.getId());
            if (PropertyValidator.isValid((Collection)itemLinks) && PropertyValidator.isValid((Collection)(linkedItems = this.itemRepository.findByItemLinksIn(itemLinks)))) {
                for (Item linkedItem : linkedItems) {
                    linkedItem.getItemLinks().removeAll(itemLinks);
                }
                this.itemRepository.save((Iterable)linkedItems);
            }
            itemToRemove.setErrorInAlmSync(Boolean.FALSE);
            this.almErrorRepository.deleteByItemId(itemToRemove.getId());
            this.item = itemToRemove;
            this.item.setMetaMap(metaMap);
            LOGGER.debug("removeItem " + this.item);
            if (PropertyValidator.isValid((Object)itemToRemove.getJiraId())) {
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            }
        }
        itemToRemove.setMetaMap(metaMap);
        itemToRemove.setArchive(true);
        if (PropertyValidator.isValid((Object)itemToRemove.getKendisId())) {
            this.releaseTrainService.unlinkBacklogItemFromPi(itemToRemove, "delete".equals(request.getParameter("action")));
        }
        this.itemRepository.save((Object)itemToRemove);
        if (!itemToRemove.getType().equals("Feature") && PropertyValidator.isValid((Object)itemToRemove.getParent().getId())) {
            List childItems = this.itemRepository.findByParentId(itemToRemove.getParent().getId());
            Double totalEstimate = 0.0;
            for (Item childItem : childItems) {
                totalEstimate = totalEstimate + childItem.getStoryPoints();
            }
            this.customRepository.updateItemStoryPoints(itemToRemove.getParent().getId(), totalEstimate);
        }
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("success", true);
        responseJson.put("item", itemToRemove);
        responseJson.put("itemLinks", itemLinks);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(path={"/item-dates"})
    @ResponseBody
    public ResponseEntity<Object> applySprintDates(@RequestBody Item sampleIem) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            sampleIem.applySprintDates(((SessionBoard)sampleIem.getSessionBoards().get(0)).getSession(), null, null);
            responseJson.put("item", sampleIem);
        }
        catch (Exception e) {
            LOGGER.error("Inside : count not upadate item --> " + StringUtils.getTraceString((Throwable)e));
            responseJson.put("kendisError", e);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @ResponseBody
    private ResponseEntity<Object> saveWithTeamContainer(Item savedCopy, Item oldItem, @PathVariable(value="optional") Optional<String> optional, HttpServletRequest request) {
        Item item;
        ResponseEntity responseItem;
        HashMap response;
        savedCopy.setMetaMap(oldItem.getMetaMap());
        if (PropertyValidator.isValid((Object)oldItem.getRecoveryItemLinkId())) {
            savedCopy.setRecoveryItemLinkId(oldItem.getRecoveryItemLinkId());
        }
        savedCopy.setJiraFieldMap(oldItem.getJiraFieldMap());
        if (PropertyValidator.isValid((Collection)oldItem.getTeamContainers())) {
            Container container;
            savedCopy.setTeamContainers(oldItem.getTeamContainers());
            if (PropertyValidator.isValid((Collection)savedCopy.getTeamContainers()) && PropertyValidator.isValid((Object)((TeamContainer)savedCopy.getTeamContainers().get(0)).getContainer()) && PropertyValidator.isValid((Object)(container = (Container)this.containerRepository.findOne((Serializable)((Object)((TeamContainer)savedCopy.getTeamContainers().get(0)).getContainer().getId()))))) {
                ((TeamContainer)savedCopy.getTeamContainers().get(0)).setContainer(container);
            }
        }
        if ((response = (HashMap)(responseItem = this.saveItems(optional, savedCopy, request)).getBody()) != null && !Boolean.TRUE.equals((item = (Item)response.get("item")).getLastUpdatedValue("TC_IN_LINKS"))) {
            this.planService.updateTcInLinksOnChangeCell(item);
        }
        return responseItem;
    }

    @RequestMapping(path={"/update/item", "/update/item/{optional}"})
    @ResponseBody
    public ResponseEntity<Object> saveItemInline(@PathVariable(value="optional") Optional<String> optional, @RequestBody Item oldItem, HttpServletRequest request) {
        try {
            Item savedCopy = (Item)this.itemRepository.findOne((Serializable)((Object)oldItem.getId()));
            if (PropertyValidator.isValid((Object)savedCopy)) {
                savedCopy.setMetaMap(oldItem.getMetaMap());
                if (oldItem.getJiraKey() != null) {
                    savedCopy.setJiraKey(oldItem.getJiraKey());
                }
                if (oldItem.getKendisKey() != null) {
                    savedCopy.setKendisKey(oldItem.getKendisKey());
                }
                if (oldItem.getExternalReferenceURL() != null) {
                    savedCopy.setExternalReferenceURL(oldItem.getExternalReferenceURL());
                }
                if (PropertyValidator.isValid((Object)oldItem.getTitle())) {
                    savedCopy.setTitle(oldItem.getTitle());
                }
                if (PropertyValidator.isValid((Object)oldItem.getStoryPoints())) {
                    savedCopy.setStoryPoints(oldItem.getStoryPoints());
                }
                if (PropertyValidator.isValid((Object)oldItem.getStoryPointsValue())) {
                    savedCopy.setStoryPointsValue(oldItem.getStoryPointsValue());
                }
                if (PropertyValidator.isValid((Object)oldItem.getStatus())) {
                    savedCopy.setStatus(oldItem.getStatus());
                }
                if (PropertyValidator.isValid((Object)oldItem.getStartDate())) {
                    savedCopy.setStartDate(oldItem.getStartDate());
                }
                if (PropertyValidator.isValid((Object)oldItem.getStartDate())) {
                    savedCopy.setStartDate(oldItem.getStartDate());
                }
                if (PropertyValidator.isValid((Object)oldItem.getEndDate())) {
                    savedCopy.setEndDate(oldItem.getEndDate());
                }
                if (PropertyValidator.isValid((Object)oldItem.getDueDate())) {
                    savedCopy.setDueDate(oldItem.getDueDate());
                }
                if (PropertyValidator.isValid((Object)oldItem.getFields())) {
                    savedCopy.setFields(oldItem.getFields());
                }
                if (Boolean.TRUE.equals(oldItem.getLastUpdatedValue("noStartEndDate"))) {
                    savedCopy.setEndDate(oldItem.getEndDate());
                    savedCopy.setStartDate(oldItem.getStartDate());
                }
                if (Boolean.TRUE.equals(oldItem.getLastUpdatedValue("noDueDate"))) {
                    savedCopy.setDueDate(oldItem.getDueDate());
                }
                return this.saveWithTeamContainer(savedCopy, oldItem, optional, request);
            }
            return null;
        }
        catch (Exception e) {
            Gson gson = new Gson();
            LOGGER.error("Item json : " + gson.toJson((Object)oldItem));
            LOGGER.error("Inside : count not upadate item --> " + StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    @RequestMapping(path={"/save/story", "/save/story/{optional}"})
    @ResponseBody
    public ResponseEntity<Object> saveUSerStory(@PathVariable(value="optional") Optional<String> optional, @RequestBody Item oldItem, HttpServletRequest request) {
        try {
            Item item1 = (Item)this.itemRepository.findOne((Serializable)((Object)oldItem.getId()));
            if (PropertyValidator.isValid((Object)item1)) {
                return this.saveWithTeamContainer(item1, oldItem, optional, request);
            }
            return null;
        }
        catch (Exception e) {
            Gson gson = new Gson();
            LOGGER.error("Item json : " + gson.toJson((Object)oldItem));
            LOGGER.error("Inside : count not save User Story --> " + StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    @RequestMapping(value={"/save/item"})
    @ResponseBody
    public ResponseEntity<Object> saveItems(@PathVariable(value="optional") Optional<String> optional, @RequestBody Item item1, HttpServletRequest request) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            SessionBoard sessionBoard;
            this.item = item1;
            boolean editMode = false;
            boolean updateInJira = true;
            Status oldStatus = null;
            if (PropertyValidator.isValid((Collection)item1.getItemLinks())) {
                List itemLinks = this.itemLinkRepository.save((Iterable)item1.getItemLinks());
                item1.setItemLinks(itemLinks);
            }
            if (PropertyValidator.isValid((Object)(sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)((SessionBoard)item1.getSessionBoards().get(0)).getId()))))) {
                item1.getSessionBoards().set(0, sessionBoard);
            }
            List tcOLD = null;
            List tcNew = item1.getTeamContainers();
            if ("null".equals(item1.getStoryPointsValue())) {
                item1.setStoryPoints(null);
            }
            if (item1.getId() != null) {
                Item oldItem = (Item)this.itemRepository.findOne((Serializable)((Object)item1.getId()));
                this.savedItem = (Item)this.itemRepository.findOne((Serializable)((Object)item1.getId()));
                oldItem.setTitle(item1.getTitle());
                oldItem.setExternalReferenceURL(item1.getExternalReferenceURL());
                if (oldItem.getKendisId() == null) {
                    oldItem.setJiraKey(item1.getJiraKey());
                    oldItem.setKendisKey(item1.getKendisKey());
                }
                oldItem.setStoryPoints(item1.getStoryPoints());
                oldItem.setDueDate(item1.getDueDate());
                oldItem.setIsEnabler(item1.getIsEnabler());
                oldStatus = oldItem.getStatus();
                oldItem.setStatus(item1.getStatus());
                oldItem.setJiraIssueTypeId(item1.getJiraIssueTypeId());
                oldItem.setJiraProjectKey(item1.getJiraProjectKey());
                oldItem.setMetaMap(item1.getMetaMap());
                oldItem.setIssueType(item1.getIssueType());
                oldItem.setErrorInAlmSync(Boolean.FALSE);
                oldItem.setFlagged(item1.getFlagged());
                oldItem.setStartDate(item1.getStartDate());
                oldItem.setEndDate(item1.getEndDate());
                if (PropertyValidator.isValid((Collection)item1.getJiraFieldMap())) {
                    oldItem.setJiraFieldMap(item1.getJiraFieldMap());
                } else {
                    oldItem.setJiraFieldMap(null);
                }
                if (PropertyValidator.isValid((Object)item1.getRecoveryItemLinkId())) {
                    if (!PropertyValidator.isValid((Collection)oldItem.getItemLinks())) {
                        oldItem.setItemLinks(new ArrayList());
                    }
                    oldItem.getItemLinks().add(new ItemLink(item1.getRecoveryItemLinkId()));
                }
                if (PropertyValidator.isValid((Object)item1.getFields())) {
                    oldItem.setFields(item1.getFields());
                }
                item1 = oldItem;
                editMode = true;
            }
            AlmAccount almAccount = null;
            3 emptyCards = null;
            if (Item.USER_STORY.equals(item1.getType())) {
                List ssp;
                Map changed = this.changeStoryTeamContainer(item1, tcOLD, tcNew, optional);
                if (Boolean.TRUE.equals(changed.get("sprint"))) {
                    Date sDate = item1.getStartDate();
                    Date eDate = item1.getEndDate();
                    if (request.getRequestURL().indexOf("/save/story") > -1) {
                        sDate = null;
                        eDate = null;
                    }
                    item1.applySprintDates(sessionBoard.getSession(), sDate, eDate);
                }
                if ((Boolean.TRUE.equals(changed.get("team")) || !editMode && PropertyValidator.isValid((Object)item1.getTeam())) && PropertyValidator.isValid((Collection)tcNew) && PropertyValidator.isValid(tcNew.get(0)) && PropertyValidator.isValid((Collection)(ssp = this.planService.getSharedSprintValue(sessionBoard, (TeamContainer)tcNew.get(0))))) {
                    if (!PropertyValidator.isValid((Collection)item1.getJiraFieldMap())) {
                        item1.setJiraFieldMap(new ArrayList());
                    }
                    item1.getJiraFieldMap().addAll(ssp);
                    updateInJira = true;
                }
                if (editMode) {
                    emptyCards = new /* Unavailable Anonymous Inner Class!! */;
                }
            } else if (item1.getId() != null && "nexus".equals(sessionBoard.getSession().getSessionType())) {
                this.changeFeatureTeamContainer(item1, tcOLD, tcNew);
            }
            if (!editMode && Boolean.TRUE.equals(sessionBoard.getSession().getAlmEnabled())) {
                if (PropertyValidator.isValid((Collection)sessionBoard.getSession().getAlmConfigurations()) && PropertyValidator.isValid(sessionBoard.getSession().getAlmConfigurations().get(0))) {
                    almAccount = ((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getAlmAccount();
                } else if (PropertyValidator.isValid((Object)sessionBoard.getSession().getTfsAlmConfigurations())) {
                    almAccount = sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount();
                }
                if (almAccount != null && almAccount.getIsPrivate().booleanValue()) {
                    item1.setFetchedBy(JiraUtils.getProfileAlmUser((AlmAccount)almAccount));
                }
            }
            if (PropertyValidator.isValid((Object)item1.getParent()) && PropertyValidator.isValid((Object)item1.getParent().getId())) {
                List childItems = this.itemRepository.findByParentId(item1.getParent().getId());
                Double totalEstimate = 0.0;
                for (Item childItem : childItems) {
                    totalEstimate = totalEstimate + childItem.getStoryPoints();
                }
                this.customRepository.updateItemStoryPoints(item1.getParent().getId(), totalEstimate);
            }
            this.item = (Item)this.itemRepository.save((Object)item1);
            if (!PropertyValidator.isValid(almAccount)) {
                if (PropertyValidator.isValid((Collection)sessionBoard.getSession().getAlmConfigurations()) && PropertyValidator.isValid(sessionBoard.getSession().getAlmConfigurations().get(0))) {
                    almAccount = ((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getAlmAccount();
                } else if (PropertyValidator.isValid((Object)sessionBoard.getSession().getTfsAlmConfigurations())) {
                    almAccount = sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount();
                }
            }
            if (oldStatus != null) {
                if (!PropertyValidator.isValid((Object)item1.getStatus().getCategory())) {
                    Status newStatus = (Status)this.statusRepository.findOne((Serializable)((Object)item1.getStatus().getId()));
                    item1.setStatus(newStatus);
                }
                this.planService.updateItemLinksStatusBasedOnItemStatus(item1, oldStatus, sessionBoard, UserContextUtil.getUserContext().getCurrentCompanyId());
            }
            if (Boolean.TRUE.equals(sessionBoard.getSession().getAlmEnabled())) {
                if (PropertyValidator.isValid((Object)item1.getJiraProjectKey())) {
                    String param;
                    if (!PropertyValidator.isValid((Object)item1.getJiraId()) || item1.isDeletedInJira()) {
                        editMode = false;
                    }
                    if (PropertyValidator.isValid((Object)(param = request.getParameter("updateInJira"))) && !"true".equals(param)) {
                        updateInJira = false;
                    }
                    if (updateInJira) {
                        this.saveItemInJira(sessionBoard, editMode, optional);
                    }
                } else if (PropertyValidator.isValid((Object)item1.getTfsProject())) {
                    this.tfSservice.sendItemToTFS(this.item, item1, sessionBoard, editMode);
                }
            }
            if (PropertyValidator.isValid((Object)item1.getParent())) {
                responseJson.put("parentItem", item1.getParent());
            }
            if (PropertyValidator.isValid((Collection)emptyCards)) {
                this.customRepositoryImpl.removeEmptyCards((Collection)emptyCards, true);
            }
            responseJson.put("item", item1);
            this.userService.setOnboardingMeta("Get_Features_from_Jira", true);
        }
        catch (Exception e) {
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error(err);
            LOGGER.error("/save/item");
            Gson gson = new Gson();
            LOGGER.error("Item1 : " + gson.toJson((Object)item1));
            responseJson.put("kendisError", e);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private Map<String, Boolean> changeStoryTeamContainer(Item item1, List<TeamContainer> tcOLD, List<TeamContainer> tcNEW, Optional<String> optional) {
        HashMap<String, Boolean> changed = new HashMap<String, Boolean>();
        changed.put("sprint", true);
        changed.put("team", true);
        boolean isNoTeam = false;
        if (PropertyValidator.isValid(tcNEW)) {
            Item parent = this.itemRepository.findById(item1.getParent().getId());
            if (PropertyValidator.isValid((Collection)item1.getTeamContainers()) && PropertyValidator.isValid(item1.getTeamContainers().get(0))) {
                item1.setContainer(((TeamContainer)item1.getTeamContainers().get(0)).getContainer());
                item1.setTeam(((TeamContainer)item1.getTeamContainers().get(0)).getTeam());
            }
            item1.setParent(parent);
            tcOLD = parent.getTeamContainers();
            if (PropertyValidator.isValid(tcNEW)) {
                Team team = tcNEW.get(0).getTeam();
                Container container = tcNEW.get(0).getContainer();
                if (container.equals((Object)item1.getContainer())) {
                    changed.put("sprint", false);
                }
                if (team.equals((Object)item1.getTeam())) {
                    changed.put("team", false);
                }
                if (PropertyValidator.isValid((Object)team) && PropertyValidator.isValid((Object)container)) {
                    int found = -1;
                    if (team.getId().equals("-1")) {
                        isNoTeam = true;
                    } else {
                        boolean addNewTc = false;
                        if (PropertyValidator.isValid((Collection)tcOLD)) {
                            for (int i = 0; i < tcOLD.size(); ++i) {
                                if (!team.getId().equals(((TeamContainer)tcOLD.get(i)).getTeam().getId()) || !container.getId().equals(((TeamContainer)tcOLD.get(i)).getContainer().getId())) continue;
                                found = i;
                                break;
                            }
                            item1.setTeamContainers(new ArrayList());
                            if (found > -1) {
                                item1.getTeamContainers().add(tcOLD.get(found));
                            } else {
                                addNewTc = true;
                            }
                        } else {
                            addNewTc = true;
                            item1.setTeamContainers(new ArrayList());
                        }
                        if (addNewTc) {
                            TeamContainer teamContainer = new TeamContainer();
                            teamContainer.setContainer(container);
                            teamContainer.setTeam(team);
                            if (optional.isPresent() && PropertyValidator.isValid((Object)optional.get()) && "tcsequence".equals(optional.get())) {
                                teamContainer.setSequence(tcNEW.get(0).getSequence());
                            }
                            teamContainer.setIsActive(Boolean.valueOf(true));
                            teamContainer = (TeamContainer)this.teamContainerRepository.save((Object)teamContainer);
                            if (tcOLD == null) {
                                tcOLD = new ArrayList<TeamContainer>();
                            }
                            tcOLD.add(teamContainer);
                            item1.getParent().setTeamContainers(tcOLD);
                            this.itemRepository.save((Object)parent);
                            item1.getTeamContainers().add(teamContainer);
                        } else if (optional.isPresent() && PropertyValidator.isValid((Object)optional.get()) && found > -1 && "tcsequence".equals(optional.get())) {
                            TeamContainer teamContainer = (TeamContainer)this.teamContainerRepository.findOne((Serializable)((Object)((TeamContainer)tcOLD.get(found)).getId()));
                            teamContainer.setSequence(tcNEW.get(0).getSequence());
                            teamContainer = (TeamContainer)this.teamContainerRepository.save((Object)teamContainer);
                        }
                    }
                } else {
                    isNoTeam = true;
                }
            }
        } else {
            isNoTeam = true;
        }
        if (isNoTeam) {
            item1.setTeamContainers(null);
        }
        this.planService.updateTcInLinksOnChangeCell(item1);
        item1.putLastUpdatedValue("TC_IN_LINKS", (Object)true);
        return changed;
    }

    private void changeFeatureTeamContainer(Item item1, List<TeamContainer> tcOLD2, List<TeamContainer> tcNEW) {
        boolean isNoTeam = false;
        if (PropertyValidator.isValid((Object)PropertyValidator.isValid(tcNEW))) {
            Team team = tcNEW.get(0).getTeam();
            Container container = tcNEW.get(0).getContainer();
            if (PropertyValidator.isValid((Object)team) && PropertyValidator.isValid((Object)container)) {
                if (team.getId().equals("-1")) {
                    isNoTeam = true;
                } else {
                    item1.setTeamContainers(new ArrayList());
                    TeamContainer teamContainer = new TeamContainer();
                    teamContainer.setContainer(container);
                    teamContainer.setTeam(team);
                    teamContainer.setIsActive(Boolean.valueOf(true));
                    teamContainer = (TeamContainer)this.teamContainerRepository.save((Object)teamContainer);
                    item1.getTeamContainers().add(teamContainer);
                }
            } else {
                isNoTeam = true;
            }
        } else {
            isNoTeam = true;
        }
        if (isNoTeam) {
            item1.setTeamContainers(null);
        }
    }

    private void saveItemInJira(SessionBoard sessionBoard, boolean editMode, @PathVariable(value="optional") Optional<String> optional) {
        this.planService.saveItemInJira(this.savedItem, this.item, sessionBoard, editMode, optional);
    }

    private void saveItemScoreInTfs(SessionBoard board, Item item) {
        try {
            AlmAccount almAccount = board.getSession().getTfsAlmConfigurations().getAlmAccount();
            HashMap fields = new HashMap(this.scoreCardService.getScoreCardOnlyItemTfsFieldMap(board.getSession().getScoreCard().getMappings(), item));
            new Thread(() -> this.tfsUtils.updateItemInTFS(item.getTfsId(), fields, almAccount)).start();
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    private void saveItemScoreInJira(SessionBoard sessionBoard, boolean editMode, Item item) {
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        if (PropertyValidator.isValid((Object)sessionBoard.getSession().getWsjfEnabled()) && Item.FEATURE.equals(item.getType()) && editMode) {
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        }
    }

    @RequestMapping(value={"/sendmail"})
    public void sendMail() {
        HashMap<String, String> kv = new HashMap<String, String>();
        kv.put("var1", "its variable1 input");
        kv.put("var2", "its variable1 input");
        this.mailSender.sendMail("testput1@gmail.com", "string t", "template2", kv, true);
    }

    public void sampleTest() {
        this.almSyncService.generarteSampleBoards();
    }

    @RequestMapping(value={"/reset/score"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> resetWsjfScore(@RequestBody Map<String, Object> request) {
        String itemID = (String)request.get("featureId");
        String syncId = (String)request.get("syncId");
        Item savedItem = this.itemRepository.findById(itemID);
        if (PropertyValidator.isValid((Object)savedItem) && PropertyValidator.isValid((Object)savedItem.getScoreParams())) {
            Map params = savedItem.getScoreParams();
            for (Map.Entry entry : params.entrySet()) {
                entry.setValue("");
            }
            savedItem.setScoreParams(params);
            savedItem.setScore(null);
            this.itemRepository.save((Object)savedItem);
        }
        if (PropertyValidator.isValid((Collection)savedItem.getSessionBoards())) {
            HashMap<String, Object> pushJson = new HashMap<String, Object>();
            pushJson.put("item", "{\"id\":\"" + savedItem.getId() + "\",\"score\":\"" + savedItem.getScore() + "\"}");
            pushJson.put("metaMap", "{\"event\":\"ScoreChange\",\"syncId\": \"" + syncId + "\",\"boardId\": \"" + ((SessionBoard)savedItem.getSessionBoards().get(0)).getId() + "\"}");
            pushJson.put("type", savedItem.getType());
            pushJson.put("scoreParams", savedItem.getScoreParams());
            ObjectMapper mapper = new ObjectMapper();
            try {
                PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
            }
            catch (JsonProcessingException jsonProcessingException) {
                LOGGER.debug(jsonProcessingException.getMessage());
            }
        }
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("scoreParams", savedItem.getScoreParams());
        responseJson.put("score", savedItem.getScore());
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/save/score"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveScore(@RequestBody String data) throws Exception {
        Gson gson = new Gson();
        5 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestMap = (HashMap)gson.fromJson(data, T.getType());
        String itemID = (String)requestMap.get("itemID");
        Double score = (Double)requestMap.get("score");
        String syncId = (String)requestMap.get("syncId");
        String boardType = (String)requestMap.get("boardType");
        String scoreCardId = null;
        Boolean wsjfWithMappingEnabled = null;
        ScoreCard scoreCard = null;
        if (requestMap.containsKey("scoreCardId")) {
            scoreCardId = (String)requestMap.get("scoreCardId");
            scoreCard = this.scoreCardService.findById(scoreCardId);
        }
        if (requestMap.containsKey("wsjfWithMappingEnabled")) {
            wsjfWithMappingEnabled = (Boolean)requestMap.get("wsjfWithMappingEnabled");
        }
        Map params = (Map)requestMap.get("scoreParams");
        Item savedItem = this.itemRepository.findById(itemID);
        savedItem.setScoreParams(params);
        savedItem.setScore(score);
        this.itemRepository.save((Object)savedItem);
        if (wsjfWithMappingEnabled != null && scoreCard != null && wsjfWithMappingEnabled.booleanValue()) {
            if (boardType != null && boardType.equals("jira")) {
                this.scoreCardService.saveMappedFieldsToCustomFieldsLocally(savedItem, scoreCard, true);
                if (PropertyValidator.isValid((Collection)savedItem.getSessionBoards())) {
                    this.saveItemScoreInJira((SessionBoard)savedItem.getSessionBoards().get(0), true, savedItem);
                }
            } else {
                this.scoreCardService.saveMappedFieldsToCustomFieldsLocally(savedItem, scoreCard, false);
                if (PropertyValidator.isValid((Collection)savedItem.getSessionBoards())) {
                    this.saveItemScoreInTfs((SessionBoard)savedItem.getSessionBoards().get(0), savedItem);
                }
            }
        }
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("scoreParams", savedItem.getScoreParams());
        responseJson.put("score", score);
        if (PropertyValidator.isValid((Collection)savedItem.getSessionBoards())) {
            HashMap<String, Object> pushJson = new HashMap<String, Object>();
            pushJson.put("item", "{\"id\":\"" + savedItem.getId() + "\",\"score\":\"" + savedItem.getScore() + "\"}");
            pushJson.put("metaMap", "{\"event\":\"ScoreChange\",\"syncId\": \"" + syncId + "\",\"boardId\": \"" + ((SessionBoard)savedItem.getSessionBoards().get(0)).getId() + "\"}");
            pushJson.put("type", savedItem.getType());
            pushJson.put("scoreParams", savedItem.getScoreParams());
            ObjectMapper mapper = new ObjectMapper();
            try {
                PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
            }
            catch (JsonProcessingException e) {
                LOGGER.debug(e.getMessage());
            }
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/updateJiraItemsScore"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateScore(@RequestBody String data) {
        Gson gson = new Gson();
        6 T = new /* Unavailable Anonymous Inner Class!! */;
        List requestMap = (List)gson.fromJson(data, T.getType());
        ArrayList<String> idsList = new ArrayList<String>();
        HashMap<String, Double> itemsMapByScore = new HashMap<String, Double>();
        for (int i = 0; i < requestMap.size(); ++i) {
            String id = (String)((HashMap)requestMap.get(i)).get("itemID");
            Double score = (Double)((HashMap)requestMap.get(i)).get("score");
            idsList.add(id);
            itemsMapByScore.put(id, score);
        }
        ArrayList savedItems = this.itemRepository.findByJiraIdIn(idsList);
        savedItems.forEach(item -> item.setAlmScoreField((Double)itemsMapByScore.get(item.getJiraId())));
        this.itemRepository.save((Iterable)savedItems);
        HashMap<String, HashMap<String, Double>> responseJson = new HashMap<String, HashMap<String, Double>>();
        responseJson.put("items", itemsMapByScore);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/save/sequence"})
    @ResponseBody
    public ResponseEntity<Object> saveSeqeunce(@RequestBody Item item) {
        Item savedItem = (Item)this.itemRepository.findOne((Serializable)((Object)item.getId()));
        savedItem.setSequence(item.getSequence());
        savedItem.setMetaMap(item.getMetaMap());
        this.itemRepository.save((Object)savedItem);
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("id", savedItem.getId());
        responseJson.put("sequence", savedItem.getSequence());
        responseJson.put("backlogSequence", savedItem.getBacklogSequence());
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getFeatureStories/{id}"})
    @ResponseBody
    public ResponseEntity<?> findStoriesByParentId(@PathVariable(value="id") String id) {
        List stories = this.itemRepository.findStoriesByParentId(id);
        return ResponseEntity.ok((Object)stories);
    }

    private void fetchItemJiraProject(String almAccountId, String projectKey, HashMap<String, Object> response) {
        JiraProjectIssueTypes jpType = null;
        if (PropertyValidator.isValid((Object)projectKey) && (jpType = this.jiraProjectIssueTypesRepository.findByAlmAccountIdAndJiraProjectKey(almAccountId, projectKey)) != null) {
            jpType.setIssueTypes(MongoSyncUtils.retrieveData((String)jpType.getIssueTypesReference(), (AppConfig.MongoConfig)this.mongoConfig));
        }
        response.put("jiraProject", jpType);
    }

    @RequestMapping(value={"/getItemById/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> findItemByItemId(@PathVariable(value="id") String id, @RequestBody String requestBody) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList dependencyValues = new ArrayList();
        List children = null;
        List childrenOfChildren = null;
        HashMap<String, Double> points = new HashMap<String, Double>();
        Item item = this.itemRepository.findById(id);
        String solutionBoardId = null;
        try {
            String parentEpicSolutionBoardId;
            Gson gson = new Gson();
            7 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestMap = (HashMap)gson.fromJson(requestBody, T.getType());
            String sessionJSON = (String)requestMap.get("session");
            solutionBoardId = (String)requestMap.get("solutionBoardId");
            Session session = (Session)gson.fromJson(sessionJSON, Session.class);
            String almAccountId = null;
            if (PropertyValidator.isValid((Collection)session.getAlmConfigurations()) && PropertyValidator.isValid(session.getAlmConfigurations().get(0)) && PropertyValidator.isValid((Object)item.getJiraId())) {
                ArrayList<ItemJiraFieldMap> configFields = new ArrayList<ItemJiraFieldMap>();
                almAccountId = ((AlmConfigurations)session.getAlmConfigurations().get(0)).getAlmAccount().getId();
                JiraField sprint = this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountId("com.pyxis.greenhopper.jira:gh-sprint", almAccountId);
                configFields.add(new ItemJiraFieldMap(JiraField.FIXED.reporter.name(), null, "JSONObject"));
                configFields.add(new ItemJiraFieldMap(JiraField.FIXED.assignee.name(), null, "JSONObject"));
                configFields.add(new ItemJiraFieldMap(JiraField.FIXED.updated.name(), null, "string"));
                configFields.add(new ItemJiraFieldMap(JiraField.FIXED.created.name(), null, "string"));
                if (PropertyValidator.isValid((Object)sprint)) {
                    configFields.add(new ItemJiraFieldMap(sprint.getJiraId(), null, "JSONArray"));
                }
                if (PropertyValidator.isValid((Object)session.getJiraFlaggedField())) {
                    configFields.add(session.getJiraFlaggedField());
                }
                this.fetchItemJiraProject(almAccountId, item.getJiraProjectKey(), response);
                if (PropertyValidator.isValid((Collection)session.getAdditionalFieldsValuesFeature()) || PropertyValidator.isValid((Collection)session.getAdditionalFieldsValuesUserStory())) {
                    List tmp = null;
                    if (Item.Type.Feature.name().equals(item.getType())) {
                        tmp = session.getAdditionalFieldsValuesFeature();
                    }
                    if (Item.Type.UserStory.name().equals(item.getType())) {
                        tmp = session.getAdditionalFieldsValuesUserStory();
                    }
                    if (PropertyValidator.isValid((Collection)tmp)) {
                        for (ItemJiraFieldMap field : tmp) {
                            field.setClientTimeZone(session.getClientTimeZone());
                            configFields.add(field);
                        }
                    }
                }
                item.putCustomeValuesAsText(item.getJiraFieldByKey(), configFields, null);
            }
            if (PropertyValidator.isValid((Object)session.getTfsAlmConfigurations()) && PropertyValidator.isValid((Object)session.getTfsAlmConfigurations().getAlmAccount()) && PropertyValidator.isValid((Object)item.getTfsId())) {
                almAccountId = session.getTfsAlmConfigurations().getAlmAccount().getId();
            }
            HashMap itemMap = new HashMap();
            this.putSessionBoardItemLinks(item, itemMap, dependencyValues);
            ArrayList<String> keys = new ArrayList<String>();
            boolean isJira = false;
            if (PropertyValidator.isValid((Object)item.getJiraKey())) {
                isJira = true;
                keys.add(item.getJiraKey());
            } else if (PropertyValidator.isValid((Object)item.getTfsId())) {
                keys.add(item.getTfsId());
            }
            if (!PropertyValidator.isValid((Object)item.getJiraId()) && !PropertyValidator.isValid((Object)item.getTfsId()) && PropertyValidator.isValid((Object)session.getKendisOnlyLayout())) {
                response.put("kendisFields", this.customFieldService.getKendisCustomFieldsFromLayout(EnumKendis.KENDIS_ONLY_CARD.getCode(), session.getKendisOnlyLayout()));
            }
            if (PropertyValidator.isValid((Object)item.getSolutionBoard())) {
                List sessions = this.sessionRepository.findByIdIn((List)item.getSolutionBoard().getPiSessions());
                item.getSolutionBoard().setPiSessionBoards(new ArrayList());
                for (Session s : sessions) {
                    item.getSolutionBoard().getPiSessionBoards().add(new SessionBoard(s.getActiveSessionBoard()));
                }
                if (Item.Type.Epic.name().equals(item.getType()) && PropertyValidator.isValid((Collection)(childrenOfChildren = this.itemRepository.findStoriesByParentIn(children = this.solutionService.fetchChild(keys, item.getSolutionBoard(), true))))) {
                    for (Item c : childrenOfChildren) {
                        if (c.getParent() == null || c.getParent().getId() == null || c.getStoryPoints() == null) continue;
                        if (points.get(c.getParent().getId()) == null) {
                            points.put(c.getParent().getId(), 0.0);
                        }
                        points.put(c.getParent().getId(), c.getStoryPoints() + (Double)points.get(c.getParent().getId()));
                    }
                }
            }
            if (PropertyValidator.isValid((Object)(parentEpicSolutionBoardId = solutionBoardId))) {
                List epicFeatures = this.epicFeaturesRepository.findByFeatureKeyInAndSolutionBoardIdOrderByCreatedOnDescUpdatedOnDesc(keys, parentEpicSolutionBoardId);
                if (PropertyValidator.isValid((Collection)epicFeatures)) {
                    keys = new ArrayList();
                    keys.add(((EpicFeature)epicFeatures.get(0)).getEpicKey());
                    List parent = null;
                    parent = isJira ? this.itemRepository.findByJiraKeyInAndSolutionBoard(keys, new SolutionBoard(parentEpicSolutionBoardId)) : this.itemRepository.findByTfsIdInAndSolutionBoard(keys, new SolutionBoard(parentEpicSolutionBoardId));
                    if (PropertyValidator.isValid((Collection)parent)) {
                        item.setParent((Item)parent.get(0));
                    }
                }
                this.putSolutionBoardItemLinks(item, itemMap, dependencyValues, children, points);
            }
            if (Item.Type.Feature.name().equals(item.getType())) {
                children = this.itemRepository.findStoriesByParentId(id);
            }
            if (PropertyValidator.isValid((Object)solutionBoardId) && PropertyValidator.isValid((Object)almAccountId)) {
                AlmAccount almAccount = this.almAccountRepository.findById(almAccountId);
                if (item.getJiraId() != null) {
                    response.put("jiraLinksTypes", this.almSyncService.retrieveJiraIssueLinkTypesList(almAccount, false));
                } else if (item.getTfsId() != null) {
                    response.put("tfsLinksTypes", this.tfsUtils.getRelationShipTypes(almAccount));
                }
            }
            List restrictions = KendisUtils.getRestrictions((WorkSpaceRepository)this.workSpaceRepository, (WorkSpaceAccessRoleRepository)this.accessRoleRepository, session != null && session.getWorkSpace() != null ? session.getWorkSpace().getId() : null);
            if (Item.Type.Feature.name().equals(item.getType())) {
                response.put("editable", KendisUtils.isActionAllowed((String)"edit-item", (List)restrictions));
            } else {
                response.put("editable", KendisUtils.isActionAllowed((String)"edit-subitem", (List)restrictions));
            }
        }
        catch (Exception e) {
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error(err);
            response.put("kendisError", err);
        }
        response.put("item", item);
        response.put("dependencies", dependencyValues);
        response.put("children", children);
        response.put("solutionBoardId", solutionBoardId);
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/getItems/{id}/{isTFS}"})
    @ResponseBody
    public ResponseEntity<?> getItemBySourceAndTargetId123(@PathVariable(value="id") String id, @PathVariable(value="isTFS") boolean isTFS) {
        ArrayList dependencyValues = new ArrayList();
        Item item = this.itemRepository.findById(id);
        if (PropertyValidator.isValid((Object)item)) {
            HashMap itemMap = new HashMap();
            this.putSessionBoardItemLinks(item, itemMap, dependencyValues);
            this.putSolutionBoardItemLinks(item, itemMap, dependencyValues, null, new HashMap());
        }
        return ResponseEntity.ok(dependencyValues);
    }

    @RequestMapping(value={"/target-links"})
    @ResponseBody
    public ResponseEntity<?> findTargetItemLinks(@RequestBody Map<String, Object> request) {
        Map featureIdByTcIdBy = (Map)request.get("tcIdByfeatureId");
        Map storyIdByTcIdBy = (Map)request.get("tcIdByStoryId");
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            response.put("featuresTargets", this.itemLinkRepository.findByTargetTeamContainerIdInAndTargetUserStoryIdExists(featureIdByTcIdBy.values(), false));
            response.put("storiesTargets", this.itemLinkRepository.findByTargetTeamContainerIdInAndTargetUserStoryIdIn(storyIdByTcIdBy.values(), storyIdByTcIdBy.keySet()));
        }
        catch (Exception e) {
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error(err);
            response.put("kendisError", err);
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    private void putSessionBoardItemLinks(Item item, Map<String, Item> itemMap, List<HashMap<String, Object>> dependencyValues) {
        HashMap dep;
        List tcs;
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(item.getId());
        boolean isTFS = item.getTfsId() != null;
        List itemTeamContainers = item.getTeamContainers();
        List sourceItemLinks = item.getItemLinks();
        ArrayList<String> teamContainerIds = new ArrayList<String>();
        if (PropertyValidator.isValid((Collection)itemTeamContainers)) {
            for (TeamContainer tc : itemTeamContainers) {
                teamContainerIds.add(tc.getId());
            }
        }
        List targetItemLinks = null;
        targetItemLinks = item.getType().equals(Item.Type.Feature.name()) ? this.itemLinkRepository.findByTargetTeamContainerIdInAndTargetUserStoryIdExists(teamContainerIds, false) : this.itemLinkRepository.findByTargetTeamContainerIdInAndTargetUserStoryIdIn(teamContainerIds, ids);
        ArrayList<String> targetTCIds = new ArrayList<String>();
        ArrayList<String> targetItemIds = new ArrayList<String>();
        if (PropertyValidator.isValid((Collection)sourceItemLinks)) {
            for (ItemLink sourceItemLink : sourceItemLinks) {
                if (PropertyValidator.isValid((Object)sourceItemLink.getTargetUserStoryId())) {
                    targetItemIds.add(sourceItemLink.getTargetUserStoryId());
                    continue;
                }
                if (!PropertyValidator.isValid((Object)sourceItemLink.getTargetTeamContainerId())) continue;
                targetTCIds.add(sourceItemLink.getTargetTeamContainerId());
            }
        }
        List targetItems = this.itemRepository.findByTeamContainersIdIn(targetTCIds);
        targetItems.addAll(this.itemRepository.findByIdIn(targetItemIds));
        ArrayList<String> sourceTCIds = new ArrayList<String>();
        ArrayList<String> sourceItemIds = new ArrayList<String>();
        for (ItemLink targetItemLink : targetItemLinks) {
            if (PropertyValidator.isValid((Object)targetItemLink.getSourceUserStoryId())) {
                sourceItemIds.add(targetItemLink.getSourceUserStoryId());
                continue;
            }
            sourceTCIds.add(targetItemLink.getSourceTeamContainerId());
        }
        List sourceItems = this.itemRepository.findByTeamContainersIdIn(sourceTCIds);
        sourceItems.addAll(this.itemRepository.findByIdIn(sourceItemIds));
        ArrayList<String> almTargetItemIds = new ArrayList<String>();
        HashMap<String, Item> targetItemMapById = new HashMap<String, Item>();
        if (PropertyValidator.isValid((Collection)item.getJiraDependencies()) && item.getType().equals("UserStory")) {
            for (ItemJiraDependency jD : item.getJiraDependencies()) {
                if (!PropertyValidator.isValid((Object)jD.getTargetItemId())) continue;
                almTargetItemIds.add(jD.getTargetItemId());
            }
            if (PropertyValidator.isValid(almTargetItemIds)) {
                List targetJiraItems = this.itemRepository.findByIdInAndType(almTargetItemIds, "UserStory");
                for (Item targetItem : targetJiraItems) {
                    targetItemMapById.put(targetItem.getId(), targetItem);
                }
                for (ItemJiraDependency jD : item.getJiraDependencies()) {
                    HashMap dep2;
                    Item targetItem;
                    if (!PropertyValidator.isValid((Object)jD.getTargetItemId()) || !PropertyValidator.isValid(targetItemMapById.get(jD.getTargetItemId())) || !PropertyValidator.isValid((Object)(targetItem = (Item)targetItemMapById.get(jD.getTargetItemId()))) || !PropertyValidator.isValid((Collection)targetItem.getTeamContainers()) || targetItem.getTeamContainers().size() <= 0) continue;
                    if (jD.getIsTFS().booleanValue()) {
                        HashMap dep3;
                        String[] type = jD.getTfsLinkType().split("-");
                        List<String> typeList = Arrays.asList(type);
                        if (typeList.size() > 1 && typeList.get(1).equals("Forward")) {
                            dep3 = this.createItemLinksDataForFeatureDetailView(item, targetItem, (Object)jD, jD.getTfsLinkType());
                            dep3.put("boardType", "sessionBoard");
                            dep3.put("isALM", true);
                            if (dependencyValues.contains(dep3)) continue;
                            dependencyValues.add(dep3);
                            continue;
                        }
                        dep3 = this.createItemLinksDataForFeatureDetailView(targetItem, item, (Object)jD, jD.getTfsLinkType());
                        dep3.put("boardType", "sessionBoard");
                        dep3.put("isALM", true);
                        if (dependencyValues.contains(dep3)) continue;
                        dependencyValues.add(dep3);
                        continue;
                    }
                    if (jD.getDirection().equals("OUT")) {
                        dep2 = this.createItemLinksDataForFeatureDetailView(item, targetItem, (Object)jD, jD.getLinkType().getJiraId() + "-" + jD.getDirection());
                        dep2.put("boardType", "sessionBoard");
                        dep2.put("isALM", true);
                        if (dependencyValues.contains(dep2)) continue;
                        dependencyValues.add(dep2);
                        continue;
                    }
                    if (!jD.getDirection().equals("IN")) continue;
                    dep2 = this.createItemLinksDataForFeatureDetailView(targetItem, item, (Object)jD, jD.getLinkType().getJiraId() + "-" + jD.getDirection());
                    dep2.put("boardType", "sessionBoard");
                    dep2.put("isALM", true);
                    if (dependencyValues.contains(dep2)) continue;
                    dependencyValues.add(dep2);
                }
            }
        }
        HashMap<String, Boolean> used = new HashMap<String, Boolean>();
        for (Item item2 : targetItems) {
            itemMap.put(item2.getId(), item2);
            if (!PropertyValidator.isValid((Collection)sourceItemLinks)) continue;
            block7: for (ItemLink sourceItemLink : sourceItemLinks) {
                if (used.containsKey(sourceItemLink.getId()) || !PropertyValidator.isValid((Collection)(tcs = item2.getTeamContainers()))) continue;
                for (TeamContainer tc : tcs) {
                    if (item2.getType().equals(Item.Type.Feature.name())) {
                        if (!tc.getId().equals(sourceItemLink.getTargetTeamContainerId()) || PropertyValidator.isValid((Object)sourceItemLink.getTargetUserStoryId())) continue;
                        dep = this.createItemLinksDataForFeatureDetailView(item, item2, (Object)sourceItemLink, sourceItemLink.getType());
                        dep.put("boardType", "sessionBoard");
                        dep.put("isALM", false);
                        if (!dependencyValues.contains(dep)) {
                            dependencyValues.add(dep);
                        }
                        used.put(sourceItemLink.getId(), true);
                        continue block7;
                    }
                    if (!tc.getId().equals(sourceItemLink.getTargetTeamContainerId()) || !item2.getId().equals(sourceItemLink.getTargetUserStoryId())) continue;
                    dep = this.createItemLinksDataForFeatureDetailView(item, item2, (Object)sourceItemLink, sourceItemLink.getType());
                    dep.put("boardType", "sessionBoard");
                    dep.put("isALM", false);
                    if (!dependencyValues.contains(dep)) {
                        dependencyValues.add(dep);
                    }
                    used.put(sourceItemLink.getId(), true);
                    continue block7;
                }
            }
        }
        used = new HashMap();
        for (Item item2 : sourceItems) {
            itemMap.put(item2.getId(), item2);
            block10: for (ItemLink targetItemLink : targetItemLinks) {
                if (used.containsKey(targetItemLink.getId()) || !PropertyValidator.isValid((Collection)(tcs = item2.getTeamContainers()))) continue;
                for (TeamContainer tc : tcs) {
                    if (item2.getType().equals(Item.Type.Feature.name())) {
                        if (!tc.getId().equals(targetItemLink.getSourceTeamContainerId()) || PropertyValidator.isValid((Object)targetItemLink.getSourceUserStoryId())) continue;
                        dep = this.createItemLinksDataForFeatureDetailView(item2, item, (Object)targetItemLink, targetItemLink.getType());
                        dep.put("boardType", "sessionBoard");
                        dep.put("isALM", false);
                        if (!dependencyValues.contains(dep)) {
                            dependencyValues.add(dep);
                        }
                        used.put(targetItemLink.getId(), true);
                        continue block10;
                    }
                    if (!tc.getId().equals(targetItemLink.getSourceTeamContainerId()) || !item2.getId().equals(targetItemLink.getSourceUserStoryId())) continue;
                    dep = this.createItemLinksDataForFeatureDetailView(item2, item, (Object)targetItemLink, targetItemLink.getType());
                    dep.put("boardType", "sessionBoard");
                    dep.put("isALM", false);
                    if (!dependencyValues.contains(dep)) {
                        dependencyValues.add(dep);
                    }
                    used.put(targetItemLink.getId(), true);
                    continue block10;
                }
            }
        }
    }

    private void putSolutionBoardItemLinks(Item item, Map<String, Item> itemMap, List<HashMap<String, Object>> dependencyValues, List<Item> children, Map<String, Double> points) {
        HashMap dep;
        TeamContainer _tc;
        List linkedItemsChildren;
        boolean isTFS = item.getTfsId() != null;
        ArrayList linksOut = item.getSolutionSourceItemLinks();
        ArrayList linksIn = item.getSolutionTargetItemLinks();
        ArrayList<String> itemIds = new ArrayList<String>();
        if (PropertyValidator.isValid((Collection)linksOut)) {
            for (ItemLink link : linksOut) {
                if (itemMap.containsKey(link.getTargetItemId())) continue;
                itemIds.add(link.getTargetItemId());
            }
        }
        if (PropertyValidator.isValid((Collection)linksIn)) {
            for (ItemLink link : linksIn) {
                if (itemMap.containsKey(link.getSourceItemId())) continue;
                itemIds.add(link.getSourceItemId());
            }
        }
        ArrayList<String> keys = new ArrayList<String>();
        SolutionBoard sol = null;
        if (PropertyValidator.isValid(itemIds)) {
            List items = this.itemRepository.findByIdIn(itemIds);
            for (Item it : items) {
                itemMap.put(it.getId(), it);
                if (!it.getType().equals(Item.Type.Epic.name()) || it.getId().equals(item.getId())) continue;
                if (it.getTfsId() == null) {
                    keys.add(it.getJiraKey());
                    itemMap.put(it.getJiraKey(), it);
                } else {
                    keys.add(it.getTfsId());
                    itemMap.put(it.getTfsId(), it);
                }
                if (sol != null) continue;
                sol = it.getSolutionBoard();
            }
        }
        if (keys.size() > 0 && sol != null && PropertyValidator.isValid((Collection)(linkedItemsChildren = this.solutionService.fetchChild(keys, sol, true)))) {
            for (Item feature : linkedItemsChildren) {
                if (!itemMap.containsKey(feature.getParentKey()) || !PropertyValidator.isValid((Collection)feature.getTeamContainers())) continue;
                if (itemMap.get(feature.getParentKey()).getTeamContainers() == null) {
                    itemMap.get(feature.getParentKey()).setTeamContainers(new ArrayList());
                }
                itemMap.get(feature.getParentKey()).getTeamContainers().add(feature.calcPhoenixTC());
            }
        }
        if (PropertyValidator.isValid(children)) {
            String key = item.getTfsId() == null ? item.getJiraKey() : item.getTfsId();
            for (Item feature : children) {
                feature.setStoryPoints(points.get(feature.getId()));
                feature.setPhoenixTC(feature.calcPhoenixTC());
                if (!feature.getParentKey().equals(key) || !PropertyValidator.isValid((Collection)feature.getTeamContainers())) continue;
                if (item.getTeamContainers() == null) {
                    item.setTeamContainers(new ArrayList());
                }
                item.getTeamContainers().add(feature.getPhoenixTC());
            }
        }
        TeamContainer tc = item.calcPhoenixTC();
        if (PropertyValidator.isValid((Collection)linksOut) && PropertyValidator.isValid((Object)tc)) {
            for (ItemLink link : linksOut) {
                link.setTargetItem(itemMap.get(link.getTargetItemId()));
                if (link.getTargetItem() == null) continue;
                _tc = link.getTargetItem().getPhoenixTC();
                if (_tc == null) {
                    _tc = link.getTargetItem().calcPhoenixTC();
                }
                if (!PropertyValidator.isValid((Object)_tc)) continue;
                dep = this.makeDependencyBetweenSourceAndTarget(item, link.getTargetItem(), tc.getId(), _tc.getId(), link.getType(), Boolean.valueOf(false), "outbound", (Object)link);
                dep.put("boardType", "solutionBoard");
                dep.put("sourceSessionId", link.getSourceSessionId());
                dep.put("targetSessionId", link.getTargetSessionId());
                dep.put("solutionId", link.getSolutionId());
                dependencyValues.add(dep);
            }
        }
        if (PropertyValidator.isValid((Collection)linksIn)) {
            for (ItemLink link : linksIn) {
                link.setSourceItem(itemMap.get(link.getSourceItemId()));
                if (link.getSourceItem() == null) continue;
                _tc = link.getSourceItem().getPhoenixTC();
                if (link.getSourceItem() == null) continue;
                if (_tc == null) {
                    _tc = link.getSourceItem().calcPhoenixTC();
                }
                if (!PropertyValidator.isValid((Object)_tc) || !PropertyValidator.isValid((Object)tc)) continue;
                dep = this.makeDependencyBetweenSourceAndTarget(link.getSourceItem(), item, _tc.getId(), tc.getId(), link.getType(), Boolean.valueOf(isTFS), "inbound", (Object)link);
                dep.put("boardType", "solutionBoard");
                dep.put("sourceSessionId", link.getSourceSessionId());
                dep.put("targetSessionId", link.getTargetSessionId());
                dep.put("solutionId", link.getSolutionId());
                dependencyValues.add(dep);
            }
        }
    }

    public HashMap<String, Object> createItemLinksDataForFeatureDetailView(Item sourceItem, Item targetItem, Object link, String type) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("sItem", sourceItem);
        data.put("tItem", targetItem);
        data.put("type", type);
        if (link instanceof ItemLink) {
            ItemLink itemLink = (ItemLink)link;
            data.put("link", itemLink);
            data.put("sTCId", itemLink.getSourceTeamContainerId());
            data.put("tTCId", itemLink.getTargetTeamContainerId());
            if (PropertyValidator.isValid((Object)sourceItem) && PropertyValidator.isValid((Collection)sourceItem.getTeamContainers())) {
                for (TeamContainer tC : sourceItem.getTeamContainers()) {
                    if (!PropertyValidator.isValid((Object)tC) || !tC.getId().equals(itemLink.getSourceTeamContainerId())) continue;
                    data.put("sSprint", tC.getContainer());
                    data.put("sTeam", tC.getTeam());
                    break;
                }
            }
            if (PropertyValidator.isValid((Object)targetItem) && PropertyValidator.isValid((Collection)targetItem.getTeamContainers())) {
                for (TeamContainer tC : targetItem.getTeamContainers()) {
                    if (!PropertyValidator.isValid((Object)tC) || !tC.getId().equals(itemLink.getTargetTeamContainerId())) continue;
                    data.put("tSprint", tC.getContainer());
                    data.put("tTeam", tC.getTeam());
                    break;
                }
            }
            data.put("status", itemLink.getWfStatus() != null ? itemLink.getWfStatus().getTitle() : itemLink.getStatus());
        } else {
            ItemJiraDependency jD = (ItemJiraDependency)link;
            data.put("link", jD);
            if (PropertyValidator.isValid((Object)sourceItem) && PropertyValidator.isValid((Collection)sourceItem.getTeamContainers())) {
                data.put("sTCId", ((TeamContainer)sourceItem.getTeamContainers().get(0)).getId());
                data.put("sSprint", ((TeamContainer)sourceItem.getTeamContainers().get(0)).getContainer());
                data.put("sTeam", ((TeamContainer)sourceItem.getTeamContainers().get(0)).getTeam());
            }
            if (PropertyValidator.isValid((Object)targetItem) && PropertyValidator.isValid((Collection)targetItem.getTeamContainers())) {
                data.put("tTCId", ((TeamContainer)targetItem.getTeamContainers().get(0)).getId());
                data.put("tSprint", ((TeamContainer)targetItem.getTeamContainers().get(0)).getContainer());
                data.put("tTeam", ((TeamContainer)targetItem.getTeamContainers().get(0)).getTeam());
            }
            data.put("status", jD.getWfStatus() != null ? jD.getWfStatus().getTitle() : null);
        }
        return data;
    }

    public HashMap<String, Object> makeDependencyBetweenSourceAndTarget(Item sourceItem, Item targetItem, String sourceTeamContainerId, String targetTeamContainerId, String type, Boolean isTFS1, String dpType, Object link) {
        String keyName = "";
        ArrayList<Item> sourceAndTarget = new ArrayList<Item>();
        sourceAndTarget.add(sourceItem);
        sourceAndTarget.add(targetItem);
        HashMap<String, Object> dataa = new HashMap<String, Object>();
        keyName = dpType == "inbound" ? "source" : "target";
        Item selectedItem = dpType == "inbound" ? sourceItem : targetItem;
        for (TeamContainer teams : selectedItem.getTeamContainers()) {
            if (!(teams.getId().equals(sourceTeamContainerId) & dpType.equals("inbound")) && !(teams.getId().equals(targetTeamContainerId) & dpType.equals("outbound"))) continue;
            dataa.put("dptype", dpType);
            dataa.put("id" + keyName, selectedItem.getId());
            dataa.put("type" + keyName, selectedItem.getType());
            dataa.put("jiraid" + keyName, selectedItem.getJiraId());
            dataa.put("tfsid" + keyName, selectedItem.getTfsId());
            dataa.put("jirakey" + keyName, selectedItem.getJiraKey());
            dataa.put("tfsURL" + keyName, selectedItem.getTfsURL());
            dataa.put("jiraURL" + keyName, selectedItem.getJiraURL());
            dataa.put("externalReferenceURL" + keyName, selectedItem.getExternalReferenceURL() != null ? selectedItem.getExternalReferenceURL() : "");
            dataa.put("title" + keyName, selectedItem.getTitle());
            dataa.put("teamlabel" + keyName, teams.getTeam().getLabel());
            dataa.put("teamtitle" + keyName, teams.getTeam().getTitle());
            dataa.put("teamcolor" + keyName, teams.getTeam().getColor());
            dataa.put("sprintLabel" + keyName, teams.getContainer().getLabel());
            dataa.put("sprintTitle" + keyName, teams.getContainer().getTitle());
            dataa.put("Status" + keyName, selectedItem.getStatus().getTitle());
            dataa.put("category" + keyName, selectedItem.getStatus().getCategory());
            dataa.put("Color" + keyName, selectedItem.getStatus().getColor());
            dataa.put("RelationType", type);
            if (!PropertyValidator.isValid((Object)link)) continue;
            if (link instanceof ItemLink) {
                ItemLink itemLink = (ItemLink)link;
                dataa.put("linkId", itemLink.getId());
                if (PropertyValidator.isValid((Object)itemLink.getAlmLinkId())) {
                    dataa.put("almLinkId", String.valueOf(itemLink.getAlmLinkId()));
                }
                dataa.put("customId", String.valueOf(itemLink.getCustomId()));
            }
            if (!(link instanceof ItemJiraDependency)) continue;
            ItemJiraDependency jD = (ItemJiraDependency)link;
            dataa.put("linkId", jD.getId());
            if (!PropertyValidator.isValid((Object)jD.getJiraDependencyId())) continue;
            dataa.put("jiraDependencyId", String.valueOf(jD.getJiraDependencyId()));
        }
        return dataa;
    }

    private void updateTcInLinksOnDrag(Item item1) {
        try {
            if (item1.getTeamContainers() != null && item1.getTeamContainers().size() > 0 && ((TeamContainer)item1.getTeamContainers().get(0)).getId() != null) {
                List links = this.itemLinkRepository.findByTargetUserStoryIdOrSourceUserStoryId(item1.getId(), item1.getId());
                if (PropertyValidator.isValid((Collection)links)) {
                    for (int i = 0; i < links.size(); ++i) {
                        if (((ItemLink)links.get(i)).getSourceUserStoryId() != null && ((ItemLink)links.get(i)).getSourceUserStoryId().equals(item1.getId())) {
                            ((ItemLink)links.get(i)).setSourceTeamContainerId(((TeamContainer)item1.getTeamContainers().get(0)).getId());
                        }
                        if (((ItemLink)links.get(i)).getTargetUserStoryId() == null || !((ItemLink)links.get(i)).getTargetUserStoryId().equals(item1.getId())) continue;
                        ((ItemLink)links.get(i)).setTargetTeamContainerId(((TeamContainer)item1.getTeamContainers().get(0)).getId());
                    }
                }
                this.itemLinkRepository.save((Iterable)links);
            }
        }
        catch (Exception e) {
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error(err);
        }
    }

    @RequestMapping(value={"/save/ussequence"})
    public Item saveUSSeqeunce(@RequestBody Item item1) {
        Item savedItem_ = (Item)this.itemRepository.findOne((Serializable)((Object)item1.getId()));
        this.savedItem = (Item)this.itemRepository.findOne((Serializable)((Object)item1.getId()));
        boolean updateJira = Boolean.FALSE;
        boolean updateDate = Boolean.TRUE;
        if (item1.getParent() != null && savedItem_.getParent() != null && !savedItem_.getParent().equals((Object)item1.getParent())) {
            updateJira = Boolean.TRUE;
        }
        savedItem_.setParent(item1.getParent());
        if (PropertyValidator.isValid((Collection)item1.getTeamContainers())) {
            Container container;
            if (PropertyValidator.isValid((Collection)savedItem_.getTeamContainers())) {
                if (!((TeamContainer)savedItem_.getTeamContainers().get(0)).equals(item1.getTeamContainers().get(0))) {
                    updateJira = Boolean.TRUE;
                }
                savedItem_.setContainer(((TeamContainer)savedItem_.getTeamContainers().get(0)).getContainer());
                savedItem_.setTeam(((TeamContainer)savedItem_.getTeamContainers().get(0)).getTeam());
                if (savedItem_.getContainer().equals((Object)((TeamContainer)item1.getTeamContainers().get(0)).getContainer())) {
                    updateDate = Boolean.FALSE;
                }
            } else if (!PropertyValidator.isValid((Collection)savedItem_.getTeamContainers()) && PropertyValidator.isValid((Collection)item1.getTeamContainers())) {
                updateJira = Boolean.TRUE;
            }
            savedItem_.setSequence(item1.getSequence());
            savedItem_.setTeamContainers(item1.getTeamContainers());
            this.planService.updateTcInLinksOnChangeCell(item1);
            if (PropertyValidator.isValid((Object)((TeamContainer)item1.getTeamContainers().get(0)).getContainer()) && PropertyValidator.isValid((Object)(container = (Container)this.containerRepository.findOne((Serializable)((Object)((TeamContainer)item1.getTeamContainers().get(0)).getContainer().getId()))))) {
                ((TeamContainer)item1.getTeamContainers().get(0)).setContainer(container);
            }
        } else {
            savedItem_.setBacklogSequence(item1.getBacklogSequence());
        }
        String sessionId = ((SessionBoard)item1.getSessionBoards().get(0)).getId();
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionId));
        if (updateDate) {
            savedItem_.applySprintDates(sessionBoard.getSession(), null, null);
        }
        savedItem_.setMetaMap(item1.getMetaMap());
        savedItem_.setJiraFieldMap(item1.getJiraFieldMap());
        savedItem_ = (Item)this.itemRepository.save((Object)savedItem_);
        item1.setJiraId(savedItem_.getJiraId());
        item1.setJiraKey(savedItem_.getJiraKey());
        item1.setJiraProjectKey(savedItem_.getJiraProjectKey());
        this.item = savedItem_;
        this.item.setJiraFieldMap(item1.getJiraFieldMap());
        if (Boolean.TRUE.equals(sessionBoard.getSession().getAlmEnabled()) && updateJira) {
            this.saveItemInJira(sessionBoard, true, Optional.ofNullable("tcsequence"));
        } else {
            this.item = null;
            this.savedItem = null;
        }
        savedItem_.setMetaMap(item1.getMetaMap());
        return savedItem_;
    }

    @RequestMapping(value={"/save/existingJiraItem1"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveExistingJiraItem1(@RequestBody String requestStr) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private String[] resyncOnAddExisting(SearchVO searchVO, JiraFilter filter, AlmConfigurations almConfig, List<BacklogMappingLinks> childLinkMappings, List<JiraFilter> featureFilters, Map<String, Object> ids) throws Exception {
        Session session;
        String itemKeys = searchVO.getItemKeys();
        String syncId = searchVO.getSyncId();
        String sessionBoardId = searchVO.getSessionBoardId();
        String sessionId = searchVO.getSessionId();
        HashMap<String, JiraFilter> filterMap = new HashMap<String, JiraFilter>();
        String tempFilterId = "AddExisting-" + UUID.randomUUID();
        filter.setId(tempFilterId);
        String[] itemKeyList = null;
        ResyncParamsVO resync = null;
        if (itemKeys != null && PropertyValidator.isValid((Object)itemKeys)) {
            for (String itemId : itemKeyList = itemKeys.split(",")) {
                filterMap.put(itemId, filter);
            }
            resync = new ResyncParamsVO();
            resync.forceUpdate = true;
        }
        String itemsStr = null;
        String statusesStr = null;
        Map result = this.almSyncService.retrieveDataAgainstJiraFilter2(filter, almConfig.getId(), childLinkMappings, sessionBoardId, syncId, sessionId, filterMap, false, Boolean.valueOf(false), false, false, resync);
        ObjectMapper mapper = new ObjectMapper();
        if (PropertyValidator.isValid(result.get("features"))) {
            itemsStr = mapper.writeValueAsString(result.get("features"));
        }
        if (PropertyValidator.isValid(result.get("statuses"))) {
            statusesStr = mapper.writeValueAsString(result.get("statuses"));
        }
        if (PropertyValidator.isValid(featureFilters)) {
            featureFilters.remove(new JiraFilter(tempFilterId));
        }
        if (PropertyValidator.isValid((Collection)(session = this.sessionRepository.findById(sessionId)).getItemsAddedFromKanban())) {
            for (int i = 0; i < session.getItemsAddedFromKanban().size(); ++i) {
                Map itemMap = (Map)session.getItemsAddedFromKanban().get(i);
                if (!filterMap.containsKey(itemMap.get("itemId"))) continue;
                session.getItemsAddedFromKanban().remove(i);
                --i;
            }
            this.sessionRepository.save((Object)session);
        }
        return new String[]{itemsStr, statusesStr};
    }

    @RequestMapping(value={"team/extraField/remove/{id}"})
    @ResponseBody
    public ResponseEntity<Object> getTeamSprints(@PathVariable(value="id") String configId) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        AlmConfigurations almConfigurations = (AlmConfigurations)this.almConfigurationsRepository.findOne((Serializable)((Object)configId));
        if (PropertyValidator.isValid((Object)almConfigurations) && PropertyValidator.isValid((Collection)almConfigurations.getTeamMappings())) {
            for (BacklogMapping teamMapping : almConfigurations.getTeamMappings()) {
                teamMapping.setJiraFieldMap(null);
            }
            this.almConfigurationsRepository.save((Object)almConfigurations);
            responseJson.put("success", true);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/save/existingJiraItem"})
    public void saveExistingJiraItem(@RequestBody String reqBody) {
        Item parent = null;
        List jIssues = null;
        JiraIssueLinkType linkType = null;
        ArrayList kItems = new ArrayList();
        Gson gson = new Gson();
        SearchVO searchVO = (SearchVO)gson.fromJson(reqBody, SearchVO.class);
        jIssues = searchVO.getJiraItems();
        linkType = searchVO.getLinkType();
        if (Item.USER_STORY.equals(searchVO.getItemTypeTobeConvertedInto())) {
            String parentLvl1Id = searchVO.getFeatureId();
            TeamContainer teamContainer = null;
            if (PropertyValidator.isValid((Object)searchVO.getTeamContainerId())) {
                teamContainer = (TeamContainer)this.teamContainerRepository.findOne((Serializable)((Object)searchVO.getTeamContainerId()));
            }
            parent = (Item)this.itemRepository.findOne((Serializable)((Object)parentLvl1Id));
            JSONObject pushJson = new JSONObject();
            String[] resync_result = null;
            ArrayList errors = new ArrayList();
            try {
                linkType = (JiraIssueLinkType)searchVO.getLinkTypes().get(0);
                Map idsToAdd = this.planService.addJiraItemAsChild((Collection)jIssues, parent, linkType, teamContainer, errors);
                if (PropertyValidator.isValid((Object)idsToAdd) && !idsToAdd.isEmpty()) {
                    JiraFilter filter = searchVO.getFilter();
                    AlmConfigurations almConfig = (AlmConfigurations)this.almConfigurationsRepository.findOne((Serializable)((Object)searchVO.getAlmConfigId()));
                    ArrayList<JiraFilter> featureFilters = almConfig.getFeatureFilter();
                    if (!PropertyValidator.isValid((Collection)featureFilters)) {
                        featureFilters = new ArrayList<JiraFilter>();
                    }
                    if (!PropertyValidator.isValid((Collection)almConfig.getFeatureMappings())) {
                        almConfig.setFeatureMappings(new ArrayList());
                    }
                    if (PropertyValidator.isValid((Object)filter)) {
                        filter.setFilterFetchedBy(JiraUtils.getProfileAlmUser((AlmAccount)almConfig.getAlmAccount()));
                        featureFilters.add(filter);
                        filter.setJql("key in ('" + parent.getJiraKey() + "')");
                        filter.setFeatureLinkMappings(new ArrayList());
                        filter.getFeatureLinkMappings().add(new BacklogMappingLinks(parent.getJiraProjectKey(), parent.getLinkTypes()));
                        searchVO.setItemKeys(parent.getJiraId());
                    }
                    almConfig.setFeatureFilter(featureFilters);
                    resync_result = this.resyncOnAddExisting(searchVO, searchVO.getFilter(), almConfig, searchVO.getFilter().getFeatureLinkMappings(), featureFilters, idsToAdd);
                }
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            finally {
                try {
                    pushJson.put("addExisting", true);
                    pushJson.put("isJira", true);
                    pushJson.put("type", (Object)"US");
                    if (resync_result != null && resync_result.length > 1) {
                        pushJson.put("items", (Object)resync_result[0]);
                        pushJson.put("statuses", (Object)resync_result[1]);
                    }
                    pushJson.put("push", (Object)"Self");
                    pushJson.put("metaMap", (Object)searchVO.getMetaMap());
                    pushJson.put("errors", errors);
                    if (!PropertyValidator.isValid((Object)searchVO.getRequestId())) {
                        PushSender.sendMsg((String)pushJson.toString());
                    } else {
                        this.pushResponseRepository.save((Object)new PushResponse(searchVO.getRequestId(), pushJson.toString()));
                    }
                }
                catch (JSONException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
        }
    }

    private void pushAlmError(ViztrendJiraException e, Item item, User loggedInUser) {
        item.setErrorInAlmSync(Boolean.valueOf(true));
        item.setAlmErrorMessage(e.getMessage());
        this.itemRepository.save((Object)item);
        this.almErrorRepository.save((Object)AlmErrorUtils.buildAlmErrorObj((Item)item, (String)((SessionBoard)item.getSessionBoards().get(0)).getId(), (User)loggedInUser, (ViztrendJiraException)e, (Boolean)false));
        PushSender.sendMsg((String)AlmErrorUtils.buildAlmPushJson((Item)item, (String)((SessionBoard)item.getSessionBoards().get(0)).getId(), (String)"AlmError", (String)e.getMessage(), (Boolean)false, (Boolean)false));
    }

    @RequestMapping(value={"/save/link"})
    @ResponseBody
    public ResponseEntity<Object> saveLink(@RequestBody String requestBody) {
        try {
            Gson gson = new Gson();
            9 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestMap = (HashMap)gson.fromJson(requestBody, T.getType());
            String itemJson = (String)requestMap.get("item");
            Boolean syncJira = (Boolean)requestMap.get("syncJira");
            String jDepId = (String)requestMap.get("jiraDependencyId");
            String inwardIssueId = (String)requestMap.get("inwardIssue");
            String outwardIssueId = (String)requestMap.get("outwardIssue");
            String linkType = (String)requestMap.get("type");
            String almAccountId = (String)requestMap.get("almAccountId");
            String syncId = (String)requestMap.get("syncId");
            String requestId = (String)requestMap.get("requestId");
            String sessionBoardId = (String)requestMap.get("sessionBoardId");
            Map oldBoardIds = (Map)requestMap.get("oldStateBoardIds");
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            Item item = (Item)mapper.readValue(itemJson, mapper.getTypeFactory().constructType(Item.class));
            List linkIdsBeingUpdated = (List)requestMap.get("linkIds");
            ArrayList linksBeingUpdated = new ArrayList();
            ArrayList<String> sessionBoardIds = new ArrayList<String>();
            ArrayList linkIds = new ArrayList();
            for (int i = 0; i < item.getItemLinks().size(); ++i) {
                ItemLink link = (ItemLink)item.getItemLinks().get(i);
                if (link.getSessionBoardId() != null && !Boolean.TRUE.equals(link.getLost())) {
                    if (PropertyValidator.isValid((Object)oldBoardIds) && oldBoardIds.containsKey(link.getId())) {
                        sessionBoardIds.add((String)oldBoardIds.get(link.getId()));
                    } else {
                        sessionBoardIds.add(link.getSessionBoardId());
                    }
                }
                if (link.getId() == null) {
                    SessionBoard sessionBoard;
                    Session session;
                    if (PropertyValidator.isValid((Object)link.getWfStatus())) {
                        if (link.getWfStatus().getCategory().equals("Done")) {
                            link.setResolvedOn(new Date());
                        } else {
                            link.setResolvedOn(null);
                        }
                    }
                    if (PropertyValidator.isValid((Object)(session = (sessionBoard = this.sessionBoardRepository.findById(link.getSessionBoardId())).getSession()).getDependencyPrefix())) {
                        link.setCustomId(Integer.valueOf(this.customRepository.getNextSeq(session.getId(), null, null)).intValue());
                    }
                    try {
                        int index = i;
                        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                    }
                    catch (Exception ex) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)ex));
                    }
                    continue;
                }
                if (linkIdsBeingUpdated == null) continue;
                linkIdsBeingUpdated.forEach(id -> {
                    if (id.equals(link.getId())) {
                        linksBeingUpdated.add(link);
                        linkIds.add(new ObjectId(link.getId()));
                        return;
                    }
                });
            }
            ArrayList<Boolean> archive = new ArrayList<Boolean>();
            archive.add(true);
            archive.add(false);
            Query query = new Query();
            if (PropertyValidator.isValid(sessionBoardIds)) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoardId").in(sessionBoardIds));
            }
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(linkIds));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").in(archive));
            List savedLinks = this.customRepositoryImpl.getMongoTemplate().find(query, ItemLink.class);
            HashMap<String, ItemLink> map = new HashMap<String, ItemLink>();
            for (ItemLink savedLink : savedLinks) {
                map.put(savedLink.getId(), savedLink);
            }
            savedLinks.clear();
            sessionBoardIds.clear();
            linkIds.clear();
            List linkedAlmLinks = null;
            HashMap<String, Object> response = new HashMap<String, Object>();
            for (int i = 0; i < linksBeingUpdated.size(); ++i) {
                ItemLink link = (ItemLink)linksBeingUpdated.get(i);
                ItemLink savedLink = (ItemLink)map.get(link.getId());
                if (savedLink != null) {
                    if (Boolean.TRUE.equals(link.getLost())) {
                        link.setLost(null);
                    } else {
                        link.setSourceUserStoryId(savedLink.getSourceUserStoryId());
                        link.setTargetUserStoryId(savedLink.getTargetUserStoryId());
                    }
                    if (!savedLink.getStatus().equals(link.getStatus())) {
                        if (link.getStatus().equals("Open")) {
                            link.setResolvedOn(null);
                        } else {
                            link.setResolvedOn(new Date());
                        }
                    }
                    if (PropertyValidator.isValid((Object)savedLink.getWfStatus()) && !savedLink.getWfStatus().equals((Object)link.getWfStatus())) {
                        this.startJiraNotificationThread(link, savedLink, "dependency_statuschange_template", Boolean.valueOf(false));
                    }
                    if (!(link.getResponsible() == null && savedLink.getResponsible() == null || link.getResponsible() != null && savedLink.getResponsible() != null && link.getResponsible().getId().equals(savedLink.getResponsible().getId()))) {
                        this.startJiraNotificationThread(link, savedLink, "dependency_responsible_template", Boolean.valueOf(false));
                        if (PropertyValidator.isValid((Object)savedLink.getResponsible())) {
                            this.startJiraNotificationThread(link, savedLink, "dependency_old_responsible_template", Boolean.valueOf(true));
                        }
                    }
                    link.setOriginItemId(savedLink.getOriginItemId());
                    link.setDuplicateOfId(savedLink.getDuplicateOfId());
                    link.setSessionBoardId(sessionBoardId);
                    if (savedLink.getCreatedBy() != null) {
                        link.setCreatedBy(savedLink.getCreatedBy());
                    }
                    if (savedLink.getCreatedOn() != null) {
                        link.setCreatedOn(savedLink.getCreatedOn());
                    }
                }
                if (!PropertyValidator.isValid((Object)link.getAlmLinkId())) continue;
                linkedAlmLinks = (List)this.almSyncService.syncKendisAndAlmLink((Object)link);
            }
            Item savedItem = (Item)this.itemRepository.findOne((Serializable)((Object)item.getId()));
            List itemLinks = this.itemLinkRepository.save((Iterable)item.getItemLinks());
            if (!PropertyValidator.isValid((Collection)savedItem.getItemLinks())) {
                savedItem.setItemLinks(new ArrayList());
            }
            if (!savedItem.getItemLinks().contains(itemLinks.get(0))) {
                savedItem.getItemLinks().addAll(itemLinks);
            }
            if (PropertyValidator.isValid((Object)item.getMetaMap())) {
                Gson gson2 = new GsonBuilder().registerTypeAdapter(Date.class, (json, typeOfT, context) -> new Date(json.getAsJsonPrimitive().getAsLong())).registerTypeAdapter(Date.class, (date, type, jsonSerializationContext) -> new JsonPrimitive((Number)date.getTime())).create();
                HashMap metaMap = (HashMap)gson.fromJson(item.getMetaMap(), T.getType());
                metaMap.put("saveLinks", itemLinks);
                savedItem.setMetaMap(gson2.toJson((Object)metaMap));
            }
            savedItem.putLastUpdatedValue(Item.Actions.itemLink.name(), itemLinks.get(0));
            this.itemRepository.save((Object)savedItem);
            if (Boolean.TRUE.equals(syncJira)) {
                User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            }
            this.userService.setOnboardingMeta("Create_Dependencies", true);
            response.put("itemLink", itemLinks.get(0));
            response.put("linkedAlmLinks", linkedAlmLinks);
            return new ResponseEntity(response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/save/links"})
    @ResponseBody
    public ResponseEntity<Object> saveLinks(@RequestBody String requestBody) {
        try {
            Gson gson = new Gson();
            12 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestMap = (HashMap)gson.fromJson(requestBody, T.getType());
            String itemJson = (String)requestMap.get("item");
            String syncId = (String)requestMap.get("syncId");
            String requestId = (String)requestMap.get("requestId");
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            Item item = (Item)mapper.readValue(itemJson, mapper.getTypeFactory().constructType(Item.class));
            List linkIdsBeingUpdated = (List)requestMap.get("linkIds");
            ArrayList<ItemLink> linksBeingUpdated = new ArrayList<ItemLink>();
            SessionBoard sessionBoard = this.sessionBoardRepository.findById(((ItemLink)item.getItemLinks().get(0)).getSessionBoardId());
            Session session = sessionBoard.getSession();
            for (int i = 0; i < item.getItemLinks().size(); ++i) {
                ItemLink link2 = (ItemLink)item.getItemLinks().get(i);
                if (link2.getId() == null) {
                    if (PropertyValidator.isValid((Object)link2.getWfStatus())) {
                        if (link2.getWfStatus().getCategory().equals("Done")) {
                            link2.setResolvedOn(new Date());
                        } else {
                            link2.setResolvedOn(null);
                        }
                    }
                    if (PropertyValidator.isValid((Object)session.getDependencyPrefix())) {
                        link2.setCustomId(Integer.valueOf(this.customRepository.getNextSeq(session.getId(), null, null)).intValue());
                    }
                    try {
                        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                    }
                    catch (Exception ex) {
                        StringUtils.getTraceString((Throwable)ex);
                    }
                    continue;
                }
                if (linkIdsBeingUpdated == null) continue;
                linkIdsBeingUpdated.forEach(id -> {
                    if (id.equals(link2.getId())) {
                        linksBeingUpdated.add(link2);
                        return;
                    }
                });
            }
            linksBeingUpdated.forEach(link -> {
                ItemLink savedLink = (ItemLink)this.itemLinkRepository.findOne((Serializable)((Object)link.getId()));
                if (!savedLink.getStatus().equals(link.getStatus())) {
                    if (link.getStatus().equals("Open")) {
                        link.setResolvedOn(null);
                    } else {
                        link.setResolvedOn(new Date());
                    }
                }
            });
            Item savedItem = (Item)this.itemRepository.findOne((Serializable)((Object)item.getId()));
            JiraUtils.saveLinks((Item)savedItem, (List)item.getItemLinks(), (String)syncId, (String)requestId);
            List itemLinks = this.itemLinkRepository.save((Iterable)item.getItemLinks());
            if (!PropertyValidator.isValid((Collection)savedItem.getItemLinks())) {
                savedItem.setItemLinks(new ArrayList());
            }
            savedItem.getItemLinks().addAll(itemLinks);
            if (PropertyValidator.isValid((Object)item.getMetaMap())) {
                HashMap metaMap = (HashMap)gson.fromJson(item.getMetaMap(), T.getType());
                metaMap.put("saveLinks", itemLinks);
                savedItem.setMetaMap(gson.toJson((Object)metaMap));
            }
            savedItem.putLastUpdatedValue(Item.Actions.itemLinks.name(), (Object)itemLinks);
            this.itemRepository.save((Object)savedItem);
            this.userService.setOnboardingMeta("Create_Dependencies", true);
            return new ResponseEntity((Object)itemLinks, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("request : /save/links");
            LOGGER.error("requestrequestBody : " + requestBody);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/remove/link"})
    public ResponseEntity<Object> removeLink(@RequestBody Item item) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            Item savedItem = (Item)this.itemRepository.findOne((Serializable)((Object)item.getId()));
            ItemLink linktodel = null;
            for (ItemLink il : savedItem.getItemLinks()) {
                if (!PropertyValidator.isValid((Object)il) || !PropertyValidator.isValid((Object)il.getId()) || !il.getId().equals(((ItemLink)item.getItemLinks().get(0)).getId())) continue;
                linktodel = il;
            }
            if (!PropertyValidator.isValid(linktodel)) {
                linktodel = (ItemLink)item.getItemLinks().get(0);
            } else {
                this.startJiraNotificationThread(linktodel, linktodel, "dependency_delete_template", Boolean.valueOf(false));
            }
            List linkedAlmLinks = null;
            linkedAlmLinks = JiraUtils.removeLink((ItemLink)linktodel, (Item)savedItem, (boolean)((ItemLink)item.getItemLinks().get(0)).isRemoveAlmLink());
            this.customRepository.deleteItemLink(linktodel);
            savedItem.setMetaMap(item.getMetaMap());
            savedItem.getItemLinks().remove(linktodel);
            savedItem.putLastUpdatedValue(Item.Actions.itemLinkRemoved.name(), (Object)linktodel);
            this.itemRepository.save((Object)savedItem);
            response.put("success", true);
            response.put("linkedAlmLinks", linkedAlmLinks);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/resetSequences"})
    public void resetSequences(@RequestBody String requestPayload) {
        Gson g = new Gson();
        14 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(requestPayload, T.getType());
        ArrayList teamContainers = (ArrayList)reqbody.get("teamContainers");
        List tcs = this.teamContainerRepository.findByIdIn((List)teamContainers);
        Double sequence = new Double(System.nanoTime() / 100000L);
        for (TeamContainer tc : tcs) {
            sequence = sequence + 1000.0;
            tc.setSequence(sequence);
        }
        this.teamContainerRepository.save((Iterable)tcs);
    }

    @RequestMapping(value={"/save/association"})
    public Item saveAssociation(@RequestBody Item item1) {
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        this.savedItem = (Item)this.itemRepository.findOne((Serializable)((Object)item1.getId()));
        if (this.savedItem.getPhoenixSequence() == null) {
            this.savedItem.setPhoenixSequence(this.savedItem.maxPhoenixSequence());
        }
        TeamContainer teamContainer = new TeamContainer();
        teamContainer.setId(((TeamContainer)item1.getTeamContainers().get(0)).getId());
        teamContainer.setContainer(((TeamContainer)item1.getTeamContainers().get(0)).getContainer());
        teamContainer.setTeam(((TeamContainer)item1.getTeamContainers().get(0)).getTeam());
        teamContainer.setSequence(((TeamContainer)item1.getTeamContainers().get(0)).getSequence());
        ((TeamContainer)item1.getTeamContainers().get(0)).setIsActive(Boolean.valueOf(true));
        teamContainer.setIsActive(Boolean.valueOf(true));
        if (PropertyValidator.isValid((Object)teamContainer.getId())) {
            TeamContainer savedTC = (TeamContainer)this.teamContainerRepository.findOne((Serializable)((Object)teamContainer.getId()));
            teamContainer.setOriginItemId(savedTC.getOriginItemId());
            teamContainer.setDuplicateOfId(savedTC.getDuplicateOfId());
        }
        teamContainer = (TeamContainer)this.teamContainerRepository.save((Object)teamContainer);
        String sessionId = ((SessionBoard)item1.getSessionBoards().get(0)).getId();
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionId));
        if (!PropertyValidator.isValid((Collection)this.savedItem.getTeamContainers())) {
            this.savedItem.setTeamContainers(new ArrayList());
        }
        if (!PropertyValidator.isValid((Object)((TeamContainer)item1.getTeamContainers().get(0)).getId())) {
            this.savedItem.getTeamContainers().add(teamContainer);
        } else {
            int index = this.savedItem.getTeamContainers().indexOf(teamContainer);
            if (index > -1) {
                this.savedItem.putLastUpdatedValue("oldContainer", (Object)((TeamContainer)this.savedItem.getTeamContainers().get(index)).getContainer());
                this.savedItem.putLastUpdatedValue("oldTeam", (Object)((TeamContainer)this.savedItem.getTeamContainers().get(index)).getTeam());
                this.savedItem.setTeam(((TeamContainer)this.savedItem.getTeamContainers().get(index)).getTeam());
                this.savedItem.setContainer(((TeamContainer)this.savedItem.getTeamContainers().get(index)).getContainer());
                ((TeamContainer)this.savedItem.getTeamContainers().get(index)).setContainer(((TeamContainer)item1.getTeamContainers().get(0)).getContainer());
                ((TeamContainer)this.savedItem.getTeamContainers().get(index)).setTeam(((TeamContainer)item1.getTeamContainers().get(0)).getTeam());
                ((TeamContainer)this.savedItem.getTeamContainers().get(index)).setSequence(((TeamContainer)item1.getTeamContainers().get(0)).getSequence());
                this.savedItem.putLastUpdatedValue(Item.Actions.teamContainer.name(), (Object)teamContainer);
            }
        }
        if ("nexus".equals(sessionBoard.getSession().getSessionType())) {
            this.savedItem.getTeamContainers().clear();
            this.savedItem.getTeamContainers().add(teamContainer);
        }
        this.savedItem.setMetaMap(item1.getMetaMap());
        this.savedItem = (Item)this.itemRepository.save((Object)this.savedItem);
        this.item = item1;
        Gson gson = new Gson();
        15 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap paramMap = (HashMap)gson.fromJson(item1.getMetaMap(), T.getType());
        boolean kendisOnly = true;
        TeamContainer finalTc = teamContainer;
        String eventType = (String)paramMap.get("event");
        if (PropertyValidator.isValid((Object)sessionBoard.getSession().getAlmEnabled()) && sessionBoard.getSession().getAlmEnabled().booleanValue() && PropertyValidator.isValid((Object)this.savedItem.getJiraProjectKey())) {
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            kendisOnly = false;
        }
        if (kendisOnly && PropertyValidator.isValid((Object)eventType) && eventType.equals("CrossCellSort")) {
            this.planService.updateChildrenInTcs(sessionBoard, finalTc);
        }
        this.item = (Item)this.itemRepository.findOne((Serializable)((Object)item1.getId()));
        return this.item;
    }

    @RequestMapping(value={"/remove/association"})
    public Item removeAssociation(@RequestBody Item item) {
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        TeamContainer teamContainer = (TeamContainer)this.teamContainerRepository.findOne((Serializable)((Object)((TeamContainer)item.getTeamContainers().get(0)).getId()));
        Item savedItem = null;
        if (PropertyValidator.isValid((Object)item.getType()) && item.getType().equals("Feature")) {
            ArrayList<TeamContainer> tms = new ArrayList<TeamContainer>();
            tms.add(teamContainer);
            List userstories = this.itemRepository.findByTypeAndParentAndTeamContainersIn(Item.USER_STORY, item, tms);
            for (Item us : userstories) {
                ArrayList<TeamContainer> tmpUSTCs = new ArrayList<TeamContainer>();
                List usTCs = us.getTeamContainers();
                for (int i = 0; i < usTCs.size(); ++i) {
                    TeamContainer usTC = (TeamContainer)usTCs.get(i);
                    us.getTeamContainers().remove(teamContainer);
                    if (!usTC.getId().equals(teamContainer.getId())) continue;
                    tmpUSTCs.add(usTC);
                }
                us.getTeamContainers().removeAll(tmpUSTCs);
            }
            List userstories_ = this.itemRepository.save((Iterable)userstories);
            List itemLinks = this.itemLinkRepository.findBySourceTeamContainerIdOrTargetTeamContainerId(teamContainer.getId(), teamContainer.getId());
            KendisUtils.archiveItemLinks((ItemLinkRepository)this.itemLinkRepository, (List)itemLinks);
            List itemsNeedToUpdated = this.itemRepository.findByItemLinksIn(itemLinks);
            if (PropertyValidator.isValid((Collection)itemsNeedToUpdated)) {
                for (Item item2 : itemsNeedToUpdated) {
                    item2.getItemLinks().removeAll(itemLinks);
                }
                this.itemRepository.save((Iterable)itemsNeedToUpdated);
            }
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        } else if (PropertyValidator.isValid((Object)item.getType()) && item.getType().equals(Item.USER_STORY)) {
            List linkedItems;
            savedItem = (Item)this.itemRepository.findOne((Serializable)((Object)item.getId()));
            List itemLinks = this.itemLinkRepository.findByTargetUserStoryIdOrSourceUserStoryId(savedItem.getId(), savedItem.getId());
            if (PropertyValidator.isValid((Collection)itemLinks) && PropertyValidator.isValid((Collection)(linkedItems = this.itemRepository.findByItemLinksIn(itemLinks)))) {
                for (Item linkedItem : linkedItems) {
                    linkedItem.getItemLinks().removeAll(itemLinks);
                }
                this.itemRepository.save((Iterable)linkedItems);
            }
            if (PropertyValidator.isValid((Object)savedItem.getJiraId())) {
                ArrayList items = new ArrayList();
                items.add(savedItem);
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            }
        }
        savedItem = (Item)this.itemRepository.findOne((Serializable)((Object)item.getId()));
        savedItem.setMetaMap(item.getMetaMap());
        ArrayList<TeamContainer> tmpTCs = new ArrayList<TeamContainer>();
        for (TeamContainer itmTC : savedItem.getTeamContainers()) {
            if (!itmTC.getId().equals(teamContainer.getId())) continue;
            tmpTCs.add(itmTC);
        }
        savedItem.getTeamContainers().removeAll(tmpTCs);
        String itemMetaMap = item.getMetaMap();
        savedItem = (Item)this.itemRepository.save((Object)savedItem);
        savedItem.setMetaMap(itemMetaMap);
        return savedItem;
    }

    @RequestMapping(value={"/containers"})
    public List<Container> getContainers() {
        return this.containerRepository.findAll();
    }

    @RequestMapping(value={"/save/container"})
    public Container saveContainers(@RequestBody Container container) {
        return (Container)this.containerRepository.save((Object)container);
    }

    @RequestMapping(value={"/container/{id}"})
    public Container getContainer(@PathVariable(value="id") String id) {
        return (Container)this.containerRepository.findOne((Serializable)((Object)id));
    }

    @RequestMapping(value={"/teams"})
    public List<Team> getTeams() {
        List teams = this.teamRepository.findAll();
        return teams;
    }

    @RequestMapping(value={"/team/{id}"})
    public Team getTeam(@PathVariable(value="id") String id) {
        return (Team)this.teamRepository.findOne((Serializable)((Object)id));
    }

    private void createDefaultData(User user, String tenant) {
        WorkSpace defaultWorkSpace = new WorkSpace();
        defaultWorkSpace.setTitle("Default Collection");
        defaultWorkSpace.setDefault(true);
        if (PropertyValidator.isValid((Object)tenant)) {
            defaultWorkSpace.setTenant(tenant);
        }
        defaultWorkSpace = (WorkSpace)this.workSpaceRepository.save((Object)defaultWorkSpace);
        Group group = new Group();
        group.setTitle("Default Group");
        if (PropertyValidator.isValid((Object)tenant)) {
            group.setTenant(tenant);
        }
        this.groupRepository.save((Object)group);
        Role adminRole = new Role();
        adminRole.setTitle("Admin");
        if (PropertyValidator.isValid((Object)tenant)) {
            adminRole.setTenant(tenant);
        }
        Role userRole = new Role();
        userRole.setTitle("User");
        HashSet<String> userRestrictions = new HashSet<String>();
        userRestrictions.add(EnumPermission.CREATE_SESSION.getCode());
        userRestrictions.add(EnumPermission.EDIT_SESSION.getCode());
        userRestrictions.add(EnumPermission.DELETE_SESSION.getCode());
        userRestrictions.add(EnumPermission.STATE_UPDATE.getCode());
        userRestrictions.add(EnumPermission.LOCK_SESSION.getCode());
        userRole.setRestrictions(userRestrictions);
        if (PropertyValidator.isValid((Object)tenant)) {
            userRole.setTenant(tenant);
        }
        Role readOnlyRole = new Role();
        readOnlyRole.setTitle("Read-Only");
        if (PropertyValidator.isValid((Object)tenant)) {
            readOnlyRole.setTenant(tenant);
        }
        HashSet<String> readOnlyRestrictions = new HashSet<String>();
        List<EnumPermission> permissions = Arrays.asList(EnumPermission.values());
        for (EnumPermission enumPermission : permissions) {
            readOnlyRestrictions.add(enumPermission.getCode());
        }
        readOnlyRole.setRestrictions(readOnlyRestrictions);
        ArrayList<Role> defaultRoles = new ArrayList<Role>();
        defaultRoles.add(adminRole);
        defaultRoles.add(userRole);
        defaultRoles.add(readOnlyRole);
        this.roleRepository.save(defaultRoles);
        if (PropertyValidator.isValid((Object)user)) {
            WorkSpaceAccessRole accessRole = new WorkSpaceAccessRole();
            accessRole.setWorkSpace(defaultWorkSpace);
            accessRole.setUser(user);
            if (PropertyValidator.isValid((Object)tenant)) {
                accessRole.setTenant(tenant);
            }
            EnumStatusCategory[] roles = new ArrayList();
            roles.add(adminRole);
            accessRole.setRoles(roles);
            this.workSpaceAccessRoleRepository.save((Object)accessRole);
        }
        this.workSpaceTypeService.createDefaultWorkSpaceType();
        WorkFlow defaultScheme = new WorkFlow();
        defaultScheme.setTitle("Default Workflow");
        defaultScheme.setDefault(true);
        if (PropertyValidator.isValid((Object)tenant)) {
            defaultScheme.setTenant(tenant);
        }
        defaultScheme = (WorkFlow)this.workFlowRepository.save((Object)defaultScheme);
        for (EnumStatusCategory category : EnumStatusCategory.values()) {
            ArrayList<Status> statuses;
            if (category.getCode().equals("ToDo")) {
                Status status1 = new Status();
                status1.setTitle("Open");
                status1.setCategory(category.getCode());
                status1.setColor("#f2930c");
                status1.setWorkFlow(defaultScheme);
                if (PropertyValidator.isValid((Object)tenant)) {
                    status1.setTenant(tenant);
                }
                statuses = new ArrayList<Status>();
                statuses.add(status1);
                this.statusRepository.save(statuses);
                continue;
            }
            if (category.getCode().equals("InProgress")) {
                Status status4 = new Status();
                status4.setTitle("In Progress");
                status4.setCategory(category.getCode());
                status4.setColor("#6498d8");
                status4.setWorkFlow(defaultScheme);
                if (PropertyValidator.isValid((Object)tenant)) {
                    status4.setTenant(tenant);
                }
                this.statusRepository.save((Object)status4);
                continue;
            }
            if (!category.getCode().equals("Done")) continue;
            Status status7 = new Status();
            status7.setTitle("Done");
            status7.setCategory(category.getCode());
            status7.setColor("#00BEA0");
            status7.setWorkFlow(defaultScheme);
            if (PropertyValidator.isValid((Object)tenant)) {
                status7.setTenant(tenant);
            }
            statuses = new ArrayList();
            statuses.add(status7);
            this.statusRepository.save(statuses);
        }
        this.tfSservice.createDefaultDependencyWorkflow();
        StateScheme defaulStatetScheme = new StateScheme();
        defaulStatetScheme.setTitle("Default State Scheme");
        defaulStatetScheme.setDefault(true);
        if (PropertyValidator.isValid((Object)tenant)) {
            defaulStatetScheme.setTenant(tenant);
        }
        defaulStatetScheme = (StateScheme)this.stateSchemeRepository.save((Object)defaulStatetScheme);
        StateCategory stateCategory0 = new StateCategory();
        stateCategory0.setTitle("Misc.");
        if (PropertyValidator.isValid((Object)tenant)) {
            stateCategory0.setTenant(tenant);
        }
        stateCategory0 = (StateCategory)this.stateCategoryRepository.save((Object)stateCategory0);
        State state0 = new State();
        state0.setTitle("Draft");
        state0.setActionNarrative("Draft");
        state0.setDoneNarrative("Draft");
        state0.setCategory(stateCategory0);
        state0.setSequence(Integer.valueOf(0));
        state0.setStateScheme(defaulStatetScheme);
        if (PropertyValidator.isValid((Object)tenant)) {
            state0.setTenant(tenant);
        }
        this.stateRepository.save((Object)state0);
        StateCategory stateCategory1 = new StateCategory();
        stateCategory1.setTitle("Planning");
        if (PropertyValidator.isValid((Object)tenant)) {
            stateCategory1.setTenant(tenant);
        }
        stateCategory1 = (StateCategory)this.stateCategoryRepository.save((Object)stateCategory1);
        State state1 = new State();
        state1.setTitle("Planning");
        state1.setActionNarrative("Start Planning");
        state1.setDoneNarrative("Planned");
        state1.setCategory(stateCategory1);
        state1.setSequence(Integer.valueOf(1));
        state1.setStateScheme(defaulStatetScheme);
        if (PropertyValidator.isValid((Object)tenant)) {
            state1.setTenant(tenant);
        }
        this.stateRepository.save((Object)state1);
        StateCategory stateCategory2 = new StateCategory();
        stateCategory2.setTitle("Execution");
        if (PropertyValidator.isValid((Object)tenant)) {
            stateCategory2.setTenant(tenant);
        }
        stateCategory2 = (StateCategory)this.stateCategoryRepository.save((Object)stateCategory2);
        State state2 = new State();
        state2.setTitle("Tracking");
        state2.setActionNarrative("Start Tracking");
        state2.setDoneNarrative("Tracked");
        state2.setSequence(Integer.valueOf(2));
        state2.setCategory(stateCategory2);
        state2.setStateScheme(defaulStatetScheme);
        if (PropertyValidator.isValid((Object)tenant)) {
            state2.setTenant(tenant);
        }
        this.stateRepository.save((Object)state2);
        StateCategory stateCategory3 = new StateCategory();
        stateCategory3.setTitle("Done");
        if (PropertyValidator.isValid((Object)tenant)) {
            stateCategory3.setTenant(tenant);
        }
        stateCategory3 = (StateCategory)this.stateCategoryRepository.save((Object)stateCategory3);
        State state3 = new State();
        state3.setTitle("Close");
        state3.setActionNarrative("Close");
        state3.setDoneNarrative("Closed");
        state3.setCategory(stateCategory3);
        state3.setSequence(Integer.valueOf(3));
        state3.setIsFinal(Boolean.valueOf(true));
        state3.setStateScheme(defaulStatetScheme);
        if (PropertyValidator.isValid((Object)tenant)) {
            state3.setTenant(tenant);
        }
        this.stateRepository.save((Object)state3);
        IssueType enabler = new IssueType(null, "Enabler", "#fbf1d8");
        enabler.setColorUpdated(Boolean.valueOf(true));
        if (PropertyValidator.isValid((Object)tenant)) {
            enabler.setTenant(tenant);
        }
        IssueType risk = new IssueType(null, "Risk", "#fde9e9");
        risk.setColorUpdated(Boolean.valueOf(true));
        if (PropertyValidator.isValid((Object)tenant)) {
            risk.setTenant(tenant);
        }
        IssueType goal = new IssueType(null, "Goal", "#e9f7ef");
        goal.setColorUpdated(Boolean.valueOf(true));
        if (PropertyValidator.isValid((Object)tenant)) {
            goal.setTenant(tenant);
        }
        ArrayList<IssueType> issueTypes = new ArrayList<IssueType>();
        issueTypes.add(enabler);
        issueTypes.add(risk);
        issueTypes.add(goal);
        this.issueTypeRepository.save(issueTypes);
        if (!PropertyValidator.isValid((Collection)this.configRepository.findAll())) {
            Config appConfigSetting = new Config();
            this.configRepository.save((Object)appConfigSetting);
        }
        AlmAccount almAccount = null;
        JiraConnectVO connectVO = this.almSyncService.getConnectAccountByCompanyPrefix(UserContextUtil.getUserContext().getCurrentCompanyPrefix());
        if (PropertyValidator.isValid((Object)connectVO)) {
            almAccount = new AlmAccount("jira", "Jira Connect", connectVO.getJiraHostUrl(), null, null, null, null, null, connectVO.getId(), true, null);
            almAccount = (AlmAccount)this.almAccountRepository.save((Object)almAccount);
        }
        if (PropertyValidator.isValid((Object)user)) {
            user = this.setSyncDefaultData(user, Boolean.valueOf(false));
            this.userRepository.save((Object)user);
        }
    }

    @RequestMapping(value={"/board-list/{id}"})
    @ResponseBody
    public ResponseEntity<Object> getAllOtherBoards(@PathVariable String id) {
        HashMap responseJson = new HashMap();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        HashSet workSpaces = new HashSet();
        List<WorkSpaceAccessRole> workSpaceAccessRoles = new ArrayList();
        if (PropertyValidator.isValid((Object)user) && (user.getIsAdmin().booleanValue() || user.getIsSuperAdmin().booleanValue())) {
            workSpaces = Sets.newHashSet((Iterable)this.workSpaceRepository.findByIsModuleIsFalseOrIsModuleIsNull());
            for (WorkSpace workSpace : workSpaces) {
                WorkSpaceAccessRole accessRole = new WorkSpaceAccessRole();
                accessRole.setWorkSpace(workSpace);
                accessRole.setUser(user);
                workSpaceAccessRoles.add(accessRole);
            }
        } else {
            workSpaceAccessRoles = this.customRepository.findWorkspaceAccessRoles(user);
            for (WorkSpaceAccessRole workSpaceAccessRole : workSpaceAccessRoles) {
                if (!PropertyValidator.isValid((Object)workSpaceAccessRole.getWorkSpace())) continue;
                workSpaces.add(workSpaceAccessRole.getWorkSpace());
            }
        }
        List sessions = new ArrayList();
        List parentBoards = new ArrayList();
        if (PropertyValidator.isValid((Collection)workSpaces)) {
            sessions = this.sessionRepository.findByWorkSpaceIn(new ArrayList(workSpaces));
            parentBoards = this.sessionBoardRepository.findBySessionInAndParentBoardIsNullOrderByCreatedOnDesc(sessions);
        }
        responseJson.put("allBoards", parentBoards);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/all-teams"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getAllTeams() {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        responseJson.put("companyTeams", this.teamRepository.findAll());
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/accessableBoards1"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getAllAccessableBoards1(@RequestBody Map<String, Object> request) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String almAccountId = (String)request.get("almAccountId");
        List projectKeys = (List)request.get("projectKeys");
        Boolean jiraSynapseRTEnabled = (Boolean)request.get("jiraSynapseRTEnabled");
        Boolean almEnabled = (Boolean)request.get("almEnabled");
        if (Boolean.TRUE.equals(almEnabled)) {
            AlmAccount almAccount = AlmUtils.getALMAcount((String)almAccountId, (AlmAccountRepository)this.almAccountRepository);
            HashMap itemTypes = new HashMap();
            if (PropertyValidator.isValid((Object)almAccount)) {
                try {
                    this.fetchJiraIssueTypes(almAccountId, projectKeys, responseJson);
                    if (Boolean.TRUE.equals(jiraSynapseRTEnabled)) {
                        JiraIssueLinkType synapseRTChildsLinkType = new JiraIssueLinkType("synapseRT", "", "SynapseRT (Parent-Child)", "synapseRT", "synapseRT", "synapseRT");
                        synapseRTChildsLinkType.setId("synapseRT");
                        ArrayList<JiraIssueLinkType> synapseRTChildsLinkTypes = new ArrayList<JiraIssueLinkType>();
                        synapseRTChildsLinkTypes.add(synapseRTChildsLinkType);
                        responseJson.put("itemLinkTypes", synapseRTChildsLinkTypes);
                    } else {
                        responseJson.put("itemLinkTypes", this.almSyncService.retrieveJiraIssueLinkTypesList(almAccount, false));
                    }
                    responseJson.put("jiraFields", this.almSyncService.retrieveJiraFieldsJSON(almAccount, false));
                }
                catch (ViztrendJiraException vJe) {
                    responseJson.put("itemLinkTypes", new ArrayList());
                    responseJson.put("jiraFields", new ArrayList());
                    responseJson.put("itemTypes", itemTypes);
                    responseJson.put("error", vJe.getAlmError());
                    responseJson.put("allBoards", new ArrayList());
                    List allIssueTypes = this.issueTypeRepository.findAllByOrderBySequenceAsc();
                    responseJson.put("allIssueTypes", allIssueTypes);
                    responseJson.put("companyTeams", this.teamRepository.findAll());
                    return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
                }
            }
        }
        responseJson.put("allBoards", new ArrayList());
        List allIssueTypes = this.issueTypeRepository.findAllByOrderBySequenceAsc();
        responseJson.put("allIssueTypes", allIssueTypes);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/accessableBoards/{id}"})
    @ResponseBody
    public ResponseEntity<Object> getAllAccessableBoards(@PathVariable String id) {
        SessionBoard sessionBoard;
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        HashSet workSpaces = new HashSet();
        List<WorkSpaceAccessRole> workSpaceAccessRoles = new ArrayList();
        if (PropertyValidator.isValid((Object)user) && (user.getIsAdmin().booleanValue() || user.getIsSuperAdmin().booleanValue())) {
            workSpaces = Sets.newHashSet((Iterable)this.workSpaceRepository.findByIsModuleIsFalseOrIsModuleIsNull());
            for (WorkSpace workSpace : workSpaces) {
                WorkSpaceAccessRole accessRole = new WorkSpaceAccessRole();
                accessRole.setWorkSpace(workSpace);
                accessRole.setUser(user);
                workSpaceAccessRoles.add(accessRole);
            }
        } else {
            workSpaceAccessRoles = this.customRepository.findWorkspaceAccessRoles(user);
            for (WorkSpaceAccessRole workSpaceAccessRole : workSpaceAccessRoles) {
                if (!PropertyValidator.isValid((Object)workSpaceAccessRole.getWorkSpace())) continue;
                workSpaces.add(workSpaceAccessRole.getWorkSpace());
            }
        }
        List sessions = new ArrayList();
        List parentBoards = new ArrayList();
        if (PropertyValidator.isValid((Collection)workSpaces)) {
            sessions = this.sessionRepository.findByWorkSpaceIn(new ArrayList(workSpaces));
            parentBoards = this.sessionBoardRepository.findBySessionInAndParentBoardIsNullOrderByCreatedOnDesc(sessions);
        }
        if ((sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)id))).getSession().getAlmEnabled().booleanValue()) {
            AlmAccount almAcc = AlmUtils.getALMAcount((String)((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getAlmAccount().getId(), (AlmAccountRepository)this.almAccountRepository);
            AlmAccount taggedAlmAccount = JiraUtils.getTaggedAlmUser((User)user, (AlmAccount)almAcc);
            if (PropertyValidator.isValid((Object)taggedAlmAccount)) {
                almAcc = taggedAlmAccount;
            } else {
                almAcc.setIsTaggedUser(Boolean.valueOf(true));
            }
            HashMap itemTypes = new HashMap();
            if (PropertyValidator.isValid((Object)almAcc)) {
                try {
                    ArrayList<String> projectKeys = new ArrayList<String>();
                    if (PropertyValidator.isValid((Collection)((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getFeatureMappings())) {
                        for (BacklogMapping featureMapObj : ((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getFeatureMappings()) {
                            if (!PropertyValidator.isValid((Object)featureMapObj.getProjectKey())) continue;
                            projectKeys.add(featureMapObj.getProjectKey());
                        }
                    }
                    if (PropertyValidator.isValid((Collection)((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getTeamMappings())) {
                        for (BacklogMapping featureMapObj : ((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getTeamMappings()) {
                            if (!PropertyValidator.isValid((Collection)featureMapObj.getProjectKeys())) continue;
                            projectKeys.addAll(featureMapObj.getProjectKeys());
                        }
                    }
                    this.fetchJiraIssueTypes(((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getAlmAccount().getId(), projectKeys, responseJson);
                    if (Boolean.TRUE.equals(sessionBoard.getSession().getJiraSynapseRTEnabled())) {
                        JiraIssueLinkType synapseRTChildsLinkType = new JiraIssueLinkType("synapseRT", "", "SynapseRT (Parent-Child)", "synapseRT", "synapseRT", "synapseRT");
                        synapseRTChildsLinkType.setId("synapseRT");
                        ArrayList<JiraIssueLinkType> synapseRTChildsLinkTypes = new ArrayList<JiraIssueLinkType>();
                        synapseRTChildsLinkTypes.add(synapseRTChildsLinkType);
                        responseJson.put("itemLinkTypes", synapseRTChildsLinkTypes);
                    } else {
                        responseJson.put("itemLinkTypes", this.almSyncService.retrieveJiraIssueLinkTypesList(almAcc, false));
                    }
                    responseJson.put("jiraFields", this.almSyncService.retrieveJiraFieldsJSON(almAcc, false));
                }
                catch (ViztrendJiraException vJe) {
                    responseJson.put("itemLinkTypes", new ArrayList());
                    responseJson.put("jiraFields", new ArrayList());
                    responseJson.put("itemTypes", itemTypes);
                    responseJson.put("error", vJe.getAlmError());
                    return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
                }
            }
        }
        responseJson.put("allBoards", parentBoards);
        List allIssueTypes = this.issueTypeRepository.findAllByOrderBySequenceAsc();
        responseJson.put("allIssueTypes", allIssueTypes);
        responseJson.put("companyTeams", this.teamRepository.findAll());
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/boards-workspaces"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getBoardsWorkspaces(@RequestBody HashMap<String, Object> requestBody) {
        HashMap responseJson = new HashMap();
        try {
            LOGGER.debug("*****getBoards**** -----> /plan/boards-workspaces   START");
            responseJson = this.planService.getUserWorkSpaces(requestBody);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error("*****getBoards**** -----> /plan/boards-workspaces -----> Exception Occurred. ---------------");
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        LOGGER.debug("*****getBoards**** -----> /plan/boards-workspaces   END");
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/boards"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getBoards(@RequestBody HashMap<String, Object> requestBody) {
        HashMap responseJson = new HashMap();
        try {
            LOGGER.debug("*****getBoards**** -----> /plan/boards   START");
            responseJson = this.planService.getBoards(requestBody);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error("*****getBoards**** -----> /plan/boards -----> Exception Occurred. ---------------");
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        LOGGER.debug("*****getBoards**** -----> /plan/boards   END");
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/boards-states"})
    @ResponseBody
    public ResponseEntity<Object> getBoardsStates() {
        HashMap<String, StateScheme> responseJson = new HashMap<String, StateScheme>();
        StateScheme scheme = this.getDefaultStateScheme();
        scheme.setStates(this.stateRepository.findByStateScheme(scheme));
        responseJson.put("stateSchemes", scheme);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/boards-meta"})
    @ResponseBody
    public ResponseEntity<Object> getBoardsMetaNew() {
        User userObject;
        List dependencyStatusSchemes;
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        List teams = this.teamRepository.findAll();
        ArrayList<WorkFlow> statusSchemes = this.customRepository.findAllByTfsProjectIsNullAndWorkflowTypeNullOrGiven("General");
        if (!PropertyValidator.isValid((Collection)statusSchemes)) {
            statusSchemes = new ArrayList<WorkFlow>();
            statusSchemes.add(this.getDefaultWorkFlow());
        }
        if (!PropertyValidator.isValid((Collection)(dependencyStatusSchemes = this.workFlowRepository.findAllByWorkflowType("Dependency")))) {
            dependencyStatusSchemes.add(this.tfSservice.createDefaultDependencyWorkflow());
        }
        if ((userObject = (User)this.userRepository.findOne((Serializable)((Object)user.getId()))).getSkipTutorial() == null) {
            userObject.setSkipTutorial(Integer.valueOf(1));
            user.setSkipTutorial(userObject.getSkipTutorial());
            this.userRepository.save((Object)userObject);
            responseJson.put("skipTutorial", userObject.getSkipTutorial());
        }
        responseJson.put("teams", teams);
        responseJson.put("statusSchemes", statusSchemes);
        responseJson.put("dependencyStatusSchemes", dependencyStatusSchemes);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/boards/meta"})
    @ResponseBody
    public ResponseEntity<Object> getBoardsMeta() {
        User userObject;
        List dependencyStatusSchemes;
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        List teams = this.teamRepository.findAll();
        ArrayList<WorkFlow> statusSchemes = this.customRepository.findAllByTfsProjectIsNullAndWorkflowTypeNullOrGiven("General");
        if (!PropertyValidator.isValid((Collection)statusSchemes)) {
            statusSchemes = new ArrayList<WorkFlow>();
            statusSchemes.add(this.getDefaultWorkFlow());
        }
        if (!PropertyValidator.isValid((Collection)(dependencyStatusSchemes = this.workFlowRepository.findAllByWorkflowType("Dependency")))) {
            dependencyStatusSchemes.add(this.tfSservice.createDefaultDependencyWorkflow());
        }
        if ((userObject = (User)this.userRepository.findOne((Serializable)((Object)user.getId()))).getSkipTutorial() == null) {
            userObject.setSkipTutorial(Integer.valueOf(1));
            user.setSkipTutorial(userObject.getSkipTutorial());
            this.userRepository.save((Object)userObject);
            responseJson.put("skipTutorial", userObject.getSkipTutorial());
        }
        List<WorkSpace> workSpaces = new ArrayList();
        List workSpaceAccessRoles = new ArrayList();
        if (PropertyValidator.isValid((Object)user) && (user.getIsAdmin().booleanValue() || user.getIsSuperAdmin().booleanValue())) {
            workSpaces = this.workSpaceRepository.findByIsModuleIsFalseOrIsModuleIsNull();
        } else {
            if (!PropertyValidator.isValid((Collection)user.getGroups())) {
                user.setGroups(new HashSet());
            }
            workSpaceAccessRoles = this.customRepository.findWorkspaceAccessRoles(user);
            for (WorkSpaceAccessRole workSpaceAccessRole : workSpaceAccessRoles) {
                WorkSpace workspace = workSpaceAccessRole.getWorkSpace();
                if (!PropertyValidator.isValid((Object)workspace) || workspace.getLevel() != null && workspace.getLevel() != -1) continue;
                workSpaces.add(workSpaceAccessRole.getWorkSpace());
            }
        }
        StateScheme scheme = this.getDefaultStateScheme();
        scheme.setStates(this.stateRepository.findByStateScheme(scheme));
        responseJson.put("teams", teams);
        responseJson.put("workSpaces", workSpaces);
        responseJson.put("stateSchemes", scheme);
        responseJson.put("statusSchemes", statusSchemes);
        responseJson.put("dependencyStatusSchemes", dependencyStatusSchemes);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/apply/changes"})
    public void applyChangesToJiraItem() {
        this.webHookSyncService.retrieveAllUnMappedData();
    }

    @RequestMapping(value={"/save/session"})
    public SessionBoard saveBoard(@RequestBody SessionBoardVo sBVo) {
        this.saveSessionBoard(sBVo);
        return null;
    }

    @RequestMapping(value={"/create/session"})
    public SessionBoard createSessionboardForTesting(@RequestBody SessionBoardVo sBVo) {
        SessionBoard savedBoard = this.saveSessionBoard(sBVo);
        return savedBoard;
    }

    @RequestMapping(value={"/save/session_temp"})
    public SessionBoard saveBoardTemp(@RequestBody SessionBoard sessionBoard) {
        sessionBoard.setContainers(this.containerRepository.save((Iterable)sessionBoard.getContainers()));
        if (!PropertyValidator.isValid((Object)sessionBoard.getId())) {
            State draftState = this.stateRepository.findByTitle("Draft");
            sessionBoard.setState(draftState);
            sessionBoard.setCreationDate(new Date());
        }
        Session sessionWrapper = new Session();
        sessionWrapper = sessionBoard.getSession();
        sessionWrapper.setStateScheme(this.getDefaultStateScheme());
        sessionWrapper.setLoadOldObjectivesView(Boolean.valueOf(false));
        sessionWrapper.setAutoFillStartEndDate(true);
        if (PropertyValidator.isValid((Collection)sessionBoard.getContainers())) {
            Date smallestDate = null;
            Date largestDate = null;
            for (int i = 0; i < sessionBoard.getContainers().size(); ++i) {
                Container sprint = (Container)sessionBoard.getContainers().get(i);
                if (PropertyValidator.isValid((Object)sprint.getStartDate())) {
                    if (smallestDate == null) {
                        smallestDate = sprint.getStartDate();
                    } else if (sprint.getStartDate().getTime() < smallestDate.getTime()) {
                        smallestDate = sprint.getStartDate();
                    }
                }
                if (!PropertyValidator.isValid((Object)sprint.getEndDate())) continue;
                if (largestDate == null) {
                    largestDate = sprint.getEndDate();
                    continue;
                }
                if (sprint.getEndDate().getTime() <= largestDate.getTime()) continue;
                largestDate = sprint.getEndDate();
            }
            if (PropertyValidator.isValid(smallestDate)) {
                sessionWrapper.setStartDate(smallestDate);
            }
            if (PropertyValidator.isValid(largestDate)) {
                sessionWrapper.setEndDate(largestDate);
            }
        }
        if (!PropertyValidator.isValid((Object)sessionBoard.getSession().getId())) {
            sessionWrapper.setDisabledForDashboardListing(false);
            sessionWrapper.setHideMilestonesBar(Boolean.FALSE);
        }
        sessionWrapper.setLoadNewStructureMilestones(Boolean.valueOf(true));
        if (PropertyValidator.isValid((Object)sessionBoard.getAlmAccount())) {
            TFSAlmConfigurations almConfiguration;
            AlmAccount almAccount = sessionBoard.getAlmAccount();
            if (almAccount.getType().equals("tfs")) {
                almConfiguration = new TFSAlmConfigurations();
                almConfiguration.setAlmAccount(sessionBoard.getAlmAccount());
                almConfiguration = (TFSAlmConfigurations)this.tfsAlmConfigurationsRepository.save((Object)almConfiguration);
                sessionWrapper.setTfsAlmConfigurations(almConfiguration);
                sessionWrapper.setAlmEnabled(Boolean.valueOf(true));
            } else {
                almConfiguration = new AlmConfigurations();
                almConfiguration.setAlmAccount(sessionBoard.getAlmAccount());
                almConfiguration = (AlmConfigurations)this.almConfigurationsRepository.save((Object)almConfiguration);
                ArrayList<TFSAlmConfigurations> almConfigs = new ArrayList<TFSAlmConfigurations>();
                almConfigs.add(almConfiguration);
                sessionWrapper.setAlmConfigurations(almConfigs);
                sessionWrapper.setAlmEnabled(Boolean.valueOf(true));
                String originUrl = null;
                Boolean isLocalDeployment = new Boolean(this.env.getProperty("isLocalDeployment"));
                originUrl = isLocalDeployment != false ? sessionBoard.getKendisBaseUrl() : UserContextUtil.getUserContext().getCurrentCompany().getUrl();
                try {
                    if (!sessionBoard.getAlmAccount().isUsingJiraConnect()) {
                        AlmAccount almAcc = AlmUtils.getALMAcount((String)sessionBoard.getAlmAccount().getId(), (AlmAccountRepository)this.almAccountRepository);
                        WebhookResponseVO webhookObj = this.webHookSyncService.checkJiraWebhookExist(sessionBoard.getAlmAccount().getId(), almAcc, originUrl);
                        if (!PropertyValidator.isValid((Object)webhookObj)) {
                            try {
                                String webhook = this.webHookSyncService.createWebhook(originUrl + "/webhook", almAcc);
                                Gson gson = new Gson();
                                19 T = new /* Unavailable Anonymous Inner Class!! */;
                                if (!PropertyValidator.isValid((Object)webhook)) {
                                    String errMsg = "Could not create webhook.";
                                    if (PropertyValidator.isValid((Object)almAcc.getJiraOauthToken()) && almAcc.getJiraOauthToken().isCloud()) {
                                        errMsg = "Could not create webhook for jira oauth cloud alm account.";
                                    }
                                    AlmError almError = new AlmError();
                                    almError.setAlmErrorMessage(errMsg);
                                    almError.setHttpErrorCode(Integer.valueOf(500));
                                    throw new ViztrendJiraException(Integer.valueOf(401), errMsg, almError);
                                }
                                HashMap paramMap = (HashMap)gson.fromJson(webhook, T.getType());
                                String jiraWebhookURL = (String)paramMap.get("self");
                                sessionBoard.getAlmAccount().setWebhookURL(jiraWebhookURL);
                                almAcc.setWebhookURL(jiraWebhookURL);
                                this.customRepositoryImpl.updateAlmAccountWebhookURL(almAcc.getId(), jiraWebhookURL);
                            }
                            catch (ViztrendJiraException e) {
                                SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                                User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
                                LOGGER.error("FAILED: Creating Webhook. " + e.getMessage() + "\n " + e.getAlmError());
                                this.almErrorRepository.save((Object)AlmErrorUtils.buildAlmErrorObj(null, (String)sessionBoard.getId(), (User)user, (ViztrendJiraException)e, (Boolean)false));
                            }
                        }
                    }
                }
                catch (ViztrendJiraException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
        }
        this.sessionRepository.save((Object)sessionWrapper);
        sessionBoard.setSession(sessionWrapper);
        sessionBoard = (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard);
        this.customRepository.updateActiveSessionBoard(sessionBoard.getSession().getId(), sessionBoard.getId());
        this.userService.setOnboardingMeta("Create_Board", true);
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("board_created", 1);
        IntercommUtils.post((String)UserContextUtil.getUserContext().getLoggedInUser().getUserName(), vars);
        return sessionBoard;
    }

    private String getHttpScheme() {
        if (this.env.getProperty("redirect.from.http.server.port") != null) {
            return "https";
        }
        return "http";
    }

    @RequestMapping(value={"/session/status"})
    public void changeSessionStatus(@RequestBody SessionBoard sessionBoard) {
        SessionBoard board = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoard.getId()));
        board.setStatus(sessionBoard.getStatus());
        this.sessionBoardRepository.save((Object)board);
        JSONObject pushJson = new JSONObject();
        try {
            pushJson.put("type", (Object)"Board");
            pushJson.put("boardId", (Object)sessionBoard.getId());
            pushJson.put("status", (Object)sessionBoard.getStatus());
            pushJson.put("metaMap", (Object)sessionBoard.getMetaMap());
            PushSender.sendMsg((String)pushJson.toString());
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    @RequestMapping(value={"/move/{sessionId}/{collectionId}"})
    public ResponseEntity<Object> moveBoard(@PathVariable(value="sessionId") String sessionId, @PathVariable(value="collectionId") String collectionId) {
        HashMap<String, String> responseJson = new HashMap<String, String>();
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
        WorkSpace workSpace = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)collectionId));
        if (PropertyValidator.isValid((Object)workSpace)) {
            session.setWorkSpace(workSpace);
            this.sessionRepository.save((Object)session);
            responseJson.put("success", "true");
        } else {
            responseJson.put("success", "false");
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/remove/board/{id}"})
    public void removeBoard(@PathVariable(value="id") String id) {
        this.customRepository.setArchive(id, Boolean.valueOf(true), Session.class);
    }

    @RequestMapping(value={"/archive/board/{id}/{archive}"})
    public ResponseEntity<Object> archiveBoard(@PathVariable(value="id") String id, @PathVariable(value="archive") boolean archive) {
        if (archive) {
            this.customRepository.setRowStatus(id, 1, Session.class);
        } else {
            this.customRepository.setRowStatus(id, 0, Session.class);
        }
        return new ResponseEntity((Object)id, HttpStatus.OK);
    }

    @RequestMapping(value={"/board/export/{id}/{type}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> exportBoard(@PathVariable(value="id") String id, @PathVariable(value="type") String type, @RequestBody Map<String, String> param) {
        Thread t = new Thread(() -> {
            SessionBoard board = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)id));
            String syncId = (String)param.get("syncId");
            try {
                String extension = "xls";
                int exportType = 1;
                if (PropertyValidator.isValid((Object)type) && "csv".equalsIgnoreCase(type)) {
                    extension = "csv";
                    exportType = 0;
                }
                String cleanedSessionTitle = AlmUtils.cleanText((String)board.getSession().getTitle());
                String csvHeader = "Position,Key,Summary,Story Points,Due Date,Status,Created by,Created on,Updated by,Updated on,Type,Card Type,Parent Key,Parent Title,Session Board,Sprints,Teams,Linked Items,Wsjf Score";
                if (param.containsKey("servicenowHeader")) {
                    csvHeader = (String)param.get("servicenowHeader");
                    cleanedSessionTitle = cleanedSessionTitle + "_(importable)";
                }
                String filePath = this.exportService.exportBoardData(id, board, exportType, csvHeader);
                KendisUtils.downloadExportFile((String)syncId, (String)filePath, (String)(cleanedSessionTitle + "." + extension), (PushResponseRepository)this.pushResponseRepository);
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        });
        t.start();
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @RequestMapping(value={"/board/edit/{id}"})
    public ResponseEntity<Object> editBoard(@PathVariable(value="id") String id) {
        try {
            HashMap data = new HashMap();
            return new ResponseEntity(data, HttpStatus.OK);
        }
        catch (ViztrendJiraException vJe) {
            return new ResponseEntity((Object)vJe.getAlmError(), HttpStatus.BAD_REQUEST);
        }
        catch (Exception ve) {
            AlmError almerr = new AlmError();
            almerr.setAlmErrorMessage("Sorry but your board was not able to load. Try Again.");
            almerr.setHttpErrorCode(Integer.valueOf(400));
            return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/almMeta"})
    public ResponseEntity<Object> laodAlmMeta() {
        HashMap<String, List> data = new HashMap<String, List>();
        data.put("workFlow", this.workFlowRepository.findAllByWorkflowTypeOrWorkflowTypeIsNullOrderByCreatedOn("General"));
        data.put("accessRoles", this.getWorkSpaceAccessRoles());
        data.put("permissions", EnumPermission.getAllCodesList());
        return new ResponseEntity(data, HttpStatus.OK);
    }

    private List<WorkSpaceAccessRole> getWorkSpaceAccessRoles() {
        HashSet groups;
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        if (Boolean.TRUE.equals(this.getUserSyncDefaultData(user = (User)this.userRepository.findOne((Serializable)((Object)user.getId()))))) {
            this.createDefaultData(user, null);
        }
        if (!PropertyValidator.isValid((Collection)(groups = user.getGroups()))) {
            groups = new HashSet();
        }
        List workSpaceAccessRoles = this.customRepository.findWorkspaceAccessRoles(user);
        return workSpaceAccessRoles;
    }

    @RequestMapping(value={"/resetsequences"})
    public void resetSequence() {
        List nullSeqItems = this.itemRepository.findBySequenceIsNullOrBacklogSequenceIsNull();
        this.itemRepository.save((Iterable)nullSeqItems);
    }

    @RequestMapping(value={"/resyncjirafields/{requestId}/{almAccId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> resyncJiraFields(@PathVariable(value="requestId") String requestId, @PathVariable(value="almAccId") String almAccId, HttpServletRequest request) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @RequestMapping(value={"/getjirafields"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getJiraFields(@RequestBody HashMap<String, Object> reqbody) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity(new HashMap(), HttpStatus.OK);
    }

    @RequestMapping(value={"/{sessionId}/{id}/auditlog"})
    @ResponseBody
    public ResponseEntity<Object> getSessionBoardAuditLog(@PathVariable(value="sessionId") String sessionId, @PathVariable(value="id") String id) {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        if (PropertyValidator.isValid((Object)id)) {
            List auditLogs = this.auditLogRepository.findBySessionBoardIdOrSessionIdOrderByCreatedOnDesc(id, sessionId);
            responseJson.put("auditlogs", auditLogs);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/{sessionBoardId}/auditlog/{action}/{id}"})
    @ResponseBody
    public ResponseEntity<Object> downloadAuditLogById(@PathVariable(value="sessionBoardId") String sessionBoardId, @PathVariable(value="action") String action, @PathVariable(value="id") String auditLogId) {
        try {
            Gson gson = new Gson();
            AuditLog auditLog = (AuditLog)this.auditLogRepository.findOne((Serializable)((Object)auditLogId));
            if (PropertyValidator.isValid((Object)auditLog.getAuditData())) {
                if (action.equals("download")) {
                    if (auditLog.getEventType().equals("COMPARISON")) {
                        22 T = new /* Unavailable Anonymous Inner Class!! */;
                        HashMap auditbody = (HashMap)gson.fromJson(auditLog.getAuditData(), T.getType());
                        return this.exportService.exportChartDetail("xls", auditbody);
                    }
                    23 T = new /* Unavailable Anonymous Inner Class!! */;
                    HashMap auditbody = (HashMap)gson.fromJson(auditLog.getAuditData(), T.getType());
                    return this.resynLogs("download", sessionBoardId, auditbody);
                }
                return new ResponseEntity((Object)auditLog, HttpStatus.OK);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
        return null;
    }

    @RequestMapping(value={"/boardlinks/{boardId}"})
    @ResponseBody
    public ResponseEntity<Object> getBoardLinkTypes(@PathVariable(value="boardId") String boardId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            SessionBoard activeSessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)boardId));
            if (activeSessionBoard.getSession().getAlmConfigurations() != null && activeSessionBoard.getSession().getAlmConfigurations().size() > 0) {
                response.put("jiraLinksTypes", this.almSyncService.retrieveJiraIssueLinkTypesList(((AlmConfigurations)activeSessionBoard.getSession().getAlmConfigurations().get(0)).getAlmAccount(), false));
            } else if (activeSessionBoard.getSession().getTfsAlmConfigurations() != null && activeSessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount() != null) {
                response.put("tfsLinksTypes", this.tfsUtils.getRelationShipTypes(activeSessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/items/{id}"})
    @ResponseBody
    public ResponseEntity<Object> getBoardItems(@PathVariable(value="id") String id) {
        HashMap responseJson = new HashMap();
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        SessionBoard board = new SessionBoard(id);
        sessionBoards.add(board);
        List bos = this.itemRepository.findBySessionBoardsInOrderBySequence(sessionBoards);
        ArrayList<Item> boardItems = new ArrayList<Item>();
        if (PropertyValidator.isValid((Collection)bos)) {
            for (Item item : bos) {
                boardItems.add(this.transform(item));
            }
        }
        responseJson.put("items", boardItems);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private List<DBObject> retreiveItemsOnly(String id, List<String> fieldsToInclude) throws Exception {
        return this.customRepositoryImpl.retreiveItemsOnly(id, null, fieldsToInclude);
    }

    @RequestMapping(value={"/items1/{id}"})
    @ResponseBody
    public ResponseEntity<Object> getBoardItems1(@PathVariable(value="id") String id) {
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)id));
        HashMap<String, List> responseJson = new HashMap<String, List>();
        HashMap teamMapById = new HashMap();
        HashMap containerMapById = new HashMap();
        List containers = sessionBoard.getContainers();
        List teams = sessionBoard.getTeams();
        containers.forEach(container -> containerMapById.put(container.getId(), container));
        teams.forEach(team -> teamMapById.put(team.getId(), team));
        ArrayList allStatuses = new ArrayList();
        HashMap statusMapById = new HashMap();
        List issueTypes = this.issueTypeRepository.findAll();
        HashMap issueTypeMapById = new HashMap();
        issueTypes.forEach(issueType -> issueTypeMapById.put(issueType.getId(), issueType));
        ArrayList itemLinks = new ArrayList();
        HashMap itemLinkMapById = new HashMap();
        ArrayList jiraLinks = new ArrayList();
        HashMap jiraLinkMapById = new HashMap();
        ArrayList<Item> boardItems = new ArrayList<Item>();
        HashSet jiraIds = new HashSet();
        List allItems = null;
        try {
            allItems = this.customRepositoryImpl.retreiveItemsOnly(id, null, null);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        if (PropertyValidator.isValid((Collection)allItems)) {
            for (DBObject vo : allItems) {
                try {
                    DBRef userRef;
                    Item item = this.createItemForReport(vo, statusMapById, allStatuses, itemLinkMapById, itemLinks, jiraLinkMapById, jiraLinks, teamMapById, containerMapById, issueTypeMapById);
                    if (PropertyValidator.isValid((Object)vo.get("jiraFieldByKey"))) {
                        item.setJiraFieldByKey((Map)vo.get("jiraFieldByKey"));
                    }
                    if ((userRef = (DBRef)vo.get("fetchedBy")) != null) {
                        item.setFetchedBy(new User(String.valueOf(userRef.getId())));
                    }
                    boardItems.add(item);
                }
                catch (Exception exx) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)exx));
                }
            }
        }
        List _itemLinks = this.itemLinkRepository.findByIdIn(itemLinks);
        List _jiraLinks = this.itemJiraDependencyRepository.findByIdIn(jiraLinks);
        List _statuses = this.statusRepository.findByIdIn(allStatuses);
        responseJson.put("statuses", _statuses);
        responseJson.put("links", _itemLinks);
        responseJson.put("jiraLinks", _jiraLinks);
        responseJson.put("items", boardItems);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private Item createItemForReport(DBObject vo, HashMap<String, String> statusMapById, ArrayList<String> allStatuses, HashMap<String, String> itemLinkMapById, ArrayList<String> itemLinks, HashMap<String, String> jiraLinkMapById, ArrayList<String> jiraLinks, HashMap<String, Team> teamMapById, HashMap<String, Container> containerMapById, HashMap<String, IssueType> issueTypeMapById) {
        Item parent = null;
        DBRef parentRef = (DBRef)vo.get("parent");
        if (PropertyValidator.isValid((Object)parentRef)) {
            parent = new Item(String.valueOf(parentRef.getId()));
        }
        DBRef statusRef = (DBRef)vo.get("status");
        Status status = new Status();
        if (!PropertyValidator.isValid((Object)statusRef)) {
            LOGGER.debug("Status ref is null for Item :: " + String.valueOf(vo.get("_id")));
        } else {
            String statusId = String.valueOf(statusRef.getId());
            status.setId(statusId);
            if (statusMapById.get(statusId) == null) {
                statusMapById.put(statusId, statusId);
                allStatuses.add(statusId);
            }
        }
        IssueType issueType = null;
        DBRef issueTypeRef = (DBRef)vo.get("issueType");
        if (PropertyValidator.isValid((Object)issueTypeRef)) {
            String issueTypeId = String.valueOf(issueTypeRef.getId());
            issueType = issueTypeMapById.get(issueTypeId);
        }
        ArrayList _itemLinks = new ArrayList();
        List itemLinksRef = (List)vo.get("itemLinks");
        if (PropertyValidator.isValid((Collection)itemLinksRef)) {
            itemLinksRef.forEach(linkRef -> {
                String linkId = String.valueOf(linkRef.getId());
                ItemLink link = new ItemLink();
                link.setId(linkId);
                if (itemLinkMapById.get(linkId) == null) {
                    itemLinkMapById.put(linkId, linkId);
                    itemLinks.add(linkId);
                }
                _itemLinks.add(link);
            });
        }
        ArrayList _jiraLinks = new ArrayList();
        List jiraLinksRef = (List)vo.get("jiraDependencies");
        if (PropertyValidator.isValid((Collection)jiraLinksRef)) {
            jiraLinksRef.forEach(linkRef -> {
                String linkId = String.valueOf(linkRef.getId());
                ItemJiraDependency link = new ItemJiraDependency();
                link.setId(linkId);
                if (jiraLinkMapById.get(linkId) == null) {
                    jiraLinkMapById.put(linkId, linkId);
                    jiraLinks.add(linkId);
                }
                _jiraLinks.add(link);
            });
        }
        List teamContainersRef = (List)vo.get("teamContainers");
        ArrayList<TeamContainer> teamContainers = new ArrayList<TeamContainer>();
        if (PropertyValidator.isValid((Collection)teamContainersRef)) {
            for (int i = 0; i < teamContainersRef.size(); ++i) {
                DBRef tcRef = (DBRef)teamContainersRef.get(i);
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(tcRef.getId()));
                DBCursor dbCursorDomain = this.customRepositoryImpl.getMongoTemplate().getCollection("teamContainer").find(query.getQueryObject());
                if (!dbCursorDomain.hasNext() || !PropertyValidator.isValid(teamMapById) || !PropertyValidator.isValid(containerMapById)) continue;
                DBObject tcObject = dbCursorDomain.next();
                DBRef teamRef = (DBRef)tcObject.get("team");
                DBRef containerRef = (DBRef)tcObject.get("container");
                Double sequence = (Double)tcObject.get("sequence");
                if (!PropertyValidator.isValid((Object)teamRef) || !PropertyValidator.isValid((Object)containerRef)) continue;
                Team team = teamMapById.get(String.valueOf(teamRef.getId()));
                Container container = containerMapById.get(String.valueOf(containerRef.getId()));
                if (!PropertyValidator.isValid((Object)team) || !PropertyValidator.isValid((Object)container)) continue;
                TeamContainer teamContainer = new TeamContainer();
                teamContainer.setId(String.valueOf(tcObject.get("_id")));
                teamContainer.setOriginItemId((String)tcObject.get("originItemId"));
                teamContainer.setTeam(team);
                teamContainer.setContainer(container);
                teamContainer.setSequence(sequence);
                if (!PropertyValidator.isValid((Object)team) || !PropertyValidator.isValid((Object)team.getId()) || !PropertyValidator.isValid((Object)container) || !PropertyValidator.isValid((Object)container.getId())) continue;
                teamContainers.add(teamContainer);
            }
        }
        ArrayList _jiraLinkTypes = new ArrayList();
        List jiraLinkTypesRef = (List)vo.get("linkTypes");
        if (PropertyValidator.isValid((Collection)jiraLinkTypesRef)) {
            jiraLinkTypesRef.forEach(linkRef -> {
                JiraIssueLinkType link = new JiraIssueLinkType(linkRef);
                _jiraLinkTypes.add(link);
            });
        }
        return new Item(vo, null, status, issueType, parent, _itemLinks, _jiraLinks, teamContainers, _jiraLinkTypes);
    }

    public void logTime() {
        Instant start = Instant.now();
        Instant end = Instant.now();
        Duration timeElapsed = Duration.between(start, end);
    }

    @RequestMapping(value={"/board/{id}/revertstate"})
    @ResponseBody
    public ResponseEntity<Object> revertState(@PathVariable(value="id") String id) {
        HashMap<String, String> responseJson = new HashMap<String, String>();
        try {
            SessionBoard board = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)id));
            List boardStates = this.sessionBoardRepository.findBySessionIdOrderByCreatedOnDesc(board.getSession().getId());
            Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)board.getSession().getId()));
            LOGGER.debug("Started to revert Board state");
            LOGGER.debug("Existing board states : " + boardStates.size());
            if (PropertyValidator.isValid((Collection)boardStates) && boardStates.size() > 1) {
                SessionBoard latestState = (SessionBoard)boardStates.get(0);
                if (PropertyValidator.isValid((Object)latestState.getState())) {
                    LOGGER.debug("Latest Board State : " + latestState.getState().getTitle());
                }
                SessionBoard stateToBeActive = (SessionBoard)boardStates.get(1);
                if (PropertyValidator.isValid((Object)latestState) && PropertyValidator.isValid((Object)stateToBeActive)) {
                    if (PropertyValidator.isValid((Object)stateToBeActive.getState())) {
                        LOGGER.debug("Board State To Be Settled : " + stateToBeActive.getState().getTitle());
                    }
                    stateToBeActive.setStatus(SessionBoard.OPEN);
                    stateToBeActive.setParentBoard(null);
                    session.setActiveSessionBoard(stateToBeActive.getId());
                    latestState.setSession(null);
                    if (boardStates.size() > 2) {
                        ((SessionBoard)boardStates.get(2)).setParentBoard(stateToBeActive.getId());
                    }
                    if (boardStates.size() > 3) {
                        ((SessionBoard)boardStates.get(3)).setParentBoard(stateToBeActive.getId());
                    }
                    AuditLog auditLogObject = null;
                    if (PropertyValidator.isValid((Object)latestState.getState()) && PropertyValidator.isValid((Object)stateToBeActive.getState())) {
                        JSONArray logArray = new JSONArray();
                        JSONObject log = new JSONObject();
                        log.put("changed", (Object)"Board State Reverted -");
                        log.put("from", (Object)latestState.getState().getTitle());
                        log.put("to", (Object)stateToBeActive.getState().getTitle());
                        logArray.put((Object)log);
                        auditLogObject = new AuditLog(null, session.getId(), "STATE_REVERTED", logArray.toString());
                        LOGGER.debug("Board State Reversion Audit Entry Created");
                    }
                    this.sessionBoardRepository.save((Iterable)boardStates);
                    LOGGER.debug("Board States Saved");
                    if (PropertyValidator.isValid(auditLogObject)) {
                        this.auditLogRepository.save(auditLogObject);
                        LOGGER.debug("Board State Audit Entry Saved");
                    }
                    this.itemRepository.deleteBySessionBoardsIdIn(latestState.getId());
                    this.sessionBoardRepository.delete((Object)latestState);
                    LOGGER.debug("Old State Items deleted");
                    List latestStateTCs = this.teamContainerRepository.findByContainerIn(latestState.getContainers());
                    if (PropertyValidator.isValid((Collection)latestStateTCs)) {
                        ArrayList<String> tcs = new ArrayList<String>();
                        for (TeamContainer teamContainer : latestStateTCs) {
                            tcs.add(teamContainer.getId());
                        }
                        this.itemLinkRepository.deleteBySourceTeamContainerIdInOrTargetTeamContainerIdIn(tcs, tcs);
                        LOGGER.debug("Old State Item Links deleted");
                        this.teamContainerRepository.deleteByIdIn(tcs);
                        LOGGER.debug("Old State Team Containers deleted");
                    }
                    responseJson.put("activeState", stateToBeActive.getId());
                }
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity(null, HttpStatus.NOT_FOUND);
        }
    }

    private void sendLazyMetaToClient(SessionBoard sessionBoard, Boolean useALM, String requestId) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    @RequestMapping(value={"/milestone-meta/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getMilestoneMeta(@PathVariable(value="id") String boardId) {
        HashMap<String, Serializable> responseJson = new HashMap<String, Serializable>();
        try {
            SessionBoard sessionBoard = this.sessionBoardRepository.findById(boardId);
            ItemTypeScheme milestoneScheme = this.tfSservice.getItemTypeScheme(EnumKendis.MILESTONE.getCode());
            ItemTypeScheme phaseScheme = this.tfSservice.getItemTypeScheme(EnumKendis.PHASES.getCode());
            if (!PropertyValidator.isValid((Object)sessionBoard.getSession().getMilestoneSchemeId()) && !PropertyValidator.isValid((Object)sessionBoard.getSession().getPhaseSchemeId())) {
                Session session = this.sessionRepository.findById(sessionBoard.getSession().getId());
                if (!PropertyValidator.isValid((Object)session.getMilestoneSchemeId())) {
                    session.setMilestoneSchemeId(milestoneScheme.getId());
                }
                sessionBoard.getSession().setMilestoneSchemeId(milestoneScheme.getId());
                if (!PropertyValidator.isValid((Object)session.getPhaseSchemeId())) {
                    session.setPhaseSchemeId(phaseScheme.getId());
                }
                sessionBoard.getSession().setPhaseSchemeId(phaseScheme.getId());
                this.sessionRepository.save((Object)session);
            }
            responseJson.put("success", Boolean.valueOf(true));
            responseJson.put("milestoneScheme", this.externalEntitiesService.getItemTypeScheme(milestoneScheme));
            responseJson.put("phaseScheme", this.externalEntitiesService.getItemTypeScheme(phaseScheme));
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            responseJson.put("success", Boolean.valueOf(true));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/board-meta/{id}", "/{id}/board-meta"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getBoardMeta(@PathVariable(value="id") String id, HttpServletRequest request, @RequestBody Map<String, Object> requestBody) {
        try {
            HashMap<String, Object> responseJson = new HashMap<String, Object>();
            SessionBoard sessionBoard = this.sessionBoardRepository.findById(id);
            List linkedBoards = PropertyValidator.isValid((Object)sessionBoard.getParentBoard()) ? this.sessionBoardRepository.findByIdOrParentBoardOrderByCreatedOnAsc(sessionBoard.getParentBoard(), sessionBoard.getParentBoard()) : this.sessionBoardRepository.findByIdOrParentBoardOrderByCreatedOnAsc(sessionBoard.getId(), sessionBoard.getId());
            if (requestBody.containsKey("sprintReport")) {
                String trackingBoardId;
                if (sessionBoard.getState().getTitle().equalsIgnoreCase("Close") && PropertyValidator.isValid((Object)(trackingBoardId = (String)linkedBoards.stream().filter(board -> board.getState().getTitle().equals("Tracking")).map(BaseEntity::getId).findFirst().orElse(null)))) {
                    sessionBoard = this.sessionBoardRepository.findById(trackingBoardId);
                }
                sessionBoard.setState(null);
                sessionBoard.setSession(new Session(sessionBoard.getSession().getId(), sessionBoard.getSession().getTitle(), sessionBoard.getSession().getActiveSessionBoard(), sessionBoard.getSession().getChildItem(), sessionBoard.getSession().getChildItems(), sessionBoard.getSession().getParentItem(), sessionBoard.getSession().getParentItems(), sessionBoard.getSession().getPrefix(), sessionBoard.getSession().getSprintLabel(), sessionBoard.getSession().getSprintsLabel(), sessionBoard.getSession().getTeamLabel(), sessionBoard.getSession().getTeamsLabel()));
                sessionBoard.getTeams().stream().peek(team -> team.setWorkSpaces(null)).collect(Collectors.toList());
                responseJson.put("sessionBoard", sessionBoard);
            } else {
                sessionBoard.setLinkedBoards(linkedBoards);
                Boolean useALM = true;
                if (requestBody.containsKey("alm")) {
                    useALM = (Boolean)requestBody.get("alm");
                }
                responseJson.put("sessionBoard", sessionBoard);
                responseJson.put("boardFilters", this.tfSservice.fetchBoardFilters(sessionBoard.getSession().getId(), UserContextUtil.getUserContext().getLoggedInUser().getId()));
                responseJson.put("kendisFields", this.customFieldService.getKendisCustomFieldsFromDefaultLayout(EnumKendis.KENDIS_ONLY_CARD.getCode()));
                ItemTypeScheme milestoneScheme = this.tfSservice.getItemTypeScheme(EnumKendis.MILESTONE.getCode());
                ItemTypeScheme phaseScheme = this.tfSservice.getItemTypeScheme(EnumKendis.PHASES.getCode());
                boolean idFound = false;
                String mlId = null;
                String phId = null;
                if (PropertyValidator.isValid((Object)milestoneScheme)) {
                    mlId = milestoneScheme.getId();
                    idFound = true;
                }
                if (PropertyValidator.isValid((Object)phaseScheme)) {
                    phId = phaseScheme.getId();
                    idFound = true;
                }
                if (idFound && !PropertyValidator.isValid((Object)sessionBoard.getSession().getMilestoneSchemeId()) && !PropertyValidator.isValid((Object)sessionBoard.getSession().getPhaseSchemeId())) {
                    Session session = this.sessionRepository.findById(sessionBoard.getSession().getId());
                    if (mlId != null) {
                        if (!PropertyValidator.isValid((Object)session.getMilestoneSchemeId())) {
                            session.setMilestoneSchemeId(mlId);
                        }
                        sessionBoard.getSession().setMilestoneSchemeId(mlId);
                    }
                    if (phId != null) {
                        if (!PropertyValidator.isValid((Object)session.getPhaseSchemeId())) {
                            session.setPhaseSchemeId(phId);
                        }
                        sessionBoard.getSession().setPhaseSchemeId(phId);
                    }
                    this.sessionRepository.save((Object)session);
                }
                if (mlId != null) {
                    responseJson.put("milestoneScheme", this.externalEntitiesService.getItemTypeScheme(milestoneScheme));
                }
                if (phId != null) {
                    responseJson.put("phaseScheme", this.externalEntitiesService.getItemTypeScheme(phaseScheme));
                }
                this.sendLazyMetaToClient(sessionBoard, useALM, (String)requestBody.get("requestId"));
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity(null, HttpStatus.NOT_FOUND);
        }
    }

    private void fetchJiraIssueTypes(String almAccountId, List<String> projectKeys, HashMap<String, Object> responseJson) {
        if (PropertyValidator.isValid(projectKeys)) {
            List jiraProjectIssueTypes = this.jiraProjectIssueTypesRepository.findByAlmAccountIdAndJiraProjectKeyIn(almAccountId, projectKeys);
            for (JiraProjectIssueTypes jpType : jiraProjectIssueTypes) {
                if (!PropertyValidator.isValid((Object)jpType.getIssueTypesReference())) continue;
                jpType.setIssueTypes(MongoSyncUtils.retrieveData((String)jpType.getIssueTypesReference(), (AppConfig.MongoConfig)this.mongoConfig));
            }
            responseJson.put("jiraProjectIssueTypes", jiraProjectIssueTypes);
        }
    }

    private void fillBoardStatuses(SessionBoard sessionBoard) {
        sessionBoard.getSession().setStateScheme(this.getDefaultStateScheme());
        sessionBoard.getSession().getStateScheme().setStates(this.stateRepository.findByStateScheme(sessionBoard.getSession().getStateScheme()));
        if (PropertyValidator.isValid((Collection)sessionBoard.getSession().getAlmConfigurations())) {
            sessionBoard.getSession().getItemWorkFlow().setStatuses(this.statusRepository.findByJiraProjKeyNotNullAndSessionIdAndItemType(sessionBoard.getSession().getId(), "Feature"));
            sessionBoard.getSession().getSubItemWorkFlow().setStatuses(this.statusRepository.findByJiraProjKeyNotNullAndSessionIdAndItemType(sessionBoard.getSession().getId(), "UserStory"));
            sessionBoard.getSession().getItemWorkFlow().getStatuses().addAll(KendisUtils.sortStatuses((List)this.statusRepository.findByWorkFlow(sessionBoard.getSession().getItemWorkFlow()), (String)sessionBoard.getSession().getItemWorkFlow().getStatusSequence()));
            sessionBoard.getSession().getSubItemWorkFlow().getStatuses().addAll(KendisUtils.sortStatuses((List)this.statusRepository.findByWorkFlow(sessionBoard.getSession().getSubItemWorkFlow()), (String)sessionBoard.getSession().getSubItemWorkFlow().getStatusSequence()));
        } else {
            sessionBoard.getSession().getItemWorkFlow().setStatuses(KendisUtils.sortStatuses((List)this.statusRepository.findByWorkFlow(sessionBoard.getSession().getItemWorkFlow()), (String)sessionBoard.getSession().getItemWorkFlow().getStatusSequence()));
            sessionBoard.getSession().getSubItemWorkFlow().setStatuses(KendisUtils.sortStatuses((List)this.statusRepository.findByWorkFlow(sessionBoard.getSession().getSubItemWorkFlow()), (String)sessionBoard.getSession().getSubItemWorkFlow().getStatusSequence()));
        }
    }

    private HashMap<String, IssueType> getIsuueTypeOfTheBoard(Session session) {
        HashMap<String, IssueType> issueTypeMapByIdForUserSelection = new HashMap<String, IssueType>();
        try {
            List issueTypes = this.issueTypeRepository.findAll();
            HashMap issueTypeMapById = new HashMap();
            issueTypes.forEach(issueType -> issueTypeMapById.put(issueType.getId(), issueType));
            List issueTypesForUserSelection = issueTypes;
            IssueType parentIssueType = new IssueType();
            parentIssueType.setTitle(session.getParentItem());
            parentIssueType.setSequence(Double.valueOf(Double.MIN_VALUE));
            issueTypeMapByIdForUserSelection.put("-100", parentIssueType);
            issueTypesForUserSelection.forEach(issueType -> issueTypeMapByIdForUserSelection.put(issueType.getId(), (IssueType)issueType));
            return issueTypeMapByIdForUserSelection;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return issueTypeMapByIdForUserSelection;
        }
    }

    @RequestMapping(value={"/tfs-jira-project/{id}"})
    @ResponseBody
    public ResponseEntity<Object> getTfsProject(@PathVariable(value="id") String id) {
        HashMap responseJson = new HashMap();
        try {
            SessionBoard sessionBoard = this.sessionBoardRepository.findById(id);
            this.populateTfsProjectResponse(responseJson, sessionBoard);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private void populateJiraIssueTypesResponse(HashMap<String, Object> responseJson, SessionBoard sessionBoard) {
        if (PropertyValidator.isValid((Collection)sessionBoard.getSession().getAlmConfigurations())) {
            responseJson.put("jira", true);
            String almId = ((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getAlmAccount().getId();
            ArrayList<String> projectKeys = new ArrayList<String>();
            List tMapping = ((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getTeamMappings();
            List bMapping = ((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getFeatureMappings();
            if (PropertyValidator.isValid((Collection)tMapping)) {
                for (BacklogMapping tm : tMapping) {
                    if (!PropertyValidator.isValid((Collection)tm.getProjectKeys())) continue;
                    projectKeys.addAll(tm.getProjectKeys());
                }
            }
            if (PropertyValidator.isValid((Collection)bMapping)) {
                for (BacklogMapping bm : bMapping) {
                    projectKeys.add(bm.getProjectKey());
                }
            }
            this.fetchJiraIssueTypes(almId, projectKeys, responseJson);
        }
    }

    private void populateTfsProjectResponse(HashMap<String, Object> responseJson, SessionBoard sessionBoard) {
        responseJson.put("cardType", this.getIsuueTypeOfTheBoard(sessionBoard.getSession()));
        this.fillBoardStatuses(sessionBoard);
        responseJson.put("itemStatuses", sessionBoard.getSession().getItemWorkFlow().getStatuses());
        responseJson.put("subItemStatuses", sessionBoard.getSession().getSubItemWorkFlow().getStatuses());
        if (PropertyValidator.isValid((Object)sessionBoard.getSession().getTfsAlmConfigurations())) {
            HashMap meta = KendisUtils.getTfsMeta((SessionBoard)sessionBoard, (TFSProjectRepository)this.tfsProjectRepository, (WorkFlowItemTypeRepository)this.workFlowItemTypeRepository, (WorkFlowRepository)this.workFlowRepository, (StatusRepository)this.statusRepository, (TFSservice)this.tfSservice);
            responseJson.putAll(meta);
            responseJson.put("tfs", true);
        } else if (PropertyValidator.isValid((Collection)sessionBoard.getSession().getAlmConfigurations())) {
            responseJson.put("jira", true);
            String almId = ((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getAlmAccount().getId();
            ArrayList<String> projectKeys = new ArrayList<String>();
            responseJson.put("jiraLinksTypes", this.almSyncService.retrieveJiraIssueLinkTypesList(((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getAlmAccount(), false));
            List tMapping = ((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getTeamMappings();
            List bMapping = ((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getFeatureMappings();
            if (PropertyValidator.isValid((Collection)tMapping)) {
                for (BacklogMapping tm : tMapping) {
                    if (!PropertyValidator.isValid((Collection)tm.getProjectKeys())) continue;
                    projectKeys.addAll(tm.getProjectKeys());
                }
            }
            if (PropertyValidator.isValid((Collection)bMapping)) {
                for (BacklogMapping bm : bMapping) {
                    projectKeys.add(bm.getProjectKey());
                }
            }
            this.fetchJiraIssueTypes(almId, projectKeys, responseJson);
        }
    }

    @RequestMapping(value={"/getMetaInfo/{sessionIds}"})
    @ResponseBody
    public ResponseEntity<Object> getMetaInfo(@PathVariable(value="sessionIds") List<String> sessionIds) {
        HashMap responseJsonFinal = new HashMap();
        try {
            for (String sessionId : sessionIds) {
                HashMap responseSingleBoard = new HashMap();
                Session session = this.sessionRepository.findById(sessionId);
                List sessionBoardList = this.sessionBoardRepository.findBySessionId(sessionId);
                for (SessionBoard sessionBoard : sessionBoardList) {
                    sessionBoard.setSession(session);
                    this.populateTfsProjectResponse(responseSingleBoard, sessionBoard);
                    responseJsonFinal.put(sessionBoard.getId(), responseSingleBoard);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJsonFinal, HttpStatus.OK);
    }

    @RequestMapping(value={"/getJiraLinkTypeInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getJiraLinkTypeInfo(@RequestBody String requestPayload) {
        Gson g = new Gson();
        25 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(requestPayload, T.getType());
        List sessionIds = (List)reqbody.get("sessionIds");
        String requestId = (String)reqbody.get("requestId");
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        HashMap response = new HashMap();
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/board/{id}"})
    @ResponseBody
    public ResponseEntity<Object> getBoard(@PathVariable(value="id") String id, HttpServletRequest request) {
        try {
            boolean isRequiredJiraValidation = !"true".equals(request.getParameter("byPassJira"));
            HashMap<String, Object> responseJson = new HashMap<String, Object>();
            SessionBoard sessionBoard = this.sessionBoardRepository.findById(id);
            if (PropertyValidator.isValid((Object)sessionBoard) && PropertyValidator.isValid((Object)sessionBoard.getId())) {
                if (!PropertyValidator.isValid((Object)sessionBoard.getState())) {
                    State draftState = this.stateRepository.findByTitle("Draft");
                    sessionBoard.setState(draftState);
                    this.sessionBoardRepository.save((Object)sessionBoard);
                }
                List linkedBoards = PropertyValidator.isValid((Object)sessionBoard.getParentBoard()) ? this.sessionBoardRepository.findByIdOrParentBoardOrderByCreatedOnAsc(sessionBoard.getParentBoard(), sessionBoard.getParentBoard()) : this.sessionBoardRepository.findByIdOrParentBoardOrderByCreatedOnAsc(sessionBoard.getId(), sessionBoard.getId());
                if (PropertyValidator.isValid((Object)sessionBoard.getSession()) && PropertyValidator.isValid((Object)sessionBoard.getSession().getId())) {
                    this.fillBoardStatuses(sessionBoard);
                    if (!PropertyValidator.isValid((Object)sessionBoard.getSession().getDependencyWorkFlow())) {
                        this.tfSservice.linkDependencyWorkflow(sessionBoard);
                    }
                    List dependencyStatuses = this.statusRepository.findByWorkFlow(sessionBoard.getSession().getDependencyWorkFlow());
                    WorkFlow workFlow = sessionBoard.getSession().getDependencyWorkFlow();
                    List sortedStatuses = new ArrayList();
                    if (PropertyValidator.isValid((Object)workFlow.getStatusSequence())) {
                        sortedStatuses = KendisUtils.sortStatuses((List)dependencyStatuses, (String)workFlow.getStatusSequence());
                        responseJson.put("dependencyStatuses", sortedStatuses);
                    } else {
                        responseJson.put("dependencyStatuses", dependencyStatuses);
                    }
                    List dependencyLimit = this.almSyncService.getTeamSprintDependencies(sessionBoard);
                    responseJson.put("teamSprintDependencyLimit", dependencyLimit);
                    responseJson.put("boardFilters", this.tfSservice.fetchBoardFilters(sessionBoard.getSession().getId(), UserContextUtil.getUserContext().getLoggedInUser().getId()));
                    if (sessionBoard.getSession().getNewSystemLinkTypes().booleanValue()) {
                        List kendisLinkTypes = this.itemLinkTypeRepository.findBySystem(Boolean.TRUE);
                        if (!PropertyValidator.isValid((Collection)kendisLinkTypes)) {
                            kendisLinkTypes = this.tfSservice.createNewKendisLinkTypes();
                        }
                        responseJson.put("kendisLinkTypes", kendisLinkTypes);
                    }
                } else {
                    Session sessionWrapper = new Session();
                    sessionWrapper.setItemWorkFlow(this.getDefaultWorkFlow());
                    sessionWrapper.setSubItemWorkFlow(this.getDefaultWorkFlow());
                    sessionWrapper.setStateScheme(this.getDefaultStateScheme());
                    this.sessionRepository.save((Object)sessionWrapper);
                    sessionBoard.setSession(sessionWrapper);
                    this.sessionBoardRepository.save((Object)sessionBoard);
                    sessionBoard.getSession().getStateScheme().setStates(this.stateRepository.findByStateScheme(sessionBoard.getSession().getStateScheme()));
                    if (sessionBoard.getSession().getAlmEnabled().booleanValue()) {
                        sessionBoard.getSession().getItemWorkFlow().setStatuses(this.statusRepository.findByJiraProjKeyNotNull());
                    } else {
                        sessionBoard.getSession().getItemWorkFlow().setStatuses(KendisUtils.sortStatuses((List)this.statusRepository.findByWorkFlow(sessionBoard.getSession().getItemWorkFlow()), (String)sessionBoard.getSession().getItemWorkFlow().getStatusSequence()));
                        sessionBoard.getSession().getSubItemWorkFlow().setStatuses(KendisUtils.sortStatuses((List)this.statusRepository.findByWorkFlow(sessionBoard.getSession().getSubItemWorkFlow()), (String)sessionBoard.getSession().getSubItemWorkFlow().getStatusSequence()));
                    }
                }
                sessionBoard.setTeamSprintVelocities(this.teamSprintVelocityRepository.findBySessionBoardId(sessionBoard.getId()));
                sessionBoard.setLinkedBoards(linkedBoards);
                ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
                sessionBoards.add(new SessionBoard(id));
                List tcs = this.teamContainerRepository.findBySequenceIsNull();
                if (PropertyValidator.isValid((Collection)tcs)) {
                    this.teamContainerRepository.save((Iterable)tcs);
                }
                sessionBoard.setItems(new ArrayList());
                sessionBoard.setServerTimeZone(AlmUtils.getServerTimeZone());
            }
            ArrayList<User> companyUsers = new ArrayList<User>();
            List usersAll = this.userRepository.findByUserCompanies_Company_Id(UserContextUtil.getUserContext().getCurrentCompany().getId());
            List nonKendisUsers = this.userRepository.findByTenantAndUserTypeNotAndArchiveFalseAndRowStatus(UserContextUtil.getUserContext().getCurrentCompany().getTenant(), User.UserType.KENDIS.toString(), (Number)0);
            for (User user : usersAll) {
                if (!this.tfSservice.isLoggedInCompanyUser(user).booleanValue()) continue;
                companyUsers.add(user);
            }
            if (PropertyValidator.isValid((Collection)nonKendisUsers)) {
                companyUsers.addAll(nonKendisUsers);
            }
            responseJson.put("users", companyUsers);
            responseJson.put("sessionBoard", sessionBoard);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity(null, HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/validate-alm/{requestId}/{id}"}, method={RequestMethod.GET})
    public void validateUser(@PathVariable(value="requestId") String requestId, @PathVariable(value="id") String almId) {
        User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    private SessionBoard getBoardForEdit(@PathVariable(value="id") String id) {
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)id));
        if (PropertyValidator.isValid((Object)sessionBoard) && PropertyValidator.isValid((Object)sessionBoard.getId())) {
            if (PropertyValidator.isValid((Object)sessionBoard.getSession()) && PropertyValidator.isValid((Collection)sessionBoard.getSession().getAlmConfigurations())) {
                AlmAccount almAcc = ((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getAlmAccount();
                String[] stringArray = new String[]{almAcc.getUrl(), almAcc.getUsername(), almAcc.getPassword()};
            }
            if (!PropertyValidator.isValid((Object)sessionBoard.getState())) {
                State draftState = this.stateRepository.findByTitle("Draft");
                sessionBoard.setState(draftState);
                this.sessionBoardRepository.save((Object)sessionBoard);
            }
            List linkedBoards = PropertyValidator.isValid((Object)sessionBoard.getParentBoard()) ? this.sessionBoardRepository.findByIdOrParentBoardOrderByCreatedOnAsc(sessionBoard.getParentBoard(), sessionBoard.getParentBoard()) : this.sessionBoardRepository.findByIdOrParentBoardOrderByCreatedOnAsc(sessionBoard.getId(), sessionBoard.getId());
            if (PropertyValidator.isValid((Object)sessionBoard.getSession()) && PropertyValidator.isValid((Object)sessionBoard.getSession().getId())) {
                sessionBoard.getSession().getStateScheme().setStates(this.stateRepository.findByStateScheme(sessionBoard.getSession().getStateScheme()));
                if (sessionBoard.getSession().getAlmEnabled().booleanValue()) {
                    sessionBoard.getSession().getItemWorkFlow().setStatuses(this.statusRepository.findByJiraProjKeyNotNull());
                    sessionBoard.getSession().getSubItemWorkFlow().setStatuses(sessionBoard.getSession().getItemWorkFlow().getStatuses());
                    sessionBoard.getSession().getItemWorkFlow().getStatuses().addAll(this.statusRepository.findByWorkFlow(sessionBoard.getSession().getItemWorkFlow()));
                    sessionBoard.getSession().getSubItemWorkFlow().getStatuses().addAll(this.statusRepository.findByWorkFlow(sessionBoard.getSession().getSubItemWorkFlow()));
                } else {
                    sessionBoard.getSession().getItemWorkFlow().setStatuses(this.statusRepository.findByWorkFlow(sessionBoard.getSession().getItemWorkFlow()));
                    sessionBoard.getSession().getSubItemWorkFlow().setStatuses(this.statusRepository.findByWorkFlow(sessionBoard.getSession().getSubItemWorkFlow()));
                }
            } else {
                Session sessionWrapper = new Session();
                sessionWrapper.setItemWorkFlow(this.getDefaultWorkFlow());
                sessionWrapper.setSubItemWorkFlow(this.getDefaultWorkFlow());
                sessionWrapper.setStateScheme(this.getDefaultStateScheme());
                this.sessionRepository.save((Object)sessionWrapper);
                sessionBoard.setSession(sessionWrapper);
                this.sessionBoardRepository.save((Object)sessionBoard);
                sessionBoard.getSession().getStateScheme().setStates(this.stateRepository.findByStateScheme(sessionBoard.getSession().getStateScheme()));
                if (sessionBoard.getSession().getAlmEnabled().booleanValue()) {
                    sessionBoard.getSession().getItemWorkFlow().setStatuses(this.statusRepository.findByJiraProjKeyNotNull());
                } else {
                    sessionBoard.getSession().getItemWorkFlow().setStatuses(this.statusRepository.findByWorkFlow(sessionBoard.getSession().getItemWorkFlow()));
                    sessionBoard.getSession().getSubItemWorkFlow().setStatuses(this.statusRepository.findByWorkFlow(sessionBoard.getSession().getSubItemWorkFlow()));
                }
            }
            sessionBoard.setLinkedBoards(linkedBoards);
            if (PropertyValidator.isValid((Collection)sessionBoard.getSession().getAlmConfigurations())) {
                ((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).setAlmAccount(((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getAlmAccount().copyWithoutPwd());
            }
        }
        return sessionBoard;
    }

    private Item transform(Item vo) {
        Item bo = new Item(vo);
        return bo;
    }

    @RequestMapping(value={"/activities/{id}"})
    public List<ItemLog> getSessionBoardActvities(@PathVariable(value="id") String id) {
        return this.itemLogRepository.findBySessionBoardOrderByCreatedOnDesc(new SessionBoard(id), (Pageable)new PageRequest(0, 100));
    }

    @RequestMapping(value={"/search/activities"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getActvities(HttpServletRequest request, @RequestBody String requestPayload) {
        Gson g = new Gson();
        28 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(requestPayload, T.getType());
        if (request.getParameter("page") != null) {
            reqbody.put("page", request.getParameter("page"));
        } else {
            reqbody.put("page", 0);
        }
        reqbody.put("activies", this.planService.getActivitiesByTeamAndSprint((String)reqbody.get("searchString"), (String)reqbody.get("boardId"), (String)reqbody.get("teamId"), (String)reqbody.get("sprintId"), (Boolean)reqbody.get("isWebhook"), request.getParameter("page")));
        return new ResponseEntity((Object)reqbody, HttpStatus.OK);
    }

    @RequestMapping(value={"/search/errors"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getAlmErrors(@RequestBody String requestPayload) {
        Gson g = new Gson();
        29 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(requestPayload, T.getType());
        return new ResponseEntity((Object)this.almSyncService.searchAlmErrors((String)reqbody.get("searchString"), (String)reqbody.get("boardId"), (Boolean)reqbody.get("errFlag"), (Boolean)reqbody.get("warFlag")), HttpStatus.OK);
    }

    @RequestMapping(value={"/board/export/pdf/prepare/{id}"})
    public String prepareDataForPDF(@PathVariable(value="id") String id, HttpServletRequest request, HttpServletResponse response) {
        String result = "[]";
        try {
            if (PropertyValidator.isValid((Object)id)) {
                SessionBoard board = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)id));
                List items = this.exportService.prepareDataForExport(id, board);
                Gson gson = new Gson();
                PdfResponseWrapper respWrapper = new PdfResponseWrapper(this);
                respWrapper.setBoard(board);
                respWrapper.setItems(items);
                result = gson.toJson((Object)respWrapper, PdfResponseWrapper.class);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    @RequestMapping(value={"/userInfo"})
    public User getUserInfo(HttpServletRequest request, HttpServletResponse response) {
        try {
            List accounts;
            long daysLeft;
            String serverName;
            UserCompany userCompany;
            User userObject;
            Company company;
            block93: {
                Group group;
                Object groupList;
                SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                if (secureUser.getUserContextDTO() == null) {
                    return null;
                }
                String baseURL = "";
                String host = request.getParameter("host");
                String protocol = request.getParameter("protocol");
                if (PropertyValidator.isValid((Object)host) && PropertyValidator.isValid((Object)protocol)) {
                    baseURL = protocol + "//" + host;
                    UserContextUtil.getUserContext().getCurrentCompany().setUrl(baseURL);
                }
                User contextUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
                LdapUser ldapUser = (LdapUser)secureUser.getUserContextDTO().getContextMap().get("ldapUser");
                company = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompanyId());
                HashSet<String> groups = new HashSet<String>();
                List configs = this.configRepository.findAll();
                boolean ldapAuthorization = false;
                if (PropertyValidator.isValid((Collection)configs) && PropertyValidator.isValid((Object)((Config)configs.get(0)).getLdapConfig()) && ((Config)configs.get(0)).getLdapConfig().isAuthorization()) {
                    ldapAuthorization = true;
                }
                if (Boolean.TRUE.equals(this.getUserSyncDefaultData(userObject = (User)this.userRepository.findOne((Serializable)((Object)contextUser.getId()))))) {
                    this.createDefaultData(userObject, null);
                }
                if (PropertyValidator.isValid((Object)ldapUser) && PropertyValidator.isValid((Collection)ldapUser.getGroups()) && PropertyValidator.isValid((Object)ldapUser.getProvider()) && ldapUser.getProvider().equals("okta")) {
                    groups.addAll(ldapUser.getGroups());
                    groupList = this.groupRepository.findByTitleInOrExternalReferenceIn(new ArrayList(groups), new ArrayList(groups));
                    if (PropertyValidator.isValid((Collection)groupList)) {
                        groups = new HashSet();
                        Iterator iterator = groupList.iterator();
                        while (iterator.hasNext()) {
                            group = (Group)iterator.next();
                            groups.add(group.getId());
                        }
                    }
                } else {
                    if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && UserContextUtil.getUserContext().isDebug() && PropertyValidator.isValid((Object)ldapUser)) {
                        if (PropertyValidator.isValid((Collection)ldapUser.getOtherAttributes())) {
                            LOGGER.debug("ldap user attributes : : User Id :" + ldapUser.getId() + ": " + Arrays.toString(ldapUser.getOtherAttributes().toArray()));
                        } else {
                            LOGGER.debug("ldap user attributes : : User Id :" + ldapUser.getId() + ": no other attributes");
                        }
                    }
                    if (ldapAuthorization && PropertyValidator.isValid((Object)ldapUser) && PropertyValidator.isValid((Collection)ldapUser.getGroups())) {
                        for (Object gp : ldapUser.getGroups()) {
                            String[] gpArr;
                            for (String gpStrArr : gpArr = ((String)gp).split(",")) {
                                if (!gpStrArr.startsWith("CN=")) continue;
                                groups.add(gpStrArr.substring(gpStrArr.indexOf("=") + 1));
                            }
                        }
                        groupList = this.groupRepository.findByTitleIn(new ArrayList(groups));
                        if (PropertyValidator.isValid((Collection)groupList)) {
                            Object gp;
                            groups = new HashSet();
                            gp = groupList.iterator();
                            while (gp.hasNext()) {
                                group = (Group)gp.next();
                                groups.add(group.getId());
                            }
                        }
                    }
                }
                if (PropertyValidator.isValid((Collection)userObject.getGroups())) {
                    if (!PropertyValidator.isValid(groups)) {
                        groups = new HashSet();
                    }
                    groups.addAll(userObject.getGroups());
                }
                if (!PropertyValidator.isValid(groups)) {
                    groups = new HashSet();
                }
                contextUser.setGroups(groups);
                String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
                ArrayList ucomp = new ArrayList();
                for (int i = 0; i < userObject.getUserCompanies().size(); ++i) {
                    if (!cid.equals(((UserCompany)userObject.getUserCompanies().get(i)).getCompany().getId())) continue;
                    userObject.setIsAdmin(((UserCompany)userObject.getUserCompanies().get(i)).getIsAdmin());
                    userObject.setIsSuperAdmin(((UserCompany)userObject.getUserCompanies().get(i)).getIsAdmin());
                    if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext().getCurrentCompany()) && UserContextUtil.getUserContext().getCurrentCompany().isGuestEnabled()) {
                        userObject.setIsGuest(((UserCompany)userObject.getUserCompanies().get(i)).getIsGuest());
                    }
                    contextUser.setIsAdmin(((UserCompany)userObject.getUserCompanies().get(i)).getIsAdmin());
                    contextUser.setIsSuperAdmin(((UserCompany)userObject.getUserCompanies().get(i)).getIsAdmin());
                    contextUser.setIsGuest(((UserCompany)userObject.getUserCompanies().get(i)).getIsGuest());
                    ucomp.add(userObject.getUserCompanies().get(i));
                }
                UserContextUtil.getUserContext().getUserContextDTO().getContextMap().put("user", contextUser);
                userCompany = userObject.getUserCompanies().stream().filter(uCompany -> uCompany.getCompany().getId().equals(UserContextUtil.getUserContext().getCurrentCompany().getId())).findFirst().orElse(null);
                if (PropertyValidator.isValid((Object)userCompany.getCompany().getPaymentDetails())) {
                    userCompany.getCompany().getPaymentDetails().setIntent_id(null);
                    userCompany.getCompany().getPaymentDetails().setCustomerId(null);
                }
                userCompany.setPackageUsageDetails(this.userService.getPackageLimitCount(userCompany.getCompany()));
                userObject.setLoggedInUserCompany(userCompany);
                HashSet workSpaces = new HashSet();
                ArrayList<Object> workSpaceAccessRoles = new ArrayList<Object>();
                if (PropertyValidator.isValid((Object)contextUser) && (contextUser.getIsAdmin().booleanValue() || contextUser.getIsSuperAdmin().booleanValue())) {
                    workSpaces = Sets.newHashSet((Iterable)this.workSpaceRepository.findAll());
                    for (WorkSpace workSpace : workSpaces) {
                        WorkSpaceAccessRole accessRole = new WorkSpaceAccessRole();
                        accessRole.setWorkSpace(workSpace);
                        accessRole.setUser(new User(contextUser.getId()));
                        workSpaceAccessRoles.add(accessRole);
                    }
                } else {
                    List workSpaceAccessRolesNonAdmin = this.accessRoleRepository.findByUserOrGroupIn(userObject, new ArrayList(groups));
                    if (PropertyValidator.isValid((Collection)workSpaceAccessRolesNonAdmin)) {
                        HashMap workspaceRestrictionsMap = new HashMap();
                        for (WorkSpaceAccessRole workSpaceAccessRole : workSpaceAccessRolesNonAdmin) {
                            if (PropertyValidator.isValid((Object)workSpaceAccessRole.getCustomView()) || PropertyValidator.isValid((Object)workSpaceAccessRole.getWorkSpace())) {
                                Set tempRestrictions;
                                HashSet restrictions = null;
                                boolean unrestrictedRoleExists = false;
                                if (PropertyValidator.isValid((Collection)workSpaceAccessRole.getRoles())) {
                                    for (Role role : workSpaceAccessRole.getRoles()) {
                                        Set roleRestrictions = role.getRestrictions();
                                        if (!PropertyValidator.isValid((Collection)roleRestrictions) || roleRestrictions.isEmpty()) {
                                            unrestrictedRoleExists = true;
                                            break;
                                        }
                                        if (restrictions == null) {
                                            restrictions = new HashSet(roleRestrictions);
                                            continue;
                                        }
                                        restrictions.retainAll(roleRestrictions);
                                    }
                                }
                                if (unrestrictedRoleExists) {
                                    restrictions = new HashSet();
                                }
                                if (PropertyValidator.isValid((Object)workSpaceAccessRole.getCustomView())) {
                                    if (null != workspaceRestrictionsMap.get(workSpaceAccessRole.getCustomView().getId())) {
                                        tempRestrictions = (Set)workspaceRestrictionsMap.get(workSpaceAccessRole.getCustomView().getId());
                                        if (PropertyValidator.isValid(restrictions)) {
                                            restrictions.retainAll(tempRestrictions);
                                        }
                                    }
                                    workspaceRestrictionsMap.put(workSpaceAccessRole.getCustomView().getId(), restrictions);
                                } else if (PropertyValidator.isValid((Object)workSpaceAccessRole.getWorkSpace())) {
                                    if (null != workspaceRestrictionsMap.get(workSpaceAccessRole.getWorkSpace().getId())) {
                                        tempRestrictions = (Set)workspaceRestrictionsMap.get(workSpaceAccessRole.getWorkSpace().getId());
                                        if (PropertyValidator.isValid(restrictions)) {
                                            restrictions.retainAll(tempRestrictions);
                                        }
                                    }
                                    workspaceRestrictionsMap.put(workSpaceAccessRole.getWorkSpace().getId(), restrictions);
                                }
                            }
                            WorkSpaceAccessRole accessRole = new WorkSpaceAccessRole();
                            if (PropertyValidator.isValid((Object)workSpaceAccessRole.getWorkSpace())) {
                                accessRole.setWorkSpace(new WorkSpace(workSpaceAccessRole.getWorkSpace().getId()));
                            }
                            if (PropertyValidator.isValid((Object)workSpaceAccessRole.getCustomView())) {
                                ObjectiveCustomView view = new ObjectiveCustomView();
                                view.setId(workSpaceAccessRole.getCustomView().getId());
                                accessRole.setCustomView(view);
                            }
                            if (PropertyValidator.isValid((Object)workSpaceAccessRole.getSolutionArea())) {
                                SolutionArea solutionArea = new SolutionArea();
                                solutionArea.setId(workSpaceAccessRole.getSolutionArea().getId());
                                accessRole.setSolutionArea(solutionArea);
                            }
                            accessRole.setUser(new User(userObject.getId()));
                            accessRole.setRoles(workSpaceAccessRole.getRoles());
                            if (workSpaceAccessRole.getGroup() != null) {
                                accessRole.setGroup(new Group(workSpaceAccessRole.getGroup().getId()));
                            }
                            workSpaceAccessRoles.add(accessRole);
                        }
                        for (WorkSpaceAccessRole workSpaceAccessRole : workSpaceAccessRolesNonAdmin) {
                            if (!PropertyValidator.isValid((Object)workSpaceAccessRole.getCustomView()) && !PropertyValidator.isValid((Object)workSpaceAccessRole.getWorkSpace()) || !PropertyValidator.isValid((Collection)workSpaceAccessRole.getRoles())) continue;
                            for (Role role : workSpaceAccessRole.getRoles()) {
                                Set effectiveRestrictions = null;
                                if (PropertyValidator.isValid((Object)workSpaceAccessRole.getCustomView())) {
                                    effectiveRestrictions = (Set)workspaceRestrictionsMap.get(workSpaceAccessRole.getCustomView().getId());
                                } else if (PropertyValidator.isValid((Object)workSpaceAccessRole.getWorkSpace())) {
                                    effectiveRestrictions = (Set)workspaceRestrictionsMap.get(workSpaceAccessRole.getWorkSpace().getId());
                                }
                                role.setRestrictions(effectiveRestrictions != null ? new HashSet(effectiveRestrictions) : new HashSet());
                            }
                        }
                    }
                }
                userObject.setUserCompanies(ucomp);
                userObject.setAccessRoles(workSpaceAccessRoles);
                userObject.setPermissions(EnumPermission.getAllCodesList());
                userObject.setLdapUser((LdapUser)secureUser.getUserContextDTO().getContextMap().get("ldapUser"));
                serverName = request.getServerName();
                daysLeft = 0L;
                if (this.env.getProperty("isLocalDeployment").equals("true") || !SystemUtil.isCloudDomain((String)serverName)) {
                    if (PropertyValidator.isValid((Collection)this.appInitConfigRepository.findAll())) {
                        userObject.setInstallationId(((AppInitConfig)this.appInitConfigRepository.findAll().get(0)).getKeySecrets());
                    }
                    String paymentKey = userCompany.getCompany().getPaymentKey();
                    userObject.setPaymentKey(paymentKey);
                    try {
                        PaymentPackageConfig packageConfig;
                        if (!PropertyValidator.isValid((Object)userCompany.getCompany().getPaymentKey())) break block93;
                        try {
                            paymentKey = paymentKey.length() == 43 ? new KhufiaKari().decryptOldKeys(paymentKey) : new KhufiaKari().decrypt(paymentKey);
                        }
                        catch (Exception ex) {
                            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
                            throw new RuntimeException();
                        }
                        String[] splitPaymentKey = paymentKey.split(":");
                        String mode = splitPaymentKey[0];
                        String userCount = splitPaymentKey[1];
                        String expiry = splitPaymentKey[2];
                        String duration = splitPaymentKey[3];
                        String guestUserCount = null;
                        String enableArt = null;
                        boolean updateCompanyInRepository = false;
                        if (splitPaymentKey.length > 4) {
                            guestUserCount = splitPaymentKey[4];
                        }
                        if (splitPaymentKey.length > 5) {
                            enableArt = splitPaymentKey[5];
                        }
                        Date expiryDate = new Date(Long.parseLong(expiry));
                        if ("trial".equals(mode)) {
                            company.setNextPaymentDate(null);
                            packageConfig = new PaymentPackageConfig();
                            packageConfig.setAllTrue();
                            if (PropertyValidator.isValid((Object)company.getPaymentPackageConfig())) {
                                packageConfig.setConfidenceVote(company.getPaymentPackageConfig().getConfidenceVote());
                                packageConfig.setPrivacyStatement(company.getPaymentPackageConfig().getPrivacyStatement());
                                packageConfig.setOrgFlags(company.getPaymentPackageConfig().getOrgFlags());
                            }
                            company.setPaymentPackageConfig(packageConfig);
                            company.setExpiryDate(expiryDate);
                            this.companyRepository.save((Object)company);
                        } else if ("paid-p".equals(mode) || "paid".equals(mode)) {
                            company.setNextPaymentDate(expiryDate);
                            packageConfig = new PaymentPackageConfig();
                            packageConfig.setAllTrue();
                            if (PropertyValidator.isValid((Object)company.getPaymentPackageConfig())) {
                                packageConfig.setConfidenceVote(company.getPaymentPackageConfig().getConfidenceVote());
                                packageConfig.setPrivacyStatement(company.getPaymentPackageConfig().getPrivacyStatement());
                                packageConfig.setOrgFlags(company.getPaymentPackageConfig().getOrgFlags());
                            }
                            company.setPaymentPackageConfig(packageConfig);
                            company.setExpiryDate(null);
                            this.companyRepository.save((Object)company);
                        } else if ("paid-s".equals(mode)) {
                            company.setNextPaymentDate(expiryDate);
                            packageConfig = new PaymentPackageConfig();
                            packageConfig.setAllFalse();
                            if (PropertyValidator.isValid((Object)company.getPaymentPackageConfig())) {
                                packageConfig.setConfidenceVote(company.getPaymentPackageConfig().getConfidenceVote());
                                packageConfig.setPrivacyStatement(company.getPaymentPackageConfig().getPrivacyStatement());
                                packageConfig.setOrgFlags(company.getPaymentPackageConfig().getOrgFlags());
                            }
                            company.setPaymentPackageConfig(packageConfig);
                            company.setExpiryDate(null);
                            this.companyRepository.save((Object)company);
                        }
                        if (company.getUserCount() != Long.parseLong(userCount)) {
                            company.setUserCount(Long.parseLong(userCount));
                            this.companyRepository.save((Object)company);
                        }
                        if (PropertyValidator.isValid((Object)guestUserCount)) {
                            long guestUserCountValue = Long.parseLong(guestUserCount);
                            if (company.getGuestUserCount() != guestUserCountValue) {
                                if (guestUserCountValue > 0L) {
                                    company.setGuestUserCount(guestUserCountValue);
                                    company.setGuestEnabled(true);
                                } else {
                                    company.setGuestEnabled(false);
                                }
                                updateCompanyInRepository = true;
                            }
                        } else {
                            company.setGuestEnabled(false);
                            updateCompanyInRepository = true;
                        }
                        if (PropertyValidator.isValid((Object)enableArt)) {
                            boolean isEnableArt = enableArt.equalsIgnoreCase("Yes");
                            company.setEnableArt(company.isEnableArt() == isEnableArt ? company.isEnableArt() : isEnableArt);
                        }
                        if (company.getDuration() != Long.parseLong(duration)) {
                            company.setDuration(Long.parseLong(duration));
                            this.companyRepository.save((Object)company);
                        }
                        userCompany.setCompany(company);
                        if (updateCompanyInRepository) {
                            this.companyRepository.save((Object)company);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                        throw new RuntimeException(e);
                    }
                }
            }
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            if (PropertyValidator.isValid((Object)userCompany.getCompany().getExpiryDate())) {
                Date expiryDate = userCompany.getCompany().getExpiryDate();
                long diff = (expiryDate = DateUtils.addDays((Date)expiryDate, (int)1)).getTime() - cal.getTime().getTime();
                daysLeft = diff > 0L ? TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS) : -1L;
            } else if (PropertyValidator.isValid((Object)userCompany.getCompany().getNextPaymentDate())) {
                Date nextPaymentDate = userCompany.getCompany().getNextPaymentDate();
                long diff = (nextPaymentDate = DateUtils.addDays((Date)nextPaymentDate, (int)1)).getTime() - cal.getTime().getTime();
                daysLeft = diff < 0L ? -4L : -2L;
            } else {
                daysLeft = -2L;
            }
            if (daysLeft == 0L) {
                daysLeft = -1L;
            }
            if (!SystemUtil.isCloudDomain((String)serverName) && !PropertyValidator.isValid((Object)userCompany.getCompany().getPaymentKey())) {
                daysLeft = -3L;
            }
            if (daysLeft == 0L) {
                daysLeft = -1L;
            }
            userObject.setTrialDaysLeft(daysLeft);
            KendisStats kendisStat = this.kendisStatsRepository.findByCompanyId(UserContextUtil.getUserContext().getCurrentCompanyId());
            if (PropertyValidator.isValid((Object)kendisStat) && PropertyValidator.isValid((Object)kendisStat.getSurveyData()) || this.env.getProperty("isLocalDeployment").equals("true")) {
                userObject.setFilledUpSurvey(true);
            }
            if (company.getNextPaymentDate() != null) {
                userObject.setIsPaid(Boolean.valueOf(true));
            } else {
                userObject.setIsPaid(Boolean.valueOf(false));
            }
            userObject.setPassword(null);
            String intercomSec = this.env.getProperty("intercomm.sec");
            if (PropertyValidator.isValid((Object)intercomSec)) {
                userObject.setIntercomUserHash(EncDecUtility.getHash256((String)intercomSec, (String)userObject.getUserName()));
            }
            String companyId = UserContextUtil.getUserContext().getCurrentCompanyId();
            User loggedInUser = this.userRepository.findByUserNameIgnoreCase(UserContextUtil.getUserContext().getLoggedInUser().getUserName());
            for (UserCompany uc : loggedInUser.getUserCompanies()) {
                if (!uc.getCompany().getId().equals(companyId)) continue;
                uc.setLastLogin(new Date());
            }
            loggedInUser.setTressPassCount(0);
            this.userRepository.save((Object)loggedInUser);
            if (!this.env.getProperty("isLocalDeployment").equals("true")) {
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            }
            if (PropertyValidator.isValid((Collection)(accounts = this.aLMSyncService.fetchJiraAccount(true))) && PropertyValidator.isValid((Collection)userObject.getAlmCredentials())) {
                AlmAccUser accUser = (AlmAccUser)userObject.getAlmCredentials().get(0);
                boolean almAccountFound = false;
                for (AlmAccount account : accounts) {
                    if (!accUser.getAlmAccId().equals(account.getId())) continue;
                    almAccountFound = true;
                }
                if (!almAccountFound) {
                    userObject.getAlmCredentials().remove(0);
                }
            }
            if (!this.isFeatureConfigMetaSynced(EnumFeatureConfigMeta.PIAGENDA.getCode()).booleanValue()) {
                LOGGER.debug("PI Agenda config not found adding meta");
                this.setFeatureConfigMetaSynced(EnumFeatureConfigMeta.PIAGENDA.getCode());
            }
            return userObject;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    @RequestMapping(value={"/changeState1"})
    public SessionBoard changeState1(@RequestBody SessionBoard requestBoard) {
        Optional<Container> container;
        List mappers;
        String boardId = requestBoard.getId();
        String stateId = requestBoard.getState().getId();
        SessionBoard savedSessionBoard = null;
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        savedSessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)boardId));
        if (!PropertyValidator.isValid((Object)savedSessionBoard.getState())) {
            savedSessionBoard.setState(new State(stateId));
            this.sessionBoardRepository.save((Object)savedSessionBoard);
            return savedSessionBoard;
        }
        List newTeams = savedSessionBoard.getTeams();
        List newContainers = savedSessionBoard.getContainers();
        ArrayList<ItemLink> newItemLinks = new ArrayList<ItemLink>();
        ArrayList<Item> newItems = new ArrayList<Item>();
        ArrayList<TeamContainer> newTeamContainers = new ArrayList<TeamContainer>();
        sessionBoards.add(savedSessionBoard);
        List items = this.itemRepository.findBySessionBoardsIn(sessionBoards);
        try {
            for (Item item2 : items) {
                List itemLinks;
                TeamContainer tc22;
                List teamContainers = item2.getTeamContainers();
                if (PropertyValidator.isValid((Collection)teamContainers)) {
                    for (TeamContainer tc22 : teamContainers) {
                        Optional<TeamContainer> duplicateTc;
                        if (!PropertyValidator.isValid((Object)tc22) || (duplicateTc = newTeamContainers.stream().filter(x -> tc22.getId().equals(x.getId())).findFirst()).isPresent()) continue;
                        newTeamContainers.add(tc22);
                    }
                }
                if (!PropertyValidator.isValid((Collection)(itemLinks = item2.getItemLinks()))) continue;
                tc22 = itemLinks.iterator();
                while (tc22.hasNext()) {
                    ItemLink itemLink = (ItemLink)tc22.next();
                    newItemLinks.add(itemLink);
                }
            }
            newContainers.forEach(f -> {
                f.setDuplicateOfId(f.getId());
                if (!PropertyValidator.isValid((Object)f.getOriginItemId())) {
                    f.setOriginItemId(f.getId());
                }
                f.setId(null);
            });
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String sStackTrace = sw.toString();
            LOGGER.debug(" :: JsonProcessingException ..  " + sStackTrace);
        }
        newContainers = this.containerRepository.save((Iterable)newContainers);
        ArrayList<TeamContainer> modTeamContainers = new ArrayList<TeamContainer>();
        for (TeamContainer tc : newTeamContainers) {
            Optional<Container> container2 = newContainers.stream().filter(x -> tc.getContainer().getId().equals(x.getDuplicateOfId())).findFirst();
            tc.setContainer(container2.get());
            modTeamContainers.add(tc);
        }
        modTeamContainers.forEach(f -> {
            f.setDuplicateOfId(f.getId());
            if (!PropertyValidator.isValid((Object)f.getOriginItemId())) {
                f.setOriginItemId(f.getId());
            }
            f.setId(null);
        });
        List subSetsModTeamContainers = Lists.partition(new ArrayList(modTeamContainers), (int)100);
        ArrayList tempModTeamContainers = new ArrayList();
        for (List subSetModTeamContainer : subSetsModTeamContainers) {
            tempModTeamContainers.addAll(this.teamContainerRepository.save((Iterable)subSetModTeamContainer));
            LOGGER.debug(" subSetModTeamContainer....  ");
        }
        modTeamContainers = tempModTeamContainers;
        HashMap<String, String> itemIdsMap = new HashMap<String, String>();
        ArrayList<ItemLink> newItemLinksNotNullList = new ArrayList<ItemLink>();
        for (ItemLink itemLink : newItemLinks) {
            String newItemId;
            String newUserStoryId;
            if (itemLink == null) continue;
            Optional<TeamContainer> srcTc = modTeamContainers.stream().filter(x -> itemLink.getSourceTeamContainerId().equals(x.getDuplicateOfId())).findFirst();
            Optional<TeamContainer> targetTc = modTeamContainers.stream().filter(x -> itemLink.getTargetTeamContainerId().equals(x.getDuplicateOfId())).findFirst();
            if (srcTc.isPresent()) {
                itemLink.setSourceTeamContainerId(srcTc.get().getId());
                if (PropertyValidator.isValid((Object)itemLink.getSourceUserStoryId())) {
                    if (itemIdsMap.containsKey(itemLink.getSourceUserStoryId())) {
                        itemLink.setSourceUserStoryId((String)itemIdsMap.get(itemLink.getSourceUserStoryId()));
                    } else {
                        newUserStoryId = ObjectId.get().toString();
                        itemIdsMap.put(itemLink.getSourceUserStoryId(), newUserStoryId);
                        itemLink.setSourceUserStoryId(newUserStoryId);
                    }
                }
                if (PropertyValidator.isValid((Object)itemLink.getSourceItemId())) {
                    if (itemIdsMap.containsKey(itemLink.getSourceItemId())) {
                        itemLink.setSourceItemId((String)itemIdsMap.get(itemLink.getSourceItemId()));
                    } else {
                        newItemId = ObjectId.get().toString();
                        itemIdsMap.put(itemLink.getSourceItemId(), newItemId);
                        itemLink.setSourceItemId(newItemId);
                    }
                }
                if (PropertyValidator.isValid((Object)itemLink.getSourceFeatureId())) {
                    if (itemIdsMap.containsKey(itemLink.getSourceFeatureId())) {
                        itemLink.setSourceFeatureId((String)itemIdsMap.get(itemLink.getSourceFeatureId()));
                    } else {
                        newItemId = ObjectId.get().toString();
                        itemIdsMap.put(itemLink.getSourceFeatureId(), newItemId);
                        itemLink.setSourceFeatureId(newItemId);
                    }
                }
            }
            if (targetTc.isPresent()) {
                itemLink.setTargetTeamContainerId(targetTc.get().getId());
                if (PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId())) {
                    if (itemIdsMap.containsKey(itemLink.getTargetUserStoryId())) {
                        itemLink.setTargetUserStoryId((String)itemIdsMap.get(itemLink.getTargetUserStoryId()));
                    } else {
                        newUserStoryId = ObjectId.get().toString();
                        itemIdsMap.put(itemLink.getTargetUserStoryId(), newUserStoryId);
                        itemLink.setTargetUserStoryId(newUserStoryId);
                    }
                }
                if (PropertyValidator.isValid((Object)itemLink.getTargetItemId())) {
                    if (itemIdsMap.containsKey(itemLink.getTargetItemId())) {
                        itemLink.setTargetItemId((String)itemIdsMap.get(itemLink.getTargetItemId()));
                    } else {
                        newItemId = ObjectId.get().toString();
                        itemIdsMap.put(itemLink.getTargetItemId(), newItemId);
                        itemLink.setTargetItemId(newItemId);
                    }
                }
                if (PropertyValidator.isValid((Object)itemLink.getTargetFeatureId())) {
                    if (itemIdsMap.containsKey(itemLink.getTargetFeatureId())) {
                        itemLink.setTargetFeatureId((String)itemIdsMap.get(itemLink.getTargetFeatureId()));
                    } else {
                        newItemId = ObjectId.get().toString();
                        itemIdsMap.put(itemLink.getTargetFeatureId(), newItemId);
                        itemLink.setTargetFeatureId(newItemId);
                    }
                }
            }
            itemLink.setOriginItemId(itemLink.getOriginItemId() == null ? itemLink.getId() : itemLink.getOriginItemId());
            itemLink.setDuplicateOfId(itemLink.getId());
            itemLink.setId(null);
            newItemLinksNotNullList.add(itemLink);
        }
        List subSetsNewItemLinksNotNullList = Lists.partition(new ArrayList(newItemLinksNotNullList), (int)100);
        for (List subSetNewItemLinksNotNullList : subSetsNewItemLinksNotNullList) {
            this.itemLinkRepository.save((Iterable)subSetNewItemLinksNotNullList);
            LOGGER.debug(" subSetNewItemLinksNotNullList....  ");
        }
        SessionBoard sessionBoard = new SessionBoard();
        if (PropertyValidator.isValid((Object)requestBoard.getState().getIsFinal()) && requestBoard.getState().getIsFinal().booleanValue()) {
            sessionBoard.setStatus(SessionBoard.CLOSED);
        } else {
            sessionBoard.setStatus(SessionBoard.OPEN);
        }
        sessionBoard.setState(new State(stateId));
        sessionBoard.setContainers(newContainers);
        sessionBoard.setTeams(newTeams);
        sessionBoard.setTeamSequence(savedSessionBoard.getTeamSequence());
        sessionBoard.setObjectiveIds(savedSessionBoard.getObjectiveIds());
        sessionBoard.setObjectivesMap(savedSessionBoard.getObjectivesMap());
        sessionBoard.setCreationDate(new Date());
        sessionBoard.setSession(savedSessionBoard.getSession());
        SessionBoard sessionBoard2 = (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard);
        if (savedSessionBoard.getSession().getAlmEnabled().booleanValue() && PropertyValidator.isValid((Collection)(mappers = this.itemSyncMapperRepository.findBySessionBoard(savedSessionBoard)))) {
            Object itemSyncMapper22;
            for (Object itemSyncMapper22 : mappers) {
                itemSyncMapper22.setSessionBoard(sessionBoard2);
                container = newContainers.stream().filter(arg_0 -> PlanController.lambda$changeState1$25((ItemSyncMapper)itemSyncMapper22, arg_0)).findFirst();
                if (!container.isPresent()) continue;
                itemSyncMapper22.setContainer(container.get());
            }
            List subSetsMappers = Lists.partition(new ArrayList(mappers), (int)100);
            itemSyncMapper22 = subSetsMappers.iterator();
            while (itemSyncMapper22.hasNext()) {
                List subSetMappers = (List)itemSyncMapper22.next();
                this.itemSyncMapperRepository.save((Iterable)subSetMappers);
                LOGGER.debug(" subSetMappers....  ");
            }
        }
        List tsvList = this.teamSprintVelocityRepository.findBySessionBoardId(savedSessionBoard.getId());
        tsvList.forEach(f -> f.setDuplicateOfId(f.getId()));
        for (Object newTsv : tsvList) {
            container = newContainers.stream().filter(arg_0 -> PlanController.lambda$changeState1$27((TeamSprintVelocity)newTsv, arg_0)).findFirst();
            if (container.isPresent()) {
                newTsv.setSprintId(container.get().getId());
            }
            newTsv.setId(null);
            newTsv.setSessionBoardId(sessionBoard2.getId());
        }
        List subSetsTSVList = Lists.partition(new ArrayList(tsvList), (int)100);
        for (Object subSetTSVList : subSetsTSVList) {
            this.teamSprintVelocityRepository.save((Iterable)subSetTSVList);
            LOGGER.debug(" subSetTSVList....  ");
        }
        ArrayList<SessionBoard> newSessionBoardList = new ArrayList<SessionBoard>();
        newSessionBoardList.add(sessionBoard2);
        for (Item item3 : items) {
            if (PropertyValidator.isValid((Collection)item3.getTeamContainers())) {
                for (TeamContainer tc : item3.getTeamContainers()) {
                    for (TeamContainer xtc : modTeamContainers) {
                        if (!PropertyValidator.isValid((Object)tc) || !PropertyValidator.isValid((Object)xtc) || !tc.getId().equals(xtc.getDuplicateOfId())) continue;
                        tc.setId(xtc.getId());
                    }
                }
            }
            item3.setSessionBoards(newSessionBoardList);
            newItems.add(item3);
        }
        ArrayList itemJiraDependencies = new ArrayList();
        HashMap oldIdsMap = new HashMap();
        HashMap itemDuplicateOfMap = new HashMap();
        newItems.forEach(item -> {
            String newItemId = ObjectId.get().toString();
            oldIdsMap.put(item.getId(), newItemId);
            item.setDuplicateOfId(item.getId());
            if (!PropertyValidator.isValid((Object)item.getOriginItemId())) {
                item.setOriginItemId(item.getId());
            }
            if (itemIdsMap.containsKey(item.getId())) {
                oldIdsMap.put(item.getId(), itemIdsMap.get(item.getId()));
                item.setId((String)itemIdsMap.get(item.getId()));
            } else {
                item.setId(newItemId);
            }
            item.setSuspendActivity(true);
            if (PropertyValidator.isValid((Collection)item.getJiraDependencies())) {
                for (ItemJiraDependency itemJiraDependency : item.getJiraDependencies()) {
                    if (!PropertyValidator.isValid((Object)itemJiraDependency)) continue;
                    if (PropertyValidator.isValid((Object)itemJiraDependency.getSourceItemId()) && oldIdsMap.containsKey(itemJiraDependency.getSourceItemId())) {
                        itemJiraDependency.setId(null);
                        itemJiraDependency.setSourceItemId((String)oldIdsMap.get(itemJiraDependency.getSourceItemId()));
                    }
                    if (PropertyValidator.isValid((Object)itemJiraDependency.getTargetItemId()) && oldIdsMap.containsKey(itemJiraDependency.getTargetItemId())) {
                        itemJiraDependency.setId(null);
                        itemJiraDependency.setTargetItemId((String)oldIdsMap.get(itemJiraDependency.getTargetItemId()));
                    }
                    itemJiraDependencies.add(itemJiraDependency);
                }
            }
            itemDuplicateOfMap.put(item.getDuplicateOfId(), item.getId());
        });
        if (PropertyValidator.isValid(itemJiraDependencies)) {
            List subSetsItemJiraDependencies = Lists.partition(new ArrayList(itemJiraDependencies), (int)100);
            for (Object subSetItemJiraDependencies : subSetsItemJiraDependencies) {
                this.itemJiraDependencyRepository.save((Iterable)subSetItemJiraDependencies);
                LOGGER.debug(" subSetItemJiraDependencies....  ");
            }
        }
        List subSetsNewItems = Lists.partition(new ArrayList(newItems), (int)100);
        ArrayList tempNewItems = new ArrayList();
        for (List subSetNewItems : subSetsNewItems) {
            tempNewItems.addAll(this.itemRepository.save((Iterable)subSetNewItems));
            LOGGER.debug(" subSetNewItems....  ");
        }
        newItems = tempNewItems;
        ArrayList<Item> itemsWithParent = new ArrayList<Item>();
        int ind = 0;
        for (Item item2 : newItems) {
            if (!Item.USER_STORY.equals(item2.getType()) || !PropertyValidator.isValid((Object)item2.getParent())) continue;
            if (itemDuplicateOfMap.containsKey(item2.getParent().getId())) {
                item2.setParent(new Item((String)itemDuplicateOfMap.get(item2.getParent().getId())));
                itemsWithParent.add(item2);
            }
            LOGGER.debug(" Item.USER_STORY.equals(item.getType()) loop....  " + ind++);
        }
        List subSetsItemsWithParent = Lists.partition(new ArrayList(itemsWithParent), (int)100);
        for (List subSetItemsWithParent : subSetsItemsWithParent) {
            this.itemRepository.save((Iterable)subSetItemsWithParent);
            LOGGER.debug(" subSetItemsWithParent....  ");
        }
        sessionBoard2.copyObjectives(itemDuplicateOfMap);
        this.customRepository.setSessionBoardParent(savedSessionBoard.getId(), sessionBoard2.getId());
        this.customRepository.lockSessionBoard(savedSessionBoard.getId(), Boolean.valueOf(true));
        this.customRepository.updateSessionBoardsParent(boardId, sessionBoard2.getId());
        this.customRepository.updateActiveSessionBoard(sessionBoard2.getSession().getId(), sessionBoard2.getId());
        SessionBoard sessionBoard3 = (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard2);
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("type", (Object)"Board");
            jSONObject.put("newStateId", (Object)stateId);
            jSONObject.put("newBoardId", (Object)sessionBoard3.getId());
            jSONObject.put("metaMap", (Object)requestBoard.getMetaMap());
            PushSender.sendMsg((String)jSONObject.toString());
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return sessionBoard3;
    }

    @RequestMapping(value={"/changeState"})
    @ResponseBody
    public ResponseEntity<Object> changeState(@RequestBody String request) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity((Object)"success", HttpStatus.OK);
    }

    @RequestMapping(value={"/duplicateSession"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> duplicateSession(@RequestBody Map<String, Object> paramMap) {
        try {
            Iterator tempModTeamContainers;
            HashMap<String, String> responseJson = new HashMap<String, String>();
            Gson gson = new Gson();
            String sessionBoardIdToBeCopied = (String)paramMap.get("id");
            String sessionName = (String)paramMap.get("name");
            String linkRegister = (String)paramMap.get("linkRegister");
            String teamMapping = (String)paramMap.get("teamMapping");
            String sprintMapping = (String)paramMap.get("sprintMapping");
            String backlogData = (String)paramMap.get("backlogData");
            String sprintData = (String)paramMap.get("sprintData");
            String objectivesData = (String)paramMap.get("objectivesData");
            String velocitiesData = (String)paramMap.get("velocitiesData");
            String collectionId = (String)paramMap.get("collection");
            String isTFSBoard = (String)paramMap.get("isTFSBoard");
            String sessionId = (String)paramMap.get("sessionId");
            String prefix = (String)paramMap.get("prefix");
            String color = (String)paramMap.get("color");
            Boolean planningAgenda = false;
            Boolean teamCapacity = false;
            Boolean teamCapacitySprint = false;
            Boolean programRoles = false;
            Boolean planningSos = false;
            Boolean enableWsjf = false;
            String newSessionId = ObjectId.get().toString();
            String newSessionBoardId = ObjectId.get().toString();
            SessionBoard newCopiedSessionBoard = null;
            SessionBoard oldSessionBoard = null;
            Session savedSession = null;
            AlmConfigurations almConfiguration = null;
            TFSAlmConfigurations tfsALMConfiguration = null;
            List tfsProjects = null;
            ArrayList<WorkFlow> tfsWorkFlows = new ArrayList<WorkFlow>();
            ArrayList tfsWorkFlowItemTypes = new ArrayList();
            Object tfsFilters = null;
            newCopiedSessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardIdToBeCopied));
            oldSessionBoard = new SessionBoard(newCopiedSessionBoard);
            savedSession = newCopiedSessionBoard.getSession();
            String oldSessionId = savedSession.getId();
            HashMap<String, String> statusMapByOldId = new HashMap<String, String>();
            HashMap<String, String> workFlowItemTypeMapByOldId = new HashMap<String, String>();
            HashMap<String, String> workFlowMapByOldId = new HashMap<String, String>();
            HashMap tfsProjectMapByOldId = new HashMap();
            List jiraSessionStatuses = new ArrayList();
            ArrayList<Status> tfsSessionStatuses = new ArrayList<Status>();
            ResyncParamsVO syncUitls = new ResyncParamsVO();
            if (!"true".equals(isTFSBoard) && PropertyValidator.isValid(jiraSessionStatuses = this.statusRepository.findBySessionIdAndJiraProjKeyExists(savedSession.getId(), Boolean.valueOf(true)))) {
                for (Status status : jiraSessionStatuses) {
                    String newStatusId = ObjectId.get().toString();
                    statusMapByOldId.put(status.getId(), newStatusId);
                    status.setId(newStatusId);
                    status.setSessionId(newSessionId);
                    status.setCreatedOn(new Date());
                    status.setCreatedBy(UserContextUtil.getUserContext().getLoggedInUser().getUserName());
                }
            }
            boolean isResyncRequired = false;
            HashMap<String, TFSTeamMapping> tfsTeamMappingsWithKendsiTeamId = new HashMap<String, TFSTeamMapping>();
            if (savedSession.getAlmEnabled().booleanValue()) {
                HashMap<String, String> oldProjectIdMap = new HashMap<String, String>();
                if ("true".equals(isTFSBoard)) {
                    tfsProjects = this.tfsProjectRepository.findBySessionId(savedSession.getId());
                    if (PropertyValidator.isValid((Collection)tfsProjects)) {
                        for (TFSProject tfsProject : tfsProjects) {
                            String newProjectId = ObjectId.get().toString();
                            oldProjectIdMap.put(tfsProject.getId(), newProjectId);
                            tfsProject.setId(newProjectId);
                            tfsProject.setSessionId(newSessionId);
                            tfsProject.setCreatedOn(new Date());
                            tfsProject.setCreatedBy(UserContextUtil.getUserContext().getLoggedInUser().getUserName());
                        }
                        for (int i = 0; i < tfsProjects.size(); ++i) {
                            WorkFlow workflow;
                            String newid;
                            TFSProject project2 = (TFSProject)tfsProjects.get(i);
                            List itemTypes = this.workFlowItemTypeRepository.findBySessionIdAndTfsProjectId(savedSession.getId(), project2.getTfsId());
                            if (PropertyValidator.isValid((Collection)itemTypes)) {
                                for (WorkFlowItemType workFlowItemType : itemTypes) {
                                    newid = ObjectId.get().toString();
                                    workFlowItemTypeMapByOldId.put(workFlowItemType.getId(), newid);
                                    workFlowItemType.setId(newid);
                                    workFlowItemType.setSessionId(newSessionId);
                                    workFlowItemType.setCreatedOn(new Date());
                                    workFlowItemType.setCreatedBy(UserContextUtil.getUserContext().getLoggedInUser().getUserName());
                                }
                                tfsWorkFlowItemTypes.addAll(itemTypes);
                            }
                            if (!PropertyValidator.isValid((Object)(workflow = this.workFlowRepository.findBySessionIdAndTfsProjectId(savedSession.getId(), project2.getTfsId())))) continue;
                            List statuses = this.statusRepository.findByWorkFlow(workflow);
                            newid = ObjectId.get().toString();
                            workFlowMapByOldId.put(workflow.getId(), newid);
                            workflow.setId(newid);
                            workflow.setSessionId(newSessionId);
                            workflow.setCreatedOn(new Date());
                            workflow.setCreatedBy(UserContextUtil.getUserContext().getLoggedInUser().getUserName());
                            tfsWorkFlows.add(workflow);
                            for (Status status : statuses) {
                                String newStatusId = ObjectId.get().toString();
                                statusMapByOldId.put(status.getId(), newStatusId);
                                status.setId(newStatusId);
                                status.setSessionId(newSessionId);
                                status.setWorkFlow(workflow);
                                status.setWorkFlowItemType(new WorkFlowItemType((String)workFlowItemTypeMapByOldId.get(status.getWorkFlowItemType().getId())));
                                status.setCreatedOn(new Date());
                                status.setCreatedBy(UserContextUtil.getUserContext().getLoggedInUser().getUserName());
                                tfsSessionStatuses.add(status);
                            }
                        }
                        this.tfsProjectRepository.save((Iterable)tfsProjects);
                        this.workFlowRepository.save(tfsWorkFlows);
                        this.workFlowItemTypeRepository.save(tfsWorkFlowItemTypes);
                        this.statusRepository.save(tfsSessionStatuses);
                    }
                    TFSAlmConfigurations savedTFSAlmConfiguration = savedSession.getTfsAlmConfigurations();
                    tfsALMConfiguration = new TFSAlmConfigurations();
                    tfsALMConfiguration.setId(ObjectId.get().toString());
                    tfsALMConfiguration.setAlmAccount(savedTFSAlmConfiguration.getAlmAccount());
                    tfsALMConfiguration.setCreatedOn(new Date());
                    tfsALMConfiguration.setCreatedBy(UserContextUtil.getUserContext().getLoggedInUser().getUserName());
                    if ("true".equals(teamMapping) && PropertyValidator.isValid((Object)savedTFSAlmConfiguration) && PropertyValidator.isValid((Collection)savedTFSAlmConfiguration.getTeamMappings())) {
                        for (TFSTeamMapping tfsTeamMapping : savedTFSAlmConfiguration.getTeamMappings()) {
                            tfsTeamMapping.setTfsProject((String)oldProjectIdMap.get(tfsTeamMapping.getTfsProject()));
                            tfsTeamMappingsWithKendsiTeamId.put(tfsTeamMapping.getKendisTeamId(), tfsTeamMapping);
                        }
                        tfsALMConfiguration.setTeamMappings(savedTFSAlmConfiguration.getTeamMappings());
                    }
                    if (paramMap.containsKey("wiql") || paramMap.containsKey("tfsFilter") || paramMap.containsKey("wiqlParams")) {
                        isResyncRequired = true;
                        TFSFilter newTfsFilter = new TFSFilter();
                        newTfsFilter.setId(ObjectId.get().toString());
                        newTfsFilter.setSessionId(savedSession.getId());
                        newTfsFilter.setFilterFetchedBy(UserContextUtil.getUserContext().getLoggedInUser());
                        newTfsFilter.setSystem(Boolean.TRUE);
                        if (paramMap.containsKey("wiqlParams")) {
                            String workItemType = (String)paramMap.get("workItemType");
                            Object iterationPath = paramMap.get("iterationPath");
                            Object iterationPathId = paramMap.get("iterationPathId");
                            Object areaPath = paramMap.get("areaPath");
                            Object areaPathId = paramMap.get("areaPathId");
                            Object _state = paramMap.get("state");
                            String iterationPathOp = (String)paramMap.get("iterationPathOp");
                            String areaPathOp = (String)paramMap.get("areaPathOp");
                            String stateOp = (String)paramMap.get("stateOp");
                            String wiql = AlmUtils.createWIQLQuery(paramMap);
                            newTfsFilter.setMoreInfo(new HashMap());
                            newTfsFilter.getMoreInfo().put("iterationPathOp", iterationPathOp);
                            newTfsFilter.getMoreInfo().put("areaPathOp", areaPathOp);
                            newTfsFilter.getMoreInfo().put("stateOp", stateOp);
                            newTfsFilter.getMoreInfo().put("itemType", workItemType);
                            newTfsFilter.getMoreInfo().put("areaPath", areaPath);
                            newTfsFilter.getMoreInfo().put("iterationPath", iterationPath);
                            newTfsFilter.getMoreInfo().put("iterationPathId", iterationPathId);
                            newTfsFilter.getMoreInfo().put("areaPathId", areaPathId);
                            newTfsFilter.getMoreInfo().put("state", _state);
                            newTfsFilter.setTfsId(ObjectId.get().toString());
                            newTfsFilter.setIsWiql(Boolean.TRUE);
                            newTfsFilter.setQueryJSON(wiql);
                            newTfsFilter.setName("Features by Iteration Path");
                        } else if (paramMap.containsKey("wiql")) {
                            String wiql = (String)paramMap.get("wiql");
                            newTfsFilter.setTfsId(ObjectId.get().toString());
                            newTfsFilter.setIsWiql(Boolean.TRUE);
                            newTfsFilter.setQueryJSON(wiql);
                            newTfsFilter.setName("Features by Iteration Path");
                        } else {
                            String tfsFilterStr = (String)paramMap.get("tfsFilter");
                            32 _T = new /* Unavailable Anonymous Inner Class!! */;
                            Map tfsFilterMap = (Map)gson.fromJson(tfsFilterStr, _T.getType());
                            newTfsFilter.setTfsId((String)tfsFilterMap.get("id"));
                            newTfsFilter.setIsWiql(Boolean.FALSE);
                            newTfsFilter.setHtmlUrl((String)tfsFilterMap.get("htmlUrl"));
                            newTfsFilter.setQueryJSON((String)tfsFilterMap.get("wiql"));
                            newTfsFilter.setName((String)tfsFilterMap.get("name"));
                        }
                        TFSBacklogMappingLinks backlogMapping = new TFSBacklogMappingLinks();
                        String tfsProjectName = (String)paramMap.get("tfsProjectName");
                        String tfsProjectId = (String)paramMap.get("tfsProjectId");
                        newTfsFilter.setTfsProject(tfsProjectName);
                        newTfsFilter.setTfsProjectId(tfsProjectId);
                        backlogMapping.setTfsProjectId(tfsProjectId);
                        backlogMapping.setProject(tfsProjectName);
                        backlogMapping.setLinkTypes(Arrays.asList("System.LinkTypes.Hierarchy-Forward"));
                        backlogMapping.setLinkTypesName(Arrays.asList("Child"));
                        newTfsFilter.setBacklogMappingLinks(Arrays.asList(backlogMapping));
                        this.tfsFilterRepository.save((Object)newTfsFilter);
                        if (tfsALMConfiguration.getFeatureFilters() == null) {
                            tfsALMConfiguration.setFeatureFilters(new ArrayList());
                        }
                        tfsALMConfiguration.getFeatureFilters().add(newTfsFilter);
                    }
                    this.tfsAlmConfigurationsRepository.save((Object)tfsALMConfiguration);
                    savedSession.setTfsAlmConfigurations(tfsALMConfiguration);
                } else {
                    AlmConfigurations savedAlmConfiguration = (AlmConfigurations)savedSession.getAlmConfigurations().get(0);
                    almConfiguration = new AlmConfigurations();
                    almConfiguration.setId(ObjectId.get().toString());
                    almConfiguration.setAlmAccount(savedAlmConfiguration.getAlmAccount());
                    almConfiguration.setCreatedOn(new Date());
                    almConfiguration.setCreatedBy(UserContextUtil.getUserContext().getLoggedInUser().getUserName());
                    if ("true".equals(teamMapping)) {
                        almConfiguration.setTeamMappings(savedAlmConfiguration.getTeamMappings());
                    }
                    almConfiguration = (AlmConfigurations)this.almConfigurationsRepository.save((Object)almConfiguration);
                    ArrayList<AlmConfigurations> almConfigs = new ArrayList<AlmConfigurations>();
                    almConfigs.add(almConfiguration);
                    savedSession.setAlmConfigurations(almConfigs);
                }
            }
            savedSession.setId(newSessionId);
            savedSession.setTitle(sessionName);
            savedSession.setPrefix(prefix);
            savedSession.setPrefixColor(color);
            savedSession.setHidePiJourney(Boolean.valueOf(false));
            savedSession.setCreatedOn(new Date());
            savedSession.setCreatedBy(UserContextUtil.getUserContext().getLoggedInUser().getUserName());
            savedSession.setActiveSessionBoard(newSessionBoardId);
            savedSession.setStartDate(null);
            savedSession.setEndDate(null);
            savedSession.setPlanningStartDate(null);
            savedSession.setPlanningEndDate(null);
            savedSession.setPiNumber(null);
            savedSession.setAdditionalFieldsEnabled(Boolean.valueOf(false));
            savedSession.setAdditionalFieldsIdsFeature(null);
            savedSession.setAdditionalFieldsIdsUserStory(null);
            savedSession.setAdditionalFieldsTypesFeature(null);
            savedSession.setAdditionalFieldsTypesUserStory(null);
            savedSession.setAdditionalFieldsValuesFeature(null);
            savedSession.setAdditionalFieldsValuesUserStory(null);
            savedSession.setConfidenceVoteSurvey(null);
            savedSession.setLoadOldObjectivesView(Boolean.valueOf(false));
            savedSession.setLoadNewStructureMilestones(Boolean.valueOf(true));
            savedSession.setItemsAddedFromKanban(null);
            savedSession.setDisabledForDashboardListing(false);
            if (isResyncRequired) {
                savedSession.setResyncRequired(Boolean.TRUE);
            }
            savedSession.setHideMilestonesBar(Boolean.FALSE);
            if (!"true".equals(linkRegister)) {
                savedSession.setRiskRegister(null);
            }
            if (PropertyValidator.isValid((Object)collectionId)) {
                WorkSpace workspace = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)collectionId));
                savedSession.setWorkSpace(workspace);
            }
            savedSession = (Session)this.sessionRepository.save((Object)savedSession);
            newCopiedSessionBoard.setId(newSessionBoardId);
            newCopiedSessionBoard.setStatus(SessionBoard.OPEN);
            newCopiedSessionBoard.setObjectiveIds(null);
            newCopiedSessionBoard.setObjectivesMap(null);
            newCopiedSessionBoard.setParentBoard(null);
            newCopiedSessionBoard.setCreationDate(new Date());
            newCopiedSessionBoard.setCreatedOn(new Date());
            newCopiedSessionBoard.setStateChangeDate(null);
            newCopiedSessionBoard.setCreatedBy(UserContextUtil.getUserContext().getUsername());
            State draftState = this.stateRepository.findByTitle("Draft");
            newCopiedSessionBoard.setState(draftState);
            newCopiedSessionBoard.setSession(savedSession);
            ArrayList existingContainers = oldSessionBoard.getContainers();
            List<Container> newContainers = null;
            ArrayList oldContainers = new ArrayList(newCopiedSessionBoard.getContainers());
            HashMap<String, String> newContainersIdByOldId = new HashMap<String, String>();
            HashMap<String, String> newContainersIdByOldOriginId = new HashMap<String, String>();
            HashMap<String, String> oldOriginIdByNewContainersId = new HashMap<String, String>();
            HashMap oldContainersById = new HashMap();
            HashMap<String, Map> tfsSprintDataByNewSprintId = new HashMap<String, Map>();
            oldContainers.forEach(f -> oldContainersById.put(f.getId(), f));
            if (paramMap.containsKey("kendisSprints")) {
                String kendisSprintsStr = (String)paramMap.get("kendisSprints");
                33 _T = new /* Unavailable Anonymous Inner Class!! */;
                List kendisSprints = (List)gson.fromJson(kendisSprintsStr, _T.getType());
                newContainers = new ArrayList();
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                df.setTimeZone(TimeZone.getTimeZone("UTC"));
                if (PropertyValidator.isValid((Collection)kendisSprints)) {
                    for (Map sprintMap : kendisSprints) {
                        Container newSprint = null;
                        String newContainerId = ObjectId.get().toString();
                        if (existingContainers.size() > 0) {
                            newSprint = (Container)existingContainers.get(0);
                            existingContainers.remove(0);
                            newContainersIdByOldId.put(newSprint.getId(), newContainerId);
                            newContainersIdByOldOriginId.put(newSprint.getOriginItemId(), newContainerId);
                            oldOriginIdByNewContainersId.put(newContainerId, newSprint.getOriginItemId());
                        } else {
                            newSprint = new Container();
                        }
                        newSprint.setId(newContainerId);
                        tfsSprintDataByNewSprintId.put(newContainerId, sprintMap);
                        newSprint.setTitle((String)sprintMap.get("title"));
                        newSprint.setLabel((String)sprintMap.get("label"));
                        String startDateStr = (String)sprintMap.get("startDate");
                        String endDateStr = (String)sprintMap.get("endDate");
                        if (PropertyValidator.isValid((Object)startDateStr)) {
                            Date startDate = df.parse(startDateStr);
                            newSprint.setStartDate(startDate);
                        } else {
                            newSprint.setStartDate(null);
                        }
                        if (PropertyValidator.isValid((Object)endDateStr)) {
                            Date endDate = df.parse(endDateStr);
                            newSprint.setEndDate(endDate);
                        } else {
                            newSprint.setEndDate(null);
                        }
                        newSprint.setStartedOn(null);
                        newSprint.setEndedOn(null);
                        newSprint.setCreatedOn(new Date());
                        newSprint.setCreatedBy(UserContextUtil.getUserContext().getLoggedInUser().getUserName());
                        newSprint.setOriginItemId(null);
                        newSprint.setDuplicateOfId(null);
                        newSprint.setDuplicateToId(null);
                        newContainers.add(newSprint);
                    }
                }
            } else {
                newContainers = existingContainers;
                newContainers.forEach(f -> {
                    String newContainerId = ObjectId.get().toString();
                    newContainersIdByOldId.put(f.getId(), newContainerId);
                    newContainersIdByOldOriginId.put(f.getOriginItemId(), newContainerId);
                    oldOriginIdByNewContainersId.put(newContainerId, f.getOriginItemId());
                    f.setId(newContainerId);
                    f.setStartDate(null);
                    f.setEndDate(null);
                    f.setStartedOn(null);
                    f.setEndedOn(null);
                    f.setCreatedOn(new Date());
                    f.setCreatedBy(UserContextUtil.getUserContext().getLoggedInUser().getUserName());
                    f.setOriginItemId(null);
                    f.setDuplicateOfId(null);
                    f.setDuplicateToId(null);
                });
            }
            List<ItemSyncMapper> mappers = null;
            if (paramMap.containsKey("kendisSprints")) {
                mappers = new ArrayList();
                if (newCopiedSessionBoard.getSession().getAlmEnabled().booleanValue()) {
                    Iterator tfsProjectId = (String)paramMap.get("tfsProjectId");
                    List existingMappers = this.itemSyncMapperRepository.findBySessionBoard(new SessionBoard(sessionBoardIdToBeCopied));
                    HashMap<Object, ItemSyncMapper> itemSyncMappersByKey = new HashMap<Object, ItemSyncMapper>();
                    if (PropertyValidator.isValid((Collection)existingMappers)) {
                        for (ItemSyncMapper itemSyncMapper : existingMappers) {
                            if (!PropertyValidator.isValid((Object)itemSyncMapper.getTeam()) || !PropertyValidator.isValid((Object)itemSyncMapper.getContainer())) continue;
                            String newContainerId = (String)newContainersIdByOldId.get(itemSyncMapper.getContainer().getId());
                            String key = itemSyncMapper.getTeam().getId() + ":" + newContainerId;
                            itemSyncMappersByKey.put(key, itemSyncMapper);
                        }
                        if (PropertyValidator.isValid((Collection)newCopiedSessionBoard.getTeams())) {
                            for (Team team : newCopiedSessionBoard.getTeams()) {
                                TFSTeamMapping tfsTeamMapping = (TFSTeamMapping)tfsTeamMappingsWithKendsiTeamId.get(team.getId());
                                for (Container sprint : newContainers) {
                                    Map sprintMap;
                                    String key = team.getId() + ":" + sprint.getId();
                                    ItemSyncMapper itemSyncMapper = (ItemSyncMapper)itemSyncMappersByKey.get(key);
                                    if (itemSyncMapper == null) {
                                        itemSyncMapper = new ItemSyncMapper();
                                        itemSyncMapper.setTeam(team);
                                        itemSyncMapper.setContainer(sprint);
                                    } else {
                                        itemSyncMapper.setContainer(new Container(sprint.getId()));
                                    }
                                    itemSyncMapper.setId(ObjectId.get().toString());
                                    itemSyncMapper.setSessionBoard(newCopiedSessionBoard);
                                    if (!PropertyValidator.isValid((Object)tfsTeamMapping)) continue;
                                    mappers.add(itemSyncMapper);
                                    itemSyncMapper.setTfsSprint(null);
                                    itemSyncMapper.setTfsProjectId(tfsTeamMapping.getTfsProjectTfsId());
                                    if (!tfsTeamMapping.getTfsProjectTfsId().equals(tfsProjectId) || !PropertyValidator.isValid((Object)(sprintMap = (Map)tfsSprintDataByNewSprintId.get(sprint.getId())))) continue;
                                    String tfsId = (String)sprintMap.get("tfsSprintId");
                                    String path = (String)sprintMap.get("path");
                                    String title = (String)sprintMap.get("tfsSprintName");
                                    Sprint tfsSprint = new Sprint();
                                    tfsSprint.setIterationPath(path);
                                    tfsSprint.setTitle(title);
                                    tfsSprint.setTfsId(tfsId);
                                    itemSyncMapper.setTfsSprint(tfsSprint);
                                }
                            }
                        }
                    }
                }
            } else if ("true".equals(teamMapping) && "false".equals(sprintMapping) && "true".equals(isTFSBoard)) {
                if (newCopiedSessionBoard.getSession().getAlmEnabled().booleanValue() && PropertyValidator.isValid(mappers = this.itemSyncMapperRepository.findBySessionBoard(new SessionBoard(sessionBoardIdToBeCopied)))) {
                    for (ItemSyncMapper itemSyncMapper : mappers) {
                        if (!PropertyValidator.isValid((Object)itemSyncMapper.getContainer())) continue;
                        itemSyncMapper.setId(ObjectId.get().toString());
                        itemSyncMapper.setSessionBoard(newCopiedSessionBoard);
                        itemSyncMapper.setTfsSprint(null);
                        if (!newContainersIdByOldId.containsKey(itemSyncMapper.getContainer().getId())) continue;
                        itemSyncMapper.setContainer(new Container((String)newContainersIdByOldId.get(itemSyncMapper.getContainer().getId())));
                    }
                }
            } else if ("true".equals(sprintMapping) && newCopiedSessionBoard.getSession().getAlmEnabled().booleanValue() && PropertyValidator.isValid(mappers = this.itemSyncMapperRepository.findBySessionBoard(new SessionBoard(sessionBoardIdToBeCopied)))) {
                for (ItemSyncMapper itemSyncMapper : mappers) {
                    if (!PropertyValidator.isValid((Object)itemSyncMapper.getContainer())) continue;
                    itemSyncMapper.setId(ObjectId.get().toString());
                    itemSyncMapper.setSessionBoard(newCopiedSessionBoard);
                    if (!newContainersIdByOldId.containsKey(itemSyncMapper.getContainer().getId())) continue;
                    itemSyncMapper.setContainer(new Container((String)newContainersIdByOldId.get(itemSyncMapper.getContainer().getId())));
                }
            }
            List tsvList = null;
            if ("true".equals(velocitiesData)) {
                tsvList = this.teamSprintVelocityRepository.findBySessionBoardId(sessionBoardIdToBeCopied);
                for (TeamSprintVelocity newTsv : tsvList) {
                    if (newContainersIdByOldId.containsKey(newTsv.getSprintId())) {
                        newTsv.setSprintId((String)newContainersIdByOldId.get(newTsv.getSprintId()));
                    }
                    newTsv.setId(ObjectId.get().toString());
                    newTsv.setSessionBoardId(newCopiedSessionBoard.getId());
                    newTsv.setCreatedOn(new Date());
                    newTsv.setCommitedLoad(Double.valueOf(0.0));
                    newTsv.setLastBaseLineAuditLogId(null);
                    newTsv.setLastSpillOverAuditLogId(null);
                    newTsv.setLastBaseLineDate(null);
                    newTsv.setLastSpillOverDate(null);
                    newTsv.setCreatedBy(UserContextUtil.getUserContext().getLoggedInUser().getUserName());
                }
            }
            List dependencyLimit = null;
            dependencyLimit = this.almSyncService.getTeamSprintDependencies(oldSessionId);
            if (PropertyValidator.isValid((Collection)dependencyLimit)) {
                for (TeamSprintDependencyLimit teamSprintLimit : dependencyLimit) {
                    teamSprintLimit.setId(ObjectId.get().toString());
                    teamSprintLimit.setSessionId(newSessionId);
                    teamSprintLimit.setSprintId((String)newContainersIdByOldId.get(teamSprintLimit.getSprintId()));
                }
                this.TeamSprintDependencyLimitRepository.save((Iterable)dependencyLimit);
            }
            ArrayList newItemLinks = new ArrayList();
            ArrayList newItems = new ArrayList();
            ArrayList newTeamContainers = new ArrayList();
            HashMap newTeamContainersNewIdsMapByOldId = new HashMap();
            HashMap oldTeamContainersMapByOldId = new HashMap();
            HashMap newItemsIdsMapByOldId = new HashMap();
            ArrayList newItemJiraDependencies = new ArrayList();
            ArrayList subItems = new ArrayList();
            ArrayList parentItems = new ArrayList();
            if ("true".equals(backlogData)) {
                // empty if block
            }
            if ("true".equals(objectivesData) && "true".equals(backlogData)) {
                newCopiedSessionBoard.copyObjectives(newItemsIdsMapByOldId);
            }
            if (PropertyValidator.isValid(newContainers)) {
                newContainers = this.containerRepository.save(newContainers);
            }
            if (PropertyValidator.isValid(mappers)) {
                List subSetsMappers = Lists.partition(new ArrayList(mappers), (int)100);
                for (List subSetMappers : subSetsMappers) {
                    this.itemSyncMapperRepository.save((Iterable)subSetMappers);
                }
            }
            if (PropertyValidator.isValid((Collection)tsvList)) {
                List subSetsTSVList = Lists.partition(new ArrayList(tsvList), (int)100);
                for (Object subSetTSVList : subSetsTSVList) {
                    this.teamSprintVelocityRepository.save((Iterable)subSetTSVList);
                }
            }
            if (PropertyValidator.isValid(newTeamContainers) && "true".equals(sprintData)) {
                List subSetsModTeamContainers = Lists.partition(new ArrayList(newTeamContainers), (int)100);
                tempModTeamContainers = new ArrayList();
                for (List subSetModTeamContainer : subSetsModTeamContainers) {
                    tempModTeamContainers.addAll(this.teamContainerRepository.save((Iterable)subSetModTeamContainer));
                    LOGGER.debug(" subSetModTeamContainer.... ");
                }
            }
            if (PropertyValidator.isValid(newItemLinks) && "true".equals(sprintData)) {
                List subSetsNewItemLinksNotNullList = Lists.partition(new ArrayList(newItemLinks), (int)100);
                for (List subSetNewItemLinksNotNullList : subSetsNewItemLinksNotNullList) {
                    this.itemLinkRepository.save((Iterable)subSetNewItemLinksNotNullList);
                    LOGGER.debug(" subSetNewItemLinksNotNullList.... ");
                }
            }
            if (PropertyValidator.isValid(parentItems)) {
                List subSetsParentItems = Lists.partition(new ArrayList(parentItems), (int)100);
                tempModTeamContainers = subSetsParentItems.iterator();
                while (tempModTeamContainers.hasNext()) {
                    List subSetParentItems = (List)tempModTeamContainers.next();
                    this.itemRepository.save((Iterable)subSetParentItems);
                }
            }
            if (PropertyValidator.isValid(subItems)) {
                for (Object subItem : subItems) {
                    subItem.setParent(new Item((String)newItemsIdsMapByOldId.get(subItem.getParent().getId())));
                }
                List subSetsSubItems = Lists.partition(new ArrayList(subItems), (int)100);
                for (List subSetSubItems : subSetsSubItems) {
                    this.itemRepository.save((Iterable)subSetSubItems);
                }
            }
            newCopiedSessionBoard.setContainers(newContainers);
            newCopiedSessionBoard.setNoticationCounter(null);
            newCopiedSessionBoard.setTzEnabled(null);
            newCopiedSessionBoard.setTzStartTime(null);
            newCopiedSessionBoard.setTzStartTimeDiff(null);
            newCopiedSessionBoard.setTzEndTime(null);
            newCopiedSessionBoard.setTzEndTimeDiff(null);
            newCopiedSessionBoard.setTzSite(null);
            newCopiedSessionBoard = (SessionBoard)this.sessionBoardRepository.save((Object)newCopiedSessionBoard);
            this.planService.copyCollaborationTypesFromOriginalBoard(sessionBoardIdToBeCopied, newCopiedSessionBoard.getId(), newSessionId);
            if (newCopiedSessionBoard.getSession().getAlmEnabled().booleanValue() && PropertyValidator.isValid((Collection)newCopiedSessionBoard.getSession().getAlmConfigurations()) && PropertyValidator.isValid((Collection)((AlmConfigurations)newCopiedSessionBoard.getSession().getAlmConfigurations().get(0)).getTeamMappings())) {
                AlmConfigurations configurations = (AlmConfigurations)newCopiedSessionBoard.getSession().getAlmConfigurations().get(0);
                for (BacklogMapping bm : configurations.getTeamMappings()) {
                    if (!PropertyValidator.isValid((Object)bm.getProjectKey())) continue;
                    syncUitls.retrieveAndConvertJiraStatuses(bm.getProjectKey(), configurations.getAlmAccount(), newCopiedSessionBoard.getSession().getId(), null, false, this.importUtil, this.statusRepository);
                }
            }
            ArrayList<String> sessionIds = new ArrayList<String>();
            sessionIds.add(sessionId);
            List oldTeamSprintVelocityList = this.teamSprintVelocityRepository.findBySessionBoardId(sessionBoardIdToBeCopied);
            if (paramMap.get("planningAgenda") != null) {
                planningAgenda = (Boolean)paramMap.get("planningAgenda");
            }
            if (paramMap.get("teamCapacity") != null) {
                teamCapacity = (Boolean)paramMap.get("teamCapacity");
            }
            if (paramMap.get("programRoles") != null) {
                programRoles = (Boolean)paramMap.get("programRoles");
            }
            if (paramMap.get("planningSos") != null) {
                planningSos = (Boolean)paramMap.get("planningSos");
            }
            if (paramMap.get("teamCapacitySprint") != null) {
                teamCapacitySprint = (Boolean)paramMap.get("teamCapacitySprint");
            }
            if (paramMap.get("enableWsjf") != null) {
                enableWsjf = (Boolean)paramMap.get("enableWsjf");
            }
            if (enableWsjf.booleanValue()) {
                savedSession.setWsjfEnabled(enableWsjf);
                savedSession.setwsjfAlmEnabled(oldSessionBoard.getSession().getwsjfAlmEnabled());
                savedSession.setWsjfKendisEnabled(oldSessionBoard.getSession().getWsjfKendisEnabled());
                savedSession.setSetWsjfAlmFieldForAllProjects(oldSessionBoard.getSession().getSetWsjfAlmFieldForAllProjects());
                if (Boolean.TRUE.equals(oldSessionBoard.getSession().getwsjfAlmEnabled())) {
                    savedSession.setwsjfAlmFieldKey(oldSessionBoard.getSession().getwsjfAlmFieldKey());
                } else {
                    savedSession.setwsjfAlmFieldKey(null);
                }
                if (PropertyValidator.isValid((Object)savedSession.getSetWsjfAlmFieldForAllProjects()) && savedSession.getSetWsjfAlmFieldForAllProjects().booleanValue() && PropertyValidator.isValid((Object)((String)paramMap.get("tfsProjectIds")))) {
                    String tfsProjectIds = (String)paramMap.get("tfsProjectIds");
                    Session sessionSaved = savedSession;
                    ArrayList<String> tfsProjectIdsList = new ArrayList<String>(Arrays.asList(tfsProjectIds.split(",")));
                    List tfsProject = (List)this.tfsProjectRepository.findAll(tfsProjectIdsList);
                    tfsProject.forEach(project -> project.setWsjfAlmField(sessionSaved.getwsjfAlmFieldKey()));
                    this.tfsProjectRepository.save((Iterable)tfsProject);
                }
                if (Boolean.TRUE.equals(savedSession.getWsjfEnabled())) {
                    List mappings;
                    this.aLMSyncService.createScoreCard(oldSessionBoard.getSession(), savedSession);
                    if (oldSessionBoard.getSession() != null && oldSessionBoard.getSession().getScoreCard() != null && (mappings = oldSessionBoard.getSession().getScoreCard().getMappings()) != null) {
                        this.aLMSyncService.saveMappings(savedSession, mappings);
                    }
                    if (PropertyValidator.isValid((Collection)savedSession.getAlmConfigurations())) {
                        this.almConfigurationsRepository.save((Iterable)savedSession.getAlmConfigurations());
                    }
                }
                savedSession = (Session)this.sessionRepository.save((Object)savedSession);
            } else {
                savedSession.setWsjfEnabled(enableWsjf);
                savedSession = (Session)this.sessionRepository.save((Object)savedSession);
            }
            if (planningAgenda.booleanValue() || teamCapacity.booleanValue() || programRoles.booleanValue() || planningSos.booleanValue()) {
                PiJourney oldPiJourney = new PiJourney();
                PiJourney newPiJourney = new PiJourney();
                oldPiJourney = this.piJourneyRepository.findBySessionId(sessionId);
                if (oldPiJourney != null) {
                    Iterator<PiTeamCapacity> newPiTeamCapacityList;
                    newPiJourney.setId(ObjectId.get().toString());
                    newPiJourney.setSessionId(newSessionId);
                    if (teamCapacitySprint.booleanValue()) {
                        newPiJourney.setDefaultUserCapacity(oldPiJourney.getDefaultUserCapacity());
                    }
                    PiAgenda newPiAgenda = new PiAgenda();
                    if (planningAgenda.booleanValue()) {
                        newPiAgenda.setPiJourneyId(newPiJourney.getId());
                        newPiAgenda.setPiAgendaDays(new ArrayList());
                        ArrayList piJourneyDaysList = oldPiJourney.getDays();
                        newPiAgenda = (PiAgenda)this.piAgendaRepository.save((Object)newPiAgenda);
                        newPiJourney.setAgenda(newPiAgenda);
                        ArrayList newPiJourneyDaysList = new ArrayList();
                        Iterator iterator = piJourneyDaysList.iterator();
                        while (iterator.hasNext()) {
                            PiDay oldDay;
                            PiDay piJourneyNewDay = oldDay = (PiDay)iterator.next();
                            piJourneyNewDay.setId(null);
                            piJourneyNewDay.setPiJourneyId(newPiJourney.getId());
                            piJourneyNewDay.setStartTime(Float.valueOf(0.0f));
                            piJourneyNewDay.setEndTime(Float.valueOf(0.0f));
                            piJourneyNewDay.setStartDate(null);
                            piJourneyNewDay.setEndDate(null);
                            newPiJourneyDaysList.add(piJourneyNewDay);
                        }
                        this.piDayRepository.save(newPiJourneyDaysList);
                        newPiJourney.setDays(newPiJourneyDaysList);
                    } else {
                        newPiJourney.setDays(new ArrayList());
                    }
                    newPiJourney.setSites(new ArrayList());
                    newPiJourney = (PiJourney)this.piJourneyRepository.save((Object)newPiJourney);
                    newPiAgenda.setPiAgendaDays(new ArrayList());
                    newPiAgenda.setPiJourneyId(newPiJourney.getId());
                    newPiAgenda = (PiAgenda)this.piAgendaRepository.save((Object)newPiAgenda);
                    newPiJourney.setAgenda(newPiAgenda);
                    newPiJourney = (PiJourney)this.piJourneyRepository.save((Object)newPiJourney);
                    if (planningAgenda.booleanValue()) {
                        List newSites = oldPiJourney.getSites();
                        if (PropertyValidator.isValid((Collection)newSites)) {
                            for (PiSite site : newSites) {
                                site.setId(null);
                            }
                            newSites = this.piSiteRepository.save((Iterable)newSites);
                            newPiJourney.setSites(new ArrayList(newSites));
                        }
                        PiAgenda piAgendaOld = this.piAgendaRepository.findByPiJourneyId(oldPiJourney.getId());
                        if (PropertyValidator.isValid((Object)newPiAgenda) && PropertyValidator.isValid((Object)newPiAgenda.getId())) {
                            ArrayList piDaysList = piAgendaOld.getPiAgendaDays();
                            ArrayList<PiAgendaDay> newPiDaysList = new ArrayList<PiAgendaDay>();
                            for (int i = 0; i < piDaysList.size(); ++i) {
                                PiAgendaDay oldPiAgendaDay;
                                PiAgendaDay newPiAgendaDay = oldPiAgendaDay = (PiAgendaDay)piDaysList.get(i);
                                if (PropertyValidator.isValid((Collection)newPiJourney.getDays())) {
                                    PiDay day = (PiDay)newPiJourney.getDays().get(i);
                                    newPiAgendaDay.setDay(day);
                                }
                                ArrayList oldEventList = newPiAgendaDay.getEvents();
                                List<PiJourneyEvent> newEventList = new ArrayList();
                                newPiAgendaDay.setId(null);
                                Iterator iterator = oldEventList.iterator();
                                while (iterator.hasNext()) {
                                    PiJourneyEvent oldPiJourneyEvent;
                                    PiJourneyEvent newPiJourneyEvent = oldPiJourneyEvent = (PiJourneyEvent)iterator.next();
                                    newPiJourneyEvent.setId(null);
                                    newPiJourneyEvent.setPiJourneyId(newPiJourney.getId());
                                    newPiJourneyEvent.setAttachments(new ArrayList());
                                    newPiJourneyEvent.setRooms(new ArrayList());
                                    newPiJourneyEvent.setTeams(new ArrayList());
                                    newEventList.add(newPiJourneyEvent);
                                }
                                newEventList = this.piJourneyEventRepository.save(newEventList);
                                newPiAgendaDay = (PiAgendaDay)this.piAgendaDayRepository.save((Object)newPiAgendaDay);
                                newPiAgendaDay.setEvents(newEventList);
                                newPiDaysList.add(newPiAgendaDay);
                            }
                            newPiAgenda.setPiAgendaDays(newPiDaysList);
                            newPiJourney.setAgenda(newPiAgenda);
                            newPiAgenda = (PiAgenda)this.piAgendaRepository.save((Object)newPiAgenda);
                            newPiJourney = (PiJourney)this.piJourneyRepository.save((Object)newPiJourney);
                        }
                    }
                    if (teamCapacity.booleanValue()) {
                        List piTeamCapacityList = this.piTeamCapacityRepository.findByPiJourneyIdAndSessionId(oldPiJourney.getId(), sessionId);
                        HashMap<String, Double> teamCapacitySumByTeamIdSprintId = new HashMap<String, Double>();
                        newPiTeamCapacityList = new ArrayList();
                        ArrayList<PiSite> newCapacitySites = new ArrayList<PiSite>();
                        for (Object oldPiTeamCapacity : piTeamCapacityList) {
                            PiTeamCapacity newPiTeamCapacity = oldPiTeamCapacity;
                            newPiTeamCapacity.setPiJourneyId(newPiJourney.getId());
                            newPiTeamCapacity.setSessionId(newSessionId);
                            newPiTeamCapacity.setId(null);
                            HashMap<String, String> oldToNewSiteIdMap = new HashMap<String, String>();
                            HashMap<String, PiSite> newSiteIdMap = new HashMap<String, PiSite>();
                            ArrayList teamSites = oldPiTeamCapacity.getSites();
                            if (PropertyValidator.isValid((Collection)teamSites)) {
                                for (PiSite capSite : teamSites) {
                                    String newSiteId = ObjectId.get().toString();
                                    oldToNewSiteIdMap.put(capSite.getId(), newSiteId);
                                    capSite.setId(newSiteId);
                                    capSite.setUpdatedBy(null);
                                    capSite.setCreatedBy(null);
                                    capSite.setCreatedOn(null);
                                    capSite.setUpdatedOn(null);
                                    newCapacitySites.add(capSite);
                                    newSiteIdMap.put(newSiteId, capSite);
                                }
                            }
                            newPiTeamCapacity.setSites(teamSites);
                            List<PiUserCapacity> piUserCapacityList = new ArrayList();
                            Iterator iterator = newPiTeamCapacity.getUsersCapacity().iterator();
                            while (iterator.hasNext()) {
                                PiContainerCapacity newContainerCapacity;
                                String newUserSiteId;
                                PiUserCapacity oldUserCapacity;
                                PiUserCapacity newUserCapacity = oldUserCapacity = (PiUserCapacity)iterator.next();
                                newUserCapacity.setId(null);
                                newUserCapacity.setPiJourneyId(newPiJourney.getId());
                                newUserCapacity.setSessionBoardId(newSessionBoardId);
                                if (PropertyValidator.isValid((Object)oldUserCapacity.getSite()) && PropertyValidator.isValid((Object)oldUserCapacity.getSite().getId()) && PropertyValidator.isValid((Object)(newUserSiteId = (String)oldToNewSiteIdMap.get(oldUserCapacity.getSite().getId())))) {
                                    newUserCapacity.setSite((PiSite)newSiteIdMap.get(newUserSiteId));
                                }
                                if (teamCapacitySprint.booleanValue()) {
                                    ArrayList<PiContainerCapacity> containerCapacityList = new ArrayList<PiContainerCapacity>();
                                    for (PiContainerCapacity oldContainerCapacity : newUserCapacity.getContainersCapacity()) {
                                        Double capacitySum;
                                        if (newContainersIdByOldOriginId.get(oldContainerCapacity.getContainerId()) != null) {
                                            newContainerCapacity = new PiContainerCapacity();
                                            newContainerCapacity.setCapacity(oldContainerCapacity.getCapacity());
                                            newContainerCapacity.setContainerId(((String)newContainersIdByOldOriginId.get(oldContainerCapacity.getContainerId())).toString());
                                            containerCapacityList.add(newContainerCapacity);
                                            if (!PropertyValidator.isValid(teamCapacitySumByTeamIdSprintId.get(oldPiTeamCapacity.getTeam().getId() + "_" + oldContainerCapacity.getContainerId()))) {
                                                teamCapacitySumByTeamIdSprintId.put(oldPiTeamCapacity.getTeam().getId() + "_" + oldContainerCapacity.getContainerId(), 0.0);
                                            }
                                            capacitySum = (Double)teamCapacitySumByTeamIdSprintId.get(oldPiTeamCapacity.getTeam().getId() + "_" + oldContainerCapacity.getContainerId());
                                            capacitySum = capacitySum + (double)oldContainerCapacity.getCapacity().floatValue();
                                            teamCapacitySumByTeamIdSprintId.put(oldPiTeamCapacity.getTeam().getId() + "_" + oldContainerCapacity.getContainerId(), capacitySum);
                                            continue;
                                        }
                                        if (newContainersIdByOldId.get(oldContainerCapacity.getContainerId()) == null) continue;
                                        newContainerCapacity = new PiContainerCapacity();
                                        newContainerCapacity.setCapacity(oldContainerCapacity.getCapacity());
                                        newContainerCapacity.setContainerId(((String)newContainersIdByOldId.get(oldContainerCapacity.getContainerId())).toString());
                                        containerCapacityList.add(newContainerCapacity);
                                        if (!PropertyValidator.isValid(teamCapacitySumByTeamIdSprintId.get(oldPiTeamCapacity.getTeam().getId() + "_" + oldContainerCapacity.getContainerId()))) {
                                            teamCapacitySumByTeamIdSprintId.put(oldPiTeamCapacity.getTeam().getId() + "_" + oldContainerCapacity.getContainerId(), 0.0);
                                        }
                                        capacitySum = (Double)teamCapacitySumByTeamIdSprintId.get(oldPiTeamCapacity.getTeam().getId() + "_" + oldContainerCapacity.getContainerId());
                                        capacitySum = capacitySum + (double)oldContainerCapacity.getCapacity().floatValue();
                                        teamCapacitySumByTeamIdSprintId.put(oldPiTeamCapacity.getTeam().getId() + "_" + oldContainerCapacity.getContainerId(), capacitySum);
                                    }
                                    newUserCapacity.setContainersCapacity(containerCapacityList);
                                } else {
                                    ArrayList<PiContainerCapacity> emptyCapacityList = new ArrayList<PiContainerCapacity>();
                                    for (PiContainerCapacity oldContainerCapacity : newUserCapacity.getContainersCapacity()) {
                                        if (newContainersIdByOldOriginId.get(oldContainerCapacity.getContainerId()) != null) {
                                            newContainerCapacity = new PiContainerCapacity();
                                            newContainerCapacity.setCapacity(Float.valueOf(0.0f));
                                            newContainerCapacity.setContainerId(((String)newContainersIdByOldOriginId.get(oldContainerCapacity.getContainerId())).toString());
                                            emptyCapacityList.add(newContainerCapacity);
                                            continue;
                                        }
                                        if (newContainersIdByOldId.get(oldContainerCapacity.getContainerId()) == null) continue;
                                        newContainerCapacity = new PiContainerCapacity();
                                        newContainerCapacity.setCapacity(Float.valueOf(0.0f));
                                        newContainerCapacity.setContainerId(((String)newContainersIdByOldId.get(oldContainerCapacity.getContainerId())).toString());
                                        emptyCapacityList.add(newContainerCapacity);
                                    }
                                    newUserCapacity.setContainersCapacity(emptyCapacityList);
                                }
                                piUserCapacityList.add(newUserCapacity);
                            }
                            piUserCapacityList = this.piUserCapacityRepository.save(piUserCapacityList);
                            newPiTeamCapacity.setUsersCapacity(piUserCapacityList);
                            newPiTeamCapacityList.add(newPiTeamCapacity);
                        }
                        this.piSiteRepository.save(newCapacitySites);
                        this.piTeamCapacityRepository.save(newPiTeamCapacityList);
                        List<TeamSprintVelocity> newBoardTeamSprintVelocityList = new ArrayList();
                        if (teamCapacitySprint.booleanValue()) {
                            for (TeamSprintVelocity teamSprintVelocityOld : oldTeamSprintVelocityList) {
                                TeamSprintVelocity tsv = new TeamSprintVelocity(teamSprintVelocityOld);
                                if (PropertyValidator.isValid((Object)tsv.getTeamId()) && PropertyValidator.isValid((Object)tsv.getSprintId())) {
                                    String newSprintId = "";
                                    String originSprintId = "";
                                    if (oldContainersById.get(tsv.getSprintId()) != null) {
                                        newSprintId = (String)newContainersIdByOldOriginId.get(tsv.getSprintId());
                                        String newContainerId = (String)newContainersIdByOldId.get(tsv.getSprintId());
                                        originSprintId = (String)oldOriginIdByNewContainersId.get(newContainerId);
                                    }
                                    if (PropertyValidator.isValid(teamCapacitySumByTeamIdSprintId.get(tsv.getTeamId() + "_" + newSprintId))) {
                                        tsv.setVelocity((Double)teamCapacitySumByTeamIdSprintId.get(tsv.getTeamId() + "_" + newSprintId));
                                    } else if (PropertyValidator.isValid(teamCapacitySumByTeamIdSprintId.get(tsv.getTeamId() + "_" + originSprintId))) {
                                        tsv.setVelocity((Double)teamCapacitySumByTeamIdSprintId.get(tsv.getTeamId() + "_" + originSprintId));
                                    }
                                }
                                if (!PropertyValidator.isValid((Object)tsv.getVelocity())) {
                                    tsv.setVelocity(Double.valueOf(0.0));
                                }
                                tsv.setSessionBoardId(newCopiedSessionBoard.getId());
                                if (PropertyValidator.isValid(newContainersIdByOldOriginId.get(tsv.getSprintId()))) {
                                    tsv.setSprintId((String)newContainersIdByOldOriginId.get(tsv.getSprintId()));
                                } else {
                                    if (!PropertyValidator.isValid(newContainersIdByOldId.get(tsv.getSprintId()))) continue;
                                    tsv.setSprintId((String)newContainersIdByOldId.get(tsv.getSprintId()));
                                }
                                tsv.setCommitedLoad(Double.valueOf(0.0));
                                tsv.setLastBaseLineAuditLogId(null);
                                tsv.setLastSpillOverAuditLogId(null);
                                tsv.setLastBaseLineDate(null);
                                tsv.setLastSpillOverDate(null);
                                newBoardTeamSprintVelocityList.add(tsv);
                            }
                            newBoardTeamSprintVelocityList = this.teamSprintVelocityRepository.save(newBoardTeamSprintVelocityList);
                        }
                    }
                    if (programRoles.booleanValue()) {
                        List programRoleList = this.piProgramRoleRepository.findByPiJourneyId(oldPiJourney.getId());
                        ArrayList<PiProgramRole> newProgramRoleList = new ArrayList<PiProgramRole>();
                        newPiTeamCapacityList = programRoleList.iterator();
                        while (newPiTeamCapacityList.hasNext()) {
                            PiProgramRole oldRole;
                            PiProgramRole newRole = oldRole = (PiProgramRole)newPiTeamCapacityList.next();
                            newRole.setId(null);
                            newRole.setPiJourneyId(newPiJourney.getId());
                            newProgramRoleList.add(newRole);
                        }
                        this.piProgramRoleRepository.save(newProgramRoleList);
                    }
                    if (planningSos.booleanValue()) {
                        List piSosList = this.piSosRepository.findBySessionId(sessionId);
                        ArrayList<PiSos> newPiSosList = new ArrayList<PiSos>();
                        for (PiSos piSos : piSosList) {
                            boolean nullsOnly;
                            List<Question> questionList = new ArrayList();
                            if (piSos.getQuestions() != null && !(nullsOnly = piSos.getQuestions().stream().allMatch(x -> x == null))) {
                                for (Question question : piSos.getQuestions()) {
                                    question.setId(null);
                                    questionList.add(question);
                                }
                            }
                            questionList = this.questionRepository.save(questionList);
                            ArrayList<Answer> answerList = new ArrayList<Answer>();
                            for (Question question : questionList) {
                                for (Team team : newCopiedSessionBoard.getTeams()) {
                                    Answer emptyAnswerForQuestion = new Answer();
                                    emptyAnswerForQuestion.setTeam(team);
                                    emptyAnswerForQuestion.setQuestion(question);
                                    answerList.add(emptyAnswerForQuestion);
                                }
                            }
                            this.answerRepository.save(answerList);
                            piSos.setQuestions(questionList);
                            piSos.setId(null);
                            piSos.setRoomLink(null);
                            piSos.setRoomTitle(null);
                            piSos.setSessionId(newSessionId);
                            piSos.setPiJourneyId(newPiJourney.getId());
                            piSos.setStartDate(null);
                            piSos.setEndDate(null);
                            piSos.setStartTime(null);
                            piSos.setEndTime(null);
                            newPiSosList.add(piSos);
                        }
                        this.piSosRepository.save(newPiSosList);
                    }
                }
            }
            try {
                HashMap sourceBoardFilters = this.tfSservice.fetchBoardFilters(oldSessionId, UserContextUtil.getUserContext().getLoggedInUser().getId());
                HashMap sourceDepFilters = this.tfSservice.fetchDependencyFilters(oldSessionId, UserContextUtil.getUserContext().getLoggedInUser().getId());
                ArrayList allFiltersToBecopied = new ArrayList();
                if (PropertyValidator.isValid((Object)sourceBoardFilters)) {
                    if (PropertyValidator.isValid((Collection)((Collection)sourceBoardFilters.get("quickFilter")))) {
                        allFiltersToBecopied.addAll((Collection)sourceBoardFilters.get("quickFilter"));
                    }
                    if (PropertyValidator.isValid((Collection)((Collection)sourceBoardFilters.get("myFilter")))) {
                        allFiltersToBecopied.addAll((Collection)sourceBoardFilters.get("myFilter"));
                    }
                }
                if (PropertyValidator.isValid((Object)sourceDepFilters)) {
                    if (PropertyValidator.isValid((Collection)((Collection)sourceDepFilters.get("quickFilter")))) {
                        allFiltersToBecopied.addAll((Collection)sourceDepFilters.get("quickFilter"));
                    }
                    if (PropertyValidator.isValid((Collection)((Collection)sourceDepFilters.get("myFilter")))) {
                        allFiltersToBecopied.addAll((Collection)sourceDepFilters.get("myFilter"));
                    }
                }
                for (BoardFilter sourceFilter : allFiltersToBecopied) {
                    BoardFilter newFilter = new BoardFilter();
                    newFilter.setFilterName(sourceFilter.getFilterName());
                    newFilter.setFilters(sourceFilter.getFilters());
                    newFilter.setDescription(sourceFilter.getDescription());
                    newFilter.setUserId(sourceFilter.getUserId());
                    newFilter.setUser(sourceFilter.getUser());
                    newFilter.setSessionId(newSessionId);
                    newFilter.setCreatedOn(new Date());
                    newFilter.setCreatedBy(UserContextUtil.getUserContext().getLoggedInUser().getUserName());
                    newFilter.setType(sourceFilter.getType());
                    this.tfSservice.createBoardFilter(newFilter);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error copying board filters: " + StringUtils.getTraceString((Throwable)e));
            }
            responseJson.put("boardId", newCopiedSessionBoard.getId());
            responseJson.put("title", newCopiedSessionBoard.getSession().getTitle());
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            AlmError almerr = new AlmError();
            almerr.setAlmErrorMessage(StringUtils.getTraceString((Throwable)e));
            almerr.setHttpErrorCode(Integer.valueOf(400));
            return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/duplicate"})
    public SessionBoard duplicateBoard(@RequestBody SessionBoard session) {
        SessionBoard savedSessionBoard = null;
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        savedSessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)session.getId()));
        List newTeams = savedSessionBoard.getTeams();
        List newContainers = savedSessionBoard.getContainers();
        ArrayList<ItemLink> newItemLinks = new ArrayList<ItemLink>();
        List<Item> newItems = new ArrayList();
        ArrayList<TeamContainer> newTeamContainers = new ArrayList<TeamContainer>();
        sessionBoards.add(savedSessionBoard);
        List items = this.itemRepository.findBySessionBoardsIn(sessionBoards);
        for (Object item : items) {
            List itemLinks;
            TeamContainer tc22;
            List list = item.getTeamContainers();
            if (PropertyValidator.isValid((Collection)list)) {
                for (TeamContainer tc22 : list) {
                    Optional<TeamContainer> duplicateTc = newTeamContainers.stream().filter(x -> tc22.getId().equals(x.getId())).findFirst();
                    if (duplicateTc.isPresent()) continue;
                    newTeamContainers.add(tc22);
                }
            }
            if (!PropertyValidator.isValid((Collection)(itemLinks = item.getItemLinks()))) continue;
            tc22 = itemLinks.iterator();
            while (tc22.hasNext()) {
                ItemLink itemLink = (ItemLink)tc22.next();
                newItemLinks.add(itemLink);
            }
        }
        newTeams.forEach(f -> f.setDuplicateOfId(f.getId()));
        newTeams.forEach(f -> f.setId(null));
        newContainers.forEach(f -> f.setDuplicateOfId(f.getId()));
        newContainers.forEach(f -> f.setId(null));
        newTeams = this.teamRepository.save((Iterable)newTeams);
        newContainers = this.containerRepository.save((Iterable)newContainers);
        List<TeamContainer> modTeamContainers = new ArrayList();
        for (TeamContainer teamContainer : newTeamContainers) {
            Optional<Team> team = newTeams.stream().filter(x -> teamContainer.getTeam().getId().equals(x.getDuplicateOfId())).findFirst();
            Optional<Container> container = newContainers.stream().filter(x -> teamContainer.getContainer().getId().equals(x.getDuplicateOfId())).findFirst();
            teamContainer.setTeam(team.get());
            teamContainer.setContainer(container.get());
            modTeamContainers.add(teamContainer);
        }
        modTeamContainers.forEach(f -> f.setDuplicateOfId(f.getId()));
        modTeamContainers.forEach(f -> f.setId(null));
        modTeamContainers = this.teamContainerRepository.save(modTeamContainers);
        ArrayList<ItemLink> newItemLinksNotNullList = new ArrayList<ItemLink>();
        for (ItemLink itemLink : newItemLinks) {
            if (itemLink == null) continue;
            Optional<TeamContainer> srcTc = modTeamContainers.stream().filter(x -> itemLink.getSourceTeamContainerId() != null && itemLink.getSourceTeamContainerId().equals(x.getDuplicateOfId())).findFirst();
            Optional<TeamContainer> targetTc = modTeamContainers.stream().filter(x -> itemLink.getTargetTeamContainerId() != null && itemLink.getTargetTeamContainerId().equals(x.getDuplicateOfId())).findFirst();
            if (srcTc.isPresent()) {
                itemLink.setSourceTeamContainerId(srcTc.get().getId());
            }
            if (targetTc.isPresent()) {
                itemLink.setTargetTeamContainerId(targetTc.get().getId());
            }
            itemLink.setOriginItemId(itemLink.getOriginItemId() == null ? itemLink.getId() : itemLink.getOriginItemId());
            itemLink.setDuplicateOfId(itemLink.getId());
            itemLink.setId(null);
            newItemLinksNotNullList.add(itemLink);
        }
        this.itemLinkRepository.save(newItemLinksNotNullList);
        SessionBoard sessionBoard = new SessionBoard();
        sessionBoard.setStatus(SessionBoard.OPEN);
        sessionBoard.setContainers(newContainers);
        sessionBoard.setTeams(newTeams);
        SessionBoard sessionBoard2 = (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard);
        ArrayList<SessionBoard> newSessionBoardList = new ArrayList<SessionBoard>();
        newSessionBoardList.add(sessionBoard2);
        for (Item item : items) {
            if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                for (TeamContainer tc : item.getTeamContainers()) {
                    Optional<TeamContainer> teamContainer = modTeamContainers.stream().filter(x -> tc.getId().equals(x.getDuplicateOfId())).findFirst();
                    if (!teamContainer.isPresent()) continue;
                    tc.setId(teamContainer.get().getId());
                }
            }
            item.setSessionBoards(newSessionBoardList);
            newItems.add(item);
        }
        for (int i = 0; i < newItems.size(); ++i) {
            Item item;
            item = (Item)newItems.get(i);
            item.setDuplicateOfId(item.getId());
            if (item.getOriginItemId() != null) {
                item.setOriginItemId(item.getOriginItemId());
            } else {
                item.setOriginItemId(item.getId());
            }
            item.setId(null);
        }
        newItems = this.itemRepository.save(newItems);
        ArrayList<Item> itemsWithParent = new ArrayList<Item>();
        for (Item item : newItems) {
            Optional<Item> parentItem;
            if (!item.getType().equals(Item.USER_STORY) || !(parentItem = newItems.stream().filter(x -> item.getParent().getId().equals(x.getDuplicateOfId())).findFirst()).isPresent()) continue;
            item.setParent(parentItem.get());
            itemsWithParent.add(item);
        }
        this.itemRepository.save(itemsWithParent);
        return sessionBoard2;
    }

    @RequestMapping(value={"/board/dataForDependencies/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getBoardDataForDependencies(@PathVariable(value="id") String id) {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        List logs = this.itemLogRepository.findBySessionBoardAndItemTypeOrderByEventTimeAsc(null, "ItemLink");
        responseJson.put("linkLogs", logs);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/board/scopeChangeTrackerData/{currentId}/{compId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getScopChangeTrackerData(@PathVariable(value="currentId") String currentId, @PathVariable(value="compId") String compId) {
        HashMap<String, Serializable> responseJson = new HashMap<String, Serializable>();
        SessionBoard currentSessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)currentId));
        List otherSessionBoards = this.sessionBoardRepository.findBySessionIdOrderByCreatedOnAsc(currentSessionBoard.getSession().getId());
        ArrayList previousSessionBoards = new ArrayList();
        SessionBoard comparisonBoard = null;
        for (int i = 0; i < otherSessionBoards.size() && !currentSessionBoard.getId().equals(((SessionBoard)otherSessionBoards.get(i)).getId()); ++i) {
            if (compId.equals(((SessionBoard)otherSessionBoards.get(i)).getId())) {
                comparisonBoard = (SessionBoard)otherSessionBoards.get(i);
            }
            previousSessionBoards.add(otherSessionBoards.get(i));
        }
        responseJson.put("otherSessionBoards", previousSessionBoards);
        if (comparisonBoard == null && previousSessionBoards.size() > 0) {
            comparisonBoard = (SessionBoard)previousSessionBoards.get(previousSessionBoards.size() - 1);
        }
        if (comparisonBoard != null) {
            Object countMap;
            responseJson.put("comparisonSessionBoards", (Serializable)comparisonBoard);
            ArrayList<SessionBoard> SBs = new ArrayList<SessionBoard>();
            SBs.add(currentSessionBoard);
            List currentItems = this.itemRepository.findBySessionBoardsIn(SBs);
            SBs.clear();
            SBs.add(comparisonBoard);
            List compItems = this.itemRepository.findBySessionBoardsIn(SBs);
            int currentFeatureCount = 0;
            int currentStoryCount = 0;
            int comparisonFeatureCount = 0;
            int comparisonStoryCount = 0;
            int currentDepCount = 0;
            int currentDepResCount = 0;
            int comparisonDepCount = 0;
            int comparisonDepResCount = 0;
            HashMap currentFeatureCountByTeam = new HashMap();
            HashMap currentStoryCountByTeam = new HashMap();
            HashMap comparisonFeatureCountByTeam = new HashMap();
            HashMap comparisonStoryCountByTeam = new HashMap();
            HashMap currentStoryPointsByTeam = new HashMap();
            HashMap comparisonStoryPointsByTeam = new HashMap();
            for (Item item : currentItems) {
                Object link2;
                if (PropertyValidator.isValid((Collection)item.getItemLinks())) {
                    currentDepCount += item.getItemLinks().size();
                    for (Object link2 : item.getItemLinks()) {
                        if (!link2.getStatus().equals("Resolved")) continue;
                        ++currentDepResCount;
                    }
                }
                if (item.getType().equals(Item.Type.Feature.toString())) {
                    ++currentFeatureCount;
                    countMap = currentFeatureCountByTeam;
                } else {
                    ++currentStoryCount;
                    countMap = currentStoryCountByTeam;
                }
                if (!PropertyValidator.isValid((Collection)item.getTeamContainers())) continue;
                link2 = item.getTeamContainers().iterator();
                while (link2.hasNext()) {
                    TeamContainer tc = (TeamContainer)link2.next();
                    this.addIntInMapForScopeChangeTracker((HashMap)countMap, tc.getTeam().getId(), 1);
                    if (!PropertyValidator.isValid((Object)item.getStoryPoints())) continue;
                    this.addDoubleInMapForScopeChangeTracker(currentStoryPointsByTeam, tc.getTeam().getId(), item.getStoryPoints().doubleValue());
                }
            }
            for (Item item : compItems) {
                if (PropertyValidator.isValid((Collection)item.getItemLinks())) {
                    comparisonDepCount += item.getItemLinks().size();
                    for (Object link2 : item.getItemLinks()) {
                        if (!link2.getStatus().equals("Resolved")) continue;
                        ++comparisonDepResCount;
                    }
                }
                if (item.getType().equals(Item.Type.Feature.toString())) {
                    ++comparisonFeatureCount;
                    countMap = comparisonFeatureCountByTeam;
                } else {
                    ++comparisonStoryCount;
                    countMap = comparisonStoryCountByTeam;
                }
                if (!PropertyValidator.isValid((Collection)item.getTeamContainers())) continue;
                for (TeamContainer tc : item.getTeamContainers()) {
                    this.addIntInMapForScopeChangeTracker((HashMap)countMap, tc.getTeam().getId(), 1);
                    if (!PropertyValidator.isValid((Object)item.getStoryPoints())) continue;
                    this.addDoubleInMapForScopeChangeTracker(comparisonStoryPointsByTeam, tc.getTeam().getId(), item.getStoryPoints().doubleValue());
                }
            }
            responseJson.put("currentDepCount", Integer.valueOf(currentDepCount));
            responseJson.put("currentDepResCount", Integer.valueOf(currentDepResCount));
            responseJson.put("comparisonDepCount", Integer.valueOf(comparisonDepCount));
            responseJson.put("comparisonDepResCount", Integer.valueOf(comparisonDepResCount));
            responseJson.put("currentStoryCount", Integer.valueOf(currentStoryCount));
            responseJson.put("currentFeatureCount", Integer.valueOf(currentFeatureCount));
            responseJson.put("comparisonStoryCount", Integer.valueOf(comparisonStoryCount));
            responseJson.put("comparisonFeatureCount", Integer.valueOf(comparisonFeatureCount));
            responseJson.put("currentStoryCountByTeam", currentStoryCountByTeam);
            responseJson.put("currentFeatureCountByTeam", currentFeatureCountByTeam);
            responseJson.put("comparisonStoryCountByTeam", comparisonStoryCountByTeam);
            responseJson.put("comparisonFeatureCountByTeam", comparisonFeatureCountByTeam);
            responseJson.put("currentStoryPointsByTeam", currentStoryPointsByTeam);
            responseJson.put("comparisonStoryPointsByTeam", comparisonStoryPointsByTeam);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private void addIntInMapForScopeChangeTracker(HashMap<String, Object> map, String key, int value) {
        Integer count = 1;
        if (map.get(key) != null) {
            count = (Integer)map.get(key);
            count = count + value;
        }
        map.put(key, count);
    }

    private void addDoubleInMapForScopeChangeTracker(HashMap<String, Object> map, String key, double value) {
        Double count = 1.0;
        if (map.get(key) != null) {
            count = (Double)map.get(key);
            count = count + value;
        }
        map.put(key, count);
    }

    @RequestMapping(value={"/mapper/{id}", "/{id}/sync-mapper"}, method={RequestMethod.GET})
    public List<ItemSyncMapper> getItemSyncMapper(@PathVariable(value="id") String id) {
        SessionBoard session = new SessionBoard(id);
        List<ItemSyncMapper> syncMapper = new ArrayList();
        try {
            syncMapper = this.itemSyncMapperRepository.findBySessionBoard(session);
            for (ItemSyncMapper itemSyncMapper : syncMapper) {
                itemSyncMapper.setSessionBoard(session);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return syncMapper;
    }

    @RequestMapping(value={"/dependencies/download/excel"}, method={RequestMethod.POST})
    public ResponseEntity<ByteArrayResource> downloadDeps(HttpServletRequest request) {
        try {
            String extension = "xls";
            if (!PropertyValidator.isValid((Object)request)) {
                return null;
            }
            String reqBody = request.getParameter("dependencyData");
            reqBody = URLDecoder.decode(reqBody, "UTF-8");
            JSONObject reqBodyObj = new JSONObject(reqBody);
            int exportType = 1;
            String viewType = reqBodyObj.getString("viewType");
            if (PropertyValidator.isValid((Object)reqBodyObj.getString("exportType")) && "csv".equalsIgnoreCase(reqBodyObj.getString("exportType"))) {
                extension = "csv";
                exportType = 0;
            }
            String filePath = this.exportService.exportDepsData(reqBodyObj.getJSONArray("dependencyData"), exportType, viewType);
            String cleanedSessionTitle = AlmUtils.cleanText((String)reqBodyObj.getString("boardName"));
            File responsefile = new File(filePath);
            Path path = Paths.get(filePath, new String[0]);
            ByteArrayResource resource = new ByteArrayResource(Files.readAllBytes(path));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=\"" + cleanedSessionTitle + "_dependencies." + extension + "\"");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength(responsefile.length()).contentType(MediaType.parseMediaType((String)"application/octet-stream")).body((Object)resource);
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return null;
    }

    @RequestMapping(value={"/resync/filterdata"})
    public ResponseEntity<Object> resyncFilterData(@RequestBody String param) {
        Gson gson = new Gson();
        34 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap paramMap = (HashMap)gson.fromJson(param, T.getType());
        String sessionBoardId = (String)paramMap.get("sessionBoardId");
        String syncId = (String)paramMap.get("syncId");
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
        AlmConfigurations almConfig = (AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0);
        if (PropertyValidator.isValid((Object)almConfig)) {
            this.almSyncService.deleteJiraIssues(sessionBoard.getId());
            ArrayList data = new ArrayList();
            HashSet hashSet = new HashSet();
        }
        JSONObject pushJson = new JSONObject();
        try {
            pushJson.put("type", (Object)"Board");
            pushJson.put("id", (Object)sessionBoard.getId());
            pushJson.put("push", (Object)"Self");
            pushJson.put("metaMap", (Object)("{\"event\":\"Save\", \"boardId\":\"" + sessionBoard.getId() + "\", \"syncId\":\"" + syncId + "\"}"));
            PushSender.sendMsg((String)pushJson.toString());
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity((Object)sessionBoard, HttpStatus.OK);
    }

    @RequestMapping(value={"/ipsprint/{boardId}/{sprintId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> markIPSprint(@PathVariable(value="boardId") String boardId, @PathVariable(value="sprintId") String sprintId) {
        HashMap responseJson = new HashMap();
        if (PropertyValidator.isValid((Object)boardId)) {
            Container container2;
            SessionBoard board = this.customRepository.getSessionBoardbyId(boardId);
            board.getContainers().forEach(container -> container.setIsIPSprint(Boolean.valueOf(false)));
            this.containerRepository.save((Iterable)board.getContainers());
            if (PropertyValidator.isValid((Object)sprintId) && !sprintId.equals("undefined") && PropertyValidator.isValid((Object)(container2 = (Container)board.getContainers().stream().filter(sprint -> sprint.getId().equals(sprintId)).findAny().orElse(null)))) {
                container2.setIsIPSprint(Boolean.valueOf(true));
                this.containerRepository.save((Object)container2);
            }
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/board/{boardId}/errors"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getSessionErrors(@PathVariable(value="boardId") String boardId) {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        try {
            responseJson.put("almErrors", this.almSyncService.retrieveAlmErrors(boardId));
            responseJson.put("almInfo", this.almInfoRepository.findBySessionBoardId(boardId));
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (ViztrendJiraException vJe) {
            return new ResponseEntity((Object)vJe.getAlmError(), HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/resync/checkPreCondition"})
    public ResponseEntity<Object> checkResyncPreConditions(@RequestBody String param) {
        Gson gson = new Gson();
        35 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap paramMap = (HashMap)gson.fromJson(param, T.getType());
        String sessionBoardId = (String)paramMap.get("sessionBoardId");
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
        AlmConfigurations almConfig = (AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0);
        Map result = new HashMap();
        if (PropertyValidator.isValid((Object)almConfig)) {
            result = this.almSyncService.checkWhichFiltersWereUpdated(almConfig);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/jira-alm-fields/{almAccountId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getAlmFiedlds(@PathVariable(value="almAccountId") String almAccountId) {
        return new ResponseEntity((Object)this.jiraFieldRepository.findByAlmAccountId(almAccountId), HttpStatus.OK);
    }

    @RequestMapping(value={"/errors/item/{param}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getItemErrors(@PathVariable(value="param") String param, @RequestBody AlmAccount alm) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        HashMap<String, String> fields = new HashMap<String, String>();
        try {
            fields.put(this.jiraFieldRepository.findBySchemaCustomIgnoreCaseAndAlmAccountId("com.pyxis.greenhopper.jira:gh-sprint", alm.getId()).getJiraId(), "Sprint");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            fields.put(this.jiraFieldRepository.findByNameIgnoreCaseAndAlmAccountId("Story Points", alm.getId()).getJiraId(), "Story Points");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            fields.put(this.jiraFieldRepository.findByNameIgnoreCaseAndAlmAccountId(alm.getJiraEpicNameLabel(), alm.getId()).getJiraId(), alm.getJiraEpicNameLabel());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Item item = new Item(param);
        responseJson.put("almErrors", this.almErrorRepository.findByItem(item));
        responseJson.put("almInfo", this.almInfoRepository.findByItem(item));
        responseJson.put("customKeyNames", fields);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/fix/item/{param}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fixItemErrors(@PathVariable(value="param") String param, @RequestBody SessionBoard sessionBoard) {
        HashMap responseJson = new HashMap();
        responseJson.put("almErrors", this.almErrorRepository.findByItemId(param));
        Item item1 = (Item)this.itemRepository.findOne((Serializable)((Object)param));
        item1.setErrorInAlmSync(Boolean.FALSE);
        this.almErrorRepository.deleteByItemId(param);
        this.item = (Item)this.itemRepository.save((Object)item1);
        if (PropertyValidator.isValid((Object)item1.getJiraId())) {
            this.savedItem = item1;
        }
        sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoard.getId()));
        this.saveItemInJira(sessionBoard, item1.getJiraId() != null, null);
        responseJson.put("item", item1);
        PushSender.sendMsg((String)AlmErrorUtils.buildAlmPushJson((Item)this.item, (String)sessionBoard.getId(), (String)"AlmErrorFix", null, (Boolean)false, (Boolean)false));
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/saveItemScore"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveItemScore(@RequestBody Item inputItem) {
        try {
            String sessionBoardId = null;
            HashMap<String, Item> responseJson = new HashMap<String, Item>();
            sessionBoardId = ((SessionBoard)inputItem.getSessionBoards().get(0)).getId();
            SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            this.savedItem = (Item)this.itemRepository.findOne((Serializable)((Object)inputItem.getId()));
            Item itemToUpdate = this.itemRepository.findById(inputItem.getId());
            itemToUpdate.setJiraFieldMap(inputItem.getJiraFieldMap());
            this.item = this.savedItem;
            if (sessionBoard.getSession().getwsjfAlmEnabled().booleanValue()) {
                this.planService.editFeatureInJira(this.savedItem, itemToUpdate, sessionBoard, true, loggedInUser);
            }
            itemToUpdate.setAlmScoreField(itemToUpdate.getScore());
            itemToUpdate = (Item)this.itemRepository.save((Object)itemToUpdate);
            responseJson.put("item", itemToUpdate);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
    }

    private User setSyncDefaultData(User user, Boolean syncFlag) {
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        for (int i = 0; i < user.getUserCompanies().size(); ++i) {
            if (!((UserCompany)user.getUserCompanies().get(i)).getCompany().getId().equals(cid)) continue;
            ((UserCompany)user.getUserCompanies().get(i)).setSyncDefaultData(syncFlag);
        }
        return user;
    }

    private Boolean getUserSyncDefaultData(User user) {
        Boolean syncFlag = false;
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        for (int i = 0; i < user.getUserCompanies().size(); ++i) {
            if (!((UserCompany)user.getUserCompanies().get(i)).getCompany().getId().equals(cid)) continue;
            syncFlag = ((UserCompany)user.getUserCompanies().get(i)).getSyncDefaultData();
        }
        return syncFlag;
    }

    private Boolean isFeatureConfigMetaSynced(String featureCode) {
        List featureConfigMetaList = this.companyFeatureMetaConfigRepository.findAll();
        if (!PropertyValidator.isValid((Collection)featureConfigMetaList)) {
            return false;
        }
        if (PropertyValidator.isValid((Collection)featureConfigMetaList)) {
            CompanyFeatureMetaConfig companyFeatureMetaConfig = (CompanyFeatureMetaConfig)featureConfigMetaList.get(0);
            for (Map featureMetaMap : companyFeatureMetaConfig.getFeatureConfigMeta()) {
                if (featureMetaMap != null && !((Boolean)featureMetaMap.get(featureCode)).equals(false)) continue;
                return false;
            }
        }
        return true;
    }

    private void setFeatureConfigMetaSynced(String featureCode) {
        List featureConfigMetaList = this.companyFeatureMetaConfigRepository.findAll();
        CompanyFeatureMetaConfig companyFeatureMetaConfig = null;
        if (!PropertyValidator.isValid((Collection)featureConfigMetaList)) {
            companyFeatureMetaConfig = new CompanyFeatureMetaConfig();
            HashMap<String, Boolean> featureMetaMap = new HashMap<String, Boolean>();
            featureMetaMap.put(featureCode, true);
            ArrayList<HashMap<String, Boolean>> featureMapList = new ArrayList<HashMap<String, Boolean>>();
            featureMapList.add(featureMetaMap);
            companyFeatureMetaConfig.setFeatureConfigMeta(featureMapList);
        } else {
            companyFeatureMetaConfig = (CompanyFeatureMetaConfig)featureConfigMetaList.get(0);
            for (Map featureMetaMap : companyFeatureMetaConfig.getFeatureConfigMeta()) {
                featureMetaMap.put(featureCode, true);
            }
        }
        this.companyFeatureMetaConfigRepository.save((Object)companyFeatureMetaConfig);
    }

    @RequestMapping(value={"/data/cleanup"})
    public void cleanup(@RequestBody String params) {
        if (PropertyValidator.isValid((Object)params)) {
            Gson gson = new Gson();
            36 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap paramMap = (HashMap)gson.fromJson(params, T.getType());
            String tables = (String)paramMap.get("collections");
            String init = (String)paramMap.get("init");
            String code = (String)paramMap.get("code");
            if (PropertyValidator.isValid((Object)code) && code.equals("mongo12#")) {
                String[] tablesArray;
                for (String collection : tablesArray = tables.split(",")) {
                    this.customRepository.getMongoTemplate().dropCollection(collection);
                }
            }
        }
    }

    @RequestMapping(value={"/data/init"})
    public void initData(@RequestBody String code) {
        if (PropertyValidator.isValid((Object)code) && code.equals("shakeelsbzindabad")) {
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            user = (User)this.userRepository.findOne((Serializable)((Object)user.getId()));
            this.createDefaultData(user, null);
        }
    }

    @RequestMapping(value={"/resync/feature"})
    @ResponseBody
    public ResponseEntity<Object> resyncFeature(@RequestBody String payload) {
        Thread t = new Thread(() -> {
            HashMap<String, String> exp;
            String err;
            Integer counter = 0;
            String syncId = null;
            String sessionId = null;
            String syncItems = null;
            String sessionBoardId = null;
            String almConfigId = null;
            ObjectMapper mapper = new ObjectMapper();
            List itemIdsToSync = null;
            Set filterIdsToSync = null;
            Boolean isReadOnly = false;
            String linkMappingsByFilters = null;
            String issueTypesByFilters = null;
            String auditLog = null;
            String eventType = null;
            Boolean removeEmptyCards = false;
            ResyncParamsVO resyncParams = null;
            AlmConfigurations almConfigurations = null;
            Map filterResult = new HashMap();
            Map syncFilters = new HashMap();
            Map lastSyncDate = new HashMap();
            Gson g = new Gson();
            boolean isLocked = false;
            try {
                37 T = new /* Unavailable Anonymous Inner Class!! */;
                HashMap reqbody = (HashMap)g.fromJson(payload, T.getType());
                resyncParams = new ResyncParamsVO((Map)reqbody.get("resyncParams"));
                syncId = (String)reqbody.get("syncId");
                sessionBoardId = (String)reqbody.get("sessionBoardId");
                almConfigId = (String)reqbody.get("almConfigId");
                syncItems = (String)reqbody.get("syncItems");
                sessionId = (String)reqbody.get("sessionId");
                syncFilters = (Map)reqbody.get("syncFilters");
                lastSyncDate = (Map)reqbody.get("lastSyncDate");
                isReadOnly = Boolean.parseBoolean("" + reqbody.get("isReadOnly"));
                linkMappingsByFilters = (String)reqbody.get("linkMappingsByFilters");
                issueTypesByFilters = (String)reqbody.get("issueTypesByFilters");
                auditLog = (String)reqbody.get("auditLog");
                eventType = (String)reqbody.get("eventType");
                if (PropertyValidator.isValid(reqbody.get("removeEmptyCards"))) {
                    removeEmptyCards = (Boolean)reqbody.get("removeEmptyCards");
                }
                if (Boolean.TRUE.equals(isReadOnly)) {
                    this.resynLogs(null, sessionBoardId, null);
                }
                if (PropertyValidator.isValid((Object)auditLog)) {
                    AuditLog auditLogObject = new AuditLog(sessionBoardId, eventType, auditLog);
                    this.auditLogRepository.save((Object)auditLogObject);
                }
                if (PropertyValidator.isValid((Object)syncItems)) {
                    itemIdsToSync = (List)mapper.readValue(syncItems, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, String.class));
                }
                if (PropertyValidator.isValid(syncFilters)) {
                    filterIdsToSync = syncFilters.keySet();
                }
                if (PropertyValidator.isValid((Object)almConfigId)) {
                    almConfigurations = (AlmConfigurations)this.almConfigurationsRepository.findOne((Serializable)((Object)almConfigId));
                }
            }
            catch (Exception e) {
                err = StringUtils.getTraceString((Throwable)e);
                LOGGER.error(err);
                exp = new HashMap<String, String>();
                exp.put("kendisError", err);
                KendisUtils.onResyncError((String)syncId, (String)"/resync/feature", (String)g.toJson(exp), sessionBoardId, (PushResponseRepository)this.pushResponseRepository);
            }
            try {
                if (!isReadOnly.booleanValue()) {
                    this.customRepositoryImpl.checkIfSessionLocked(sessionId, PropertyValidator.isValid(eventType) && eventType.indexOf("_ADD_DEL") > -1 ? "Add/Remove" : "Resync");
                }
                boolean bucketSync = false;
                if (resyncParams.bucketSync.booleanValue()) {
                    bucketSync = true;
                }
                resyncParams.bucketSync = false;
                boolean anySyncedDone = false;
                boolean validateFilter = true;
                boolean chunkedKeys = false;
                if (PropertyValidator.isValid(filterIdsToSync)) {
                    if (PropertyValidator.isValid(linkMappingsByFilters)) {
                        almConfigurations = this.saveLinkMappingOnResync(almConfigurations, linkMappingsByFilters, issueTypesByFilters);
                    }
                    if (resyncParams.isReferesh || resyncParams.isAutoSync || !resyncParams.isReferesh && !isReadOnly.booleanValue()) {
                        validateFilter = false;
                    }
                    for (String filterId : filterIdsToSync) {
                        try {
                            if (!PropertyValidator.isValid((Collection)almConfigurations.getFeatureFilter())) continue;
                            for (JiraFilter filter : almConfigurations.getFeatureFilter()) {
                                Object count;
                                boolean anyLastSync;
                                if (!filterId.equals(filter.getId())) continue;
                                boolean bl = anyLastSync = lastSyncDate != null && lastSyncDate.containsKey(filter.getId());
                                if (!validateFilter || anyLastSync) {
                                    if (syncFilters.get(filter.getId()) instanceof List) {
                                        filter.setIssueKeys((List)syncFilters.get(filter.getId()));
                                    } else if (filter.getId().equals(syncFilters.get(filter.getId()))) {
                                        if (!chunkedKeys) {
                                            syncFilters = this.customRepositoryImpl.findJiraItemsByFilter(sessionBoardId, filterIdsToSync, resyncParams.jiraIdsMap);
                                            chunkedKeys = true;
                                        }
                                        filter.setIssueKeys((List)syncFilters.get(filter.getId()));
                                    }
                                }
                                filterResult = this.almSyncService.retrieveDataAgainstJiraFilter2(filter, almConfigId, filter.getFeatureLinkMappings(), sessionBoardId, syncId, sessionId, null, true, isReadOnly, validateFilter, removeEmptyCards.booleanValue(), resyncParams);
                                if (!isReadOnly.booleanValue() && resyncParams.isReferesh || anyLastSync) {
                                    filter.setLastSyncDate(new Date());
                                    anySyncedDone = true;
                                }
                                if (!PropertyValidator.isValid(count = filterResult.get("count")) || !(count instanceof Integer)) continue;
                                counter = counter + (Integer)count;
                            }
                        }
                        catch (ViztrendJiraException vJe) {
                            KendisUtils.onResyncError((String)syncId, (String)"/resync/feature", (String)StringUtils.getTraceString((Throwable)vJe), (String)sessionBoardId, (PushResponseRepository)this.pushResponseRepository);
                        }
                        catch (Exception vJe) {
                            KendisUtils.onResyncError((String)syncId, (String)"/resync/feature", (String)StringUtils.getTraceString((Throwable)vJe), (String)sessionBoardId, (PushResponseRepository)this.pushResponseRepository);
                        }
                    }
                }
                if (anySyncedDone && !isReadOnly.booleanValue()) {
                    almConfigurations = (AlmConfigurations)this.almConfigurationsRepository.save((Object)almConfigurations);
                }
                if (PropertyValidator.isValid(itemIdsToSync)) {
                    try {
                        List itemsToSync = this.itemRepository.findByIdIn(itemIdsToSync);
                        if (PropertyValidator.isValid((Collection)itemsToSync)) {
                            HashMap<String, JiraFilter> featureChildLinkTypeMap = new HashMap<String, JiraFilter>();
                            HashMap jiraKeysGroupByUser = new HashMap();
                            HashMap itemsGroupByUser = new HashMap();
                            HashMap<String, User> usersMap = new HashMap<String, User>();
                            ArrayList<BacklogMappingLinks> featureChildMappingLinks = new ArrayList<BacklogMappingLinks>();
                            ArrayList<String> jiraKeys = new ArrayList<String>();
                            for (Item itemToSync : itemsToSync) {
                                if (PropertyValidator.isValid((Object)itemToSync.getJiraId()) && PropertyValidator.isValid((Object)itemToSync.getJiraKey())) {
                                    jiraKeys.add(itemToSync.getJiraKey());
                                    if (PropertyValidator.isValid((Object)itemToSync.getFetchedBy())) {
                                        if (!jiraKeysGroupByUser.containsKey(itemToSync.getFetchedBy().getId())) {
                                            jiraKeysGroupByUser.put(itemToSync.getFetchedBy().getId(), new ArrayList());
                                            itemsGroupByUser.put(itemToSync.getFetchedBy().getId(), new ArrayList());
                                            usersMap.put(itemToSync.getFetchedBy().getId(), itemToSync.getFetchedBy());
                                        }
                                        ((List)jiraKeysGroupByUser.get(itemToSync.getFetchedBy().getId())).add(itemToSync.getJiraKey());
                                        ((List)itemsGroupByUser.get(itemToSync.getFetchedBy().getId())).add(itemToSync);
                                    } else {
                                        if (!jiraKeysGroupByUser.containsKey(null)) {
                                            jiraKeysGroupByUser.put(null, new ArrayList());
                                            itemsGroupByUser.put(null, new ArrayList());
                                            usersMap.put(null, null);
                                        }
                                        ((List)jiraKeysGroupByUser.get(null)).add(itemToSync.getJiraKey());
                                        ((List)itemsGroupByUser.get(null)).add(itemToSync);
                                    }
                                }
                                if (!PropertyValidator.isValid((Object)itemToSync.getJiraId())) continue;
                                if (!PropertyValidator.isValid((Object)itemToSync.getJiraFilter()) || PropertyValidator.isValid((Collection)itemsToSync) && itemToSync.getJiraFilter().contains("AddExisting")) {
                                    BacklogMappingLinks bmlink = new BacklogMappingLinks();
                                    bmlink.setLinkTypes(itemToSync.getLinkTypes());
                                    bmlink.setProjectKey(itemToSync.getJiraProjectKey());
                                    featureChildMappingLinks = new ArrayList();
                                    featureChildMappingLinks.add(bmlink);
                                    JiraFilter jfilter2 = new JiraFilter();
                                    jfilter2.setId(itemToSync.getJiraFilter());
                                    jfilter2.setFeatureLinkMappings(featureChildMappingLinks);
                                    featureChildLinkTypeMap.put(itemToSync.getJiraId(), jfilter2);
                                    continue;
                                }
                                String savedItemFilter = itemToSync.getJiraFilter();
                                JiraFilter jiraFilter = almConfigurations.getFeatureFilter().stream().filter(jfilter -> jfilter.getId().equals(savedItemFilter)).findAny().orElse(null);
                                if (!PropertyValidator.isValid((Object)jiraFilter) || !PropertyValidator.isValid((Object)jiraFilter.getId())) continue;
                                featureChildLinkTypeMap.put(itemToSync.getJiraId(), jiraFilter);
                            }
                            for (String userId : jiraKeysGroupByUser.keySet()) {
                                List jiraKeys1 = (List)jiraKeysGroupByUser.get(userId);
                                resyncParams.items = (List)itemsGroupByUser.get(userId);
                                User filterUser = (User)usersMap.get(userId);
                                String jiraKeysStr = String.join((CharSequence)",", jiraKeys1);
                                if (PropertyValidator.isValid((Object)jiraKeysStr)) {
                                    String jql = " key IN (" + jiraKeysStr + ") ";
                                    JiraFilter filter = new JiraFilter();
                                    filter.setIndividualSync(true);
                                    filter.setFilterFetchedBy(filterUser);
                                    filter.setJql(jql);
                                    filterResult = this.almSyncService.retrieveDataAgainstJiraFilter2(filter, almConfigurations.getId(), null, ((SessionBoard)((Item)itemsToSync.get(0)).getSessionBoards().get(0)).getId(), syncId, ((SessionBoard)((Item)itemsToSync.get(0)).getSessionBoards().get(0)).getSession().getId(), featureChildLinkTypeMap, true, isReadOnly, false, removeEmptyCards.booleanValue(), resyncParams);
                                    continue;
                                }
                                LOGGER.error("Invalid jiraKeysStr for cell sync.");
                            }
                        }
                    }
                    catch (ViztrendJiraException vJe) {
                        KendisUtils.onResyncError((String)syncId, (String)"/resync/feature", (String)StringUtils.getTraceString((Throwable)vJe), (String)sessionBoardId, (PushResponseRepository)this.pushResponseRepository);
                    }
                }
                if (bucketSync) {
                    try {
                        resyncParams.bucketSync = true;
                        JiraFilter filter = new JiraFilter("bucket");
                        filterResult = this.almSyncService.retrieveDataAgainstJiraFilter2(filter, almConfigId, null, sessionBoardId, syncId, sessionId, null, true, isReadOnly, false, removeEmptyCards.booleanValue(), resyncParams);
                    }
                    catch (ViztrendJiraException vJe) {
                        KendisUtils.onResyncError((String)syncId, (String)"/resync/feature", (String)StringUtils.getTraceString((Throwable)vJe), (String)sessionBoardId, (PushResponseRepository)this.pushResponseRepository);
                    }
                }
            }
            catch (ViztrendJiraException vJe) {
                if (HttpStatus.LOCKED.toString().equals(String.valueOf(vJe.getCode()))) {
                    isLocked = true;
                    KendisUtils.onResyncError((String)syncId, (String)"/resync/feature", (String)g.toJson((Object)vJe), (String)sessionBoardId, (PushResponseRepository)this.pushResponseRepository);
                } else {
                    KendisUtils.onResyncError((String)syncId, (String)"/resync/feature", (String)StringUtils.getTraceString((Throwable)vJe), (String)sessionBoardId, (PushResponseRepository)this.pushResponseRepository);
                }
            }
            catch (Exception e) {
                err = StringUtils.getTraceString((Throwable)e);
                LOGGER.error(err);
                exp = new HashMap();
                exp.put("kendisError", err);
                KendisUtils.onResyncError((String)syncId, (String)"/resync/feature", (String)g.toJson(exp), (String)sessionBoardId, (PushResponseRepository)this.pushResponseRepository);
            }
            if (!isReadOnly.booleanValue()) {
                int diff;
                SessionBoard board;
                this.customRepositoryImpl.removeSessionLock(sessionId);
                if (resyncParams.isNotification && (board = this.sessionBoardRepository.findById(sessionBoardId)).getNoticationCounter() != null && board.getNoticationCounter() > 0 && (diff = board.getNoticationCounter() - counter) > -1) {
                    this.customRepositoryImpl.updateNoticationCount(sessionBoardId, Integer.valueOf(diff));
                }
            }
            if (!isLocked) {
                KendisUtils.onResyncComplete((String)syncId, (String)"/resync/feature", (String)payload, (Boolean)isReadOnly, (AlmAccount)((AlmAccount)filterResult.get("almAccount")), (String)sessionBoardId, (PushResponseRepository)this.pushResponseRepository);
            }
        });
        t.start();
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/logdata/{action}/{sessionBoardId}"})
    @ResponseBody
    public ResponseEntity<Object> resynLogs(@PathVariable String action, @PathVariable String sessionBoardId, @RequestBody HashMap<String, String> requestBody) {
        try {
            if (action == null || "remove".equals(action) || !"download".equals(action) && !"notify".equals(action)) return null;
            Gson gson = new Gson();
            String resync_logs = requestBody.get("data");
            String actionName = requestBody.get("actionName");
            if (!PropertyValidator.isValid((Object)actionName)) {
                actionName = "items";
            }
            actionName = actionName.replaceAll(" ", "_");
            HashMap chunks = new HashMap();
            if (PropertyValidator.isValid((Object)resync_logs)) {
                38 T = new /* Unavailable Anonymous Inner Class!! */;
                chunks = (HashMap)gson.fromJson(resync_logs, T.getType());
            }
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
            String filePath = this.exportService.exportLogData(sessionBoard, chunks, null, requestBody);
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
            String downloadName = AlmUtils.cleanText((String)sessionBoard.getSession().getTitle()) + "_" + actionName + "_logs_" + formatter.format(new Date()) + ".xls";
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("srcPath", URLEncoder.encode(filePath, "UTF-8"));
            data.put("name", URLEncoder.encode(downloadName, "UTF-8"));
            if ("download".equals(action)) {
                return new ResponseEntity(data, HttpStatus.OK);
            }
            if (!"notify".equals(action)) return null;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
        return null;
    }

    private AlmConfigurations saveLinkMappingOnResync(AlmConfigurations almConfig, String linkMappingsByFilters, String issueTypesByFilters) {
        ArrayList featureFilters;
        Gson gson = new Gson();
        39 P = new /* Unavailable Anonymous Inner Class!! */;
        40 I = new /* Unavailable Anonymous Inner Class!! */;
        Map newLinkMappings = (Map)gson.fromJson(linkMappingsByFilters, P.getType());
        Map newSelectedTypes = new HashMap();
        if (PropertyValidator.isValid((Object)issueTypesByFilters)) {
            newSelectedTypes = (Map)gson.fromJson(issueTypesByFilters, I.getType());
        }
        if (!PropertyValidator.isValid((Collection)(featureFilters = almConfig.getFeatureFilter()))) {
            featureFilters = new ArrayList();
        }
        if (!PropertyValidator.isValid((Collection)almConfig.getFeatureMappings())) {
            almConfig.setFeatureMappings(new ArrayList());
        }
        for (JiraFilter jiraFilter : almConfig.getFeatureFilter()) {
            if (newLinkMappings.get(jiraFilter.getId()) != null) {
                if (!PropertyValidator.isValid((Collection)jiraFilter.getFeatureLinkMappings())) {
                    jiraFilter.setFeatureLinkMappings(new ArrayList());
                }
                jiraFilter.getFeatureLinkMappings().addAll((Collection)newLinkMappings.get(jiraFilter.getId()));
                almConfig.addInFeatureMappings((Collection)newLinkMappings.get(jiraFilter.getId()));
            }
            if (newSelectedTypes.get(jiraFilter.getId()) == null) continue;
            if (PropertyValidator.isValid((Object)jiraFilter.getChildIssueTypes())) {
                jiraFilter.getChildIssueTypes().putAll((Map)newSelectedTypes.get(jiraFilter.getId()));
                continue;
            }
            jiraFilter.setChildIssueTypes((Map)newSelectedTypes.get(jiraFilter.getId()));
        }
        almConfig = (AlmConfigurations)this.almConfigurationsRepository.save((Object)almConfig);
        return almConfig;
    }

    @RequestMapping(value={"/team/settings/save"})
    public ResponseEntity<Object> saveTeamMapping(@RequestBody String payload) {
        try {
            HashMap<String, Object> responseJson = new HashMap<String, Object>();
            responseJson.put("success", false);
            Boolean isAdditionalFieldEnabled = new Boolean(this.env.getProperty("isAdditionalFieldEnabled"));
            Gson gson = new Gson();
            41 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)gson.fromJson(payload, T.getType());
            String almConfigId = (String)reqbody.get("almConfigId");
            String almAccountId = (String)reqbody.get("almAccountId");
            String sessionBoardId = (String)reqbody.get("sessionBoardId");
            String sessionId = (String)reqbody.get("sessionId");
            String teamId = (String)reqbody.get("teamId");
            Boolean syncWithJira = (Boolean)reqbody.get("syncWithJira");
            Boolean resyncBoard = (Boolean)reqbody.get("reSyncRequired");
            String teamContainersJson = (String)reqbody.get("teamContainers");
            String backlogMappingJson = (String)reqbody.get("backlogMapping");
            ResyncParamsVO syncUitls = new ResyncParamsVO();
            ObjectMapper map = new ObjectMapper();
            List itemSyncMappers = null;
            try {
                itemSyncMappers = (List)map.readValue(teamContainersJson, (JavaType)map.getTypeFactory().constructCollectionType(List.class, ItemSyncMapper.class));
            }
            catch (IOException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            ArrayList<Object> itemSyncMappersToBeDeleted = new ArrayList<Object>();
            List savedItemSyncMappers = new ArrayList();
            savedItemSyncMappers = this.itemSyncMapperRepository.findBySessionBoardAndTeam(new SessionBoard(sessionBoardId), new Team(teamId));
            if (PropertyValidator.isValid(savedItemSyncMappers)) {
                for (ItemSyncMapper itemSyncMapper : itemSyncMappers) {
                    Object savedItemSyncMapper;
                    if (!PropertyValidator.isValid((Object)itemSyncMapper.getId()) || !PropertyValidator.isValid((Object)(savedItemSyncMapper = (ItemSyncMapper)savedItemSyncMappers.get(savedItemSyncMappers.indexOf(itemSyncMapper))))) continue;
                    if (PropertyValidator.isValid((Object)savedItemSyncMapper.getSprint()) && PropertyValidator.isValid((Object)itemSyncMapper.getSprint())) {
                        if (savedItemSyncMapper.getSprint().getJiraId().equals(itemSyncMapper.getSprint().getJiraId())) continue;
                        itemSyncMappersToBeDeleted.add(savedItemSyncMapper);
                        continue;
                    }
                    if (!PropertyValidator.isValid((Object)savedItemSyncMapper.getSprint()) && PropertyValidator.isValid((Object)itemSyncMapper.getSprint())) {
                        itemSyncMappersToBeDeleted.add(savedItemSyncMapper);
                        continue;
                    }
                    if (PropertyValidator.isValid((Object)savedItemSyncMapper.getSprint()) && PropertyValidator.isValid((Object)itemSyncMapper.getSprint())) continue;
                }
            }
            AlmConfigurations configurations = (AlmConfigurations)this.almConfigurationsRepository.findOne((Serializable)((Object)almConfigId));
            BacklogMapping backlogMapping = (BacklogMapping)gson.fromJson(backlogMappingJson, BacklogMapping.class);
            if (syncWithJira.booleanValue()) {
                this.planService.convertJiraSprints(backlogMapping.getBoardId(), almAccountId, sessionBoardId);
                if (PropertyValidator.isValid((Collection)backlogMapping.getProjectKeys())) {
                    for (String projectKey : backlogMapping.getProjectKeys()) {
                        this.almSyncService.retrieveJiraProjectFields(configurations.getAlmAccount(), projectKey, Boolean.valueOf(true), Boolean.valueOf(false));
                    }
                }
            }
            ArrayList<BacklogMapping> teamMappings = configurations.getTeamMappings();
            boolean teamFound = false;
            if (!PropertyValidator.isValid((Collection)teamMappings)) {
                teamMappings = new ArrayList<BacklogMapping>();
                teamMappings.add(backlogMapping);
                teamFound = true;
            } else {
                for (int i = 0; i < teamMappings.size(); ++i) {
                    if (!((BacklogMapping)teamMappings.get(i)).getTeamId().equals(teamId)) continue;
                    teamMappings.set(i, backlogMapping);
                    teamFound = true;
                    break;
                }
            }
            if (!teamFound) {
                teamMappings.add(backlogMapping);
            }
            configurations.setTeamMappings(teamMappings);
            this.almConfigurationsRepository.save((Object)configurations);
            if (PropertyValidator.isValid((Collection)backlogMapping.getProjectKeys())) {
                ArrayList statuses = new ArrayList();
                for (String projectKey : backlogMapping.getProjectKeys()) {
                    if (this.statusRepository.existsByJiraProjKeyAndSessionId(projectKey, sessionId)) continue;
                    statuses.addAll(syncUitls.retrieveAndConvertJiraStatuses(projectKey, configurations.getAlmAccount(), sessionId, null, false, this.importUtil, this.statusRepository));
                }
                responseJson.put("newJiraStatuses", statuses);
            }
            if (PropertyValidator.isValid((Collection)itemSyncMappers)) {
                if (syncWithJira.booleanValue()) {
                    String toZoneId = TimeZone.getDefault().getID();
                    String sTime = null;
                    String eTime = null;
                    HashMap validationJson = this.almSyncService.validateAlmAccountUser(configurations.getAlmAccount(), UserContextUtil.getUserContext().getLoggedInUser());
                    Map jiraUser = JiraUtils.getJiraUser((HashMap)validationJson);
                    if (jiraUser.containsKey("timeZone")) {
                        toZoneId = (String)jiraUser.get("timeZone");
                    }
                    ArrayList<AlmError> almErrors = new ArrayList<AlmError>();
                    for (int i = 0; i < itemSyncMappers.size(); ++i) {
                        if (!PropertyValidator.isValid((Object)((ItemSyncMapper)itemSyncMappers.get(i)).getSprint())) continue;
                        if ("0".equals(((ItemSyncMapper)itemSyncMappers.get(i)).getSprint().getJiraId())) {
                            ((ItemSyncMapper)itemSyncMappers.get(i)).setSprint(null);
                            continue;
                        }
                        if ("+1".equals(((ItemSyncMapper)itemSyncMappers.get(i)).getSprint().getJiraId())) {
                            try {
                                ((ItemSyncMapper)itemSyncMappers.get(i)).setSprint(this.planService.createSprintInJira((ItemSyncMapper)itemSyncMappers.get(i), configurations.getAlmAccount(), backlogMapping, (Container)this.containerRepository.findOne((Serializable)((Object)((ItemSyncMapper)itemSyncMappers.get(i)).getContainer().getId())), sessionBoardId, toZoneId, sTime, eTime));
                                ((ItemSyncMapper)itemSyncMappers.get(i)).setCreateNewInJira(Boolean.FALSE);
                            }
                            catch (ViztrendJiraException vJe) {
                                if (!PropertyValidator.isValid((Object)vJe.getAlmError().getDescription())) {
                                    vJe.getAlmError().setDescription(vJe.getAlmError().getErrorJson());
                                }
                                almErrors.add(vJe.getAlmError());
                            }
                            continue;
                        }
                        Sprint sprint = this.sprintRepository.findSprintByJiraIdAndIsVersionAndAlmAccountIdAndSessionBoardId(((ItemSyncMapper)itemSyncMappers.get(i)).getSprint().getJiraId(), ((ItemSyncMapper)itemSyncMappers.get(i)).getSprint().getIsVersion(), almAccountId, sessionBoardId);
                        ((ItemSyncMapper)itemSyncMappers.get(i)).setSprint(sprint);
                    }
                    if (PropertyValidator.isValid(almErrors)) {
                        return new ResponseEntity(almErrors, HttpStatus.BAD_REQUEST);
                    }
                    itemSyncMappers = this.itemSyncMapperRepository.save((Iterable)itemSyncMappers);
                } else {
                    this.itemSyncMapperRepository.delete((Iterable)itemSyncMappers);
                }
            }
            responseJson.put("teamId", teamId);
            responseJson.put("syncWithJira", syncWithJira);
            responseJson.put("itemSyncMappers", itemSyncMappers);
            responseJson.put("backlogMapping", backlogMapping);
            responseJson.put("success", true);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (ViztrendJiraException vJe) {
            return new ResponseEntity((Object)vJe.getAlmError(), HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/basic/save"})
    public ResponseEntity<Object> saveBasicSettings(@RequestBody HashMap<String, Object> request) {
        String sessionStr = (String)request.get("session");
        String metaMap = (String)request.get("metaMap");
        String getJiraColorsMap = (String)request.get("getJiraColors");
        ObjectMapper mapper = new ObjectMapper();
        try {
            Session session = (Session)mapper.readValue(sessionStr, Session.class);
            Object getJiraColorsVal = mapper.readValue(getJiraColorsMap, Object.class);
            HashMap mapForJiraColors = (HashMap)getJiraColorsVal;
            Session savedSession = (Session)this.sessionRepository.findOne((Serializable)((Object)session.getId()));
            savedSession.setTitle(session.getTitle());
            savedSession.setParentItem(session.getParentItem());
            savedSession.setChildItem(session.getChildItem());
            savedSession.setParentItems(session.getParentItems());
            savedSession.setChildItems(session.getChildItems());
            savedSession.setSprintLabel(session.getSprintLabel());
            savedSession.setSprintsLabel(session.getSprintsLabel());
            savedSession.setTeamLabel(session.getTeamLabel());
            savedSession.setTeamsLabel(session.getTeamsLabel());
            savedSession.setJiraBaseURL(session.getJiraBaseURL());
            savedSession.setStartDate(session.getStartDate());
            savedSession.setEndDate(session.getEndDate());
            savedSession.setPlanningStartDate(session.getPlanningStartDate());
            savedSession.setPlanningEndDate(session.getPlanningEndDate());
            savedSession.setReadOnlyWithOutALMProfile(session.getReadOnlyWithOutALMProfile());
            savedSession.setHidePiJourney(session.getHidePiJourney());
            savedSession.setHideMilestonesBar(session.getHideMilestonesBar());
            savedSession.setMilestoneWidgetHeader(session.getMilestoneWidgetHeader());
            savedSession.setPrefix(session.getPrefix());
            savedSession.setPrefixColor(session.getPrefixColor());
            savedSession.setParentItemColor(session.getParentItemColor());
            savedSession.setChildItemColor(session.getChildItemColor());
            savedSession.setParentItemTextColor(session.getParentItemTextColor());
            savedSession.setChildItemTextColor(session.getChildItemTextColor());
            savedSession.setKendisOnlyLayout(session.getKendisOnlyLayout());
            savedSession.setItemParent(session.getItemParent());
            savedSession.setTeamSettings(session.getTeamSettings());
            if (PropertyValidator.isValid((Object)mapForJiraColors) && PropertyValidator.isValid(mapForJiraColors.get("isJiraColorsEnabled"))) {
                Boolean isJiraColorsEnabled = (Boolean)mapForJiraColors.get("isJiraColorsEnabled");
                if (isJiraColorsEnabled.booleanValue()) {
                    if (PropertyValidator.isValid(mapForJiraColors.get("additionalFieldsValues"))) {
                        List additionalFieldsValues = (List)mapForJiraColors.get("additionalFieldsValues");
                        savedSession.setFieldsValuesForColors(additionalFieldsValues);
                    }
                    savedSession.setIsJiraColorsEnabled(Boolean.valueOf(true));
                } else {
                    savedSession.setIsJiraColorsEnabled(Boolean.valueOf(false));
                    savedSession.setFieldsValuesForColors(new ArrayList());
                }
            }
            this.sessionRepository.save((Object)savedSession);
            JSONObject pushJson = new JSONObject();
            try {
                pushJson.put("type", (Object)"Board");
                pushJson.put("metaMap", (Object)metaMap);
                PushSender.sendMsg((String)pushJson.toString());
            }
            catch (JSONException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @RequestMapping(value={"/team/sequence"})
    public ResponseEntity<Object> saveTeamSequence(@RequestBody String payload) {
        Gson g = new Gson();
        42 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(payload, T.getType());
        String boardId = (String)reqbody.get("sessionBoardId");
        String seq = (String)reqbody.get("teamSequence");
        String[] teamSequence = seq.split(",");
        this.customRepository.updateTeamSequenceByBoardId(boardId, teamSequence);
        return null;
    }

    @RequestMapping(value={"/linkjiradependency/save"})
    public ResponseEntity<Object> saveLinkJiraDependency(@RequestBody HashMap<String, Object> request) {
        String sessionStr = (String)request.get("session");
        String mappingsStr = null;
        List mappings = null;
        if (request.containsKey("mappings")) {
            mappingsStr = (String)request.get("mappings");
        }
        String teamSprintDependencyLimitStr = (String)request.get("teamSprintDependencyLimit");
        ObjectMapper mapper = new ObjectMapper();
        List TeamSprintDependencyLimitList = null;
        try {
            AlmAccount almAccount;
            Map jiraUser;
            Session session = (Session)mapper.readValue(sessionStr, Session.class);
            if (mappingsStr != null) {
                mappings = (List)mapper.readValue(mappingsStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            Session savedSession = (Session)this.sessionRepository.findOne((Serializable)((Object)session.getId()));
            savedSession.setJiraLinkTypes(session.getJiraLinkTypes());
            savedSession.setJiraDependencyEnabled(session.getJiraDependencyEnabled());
            savedSession.setJiraFeatureParentEnabled(session.getJiraFeatureParentEnabled());
            savedSession.setJiraFeatureParentIssueType(session.getJiraFeatureParentIssueType());
            savedSession.setJiraFeatureParentLinkType(session.getJiraFeatureParentLinkType());
            if (!PropertyValidator.isValid((Collection)savedSession.getJiraLinkTypesCached())) {
                savedSession.setJiraLinkTypesCached(new HashSet());
            }
            if (PropertyValidator.isValid((Collection)session.getJiraLinkTypes())) {
                savedSession.getJiraLinkTypesCached().addAll(session.getJiraLinkTypes());
            }
            if (Boolean.FALSE.equals(session.getJiraSharedSprintFieldEnabled()) && PropertyValidator.isValid((Collection)savedSession.getAlmConfigurations())) {
                if (PropertyValidator.isValid((Collection)((AlmConfigurations)savedSession.getAlmConfigurations().get(0)).getTeamMappings())) {
                    for (BacklogMapping backlogMapping : ((AlmConfigurations)savedSession.getAlmConfigurations().get(0)).getTeamMappings()) {
                        backlogMapping.setJiraFieldMap(null);
                    }
                }
            } else if (Boolean.TRUE.equals(session.getJiraSharedSprintFieldEnabled()) && PropertyValidator.isValid((Object)savedSession.getJiraSharedSprintField()) && !savedSession.getJiraSharedSprintField().getKey().equals(session.getJiraSharedSprintField().getKey()) && PropertyValidator.isValid((Collection)((AlmConfigurations)savedSession.getAlmConfigurations().get(0)).getTeamMappings())) {
                for (BacklogMapping backlogMapping : ((AlmConfigurations)savedSession.getAlmConfigurations().get(0)).getTeamMappings()) {
                    backlogMapping.setJiraFieldMap(null);
                }
            }
            savedSession.setJiraSharedSprintFieldEnabled(session.getJiraSharedSprintFieldEnabled());
            savedSession.setJiraSharedSprintField(session.getJiraSharedSprintField());
            savedSession.setDependencyReceiveLimit(session.getDependencyReceiveLimit());
            savedSession.setFlaggedFieldEnabled(session.getFlaggedFieldEnabled());
            savedSession.setKendisFlaggedFieldEnabled(session.getKendisFlaggedFieldEnabled());
            savedSession.setJiraFlaggedFieldEnabled(session.getJiraFlaggedFieldEnabled());
            savedSession.setJiraFlaggedField(session.getJiraFlaggedField());
            savedSession.setJiraSynapseRTEnabled(session.getJiraSynapseRTEnabled());
            savedSession.setItemLinkStatusDependentOn(session.getItemLinkStatusDependentOn());
            savedSession.setReOpenDependencyIfItemReOpen(session.getReOpenDependencyIfItemReOpen());
            savedSession.setIgnoreUpdateIfManualResolvedForItem(session.getIgnoreUpdateIfManualResolvedForItem());
            savedSession.setSubItemLinkStatusDependentOn(session.getSubItemLinkStatusDependentOn());
            savedSession.setReOpenDependencyIfSubItemReOpen(session.getReOpenDependencyIfSubItemReOpen());
            savedSession.setIgnoreUpdateIfManualResolvedForSubItem(session.getIgnoreUpdateIfManualResolvedForSubItem());
            savedSession.setAdditionalFieldsEnabled(session.getAdditionalFieldsEnabled());
            savedSession.setAdditionalFieldsJiraTimeZone(session.getAdditionalFieldsJiraTimeZone());
            savedSession.setAdditionalFieldsValuesUserStory(session.getAdditionalFieldsValuesUserStory());
            savedSession.setAdditionalFieldsValuesFeature(session.getAdditionalFieldsValuesFeature());
            savedSession.setAdditionalFieldsTypesUserStory(session.getAdditionalFieldsTypesUserStory());
            savedSession.setAdditionalFieldsTypesFeature(session.getAdditionalFieldsTypesFeature());
            savedSession.setwsjfAlmEnabled(session.getwsjfAlmEnabled());
            savedSession.setWsjfKendisEnabled(session.getWsjfKendisEnabled());
            savedSession.setStartSprintWebhookEnabled(session.getStartSprintWebhookEnabled());
            savedSession.setEndSprintWebhookEnabled(session.getEndSprintWebhookEnabled());
            savedSession.setStartDateAction(session.getStartDateAction());
            savedSession.setWsjfEnabled(session.getWsjfEnabled());
            savedSession.setWsjfWithMappingEnabled(session.getWsjfWithMappingEnabled());
            savedSession.setLineArrowDirection(session.getLineArrowDirection());
            savedSession.setBucketEnabled(session.getBucketEnabled());
            savedSession.setBuckets(session.getBuckets());
            savedSession.setReverseDependencyDirection(session.getReverseDependencyDirection());
            savedSession.setKendisLinkTypeDisabled(session.getKendisLinkTypeDisabled());
            if (Boolean.TRUE.equals(session.getwsjfAlmEnabled())) {
                savedSession.setwsjfAlmFieldKey(session.getwsjfAlmFieldKey());
            } else {
                savedSession.setwsjfAlmFieldKey(null);
            }
            if (PropertyValidator.isValid((Object)savedSession.getAdditionalFieldsJiraTimeZone()) && (jiraUser = JiraUtils.getJiraUser((HashMap)this.almSyncService.validateAlmAccountUser(almAccount = AlmUtils.getALMAcount((String)((AlmConfigurations)savedSession.getAlmConfigurations().get(0)).getAlmAccount().getId(), (AlmAccountRepository)this.almAccountRepository), UserContextUtil.getUserContext().getLoggedInUser()))).containsKey("timeZone")) {
                savedSession.setAdditionalFieldsJiraTimeZone((String)jiraUser.get("timeZone"));
            }
            if (Boolean.TRUE.equals(savedSession.getWsjfEnabled())) {
                this.aLMSyncService.createScoreCard(session, savedSession);
                if (mappings != null) {
                    this.aLMSyncService.saveMappings(session, mappings);
                }
                if (PropertyValidator.isValid((Collection)savedSession.getAlmConfigurations())) {
                    this.almConfigurationsRepository.save((Iterable)savedSession.getAlmConfigurations());
                }
            }
            savedSession = (Session)this.sessionRepository.save((Object)savedSession);
            this.customRepositoryImpl.addItemsAsBuckets(savedSession);
            if (teamSprintDependencyLimitStr != null) {
                TeamSprintDependencyLimitList = (List)mapper.readValue(teamSprintDependencyLimitStr, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, TeamSprintDependencyLimit.class));
                TeamSprintDependencyLimitList = this.TeamSprintDependencyLimitRepository.save((Iterable)TeamSprintDependencyLimitList);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @RequestMapping(value={"/team/addToWorkspace"})
    public ResponseEntity<Object> addTeamToWorkspace(@RequestBody Team team) {
        Team saveTeam = (Team)this.teamRepository.findOne((Serializable)((Object)team.getId()));
        if (saveTeam.getWorkSpaces() == null) {
            saveTeam.setWorkSpaces(new ArrayList());
        }
        saveTeam.getWorkSpaces().add(team.getWorkSpaces().get(0));
        this.teamRepository.save((Object)saveTeam);
        Team dbTeam = (Team)this.teamRepository.findOne((Serializable)((Object)team.getId()));
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", true);
        responseJson.put("team", (Boolean)dbTeam);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/team/save"})
    public ResponseEntity<Object> saveTeam(@RequestBody String payload) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("success", false);
        try {
            JSONObject jObj = new JSONObject(payload);
            ObjectMapper mapper = new ObjectMapper();
            Team team = (Team)mapper.readValue(jObj.getString("team"), Team.class);
            Team savedTeam = null;
            if (PropertyValidator.isValid((Object)team)) {
                if (PropertyValidator.isValid((Object)team.getId())) {
                    savedTeam = (Team)this.teamRepository.findOne((Serializable)((Object)team.getId()));
                    boolean titleUpdated = false;
                    if (PropertyValidator.isValid((Object)team.getTitle()) && !team.getTitle().equals(savedTeam.getTitle())) {
                        savedTeam.setTitle(team.getTitle());
                        titleUpdated = true;
                    }
                    if (PropertyValidator.isValid((Object)team.getLabel())) {
                        savedTeam.setLabel(team.getLabel());
                    }
                    if (PropertyValidator.isValid((Object)team.getColor())) {
                        savedTeam.setColor(team.getColor());
                    }
                    if (PropertyValidator.isValid((Object)team.getSequence())) {
                        savedTeam.setSequence(team.getSequence());
                    }
                    savedTeam = (Team)this.teamRepository.save((Object)savedTeam);
                    boolean titleUpdatedFlag = titleUpdated;
                    new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                } else {
                    savedTeam = (Team)this.teamRepository.save((Object)team);
                    String sessionBoardId = jObj.getString("sessionBoardId");
                    if (PropertyValidator.isValid((Object)sessionBoardId)) {
                        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
                        ArrayList<Team> teams = sessionBoard.getTeams();
                        if (!PropertyValidator.isValid((Collection)teams)) {
                            teams = new ArrayList<Team>();
                        }
                        teams.add(savedTeam);
                        sessionBoard.setTeams(teams);
                        if (PropertyValidator.isValid((String[])sessionBoard.getTeamSequence())) {
                            sessionBoard.setTeamSequence((String[])ArrayUtils.add((Object[])sessionBoard.getTeamSequence(), (int)sessionBoard.getTeamSequence().length, (Object)savedTeam.getId()));
                        }
                        this.sessionBoardRepository.save((Object)sessionBoard);
                        if (sessionBoard.getSession().getAlmEnabled().booleanValue()) {
                            AlmConfigurations config = (AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0);
                            ArrayList<BacklogMapping> teamMappings = config.getTeamMappings();
                            BacklogMapping backlogObj = new BacklogMapping();
                            backlogObj.setTeamId(savedTeam.getId());
                            backlogObj.setBacklogId(UUID.randomUUID().toString());
                            if (!PropertyValidator.isValid((Collection)teamMappings)) {
                                teamMappings = new ArrayList<BacklogMapping>();
                            }
                            teamMappings.add(backlogObj);
                            config.setTeamMappings(teamMappings);
                            this.almConfigurationsRepository.save((Object)config);
                            responseJson.put("teamMap", backlogObj);
                        }
                        responseJson.put("teamSequence", sessionBoard.getTeamSequence());
                        this.almSyncService.updateTeamSprintDependencyOnAddTeam(sessionBoard, savedTeam);
                    }
                    responseJson.put("newTeam", true);
                    if (PropertyValidator.isValid((Object)savedTeam)) {
                        AuditLog auditLogObject = new AuditLog(sessionBoardId, "TEAM_ADD", null);
                        auditLogObject.setEventText("Team " + savedTeam.getTitle() + " added");
                        this.auditLogRepository.save((Object)auditLogObject);
                    }
                }
            }
            if (PropertyValidator.isValid(savedTeam)) {
                responseJson.put("success", true);
                responseJson.put("data", savedTeam);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/audit"})
    public ResponseEntity<Object> saveAuditChanged(@RequestBody AuditLog audit) {
        try {
            if (PropertyValidator.isValid((Object)audit)) {
                audit = (AuditLog)this.auditLogRepository.save((Object)audit);
            }
            return new ResponseEntity((Object)audit, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e), (Object)"saveSyncSetting failed with exeption");
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/team/associate"})
    public ResponseEntity<Object> associateTeam(@RequestBody String payload) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("success", false);
        Gson g = new Gson();
        45 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(payload, T.getType());
        String teamId = (String)reqbody.get("teamId");
        String sessionBoardId = (String)reqbody.get("sessionBoardId");
        if (PropertyValidator.isValid((Object)sessionBoardId) && PropertyValidator.isValid((Object)teamId)) {
            Team team = (Team)this.teamRepository.findOne((Serializable)((Object)teamId));
            SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
            ArrayList<Team> teams = sessionBoard.getTeams();
            if (!PropertyValidator.isValid((Collection)teams)) {
                teams = new ArrayList<Team>();
            }
            for (Team t : sessionBoard.getTeams()) {
                if (!t.getId().equals(team.getId())) continue;
                responseJson.put("success", false);
                responseJson.put("reason", "AlreadyExist");
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            teams.add(team);
            sessionBoard.setTeams(teams);
            if (PropertyValidator.isValid((String[])sessionBoard.getTeamSequence())) {
                sessionBoard.setTeamSequence((String[])ArrayUtils.add((Object[])sessionBoard.getTeamSequence(), (int)sessionBoard.getTeamSequence().length, (Object)team.getId()));
            }
            this.sessionBoardRepository.save((Object)sessionBoard);
            if (sessionBoard.getSession().getAlmEnabled().booleanValue()) {
                AlmConfigurations config = (AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0);
                ArrayList<BacklogMapping> teamMappings = config.getTeamMappings();
                BacklogMapping backlogObj = new BacklogMapping();
                backlogObj.setTeamId(team.getId());
                backlogObj.setBacklogId(UUID.randomUUID().toString());
                if (!PropertyValidator.isValid((Collection)teamMappings)) {
                    teamMappings = new ArrayList<BacklogMapping>();
                }
                teamMappings.add(backlogObj);
                config.setTeamMappings(teamMappings);
                this.almConfigurationsRepository.save((Object)config);
                responseJson.put("teamMapping", backlogObj);
            }
            responseJson.put("teamSequence", sessionBoard.getTeamSequence());
            if (PropertyValidator.isValid((Object)team)) {
                responseJson.put("success", true);
                responseJson.put("team", team);
                AuditLog auditLogObject = new AuditLog(sessionBoardId, "TEAM_ADD", null);
                auditLogObject.setEventText("Existing Team " + team.getTitle() + " added");
                this.auditLogRepository.save((Object)auditLogObject);
            }
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/team/delete"})
    public ResponseEntity<Object> deleteTeam(@RequestBody String payload) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("success", false);
        Gson g = new Gson();
        46 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(payload, T.getType());
        String teamId = (String)reqbody.get("teamId");
        String sessionBoardId = (String)reqbody.get("sessionBoardId");
        if (PropertyValidator.isValid((Object)sessionBoardId)) {
            List teamMappings;
            SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
            AlmConfigurations configurations = null;
            if (PropertyValidator.isValid((Collection)sessionBoard.getSession().getAlmConfigurations()) && PropertyValidator.isValid((Collection)(teamMappings = (configurations = (AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getTeamMappings()))) {
                int teamMappingsLength = teamMappings.size();
                for (int i = 0; i < teamMappingsLength; ++i) {
                    if (!((BacklogMapping)teamMappings.get(i)).getTeamId().equals(teamId)) continue;
                    teamMappings.remove(i);
                    break;
                }
                if (teamMappings.size() == 0) {
                    configurations.setTeamMappings(null);
                } else {
                    configurations.setTeamMappings(teamMappings);
                }
            }
            this.TeamSprintDependencyLimitRepository.deleteBySessionIdAndTeamId(sessionBoard.getSession().getId(), teamId);
            List teamContainersToBeDeleted = this.teamContainerRepository.findByTeamAndContainerIn(new Team(teamId), sessionBoard.getContainers());
            if (PropertyValidator.isValid((Collection)teamContainersToBeDeleted)) {
                List items = this.itemRepository.findByTeamContainersIn(teamContainersToBeDeleted);
                if (PropertyValidator.isValid((Collection)items)) {
                    for (Item item : items) {
                        ArrayList<TeamContainer> deletedTCs = new ArrayList<TeamContainer>();
                        for (TeamContainer tc : item.getTeamContainers()) {
                            TeamContainer deletedTC = teamContainersToBeDeleted.stream().filter(lt -> lt.getId().equals(tc.getId())).findAny().orElse(null);
                            if (!PropertyValidator.isValid((Object)deletedTC)) continue;
                            deletedTCs.add(deletedTC);
                        }
                        item.getTeamContainers().removeAll(deletedTCs);
                    }
                    this.itemRepository.save((Iterable)items);
                }
                this.teamContainerRepository.delete((Iterable)teamContainersToBeDeleted);
                ArrayList teamContainerIds = new ArrayList();
                teamContainersToBeDeleted.forEach(teamContainer -> teamContainerIds.add(teamContainer.getId()));
                List itemLinks = this.itemLinkRepository.findBySourceTeamContainerIdInOrTargetTeamContainerIdIn(teamContainerIds, teamContainerIds);
                if (PropertyValidator.isValid((Collection)itemLinks)) {
                    items = this.itemRepository.findByItemLinksIn(itemLinks);
                    if (PropertyValidator.isValid((Collection)items)) {
                        for (int i = 0; i < items.size(); ++i) {
                            Object savedItemLinks;
                            Object deletedItemLinks = savedItemLinks = ((Item)items.get(i)).getItemLinks();
                            for (int j = 0; j < savedItemLinks.size(); ++j) {
                                int tcIndex = j;
                                ItemLink it = itemLinks.stream().filter(arg_0 -> PlanController.lambda$deleteTeam$52((List)savedItemLinks, tcIndex, arg_0)).findAny().orElse(null);
                                if (!PropertyValidator.isValid((Object)it)) continue;
                                deletedItemLinks.remove(j);
                            }
                            ((Item)items.get(i)).setItemLinks((List)deletedItemLinks);
                        }
                        this.itemRepository.save((Iterable)items);
                    }
                    KendisUtils.archiveItemLinks((ItemLinkRepository)this.itemLinkRepository, (List)itemLinks);
                }
            }
            this.itemSyncMapperRepository.deleteBySessionBoardAndTeam(sessionBoard, new Team(teamId));
            int index = sessionBoard.getTeams().indexOf(new Team(teamId));
            Team team = null;
            if (index > -1) {
                team = (Team)sessionBoard.getTeams().remove(index);
            }
            if (PropertyValidator.isValid((String[])sessionBoard.getTeamSequence()) && ArrayUtils.indexOf((Object[])sessionBoard.getTeamSequence(), (Object)teamId) > -1) {
                sessionBoard.setTeamSequence((String[])ArrayUtils.remove((Object[])sessionBoard.getTeamSequence(), (int)ArrayUtils.indexOf((Object[])sessionBoard.getTeamSequence(), (Object)teamId)));
            }
            if (sessionBoard.getSession().getAlmEnabled().booleanValue()) {
                this.almConfigurationsRepository.save((Iterable)sessionBoard.getSession().getAlmConfigurations());
            }
            this.sessionBoardRepository.save((Object)sessionBoard);
            responseJson.put("teamSequence", sessionBoard.getTeamSequence());
            List riskLinkToBeDeleted = this.riskRepository.findAll();
            for (Risk risk : riskLinkToBeDeleted) {
                boolean found = false;
                List boardTeams = risk.getBoardTeams();
                if (boardTeams == null) continue;
                Iterator itr = boardTeams.iterator();
                while (itr.hasNext()) {
                    BoardTeam bT = (BoardTeam)itr.next();
                    if (!bT.getSessionId().equalsIgnoreCase(sessionBoard.getSession().getId()) || !bT.getTeamId().equalsIgnoreCase(teamId)) continue;
                    itr.remove();
                    found = true;
                }
                if (!found) continue;
                this.riskRepository.save((Object)risk);
            }
            if (PropertyValidator.isValid((Object)team)) {
                AuditLog auditLogObject = new AuditLog(sessionBoardId, "TEAM_REMOVED", null);
                auditLogObject.setEventText("Team " + team.getTitle() + " removed");
                this.auditLogRepository.save((Object)auditLogObject);
            }
            this.piJourneyBoardService.updateTeamBreakoutOnTeamRemove(sessionBoard.getSession().getId(), teamId);
        }
        responseJson.put("teamId", teamId);
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    public ResponseEntity<Object> deleteTeamold(@RequestBody String payload) {
        List teamContainers;
        int i;
        SessionBoard sessionBoard;
        List teams;
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("success", false);
        Gson g = new Gson();
        47 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(payload, T.getType());
        String almConfigId = (String)reqbody.get("almConfigId");
        String teamId = (String)reqbody.get("teamId");
        String teamContainersJson = (String)reqbody.get("teamContainers");
        String sessionBoardId = (String)reqbody.get("sessionBoardId");
        ObjectMapper map = new ObjectMapper();
        List itemSyncMappers = null;
        try {
            itemSyncMappers = (List)map.readValue(teamContainersJson, (JavaType)map.getTypeFactory().constructCollectionType(List.class, ItemSyncMapper.class));
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        48 P = new /* Unavailable Anonymous Inner Class!! */;
        AlmConfigurations configurations = (AlmConfigurations)this.almConfigurationsRepository.findOne((Serializable)((Object)almConfigId));
        List teamMappings = configurations.getTeamMappings();
        if (PropertyValidator.isValid((Collection)teamMappings)) {
            for (int i2 = 0; i2 < teamMappings.size(); ++i2) {
                if (!((BacklogMapping)teamMappings.get(i2)).getTeamId().equals(teamId)) continue;
                teamMappings.remove(i2);
                break;
            }
            if (teamMappings.size() == 0) {
                configurations.setTeamMappings(null);
            } else {
                configurations.setTeamMappings(teamMappings);
            }
        }
        this.almConfigurationsRepository.save((Object)configurations);
        if (PropertyValidator.isValid((Object)sessionBoardId) && PropertyValidator.isValid((Collection)(teams = (sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId))).getTeams()))) {
            for (i = 0; i < teams.size(); ++i) {
                if (!((Team)teams.get(i)).getId().equals(teamId)) continue;
                teams.remove(i);
            }
            sessionBoard.setTeams(teams);
            this.sessionBoardRepository.save((Object)sessionBoard);
        }
        if (PropertyValidator.isValid((Collection)(teamContainers = this.teamContainerRepository.findByTeam_Id(teamId)))) {
            List items = this.itemRepository.findByTeamContainersIn(teamContainers);
            if (PropertyValidator.isValid((Collection)items)) {
                for (i = 0; i < items.size(); ++i) {
                    List itemTeamContainers;
                    List newItemTeamContainers = itemTeamContainers = ((Item)items.get(i)).getTeamContainers();
                    for (int j = 0; j < itemTeamContainers.size(); ++j) {
                        int tcIndex = j;
                        TeamContainer tc = teamContainers.stream().filter(lt -> lt.getId().equals(((TeamContainer)itemTeamContainers.get(tcIndex)).getId())).findAny().orElse(null);
                        if (!PropertyValidator.isValid((Object)tc)) continue;
                        newItemTeamContainers.remove(j);
                        teamContainers.remove(tc);
                    }
                    ((Item)items.get(i)).setTeamContainers(newItemTeamContainers);
                }
                this.itemRepository.save((Iterable)items);
            }
            this.teamContainerRepository.save((Iterable)teamContainers);
        }
        if (PropertyValidator.isValid((Collection)itemSyncMappers)) {
            this.itemSyncMapperRepository.delete((Iterable)itemSyncMappers);
        }
        responseJson.put("teamId", teamId);
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/container/save"})
    public ResponseEntity<Object> saveContainer(@RequestBody String payload) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", false);
        try {
            if (PropertyValidator.isValid((Object)payload)) {
                JSONObject jObj = new JSONObject(payload);
                ObjectMapper mapper = new ObjectMapper();
                Container container = (Container)mapper.readValue(jObj.getString("container"), Container.class);
                Container savedContainer = null;
                if (PropertyValidator.isValid((Object)container.getId())) {
                    savedContainer = (Container)this.containerRepository.findOne((Serializable)((Object)container.getId()));
                    boolean titleUpdated = false;
                    boolean anyAction = jObj.has("action");
                    if (anyAction) {
                        if ("sequnce".equals(jObj.get("action")) && PropertyValidator.isValid((Object)container.getSequence())) {
                            savedContainer.setSequence(container.getSequence());
                        }
                    } else {
                        if (PropertyValidator.isValid((Object)container.getTitle()) && !container.getTitle().equals(savedContainer.getTitle())) {
                            savedContainer.setTitle(container.getTitle());
                            titleUpdated = true;
                        }
                        if (PropertyValidator.isValid((Object)container.getLabel())) {
                            savedContainer.setLabel(container.getLabel());
                        }
                        savedContainer.setStartDate(container.getStartDate());
                        savedContainer.setEndDate(container.getEndDate());
                        if (PropertyValidator.isValid((Object)container.getSequence())) {
                            savedContainer.setSequence(container.getSequence());
                        }
                    }
                    String sessionBoardId = jObj.getString("sessionBoardId");
                    SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
                    savedContainer = (Container)this.containerRepository.save((Object)savedContainer);
                    boolean titleUpdatedFlag = titleUpdated;
                    new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                } else {
                    savedContainer = (Container)this.containerRepository.save((Object)container);
                    String sessionBoardId = jObj.getString("sessionBoardId");
                    if (PropertyValidator.isValid((Object)sessionBoardId)) {
                        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
                        ArrayList<Container> containers = sessionBoard.getContainers();
                        if (!PropertyValidator.isValid((Collection)containers)) {
                            containers = new ArrayList<Container>();
                        }
                        containers.add(savedContainer);
                        sessionBoard.setContainers(containers);
                        this.sessionBoardRepository.save((Object)sessionBoard);
                        this.almSyncService.updateTeamSprintDependencyOnAddContainer(sessionBoard, savedContainer);
                        this.piJourneyBoardService.updateTeamCapacityOnAddSprint(sessionBoard, savedContainer);
                    }
                    responseJson.put("newContainer", true);
                    AuditLog auditLogObject = new AuditLog(sessionBoardId, "CONTAINER_ADD", null);
                    auditLogObject.setEventText("Sprint " + savedContainer.getTitle() + " added");
                    this.auditLogRepository.save((Object)auditLogObject);
                }
                if (PropertyValidator.isValid((Object)savedContainer)) {
                    responseJson.put("success", true);
                    responseJson.put("data", (Boolean)savedContainer);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/container/delete"})
    public ResponseEntity<Object> deleteContainer(@RequestBody String payload) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", false);
        try {
            SessionBoard sessionBoard;
            List containers;
            String sessionBoardId;
            JSONObject jObj;
            ObjectMapper mapper;
            Container container;
            if (PropertyValidator.isValid((Object)payload) && PropertyValidator.isValid((Object)(container = (Container)(mapper = new ObjectMapper()).readValue((jObj = new JSONObject(payload)).getString("container"), Container.class)).getId()) && PropertyValidator.isValid((Object)(sessionBoardId = jObj.getString("sessionBoardId"))) && PropertyValidator.isValid((Collection)(containers = (sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId))).getContainers()))) {
                int index = containers.indexOf(container);
                if (index > -1) {
                    container = (Container)containers.remove(index);
                }
                sessionBoard.setContainers(containers);
                this.sessionBoardRepository.save((Object)sessionBoard);
                List riskLinkToBeDeleted = this.riskRepository.findAll();
                for (Risk risk : riskLinkToBeDeleted) {
                    boolean found = false;
                    List boardSprint = risk.getBoardSprints();
                    if (boardSprint == null) continue;
                    Iterator itr = boardSprint.iterator();
                    while (itr.hasNext()) {
                        BoardSprints bT = (BoardSprints)itr.next();
                        if (!bT.getSessionId().equalsIgnoreCase(sessionBoard.getSession().getId()) || !bT.getSprintId().equalsIgnoreCase(container.getId())) continue;
                        itr.remove();
                        found = true;
                    }
                    if (!found) continue;
                    this.riskRepository.save((Object)risk);
                }
                List teamContainers = this.teamContainerRepository.findByContainer_Id(container.getId());
                if (PropertyValidator.isValid((Collection)teamContainers)) {
                    List items = this.itemRepository.findByTeamContainersIn(teamContainers);
                    if (PropertyValidator.isValid((Collection)items)) {
                        for (int i = 0; i < items.size(); ++i) {
                            List itemTeamContainers;
                            List newItemTeamContainers = itemTeamContainers = ((Item)items.get(i)).getTeamContainers();
                            for (int j = 0; j < itemTeamContainers.size(); ++j) {
                                int tcIndex = j;
                                TeamContainer tc = teamContainers.stream().filter(lt -> lt.getId().equals(((TeamContainer)itemTeamContainers.get(tcIndex)).getId())).findAny().orElse(null);
                                if (!PropertyValidator.isValid((Object)tc)) continue;
                                newItemTeamContainers.remove(j);
                            }
                            ((Item)items.get(i)).setTeamContainers(newItemTeamContainers);
                        }
                        this.itemRepository.save((Iterable)items);
                    }
                    ArrayList teamContainerIds = new ArrayList();
                    teamContainers.forEach(teamContainer -> teamContainerIds.add(teamContainer.getId()));
                    List itemLinks = this.itemLinkRepository.findBySourceTeamContainerIdInOrTargetTeamContainerIdIn((Collection)teamContainerIds, (Collection)teamContainerIds);
                    if (PropertyValidator.isValid((Collection)itemLinks)) {
                        items = this.itemRepository.findByItemLinksIn(itemLinks);
                        if (PropertyValidator.isValid((Collection)items)) {
                            for (int i = 0; i < items.size(); ++i) {
                                List savedItemLinks;
                                List deletedItemLinks = savedItemLinks = ((Item)items.get(i)).getItemLinks();
                                for (int j = 0; j < savedItemLinks.size(); ++j) {
                                    int tcIndex = j;
                                    ItemLink it = itemLinks.stream().filter(lt -> lt.getId().equals(((ItemLink)savedItemLinks.get(tcIndex)).getId())).findAny().orElse(null);
                                    if (!PropertyValidator.isValid((Object)it)) continue;
                                    deletedItemLinks.remove(j);
                                }
                                ((Item)items.get(i)).setItemLinks(deletedItemLinks);
                            }
                            this.itemRepository.save((Iterable)items);
                        }
                        KendisUtils.archiveItemLinks((ItemLinkRepository)this.itemLinkRepository, (List)itemLinks);
                    }
                    this.teamContainerRepository.delete((Iterable)teamContainers);
                }
                List piTeamCapacityList = this.piTeamCapacityRepository.findBySessionId(sessionBoard.getSession().getId());
                for (PiTeamCapacity piTeamCapacity : piTeamCapacityList) {
                    for (PiUserCapacity userCapacity : piTeamCapacity.getUsersCapacity()) {
                        PiContainerCapacity containerCapacityToBeRemoved = null;
                        for (PiContainerCapacity containerCapacity : userCapacity.getContainersCapacity()) {
                            if (!containerCapacity.getContainerId().equals(container.getId())) continue;
                            containerCapacityToBeRemoved = containerCapacity;
                            break;
                        }
                        if (containerCapacityToBeRemoved == null) continue;
                        userCapacity.getContainersCapacity().remove(containerCapacityToBeRemoved);
                        this.piUserCapacityRepository.save((Object)userCapacity);
                    }
                }
                this.containerRepository.delete((Serializable)((Object)container.getId()));
                this.itemSyncMapperRepository.deleteBySessionBoardAndContainer(sessionBoard, container);
                this.TeamSprintDependencyLimitRepository.deleteBySessionIdAndSprintId(sessionBoard.getSession().getId(), container.getId());
                responseJson.put("success", true);
                responseJson.put("data", (Boolean)container);
                AuditLog auditLogObject = new AuditLog(sessionBoardId, "CONTAINER_DEL", null);
                auditLogObject.setEventText("Sprint " + (container.getTitle() == null ? "" : container.getTitle()) + " removed");
                this.auditLogRepository.save((Object)auditLogObject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    public ResponseEntity<Object> deleteContainerOLD(@RequestBody String payload) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", false);
        try {
            String sessionBoardId;
            JSONObject jObj;
            ObjectMapper mapper;
            Container container;
            if (PropertyValidator.isValid((Object)payload) && PropertyValidator.isValid((Object)(container = (Container)(mapper = new ObjectMapper()).readValue((jObj = new JSONObject(payload)).getString("container"), Container.class)).getId()) && PropertyValidator.isValid((Object)(sessionBoardId = jObj.getString("sessionBoardId")))) {
                List itemSyncMappers = null;
                String teamContainersJson = jObj.getString("teamContainers");
                itemSyncMappers = (List)mapper.readValue(teamContainersJson, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, ItemSyncMapper.class));
                SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
                List containers = sessionBoard.getContainers();
                if (PropertyValidator.isValid((Collection)containers)) {
                    for (int i = 0; i < containers.size(); ++i) {
                        if (!((Container)containers.get(i)).getId().equals(container.getId())) continue;
                        containers.remove(i);
                    }
                    sessionBoard.setContainers(containers);
                    this.sessionBoardRepository.save((Object)sessionBoard);
                    List teamContainers = this.teamContainerRepository.findByContainer_Id(container.getId());
                    if (PropertyValidator.isValid((Collection)teamContainers)) {
                        List items = this.itemRepository.findByTeamContainersIn(teamContainers);
                        if (PropertyValidator.isValid((Collection)items)) {
                            for (int i = 0; i < items.size(); ++i) {
                                List itemTeamContainers;
                                List newItemTeamContainers = itemTeamContainers = ((Item)items.get(i)).getTeamContainers();
                                for (int j = 0; j < itemTeamContainers.size(); ++j) {
                                    int tcIndex = j;
                                    TeamContainer tc = teamContainers.stream().filter(lt -> lt.getId().equals(((TeamContainer)itemTeamContainers.get(tcIndex)).getId())).findAny().orElse(null);
                                    if (!PropertyValidator.isValid((Object)tc)) continue;
                                    newItemTeamContainers.remove(j);
                                    teamContainers.remove(tc);
                                }
                                ((Item)items.get(i)).setTeamContainers(newItemTeamContainers);
                            }
                            this.itemRepository.save((Iterable)items);
                        }
                        this.teamContainerRepository.save((Iterable)teamContainers);
                    }
                    this.containerRepository.delete((Serializable)((Object)container.getId()));
                    if (PropertyValidator.isValid((Collection)itemSyncMappers)) {
                        this.itemSyncMapperRepository.delete((Iterable)itemSyncMappers);
                    }
                    responseJson.put("success", true);
                    responseJson.put("data", (Boolean)container);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/filtersOnly"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getJiraFilters(@RequestBody String request) {
        try {
            HashMap<String, Serializable> data;
            block9: {
                AlmAccount almAcc;
                Gson gson = new Gson();
                50 T = new /* Unavailable Anonymous Inner Class!! */;
                HashMap reqbody = (HashMap)gson.fromJson(request, T.getType());
                data = new HashMap<String, Serializable>();
                String almAccId = (String)reqbody.get("almAccountId");
                String searchText = (String)reqbody.get("searchText");
                String searchType = (String)reqbody.get("searchType");
                double startAtValue = 0.0;
                if (reqbody.get("startAt") != null) {
                    startAtValue = (Double)reqbody.get("startAt");
                }
                int startAt = (int)Math.round(startAtValue);
                if (almAccId != null && PropertyValidator.isValid((Object)(almAcc = AlmUtils.getALMAcount((String)almAccId, (AlmAccountRepository)this.almAccountRepository)))) {
                    try {
                        if ("id".equals(searchType)) {
                            JiraFilter filter = this.almSyncService.retrieveJiraFilter(searchText, almAcc);
                            ArrayList<JiraFilter> filters = new ArrayList<JiraFilter>();
                            if (PropertyValidator.isValid((Object)filter)) {
                                filters.add(filter);
                            }
                            data.put("filters", filters);
                            data.put("totalCount", Integer.valueOf(filters.size()));
                        } else {
                            Map filtersMap = this.aLMSyncService.retrievePaginatedJiraFilterList(almAcc, searchText, startAt);
                            data.put("filters", (Serializable)filtersMap.get("filters"));
                            data.put("favourite", (Serializable)filtersMap.get("favourite"));
                            data.put("totalCount", (Serializable)filtersMap.get("totalCount"));
                        }
                    }
                    catch (Exception e) {
                        String err = StringUtils.getTraceString((Throwable)e);
                        LOGGER.error("Error While fetching paginated Jira filters" + err);
                        if (!(e instanceof ViztrendJiraException)) break block9;
                        ViztrendJiraException vjr = (ViztrendJiraException)((Object)e);
                        AlmError almerr = new AlmError();
                        almerr.setAlmErrorMessage(vjr.getCode() == 504 ? "504 Gateway Time-out" : vjr.getMessage());
                        almerr.setHttpErrorCode(vjr.getCode());
                        throw new ViztrendJiraException(vjr.getCode(), vjr.getMessage(), almerr);
                    }
                }
            }
            return new ResponseEntity(data, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(Arrays.toString(e.getStackTrace()));
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/fetchJiraProjectsnBords"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getJiraProjectnBoardList(@RequestBody String requestStr) {
        Gson gson = new Gson();
        HashMap jiraApiRespoonse = new HashMap<String, Object>();
        51 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)gson.fromJson(requestStr, T.getType());
        String almAccId = (String)reqbody.get("almAccountId");
        String fetchType = (String)reqbody.get("fetchType");
        String itemName = reqbody.get("searchtext") != null ? (String)reqbody.get("searchtext") : "";
        double startAtValue = 0.0;
        if (reqbody.get("startAt") != null) {
            startAtValue = (Double)reqbody.get("startAt");
        }
        int startAt = (int)Math.round(startAtValue);
        if (almAccId != null) {
            try {
                AlmAccount almAcc = AlmUtils.getALMAcount((String)almAccId, (AlmAccountRepository)this.almAccountRepository);
                if (PropertyValidator.isValid((Object)almAcc)) {
                    if (fetchType.equals("projects")) {
                        jiraApiRespoonse = this.aLMSyncService.retrieveJiraPaginatedProjects(almAcc, itemName, startAt);
                    } else if (fetchType.equals("boards")) {
                        jiraApiRespoonse = this.aLMSyncService.retrievePaginatedJiraBoardList(almAcc, itemName, startAt);
                    }
                }
            }
            catch (Exception e) {
                String err = StringUtils.getTraceString((Throwable)e);
                LOGGER.error(err);
                if (e instanceof ViztrendJiraException) {
                    jiraApiRespoonse.put("kendisError", ((ViztrendJiraException)((Object)e)).getAlmError());
                }
                jiraApiRespoonse.put("kendisError", e);
            }
        }
        return new ResponseEntity(jiraApiRespoonse, HttpStatus.OK);
    }

    @RequestMapping(value={"/filtersWithMeta"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getJiraFiltersWithMeta(@RequestBody String requestStr) {
        try {
            AlmAccount almAcc;
            Gson gson = new Gson();
            52 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)gson.fromJson(requestStr, T.getType());
            String almAccId = (String)reqbody.get("almAccountId");
            String requestId = (String)reqbody.get("requestId");
            String metaMap = (String)reqbody.get("metaMap");
            boolean jobStarted = false;
            if (almAccId != null && PropertyValidator.isValid((Object)(almAcc = AlmUtils.getALMAcount((String)almAccId, (AlmAccountRepository)this.almAccountRepository)))) {
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                jobStarted = true;
            }
            if (!jobStarted) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("push", "Self");
                data.put("type", "Board");
                data.put("metaMap", metaMap);
                this.pushResponseRepository.save((Object)new PushResponse(requestId, gson.toJson(data), Boolean.valueOf(true)));
            }
            return new ResponseEntity(new HashMap(), HttpStatus.OK);
        }
        catch (Exception e) {
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error(err);
            return new ResponseEntity((Object)err, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get/jiraMeta"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getJiraMeta(@RequestBody String requestStr) {
        Gson g = new Gson();
        HashMap<String, Session> responseJson = new HashMap<String, Session>();
        54 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(requestStr, T.getType());
        Gson gson = new Gson();
        String sessionId = (String)reqbody.get("sessionId");
        String almConfigId = (String)reqbody.get("almConfigId");
        ArrayList<String> projectKeys = new ArrayList<String>();
        Object jiraProjectIssueTypes = null;
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
        AlmConfigurations almConfig = (AlmConfigurations)this.almConfigurationsRepository.findOne((Serializable)((Object)almConfigId));
        if (PropertyValidator.isValid((Object)session)) {
            if (PropertyValidator.isValid((Collection)almConfig.getFeatureMappings())) {
                for (BacklogMapping projectLinkMapping : almConfig.getFeatureMappings()) {
                    if (!PropertyValidator.isValid((Object)projectLinkMapping.getProjectKey()) || projectKeys.contains(projectLinkMapping.getProjectKey())) continue;
                    projectKeys.add(projectLinkMapping.getProjectKey());
                }
            }
            if (PropertyValidator.isValid((Collection)almConfig.getTeamMappings())) {
                for (BacklogMapping projectLinkMapping : almConfig.getTeamMappings()) {
                    if (!PropertyValidator.isValid((Object)projectLinkMapping.getProjectKey()) || projectKeys.contains(projectLinkMapping.getProjectKey())) continue;
                    projectKeys.add(projectLinkMapping.getProjectKey());
                }
            }
        }
        this.fetchJiraIssueTypes(almConfig.getAlmAccount().getId(), projectKeys, responseJson);
        responseJson.put("session", session);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getJiraStatuses"}, method={RequestMethod.POST})
    public List<Status> getJiraStatuses(@RequestBody String requestStr) {
        Gson g = new Gson();
        HashMap responseJson = new HashMap();
        55 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(requestStr, T.getType());
        Gson gson = new Gson();
        String sessionId = (String)reqbody.get("sessionId");
        String projKey = (String)reqbody.get("projKey");
        return this.statusRepository.findByJiraProjKeyAndSessionId(projKey, sessionId);
    }

    @RequestMapping(value={"/filter/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveFilter(@RequestBody String requestStr) throws Exception {
        Gson g = new Gson();
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        56 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(requestStr, T.getType());
        Gson gson = new Gson();
        String filterJson = (String)reqbody.get("filter");
        String almConfigId = (String)reqbody.get("almConfigId");
        String sessionBoardId = (String)reqbody.get("boardId");
        String sessionId = (String)reqbody.get("sessionId");
        String linkMappingJson = (String)reqbody.get("linkMappings");
        String syncId = (String)reqbody.get("syncId");
        JiraFilter filter = null;
        ObjectMapper map = new ObjectMapper();
        try {
            filter = (JiraFilter)map.readValue(filterJson, JiraFilter.class);
        }
        catch (JsonParseException jsonParseException) {
        }
        catch (JsonMappingException jsonMappingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            57 P = new /* Unavailable Anonymous Inner Class!! */;
            Collection linkMappings = (Collection)gson.fromJson(linkMappingJson, P.getType());
            AlmConfigurations almConfig = (AlmConfigurations)this.almConfigurationsRepository.findOne((Serializable)((Object)almConfigId));
            ArrayList<JiraFilter> featureFilters = almConfig.getFeatureFilter();
            if (!PropertyValidator.isValid((Collection)featureFilters)) {
                featureFilters = new ArrayList<JiraFilter>();
            }
            if (!PropertyValidator.isValid((Collection)almConfig.getFeatureMappings())) {
                almConfig.setFeatureMappings(new ArrayList());
            }
            if (PropertyValidator.isValid((Object)filter)) {
                filter.setFilterFetchedBy(JiraUtils.getProfileAlmUser((AlmAccount)almConfig.getAlmAccount()));
                for (JiraFilter jiraFilter : featureFilters) {
                    if (filter.getId() == null || !filter.getId().equals(jiraFilter.getId())) continue;
                    throw new KendisException("JiraFilter", "This filter is already saved");
                }
                featureFilters.add(filter);
            }
            almConfig.setFeatureFilter(featureFilters);
            ArrayList<String> projectKeys = new ArrayList<String>();
            for (BacklogMappingLinks backlogMappingLinks : linkMappings) {
                boolean mappingFound = false;
                for (BacklogMapping projectLinkMapping : almConfig.getFeatureMappings()) {
                    if (!backlogMappingLinks.getProjectKey().equals(projectLinkMapping.getProjectKey())) continue;
                    mappingFound = true;
                    break;
                }
                if (mappingFound) continue;
                projectKeys.add(backlogMappingLinks.getProjectKey());
            }
            if (PropertyValidator.isValid(projectKeys)) {
                this.almSyncService.retrieveJiraProjectFields(almConfig.getAlmAccount(), String.join((CharSequence)",", projectKeys), Boolean.valueOf(true), Boolean.valueOf(false));
            }
            almConfig.addInFeatureMappings(linkMappings);
            this.almConfigurationsRepository.save((Object)almConfig);
            this.almSyncService.retrieveDataAgainstJiraFilter2(filter, almConfigId, new ArrayList(linkMappings), sessionBoardId, syncId, sessionId, null, false, Boolean.valueOf(false), false, false, null);
            filter.setLastSyncDate(new Date());
            almConfig.addInFeatureMappings(linkMappings);
            this.almConfigurationsRepository.save((Object)almConfig);
            this.userService.setOnboardingMeta("Get_Features_from_Jira", true);
            if (PropertyValidator.isValid((Object)filter)) {
                AuditLog auditLogObject = new AuditLog(sessionBoardId, "FILTER_ADD", null);
                JSONObject auditResource = new JSONObject();
                auditResource.put("name", (Object)filter.getName());
                auditResource.put("jiraId", (Object)filter.getId());
                auditLogObject.setAuditResource(auditResource.toString());
                this.auditLogRepository.save((Object)auditLogObject);
            }
        }
        catch (ViztrendJiraException vJe) {
            responseJson.put("kendisError", vJe.getAlmError());
        }
        catch (Exception vJe) {
            responseJson.put("kendisError", vJe);
        }
        KendisUtils.onResyncComplete((String)syncId, (String)"/resync/feature", (String)g.toJson(new HashMap()), (Boolean)false, null, (String)sessionBoardId, (PushResponseRepository)this.pushResponseRepository);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/filter/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteFilter(@RequestBody String requestStr) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("success", false);
        try {
            Gson gson = new Gson();
            58 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)gson.fromJson(requestStr, T.getType());
            String filterId = (String)reqbody.get("filterId");
            String almConfigId = (String)reqbody.get("almConfigId");
            String sessionBoardId = (String)reqbody.get("sessionBoardId");
            Boolean deleteWithContent = (Boolean)reqbody.get("deleteWithContent");
            if (Boolean.TRUE.equals(deleteWithContent)) {
                List parentItems = this.itemRepository.findByJiraFilterAndSessionBoardsIdInAndType(filterId, sessionBoardId, Item.FEATURE);
                List deletedList = this.itemRepository.deleteByParentIn(parentItems);
                this.itemRepository.delete((Iterable)parentItems);
                parentItems.addAll(deletedList);
                this.customRepositoryImpl.saveLogsForDeletedItems(parentItems);
            } else {
                this.customRepository.removeItemsJraFilterId(filterId, sessionBoardId);
            }
            AlmConfigurations almConfig = (AlmConfigurations)this.almConfigurationsRepository.findOne((Serializable)((Object)almConfigId));
            List featureFilters = almConfig.getFeatureFilter();
            JiraFilter featureFilter = null;
            if (PropertyValidator.isValid((Collection)featureFilters)) {
                for (int i = 0; i < featureFilters.size(); ++i) {
                    if (!((JiraFilter)featureFilters.get(i)).getId().equalsIgnoreCase(filterId)) continue;
                    featureFilter = (JiraFilter)featureFilters.get(i);
                    featureFilters.remove(i);
                }
                almConfig.setFeatureFilter(featureFilters);
            }
            if (PropertyValidator.isValid(featureFilter)) {
                AuditLog auditLogObject = new AuditLog(sessionBoardId, "FILTER_REMOVED", null);
                JSONObject auditResource = new JSONObject();
                auditResource.put("name", (Object)featureFilter.getName());
                auditResource.put("jiraId", (Object)featureFilter.getId());
                auditLogObject.setAuditResource(auditResource.toString());
                this.auditLogRepository.save((Object)auditLogObject);
            }
            this.almConfigurationsRepository.save((Object)almConfig);
            responseJson.put("filterId", filterId);
            responseJson.put("success", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/alm/save"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<Object> linkAlmAccounts(@RequestBody String payload) {
        block25: {
            try {
                HashMap<String, Object> responseJson = new HashMap<String, Object>();
                responseJson.put("success", false);
                if (!PropertyValidator.isValid((Object)payload)) break block25;
                JSONObject jsonObj = new JSONObject(payload);
                ObjectMapper mapper = new ObjectMapper();
                AlmAccount almaccount = (AlmAccount)mapper.readValue(jsonObj.getString("almAccount"), AlmAccount.class);
                String almConfigId = jsonObj.getString("almConfigId");
                String sessionId = jsonObj.getString("sessionId");
                Boolean isTFS = PropertyValidator.isValid((Object)almaccount.getType()) && almaccount.getType().equals("tfs") ? Boolean.valueOf(true) : Boolean.valueOf(false);
                if (!PropertyValidator.isValid((Object)almaccount.getId())) {
                    try {
                        HashMap<String, String> param = new HashMap<String, String>();
                        param.put("url", almaccount.getUrl());
                        param.put("username", almaccount.getUsername());
                        param.put("password", almaccount.getPassword());
                        if (Boolean.TRUE.equals(almaccount.getIsPatOn())) {
                            param.put("isPatOn", "true");
                        }
                        if (!isTFS.booleanValue()) {
                            param.put("useConnect", String.valueOf(almaccount.isUsingJiraConnect()));
                            if (almaccount.isUsingJiraConnect()) {
                                param.put("atlassianHostDomainId", jsonObj.getString("atlassianHostDomainId"));
                                param.put("jiraHostId", jsonObj.getString("jiraHostId"));
                                param.put("jiraHostUrl", jsonObj.getString("jiraHostUrl"));
                            }
                            this.aLMSyncService.retrieveJiraFields(mapper.writeValueAsString(param));
                        }
                    }
                    catch (ViztrendJiraException vJe) {
                        return new ResponseEntity((Object)vJe.getAlmError(), HttpStatus.BAD_REQUEST);
                    }
                    if (!isTFS.booleanValue()) {
                        HashMap savedAlmAccountMap = this.aLMSyncService.linkJiraAccount(almaccount);
                        AlmAccount saveAlmAccount = (AlmAccount)savedAlmAccountMap.get("almAccount");
                        almaccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)saveAlmAccount.getId()));
                    } else {
                        almaccount = (AlmAccount)this.almAccountRepository.save((Object)almaccount);
                    }
                }
                Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
                AlmConfigurations almConfiguration = null;
                TFSAlmConfigurations tsfAlmConfiguration = null;
                ArrayList<AlmConfigurations> almConfigs = null;
                if (!isTFS.booleanValue()) {
                    almConfiguration = new AlmConfigurations();
                    almConfigs = session.getAlmConfigurations();
                    if (PropertyValidator.isValid((Object)almConfigId)) {
                        almConfiguration = (AlmConfigurations)this.almConfigurationsRepository.findOne((Serializable)((Object)almConfigId));
                        if (PropertyValidator.isValid((Object)almConfiguration)) {
                            almConfiguration.setAlmAccount(almaccount);
                        }
                        almConfiguration = (AlmConfigurations)this.almConfigurationsRepository.save((Object)almConfiguration);
                    } else {
                        almConfiguration.setAlmAccount(almaccount);
                        almConfiguration = (AlmConfigurations)this.almConfigurationsRepository.save((Object)almConfiguration);
                    }
                    if (PropertyValidator.isValid((Collection)almConfigs)) {
                        almConfigs.set(0, almConfiguration);
                    } else {
                        almConfigs = new ArrayList<AlmConfigurations>();
                        almConfigs.add(almConfiguration);
                    }
                } else {
                    tsfAlmConfiguration = new TFSAlmConfigurations();
                    tsfAlmConfiguration.setAlmAccount(almaccount);
                    tsfAlmConfiguration = (TFSAlmConfigurations)this.tfsAlmConfigurationsRepository.save((Object)tsfAlmConfiguration);
                }
                String jiraBaseUrl = almaccount.getUrl();
                if (!jiraBaseUrl.contains("/browse") || !jiraBaseUrl.contains("browse")) {
                    session.setJiraBaseURL(jiraBaseUrl + "/browse");
                } else {
                    session.setJiraBaseURL(jiraBaseUrl);
                }
                if (!isTFS.booleanValue()) {
                    session.setAlmConfigurations(almConfigs);
                    responseJson.put("almConfiguration", almConfiguration);
                } else {
                    responseJson.put("tsfAlmConfiguration", tsfAlmConfiguration);
                    session.setTfsAlmConfigurations(tsfAlmConfiguration);
                }
                session.setAlmEnabled(Boolean.valueOf(true));
                this.sessionRepository.save((Object)session);
                responseJson.put("success", true);
                responseJson.put("jiraBaseUrl", jiraBaseUrl);
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            catch (ViztrendJiraException vJe) {
                return new ResponseEntity((Object)vJe.getAlmError(), HttpStatus.BAD_REQUEST);
            }
            catch (JSONException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            catch (JsonParseException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            catch (JsonMappingException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            catch (IOException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        AlmError almerr = new AlmError();
        almerr.setAlmErrorMessage("Invalid input parameters");
        almerr.setHttpErrorCode(Integer.valueOf(400));
        return new ResponseEntity((Object)almerr, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/syncsetting/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveSyncSetting(@RequestBody String requestStr) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("success", false);
        try {
            Gson g = new Gson();
            59 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)g.fromJson(requestStr, T.getType());
            String featureMappingStr = reqbody.get("featureMapObj").toString();
            String almConfigId = (String)reqbody.get("almConfigId");
            String sessionId = (String)reqbody.get("sessionId");
            BacklogMapping featureMappingObj = (BacklogMapping)g.fromJson(featureMappingStr, BacklogMapping.class);
            AlmConfigurations almConfig = (AlmConfigurations)this.almConfigurationsRepository.findOne((Serializable)((Object)almConfigId));
            ArrayList<BacklogMapping> featureMappings = almConfig.getFeatureMappings();
            ResyncParamsVO syncUitls = new ResyncParamsVO();
            Boolean edit = false;
            if (!PropertyValidator.isValid((Collection)featureMappings)) {
                featureMappings = new ArrayList<BacklogMapping>();
            }
            for (int i = 0; i < featureMappings.size(); ++i) {
                if (!((BacklogMapping)featureMappings.get(i)).getBacklogId().equals(featureMappingObj.getBacklogId())) continue;
                edit = true;
                featureMappings.remove(i);
                featureMappings.add(i, featureMappingObj);
            }
            if (edit.equals(false)) {
                featureMappings.add(featureMappingObj);
            }
            almConfig.setFeatureMappings(featureMappings);
            this.almConfigurationsRepository.save((Object)almConfig);
            this.almSyncService.retrieveJiraProjectFields(almConfig.getAlmAccount(), featureMappingObj.getProjectKey(), Boolean.valueOf(true), Boolean.valueOf(false));
            ArrayList<String> projectKeys = new ArrayList<String>();
            projectKeys.add(featureMappingObj.getProjectKey());
            this.fetchJiraIssueTypes(almConfig.getAlmAccount().getId(), projectKeys, responseJson);
            responseJson.put("projectKey", featureMappingObj.getProjectKey());
            responseJson.put("featureMapping", featureMappingObj);
            responseJson.put("success", true);
            if (!this.statusRepository.existsByJiraProjKeyAndSessionId(featureMappingObj.getProjectKey(), sessionId)) {
                responseJson.put("statuses", syncUitls.retrieveAndConvertJiraStatuses(featureMappingObj.getProjectKey(), almConfig.getAlmAccount(), sessionId, null, false, this.importUtil, this.statusRepository));
            }
        }
        catch (Exception e) {
            LOGGER.error("saveSyncSetting failed with exeption");
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/syncsetting/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteSyncSetting(@RequestBody String requestStr) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("success", false);
        try {
            Gson g = new Gson();
            60 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)g.fromJson(requestStr, T.getType());
            String featureMappingId = (String)reqbody.get("featureMappingId");
            String almConfigId = (String)reqbody.get("almConfigId");
            AlmConfigurations almConfig = (AlmConfigurations)this.almConfigurationsRepository.findOne((Serializable)((Object)almConfigId));
            List featureMappings = almConfig.getFeatureMappings();
            for (int i = 0; i < featureMappings.size(); ++i) {
                if (!((BacklogMapping)featureMappings.get(i)).getBacklogId().equals(featureMappingId)) continue;
                featureMappings.remove(i);
            }
            almConfig.setFeatureMappings(featureMappings);
            this.almConfigurationsRepository.save((Object)almConfig);
            responseJson.put("featureMappingId", featureMappingId);
            responseJson.put("success", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/save/jiralink"})
    @ResponseBody
    public ResponseEntity<Object> saveJiraLink(@RequestBody String requestBody) {
        try {
            Gson gson = new Gson();
            61 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestMap = (HashMap)gson.fromJson(requestBody, T.getType());
            String jiraLinkJson = (String)requestMap.get("jiraLink");
            String itemJson = (String)requestMap.get("item");
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            ItemJiraDependency dependency = (ItemJiraDependency)mapper.readValue(jiraLinkJson, mapper.getTypeFactory().constructType(ItemJiraDependency.class));
            List oldLink = this.itemJiraDependencyRepository.findByJiraDependencyIdAndSessionBoardId(dependency.getJiraDependencyId(), dependency.getSessionBoardId());
            ItemLink itemLink = null;
            if (PropertyValidator.isValid((Collection)oldLink)) {
                for (ItemJiraDependency link : oldLink) {
                    this.almSyncService.setLinkMeta(link, dependency);
                    if (!dependency.getWfStatus().getCategory().equalsIgnoreCase("Done")) continue;
                    link.setResolvedOn(new Date());
                }
                itemLink = (ItemLink)this.almSyncService.syncKendisAndAlmLink(oldLink.get(0));
                this.itemJiraDependencyRepository.save((Iterable)oldLink);
            }
            HashMap response = new HashMap();
            response.put("jiraLink", oldLink);
            response.put("kendisLink", itemLink);
            HashMap dependencyStatusByJiraId = new HashMap();
            if (PropertyValidator.isValid((Object)((ItemJiraDependency)oldLink.get(0)).getWfStatus())) {
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(((ItemJiraDependency)oldLink.get(0)).getJiraDependencyId());
                if (((ItemJiraDependency)oldLink.get(0)).getWfStatus().getCategory().equalsIgnoreCase("Done")) {
                    dependencyStatusByJiraId.put("Resolved", ids);
                } else {
                    dependencyStatusByJiraId.put("Open", ids);
                }
            }
            HashMap<String, Object> metaMap = new HashMap<String, Object>();
            JSONObject pushJson = new JSONObject();
            Item item = (Item)mapper.readValue(itemJson, mapper.getTypeFactory().constructType(Item.class));
            pushJson.put("isJira", true);
            pushJson.put("isWebhook", true);
            pushJson.put("type", (Object)item.getType());
            pushJson.put("id", (Object)item.getId());
            pushJson.put("boardId", (Object)dependency.getSessionBoardId());
            metaMap.put("event", "itemLinksUpdated");
            metaMap.put("boardId", dependency.getSessionBoardId());
            metaMap.put("boardid", dependency.getSessionBoardId());
            metaMap.put("isJira", Boolean.TRUE);
            try {
                pushJson.put("metaMap", (Object)gson.toJson(metaMap));
            }
            catch (JSONException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            pushJson.put("jiraDependencyIds", (Object)gson.toJson(dependencyStatusByJiraId));
            pushJson.put("item", (Object)gson.toJson((Object)item));
            Gson gson2 = new GsonBuilder().registerTypeAdapter(Date.class, (json, typeOfT, context) -> new Date(json.getAsJsonPrimitive().getAsLong())).registerTypeAdapter(Date.class, (date, type, jsonSerializationContext) -> new JsonPrimitive((Number)date.getTime())).create();
            pushJson.put("jiraLink", (Object)gson2.toJson(oldLink.get(0)));
            String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
            PushSender.sendMsg((String)cid, (String)pushJson.toString());
            return new ResponseEntity(response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/objective/{toggle}/{boardId}"})
    @ResponseBody
    public ResponseEntity<Object> updateJiraNotifySetting(@PathVariable(value="toggle") String toggle, @PathVariable(value="boardId") String boardId) {
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)boardId));
        session.setUseObjectives(Boolean.valueOf(Boolean.parseBoolean(toggle)));
        this.sessionRepository.save((Object)session);
        return new ResponseEntity((Object)toggle, HttpStatus.OK);
    }

    @RequestMapping(value={"/copyusers"})
    public void dbSettlement() {
        Company company = new Company();
        company.setTenant("57441417-89c5-4afb-ad13-e586a0010678");
        company.setName("parkmobile");
        company.setUrl("parkmobile");
        company.setUrlPrefix("parkmobile");
        company = (Company)this.companyRepository.save((Object)company);
        List users = this.userRepository.findAll();
        for (User user : users) {
            UserCompany userCompany = new UserCompany();
            company.setId("5b7976f8e21b8469c2ec132b");
            userCompany.setCompany(company);
            userCompany.setIsActive(user.getIsActive());
            userCompany.setIsAdmin(user.getIsSuperAdmin());
            if (user.getIsAdmin().booleanValue() && user.getIsSuperAdmin().booleanValue()) {
                userCompany.setIsOwner(Boolean.valueOf(true));
            }
            String[] fullName = user.getFullName().split(" ");
            user.setFirstName(fullName[0]);
            if (fullName.length > 1) {
                user.setLastName(fullName[1]);
            }
            user.setUserCompanies(new ArrayList());
            user.getUserCompanies().add(userCompany);
        }
        this.userRepository.save((Iterable)users);
        List almAccounts = this.almAccountRepository.findAll();
        for (AlmAccount almAccount : almAccounts) {
            almAccount.setTenant(company.getTenant());
        }
        this.almAccountRepository.save((Iterable)almAccounts);
    }

    public void markadmin() {
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        User userObject = (User)this.userRepository.findOne((Serializable)((Object)user.getId()));
        ((UserCompany)userObject.getUserCompanies().get(0)).setIsAdmin(Boolean.valueOf(true));
        this.userRepository.save((Object)userObject);
    }

    @RequestMapping(value={"/baseurl"})
    @ResponseBody
    public ResponseEntity<Object> setBaseUrl(@RequestParam String baseUrl) {
        baseUrl = baseUrl.substring(0, baseUrl.lastIndexOf("/"));
        UserContextUtil.getUserContext().getCurrentCompany().setUrl(baseUrl);
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/jirasearch"})
    @ResponseBody
    public ResponseEntity<Object> jiraSearch(@RequestBody String requestPayload) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        Gson g = new Gson();
        62 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(requestPayload, T.getType());
        String url = (String)reqbody.get("url");
        String queryStr = (String)reqbody.get("query");
        String almAccountId = (String)reqbody.get("almAccountId");
        String fieldKey = (String)reqbody.get("fieldKey");
        String fieldType = (String)reqbody.get("fieldType");
        String component = (String)reqbody.get("component");
        url = url + queryStr;
        AlmAccount almAccount = AlmUtils.getALMAcount((String)almAccountId, (AlmAccountRepository)this.almAccountRepository);
        try {
            String result = this.almSyncService.searchFromJira(url, almAccount);
            if (fieldKey.equals("reporter") || fieldKey.equals("assignee")) {
                63 P = new /* Unavailable Anonymous Inner Class!! */;
                ArrayList param = (ArrayList)g.fromJson(result, P.getType());
                responseJson.put("result", param);
            } else {
                HashMap param = (HashMap)g.fromJson(result, T.getType());
                responseJson.put("result", param);
            }
        }
        catch (ViztrendJiraException vJe) {
            responseJson.put("kendisError", vJe.getAlmError());
        }
        responseJson.put("fieldKey", fieldKey);
        responseJson.put("fieldType", fieldType);
        responseJson.put("component", component);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/jiraButtons/{boardId}"})
    @ResponseBody
    public ResponseEntity<Object> savejiraButtons(@PathVariable(value="boardId") String boardId, @RequestBody HashMap<String, Boolean> jiraButtons) {
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)boardId));
        session.setJiraButtons(jiraButtons);
        this.sessionRepository.save((Object)session);
        return new ResponseEntity(jiraButtons, HttpStatus.OK);
    }

    @RequestMapping(value={"/boardsyncstatus/{boardId}"})
    @ResponseBody
    public ResponseEntity<Object> checkBoardSyncStatus(@PathVariable(value="boardId") String boardId) {
        return new ResponseEntity((Object)SystemVarsUtils.chkLockSync((String)boardId), HttpStatus.OK);
    }

    @RequestMapping(value={"/deleteJiraDependency"})
    @ResponseBody
    public ResponseEntity<Object> deleteJiraDependency(@RequestBody HashMap<String, String> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String issueLinkId = requestBody.get("id");
        String jiraIssueLinkId = requestBody.get("jiraId");
        String sessionBoardId = requestBody.get("sessionBoardId");
        String itemId = requestBody.get("itemId");
        String syncId = requestBody.get("syncId");
        String almAccountId = requestBody.get("almAccountId");
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        List linkedItems = new ArrayList();
        ArrayList<String> depIds = new ArrayList<String>();
        List itemJiraDependencies = this.itemJiraDependencyRepository.findByJiraDependencyIdAndSessionBoardId(jiraIssueLinkId, sessionBoardId);
        if (PropertyValidator.isValid((Collection)itemJiraDependencies)) {
            for (ItemJiraDependency itemJiraDependency : itemJiraDependencies) {
                depIds.add(itemJiraDependency.getId());
            }
            if (PropertyValidator.isValid(depIds) && PropertyValidator.isValid(linkedItems = this.itemRepository.findByJiraDependencies_IdIn(depIds))) {
                for (Item item2 : linkedItems) {
                    if (!PropertyValidator.isValid((Collection)item2.getJiraDependencies())) continue;
                    item2.getJiraDependencies().removeIf(dep -> depIds.contains(dep.getId()));
                }
                this.itemRepository.save(linkedItems);
                this.itemJiraDependencyRepository.delete((Iterable)itemJiraDependencies);
            }
        }
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        ObjectMapper mapper = new ObjectMapper();
        String itemsStr = null;
        try {
            itemsStr = mapper.writeValueAsString(linkedItems);
        }
        catch (JsonProcessingException e) {
            LOGGER.trace(" :: Failed to convert items to json ");
        }
        JSONObject pushJson = new JSONObject();
        HashMap<String, Object> metaMap = new HashMap<String, Object>();
        try {
            Gson gson = new Gson();
            pushJson.put("isJira", true);
            pushJson.put("isWebhook", true);
            pushJson.put("jiraId", (Object)jiraIssueLinkId);
            pushJson.put("jiraDependencyId", (Object)((ItemJiraDependency)itemJiraDependencies.get(0)).getId());
            pushJson.put("sourceItemId", (Object)((ItemJiraDependency)itemJiraDependencies.get(0)).getSourceItemId());
            pushJson.put("targetItemId", (Object)((ItemJiraDependency)itemJiraDependencies.get(0)).getTargetItemId());
            metaMap.put("event", "deleteJiraLink");
            metaMap.put("isJira", Boolean.TRUE);
            metaMap.put("syncId", syncId);
            metaMap.put("boardId", ((ItemJiraDependency)itemJiraDependencies.get(0)).getSessionBoardId());
            pushJson.put("metaMap", (Object)gson.toJson(metaMap));
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        PushSender.sendMsg((String)cid, (String)pushJson.toString());
        responseJson.put("id", issueLinkId);
        responseJson.put("itemId", itemId);
        responseJson.put("items", itemsStr);
        responseJson.put("success", true);
        responseJson.put("removedLinksIds", depIds);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/dashboard/getLinksLog/{sessionBoardId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getLinksLog(@PathVariable(value="sessionBoardId") String sessionBoardId) {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        SessionBoard sessionBoard = null;
        List logs = this.itemLogRepository.findBySessionBoardAndItemTypeOrderByEventTimeAsc(sessionBoard, "ItemLink");
        responseJson.put("log", logs);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/old-links"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getUnLinkedDependencies(@RequestBody HashMap<String, Object> param) {
        try {
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            HashMap<String, Object> response = new HashMap<String, Object>();
            ArrayList<Boolean> archive = new ArrayList<Boolean>();
            archive.add(true);
            archive.add(false);
            String sessionBoardId = (String)param.get("sessionBoardId");
            List sessionBoardIds = (List)param.get("sessionBoardIds");
            List ids = (List)param.get("linkIds");
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoardId").in((Collection)sessionBoardIds));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").not().in((Collection)KendisUtils.getListAsObjectIds((Collection)ids)));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").in(archive));
            DBCursor cursor = this.customRepositoryImpl.getMongoTemplate().getCollection("itemLink").find(query.getQueryObject());
            List links = cursor.toArray();
            HashMap tcMap = new HashMap();
            HashSet<String> tcIds = new HashSet<String>();
            HashMap<String, Boolean> idsMap = new HashMap<String, Boolean>();
            for (int i = 0; i < links.size(); ++i) {
                int j;
                String id = String.valueOf(((DBObject)links.get(i)).get("_id"));
                ((DBObject)links.get(i)).put("id", (Object)id);
                DBRef wfStatusRef = (DBRef)((DBObject)links.get(i)).get("wfStatus");
                DBRef reporterRef = (DBRef)((DBObject)links.get(i)).get("reporter");
                DBRef responsibleRef = (DBRef)((DBObject)links.get(i)).get("responsible");
                if (wfStatusRef != null) {
                    ((DBObject)links.get(i)).put("wfStatus", (Object)String.valueOf(wfStatusRef.getId()));
                }
                if (reporterRef != null) {
                    ((DBObject)links.get(i)).put("reporter", (Object)String.valueOf(reporterRef.getId()));
                }
                if (responsibleRef != null) {
                    ((DBObject)links.get(i)).put("responsible", (Object)String.valueOf(responsibleRef.getId()));
                }
                tcIds.add((String)((DBObject)links.get(i)).get("sourceTeamContainerId"));
                tcIds.add((String)((DBObject)links.get(i)).get("targetTeamContainerId"));
                idsMap.put(id, true);
                ArrayList<String> conversationsIds = new ArrayList<String>();
                List conversationsRef = (List)((DBObject)links.get(i)).get("conversations");
                List watcherListRef = (List)((DBObject)links.get(i)).get("watcherList");
                ArrayList<Watcher> watchers = new ArrayList<Watcher>();
                if (PropertyValidator.isValid((Collection)conversationsRef)) {
                    List conv;
                    for (j = 0; j < conversationsRef.size(); ++j) {
                        conversationsIds.add(String.valueOf(((DBRef)conversationsRef.get(j)).getId()));
                    }
                    if (PropertyValidator.isValid(conversationsIds) && PropertyValidator.isValid((Collection)(conv = (List)this.conversationRepository.findAll(conversationsIds)))) {
                        ((DBObject)links.get(i)).put("conversations", (Object)conv);
                    }
                }
                if (!PropertyValidator.isValid((Collection)watcherListRef)) continue;
                for (j = 0; j < watcherListRef.size(); ++j) {
                    watchers.add(new Watcher(String.valueOf(((DBRef)watcherListRef.get(j)).getId())));
                }
                ((DBObject)links.get(i)).put("watcherList", watchers);
            }
            ArrayList<String> tenants = new ArrayList<String>();
            tenants.add(null);
            tenants.add(tenant);
            List tcs = this.teamContainerRepository.findByIdInAndTenantIn(tcIds, tenants);
            if (PropertyValidator.isValid((Collection)tcs)) {
                for (int i = 0; i < tcs.size(); ++i) {
                    tcMap.put(((TeamContainer)tcs.get(i)).getId(), tcs.get(i));
                }
            }
            response.put("lostLinks", links);
            response.put("lostTCS", tcMap);
            response.put("idsMap", idsMap);
            return new ResponseEntity(response, HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/recover/old-link"})
    public void recoverUnLinkedDependency(@RequestBody String itemLinkId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(itemLinkId)));
        DBCursor cursor = this.customRepositoryImpl.getMongoTemplate().getCollection("itemLink").find(query.getQueryObject());
        if (cursor.size() > 0) {
            DBObject link = cursor.next();
            link.put("archive", (Object)false);
            this.customRepositoryImpl.getMongoTemplate().getCollection("itemLink").save(link);
        }
    }

    @RequestMapping(value={"/remove/old-link"})
    @ResponseBody
    public ResponseEntity<Object> removeUnLinkedDependency(@RequestBody String itemLinkId) {
        WriteResult wr = this.customRepositoryImpl.getMongoTemplate().getCollection("itemLink").remove((DBObject)new BasicDBObject("_id", (Object)new ObjectId(itemLinkId)));
        return new ResponseEntity((Object)wr, HttpStatus.OK);
    }

    @RequestMapping(value={"/jira/{almAccountId}/issue/{jiraId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getJiraFields(@PathVariable(value="almAccountId") String almAccountId, @PathVariable(value="jiraId") String jiraId) {
        try {
            AlmAccount almAccount = this.almAccountRepository.findById(almAccountId);
            return new ResponseEntity((Object)this.almSyncService.retrieveJiraIssueById(jiraId, almAccount), HttpStatus.OK);
        }
        catch (Exception e) {
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error(err);
            HashMap<String, Object> responseJson = new HashMap<String, Object>();
            if (e instanceof ViztrendJiraException) {
                responseJson.put("kendisError", ((ViztrendJiraException)((Object)e)).getAlmError());
            } else {
                responseJson.put("kendisError", e);
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
    }

    @RequestMapping(value={"/refresh"}, method={RequestMethod.POST})
    @Deprecated
    public void refreshBoard(@RequestBody HashMap<String, Object> param) {
        Gson g = new Gson();
        Boolean isReadOnly = Boolean.parseBoolean("" + param.get("isReadOnly"));
        String syncId = (String)param.get("syncId");
        String sessionBoardId = (String)param.get("sessionBoardId");
        Map filterResult = new HashMap();
        AlmAccount almAccount = null;
        HashMap<String, Object> pushDate = new HashMap<String, Object>();
        try {
            filterResult = this.almSyncService.refreshData(param);
            almAccount = (AlmAccount)filterResult.get("almAccount");
            filterResult.remove("almAccount");
            pushDate.put("ReFreshInfo", filterResult);
        }
        catch (ViztrendJiraException vJe) {
            KendisUtils.onResyncError((String)syncId, (String)"/refresh", (String)vJe.getMessage(), (String)sessionBoardId, (PushResponseRepository)this.pushResponseRepository);
            pushDate.put("hasError", true);
        }
        catch (Exception e) {
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error(err);
            pushDate.put("kendisError", err);
            KendisUtils.onResyncError((String)syncId, (String)"/refresh", (String)g.toJson(pushDate), (String)sessionBoardId, (PushResponseRepository)this.pushResponseRepository);
            pushDate.put("hasError", true);
        }
        KendisUtils.onResyncComplete((String)syncId, (String)"/filter/refresh", (String)g.toJson(pushDate), (Boolean)isReadOnly, (AlmAccount)almAccount, (String)sessionBoardId, (PushResponseRepository)this.pushResponseRepository);
    }

    @RequestMapping(value={"/enableViewers/{count}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> enableViewerFeature(@PathVariable(value="count") String viewerCount) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        Company company = this.companyRepository.findById(cid);
        if (PropertyValidator.isValid((Object)company) && PropertyValidator.isValid((Object)viewerCount)) {
            company.setGuestEnabled(true);
            company.setGuestUserCount(Long.parseLong(viewerCount));
            this.companyRepository.save((Object)company);
            responseJson.put("viewers", true);
            responseJson.put("viewerCount", viewerCount);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/disableViewers"}, method={RequestMethod.GET})
    public ResponseEntity<Object> enableViewerFeature() {
        HashMap<String, Comparable<Boolean>> responseJson = new HashMap<String, Comparable<Boolean>>();
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        Company company = this.companyRepository.findById(cid);
        if (PropertyValidator.isValid((Object)company)) {
            company.setGuestEnabled(false);
            company.setGuestUserCount(0L);
            this.companyRepository.save((Object)company);
            responseJson.put("viewers", Boolean.valueOf(false));
            responseJson.put("viewerCount", Integer.valueOf(0));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-jira-fields-for-sos/{almId}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getJiraFieldsForSos(@PathVariable(value="almId") String almAccountId) {
        HashMap<String, String> responseJson = new HashMap<String, String>();
        AlmAccount almAccount = AlmUtils.getALMAcount((String)almAccountId, (AlmAccountRepository)this.almAccountRepository);
        responseJson.put("jiraFields", this.almSyncService.retrieveJiraFieldsJSON(almAccount, false));
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-jiraproject-issuetypes"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getJiraProjectMetaForItem(@RequestBody HashMap<String, Object> requestBody) {
        HashMap responseJson = new HashMap();
        String almAccountId = (String)requestBody.get("almAccountId");
        String itemId = (String)requestBody.get("itemId");
        Item item = this.itemRepository.findById(itemId);
        this.fetchItemJiraProject(almAccountId, item.getJiraProjectKey(), responseJson);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/flag-item"}, method={RequestMethod.POST})
    public ResponseEntity<Object> blockItems(@RequestBody Item inputItem) {
        HashMap<String, Item> responseJson = new HashMap<String, Item>();
        if (inputItem.getId() != null) {
            65 T = new /* Unavailable Anonymous Inner Class!! */;
            Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).registerTypeAdapter(Date.class, (json, typeOfT, context) -> new Date(json.getAsJsonPrimitive().getAsLong())).registerTypeAdapter(Date.class, (date, type, jsonSerializationContext) -> new JsonPrimitive((Number)date.getTime())).create();
            Item oldItem = (Item)this.itemRepository.findOne((Serializable)((Object)inputItem.getId()));
            Map meta = (Map)gsonExclusive.fromJson(inputItem.getMetaMap(), T.getType());
            this.savedItem = (Item)this.itemRepository.findOne((Serializable)((Object)inputItem.getId()));
            oldItem.setFlagged(inputItem.getFlagged());
            if (PropertyValidator.isValid((Collection)inputItem.getJiraFieldMap())) {
                ArrayList fields = oldItem.getJiraFieldMap();
                if (!PropertyValidator.isValid((Collection)fields)) {
                    fields = new ArrayList();
                }
                String key = ((ItemJiraFieldMap)inputItem.getJiraFieldMap().get(0)).getKey();
                ItemJiraFieldMap oldField = null;
                for (int i = 0; i < fields.size(); ++i) {
                    if (!((ItemJiraFieldMap)fields.get(i)).getKey().equals(key)) continue;
                    oldField = (ItemJiraFieldMap)fields.remove(i);
                    break;
                }
                if (Boolean.TRUE.equals(inputItem.getFlagged())) {
                    fields.add(inputItem.getJiraFieldMap().get(0));
                } else if (oldField != null) {
                    oldField.setValue(null);
                    oldItem.getJiraFieldMap().add(oldField);
                }
                oldItem.setJiraFieldMap(fields);
            }
            inputItem = oldItem;
            inputItem.setSuspendActivity(true);
            this.item = (Item)this.itemRepository.save((Object)inputItem);
            SessionBoard sessionBoard = null;
            if (PropertyValidator.isValid((Collection)inputItem.getSessionBoards())) {
                sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)((SessionBoard)inputItem.getSessionBoards().get(0)).getId()));
                meta.put("boardId", sessionBoard.getId());
            }
            if (PropertyValidator.isValid((Object)sessionBoard.getSession().getAlmEnabled()) && sessionBoard.getSession().getAlmEnabled().booleanValue() && PropertyValidator.isValid((Object)this.savedItem.getJiraId())) {
                Optional optional = Optional.empty();
                this.saveItemInJira(sessionBoard, true, optional);
            }
            this.item.setMetaMap(gsonExclusive.toJson((Object)meta));
            responseJson.put("item", inputItem);
            PushSender.sendMsg((String)UserContextUtil.getUserContext().getCurrentCompanyId(), (String)gsonExclusive.toJson((Object)inputItem));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/export/score-details"}, method={RequestMethod.POST})
    public ResponseEntity<Object> downloadScoreDetails(@RequestBody Map<String, Object> reqBody) {
        try {
            String extension = "xls";
            int exportType = 1;
            if (PropertyValidator.isValid((Object)reqBody.get("exportType")) && "csv".equalsIgnoreCase((String)reqBody.get("exportType"))) {
                extension = "csv";
                exportType = 0;
            }
            String id = (String)reqBody.get("boardId");
            SessionBoard board = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)id));
            List orderedList = this.exportService.prepareDataForExport(id, board);
            ArrayList<Item> itemsToExport = new ArrayList<Item>();
            for (Item item : orderedList) {
                if (!item.getType().equals("Feature")) continue;
                itemsToExport.add(item);
            }
            String filePath = this.exportService.exportWsjfDataTFS(itemsToExport, (String)reqBody.get("selectedColumns"), exportType, board);
            String cleanedSessionTitle = AlmUtils.cleanText((String)((String)reqBody.get("boardName")));
            String downloadName = AlmUtils.cleanText((String)cleanedSessionTitle) + "." + extension;
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("srcPath", URLEncoder.encode(filePath, "UTF-8"));
            data.put("name", downloadName);
            return new ResponseEntity(data, HttpStatus.OK);
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return null;
    }

    @RequestMapping(value={"/get-item-history"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getItemHistory(@RequestBody String requestPayload) {
        Gson g = new Gson();
        ObjectMapper mapper = new ObjectMapper();
        66 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(requestPayload, T.getType());
        String sessionBoardId = (String)reqbody.get("sessionBoardId");
        String zoneOffset = (String)reqbody.get("zoneOffset");
        String itemIds = (String)reqbody.get("itemIds");
        ArrayList<String> itemIdsList = new ArrayList<String>(Arrays.asList(itemIds.split(",")));
        List itemsCompletePathHistory = this.getItemsCompleteHistory(itemIdsList);
        ArrayList itemsHistory = new ArrayList();
        return new ResponseEntity((Object)itemsCompletePathHistory, HttpStatus.OK);
    }

    private List<DBObject> getItemsCompleteHistory(List<String> itemsIds) {
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.with(new Sort(Sort.Direction.ASC, new String[]{"updatedOn"}));
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)"itemId").in(itemsIds), Criteria.where((String)"detail.originItemId").in(itemsIds)});
        query.addCriteria((CriteriaDefinition)criteria);
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("itemLog").find(query.getQueryObject());
        return dbCursorPrefix.toArray();
    }

    public List<String> getItemsHistoryList(SessionBoard sessionBoard, String sessionBoardId, String zoneOffset) {
        ArrayList<String> historyList = new ArrayList<String>();
        ObjectMapper mapper = new ObjectMapper();
        List itemList = this.itemLogRepository.findBySessionBoardAndItemTypeOrderByEventTimeAsc(sessionBoard, "Item");
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        HashMap<String, Boolean> validFieldsMap = new HashMap<String, Boolean>();
        validFieldsMap.put("score", true);
        validFieldsMap.put("scoreParams", true);
        HashMap<String, String> nameForFeilds = new HashMap<String, String>();
        nameForFeilds.put("score", "Score");
        nameForFeilds.put("scoreParams", "Score Param");
        HashMap previousValueMap = new HashMap();
        for (ItemLog item : itemList) {
            boolean anyActivity = false;
            String historyString = "";
            String jsonChanges = item.getChanges();
            if (jsonChanges == null || jsonChanges.equals("{}")) continue;
            String featureId = null;
            String featureURL = null;
            ObjectMapper objectMapper = new ObjectMapper();
            HashMap obj = (HashMap)objectMapper.convertValue(item.getDetail(), Map.class);
            featureId = obj.get("tfsId") != null ? (String)obj.get("tfsId") : (obj.get("jiraKey") != null ? (String)obj.get("jiraKey") : "");
            featureURL = obj.get("tfsURL") != null ? (String)obj.get("tfsURL") : (obj.get("jiraURL") != null ? (String)obj.get("jiraURL") : "");
            Calendar cal = Calendar.getInstance();
            cal.setTime(item.getCreatedOn());
            cal.add(12, Integer.parseInt(zoneOffset));
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            String strDate = dateFormat.format(cal.getTime());
            String eventType = item.getEventType().substring(0, 1).toUpperCase() + item.getEventType().substring(1).toLowerCase();
            ArrayList<String> historyLogs = new ArrayList<String>();
            try {
                Map map = (Map)mapper.readValue(jsonChanges, Map.class);
                System.err.println(map);
                Iterator iterator = map.entrySet().iterator();
                boolean isFirstMapIter = true;
                while (iterator.hasNext()) {
                    String result;
                    Map.Entry pair = iterator.next();
                    if (validFieldsMap.get(pair.getKey()) == null) continue;
                    anyActivity = true;
                    String historyChange = " <div class='line prow '> ";
                    historyChange = historyChange + strDate;
                    historyChange = historyChange + "<a v-if=" + featureURL + " href=" + featureURL + " target=\"_blank\">\"" + featureId + "\"</a>";
                    if (pair.getKey().equals("score")) {
                        result = this.getLastHistory1(sessionBoard, sessionBoardId, historyChange = historyChange + (String)nameForFeilds.get(pair.getKey()), pair, eventType, previousValueMap, item, itemList);
                        if (result == null) continue;
                        historyChange = result;
                    }
                    if (pair.getKey().equals("scoreParams")) {
                        result = this.getLastHistory1(sessionBoard, sessionBoardId, historyChange, pair, eventType, previousValueMap, item, itemList);
                        if (result == null) continue;
                        historyChange = result;
                    }
                    historyChange = historyChange + "<span class='b' title=" + loggedInUser.getEmail() + ">\"" + loggedInUser.getFullName() + "\"</span>";
                    historyChange = historyChange + " </div> ";
                    historyLogs.add(historyChange);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (String log : historyLogs) {
                historyString = historyString + log;
            }
            if (!anyActivity) continue;
            historyList.add(historyString);
        }
        return historyList;
    }

    private String getLastHistory1(SessionBoard sessionBoard, String sessionBoardId, String historyChange, Map.Entry pair, String eventType, HashMap<String, Object> previousValueMap, ItemLog currentItemLog, List<ItemLog> allLogs) {
        String key = (String)pair.getKey();
        ObjectMapper objectMapper = new ObjectMapper();
        HashMap currentItemDetails = (HashMap)objectMapper.convertValue(currentItemLog.getDetail(), Map.class);
        String currentItemId = (String)currentItemDetails.get("id");
        Object value = pair.getValue();
        String finalString = " changed ";
        String _key = currentItemId + ":" + key;
        if (previousValueMap.get(_key) != null) {
            Object _value = previousValueMap.get(_key);
            if (key.equals("score")) {
                Double prevScore = (Double)_value;
                finalString = finalString + "from \"" + prevScore + "\"";
                finalString = finalString + " to \"" + value + "\"";
            } else {
                Map prevScoreParams = (Map)_value;
                HashMap currentScoreParams = (HashMap)objectMapper.convertValue(value, Map.class);
                SolutionBoard solutionBoard = null;
                ScoreCard scoreCard = null;
                if (sessionBoard == null) {
                    solutionBoard = (SolutionBoard)this.solutionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
                }
                if (solutionBoard != null) {
                    scoreCard = solutionBoard.getScoreCard();
                } else if (sessionBoard != null) {
                    scoreCard = sessionBoard.getSession().getScoreCard();
                }
                if (!prevScoreParams.get("param1").equals(currentScoreParams.get("param1"))) {
                    if (scoreCard.getParams().get("param1") != null) {
                        finalString = finalString + " \"" + ((ScoreParam)scoreCard.getParams().get("param1")).getName() + "\"";
                    }
                    finalString = finalString + "from \"" + prevScoreParams.get("param1") + "\"";
                    finalString = finalString + " to \"" + currentScoreParams.get("param1") + "\"";
                }
                if (!prevScoreParams.get("param2").equals(currentScoreParams.get("param2"))) {
                    if (scoreCard.getParams().get("param2") != null) {
                        finalString = finalString + " \"" + ((ScoreParam)scoreCard.getParams().get("param2")).getName() + "\"";
                    }
                    finalString = finalString + "from \"" + prevScoreParams.get("param2") + "\"";
                    finalString = finalString + " to \"" + currentScoreParams.get("param2") + "\"";
                }
                if (!prevScoreParams.get("param3").equals(currentScoreParams.get("param3"))) {
                    if (scoreCard.getParams().get("param3") != null) {
                        finalString = finalString + " \"" + ((ScoreParam)scoreCard.getParams().get("param3")).getName() + "\"";
                    }
                    finalString = finalString + "from \"" + prevScoreParams.get("param3") + "\"";
                    finalString = finalString + " to \"" + currentScoreParams.get("param3") + "\"";
                }
                if (!prevScoreParams.get("param4").equals(currentScoreParams.get("param4"))) {
                    if (scoreCard.getParams().get("param4") != null) {
                        finalString = finalString + " \"" + ((ScoreParam)scoreCard.getParams().get("param4")).getName() + "\"";
                    }
                    finalString = finalString + "from \"" + prevScoreParams.get("param4") + "\"";
                    finalString = finalString + " to \"" + currentScoreParams.get("param4") + "\"";
                }
            }
        }
        previousValueMap.put(_key, value);
        historyChange = historyChange + finalString;
        return historyChange;
    }

    @RequestMapping(value={"/save-criteria"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveWsjfFilterCriteria(@RequestBody String requestPayload) {
        Gson g = new Gson();
        67 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(requestPayload, T.getType());
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList newSelectedFeatures = new ArrayList();
        ArrayList unSelectedFeatures = new ArrayList();
        String id = null;
        try {
            String sessionId = (String)reqbody.get("sessionId");
            String criteriaTitle = (String)reqbody.get("criteriaTitle");
            String flag = (String)reqbody.get("flag");
            User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
            if (PropertyValidator.isValid(reqbody.get("id"))) {
                id = (String)reqbody.get("id");
            }
            if (PropertyValidator.isValid(reqbody.get("unSelectedFeatures"))) {
                unSelectedFeatures = (ArrayList)reqbody.get("unSelectedFeatures");
            }
            if (PropertyValidator.isValid(reqbody.get("newSelectedFeatures"))) {
                newSelectedFeatures = (ArrayList)reqbody.get("newSelectedFeatures");
            }
            if (flag.equals("edit")) {
                WsjfFilterCriteria criteriaToBeUpdated = new WsjfFilterCriteria();
                criteriaToBeUpdated = this.wsjfFilterCriteriaRepository.findById(id);
                criteriaToBeUpdated.setTitle(criteriaTitle);
                this.wsjfFilterCriteriaRepository.save((Object)criteriaToBeUpdated);
                data.put("updatedCriteria", criteriaToBeUpdated);
                data.put("flag", flag);
            } else if (flag.equals("saveSelectedItems")) {
                WsjfFilterCriteria criteria = this.wsjfFilterCriteriaRepository.findById(id);
                if (PropertyValidator.isValid((Object)criteria)) {
                    ArrayList oldSelectedItems = criteria.getSelectedItems();
                    oldSelectedItems.addAll(newSelectedFeatures);
                    ArrayList<String> unSelectedFeatureIds = new ArrayList<String>();
                    for (Map feature : unSelectedFeatures) {
                        String featureId = (String)feature.get("id");
                        unSelectedFeatureIds.add(featureId);
                    }
                    oldSelectedItems = (ArrayList)oldSelectedItems.stream().filter(item -> !unSelectedFeatureIds.contains((String)item.get("id"))).collect(Collectors.toList());
                    criteria.setSelectedItems(oldSelectedItems);
                    criteria.setTitle(criteriaTitle);
                } else {
                    criteria = new WsjfFilterCriteria();
                    criteria.setTitle(criteriaTitle);
                    criteria.setSelectedItems(newSelectedFeatures);
                    criteria.setSessionId(sessionId);
                    criteria.setUserId(loggedInUser.getId());
                }
                criteria = (WsjfFilterCriteria)this.wsjfFilterCriteriaRepository.save((Object)criteria);
                data.put("flag", flag);
                data.put("criteriaUpdatedForSelectedItems", criteria);
            } else {
                WsjfFilterCriteria savedCriteria = new WsjfFilterCriteria();
                savedCriteria.setTitle(criteriaTitle);
                savedCriteria.setSessionId(sessionId);
                savedCriteria.setUserId(loggedInUser.getId());
                this.wsjfFilterCriteriaRepository.save((Object)savedCriteria);
                data.put("criteria", savedCriteria);
            }
            return new ResponseEntity(data, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    @RequestMapping(value={"/load-criterias"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> loadCriteriaList(@RequestBody String requestPayload) {
        Gson g = new Gson();
        68 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(requestPayload, T.getType());
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        String sessionId = (String)reqbody.get("sessionId");
        List criteriaList = this.wsjfFilterCriteriaRepository.findBySessionId(sessionId);
        HashMap data = new HashMap();
        data.put("criteriaList", criteriaList);
        data.put("user", loggedInUser);
        return new ResponseEntity(data, HttpStatus.OK);
    }

    @RequestMapping(value={"/delete-criteria"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteCriteria(@RequestBody String requestPayload) {
        Gson g = new Gson();
        69 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(requestPayload, T.getType());
        String criteriaId = (String)reqbody.get("criteriaId");
        String sessionId = (String)reqbody.get("sessionId");
        WsjfFilterCriteria criteriaToBeDeleted = new WsjfFilterCriteria();
        criteriaToBeDeleted = this.wsjfFilterCriteriaRepository.findById(criteriaId);
        this.wsjfFilterCriteriaRepository.delete((Object)criteriaToBeDeleted);
        List criteriaList = this.wsjfFilterCriteriaRepository.findBySessionId(sessionId);
        HashMap<String, List> data = new HashMap<String, List>();
        data.put("criteriaList", criteriaList);
        return new ResponseEntity(data, HttpStatus.OK);
    }

    @RequestMapping(value={"/jira-sprints"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchJiraSprint(@RequestBody Map<String, Object> param) {
        String almAccId = (String)param.get("almAccId");
        List jiraIds = (List)param.get("jiraIds");
        Map result = this.almSyncService.retrieveJiraSprints(jiraIds, almAccId);
        List jiraSprints = this.sprintRepository.findSprintByJiraIdInAndAlmAccountId((Collection)jiraIds, almAccId);
        if (PropertyValidator.isValid((Collection)jiraSprints)) {
            for (Sprint sprint : jiraSprints) {
                if (!result.containsKey(sprint.getJiraId())) continue;
                sprint.setState(((JiraSprint)result.get(sprint.getJiraId())).getState());
                sprint.setTitle(((JiraSprint)result.get(sprint.getJiraId())).getName());
            }
            this.sprintRepository.save((Iterable)jiraSprints);
        }
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    public void startJiraNotificationThread(ItemLink link, ItemLink savedLink, String template, Boolean isOldResponsible) {
        try {
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    @RequestMapping(value={"/create-onboard-guide"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> createOnboardGuide() {
        try {
            FeatureSetupProgress featuresList = new FeatureSetupProgress();
            ArrayList featureProgressList = new ArrayList();
            String labelKey = "label";
            String completedKey = "completed";
            String orderkey = "order";
            ArrayList<String> keys = new ArrayList<String>();
            keys.add("Connect_To_Jira");
            keys.add("Create_Board");
            keys.add("Get_Features_from_Jira");
            keys.add("Create_Dependencies");
            keys.add("Manage_Objectives");
            keys.add("ROAM_Risks");
            keys.add("Start_Planning_Agenda");
            for (String key : keys) {
                HashMap keyMeta = new HashMap();
                HashMap<String, Object> metaData = new HashMap<String, Object>();
                metaData.put(labelKey, key);
                metaData.put(completedKey, false);
                metaData.put(orderkey, 1);
                keyMeta.put(key, metaData);
                featureProgressList.add(keyMeta);
            }
            featuresList.setFeatureSetup(featureProgressList);
            this.featureSetupProgressRepository.save((Object)featuresList);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return null;
    }

    @RequestMapping(value={"/get-company-onboarding-data"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getCompanyOnboardingData() {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        List onboardingData = this.featureSetupProgressRepository.findAll();
        FeatureSetupProgress featuresList = new FeatureSetupProgress();
        if (!PropertyValidator.isValid((Collection)onboardingData)) {
            featuresList = this.userService.checkOnboardingMeta();
            responseJson.put("onboardingData", featuresList);
        } else {
            responseJson.put("onboardingData", onboardingData.get(0));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/board/starred"})
    public ResponseEntity<Object> markStarred(@RequestBody UserBoardPreferences boardPref) throws Exception {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        try {
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            boardPref.setUserId(user.getId());
            this.planService.savePreferrence(boardPref);
            responseJson.put("success", true);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception ex) {
            responseJson.put("success", false);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
    }

    @PostMapping(value={"/board/starred/sort"})
    public ResponseEntity<Object> boardPreferences(@RequestBody ResponseSequence responseSequence) throws Exception {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        UserBoardPreferences boardPreference = this.userBoardPreferenceRepository.findBySessionId(responseSequence.getSessionId());
        boardPreference.setSequence(responseSequence.getSequence());
        this.userBoardPreferenceRepository.save((Object)boardPreference);
        responseJson.put("boardPref", boardPreference);
        responseJson.put("boardList", this.userBoardPreferenceRepository.findAll());
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/board/sort"})
    public ResponseEntity<Void> sortPIBoards(@RequestBody ResponseSequence responseSequence) {
        try {
            Session session = this.sessionRepository.findById(responseSequence.getSessionId());
            if (PropertyValidator.isValid((Object)session)) {
                session.setSequence(responseSequence.getSequence());
                this.sessionRepository.save((Object)session);
            }
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("*****sortPIBoards**** -----> Exception Occurred. ---------------", (Throwable)e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/gameplay/sync-player-location"})
    public ResponseEntity<Object> logUserBoardLocation(@RequestBody UserBoardLocation userBoardLocation) {
        HashMap<String, UserBoardLocation> responseJson = new HashMap<String, UserBoardLocation>();
        userBoardLocation = this.almSyncService.saveUserBoardLocation(userBoardLocation);
        responseJson.put("player", userBoardLocation);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/gameplay/list-players"})
    public ResponseEntity<Object> getPlayersList(@RequestBody UserBoardLocation UserBoardLocation2) {
        LOGGER.debug("/gameplay/list-players");
        HashMap<String, List> responseJson = new HashMap<String, List>();
        List playersList = this.almSyncService.getAllActivePlayers(UserBoardLocation2);
        LOGGER.info(UserBoardLocation2.toString());
        responseJson.put("players", playersList);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @GetMapping(value={"/gameplay/get-player/{userId}"})
    public ResponseEntity<Object> getPlayer(@PathVariable(value="userId") String userId) {
        LOGGER.debug("/gameplay/get-player/{userId}");
        HashMap<String, UserBoardLocation> responseJson = new HashMap<String, UserBoardLocation>();
        UserBoardLocation userBoardLocation = this.almSyncService.getPlayerByUserId(userId);
        responseJson.put("player", userBoardLocation);
        LOGGER.debug(userBoardLocation.toString());
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/gameplay/sync-player-state"})
    public ResponseEntity<Object> syncPlayerState(@RequestParam(value="id") String userId, @RequestParam(value="state") boolean playerState) {
        LOGGER.debug("/gameplay/sync-player-state");
        HashMap<String, UserBoardLocation> responseJson = new HashMap<String, UserBoardLocation>();
        UserBoardLocation userBoardLocation = this.almSyncService.syncPlayerState(userId, playerState);
        responseJson.put("player", userBoardLocation);
        LOGGER.debug(userBoardLocation.toString());
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private ResponseEntity<Object> downloadAuditLogExcelFile(String params) {
        try {
            Gson gson = new Gson();
            71 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap paramMap = (HashMap)gson.fromJson(params, T.getType());
            String boardType = (String)paramMap.get("boardType");
            String timeZone = (String)paramMap.get("timeZone");
            String sessionBoardId = (String)paramMap.get("sessionBoardId");
            List auditLogList = this.auditLogRepository.findBySessionBoardId(sessionBoardId);
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
            List auditLogListSessionId = this.auditLogRepository.findBySessionId(sessionBoard.getSession().getId());
            auditLogList.addAll(auditLogListSessionId);
            String filePath = this.exportService.exportAuditLogs(auditLogList, boardType, timeZone);
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
            String downloadName = AlmUtils.cleanText((String)sessionBoard.getSession().getTitle()) + "_Audit_logs_" + formatter.format(new Date()) + ".xlsx";
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("srcPath", URLEncoder.encode(filePath, "UTF-8"));
            data.put("name", URLEncoder.encode(downloadName, "UTF-8"));
            return new ResponseEntity(data, HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)"Error Fetching Logs", HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/auditlog"})
    @ResponseBody
    public ResponseEntity<Object> downloadAuditLogBulk(@RequestBody String params) {
        try {
            return this.downloadAuditLogExcelFile(params);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)"Error Fetching Audit Logs", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/{sessionBoardId}/activitylog"})
    @ResponseBody
    public ResponseEntity<Object> downloadActivityLogExcelFile(@PathVariable(value="sessionBoardId") String sessionBoardId, String action, @RequestBody List activityLogList) {
        if (action.equals("download")) {
            try {
                SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
                ArrayList<String> sessionBoardIds = new ArrayList<String>();
                sessionBoardIds.add(sessionBoardId);
                SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
                List itemRepoList = this.itemRepository.findBySessionBoardsIdIn(sessionBoardIds);
                String filePath = this.exportService.exportActivityLogs(activityLogList, sessionBoard.getTeams(), sessionBoard.getContainers(), this.issueTypeRepository.findAllByOrderBySequenceAsc(), itemRepoList, null, sessionBoard);
                SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
                String downloadName = AlmUtils.cleanText((String)sessionBoard.getSession().getTitle()) + "_Activity_logs_" + formatter.format(new Date()) + ".xlsx";
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("srcPath", URLEncoder.encode(filePath, "UTF-8"));
                data.put("name", URLEncoder.encode(downloadName, "UTF-8"));
                return new ResponseEntity(data, HttpStatus.OK);
            }
            catch (Exception e) {
                return new ResponseEntity((Object)e.getMessage(), HttpStatus.BAD_REQUEST);
            }
        }
        return null;
    }

    @RequestMapping(value={"/generate/activitylog/{sessionBoardId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> downloadActivityLogBulk(@RequestBody String requestPayload, @PathVariable String sessionBoardId) {
        try {
            Gson g = new Gson();
            72 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)g.fromJson(requestPayload, T.getType());
            reqbody.put("activies", this.planService.getAllActivitiesByTeamAndSprint((String)reqbody.get("searchString"), (String)reqbody.get("boardId"), (String)reqbody.get("teamId"), (String)reqbody.get("sprintId"), (Boolean)reqbody.get("isWebhook")));
            return this.downloadActivityLogExcelFile(sessionBoardId, "download", (List)reqbody.get("activies"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/search/auditlogs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> searchAuditLogActions(@RequestBody String searchText) {
        List auditLogList = this.auditLogRepository.findAll();
        ArrayList<AuditLog> auditLogFiltered = new ArrayList<AuditLog>();
        HashMap<String, List> responseJson = new HashMap<String, List>();
        if (searchText.equals("All")) {
            responseJson.put("auditlogs", auditLogList);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        for (AuditLog auditlog : auditLogList) {
            if (!auditlog.getEventType().contains(searchText)) continue;
            auditLogFiltered.add(auditlog);
        }
        responseJson.put("auditlogs", auditLogFiltered);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-criteria/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getCriteria(@PathVariable(value="id") String id) {
        WsjfFilterCriteria criteria;
        HashMap<String, String> responseJson = new HashMap<String, String>();
        if (PropertyValidator.isValid((Object)id)) {
            criteria = this.wsjfFilterCriteriaRepository.findById(id);
            if (!PropertyValidator.isValid((Object)criteria)) {
                responseJson.put("error", "Invalid Id");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
        } else {
            responseJson.put("error", "Invalid Id");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        responseJson.put("criteria", (String)criteria);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/check/jira/dependency/enabled/{sessionId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> checkJiraDependencyEnabled(@PathVariable String sessionId) {
        if (PropertyValidator.isValid((Object)sessionId)) {
            HashMap<String, Object> responseJson = new HashMap<String, Object>();
            Session session = new Session();
            session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
            if (session.getJiraDependencyEnabled().booleanValue()) {
                responseJson.put("isJiraEnabled", true);
                responseJson.put("jiraLinkTypes", session.getJiraLinkTypes());
            } else {
                responseJson.put("isJiraEnabled", false);
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        return new ResponseEntity((Object)"Invalid Session Id", HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/check/team-and-sprint-mapping/{sessionBoardId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> checkTeamAndSprintMapping(@PathVariable String sessionBoardId) {
        if (PropertyValidator.isValid((Object)sessionBoardId)) {
            HashMap<String, List> responseJson = new HashMap<String, List>();
            SessionBoard sessionBoard = new SessionBoard();
            sessionBoard = this.sessionBoardRepository.findById(sessionBoardId);
            List itemSyncMapperList = this.itemSyncMapperRepository.findBySessionBoard(sessionBoard);
            responseJson.put("ItemSyncMapperList", itemSyncMapperList);
            responseJson.put("Teams", sessionBoard.getTeams());
            responseJson.put("Sprints", sessionBoard.getContainers());
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        return new ResponseEntity((Object)"Invalid Board Id", HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/save-sync-timer"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveAutoSyncTimer(@RequestBody Map<String, Object> request) {
        String sessionBoardId = (String)request.get("sessionId");
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        try {
            this.customRepositoryImpl.updateSyncTimer(sessionBoardId, Integer.valueOf(Integer.parseInt((String)request.get("syncTimer"))));
            response.put("success", Boolean.valueOf(true));
        }
        catch (Exception e) {
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error(err);
            response.put("kendisError", e);
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/save-sync-counter"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> autoSync(@RequestBody Map<String, Object> request) {
        String sessionBoardId = (String)request.get("boardId");
        HashMap<String, Boolean> response = new HashMap<String, Boolean>();
        this.customRepositoryImpl.updateNoticationCount(sessionBoardId, Integer.valueOf(Integer.parseInt((String)request.get("noticationCounter"))));
        response.put("success", true);
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/fetch-sync-counter"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> checkNewItems(@RequestBody Map<String, Object> request) {
        ArrayList<String> logs = null;
        if (PropertyValidator.isValid((Object)request.get("debug"))) {
            logs = new ArrayList<String>();
        }
        String sessionBoardId = (String)request.get("boardId");
        Boolean auto = Boolean.TRUE.equals(request.get("auto"));
        if (logs != null) {
            logs.add("/fetch-sync-counter pinged from " + request.get("caller"));
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("logs", logs);
        String requestId = (String)request.get("requestId");
        if (PropertyValidator.isValid((Object)sessionBoardId)) {
            Long timer = null;
            if (auto.booleanValue()) {
                try {
                    if (logs != null) {
                        logs.add("checking auto fetching notication counter");
                    }
                    if (request.containsKey("timer")) {
                        timer = new Long((String)request.get("timer"));
                    }
                    if (timer == null) {
                        timer = 599999L;
                    }
                    this.customRepositoryImpl.checkIfSessionLockedWithTime(sessionBoardId, "NOTIFICATION_EVENT", timer);
                }
                catch (ViztrendJiraException vJe) {
                    response.put("countOnly", true);
                    response.put("timer", vJe.getMessage());
                    if (auto.booleanValue() && logs != null) {
                        logs.add("waiting for next cycle of auto fetching notication counter");
                    }
                    return new ResponseEntity(response, HttpStatus.OK);
                }
            }
            if (auto.booleanValue() && logs != null) {
                logs.add("staring auto fetching notication counter");
            }
            Long _timer = timer;
            if (PropertyValidator.isValid(logs)) {
                this.jiraSyncServiceImpl.liveSync(auto, _timer, sessionBoardId, Item.Type.Feature.name(), null, (String)request.get("syncId"), (String)request.get("polling"), logs);
            } else {
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            }
            response.put("success", true);
            return new ResponseEntity(response, HttpStatus.OK);
        }
        return new ResponseEntity((Object)"Invalid Board Id", HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/save-excluded-items"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveExcludedItems(@RequestBody StatsExclusion excludedItemsVO) {
        try {
            HashMap response = this.planService.saveExcludedItems(excludedItemsVO);
            return new ResponseEntity((Object)response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("*****saveExcludedItems**** -----> Exception Occurred. ---------------");
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/fetch-excluded-items"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchExcludedItems(@RequestBody HashMap<String, String> statsExclusionMap) {
        try {
            HashMap response = this.planService.fetchExcludedItems(statsExclusionMap);
            return new ResponseEntity((Object)response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("*****saveExcludedItems**** -----> Exception Occurred. ---------------");
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/save-custom-wsjf-settings"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveCustomWsjfSettings(@RequestBody HashMap<String, Object> requestBody) {
        try {
            HashMap response = this.planService.saveCustomWsjfSettings(requestBody);
            return new ResponseEntity((Object)response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("*****saveCustomWsjfSettings**** -----> Exception Occurred. ---------------");
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private static /* synthetic */ boolean lambda$deleteTeam$52(List savedItemLinks, int tcIndex, ItemLink lt) {
        return lt.getId().equals(((ItemLink)savedItemLinks.get(tcIndex)).getId());
    }

    private static /* synthetic */ boolean lambda$changeState1$27(TeamSprintVelocity newTsv, Container x) {
        return newTsv.getSprintId().equals(x.getDuplicateOfId());
    }

    private static /* synthetic */ boolean lambda$changeState1$25(ItemSyncMapper itemSyncMapper, Container x) {
        return itemSyncMapper.getContainer().getId().equals(x.getDuplicateOfId());
    }

    static /* synthetic */ PlanService access$000(PlanController x0) {
        return x0.planService;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    static /* synthetic */ AlmConfigurationsRepository access$200(PlanController x0) {
        return x0.almConfigurationsRepository;
    }

    static /* synthetic */ ALMSyncService access$300(PlanController x0) {
        return x0.almSyncService;
    }

    static /* synthetic */ JiraProjectIssueTypesRepository access$400(PlanController x0) {
        return x0.jiraProjectIssueTypesRepository;
    }

    static /* synthetic */ AppConfig.MongoConfig access$500(PlanController x0) {
        return x0.mongoConfig;
    }

    static /* synthetic */ String[] access$600(PlanController x0, SearchVO x1, JiraFilter x2, AlmConfigurations x3, List x4, List x5, Map x6) throws Exception {
        return x0.resyncOnAddExisting(x1, x2, x3, x4, x5, x6);
    }

    static /* synthetic */ UserService access$700(PlanController x0) {
        return x0.userService;
    }

    static /* synthetic */ PushResponseRepository access$800(PlanController x0) {
        return x0.pushResponseRepository;
    }

    static /* synthetic */ NotificationService access$900(PlanController x0) {
        return x0.notificationService;
    }

    static /* synthetic */ CustomRepository access$1000(PlanController x0) {
        return x0.customRepository;
    }

    static /* synthetic */ void access$1100(PlanController x0, ViztrendJiraException x1, Item x2, User x3) {
        x0.pushAlmError(x1, x2, x3);
    }

    static /* synthetic */ AlmAccountRepository access$1200(PlanController x0) {
        return x0.almAccountRepository;
    }

    static /* synthetic */ void access$1300(PlanController x0, String x1, List x2, HashMap x3) {
        x0.fetchJiraIssueTypes(x1, x2, x3);
    }

    static /* synthetic */ ImportUtil access$1400(PlanController x0) {
        return x0.importUtil;
    }

    static /* synthetic */ StatusRepository access$1500(PlanController x0) {
        return x0.statusRepository;
    }

    static /* synthetic */ void access$1600(PlanController x0, SessionBoard x1) {
        x0.fillBoardStatuses(x1);
    }

    static /* synthetic */ TFSProjectRepository access$1700(PlanController x0) {
        return x0.tfsProjectRepository;
    }

    static /* synthetic */ WorkFlowItemTypeRepository access$1800(PlanController x0) {
        return x0.workFlowItemTypeRepository;
    }

    static /* synthetic */ WorkFlowRepository access$1900(PlanController x0) {
        return x0.workFlowRepository;
    }

    static /* synthetic */ TFSservice access$2000(PlanController x0) {
        return x0.tfSservice;
    }

    static /* synthetic */ TFSUtils access$2100(PlanController x0) {
        return x0.tfsUtils;
    }

    static /* synthetic */ IssueTypeRepository access$2200(PlanController x0) {
        return x0.issueTypeRepository;
    }

    static /* synthetic */ ItemLinkTypeRepository access$2300(PlanController x0) {
        return x0.itemLinkTypeRepository;
    }

    static /* synthetic */ SessionRepository access$2400(PlanController x0) {
        return x0.sessionRepository;
    }

    static /* synthetic */ SessionBoardRepository access$2500(PlanController x0) {
        return x0.sessionBoardRepository;
    }

    static /* synthetic */ void access$2600(PlanController x0, HashMap x1, SessionBoard x2) {
        x0.populateTfsProjectResponse(x1, x2);
    }

    static /* synthetic */ ReleaseTrainService access$2700(PlanController x0) {
        return x0.releaseTrainService;
    }

    static /* synthetic */ CompanyRepository access$2800(PlanController x0) {
        return x0.companyRepository;
    }

    static /* synthetic */ KendisStatsRepository access$2900(PlanController x0) {
        return x0.kendisStatsRepository;
    }

    static /* synthetic */ CustomRepositoryImpl access$3000(PlanController x0) {
        return x0.customRepositoryImpl;
    }

    static /* synthetic */ ItemRepository access$3100(PlanController x0) {
        return x0.itemRepository;
    }

    static /* synthetic */ RiskRepository access$3200(PlanController x0) {
        return x0.riskRepository;
    }

    static /* synthetic */ ItemLinkRepository access$3300(PlanController x0) {
        return x0.itemLinkRepository;
    }

    static /* synthetic */ ItemSyncMapperRepository access$3400(PlanController x0) {
        return x0.itemSyncMapperRepository;
    }

    static /* synthetic */ TeamSprintVelocityRepository access$3500(PlanController x0) {
        return x0.teamSprintVelocityRepository;
    }

    static /* synthetic */ TeamSprintDependencyLimitRepository access$3600(PlanController x0) {
        return x0.TeamSprintDependencyLimitRepository;
    }

    static /* synthetic */ ContainerRepository access$3700(PlanController x0) {
        return x0.containerRepository;
    }

    static /* synthetic */ TeamContainerRepository access$3800(PlanController x0) {
        return x0.teamContainerRepository;
    }

    static /* synthetic */ ItemJiraDependencyRepository access$3900(PlanController x0) {
        return x0.itemJiraDependencyRepository;
    }

    static /* synthetic */ NotificationRepository access$4000(PlanController x0) {
        return x0.notificationRepository;
    }

    static /* synthetic */ JiraSyncServiceImpl access$4100(PlanController x0) {
        return x0.jiraSyncServiceImpl;
    }
}

